/* designerwindow.c generated by valac 0.24.0, the Vala compiler
 * generated from designerwindow.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: designerwindow.vala
 *   
 *   Copyright Ashley Newson 2013
 */
/**
 * Sets file extension filter opens in component open/save dialogs.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <config.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <glib/gstdio.h>
#include <cairo-pdf.h>
#include <cairo-svg.h>


#define TYPE_DESIGNER_WINDOW (designer_window_get_type ())
#define DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER_WINDOW, DesignerWindow))
#define DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER_WINDOW, DesignerWindowClass))
#define IS_DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER_WINDOW))
#define IS_DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER_WINDOW))
#define DESIGNER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER_WINDOW, DesignerWindowClass))

typedef struct _DesignerWindow DesignerWindow;
typedef struct _DesignerWindowClass DesignerWindowClass;
typedef struct _DesignerWindowPrivate DesignerWindowPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_DESIGNER (designer_get_type ())
#define DESIGNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER, Designer))
#define DESIGNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER, DesignerClass))
#define IS_DESIGNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER))
#define IS_DESIGNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER))
#define DESIGNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER, DesignerClass))

typedef struct _Designer Designer;
typedef struct _DesignerClass DesignerClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define DESIGNER_WINDOW_TYPE_MOUSE_MODE (designer_window_mouse_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _designer_unref0(var) ((var == NULL) ? NULL : (var = (designer_unref (var), NULL)))
#define _project_unref0(var) ((var == NULL) ? NULL : (var = (project_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;
typedef struct _Block1Data Block1Data;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _Block2Data Block2Data;
typedef struct _ProjectPrivate ProjectPrivate;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;
typedef struct _DesignerPrivate DesignerPrivate;
typedef struct _Block3Data Block3Data;
#define _circuit_information_unref0(var) ((var == NULL) ? NULL : (var = (circuit_information_unref (var), NULL)))
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define IMAGE_EXPORTER_TYPE_IMAGE_FORMAT (image_exporter_image_format_get_type ())
#define _compiled_circuit_unref0(var) ((var == NULL) ? NULL : (var = (compiled_circuit_unref (var), NULL)))

struct _DesignerWindow {
	GtkWindow parent_instance;
	DesignerWindowPrivate * priv;
	gint myID;
	gchar* componentFileName;
	gint gridSize;
	gfloat zoom;
	gboolean showGrid;
	gboolean liveScrollUpdate;
	gboolean shadowComponent;
};

struct _DesignerWindowClass {
	GtkWindowClass parent_class;
};

typedef enum  {
	DESIGNER_WINDOW_MOUSE_MODE_SCROLL,
	DESIGNER_WINDOW_MOUSE_MODE_ZOOM,
	DESIGNER_WINDOW_MOUSE_MODE_SELECT,
	DESIGNER_WINDOW_MOUSE_MODE_MOVE,
	DESIGNER_WINDOW_MOUSE_MODE_ORIENTATE,
	DESIGNER_WINDOW_MOUSE_MODE_DELETE,
	DESIGNER_WINDOW_MOUSE_MODE_ADJUST,
	DESIGNER_WINDOW_MOUSE_MODE_ANNOTATE,
	DESIGNER_WINDOW_MOUSE_MODE_WIRE,
	DESIGNER_WINDOW_MOUSE_MODE_BIND,
	DESIGNER_WINDOW_MOUSE_MODE_TAG,
	DESIGNER_WINDOW_MOUSE_MODE_INVERT,
	DESIGNER_WINDOW_MOUSE_MODE_INSERT
} DesignerWindowMouseMode;

struct _DesignerWindowPrivate {
	GtkBox* vBox;
	GtkMenuBar* menubar;
	GtkMenuItem* menuFile;
	GtkMenu* menuFileMenu;
	GtkMenuItem* menuFileNewproject;
	GtkMenuItem* menuFileNewcomponent;
	GtkMenuItem* menuFileSeparator1;
	GtkMenuItem* menuFileSaveproject;
	GtkMenuItem* menuFileSaveasproject;
	GtkMenuItem* menuFileSeparator2;
	GtkMenuItem* menuFileOpen;
	GtkMenuItem* menuFileOpenplugincomponent;
	GtkMenuItem* menuFileSeparator3;
	GtkMenuItem* menuFileOpenproject;
	GtkMenuItem* menuFileSeparator4;
	GtkMenuItem* menuFileSave;
	GtkMenuItem* menuFileSaveas;
	GtkMenuItem* menuFileSeparator5;
	GtkMenuItem* menuFileExport;
	GtkMenu* menuFileExportMenu;
	GtkMenuItem* menuFileExportPng;
	GtkMenuItem* menuFileExportPdf;
	GtkMenuItem* menuFileExportSvg;
	GtkMenuItem* menuFileSeparator6;
	GtkMenuItem* menuFilePagesetup;
	GtkMenuItem* menuFilePrint;
	GtkMenuItem* menuFileSeparator7;
	GtkMenuItem* menuFileRemovecomponent;
	GtkMenuItem* menuFileRemoveplugincomponent;
	GtkMenu* menuFileRemoveplugincomponentMenu;
	GtkMenuItem** menuFileRemoveplugincomponentComponents;
	gint menuFileRemoveplugincomponentComponents_length1;
	gint _menuFileRemoveplugincomponentComponents_size_;
	GtkMenuItem* menuFileSeparator8;
	GtkMenuItem* menuFileExit;
	GtkMenuItem* menuView;
	GtkMenu* menuViewMenu;
	GtkMenuItem* menuViewFitdesign;
	GtkMenuItem* menuViewSeparator1;
	GtkCheckMenuItem* menuViewShowgrid;
	GtkCheckMenuItem* menuViewLivescrollupdate;
	GtkCheckMenuItem* menuViewShadowcomponent;
	GtkCheckMenuItem* menuViewColourbackgrounds;
	GtkCheckMenuItem* menuViewHighlighterrors;
	GtkCheckMenuItem* menuViewShowdesignerhints;
	GtkMenuItem* menuEdit;
	GtkMenu* menuEditMenu;
	GtkCheckMenuItem* menuEditAutobind;
	GtkMenuItem* menuRun;
	GtkMenu* menuRunMenu;
	GtkMenuItem* menuRunRun;
	GtkMenuItem* menuRunCheckcircuit;
	GtkMenuItem* menuRunSeparator1;
	GtkCheckMenuItem* menuRunStartpaused;
	GtkMenuItem* menuProject;
	GtkMenu* menuProjectMenu;
	GtkMenuItem* menuProjectStatistics;
	GtkMenuItem* menuProjectOptions;
	GtkMenuItem* menuComponent;
	GtkMenu* menuComponentMenu;
	GtkMenuItem* menuComponentMakeroot;
	GtkMenuItem* menuComponentCustomise;
	GtkMenuItem* menuWindows;
	GtkMenu* menuWindowsMenu;
	GtkMenuItem** menuWindowsComponents;
	gint menuWindowsComponents_length1;
	gint _menuWindowsComponents_size_;
	GtkMenuItem* menuHelp;
	GtkMenu* menuHelpMenu;
	GtkMenuItem* menuHelpAbout;
	GtkRadioToolButton* hiddenRadioToolButton;
	GtkToolbar* toolbar;
	GtkRadioToolButton* toolScroll;
	GtkImage* toolScrollImage;
	GtkRadioToolButton* toolZoom;
	GtkImage* toolZoomImage;
	GtkSeparatorToolItem* toolSeparator1;
	GtkRadioToolButton* toolCursor;
	GtkImage* toolCursorImage;
	GtkRadioToolButton* toolMove;
	GtkImage* toolMoveImage;
	GtkRadioToolButton* toolOrientate;
	GtkImage* toolOrientateImage;
	GtkRadioToolButton* toolDelete;
	GtkImage* toolDeleteImage;
	GtkRadioToolButton* toolAdjust;
	GtkImage* toolAdjustImage;
	GtkSeparatorToolItem* toolSeparator2;
	GtkRadioToolButton* toolAnnotate;
	GtkImage* toolAnnotateImage;
	GtkRadioToolButton* toolWire;
	GtkImage* toolWireImage;
	GtkRadioToolButton* toolBind;
	GtkImage* toolBindImage;
	GtkRadioToolButton* toolTag;
	GtkImage* toolTagImage;
	GtkRadioToolButton* toolInvert;
	GtkImage* toolInvertImage;
	GtkSeparatorToolItem* toolSeparator3;
	GtkMenuToolButton* toolCustoms;
	GtkImage* toolCustomsImage;
	GtkMenu* toolCustomsMenu;
	GtkMenuItem** toolCustomsMenuComponents;
	gint toolCustomsMenuComponents_length1;
	gint _toolCustomsMenuComponents_size_;
	GtkMenuToolButton* toolPlugins;
	GtkImage* toolPluginsImage;
	GtkMenu* toolPluginsMenu;
	GtkMenuItem** toolPluginsMenuComponents;
	gint toolPluginsMenuComponents_length1;
	gint _toolPluginsMenuComponents_size_;
	GtkSeparatorToolItem* toolSeparator4;
	GtkRadioToolButton** toolStandards;
	gint toolStandards_length1;
	gint _toolStandards_size_;
	GtkImage** toolStandardImages;
	gint toolStandardImages_length1;
	gint _toolStandardImages_size_;
	GtkEventBox* controller;
	GtkDrawingArea* display;
	GtkFileFilter* anysspFileFilter;
	GtkFileFilter* anysscFileFilter;
	GtkFileFilter* anyssxFileFilter;
	GtkFileFilter* sspFileFilter;
	GtkFileFilter* sscFileFilter;
	GtkFileFilter* sscxmlFileFilter;
	GtkFileFilter* xmlFileFilter;
	GtkFileFilter* ssxFileFilter;
	GtkFileFilter* pngFileFilter;
	GtkFileFilter* pdfFileFilter;
	GtkFileFilter* svgFileFilter;
	GtkFileFilter* anyFileFilter;
	GtkPrintSettings* printSettings;
	GtkPageSetup* pageSetup;
	cairo_surface_t* gridCache;
	cairo_surface_t* staticCache;
	ComponentDef** standardComponentDefs;
	gint standardComponentDefs_length1;
	gint _standardComponentDefs_size_;
	Designer* designer;
	gboolean _hasDesigner;
	Project* project;
	gboolean _hasProject;
	gint xMouseStart;
	gint yMouseStart;
	gfloat xMouseTravel;
	gfloat yMouseTravel;
	gfloat xMouseTravelStart;
	gfloat yMouseTravelStart;
	gboolean mouseIsDown;
	gint xView;
	gint yView;
	gboolean highlightErrors;
	gboolean colourBackgrounds;
	gboolean showHints;
	gboolean autoBind;
	gfloat diagonalThreshold;
	DesignerWindowMouseMode mouseMode;
};

struct _Block1Data {
	int _ref_count_;
	DesignerWindow* self;
	ComponentDef* componentDef;
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _Block2Data {
	int _ref_count_;
	DesignerWindow* self;
	CustomComponentDef* customComponentDef;
};

struct _Project {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectPrivate * priv;
	gboolean running;
	CustomComponentDef** customComponentDefs;
	gint customComponentDefs_length1;
	PluginComponentDef** pluginComponentDefs;
	gint pluginComponentDefs_length1;
	PluginComponentManager** pluginComponentManagers;
	gint pluginComponentManagers_length1;
	CustomComponentDef* rootComponent;
	gint myID;
	gchar* description;
	gchar* filename;
};

struct _ProjectClass {
	GTypeClass parent_class;
	void (*finalize) (Project *self);
};

struct _Designer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DesignerPrivate * priv;
	DesignerWindow* window;
	CustomComponentDef* customComponentDef;
	gint myID;
	ComponentDef* insertComponentDef;
	ComponentDef* lastInsertCustomComponentDef;
	ComponentDef* lastInsertPluginComponentDef;
	ComponentInst* shadowComponentInst;
};

struct _DesignerClass {
	GTypeClass parent_class;
	void (*finalize) (Designer *self);
};

struct _Block3Data {
	int _ref_count_;
	DesignerWindow* self;
	PluginComponentDef* pluginComponentDef;
};

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

typedef enum  {
	PROJECT_LOAD_ERROR_NOT_PROJECT,
	PROJECT_LOAD_ERROR_CANCEL,
	PROJECT_LOAD_ERROR_FILE,
	PROJECT_LOAD_ERROR_LOAD
} ProjectLoadError;
#define PROJECT_LOAD_ERROR project_load_error_quark ()
typedef enum  {
	IMAGE_EXPORTER_IMAGE_FORMAT_PNG_RGB,
	IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB,
	IMAGE_EXPORTER_IMAGE_FORMAT_PDF,
	IMAGE_EXPORTER_IMAGE_FORMAT_SVG,
	IMAGE_EXPORTER_IMAGE_FORMAT_SVG_CLEAR
} ImageExporterImageFormat;

typedef void (*ImageExporterRenderer) (const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution, void* user_data);

static gpointer designer_window_parent_class = NULL;
static DesignerWindow** designer_window_designerWindows;
static gint designer_window_designerWindows_length1;
static DesignerWindow** designer_window_designerWindows = NULL;
static gint designer_window_designerWindows_length1 = 0;
static gint _designer_window_designerWindows_size_ = 0;
extern ComponentDef** core_standardComponentDefs;
extern gint core_standardComponentDefs_length1;

GType designer_window_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
gpointer designer_ref (gpointer instance);
void designer_unref (gpointer instance);
GParamSpec* param_spec_designer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_designer (GValue* value, gpointer v_object);
void value_take_designer (GValue* value, gpointer v_object);
gpointer value_get_designer (const GValue* value);
GType designer_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
static GType designer_window_mouse_mode_get_type (void) G_GNUC_UNUSED;
#define DESIGNER_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DESIGNER_WINDOW, DesignerWindowPrivate))
enum  {
	DESIGNER_WINDOW_DUMMY_PROPERTY
};
void designer_window_register (DesignerWindow* window);
static void _vala_array_add55 (DesignerWindow*** array, int* length, int* size, DesignerWindow* value);
void designer_window_unregister (DesignerWindow* window);
static void _vala_array_add56 (DesignerWindow*** array, int* length, int* size, DesignerWindow* value);
static DesignerWindow** _vala_array_dup45 (DesignerWindow** self, int length);
void project_clean_up (void);
gboolean designer_window_project_has_windows (Project* project);
gint designer_window_count_project_windows (Project* project);
DesignerWindow** designer_window_get_project_windows (Project* project, int* result_length1);
static void _vala_array_add57 (DesignerWindow*** array, int* length, int* size, DesignerWindow* value);
DesignerWindow* designer_window_new (void);
DesignerWindow* designer_window_construct (GType object_type);
void designer_window_populate (DesignerWindow* self);
static void designer_window_register_designerwindow (DesignerWindow* self);
DesignerWindow* designer_window_new_with_new_project (void);
DesignerWindow* designer_window_construct_with_new_project (GType object_type);
static void designer_window_new_project (DesignerWindow* self);
DesignerWindow* designer_window_new_with_project_from_file (const gchar* filename);
DesignerWindow* designer_window_construct_with_project_from_file (GType object_type, const gchar* filename);
static void designer_window_load_project (DesignerWindow* self, const gchar* filename);
DesignerWindow* designer_window_new_with_new_designer (Project* project);
DesignerWindow* designer_window_construct_with_new_designer (GType object_type, Project* project);
static void designer_window_set_hasProject (DesignerWindow* self, gboolean value);
void designer_window_update_title (DesignerWindow* self);
static DesignerWindow* designer_window_new_designer (DesignerWindow* self);
GType custom_component_def_get_type (void) G_GNUC_CONST;
DesignerWindow* designer_window_new_with_existing_component (Project* project, CustomComponentDef* customComponentDef);
DesignerWindow* designer_window_construct_with_existing_component (GType object_type, Project* project, CustomComponentDef* customComponentDef);
static void designer_window_set_component (DesignerWindow* self, CustomComponentDef* customComponentDef);
DesignerWindow* designer_window_new_with_new_component (Project* project);
DesignerWindow* designer_window_construct_with_new_component (GType object_type, Project* project);
static void designer_window_new_component (DesignerWindow* self);
DesignerWindow* designer_window_new_with_component_from_file (Project* project, const gchar* filename);
DesignerWindow* designer_window_construct_with_component_from_file (GType object_type, Project* project, const gchar* filename);
static void designer_window_load_component (DesignerWindow* self, const gchar* filename);
static gboolean __lambda7_ (DesignerWindow* self);
static gboolean designer_window_close_window (DesignerWindow* self);
static gboolean ___lambda7__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
#define CORE_programName "SmartSim"
static void _designer_window_new_project_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda8_ (DesignerWindow* self);
static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda9_ (DesignerWindow* self);
static gboolean designer_window_save_project (DesignerWindow* self, gboolean saveAs);
static void ___lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda10_ (DesignerWindow* self);
static void ___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda11_ (DesignerWindow* self);
static gboolean designer_window_open_project (DesignerWindow* self);
static void ___lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda12_ (DesignerWindow* self);
gboolean designer_window_save_component (DesignerWindow* self, gboolean saveAs);
static void ___lambda12__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda13_ (DesignerWindow* self);
static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda14_ (DesignerWindow* self);
static gboolean designer_window_open_component (DesignerWindow* self);
static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda15_ (DesignerWindow* self);
static gboolean designer_window_open_plugin_component (DesignerWindow* self);
static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void designer_window_export_png (DesignerWindow* self);
static void _designer_window_export_png_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void designer_window_export_pdf (DesignerWindow* self);
static void _designer_window_export_pdf_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void designer_window_export_svg (DesignerWindow* self);
static void _designer_window_export_svg_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void designer_window_print_page_setup (DesignerWindow* self);
static void _designer_window_print_page_setup_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void designer_window_print (DesignerWindow* self);
static void _designer_window_print_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda16_ (DesignerWindow* self);
static gboolean designer_window_remove_component (DesignerWindow* self);
static void ___lambda16__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda17_ (DesignerWindow* self);
static void ___lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda18_ (DesignerWindow* self);
static void designer_window_fit_design (DesignerWindow* self);
static void ___lambda18__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda19_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
gboolean designer_window_render_design (DesignerWindow* self, cairo_t* passedDisplayContext);
static void ___lambda19__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda20_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda20__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda21_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda21__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda22_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda22__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda23_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda23__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda24_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda24__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda25_ (DesignerWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda25__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void designer_window_run_circuit (DesignerWindow* self);
static void _designer_window_run_circuit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void designer_window_validate_circuit (DesignerWindow* self);
static void _designer_window_validate_circuit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void designer_window_set_root_component (DesignerWindow* self);
static void _designer_window_set_root_component_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void designer_window_customise_component (DesignerWindow* self);
static void _designer_window_customise_component_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void designer_window_display_statistics (DesignerWindow* self);
static void _designer_window_display_statistics_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void designer_window_configure_project (DesignerWindow* self);
static void _designer_window_configure_project_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void designer_window_show_about (DesignerWindow* self);
static void _designer_window_show_about_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda66_ (DesignerWindow* self);
gboolean designer_window_render_overlay (DesignerWindow* self);
static void ___lambda66__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda67_ (DesignerWindow* self);
static void ___lambda67__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda68_ (DesignerWindow* self);
static void ___lambda68__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda69_ (DesignerWindow* self);
static void ___lambda69__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda70_ (DesignerWindow* self);
static void ___lambda70__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda71_ (DesignerWindow* self);
static void ___lambda71__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda72_ (DesignerWindow* self);
static void ___lambda72__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda73_ (DesignerWindow* self);
static void ___lambda73__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda74_ (DesignerWindow* self);
void designer_forget_wire (Designer* self);
static void ___lambda74__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda75_ (DesignerWindow* self);
static void ___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda76_ (DesignerWindow* self);
static void ___lambda76__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda77_ (DesignerWindow* self);
static void ___lambda77__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda78_ (DesignerWindow* self);
static gboolean designer_window_get_hasDesigner (DesignerWindow* self);
gboolean designer_set_insert_last_custom (Designer* self);
static void designer_window_deselect_tools (DesignerWindow* self);
static void ___lambda78__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda79_ (DesignerWindow* self);
gboolean designer_set_insert_last_plugin (Designer* self);
static void ___lambda79__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static ComponentDef** _vala_array_dup46 (ComponentDef** self, int length);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
static void _____lambda80_ (Block1Data* _data1_);
void designer_set_insert_component (Designer* self, ComponentDef* insertComponentDef);
static void ______lambda80__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _vala_array_add58 (GtkRadioToolButton*** array, int* length, int* size, GtkRadioToolButton* value);
static void _vala_array_add59 (GtkImage*** array, int* length, int* size, GtkImage* value);
static gboolean designer_window_mouse_down (DesignerWindow* self, GdkEventButton* event);
static gboolean _designer_window_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean designer_window_mouse_move (DesignerWindow* self, GdkEventMotion* event);
static gboolean _designer_window_mouse_move_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean designer_window_mouse_up (DesignerWindow* self, GdkEventButton* event);
static gboolean _designer_window_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda81_ (DesignerWindow* self, cairo_t* context);
static gboolean ___lambda81__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean __lambda82_ (DesignerWindow* self);
static gboolean ___lambda82__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
void designer_window_update_custom_menu (DesignerWindow* self);
void designer_window_update_plugin_menu (DesignerWindow* self);
static gboolean designer_window_get_hasProject (DesignerWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
GType plugin_component_def_get_type (void) G_GNUC_CONST;
gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
static void ______lambda3_ (Block2Data* _data2_);
static void _______lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _vala_array_add60 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value);
static void ______lambda4_ (Block2Data* _data2_);
gint project_reopen_window_from_component (Project* self, CustomComponentDef* customComponentDef);
static void _______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _vala_array_add61 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ______lambda5_ (Block3Data* _data3_);
static void _______lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _vala_array_add62 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value);
static void ______lambda6_ (Block3Data* _data3_);
static gboolean designer_window_remove_plugin_component (DesignerWindow* self, PluginComponentDef* pluginComponentDef);
static void _______lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _vala_array_add63 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value);
void designer_window_update_error_mode (DesignerWindow* self, gboolean _error_);
gboolean designer_get_hasComponent (Designer* self);
void custom_component_def_get_design_bounds (CustomComponentDef* self, gint* right, gint* down, gint* left, gint* up);
void designer_customise_component (Designer* self);
void project_configure (Project* self);
void project_update_titles (Project* self);
CircuitInformation* circuit_information_new (Project* project);
CircuitInformation* circuit_information_construct (GType object_type, Project* project);
const gchar* circuit_information_get_summary (CircuitInformation* self);
void basic_dialog_information (GtkWindow* window, const gchar* text);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gint designer_snap_pin (Designer* self, gint* x, gint* y, gint range);
void designer_select_components (Designer* self, gint x, gint y, gboolean toggle);
void designer_select_wires (Designer* self, gint x, gint y, gboolean toggle, gboolean includeTag);
void designer_select_annotations (Designer* self, gint x, gint y, gboolean toggle);
void designer_move_components (Designer* self, gint x, gint y, gboolean ignoreSelect, gboolean autoBind);
void designer_move_wires (Designer* self, gint x, gint y, gboolean ignoreSelect, gboolean autoBind);
void designer_move_annotations (Designer* self, gint x, gint y, gboolean ignoreSelect);
void designer_delete_components (Designer* self, gint x, gint y);
void designer_delete_wires (Designer* self, gint x, gint y);
void designer_delete_tags (Designer* self, gint x, gint y);
void designer_delete_annotations (Designer* self, gint x, gint y);
void designer_adjust_components (Designer* self, gint x, gint y, gboolean autoBind);
void designer_adjust_annotations (Designer* self, gint x, gint y);
void designer_adjust_wires (Designer* self, gint x, gint y);
void designer_add_annotation (Designer* self, gint x, gint y, const gchar* text, gdouble fontSize);
void designer_draw_wire (Designer* self, gint x, gint y, gfloat diagonalThreshold, gboolean autoBind);
gint designer_bind_wire (Designer* self, gint x, gint y);
gint designer_connect_component (Designer* self, gint x, gint y);
gint designer_unbind_wire (Designer* self, gint x, gint y);
gint designer_disconnect_component (Designer* self, gint x, gint y);
void designer_tag_wire (Designer* self, gint x1, gint y1, gint x2, gint y2, gboolean oldDirection);
void designer_invert_pin (Designer* self, gint x, gint y);
void designer_add_componentInst (Designer* self, gint x, gint y, Direction direction, gboolean autoBind);
void designer_flip_component (Designer* self, gboolean autoBind);
void designer_orientate_component (Designer* self, Direction direction, gboolean autoBind);
void designer_set_name (Designer* self, const gchar* newName);
const gchar* project_get_name (Project* self);
const gchar* designer_get_designerName (Designer* self);
gint project_reopen_window_from_file (Project* self, const gchar* filename);
gboolean project_plugins_allowed (Project* self, const gchar* extra);
PluginComponentDef* project_load_plugin_component (Project* self, const gchar* filename, const gchar* altFilename);
void project_update_plugin_menus (Project* self);
gint basic_dialog_ask_overwrite (GtkWindow* window, const gchar* filename);
gint designer_save_component (Designer* self, const gchar* filename);
static gboolean designer_window_do_save_project (DesignerWindow* self, gboolean saveAs);
gint project_save (Project* self, const gchar* filename);
void designer_set_component (Designer* self, CustomComponentDef* customComponentDef);
CustomComponentDef* project_new_component (Project* self);
CustomComponentDef* project_load_component (Project* self, const gchar* fileName);
void project_unregister_designer (Project* self, Designer* designer);
static void designer_window_set_hasDesigner (DesignerWindow* self, gboolean value);
Designer* project_new_designer (Project* self, DesignerWindow* window);
Project* project_new (void);
Project* project_construct (GType object_type);
GQuark project_load_error_quark (void);
Project* project_new_load (const gchar* filename, GError** error);
Project* project_construct_load (GType object_type, const gchar* filename, GError** error);
CustomComponentDef* project_get_default_component (Project* self);
#define CORE_versionString PACKAGE_VERSION ""
#define CORE_copyrightString "Ashley Newson 2013"
#define CORE_licenseType GTK_LICENSE_GPL_3_0
#define CORE_licenseName "Public Package - GNU GPL 3.0 - Freely Distributable"
#define CORE_shortLicenseText "This software, SmartSim, and its corresponding resource files are the\n" \
"intellectual property of Ashley Newson. This package is released under" \
"\n" \
"the GNU General Public License 3.0. A provided \"COPYING\" file provid" \
"es\n" \
"the full license text.\n" \
"\n" \
"This package may be provided with the Gtk and Rsvg Libraries. The\n" \
"licenses of these libraries are included in the \"GTK_COPYING\" and\n" \
"\"RSVG_COPYING\" files.\n" \
"\n" \
"SmartSim is free software; you can redistribute it and/or modify it\n" \
"under the terms of the GNU General Public Licence as published by the\n" \
"Free Software Foundation; either version 3 of the Licence, or (at your" \
"\n" \
"option) any later version.\n" \
"\n" \
"SmartSim is distributed in the hope that it will be useful, but WITHOU" \
"T\n" \
"ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or\n" \
"FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Licence\n" \
"for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public Licence alon" \
"g\n" \
"with SmartSim. If not, see:\n" \
"  http://www.gnu.org/licenses/\n"
#define CORE_websiteString "http://www.smartsim.org.uk"
void designer_window_print_render (DesignerWindow* self, GtkPrintContext* printContext, gint page_nr);
static void _designer_window_print_render_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void component_inst_render (ComponentInst* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
#define CORE_shortVersionString PACKAGE_VERSION
void designer_render (Designer* self, cairo_t* context, gboolean showHints, gboolean showErrors, gboolean colourBackgrounds);
GType image_exporter_image_format_get_type (void) G_GNUC_CONST;
void image_exporter_export_png (ImageExporterRenderer renderer, void* renderer_target);
static void designer_window_file_render (DesignerWindow* self, const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution);
static void _designer_window_file_render_image_exporter_renderer (const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution, gpointer self);
void image_exporter_export_pdf (ImageExporterRenderer renderer, void* renderer_target);
void image_exporter_export_svg (ImageExporterRenderer renderer, void* renderer_target);
static gboolean designer_window_comfirm_close (DesignerWindow* self);
static void designer_window_unregister_designerwindow (DesignerWindow* self);
void designer_window_force_destroy_window (DesignerWindow* self);
gint basic_dialog_ask_proceed (GtkWindow* window, const gchar* text, const gchar* buttonOK, const gchar* buttonCancel);
gint project_remove_component (Project* self, CustomComponentDef* removeComponent);
void project_update_custom_menus (Project* self);
gint project_remove_plugin_component (Project* self, PluginComponentDef* removeComponent);
CompiledCircuit* project_validate (Project* self);
const gchar* compiled_circuit_get_errorMessage (CompiledCircuit* self);
CompiledCircuit* project_run (Project* self, gboolean* startNow);
void project_set_root_component (Project* self, CustomComponentDef* rootComponent);
static void designer_window_finalize (GObject* obj);
static void _vala_designer_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_designer_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gchar* CORE_authorsStrings[2];

/**
 * Actions to perform when the mouse button is released.
 */
static GType designer_window_mouse_mode_get_type (void) {
	static volatile gsize designer_window_mouse_mode_type_id__volatile = 0;
	if (g_once_init_enter (&designer_window_mouse_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{DESIGNER_WINDOW_MOUSE_MODE_SCROLL, "DESIGNER_WINDOW_MOUSE_MODE_SCROLL", "scroll"}, {DESIGNER_WINDOW_MOUSE_MODE_ZOOM, "DESIGNER_WINDOW_MOUSE_MODE_ZOOM", "zoom"}, {DESIGNER_WINDOW_MOUSE_MODE_SELECT, "DESIGNER_WINDOW_MOUSE_MODE_SELECT", "select"}, {DESIGNER_WINDOW_MOUSE_MODE_MOVE, "DESIGNER_WINDOW_MOUSE_MODE_MOVE", "move"}, {DESIGNER_WINDOW_MOUSE_MODE_ORIENTATE, "DESIGNER_WINDOW_MOUSE_MODE_ORIENTATE", "orientate"}, {DESIGNER_WINDOW_MOUSE_MODE_DELETE, "DESIGNER_WINDOW_MOUSE_MODE_DELETE", "delete"}, {DESIGNER_WINDOW_MOUSE_MODE_ADJUST, "DESIGNER_WINDOW_MOUSE_MODE_ADJUST", "adjust"}, {DESIGNER_WINDOW_MOUSE_MODE_ANNOTATE, "DESIGNER_WINDOW_MOUSE_MODE_ANNOTATE", "annotate"}, {DESIGNER_WINDOW_MOUSE_MODE_WIRE, "DESIGNER_WINDOW_MOUSE_MODE_WIRE", "wire"}, {DESIGNER_WINDOW_MOUSE_MODE_BIND, "DESIGNER_WINDOW_MOUSE_MODE_BIND", "bind"}, {DESIGNER_WINDOW_MOUSE_MODE_TAG, "DESIGNER_WINDOW_MOUSE_MODE_TAG", "tag"}, {DESIGNER_WINDOW_MOUSE_MODE_INVERT, "DESIGNER_WINDOW_MOUSE_MODE_INVERT", "invert"}, {DESIGNER_WINDOW_MOUSE_MODE_INSERT, "DESIGNER_WINDOW_MOUSE_MODE_INSERT", "insert"}, {0, NULL, NULL}};
		GType designer_window_mouse_mode_type_id;
		designer_window_mouse_mode_type_id = g_enum_register_static ("DesignerWindowMouseMode", values);
		g_once_init_leave (&designer_window_mouse_mode_type_id__volatile, designer_window_mouse_mode_type_id);
	}
	return designer_window_mouse_mode_type_id__volatile;
}


/**
 * Adds //window// to the list of visible DesignerWindows.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add55 (DesignerWindow*** array, int* length, int* size, DesignerWindow* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DesignerWindow*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void designer_window_register (DesignerWindow* window) {
	gint position = 0;
	DesignerWindow** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	DesignerWindow** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	DesignerWindow* _tmp2_ = NULL;
	DesignerWindow* _tmp3_ = NULL;
	DesignerWindow* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	g_return_if_fail (window != NULL);
	_tmp0_ = designer_window_designerWindows;
	_tmp0__length1 = designer_window_designerWindows_length1;
	position = _tmp0__length1;
	_tmp1_ = designer_window_designerWindows;
	_tmp1__length1 = designer_window_designerWindows_length1;
	_tmp2_ = window;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_vala_array_add55 (&designer_window_designerWindows, &designer_window_designerWindows_length1, &_designer_window_designerWindows_size_, _tmp3_);
	_tmp4_ = window;
	_tmp4_->myID = position;
	_tmp5_ = stdout;
	fprintf (_tmp5_, "Registered designer window %i\n", position);
}


/**
 * Removes //window// from the list of visible DesignerWindows.
 * When there are no more visible windows, the application quits.
 */
static void _vala_array_add56 (DesignerWindow*** array, int* length, int* size, DesignerWindow* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DesignerWindow*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static DesignerWindow** _vala_array_dup45 (DesignerWindow** self, int length) {
	DesignerWindow** result;
	int i;
	result = g_new0 (DesignerWindow*, length + 1);
	for (i = 0; i < length; i++) {
		DesignerWindow* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void designer_window_unregister (DesignerWindow* window) {
	DesignerWindow** tempArray = NULL;
	DesignerWindow** _tmp0_ = NULL;
	gint tempArray_length1 = 0;
	gint _tempArray_size_ = 0;
	gint position = 0;
	gint newID = 0;
	DesignerWindow* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	DesignerWindow** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	DesignerWindow* _tmp7_ = NULL;
	DesignerWindow** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	DesignerWindow** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	FILE* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	DesignerWindow** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	g_return_if_fail (window != NULL);
	_tmp0_ = g_new0 (DesignerWindow*, 0 + 1);
	tempArray = _tmp0_;
	tempArray_length1 = 0;
	_tempArray_size_ = tempArray_length1;
	newID = 0;
	_tmp1_ = window;
	_tmp2_ = _tmp1_->myID;
	position = _tmp2_;
	_tmp3_ = position;
	if (_tmp3_ == (-1)) {
		FILE* _tmp4_ = NULL;
		_tmp4_ = stdout;
		fprintf (_tmp4_, "Window already unregistered!\n");
		tempArray = (_vala_array_free (tempArray, tempArray_length1, (GDestroyNotify) g_object_unref), NULL);
		return;
	}
	_tmp5_ = designer_window_designerWindows;
	_tmp5__length1 = designer_window_designerWindows_length1;
	_tmp6_ = position;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp7_->myID = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				DesignerWindow** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = designer_window_designerWindows;
				_tmp11__length1 = designer_window_designerWindows_length1;
				if (!(_tmp10_ < _tmp11__length1)) {
					break;
				}
				_tmp12_ = i;
				_tmp13_ = position;
				if (_tmp12_ != _tmp13_) {
					DesignerWindow** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					DesignerWindow* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					DesignerWindow** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					DesignerWindow** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					DesignerWindow* _tmp21_ = NULL;
					DesignerWindow* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					_tmp14_ = designer_window_designerWindows;
					_tmp14__length1 = designer_window_designerWindows_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = newID;
					_tmp16_->myID = _tmp17_;
					_tmp18_ = tempArray;
					_tmp18__length1 = tempArray_length1;
					_tmp19_ = designer_window_designerWindows;
					_tmp19__length1 = designer_window_designerWindows_length1;
					_tmp20_ = i;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp22_ = _g_object_ref0 (_tmp21_);
					_vala_array_add56 (&tempArray, &tempArray_length1, &_tempArray_size_, _tmp22_);
					_tmp23_ = newID;
					newID = _tmp23_ + 1;
				}
			}
		}
	}
	_tmp24_ = tempArray;
	_tmp24__length1 = tempArray_length1;
	_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup45 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
	_tmp25__length1 = _tmp24__length1;
	designer_window_designerWindows = (_vala_array_free (designer_window_designerWindows, designer_window_designerWindows_length1, (GDestroyNotify) g_object_unref), NULL);
	designer_window_designerWindows = _tmp25_;
	designer_window_designerWindows_length1 = _tmp25__length1;
	_designer_window_designerWindows_size_ = designer_window_designerWindows_length1;
	_tmp26_ = stdout;
	_tmp27_ = position;
	fprintf (_tmp26_, "Unregistered designer window %i\n", _tmp27_);
	project_clean_up ();
	_tmp28_ = designer_window_designerWindows;
	_tmp28__length1 = designer_window_designerWindows_length1;
	if (_tmp28__length1 == 0) {
		FILE* _tmp29_ = NULL;
		_tmp29_ = stdout;
		fprintf (_tmp29_, "No more designer windows! Closing...\n");
		gtk_main_quit ();
	}
	tempArray = (_vala_array_free (tempArray, tempArray_length1, (GDestroyNotify) g_object_unref), NULL);
}


gboolean designer_window_project_has_windows (Project* project) {
	gboolean result = FALSE;
	DesignerWindow** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (project != NULL, FALSE);
	_tmp0_ = designer_window_designerWindows;
	_tmp0__length1 = designer_window_designerWindows_length1;
	{
		DesignerWindow** designerWindow_collection = NULL;
		gint designerWindow_collection_length1 = 0;
		gint _designerWindow_collection_size_ = 0;
		gint designerWindow_it = 0;
		designerWindow_collection = _tmp0_;
		designerWindow_collection_length1 = _tmp0__length1;
		for (designerWindow_it = 0; designerWindow_it < _tmp0__length1; designerWindow_it = designerWindow_it + 1) {
			DesignerWindow* _tmp1_ = NULL;
			DesignerWindow* designerWindow = NULL;
			_tmp1_ = _g_object_ref0 (designerWindow_collection[designerWindow_it]);
			designerWindow = _tmp1_;
			{
				DesignerWindow* _tmp2_ = NULL;
				Project* _tmp3_ = NULL;
				Project* _tmp4_ = NULL;
				_tmp2_ = designerWindow;
				_tmp3_ = _tmp2_->priv->project;
				_tmp4_ = project;
				if (_tmp3_ == _tmp4_) {
					result = TRUE;
					_g_object_unref0 (designerWindow);
					return result;
				}
				_g_object_unref0 (designerWindow);
			}
		}
	}
	result = FALSE;
	return result;
}


gint designer_window_count_project_windows (Project* project) {
	gint result = 0;
	gint count = 0;
	DesignerWindow** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (project != NULL, 0);
	count = 0;
	_tmp0_ = designer_window_designerWindows;
	_tmp0__length1 = designer_window_designerWindows_length1;
	{
		DesignerWindow** designerWindow_collection = NULL;
		gint designerWindow_collection_length1 = 0;
		gint _designerWindow_collection_size_ = 0;
		gint designerWindow_it = 0;
		designerWindow_collection = _tmp0_;
		designerWindow_collection_length1 = _tmp0__length1;
		for (designerWindow_it = 0; designerWindow_it < _tmp0__length1; designerWindow_it = designerWindow_it + 1) {
			DesignerWindow* _tmp1_ = NULL;
			DesignerWindow* designerWindow = NULL;
			_tmp1_ = _g_object_ref0 (designerWindow_collection[designerWindow_it]);
			designerWindow = _tmp1_;
			{
				DesignerWindow* _tmp2_ = NULL;
				Project* _tmp3_ = NULL;
				Project* _tmp4_ = NULL;
				_tmp2_ = designerWindow;
				_tmp3_ = _tmp2_->priv->project;
				_tmp4_ = project;
				if (_tmp3_ == _tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = count;
					count = _tmp5_ + 1;
				}
				_g_object_unref0 (designerWindow);
			}
		}
	}
	result = count;
	return result;
}


static void _vala_array_add57 (DesignerWindow*** array, int* length, int* size, DesignerWindow* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DesignerWindow*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


DesignerWindow** designer_window_get_project_windows (Project* project, int* result_length1) {
	DesignerWindow** result = NULL;
	DesignerWindow** projectDesignerWindows = NULL;
	DesignerWindow** _tmp0_ = NULL;
	gint projectDesignerWindows_length1 = 0;
	gint _projectDesignerWindows_size_ = 0;
	DesignerWindow** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	DesignerWindow** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_val_if_fail (project != NULL, NULL);
	_tmp0_ = g_new0 (DesignerWindow*, 0 + 1);
	projectDesignerWindows = _tmp0_;
	projectDesignerWindows_length1 = 0;
	_projectDesignerWindows_size_ = projectDesignerWindows_length1;
	_tmp1_ = designer_window_designerWindows;
	_tmp1__length1 = designer_window_designerWindows_length1;
	{
		DesignerWindow** designerWindow_collection = NULL;
		gint designerWindow_collection_length1 = 0;
		gint _designerWindow_collection_size_ = 0;
		gint designerWindow_it = 0;
		designerWindow_collection = _tmp1_;
		designerWindow_collection_length1 = _tmp1__length1;
		for (designerWindow_it = 0; designerWindow_it < _tmp1__length1; designerWindow_it = designerWindow_it + 1) {
			DesignerWindow* _tmp2_ = NULL;
			DesignerWindow* designerWindow = NULL;
			_tmp2_ = _g_object_ref0 (designerWindow_collection[designerWindow_it]);
			designerWindow = _tmp2_;
			{
				DesignerWindow* _tmp3_ = NULL;
				Project* _tmp4_ = NULL;
				Project* _tmp5_ = NULL;
				_tmp3_ = designerWindow;
				_tmp4_ = _tmp3_->priv->project;
				_tmp5_ = project;
				if (_tmp4_ == _tmp5_) {
					DesignerWindow** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					DesignerWindow* _tmp7_ = NULL;
					DesignerWindow* _tmp8_ = NULL;
					_tmp6_ = projectDesignerWindows;
					_tmp6__length1 = projectDesignerWindows_length1;
					_tmp7_ = designerWindow;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_vala_array_add57 (&projectDesignerWindows, &projectDesignerWindows_length1, &_projectDesignerWindows_size_, _tmp8_);
				}
				_g_object_unref0 (designerWindow);
			}
		}
	}
	_tmp9_ = projectDesignerWindows;
	_tmp9__length1 = projectDesignerWindows_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}


/**
 * Create a new DesignerWindow without any project or component.
 */
DesignerWindow* designer_window_construct (GType object_type) {
	DesignerWindow * self = NULL;
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	return self;
}


DesignerWindow* designer_window_new (void) {
	return designer_window_construct (TYPE_DESIGNER_WINDOW);
}


/**
 * Create a new DesignerWindow with a new project but no component.
 */
DesignerWindow* designer_window_construct_with_new_project (GType object_type) {
	DesignerWindow * self = NULL;
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	designer_window_new_project (self);
	return self;
}


DesignerWindow* designer_window_new_with_new_project (void) {
	return designer_window_construct_with_new_project (TYPE_DESIGNER_WINDOW);
}


DesignerWindow* designer_window_construct_with_project_from_file (GType object_type, const gchar* filename) {
	DesignerWindow * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	_tmp0_ = filename;
	designer_window_load_project (self, _tmp0_);
	return self;
}


DesignerWindow* designer_window_new_with_project_from_file (const gchar* filename) {
	return designer_window_construct_with_project_from_file (TYPE_DESIGNER_WINDOW, filename);
}


/**
 * Create a new DesignerWindow with a designer and project, but no
 * component.
 */
static gpointer _project_ref0 (gpointer self) {
	return self ? project_ref (self) : NULL;
}


DesignerWindow* designer_window_construct_with_new_designer (GType object_type, Project* project) {
	DesignerWindow * self = NULL;
	Project* _tmp0_ = NULL;
	Project* _tmp1_ = NULL;
	DesignerWindow* _tmp2_ = NULL;
	DesignerWindow* _tmp3_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	_tmp0_ = project;
	_tmp1_ = _project_ref0 (_tmp0_);
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp1_;
	designer_window_set_hasProject (self, TRUE);
	designer_window_update_title (self);
	_tmp2_ = designer_window_new_designer (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	return self;
}


DesignerWindow* designer_window_new_with_new_designer (Project* project) {
	return designer_window_construct_with_new_designer (TYPE_DESIGNER_WINDOW, project);
}


DesignerWindow* designer_window_construct_with_existing_component (GType object_type, Project* project, CustomComponentDef* customComponentDef) {
	DesignerWindow * self = NULL;
	Project* _tmp0_ = NULL;
	Project* _tmp1_ = NULL;
	DesignerWindow* _tmp2_ = NULL;
	DesignerWindow* _tmp3_ = NULL;
	CustomComponentDef* _tmp4_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	g_return_val_if_fail (customComponentDef != NULL, NULL);
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	_tmp0_ = project;
	_tmp1_ = _project_ref0 (_tmp0_);
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp1_;
	designer_window_set_hasProject (self, TRUE);
	designer_window_update_title (self);
	_tmp2_ = designer_window_new_designer (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = customComponentDef;
	designer_window_set_component (self, _tmp4_);
	return self;
}


DesignerWindow* designer_window_new_with_existing_component (Project* project, CustomComponentDef* customComponentDef) {
	return designer_window_construct_with_existing_component (TYPE_DESIGNER_WINDOW, project, customComponentDef);
}


/**
 * Create a new DesignerWindow with a project, and new designer and
 * component.
 */
DesignerWindow* designer_window_construct_with_new_component (GType object_type, Project* project) {
	DesignerWindow * self = NULL;
	Project* _tmp0_ = NULL;
	Project* _tmp1_ = NULL;
	DesignerWindow* _tmp2_ = NULL;
	DesignerWindow* _tmp3_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	_tmp0_ = project;
	_tmp1_ = _project_ref0 (_tmp0_);
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp1_;
	designer_window_set_hasProject (self, TRUE);
	designer_window_update_title (self);
	_tmp2_ = designer_window_new_designer (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	designer_window_new_component (self);
	return self;
}


DesignerWindow* designer_window_new_with_new_component (Project* project) {
	return designer_window_construct_with_new_component (TYPE_DESIGNER_WINDOW, project);
}


/**
 * Create a new DesignerWindow with a project, new designer,
 * and load a component from a file.
 */
DesignerWindow* designer_window_construct_with_component_from_file (GType object_type, Project* project, const gchar* filename) {
	DesignerWindow * self = NULL;
	Project* _tmp0_ = NULL;
	Project* _tmp1_ = NULL;
	DesignerWindow* _tmp2_ = NULL;
	DesignerWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_val_if_fail (project != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (DesignerWindow*) g_object_new (object_type, NULL);
	designer_window_populate (self);
	designer_window_register_designerwindow (self);
	_tmp0_ = project;
	_tmp1_ = _project_ref0 (_tmp0_);
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp1_;
	designer_window_set_hasProject (self, TRUE);
	designer_window_update_title (self);
	_tmp2_ = designer_window_new_designer (self);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = filename;
	designer_window_load_component (self, _tmp4_);
	return self;
}


DesignerWindow* designer_window_new_with_component_from_file (Project* project, const gchar* filename) {
	return designer_window_construct_with_component_from_file (TYPE_DESIGNER_WINDOW, project, filename);
}


/**
 * Populate the window with widgets.
 */
static gboolean __lambda7_ (DesignerWindow* self) {
	gboolean result = FALSE;
	designer_window_close_window (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda7__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda7_ ((DesignerWindow*) self);
	return result;
}


static void _designer_window_new_project_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_new_project ((DesignerWindow*) self);
}


static void __lambda8_ (DesignerWindow* self) {
	DesignerWindow* _tmp0_ = NULL;
	DesignerWindow* _tmp1_ = NULL;
	_tmp0_ = designer_window_new_designer (self);
	_tmp1_ = _tmp0_;
	designer_window_new_component (_tmp1_);
	_g_object_unref0 (_tmp1_);
}


static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda8_ ((DesignerWindow*) self);
}


static void __lambda9_ (DesignerWindow* self) {
	designer_window_save_project (self, FALSE);
}


static void ___lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda9_ ((DesignerWindow*) self);
}


static void __lambda10_ (DesignerWindow* self) {
	designer_window_save_project (self, TRUE);
}


static void ___lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda10_ ((DesignerWindow*) self);
}


static void __lambda11_ (DesignerWindow* self) {
	designer_window_open_project (self);
}


static void ___lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda11_ ((DesignerWindow*) self);
}


static void __lambda12_ (DesignerWindow* self) {
	designer_window_save_component (self, FALSE);
}


static void ___lambda12__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda12_ ((DesignerWindow*) self);
}


static void __lambda13_ (DesignerWindow* self) {
	designer_window_save_component (self, TRUE);
}


static void ___lambda13__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda13_ ((DesignerWindow*) self);
}


static void __lambda14_ (DesignerWindow* self) {
	designer_window_open_component (self);
}


static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda14_ ((DesignerWindow*) self);
}


static void __lambda15_ (DesignerWindow* self) {
	designer_window_open_plugin_component (self);
}


static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda15_ ((DesignerWindow*) self);
}


static void _designer_window_export_png_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_export_png ((DesignerWindow*) self);
}


static void _designer_window_export_pdf_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_export_pdf ((DesignerWindow*) self);
}


static void _designer_window_export_svg_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_export_svg ((DesignerWindow*) self);
}


static void _designer_window_print_page_setup_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_print_page_setup ((DesignerWindow*) self);
}


static void _designer_window_print_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_print ((DesignerWindow*) self);
}


static void __lambda16_ (DesignerWindow* self) {
	designer_window_remove_component (self);
}


static void ___lambda16__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda16_ ((DesignerWindow*) self);
}


static void __lambda17_ (DesignerWindow* self) {
	designer_window_close_window (self);
}


static void ___lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda17_ ((DesignerWindow*) self);
}


static void __lambda18_ (DesignerWindow* self) {
	designer_window_fit_design (self);
}


static void ___lambda18__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda18_ ((DesignerWindow*) self);
}


static void __lambda19_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->showGrid = _tmp2_;
	designer_window_render_design (self, NULL);
}


static void ___lambda19__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda19_ ((DesignerWindow*) self, _sender);
}


static void __lambda20_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->liveScrollUpdate = _tmp2_;
}


static void ___lambda20__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda20_ ((DesignerWindow*) self, _sender);
}


static void __lambda21_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->shadowComponent = _tmp2_;
}


static void ___lambda21__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda21_ ((DesignerWindow*) self, _sender);
}


static void __lambda22_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->highlightErrors = _tmp2_;
	designer_window_render_design (self, NULL);
}


static void ___lambda22__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda22_ ((DesignerWindow*) self, _sender);
}


static void __lambda23_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->colourBackgrounds = _tmp2_;
	designer_window_render_design (self, NULL);
}


static void ___lambda23__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda23_ ((DesignerWindow*) self, _sender);
}


static void __lambda24_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->showHints = _tmp2_;
	designer_window_render_design (self, NULL);
}


static void ___lambda24__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda24_ ((DesignerWindow*) self, _sender);
}


static void __lambda25_ (DesignerWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->autoBind = _tmp2_;
	designer_window_render_design (self, NULL);
}


static void ___lambda25__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda25_ ((DesignerWindow*) self, _sender);
}


static void _designer_window_run_circuit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_run_circuit ((DesignerWindow*) self);
}


static void _designer_window_validate_circuit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_validate_circuit ((DesignerWindow*) self);
}


static void _designer_window_set_root_component_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_set_root_component ((DesignerWindow*) self);
}


static void _designer_window_customise_component_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_customise_component ((DesignerWindow*) self);
}


static void _designer_window_display_statistics_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_display_statistics ((DesignerWindow*) self);
}


static void _designer_window_configure_project_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_configure_project ((DesignerWindow*) self);
}


static void _designer_window_show_about_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	designer_window_show_about ((DesignerWindow*) self);
}


static void __lambda66_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_SCROLL;
	designer_window_render_overlay (self);
}


static void ___lambda66__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda66_ ((DesignerWindow*) self);
}


static void __lambda67_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_ZOOM;
	designer_window_render_overlay (self);
}


static void ___lambda67__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda67_ ((DesignerWindow*) self);
}


static void __lambda68_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_SELECT;
	designer_window_render_overlay (self);
}


static void ___lambda68__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda68_ ((DesignerWindow*) self);
}


static void __lambda69_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_MOVE;
	designer_window_render_overlay (self);
}


static void ___lambda69__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda69_ ((DesignerWindow*) self);
}


static void __lambda70_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_ORIENTATE;
	designer_window_render_overlay (self);
}


static void ___lambda70__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda70_ ((DesignerWindow*) self);
}


static void __lambda71_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_DELETE;
	designer_window_render_overlay (self);
}


static void ___lambda71__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda71_ ((DesignerWindow*) self);
}


static void __lambda72_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_ADJUST;
	designer_window_render_overlay (self);
}


static void ___lambda72__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda72_ ((DesignerWindow*) self);
}


static void __lambda73_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_ANNOTATE;
	designer_window_render_overlay (self);
}


static void ___lambda73__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda73_ ((DesignerWindow*) self);
}


static void __lambda74_ (DesignerWindow* self) {
	DesignerWindowMouseMode _tmp0_ = 0;
	_tmp0_ = self->priv->mouseMode;
	if (_tmp0_ == DESIGNER_WINDOW_MOUSE_MODE_WIRE) {
		Designer* _tmp1_ = NULL;
		_tmp1_ = self->priv->designer;
		designer_forget_wire (_tmp1_);
		designer_window_render_design (self, NULL);
	}
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_WIRE;
	designer_window_render_overlay (self);
}


static void ___lambda74__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda74_ ((DesignerWindow*) self);
}


static void __lambda75_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_BIND;
	designer_window_render_overlay (self);
}


static void ___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda75_ ((DesignerWindow*) self);
}


static void __lambda76_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_TAG;
	designer_window_render_overlay (self);
}


static void ___lambda76__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda76_ ((DesignerWindow*) self);
}


static void __lambda77_ (DesignerWindow* self) {
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_INVERT;
	designer_window_render_overlay (self);
}


static void ___lambda77__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda77_ ((DesignerWindow*) self);
}


static void __lambda78_ (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->designer;
		_tmp3_ = designer_set_insert_last_custom (_tmp2_);
		if (_tmp3_) {
			Designer* _tmp4_ = NULL;
			designer_window_deselect_tools (self);
			self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_INSERT;
			_tmp4_ = self->priv->designer;
			designer_set_insert_last_custom (_tmp4_);
			designer_window_render_overlay (self);
		}
	}
}


static void ___lambda78__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda78_ ((DesignerWindow*) self);
}


static void __lambda79_ (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->designer;
		_tmp3_ = designer_set_insert_last_plugin (_tmp2_);
		if (_tmp3_) {
			Designer* _tmp4_ = NULL;
			designer_window_deselect_tools (self);
			self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_INSERT;
			_tmp4_ = self->priv->designer;
			designer_set_insert_last_plugin (_tmp4_);
			designer_window_render_overlay (self);
		}
	}
}


static void ___lambda79__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda79_ ((DesignerWindow*) self);
}


static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


static ComponentDef** _vala_array_dup46 (ComponentDef** self, int length) {
	ComponentDef** result;
	int i;
	result = g_new0 (ComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DesignerWindow* self;
		self = _data1_->self;
		_component_def_unref0 (_data1_->componentDef);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _____lambda80_ (Block1Data* _data1_) {
	DesignerWindow* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = _data1_->self;
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		ComponentDef* _tmp3_ = NULL;
		self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_INSERT;
		_tmp2_ = self->priv->designer;
		_tmp3_ = _data1_->componentDef;
		designer_set_insert_component (_tmp2_, _tmp3_);
		designer_window_render_overlay (self);
	}
}


static void ______lambda80__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	_____lambda80_ (self);
}


static void _vala_array_add58 (GtkRadioToolButton*** array, int* length, int* size, GtkRadioToolButton* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkRadioToolButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add59 (GtkImage*** array, int* length, int* size, GtkImage* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkImage*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _designer_window_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = designer_window_mouse_down ((DesignerWindow*) self, event);
	return result;
}


static gboolean _designer_window_mouse_move_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = designer_window_mouse_move ((DesignerWindow*) self, event);
	return result;
}


static gboolean _designer_window_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = designer_window_mouse_up ((DesignerWindow*) self, event);
	return result;
}


static gboolean __lambda81_ (DesignerWindow* self, cairo_t* context) {
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	designer_window_render_design (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda81__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = __lambda81_ ((DesignerWindow*) self, cr);
	return result;
}


static gboolean __lambda82_ (DesignerWindow* self) {
	gboolean result = FALSE;
	_cairo_surface_destroy0 (self->priv->gridCache);
	self->priv->gridCache = NULL;
	designer_window_render_design (self, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda82__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = __lambda82_ ((DesignerWindow*) self);
	return result;
}


void designer_window_populate (DesignerWindow* self) {
	FILE* _tmp0_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkMenuBar* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkMenuBar* _tmp8_ = NULL;
	GtkMenuItem* _tmp9_ = NULL;
	GtkMenuBar* _tmp10_ = NULL;
	GtkMenuItem* _tmp11_ = NULL;
	GtkMenu* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_ = NULL;
	GtkMenu* _tmp14_ = NULL;
	GtkMenuItem* _tmp15_ = NULL;
	GtkMenu* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_ = NULL;
	GtkMenuItem* _tmp18_ = NULL;
	GtkMenuItem* _tmp19_ = NULL;
	GtkMenu* _tmp20_ = NULL;
	GtkMenuItem* _tmp21_ = NULL;
	GtkMenuItem* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_ = NULL;
	GtkSeparatorMenuItem* _tmp24_ = NULL;
	GtkMenu* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_ = NULL;
	GtkMenuItem* _tmp27_ = NULL;
	GtkMenu* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_ = NULL;
	GtkMenuItem* _tmp30_ = NULL;
	GtkMenuItem* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_ = NULL;
	GtkMenu* _tmp33_ = NULL;
	GtkMenuItem* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_ = NULL;
	GtkMenuItem* _tmp36_ = NULL;
	GtkSeparatorMenuItem* _tmp37_ = NULL;
	GtkMenu* _tmp38_ = NULL;
	GtkMenuItem* _tmp39_ = NULL;
	GtkMenuItem* _tmp40_ = NULL;
	GtkMenu* _tmp41_ = NULL;
	GtkMenuItem* _tmp42_ = NULL;
	GtkMenuItem* _tmp43_ = NULL;
	GtkSeparatorMenuItem* _tmp44_ = NULL;
	GtkMenu* _tmp45_ = NULL;
	GtkMenuItem* _tmp46_ = NULL;
	GtkMenuItem* _tmp47_ = NULL;
	GtkMenu* _tmp48_ = NULL;
	GtkMenuItem* _tmp49_ = NULL;
	GtkMenuItem* _tmp50_ = NULL;
	GtkMenuItem* _tmp51_ = NULL;
	GtkMenuItem* _tmp52_ = NULL;
	GtkMenu* _tmp53_ = NULL;
	GtkMenuItem* _tmp54_ = NULL;
	GtkMenuItem* _tmp55_ = NULL;
	GtkMenuItem* _tmp56_ = NULL;
	GtkSeparatorMenuItem* _tmp57_ = NULL;
	GtkMenu* _tmp58_ = NULL;
	GtkMenuItem* _tmp59_ = NULL;
	GtkMenuItem* _tmp60_ = NULL;
	GtkMenu* _tmp61_ = NULL;
	GtkMenuItem* _tmp62_ = NULL;
	GtkMenuItem* _tmp63_ = NULL;
	GtkMenuItem* _tmp64_ = NULL;
	GtkMenuItem* _tmp65_ = NULL;
	GtkMenu* _tmp66_ = NULL;
	GtkMenuItem* _tmp67_ = NULL;
	GtkMenuItem* _tmp68_ = NULL;
	GtkMenuItem* _tmp69_ = NULL;
	GtkSeparatorMenuItem* _tmp70_ = NULL;
	GtkMenu* _tmp71_ = NULL;
	GtkMenuItem* _tmp72_ = NULL;
	GtkMenuItem* _tmp73_ = NULL;
	GtkMenu* _tmp74_ = NULL;
	GtkMenuItem* _tmp75_ = NULL;
	GtkMenuItem* _tmp76_ = NULL;
	GtkMenu* _tmp77_ = NULL;
	GtkMenuItem* _tmp78_ = NULL;
	GtkMenu* _tmp79_ = NULL;
	GtkMenuItem* _tmp80_ = NULL;
	GtkMenu* _tmp81_ = NULL;
	GtkMenuItem* _tmp82_ = NULL;
	GtkMenuItem* _tmp83_ = NULL;
	GtkMenuItem* _tmp84_ = NULL;
	GtkMenu* _tmp85_ = NULL;
	GtkMenuItem* _tmp86_ = NULL;
	GtkMenuItem* _tmp87_ = NULL;
	GtkMenuItem* _tmp88_ = NULL;
	GtkMenu* _tmp89_ = NULL;
	GtkMenuItem* _tmp90_ = NULL;
	GtkMenuItem* _tmp91_ = NULL;
	GtkSeparatorMenuItem* _tmp92_ = NULL;
	GtkMenu* _tmp93_ = NULL;
	GtkMenuItem* _tmp94_ = NULL;
	GtkMenuItem* _tmp95_ = NULL;
	GtkMenu* _tmp96_ = NULL;
	GtkMenuItem* _tmp97_ = NULL;
	GtkMenuItem* _tmp98_ = NULL;
	GtkMenuItem* _tmp99_ = NULL;
	GtkMenu* _tmp100_ = NULL;
	GtkMenuItem* _tmp101_ = NULL;
	GtkMenuItem* _tmp102_ = NULL;
	GtkMenuItem* _tmp103_ = NULL;
	GtkSeparatorMenuItem* _tmp104_ = NULL;
	GtkMenu* _tmp105_ = NULL;
	GtkMenuItem* _tmp106_ = NULL;
	GtkMenuItem* _tmp107_ = NULL;
	GtkMenu* _tmp108_ = NULL;
	GtkMenuItem* _tmp109_ = NULL;
	GtkMenuItem* _tmp110_ = NULL;
	GtkMenuItem* _tmp111_ = NULL;
	GtkMenuItem* _tmp112_ = NULL;
	GtkMenu* _tmp113_ = NULL;
	GtkMenuItem* _tmp114_ = NULL;
	GtkMenuItem* _tmp115_ = NULL;
	GtkSeparatorMenuItem* _tmp116_ = NULL;
	GtkMenu* _tmp117_ = NULL;
	GtkMenuItem* _tmp118_ = NULL;
	GtkMenuItem* _tmp119_ = NULL;
	GtkMenu* _tmp120_ = NULL;
	GtkMenuItem* _tmp121_ = NULL;
	GtkMenuItem* _tmp122_ = NULL;
	GtkMenuItem* _tmp123_ = NULL;
	GtkMenuBar* _tmp124_ = NULL;
	GtkMenuItem* _tmp125_ = NULL;
	GtkMenu* _tmp126_ = NULL;
	GtkMenuItem* _tmp127_ = NULL;
	GtkMenu* _tmp128_ = NULL;
	GtkMenuItem* _tmp129_ = NULL;
	GtkMenu* _tmp130_ = NULL;
	GtkMenuItem* _tmp131_ = NULL;
	GtkMenuItem* _tmp132_ = NULL;
	GtkSeparatorMenuItem* _tmp133_ = NULL;
	GtkMenu* _tmp134_ = NULL;
	GtkMenuItem* _tmp135_ = NULL;
	GtkCheckMenuItem* _tmp136_ = NULL;
	GtkMenu* _tmp137_ = NULL;
	GtkCheckMenuItem* _tmp138_ = NULL;
	GtkCheckMenuItem* _tmp139_ = NULL;
	GtkCheckMenuItem* _tmp140_ = NULL;
	GtkCheckMenuItem* _tmp141_ = NULL;
	GtkMenu* _tmp142_ = NULL;
	GtkCheckMenuItem* _tmp143_ = NULL;
	GtkCheckMenuItem* _tmp144_ = NULL;
	GtkCheckMenuItem* _tmp145_ = NULL;
	GtkCheckMenuItem* _tmp146_ = NULL;
	GtkMenu* _tmp147_ = NULL;
	GtkCheckMenuItem* _tmp148_ = NULL;
	GtkCheckMenuItem* _tmp149_ = NULL;
	GtkCheckMenuItem* _tmp150_ = NULL;
	GtkCheckMenuItem* _tmp151_ = NULL;
	GtkMenu* _tmp152_ = NULL;
	GtkCheckMenuItem* _tmp153_ = NULL;
	GtkCheckMenuItem* _tmp154_ = NULL;
	GtkCheckMenuItem* _tmp155_ = NULL;
	GtkCheckMenuItem* _tmp156_ = NULL;
	GtkMenu* _tmp157_ = NULL;
	GtkCheckMenuItem* _tmp158_ = NULL;
	GtkCheckMenuItem* _tmp159_ = NULL;
	GtkCheckMenuItem* _tmp160_ = NULL;
	GtkCheckMenuItem* _tmp161_ = NULL;
	GtkMenu* _tmp162_ = NULL;
	GtkCheckMenuItem* _tmp163_ = NULL;
	GtkCheckMenuItem* _tmp164_ = NULL;
	GtkCheckMenuItem* _tmp165_ = NULL;
	GtkMenuItem* _tmp166_ = NULL;
	GtkMenuBar* _tmp167_ = NULL;
	GtkMenuItem* _tmp168_ = NULL;
	GtkMenu* _tmp169_ = NULL;
	GtkMenuItem* _tmp170_ = NULL;
	GtkMenu* _tmp171_ = NULL;
	GtkCheckMenuItem* _tmp172_ = NULL;
	GtkMenu* _tmp173_ = NULL;
	GtkCheckMenuItem* _tmp174_ = NULL;
	GtkCheckMenuItem* _tmp175_ = NULL;
	GtkCheckMenuItem* _tmp176_ = NULL;
	GtkMenuItem* _tmp177_ = NULL;
	GtkMenuBar* _tmp178_ = NULL;
	GtkMenuItem* _tmp179_ = NULL;
	GtkMenu* _tmp180_ = NULL;
	GtkMenuItem* _tmp181_ = NULL;
	GtkMenuItem* _tmp182_ = NULL;
	GtkMenu* _tmp183_ = NULL;
	GtkMenuItem* _tmp184_ = NULL;
	GtkMenuItem* _tmp185_ = NULL;
	GtkMenu* _tmp186_ = NULL;
	GtkMenuItem* _tmp187_ = NULL;
	GtkMenuItem* _tmp188_ = NULL;
	GtkMenuItem* _tmp189_ = NULL;
	GtkMenu* _tmp190_ = NULL;
	GtkMenuItem* _tmp191_ = NULL;
	GtkSeparatorMenuItem* _tmp192_ = NULL;
	GtkMenu* _tmp193_ = NULL;
	GtkMenuItem* _tmp194_ = NULL;
	GtkCheckMenuItem* _tmp195_ = NULL;
	GtkMenu* _tmp196_ = NULL;
	GtkCheckMenuItem* _tmp197_ = NULL;
	GtkMenuItem* _tmp198_ = NULL;
	GtkMenuBar* _tmp199_ = NULL;
	GtkMenuItem* _tmp200_ = NULL;
	GtkMenu* _tmp201_ = NULL;
	GtkMenuItem* _tmp202_ = NULL;
	GtkMenuItem* _tmp203_ = NULL;
	GtkMenu* _tmp204_ = NULL;
	GtkMenuItem* _tmp205_ = NULL;
	GtkMenuItem* _tmp206_ = NULL;
	GtkMenu* _tmp207_ = NULL;
	GtkMenuItem* _tmp208_ = NULL;
	GtkMenuItem* _tmp209_ = NULL;
	GtkMenuItem* _tmp210_ = NULL;
	GtkMenu* _tmp211_ = NULL;
	GtkMenuItem* _tmp212_ = NULL;
	GtkMenuItem* _tmp213_ = NULL;
	GtkMenuBar* _tmp214_ = NULL;
	GtkMenuItem* _tmp215_ = NULL;
	GtkMenu* _tmp216_ = NULL;
	GtkMenuItem* _tmp217_ = NULL;
	GtkMenuItem* _tmp218_ = NULL;
	GtkMenu* _tmp219_ = NULL;
	GtkMenuItem* _tmp220_ = NULL;
	GtkMenuItem* _tmp221_ = NULL;
	GtkMenu* _tmp222_ = NULL;
	GtkMenuItem* _tmp223_ = NULL;
	GtkMenuItem* _tmp224_ = NULL;
	GtkMenuItem* _tmp225_ = NULL;
	GtkMenu* _tmp226_ = NULL;
	GtkMenuItem* _tmp227_ = NULL;
	GtkMenuItem* _tmp228_ = NULL;
	GtkMenuBar* _tmp229_ = NULL;
	GtkMenuItem* _tmp230_ = NULL;
	GtkMenuItem* _tmp231_ = NULL;
	GtkMenuItem* _tmp232_ = NULL;
	GtkMenuBar* _tmp233_ = NULL;
	GtkMenuItem* _tmp234_ = NULL;
	GtkMenu* _tmp235_ = NULL;
	GtkMenuItem* _tmp236_ = NULL;
	GtkMenu* _tmp237_ = NULL;
	GtkMenuItem* _tmp238_ = NULL;
	GtkMenu* _tmp239_ = NULL;
	GtkMenuItem* _tmp240_ = NULL;
	GtkMenuItem* _tmp241_ = NULL;
	GtkRadioToolButton* _tmp242_ = NULL;
	GtkToolbar* _tmp243_ = NULL;
	GtkToolbar* _tmp244_ = NULL;
	GtkBox* _tmp245_ = NULL;
	GtkToolbar* _tmp246_ = NULL;
	GtkImage* _tmp247_ = NULL;
	GtkRadioToolButton* _tmp248_ = NULL;
	GtkRadioToolButton* _tmp249_ = NULL;
	GtkRadioToolButton* _tmp250_ = NULL;
	GtkRadioToolButton* _tmp251_ = NULL;
	GtkImage* _tmp252_ = NULL;
	GtkToolbar* _tmp253_ = NULL;
	GtkRadioToolButton* _tmp254_ = NULL;
	GtkRadioToolButton* _tmp255_ = NULL;
	GtkRadioToolButton* _tmp256_ = NULL;
	GtkRadioToolButton* _tmp257_ = NULL;
	GtkImage* _tmp258_ = NULL;
	GtkRadioToolButton* _tmp259_ = NULL;
	GtkRadioToolButton* _tmp260_ = NULL;
	GtkRadioToolButton* _tmp261_ = NULL;
	GtkRadioToolButton* _tmp262_ = NULL;
	GtkImage* _tmp263_ = NULL;
	GtkToolbar* _tmp264_ = NULL;
	GtkRadioToolButton* _tmp265_ = NULL;
	GtkRadioToolButton* _tmp266_ = NULL;
	GtkRadioToolButton* _tmp267_ = NULL;
	GtkSeparatorToolItem* _tmp268_ = NULL;
	GtkToolbar* _tmp269_ = NULL;
	GtkSeparatorToolItem* _tmp270_ = NULL;
	GtkImage* _tmp271_ = NULL;
	GtkRadioToolButton* _tmp272_ = NULL;
	GtkRadioToolButton* _tmp273_ = NULL;
	GtkRadioToolButton* _tmp274_ = NULL;
	GtkRadioToolButton* _tmp275_ = NULL;
	GtkImage* _tmp276_ = NULL;
	GtkToolbar* _tmp277_ = NULL;
	GtkRadioToolButton* _tmp278_ = NULL;
	GtkRadioToolButton* _tmp279_ = NULL;
	GtkRadioToolButton* _tmp280_ = NULL;
	GtkImage* _tmp281_ = NULL;
	GtkRadioToolButton* _tmp282_ = NULL;
	GtkRadioToolButton* _tmp283_ = NULL;
	GtkRadioToolButton* _tmp284_ = NULL;
	GtkRadioToolButton* _tmp285_ = NULL;
	GtkImage* _tmp286_ = NULL;
	GtkToolbar* _tmp287_ = NULL;
	GtkRadioToolButton* _tmp288_ = NULL;
	GtkRadioToolButton* _tmp289_ = NULL;
	GtkRadioToolButton* _tmp290_ = NULL;
	GtkImage* _tmp291_ = NULL;
	GtkRadioToolButton* _tmp292_ = NULL;
	GtkRadioToolButton* _tmp293_ = NULL;
	GtkRadioToolButton* _tmp294_ = NULL;
	GtkRadioToolButton* _tmp295_ = NULL;
	GtkImage* _tmp296_ = NULL;
	GtkToolbar* _tmp297_ = NULL;
	GtkRadioToolButton* _tmp298_ = NULL;
	GtkRadioToolButton* _tmp299_ = NULL;
	GtkRadioToolButton* _tmp300_ = NULL;
	GtkImage* _tmp301_ = NULL;
	GtkRadioToolButton* _tmp302_ = NULL;
	GtkRadioToolButton* _tmp303_ = NULL;
	GtkRadioToolButton* _tmp304_ = NULL;
	GtkRadioToolButton* _tmp305_ = NULL;
	GtkImage* _tmp306_ = NULL;
	GtkToolbar* _tmp307_ = NULL;
	GtkRadioToolButton* _tmp308_ = NULL;
	GtkRadioToolButton* _tmp309_ = NULL;
	GtkRadioToolButton* _tmp310_ = NULL;
	GtkImage* _tmp311_ = NULL;
	GtkRadioToolButton* _tmp312_ = NULL;
	GtkRadioToolButton* _tmp313_ = NULL;
	GtkRadioToolButton* _tmp314_ = NULL;
	GtkRadioToolButton* _tmp315_ = NULL;
	GtkImage* _tmp316_ = NULL;
	GtkToolbar* _tmp317_ = NULL;
	GtkRadioToolButton* _tmp318_ = NULL;
	GtkRadioToolButton* _tmp319_ = NULL;
	GtkRadioToolButton* _tmp320_ = NULL;
	GtkSeparatorToolItem* _tmp321_ = NULL;
	GtkToolbar* _tmp322_ = NULL;
	GtkSeparatorToolItem* _tmp323_ = NULL;
	GtkImage* _tmp324_ = NULL;
	GtkRadioToolButton* _tmp325_ = NULL;
	GtkRadioToolButton* _tmp326_ = NULL;
	GtkRadioToolButton* _tmp327_ = NULL;
	GtkRadioToolButton* _tmp328_ = NULL;
	GtkImage* _tmp329_ = NULL;
	GtkToolbar* _tmp330_ = NULL;
	GtkRadioToolButton* _tmp331_ = NULL;
	GtkRadioToolButton* _tmp332_ = NULL;
	GtkRadioToolButton* _tmp333_ = NULL;
	GtkImage* _tmp334_ = NULL;
	GtkRadioToolButton* _tmp335_ = NULL;
	GtkRadioToolButton* _tmp336_ = NULL;
	GtkRadioToolButton* _tmp337_ = NULL;
	GtkRadioToolButton* _tmp338_ = NULL;
	GtkImage* _tmp339_ = NULL;
	GtkToolbar* _tmp340_ = NULL;
	GtkRadioToolButton* _tmp341_ = NULL;
	GtkRadioToolButton* _tmp342_ = NULL;
	GtkRadioToolButton* _tmp343_ = NULL;
	GtkImage* _tmp344_ = NULL;
	GtkRadioToolButton* _tmp345_ = NULL;
	GtkRadioToolButton* _tmp346_ = NULL;
	GtkRadioToolButton* _tmp347_ = NULL;
	GtkRadioToolButton* _tmp348_ = NULL;
	GtkImage* _tmp349_ = NULL;
	GtkToolbar* _tmp350_ = NULL;
	GtkRadioToolButton* _tmp351_ = NULL;
	GtkRadioToolButton* _tmp352_ = NULL;
	GtkRadioToolButton* _tmp353_ = NULL;
	GtkImage* _tmp354_ = NULL;
	GtkRadioToolButton* _tmp355_ = NULL;
	GtkRadioToolButton* _tmp356_ = NULL;
	GtkRadioToolButton* _tmp357_ = NULL;
	GtkRadioToolButton* _tmp358_ = NULL;
	GtkImage* _tmp359_ = NULL;
	GtkToolbar* _tmp360_ = NULL;
	GtkRadioToolButton* _tmp361_ = NULL;
	GtkRadioToolButton* _tmp362_ = NULL;
	GtkRadioToolButton* _tmp363_ = NULL;
	GtkImage* _tmp364_ = NULL;
	GtkRadioToolButton* _tmp365_ = NULL;
	GtkRadioToolButton* _tmp366_ = NULL;
	GtkRadioToolButton* _tmp367_ = NULL;
	GtkRadioToolButton* _tmp368_ = NULL;
	GtkImage* _tmp369_ = NULL;
	GtkToolbar* _tmp370_ = NULL;
	GtkRadioToolButton* _tmp371_ = NULL;
	GtkRadioToolButton* _tmp372_ = NULL;
	GtkRadioToolButton* _tmp373_ = NULL;
	GtkSeparatorToolItem* _tmp374_ = NULL;
	GtkToolbar* _tmp375_ = NULL;
	GtkSeparatorToolItem* _tmp376_ = NULL;
	GtkImage* _tmp377_ = NULL;
	GtkImage* _tmp378_ = NULL;
	GtkMenuToolButton* _tmp379_ = NULL;
	GtkToolbar* _tmp380_ = NULL;
	GtkMenuToolButton* _tmp381_ = NULL;
	GtkMenuToolButton* _tmp382_ = NULL;
	GtkMenuToolButton* _tmp383_ = NULL;
	GtkImage* _tmp384_ = NULL;
	GtkImage* _tmp385_ = NULL;
	GtkMenuToolButton* _tmp386_ = NULL;
	GtkToolbar* _tmp387_ = NULL;
	GtkMenuToolButton* _tmp388_ = NULL;
	GtkMenuToolButton* _tmp389_ = NULL;
	GtkMenuToolButton* _tmp390_ = NULL;
	GtkSeparatorToolItem* _tmp391_ = NULL;
	GtkToolbar* _tmp392_ = NULL;
	GtkSeparatorToolItem* _tmp393_ = NULL;
	ComponentDef** _tmp394_ = NULL;
	gint _tmp394__length1 = 0;
	ComponentDef** _tmp395_ = NULL;
	gint _tmp395__length1 = 0;
	GtkEventBox* _tmp435_ = NULL;
	GtkBox* _tmp436_ = NULL;
	GtkEventBox* _tmp437_ = NULL;
	GtkEventBox* _tmp438_ = NULL;
	GtkEventBox* _tmp439_ = NULL;
	GtkEventBox* _tmp440_ = NULL;
	GtkEventBox* _tmp441_ = NULL;
	GtkDrawingArea* _tmp442_ = NULL;
	GtkEventBox* _tmp443_ = NULL;
	GtkDrawingArea* _tmp444_ = NULL;
	GtkDrawingArea* _tmp445_ = NULL;
	GtkDrawingArea* _tmp446_ = NULL;
	GtkPrintSettings* _tmp447_ = NULL;
	GtkPageSetup* _tmp448_ = NULL;
	GtkPageSetup* _tmp449_ = NULL;
	GtkFileFilter* _tmp450_ = NULL;
	GtkFileFilter* _tmp451_ = NULL;
	GtkFileFilter* _tmp452_ = NULL;
	GtkFileFilter* _tmp453_ = NULL;
	GtkFileFilter* _tmp454_ = NULL;
	GtkFileFilter* _tmp455_ = NULL;
	GtkFileFilter* _tmp456_ = NULL;
	GtkFileFilter* _tmp457_ = NULL;
	GtkFileFilter* _tmp458_ = NULL;
	GtkFileFilter* _tmp459_ = NULL;
	GtkFileFilter* _tmp460_ = NULL;
	GtkFileFilter* _tmp461_ = NULL;
	GtkFileFilter* _tmp462_ = NULL;
	GtkFileFilter* _tmp463_ = NULL;
	GtkFileFilter* _tmp464_ = NULL;
	GtkFileFilter* _tmp465_ = NULL;
	GtkFileFilter* _tmp466_ = NULL;
	GtkFileFilter* _tmp467_ = NULL;
	GtkFileFilter* _tmp468_ = NULL;
	GtkFileFilter* _tmp469_ = NULL;
	GtkFileFilter* _tmp470_ = NULL;
	GtkFileFilter* _tmp471_ = NULL;
	GtkFileFilter* _tmp472_ = NULL;
	GtkFileFilter* _tmp473_ = NULL;
	GtkFileFilter* _tmp474_ = NULL;
	GtkFileFilter* _tmp475_ = NULL;
	GtkFileFilter* _tmp476_ = NULL;
	GtkFileFilter* _tmp477_ = NULL;
	GtkFileFilter* _tmp478_ = NULL;
	GtkFileFilter* _tmp479_ = NULL;
	GtkFileFilter* _tmp480_ = NULL;
	GtkFileFilter* _tmp481_ = NULL;
	GtkFileFilter* _tmp482_ = NULL;
	GtkFileFilter* _tmp483_ = NULL;
	GtkFileFilter* _tmp484_ = NULL;
	GtkFileFilter* _tmp485_ = NULL;
	GtkFileFilter* _tmp486_ = NULL;
	GtkFileFilter* _tmp487_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Design Window Created\n");
	gtk_window_set_default_size ((GtkWindow*) self, 800, 600);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda7__gtk_widget_delete_event, self, 0);
	gtk_window_set_title ((GtkWindow*) self, CORE_programName);
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		_tmp2_ = gdk_pixbuf_new_from_file (PACKAGE_DATADIR "images/icons/smartsim64.png", &_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
		gtk_window_set_icon ((GtkWindow*) self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally49;
	__catch49_g_error:
	{
		FILE* _tmp3_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "Could not load window image.\n");
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->vBox);
	self->priv->vBox = _tmp4_;
	_tmp5_ = self->priv->vBox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkMenuBar*) gtk_menu_bar_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp6_;
	_tmp7_ = self->priv->vBox;
	_tmp8_ = self->priv->menubar;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("File");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->menuFile);
	self->priv->menuFile = _tmp9_;
	_tmp10_ = self->priv->menubar;
	_tmp11_ = self->priv->menuFile;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->menuFileMenu);
	self->priv->menuFileMenu = _tmp12_;
	_tmp13_ = self->priv->menuFile;
	_tmp14_ = self->priv->menuFileMenu;
	gtk_menu_item_set_submenu (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("New Project");
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->menuFileNewproject);
	self->priv->menuFileNewproject = _tmp15_;
	_tmp16_ = self->priv->menuFileMenu;
	_tmp17_ = self->priv->menuFileNewproject;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->menuFileNewproject;
	g_signal_connect_object (_tmp18_, "activate", (GCallback) _designer_window_new_project_gtk_menu_item_activate, self, 0);
	_tmp19_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("New Component");
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->menuFileNewcomponent);
	self->priv->menuFileNewcomponent = _tmp19_;
	_tmp20_ = self->priv->menuFileMenu;
	_tmp21_ = self->priv->menuFileNewcomponent;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->menuFileNewcomponent;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) ___lambda8__gtk_menu_item_activate, self, 0);
	_tmp23_ = self->priv->menuFileNewcomponent;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, FALSE);
	_tmp24_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->menuFileSeparator1);
	self->priv->menuFileSeparator1 = (GtkMenuItem*) _tmp24_;
	_tmp25_ = self->priv->menuFileMenu;
	_tmp26_ = self->priv->menuFileSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Save Project");
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->menuFileSaveproject);
	self->priv->menuFileSaveproject = _tmp27_;
	_tmp28_ = self->priv->menuFileMenu;
	_tmp29_ = self->priv->menuFileSaveproject;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->menuFileSaveproject;
	g_signal_connect_object (_tmp30_, "activate", (GCallback) ___lambda9__gtk_menu_item_activate, self, 0);
	_tmp31_ = self->priv->menuFileSaveproject;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, FALSE);
	_tmp32_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Save Project As");
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->menuFileSaveasproject);
	self->priv->menuFileSaveasproject = _tmp32_;
	_tmp33_ = self->priv->menuFileMenu;
	_tmp34_ = self->priv->menuFileSaveasproject;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->menuFileSaveasproject;
	g_signal_connect_object (_tmp35_, "activate", (GCallback) ___lambda10__gtk_menu_item_activate, self, 0);
	_tmp36_ = self->priv->menuFileSaveasproject;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, FALSE);
	_tmp37_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->menuFileSeparator2);
	self->priv->menuFileSeparator2 = (GtkMenuItem*) _tmp37_;
	_tmp38_ = self->priv->menuFileMenu;
	_tmp39_ = self->priv->menuFileSeparator2;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Open Project");
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->menuFileOpenproject);
	self->priv->menuFileOpenproject = _tmp40_;
	_tmp41_ = self->priv->menuFileMenu;
	_tmp42_ = self->priv->menuFileOpenproject;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->menuFileOpenproject;
	g_signal_connect_object (_tmp43_, "activate", (GCallback) ___lambda11__gtk_menu_item_activate, self, 0);
	_tmp44_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->menuFileSeparator3);
	self->priv->menuFileSeparator3 = (GtkMenuItem*) _tmp44_;
	_tmp45_ = self->priv->menuFileMenu;
	_tmp46_ = self->priv->menuFileSeparator3;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Save Component");
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->menuFileSave);
	self->priv->menuFileSave = _tmp47_;
	_tmp48_ = self->priv->menuFileMenu;
	_tmp49_ = self->priv->menuFileSave;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = self->priv->menuFileSave;
	g_signal_connect_object (_tmp50_, "activate", (GCallback) ___lambda12__gtk_menu_item_activate, self, 0);
	_tmp51_ = self->priv->menuFileSave;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp51_, FALSE);
	_tmp52_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Save Component As");
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->menuFileSaveas);
	self->priv->menuFileSaveas = _tmp52_;
	_tmp53_ = self->priv->menuFileMenu;
	_tmp54_ = self->priv->menuFileSaveas;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->menuFileSaveas;
	g_signal_connect_object (_tmp55_, "activate", (GCallback) ___lambda13__gtk_menu_item_activate, self, 0);
	_tmp56_ = self->priv->menuFileSaveas;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, FALSE);
	_tmp57_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->menuFileSeparator4);
	self->priv->menuFileSeparator4 = (GtkMenuItem*) _tmp57_;
	_tmp58_ = self->priv->menuFileMenu;
	_tmp59_ = self->priv->menuFileSeparator4;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Open Component");
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (self->priv->menuFileOpen);
	self->priv->menuFileOpen = _tmp60_;
	_tmp61_ = self->priv->menuFileMenu;
	_tmp62_ = self->priv->menuFileOpen;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = self->priv->menuFileOpen;
	g_signal_connect_object (_tmp63_, "activate", (GCallback) ___lambda14__gtk_menu_item_activate, self, 0);
	_tmp64_ = self->priv->menuFileOpen;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp64_, FALSE);
	_tmp65_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Open Plugin Component");
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->menuFileOpenplugincomponent);
	self->priv->menuFileOpenplugincomponent = _tmp65_;
	_tmp66_ = self->priv->menuFileMenu;
	_tmp67_ = self->priv->menuFileOpenplugincomponent;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = self->priv->menuFileOpenplugincomponent;
	g_signal_connect_object (_tmp68_, "activate", (GCallback) ___lambda15__gtk_menu_item_activate, self, 0);
	_tmp69_ = self->priv->menuFileOpenplugincomponent;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp69_, FALSE);
	_tmp70_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (self->priv->menuFileSeparator5);
	self->priv->menuFileSeparator5 = (GtkMenuItem*) _tmp70_;
	_tmp71_ = self->priv->menuFileMenu;
	_tmp72_ = self->priv->menuFileSeparator5;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Export");
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->menuFileExport);
	self->priv->menuFileExport = _tmp73_;
	_tmp74_ = self->priv->menuFileMenu;
	_tmp75_ = self->priv->menuFileExport;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = self->priv->menuFileExport;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp76_, FALSE);
	_tmp77_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->menuFileExportMenu);
	self->priv->menuFileExportMenu = _tmp77_;
	_tmp78_ = self->priv->menuFileExport;
	_tmp79_ = self->priv->menuFileExportMenu;
	gtk_menu_item_set_submenu (_tmp78_, (GtkWidget*) _tmp79_);
	_tmp80_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Design Image as PNG Image");
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->priv->menuFileExportPng);
	self->priv->menuFileExportPng = _tmp80_;
	_tmp81_ = self->priv->menuFileExportMenu;
	_tmp82_ = self->priv->menuFileExportPng;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp81_, (GtkWidget*) _tmp82_);
	_tmp83_ = self->priv->menuFileExportPng;
	g_signal_connect_object (_tmp83_, "activate", (GCallback) _designer_window_export_png_gtk_menu_item_activate, self, 0);
	_tmp84_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Design Image as PDF Document");
	g_object_ref_sink (_tmp84_);
	_g_object_unref0 (self->priv->menuFileExportPdf);
	self->priv->menuFileExportPdf = _tmp84_;
	_tmp85_ = self->priv->menuFileExportMenu;
	_tmp86_ = self->priv->menuFileExportPdf;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = self->priv->menuFileExportPdf;
	g_signal_connect_object (_tmp87_, "activate", (GCallback) _designer_window_export_pdf_gtk_menu_item_activate, self, 0);
	_tmp88_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Design Image as SVG Image");
	g_object_ref_sink (_tmp88_);
	_g_object_unref0 (self->priv->menuFileExportSvg);
	self->priv->menuFileExportSvg = _tmp88_;
	_tmp89_ = self->priv->menuFileExportMenu;
	_tmp90_ = self->priv->menuFileExportSvg;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = self->priv->menuFileExportSvg;
	g_signal_connect_object (_tmp91_, "activate", (GCallback) _designer_window_export_svg_gtk_menu_item_activate, self, 0);
	_tmp92_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->menuFileSeparator6);
	self->priv->menuFileSeparator6 = (GtkMenuItem*) _tmp92_;
	_tmp93_ = self->priv->menuFileMenu;
	_tmp94_ = self->priv->menuFileSeparator6;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Page Setup");
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->menuFilePagesetup);
	self->priv->menuFilePagesetup = _tmp95_;
	_tmp96_ = self->priv->menuFileMenu;
	_tmp97_ = self->priv->menuFilePagesetup;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp96_, (GtkWidget*) _tmp97_);
	_tmp98_ = self->priv->menuFilePagesetup;
	g_signal_connect_object (_tmp98_, "activate", (GCallback) _designer_window_print_page_setup_gtk_menu_item_activate, self, 0);
	_tmp99_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Print");
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->menuFilePrint);
	self->priv->menuFilePrint = _tmp99_;
	_tmp100_ = self->priv->menuFileMenu;
	_tmp101_ = self->priv->menuFilePrint;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp100_, (GtkWidget*) _tmp101_);
	_tmp102_ = self->priv->menuFilePrint;
	g_signal_connect_object (_tmp102_, "activate", (GCallback) _designer_window_print_gtk_menu_item_activate, self, 0);
	_tmp103_ = self->priv->menuFilePrint;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp103_, FALSE);
	_tmp104_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->menuFileSeparator7);
	self->priv->menuFileSeparator7 = (GtkMenuItem*) _tmp104_;
	_tmp105_ = self->priv->menuFileMenu;
	_tmp106_ = self->priv->menuFileSeparator7;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp105_, (GtkWidget*) _tmp106_);
	_tmp107_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Remove Component");
	g_object_ref_sink (_tmp107_);
	_g_object_unref0 (self->priv->menuFileRemovecomponent);
	self->priv->menuFileRemovecomponent = _tmp107_;
	_tmp108_ = self->priv->menuFileMenu;
	_tmp109_ = self->priv->menuFileRemovecomponent;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp108_, (GtkWidget*) _tmp109_);
	_tmp110_ = self->priv->menuFileRemovecomponent;
	g_signal_connect_object (_tmp110_, "activate", (GCallback) ___lambda16__gtk_menu_item_activate, self, 0);
	_tmp111_ = self->priv->menuFileRemovecomponent;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp111_, FALSE);
	_tmp112_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Remove Plugin Component");
	g_object_ref_sink (_tmp112_);
	_g_object_unref0 (self->priv->menuFileRemoveplugincomponent);
	self->priv->menuFileRemoveplugincomponent = _tmp112_;
	_tmp113_ = self->priv->menuFileMenu;
	_tmp114_ = self->priv->menuFileRemoveplugincomponent;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp113_, (GtkWidget*) _tmp114_);
	_tmp115_ = self->priv->menuFileRemoveplugincomponent;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp115_, FALSE);
	_tmp116_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp116_);
	_g_object_unref0 (self->priv->menuFileSeparator8);
	self->priv->menuFileSeparator8 = (GtkMenuItem*) _tmp116_;
	_tmp117_ = self->priv->menuFileMenu;
	_tmp118_ = self->priv->menuFileSeparator8;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp117_, (GtkWidget*) _tmp118_);
	_tmp119_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Close");
	g_object_ref_sink (_tmp119_);
	_g_object_unref0 (self->priv->menuFileExit);
	self->priv->menuFileExit = _tmp119_;
	_tmp120_ = self->priv->menuFileMenu;
	_tmp121_ = self->priv->menuFileExit;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp120_, (GtkWidget*) _tmp121_);
	_tmp122_ = self->priv->menuFileExit;
	g_signal_connect_object (_tmp122_, "activate", (GCallback) ___lambda17__gtk_menu_item_activate, self, 0);
	_tmp123_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("View");
	g_object_ref_sink (_tmp123_);
	_g_object_unref0 (self->priv->menuView);
	self->priv->menuView = _tmp123_;
	_tmp124_ = self->priv->menubar;
	_tmp125_ = self->priv->menuView;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp124_, (GtkWidget*) _tmp125_);
	_tmp126_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp126_);
	_g_object_unref0 (self->priv->menuViewMenu);
	self->priv->menuViewMenu = _tmp126_;
	_tmp127_ = self->priv->menuView;
	_tmp128_ = self->priv->menuViewMenu;
	gtk_menu_item_set_submenu (_tmp127_, (GtkWidget*) _tmp128_);
	_tmp129_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Fit Design to Display");
	g_object_ref_sink (_tmp129_);
	_g_object_unref0 (self->priv->menuViewFitdesign);
	self->priv->menuViewFitdesign = _tmp129_;
	_tmp130_ = self->priv->menuViewMenu;
	_tmp131_ = self->priv->menuViewFitdesign;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp130_, (GtkWidget*) _tmp131_);
	_tmp132_ = self->priv->menuViewFitdesign;
	g_signal_connect_object (_tmp132_, "activate", (GCallback) ___lambda18__gtk_menu_item_activate, self, 0);
	_tmp133_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp133_);
	_g_object_unref0 (self->priv->menuViewSeparator1);
	self->priv->menuViewSeparator1 = (GtkMenuItem*) _tmp133_;
	_tmp134_ = self->priv->menuViewMenu;
	_tmp135_ = self->priv->menuViewSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp134_, (GtkWidget*) _tmp135_);
	_tmp136_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Show Grid");
	g_object_ref_sink (_tmp136_);
	_g_object_unref0 (self->priv->menuViewShowgrid);
	self->priv->menuViewShowgrid = _tmp136_;
	_tmp137_ = self->priv->menuViewMenu;
	_tmp138_ = self->priv->menuViewShowgrid;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp137_, (GtkWidget*) ((GtkMenuItem*) _tmp138_));
	_tmp139_ = self->priv->menuViewShowgrid;
	gtk_check_menu_item_set_active (_tmp139_, TRUE);
	_tmp140_ = self->priv->menuViewShowgrid;
	g_signal_connect_object (_tmp140_, "toggled", (GCallback) ___lambda19__gtk_check_menu_item_toggled, self, 0);
	_tmp141_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Live Scroll Update");
	g_object_ref_sink (_tmp141_);
	_g_object_unref0 (self->priv->menuViewLivescrollupdate);
	self->priv->menuViewLivescrollupdate = _tmp141_;
	_tmp142_ = self->priv->menuViewMenu;
	_tmp143_ = self->priv->menuViewLivescrollupdate;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp142_, (GtkWidget*) ((GtkMenuItem*) _tmp143_));
	_tmp144_ = self->priv->menuViewLivescrollupdate;
	gtk_check_menu_item_set_active (_tmp144_, FALSE);
	_tmp145_ = self->priv->menuViewLivescrollupdate;
	g_signal_connect_object (_tmp145_, "toggled", (GCallback) ___lambda20__gtk_check_menu_item_toggled, self, 0);
	_tmp146_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Shadow Component");
	g_object_ref_sink (_tmp146_);
	_g_object_unref0 (self->priv->menuViewShadowcomponent);
	self->priv->menuViewShadowcomponent = _tmp146_;
	_tmp147_ = self->priv->menuViewMenu;
	_tmp148_ = self->priv->menuViewShadowcomponent;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp147_, (GtkWidget*) ((GtkMenuItem*) _tmp148_));
	_tmp149_ = self->priv->menuViewShadowcomponent;
	gtk_check_menu_item_set_active (_tmp149_, FALSE);
	_tmp150_ = self->priv->menuViewShadowcomponent;
	g_signal_connect_object (_tmp150_, "toggled", (GCallback) ___lambda21__gtk_check_menu_item_toggled, self, 0);
	_tmp151_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Highlight Errors");
	g_object_ref_sink (_tmp151_);
	_g_object_unref0 (self->priv->menuViewHighlighterrors);
	self->priv->menuViewHighlighterrors = _tmp151_;
	_tmp152_ = self->priv->menuViewMenu;
	_tmp153_ = self->priv->menuViewHighlighterrors;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp152_, (GtkWidget*) ((GtkMenuItem*) _tmp153_));
	_tmp154_ = self->priv->menuViewHighlighterrors;
	gtk_check_menu_item_set_active (_tmp154_, TRUE);
	_tmp155_ = self->priv->menuViewHighlighterrors;
	g_signal_connect_object (_tmp155_, "toggled", (GCallback) ___lambda22__gtk_check_menu_item_toggled, self, 0);
	_tmp156_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Colour Backgrounds");
	g_object_ref_sink (_tmp156_);
	_g_object_unref0 (self->priv->menuViewColourbackgrounds);
	self->priv->menuViewColourbackgrounds = _tmp156_;
	_tmp157_ = self->priv->menuViewMenu;
	_tmp158_ = self->priv->menuViewColourbackgrounds;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp157_, (GtkWidget*) ((GtkMenuItem*) _tmp158_));
	_tmp159_ = self->priv->menuViewColourbackgrounds;
	gtk_check_menu_item_set_active (_tmp159_, TRUE);
	_tmp160_ = self->priv->menuViewColourbackgrounds;
	g_signal_connect_object (_tmp160_, "toggled", (GCallback) ___lambda23__gtk_check_menu_item_toggled, self, 0);
	_tmp161_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Show Designer Hints");
	g_object_ref_sink (_tmp161_);
	_g_object_unref0 (self->priv->menuViewShowdesignerhints);
	self->priv->menuViewShowdesignerhints = _tmp161_;
	_tmp162_ = self->priv->menuViewMenu;
	_tmp163_ = self->priv->menuViewShowdesignerhints;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp162_, (GtkWidget*) ((GtkMenuItem*) _tmp163_));
	_tmp164_ = self->priv->menuViewShowdesignerhints;
	gtk_check_menu_item_set_active (_tmp164_, TRUE);
	_tmp165_ = self->priv->menuViewShowdesignerhints;
	g_signal_connect_object (_tmp165_, "toggled", (GCallback) ___lambda24__gtk_check_menu_item_toggled, self, 0);
	_tmp166_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Edit");
	g_object_ref_sink (_tmp166_);
	_g_object_unref0 (self->priv->menuEdit);
	self->priv->menuEdit = _tmp166_;
	_tmp167_ = self->priv->menubar;
	_tmp168_ = self->priv->menuEdit;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp167_, (GtkWidget*) _tmp168_);
	_tmp169_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp169_);
	_g_object_unref0 (self->priv->menuEditMenu);
	self->priv->menuEditMenu = _tmp169_;
	_tmp170_ = self->priv->menuEdit;
	_tmp171_ = self->priv->menuEditMenu;
	gtk_menu_item_set_submenu (_tmp170_, (GtkWidget*) _tmp171_);
	_tmp172_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Automatic Binding");
	g_object_ref_sink (_tmp172_);
	_g_object_unref0 (self->priv->menuEditAutobind);
	self->priv->menuEditAutobind = _tmp172_;
	_tmp173_ = self->priv->menuEditMenu;
	_tmp174_ = self->priv->menuEditAutobind;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp173_, (GtkWidget*) ((GtkMenuItem*) _tmp174_));
	_tmp175_ = self->priv->menuEditAutobind;
	gtk_check_menu_item_set_active (_tmp175_, TRUE);
	_tmp176_ = self->priv->menuEditAutobind;
	g_signal_connect_object (_tmp176_, "toggled", (GCallback) ___lambda25__gtk_check_menu_item_toggled, self, 0);
	_tmp177_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Run");
	g_object_ref_sink (_tmp177_);
	_g_object_unref0 (self->priv->menuRun);
	self->priv->menuRun = _tmp177_;
	_tmp178_ = self->priv->menubar;
	_tmp179_ = self->priv->menuRun;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp178_, (GtkWidget*) _tmp179_);
	_tmp180_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp180_);
	_g_object_unref0 (self->priv->menuRunMenu);
	self->priv->menuRunMenu = _tmp180_;
	_tmp181_ = self->priv->menuRun;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp181_, FALSE);
	_tmp182_ = self->priv->menuRun;
	_tmp183_ = self->priv->menuRunMenu;
	gtk_menu_item_set_submenu (_tmp182_, (GtkWidget*) _tmp183_);
	_tmp184_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Run");
	g_object_ref_sink (_tmp184_);
	_g_object_unref0 (self->priv->menuRunRun);
	self->priv->menuRunRun = _tmp184_;
	_tmp185_ = self->priv->menuRunRun;
	g_signal_connect_object (_tmp185_, "activate", (GCallback) _designer_window_run_circuit_gtk_menu_item_activate, self, 0);
	_tmp186_ = self->priv->menuRunMenu;
	_tmp187_ = self->priv->menuRunRun;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp186_, (GtkWidget*) _tmp187_);
	_tmp188_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Check Circuit Validity");
	g_object_ref_sink (_tmp188_);
	_g_object_unref0 (self->priv->menuRunCheckcircuit);
	self->priv->menuRunCheckcircuit = _tmp188_;
	_tmp189_ = self->priv->menuRunCheckcircuit;
	g_signal_connect_object (_tmp189_, "activate", (GCallback) _designer_window_validate_circuit_gtk_menu_item_activate, self, 0);
	_tmp190_ = self->priv->menuRunMenu;
	_tmp191_ = self->priv->menuRunCheckcircuit;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp190_, (GtkWidget*) _tmp191_);
	_tmp192_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp192_);
	_g_object_unref0 (self->priv->menuRunSeparator1);
	self->priv->menuRunSeparator1 = (GtkMenuItem*) _tmp192_;
	_tmp193_ = self->priv->menuRunMenu;
	_tmp194_ = self->priv->menuRunSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp193_, (GtkWidget*) _tmp194_);
	_tmp195_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Start Paused");
	g_object_ref_sink (_tmp195_);
	_g_object_unref0 (self->priv->menuRunStartpaused);
	self->priv->menuRunStartpaused = _tmp195_;
	_tmp196_ = self->priv->menuRunMenu;
	_tmp197_ = self->priv->menuRunStartpaused;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp196_, (GtkWidget*) ((GtkMenuItem*) _tmp197_));
	_tmp198_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Component");
	g_object_ref_sink (_tmp198_);
	_g_object_unref0 (self->priv->menuComponent);
	self->priv->menuComponent = _tmp198_;
	_tmp199_ = self->priv->menubar;
	_tmp200_ = self->priv->menuComponent;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp199_, (GtkWidget*) _tmp200_);
	_tmp201_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp201_);
	_g_object_unref0 (self->priv->menuComponentMenu);
	self->priv->menuComponentMenu = _tmp201_;
	_tmp202_ = self->priv->menuComponent;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp202_, FALSE);
	_tmp203_ = self->priv->menuComponent;
	_tmp204_ = self->priv->menuComponentMenu;
	gtk_menu_item_set_submenu (_tmp203_, (GtkWidget*) _tmp204_);
	_tmp205_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Set as Root");
	g_object_ref_sink (_tmp205_);
	_g_object_unref0 (self->priv->menuComponentMakeroot);
	self->priv->menuComponentMakeroot = _tmp205_;
	_tmp206_ = self->priv->menuComponentMakeroot;
	g_signal_connect_object (_tmp206_, "activate", (GCallback) _designer_window_set_root_component_gtk_menu_item_activate, self, 0);
	_tmp207_ = self->priv->menuComponentMenu;
	_tmp208_ = self->priv->menuComponentMakeroot;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp207_, (GtkWidget*) _tmp208_);
	_tmp209_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Customise");
	g_object_ref_sink (_tmp209_);
	_g_object_unref0 (self->priv->menuComponentCustomise);
	self->priv->menuComponentCustomise = _tmp209_;
	_tmp210_ = self->priv->menuComponentCustomise;
	g_signal_connect_object (_tmp210_, "activate", (GCallback) _designer_window_customise_component_gtk_menu_item_activate, self, 0);
	_tmp211_ = self->priv->menuComponentMenu;
	_tmp212_ = self->priv->menuComponentCustomise;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp211_, (GtkWidget*) _tmp212_);
	_tmp213_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Project");
	g_object_ref_sink (_tmp213_);
	_g_object_unref0 (self->priv->menuProject);
	self->priv->menuProject = _tmp213_;
	_tmp214_ = self->priv->menubar;
	_tmp215_ = self->priv->menuProject;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp214_, (GtkWidget*) _tmp215_);
	_tmp216_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp216_);
	_g_object_unref0 (self->priv->menuProjectMenu);
	self->priv->menuProjectMenu = _tmp216_;
	_tmp217_ = self->priv->menuProject;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp217_, FALSE);
	_tmp218_ = self->priv->menuProject;
	_tmp219_ = self->priv->menuProjectMenu;
	gtk_menu_item_set_submenu (_tmp218_, (GtkWidget*) _tmp219_);
	_tmp220_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Statistics");
	g_object_ref_sink (_tmp220_);
	_g_object_unref0 (self->priv->menuProjectStatistics);
	self->priv->menuProjectStatistics = _tmp220_;
	_tmp221_ = self->priv->menuProjectStatistics;
	g_signal_connect_object (_tmp221_, "activate", (GCallback) _designer_window_display_statistics_gtk_menu_item_activate, self, 0);
	_tmp222_ = self->priv->menuProjectMenu;
	_tmp223_ = self->priv->menuProjectStatistics;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp222_, (GtkWidget*) _tmp223_);
	_tmp224_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Options");
	g_object_ref_sink (_tmp224_);
	_g_object_unref0 (self->priv->menuProjectOptions);
	self->priv->menuProjectOptions = _tmp224_;
	_tmp225_ = self->priv->menuProjectOptions;
	g_signal_connect_object (_tmp225_, "activate", (GCallback) _designer_window_configure_project_gtk_menu_item_activate, self, 0);
	_tmp226_ = self->priv->menuProjectMenu;
	_tmp227_ = self->priv->menuProjectOptions;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp226_, (GtkWidget*) _tmp227_);
	_tmp228_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Windows");
	g_object_ref_sink (_tmp228_);
	_g_object_unref0 (self->priv->menuWindows);
	self->priv->menuWindows = _tmp228_;
	_tmp229_ = self->priv->menubar;
	_tmp230_ = self->priv->menuWindows;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp229_, (GtkWidget*) _tmp230_);
	_tmp231_ = self->priv->menuWindows;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp231_, FALSE);
	_tmp232_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Help");
	g_object_ref_sink (_tmp232_);
	_g_object_unref0 (self->priv->menuHelp);
	self->priv->menuHelp = _tmp232_;
	_tmp233_ = self->priv->menubar;
	_tmp234_ = self->priv->menuHelp;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp233_, (GtkWidget*) _tmp234_);
	_tmp235_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp235_);
	_g_object_unref0 (self->priv->menuHelpMenu);
	self->priv->menuHelpMenu = _tmp235_;
	_tmp236_ = self->priv->menuHelp;
	_tmp237_ = self->priv->menuHelpMenu;
	gtk_menu_item_set_submenu (_tmp236_, (GtkWidget*) _tmp237_);
	_tmp238_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("About");
	g_object_ref_sink (_tmp238_);
	_g_object_unref0 (self->priv->menuHelpAbout);
	self->priv->menuHelpAbout = _tmp238_;
	_tmp239_ = self->priv->menuHelpMenu;
	_tmp240_ = self->priv->menuHelpAbout;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp239_, (GtkWidget*) _tmp240_);
	_tmp241_ = self->priv->menuHelpAbout;
	g_signal_connect_object (_tmp241_, "activate", (GCallback) _designer_window_show_about_gtk_menu_item_activate, self, 0);
	_tmp242_ = (GtkRadioToolButton*) gtk_radio_tool_button_new (NULL);
	g_object_ref_sink (_tmp242_);
	_g_object_unref0 (self->priv->hiddenRadioToolButton);
	self->priv->hiddenRadioToolButton = _tmp242_;
	_tmp243_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp243_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp243_;
	_tmp244_ = self->priv->toolbar;
	g_object_set (_tmp244_, "toolbar-style", GTK_TOOLBAR_ICONS, NULL);
	_tmp245_ = self->priv->vBox;
	_tmp246_ = self->priv->toolbar;
	gtk_box_pack_start (_tmp245_, (GtkWidget*) _tmp246_, FALSE, TRUE, (guint) 0);
	_tmp247_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/scroll.png");
	g_object_ref_sink (_tmp247_);
	_g_object_unref0 (self->priv->toolScrollImage);
	self->priv->toolScrollImage = _tmp247_;
	_tmp248_ = self->priv->hiddenRadioToolButton;
	_tmp249_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp248_);
	g_object_ref_sink (_tmp249_);
	_g_object_unref0 (self->priv->toolScroll);
	self->priv->toolScroll = _tmp249_;
	_tmp250_ = self->priv->toolScroll;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp250_, "Scroll");
	_tmp251_ = self->priv->toolScroll;
	_tmp252_ = self->priv->toolScrollImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp251_, (GtkWidget*) _tmp252_);
	_tmp253_ = self->priv->toolbar;
	_tmp254_ = self->priv->toolScroll;
	gtk_toolbar_insert (_tmp253_, (GtkToolItem*) _tmp254_, -1);
	_tmp255_ = self->priv->toolScroll;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp255_, "Scroll: Move your view of the circuit with click and drag.");
	_tmp256_ = self->priv->toolScroll;
	g_signal_connect_object ((GtkToolButton*) _tmp256_, "clicked", (GCallback) ___lambda66__gtk_tool_button_clicked, self, 0);
	_tmp257_ = self->priv->toolScroll;
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) _tmp257_, TRUE);
	_tmp258_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/zoom.png");
	g_object_ref_sink (_tmp258_);
	_g_object_unref0 (self->priv->toolZoomImage);
	self->priv->toolZoomImage = _tmp258_;
	_tmp259_ = self->priv->hiddenRadioToolButton;
	_tmp260_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp259_);
	g_object_ref_sink (_tmp260_);
	_g_object_unref0 (self->priv->toolZoom);
	self->priv->toolZoom = _tmp260_;
	_tmp261_ = self->priv->toolZoom;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp261_, "Zoom");
	_tmp262_ = self->priv->toolZoom;
	_tmp263_ = self->priv->toolZoomImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp262_, (GtkWidget*) _tmp263_);
	_tmp264_ = self->priv->toolbar;
	_tmp265_ = self->priv->toolZoom;
	gtk_toolbar_insert (_tmp264_, (GtkToolItem*) _tmp265_, -1);
	_tmp266_ = self->priv->toolZoom;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp266_, "Zoom: Drag downward to zoom in or upward to zoom out.");
	_tmp267_ = self->priv->toolZoom;
	g_signal_connect_object ((GtkToolButton*) _tmp267_, "clicked", (GCallback) ___lambda67__gtk_tool_button_clicked, self, 0);
	_tmp268_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp268_);
	_g_object_unref0 (self->priv->toolSeparator1);
	self->priv->toolSeparator1 = _tmp268_;
	_tmp269_ = self->priv->toolbar;
	_tmp270_ = self->priv->toolSeparator1;
	gtk_toolbar_insert (_tmp269_, (GtkToolItem*) _tmp270_, -1);
	_tmp271_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/cursor.png");
	g_object_ref_sink (_tmp271_);
	_g_object_unref0 (self->priv->toolCursorImage);
	self->priv->toolCursorImage = _tmp271_;
	_tmp272_ = self->priv->hiddenRadioToolButton;
	_tmp273_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp272_);
	g_object_ref_sink (_tmp273_);
	_g_object_unref0 (self->priv->toolCursor);
	self->priv->toolCursor = _tmp273_;
	_tmp274_ = self->priv->toolCursor;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp274_, "Cursor");
	_tmp275_ = self->priv->toolCursor;
	_tmp276_ = self->priv->toolCursorImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp275_, (GtkWidget*) _tmp276_);
	_tmp277_ = self->priv->toolbar;
	_tmp278_ = self->priv->toolCursor;
	gtk_toolbar_insert (_tmp277_, (GtkToolItem*) _tmp278_, -1);
	_tmp279_ = self->priv->toolCursor;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp279_, "Select: Click on an object to select it.");
	_tmp280_ = self->priv->toolCursor;
	g_signal_connect_object ((GtkToolButton*) _tmp280_, "clicked", (GCallback) ___lambda68__gtk_tool_button_clicked, self, 0);
	_tmp281_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/move.png");
	g_object_ref_sink (_tmp281_);
	_g_object_unref0 (self->priv->toolMoveImage);
	self->priv->toolMoveImage = _tmp281_;
	_tmp282_ = self->priv->hiddenRadioToolButton;
	_tmp283_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp282_);
	g_object_ref_sink (_tmp283_);
	_g_object_unref0 (self->priv->toolMove);
	self->priv->toolMove = _tmp283_;
	_tmp284_ = self->priv->toolMove;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp284_, "Move");
	_tmp285_ = self->priv->toolMove;
	_tmp286_ = self->priv->toolMoveImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp285_, (GtkWidget*) _tmp286_);
	_tmp287_ = self->priv->toolbar;
	_tmp288_ = self->priv->toolMove;
	gtk_toolbar_insert (_tmp287_, (GtkToolItem*) _tmp288_, -1);
	_tmp289_ = self->priv->toolMove;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp289_, "Move: Click and drag an object to move it.");
	_tmp290_ = self->priv->toolMove;
	g_signal_connect_object ((GtkToolButton*) _tmp290_, "clicked", (GCallback) ___lambda69__gtk_tool_button_clicked, self, 0);
	_tmp291_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/orientate.png");
	g_object_ref_sink (_tmp291_);
	_g_object_unref0 (self->priv->toolOrientateImage);
	self->priv->toolOrientateImage = _tmp291_;
	_tmp292_ = self->priv->hiddenRadioToolButton;
	_tmp293_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp292_);
	g_object_ref_sink (_tmp293_);
	_g_object_unref0 (self->priv->toolOrientate);
	self->priv->toolOrientate = _tmp293_;
	_tmp294_ = self->priv->toolOrientate;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp294_, "Orientate");
	_tmp295_ = self->priv->toolOrientate;
	_tmp296_ = self->priv->toolOrientateImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp295_, (GtkWidget*) _tmp296_);
	_tmp297_ = self->priv->toolbar;
	_tmp298_ = self->priv->toolOrientate;
	gtk_toolbar_insert (_tmp297_, (GtkToolItem*) _tmp298_, -1);
	_tmp299_ = self->priv->toolOrientate;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp299_, "Orientate: Change the rotation of a component by dragging it. Flip by " \
"clicking.");
	_tmp300_ = self->priv->toolOrientate;
	g_signal_connect_object ((GtkToolButton*) _tmp300_, "clicked", (GCallback) ___lambda70__gtk_tool_button_clicked, self, 0);
	_tmp301_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/delete.png");
	g_object_ref_sink (_tmp301_);
	_g_object_unref0 (self->priv->toolDeleteImage);
	self->priv->toolDeleteImage = _tmp301_;
	_tmp302_ = self->priv->hiddenRadioToolButton;
	_tmp303_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp302_);
	g_object_ref_sink (_tmp303_);
	_g_object_unref0 (self->priv->toolDelete);
	self->priv->toolDelete = _tmp303_;
	_tmp304_ = self->priv->toolDelete;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp304_, "Delete");
	_tmp305_ = self->priv->toolDelete;
	_tmp306_ = self->priv->toolDeleteImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp305_, (GtkWidget*) _tmp306_);
	_tmp307_ = self->priv->toolbar;
	_tmp308_ = self->priv->toolDelete;
	gtk_toolbar_insert (_tmp307_, (GtkToolItem*) _tmp308_, -1);
	_tmp309_ = self->priv->toolDelete;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp309_, "Delete: Click on an object to delete it.");
	_tmp310_ = self->priv->toolDelete;
	g_signal_connect_object ((GtkToolButton*) _tmp310_, "clicked", (GCallback) ___lambda71__gtk_tool_button_clicked, self, 0);
	_tmp311_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/adjust.png");
	g_object_ref_sink (_tmp311_);
	_g_object_unref0 (self->priv->toolAdjustImage);
	self->priv->toolAdjustImage = _tmp311_;
	_tmp312_ = self->priv->hiddenRadioToolButton;
	_tmp313_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp312_);
	g_object_ref_sink (_tmp313_);
	_g_object_unref0 (self->priv->toolAdjust);
	self->priv->toolAdjust = _tmp313_;
	_tmp314_ = self->priv->toolAdjust;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp314_, "Adjust");
	_tmp315_ = self->priv->toolAdjust;
	_tmp316_ = self->priv->toolAdjustImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp315_, (GtkWidget*) _tmp316_);
	_tmp317_ = self->priv->toolbar;
	_tmp318_ = self->priv->toolAdjust;
	gtk_toolbar_insert (_tmp317_, (GtkToolItem*) _tmp318_, -1);
	_tmp319_ = self->priv->toolAdjust;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp319_, "Adjust: Click on an object to change its properties.");
	_tmp320_ = self->priv->toolAdjust;
	g_signal_connect_object ((GtkToolButton*) _tmp320_, "clicked", (GCallback) ___lambda72__gtk_tool_button_clicked, self, 0);
	_tmp321_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp321_);
	_g_object_unref0 (self->priv->toolSeparator2);
	self->priv->toolSeparator2 = _tmp321_;
	_tmp322_ = self->priv->toolbar;
	_tmp323_ = self->priv->toolSeparator2;
	gtk_toolbar_insert (_tmp322_, (GtkToolItem*) _tmp323_, -1);
	_tmp324_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/annotate.png");
	g_object_ref_sink (_tmp324_);
	_g_object_unref0 (self->priv->toolAnnotateImage);
	self->priv->toolAnnotateImage = _tmp324_;
	_tmp325_ = self->priv->hiddenRadioToolButton;
	_tmp326_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp325_);
	g_object_ref_sink (_tmp326_);
	_g_object_unref0 (self->priv->toolAnnotate);
	self->priv->toolAnnotate = _tmp326_;
	_tmp327_ = self->priv->toolAnnotate;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp327_, "Annotate");
	_tmp328_ = self->priv->toolAnnotate;
	_tmp329_ = self->priv->toolAnnotateImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp328_, (GtkWidget*) _tmp329_);
	_tmp330_ = self->priv->toolbar;
	_tmp331_ = self->priv->toolAnnotate;
	gtk_toolbar_insert (_tmp330_, (GtkToolItem*) _tmp331_, -1);
	_tmp332_ = self->priv->toolAnnotate;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp332_, "Annotate: Click to insert a text comment.");
	_tmp333_ = self->priv->toolAnnotate;
	g_signal_connect_object ((GtkToolButton*) _tmp333_, "clicked", (GCallback) ___lambda73__gtk_tool_button_clicked, self, 0);
	_tmp334_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/wire.png");
	g_object_ref_sink (_tmp334_);
	_g_object_unref0 (self->priv->toolWireImage);
	self->priv->toolWireImage = _tmp334_;
	_tmp335_ = self->priv->hiddenRadioToolButton;
	_tmp336_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp335_);
	g_object_ref_sink (_tmp336_);
	_g_object_unref0 (self->priv->toolWire);
	self->priv->toolWire = _tmp336_;
	_tmp337_ = self->priv->toolWire;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp337_, "Wire");
	_tmp338_ = self->priv->toolWire;
	_tmp339_ = self->priv->toolWireImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp338_, (GtkWidget*) _tmp339_);
	_tmp340_ = self->priv->toolbar;
	_tmp341_ = self->priv->toolWire;
	gtk_toolbar_insert (_tmp340_, (GtkToolItem*) _tmp341_, -1);
	_tmp342_ = self->priv->toolWire;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp342_, "Wire: Insert a wire by clicking on successive points. Click again on t" \
"he last point to finalise the wire. Click on the previous point to und" \
"o. Click this button again to forget the wire currently being draw.");
	_tmp343_ = self->priv->toolWire;
	g_signal_connect_object ((GtkToolButton*) _tmp343_, "clicked", (GCallback) ___lambda74__gtk_tool_button_clicked, self, 0);
	_tmp344_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/bind.png");
	g_object_ref_sink (_tmp344_);
	_g_object_unref0 (self->priv->toolBindImage);
	self->priv->toolBindImage = _tmp344_;
	_tmp345_ = self->priv->hiddenRadioToolButton;
	_tmp346_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp345_);
	g_object_ref_sink (_tmp346_);
	_g_object_unref0 (self->priv->toolBind);
	self->priv->toolBind = _tmp346_;
	_tmp347_ = self->priv->toolBind;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp347_, "Bind");
	_tmp348_ = self->priv->toolBind;
	_tmp349_ = self->priv->toolBindImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp348_, (GtkWidget*) _tmp349_);
	_tmp350_ = self->priv->toolbar;
	_tmp351_ = self->priv->toolBind;
	gtk_toolbar_insert (_tmp350_, (GtkToolItem*) _tmp351_, -1);
	_tmp352_ = self->priv->toolBind;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp352_, "Bind: Click where a wire meets a pin or another wire to connect them. " \
"Click on an existing connection to remove it.");
	_tmp353_ = self->priv->toolBind;
	g_signal_connect_object ((GtkToolButton*) _tmp353_, "clicked", (GCallback) ___lambda75__gtk_tool_button_clicked, self, 0);
	_tmp354_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/tag.png");
	g_object_ref_sink (_tmp354_);
	_g_object_unref0 (self->priv->toolTagImage);
	self->priv->toolTagImage = _tmp354_;
	_tmp355_ = self->priv->hiddenRadioToolButton;
	_tmp356_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp355_);
	g_object_ref_sink (_tmp356_);
	_g_object_unref0 (self->priv->toolTag);
	self->priv->toolTag = _tmp356_;
	_tmp357_ = self->priv->toolTag;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp357_, "Tag");
	_tmp358_ = self->priv->toolTag;
	_tmp359_ = self->priv->toolTagImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp358_, (GtkWidget*) _tmp359_);
	_tmp360_ = self->priv->toolbar;
	_tmp361_ = self->priv->toolTag;
	gtk_toolbar_insert (_tmp360_, (GtkToolItem*) _tmp361_, -1);
	_tmp362_ = self->priv->toolTag;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp362_, "Tag: Drag to or from a wire to create an interface to the higher (cont" \
"ainer) component.");
	_tmp363_ = self->priv->toolTag;
	g_signal_connect_object ((GtkToolButton*) _tmp363_, "clicked", (GCallback) ___lambda76__gtk_tool_button_clicked, self, 0);
	_tmp364_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/invert.png");
	g_object_ref_sink (_tmp364_);
	_g_object_unref0 (self->priv->toolInvertImage);
	self->priv->toolInvertImage = _tmp364_;
	_tmp365_ = self->priv->hiddenRadioToolButton;
	_tmp366_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp365_);
	g_object_ref_sink (_tmp366_);
	_g_object_unref0 (self->priv->toolInvert);
	self->priv->toolInvert = _tmp366_;
	_tmp367_ = self->priv->toolInvert;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp367_, "Invert");
	_tmp368_ = self->priv->toolInvert;
	_tmp369_ = self->priv->toolInvertImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp368_, (GtkWidget*) _tmp369_);
	_tmp370_ = self->priv->toolbar;
	_tmp371_ = self->priv->toolInvert;
	gtk_toolbar_insert (_tmp370_, (GtkToolItem*) _tmp371_, -1);
	_tmp372_ = self->priv->toolInvert;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp372_, "Invert: Click on the end of a pin to invert it.");
	_tmp373_ = self->priv->toolInvert;
	g_signal_connect_object ((GtkToolButton*) _tmp373_, "clicked", (GCallback) ___lambda77__gtk_tool_button_clicked, self, 0);
	_tmp374_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp374_);
	_g_object_unref0 (self->priv->toolSeparator3);
	self->priv->toolSeparator3 = _tmp374_;
	_tmp375_ = self->priv->toolbar;
	_tmp376_ = self->priv->toolSeparator3;
	gtk_toolbar_insert (_tmp375_, (GtkToolItem*) _tmp376_, -1);
	_tmp377_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/custom.png");
	g_object_ref_sink (_tmp377_);
	_g_object_unref0 (self->priv->toolCustomsImage);
	self->priv->toolCustomsImage = _tmp377_;
	_tmp378_ = self->priv->toolCustomsImage;
	_tmp379_ = (GtkMenuToolButton*) gtk_menu_tool_button_new ((GtkWidget*) _tmp378_, "Custom...");
	g_object_ref_sink (_tmp379_);
	_g_object_unref0 (self->priv->toolCustoms);
	self->priv->toolCustoms = _tmp379_;
	_tmp380_ = self->priv->toolbar;
	_tmp381_ = self->priv->toolCustoms;
	gtk_toolbar_insert (_tmp380_, (GtkToolItem*) _tmp381_, -1);
	_tmp382_ = self->priv->toolCustoms;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp382_, "Custom Components: Select a custom component from the drop-down menu. " \
"Click the button for the last used component.");
	_tmp383_ = self->priv->toolCustoms;
	g_signal_connect_object ((GtkToolButton*) _tmp383_, "clicked", (GCallback) ___lambda78__gtk_tool_button_clicked, self, 0);
	_tmp384_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/plugin.png");
	g_object_ref_sink (_tmp384_);
	_g_object_unref0 (self->priv->toolPluginsImage);
	self->priv->toolPluginsImage = _tmp384_;
	_tmp385_ = self->priv->toolPluginsImage;
	_tmp386_ = (GtkMenuToolButton*) gtk_menu_tool_button_new ((GtkWidget*) _tmp385_, "Plugin...");
	g_object_ref_sink (_tmp386_);
	_g_object_unref0 (self->priv->toolPlugins);
	self->priv->toolPlugins = _tmp386_;
	_tmp387_ = self->priv->toolbar;
	_tmp388_ = self->priv->toolPlugins;
	gtk_toolbar_insert (_tmp387_, (GtkToolItem*) _tmp388_, -1);
	_tmp389_ = self->priv->toolPlugins;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp389_, "Plugin Components: Select a plugin component from the drop-down menu. " \
"Click the button for the last used component.");
	_tmp390_ = self->priv->toolPlugins;
	g_signal_connect_object ((GtkToolButton*) _tmp390_, "clicked", (GCallback) ___lambda79__gtk_tool_button_clicked, self, 0);
	_tmp391_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp391_);
	_g_object_unref0 (self->priv->toolSeparator4);
	self->priv->toolSeparator4 = _tmp391_;
	_tmp392_ = self->priv->toolbar;
	_tmp393_ = self->priv->toolSeparator4;
	gtk_toolbar_insert (_tmp392_, (GtkToolItem*) _tmp393_, -1);
	_tmp394_ = core_standardComponentDefs;
	_tmp394__length1 = core_standardComponentDefs_length1;
	_tmp395_ = (_tmp394_ != NULL) ? _vala_array_dup46 (_tmp394_, _tmp394__length1) : ((gpointer) _tmp394_);
	_tmp395__length1 = _tmp394__length1;
	self->priv->standardComponentDefs = (_vala_array_free (self->priv->standardComponentDefs, self->priv->standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	self->priv->standardComponentDefs = _tmp395_;
	self->priv->standardComponentDefs_length1 = _tmp395__length1;
	self->priv->_standardComponentDefs_size_ = self->priv->standardComponentDefs_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp396_ = FALSE;
			_tmp396_ = TRUE;
			while (TRUE) {
				Block1Data* _data1_;
				gint _tmp398_ = 0;
				ComponentDef** _tmp399_ = NULL;
				gint _tmp399__length1 = 0;
				ComponentDef** _tmp400_ = NULL;
				gint _tmp400__length1 = 0;
				gint _tmp401_ = 0;
				ComponentDef* _tmp402_ = NULL;
				ComponentDef* _tmp403_ = NULL;
				GtkImage* toolStandardImage = NULL;
				GtkRadioToolButton* toolStandard = NULL;
				ComponentDef* _tmp404_ = NULL;
				const gchar* _tmp405_ = NULL;
				gchar* _tmp406_ = NULL;
				gchar* _tmp407_ = NULL;
				GtkImage* _tmp408_ = NULL;
				GtkImage* _tmp409_ = NULL;
				GtkRadioToolButton* _tmp410_ = NULL;
				GtkRadioToolButton* _tmp411_ = NULL;
				GtkRadioToolButton* _tmp412_ = NULL;
				ComponentDef* _tmp413_ = NULL;
				const gchar* _tmp414_ = NULL;
				GtkRadioToolButton* _tmp415_ = NULL;
				GtkImage* _tmp416_ = NULL;
				GtkRadioToolButton* _tmp417_ = NULL;
				GtkRadioToolButton** _tmp418_ = NULL;
				gint _tmp418__length1 = 0;
				GtkRadioToolButton* _tmp419_ = NULL;
				GtkRadioToolButton* _tmp420_ = NULL;
				GtkImage** _tmp421_ = NULL;
				gint _tmp421__length1 = 0;
				GtkImage* _tmp422_ = NULL;
				GtkImage* _tmp423_ = NULL;
				GtkToolbar* _tmp424_ = NULL;
				GtkRadioToolButton* _tmp425_ = NULL;
				GtkRadioToolButton* _tmp426_ = NULL;
				ComponentDef* _tmp427_ = NULL;
				const gchar* _tmp428_ = NULL;
				gchar* _tmp429_ = NULL;
				gchar* _tmp430_ = NULL;
				ComponentDef* _tmp431_ = NULL;
				const gchar* _tmp432_ = NULL;
				gchar* _tmp433_ = NULL;
				gchar* _tmp434_ = NULL;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				if (!_tmp396_) {
					gint _tmp397_ = 0;
					_tmp397_ = i;
					i = _tmp397_ + 1;
				}
				_tmp396_ = FALSE;
				_tmp398_ = i;
				_tmp399_ = self->priv->standardComponentDefs;
				_tmp399__length1 = self->priv->standardComponentDefs_length1;
				if (!(_tmp398_ < _tmp399__length1)) {
					block1_data_unref (_data1_);
					_data1_ = NULL;
					break;
				}
				_tmp400_ = self->priv->standardComponentDefs;
				_tmp400__length1 = self->priv->standardComponentDefs_length1;
				_tmp401_ = i;
				_tmp402_ = _tmp400_[_tmp401_];
				_tmp403_ = _component_def_ref0 (_tmp402_);
				_data1_->componentDef = _tmp403_;
				_tmp404_ = _data1_->componentDef;
				_tmp405_ = _tmp404_->iconFilename;
				_tmp406_ = g_strconcat (PACKAGE_DATADIR "components/icons/", _tmp405_, NULL);
				_tmp407_ = _tmp406_;
				_tmp408_ = (GtkImage*) gtk_image_new_from_file (_tmp407_);
				g_object_ref_sink (_tmp408_);
				_g_object_unref0 (toolStandardImage);
				toolStandardImage = _tmp408_;
				_g_free0 (_tmp407_);
				_tmp409_ = toolStandardImage;
				g_object_set (_tmp409_, "icon-size", 24, NULL);
				_tmp410_ = self->priv->hiddenRadioToolButton;
				_tmp411_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp410_);
				g_object_ref_sink (_tmp411_);
				_g_object_unref0 (toolStandard);
				toolStandard = _tmp411_;
				_tmp412_ = toolStandard;
				_tmp413_ = _data1_->componentDef;
				_tmp414_ = _tmp413_->name;
				gtk_tool_button_set_label ((GtkToolButton*) _tmp412_, _tmp414_);
				_tmp415_ = toolStandard;
				_tmp416_ = toolStandardImage;
				gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp415_, (GtkWidget*) _tmp416_);
				_tmp417_ = toolStandard;
				g_signal_connect_data ((GtkToolButton*) _tmp417_, "clicked", (GCallback) ______lambda80__gtk_tool_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
				_tmp418_ = self->priv->toolStandards;
				_tmp418__length1 = self->priv->toolStandards_length1;
				_tmp419_ = toolStandard;
				_tmp420_ = _g_object_ref0 (_tmp419_);
				_vala_array_add58 (&self->priv->toolStandards, &self->priv->toolStandards_length1, &self->priv->_toolStandards_size_, _tmp420_);
				_tmp421_ = self->priv->toolStandardImages;
				_tmp421__length1 = self->priv->toolStandardImages_length1;
				_tmp422_ = toolStandardImage;
				_tmp423_ = _g_object_ref0 (_tmp422_);
				_vala_array_add59 (&self->priv->toolStandardImages, &self->priv->toolStandardImages_length1, &self->priv->_toolStandardImages_size_, _tmp423_);
				_tmp424_ = self->priv->toolbar;
				_tmp425_ = toolStandard;
				gtk_toolbar_insert (_tmp424_, (GtkToolItem*) _tmp425_, -1);
				_tmp426_ = toolStandard;
				_tmp427_ = _data1_->componentDef;
				_tmp428_ = _tmp427_->name;
				_tmp429_ = g_strconcat (_tmp428_, ": ", NULL);
				_tmp430_ = _tmp429_;
				_tmp431_ = _data1_->componentDef;
				_tmp432_ = _tmp431_->description;
				_tmp433_ = g_strconcat (_tmp430_, _tmp432_, NULL);
				_tmp434_ = _tmp433_;
				gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp426_, _tmp434_);
				_g_free0 (_tmp434_);
				_g_free0 (_tmp430_);
				_g_object_unref0 (toolStandard);
				_g_object_unref0 (toolStandardImage);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
		}
	}
	_tmp435_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp435_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp435_;
	_tmp436_ = self->priv->vBox;
	_tmp437_ = self->priv->controller;
	gtk_box_pack_start (_tmp436_, (GtkWidget*) _tmp437_, TRUE, TRUE, (guint) 0);
	_tmp438_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp438_, "button-press-event", (GCallback) _designer_window_mouse_down_gtk_widget_button_press_event, self, 0);
	_tmp439_ = self->priv->controller;
	gtk_widget_set_events ((GtkWidget*) _tmp439_, (gint) GDK_POINTER_MOTION_MASK);
	_tmp440_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp440_, "motion-notify-event", (GCallback) _designer_window_mouse_move_gtk_widget_motion_notify_event, self, 0);
	_tmp441_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp441_, "button-release-event", (GCallback) _designer_window_mouse_up_gtk_widget_button_release_event, self, 0);
	_tmp442_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp442_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp442_;
	_tmp443_ = self->priv->controller;
	_tmp444_ = self->priv->display;
	gtk_container_add ((GtkContainer*) _tmp443_, (GtkWidget*) _tmp444_);
	_tmp445_ = self->priv->display;
	g_signal_connect_object ((GtkWidget*) _tmp445_, "draw", (GCallback) ___lambda81__gtk_widget_draw, self, 0);
	_tmp446_ = self->priv->display;
	g_signal_connect_object ((GtkWidget*) _tmp446_, "configure-event", (GCallback) ___lambda82__gtk_widget_configure_event, self, 0);
	_tmp447_ = gtk_print_settings_new ();
	_g_object_unref0 (self->priv->printSettings);
	self->priv->printSettings = _tmp447_;
	_tmp448_ = gtk_page_setup_new ();
	_g_object_unref0 (self->priv->pageSetup);
	self->priv->pageSetup = _tmp448_;
	_tmp449_ = self->priv->pageSetup;
	gtk_page_setup_set_orientation (_tmp449_, GTK_PAGE_ORIENTATION_LANDSCAPE);
	_tmp450_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp450_);
	_g_object_unref0 (self->priv->anysspFileFilter);
	self->priv->anysspFileFilter = _tmp450_;
	_tmp451_ = self->priv->anysspFileFilter;
	gtk_file_filter_set_name (_tmp451_, "Any SmartSim Project Format (.ssp)");
	_tmp452_ = self->priv->anysspFileFilter;
	gtk_file_filter_add_pattern (_tmp452_, "*.ssp");
	_tmp453_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp453_);
	_g_object_unref0 (self->priv->sspFileFilter);
	self->priv->sspFileFilter = _tmp453_;
	_tmp454_ = self->priv->sspFileFilter;
	gtk_file_filter_set_name (_tmp454_, "SmartSim Project Format (.ssp)");
	_tmp455_ = self->priv->sspFileFilter;
	gtk_file_filter_add_pattern (_tmp455_, "*.ssp");
	_tmp456_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp456_);
	_g_object_unref0 (self->priv->anysscFileFilter);
	self->priv->anysscFileFilter = _tmp456_;
	_tmp457_ = self->priv->anysscFileFilter;
	gtk_file_filter_set_name (_tmp457_, "Any SmartSim Component Format (.ssc, .ssc.xml, .xml)");
	_tmp458_ = self->priv->anysscFileFilter;
	gtk_file_filter_add_pattern (_tmp458_, "*.ssc");
	_tmp459_ = self->priv->anysscFileFilter;
	gtk_file_filter_add_pattern (_tmp459_, "*.ssc.xml");
	_tmp460_ = self->priv->anysscFileFilter;
	gtk_file_filter_add_pattern (_tmp460_, "*.xml");
	_tmp461_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp461_);
	_g_object_unref0 (self->priv->sscFileFilter);
	self->priv->sscFileFilter = _tmp461_;
	_tmp462_ = self->priv->sscFileFilter;
	gtk_file_filter_set_name (_tmp462_, "SmartSim Component (.ssc)");
	_tmp463_ = self->priv->sscFileFilter;
	gtk_file_filter_add_pattern (_tmp463_, "*.ssc");
	_tmp464_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp464_);
	_g_object_unref0 (self->priv->xmlFileFilter);
	self->priv->xmlFileFilter = _tmp464_;
	_tmp465_ = self->priv->xmlFileFilter;
	gtk_file_filter_set_name (_tmp465_, "SmartSim Component (.xml)");
	_tmp466_ = self->priv->xmlFileFilter;
	gtk_file_filter_add_pattern (_tmp466_, "*.xml");
	_tmp467_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp467_);
	_g_object_unref0 (self->priv->sscxmlFileFilter);
	self->priv->sscxmlFileFilter = _tmp467_;
	_tmp468_ = self->priv->sscxmlFileFilter;
	gtk_file_filter_set_name (_tmp468_, "SmartSim Component (.ssc.xml)");
	_tmp469_ = self->priv->sscxmlFileFilter;
	gtk_file_filter_add_pattern (_tmp469_, "*.ssc.xml");
	_tmp470_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp470_);
	_g_object_unref0 (self->priv->anyssxFileFilter);
	self->priv->anyssxFileFilter = _tmp470_;
	_tmp471_ = self->priv->anyssxFileFilter;
	gtk_file_filter_set_name (_tmp471_, "Any SmartSim Plugin Component (.ssx)");
	_tmp472_ = self->priv->anyssxFileFilter;
	gtk_file_filter_add_pattern (_tmp472_, "*.ssx");
	_tmp473_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp473_);
	_g_object_unref0 (self->priv->ssxFileFilter);
	self->priv->ssxFileFilter = _tmp473_;
	_tmp474_ = self->priv->ssxFileFilter;
	gtk_file_filter_set_name (_tmp474_, "SmartSim Plugin Component (.ssx)");
	_tmp475_ = self->priv->ssxFileFilter;
	gtk_file_filter_add_pattern (_tmp475_, "*.ssx");
	_tmp476_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp476_);
	_g_object_unref0 (self->priv->pngFileFilter);
	self->priv->pngFileFilter = _tmp476_;
	_tmp477_ = self->priv->pngFileFilter;
	gtk_file_filter_set_name (_tmp477_, "Portable Network Graphic (.png)");
	_tmp478_ = self->priv->pngFileFilter;
	gtk_file_filter_add_pattern (_tmp478_, "*.png");
	_tmp479_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp479_);
	_g_object_unref0 (self->priv->pdfFileFilter);
	self->priv->pdfFileFilter = _tmp479_;
	_tmp480_ = self->priv->pdfFileFilter;
	gtk_file_filter_set_name (_tmp480_, "Adobe Portable Document (.pdf)");
	_tmp481_ = self->priv->pdfFileFilter;
	gtk_file_filter_add_pattern (_tmp481_, "*.pdf");
	_tmp482_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp482_);
	_g_object_unref0 (self->priv->svgFileFilter);
	self->priv->svgFileFilter = _tmp482_;
	_tmp483_ = self->priv->svgFileFilter;
	gtk_file_filter_set_name (_tmp483_, "Scalable Vector Graphic (.svg)");
	_tmp484_ = self->priv->svgFileFilter;
	gtk_file_filter_add_pattern (_tmp484_, "*.svg");
	_tmp485_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp485_);
	_g_object_unref0 (self->priv->anyFileFilter);
	self->priv->anyFileFilter = _tmp485_;
	_tmp486_ = self->priv->anyFileFilter;
	gtk_file_filter_set_name (_tmp486_, "Any File");
	_tmp487_ = self->priv->anyFileFilter;
	gtk_file_filter_add_pattern (_tmp487_, "*");
	designer_window_update_custom_menu (self);
	designer_window_update_plugin_menu (self);
	gtk_widget_show_all ((GtkWidget*) self);
}


/**
 * Updates the custom components listed in the "Windows" menu and
 * custom component insert menu.
 */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		DesignerWindow* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ______lambda3_ (Block2Data* _data2_) {
	DesignerWindow* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = _data2_->self;
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		CustomComponentDef* _tmp3_ = NULL;
		designer_window_deselect_tools (self);
		self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_INSERT;
		_tmp2_ = self->priv->designer;
		_tmp3_ = _data2_->customComponentDef;
		designer_set_insert_component (_tmp2_, (ComponentDef*) _tmp3_);
		designer_window_render_overlay (self);
	}
}


static void _______lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda3_ (self);
}


static void _vala_array_add60 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkMenuItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ______lambda4_ (Block2Data* _data2_) {
	DesignerWindow* self;
	Project* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	self = _data2_->self;
	_tmp0_ = self->priv->project;
	_tmp1_ = _data2_->customComponentDef;
	project_reopen_window_from_component (_tmp0_, _tmp1_);
}


static void _______lambda4__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda4_ (self);
}


static void _vala_array_add61 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkMenuItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void designer_window_update_custom_menu (DesignerWindow* self) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	GtkMenu* _tmp4_ = NULL;
	GtkMenu* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkMenuToolButton* _tmp43_ = NULL;
	GtkMenu* _tmp44_ = NULL;
	GtkMenuItem* _tmp45_ = NULL;
	GtkMenu* _tmp46_ = NULL;
	GtkMenu* _tmp47_ = NULL;
	GtkMenu* _tmp48_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toolCustomsMenu;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_ = NULL;
		_tmp1_ = self->priv->toolCustomsMenu;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->menuWindowsMenu;
	if (_tmp2_ != NULL) {
		GtkMenu* _tmp3_ = NULL;
		_tmp3_ = self->priv->menuWindowsMenu;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
	}
	_tmp4_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->toolCustomsMenu);
	self->priv->toolCustomsMenu = _tmp4_;
	_tmp5_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->menuWindowsMenu);
	self->priv->menuWindowsMenu = _tmp5_;
	_tmp6_ = designer_window_get_hasProject (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkMenuItem** _tmp8_ = NULL;
		GtkMenuItem** _tmp9_ = NULL;
		_tmp8_ = g_new0 (GtkMenuItem*, 0 + 1);
		self->priv->toolCustomsMenuComponents = (_vala_array_free (self->priv->toolCustomsMenuComponents, self->priv->toolCustomsMenuComponents_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->toolCustomsMenuComponents = _tmp8_;
		self->priv->toolCustomsMenuComponents_length1 = 0;
		self->priv->_toolCustomsMenuComponents_size_ = self->priv->toolCustomsMenuComponents_length1;
		_tmp9_ = g_new0 (GtkMenuItem*, 0 + 1);
		self->priv->menuWindowsComponents = (_vala_array_free (self->priv->menuWindowsComponents, self->priv->menuWindowsComponents_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->menuWindowsComponents = _tmp9_;
		self->priv->menuWindowsComponents_length1 = 0;
		self->priv->_menuWindowsComponents_size_ = self->priv->menuWindowsComponents_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					Block2Data* _data2_;
					gint _tmp12_ = 0;
					Project* _tmp13_ = NULL;
					CustomComponentDef** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					Project* _tmp15_ = NULL;
					CustomComponentDef** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					CustomComponentDef* _tmp18_ = NULL;
					GtkMenuItem* toolMenuItem = NULL;
					CustomComponentDef* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					GtkMenuItem* _tmp21_ = NULL;
					GtkMenu* _tmp22_ = NULL;
					GtkMenuItem* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_ = FALSE;
					GtkMenuItem** _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					GtkMenuItem* _tmp32_ = NULL;
					GtkMenuItem* _tmp33_ = NULL;
					GtkMenuItem* windowMenuItem = NULL;
					CustomComponentDef* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					GtkMenuItem* _tmp36_ = NULL;
					GtkMenu* _tmp37_ = NULL;
					GtkMenuItem* _tmp38_ = NULL;
					GtkMenuItem* _tmp39_ = NULL;
					GtkMenuItem** _tmp40_ = NULL;
					gint _tmp40__length1 = 0;
					GtkMenuItem* _tmp41_ = NULL;
					GtkMenuItem* _tmp42_ = NULL;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->self = g_object_ref (self);
					if (!_tmp10_) {
						gint _tmp11_ = 0;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = self->priv->project;
					_tmp14_ = _tmp13_->customComponentDefs;
					_tmp14__length1 = _tmp13_->customComponentDefs_length1;
					if (!(_tmp12_ < _tmp14__length1)) {
						block2_data_unref (_data2_);
						_data2_ = NULL;
						break;
					}
					_tmp15_ = self->priv->project;
					_tmp16_ = _tmp15_->customComponentDefs;
					_tmp16__length1 = _tmp15_->customComponentDefs_length1;
					_tmp17_ = i;
					_tmp18_ = _tmp16_[_tmp17_];
					_data2_->customComponentDef = _tmp18_;
					_tmp19_ = _data2_->customComponentDef;
					_tmp20_ = ((ComponentDef*) _tmp19_)->name;
					_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp20_);
					g_object_ref_sink (_tmp21_);
					toolMenuItem = _tmp21_;
					_tmp22_ = self->priv->toolCustomsMenu;
					_tmp23_ = toolMenuItem;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp22_, (GtkWidget*) _tmp23_);
					_tmp24_ = toolMenuItem;
					g_signal_connect_data (_tmp24_, "activate", (GCallback) _______lambda3__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp25_ = designer_window_get_hasDesigner (self);
					_tmp26_ = _tmp25_;
					if (_tmp26_) {
						CustomComponentDef* _tmp27_ = NULL;
						Designer* _tmp28_ = NULL;
						CustomComponentDef* _tmp29_ = NULL;
						_tmp27_ = _data2_->customComponentDef;
						_tmp28_ = self->priv->designer;
						_tmp29_ = _tmp28_->customComponentDef;
						if (_tmp27_ == _tmp29_) {
							GtkMenuItem* _tmp30_ = NULL;
							_tmp30_ = toolMenuItem;
							gtk_widget_set_sensitive ((GtkWidget*) _tmp30_, FALSE);
						}
					}
					_tmp31_ = self->priv->toolCustomsMenuComponents;
					_tmp31__length1 = self->priv->toolCustomsMenuComponents_length1;
					_tmp32_ = toolMenuItem;
					_tmp33_ = _g_object_ref0 (_tmp32_);
					_vala_array_add60 (&self->priv->toolCustomsMenuComponents, &self->priv->toolCustomsMenuComponents_length1, &self->priv->_toolCustomsMenuComponents_size_, _tmp33_);
					_tmp34_ = _data2_->customComponentDef;
					_tmp35_ = ((ComponentDef*) _tmp34_)->name;
					_tmp36_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp35_);
					g_object_ref_sink (_tmp36_);
					windowMenuItem = _tmp36_;
					_tmp37_ = self->priv->menuWindowsMenu;
					_tmp38_ = windowMenuItem;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp37_, (GtkWidget*) _tmp38_);
					_tmp39_ = windowMenuItem;
					g_signal_connect_data (_tmp39_, "activate", (GCallback) _______lambda4__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp40_ = self->priv->menuWindowsComponents;
					_tmp40__length1 = self->priv->menuWindowsComponents_length1;
					_tmp41_ = windowMenuItem;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					_vala_array_add61 (&self->priv->menuWindowsComponents, &self->priv->menuWindowsComponents_length1, &self->priv->_menuWindowsComponents_size_, _tmp42_);
					_g_object_unref0 (windowMenuItem);
					_g_object_unref0 (toolMenuItem);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
			}
		}
	}
	_tmp43_ = self->priv->toolCustoms;
	_tmp44_ = self->priv->toolCustomsMenu;
	gtk_menu_tool_button_set_menu (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->menuWindows;
	_tmp46_ = self->priv->menuWindowsMenu;
	gtk_menu_item_set_submenu (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->toolCustomsMenu;
	gtk_widget_show_all ((GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->menuWindowsMenu;
	gtk_widget_show_all ((GtkWidget*) _tmp48_);
}


/**
 * Updates the plugin components listed in the "Windows" menu and
 * plugin component insert menu.
 */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		DesignerWindow* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void ______lambda5_ (Block3Data* _data3_) {
	DesignerWindow* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = _data3_->self;
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		PluginComponentDef* _tmp3_ = NULL;
		designer_window_deselect_tools (self);
		self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_INSERT;
		_tmp2_ = self->priv->designer;
		_tmp3_ = _data3_->pluginComponentDef;
		designer_set_insert_component (_tmp2_, (ComponentDef*) _tmp3_);
		designer_window_render_overlay (self);
	}
}


static void _______lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda5_ (self);
}


static void _vala_array_add62 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkMenuItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ______lambda6_ (Block3Data* _data3_) {
	DesignerWindow* self;
	PluginComponentDef* _tmp0_ = NULL;
	self = _data3_->self;
	_tmp0_ = _data3_->pluginComponentDef;
	designer_window_remove_plugin_component (self, _tmp0_);
}


static void _______lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda6_ (self);
}


static void _vala_array_add63 (GtkMenuItem*** array, int* length, int* size, GtkMenuItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkMenuItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void designer_window_update_plugin_menu (DesignerWindow* self) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* _tmp2_ = NULL;
	GtkMenuItem* _tmp4_ = NULL;
	GtkMenu* _tmp5_ = NULL;
	GtkMenu* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GtkMenuToolButton* _tmp39_ = NULL;
	GtkMenu* _tmp40_ = NULL;
	GtkMenuItem* _tmp41_ = NULL;
	GtkMenu* _tmp42_ = NULL;
	GtkMenu* _tmp43_ = NULL;
	GtkMenu* _tmp44_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toolPluginsMenu;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_ = NULL;
		_tmp1_ = self->priv->toolPluginsMenu;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->menuFileRemoveplugincomponentMenu;
	if (_tmp2_ != NULL) {
		GtkMenu* _tmp3_ = NULL;
		_tmp3_ = self->priv->menuFileRemoveplugincomponentMenu;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
	}
	_tmp4_ = self->priv->menuFileRemoveplugincomponent;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->toolPluginsMenu);
	self->priv->toolPluginsMenu = _tmp5_;
	_tmp6_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->menuFileRemoveplugincomponentMenu);
	self->priv->menuFileRemoveplugincomponentMenu = _tmp6_;
	_tmp7_ = designer_window_get_hasProject (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GtkMenuItem** _tmp9_ = NULL;
		GtkMenuItem** _tmp10_ = NULL;
		_tmp9_ = g_new0 (GtkMenuItem*, 0 + 1);
		self->priv->toolPluginsMenuComponents = (_vala_array_free (self->priv->toolPluginsMenuComponents, self->priv->toolPluginsMenuComponents_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->toolPluginsMenuComponents = _tmp9_;
		self->priv->toolPluginsMenuComponents_length1 = 0;
		self->priv->_toolPluginsMenuComponents_size_ = self->priv->toolPluginsMenuComponents_length1;
		_tmp10_ = g_new0 (GtkMenuItem*, 0 + 1);
		self->priv->menuFileRemoveplugincomponentComponents = (_vala_array_free (self->priv->menuFileRemoveplugincomponentComponents, self->priv->menuFileRemoveplugincomponentComponents_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->menuFileRemoveplugincomponentComponents = _tmp10_;
		self->priv->menuFileRemoveplugincomponentComponents_length1 = 0;
		self->priv->_menuFileRemoveplugincomponentComponents_size_ = self->priv->menuFileRemoveplugincomponentComponents_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					Block3Data* _data3_;
					gint _tmp13_ = 0;
					Project* _tmp14_ = NULL;
					PluginComponentDef** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					Project* _tmp16_ = NULL;
					PluginComponentDef** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					PluginComponentDef* _tmp19_ = NULL;
					GtkMenuItem* toolMenuItem = NULL;
					PluginComponentDef* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					GtkMenuItem* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkMenuItem** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					GtkMenuItem* _tmp27_ = NULL;
					GtkMenuItem* _tmp28_ = NULL;
					GtkMenuItem* removeplugincomponentMenuItem = NULL;
					PluginComponentDef* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					GtkMenuItem* _tmp31_ = NULL;
					GtkMenu* _tmp32_ = NULL;
					GtkMenuItem* _tmp33_ = NULL;
					GtkMenuItem* _tmp34_ = NULL;
					GtkMenuItem** _tmp35_ = NULL;
					gint _tmp35__length1 = 0;
					GtkMenuItem* _tmp36_ = NULL;
					GtkMenuItem* _tmp37_ = NULL;
					GtkMenuItem* _tmp38_ = NULL;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->self = g_object_ref (self);
					if (!_tmp11_) {
						gint _tmp12_ = 0;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = self->priv->project;
					_tmp15_ = _tmp14_->pluginComponentDefs;
					_tmp15__length1 = _tmp14_->pluginComponentDefs_length1;
					if (!(_tmp13_ < _tmp15__length1)) {
						block3_data_unref (_data3_);
						_data3_ = NULL;
						break;
					}
					_tmp16_ = self->priv->project;
					_tmp17_ = _tmp16_->pluginComponentDefs;
					_tmp17__length1 = _tmp16_->pluginComponentDefs_length1;
					_tmp18_ = i;
					_tmp19_ = _tmp17_[_tmp18_];
					_data3_->pluginComponentDef = _tmp19_;
					_tmp20_ = _data3_->pluginComponentDef;
					_tmp21_ = ((ComponentDef*) _tmp20_)->name;
					_tmp22_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp21_);
					g_object_ref_sink (_tmp22_);
					toolMenuItem = _tmp22_;
					_tmp23_ = self->priv->toolPluginsMenu;
					_tmp24_ = toolMenuItem;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
					_tmp25_ = toolMenuItem;
					g_signal_connect_data (_tmp25_, "activate", (GCallback) _______lambda5__gtk_menu_item_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp26_ = self->priv->toolPluginsMenuComponents;
					_tmp26__length1 = self->priv->toolPluginsMenuComponents_length1;
					_tmp27_ = toolMenuItem;
					_tmp28_ = _g_object_ref0 (_tmp27_);
					_vala_array_add62 (&self->priv->toolPluginsMenuComponents, &self->priv->toolPluginsMenuComponents_length1, &self->priv->_toolPluginsMenuComponents_size_, _tmp28_);
					_tmp29_ = _data3_->pluginComponentDef;
					_tmp30_ = ((ComponentDef*) _tmp29_)->name;
					_tmp31_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp30_);
					g_object_ref_sink (_tmp31_);
					removeplugincomponentMenuItem = _tmp31_;
					_tmp32_ = self->priv->menuFileRemoveplugincomponentMenu;
					_tmp33_ = removeplugincomponentMenuItem;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp32_, (GtkWidget*) _tmp33_);
					_tmp34_ = removeplugincomponentMenuItem;
					g_signal_connect_data (_tmp34_, "activate", (GCallback) _______lambda6__gtk_menu_item_activate, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp35_ = self->priv->menuFileRemoveplugincomponentComponents;
					_tmp35__length1 = self->priv->menuFileRemoveplugincomponentComponents_length1;
					_tmp36_ = removeplugincomponentMenuItem;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					_vala_array_add63 (&self->priv->menuFileRemoveplugincomponentComponents, &self->priv->menuFileRemoveplugincomponentComponents_length1, &self->priv->_menuFileRemoveplugincomponentComponents_size_, _tmp37_);
					_tmp38_ = self->priv->menuFileRemoveplugincomponent;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp38_, TRUE);
					_g_object_unref0 (removeplugincomponentMenuItem);
					_g_object_unref0 (toolMenuItem);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
		}
	}
	_tmp39_ = self->priv->toolPlugins;
	_tmp40_ = self->priv->toolPluginsMenu;
	gtk_menu_tool_button_set_menu (_tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->menuFileRemoveplugincomponent;
	_tmp42_ = self->priv->menuFileRemoveplugincomponentMenu;
	gtk_menu_item_set_submenu (_tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->toolPluginsMenu;
	gtk_widget_show_all ((GtkWidget*) _tmp43_);
	_tmp44_ = self->priv->menuFileRemoveplugincomponentMenu;
	gtk_widget_show_all ((GtkWidget*) _tmp44_);
}


static void designer_window_deselect_tools (DesignerWindow* self) {
	GtkRadioToolButton* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hiddenRadioToolButton;
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) _tmp0_, TRUE);
}


void designer_window_update_error_mode (DesignerWindow* self, gboolean _error_) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_) {
		self->priv->colourBackgrounds = FALSE;
	} else {
		GtkCheckMenuItem* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->menuViewColourbackgrounds;
		_tmp2_ = gtk_check_menu_item_get_active (_tmp1_);
		_tmp3_ = _tmp2_;
		self->priv->colourBackgrounds = _tmp3_;
	}
}


static void designer_window_fit_design (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->designer;
		_tmp3_ = designer_get_hasComponent (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			GtkAllocation areaAllocation = {0};
			GtkEventBox* _tmp5_ = NULL;
			GtkAllocation _tmp6_ = {0};
			gint width = 0;
			GtkAllocation _tmp7_ = {0};
			gint _tmp8_ = 0;
			gint height = 0;
			GtkAllocation _tmp9_ = {0};
			gint _tmp10_ = 0;
			gint rightBound = 0;
			gint downBound = 0;
			gint leftBound = 0;
			gint upBound = 0;
			gint boundWidth = 0;
			gint boundHeight = 0;
			gfloat altZoom = 0.0F;
			Designer* _tmp11_ = NULL;
			CustomComponentDef* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gfloat _tmp38_ = 0.0F;
			gfloat _tmp39_ = 0.0F;
			_tmp5_ = self->priv->controller;
			gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
			areaAllocation = _tmp6_;
			_tmp7_ = areaAllocation;
			_tmp8_ = _tmp7_.width;
			width = _tmp8_;
			_tmp9_ = areaAllocation;
			_tmp10_ = _tmp9_.height;
			height = _tmp10_;
			_tmp11_ = self->priv->designer;
			_tmp12_ = _tmp11_->customComponentDef;
			custom_component_def_get_design_bounds (_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
			rightBound = _tmp13_;
			downBound = _tmp14_;
			leftBound = _tmp15_;
			upBound = _tmp16_;
			_tmp18_ = rightBound;
			_tmp19_ = leftBound;
			if (_tmp18_ == _tmp19_) {
				_tmp17_ = TRUE;
			} else {
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				_tmp20_ = downBound;
				_tmp21_ = upBound;
				_tmp17_ = _tmp20_ == _tmp21_;
			}
			if (_tmp17_) {
				return;
			}
			_tmp22_ = rightBound;
			rightBound = _tmp22_ + 10;
			_tmp23_ = downBound;
			downBound = _tmp23_ + 10;
			_tmp24_ = leftBound;
			leftBound = _tmp24_ - 10;
			_tmp25_ = upBound;
			upBound = _tmp25_ - 10;
			_tmp26_ = rightBound;
			_tmp27_ = leftBound;
			self->priv->xView = (_tmp26_ + _tmp27_) / 2;
			_tmp28_ = downBound;
			_tmp29_ = upBound;
			self->priv->yView = (_tmp28_ + _tmp29_) / 2;
			_tmp30_ = rightBound;
			_tmp31_ = leftBound;
			boundWidth = _tmp30_ - _tmp31_;
			_tmp32_ = downBound;
			_tmp33_ = upBound;
			boundHeight = _tmp32_ - _tmp33_;
			_tmp34_ = width;
			_tmp35_ = boundWidth;
			self->zoom = ((gfloat) _tmp34_) / ((gfloat) _tmp35_);
			_tmp36_ = height;
			_tmp37_ = boundHeight;
			altZoom = ((gfloat) _tmp36_) / ((gfloat) _tmp37_);
			_tmp38_ = altZoom;
			_tmp39_ = self->zoom;
			if (_tmp38_ < _tmp39_) {
				gfloat _tmp40_ = 0.0F;
				_tmp40_ = altZoom;
				self->zoom = _tmp40_;
			}
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = NULL;
			designer_window_render_design (self, NULL);
		}
	}
}


/**
 * Handles user request to open the Customiser.
 */
static void designer_window_customise_component (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		_tmp2_ = self->priv->designer;
		designer_customise_component (_tmp2_);
	}
}


static void designer_window_configure_project (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Project* _tmp2_ = NULL;
		Project* _tmp3_ = NULL;
		_tmp2_ = self->priv->project;
		project_configure (_tmp2_);
		_tmp3_ = self->priv->project;
		project_update_titles (_tmp3_);
	}
}


static void designer_window_display_statistics (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		CircuitInformation* circuitInformation = NULL;
		Project* _tmp2_ = NULL;
		CircuitInformation* _tmp3_ = NULL;
		CircuitInformation* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp2_ = self->priv->project;
		_tmp3_ = circuit_information_new (_tmp2_);
		circuitInformation = _tmp3_;
		_tmp4_ = circuitInformation;
		_tmp5_ = circuit_information_get_summary (_tmp4_);
		_tmp6_ = _tmp5_;
		if (g_strcmp0 (_tmp6_, "") != 0) {
			CircuitInformation* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp7_ = circuitInformation;
			_tmp8_ = circuit_information_get_summary (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat ("Statistics:\n\n", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			basic_dialog_information ((GtkWindow*) self, _tmp11_);
			_g_free0 (_tmp11_);
		}
		_circuit_information_unref0 (circuitInformation);
	}
}


/**
 * Handles mouse button down in the work area. Records mouse
 * (drag) starting point.
 */
static gboolean designer_window_mouse_down (DesignerWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->mouseIsDown = TRUE;
	_tmp0_ = event;
	_tmp1_ = _tmp0_->x;
	self->priv->xMouseStart = (gint) _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->y;
	self->priv->yMouseStart = (gint) _tmp3_;
	result = FALSE;
	return result;
}


static gboolean designer_window_mouse_move (DesignerWindow* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkAllocation areaAllocation = {0};
	GtkEventBox* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	gint width = 0;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint height = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint xCentre = 0;
	gint _tmp7_ = 0;
	gint yCentre = 0;
	gint _tmp8_ = 0;
	gint xStart = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint yStart = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint xEnd = 0;
	GdkEventMotion* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	gint yEnd = 0;
	GdkEventMotion* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	gint _tmp18_ = 0;
	gint yDiff = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint xBoardStart = 0;
	gint _tmp21_ = 0;
	gfloat _tmp22_ = 0.0F;
	gint _tmp23_ = 0;
	gint yBoardStart = 0;
	gint _tmp24_ = 0;
	gfloat _tmp25_ = 0.0F;
	gint _tmp26_ = 0;
	gint xBoardEnd = 0;
	gint _tmp27_ = 0;
	gfloat _tmp28_ = 0.0F;
	gint _tmp29_ = 0;
	gint yBoardEnd = 0;
	gint _tmp30_ = 0;
	gfloat _tmp31_ = 0.0F;
	gint _tmp32_ = 0;
	gint xBoardDiff = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint yBoardDiff = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint yDiffAbs = 0;
	gfloat _tmp41_ = 0.0F;
	GdkEventMotion* _tmp42_ = NULL;
	gdouble _tmp43_ = 0.0;
	gfloat _tmp44_ = 0.0F;
	gfloat _tmp45_ = 0.0F;
	GdkEventMotion* _tmp46_ = NULL;
	gdouble _tmp47_ = 0.0;
	gfloat _tmp48_ = 0.0F;
	GdkEventMotion* _tmp49_ = NULL;
	gdouble _tmp50_ = 0.0;
	GdkEventMotion* _tmp51_ = NULL;
	gdouble _tmp52_ = 0.0;
	gfloat _tmp53_ = 0.0F;
	gfloat _tmp59_ = 0.0F;
	DesignerWindowMouseMode _tmp65_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_events_pending ();
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->controller;
	gtk_widget_get_allocation ((GtkWidget*) _tmp1_, &_tmp2_);
	areaAllocation = _tmp2_;
	_tmp3_ = areaAllocation;
	_tmp4_ = _tmp3_.width;
	width = _tmp4_;
	_tmp5_ = areaAllocation;
	_tmp6_ = _tmp5_.height;
	height = _tmp6_;
	_tmp7_ = width;
	xCentre = _tmp7_ / 2;
	_tmp8_ = height;
	yCentre = _tmp8_ / 2;
	_tmp9_ = self->priv->xMouseStart;
	_tmp10_ = xCentre;
	xStart = _tmp9_ - _tmp10_;
	_tmp11_ = self->priv->yMouseStart;
	_tmp12_ = yCentre;
	yStart = _tmp11_ - _tmp12_;
	_tmp13_ = event;
	_tmp14_ = _tmp13_->x;
	_tmp15_ = xCentre;
	xEnd = ((gint) _tmp14_) - _tmp15_;
	_tmp16_ = event;
	_tmp17_ = _tmp16_->y;
	_tmp18_ = yCentre;
	yEnd = ((gint) _tmp17_) - _tmp18_;
	_tmp19_ = yEnd;
	_tmp20_ = yStart;
	yDiff = _tmp19_ - _tmp20_;
	_tmp21_ = xStart;
	_tmp22_ = self->zoom;
	_tmp23_ = self->priv->xView;
	xBoardStart = (gint) ((((gfloat) _tmp21_) / _tmp22_) + ((gfloat) _tmp23_));
	_tmp24_ = yStart;
	_tmp25_ = self->zoom;
	_tmp26_ = self->priv->yView;
	yBoardStart = (gint) ((((gfloat) _tmp24_) / _tmp25_) + ((gfloat) _tmp26_));
	_tmp27_ = xEnd;
	_tmp28_ = self->zoom;
	_tmp29_ = self->priv->xView;
	xBoardEnd = (gint) ((((gfloat) _tmp27_) / _tmp28_) + ((gfloat) _tmp29_));
	_tmp30_ = yEnd;
	_tmp31_ = self->zoom;
	_tmp32_ = self->priv->yView;
	yBoardEnd = (gint) ((((gfloat) _tmp30_) / _tmp31_) + ((gfloat) _tmp32_));
	_tmp33_ = xBoardEnd;
	_tmp34_ = xBoardStart;
	xBoardDiff = _tmp33_ - _tmp34_;
	_tmp35_ = yBoardEnd;
	_tmp36_ = yBoardStart;
	yBoardDiff = _tmp35_ - _tmp36_;
	_tmp38_ = yDiff;
	if (_tmp38_ > 0) {
		gint _tmp39_ = 0;
		_tmp39_ = yDiff;
		_tmp37_ = _tmp39_;
	} else {
		gint _tmp40_ = 0;
		_tmp40_ = yDiff;
		_tmp37_ = -_tmp40_;
	}
	yDiffAbs = _tmp37_;
	_tmp41_ = self->priv->xMouseTravel;
	_tmp42_ = event;
	_tmp43_ = _tmp42_->x;
	_tmp44_ = self->priv->xMouseTravelStart;
	self->priv->xMouseTravel = _tmp41_ + (((gfloat) _tmp43_) - _tmp44_);
	_tmp45_ = self->priv->yMouseTravel;
	_tmp46_ = event;
	_tmp47_ = _tmp46_->y;
	_tmp48_ = self->priv->yMouseTravelStart;
	self->priv->yMouseTravel = _tmp45_ + (((gfloat) _tmp47_) - _tmp48_);
	_tmp49_ = event;
	_tmp50_ = _tmp49_->x;
	self->priv->xMouseTravelStart = (gfloat) _tmp50_;
	_tmp51_ = event;
	_tmp52_ = _tmp51_->y;
	self->priv->yMouseTravelStart = (gfloat) _tmp52_;
	_tmp53_ = self->priv->xMouseTravel;
	if (_tmp53_ < ((gfloat) (-40))) {
		gfloat _tmp54_ = 0.0F;
		gfloat _tmp55_ = 0.0F;
		_tmp54_ = self->priv->yMouseTravel;
		_tmp55_ = self->priv->xMouseTravel;
		self->priv->yMouseTravel = _tmp54_ * ((-40) / _tmp55_);
		self->priv->xMouseTravel = (gfloat) (-40);
	} else {
		gfloat _tmp56_ = 0.0F;
		_tmp56_ = self->priv->xMouseTravel;
		if (_tmp56_ > ((gfloat) 40)) {
			gfloat _tmp57_ = 0.0F;
			gfloat _tmp58_ = 0.0F;
			_tmp57_ = self->priv->yMouseTravel;
			_tmp58_ = self->priv->xMouseTravel;
			self->priv->yMouseTravel = _tmp57_ * (40 / _tmp58_);
			self->priv->xMouseTravel = (gfloat) 40;
		}
	}
	_tmp59_ = self->priv->yMouseTravel;
	if (_tmp59_ < ((gfloat) (-40))) {
		gfloat _tmp60_ = 0.0F;
		gfloat _tmp61_ = 0.0F;
		_tmp60_ = self->priv->xMouseTravel;
		_tmp61_ = self->priv->yMouseTravel;
		self->priv->xMouseTravel = _tmp60_ * ((-40) / _tmp61_);
		self->priv->yMouseTravel = (gfloat) (-40);
	} else {
		gfloat _tmp62_ = 0.0F;
		_tmp62_ = self->priv->yMouseTravel;
		if (_tmp62_ > ((gfloat) 40)) {
			gfloat _tmp63_ = 0.0F;
			gfloat _tmp64_ = 0.0F;
			_tmp63_ = self->priv->xMouseTravel;
			_tmp64_ = self->priv->yMouseTravel;
			self->priv->xMouseTravel = _tmp63_ * (40 / _tmp64_);
			self->priv->yMouseTravel = (gfloat) 40;
		}
	}
	_tmp65_ = self->priv->mouseMode;
	switch (_tmp65_) {
		case DESIGNER_WINDOW_MOUSE_MODE_SCROLL:
		{
			gboolean _tmp66_ = FALSE;
			gboolean _tmp67_ = FALSE;
			_tmp67_ = self->priv->mouseIsDown;
			if (_tmp67_) {
				gboolean _tmp68_ = FALSE;
				_tmp68_ = self->liveScrollUpdate;
				_tmp66_ = _tmp68_;
			} else {
				_tmp66_ = FALSE;
			}
			if (_tmp66_) {
				gint xViewOld = 0;
				gint _tmp69_ = 0;
				gint yViewOld = 0;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				_tmp69_ = self->priv->xView;
				xViewOld = _tmp69_;
				_tmp70_ = self->priv->yView;
				yViewOld = _tmp70_;
				_tmp71_ = self->priv->xView;
				_tmp72_ = xBoardDiff;
				self->priv->xView = _tmp71_ - _tmp72_;
				_tmp73_ = self->priv->yView;
				_tmp74_ = yBoardDiff;
				self->priv->yView = _tmp73_ - _tmp74_;
				_cairo_surface_destroy0 (self->priv->gridCache);
				self->priv->gridCache = NULL;
				designer_window_render_design (self, NULL);
				_tmp75_ = xViewOld;
				self->priv->xView = _tmp75_;
				_tmp76_ = yViewOld;
				self->priv->yView = _tmp76_;
				_cairo_surface_destroy0 (self->priv->gridCache);
				self->priv->gridCache = NULL;
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_ZOOM:
		{
			gboolean _tmp77_ = FALSE;
			gboolean _tmp78_ = FALSE;
			_tmp78_ = self->priv->mouseIsDown;
			if (_tmp78_) {
				gboolean _tmp79_ = FALSE;
				_tmp79_ = self->liveScrollUpdate;
				_tmp77_ = _tmp79_;
			} else {
				_tmp77_ = FALSE;
			}
			if (_tmp77_) {
				gfloat zoomOld = 0.0F;
				gfloat _tmp80_ = 0.0F;
				gint _tmp81_ = 0;
				gfloat _tmp88_ = 0.0F;
				_tmp80_ = self->zoom;
				zoomOld = _tmp80_;
				_tmp81_ = yDiff;
				if (_tmp81_ > 0) {
					gfloat _tmp82_ = 0.0F;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					_tmp82_ = self->zoom;
					_tmp83_ = yDiffAbs;
					_tmp84_ = height;
					self->zoom = _tmp82_ * (1.0f + (((gfloat) _tmp83_) / ((gfloat) _tmp84_)));
				} else {
					gfloat _tmp85_ = 0.0F;
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					_tmp85_ = self->zoom;
					_tmp86_ = yDiffAbs;
					_tmp87_ = height;
					self->zoom = _tmp85_ / (1.0f + (((gfloat) _tmp86_) / ((gfloat) _tmp87_)));
				}
				_cairo_surface_destroy0 (self->priv->gridCache);
				self->priv->gridCache = NULL;
				designer_window_render_design (self, NULL);
				_tmp88_ = zoomOld;
				self->zoom = _tmp88_;
				_cairo_surface_destroy0 (self->priv->gridCache);
				self->priv->gridCache = NULL;
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_INSERT:
		{
			gboolean _tmp89_ = FALSE;
			gboolean _tmp90_ = FALSE;
			_tmp90_ = self->priv->mouseIsDown;
			if (!_tmp90_) {
				gboolean _tmp91_ = FALSE;
				_tmp91_ = self->shadowComponent;
				_tmp89_ = _tmp91_;
			} else {
				_tmp89_ = FALSE;
			}
			if (_tmp89_) {
				Direction direction = 0;
				gfloat _tmp92_ = 0.0F;
				gfloat _tmp93_ = 0.0F;
				gfloat xMouseTravelAbs = 0.0F;
				gfloat _tmp96_ = 0.0F;
				gfloat _tmp97_ = 0.0F;
				gfloat yMouseTravelAbs = 0.0F;
				gfloat _tmp100_ = 0.0F;
				gfloat _tmp101_ = 0.0F;
				Designer* _tmp106_ = NULL;
				ComponentInst* _tmp107_ = NULL;
				gint _tmp108_ = 0;
				Designer* _tmp109_ = NULL;
				ComponentInst* _tmp110_ = NULL;
				gint _tmp111_ = 0;
				Designer* _tmp112_ = NULL;
				ComponentInst* _tmp113_ = NULL;
				Direction _tmp114_ = 0;
				_tmp93_ = self->priv->xMouseTravel;
				if (_tmp93_ > ((gfloat) 0)) {
					gfloat _tmp94_ = 0.0F;
					_tmp94_ = self->priv->xMouseTravel;
					_tmp92_ = _tmp94_;
				} else {
					gfloat _tmp95_ = 0.0F;
					_tmp95_ = self->priv->xMouseTravel;
					_tmp92_ = -_tmp95_;
				}
				xMouseTravelAbs = _tmp92_;
				_tmp97_ = self->priv->yMouseTravel;
				if (_tmp97_ > ((gfloat) 0)) {
					gfloat _tmp98_ = 0.0F;
					_tmp98_ = self->priv->yMouseTravel;
					_tmp96_ = _tmp98_;
				} else {
					gfloat _tmp99_ = 0.0F;
					_tmp99_ = self->priv->yMouseTravel;
					_tmp96_ = -_tmp99_;
				}
				yMouseTravelAbs = _tmp96_;
				_tmp100_ = xMouseTravelAbs;
				_tmp101_ = yMouseTravelAbs;
				if (_tmp100_ > _tmp101_) {
					gfloat _tmp102_ = 0.0F;
					_tmp102_ = self->priv->xMouseTravel;
					if (_tmp102_ > ((gfloat) 0)) {
						direction = DIRECTION_RIGHT;
					} else {
						direction = DIRECTION_LEFT;
					}
				} else {
					gfloat _tmp103_ = 0.0F;
					gfloat _tmp104_ = 0.0F;
					_tmp103_ = xMouseTravelAbs;
					_tmp104_ = yMouseTravelAbs;
					if (_tmp103_ < _tmp104_) {
						gfloat _tmp105_ = 0.0F;
						_tmp105_ = self->priv->yMouseTravel;
						if (_tmp105_ > ((gfloat) 0)) {
							direction = DIRECTION_DOWN;
						} else {
							direction = DIRECTION_UP;
						}
					} else {
						direction = DIRECTION_RIGHT;
					}
				}
				_tmp106_ = self->priv->designer;
				_tmp107_ = _tmp106_->shadowComponentInst;
				_tmp108_ = xBoardEnd;
				_tmp107_->xPosition = _tmp108_;
				_tmp109_ = self->priv->designer;
				_tmp110_ = _tmp109_->shadowComponentInst;
				_tmp111_ = yBoardEnd;
				_tmp110_->yPosition = _tmp111_;
				_tmp112_ = self->priv->designer;
				_tmp113_ = _tmp112_->shadowComponentInst;
				_tmp114_ = direction;
				_tmp113_->direction = _tmp114_;
				designer_window_render_overlay (self);
			}
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


/**
 * Handles mouse button up in the work area. Performs an action
 * which is determined by //mouseMode//.
 */
static gboolean designer_window_mouse_up (DesignerWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	Project* _tmp0_ = NULL;
	GtkAllocation areaAllocation = {0};
	GtkEventBox* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint width = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint height = 0;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint xCentre = 0;
	gint _tmp10_ = 0;
	gint yCentre = 0;
	gint _tmp11_ = 0;
	gint xStart = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint yStart = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint xEnd = 0;
	GdkEventButton* _tmp16_ = NULL;
	gdouble _tmp17_ = 0.0;
	gint _tmp18_ = 0;
	gint yEnd = 0;
	GdkEventButton* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	gint _tmp21_ = 0;
	gint xDiff = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint yDiff = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint xBoardStart = 0;
	gint _tmp26_ = 0;
	gfloat _tmp27_ = 0.0F;
	gint _tmp28_ = 0;
	gint yBoardStart = 0;
	gint _tmp29_ = 0;
	gfloat _tmp30_ = 0.0F;
	gint _tmp31_ = 0;
	gint xBoardEnd = 0;
	gint _tmp32_ = 0;
	gfloat _tmp33_ = 0.0F;
	gint _tmp34_ = 0;
	gint yBoardEnd = 0;
	gint _tmp35_ = 0;
	gfloat _tmp36_ = 0.0F;
	gint _tmp37_ = 0;
	gboolean snapGridStart = FALSE;
	gboolean snapGridEnd = FALSE;
	gint halfGridSize = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	DesignerWindowMouseMode _tmp41_ = 0;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp67_ = FALSE;
	FILE* _tmp84_ = NULL;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	gint _tmp87_ = 0;
	gint _tmp88_ = 0;
	gint xBoardDiff = 0;
	gint _tmp89_ = 0;
	gint _tmp90_ = 0;
	gint yBoardDiff = 0;
	gint _tmp91_ = 0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	gint _tmp94_ = 0;
	gint xDiffAbs = 0;
	gint _tmp97_ = 0;
	gint _tmp98_ = 0;
	gint yDiffAbs = 0;
	DesignerWindowMouseMode _tmp101_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->mouseIsDown = FALSE;
	_tmp0_ = self->priv->project;
	if (_tmp0_ != NULL) {
		Project* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->project;
		_tmp2_ = _tmp1_->running;
		if (_tmp2_) {
			FILE* _tmp3_ = NULL;
			_tmp3_ = stdout;
			fprintf (_tmp3_, "Cannot edit running circuit!\n");
			result = FALSE;
			return result;
		}
	}
	_tmp4_ = self->priv->controller;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	areaAllocation = _tmp5_;
	_tmp6_ = areaAllocation;
	_tmp7_ = _tmp6_.width;
	width = _tmp7_;
	_tmp8_ = areaAllocation;
	_tmp9_ = _tmp8_.height;
	height = _tmp9_;
	_tmp10_ = width;
	xCentre = _tmp10_ / 2;
	_tmp11_ = height;
	yCentre = _tmp11_ / 2;
	_tmp12_ = self->priv->xMouseStart;
	_tmp13_ = xCentre;
	xStart = _tmp12_ - _tmp13_;
	_tmp14_ = self->priv->yMouseStart;
	_tmp15_ = yCentre;
	yStart = _tmp14_ - _tmp15_;
	_tmp16_ = event;
	_tmp17_ = _tmp16_->x;
	_tmp18_ = xCentre;
	xEnd = ((gint) _tmp17_) - _tmp18_;
	_tmp19_ = event;
	_tmp20_ = _tmp19_->y;
	_tmp21_ = yCentre;
	yEnd = ((gint) _tmp20_) - _tmp21_;
	_tmp22_ = xEnd;
	_tmp23_ = xStart;
	xDiff = _tmp22_ - _tmp23_;
	_tmp24_ = yEnd;
	_tmp25_ = yStart;
	yDiff = _tmp24_ - _tmp25_;
	_tmp26_ = xStart;
	_tmp27_ = self->zoom;
	_tmp28_ = self->priv->xView;
	xBoardStart = (gint) ((((gfloat) _tmp26_) / _tmp27_) + ((gfloat) _tmp28_));
	_tmp29_ = yStart;
	_tmp30_ = self->zoom;
	_tmp31_ = self->priv->yView;
	yBoardStart = (gint) ((((gfloat) _tmp29_) / _tmp30_) + ((gfloat) _tmp31_));
	_tmp32_ = xEnd;
	_tmp33_ = self->zoom;
	_tmp34_ = self->priv->xView;
	xBoardEnd = (gint) ((((gfloat) _tmp32_) / _tmp33_) + ((gfloat) _tmp34_));
	_tmp35_ = yEnd;
	_tmp36_ = self->zoom;
	_tmp37_ = self->priv->yView;
	yBoardEnd = (gint) ((((gfloat) _tmp35_) / _tmp36_) + ((gfloat) _tmp37_));
	snapGridStart = TRUE;
	snapGridEnd = TRUE;
	_tmp38_ = self->gridSize;
	halfGridSize = _tmp38_ / 2;
	_tmp41_ = self->priv->mouseMode;
	if (_tmp41_ == DESIGNER_WINDOW_MOUSE_MODE_WIRE) {
		_tmp40_ = TRUE;
	} else {
		DesignerWindowMouseMode _tmp42_ = 0;
		_tmp42_ = self->priv->mouseMode;
		_tmp40_ = _tmp42_ == DESIGNER_WINDOW_MOUSE_MODE_BIND;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		DesignerWindowMouseMode _tmp43_ = 0;
		_tmp43_ = self->priv->mouseMode;
		_tmp39_ = _tmp43_ == DESIGNER_WINDOW_MOUSE_MODE_INVERT;
	}
	if (_tmp39_) {
		Designer* _tmp44_ = NULL;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		Designer* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		_tmp44_ = self->priv->designer;
		_tmp45_ = self->gridSize;
		_tmp46_ = designer_snap_pin (_tmp44_, &xBoardStart, &yBoardStart, _tmp45_);
		snapGridStart = _tmp46_ == 1;
		_tmp47_ = self->priv->designer;
		_tmp48_ = self->gridSize;
		_tmp49_ = designer_snap_pin (_tmp47_, &xBoardEnd, &yBoardEnd, _tmp48_);
		snapGridEnd = _tmp49_ == 1;
	}
	_tmp50_ = snapGridStart;
	if (_tmp50_) {
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		_tmp52_ = xBoardStart;
		if (_tmp52_ > 0) {
			gint _tmp53_ = 0;
			_tmp53_ = halfGridSize;
			_tmp51_ = _tmp53_;
		} else {
			gint _tmp54_ = 0;
			_tmp54_ = halfGridSize;
			_tmp51_ = -_tmp54_;
		}
		_tmp55_ = xBoardStart;
		xBoardStart = _tmp55_ + _tmp51_;
		_tmp57_ = yBoardStart;
		if (_tmp57_ > 0) {
			gint _tmp58_ = 0;
			_tmp58_ = halfGridSize;
			_tmp56_ = _tmp58_;
		} else {
			gint _tmp59_ = 0;
			_tmp59_ = halfGridSize;
			_tmp56_ = -_tmp59_;
		}
		_tmp60_ = yBoardStart;
		yBoardStart = _tmp60_ + _tmp56_;
		_tmp61_ = xBoardStart;
		_tmp62_ = self->gridSize;
		_tmp63_ = self->gridSize;
		xBoardStart = (_tmp61_ / _tmp62_) * _tmp63_;
		_tmp64_ = yBoardStart;
		_tmp65_ = self->gridSize;
		_tmp66_ = self->gridSize;
		yBoardStart = (_tmp64_ / _tmp65_) * _tmp66_;
	}
	_tmp67_ = snapGridEnd;
	if (_tmp67_) {
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		_tmp69_ = xBoardEnd;
		if (_tmp69_ > 0) {
			gint _tmp70_ = 0;
			_tmp70_ = halfGridSize;
			_tmp68_ = _tmp70_;
		} else {
			gint _tmp71_ = 0;
			_tmp71_ = halfGridSize;
			_tmp68_ = -_tmp71_;
		}
		_tmp72_ = xBoardEnd;
		xBoardEnd = _tmp72_ + _tmp68_;
		_tmp74_ = yBoardEnd;
		if (_tmp74_ > 0) {
			gint _tmp75_ = 0;
			_tmp75_ = halfGridSize;
			_tmp73_ = _tmp75_;
		} else {
			gint _tmp76_ = 0;
			_tmp76_ = halfGridSize;
			_tmp73_ = -_tmp76_;
		}
		_tmp77_ = yBoardEnd;
		yBoardEnd = _tmp77_ + _tmp73_;
		_tmp78_ = xBoardEnd;
		_tmp79_ = self->gridSize;
		_tmp80_ = self->gridSize;
		xBoardEnd = (_tmp78_ / _tmp79_) * _tmp80_;
		_tmp81_ = yBoardEnd;
		_tmp82_ = self->gridSize;
		_tmp83_ = self->gridSize;
		yBoardEnd = (_tmp81_ / _tmp82_) * _tmp83_;
	}
	_tmp84_ = stdout;
	_tmp85_ = xBoardStart;
	_tmp86_ = yBoardStart;
	_tmp87_ = xBoardEnd;
	_tmp88_ = yBoardEnd;
	fprintf (_tmp84_, "Interact @ (%i, %i) - (%i, %i)\n", _tmp85_, _tmp86_, _tmp87_, _tmp88_);
	_tmp89_ = xBoardEnd;
	_tmp90_ = xBoardStart;
	xBoardDiff = _tmp89_ - _tmp90_;
	_tmp91_ = yBoardEnd;
	_tmp92_ = yBoardStart;
	yBoardDiff = _tmp91_ - _tmp92_;
	_tmp94_ = xDiff;
	if (_tmp94_ > 0) {
		gint _tmp95_ = 0;
		_tmp95_ = xDiff;
		_tmp93_ = _tmp95_;
	} else {
		gint _tmp96_ = 0;
		_tmp96_ = xDiff;
		_tmp93_ = -_tmp96_;
	}
	xDiffAbs = _tmp93_;
	_tmp98_ = yDiff;
	if (_tmp98_ > 0) {
		gint _tmp99_ = 0;
		_tmp99_ = yDiff;
		_tmp97_ = _tmp99_;
	} else {
		gint _tmp100_ = 0;
		_tmp100_ = yDiff;
		_tmp97_ = -_tmp100_;
	}
	yDiffAbs = _tmp97_;
	_tmp101_ = self->priv->mouseMode;
	switch (_tmp101_) {
		case DESIGNER_WINDOW_MOUSE_MODE_SCROLL:
		{
			gint _tmp102_ = 0;
			gint _tmp103_ = 0;
			gint _tmp104_ = 0;
			gint _tmp105_ = 0;
			_tmp102_ = self->priv->xView;
			_tmp103_ = xBoardDiff;
			self->priv->xView = _tmp102_ - _tmp103_;
			_tmp104_ = self->priv->yView;
			_tmp105_ = yBoardDiff;
			self->priv->yView = _tmp104_ - _tmp105_;
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = NULL;
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_ZOOM:
		{
			gint _tmp106_ = 0;
			_tmp106_ = yDiff;
			if (_tmp106_ > 0) {
				gfloat _tmp107_ = 0.0F;
				gint _tmp108_ = 0;
				gint _tmp109_ = 0;
				_tmp107_ = self->zoom;
				_tmp108_ = yDiffAbs;
				_tmp109_ = height;
				self->zoom = _tmp107_ * (1.0f + (((gfloat) _tmp108_) / ((gfloat) _tmp109_)));
			} else {
				gfloat _tmp110_ = 0.0F;
				gint _tmp111_ = 0;
				gint _tmp112_ = 0;
				_tmp110_ = self->zoom;
				_tmp111_ = yDiffAbs;
				_tmp112_ = height;
				self->zoom = _tmp110_ / (1.0f + (((gfloat) _tmp111_) / ((gfloat) _tmp112_)));
			}
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = NULL;
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_SELECT:
		{
			gboolean _tmp113_ = FALSE;
			gboolean _tmp114_ = FALSE;
			gboolean _tmp115_ = FALSE;
			_tmp114_ = designer_window_get_hasDesigner (self);
			_tmp115_ = _tmp114_;
			if (_tmp115_) {
				gboolean _tmp116_ = FALSE;
				gboolean _tmp117_ = FALSE;
				_tmp116_ = designer_window_get_hasProject (self);
				_tmp117_ = _tmp116_;
				_tmp113_ = _tmp117_;
			} else {
				_tmp113_ = FALSE;
			}
			if (_tmp113_) {
				Designer* _tmp118_ = NULL;
				gint _tmp119_ = 0;
				gint _tmp120_ = 0;
				Designer* _tmp121_ = NULL;
				gint _tmp122_ = 0;
				gint _tmp123_ = 0;
				Designer* _tmp124_ = NULL;
				gint _tmp125_ = 0;
				gint _tmp126_ = 0;
				_tmp118_ = self->priv->designer;
				_tmp119_ = xBoardEnd;
				_tmp120_ = yBoardEnd;
				designer_select_components (_tmp118_, _tmp119_, _tmp120_, FALSE);
				_tmp121_ = self->priv->designer;
				_tmp122_ = xBoardEnd;
				_tmp123_ = yBoardEnd;
				designer_select_wires (_tmp121_, _tmp122_, _tmp123_, FALSE, TRUE);
				_tmp124_ = self->priv->designer;
				_tmp125_ = xBoardEnd;
				_tmp126_ = yBoardEnd;
				designer_select_annotations (_tmp124_, _tmp125_, _tmp126_, FALSE);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_MOVE:
		{
			gboolean _tmp127_ = FALSE;
			gboolean _tmp128_ = FALSE;
			gboolean _tmp129_ = FALSE;
			_tmp128_ = designer_window_get_hasDesigner (self);
			_tmp129_ = _tmp128_;
			if (_tmp129_) {
				gboolean _tmp130_ = FALSE;
				gboolean _tmp131_ = FALSE;
				_tmp130_ = designer_window_get_hasProject (self);
				_tmp131_ = _tmp130_;
				_tmp127_ = _tmp131_;
			} else {
				_tmp127_ = FALSE;
			}
			if (_tmp127_) {
				Designer* _tmp132_ = NULL;
				gint _tmp133_ = 0;
				gint _tmp134_ = 0;
				Designer* _tmp135_ = NULL;
				gint _tmp136_ = 0;
				gint _tmp137_ = 0;
				Designer* _tmp138_ = NULL;
				gint _tmp139_ = 0;
				gint _tmp140_ = 0;
				Designer* _tmp141_ = NULL;
				gint _tmp142_ = 0;
				gint _tmp143_ = 0;
				gboolean _tmp144_ = FALSE;
				Designer* _tmp145_ = NULL;
				gint _tmp146_ = 0;
				gint _tmp147_ = 0;
				gboolean _tmp148_ = FALSE;
				Designer* _tmp149_ = NULL;
				gint _tmp150_ = 0;
				gint _tmp151_ = 0;
				_tmp132_ = self->priv->designer;
				_tmp133_ = xBoardStart;
				_tmp134_ = yBoardStart;
				designer_select_components (_tmp132_, _tmp133_, _tmp134_, FALSE);
				_tmp135_ = self->priv->designer;
				_tmp136_ = xBoardStart;
				_tmp137_ = yBoardStart;
				designer_select_wires (_tmp135_, _tmp136_, _tmp137_, FALSE, TRUE);
				_tmp138_ = self->priv->designer;
				_tmp139_ = xBoardStart;
				_tmp140_ = yBoardStart;
				designer_select_annotations (_tmp138_, _tmp139_, _tmp140_, FALSE);
				_tmp141_ = self->priv->designer;
				_tmp142_ = xBoardDiff;
				_tmp143_ = yBoardDiff;
				_tmp144_ = self->priv->autoBind;
				designer_move_components (_tmp141_, _tmp142_, _tmp143_, FALSE, _tmp144_);
				_tmp145_ = self->priv->designer;
				_tmp146_ = xBoardDiff;
				_tmp147_ = yBoardDiff;
				_tmp148_ = self->priv->autoBind;
				designer_move_wires (_tmp145_, _tmp146_, _tmp147_, FALSE, _tmp148_);
				_tmp149_ = self->priv->designer;
				_tmp150_ = xBoardDiff;
				_tmp151_ = yBoardDiff;
				designer_move_annotations (_tmp149_, _tmp150_, _tmp151_, FALSE);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_DELETE:
		{
			gboolean _tmp152_ = FALSE;
			gboolean _tmp153_ = FALSE;
			gboolean _tmp154_ = FALSE;
			_tmp153_ = designer_window_get_hasDesigner (self);
			_tmp154_ = _tmp153_;
			if (_tmp154_) {
				gboolean _tmp155_ = FALSE;
				gboolean _tmp156_ = FALSE;
				_tmp155_ = designer_window_get_hasProject (self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				Designer* _tmp157_ = NULL;
				gint _tmp158_ = 0;
				gint _tmp159_ = 0;
				Designer* _tmp160_ = NULL;
				gint _tmp161_ = 0;
				gint _tmp162_ = 0;
				Designer* _tmp163_ = NULL;
				gint _tmp164_ = 0;
				gint _tmp165_ = 0;
				Designer* _tmp166_ = NULL;
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
				_tmp157_ = self->priv->designer;
				_tmp158_ = xBoardEnd;
				_tmp159_ = yBoardEnd;
				designer_delete_components (_tmp157_, _tmp158_, _tmp159_);
				_tmp160_ = self->priv->designer;
				_tmp161_ = xBoardEnd;
				_tmp162_ = yBoardEnd;
				designer_delete_wires (_tmp160_, _tmp161_, _tmp162_);
				_tmp163_ = self->priv->designer;
				_tmp164_ = xBoardEnd;
				_tmp165_ = yBoardEnd;
				designer_delete_tags (_tmp163_, _tmp164_, _tmp165_);
				_tmp166_ = self->priv->designer;
				_tmp167_ = xBoardEnd;
				_tmp168_ = yBoardEnd;
				designer_delete_annotations (_tmp166_, _tmp167_, _tmp168_);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_ADJUST:
		{
			gboolean _tmp169_ = FALSE;
			gboolean _tmp170_ = FALSE;
			gboolean _tmp171_ = FALSE;
			_tmp170_ = designer_window_get_hasDesigner (self);
			_tmp171_ = _tmp170_;
			if (_tmp171_) {
				gboolean _tmp172_ = FALSE;
				gboolean _tmp173_ = FALSE;
				_tmp172_ = designer_window_get_hasProject (self);
				_tmp173_ = _tmp172_;
				_tmp169_ = _tmp173_;
			} else {
				_tmp169_ = FALSE;
			}
			if (_tmp169_) {
				Designer* _tmp174_ = NULL;
				gint _tmp175_ = 0;
				gint _tmp176_ = 0;
				gboolean _tmp177_ = FALSE;
				Designer* _tmp178_ = NULL;
				gint _tmp179_ = 0;
				gint _tmp180_ = 0;
				Designer* _tmp181_ = NULL;
				gint _tmp182_ = 0;
				gint _tmp183_ = 0;
				_tmp174_ = self->priv->designer;
				_tmp175_ = xBoardEnd;
				_tmp176_ = yBoardEnd;
				_tmp177_ = self->priv->autoBind;
				designer_adjust_components (_tmp174_, _tmp175_, _tmp176_, _tmp177_);
				_tmp178_ = self->priv->designer;
				_tmp179_ = xBoardEnd;
				_tmp180_ = yBoardEnd;
				designer_adjust_annotations (_tmp178_, _tmp179_, _tmp180_);
				_tmp181_ = self->priv->designer;
				_tmp182_ = xBoardEnd;
				_tmp183_ = yBoardEnd;
				designer_adjust_wires (_tmp181_, _tmp182_, _tmp183_);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_ANNOTATE:
		{
			gboolean _tmp184_ = FALSE;
			gboolean _tmp185_ = FALSE;
			gboolean _tmp186_ = FALSE;
			_tmp185_ = designer_window_get_hasDesigner (self);
			_tmp186_ = _tmp185_;
			if (_tmp186_) {
				gboolean _tmp187_ = FALSE;
				gboolean _tmp188_ = FALSE;
				_tmp187_ = designer_window_get_hasProject (self);
				_tmp188_ = _tmp187_;
				_tmp184_ = _tmp188_;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				Designer* _tmp189_ = NULL;
				gint _tmp190_ = 0;
				gint _tmp191_ = 0;
				Designer* _tmp192_ = NULL;
				gint _tmp193_ = 0;
				gint _tmp194_ = 0;
				_tmp189_ = self->priv->designer;
				_tmp190_ = xBoardEnd;
				_tmp191_ = yBoardEnd;
				designer_add_annotation (_tmp189_, _tmp190_, _tmp191_, "Enter Text Here", (gdouble) 12);
				_tmp192_ = self->priv->designer;
				_tmp193_ = xBoardEnd;
				_tmp194_ = yBoardEnd;
				designer_adjust_annotations (_tmp192_, _tmp193_, _tmp194_);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_WIRE:
		{
			gboolean _tmp195_ = FALSE;
			gboolean _tmp196_ = FALSE;
			gboolean _tmp197_ = FALSE;
			_tmp196_ = designer_window_get_hasDesigner (self);
			_tmp197_ = _tmp196_;
			if (_tmp197_) {
				gboolean _tmp198_ = FALSE;
				gboolean _tmp199_ = FALSE;
				_tmp198_ = designer_window_get_hasProject (self);
				_tmp199_ = _tmp198_;
				_tmp195_ = _tmp199_;
			} else {
				_tmp195_ = FALSE;
			}
			if (_tmp195_) {
				Designer* _tmp200_ = NULL;
				gint _tmp201_ = 0;
				gint _tmp202_ = 0;
				gfloat _tmp203_ = 0.0F;
				gboolean _tmp204_ = FALSE;
				_tmp200_ = self->priv->designer;
				_tmp201_ = xBoardEnd;
				_tmp202_ = yBoardEnd;
				_tmp203_ = self->priv->diagonalThreshold;
				_tmp204_ = self->priv->autoBind;
				designer_draw_wire (_tmp200_, _tmp201_, _tmp202_, _tmp203_, _tmp204_);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_BIND:
		{
			gboolean _tmp205_ = FALSE;
			gboolean _tmp206_ = FALSE;
			gboolean _tmp207_ = FALSE;
			_tmp206_ = designer_window_get_hasDesigner (self);
			_tmp207_ = _tmp206_;
			if (_tmp207_) {
				gboolean _tmp208_ = FALSE;
				gboolean _tmp209_ = FALSE;
				_tmp208_ = designer_window_get_hasProject (self);
				_tmp209_ = _tmp208_;
				_tmp205_ = _tmp209_;
			} else {
				_tmp205_ = FALSE;
			}
			if (_tmp205_) {
				gint boundWires = 0;
				gint connectedComponents = 0;
				Designer* _tmp210_ = NULL;
				gint _tmp211_ = 0;
				gint _tmp212_ = 0;
				gint _tmp213_ = 0;
				Designer* _tmp214_ = NULL;
				gint _tmp215_ = 0;
				gint _tmp216_ = 0;
				gint _tmp217_ = 0;
				gboolean _tmp218_ = FALSE;
				gint _tmp219_ = 0;
				boundWires = 0;
				connectedComponents = 0;
				_tmp210_ = self->priv->designer;
				_tmp211_ = xBoardEnd;
				_tmp212_ = yBoardEnd;
				_tmp213_ = designer_bind_wire (_tmp210_, _tmp211_, _tmp212_);
				boundWires = _tmp213_;
				_tmp214_ = self->priv->designer;
				_tmp215_ = xBoardEnd;
				_tmp216_ = yBoardEnd;
				_tmp217_ = designer_connect_component (_tmp214_, _tmp215_, _tmp216_);
				connectedComponents = _tmp217_;
				_tmp219_ = boundWires;
				if (_tmp219_ == 1) {
					gint _tmp220_ = 0;
					_tmp220_ = connectedComponents;
					_tmp218_ = _tmp220_ == 0;
				} else {
					_tmp218_ = FALSE;
				}
				if (_tmp218_) {
					Designer* _tmp221_ = NULL;
					gint _tmp222_ = 0;
					gint _tmp223_ = 0;
					Designer* _tmp224_ = NULL;
					gint _tmp225_ = 0;
					gint _tmp226_ = 0;
					_tmp221_ = self->priv->designer;
					_tmp222_ = xBoardEnd;
					_tmp223_ = yBoardEnd;
					designer_unbind_wire (_tmp221_, _tmp222_, _tmp223_);
					_tmp224_ = self->priv->designer;
					_tmp225_ = xBoardEnd;
					_tmp226_ = yBoardEnd;
					designer_disconnect_component (_tmp224_, _tmp225_, _tmp226_);
				}
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_TAG:
		{
			gboolean _tmp227_ = FALSE;
			gboolean _tmp228_ = FALSE;
			gboolean _tmp229_ = FALSE;
			_tmp228_ = designer_window_get_hasDesigner (self);
			_tmp229_ = _tmp228_;
			if (_tmp229_) {
				gboolean _tmp230_ = FALSE;
				gboolean _tmp231_ = FALSE;
				_tmp230_ = designer_window_get_hasProject (self);
				_tmp231_ = _tmp230_;
				_tmp227_ = _tmp231_;
			} else {
				_tmp227_ = FALSE;
			}
			if (_tmp227_) {
				Designer* _tmp232_ = NULL;
				gint _tmp233_ = 0;
				gint _tmp234_ = 0;
				gint _tmp235_ = 0;
				gint _tmp236_ = 0;
				_tmp232_ = self->priv->designer;
				_tmp233_ = xBoardStart;
				_tmp234_ = yBoardStart;
				_tmp235_ = xBoardEnd;
				_tmp236_ = yBoardEnd;
				designer_tag_wire (_tmp232_, _tmp233_, _tmp234_, _tmp235_, _tmp236_, FALSE);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_INVERT:
		{
			gboolean _tmp237_ = FALSE;
			gboolean _tmp238_ = FALSE;
			gboolean _tmp239_ = FALSE;
			_tmp238_ = designer_window_get_hasDesigner (self);
			_tmp239_ = _tmp238_;
			if (_tmp239_) {
				gboolean _tmp240_ = FALSE;
				gboolean _tmp241_ = FALSE;
				_tmp240_ = designer_window_get_hasProject (self);
				_tmp241_ = _tmp240_;
				_tmp237_ = _tmp241_;
			} else {
				_tmp237_ = FALSE;
			}
			if (_tmp237_) {
				Designer* _tmp242_ = NULL;
				gint _tmp243_ = 0;
				gint _tmp244_ = 0;
				_tmp242_ = self->priv->designer;
				_tmp243_ = xBoardEnd;
				_tmp244_ = yBoardEnd;
				designer_invert_pin (_tmp242_, _tmp243_, _tmp244_);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_INSERT:
		{
			gboolean _tmp245_ = FALSE;
			gboolean _tmp246_ = FALSE;
			gboolean _tmp247_ = FALSE;
			_tmp246_ = designer_window_get_hasDesigner (self);
			_tmp247_ = _tmp246_;
			if (_tmp247_) {
				gboolean _tmp248_ = FALSE;
				gboolean _tmp249_ = FALSE;
				_tmp248_ = designer_window_get_hasProject (self);
				_tmp249_ = _tmp248_;
				_tmp245_ = _tmp249_;
			} else {
				_tmp245_ = FALSE;
			}
			if (_tmp245_) {
				Direction direction = 0;
				gint _tmp250_ = 0;
				gint _tmp251_ = 0;
				Designer* _tmp263_ = NULL;
				gint _tmp264_ = 0;
				gint _tmp265_ = 0;
				Direction _tmp266_ = 0;
				gboolean _tmp267_ = FALSE;
				_tmp250_ = xDiffAbs;
				_tmp251_ = yDiffAbs;
				if (_tmp250_ > _tmp251_) {
					gint _tmp252_ = 0;
					_tmp252_ = xDiff;
					if (_tmp252_ > 0) {
						direction = DIRECTION_RIGHT;
					} else {
						direction = DIRECTION_LEFT;
					}
				} else {
					gint _tmp253_ = 0;
					gint _tmp254_ = 0;
					_tmp253_ = xDiffAbs;
					_tmp254_ = yDiffAbs;
					if (_tmp253_ < _tmp254_) {
						gint _tmp255_ = 0;
						_tmp255_ = yDiff;
						if (_tmp255_ > 0) {
							direction = DIRECTION_DOWN;
						} else {
							direction = DIRECTION_UP;
						}
					} else {
						gboolean _tmp256_ = FALSE;
						Designer* _tmp257_ = NULL;
						ComponentInst* _tmp258_ = NULL;
						_tmp257_ = self->priv->designer;
						_tmp258_ = _tmp257_->shadowComponentInst;
						if (_tmp258_ != NULL) {
							gboolean _tmp259_ = FALSE;
							_tmp259_ = self->shadowComponent;
							_tmp256_ = _tmp259_;
						} else {
							_tmp256_ = FALSE;
						}
						if (_tmp256_) {
							Designer* _tmp260_ = NULL;
							ComponentInst* _tmp261_ = NULL;
							Direction _tmp262_ = 0;
							_tmp260_ = self->priv->designer;
							_tmp261_ = _tmp260_->shadowComponentInst;
							_tmp262_ = _tmp261_->direction;
							direction = _tmp262_;
						} else {
							direction = DIRECTION_RIGHT;
						}
					}
				}
				_tmp263_ = self->priv->designer;
				_tmp264_ = xBoardStart;
				_tmp265_ = yBoardStart;
				_tmp266_ = direction;
				_tmp267_ = self->priv->autoBind;
				designer_add_componentInst (_tmp263_, _tmp264_, _tmp265_, _tmp266_, _tmp267_);
			}
			break;
		}
		case DESIGNER_WINDOW_MOUSE_MODE_ORIENTATE:
		{
			gboolean _tmp268_ = FALSE;
			gboolean _tmp269_ = FALSE;
			gboolean _tmp270_ = FALSE;
			_tmp269_ = designer_window_get_hasDesigner (self);
			_tmp270_ = _tmp269_;
			if (_tmp270_) {
				gboolean _tmp271_ = FALSE;
				gboolean _tmp272_ = FALSE;
				_tmp271_ = designer_window_get_hasProject (self);
				_tmp272_ = _tmp271_;
				_tmp268_ = _tmp272_;
			} else {
				_tmp268_ = FALSE;
			}
			if (_tmp268_) {
				Designer* _tmp273_ = NULL;
				gint _tmp274_ = 0;
				gint _tmp275_ = 0;
				gboolean _tmp276_ = FALSE;
				gint _tmp277_ = 0;
				_tmp273_ = self->priv->designer;
				_tmp274_ = xBoardStart;
				_tmp275_ = yBoardStart;
				designer_select_components (_tmp273_, _tmp274_, _tmp275_, FALSE);
				_tmp277_ = xDiff;
				if (_tmp277_ == 0) {
					gint _tmp278_ = 0;
					_tmp278_ = yDiff;
					_tmp276_ = _tmp278_ == 0;
				} else {
					_tmp276_ = FALSE;
				}
				if (_tmp276_) {
					Designer* _tmp279_ = NULL;
					gboolean _tmp280_ = FALSE;
					_tmp279_ = self->priv->designer;
					_tmp280_ = self->priv->autoBind;
					designer_flip_component (_tmp279_, _tmp280_);
				} else {
					Direction direction = 0;
					gint _tmp281_ = 0;
					gint _tmp282_ = 0;
					Designer* _tmp287_ = NULL;
					Direction _tmp288_ = 0;
					gboolean _tmp289_ = FALSE;
					_tmp281_ = xDiffAbs;
					_tmp282_ = yDiffAbs;
					if (_tmp281_ > _tmp282_) {
						gint _tmp283_ = 0;
						_tmp283_ = xDiff;
						if (_tmp283_ > 0) {
							direction = DIRECTION_RIGHT;
						} else {
							direction = DIRECTION_LEFT;
						}
					} else {
						gint _tmp284_ = 0;
						gint _tmp285_ = 0;
						_tmp284_ = xDiffAbs;
						_tmp285_ = yDiffAbs;
						if (_tmp284_ < _tmp285_) {
							gint _tmp286_ = 0;
							_tmp286_ = yDiff;
							if (_tmp286_ > 0) {
								direction = DIRECTION_DOWN;
							} else {
								direction = DIRECTION_UP;
							}
						} else {
							direction = DIRECTION_RIGHT;
						}
					}
					_tmp287_ = self->priv->designer;
					_tmp288_ = direction;
					_tmp289_ = self->priv->autoBind;
					designer_orientate_component (_tmp287_, _tmp288_, _tmp289_);
				}
			}
			break;
		}
		default:
		break;
	}
	designer_window_render_design (self, NULL);
	result = FALSE;
	return result;
}


/**
 * Updates the window title to display identification about the
 * component being viewed.
 */
static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void designer_window_update_title (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = designer_window_get_hasDesigner (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			Designer* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->designer;
			_tmp5_ = designer_get_hasComponent (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_tmp6_) {
				const gchar* _tmp7_ = NULL;
				Project* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				Designer* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				_tmp7_ = self->componentFileName;
				if (g_strcmp0 (_tmp7_, "") != 0) {
					gchar* shortFileName = NULL;
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					Designer* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp8_ = self->componentFileName;
					_tmp9_ = g_strdup (_tmp8_);
					shortFileName = _tmp9_;
					_tmp10_ = shortFileName;
					_tmp11_ = string_last_index_of (_tmp10_, G_DIR_SEPARATOR_S, 0);
					if (_tmp11_ != (-1)) {
						const gchar* _tmp12_ = NULL;
						const gchar* _tmp13_ = NULL;
						gint _tmp14_ = 0;
						const gchar* _tmp15_ = NULL;
						gint _tmp16_ = 0;
						gint _tmp17_ = 0;
						gchar* _tmp18_ = NULL;
						_tmp12_ = shortFileName;
						_tmp13_ = shortFileName;
						_tmp14_ = string_last_index_of (_tmp13_, G_DIR_SEPARATOR_S, 0);
						_tmp15_ = shortFileName;
						_tmp16_ = strlen (_tmp15_);
						_tmp17_ = _tmp16_;
						_tmp18_ = string_slice (_tmp12_, (glong) (_tmp14_ + 1), (glong) _tmp17_);
						_g_free0 (shortFileName);
						shortFileName = _tmp18_;
					}
					_tmp19_ = self->priv->designer;
					_tmp20_ = shortFileName;
					designer_set_name (_tmp19_, _tmp20_);
					_g_free0 (shortFileName);
				} else {
					Designer* _tmp21_ = NULL;
					Designer* _tmp22_ = NULL;
					CustomComponentDef* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp21_ = self->priv->designer;
					_tmp22_ = self->priv->designer;
					_tmp23_ = _tmp22_->customComponentDef;
					_tmp24_ = ((ComponentDef*) _tmp23_)->name;
					_tmp25_ = g_strconcat ("Not saved - ", _tmp24_, NULL);
					_tmp26_ = _tmp25_;
					designer_set_name (_tmp21_, _tmp26_);
					_g_free0 (_tmp26_);
				}
				_tmp27_ = self->priv->project;
				_tmp28_ = project_get_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strconcat (CORE_programName " - ", _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strconcat (_tmp31_, " - ", NULL);
				_tmp33_ = _tmp32_;
				_tmp34_ = self->priv->designer;
				_tmp35_ = designer_get_designerName (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat (_tmp33_, _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				gtk_window_set_title ((GtkWindow*) self, _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp31_);
			} else {
				Project* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				Designer* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				_tmp39_ = self->priv->project;
				_tmp40_ = project_get_name (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strconcat (CORE_programName " - ", _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp43_, " - ", NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = self->priv->designer;
				_tmp47_ = designer_get_designerName (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strconcat (_tmp45_, _tmp48_, NULL);
				_tmp50_ = _tmp49_;
				gtk_window_set_title ((GtkWindow*) self, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
			}
		} else {
			Project* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			_tmp51_ = self->priv->project;
			_tmp52_ = project_get_name (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strconcat (CORE_programName " - ", _tmp53_, NULL);
			_tmp55_ = _tmp54_;
			gtk_window_set_title ((GtkWindow*) self, _tmp55_);
			_g_free0 (_tmp55_);
		}
	} else {
		gtk_window_set_title ((GtkWindow*) self, CORE_programName);
	}
}


/**
 * Prompts the user to open a file (when File>>Open is selected) and
 * loads the file.
 */
static gboolean designer_window_open_component (DesignerWindow* self) {
	gboolean result = FALSE;
	GtkFileChooserDialog* fileChooser = NULL;
	GtkFileChooserDialog* _tmp0_ = NULL;
	GtkFileFilter* _tmp1_ = NULL;
	GtkFileFilter* _tmp2_ = NULL;
	GtkFileFilter* _tmp3_ = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	GtkFileFilter* _tmp5_ = NULL;
	GtkFileFilter* _tmp6_ = NULL;
	GtkFileFilter* _tmp7_ = NULL;
	GtkFileFilter* _tmp8_ = NULL;
	GtkFileFilter* _tmp9_ = NULL;
	GtkFileFilter* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Load Component", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp0_);
	fileChooser = _tmp0_;
	_tmp1_ = self->priv->anysscFileFilter;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp2_);
	_tmp3_ = self->priv->sscFileFilter;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp4_);
	_tmp5_ = self->priv->sscxmlFileFilter;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp6_);
	_tmp7_ = self->priv->xmlFileFilter;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp8_);
	_tmp9_ = self->priv->anyFileFilter;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp10_);
	_tmp11_ = gtk_dialog_run ((GtkDialog*) fileChooser);
	if (_tmp11_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		Project* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gboolean _tmp16_ = FALSE;
		_tmp12_ = self->priv->project;
		_tmp13_ = gtk_file_chooser_get_filename ((GtkFileChooser*) fileChooser);
		_tmp14_ = _tmp13_;
		_tmp15_ = project_reopen_window_from_file (_tmp12_, _tmp14_);
		_tmp16_ = _tmp15_ == 0;
		_g_free0 (_tmp14_);
		if (_tmp16_) {
			FILE* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			DesignerWindow* _tmp20_ = NULL;
			DesignerWindow* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp17_ = stdout;
			_tmp18_ = gtk_file_chooser_get_filename ((GtkFileChooser*) fileChooser);
			_tmp19_ = _tmp18_;
			fprintf (_tmp17_, "Load Component From: %s\n", _tmp19_);
			_g_free0 (_tmp19_);
			_tmp20_ = designer_window_new_designer (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = gtk_file_chooser_get_filename ((GtkFileChooser*) fileChooser);
			_tmp23_ = _tmp22_;
			designer_window_load_component (_tmp21_, _tmp23_);
			_g_free0 (_tmp23_);
			_g_object_unref0 (_tmp21_);
		}
		gtk_widget_destroy ((GtkWidget*) fileChooser);
	} else {
		gtk_widget_destroy ((GtkWidget*) fileChooser);
		result = FALSE;
		_g_object_unref0 (fileChooser);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (fileChooser);
	return result;
}


/**
 * Prompts the user to open a file (when "File>>Open Plugin Component" is selected) and
 * loads the file as a plugin component.
 */
static gboolean designer_window_open_plugin_component (DesignerWindow* self) {
	gboolean result = FALSE;
	Project* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkFileChooserDialog* fileChooser = NULL;
	GtkFileChooserDialog* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	GtkFileFilter* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkFileFilter* _tmp7_ = NULL;
	GtkFileFilter* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkFileFilter* _tmp10_ = NULL;
	GtkFileFilter* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkFileChooserDialog* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->project;
	_tmp1_ = project_plugins_allowed (_tmp0_, "");
	if (_tmp1_ == FALSE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Load Component", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp2_);
	fileChooser = _tmp2_;
	_tmp3_ = fileChooser;
	_tmp4_ = self->priv->anyssxFileFilter;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp3_, _tmp5_);
	_tmp6_ = fileChooser;
	_tmp7_ = self->priv->ssxFileFilter;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp6_, _tmp8_);
	_tmp9_ = fileChooser;
	_tmp10_ = self->priv->anyFileFilter;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp9_, _tmp11_);
	{
		GtkFileChooserDialog* _tmp12_ = NULL;
		_tmp12_ = fileChooser;
		gtk_file_chooser_add_shortcut_folder ((GtkFileChooser*) _tmp12_, PACKAGE_DATADIR "plugins", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		FILE* _tmp13_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp13_ = stderr;
		fprintf (_tmp13_, "Cannot add plugins shortcut %s.\n", PACKAGE_DATADIR "plugins");
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (fileChooser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp14_ = fileChooser;
	_tmp15_ = gtk_dialog_run ((GtkDialog*) _tmp14_);
	if (_tmp15_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		FILE* _tmp16_ = NULL;
		GtkFileChooserDialog* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		Project* _tmp20_ = NULL;
		GtkFileChooserDialog* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		PluginComponentDef* _tmp24_ = NULL;
		PluginComponentDef* _tmp25_ = NULL;
		Project* _tmp26_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = fileChooser;
		_tmp18_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp17_);
		_tmp19_ = _tmp18_;
		fprintf (_tmp16_, "Load Plugin Component From: %s\n", _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->project;
		_tmp21_ = fileChooser;
		_tmp22_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = project_load_plugin_component (_tmp20_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_component_def_unref0 (_tmp25_);
		_g_free0 (_tmp23_);
		_tmp26_ = self->priv->project;
		project_update_plugin_menus (_tmp26_);
	}
	_tmp27_ = fileChooser;
	gtk_widget_destroy ((GtkWidget*) _tmp27_);
	result = FALSE;
	_g_object_unref0 (fileChooser);
	return result;
}


/**
 * Prompts the user to save to a file (when File>>Open is selected)
 * if a filename is unknown, or if //saveAs// is true, and saves the
 * component to a file.
 */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean designer_window_save_component (DesignerWindow* self, gboolean saveAs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	FILE* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	Designer* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	} else {
		Designer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->designer;
		_tmp3_ = designer_get_hasComponent (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!_tmp4_) {
			result = FALSE;
			return result;
		}
	}
	_tmp6_ = self->componentFileName;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = saveAs;
		_tmp5_ = _tmp7_;
	}
	if (_tmp5_) {
		GtkFileChooserDialog* fileChooser = NULL;
		GtkFileChooserDialog* _tmp8_ = NULL;
		GtkFileChooserDialog* _tmp9_ = NULL;
		GtkFileFilter* _tmp10_ = NULL;
		GtkFileFilter* _tmp11_ = NULL;
		GtkFileChooserDialog* _tmp12_ = NULL;
		GtkFileFilter* _tmp13_ = NULL;
		GtkFileFilter* _tmp14_ = NULL;
		GtkFileChooserDialog* _tmp15_ = NULL;
		GtkFileFilter* _tmp16_ = NULL;
		GtkFileFilter* _tmp17_ = NULL;
		GtkFileChooserDialog* _tmp18_ = NULL;
		GtkFileFilter* _tmp19_ = NULL;
		GtkFileFilter* _tmp20_ = NULL;
		GtkFileChooserDialog* _tmp21_ = NULL;
		gboolean stillChoosing = FALSE;
		GtkFileChooserDialog* _tmp54_ = NULL;
		_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save Component", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
		g_object_ref_sink (_tmp8_);
		fileChooser = _tmp8_;
		_tmp9_ = fileChooser;
		_tmp10_ = self->priv->sscFileFilter;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp9_, _tmp11_);
		_tmp12_ = fileChooser;
		_tmp13_ = self->priv->sscxmlFileFilter;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp12_, _tmp14_);
		_tmp15_ = fileChooser;
		_tmp16_ = self->priv->xmlFileFilter;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp15_, _tmp17_);
		_tmp18_ = fileChooser;
		_tmp19_ = self->priv->anyFileFilter;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp18_, _tmp20_);
		_tmp21_ = fileChooser;
		gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp21_, TRUE);
		stillChoosing = TRUE;
		while (TRUE) {
			gboolean _tmp22_ = FALSE;
			GtkFileChooserDialog* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			_tmp22_ = stillChoosing;
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = fileChooser;
			_tmp24_ = gtk_dialog_run ((GtkDialog*) _tmp23_);
			if (_tmp24_ == ((gint) GTK_RESPONSE_ACCEPT)) {
				GtkFileChooserDialog* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				const gchar* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				_tmp25_ = fileChooser;
				_tmp26_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp25_);
				_g_free0 (self->componentFileName);
				self->componentFileName = _tmp26_;
				_tmp27_ = self->componentFileName;
				_tmp28_ = string_contains (_tmp27_, ".");
				if (_tmp28_) {
					FILE* _tmp29_ = NULL;
					_tmp29_ = stdout;
					fprintf (_tmp29_, "File extension already given\n");
				} else {
					GtkFileChooserDialog* _tmp30_ = NULL;
					GtkFileFilter* _tmp31_ = NULL;
					GtkFileFilter* _tmp32_ = NULL;
					GtkFileFilter* _tmp33_ = NULL;
					_tmp30_ = fileChooser;
					_tmp31_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = self->priv->sscFileFilter;
					if (_tmp32_ == _tmp33_) {
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						_tmp34_ = self->componentFileName;
						_tmp35_ = g_strconcat (_tmp34_, ".ssc", NULL);
						_g_free0 (self->componentFileName);
						self->componentFileName = _tmp35_;
					} else {
						GtkFileChooserDialog* _tmp36_ = NULL;
						GtkFileFilter* _tmp37_ = NULL;
						GtkFileFilter* _tmp38_ = NULL;
						GtkFileFilter* _tmp39_ = NULL;
						_tmp36_ = fileChooser;
						_tmp37_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = self->priv->sscxmlFileFilter;
						if (_tmp38_ == _tmp39_) {
							const gchar* _tmp40_ = NULL;
							gchar* _tmp41_ = NULL;
							_tmp40_ = self->componentFileName;
							_tmp41_ = g_strconcat (_tmp40_, ".ssc.xml", NULL);
							_g_free0 (self->componentFileName);
							self->componentFileName = _tmp41_;
						} else {
							GtkFileChooserDialog* _tmp42_ = NULL;
							GtkFileFilter* _tmp43_ = NULL;
							GtkFileFilter* _tmp44_ = NULL;
							GtkFileFilter* _tmp45_ = NULL;
							_tmp42_ = fileChooser;
							_tmp43_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp42_);
							_tmp44_ = _tmp43_;
							_tmp45_ = self->priv->xmlFileFilter;
							if (_tmp44_ == _tmp45_) {
								const gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								_tmp46_ = self->componentFileName;
								_tmp47_ = g_strconcat (_tmp46_, ".xml", NULL);
								_g_free0 (self->componentFileName);
								self->componentFileName = _tmp47_;
							}
						}
					}
				}
				_tmp48_ = self->componentFileName;
				_tmp49_ = g_file_test (_tmp48_, G_FILE_TEST_EXISTS);
				if (_tmp49_) {
					GtkFileChooserDialog* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					gint _tmp52_ = 0;
					_tmp50_ = fileChooser;
					_tmp51_ = self->componentFileName;
					_tmp52_ = basic_dialog_ask_overwrite ((GtkWindow*) _tmp50_, _tmp51_);
					if (_tmp52_ == ((gint) GTK_RESPONSE_YES)) {
						stillChoosing = FALSE;
					}
				} else {
					stillChoosing = FALSE;
				}
			} else {
				GtkFileChooserDialog* _tmp53_ = NULL;
				_tmp53_ = fileChooser;
				gtk_widget_destroy ((GtkWidget*) _tmp53_);
				result = FALSE;
				_g_object_unref0 (fileChooser);
				return result;
			}
		}
		_tmp54_ = fileChooser;
		gtk_widget_destroy ((GtkWidget*) _tmp54_);
		_g_object_unref0 (fileChooser);
	}
	_tmp55_ = stdout;
	_tmp56_ = self->componentFileName;
	fprintf (_tmp55_, "Save Component To: %s\n", _tmp56_);
	_tmp57_ = self->priv->designer;
	_tmp58_ = self->componentFileName;
	designer_save_component (_tmp57_, _tmp58_);
	designer_window_update_title (self);
	result = FALSE;
	return result;
}


static gboolean designer_window_open_project (DesignerWindow* self) {
	gboolean result = FALSE;
	GtkFileChooserDialog* fileChooser = NULL;
	GtkFileChooserDialog* _tmp0_ = NULL;
	GtkFileFilter* _tmp1_ = NULL;
	GtkFileFilter* _tmp2_ = NULL;
	GtkFileFilter* _tmp3_ = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	GtkFileFilter* _tmp5_ = NULL;
	GtkFileFilter* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Load Project", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp0_);
	fileChooser = _tmp0_;
	_tmp1_ = self->priv->anysspFileFilter;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp2_);
	_tmp3_ = self->priv->sspFileFilter;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp4_);
	_tmp5_ = self->priv->anyFileFilter;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) fileChooser, _tmp6_);
	_tmp7_ = gtk_dialog_run ((GtkDialog*) fileChooser);
	if (_tmp7_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		FILE* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp8_ = stdout;
		_tmp9_ = gtk_file_chooser_get_filename ((GtkFileChooser*) fileChooser);
		_tmp10_ = _tmp9_;
		fprintf (_tmp8_, "Load Project From: %s\n", _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = gtk_file_chooser_get_filename ((GtkFileChooser*) fileChooser);
		_tmp12_ = _tmp11_;
		designer_window_load_project (self, _tmp12_);
		_g_free0 (_tmp12_);
		gtk_widget_destroy ((GtkWidget*) fileChooser);
	} else {
		gtk_widget_destroy ((GtkWidget*) fileChooser);
		result = FALSE;
		_g_object_unref0 (fileChooser);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (fileChooser);
	return result;
}


static gboolean designer_window_save_project (DesignerWindow* self, gboolean saveAs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = saveAs;
	designer_window_do_save_project (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean designer_window_do_save_project (DesignerWindow* self, gboolean saveAs) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Project* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	FILE* _tmp41_ = NULL;
	Project* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	Project* _tmp44_ = NULL;
	Project* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->project;
	_tmp4_ = _tmp3_->filename;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = saveAs;
		_tmp2_ = _tmp5_;
	}
	if (_tmp2_) {
		GtkFileChooserDialog* fileChooser = NULL;
		GtkFileChooserDialog* _tmp6_ = NULL;
		GtkFileChooserDialog* _tmp7_ = NULL;
		GtkFileFilter* _tmp8_ = NULL;
		GtkFileFilter* _tmp9_ = NULL;
		GtkFileChooserDialog* _tmp10_ = NULL;
		GtkFileFilter* _tmp11_ = NULL;
		GtkFileFilter* _tmp12_ = NULL;
		GtkFileChooserDialog* _tmp13_ = NULL;
		gboolean stillChoosing = FALSE;
		GtkFileChooserDialog* _tmp40_ = NULL;
		_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save Project", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
		g_object_ref_sink (_tmp6_);
		fileChooser = _tmp6_;
		_tmp7_ = fileChooser;
		_tmp8_ = self->priv->sspFileFilter;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp7_, _tmp9_);
		_tmp10_ = fileChooser;
		_tmp11_ = self->priv->anyFileFilter;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp10_, _tmp12_);
		_tmp13_ = fileChooser;
		gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp13_, TRUE);
		stillChoosing = TRUE;
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			GtkFileChooserDialog* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			_tmp14_ = stillChoosing;
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = fileChooser;
			_tmp16_ = gtk_dialog_run ((GtkDialog*) _tmp15_);
			if (_tmp16_ == ((gint) GTK_RESPONSE_ACCEPT)) {
				Project* _tmp17_ = NULL;
				GtkFileChooserDialog* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				Project* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				Project* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				_tmp17_ = self->priv->project;
				_tmp18_ = fileChooser;
				_tmp19_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp18_);
				_g_free0 (_tmp17_->filename);
				_tmp17_->filename = _tmp19_;
				_tmp20_ = self->priv->project;
				_tmp21_ = _tmp20_->filename;
				_tmp22_ = string_contains (_tmp21_, ".");
				if (_tmp22_) {
					FILE* _tmp23_ = NULL;
					_tmp23_ = stdout;
					fprintf (_tmp23_, "File extension already given\n");
				} else {
					GtkFileChooserDialog* _tmp24_ = NULL;
					GtkFileFilter* _tmp25_ = NULL;
					GtkFileFilter* _tmp26_ = NULL;
					GtkFileFilter* _tmp27_ = NULL;
					_tmp24_ = fileChooser;
					_tmp25_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = self->priv->anysspFileFilter;
					if (_tmp26_ == _tmp27_) {
						Project* _tmp28_ = NULL;
						Project* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						_tmp28_ = self->priv->project;
						_tmp29_ = self->priv->project;
						_tmp30_ = _tmp29_->filename;
						_tmp31_ = g_strconcat (_tmp30_, ".ssp", NULL);
						_g_free0 (_tmp29_->filename);
						_tmp29_->filename = _tmp31_;
					}
				}
				_tmp32_ = self->priv->project;
				_tmp33_ = _tmp32_->filename;
				_tmp34_ = g_file_test (_tmp33_, G_FILE_TEST_EXISTS);
				if (_tmp34_) {
					GtkFileChooserDialog* _tmp35_ = NULL;
					Project* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					_tmp35_ = fileChooser;
					_tmp36_ = self->priv->project;
					_tmp37_ = _tmp36_->filename;
					_tmp38_ = basic_dialog_ask_overwrite ((GtkWindow*) _tmp35_, _tmp37_);
					if (_tmp38_ == ((gint) GTK_RESPONSE_YES)) {
						stillChoosing = FALSE;
					}
				} else {
					stillChoosing = FALSE;
				}
			} else {
				GtkFileChooserDialog* _tmp39_ = NULL;
				_tmp39_ = fileChooser;
				gtk_widget_destroy ((GtkWidget*) _tmp39_);
				result = FALSE;
				_g_object_unref0 (fileChooser);
				return result;
			}
		}
		_tmp40_ = fileChooser;
		gtk_widget_destroy ((GtkWidget*) _tmp40_);
		_g_object_unref0 (fileChooser);
	}
	_tmp41_ = stdout;
	_tmp42_ = self->priv->project;
	_tmp43_ = _tmp42_->filename;
	fprintf (_tmp41_, "Save Project To: %s\n", _tmp43_);
	_tmp44_ = self->priv->project;
	_tmp45_ = self->priv->project;
	_tmp46_ = _tmp45_->filename;
	project_save (_tmp44_, _tmp46_);
	designer_window_update_title (self);
	result = TRUE;
	return result;
}


/**
 * Creates a new component in this window. Does not open a new
 * window if there is already a component.
 */
static void designer_window_new_component (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = designer_window_get_hasDesigner (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = designer_window_get_hasProject (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Designer* _tmp5_ = NULL;
		Project* _tmp6_ = NULL;
		CustomComponentDef* _tmp7_ = NULL;
		CustomComponentDef* _tmp8_ = NULL;
		_tmp5_ = self->priv->designer;
		_tmp6_ = self->priv->project;
		_tmp7_ = project_new_component (_tmp6_);
		_tmp8_ = _tmp7_;
		designer_set_component (_tmp5_, _tmp8_);
		_component_def_unref0 (_tmp8_);
	}
	designer_window_update_custom_menu (self);
	designer_window_update_plugin_menu (self);
	designer_window_update_title (self);
	designer_window_render_design (self, NULL);
}


static void designer_window_set_component (DesignerWindow* self, CustomComponentDef* customComponentDef) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (customComponentDef != NULL);
	_tmp1_ = designer_window_get_hasDesigner (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = designer_window_get_hasProject (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Designer* _tmp5_ = NULL;
		CustomComponentDef* _tmp6_ = NULL;
		Designer* _tmp7_ = NULL;
		CustomComponentDef* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp5_ = self->priv->designer;
		_tmp6_ = customComponentDef;
		designer_set_component (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->designer;
		_tmp8_ = _tmp7_->customComponentDef;
		_tmp9_ = ((ComponentDef*) _tmp8_)->filename;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->componentFileName);
		self->componentFileName = _tmp10_;
	}
	designer_window_update_custom_menu (self);
	designer_window_update_plugin_menu (self);
	designer_window_update_title (self);
	designer_window_render_design (self, NULL);
}


/**
 * Loads a component from a file in this window. Does not open a new
 * window if there is not already a component.
 */
static void designer_window_load_component (DesignerWindow* self, const gchar* filename) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp1_ = designer_window_get_hasDesigner (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = designer_window_get_hasProject (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Designer* _tmp5_ = NULL;
		Project* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		CustomComponentDef* _tmp8_ = NULL;
		CustomComponentDef* _tmp9_ = NULL;
		Designer* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp5_ = self->priv->designer;
		_tmp6_ = self->priv->project;
		_tmp7_ = filename;
		_tmp8_ = project_load_component (_tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		designer_set_component (_tmp5_, _tmp9_);
		_component_def_unref0 (_tmp9_);
		_tmp10_ = self->priv->designer;
		_tmp11_ = designer_get_hasComponent (_tmp10_);
		_tmp12_ = _tmp11_;
		if (!_tmp12_) {
			Project* _tmp13_ = NULL;
			Designer* _tmp14_ = NULL;
			_tmp13_ = self->priv->project;
			_tmp14_ = self->priv->designer;
			project_unregister_designer (_tmp13_, _tmp14_);
			designer_window_set_hasDesigner (self, FALSE);
		}
		_tmp15_ = filename;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (self->componentFileName);
		self->componentFileName = _tmp16_;
	}
	designer_window_update_custom_menu (self);
	designer_window_update_plugin_menu (self);
	designer_window_update_title (self);
	designer_window_render_design (self, NULL);
}


/**
 * Creates a new Designer for the current project. Returns the
 * window for the Designer. If there is not already a component in
 * this window, this window will be used and returned.
 */
static DesignerWindow* designer_window_new_designer (DesignerWindow* self) {
	DesignerWindow* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Project* _tmp8_ = NULL;
	Designer* _tmp9_ = NULL;
	DesignerWindow* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Designer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->designer;
		_tmp3_ = designer_get_hasComponent (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			Project* _tmp5_ = NULL;
			DesignerWindow* _tmp6_ = NULL;
			_tmp5_ = self->priv->project;
			_tmp6_ = designer_window_new_with_new_designer (_tmp5_);
			g_object_ref_sink (_tmp6_);
			result = _tmp6_;
			return result;
		} else {
			DesignerWindow* _tmp7_ = NULL;
			_tmp7_ = _g_object_ref0 (self);
			result = _tmp7_;
			return result;
		}
	}
	_tmp8_ = self->priv->project;
	_tmp9_ = project_new_designer (_tmp8_, self);
	_designer_unref0 (self->priv->designer);
	self->priv->designer = _tmp9_;
	designer_window_set_hasDesigner (self, TRUE);
	designer_window_update_title (self);
	designer_window_render_design (self, NULL);
	_tmp10_ = _g_object_ref0 (self);
	result = _tmp10_;
	return result;
}


/**
 * Creates a new Project. If there is not already a project in this
 * window, this window will be used, else a new window will be
 * created.
 */
static void designer_window_new_project (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Project* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		DesignerWindow* _tmp2_ = NULL;
		DesignerWindow* _tmp3_ = NULL;
		_tmp2_ = designer_window_new_with_new_project ();
		g_object_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp3_);
		return;
	}
	_tmp4_ = project_new ();
	_project_unref0 (self->priv->project);
	self->priv->project = _tmp4_;
	designer_window_set_hasProject (self, TRUE);
	designer_window_update_title (self);
}


static void designer_window_load_project (DesignerWindow* self, const gchar* filename) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		DesignerWindow* _tmp3_ = NULL;
		DesignerWindow* _tmp4_ = NULL;
		_tmp2_ = filename;
		_tmp3_ = designer_window_new_with_project_from_file (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		return;
	}
	{
		Project* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Project* _tmp7_ = NULL;
		Project* _tmp8_ = NULL;
		CustomComponentDef* defaultComponent = NULL;
		Project* _tmp9_ = NULL;
		CustomComponentDef* _tmp10_ = NULL;
		CustomComponentDef* _tmp11_ = NULL;
		_tmp6_ = filename;
		_tmp7_ = project_new_load (_tmp6_, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
				goto __catch51_project_load_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_project_unref0 (self->priv->project);
		self->priv->project = _tmp8_;
		designer_window_set_hasProject (self, TRUE);
		_tmp9_ = self->priv->project;
		_tmp10_ = project_get_default_component (_tmp9_);
		defaultComponent = _tmp10_;
		_tmp11_ = defaultComponent;
		if (_tmp11_ != NULL) {
			DesignerWindow* _tmp12_ = NULL;
			DesignerWindow* _tmp13_ = NULL;
			CustomComponentDef* _tmp14_ = NULL;
			_tmp12_ = designer_window_new_designer (self);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp13_);
			_tmp14_ = defaultComponent;
			designer_window_set_component (self, _tmp14_);
		}
		designer_window_update_title (self);
		_component_def_unref0 (defaultComponent);
		_project_unref0 (_tmp5_);
	}
	goto __finally51;
	__catch51_project_load_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = _error_;
		_tmp17_ = _tmp16_->message;
		fprintf (_tmp15_, "Error loading project: %s\n", _tmp17_);
		_g_error_free0 (_error_);
	}
	__finally51:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
 * Displays the about dialog (Help>>About). Displays information
 * about the SmartSim software package.
 */
static void designer_window_show_about (DesignerWindow* self) {
	GdkPixbuf* logo = NULL;
	GtkAboutDialog* aboutDialog = NULL;
	GtkAboutDialog* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	logo = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		_tmp1_ = gdk_pixbuf_new_from_file (PACKAGE_DATADIR "images/icons/smartsim64.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch52_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (logo);
		logo = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally52;
	__catch52_g_error:
	{
		FILE* _tmp3_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "Could not load logo image.\n");
	}
	__finally52:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (logo);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp4_);
	aboutDialog = _tmp4_;
	_tmp5_ = logo;
	gtk_about_dialog_set_logo (aboutDialog, _tmp5_);
	gtk_about_dialog_set_program_name (aboutDialog, CORE_programName);
	gtk_window_set_title ((GtkWindow*) aboutDialog, "About " CORE_programName);
	gtk_about_dialog_set_version (aboutDialog, CORE_versionString);
	gtk_about_dialog_set_comments (aboutDialog, "A logic circuit designer and simulator.");
	gtk_about_dialog_set_authors (aboutDialog, CORE_authorsStrings);
	gtk_about_dialog_set_copyright (aboutDialog, CORE_copyrightString);
	gtk_about_dialog_set_license_type (aboutDialog, CORE_licenseType);
	gtk_about_dialog_set_license (aboutDialog, CORE_licenseName "\n\n" CORE_shortLicenseText);
	gtk_about_dialog_set_website (aboutDialog, CORE_websiteString);
	gtk_about_dialog_set_website_label (aboutDialog, "SmartSim Website - Software and Documentation");
	gtk_about_dialog_set_wrap_license (aboutDialog, FALSE);
	gtk_dialog_run ((GtkDialog*) aboutDialog);
	gtk_widget_destroy ((GtkWidget*) aboutDialog);
	_g_object_unref0 (aboutDialog);
	_g_object_unref0 (logo);
}


/**
 * Called when the user clicks File>>Page Setup. Opens a dialog for
 * configuring the page setup for printing.
 */
void designer_window_print_page_setup (DesignerWindow* self) {
	GtkPageSetup* _tmp0_ = NULL;
	GtkPrintSettings* _tmp1_ = NULL;
	GtkPageSetup* _tmp2_ = NULL;
	GtkPageSetup* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pageSetup;
	_tmp1_ = self->priv->printSettings;
	_tmp2_ = gtk_print_run_page_setup_dialog ((GtkWindow*) self, _tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->pageSetup);
	self->priv->pageSetup = _tmp3_;
}


/**
 * Called when the user clicks File>>Print. Prompts the user with
 * printing options and prints off the current work area view.
 */
static void _designer_window_print_render_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
	designer_window_print_render ((DesignerWindow*) self, context, page_nr);
}


void designer_window_print (DesignerWindow* self) {
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	GtkDrawingArea* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkPrintOperation* printOperation = NULL;
	GtkPrintOperation* _tmp13_ = NULL;
	GtkPrintOperation* _tmp14_ = NULL;
	GtkPrintSettings* _tmp15_ = NULL;
	GtkPrintOperation* _tmp16_ = NULL;
	GtkPageSetup* _tmp17_ = NULL;
	GtkPrintOperation* _tmp18_ = NULL;
	GtkPrintOperation* _tmp19_ = NULL;
	GtkPrintOperation* _tmp20_ = NULL;
	GtkPrintOperationResult _result_ = 0;
	GtkPrintOperationResult _tmp25_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = designer_window_get_hasDesigner (self);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		FILE* _tmp8_ = NULL;
		_tmp8_ = stderr;
		fprintf (_tmp8_, "Error: Cannot print without designer\n");
		return;
	} else {
		Designer* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->designer;
		_tmp10_ = designer_get_hasComponent (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			FILE* _tmp12_ = NULL;
			_tmp12_ = stderr;
			fprintf (_tmp12_, "Error: Cannot print without component (but found designer)\n");
			return;
		}
	}
	_tmp13_ = gtk_print_operation_new ();
	printOperation = _tmp13_;
	_tmp14_ = printOperation;
	_tmp15_ = self->priv->printSettings;
	gtk_print_operation_set_print_settings (_tmp14_, _tmp15_);
	_tmp16_ = printOperation;
	_tmp17_ = self->priv->pageSetup;
	gtk_print_operation_set_default_page_setup (_tmp16_, _tmp17_);
	_tmp18_ = printOperation;
	gtk_print_operation_set_n_pages (_tmp18_, 1);
	_tmp19_ = printOperation;
	gtk_print_operation_set_unit (_tmp19_, GTK_UNIT_POINTS);
	_tmp20_ = printOperation;
	g_signal_connect_object (_tmp20_, "draw-page", (GCallback) _designer_window_print_render_gtk_print_operation_draw_page, self, 0);
	{
		GtkPrintOperationResult _tmp21_ = 0;
		GtkPrintOperation* _tmp22_ = NULL;
		GtkPrintOperationResult _tmp23_ = 0;
		_tmp22_ = printOperation;
		_tmp23_ = gtk_print_operation_run (_tmp22_, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) self, &_inner_error_);
		_tmp21_ = _tmp23_;
		if (_inner_error_ != NULL) {
			goto __catch53_g_error;
		}
		_result_ = _tmp21_;
	}
	goto __finally53;
	__catch53_g_error:
	{
		FILE* _tmp24_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp24_ = stderr;
		fprintf (_tmp24_, "Print operation failed!\n");
		_g_object_unref0 (printOperation);
		return;
	}
	__finally53:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (printOperation);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp25_ = _result_;
	if (_tmp25_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
		GtkPrintOperation* _tmp26_ = NULL;
		GtkPrintSettings* _tmp27_ = NULL;
		GtkPrintSettings* _tmp28_ = NULL;
		_tmp26_ = printOperation;
		_tmp27_ = gtk_print_operation_get_print_settings (_tmp26_);
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_g_object_unref0 (self->priv->printSettings);
		self->priv->printSettings = _tmp28_;
	}
	_g_object_unref0 (printOperation);
}


gboolean designer_window_render_overlay (DesignerWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkDrawingArea* _tmp1_ = NULL;
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	GtkDrawingArea* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	cairo_surface_t* _tmp10_ = NULL;
	cairo_t* displayContext = NULL;
	GtkDrawingArea* _tmp11_ = NULL;
	GdkWindow* _tmp12_ = NULL;
	cairo_t* _tmp13_ = NULL;
	cairo_surface_t* offScreenSurface = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	cairo_surface_t* _tmp18_ = NULL;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_surface_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	cairo_surface_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	cairo_t* _tmp29_ = NULL;
	gfloat _tmp30_ = 0.0F;
	gfloat _tmp31_ = 0.0F;
	cairo_t* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	cairo_t* _tmp47_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->display;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = designer_window_get_hasDesigner (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp4_, &_tmp5_);
	areaAllocation = _tmp5_;
	_tmp6_ = areaAllocation;
	_tmp7_ = _tmp6_.width;
	width = _tmp7_;
	_tmp8_ = areaAllocation;
	_tmp9_ = _tmp8_.height;
	height = _tmp9_;
	_tmp10_ = self->priv->staticCache;
	if (_tmp10_ == NULL) {
		designer_window_render_design (self, NULL);
	}
	_tmp11_ = self->priv->display;
	_tmp12_ = gtk_widget_get_window ((GtkWidget*) _tmp11_);
	_tmp13_ = gdk_cairo_create (_tmp12_);
	displayContext = _tmp13_;
	_tmp14_ = displayContext;
	_tmp15_ = cairo_get_target (_tmp14_);
	_tmp16_ = width;
	_tmp17_ = height;
	_tmp18_ = cairo_surface_create_similar (_tmp15_, CAIRO_CONTENT_COLOR, _tmp16_, _tmp17_);
	offScreenSurface = _tmp18_;
	_tmp19_ = offScreenSurface;
	_tmp20_ = cairo_create (_tmp19_);
	context = _tmp20_;
	_tmp21_ = displayContext;
	_tmp22_ = offScreenSurface;
	cairo_set_source_surface (_tmp21_, _tmp22_, (gdouble) 0, (gdouble) 0);
	_tmp23_ = context;
	_tmp24_ = self->priv->staticCache;
	cairo_set_source_surface (_tmp23_, _tmp24_, (gdouble) 0, (gdouble) 0);
	_tmp25_ = context;
	cairo_paint (_tmp25_);
	_tmp26_ = context;
	_tmp27_ = width;
	_tmp28_ = height;
	cairo_translate (_tmp26_, (gdouble) (_tmp27_ / 2), (gdouble) (_tmp28_ / 2));
	_tmp29_ = context;
	_tmp30_ = self->zoom;
	_tmp31_ = self->zoom;
	cairo_scale (_tmp29_, (gdouble) _tmp30_, (gdouble) _tmp31_);
	_tmp32_ = context;
	_tmp33_ = self->priv->xView;
	_tmp34_ = self->priv->yView;
	cairo_translate (_tmp32_, (gdouble) (-_tmp33_), (gdouble) (-_tmp34_));
	_tmp35_ = context;
	cairo_set_source_rgb (_tmp35_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp36_ = context;
	cairo_set_line_width (_tmp36_, (gdouble) 1);
	_tmp39_ = self->shadowComponent;
	if (_tmp39_) {
		DesignerWindowMouseMode _tmp40_ = 0;
		_tmp40_ = self->priv->mouseMode;
		_tmp38_ = _tmp40_ == DESIGNER_WINDOW_MOUSE_MODE_INSERT;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		gboolean _tmp41_ = FALSE;
		_tmp41_ = self->priv->mouseIsDown;
		_tmp37_ = !_tmp41_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		Designer* _tmp42_ = NULL;
		ComponentInst* _tmp43_ = NULL;
		cairo_t* _tmp44_ = NULL;
		gboolean _tmp45_ = FALSE;
		gboolean _tmp46_ = FALSE;
		_tmp42_ = self->priv->designer;
		_tmp43_ = _tmp42_->shadowComponentInst;
		_tmp44_ = context;
		_tmp45_ = self->priv->showHints;
		_tmp46_ = self->priv->colourBackgrounds;
		component_inst_render (_tmp43_, _tmp44_, _tmp45_, FALSE, _tmp46_);
	}
	_tmp47_ = displayContext;
	cairo_paint (_tmp47_);
	result = FALSE;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (offScreenSurface);
	_cairo_destroy0 (displayContext);
	return result;
}


/**
 * Refreshes the work area display.
 */
static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


gboolean designer_window_render_design (DesignerWindow* self, cairo_t* passedDisplayContext) {
	gboolean result = FALSE;
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	cairo_t* displayContext = NULL;
	GtkDrawingArea* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	cairo_t* _tmp6_ = NULL;
	cairo_surface_t* offScreenSurface = NULL;
	cairo_t* _tmp12_ = NULL;
	cairo_surface_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	cairo_surface_t* _tmp16_ = NULL;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_surface_t* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	cairo_t* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	cairo_t* _tmp151_ = NULL;
	gint _tmp152_ = 0;
	gint _tmp153_ = 0;
	cairo_t* _tmp154_ = NULL;
	gfloat _tmp155_ = 0.0F;
	gfloat _tmp156_ = 0.0F;
	cairo_t* _tmp157_ = NULL;
	gint _tmp158_ = 0;
	gint _tmp159_ = 0;
	cairo_t* _tmp160_ = NULL;
	Designer* _tmp161_ = NULL;
	cairo_t* _tmp162_ = NULL;
	gboolean _tmp163_ = FALSE;
	gboolean _tmp164_ = FALSE;
	gboolean _tmp165_ = FALSE;
	cairo_t* _tmp166_ = NULL;
	cairo_surface_t* _tmp167_ = NULL;
	cairo_surface_t* _tmp168_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = passedDisplayContext;
	if (_tmp6_ == NULL) {
		GtkDrawingArea* _tmp7_ = NULL;
		GdkWindow* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		_tmp7_ = self->priv->display;
		_tmp8_ = gtk_widget_get_window ((GtkWidget*) _tmp7_);
		_tmp9_ = gdk_cairo_create (_tmp8_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp9_;
	} else {
		cairo_t* _tmp10_ = NULL;
		cairo_t* _tmp11_ = NULL;
		_tmp10_ = passedDisplayContext;
		_tmp11_ = _cairo_reference0 (_tmp10_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp11_;
	}
	_tmp12_ = displayContext;
	_tmp13_ = cairo_get_target (_tmp12_);
	_tmp14_ = width;
	_tmp15_ = height;
	_tmp16_ = cairo_surface_create_similar (_tmp13_, CAIRO_CONTENT_COLOR, _tmp14_, _tmp15_);
	offScreenSurface = _tmp16_;
	_tmp17_ = offScreenSurface;
	_tmp18_ = cairo_create (_tmp17_);
	context = _tmp18_;
	_tmp19_ = displayContext;
	_tmp20_ = offScreenSurface;
	cairo_set_source_surface (_tmp19_, _tmp20_, (gdouble) 0, (gdouble) 0);
	_tmp21_ = designer_window_get_hasDesigner (self);
	_tmp22_ = _tmp21_;
	if (!_tmp22_) {
		cairo_t* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		cairo_t* _tmp26_ = NULL;
		gfloat _tmp27_ = 0.0F;
		gfloat _tmp28_ = 0.0F;
		cairo_t* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		cairo_text_extents_t textExtents = {0};
		cairo_t* _tmp32_ = NULL;
		cairo_t* _tmp33_ = NULL;
		cairo_t* _tmp34_ = NULL;
		cairo_text_extents_t _tmp35_ = {0};
		cairo_t* _tmp36_ = NULL;
		cairo_text_extents_t _tmp37_ = {0};
		gdouble _tmp38_ = 0.0;
		cairo_text_extents_t _tmp39_ = {0};
		gdouble _tmp40_ = 0.0;
		cairo_t* _tmp41_ = NULL;
		cairo_t* _tmp42_ = NULL;
		cairo_t* _tmp43_ = NULL;
		cairo_t* _tmp44_ = NULL;
		cairo_t* _tmp45_ = NULL;
		cairo_t* _tmp46_ = NULL;
		cairo_t* _tmp47_ = NULL;
		_tmp23_ = context;
		_tmp24_ = width;
		_tmp25_ = height;
		cairo_translate (_tmp23_, (gdouble) (_tmp24_ / 2), (gdouble) (_tmp25_ / 2));
		_tmp26_ = context;
		_tmp27_ = self->zoom;
		_tmp28_ = self->zoom;
		cairo_scale (_tmp26_, (gdouble) _tmp27_, (gdouble) _tmp28_);
		_tmp29_ = context;
		_tmp30_ = self->priv->xView;
		_tmp31_ = self->priv->yView;
		cairo_translate (_tmp29_, (gdouble) (-_tmp30_), (gdouble) (-_tmp31_));
		_tmp32_ = context;
		cairo_select_font_face (_tmp32_, "", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp33_ = context;
		cairo_set_font_size (_tmp33_, 16.0);
		_tmp34_ = context;
		cairo_text_extents (_tmp34_, "Welcome to " CORE_programName " v" CORE_shortVersionString, &_tmp35_);
		textExtents = _tmp35_;
		_tmp36_ = context;
		_tmp37_ = textExtents;
		_tmp38_ = _tmp37_.width;
		_tmp39_ = textExtents;
		_tmp40_ = _tmp39_.height;
		cairo_translate (_tmp36_, (-_tmp38_) / 2, (+_tmp40_) / 2);
		_tmp41_ = context;
		cairo_set_source_rgb (_tmp41_, 0.75, 0.75, 0.75);
		_tmp42_ = context;
		cairo_paint (_tmp42_);
		_tmp43_ = context;
		cairo_set_source_rgb (_tmp43_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
		_tmp44_ = context;
		cairo_show_text (_tmp44_, "Welcome to " CORE_programName " v" CORE_shortVersionString);
		_tmp45_ = context;
		cairo_stroke (_tmp45_);
		_tmp46_ = context;
		cairo_select_font_face (_tmp46_, "", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
		_tmp47_ = displayContext;
		cairo_paint (_tmp47_);
		result = FALSE;
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (offScreenSurface);
		_cairo_destroy0 (displayContext);
		return result;
	}
	_tmp48_ = context;
	cairo_set_line_width (_tmp48_, (gdouble) 1);
	_tmp49_ = self->showGrid;
	if (_tmp49_) {
		cairo_surface_t* _tmp50_ = NULL;
		cairo_t* _tmp146_ = NULL;
		cairo_surface_t* _tmp147_ = NULL;
		cairo_t* _tmp148_ = NULL;
		_tmp50_ = self->priv->gridCache;
		if (_tmp50_ == NULL) {
			cairo_t* _tmp51_ = NULL;
			cairo_surface_t* _tmp52_ = NULL;
			cairo_t* _tmp53_ = NULL;
			cairo_surface_t* _tmp54_ = NULL;
			cairo_content_t _tmp55_ = 0;
			gint _tmp56_ = 0;
			gint _tmp57_ = 0;
			cairo_surface_t* _tmp58_ = NULL;
			cairo_t* gridContext = NULL;
			cairo_surface_t* _tmp59_ = NULL;
			cairo_t* _tmp60_ = NULL;
			cairo_t* _tmp61_ = NULL;
			cairo_t* _tmp62_ = NULL;
			gfloat spacing = 0.0F;
			gfloat _tmp63_ = 0.0F;
			gint _tmp64_ = 0;
			gfloat y = 0.0F;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			gfloat _tmp70_ = 0.0F;
			gfloat _tmp71_ = 0.0F;
			gfloat x = 0.0F;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gfloat _tmp74_ = 0.0F;
			gfloat _tmp75_ = 0.0F;
			cairo_t* _tmp76_ = NULL;
			cairo_t* _tmp77_ = NULL;
			gfloat _tmp78_ = 0.0F;
			gdouble* _tmp79_ = NULL;
			gdouble* _tmp80_ = NULL;
			gint _tmp80__length1 = 0;
			gfloat _tmp93_ = 0.0F;
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gfloat _tmp96_ = 0.0F;
			gfloat _tmp97_ = 0.0F;
			gint _tmp98_ = 0;
			gint _tmp99_ = 0;
			gfloat _tmp100_ = 0.0F;
			gfloat _tmp101_ = 0.0F;
			cairo_t* _tmp102_ = NULL;
			cairo_t* _tmp103_ = NULL;
			gfloat _tmp104_ = 0.0F;
			gdouble* _tmp105_ = NULL;
			gdouble* _tmp106_ = NULL;
			gint _tmp106__length1 = 0;
			cairo_t* _tmp119_ = NULL;
			cairo_t* _tmp120_ = NULL;
			gint _tmp121_ = 0;
			gint _tmp122_ = 0;
			gfloat _tmp123_ = 0.0F;
			gint _tmp124_ = 0;
			gint _tmp125_ = 0;
			gfloat _tmp126_ = 0.0F;
			cairo_t* _tmp127_ = NULL;
			gfloat _tmp128_ = 0.0F;
			gfloat _tmp129_ = 0.0F;
			gfloat _tmp130_ = 0.0F;
			cairo_t* _tmp131_ = NULL;
			gfloat _tmp132_ = 0.0F;
			gfloat _tmp133_ = 0.0F;
			gfloat _tmp134_ = 0.0F;
			cairo_t* _tmp135_ = NULL;
			cairo_t* _tmp136_ = NULL;
			gfloat _tmp137_ = 0.0F;
			gfloat _tmp138_ = 0.0F;
			gfloat _tmp139_ = 0.0F;
			cairo_t* _tmp140_ = NULL;
			gfloat _tmp141_ = 0.0F;
			gfloat _tmp142_ = 0.0F;
			gfloat _tmp143_ = 0.0F;
			cairo_t* _tmp144_ = NULL;
			cairo_t* _tmp145_ = NULL;
			_tmp51_ = context;
			_tmp52_ = cairo_get_target (_tmp51_);
			_tmp53_ = context;
			_tmp54_ = cairo_get_target (_tmp53_);
			_tmp55_ = cairo_surface_get_content (_tmp54_);
			_tmp56_ = width;
			_tmp57_ = height;
			_tmp58_ = cairo_surface_create_similar (_tmp52_, _tmp55_, _tmp56_, _tmp57_);
			_cairo_surface_destroy0 (self->priv->gridCache);
			self->priv->gridCache = _tmp58_;
			_tmp59_ = self->priv->gridCache;
			_tmp60_ = cairo_create (_tmp59_);
			gridContext = _tmp60_;
			_tmp61_ = gridContext;
			cairo_set_source_rgb (_tmp61_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
			_tmp62_ = gridContext;
			cairo_paint (_tmp62_);
			_tmp63_ = self->zoom;
			_tmp64_ = self->gridSize;
			spacing = _tmp63_ * _tmp64_;
			while (TRUE) {
				gfloat _tmp65_ = 0.0F;
				gfloat _tmp66_ = 0.0F;
				gint _tmp67_ = 0;
				_tmp65_ = spacing;
				if (!(_tmp65_ < ((gfloat) 2))) {
					break;
				}
				_tmp66_ = spacing;
				_tmp67_ = self->gridSize;
				spacing = _tmp66_ * _tmp67_;
			}
			_tmp68_ = height;
			_tmp69_ = self->priv->yView;
			_tmp70_ = self->zoom;
			_tmp71_ = spacing;
			y = fmodf ((_tmp68_ / 2) - (((gfloat) _tmp69_) * _tmp70_), _tmp71_);
			_tmp72_ = width;
			_tmp73_ = self->priv->xView;
			_tmp74_ = self->zoom;
			_tmp75_ = spacing;
			x = fmodf ((_tmp72_ / 2) - (((gfloat) _tmp73_) * _tmp74_), _tmp75_);
			_tmp76_ = gridContext;
			cairo_set_source_rgba (_tmp76_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
			_tmp77_ = gridContext;
			_tmp78_ = spacing;
			_tmp79_ = g_new0 (gdouble, 2);
			_tmp79_[0] = 1.0;
			_tmp79_[1] = _tmp78_ - 1.0;
			_tmp80_ = _tmp79_;
			_tmp80__length1 = 2;
			cairo_set_dash (_tmp77_, _tmp80_, 2, (gdouble) 0);
			_tmp80_ = (g_free (_tmp80_), NULL);
			{
				gboolean _tmp81_ = FALSE;
				_tmp81_ = TRUE;
				while (TRUE) {
					gfloat _tmp84_ = 0.0F;
					gint _tmp85_ = 0;
					cairo_t* _tmp86_ = NULL;
					gfloat _tmp87_ = 0.0F;
					gfloat _tmp88_ = 0.0F;
					cairo_t* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gfloat _tmp91_ = 0.0F;
					cairo_t* _tmp92_ = NULL;
					if (!_tmp81_) {
						gfloat _tmp82_ = 0.0F;
						gfloat _tmp83_ = 0.0F;
						_tmp82_ = y;
						_tmp83_ = spacing;
						y = _tmp82_ + _tmp83_;
					}
					_tmp81_ = FALSE;
					_tmp84_ = y;
					_tmp85_ = height;
					if (!(_tmp84_ < ((gfloat) _tmp85_))) {
						break;
					}
					_tmp86_ = gridContext;
					_tmp87_ = x;
					_tmp88_ = y;
					cairo_move_to (_tmp86_, (gdouble) _tmp87_, (gdouble) _tmp88_);
					_tmp89_ = gridContext;
					_tmp90_ = width;
					_tmp91_ = y;
					cairo_line_to (_tmp89_, (gdouble) _tmp90_, (gdouble) _tmp91_);
					_tmp92_ = gridContext;
					cairo_stroke (_tmp92_);
				}
			}
			_tmp93_ = spacing;
			spacing = _tmp93_ * 4;
			_tmp94_ = height;
			_tmp95_ = self->priv->yView;
			_tmp96_ = self->zoom;
			_tmp97_ = spacing;
			y = fmodf ((_tmp94_ / 2) - (((gfloat) _tmp95_) * _tmp96_), _tmp97_);
			_tmp98_ = width;
			_tmp99_ = self->priv->xView;
			_tmp100_ = self->zoom;
			_tmp101_ = spacing;
			x = fmodf ((_tmp98_ / 2) - (((gfloat) _tmp99_) * _tmp100_), _tmp101_);
			_tmp102_ = gridContext;
			cairo_set_source_rgba (_tmp102_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 1.0);
			_tmp103_ = gridContext;
			_tmp104_ = spacing;
			_tmp105_ = g_new0 (gdouble, 2);
			_tmp105_[0] = 1.0;
			_tmp105_[1] = _tmp104_ - 1.0;
			_tmp106_ = _tmp105_;
			_tmp106__length1 = 2;
			cairo_set_dash (_tmp103_, _tmp106_, 2, (gdouble) 0);
			_tmp106_ = (g_free (_tmp106_), NULL);
			{
				gboolean _tmp107_ = FALSE;
				_tmp107_ = TRUE;
				while (TRUE) {
					gfloat _tmp110_ = 0.0F;
					gint _tmp111_ = 0;
					cairo_t* _tmp112_ = NULL;
					gfloat _tmp113_ = 0.0F;
					gfloat _tmp114_ = 0.0F;
					cairo_t* _tmp115_ = NULL;
					gint _tmp116_ = 0;
					gfloat _tmp117_ = 0.0F;
					cairo_t* _tmp118_ = NULL;
					if (!_tmp107_) {
						gfloat _tmp108_ = 0.0F;
						gfloat _tmp109_ = 0.0F;
						_tmp108_ = y;
						_tmp109_ = spacing;
						y = _tmp108_ + _tmp109_;
					}
					_tmp107_ = FALSE;
					_tmp110_ = y;
					_tmp111_ = height;
					if (!(_tmp110_ < ((gfloat) _tmp111_))) {
						break;
					}
					_tmp112_ = gridContext;
					_tmp113_ = x;
					_tmp114_ = y;
					cairo_move_to (_tmp112_, (gdouble) _tmp113_, (gdouble) _tmp114_);
					_tmp115_ = gridContext;
					_tmp116_ = width;
					_tmp117_ = y;
					cairo_line_to (_tmp115_, (gdouble) _tmp116_, (gdouble) _tmp117_);
					_tmp118_ = gridContext;
					cairo_stroke (_tmp118_);
				}
			}
			_tmp119_ = gridContext;
			cairo_set_dash (_tmp119_, NULL, 0, (gdouble) 0);
			_tmp120_ = gridContext;
			cairo_set_source_rgba (_tmp120_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
			_tmp121_ = width;
			_tmp122_ = self->priv->xView;
			_tmp123_ = self->zoom;
			x = (_tmp121_ / 2) - (_tmp122_ * _tmp123_);
			_tmp124_ = height;
			_tmp125_ = self->priv->yView;
			_tmp126_ = self->zoom;
			y = (_tmp124_ / 2) - (_tmp125_ * _tmp126_);
			_tmp127_ = gridContext;
			_tmp128_ = x;
			_tmp129_ = self->zoom;
			_tmp130_ = y;
			cairo_move_to (_tmp127_, (gdouble) (_tmp128_ - (10 * _tmp129_)), (gdouble) _tmp130_);
			_tmp131_ = gridContext;
			_tmp132_ = x;
			_tmp133_ = self->zoom;
			_tmp134_ = y;
			cairo_line_to (_tmp131_, (gdouble) (_tmp132_ + (10 * _tmp133_)), (gdouble) _tmp134_);
			_tmp135_ = gridContext;
			cairo_stroke (_tmp135_);
			_tmp136_ = gridContext;
			_tmp137_ = x;
			_tmp138_ = y;
			_tmp139_ = self->zoom;
			cairo_move_to (_tmp136_, (gdouble) _tmp137_, (gdouble) (_tmp138_ - (10 * _tmp139_)));
			_tmp140_ = gridContext;
			_tmp141_ = x;
			_tmp142_ = y;
			_tmp143_ = self->zoom;
			cairo_line_to (_tmp140_, (gdouble) _tmp141_, (gdouble) (_tmp142_ + (10 * _tmp143_)));
			_tmp144_ = gridContext;
			cairo_stroke (_tmp144_);
			_tmp145_ = gridContext;
			cairo_set_source_rgba (_tmp145_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
			_cairo_destroy0 (gridContext);
		}
		_tmp146_ = context;
		_tmp147_ = self->priv->gridCache;
		cairo_set_source_surface (_tmp146_, _tmp147_, (gdouble) 0, (gdouble) 0);
		_tmp148_ = context;
		cairo_paint (_tmp148_);
	} else {
		cairo_t* _tmp149_ = NULL;
		cairo_t* _tmp150_ = NULL;
		_tmp149_ = context;
		cairo_set_source_rgb (_tmp149_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp150_ = context;
		cairo_paint (_tmp150_);
	}
	_tmp151_ = context;
	_tmp152_ = width;
	_tmp153_ = height;
	cairo_translate (_tmp151_, (gdouble) (_tmp152_ / 2), (gdouble) (_tmp153_ / 2));
	_tmp154_ = context;
	_tmp155_ = self->zoom;
	_tmp156_ = self->zoom;
	cairo_scale (_tmp154_, (gdouble) _tmp155_, (gdouble) _tmp156_);
	_tmp157_ = context;
	_tmp158_ = self->priv->xView;
	_tmp159_ = self->priv->yView;
	cairo_translate (_tmp157_, (gdouble) (-_tmp158_), (gdouble) (-_tmp159_));
	_tmp160_ = context;
	cairo_set_source_rgb (_tmp160_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp161_ = self->priv->designer;
	_tmp162_ = context;
	_tmp163_ = self->priv->showHints;
	_tmp164_ = self->priv->highlightErrors;
	_tmp165_ = self->priv->colourBackgrounds;
	designer_render (_tmp161_, _tmp162_, _tmp163_, _tmp164_, _tmp165_);
	_tmp166_ = displayContext;
	cairo_paint (_tmp166_);
	_tmp167_ = offScreenSurface;
	_tmp168_ = _cairo_surface_reference0 (_tmp167_);
	_cairo_surface_destroy0 (self->priv->staticCache);
	self->priv->staticCache = _tmp168_;
	designer_window_render_overlay (self);
	result = FALSE;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (offScreenSurface);
	_cairo_destroy0 (displayContext);
	return result;
}


/**
 * Called by //print//. Renders the circuit for printing.
 */
void designer_window_print_render (DesignerWindow* self, GtkPrintContext* printContext, gint page_nr) {
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	GtkDrawingArea* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint pageWidth = 0;
	GtkPrintContext* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gint pageHeight = 0;
	GtkPrintContext* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble pageZoom = 0.0;
	cairo_t* context = NULL;
	GtkPrintContext* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	cairo_t* _tmp12_ = NULL;
	GtkPrintContext* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	gfloat _tmp17_ = 0.0F;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	FILE* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gdouble _tmp31_ = 0.0;
	cairo_t* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	cairo_t* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	Designer* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (printContext != NULL);
	_tmp0_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = printContext;
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
	pageWidth = (gint) _tmp7_;
	_tmp8_ = printContext;
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
	pageHeight = (gint) _tmp9_;
	_tmp10_ = printContext;
	_tmp11_ = gtk_print_context_get_cairo_context (_tmp10_);
	_tmp12_ = _cairo_reference0 (_tmp11_);
	context = _tmp12_;
	_tmp13_ = printContext;
	gtk_print_context_get_cairo_context (_tmp13_);
	_tmp14_ = context;
	cairo_set_source_rgb (_tmp14_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp15_ = context;
	cairo_paint (_tmp15_);
	_tmp16_ = context;
	cairo_set_line_width (_tmp16_, (gdouble) 1);
	_tmp17_ = self->zoom;
	pageZoom = (gdouble) _tmp17_;
	_tmp18_ = pageWidth;
	_tmp19_ = width;
	_tmp20_ = pageHeight;
	_tmp21_ = height;
	if ((_tmp18_ / _tmp19_) > (_tmp20_ / _tmp21_)) {
		gdouble _tmp22_ = 0.0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		_tmp22_ = pageZoom;
		_tmp23_ = pageHeight;
		_tmp24_ = height;
		pageZoom = (_tmp22_ * ((gdouble) _tmp23_)) / ((gdouble) _tmp24_);
	} else {
		gdouble _tmp25_ = 0.0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		_tmp25_ = pageZoom;
		_tmp26_ = pageWidth;
		_tmp27_ = width;
		pageZoom = (_tmp25_ * ((gdouble) _tmp26_)) / ((gdouble) _tmp27_);
	}
	_tmp28_ = stdout;
	_tmp29_ = pageWidth;
	_tmp30_ = pageHeight;
	_tmp31_ = pageZoom;
	fprintf (_tmp28_, "Printing design (render size = %i x %i, scale = %f)\n", _tmp29_, _tmp30_, _tmp31_);
	_tmp32_ = context;
	_tmp33_ = pageWidth;
	_tmp34_ = pageHeight;
	cairo_translate (_tmp32_, (gdouble) (_tmp33_ / 2), (gdouble) (_tmp34_ / 2));
	_tmp35_ = context;
	_tmp36_ = pageZoom;
	_tmp37_ = pageZoom;
	cairo_scale (_tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = context;
	_tmp39_ = self->priv->xView;
	_tmp40_ = self->priv->yView;
	cairo_translate (_tmp38_, (gdouble) (-_tmp39_), (gdouble) (-_tmp40_));
	_tmp41_ = self->priv->designer;
	_tmp42_ = context;
	_tmp43_ = self->priv->colourBackgrounds;
	designer_render (_tmp41_, _tmp42_, FALSE, FALSE, _tmp43_);
	_cairo_destroy0 (context);
}


static void _designer_window_file_render_image_exporter_renderer (const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution, gpointer self) {
	designer_window_file_render ((DesignerWindow*) self, filename, imageFormat, resolution);
}


void designer_window_export_png (DesignerWindow* self) {
	g_return_if_fail (self != NULL);
	image_exporter_export_png (_designer_window_file_render_image_exporter_renderer, self);
}


void designer_window_export_pdf (DesignerWindow* self) {
	g_return_if_fail (self != NULL);
	image_exporter_export_pdf (_designer_window_file_render_image_exporter_renderer, self);
}


void designer_window_export_svg (DesignerWindow* self) {
	g_return_if_fail (self != NULL);
	image_exporter_export_svg (_designer_window_file_render_image_exporter_renderer, self);
}


/**
 * Passed to ImageExporter as a delegate and called by an export
 * function to render to a file.
 */
static void designer_window_file_render (DesignerWindow* self, const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution) {
	cairo_surface_t* surface = NULL;
	GtkAllocation areaAllocation = {0};
	GtkDrawingArea* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	gint height = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint imageWidth = 0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint imageHeight = 0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gdouble imageZoom = 0.0;
	gfloat _tmp10_ = 0.0F;
	gdouble _tmp11_ = 0.0;
	ImageExporterImageFormat _tmp12_ = 0;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	ImageExporterImageFormat _tmp30_ = 0;
	cairo_t* _tmp37_ = NULL;
	FILE* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gdouble _tmp41_ = 0.0;
	cairo_t* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	cairo_t* _tmp45_ = NULL;
	gdouble _tmp46_ = 0.0;
	gdouble _tmp47_ = 0.0;
	cairo_t* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	Designer* _tmp51_ = NULL;
	cairo_t* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	ImageExporterImageFormat _tmp54_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = width;
	_tmp7_ = resolution;
	imageWidth = (gint) (((gdouble) _tmp6_) * _tmp7_);
	_tmp8_ = height;
	_tmp9_ = resolution;
	imageHeight = (gint) (((gdouble) _tmp8_) * _tmp9_);
	_tmp10_ = self->zoom;
	_tmp11_ = resolution;
	imageZoom = _tmp10_ * _tmp11_;
	_tmp12_ = imageFormat;
	switch (_tmp12_) {
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_RGB:
		{
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			cairo_surface_t* _tmp15_ = NULL;
			_tmp13_ = imageWidth;
			_tmp14_ = imageHeight;
			_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, _tmp13_, _tmp14_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp15_;
			break;
		}
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB:
		{
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			cairo_surface_t* _tmp18_ = NULL;
			_tmp16_ = imageWidth;
			_tmp17_ = imageHeight;
			_tmp18_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp16_, _tmp17_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp18_;
			break;
		}
		case IMAGE_EXPORTER_IMAGE_FORMAT_PDF:
		{
			const gchar* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			cairo_surface_t* _tmp22_ = NULL;
			_tmp19_ = filename;
			_tmp20_ = imageWidth;
			_tmp21_ = imageHeight;
			_tmp22_ = cairo_pdf_surface_create (_tmp19_, (gdouble) _tmp20_, (gdouble) _tmp21_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp22_;
			break;
		}
		case IMAGE_EXPORTER_IMAGE_FORMAT_SVG:
		case IMAGE_EXPORTER_IMAGE_FORMAT_SVG_CLEAR:
		{
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			cairo_surface_t* _tmp26_ = NULL;
			_tmp23_ = filename;
			_tmp24_ = imageWidth;
			_tmp25_ = imageHeight;
			_tmp26_ = cairo_svg_surface_create (_tmp23_, (gdouble) _tmp24_, (gdouble) _tmp25_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp26_;
			break;
		}
		default:
		{
			FILE* _tmp27_ = NULL;
			_tmp27_ = stderr;
			fprintf (_tmp27_, "Error: Unknown Export Format!\n");
			_cairo_surface_destroy0 (surface);
			return;
		}
	}
	_tmp28_ = surface;
	_tmp29_ = cairo_create (_tmp28_);
	context = _tmp29_;
	_tmp30_ = imageFormat;
	switch (_tmp30_) {
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB:
		case IMAGE_EXPORTER_IMAGE_FORMAT_SVG_CLEAR:
		{
			cairo_t* _tmp31_ = NULL;
			cairo_t* _tmp32_ = NULL;
			cairo_t* _tmp33_ = NULL;
			cairo_t* _tmp34_ = NULL;
			_tmp31_ = context;
			cairo_set_operator (_tmp31_, CAIRO_OPERATOR_SOURCE);
			_tmp32_ = context;
			cairo_set_source_rgba (_tmp32_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp33_ = context;
			cairo_paint (_tmp33_);
			_tmp34_ = context;
			cairo_set_operator (_tmp34_, CAIRO_OPERATOR_OVER);
			break;
		}
		default:
		{
			cairo_t* _tmp35_ = NULL;
			cairo_t* _tmp36_ = NULL;
			_tmp35_ = context;
			cairo_set_source_rgb (_tmp35_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
			_tmp36_ = context;
			cairo_paint (_tmp36_);
			break;
		}
	}
	_tmp37_ = context;
	cairo_set_line_width (_tmp37_, (gdouble) 1);
	_tmp38_ = stdout;
	_tmp39_ = imageWidth;
	_tmp40_ = imageHeight;
	_tmp41_ = imageZoom;
	fprintf (_tmp38_, "Exporting design (render size = %i x %i, scale = %f)\n", _tmp39_, _tmp40_, _tmp41_);
	_tmp42_ = context;
	_tmp43_ = imageWidth;
	_tmp44_ = imageHeight;
	cairo_translate (_tmp42_, (gdouble) (_tmp43_ / 2), (gdouble) (_tmp44_ / 2));
	_tmp45_ = context;
	_tmp46_ = imageZoom;
	_tmp47_ = imageZoom;
	cairo_scale (_tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = context;
	_tmp49_ = self->priv->xView;
	_tmp50_ = self->priv->yView;
	cairo_translate (_tmp48_, (gdouble) (-_tmp49_), (gdouble) (-_tmp50_));
	_tmp51_ = self->priv->designer;
	_tmp52_ = context;
	_tmp53_ = self->priv->colourBackgrounds;
	designer_render (_tmp51_, _tmp52_, FALSE, FALSE, _tmp53_);
	_tmp54_ = imageFormat;
	switch (_tmp54_) {
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_RGB:
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB:
		{
			cairo_surface_t* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			_tmp55_ = surface;
			_tmp56_ = filename;
			cairo_surface_write_to_png (_tmp55_, _tmp56_);
			break;
		}
		default:
		break;
	}
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
}


/**
 * Hides the window and unregisters it from the list of visible
 * DesignerWindows. Destroys only if there is no designer.
 */
static gboolean designer_window_close_window (DesignerWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Project* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp2_ = self->priv->project;
		_tmp3_ = designer_window_count_project_windows (_tmp2_);
		if (_tmp3_ == 1) {
			gboolean _tmp4_ = FALSE;
			_tmp4_ = designer_window_comfirm_close (self);
			if (!_tmp4_) {
				result = FALSE;
				return result;
			}
		}
	}
	_tmp5_ = designer_window_get_hasDesigner (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		designer_window_unregister_designerwindow (self);
		gtk_widget_hide ((GtkWidget*) self);
		_cairo_surface_destroy0 (self->priv->gridCache);
		self->priv->gridCache = NULL;
	} else {
		designer_window_force_destroy_window (self);
	}
	result = TRUE;
	return result;
}


static gboolean designer_window_comfirm_close (DesignerWindow* self) {
	gboolean result = FALSE;
	GtkMessageDialog* messageDialog = NULL;
	Project* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->project;
	_tmp1_ = project_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "You are about to close project \"%s\".\n" \
"Do you wish to save this project?", _tmp2_);
	g_object_ref_sink (_tmp3_);
	messageDialog = _tmp3_;
	_tmp4_ = messageDialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, GTK_STOCK_YES, (gint) GTK_RESPONSE_YES);
	_tmp5_ = messageDialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp5_, GTK_STOCK_NO, (gint) GTK_RESPONSE_NO);
	_tmp6_ = messageDialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp6_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp7_ = messageDialog;
	_tmp8_ = gtk_dialog_run ((GtkDialog*) _tmp7_);
	switch (_tmp8_) {
		case GTK_RESPONSE_CANCEL:
		{
			GtkMessageDialog* _tmp9_ = NULL;
			_tmp9_ = messageDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp9_);
			result = FALSE;
			_g_object_unref0 (messageDialog);
			return result;
		}
		case GTK_RESPONSE_NO:
		{
			GtkMessageDialog* _tmp10_ = NULL;
			_tmp10_ = messageDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp10_);
			result = TRUE;
			_g_object_unref0 (messageDialog);
			return result;
		}
		case GTK_RESPONSE_YES:
		{
			GtkMessageDialog* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp11_ = messageDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp11_);
			_tmp12_ = designer_window_do_save_project (self, FALSE);
			result = _tmp12_;
			_g_object_unref0 (messageDialog);
			return result;
		}
		default:
		{
			GtkMessageDialog* _tmp13_ = NULL;
			_tmp13_ = messageDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
			result = FALSE;
			_g_object_unref0 (messageDialog);
			return result;
		}
	}
	_g_object_unref0 (messageDialog);
}


void designer_window_force_destroy_window (DesignerWindow* self) {
	FILE* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Designer Window destroyed (not hidden)\n");
	_project_unref0 (self->priv->project);
	self->priv->project = NULL;
	_designer_unref0 (self->priv->designer);
	self->priv->designer = NULL;
	designer_window_set_hasDesigner (self, FALSE);
	designer_window_set_hasProject (self, FALSE);
	designer_window_update_custom_menu (self);
	designer_window_update_plugin_menu (self);
	designer_window_unregister_designerwindow (self);
	gtk_widget_destroy ((GtkWidget*) self);
}


static gboolean designer_window_remove_component (DesignerWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = designer_window_get_hasDesigner (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = basic_dialog_ask_proceed ((GtkWindow*) self, "Are you sure you want to remove this component from the project?\n" \
"All unsaved progress will be lost.", "Remove", "Keep");
	if (_tmp2_ == ((gint) GTK_RESPONSE_OK)) {
		Project* _tmp3_ = NULL;
		Designer* _tmp4_ = NULL;
		CustomComponentDef* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp3_ = self->priv->project;
		_tmp4_ = self->priv->designer;
		_tmp5_ = _tmp4_->customComponentDef;
		_tmp6_ = project_remove_component (_tmp3_, _tmp5_);
		if (_tmp6_ == 0) {
			Project* _tmp7_ = NULL;
			Project* _tmp8_ = NULL;
			Project* _tmp9_ = NULL;
			Designer* _tmp10_ = NULL;
			_tmp7_ = self->priv->project;
			project_update_custom_menus (_tmp7_);
			_tmp8_ = self->priv->project;
			project_update_plugin_menus (_tmp8_);
			_tmp9_ = self->priv->project;
			_tmp10_ = self->priv->designer;
			project_unregister_designer (_tmp9_, _tmp10_);
			designer_window_set_hasDesigner (self, FALSE);
			designer_window_update_title (self);
			designer_window_render_design (self, NULL);
		}
	}
	result = FALSE;
	return result;
}


static gboolean designer_window_remove_plugin_component (DesignerWindow* self, PluginComponentDef* pluginComponentDef) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pluginComponentDef != NULL, FALSE);
	_tmp0_ = designer_window_get_hasProject (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = basic_dialog_ask_proceed ((GtkWindow*) self, "Are you sure you want to remove this plugin component from the project" \
"?\n" \
"This will only dissociate the plugin with the project. The plugin will" \
" remain loaded until SmartSim is closed.\n", "Remove", "Keep");
	if (_tmp2_ == ((gint) GTK_RESPONSE_OK)) {
		Project* _tmp3_ = NULL;
		PluginComponentDef* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp3_ = self->priv->project;
		_tmp4_ = pluginComponentDef;
		_tmp5_ = project_remove_plugin_component (_tmp3_, _tmp4_);
		if (_tmp5_ == 0) {
			Project* _tmp6_ = NULL;
			_tmp6_ = self->priv->project;
			project_update_plugin_menus (_tmp6_);
		}
	}
	result = FALSE;
	return result;
}


/**
 * Called when user clicks Run>>Check circuit validity. Shows a
 * message dialog stating whether or not the circuit is valid.
 */
static void designer_window_validate_circuit (DesignerWindow* self) {
	CompiledCircuit* compiledCircuit = NULL;
	Project* _tmp0_ = NULL;
	CompiledCircuit* _tmp1_ = NULL;
	CompiledCircuit* _tmp2_ = NULL;
	CompiledCircuit* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->project;
	_tmp1_ = project_validate (_tmp0_);
	compiledCircuit = _tmp1_;
	_tmp2_ = compiledCircuit;
	if (_tmp2_ == NULL) {
		FILE* _tmp3_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "Cannot validate.\n");
		_compiled_circuit_unref0 (compiledCircuit);
		return;
	}
	_tmp4_ = compiledCircuit;
	_tmp5_ = compiled_circuit_get_errorMessage (_tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp6_, "") != 0) {
		FILE* _tmp7_ = NULL;
		FILE* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		CompiledCircuit* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp7_ = stdout;
		fprintf (_tmp7_, "Circuit is invalid!\n");
		_tmp8_ = stdout;
		fflush (_tmp8_);
		_tmp9_ = stderr;
		_tmp10_ = compiledCircuit;
		_tmp11_ = compiled_circuit_get_errorMessage (_tmp10_);
		_tmp12_ = _tmp11_;
		fprintf (_tmp9_, "Error Messages:\n%s\n", _tmp12_);
	} else {
		FILE* _tmp13_ = NULL;
		_tmp13_ = stdout;
		fprintf (_tmp13_, "Circuit validated with no errors\n");
	}
	designer_window_render_design (self, NULL);
	_compiled_circuit_unref0 (compiledCircuit);
}


/**
 * Called when the user clicks Run>>Run. Starts the circuit
 * simulating.
 */
static void designer_window_run_circuit (DesignerWindow* self) {
	Project* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean startNow = FALSE;
	GtkCheckMenuItem* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	CompiledCircuit* compiledCircuit = NULL;
	Project* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	CompiledCircuit* _tmp7_ = NULL;
	CompiledCircuit* _tmp8_ = NULL;
	CompiledCircuit* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->project;
	_tmp1_ = _tmp0_->running;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->menuRunStartpaused;
	_tmp3_ = gtk_check_menu_item_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	startNow = !_tmp4_;
	_tmp5_ = self->priv->project;
	_tmp6_ = startNow;
	_tmp7_ = project_run (_tmp5_, &_tmp6_);
	compiledCircuit = _tmp7_;
	_tmp8_ = compiledCircuit;
	if (_tmp8_ == NULL) {
		FILE* _tmp9_ = NULL;
		_tmp9_ = stderr;
		fprintf (_tmp9_, "Run failure.\n");
		self->priv->colourBackgrounds = FALSE;
		designer_window_render_design (self, NULL);
		_compiled_circuit_unref0 (compiledCircuit);
		return;
	}
	_tmp10_ = compiledCircuit;
	_tmp11_ = compiled_circuit_get_errorMessage (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		FILE* _tmp13_ = NULL;
		FILE* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		CompiledCircuit* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp13_ = stdout;
		fprintf (_tmp13_, "Circuit is invalid!\n");
		_tmp14_ = stdout;
		fflush (_tmp14_);
		_tmp15_ = stderr;
		_tmp16_ = compiledCircuit;
		_tmp17_ = compiled_circuit_get_errorMessage (_tmp16_);
		_tmp18_ = _tmp17_;
		fprintf (_tmp15_, "Error Messages:\n%s\n", _tmp18_);
		self->priv->colourBackgrounds = FALSE;
	} else {
		FILE* _tmp19_ = NULL;
		GtkCheckMenuItem* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "Circuit started with no errors\n");
		_tmp20_ = self->priv->menuViewColourbackgrounds;
		_tmp21_ = gtk_check_menu_item_get_active (_tmp20_);
		_tmp22_ = _tmp21_;
		self->priv->colourBackgrounds = _tmp22_;
	}
	designer_window_render_design (self, NULL);
	_compiled_circuit_unref0 (compiledCircuit);
}


/**
 * Called when the user clicks Component>>Set as root. Sets the
 * component open in the designer as root.
 */
void designer_window_set_root_component (DesignerWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = designer_window_get_hasDesigner (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = designer_window_get_hasProject (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Project* _tmp5_ = NULL;
		Designer* _tmp6_ = NULL;
		CustomComponentDef* _tmp7_ = NULL;
		_tmp5_ = self->priv->project;
		_tmp6_ = self->priv->designer;
		_tmp7_ = _tmp6_->customComponentDef;
		project_set_root_component (_tmp5_, _tmp7_);
	}
}


/**
 * Registers the window.
 */
static void designer_window_register_designerwindow (DesignerWindow* self) {
	g_return_if_fail (self != NULL);
	designer_window_register (self);
}


/**
 * Unregisters the window.
 */
static void designer_window_unregister_designerwindow (DesignerWindow* self) {
	g_return_if_fail (self != NULL);
	designer_window_unregister (self);
}


static gboolean designer_window_get_hasDesigner (DesignerWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hasDesigner;
	result = _tmp0_;
	return result;
}


static void designer_window_set_hasDesigner (DesignerWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GtkMenuItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkMenuItem* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkMenuItem* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkMenuItem* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GtkMenuItem* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hasDesigner = _tmp0_;
	_tmp1_ = self->priv->menuFileSave;
	_tmp2_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->menuFileSaveas;
	_tmp4_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->menuFilePrint;
	_tmp6_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
	_tmp7_ = self->priv->menuFileExport;
	_tmp8_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->menuFileRemovecomponent;
	_tmp10_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_);
	_tmp11_ = self->priv->menuComponent;
	_tmp12_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp12_);
}


static gboolean designer_window_get_hasProject (DesignerWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hasProject;
	result = _tmp0_;
	return result;
}


static void designer_window_set_hasProject (DesignerWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	GtkMenuItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkMenuItem* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkMenuItem* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkMenuItem* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GtkMenuItem* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkMenuItem* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkMenuItem* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_hasProject = _tmp0_;
	_tmp1_ = self->priv->menuFileNewcomponent;
	_tmp2_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->menuFileOpen;
	_tmp4_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->menuFileOpenplugincomponent;
	_tmp6_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
	_tmp7_ = self->priv->menuFileSaveproject;
	_tmp8_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->menuFileSaveasproject;
	_tmp10_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_);
	_tmp11_ = self->priv->menuRun;
	_tmp12_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp12_);
	_tmp13_ = self->priv->menuProject;
	_tmp14_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->menuWindows;
	_tmp16_ = value;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, _tmp16_);
	designer_window_update_custom_menu (self);
	designer_window_update_plugin_menu (self);
}


static void designer_window_class_init (DesignerWindowClass * klass) {
	designer_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesignerWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_designer_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_designer_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = designer_window_finalize;
}


static void designer_window_instance_init (DesignerWindow * self) {
	gchar* _tmp0_ = NULL;
	self->priv = DESIGNER_WINDOW_GET_PRIVATE (self);
	self->priv->_hasDesigner = FALSE;
	self->priv->_hasProject = FALSE;
	_tmp0_ = g_strdup ("");
	self->componentFileName = _tmp0_;
	self->gridSize = 5;
	self->priv->xView = 0;
	self->priv->yView = 0;
	self->zoom = (gfloat) 1;
	self->showGrid = TRUE;
	self->liveScrollUpdate = FALSE;
	self->shadowComponent = FALSE;
	self->priv->highlightErrors = TRUE;
	self->priv->colourBackgrounds = TRUE;
	self->priv->showHints = TRUE;
	self->priv->autoBind = TRUE;
	self->priv->diagonalThreshold = 0.2f;
	self->priv->mouseMode = DESIGNER_WINDOW_MOUSE_MODE_SELECT;
}


static void designer_window_finalize (GObject* obj) {
	DesignerWindow * self;
	FILE* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESIGNER_WINDOW, DesignerWindow);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Designer Window Destroyed\n");
	_g_object_unref0 (self->priv->vBox);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->menuFile);
	_g_object_unref0 (self->priv->menuFileMenu);
	_g_object_unref0 (self->priv->menuFileNewproject);
	_g_object_unref0 (self->priv->menuFileNewcomponent);
	_g_object_unref0 (self->priv->menuFileSeparator1);
	_g_object_unref0 (self->priv->menuFileSaveproject);
	_g_object_unref0 (self->priv->menuFileSaveasproject);
	_g_object_unref0 (self->priv->menuFileSeparator2);
	_g_object_unref0 (self->priv->menuFileOpen);
	_g_object_unref0 (self->priv->menuFileOpenplugincomponent);
	_g_object_unref0 (self->priv->menuFileSeparator3);
	_g_object_unref0 (self->priv->menuFileOpenproject);
	_g_object_unref0 (self->priv->menuFileSeparator4);
	_g_object_unref0 (self->priv->menuFileSave);
	_g_object_unref0 (self->priv->menuFileSaveas);
	_g_object_unref0 (self->priv->menuFileSeparator5);
	_g_object_unref0 (self->priv->menuFileExport);
	_g_object_unref0 (self->priv->menuFileExportMenu);
	_g_object_unref0 (self->priv->menuFileExportPng);
	_g_object_unref0 (self->priv->menuFileExportPdf);
	_g_object_unref0 (self->priv->menuFileExportSvg);
	_g_object_unref0 (self->priv->menuFileSeparator6);
	_g_object_unref0 (self->priv->menuFilePagesetup);
	_g_object_unref0 (self->priv->menuFilePrint);
	_g_object_unref0 (self->priv->menuFileSeparator7);
	_g_object_unref0 (self->priv->menuFileRemovecomponent);
	_g_object_unref0 (self->priv->menuFileRemoveplugincomponent);
	_g_object_unref0 (self->priv->menuFileRemoveplugincomponentMenu);
	self->priv->menuFileRemoveplugincomponentComponents = (_vala_array_free (self->priv->menuFileRemoveplugincomponentComponents, self->priv->menuFileRemoveplugincomponentComponents_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->menuFileSeparator8);
	_g_object_unref0 (self->priv->menuFileExit);
	_g_object_unref0 (self->priv->menuView);
	_g_object_unref0 (self->priv->menuViewMenu);
	_g_object_unref0 (self->priv->menuViewFitdesign);
	_g_object_unref0 (self->priv->menuViewSeparator1);
	_g_object_unref0 (self->priv->menuViewShowgrid);
	_g_object_unref0 (self->priv->menuViewLivescrollupdate);
	_g_object_unref0 (self->priv->menuViewShadowcomponent);
	_g_object_unref0 (self->priv->menuViewColourbackgrounds);
	_g_object_unref0 (self->priv->menuViewHighlighterrors);
	_g_object_unref0 (self->priv->menuViewShowdesignerhints);
	_g_object_unref0 (self->priv->menuEdit);
	_g_object_unref0 (self->priv->menuEditMenu);
	_g_object_unref0 (self->priv->menuEditAutobind);
	_g_object_unref0 (self->priv->menuRun);
	_g_object_unref0 (self->priv->menuRunMenu);
	_g_object_unref0 (self->priv->menuRunRun);
	_g_object_unref0 (self->priv->menuRunCheckcircuit);
	_g_object_unref0 (self->priv->menuRunSeparator1);
	_g_object_unref0 (self->priv->menuRunStartpaused);
	_g_object_unref0 (self->priv->menuProject);
	_g_object_unref0 (self->priv->menuProjectMenu);
	_g_object_unref0 (self->priv->menuProjectStatistics);
	_g_object_unref0 (self->priv->menuProjectOptions);
	_g_object_unref0 (self->priv->menuComponent);
	_g_object_unref0 (self->priv->menuComponentMenu);
	_g_object_unref0 (self->priv->menuComponentMakeroot);
	_g_object_unref0 (self->priv->menuComponentCustomise);
	_g_object_unref0 (self->priv->menuWindows);
	_g_object_unref0 (self->priv->menuWindowsMenu);
	self->priv->menuWindowsComponents = (_vala_array_free (self->priv->menuWindowsComponents, self->priv->menuWindowsComponents_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->menuHelp);
	_g_object_unref0 (self->priv->menuHelpMenu);
	_g_object_unref0 (self->priv->menuHelpAbout);
	_g_object_unref0 (self->priv->hiddenRadioToolButton);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->toolScroll);
	_g_object_unref0 (self->priv->toolScrollImage);
	_g_object_unref0 (self->priv->toolZoom);
	_g_object_unref0 (self->priv->toolZoomImage);
	_g_object_unref0 (self->priv->toolSeparator1);
	_g_object_unref0 (self->priv->toolCursor);
	_g_object_unref0 (self->priv->toolCursorImage);
	_g_object_unref0 (self->priv->toolMove);
	_g_object_unref0 (self->priv->toolMoveImage);
	_g_object_unref0 (self->priv->toolOrientate);
	_g_object_unref0 (self->priv->toolOrientateImage);
	_g_object_unref0 (self->priv->toolDelete);
	_g_object_unref0 (self->priv->toolDeleteImage);
	_g_object_unref0 (self->priv->toolAdjust);
	_g_object_unref0 (self->priv->toolAdjustImage);
	_g_object_unref0 (self->priv->toolSeparator2);
	_g_object_unref0 (self->priv->toolAnnotate);
	_g_object_unref0 (self->priv->toolAnnotateImage);
	_g_object_unref0 (self->priv->toolWire);
	_g_object_unref0 (self->priv->toolWireImage);
	_g_object_unref0 (self->priv->toolBind);
	_g_object_unref0 (self->priv->toolBindImage);
	_g_object_unref0 (self->priv->toolTag);
	_g_object_unref0 (self->priv->toolTagImage);
	_g_object_unref0 (self->priv->toolInvert);
	_g_object_unref0 (self->priv->toolInvertImage);
	_g_object_unref0 (self->priv->toolSeparator3);
	_g_object_unref0 (self->priv->toolCustoms);
	_g_object_unref0 (self->priv->toolCustomsImage);
	_g_object_unref0 (self->priv->toolCustomsMenu);
	self->priv->toolCustomsMenuComponents = (_vala_array_free (self->priv->toolCustomsMenuComponents, self->priv->toolCustomsMenuComponents_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->toolPlugins);
	_g_object_unref0 (self->priv->toolPluginsImage);
	_g_object_unref0 (self->priv->toolPluginsMenu);
	self->priv->toolPluginsMenuComponents = (_vala_array_free (self->priv->toolPluginsMenuComponents, self->priv->toolPluginsMenuComponents_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->toolSeparator4);
	self->priv->toolStandards = (_vala_array_free (self->priv->toolStandards, self->priv->toolStandards_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->toolStandardImages = (_vala_array_free (self->priv->toolStandardImages, self->priv->toolStandardImages_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->display);
	_g_object_unref0 (self->priv->anysspFileFilter);
	_g_object_unref0 (self->priv->anysscFileFilter);
	_g_object_unref0 (self->priv->anyssxFileFilter);
	_g_object_unref0 (self->priv->sspFileFilter);
	_g_object_unref0 (self->priv->sscFileFilter);
	_g_object_unref0 (self->priv->sscxmlFileFilter);
	_g_object_unref0 (self->priv->xmlFileFilter);
	_g_object_unref0 (self->priv->ssxFileFilter);
	_g_object_unref0 (self->priv->pngFileFilter);
	_g_object_unref0 (self->priv->pdfFileFilter);
	_g_object_unref0 (self->priv->svgFileFilter);
	_g_object_unref0 (self->priv->anyFileFilter);
	_g_object_unref0 (self->priv->printSettings);
	_g_object_unref0 (self->priv->pageSetup);
	_cairo_surface_destroy0 (self->priv->gridCache);
	_cairo_surface_destroy0 (self->priv->staticCache);
	self->priv->standardComponentDefs = (_vala_array_free (self->priv->standardComponentDefs, self->priv->standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	_designer_unref0 (self->priv->designer);
	_project_unref0 (self->priv->project);
	_g_free0 (self->componentFileName);
	G_OBJECT_CLASS (designer_window_parent_class)->finalize (obj);
}


/**
 * The primary interface for the user. Used to design components and
 * navigate through the application.
 */
GType designer_window_get_type (void) {
	static volatile gsize designer_window_type_id__volatile = 0;
	if (g_once_init_enter (&designer_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesignerWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) designer_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesignerWindow), 0, (GInstanceInitFunc) designer_window_instance_init, NULL };
		GType designer_window_type_id;
		designer_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "DesignerWindow", &g_define_type_info, 0);
		g_once_init_leave (&designer_window_type_id__volatile, designer_window_type_id);
	}
	return designer_window_type_id__volatile;
}


static void _vala_designer_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesignerWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DESIGNER_WINDOW, DesignerWindow);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_designer_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesignerWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DESIGNER_WINDOW, DesignerWindow);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



