/* graphic.c generated by valac 0.24.0, the Vala compiler
 * generated from graphic.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: graphic.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <librsvg/rsvg.h>
#include <stdio.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;
typedef struct _GraphicPrivate GraphicPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _graphic_unref0(var) ((var == NULL) ? NULL : (var = (graphic_unref (var), NULL)))
typedef struct _ParamSpecGraphic ParamSpecGraphic;

typedef enum  {
	GRAPHIC_LOAD_ERROR_FILE
} GraphicLoadError;
#define GRAPHIC_LOAD_ERROR graphic_load_error_quark ()
struct _Graphic {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GraphicPrivate * priv;
	gchar* filename;
	gchar* svgFilename;
	gchar* infoFilename;
};

struct _GraphicClass {
	GTypeClass parent_class;
	void (*finalize) (Graphic *self);
};

struct _GraphicPrivate {
	RsvgHandle* svgHandle;
	gint width;
	gint height;
	gint xCentre;
	gint yCentre;
};

struct _ParamSpecGraphic {
	GParamSpec parent_instance;
};


static gpointer graphic_parent_class = NULL;
extern Graphic* graphic_placeHolder;
Graphic* graphic_placeHolder = NULL;

GQuark graphic_load_error_quark (void);
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
#define GRAPHIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GRAPHIC, GraphicPrivate))
enum  {
	GRAPHIC_DUMMY_PROPERTY
};
Graphic* graphic_new_from_file (const gchar* filename, GError** error);
Graphic* graphic_construct_from_file (GType object_type, const gchar* filename, GError** error);
gint graphic_load_info (Graphic* self, const gchar* filename);
gint graphic_load_svg (Graphic* self, const gchar* filename);
void graphic_render (Graphic* self, cairo_t* context);
Graphic* graphic_new (void);
Graphic* graphic_construct (GType object_type);
static void graphic_finalize (Graphic* obj);


GQuark graphic_load_error_quark (void) {
	return g_quark_from_static_string ("graphic_load_error-quark");
}


/**
 * Loads a graphic from the files //filename//.info and
 * //filename//.svg.
 */
Graphic* graphic_construct_from_file (GType object_type, const gchar* filename, GError** error) {
	Graphic* self = NULL;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (Graphic*) g_type_create_instance (object_type);
	_tmp0_ = stdout;
	_tmp1_ = filename;
	fprintf (_tmp0_, "Loading graphic \"%s\"\n", _tmp1_);
	_tmp2_ = filename;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->filename);
	self->filename = _tmp3_;
	_tmp4_ = filename;
	_tmp5_ = g_strconcat (_tmp4_, ".info", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = graphic_load_info (self, _tmp6_);
	_tmp8_ = _tmp7_ != 0;
	_g_free0 (_tmp6_);
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		_tmp9_ = filename;
		_tmp10_ = g_strconcat ("Unable to open graphic file \"", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, ".info\".", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_error_new_literal (GRAPHIC_LOAD_ERROR, GRAPHIC_LOAD_ERROR_FILE, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == GRAPHIC_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_graphic_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = filename;
	_tmp17_ = g_strconcat (_tmp16_, ".svg", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = graphic_load_svg (self, _tmp18_);
	_tmp20_ = _tmp19_ != 0;
	_g_free0 (_tmp18_);
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
		_tmp21_ = filename;
		_tmp22_ = g_strconcat ("Unable to open svg file \"", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, ".svg\".", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (GRAPHIC_LOAD_ERROR, GRAPHIC_LOAD_ERROR_FILE, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_inner_error_ = _tmp27_;
		if (_inner_error_->domain == GRAPHIC_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_graphic_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


Graphic* graphic_new_from_file (const gchar* filename, GError** error) {
	return graphic_construct_from_file (TYPE_GRAPHIC, filename, error);
}


/**
 * Reads an info file, which describes how to use the svg image
 * (describing its centre, width...).
 */
gint graphic_load_info (Graphic* self, const gchar* filename) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	xmlDoc* xmldoc = NULL;
	xmlNode* xmlroot = NULL;
	xmlNode* xmlnode = NULL;
	const gchar* _tmp4_ = NULL;
	xmlDoc* _tmp5_ = NULL;
	xmlDoc* _tmp6_ = NULL;
	xmlDoc* _tmp10_ = NULL;
	xmlNode* _tmp11_ = NULL;
	xmlNode* _tmp12_ = NULL;
	xmlNode* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	xmlDoc* _tmp72_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (filename != NULL, 0);
	_tmp0_ = stdout;
	_tmp1_ = filename;
	fprintf (_tmp0_, "Loading graphic info \"%s\"\n", _tmp1_);
	_tmp2_ = filename;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->infoFilename);
	self->infoFilename = _tmp3_;
	_tmp4_ = filename;
	_tmp5_ = xmlParseFile (_tmp4_);
	xmldoc = _tmp5_;
	_tmp6_ = xmldoc;
	if (_tmp6_ == NULL) {
		FILE* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = filename;
		fprintf (_tmp7_, "Error loading info xml file \"%s\".\n", _tmp8_);
		_tmp9_ = stdout;
		fprintf (_tmp9_, "File inaccessible.\n");
		result = 1;
		return result;
	}
	_tmp10_ = xmldoc;
	_tmp11_ = xmlDocGetRootElement (_tmp10_);
	xmlroot = _tmp11_;
	_tmp12_ = xmlroot;
	if (_tmp12_ == NULL) {
		FILE* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = filename;
		fprintf (_tmp13_, "Error loading info xml file \"%s\".\n", _tmp14_);
		_tmp15_ = stdout;
		fprintf (_tmp15_, "File is empty.\n");
		result = 2;
		return result;
	}
	_tmp16_ = xmlroot;
	_tmp17_ = _tmp16_->name;
	if (g_strcmp0 (_tmp17_, "graphic_info") != 0) {
		FILE* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		FILE* _tmp20_ = NULL;
		xmlNode* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp18_ = stdout;
		_tmp19_ = filename;
		fprintf (_tmp18_, "Error loading info xml file \"%s\".\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = xmlroot;
		_tmp22_ = _tmp21_->name;
		fprintf (_tmp20_, "Wanted \"graphic_info\" info, but got \"%s\"\n", _tmp22_);
		result = 3;
		return result;
	}
	{
		xmlNode* _tmp23_ = NULL;
		xmlNode* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		_tmp23_ = xmlroot;
		_tmp24_ = _tmp23_->children;
		xmlnode = _tmp24_;
		_tmp25_ = TRUE;
		while (TRUE) {
			xmlNode* _tmp28_ = NULL;
			xmlNode* _tmp29_ = NULL;
			xmlElementType _tmp30_ = 0;
			xmlNode* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			GQuark _tmp35_ = 0U;
			static GQuark _tmp34_label0 = 0;
			static GQuark _tmp34_label1 = 0;
			static GQuark _tmp34_label2 = 0;
			if (!_tmp25_) {
				xmlNode* _tmp26_ = NULL;
				xmlNode* _tmp27_ = NULL;
				_tmp26_ = xmlnode;
				_tmp27_ = _tmp26_->next;
				xmlnode = _tmp27_;
			}
			_tmp25_ = FALSE;
			_tmp28_ = xmlnode;
			if (!(_tmp28_ != NULL)) {
				break;
			}
			_tmp29_ = xmlnode;
			_tmp30_ = _tmp29_->type;
			if (_tmp30_ != XML_ELEMENT_NODE) {
				continue;
			}
			_tmp31_ = xmlnode;
			_tmp32_ = _tmp31_->name;
			_tmp33_ = _tmp32_;
			_tmp35_ = (NULL == _tmp33_) ? 0 : g_quark_from_string (_tmp33_);
			if ((_tmp35_ == ((0 != _tmp34_label0) ? _tmp34_label0 : (_tmp34_label0 = g_quark_from_static_string ("centre")))) || (_tmp35_ == ((0 != _tmp34_label1) ? _tmp34_label1 : (_tmp34_label1 = g_quark_from_static_string ("center"))))) {
				switch (0) {
					default:
					{
						{
							{
								xmlAttr* xmlattr = NULL;
								xmlNode* _tmp36_ = NULL;
								xmlAttr* _tmp37_ = NULL;
								_tmp36_ = xmlnode;
								_tmp37_ = _tmp36_->properties;
								xmlattr = _tmp37_;
								{
									gboolean _tmp38_ = FALSE;
									_tmp38_ = TRUE;
									while (TRUE) {
										xmlAttr* _tmp41_ = NULL;
										xmlAttr* _tmp42_ = NULL;
										const gchar* _tmp43_ = NULL;
										xmlAttr* _tmp48_ = NULL;
										const gchar* _tmp49_ = NULL;
										if (!_tmp38_) {
											xmlAttr* _tmp39_ = NULL;
											xmlAttr* _tmp40_ = NULL;
											_tmp39_ = xmlattr;
											_tmp40_ = _tmp39_->next;
											xmlattr = _tmp40_;
										}
										_tmp38_ = FALSE;
										_tmp41_ = xmlattr;
										if (!(_tmp41_ != NULL)) {
											break;
										}
										_tmp42_ = xmlattr;
										_tmp43_ = _tmp42_->name;
										if (g_strcmp0 (_tmp43_, "x") == 0) {
											xmlAttr* _tmp44_ = NULL;
											xmlNode* _tmp45_ = NULL;
											const gchar* _tmp46_ = NULL;
											gint _tmp47_ = 0;
											_tmp44_ = xmlattr;
											_tmp45_ = _tmp44_->children;
											_tmp46_ = _tmp45_->content;
											_tmp47_ = atoi (_tmp46_);
											self->priv->xCentre = _tmp47_;
										}
										_tmp48_ = xmlattr;
										_tmp49_ = _tmp48_->name;
										if (g_strcmp0 (_tmp49_, "y") == 0) {
											xmlAttr* _tmp50_ = NULL;
											xmlNode* _tmp51_ = NULL;
											const gchar* _tmp52_ = NULL;
											gint _tmp53_ = 0;
											_tmp50_ = xmlattr;
											_tmp51_ = _tmp50_->children;
											_tmp52_ = _tmp51_->content;
											_tmp53_ = atoi (_tmp52_);
											self->priv->yCentre = _tmp53_;
										}
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp35_ == ((0 != _tmp34_label2) ? _tmp34_label2 : (_tmp34_label2 = g_quark_from_static_string ("size")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlAttr* xmlattr = NULL;
								xmlNode* _tmp54_ = NULL;
								xmlAttr* _tmp55_ = NULL;
								_tmp54_ = xmlnode;
								_tmp55_ = _tmp54_->properties;
								xmlattr = _tmp55_;
								{
									gboolean _tmp56_ = FALSE;
									_tmp56_ = TRUE;
									while (TRUE) {
										xmlAttr* _tmp59_ = NULL;
										xmlAttr* _tmp60_ = NULL;
										const gchar* _tmp61_ = NULL;
										xmlAttr* _tmp66_ = NULL;
										const gchar* _tmp67_ = NULL;
										if (!_tmp56_) {
											xmlAttr* _tmp57_ = NULL;
											xmlAttr* _tmp58_ = NULL;
											_tmp57_ = xmlattr;
											_tmp58_ = _tmp57_->next;
											xmlattr = _tmp58_;
										}
										_tmp56_ = FALSE;
										_tmp59_ = xmlattr;
										if (!(_tmp59_ != NULL)) {
											break;
										}
										_tmp60_ = xmlattr;
										_tmp61_ = _tmp60_->name;
										if (g_strcmp0 (_tmp61_, "width") == 0) {
											xmlAttr* _tmp62_ = NULL;
											xmlNode* _tmp63_ = NULL;
											const gchar* _tmp64_ = NULL;
											gint _tmp65_ = 0;
											_tmp62_ = xmlattr;
											_tmp63_ = _tmp62_->children;
											_tmp64_ = _tmp63_->content;
											_tmp65_ = atoi (_tmp64_);
											self->priv->height = _tmp65_;
										}
										_tmp66_ = xmlattr;
										_tmp67_ = _tmp66_->name;
										if (g_strcmp0 (_tmp67_, "height") == 0) {
											xmlAttr* _tmp68_ = NULL;
											xmlNode* _tmp69_ = NULL;
											const gchar* _tmp70_ = NULL;
											gint _tmp71_ = 0;
											_tmp68_ = xmlattr;
											_tmp69_ = _tmp68_->children;
											_tmp70_ = _tmp69_->content;
											_tmp71_ = atoi (_tmp70_);
											self->priv->width = _tmp71_;
										}
									}
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	_tmp72_ = xmldoc;
	xmlFreeDoc (_tmp72_);
	result = 0;
	return result;
}


/**
 * Loads the SVG using librsvg.
 */
gint graphic_load_svg (Graphic* self, const gchar* filename) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RsvgHandle* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (filename != NULL, 0);
	_tmp0_ = stdout;
	_tmp1_ = filename;
	fprintf (_tmp0_, "Loading svg \"%s\"\n", _tmp1_);
	_tmp2_ = filename;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->svgFilename);
	self->svgFilename = _tmp3_;
	{
		RsvgHandle* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		RsvgHandle* _tmp6_ = NULL;
		RsvgHandle* _tmp7_ = NULL;
		_tmp5_ = filename;
		_tmp6_ = rsvg_handle_new_from_file (_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch54_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->svgHandle);
		self->priv->svgHandle = _tmp7_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally54;
	__catch54_g_error:
	{
		FILE* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp8_ = stdout;
		_tmp9_ = filename;
		fprintf (_tmp8_, "Error loading graphic \"%s\"\n", _tmp9_);
		result = 1;
		return result;
	}
	__finally54:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp10_ = self->priv->svgHandle;
	if (_tmp10_ == NULL) {
		FILE* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = stdout;
		_tmp12_ = filename;
		fprintf (_tmp11_, "Error loading graphic \"%s\"\n", _tmp12_);
		result = 2;
		return result;
	}
	result = 0;
	return result;
}


/**
 * Renders the SVG, performing any necessary transformations.
 */
void graphic_render (Graphic* self, cairo_t* context) {
	cairo_matrix_t oldMatrix = {0};
	cairo_t* _tmp0_ = NULL;
	cairo_matrix_t _tmp1_ = {0};
	cairo_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	RsvgHandle* _tmp5_ = NULL;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_matrix_t _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	cairo_get_matrix (_tmp0_, &_tmp1_);
	oldMatrix = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = self->priv->xCentre;
	_tmp4_ = self->priv->yCentre;
	cairo_translate (_tmp2_, (gdouble) (-_tmp3_), (gdouble) (-_tmp4_));
	_tmp5_ = self->priv->svgHandle;
	_tmp6_ = context;
	rsvg_handle_render_cairo (_tmp5_, _tmp6_);
	_tmp7_ = context;
	_tmp8_ = oldMatrix;
	cairo_set_matrix (_tmp7_, &_tmp8_);
}


Graphic* graphic_construct (GType object_type) {
	Graphic* self = NULL;
	self = (Graphic*) g_type_create_instance (object_type);
	return self;
}


Graphic* graphic_new (void) {
	return graphic_construct (TYPE_GRAPHIC);
}


static void value_graphic_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_graphic_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		graphic_unref (value->data[0].v_pointer);
	}
}


static void value_graphic_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = graphic_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_graphic_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_graphic_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Graphic* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = graphic_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_graphic_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Graphic** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = graphic_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGraphic* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GRAPHIC), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_graphic (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GRAPHIC), NULL);
	return value->data[0].v_pointer;
}


void value_set_graphic (GValue* value, gpointer v_object) {
	Graphic* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GRAPHIC));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GRAPHIC));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		graphic_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		graphic_unref (old);
	}
}


void value_take_graphic (GValue* value, gpointer v_object) {
	Graphic* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GRAPHIC));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GRAPHIC));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		graphic_unref (old);
	}
}


static void graphic_class_init (GraphicClass * klass) {
	graphic_parent_class = g_type_class_peek_parent (klass);
	GRAPHIC_CLASS (klass)->finalize = graphic_finalize;
	g_type_class_add_private (klass, sizeof (GraphicPrivate));
}


static void graphic_instance_init (Graphic * self) {
	self->priv = GRAPHIC_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void graphic_finalize (Graphic* obj) {
	Graphic * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRAPHIC, Graphic);
	_g_object_unref0 (self->priv->svgHandle);
	_g_free0 (self->filename);
	_g_free0 (self->svgFilename);
	_g_free0 (self->infoFilename);
}


/**
 * Used to store and render an SVG image.
 */
GType graphic_get_type (void) {
	static volatile gsize graphic_type_id__volatile = 0;
	if (g_once_init_enter (&graphic_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_graphic_init, value_graphic_free_value, value_graphic_copy_value, value_graphic_peek_pointer, "p", value_graphic_collect_value, "p", value_graphic_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GraphicClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Graphic), 0, (GInstanceInitFunc) graphic_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType graphic_type_id;
		graphic_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Graphic", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&graphic_type_id__volatile, graphic_type_id);
	}
	return graphic_type_id__volatile;
}


gpointer graphic_ref (gpointer instance) {
	Graphic* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void graphic_unref (gpointer instance) {
	Graphic* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GRAPHIC_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



