/* main.c generated by valac 0.24.0, the Vala compiler
 * generated from main.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: main.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_FLOW (flow_get_type ())

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_VERSION_COMPARISON (version_comparison_get_type ())

#define TYPE_CORE (core_get_type ())
#define CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CORE, Core))
#define CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CORE, CoreClass))
#define IS_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CORE))
#define IS_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CORE))
#define CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CORE, CoreClass))

typedef struct _Core Core;
typedef struct _CoreClass CoreClass;
typedef struct _CorePrivate CorePrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;
#define _graphic_unref0(var) ((var == NULL) ? NULL : (var = (graphic_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DESIGNER_WINDOW (designer_window_get_type ())
#define DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER_WINDOW, DesignerWindow))
#define DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER_WINDOW, DesignerWindowClass))
#define IS_DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER_WINDOW))
#define IS_DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER_WINDOW))
#define DESIGNER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER_WINDOW, DesignerWindowClass))

typedef struct _DesignerWindow DesignerWindow;
typedef struct _DesignerWindowClass DesignerWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUFFER_COMPONENT_DEF (buffer_component_def_get_type ())
#define BUFFER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER_COMPONENT_DEF, BufferComponentDef))
#define BUFFER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER_COMPONENT_DEF, BufferComponentDefClass))
#define IS_BUFFER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER_COMPONENT_DEF))
#define IS_BUFFER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER_COMPONENT_DEF))
#define BUFFER_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER_COMPONENT_DEF, BufferComponentDefClass))

typedef struct _BufferComponentDef BufferComponentDef;
typedef struct _BufferComponentDefClass BufferComponentDefClass;

#define TYPE_AND_COMPONENT_DEF (and_component_def_get_type ())
#define AND_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AND_COMPONENT_DEF, AndComponentDef))
#define AND_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AND_COMPONENT_DEF, AndComponentDefClass))
#define IS_AND_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AND_COMPONENT_DEF))
#define IS_AND_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AND_COMPONENT_DEF))
#define AND_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AND_COMPONENT_DEF, AndComponentDefClass))

typedef struct _AndComponentDef AndComponentDef;
typedef struct _AndComponentDefClass AndComponentDefClass;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))

#define TYPE_OR_COMPONENT_DEF (or_component_def_get_type ())
#define OR_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OR_COMPONENT_DEF, OrComponentDef))
#define OR_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OR_COMPONENT_DEF, OrComponentDefClass))
#define IS_OR_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OR_COMPONENT_DEF))
#define IS_OR_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OR_COMPONENT_DEF))
#define OR_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OR_COMPONENT_DEF, OrComponentDefClass))

typedef struct _OrComponentDef OrComponentDef;
typedef struct _OrComponentDefClass OrComponentDefClass;

#define TYPE_XOR_COMPONENT_DEF (xor_component_def_get_type ())
#define XOR_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XOR_COMPONENT_DEF, XorComponentDef))
#define XOR_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XOR_COMPONENT_DEF, XorComponentDefClass))
#define IS_XOR_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XOR_COMPONENT_DEF))
#define IS_XOR_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XOR_COMPONENT_DEF))
#define XOR_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XOR_COMPONENT_DEF, XorComponentDefClass))

typedef struct _XorComponentDef XorComponentDef;
typedef struct _XorComponentDefClass XorComponentDefClass;

#define TYPE_TRISTATE_COMPONENT_DEF (tristate_component_def_get_type ())
#define TRISTATE_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRISTATE_COMPONENT_DEF, TristateComponentDef))
#define TRISTATE_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRISTATE_COMPONENT_DEF, TristateComponentDefClass))
#define IS_TRISTATE_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRISTATE_COMPONENT_DEF))
#define IS_TRISTATE_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRISTATE_COMPONENT_DEF))
#define TRISTATE_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRISTATE_COMPONENT_DEF, TristateComponentDefClass))

typedef struct _TristateComponentDef TristateComponentDef;
typedef struct _TristateComponentDefClass TristateComponentDefClass;

#define TYPE_MULTIPLEXER_COMPONENT_DEF (multiplexer_component_def_get_type ())
#define MULTIPLEXER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLEXER_COMPONENT_DEF, MultiplexerComponentDef))
#define MULTIPLEXER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLEXER_COMPONENT_DEF, MultiplexerComponentDefClass))
#define IS_MULTIPLEXER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLEXER_COMPONENT_DEF))
#define IS_MULTIPLEXER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLEXER_COMPONENT_DEF))
#define MULTIPLEXER_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLEXER_COMPONENT_DEF, MultiplexerComponentDefClass))

typedef struct _MultiplexerComponentDef MultiplexerComponentDef;
typedef struct _MultiplexerComponentDefClass MultiplexerComponentDefClass;

#define TYPE_PE_DFLIPFLOP_COMPONENT_DEF (pe_dflipflop_component_def_get_type ())
#define PE_DFLIPFLOP_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PE_DFLIPFLOP_COMPONENT_DEF, PeDFlipflopComponentDef))
#define PE_DFLIPFLOP_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PE_DFLIPFLOP_COMPONENT_DEF, PeDFlipflopComponentDefClass))
#define IS_PE_DFLIPFLOP_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PE_DFLIPFLOP_COMPONENT_DEF))
#define IS_PE_DFLIPFLOP_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PE_DFLIPFLOP_COMPONENT_DEF))
#define PE_DFLIPFLOP_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PE_DFLIPFLOP_COMPONENT_DEF, PeDFlipflopComponentDefClass))

typedef struct _PeDFlipflopComponentDef PeDFlipflopComponentDef;
typedef struct _PeDFlipflopComponentDefClass PeDFlipflopComponentDefClass;

#define TYPE_TFLIPFLOP_COMPONENT_DEF (tflipflop_component_def_get_type ())
#define TFLIPFLOP_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TFLIPFLOP_COMPONENT_DEF, TFlipflopComponentDef))
#define TFLIPFLOP_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TFLIPFLOP_COMPONENT_DEF, TFlipflopComponentDefClass))
#define IS_TFLIPFLOP_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TFLIPFLOP_COMPONENT_DEF))
#define IS_TFLIPFLOP_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TFLIPFLOP_COMPONENT_DEF))
#define TFLIPFLOP_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TFLIPFLOP_COMPONENT_DEF, TFlipflopComponentDefClass))

typedef struct _TFlipflopComponentDef TFlipflopComponentDef;
typedef struct _TFlipflopComponentDefClass TFlipflopComponentDefClass;

#define TYPE_MEMORY_COMPONENT_DEF (memory_component_def_get_type ())
#define MEMORY_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEMORY_COMPONENT_DEF, MemoryComponentDef))
#define MEMORY_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEMORY_COMPONENT_DEF, MemoryComponentDefClass))
#define IS_MEMORY_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEMORY_COMPONENT_DEF))
#define IS_MEMORY_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEMORY_COMPONENT_DEF))
#define MEMORY_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEMORY_COMPONENT_DEF, MemoryComponentDefClass))

typedef struct _MemoryComponentDef MemoryComponentDef;
typedef struct _MemoryComponentDefClass MemoryComponentDefClass;

#define TYPE_CONSTANT_COMPONENT_DEF (constant_component_def_get_type ())
#define CONSTANT_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSTANT_COMPONENT_DEF, ConstantComponentDef))
#define CONSTANT_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSTANT_COMPONENT_DEF, ConstantComponentDefClass))
#define IS_CONSTANT_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSTANT_COMPONENT_DEF))
#define IS_CONSTANT_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSTANT_COMPONENT_DEF))
#define CONSTANT_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSTANT_COMPONENT_DEF, ConstantComponentDefClass))

typedef struct _ConstantComponentDef ConstantComponentDef;
typedef struct _ConstantComponentDefClass ConstantComponentDefClass;

#define TYPE_CLOCK_COMPONENT_DEF (clock_component_def_get_type ())
#define CLOCK_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLOCK_COMPONENT_DEF, ClockComponentDef))
#define CLOCK_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLOCK_COMPONENT_DEF, ClockComponentDefClass))
#define IS_CLOCK_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLOCK_COMPONENT_DEF))
#define IS_CLOCK_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLOCK_COMPONENT_DEF))
#define CLOCK_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLOCK_COMPONENT_DEF, ClockComponentDefClass))

typedef struct _ClockComponentDef ClockComponentDef;
typedef struct _ClockComponentDefClass ClockComponentDefClass;

#define TYPE_TOGGLE_COMPONENT_DEF (toggle_component_def_get_type ())
#define TOGGLE_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_COMPONENT_DEF, ToggleComponentDef))
#define TOGGLE_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_COMPONENT_DEF, ToggleComponentDefClass))
#define IS_TOGGLE_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_COMPONENT_DEF))
#define IS_TOGGLE_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_COMPONENT_DEF))
#define TOGGLE_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_COMPONENT_DEF, ToggleComponentDefClass))

typedef struct _ToggleComponentDef ToggleComponentDef;
typedef struct _ToggleComponentDefClass ToggleComponentDefClass;

#define TYPE_READER_COMPONENT_DEF (reader_component_def_get_type ())
#define READER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READER_COMPONENT_DEF, ReaderComponentDef))
#define READER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READER_COMPONENT_DEF, ReaderComponentDefClass))
#define IS_READER_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READER_COMPONENT_DEF))
#define IS_READER_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READER_COMPONENT_DEF))
#define READER_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READER_COMPONENT_DEF, ReaderComponentDefClass))

typedef struct _ReaderComponentDef ReaderComponentDef;
typedef struct _ReaderComponentDefClass ReaderComponentDefClass;

#define TYPE_BASIC_SS_DISPLAY_COMPONENT_DEF (basic_ss_display_component_def_get_type ())
#define BASIC_SS_DISPLAY_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASIC_SS_DISPLAY_COMPONENT_DEF, BasicSsDisplayComponentDef))
#define BASIC_SS_DISPLAY_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASIC_SS_DISPLAY_COMPONENT_DEF, BasicSsDisplayComponentDefClass))
#define IS_BASIC_SS_DISPLAY_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASIC_SS_DISPLAY_COMPONENT_DEF))
#define IS_BASIC_SS_DISPLAY_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASIC_SS_DISPLAY_COMPONENT_DEF))
#define BASIC_SS_DISPLAY_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASIC_SS_DISPLAY_COMPONENT_DEF, BasicSsDisplayComponentDefClass))

typedef struct _BasicSsDisplayComponentDef BasicSsDisplayComponentDef;
typedef struct _BasicSsDisplayComponentDefClass BasicSsDisplayComponentDefClass;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _ParamSpecCore ParamSpecCore;

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

typedef enum  {
	VERSION_COMPARISON_EQUAL,
	VERSION_COMPARISON_LESS,
	VERSION_COMPARISON_GREATER
} VersionComparison;

struct _Core {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CorePrivate * priv;
};

struct _CoreClass {
	GTypeClass parent_class;
	void (*finalize) (Core *self);
};

typedef enum  {
	GRAPHIC_LOAD_ERROR_FILE
} GraphicLoadError;
#define GRAPHIC_LOAD_ERROR graphic_load_error_quark ()
typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
struct _ParamSpecCore {
	GParamSpec parent_instance;
};


static gpointer core_parent_class = NULL;
extern ComponentDef** core_standardComponentDefs;
extern gint core_standardComponentDefs_length1;
ComponentDef** core_standardComponentDefs = NULL;
gint core_standardComponentDefs_length1 = 0;
extern gchar* core_fullLicenseText;
gchar* core_fullLicenseText = NULL;
static gboolean core__versionIgnored;
static gboolean core__versionIgnored = FALSE;
extern Graphic* graphic_placeHolder;

GType flow_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
GType version_comparison_get_type (void) G_GNUC_CONST;
gpointer core_ref (gpointer instance);
void core_unref (gpointer instance);
GParamSpec* param_spec_core (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_core (GValue* value, gpointer v_object);
void value_take_core (GValue* value, gpointer v_object);
gpointer value_get_core (const GValue* value);
GType core_get_type (void) G_GNUC_CONST;
enum  {
	CORE_DUMMY_PROPERTY
};
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
#define CORE_programName "SmartSim"
#define CORE_websiteString "http://www.smartsim.org.uk"
#define CORE_shortVersionString PACKAGE_VERSION
#define CORE_versionString PACKAGE_VERSION ""
#define CORE_copyrightString "Ashley Newson 2013"
#define CORE_licenseType GTK_LICENSE_GPL_3_0
#define CORE_licenseName "Public Package - GNU GPL 3.0 - Freely Distributable"
#define CORE_shortLicenseText "This software, SmartSim, and its corresponding resource files are the\n" \
"intellectual property of Ashley Newson. This package is released under" \
"\n" \
"the GNU General Public License 3.0. A provided \"COPYING\" file provid" \
"es\n" \
"the full license text.\n" \
"\n" \
"This package may be provided with the Gtk and Rsvg Libraries. The\n" \
"licenses of these libraries are included in the \"GTK_COPYING\" and\n" \
"\"RSVG_COPYING\" files.\n" \
"\n" \
"SmartSim is free software; you can redistribute it and/or modify it\n" \
"under the terms of the GNU General Public Licence as published by the\n" \
"Free Software Foundation; either version 3 of the Licence, or (at your" \
"\n" \
"option) any later version.\n" \
"\n" \
"SmartSim is distributed in the hope that it will be useful, but WITHOU" \
"T\n" \
"ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or\n" \
"FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Licence\n" \
"for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public Licence alon" \
"g\n" \
"with SmartSim. If not, see:\n" \
"  http://www.gnu.org/licenses/\n"
gboolean core_version_ignored (const gchar* extra);
gint basic_dialog_ask_generic (GtkWindow* window, GtkMessageType messageType, const gchar* text, gchar** options, int options_length1);
gint core_main (gchar** args, int args_length1);
static gchar* core_load_string_from_file (const gchar* filename);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
GQuark graphic_load_error_quark (void);
Graphic* graphic_new_from_file (const gchar* filename, GError** error);
Graphic* graphic_construct_from_file (GType object_type, const gchar* filename, GError** error);
static void core_load_standard_defs (void);
DesignerWindow* designer_window_new (void);
DesignerWindow* designer_window_construct (GType object_type);
GType designer_window_get_type (void) G_GNUC_CONST;
DesignerWindow* designer_window_new_with_project_from_file (const gchar* filename);
DesignerWindow* designer_window_construct_with_project_from_file (GType object_type, const gchar* filename);
void plugin_component_manager_unregister_all (void);
GType buffer_component_def_get_type (void) G_GNUC_CONST;
GQuark component_def_load_error_quark (void);
BufferComponentDef* buffer_component_def_new (GError** error);
BufferComponentDef* buffer_component_def_construct (GType object_type, GError** error);
static void _vala_array_add2 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType and_component_def_get_type (void) G_GNUC_CONST;
AndComponentDef* and_component_def_new (GError** error);
AndComponentDef* and_component_def_construct (GType object_type, GError** error);
static void _vala_array_add3 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType or_component_def_get_type (void) G_GNUC_CONST;
OrComponentDef* or_component_def_new (GError** error);
OrComponentDef* or_component_def_construct (GType object_type, GError** error);
static void _vala_array_add4 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType xor_component_def_get_type (void) G_GNUC_CONST;
XorComponentDef* xor_component_def_new (GError** error);
XorComponentDef* xor_component_def_construct (GType object_type, GError** error);
static void _vala_array_add5 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType tristate_component_def_get_type (void) G_GNUC_CONST;
TristateComponentDef* tristate_component_def_new (GError** error);
TristateComponentDef* tristate_component_def_construct (GType object_type, GError** error);
static void _vala_array_add6 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType multiplexer_component_def_get_type (void) G_GNUC_CONST;
MultiplexerComponentDef* multiplexer_component_def_new (GError** error);
MultiplexerComponentDef* multiplexer_component_def_construct (GType object_type, GError** error);
static void _vala_array_add7 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType pe_dflipflop_component_def_get_type (void) G_GNUC_CONST;
PeDFlipflopComponentDef* pe_dflipflop_component_def_new (GError** error);
PeDFlipflopComponentDef* pe_dflipflop_component_def_construct (GType object_type, GError** error);
static void _vala_array_add8 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType tflipflop_component_def_get_type (void) G_GNUC_CONST;
TFlipflopComponentDef* tflipflop_component_def_new (GError** error);
TFlipflopComponentDef* tflipflop_component_def_construct (GType object_type, GError** error);
static void _vala_array_add9 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType memory_component_def_get_type (void) G_GNUC_CONST;
MemoryComponentDef* memory_component_def_new (GError** error);
MemoryComponentDef* memory_component_def_construct (GType object_type, GError** error);
static void _vala_array_add10 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType constant_component_def_get_type (void) G_GNUC_CONST;
ConstantComponentDef* constant_component_def_new (GError** error);
ConstantComponentDef* constant_component_def_construct (GType object_type, GError** error);
static void _vala_array_add11 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType clock_component_def_get_type (void) G_GNUC_CONST;
ClockComponentDef* clock_component_def_new (GError** error);
ClockComponentDef* clock_component_def_construct (GType object_type, GError** error);
static void _vala_array_add12 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType toggle_component_def_get_type (void) G_GNUC_CONST;
ToggleComponentDef* toggle_component_def_new (GError** error);
ToggleComponentDef* toggle_component_def_construct (GType object_type, GError** error);
static void _vala_array_add13 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType reader_component_def_get_type (void) G_GNUC_CONST;
ReaderComponentDef* reader_component_def_new (GError** error);
ReaderComponentDef* reader_component_def_construct (GType object_type, GError** error);
static void _vala_array_add14 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
GType basic_ss_display_component_def_get_type (void) G_GNUC_CONST;
BasicSsDisplayComponentDef* basic_ss_display_component_def_new (GError** error);
BasicSsDisplayComponentDef* basic_ss_display_component_def_construct (GType object_type, GError** error);
static void _vala_array_add15 (ComponentDef*** array, int* length, int* size, ComponentDef* value);
static ComponentDef** _vala_array_dup1 (ComponentDef** self, int length);
ComponentDef** core_get_standard_defs (int* result_length1);
static ComponentDef** _vala_array_dup2 (ComponentDef** self, int length);
gchar* core_relative_filename (const gchar* rawTargetFilename, const gchar* rawReferenceFilename);
static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value);
gchar* core_absolute_filename (const gchar* filename, const gchar* pwd);
gchar* core_reduce_filename (const gchar* rawFilename);
static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value);
VersionComparison core_compare_versions (const gchar* whatVersion, const gchar* withVersion);
static gint* core_version_to_numbers (const gchar* version, int* result_length1);
static guint8* _vala_array_dup3 (guint8* self, int length);
static void _vala_array_add21 (gint** array, int* length, int* size, gint value);
static void _vala_array_add22 (gint** array, int* length, int* size, gint value);
Core* core_new (void);
Core* core_construct (GType object_type);
static void core_finalize (Core* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* CORE_authorsStrings[2] = {"Ashley Newson <ashleynewson@smartsim.org.uk>", NULL};

/**
 * Describes the direction a signal is meant to flow.
 */
GType flow_get_type (void) {
	static volatile gsize flow_type_id__volatile = 0;
	if (g_once_init_enter (&flow_type_id__volatile)) {
		static const GEnumValue values[] = {{FLOW_NONE, "FLOW_NONE", "none"}, {FLOW_IN, "FLOW_IN", "in"}, {FLOW_OUT, "FLOW_OUT", "out"}, {FLOW_BIDIRECTIONAL, "FLOW_BIDIRECTIONAL", "bidirectional"}, {0, NULL, NULL}};
		GType flow_type_id;
		flow_type_id = g_enum_register_static ("Flow", values);
		g_once_init_leave (&flow_type_id__volatile, flow_type_id);
	}
	return flow_type_id__volatile;
}


/**
 * Describes the direction an object is facing or drawn.
 */
GType direction_get_type (void) {
	static volatile gsize direction_type_id__volatile = 0;
	if (g_once_init_enter (&direction_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTION_NONE, "DIRECTION_NONE", "none"}, {DIRECTION_RIGHT, "DIRECTION_RIGHT", "right"}, {DIRECTION_DOWN, "DIRECTION_DOWN", "down"}, {DIRECTION_LEFT, "DIRECTION_LEFT", "left"}, {DIRECTION_UP, "DIRECTION_UP", "up"}, {DIRECTION_HORIZONTAL, "DIRECTION_HORIZONTAL", "horizontal"}, {DIRECTION_VERTICAL, "DIRECTION_VERTICAL", "vertical"}, {DIRECTION_DIAGONAL, "DIRECTION_DIAGONAL", "diagonal"}, {0, NULL, NULL}};
		GType direction_type_id;
		direction_type_id = g_enum_register_static ("Direction", values);
		g_once_init_leave (&direction_type_id__volatile, direction_type_id);
	}
	return direction_type_id__volatile;
}


/**
 * Stores a comparison of versions.
 */
GType version_comparison_get_type (void) {
	static volatile gsize version_comparison_type_id__volatile = 0;
	if (g_once_init_enter (&version_comparison_type_id__volatile)) {
		static const GEnumValue values[] = {{VERSION_COMPARISON_EQUAL, "VERSION_COMPARISON_EQUAL", "equal"}, {VERSION_COMPARISON_LESS, "VERSION_COMPARISON_LESS", "less"}, {VERSION_COMPARISON_GREATER, "VERSION_COMPARISON_GREATER", "greater"}, {0, NULL, NULL}};
		GType version_comparison_type_id;
		version_comparison_type_id = g_enum_register_static ("VersionComparison", values);
		g_once_init_leave (&version_comparison_type_id__volatile, version_comparison_type_id);
	}
	return version_comparison_type_id__volatile;
}


gboolean core_version_ignored (const gchar* extra) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_val_if_fail (extra != NULL, FALSE);
	_tmp0_ = core__versionIgnored;
	if (_tmp0_ == TRUE) {
		result = TRUE;
		return result;
	}
	_tmp1_ = extra;
	_tmp2_ = g_strconcat ("Warning:\n" \
"The version of SmartSim used to save a file being loaded is greater th" \
"an the current version you are using.\n" \
"This version might not be compatible with the saved file. It could beh" \
"ave unpredictably, or cause loss of data upon saving.\n", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup ("Continue");
	_tmp5_ = g_strdup ("Continue For All Files");
	_tmp6_ = g_strdup ("Cancel Loading");
	_tmp7_ = g_new0 (gchar*, 3 + 1);
	_tmp7_[0] = _tmp4_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	_tmp9_ = basic_dialog_ask_generic (NULL, GTK_MESSAGE_WARNING, _tmp3_, _tmp8_, 3);
	_tmp10_ = _tmp9_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp3_);
	switch (_tmp10_) {
		case 0:
		{
			result = TRUE;
			return result;
		}
		case 1:
		{
			core__versionIgnored = TRUE;
			result = TRUE;
			return result;
		}
		default:
		case 2:
		{
			core__versionIgnored = FALSE;
			result = FALSE;
			return result;
		}
	}
}


/**
 * The beginning point of execution. Starts load up and creates a
 * single DesignerWindow.
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint core_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar** projectsToOpen = NULL;
	gchar** _tmp0_ = NULL;
	gint projectsToOpen_length1 = 0;
	gint _projectsToOpen_size_ = 0;
	FILE* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FILE* _tmp30_ = NULL;
	FILE* _tmp31_ = NULL;
	FILE* _tmp38_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	FILE* _tmp47_ = NULL;
	FILE* _tmp48_ = NULL;
	FILE* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	projectsToOpen = _tmp0_;
	projectsToOpen_length1 = 0;
	_projectsToOpen_size_ = projectsToOpen_length1;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "%s\n", CORE_programName);
	_tmp2_ = stdout;
	fprintf (_tmp2_, "\t%s\n", CORE_versionString);
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Copyright: %s\n", CORE_copyrightString);
	_tmp4_ = stdout;
	fprintf (_tmp4_, "License: %s\n", CORE_licenseName);
	_tmp5_ = core_load_string_from_file ("COPYING");
	_g_free0 (core_fullLicenseText);
	core_fullLicenseText = _tmp5_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gchar* arg = NULL;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				GQuark _tmp17_ = 0U;
				static GQuark _tmp16_label0 = 0;
				static GQuark _tmp16_label1 = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = args;
				_tmp9__length1 = args_length1;
				if (!(_tmp8_ < _tmp9__length1)) {
					break;
				}
				_tmp10_ = args;
				_tmp10__length1 = args_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = g_strdup (_tmp12_);
				arg = _tmp13_;
				_tmp14_ = arg;
				_tmp15_ = _tmp14_;
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("--version")))) {
					switch (0) {
						default:
						{
							result = 0;
							_g_free0 (arg);
							projectsToOpen = (_vala_array_free (projectsToOpen, projectsToOpen_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("--license")))) {
					switch (0) {
						default:
						{
							FILE* _tmp18_ = NULL;
							FILE* _tmp19_ = NULL;
							const gchar* _tmp20_ = NULL;
							_tmp18_ = stdout;
							fprintf (_tmp18_, "%s\n", CORE_licenseName);
							_tmp19_ = stdout;
							_tmp20_ = core_fullLicenseText;
							fprintf (_tmp19_, "%s\n", _tmp20_);
							result = 0;
							_g_free0 (arg);
							projectsToOpen = (_vala_array_free (projectsToOpen, projectsToOpen_length1, (GDestroyNotify) g_free), NULL);
							return result;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							gboolean _tmp24_ = FALSE;
							_tmp21_ = arg;
							_tmp22_ = string_substring (_tmp21_, (glong) 0, (glong) 2);
							_tmp23_ = _tmp22_;
							_tmp24_ = g_strcmp0 (_tmp23_, "--") == 0;
							_g_free0 (_tmp23_);
							if (_tmp24_) {
								FILE* _tmp25_ = NULL;
								const gchar* _tmp26_ = NULL;
								_tmp25_ = stderr;
								_tmp26_ = arg;
								fprintf (_tmp25_, "Unrecognised command \"%s\".\n", _tmp26_);
							} else {
								gchar** _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
								const gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								_tmp27_ = projectsToOpen;
								_tmp27__length1 = projectsToOpen_length1;
								_tmp28_ = arg;
								_tmp29_ = g_strdup (_tmp28_);
								_vala_array_add1 (&projectsToOpen, &projectsToOpen_length1, &_projectsToOpen_size_, _tmp29_);
							}
							break;
						}
					}
				}
				_g_free0 (arg);
			}
		}
	}
	_tmp30_ = stdout;
	fprintf (_tmp30_, "Loading System...\n");
	gtk_init (&args_length1, &args);
	_tmp31_ = stdout;
	fprintf (_tmp31_, "Loading Place-holder Graphic\n");
	{
		Graphic* _tmp32_ = NULL;
		Graphic* _tmp33_ = NULL;
		Graphic* _tmp34_ = NULL;
		_tmp33_ = graphic_new_from_file (PACKAGE_DATADIR "images/graphics/placeholder", &_inner_error_);
		_tmp32_ = _tmp33_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GRAPHIC_LOAD_ERROR) {
				goto __catch0_graphic_load_error;
			}
			projectsToOpen = (_vala_array_free (projectsToOpen, projectsToOpen_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp34_ = _tmp32_;
		_tmp32_ = NULL;
		_graphic_unref0 (graphic_placeHolder);
		graphic_placeHolder = _tmp34_;
		_graphic_unref0 (_tmp32_);
	}
	goto __finally0;
	__catch0_graphic_load_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp35_ = stdout;
		_tmp36_ = _error_;
		_tmp37_ = _tmp36_->message;
		fprintf (_tmp35_, "Could not load place-holder graphic: %s\n", _tmp37_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		projectsToOpen = (_vala_array_free (projectsToOpen, projectsToOpen_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp38_ = stdout;
	fprintf (_tmp38_, "Loading Components\n");
	core_load_standard_defs ();
	_tmp39_ = projectsToOpen;
	_tmp39__length1 = projectsToOpen_length1;
	if (_tmp39__length1 == 0) {
		DesignerWindow* _tmp40_ = NULL;
		DesignerWindow* _tmp41_ = NULL;
		_tmp40_ = designer_window_new ();
		g_object_ref_sink (_tmp40_);
		_tmp41_ = _tmp40_;
		_g_object_unref0 (_tmp41_);
	} else {
		gchar** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		_tmp42_ = projectsToOpen;
		_tmp42__length1 = projectsToOpen_length1;
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it = 0;
			filename_collection = _tmp42_;
			filename_collection_length1 = _tmp42__length1;
			for (filename_it = 0; filename_it < _tmp42__length1; filename_it = filename_it + 1) {
				gchar* _tmp43_ = NULL;
				gchar* filename = NULL;
				_tmp43_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp43_;
				{
					const gchar* _tmp44_ = NULL;
					DesignerWindow* _tmp45_ = NULL;
					DesignerWindow* _tmp46_ = NULL;
					_tmp44_ = filename;
					_tmp45_ = designer_window_new_with_project_from_file (_tmp44_);
					g_object_ref_sink (_tmp45_);
					_tmp46_ = _tmp45_;
					_g_object_unref0 (_tmp46_);
					_g_free0 (filename);
				}
			}
		}
	}
	_tmp47_ = stdout;
	fprintf (_tmp47_, "Ready\n");
	gtk_main ();
	_tmp48_ = stdout;
	fprintf (_tmp48_, "Program Terminating...\n");
	plugin_component_manager_unregister_all ();
	_tmp49_ = stdout;
	fprintf (_tmp49_, "Program Terminated.\n");
	result = 0;
	projectsToOpen = (_vala_array_free (projectsToOpen, projectsToOpen_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return core_main (argv, argc);
}


/**
 * Loads all primitive (built-in) components.
 */
static void _vala_array_add2 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add12 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add13 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add14 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add15 (ComponentDef*** array, int* length, int* size, ComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


static ComponentDef** _vala_array_dup1 (ComponentDef** self, int length) {
	ComponentDef** result;
	int i;
	result = g_new0 (ComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void core_load_standard_defs (void) {
	ComponentDef** standardComponentDefs = NULL;
	ComponentDef** _tmp0_ = NULL;
	gint standardComponentDefs_length1 = 0;
	gint _standardComponentDefs_size_ = 0;
	ComponentDef** _tmp59_ = NULL;
	gint _tmp59__length1 = 0;
	ComponentDef** _tmp60_ = NULL;
	gint _tmp60__length1 = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_new0 (ComponentDef*, 0 + 1);
	standardComponentDefs = _tmp0_;
	standardComponentDefs_length1 = 0;
	_standardComponentDefs_size_ = standardComponentDefs_length1;
	{
		BufferComponentDef* _tmp1_ = NULL;
		BufferComponentDef* _tmp2_ = NULL;
		ComponentDef** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		BufferComponentDef* _tmp4_ = NULL;
		AndComponentDef* _tmp5_ = NULL;
		AndComponentDef* _tmp6_ = NULL;
		ComponentDef** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		AndComponentDef* _tmp8_ = NULL;
		OrComponentDef* _tmp9_ = NULL;
		OrComponentDef* _tmp10_ = NULL;
		ComponentDef** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		OrComponentDef* _tmp12_ = NULL;
		XorComponentDef* _tmp13_ = NULL;
		XorComponentDef* _tmp14_ = NULL;
		ComponentDef** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		XorComponentDef* _tmp16_ = NULL;
		TristateComponentDef* _tmp17_ = NULL;
		TristateComponentDef* _tmp18_ = NULL;
		ComponentDef** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		TristateComponentDef* _tmp20_ = NULL;
		MultiplexerComponentDef* _tmp21_ = NULL;
		MultiplexerComponentDef* _tmp22_ = NULL;
		ComponentDef** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		MultiplexerComponentDef* _tmp24_ = NULL;
		PeDFlipflopComponentDef* _tmp25_ = NULL;
		PeDFlipflopComponentDef* _tmp26_ = NULL;
		ComponentDef** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		PeDFlipflopComponentDef* _tmp28_ = NULL;
		TFlipflopComponentDef* _tmp29_ = NULL;
		TFlipflopComponentDef* _tmp30_ = NULL;
		ComponentDef** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		TFlipflopComponentDef* _tmp32_ = NULL;
		MemoryComponentDef* _tmp33_ = NULL;
		MemoryComponentDef* _tmp34_ = NULL;
		ComponentDef** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		MemoryComponentDef* _tmp36_ = NULL;
		ConstantComponentDef* _tmp37_ = NULL;
		ConstantComponentDef* _tmp38_ = NULL;
		ComponentDef** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		ConstantComponentDef* _tmp40_ = NULL;
		ClockComponentDef* _tmp41_ = NULL;
		ClockComponentDef* _tmp42_ = NULL;
		ComponentDef** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		ClockComponentDef* _tmp44_ = NULL;
		ToggleComponentDef* _tmp45_ = NULL;
		ToggleComponentDef* _tmp46_ = NULL;
		ComponentDef** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		ToggleComponentDef* _tmp48_ = NULL;
		ReaderComponentDef* _tmp49_ = NULL;
		ReaderComponentDef* _tmp50_ = NULL;
		ComponentDef** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		ReaderComponentDef* _tmp52_ = NULL;
		BasicSsDisplayComponentDef* _tmp53_ = NULL;
		BasicSsDisplayComponentDef* _tmp54_ = NULL;
		ComponentDef** _tmp55_ = NULL;
		gint _tmp55__length1 = 0;
		BasicSsDisplayComponentDef* _tmp56_ = NULL;
		_tmp2_ = buffer_component_def_new (&_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = standardComponentDefs;
		_tmp3__length1 = standardComponentDefs_length1;
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_vala_array_add2 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp4_);
		_tmp6_ = and_component_def_new (&_inner_error_);
		_tmp5_ = _tmp6_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = standardComponentDefs;
		_tmp7__length1 = standardComponentDefs_length1;
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_vala_array_add3 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp8_);
		_tmp10_ = or_component_def_new (&_inner_error_);
		_tmp9_ = _tmp10_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = standardComponentDefs;
		_tmp11__length1 = standardComponentDefs_length1;
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_vala_array_add4 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp12_);
		_tmp14_ = xor_component_def_new (&_inner_error_);
		_tmp13_ = _tmp14_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp15_ = standardComponentDefs;
		_tmp15__length1 = standardComponentDefs_length1;
		_tmp16_ = _tmp13_;
		_tmp13_ = NULL;
		_vala_array_add5 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp16_);
		_tmp18_ = tristate_component_def_new (&_inner_error_);
		_tmp17_ = _tmp18_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = standardComponentDefs;
		_tmp19__length1 = standardComponentDefs_length1;
		_tmp20_ = _tmp17_;
		_tmp17_ = NULL;
		_vala_array_add6 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp20_);
		_tmp22_ = multiplexer_component_def_new (&_inner_error_);
		_tmp21_ = _tmp22_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = standardComponentDefs;
		_tmp23__length1 = standardComponentDefs_length1;
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		_vala_array_add7 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp24_);
		_tmp26_ = pe_dflipflop_component_def_new (&_inner_error_);
		_tmp25_ = _tmp26_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp27_ = standardComponentDefs;
		_tmp27__length1 = standardComponentDefs_length1;
		_tmp28_ = _tmp25_;
		_tmp25_ = NULL;
		_vala_array_add8 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp28_);
		_tmp30_ = tflipflop_component_def_new (&_inner_error_);
		_tmp29_ = _tmp30_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp31_ = standardComponentDefs;
		_tmp31__length1 = standardComponentDefs_length1;
		_tmp32_ = _tmp29_;
		_tmp29_ = NULL;
		_vala_array_add9 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp32_);
		_tmp34_ = memory_component_def_new (&_inner_error_);
		_tmp33_ = _tmp34_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp35_ = standardComponentDefs;
		_tmp35__length1 = standardComponentDefs_length1;
		_tmp36_ = _tmp33_;
		_tmp33_ = NULL;
		_vala_array_add10 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp36_);
		_tmp38_ = constant_component_def_new (&_inner_error_);
		_tmp37_ = _tmp38_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp39_ = standardComponentDefs;
		_tmp39__length1 = standardComponentDefs_length1;
		_tmp40_ = _tmp37_;
		_tmp37_ = NULL;
		_vala_array_add11 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp40_);
		_tmp42_ = clock_component_def_new (&_inner_error_);
		_tmp41_ = _tmp42_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp43_ = standardComponentDefs;
		_tmp43__length1 = standardComponentDefs_length1;
		_tmp44_ = _tmp41_;
		_tmp41_ = NULL;
		_vala_array_add12 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp44_);
		_tmp46_ = toggle_component_def_new (&_inner_error_);
		_tmp45_ = _tmp46_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp41_);
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp41_);
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp47_ = standardComponentDefs;
		_tmp47__length1 = standardComponentDefs_length1;
		_tmp48_ = _tmp45_;
		_tmp45_ = NULL;
		_vala_array_add13 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp48_);
		_tmp50_ = reader_component_def_new (&_inner_error_);
		_tmp49_ = _tmp50_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp45_);
			_component_def_unref0 (_tmp41_);
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp45_);
			_component_def_unref0 (_tmp41_);
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp51_ = standardComponentDefs;
		_tmp51__length1 = standardComponentDefs_length1;
		_tmp52_ = _tmp49_;
		_tmp49_ = NULL;
		_vala_array_add14 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp52_);
		_tmp54_ = basic_ss_display_component_def_new (&_inner_error_);
		_tmp53_ = _tmp54_;
		if (_inner_error_ != NULL) {
			_component_def_unref0 (_tmp49_);
			_component_def_unref0 (_tmp45_);
			_component_def_unref0 (_tmp41_);
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch1_component_def_load_error;
			}
			_component_def_unref0 (_tmp49_);
			_component_def_unref0 (_tmp45_);
			_component_def_unref0 (_tmp41_);
			_component_def_unref0 (_tmp37_);
			_component_def_unref0 (_tmp33_);
			_component_def_unref0 (_tmp29_);
			_component_def_unref0 (_tmp25_);
			_component_def_unref0 (_tmp21_);
			_component_def_unref0 (_tmp17_);
			_component_def_unref0 (_tmp13_);
			_component_def_unref0 (_tmp9_);
			_component_def_unref0 (_tmp5_);
			_component_def_unref0 (_tmp1_);
			standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp55_ = standardComponentDefs;
		_tmp55__length1 = standardComponentDefs_length1;
		_tmp56_ = _tmp53_;
		_tmp53_ = NULL;
		_vala_array_add15 (&standardComponentDefs, &standardComponentDefs_length1, &_standardComponentDefs_size_, (ComponentDef*) _tmp56_);
		_component_def_unref0 (_tmp53_);
		_component_def_unref0 (_tmp49_);
		_component_def_unref0 (_tmp45_);
		_component_def_unref0 (_tmp41_);
		_component_def_unref0 (_tmp37_);
		_component_def_unref0 (_tmp33_);
		_component_def_unref0 (_tmp29_);
		_component_def_unref0 (_tmp25_);
		_component_def_unref0 (_tmp21_);
		_component_def_unref0 (_tmp17_);
		_component_def_unref0 (_tmp13_);
		_component_def_unref0 (_tmp9_);
		_component_def_unref0 (_tmp5_);
		_component_def_unref0 (_tmp1_);
	}
	goto __finally1;
	__catch1_component_def_load_error:
	{
		GError* _error_ = NULL;
		GtkMessageDialog* messageDialog = NULL;
		const gchar* _tmp57_ = NULL;
		GtkMessageDialog* _tmp58_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = _error_->message;
		_tmp58_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "There was a fatal error trying to load the built in components:\n%s", _tmp57_);
		g_object_ref_sink (_tmp58_);
		messageDialog = _tmp58_;
		gtk_dialog_run ((GtkDialog*) messageDialog);
		gtk_widget_destroy ((GtkWidget*) messageDialog);
		exit (1);
		_g_object_unref0 (messageDialog);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp59_ = standardComponentDefs;
	_tmp59__length1 = standardComponentDefs_length1;
	_tmp60_ = (_tmp59_ != NULL) ? _vala_array_dup1 (_tmp59_, _tmp59__length1) : ((gpointer) _tmp59_);
	_tmp60__length1 = _tmp59__length1;
	core_standardComponentDefs = (_vala_array_free (core_standardComponentDefs, core_standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	core_standardComponentDefs = _tmp60_;
	core_standardComponentDefs_length1 = _tmp60__length1;
	standardComponentDefs = (_vala_array_free (standardComponentDefs, standardComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
}


static gchar* core_load_string_from_file (const gchar* filename) {
	gchar* result = NULL;
	FILE* file = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	glong length = 0L;
	FILE* _tmp5_ = NULL;
	FILE* _tmp12_ = NULL;
	FILE* _tmp13_ = NULL;
	glong _tmp14_ = 0L;
	FILE* _tmp15_ = NULL;
	glong _tmp16_ = 0L;
	guint8* _tmp17_ = NULL;
	glong _tmp18_ = 0L;
	FILE* _tmp19_ = NULL;
	guint8* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gsize _tmp21_ = 0UL;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_strconcat (PACKAGE_DATADIR, _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "r");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	file = _tmp4_;
	_tmp5_ = file;
	if (_tmp5_ == NULL) {
		FILE* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp6_ = stderr;
		fprintf (_tmp6_, "File could not be opened.\n");
		_tmp7_ = filename;
		_tmp8_ = g_strconcat ("Error opening file! Please see the \"", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "\" file.\n", NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		data = (g_free (data), NULL);
		_fclose0 (file);
		return result;
	}
	_tmp12_ = file;
	fseek (_tmp12_, (glong) 0, SEEK_END);
	_tmp13_ = file;
	_tmp14_ = ftell (_tmp13_);
	length = _tmp14_;
	_tmp15_ = file;
	fseek (_tmp15_, (glong) 0, SEEK_SET);
	_tmp16_ = length;
	_tmp17_ = g_new0 (guint8, _tmp16_ + 1);
	data = (g_free (data), NULL);
	data = _tmp17_;
	data_length1 = _tmp16_ + 1;
	_data_size_ = data_length1;
	_tmp18_ = length;
	_tmp19_ = file;
	_tmp20_ = data;
	_tmp20__length1 = data_length1;
	_tmp21_ = fread (_tmp20_, (gsize) 1, _tmp20__length1, _tmp19_);
	if (((gsize) _tmp18_) == _tmp21_) {
		guint8* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		glong _tmp23_ = 0L;
		guint8 _tmp24_ = 0U;
		guint8* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar* _tmp26_ = NULL;
		_tmp22_ = data;
		_tmp22__length1 = data_length1;
		_tmp23_ = length;
		_tmp22_[_tmp23_] = (guint8) 0;
		_tmp24_ = _tmp22_[_tmp23_];
		_tmp25_ = data;
		_tmp25__length1 = data_length1;
		_tmp26_ = g_strdup ((const gchar*) _tmp25_);
		result = _tmp26_;
		data = (g_free (data), NULL);
		_fclose0 (file);
		return result;
	} else {
		FILE* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp27_ = stderr;
		fprintf (_tmp27_, "File could not be read.\n");
		_tmp28_ = filename;
		_tmp29_ = g_strconcat ("Error reading file! Please see the \"", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, "\" file.\n", NULL);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		result = _tmp32_;
		data = (g_free (data), NULL);
		_fclose0 (file);
		return result;
	}
	data = (g_free (data), NULL);
	_fclose0 (file);
}


/**
 * Returns //standardComponentDefs//.
 */
static ComponentDef** _vala_array_dup2 (ComponentDef** self, int length) {
	ComponentDef** result;
	int i;
	result = g_new0 (ComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ComponentDef** core_get_standard_defs (int* result_length1) {
	ComponentDef** result = NULL;
	ComponentDef** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ComponentDef** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentDef** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp0_ = core_standardComponentDefs;
	_tmp0__length1 = core_standardComponentDefs_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


/**
 * Returns the relative filename based upon the current working directory
 * or a specified one.
 */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* core_relative_filename (const gchar* rawTargetFilename, const gchar* rawReferenceFilename) {
	gchar* result = NULL;
	gchar* targetFilename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* referenceFilename = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** referenceDirectories = NULL;
	gchar** _tmp4_ = NULL;
	gint referenceDirectories_length1 = 0;
	gint _referenceDirectories_size_ = 0;
	gchar** targetDirectories = NULL;
	gchar** _tmp5_ = NULL;
	gint targetDirectories_length1 = 0;
	gint _targetDirectories_size_ = 0;
	gchar* _result_ = NULL;
	gchar* _tmp6_ = NULL;
	gint startIndex = 0;
	gint endIndex = 0;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gint commonCount = 0;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	g_return_val_if_fail (rawTargetFilename != NULL, NULL);
	g_return_val_if_fail (rawReferenceFilename != NULL, NULL);
	_tmp0_ = rawTargetFilename;
	_tmp1_ = string_replace (_tmp0_, G_DIR_SEPARATOR_S, "/");
	targetFilename = _tmp1_;
	_tmp2_ = rawReferenceFilename;
	_tmp3_ = string_replace (_tmp2_, G_DIR_SEPARATOR_S, "/");
	referenceFilename = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	referenceDirectories = _tmp4_;
	referenceDirectories_length1 = 0;
	_referenceDirectories_size_ = referenceDirectories_length1;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	targetDirectories = _tmp5_;
	targetDirectories_length1 = 0;
	_targetDirectories_size_ = targetDirectories_length1;
	_tmp6_ = g_strdup ("");
	_result_ = _tmp6_;
	startIndex = 0;
	endIndex = 0;
	_tmp7_ = targetFilename;
	_tmp8_ = g_path_is_absolute (_tmp7_);
	if (!_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = rawTargetFilename;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_free0 (_result_);
		targetDirectories = (_vala_array_free (targetDirectories, targetDirectories_length1, (GDestroyNotify) g_free), NULL);
		referenceDirectories = (_vala_array_free (referenceDirectories, referenceDirectories_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (referenceFilename);
		_g_free0 (targetFilename);
		return result;
	}
	while (TRUE) {
		gint _tmp11_ = 0;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp11_ = endIndex;
		startIndex = _tmp11_ + 1;
		_tmp12_ = referenceFilename;
		_tmp13_ = startIndex;
		_tmp14_ = string_index_of (_tmp12_, "/", _tmp13_);
		endIndex = _tmp14_;
		_tmp15_ = endIndex;
		if (_tmp15_ == (-1)) {
			break;
		} else {
			gchar** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gchar* _tmp20_ = NULL;
			_tmp16_ = referenceDirectories;
			_tmp16__length1 = referenceDirectories_length1;
			_tmp17_ = referenceFilename;
			_tmp18_ = startIndex;
			_tmp19_ = endIndex;
			_tmp20_ = string_slice (_tmp17_, (glong) _tmp18_, (glong) _tmp19_);
			_vala_array_add16 (&referenceDirectories, &referenceDirectories_length1, &_referenceDirectories_size_, _tmp20_);
		}
	}
	startIndex = 0;
	endIndex = 0;
	while (TRUE) {
		gint _tmp21_ = 0;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		_tmp21_ = endIndex;
		startIndex = _tmp21_ + 1;
		_tmp22_ = targetFilename;
		_tmp23_ = startIndex;
		_tmp24_ = string_index_of (_tmp22_, "/", _tmp23_);
		endIndex = _tmp24_;
		_tmp25_ = endIndex;
		if (_tmp25_ == (-1)) {
			break;
		} else {
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gchar* _tmp30_ = NULL;
			_tmp26_ = targetDirectories;
			_tmp26__length1 = targetDirectories_length1;
			_tmp27_ = targetFilename;
			_tmp28_ = startIndex;
			_tmp29_ = endIndex;
			_tmp30_ = string_slice (_tmp27_, (glong) _tmp28_, (glong) _tmp29_);
			_vala_array_add17 (&targetDirectories, &targetDirectories_length1, &_targetDirectories_size_, _tmp30_);
		}
	}
	{
		gboolean _tmp31_ = FALSE;
		commonCount = 0;
		_tmp31_ = TRUE;
		while (TRUE) {
			gint _tmp33_ = 0;
			gchar** _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gchar** _tmp35_ = NULL;
			gint _tmp35__length1 = 0;
			gint _tmp36_ = 0;
			const gchar* _tmp37_ = NULL;
			gchar** _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			gint _tmp39_ = 0;
			const gchar* _tmp40_ = NULL;
			if (!_tmp31_) {
				gint _tmp32_ = 0;
				_tmp32_ = commonCount;
				commonCount = _tmp32_ + 1;
			}
			_tmp31_ = FALSE;
			_tmp33_ = commonCount;
			_tmp34_ = referenceDirectories;
			_tmp34__length1 = referenceDirectories_length1;
			if (!(_tmp33_ < _tmp34__length1)) {
				break;
			}
			_tmp35_ = referenceDirectories;
			_tmp35__length1 = referenceDirectories_length1;
			_tmp36_ = commonCount;
			_tmp37_ = _tmp35_[_tmp36_];
			_tmp38_ = targetDirectories;
			_tmp38__length1 = targetDirectories_length1;
			_tmp39_ = commonCount;
			_tmp40_ = _tmp38_[_tmp39_];
			if (g_strcmp0 (_tmp37_, _tmp40_) != 0) {
				break;
			}
		}
	}
	{
		gint i = 0;
		gint _tmp41_ = 0;
		_tmp41_ = commonCount;
		i = _tmp41_;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				gint _tmp44_ = 0;
				gchar** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				const gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				if (!_tmp42_) {
					gint _tmp43_ = 0;
					_tmp43_ = i;
					i = _tmp43_ + 1;
				}
				_tmp42_ = FALSE;
				_tmp44_ = i;
				_tmp45_ = referenceDirectories;
				_tmp45__length1 = referenceDirectories_length1;
				if (!(_tmp44_ < _tmp45__length1)) {
					break;
				}
				_tmp46_ = _result_;
				_tmp47_ = g_strconcat (_tmp46_, "../", NULL);
				_g_free0 (_result_);
				_result_ = _tmp47_;
			}
		}
	}
	{
		gint i = 0;
		gint _tmp48_ = 0;
		_tmp48_ = commonCount;
		i = _tmp48_;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				gint _tmp51_ = 0;
				gchar** _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				if (!_tmp49_) {
					gint _tmp50_ = 0;
					_tmp50_ = i;
					i = _tmp50_ + 1;
				}
				_tmp49_ = FALSE;
				_tmp51_ = i;
				_tmp52_ = targetDirectories;
				_tmp52__length1 = targetDirectories_length1;
				if (!(_tmp51_ < _tmp52__length1)) {
					break;
				}
				_tmp53_ = _result_;
				_tmp54_ = targetDirectories;
				_tmp54__length1 = targetDirectories_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				_tmp57_ = g_strconcat (_tmp56_, "/", NULL);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_strconcat (_tmp53_, _tmp58_, NULL);
				_g_free0 (_result_);
				_result_ = _tmp59_;
				_g_free0 (_tmp58_);
			}
		}
	}
	_tmp60_ = _result_;
	_tmp61_ = targetFilename;
	_tmp62_ = g_path_get_basename (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_strconcat (_tmp60_, _tmp63_, NULL);
	_g_free0 (_result_);
	_result_ = _tmp64_;
	_g_free0 (_tmp63_);
	result = _result_;
	targetDirectories = (_vala_array_free (targetDirectories, targetDirectories_length1, (GDestroyNotify) g_free), NULL);
	referenceDirectories = (_vala_array_free (referenceDirectories, referenceDirectories_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (referenceFilename);
	_g_free0 (targetFilename);
	return result;
}


/**
 * Returns the absolute filename based upon the current working directory
 * or a specified one.
 */
gchar* core_absolute_filename (const gchar* filename, const gchar* pwd) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (pwd != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (_tmp1_ == TRUE) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = filename;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = pwd;
	_tmp5_ = filename;
	_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = core_reduce_filename (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	return result;
}


/**
 * Simplifies a filename. For example, "./a/b\..\c/./d" would reduce to
 * "a/c/d"
 */
static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == (-1)) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp59_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != (-1)) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == (-1)) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp57_ = NULL;
				void* _tmp58_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				_tmp53_ = _tmp56_;
				if (_tmp53_ == NULL) {
					_tmp53_ = "";
				}
				_tmp57_ = ptr;
				_tmp58_ = g_stpcpy (_tmp57_, _tmp53_);
				ptr = _tmp58_;
			}
		}
		_tmp59_ = res;
		res = NULL;
		result = (gchar*) _tmp59_;
		return result;
	} else {
		gchar* _tmp60_ = NULL;
		_tmp60_ = g_strdup ("");
		result = _tmp60_;
		return result;
	}
}


gchar* core_reduce_filename (const gchar* rawFilename) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** rawParts = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint rawParts_length1 = 0;
	gint _rawParts_size_ = 0;
	gchar** reducedParts = NULL;
	gchar** _tmp5_ = NULL;
	gint reducedParts_length1 = 0;
	gint _reducedParts_size_ = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gchar* _tmp25_ = NULL;
	g_return_val_if_fail (rawFilename != NULL, NULL);
	_tmp0_ = rawFilename;
	_tmp1_ = string_replace (_tmp0_, G_DIR_SEPARATOR_S, "/");
	filename = _tmp1_;
	_tmp2_ = filename;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "/", 0);
	rawParts = _tmp4_;
	rawParts_length1 = _vala_array_length (_tmp3_);
	_rawParts_size_ = rawParts_length1;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	reducedParts = _tmp5_;
	reducedParts_length1 = 0;
	_reducedParts_size_ = reducedParts_length1;
	_tmp6_ = rawParts;
	_tmp6__length1 = rawParts_length1;
	{
		gchar** part_collection = NULL;
		gint part_collection_length1 = 0;
		gint _part_collection_size_ = 0;
		gint part_it = 0;
		part_collection = _tmp6_;
		part_collection_length1 = _tmp6__length1;
		for (part_it = 0; part_it < _tmp6__length1; part_it = part_it + 1) {
			gchar* _tmp7_ = NULL;
			gchar* part = NULL;
			_tmp7_ = g_strdup (part_collection[part_it]);
			part = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				_tmp8_ = part;
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string (".")))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("..")))) {
					switch (0) {
						default:
						{
							gchar** _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							_tmp12_ = reducedParts;
							_tmp12__length1 = reducedParts_length1;
							if (_tmp12__length1 == 0) {
								gchar** _tmp13_ = NULL;
								gint _tmp13__length1 = 0;
								gchar* _tmp14_ = NULL;
								_tmp13_ = reducedParts;
								_tmp13__length1 = reducedParts_length1;
								_tmp14_ = g_strdup ("..");
								_vala_array_add18 (&reducedParts, &reducedParts_length1, &_reducedParts_size_, _tmp14_);
							} else {
								gchar** _tmp15_ = NULL;
								gint _tmp15__length1 = 0;
								gchar** _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								const gchar* _tmp17_ = NULL;
								_tmp15_ = reducedParts;
								_tmp15__length1 = reducedParts_length1;
								_tmp16_ = reducedParts;
								_tmp16__length1 = reducedParts_length1;
								_tmp17_ = _tmp15_[_tmp16__length1 - 1];
								if (g_strcmp0 (_tmp17_, "..") == 0) {
									gchar** _tmp18_ = NULL;
									gint _tmp18__length1 = 0;
									gchar* _tmp19_ = NULL;
									_tmp18_ = reducedParts;
									_tmp18__length1 = reducedParts_length1;
									_tmp19_ = g_strdup ("..");
									_vala_array_add19 (&reducedParts, &reducedParts_length1, &_reducedParts_size_, _tmp19_);
								} else {
									gint _tmp20_ = 0;
									_tmp20_ = reducedParts_length1;
									reducedParts_length1 = _tmp20_ - 1;
								}
							}
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp21_ = NULL;
							gint _tmp21__length1 = 0;
							const gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							_tmp21_ = reducedParts;
							_tmp21__length1 = reducedParts_length1;
							_tmp22_ = part;
							_tmp23_ = g_strdup (_tmp22_);
							_vala_array_add20 (&reducedParts, &reducedParts_length1, &_reducedParts_size_, _tmp23_);
							break;
						}
					}
				}
				_g_free0 (part);
			}
		}
	}
	_tmp24_ = reducedParts;
	_tmp24__length1 = reducedParts_length1;
	_tmp25_ = _vala_g_strjoinv ("/", _tmp24_, _tmp24__length1);
	result = _tmp25_;
	reducedParts = (_vala_array_free (reducedParts, reducedParts_length1, (GDestroyNotify) g_free), NULL);
	rawParts = (_vala_array_free (rawParts, rawParts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (filename);
	return result;
}


/**
 * Compares version strings and returns a VersionComparison such that
 * If //whatVersion// is ahead of //withVersion//, GREATER is returned.
 */
VersionComparison core_compare_versions (const gchar* whatVersion, const gchar* withVersion) {
	VersionComparison result = 0;
	gint* whatNumbers = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint whatNumbers_length1 = 0;
	gint _whatNumbers_size_ = 0;
	gint* withNumbers = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint* _tmp5_ = NULL;
	gint withNumbers_length1 = 0;
	gint _withNumbers_size_ = 0;
	gint* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	g_return_val_if_fail (whatVersion != NULL, 0);
	g_return_val_if_fail (withVersion != NULL, 0);
	_tmp0_ = whatVersion;
	_tmp2_ = core_version_to_numbers (_tmp0_, &_tmp1_);
	whatNumbers = _tmp2_;
	whatNumbers_length1 = _tmp1_;
	_whatNumbers_size_ = whatNumbers_length1;
	_tmp3_ = withVersion;
	_tmp5_ = core_version_to_numbers (_tmp3_, &_tmp4_);
	withNumbers = _tmp5_;
	withNumbers_length1 = _tmp4_;
	_withNumbers_size_ = withNumbers_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint _tmp9_ = 0;
				gint* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = whatNumbers;
				_tmp10__length1 = whatNumbers_length1;
				if (_tmp9_ < _tmp10__length1) {
					gint _tmp11_ = 0;
					gint* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					_tmp11_ = i;
					_tmp12_ = withNumbers;
					_tmp12__length1 = withNumbers_length1;
					_tmp8_ = _tmp11_ < _tmp12__length1;
				} else {
					_tmp8_ = FALSE;
				}
				if (!_tmp8_) {
					break;
				}
				_tmp13_ = whatNumbers;
				_tmp13__length1 = whatNumbers_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = withNumbers;
				_tmp16__length1 = withNumbers_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				if (_tmp15_ > _tmp18_) {
					result = VERSION_COMPARISON_GREATER;
					withNumbers = (g_free (withNumbers), NULL);
					whatNumbers = (g_free (whatNumbers), NULL);
					return result;
				} else {
					gint* _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					gint* _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					_tmp19_ = whatNumbers;
					_tmp19__length1 = whatNumbers_length1;
					_tmp20_ = i;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp22_ = withNumbers;
					_tmp22__length1 = withNumbers_length1;
					_tmp23_ = i;
					_tmp24_ = _tmp22_[_tmp23_];
					if (_tmp21_ < _tmp24_) {
						result = VERSION_COMPARISON_LESS;
						withNumbers = (g_free (withNumbers), NULL);
						whatNumbers = (g_free (whatNumbers), NULL);
						return result;
					}
				}
			}
		}
	}
	_tmp25_ = whatNumbers;
	_tmp25__length1 = whatNumbers_length1;
	_tmp26_ = withNumbers;
	_tmp26__length1 = withNumbers_length1;
	if (_tmp25__length1 > _tmp26__length1) {
		result = VERSION_COMPARISON_GREATER;
		withNumbers = (g_free (withNumbers), NULL);
		whatNumbers = (g_free (whatNumbers), NULL);
		return result;
	} else {
		gint* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gint* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		_tmp27_ = whatNumbers;
		_tmp27__length1 = whatNumbers_length1;
		_tmp28_ = withNumbers;
		_tmp28__length1 = withNumbers_length1;
		if (_tmp27__length1 < _tmp28__length1) {
			result = VERSION_COMPARISON_LESS;
			withNumbers = (g_free (withNumbers), NULL);
			whatNumbers = (g_free (whatNumbers), NULL);
			return result;
		}
	}
	result = VERSION_COMPARISON_EQUAL;
	withNumbers = (g_free (withNumbers), NULL);
	whatNumbers = (g_free (whatNumbers), NULL);
	return result;
}


/**
 * Translates a version string to an array of numbers.
 */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void _vala_array_add21 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add22 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gint* core_version_to_numbers (const gchar* version, int* result_length1) {
	gint* result = NULL;
	gint* numbers = NULL;
	gint* _tmp0_ = NULL;
	gint numbers_length1 = 0;
	gint _numbers_size_ = 0;
	guint8* data = NULL;
	const gchar* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	gchar* number = NULL;
	gchar* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp16_ = NULL;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	g_return_val_if_fail (version != NULL, NULL);
	_tmp0_ = g_new0 (gint, 0);
	numbers = _tmp0_;
	numbers_length1 = 0;
	_numbers_size_ = numbers_length1;
	_tmp1_ = version;
	_tmp2_ = string_get_data (_tmp1_, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup3 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	data = _tmp4_;
	data_length1 = _tmp4__length1;
	_data_size_ = data_length1;
	_tmp5_ = g_strdup ("");
	number = _tmp5_;
	_tmp6_ = data;
	_tmp6__length1 = data_length1;
	{
		guint8* datum_collection = NULL;
		gint datum_collection_length1 = 0;
		gint _datum_collection_size_ = 0;
		gint datum_it = 0;
		datum_collection = _tmp6_;
		datum_collection_length1 = _tmp6__length1;
		for (datum_it = 0; datum_it < _tmp6__length1; datum_it = datum_it + 1) {
			guint8 datum = 0U;
			datum = datum_collection[datum_it];
			{
				guint8 _tmp7_ = 0U;
				_tmp7_ = datum;
				switch (_tmp7_) {
					default:
					{
						const gchar* _tmp8_ = NULL;
						_tmp8_ = number;
						if (g_strcmp0 (_tmp8_, "") != 0) {
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							const gchar* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							gchar* _tmp12_ = NULL;
							_tmp9_ = numbers;
							_tmp9__length1 = numbers_length1;
							_tmp10_ = number;
							_tmp11_ = atoi (_tmp10_);
							_vala_array_add21 (&numbers, &numbers_length1, &_numbers_size_, _tmp11_);
							_tmp12_ = g_strdup ("");
							_g_free0 (number);
							number = _tmp12_;
						}
						break;
					}
					case '0':
					case '1':
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
					{
						const gchar* _tmp13_ = NULL;
						guint8 _tmp14_ = 0U;
						gchar* _tmp15_ = NULL;
						_tmp13_ = number;
						_tmp14_ = datum;
						_tmp15_ = g_strdup_printf ("%s%c", _tmp13_, (gint) _tmp14_);
						_g_free0 (number);
						number = _tmp15_;
						break;
					}
				}
			}
		}
	}
	_tmp16_ = number;
	if (g_strcmp0 (_tmp16_, "") != 0) {
		gint* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		_tmp17_ = numbers;
		_tmp17__length1 = numbers_length1;
		_tmp18_ = number;
		_tmp19_ = atoi (_tmp18_);
		_vala_array_add22 (&numbers, &numbers_length1, &_numbers_size_, _tmp19_);
		_tmp20_ = g_strdup ("");
		_g_free0 (number);
		number = _tmp20_;
	}
	_tmp21_ = numbers;
	_tmp21__length1 = numbers_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	_g_free0 (number);
	data = (g_free (data), NULL);
	return result;
}


Core* core_construct (GType object_type) {
	Core* self = NULL;
	self = (Core*) g_type_create_instance (object_type);
	return self;
}


Core* core_new (void) {
	return core_construct (TYPE_CORE);
}


static void value_core_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_core_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		core_unref (value->data[0].v_pointer);
	}
}


static void value_core_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = core_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_core_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_core_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Core* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = core_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_core_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Core** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = core_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_core (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCore* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CORE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_core (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CORE), NULL);
	return value->data[0].v_pointer;
}


void value_set_core (GValue* value, gpointer v_object) {
	Core* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		core_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		core_unref (old);
	}
}


void value_take_core (GValue* value, gpointer v_object) {
	Core* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CORE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CORE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		core_unref (old);
	}
}


static void core_class_init (CoreClass * klass) {
	gchar* _tmp0_ = NULL;
	core_parent_class = g_type_class_peek_parent (klass);
	CORE_CLASS (klass)->finalize = core_finalize;
	_tmp0_ = g_strdup ("");
	core_fullLicenseText = _tmp0_;
}


static void core_instance_init (Core * self) {
	self->ref_count = 1;
}


static void core_finalize (Core* obj) {
	Core * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CORE, Core);
}


/**
 * Contains the main function. Handles initial load up and contains
 * package information.
 */
GType core_get_type (void) {
	static volatile gsize core_type_id__volatile = 0;
	if (g_once_init_enter (&core_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_core_init, value_core_free_value, value_core_copy_value, value_core_peek_pointer, "p", value_core_collect_value, "p", value_core_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) core_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Core), 0, (GInstanceInitFunc) core_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType core_type_id;
		core_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Core", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&core_type_id__volatile, core_type_id);
	}
	return core_type_id__volatile;
}


gpointer core_ref (gpointer instance) {
	Core* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void core_unref (gpointer instance) {
	Core* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CORE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



