/* path.c generated by valac 0.24.0, the Vala compiler
 * generated from path.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: path.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;
typedef struct _PathPrivate PathPrivate;

#define PATH_TYPE_LINE (path_line_get_type ())

#define TYPE_DIRECTION (direction_get_type ())
typedef struct _PathLine PathLine;
typedef struct _ParamSpecPath ParamSpecPath;

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _PathLine {
	gint x1;
	gint y1;
	gint x2;
	gint y2;
	Direction dir;
};

struct _Path {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PathPrivate * priv;
	PathLine* lines;
	gint lines_length1;
	gint last;
	gint xLast;
	gint yLast;
	gint xLineStart;
	gint yLineStart;
	Direction dirLast;
};

struct _PathClass {
	GTypeClass parent_class;
	void (*finalize) (Path *self);
};

struct _ParamSpecPath {
	GParamSpec parent_instance;
};


static gpointer path_parent_class = NULL;

gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
GType path_line_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
PathLine* path_line_dup (const PathLine* self);
void path_line_free (PathLine* self);
enum  {
	PATH_DUMMY_PROPERTY
};
Path* path_new (gint xStart, gint yStart);
Path* path_construct (GType object_type, gint xStart, gint yStart);
void path_merge (Path* self, Path* extraPath, gboolean prepend, gboolean reverse);
static void _vala_array_add64 (PathLine** array, int* length, int* size, const PathLine* value);
static PathLine* _vala_array_dup47 (PathLine* self, int length);
static PathLine* _vala_array_dup48 (PathLine* self, int length);
static PathLine* _vala_array_dup49 (PathLine* self, int length);
static PathLine* _vala_array_dup50 (PathLine* self, int length);
static PathLine* _vala_array_dup51 (PathLine* self, int length);
static void _vala_array_add65 (PathLine** array, int* length, int* size, const PathLine* value);
static PathLine* _vala_array_dup52 (PathLine* self, int length);
gint path_append (Path* self, gint x, gint y, gfloat diagonalThreshold);
static PathLine* _vala_array_dup53 (PathLine* self, int length);
static void _vala_array_add66 (PathLine** array, int* length, int* size, const PathLine* value);
static PathLine* _vala_array_dup54 (PathLine* self, int length);
gint path_find (Path* self, gint x, gint y);
void path_move (Path* self, gint x, gint y);
void path_render (Path* self, cairo_t* context);
static void path_finalize (Path* obj);


/**
 * Creates a new path which starts at (//xStart//, //yStart//).
 */
Path* path_construct (GType object_type, gint xStart, gint yStart) {
	Path* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = (Path*) g_type_create_instance (object_type);
	self->last = -1;
	_tmp0_ = xStart;
	self->xLast = _tmp0_;
	_tmp1_ = yStart;
	self->yLast = _tmp1_;
	_tmp2_ = xStart;
	self->xLineStart = _tmp2_;
	_tmp3_ = yStart;
	self->yLineStart = _tmp3_;
	self->dirLast = DIRECTION_NONE;
	return self;
}


Path* path_new (gint xStart, gint yStart) {
	return path_construct (TYPE_PATH, xStart, yStart);
}


static void _vala_array_add64 (PathLine** array, int* length, int* size, const PathLine* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PathLine, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static PathLine* _vala_array_dup47 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


static PathLine* _vala_array_dup48 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


static PathLine* _vala_array_dup49 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


static PathLine* _vala_array_dup50 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


static PathLine* _vala_array_dup51 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


static void _vala_array_add65 (PathLine** array, int* length, int* size, const PathLine* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PathLine, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static PathLine* _vala_array_dup52 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


void path_merge (Path* self, Path* extraPath, gboolean prepend, gboolean reverse) {
	PathLine* newLines = NULL;
	gint newLines_length1 = 0;
	gint _newLines_size_ = 0;
	PathLine* lastLines = NULL;
	gint lastLines_length1 = 0;
	gint _lastLines_size_ = 0;
	PathLine* extraLines = NULL;
	gint extraLines_length1 = 0;
	gint _extraLines_size_ = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp37_ = FALSE;
	PathLine* _tmp81_ = NULL;
	gint _tmp81__length1 = 0;
	PathLine* _tmp82_ = NULL;
	gint _tmp82__length1 = 0;
	PathLine* _tmp83_ = NULL;
	gint _tmp83__length1 = 0;
	PathLine* _tmp84_ = NULL;
	gint _tmp84__length1 = 0;
	gint _tmp85_ = 0;
	PathLine _tmp86_ = {0};
	gint _tmp87_ = 0;
	PathLine* _tmp88_ = NULL;
	gint _tmp88__length1 = 0;
	gint _tmp89_ = 0;
	PathLine _tmp90_ = {0};
	gint _tmp91_ = 0;
	PathLine* _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	gint _tmp93_ = 0;
	PathLine _tmp94_ = {0};
	gint _tmp95_ = 0;
	PathLine* _tmp96_ = NULL;
	gint _tmp96__length1 = 0;
	gint _tmp97_ = 0;
	PathLine _tmp98_ = {0};
	gint _tmp99_ = 0;
	PathLine* _tmp100_ = NULL;
	gint _tmp100__length1 = 0;
	gint _tmp101_ = 0;
	PathLine _tmp102_ = {0};
	Direction _tmp103_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (extraPath != NULL);
	_tmp0_ = reverse;
	if (_tmp0_) {
		PathLine* _tmp1_ = NULL;
		_tmp1_ = g_new0 (PathLine, 0);
		extraLines = (g_free (extraLines), NULL);
		extraLines = _tmp1_;
		extraLines_length1 = 0;
		_extraLines_size_ = extraLines_length1;
		{
			gint i = 0;
			Path* _tmp2_ = NULL;
			PathLine* _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			_tmp2_ = extraPath;
			_tmp3_ = _tmp2_->lines;
			_tmp3__length1 = _tmp2_->lines_length1;
			i = _tmp3__length1 - 1;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gint _tmp6_ = 0;
					PathLine reversedLine = {0};
					Path* _tmp7_ = NULL;
					PathLine* _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					PathLine _tmp10_ = {0};
					gint _tmp11_ = 0;
					Path* _tmp12_ = NULL;
					PathLine* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gint _tmp14_ = 0;
					PathLine _tmp15_ = {0};
					gint _tmp16_ = 0;
					Path* _tmp17_ = NULL;
					PathLine* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp19_ = 0;
					PathLine _tmp20_ = {0};
					gint _tmp21_ = 0;
					Path* _tmp22_ = NULL;
					PathLine* _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gint _tmp24_ = 0;
					PathLine _tmp25_ = {0};
					gint _tmp26_ = 0;
					Path* _tmp27_ = NULL;
					PathLine* _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					gint _tmp29_ = 0;
					PathLine _tmp30_ = {0};
					Direction _tmp31_ = 0;
					PathLine* _tmp32_ = NULL;
					gint _tmp32__length1 = 0;
					PathLine _tmp33_ = {0};
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = i;
						i = _tmp5_ - 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ >= 0)) {
						break;
					}
					memset (&reversedLine, 0, sizeof (PathLine));
					_tmp7_ = extraPath;
					_tmp8_ = _tmp7_->lines;
					_tmp8__length1 = _tmp7_->lines_length1;
					_tmp9_ = i;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp11_ = _tmp10_.x2;
					reversedLine.x1 = _tmp11_;
					_tmp12_ = extraPath;
					_tmp13_ = _tmp12_->lines;
					_tmp13__length1 = _tmp12_->lines_length1;
					_tmp14_ = i;
					_tmp15_ = _tmp13_[_tmp14_];
					_tmp16_ = _tmp15_.x1;
					reversedLine.x2 = _tmp16_;
					_tmp17_ = extraPath;
					_tmp18_ = _tmp17_->lines;
					_tmp18__length1 = _tmp17_->lines_length1;
					_tmp19_ = i;
					_tmp20_ = _tmp18_[_tmp19_];
					_tmp21_ = _tmp20_.y2;
					reversedLine.y1 = _tmp21_;
					_tmp22_ = extraPath;
					_tmp23_ = _tmp22_->lines;
					_tmp23__length1 = _tmp22_->lines_length1;
					_tmp24_ = i;
					_tmp25_ = _tmp23_[_tmp24_];
					_tmp26_ = _tmp25_.y1;
					reversedLine.y2 = _tmp26_;
					_tmp27_ = extraPath;
					_tmp28_ = _tmp27_->lines;
					_tmp28__length1 = _tmp27_->lines_length1;
					_tmp29_ = i;
					_tmp30_ = _tmp28_[_tmp29_];
					_tmp31_ = _tmp30_.dir;
					reversedLine.dir = _tmp31_;
					_tmp32_ = extraLines;
					_tmp32__length1 = extraLines_length1;
					_tmp33_ = reversedLine;
					_vala_array_add64 (&extraLines, &extraLines_length1, &_extraLines_size_, &_tmp33_);
				}
			}
		}
	} else {
		Path* _tmp34_ = NULL;
		PathLine* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		PathLine* _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		_tmp34_ = extraPath;
		_tmp35_ = _tmp34_->lines;
		_tmp35__length1 = _tmp34_->lines_length1;
		_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup47 (_tmp35_, _tmp35__length1) : ((gpointer) _tmp35_);
		_tmp36__length1 = _tmp35__length1;
		extraLines = (g_free (extraLines), NULL);
		extraLines = _tmp36_;
		extraLines_length1 = _tmp36__length1;
		_extraLines_size_ = extraLines_length1;
	}
	_tmp37_ = prepend;
	if (_tmp37_) {
		PathLine* _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		PathLine* _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		PathLine* _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		PathLine* _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		_tmp38_ = extraLines;
		_tmp38__length1 = extraLines_length1;
		_tmp39_ = (_tmp38_ != NULL) ? _vala_array_dup48 (_tmp38_, _tmp38__length1) : ((gpointer) _tmp38_);
		_tmp39__length1 = _tmp38__length1;
		newLines = (g_free (newLines), NULL);
		newLines = _tmp39_;
		newLines_length1 = _tmp39__length1;
		_newLines_size_ = newLines_length1;
		_tmp40_ = self->lines;
		_tmp40__length1 = self->lines_length1;
		_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup49 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
		_tmp41__length1 = _tmp40__length1;
		lastLines = (g_free (lastLines), NULL);
		lastLines = _tmp41_;
		lastLines_length1 = _tmp41__length1;
		_lastLines_size_ = lastLines_length1;
	} else {
		PathLine* _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		PathLine* _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		PathLine* _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
		PathLine* _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		_tmp42_ = self->lines;
		_tmp42__length1 = self->lines_length1;
		_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup50 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
		_tmp43__length1 = _tmp42__length1;
		newLines = (g_free (newLines), NULL);
		newLines = _tmp43_;
		newLines_length1 = _tmp43__length1;
		_newLines_size_ = newLines_length1;
		_tmp44_ = extraLines;
		_tmp44__length1 = extraLines_length1;
		_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup51 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
		_tmp45__length1 = _tmp44__length1;
		lastLines = (g_free (lastLines), NULL);
		lastLines = _tmp45_;
		lastLines_length1 = _tmp45__length1;
		_lastLines_size_ = lastLines_length1;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp46_ = FALSE;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				PathLine* _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				gint _tmp50_ = 0;
				PathLine* _tmp77_ = NULL;
				gint _tmp77__length1 = 0;
				PathLine* _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				gint _tmp79_ = 0;
				PathLine _tmp80_ = {0};
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = lastLines;
				_tmp49__length1 = lastLines_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = i;
				if (_tmp50_ == 0) {
					gint lastNew = 0;
					PathLine* _tmp51_ = NULL;
					gint _tmp51__length1 = 0;
					gboolean _tmp52_ = FALSE;
					PathLine* _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					gint _tmp54_ = 0;
					PathLine _tmp55_ = {0};
					Direction _tmp56_ = 0;
					PathLine* _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					PathLine _tmp59_ = {0};
					Direction _tmp60_ = 0;
					_tmp51_ = newLines;
					_tmp51__length1 = newLines_length1;
					lastNew = _tmp51__length1 - 1;
					_tmp53_ = newLines;
					_tmp53__length1 = newLines_length1;
					_tmp54_ = lastNew;
					_tmp55_ = _tmp53_[_tmp54_];
					_tmp56_ = _tmp55_.dir;
					_tmp57_ = lastLines;
					_tmp57__length1 = lastLines_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp60_ = _tmp59_.dir;
					if (_tmp56_ == _tmp60_) {
						PathLine* _tmp61_ = NULL;
						gint _tmp61__length1 = 0;
						gint _tmp62_ = 0;
						PathLine _tmp63_ = {0};
						Direction _tmp64_ = 0;
						_tmp61_ = newLines;
						_tmp61__length1 = newLines_length1;
						_tmp62_ = lastNew;
						_tmp63_ = _tmp61_[_tmp62_];
						_tmp64_ = _tmp63_.dir;
						_tmp52_ = _tmp64_ != DIRECTION_DIAGONAL;
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						PathLine* _tmp65_ = NULL;
						gint _tmp65__length1 = 0;
						gint _tmp66_ = 0;
						PathLine* _tmp67_ = NULL;
						gint _tmp67__length1 = 0;
						gint _tmp68_ = 0;
						PathLine _tmp69_ = {0};
						gint _tmp70_ = 0;
						PathLine* _tmp71_ = NULL;
						gint _tmp71__length1 = 0;
						gint _tmp72_ = 0;
						PathLine* _tmp73_ = NULL;
						gint _tmp73__length1 = 0;
						gint _tmp74_ = 0;
						PathLine _tmp75_ = {0};
						gint _tmp76_ = 0;
						_tmp65_ = newLines;
						_tmp65__length1 = newLines_length1;
						_tmp66_ = lastNew;
						_tmp67_ = lastLines;
						_tmp67__length1 = lastLines_length1;
						_tmp68_ = i;
						_tmp69_ = _tmp67_[_tmp68_];
						_tmp70_ = _tmp69_.x2;
						_tmp65_[_tmp66_].x2 = _tmp70_;
						_tmp71_ = newLines;
						_tmp71__length1 = newLines_length1;
						_tmp72_ = lastNew;
						_tmp73_ = lastLines;
						_tmp73__length1 = lastLines_length1;
						_tmp74_ = i;
						_tmp75_ = _tmp73_[_tmp74_];
						_tmp76_ = _tmp75_.y2;
						_tmp71_[_tmp72_].y2 = _tmp76_;
						continue;
					}
				}
				_tmp77_ = newLines;
				_tmp77__length1 = newLines_length1;
				_tmp78_ = lastLines;
				_tmp78__length1 = lastLines_length1;
				_tmp79_ = i;
				_tmp80_ = _tmp78_[_tmp79_];
				_vala_array_add65 (&newLines, &newLines_length1, &_newLines_size_, &_tmp80_);
			}
		}
	}
	_tmp81_ = newLines;
	_tmp81__length1 = newLines_length1;
	_tmp82_ = (_tmp81_ != NULL) ? _vala_array_dup52 (_tmp81_, _tmp81__length1) : ((gpointer) _tmp81_);
	_tmp82__length1 = _tmp81__length1;
	self->lines = (g_free (self->lines), NULL);
	self->lines = _tmp82_;
	self->lines_length1 = _tmp82__length1;
	_tmp83_ = self->lines;
	_tmp83__length1 = self->lines_length1;
	self->last = _tmp83__length1 - 1;
	_tmp84_ = self->lines;
	_tmp84__length1 = self->lines_length1;
	_tmp85_ = self->last;
	_tmp86_ = _tmp84_[_tmp85_];
	_tmp87_ = _tmp86_.x2;
	self->xLast = _tmp87_;
	_tmp88_ = self->lines;
	_tmp88__length1 = self->lines_length1;
	_tmp89_ = self->last;
	_tmp90_ = _tmp88_[_tmp89_];
	_tmp91_ = _tmp90_.y2;
	self->yLast = _tmp91_;
	_tmp92_ = self->lines;
	_tmp92__length1 = self->lines_length1;
	_tmp93_ = self->last;
	_tmp94_ = _tmp92_[_tmp93_];
	_tmp95_ = _tmp94_.x1;
	self->xLineStart = _tmp95_;
	_tmp96_ = self->lines;
	_tmp96__length1 = self->lines_length1;
	_tmp97_ = self->last;
	_tmp98_ = _tmp96_[_tmp97_];
	_tmp99_ = _tmp98_.y1;
	self->yLineStart = _tmp99_;
	_tmp100_ = self->lines;
	_tmp100__length1 = self->lines_length1;
	_tmp101_ = self->last;
	_tmp102_ = _tmp100_[_tmp101_];
	_tmp103_ = _tmp102_.dir;
	self->dirLast = _tmp103_;
	extraLines = (g_free (extraLines), NULL);
	lastLines = (g_free (lastLines), NULL);
	newLines = (g_free (newLines), NULL);
}


/**
 * Add a point to the path. Returns 1 if a paths should finallise.
 * Returns 2 if a point should be undone.
 */
static PathLine* _vala_array_dup53 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


static void _vala_array_add66 (PathLine** array, int* length, int* size, const PathLine* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PathLine, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static PathLine* _vala_array_dup54 (PathLine* self, int length) {
	return g_memdup (self, length * sizeof (PathLine));
}


gint path_append (Path* self, gint x, gint y, gfloat diagonalThreshold) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint xDiff = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint yDiff = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint xDiffAbs = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint yDiffAbs = 0;
	PathLine* newLines = NULL;
	PathLine* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	PathLine* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint newLines_length1 = 0;
	gint _newLines_size_ = 0;
	PathLine line = {0};
	gboolean lineAdded = FALSE;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	PathLine* _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	gint _tmp102_ = 0;
	PathLine _tmp103_ = {0};
	gint _tmp104_ = 0;
	PathLine* _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	gint _tmp106_ = 0;
	PathLine _tmp107_ = {0};
	gint _tmp108_ = 0;
	PathLine* _tmp109_ = NULL;
	gint _tmp109__length1 = 0;
	gint _tmp110_ = 0;
	PathLine _tmp111_ = {0};
	gint _tmp112_ = 0;
	PathLine* _tmp113_ = NULL;
	gint _tmp113__length1 = 0;
	gint _tmp114_ = 0;
	PathLine _tmp115_ = {0};
	gint _tmp116_ = 0;
	PathLine* _tmp117_ = NULL;
	gint _tmp117__length1 = 0;
	PathLine* _tmp118_ = NULL;
	gint _tmp118__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = x;
	_tmp2_ = self->xLast;
	if (_tmp1_ == _tmp2_) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		_tmp3_ = y;
		_tmp4_ = self->yLast;
		_tmp0_ = _tmp3_ == _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp5_ = FALSE;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = x;
		_tmp7_ = self->xLineStart;
		if (_tmp6_ == _tmp7_) {
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			_tmp8_ = y;
			_tmp9_ = self->yLineStart;
			_tmp5_ = _tmp8_ == _tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = 2;
			return result;
		} else {
			result = 1;
			return result;
		}
	}
	_tmp10_ = x;
	_tmp11_ = self->xLast;
	xDiff = _tmp10_ - _tmp11_;
	_tmp12_ = y;
	_tmp13_ = self->yLast;
	yDiff = _tmp12_ - _tmp13_;
	_tmp15_ = xDiff;
	if (_tmp15_ > 0) {
		gint _tmp16_ = 0;
		_tmp16_ = xDiff;
		_tmp14_ = _tmp16_;
	} else {
		gint _tmp17_ = 0;
		_tmp17_ = xDiff;
		_tmp14_ = -_tmp17_;
	}
	xDiffAbs = _tmp14_;
	_tmp19_ = yDiff;
	if (_tmp19_ > 0) {
		gint _tmp20_ = 0;
		_tmp20_ = yDiff;
		_tmp18_ = _tmp20_;
	} else {
		gint _tmp21_ = 0;
		_tmp21_ = yDiff;
		_tmp18_ = -_tmp21_;
	}
	yDiffAbs = _tmp18_;
	_tmp22_ = self->lines;
	_tmp22__length1 = self->lines_length1;
	_tmp23_ = (_tmp22_ != NULL) ? _vala_array_dup53 (_tmp22_, _tmp22__length1) : ((gpointer) _tmp22_);
	_tmp23__length1 = _tmp22__length1;
	newLines = _tmp23_;
	newLines_length1 = _tmp23__length1;
	_newLines_size_ = newLines_length1;
	memset (&line, 0, sizeof (PathLine));
	lineAdded = FALSE;
	_tmp25_ = x;
	_tmp26_ = self->xLineStart;
	if (_tmp25_ == _tmp26_) {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		_tmp27_ = y;
		_tmp28_ = self->yLineStart;
		_tmp24_ = _tmp27_ == _tmp28_;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		_tmp29_ = self->last;
		self->last = _tmp29_ - 1;
		_tmp30_ = newLines_length1;
		newLines_length1 = _tmp30_ - 1;
		_tmp31_ = self->last;
		if (_tmp31_ == (-1)) {
			result = 2;
			newLines = (g_free (newLines), NULL);
			return result;
		} else {
			PathLine* _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gint _tmp33_ = 0;
			PathLine _tmp34_ = {0};
			Direction _tmp35_ = 0;
			_tmp32_ = newLines;
			_tmp32__length1 = newLines_length1;
			_tmp33_ = self->last;
			_tmp34_ = _tmp32_[_tmp33_];
			_tmp35_ = _tmp34_.dir;
			self->dirLast = _tmp35_;
		}
	} else {
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		gboolean _tmp96_ = FALSE;
		_tmp36_ = xDiffAbs;
		_tmp37_ = yDiffAbs;
		if (_tmp36_ > _tmp37_) {
			gboolean _tmp38_ = FALSE;
			gint _tmp39_ = 0;
			gfloat _tmp40_ = 0.0F;
			gint _tmp41_ = 0;
			_tmp39_ = yDiffAbs;
			_tmp40_ = diagonalThreshold;
			_tmp41_ = xDiffAbs;
			if (((gfloat) _tmp39_) < (_tmp40_ * ((gfloat) _tmp41_))) {
				_tmp38_ = TRUE;
			} else {
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				_tmp42_ = y;
				_tmp43_ = self->yLast;
				_tmp38_ = _tmp42_ == _tmp43_;
			}
			if (_tmp38_) {
				Direction _tmp44_ = 0;
				_tmp44_ = self->dirLast;
				switch (_tmp44_) {
					case DIRECTION_NONE:
					{
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gint _tmp47_ = 0;
						gint _tmp48_ = 0;
						self->dirLast = DIRECTION_HORIZONTAL;
						_tmp45_ = self->xLast;
						line.x1 = _tmp45_;
						_tmp46_ = self->yLast;
						line.y1 = _tmp46_;
						_tmp47_ = x;
						line.x2 = _tmp47_;
						_tmp48_ = self->yLast;
						line.y2 = _tmp48_;
						lineAdded = TRUE;
						break;
					}
					case DIRECTION_HORIZONTAL:
					{
						PathLine* _tmp49_ = NULL;
						gint _tmp49__length1 = 0;
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
						self->dirLast = DIRECTION_HORIZONTAL;
						_tmp49_ = newLines;
						_tmp49__length1 = newLines_length1;
						_tmp50_ = self->last;
						_tmp51_ = x;
						_tmp49_[_tmp50_].x2 = _tmp51_;
						break;
					}
					case DIRECTION_VERTICAL:
					{
						PathLine* _tmp52_ = NULL;
						gint _tmp52__length1 = 0;
						gint _tmp53_ = 0;
						gint _tmp54_ = 0;
						gint _tmp55_ = 0;
						gint _tmp56_ = 0;
						gint _tmp57_ = 0;
						gint _tmp58_ = 0;
						_tmp52_ = newLines;
						_tmp52__length1 = newLines_length1;
						_tmp53_ = self->last;
						_tmp54_ = y;
						_tmp52_[_tmp53_].y2 = _tmp54_;
						self->dirLast = DIRECTION_HORIZONTAL;
						_tmp55_ = self->xLast;
						line.x1 = _tmp55_;
						_tmp56_ = y;
						line.y1 = _tmp56_;
						_tmp57_ = x;
						line.x2 = _tmp57_;
						_tmp58_ = y;
						line.y2 = _tmp58_;
						lineAdded = TRUE;
						break;
					}
					case DIRECTION_DIAGONAL:
					{
						gint _tmp59_ = 0;
						gint _tmp60_ = 0;
						gint _tmp61_ = 0;
						gint _tmp62_ = 0;
						self->dirLast = DIRECTION_HORIZONTAL;
						_tmp59_ = self->xLast;
						line.x1 = _tmp59_;
						_tmp60_ = self->yLast;
						line.y1 = _tmp60_;
						_tmp61_ = x;
						line.x2 = _tmp61_;
						_tmp62_ = self->yLast;
						line.y2 = _tmp62_;
						lineAdded = TRUE;
						break;
					}
					default:
					break;
				}
			} else {
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gint _tmp66_ = 0;
				self->dirLast = DIRECTION_DIAGONAL;
				_tmp63_ = self->xLast;
				line.x1 = _tmp63_;
				_tmp64_ = self->yLast;
				line.y1 = _tmp64_;
				_tmp65_ = x;
				line.x2 = _tmp65_;
				_tmp66_ = y;
				line.y2 = _tmp66_;
				lineAdded = TRUE;
			}
		} else {
			gboolean _tmp67_ = FALSE;
			gint _tmp68_ = 0;
			gfloat _tmp69_ = 0.0F;
			gint _tmp70_ = 0;
			_tmp68_ = xDiffAbs;
			_tmp69_ = diagonalThreshold;
			_tmp70_ = yDiffAbs;
			if (((gfloat) _tmp68_) < (_tmp69_ * ((gfloat) _tmp70_))) {
				_tmp67_ = TRUE;
			} else {
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				_tmp71_ = x;
				_tmp72_ = self->xLast;
				_tmp67_ = _tmp71_ == _tmp72_;
			}
			if (_tmp67_) {
				Direction _tmp73_ = 0;
				_tmp73_ = self->dirLast;
				switch (_tmp73_) {
					case DIRECTION_NONE:
					{
						gint _tmp74_ = 0;
						gint _tmp75_ = 0;
						gint _tmp76_ = 0;
						gint _tmp77_ = 0;
						self->dirLast = DIRECTION_VERTICAL;
						_tmp74_ = self->xLast;
						line.x1 = _tmp74_;
						_tmp75_ = self->yLast;
						line.y1 = _tmp75_;
						_tmp76_ = self->xLast;
						line.x2 = _tmp76_;
						_tmp77_ = y;
						line.y2 = _tmp77_;
						lineAdded = TRUE;
						break;
					}
					case DIRECTION_VERTICAL:
					{
						PathLine* _tmp78_ = NULL;
						gint _tmp78__length1 = 0;
						gint _tmp79_ = 0;
						gint _tmp80_ = 0;
						self->dirLast = DIRECTION_VERTICAL;
						_tmp78_ = newLines;
						_tmp78__length1 = newLines_length1;
						_tmp79_ = self->last;
						_tmp80_ = y;
						_tmp78_[_tmp79_].y2 = _tmp80_;
						break;
					}
					case DIRECTION_HORIZONTAL:
					{
						PathLine* _tmp81_ = NULL;
						gint _tmp81__length1 = 0;
						gint _tmp82_ = 0;
						gint _tmp83_ = 0;
						gint _tmp84_ = 0;
						gint _tmp85_ = 0;
						gint _tmp86_ = 0;
						gint _tmp87_ = 0;
						_tmp81_ = newLines;
						_tmp81__length1 = newLines_length1;
						_tmp82_ = self->last;
						_tmp83_ = x;
						_tmp81_[_tmp82_].x2 = _tmp83_;
						self->dirLast = DIRECTION_VERTICAL;
						_tmp84_ = x;
						line.x1 = _tmp84_;
						_tmp85_ = self->yLast;
						line.y1 = _tmp85_;
						_tmp86_ = x;
						line.x2 = _tmp86_;
						_tmp87_ = y;
						line.y2 = _tmp87_;
						lineAdded = TRUE;
						break;
					}
					case DIRECTION_DIAGONAL:
					{
						gint _tmp88_ = 0;
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
						gint _tmp91_ = 0;
						self->dirLast = DIRECTION_VERTICAL;
						_tmp88_ = self->xLast;
						line.x1 = _tmp88_;
						_tmp89_ = self->yLast;
						line.y1 = _tmp89_;
						_tmp90_ = self->xLast;
						line.x2 = _tmp90_;
						_tmp91_ = y;
						line.y2 = _tmp91_;
						lineAdded = TRUE;
						break;
					}
					default:
					break;
				}
			} else {
				gint _tmp92_ = 0;
				gint _tmp93_ = 0;
				gint _tmp94_ = 0;
				gint _tmp95_ = 0;
				self->dirLast = DIRECTION_DIAGONAL;
				_tmp92_ = self->xLast;
				line.x1 = _tmp92_;
				_tmp93_ = self->yLast;
				line.y1 = _tmp93_;
				_tmp94_ = x;
				line.x2 = _tmp94_;
				_tmp95_ = y;
				line.y2 = _tmp95_;
				lineAdded = TRUE;
			}
		}
		_tmp96_ = lineAdded;
		if (_tmp96_) {
			gint _tmp97_ = 0;
			Direction _tmp98_ = 0;
			PathLine* _tmp99_ = NULL;
			gint _tmp99__length1 = 0;
			PathLine _tmp100_ = {0};
			_tmp97_ = self->last;
			self->last = _tmp97_ + 1;
			_tmp98_ = self->dirLast;
			line.dir = _tmp98_;
			_tmp99_ = newLines;
			_tmp99__length1 = newLines_length1;
			_tmp100_ = line;
			_vala_array_add66 (&newLines, &newLines_length1, &_newLines_size_, &_tmp100_);
		}
	}
	_tmp101_ = newLines;
	_tmp101__length1 = newLines_length1;
	_tmp102_ = self->last;
	_tmp103_ = _tmp101_[_tmp102_];
	_tmp104_ = _tmp103_.x1;
	self->xLineStart = _tmp104_;
	_tmp105_ = newLines;
	_tmp105__length1 = newLines_length1;
	_tmp106_ = self->last;
	_tmp107_ = _tmp105_[_tmp106_];
	_tmp108_ = _tmp107_.y1;
	self->yLineStart = _tmp108_;
	_tmp109_ = newLines;
	_tmp109__length1 = newLines_length1;
	_tmp110_ = self->last;
	_tmp111_ = _tmp109_[_tmp110_];
	_tmp112_ = _tmp111_.x2;
	self->xLast = _tmp112_;
	_tmp113_ = newLines;
	_tmp113__length1 = newLines_length1;
	_tmp114_ = self->last;
	_tmp115_ = _tmp113_[_tmp114_];
	_tmp116_ = _tmp115_.y2;
	self->yLast = _tmp116_;
	_tmp117_ = newLines;
	_tmp117__length1 = newLines_length1;
	_tmp118_ = (_tmp117_ != NULL) ? _vala_array_dup54 (_tmp117_, _tmp117__length1) : ((gpointer) _tmp117_);
	_tmp118__length1 = _tmp117__length1;
	self->lines = (g_free (self->lines), NULL);
	self->lines = _tmp118_;
	self->lines_length1 = _tmp118__length1;
	result = 0;
	newLines = (g_free (newLines), NULL);
	return result;
}


/**
 * Return 1 if the point (//x//, //y//) is on a line between points.
 * Return 2 if the point (//x//, //y//) is on a point.
 * Else return 0.
 */
gint path_find (Path* self, gint x, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	PathLine* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->last;
	if (_tmp0_ >= 0) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_ = 0;
		PathLine* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		PathLine _tmp5_ = {0};
		gint _tmp6_ = 0;
		_tmp3_ = x;
		_tmp4_ = self->lines;
		_tmp4__length1 = self->lines_length1;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = _tmp5_.x1;
		if (_tmp3_ == _tmp6_) {
			gint _tmp7_ = 0;
			PathLine* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			PathLine _tmp9_ = {0};
			gint _tmp10_ = 0;
			_tmp7_ = y;
			_tmp8_ = self->lines;
			_tmp8__length1 = self->lines_length1;
			_tmp9_ = _tmp8_[0];
			_tmp10_ = _tmp9_.y1;
			_tmp2_ = _tmp7_ == _tmp10_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp11_ = FALSE;
			gint _tmp12_ = 0;
			PathLine* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gint _tmp14_ = 0;
			PathLine _tmp15_ = {0};
			gint _tmp16_ = 0;
			_tmp12_ = x;
			_tmp13_ = self->lines;
			_tmp13__length1 = self->lines_length1;
			_tmp14_ = self->last;
			_tmp15_ = _tmp13_[_tmp14_];
			_tmp16_ = _tmp15_.x2;
			if (_tmp12_ == _tmp16_) {
				gint _tmp17_ = 0;
				PathLine* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				PathLine _tmp20_ = {0};
				gint _tmp21_ = 0;
				_tmp17_ = y;
				_tmp18_ = self->lines;
				_tmp18__length1 = self->lines_length1;
				_tmp19_ = self->last;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp21_ = _tmp20_.y2;
				_tmp11_ = _tmp17_ == _tmp21_;
			} else {
				_tmp11_ = FALSE;
			}
			_tmp1_ = _tmp11_;
		}
		if (_tmp1_) {
			result = 2;
			return result;
		}
	}
	_tmp22_ = self->lines;
	_tmp22__length1 = self->lines_length1;
	{
		PathLine* line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp22_;
		line_collection_length1 = _tmp22__length1;
		for (line_it = 0; line_it < _tmp22__length1; line_it = line_it + 1) {
			PathLine line = {0};
			line = line_collection[line_it];
			{
				PathLine _tmp23_ = {0};
				Direction _tmp24_ = 0;
				_tmp23_ = line;
				_tmp24_ = _tmp23_.dir;
				switch (_tmp24_) {
					case DIRECTION_HORIZONTAL:
					{
						gint _tmp25_ = 0;
						PathLine _tmp26_ = {0};
						gint _tmp27_ = 0;
						_tmp25_ = y;
						_tmp26_ = line;
						_tmp27_ = _tmp26_.y1;
						if (_tmp25_ == _tmp27_) {
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
							PathLine _tmp30_ = {0};
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							_tmp30_ = line;
							_tmp31_ = _tmp30_.x1;
							_tmp32_ = x;
							if (_tmp31_ <= _tmp32_) {
								gint _tmp33_ = 0;
								PathLine _tmp34_ = {0};
								gint _tmp35_ = 0;
								_tmp33_ = x;
								_tmp34_ = line;
								_tmp35_ = _tmp34_.x2;
								_tmp29_ = _tmp33_ <= _tmp35_;
							} else {
								_tmp29_ = FALSE;
							}
							if (_tmp29_) {
								_tmp28_ = TRUE;
							} else {
								gboolean _tmp36_ = FALSE;
								PathLine _tmp37_ = {0};
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								_tmp37_ = line;
								_tmp38_ = _tmp37_.x1;
								_tmp39_ = x;
								if (_tmp38_ >= _tmp39_) {
									gint _tmp40_ = 0;
									PathLine _tmp41_ = {0};
									gint _tmp42_ = 0;
									_tmp40_ = x;
									_tmp41_ = line;
									_tmp42_ = _tmp41_.x2;
									_tmp36_ = _tmp40_ >= _tmp42_;
								} else {
									_tmp36_ = FALSE;
								}
								_tmp28_ = _tmp36_;
							}
							if (_tmp28_) {
								result = 1;
								return result;
							}
						}
						break;
					}
					case DIRECTION_VERTICAL:
					{
						gint _tmp43_ = 0;
						PathLine _tmp44_ = {0};
						gint _tmp45_ = 0;
						_tmp43_ = x;
						_tmp44_ = line;
						_tmp45_ = _tmp44_.x1;
						if (_tmp43_ == _tmp45_) {
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							PathLine _tmp48_ = {0};
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							_tmp48_ = line;
							_tmp49_ = _tmp48_.y1;
							_tmp50_ = y;
							if (_tmp49_ <= _tmp50_) {
								gint _tmp51_ = 0;
								PathLine _tmp52_ = {0};
								gint _tmp53_ = 0;
								_tmp51_ = y;
								_tmp52_ = line;
								_tmp53_ = _tmp52_.y2;
								_tmp47_ = _tmp51_ <= _tmp53_;
							} else {
								_tmp47_ = FALSE;
							}
							if (_tmp47_) {
								_tmp46_ = TRUE;
							} else {
								gboolean _tmp54_ = FALSE;
								PathLine _tmp55_ = {0};
								gint _tmp56_ = 0;
								gint _tmp57_ = 0;
								_tmp55_ = line;
								_tmp56_ = _tmp55_.y1;
								_tmp57_ = y;
								if (_tmp56_ >= _tmp57_) {
									gint _tmp58_ = 0;
									PathLine _tmp59_ = {0};
									gint _tmp60_ = 0;
									_tmp58_ = y;
									_tmp59_ = line;
									_tmp60_ = _tmp59_.y2;
									_tmp54_ = _tmp58_ >= _tmp60_;
								} else {
									_tmp54_ = FALSE;
								}
								_tmp46_ = _tmp54_;
							}
							if (_tmp46_) {
								result = 1;
								return result;
							}
						}
						break;
					}
					case DIRECTION_DIAGONAL:
					{
						gint xMin = 0;
						gint xMax = 0;
						gint yMin = 0;
						gint yMax = 0;
						gboolean _tmp61_ = FALSE;
						gboolean _tmp62_ = FALSE;
						gint _tmp63_ = 0;
						PathLine _tmp64_ = {0};
						gint _tmp65_ = 0;
						PathLine _tmp76_ = {0};
						gint _tmp77_ = 0;
						PathLine _tmp78_ = {0};
						gint _tmp79_ = 0;
						PathLine _tmp88_ = {0};
						gint _tmp89_ = 0;
						PathLine _tmp90_ = {0};
						gint _tmp91_ = 0;
						gboolean _tmp100_ = FALSE;
						gboolean _tmp101_ = FALSE;
						gboolean _tmp102_ = FALSE;
						gint _tmp103_ = 0;
						gint _tmp104_ = 0;
						_tmp63_ = x;
						_tmp64_ = line;
						_tmp65_ = _tmp64_.x1;
						if (_tmp63_ == _tmp65_) {
							gint _tmp66_ = 0;
							PathLine _tmp67_ = {0};
							gint _tmp68_ = 0;
							_tmp66_ = y;
							_tmp67_ = line;
							_tmp68_ = _tmp67_.y1;
							_tmp62_ = _tmp66_ == _tmp68_;
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							_tmp61_ = TRUE;
						} else {
							gboolean _tmp69_ = FALSE;
							gint _tmp70_ = 0;
							PathLine _tmp71_ = {0};
							gint _tmp72_ = 0;
							_tmp70_ = x;
							_tmp71_ = line;
							_tmp72_ = _tmp71_.x2;
							if (_tmp70_ == _tmp72_) {
								gint _tmp73_ = 0;
								PathLine _tmp74_ = {0};
								gint _tmp75_ = 0;
								_tmp73_ = y;
								_tmp74_ = line;
								_tmp75_ = _tmp74_.y2;
								_tmp69_ = _tmp73_ == _tmp75_;
							} else {
								_tmp69_ = FALSE;
							}
							_tmp61_ = _tmp69_;
						}
						if (_tmp61_) {
							result = 2;
							return result;
						}
						_tmp76_ = line;
						_tmp77_ = _tmp76_.x1;
						_tmp78_ = line;
						_tmp79_ = _tmp78_.x2;
						if (_tmp77_ < _tmp79_) {
							PathLine _tmp80_ = {0};
							gint _tmp81_ = 0;
							PathLine _tmp82_ = {0};
							gint _tmp83_ = 0;
							_tmp80_ = line;
							_tmp81_ = _tmp80_.x1;
							xMin = _tmp81_;
							_tmp82_ = line;
							_tmp83_ = _tmp82_.x2;
							xMax = _tmp83_;
						} else {
							PathLine _tmp84_ = {0};
							gint _tmp85_ = 0;
							PathLine _tmp86_ = {0};
							gint _tmp87_ = 0;
							_tmp84_ = line;
							_tmp85_ = _tmp84_.x2;
							xMin = _tmp85_;
							_tmp86_ = line;
							_tmp87_ = _tmp86_.x1;
							xMax = _tmp87_;
						}
						_tmp88_ = line;
						_tmp89_ = _tmp88_.y1;
						_tmp90_ = line;
						_tmp91_ = _tmp90_.y2;
						if (_tmp89_ < _tmp91_) {
							PathLine _tmp92_ = {0};
							gint _tmp93_ = 0;
							PathLine _tmp94_ = {0};
							gint _tmp95_ = 0;
							_tmp92_ = line;
							_tmp93_ = _tmp92_.y1;
							yMin = _tmp93_;
							_tmp94_ = line;
							_tmp95_ = _tmp94_.y2;
							yMax = _tmp95_;
						} else {
							PathLine _tmp96_ = {0};
							gint _tmp97_ = 0;
							PathLine _tmp98_ = {0};
							gint _tmp99_ = 0;
							_tmp96_ = line;
							_tmp97_ = _tmp96_.y2;
							yMin = _tmp97_;
							_tmp98_ = line;
							_tmp99_ = _tmp98_.y1;
							yMax = _tmp99_;
						}
						_tmp103_ = xMin;
						_tmp104_ = x;
						if (_tmp103_ <= _tmp104_) {
							gint _tmp105_ = 0;
							gint _tmp106_ = 0;
							_tmp105_ = x;
							_tmp106_ = xMax;
							_tmp102_ = _tmp105_ <= _tmp106_;
						} else {
							_tmp102_ = FALSE;
						}
						if (_tmp102_) {
							gint _tmp107_ = 0;
							gint _tmp108_ = 0;
							_tmp107_ = yMin;
							_tmp108_ = y;
							_tmp101_ = _tmp107_ <= _tmp108_;
						} else {
							_tmp101_ = FALSE;
						}
						if (_tmp101_) {
							gint _tmp109_ = 0;
							gint _tmp110_ = 0;
							_tmp109_ = y;
							_tmp110_ = yMax;
							_tmp100_ = _tmp109_ <= _tmp110_;
						} else {
							_tmp100_ = FALSE;
						}
						if (_tmp100_) {
							gboolean _tmp111_ = FALSE;
							PathLine _tmp112_ = {0};
							gint _tmp113_ = 0;
							PathLine _tmp114_ = {0};
							gint _tmp115_ = 0;
							gfloat xLineDiff = 0.0F;
							PathLine _tmp120_ = {0};
							gint _tmp121_ = 0;
							PathLine _tmp122_ = {0};
							gint _tmp123_ = 0;
							gfloat yLineDiff = 0.0F;
							PathLine _tmp124_ = {0};
							gint _tmp125_ = 0;
							PathLine _tmp126_ = {0};
							gint _tmp127_ = 0;
							gfloat gradient = 0.0F;
							gfloat _tmp128_ = 0.0F;
							gfloat _tmp129_ = 0.0F;
							gfloat _tmp130_ = 0.0F;
							gfloat _tmp131_ = 0.0F;
							gfloat gradientAbs = 0.0F;
							gfloat diff = 0.0F;
							gfloat diffAbs = 0.0F;
							gfloat _tmp134_ = 0.0F;
							gfloat _tmp159_ = 0.0F;
							_tmp112_ = line;
							_tmp113_ = _tmp112_.x1;
							_tmp114_ = line;
							_tmp115_ = _tmp114_.x2;
							if (_tmp113_ == _tmp115_) {
								_tmp111_ = TRUE;
							} else {
								PathLine _tmp116_ = {0};
								gint _tmp117_ = 0;
								PathLine _tmp118_ = {0};
								gint _tmp119_ = 0;
								_tmp116_ = line;
								_tmp117_ = _tmp116_.y1;
								_tmp118_ = line;
								_tmp119_ = _tmp118_.y2;
								_tmp111_ = _tmp117_ == _tmp119_;
							}
							if (_tmp111_) {
								break;
							}
							_tmp120_ = line;
							_tmp121_ = _tmp120_.x2;
							_tmp122_ = line;
							_tmp123_ = _tmp122_.x1;
							xLineDiff = ((gfloat) _tmp121_) - ((gfloat) _tmp123_);
							_tmp124_ = line;
							_tmp125_ = _tmp124_.y2;
							_tmp126_ = line;
							_tmp127_ = _tmp126_.y1;
							yLineDiff = ((gfloat) _tmp125_) - ((gfloat) _tmp127_);
							_tmp128_ = yLineDiff;
							_tmp129_ = xLineDiff;
							gradient = _tmp128_ / _tmp129_;
							_tmp131_ = gradient;
							if (_tmp131_ < ((gfloat) 0)) {
								gfloat _tmp132_ = 0.0F;
								_tmp132_ = gradient;
								_tmp130_ = -_tmp132_;
							} else {
								gfloat _tmp133_ = 0.0F;
								_tmp133_ = gradient;
								_tmp130_ = _tmp133_;
							}
							gradientAbs = _tmp130_;
							_tmp134_ = gradientAbs;
							if (_tmp134_ < ((gfloat) 1)) {
								gfloat yExpected = 0.0F;
								gfloat _tmp135_ = 0.0F;
								gint _tmp136_ = 0;
								PathLine _tmp137_ = {0};
								gint _tmp138_ = 0;
								PathLine _tmp139_ = {0};
								gint _tmp140_ = 0;
								gint _tmp141_ = 0;
								gfloat _tmp142_ = 0.0F;
								gfloat _tmp143_ = 0.0F;
								gfloat _tmp144_ = 0.0F;
								_tmp135_ = gradient;
								_tmp136_ = x;
								_tmp137_ = line;
								_tmp138_ = _tmp137_.x1;
								_tmp139_ = line;
								_tmp140_ = _tmp139_.y1;
								yExpected = (_tmp135_ * (((gfloat) _tmp136_) - ((gfloat) _tmp138_))) + ((gfloat) _tmp140_);
								_tmp141_ = y;
								_tmp142_ = yExpected;
								diff = _tmp141_ - _tmp142_;
								_tmp144_ = diff;
								if (_tmp144_ < ((gfloat) 0)) {
									gfloat _tmp145_ = 0.0F;
									_tmp145_ = diff;
									_tmp143_ = -_tmp145_;
								} else {
									gfloat _tmp146_ = 0.0F;
									_tmp146_ = diff;
									_tmp143_ = _tmp146_;
								}
								diffAbs = _tmp143_;
							} else {
								gfloat xExpected = 0.0F;
								gint _tmp147_ = 0;
								PathLine _tmp148_ = {0};
								gint _tmp149_ = 0;
								gfloat _tmp150_ = 0.0F;
								PathLine _tmp151_ = {0};
								gint _tmp152_ = 0;
								gint _tmp153_ = 0;
								gfloat _tmp154_ = 0.0F;
								gfloat _tmp155_ = 0.0F;
								gfloat _tmp156_ = 0.0F;
								_tmp147_ = y;
								_tmp148_ = line;
								_tmp149_ = _tmp148_.y1;
								_tmp150_ = gradient;
								_tmp151_ = line;
								_tmp152_ = _tmp151_.x1;
								xExpected = ((((gfloat) _tmp147_) - ((gfloat) _tmp149_)) / _tmp150_) + ((gfloat) _tmp152_);
								_tmp153_ = x;
								_tmp154_ = xExpected;
								diff = _tmp153_ - _tmp154_;
								_tmp156_ = diff;
								if (_tmp156_ < ((gfloat) 0)) {
									gfloat _tmp157_ = 0.0F;
									_tmp157_ = diff;
									_tmp155_ = -_tmp157_;
								} else {
									gfloat _tmp158_ = 0.0F;
									_tmp158_ = diff;
									_tmp155_ = _tmp158_;
								}
								diffAbs = _tmp155_;
							}
							_tmp159_ = diffAbs;
							if (_tmp159_ <= ((gfloat) 5)) {
								result = 1;
								return result;
							}
						}
						break;
					}
					default:
					break;
				}
			}
		}
	}
	result = 0;
	return result;
}


/**
 * Displaces the path by //x// horizontally, and //y// vertically.
 */
void path_move (Path* self, gint x, gint y) {
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				PathLine* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				PathLine* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				PathLine* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				PathLine* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				PathLine* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				PathLine* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				PathLine* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				PathLine* _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				PathLine* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->lines;
				_tmp3__length1 = self->lines_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = self->lines;
				_tmp4__length1 = self->lines_length1;
				_tmp5_ = i;
				_tmp6_ = self->lines;
				_tmp6__length1 = self->lines_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_].x1;
				_tmp9_ = x;
				_tmp6_[_tmp7_].x1 = _tmp8_ + _tmp9_;
				_tmp10_ = self->lines;
				_tmp10__length1 = self->lines_length1;
				_tmp11_ = i;
				_tmp12_ = self->lines;
				_tmp12__length1 = self->lines_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_].y1;
				_tmp15_ = y;
				_tmp12_[_tmp13_].y1 = _tmp14_ + _tmp15_;
				_tmp16_ = self->lines;
				_tmp16__length1 = self->lines_length1;
				_tmp17_ = i;
				_tmp18_ = self->lines;
				_tmp18__length1 = self->lines_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_].x2;
				_tmp21_ = x;
				_tmp18_[_tmp19_].x2 = _tmp20_ + _tmp21_;
				_tmp22_ = self->lines;
				_tmp22__length1 = self->lines_length1;
				_tmp23_ = i;
				_tmp24_ = self->lines;
				_tmp24__length1 = self->lines_length1;
				_tmp25_ = i;
				_tmp26_ = _tmp24_[_tmp25_].y2;
				_tmp27_ = y;
				_tmp24_[_tmp25_].y2 = _tmp26_ + _tmp27_;
			}
		}
	}
	_tmp28_ = self->xLast;
	_tmp29_ = x;
	self->xLast = _tmp28_ + _tmp29_;
	_tmp30_ = self->yLast;
	_tmp31_ = y;
	self->yLast = _tmp30_ + _tmp31_;
	_tmp32_ = self->xLineStart;
	_tmp33_ = x;
	self->xLineStart = _tmp32_ + _tmp33_;
	_tmp34_ = self->yLineStart;
	_tmp35_ = y;
	self->yLineStart = _tmp34_ + _tmp35_;
}


/**
 * Renders the path's lines.
 */
void path_render (Path* self, cairo_t* context) {
	PathLine* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->lines;
	_tmp0__length1 = self->lines_length1;
	{
		PathLine* line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp0_;
		line_collection_length1 = _tmp0__length1;
		for (line_it = 0; line_it < _tmp0__length1; line_it = line_it + 1) {
			PathLine line = {0};
			line = line_collection[line_it];
			{
				cairo_t* _tmp1_ = NULL;
				PathLine _tmp2_ = {0};
				gint _tmp3_ = 0;
				PathLine _tmp4_ = {0};
				gint _tmp5_ = 0;
				cairo_t* _tmp6_ = NULL;
				PathLine _tmp7_ = {0};
				gint _tmp8_ = 0;
				PathLine _tmp9_ = {0};
				gint _tmp10_ = 0;
				cairo_t* _tmp11_ = NULL;
				_tmp1_ = context;
				_tmp2_ = line;
				_tmp3_ = _tmp2_.x1;
				_tmp4_ = line;
				_tmp5_ = _tmp4_.y1;
				cairo_move_to (_tmp1_, (gdouble) _tmp3_, (gdouble) _tmp5_);
				_tmp6_ = context;
				_tmp7_ = line;
				_tmp8_ = _tmp7_.x2;
				_tmp9_ = line;
				_tmp10_ = _tmp9_.y2;
				cairo_line_to (_tmp6_, (gdouble) _tmp8_, (gdouble) _tmp10_);
				_tmp11_ = context;
				cairo_stroke (_tmp11_);
			}
		}
	}
}


PathLine* path_line_dup (const PathLine* self) {
	PathLine* dup;
	dup = g_new0 (PathLine, 1);
	memcpy (dup, self, sizeof (PathLine));
	return dup;
}


void path_line_free (PathLine* self) {
	g_free (self);
}


GType path_line_get_type (void) {
	static volatile gsize path_line_type_id__volatile = 0;
	if (g_once_init_enter (&path_line_type_id__volatile)) {
		GType path_line_type_id;
		path_line_type_id = g_boxed_type_register_static ("PathLine", (GBoxedCopyFunc) path_line_dup, (GBoxedFreeFunc) path_line_free);
		g_once_init_leave (&path_line_type_id__volatile, path_line_type_id);
	}
	return path_line_type_id__volatile;
}


static void value_path_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_path_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		path_unref (value->data[0].v_pointer);
	}
}


static void value_path_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = path_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_path_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_path_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Path* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = path_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_path_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Path** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = path_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPath* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PATH), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_path (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PATH), NULL);
	return value->data[0].v_pointer;
}


void value_set_path (GValue* value, gpointer v_object) {
	Path* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PATH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PATH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		path_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		path_unref (old);
	}
}


void value_take_path (GValue* value, gpointer v_object) {
	Path* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PATH));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PATH));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		path_unref (old);
	}
}


static void path_class_init (PathClass * klass) {
	path_parent_class = g_type_class_peek_parent (klass);
	PATH_CLASS (klass)->finalize = path_finalize;
}


static void path_instance_init (Path * self) {
	self->ref_count = 1;
}


static void path_finalize (Path* obj) {
	Path * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PATH, Path);
	self->lines = (g_free (self->lines), NULL);
}


/**
 * Describes a path of straight lines.
 * 
 * Used (sometimes in groups) to describe the structure of a wire.
 */
GType path_get_type (void) {
	static volatile gsize path_type_id__volatile = 0;
	if (g_once_init_enter (&path_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_path_init, value_path_free_value, value_path_copy_value, value_path_peek_pointer, "p", value_path_collect_value, "p", value_path_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PathClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) path_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Path), 0, (GInstanceInitFunc) path_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType path_type_id;
		path_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Path", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&path_type_id__volatile, path_type_id);
	}
	return path_type_id__volatile;
}


gpointer path_ref (gpointer instance) {
	Path* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void path_unref (gpointer instance) {
	Path* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PATH_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



