/* pininst.c generated by valac 0.24.0, the Vala compiler
 * generated from pininst.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: pininst.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
#define _pin_def_unref0(var) ((var == NULL) ? NULL : (var = (pin_def_unref (var), NULL)))
typedef struct _PinDefPrivate PinDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_FLOW (flow_get_type ())

#define PIN_DEF_TYPE_LABEL_TYPE (pin_def_label_type_get_type ())
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;
typedef struct _ParamSpecPinInst ParamSpecPinInst;

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	PIN_DEF_LABEL_TYPE_NONE,
	PIN_DEF_LABEL_TYPE_TEXT,
	PIN_DEF_LABEL_TYPE_TEXTBAR,
	PIN_DEF_LABEL_TYPE_CLOCK
} PinDefLabelType;

struct _PinDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinDefPrivate * priv;
	gint x;
	gint y;
	gint xLabel;
	gint yLabel;
	gint xConnect;
	gint yConnect;
	Direction direction;
	gint length;
	gboolean array;
	Flow flow;
	gint defaultArraySize;
	gint idealSpace;
	gfloat minSpace;
	gchar* label;
	gboolean required;
	gboolean userArrayResize;
	gboolean showDefault;
	PinDefLabelType labelType;
};

struct _PinDefClass {
	GTypeClass parent_class;
	void (*finalize) (PinDef *self);
};

struct _ParamSpecPinInst {
	GParamSpec parent_instance;
};


static gpointer pin_inst_parent_class = NULL;

gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
enum  {
	PIN_INST_DUMMY_PROPERTY
};
PinInst* pin_inst_new (PinDef* pinDef, gint arraySize);
PinInst* pin_inst_construct (GType object_type, PinDef* pinDef, gint arraySize);
GType direction_get_type (void) G_GNUC_CONST;
GType flow_get_type (void) G_GNUC_CONST;
GType pin_def_label_type_get_type (void) G_GNUC_CONST;
void pin_inst_update_spacing (PinInst* self);
gint pin_inst_append (PinInst* self);
void pin_inst_update_position (PinInst* self);
void pin_inst_try_invert (PinInst* self, gint x, gint y);
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gboolean pin_inst_try_connect (PinInst* self, gint x, gint y, WireInst* wireInst, ComponentInst* componentInst);
void component_inst_absolute_position (ComponentInst* self, gint xRelative, gint yRelative, gint* xRaw, gint* yRaw);
void wire_inst_register_component (WireInst* self, ComponentInst* newComponentInst, gint x, gint y);
gboolean pin_inst_try_disconnect (PinInst* self, gint x, gint y, ComponentInst* componentInst);
void wire_inst_unregister_component_xy (WireInst* self, ComponentInst* oldComponentInst, gint x, gint y);
gboolean pin_inst_disconnect (PinInst* self, ComponentInst* componentInst);
gint pin_inst_validate_connections (PinInst* self);
void pin_inst_render (PinInst* self, cairo_t* context, gboolean showHints);
static void pin_inst_finalize (PinInst* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Creates a pin or an array of pins from the PinDef //pinDef//.
 */
static gpointer _pin_def_ref0 (gpointer self) {
	return self ? pin_def_ref (self) : NULL;
}


PinInst* pin_inst_construct (GType object_type, PinDef* pinDef, gint arraySize) {
	PinInst* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	PinDef* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	PinDef* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	PinDef* _tmp46_ = NULL;
	PinDef* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	PinDef* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	gint _tmp51_ = 0;
	g_return_val_if_fail (pinDef != NULL, NULL);
	self = (PinInst*) g_type_create_instance (object_type);
	_tmp0_ = arraySize;
	_tmp1_ = _tmp0_;
	self->x = g_renew (gint, self->x, _tmp0_);
	(_tmp1_ > self->x_length1) ? memset (self->x + self->x_length1, 0, sizeof (gint) * (_tmp1_ - self->x_length1)) : NULL;
	self->x_length1 = _tmp1_;
	_tmp2_ = arraySize;
	_tmp3_ = _tmp2_;
	self->y = g_renew (gint, self->y, _tmp2_);
	(_tmp3_ > self->y_length1) ? memset (self->y + self->y_length1, 0, sizeof (gint) * (_tmp3_ - self->y_length1)) : NULL;
	self->y_length1 = _tmp3_;
	_tmp4_ = arraySize;
	_tmp5_ = _tmp4_;
	self->xConnect = g_renew (gint, self->xConnect, _tmp4_);
	(_tmp5_ > self->xConnect_length1) ? memset (self->xConnect + self->xConnect_length1, 0, sizeof (gint) * (_tmp5_ - self->xConnect_length1)) : NULL;
	self->xConnect_length1 = _tmp5_;
	_tmp6_ = arraySize;
	_tmp7_ = _tmp6_;
	self->yConnect = g_renew (gint, self->yConnect, _tmp6_);
	(_tmp7_ > self->yConnect_length1) ? memset (self->yConnect + self->yConnect_length1, 0, sizeof (gint) * (_tmp7_ - self->yConnect_length1)) : NULL;
	self->yConnect_length1 = _tmp7_;
	_tmp8_ = arraySize;
	_tmp9_ = _tmp8_;
	self->invert = g_renew (gboolean, self->invert, _tmp8_);
	(_tmp9_ > self->invert_length1) ? memset (self->invert + self->invert_length1, 0, sizeof (gboolean) * (_tmp9_ - self->invert_length1)) : NULL;
	self->invert_length1 = _tmp9_;
	_tmp10_ = arraySize;
	_tmp11_ = _tmp10_;
	self->wireInsts = g_renew (WireInst*, self->wireInsts, _tmp10_);
	(_tmp11_ > self->wireInsts_length1) ? memset (self->wireInsts + self->wireInsts_length1, 0, sizeof (WireInst*) * (_tmp11_ - self->wireInsts_length1)) : NULL;
	self->wireInsts_length1 = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				PinDef* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint* _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				PinDef* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				PinDef* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint* _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				PinDef* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gboolean* _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gint _tmp37_ = 0;
				gboolean _tmp38_ = FALSE;
				WireInst** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gint _tmp40_ = 0;
				WireInst* _tmp41_ = NULL;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = arraySize;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = self->x;
				_tmp16__length1 = self->x_length1;
				_tmp17_ = i;
				_tmp18_ = pinDef;
				_tmp19_ = _tmp18_->x;
				_tmp16_[_tmp17_] = _tmp19_;
				_tmp20_ = _tmp16_[_tmp17_];
				_tmp21_ = self->y;
				_tmp21__length1 = self->y_length1;
				_tmp22_ = i;
				_tmp23_ = pinDef;
				_tmp24_ = _tmp23_->y;
				_tmp21_[_tmp22_] = _tmp24_;
				_tmp25_ = _tmp21_[_tmp22_];
				_tmp26_ = self->xConnect;
				_tmp26__length1 = self->xConnect_length1;
				_tmp27_ = i;
				_tmp28_ = pinDef;
				_tmp29_ = _tmp28_->xConnect;
				_tmp26_[_tmp27_] = _tmp29_;
				_tmp30_ = _tmp26_[_tmp27_];
				_tmp31_ = self->yConnect;
				_tmp31__length1 = self->yConnect_length1;
				_tmp32_ = i;
				_tmp33_ = pinDef;
				_tmp34_ = _tmp33_->yConnect;
				_tmp31_[_tmp32_] = _tmp34_;
				_tmp35_ = _tmp31_[_tmp32_];
				_tmp36_ = self->invert;
				_tmp36__length1 = self->invert_length1;
				_tmp37_ = i;
				_tmp36_[_tmp37_] = FALSE;
				_tmp38_ = _tmp36_[_tmp37_];
				_tmp39_ = self->wireInsts;
				_tmp39__length1 = self->wireInsts_length1;
				_tmp40_ = i;
				_wire_inst_unref0 (_tmp39_[_tmp40_]);
				_tmp39_[_tmp40_] = NULL;
				_tmp41_ = _tmp39_[_tmp40_];
			}
		}
	}
	_tmp42_ = pinDef;
	_tmp43_ = _tmp42_->xLabel;
	self->xLabel = _tmp43_;
	_tmp44_ = pinDef;
	_tmp45_ = _tmp44_->yLabel;
	self->yLabel = _tmp45_;
	_tmp46_ = pinDef;
	_tmp47_ = _pin_def_ref0 (_tmp46_);
	_pin_def_unref0 (self->pinDef);
	self->pinDef = _tmp47_;
	_tmp48_ = arraySize;
	self->arraySize = _tmp48_;
	_tmp49_ = pinDef;
	_tmp50_ = _tmp49_->showDefault;
	self->show = _tmp50_;
	_tmp51_ = arraySize;
	if (_tmp51_ != 0) {
		pin_inst_update_spacing (self);
	}
	return self;
}


PinInst* pin_inst_new (PinDef* pinDef, gint arraySize) {
	return pin_inst_construct (TYPE_PIN_INST, pinDef, arraySize);
}


/**
 * Increases the number of pins in an array by 1.
 */
gint pin_inst_append (PinInst* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp13_ = 0;
	PinDef* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp18_ = 0;
	PinDef* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp23_ = 0;
	PinDef* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint* _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	gint _tmp28_ = 0;
	PinDef* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gboolean* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	gint _tmp33_ = 0;
	gboolean _tmp34_ = FALSE;
	WireInst** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint _tmp36_ = 0;
	WireInst* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->arraySize;
	_tmp1_ = _tmp0_ + 1;
	self->x = g_renew (gint, self->x, _tmp0_ + 1);
	(_tmp1_ > self->x_length1) ? memset (self->x + self->x_length1, 0, sizeof (gint) * (_tmp1_ - self->x_length1)) : NULL;
	self->x_length1 = _tmp1_;
	_tmp2_ = self->arraySize;
	_tmp3_ = _tmp2_ + 1;
	self->y = g_renew (gint, self->y, _tmp2_ + 1);
	(_tmp3_ > self->y_length1) ? memset (self->y + self->y_length1, 0, sizeof (gint) * (_tmp3_ - self->y_length1)) : NULL;
	self->y_length1 = _tmp3_;
	_tmp4_ = self->arraySize;
	_tmp5_ = _tmp4_ + 1;
	self->xConnect = g_renew (gint, self->xConnect, _tmp4_ + 1);
	(_tmp5_ > self->xConnect_length1) ? memset (self->xConnect + self->xConnect_length1, 0, sizeof (gint) * (_tmp5_ - self->xConnect_length1)) : NULL;
	self->xConnect_length1 = _tmp5_;
	_tmp6_ = self->arraySize;
	_tmp7_ = _tmp6_ + 1;
	self->yConnect = g_renew (gint, self->yConnect, _tmp6_ + 1);
	(_tmp7_ > self->yConnect_length1) ? memset (self->yConnect + self->yConnect_length1, 0, sizeof (gint) * (_tmp7_ - self->yConnect_length1)) : NULL;
	self->yConnect_length1 = _tmp7_;
	_tmp8_ = self->arraySize;
	_tmp9_ = _tmp8_ + 1;
	self->invert = g_renew (gboolean, self->invert, _tmp8_ + 1);
	(_tmp9_ > self->invert_length1) ? memset (self->invert + self->invert_length1, 0, sizeof (gboolean) * (_tmp9_ - self->invert_length1)) : NULL;
	self->invert_length1 = _tmp9_;
	_tmp10_ = self->arraySize;
	_tmp11_ = _tmp10_ + 1;
	self->wireInsts = g_renew (WireInst*, self->wireInsts, _tmp10_ + 1);
	(_tmp11_ > self->wireInsts_length1) ? memset (self->wireInsts + self->wireInsts_length1, 0, sizeof (WireInst*) * (_tmp11_ - self->wireInsts_length1)) : NULL;
	self->wireInsts_length1 = _tmp11_;
	_tmp12_ = self->x;
	_tmp12__length1 = self->x_length1;
	_tmp13_ = self->arraySize;
	_tmp14_ = self->pinDef;
	_tmp15_ = _tmp14_->x;
	_tmp12_[_tmp13_] = _tmp15_;
	_tmp16_ = _tmp12_[_tmp13_];
	_tmp17_ = self->y;
	_tmp17__length1 = self->y_length1;
	_tmp18_ = self->arraySize;
	_tmp19_ = self->pinDef;
	_tmp20_ = _tmp19_->y;
	_tmp17_[_tmp18_] = _tmp20_;
	_tmp21_ = _tmp17_[_tmp18_];
	_tmp22_ = self->xConnect;
	_tmp22__length1 = self->xConnect_length1;
	_tmp23_ = self->arraySize;
	_tmp24_ = self->pinDef;
	_tmp25_ = _tmp24_->xConnect;
	_tmp22_[_tmp23_] = _tmp25_;
	_tmp26_ = _tmp22_[_tmp23_];
	_tmp27_ = self->yConnect;
	_tmp27__length1 = self->yConnect_length1;
	_tmp28_ = self->arraySize;
	_tmp29_ = self->pinDef;
	_tmp30_ = _tmp29_->yConnect;
	_tmp27_[_tmp28_] = _tmp30_;
	_tmp31_ = _tmp27_[_tmp28_];
	_tmp32_ = self->invert;
	_tmp32__length1 = self->invert_length1;
	_tmp33_ = self->arraySize;
	_tmp32_[_tmp33_] = FALSE;
	_tmp34_ = _tmp32_[_tmp33_];
	_tmp35_ = self->wireInsts;
	_tmp35__length1 = self->wireInsts_length1;
	_tmp36_ = self->arraySize;
	_wire_inst_unref0 (_tmp35_[_tmp36_]);
	_tmp35_[_tmp36_] = NULL;
	_tmp37_ = _tmp35_[_tmp36_];
	_tmp38_ = self->arraySize;
	self->arraySize = _tmp38_ + 1;
	pin_inst_update_spacing (self);
	_tmp39_ = self->arraySize;
	result = _tmp39_ - 1;
	return result;
}


/**
 * Calculates the best spacing for pins in an array.
 */
void pin_inst_update_spacing (PinInst* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	PinDef* _tmp2_ = NULL;
	gfloat _tmp3_ = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->pinDef;
	_tmp3_ = _tmp2_->minSpace;
	if (_tmp3_ == ((gfloat) 0)) {
		PinDef* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->pinDef;
		_tmp5_ = _tmp4_->idealSpace;
		_tmp1_ = _tmp5_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp6_ = 0;
		_tmp6_ = self->arraySize;
		_tmp0_ = _tmp6_ == 1;
	}
	if (_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					PinDef* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gint* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					PinDef* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gint* _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					gint _tmp22_ = 0;
					PinDef* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gint* _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					gint _tmp27_ = 0;
					PinDef* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					if (!_tmp7_) {
						gint _tmp8_ = 0;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = i;
					_tmp10_ = self->arraySize;
					if (!(_tmp9_ < _tmp10_)) {
						break;
					}
					_tmp11_ = self->xConnect;
					_tmp11__length1 = self->xConnect_length1;
					_tmp12_ = i;
					_tmp13_ = self->pinDef;
					_tmp14_ = _tmp13_->xConnect;
					_tmp11_[_tmp12_] = _tmp14_;
					_tmp15_ = _tmp11_[_tmp12_];
					_tmp16_ = self->yConnect;
					_tmp16__length1 = self->yConnect_length1;
					_tmp17_ = i;
					_tmp18_ = self->pinDef;
					_tmp19_ = _tmp18_->yConnect;
					_tmp16_[_tmp17_] = _tmp19_;
					_tmp20_ = _tmp16_[_tmp17_];
					_tmp21_ = self->x;
					_tmp21__length1 = self->x_length1;
					_tmp22_ = i;
					_tmp23_ = self->pinDef;
					_tmp24_ = _tmp23_->x;
					_tmp21_[_tmp22_] = _tmp24_;
					_tmp25_ = _tmp21_[_tmp22_];
					_tmp26_ = self->y;
					_tmp26__length1 = self->y_length1;
					_tmp27_ = i;
					_tmp28_ = self->pinDef;
					_tmp29_ = _tmp28_->y;
					_tmp26_[_tmp27_] = _tmp29_;
					_tmp30_ = _tmp26_[_tmp27_];
				}
			}
		}
	} else {
		gfloat space = 0.0F;
		PinDef* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gfloat _tmp34_ = 0.0F;
		PinDef* _tmp35_ = NULL;
		gfloat _tmp36_ = 0.0F;
		PinDef* _tmp39_ = NULL;
		Direction _tmp40_ = 0;
		_tmp31_ = self->pinDef;
		_tmp32_ = _tmp31_->idealSpace;
		_tmp33_ = self->arraySize;
		space = ((gfloat) _tmp32_) / (_tmp33_ - 1);
		_tmp34_ = space;
		_tmp35_ = self->pinDef;
		_tmp36_ = _tmp35_->minSpace;
		if (_tmp34_ < _tmp36_) {
			PinDef* _tmp37_ = NULL;
			gfloat _tmp38_ = 0.0F;
			_tmp37_ = self->pinDef;
			_tmp38_ = _tmp37_->minSpace;
			space = _tmp38_;
		}
		_tmp39_ = self->pinDef;
		_tmp40_ = _tmp39_->direction;
		switch (_tmp40_) {
			case DIRECTION_RIGHT:
			case DIRECTION_LEFT:
			{
				gfloat yStart = 0.0F;
				PinDef* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gfloat _tmp43_ = 0.0F;
				gint _tmp44_ = 0;
				PinDef* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				PinDef* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				PinDef* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gfloat _tmp77_ = 0.0F;
				gint _tmp78_ = 0;
				PinDef* _tmp79_ = NULL;
				gint _tmp80_ = 0;
				gfloat _tmp81_ = 0.0F;
				gint _tmp82_ = 0;
				_tmp41_ = self->pinDef;
				_tmp42_ = _tmp41_->y;
				_tmp43_ = space;
				_tmp44_ = self->arraySize;
				yStart = ((gfloat) _tmp42_) - ((_tmp43_ * (_tmp44_ - 1)) / 2);
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp45_ = FALSE;
						_tmp45_ = TRUE;
						while (TRUE) {
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gint* _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							gint _tmp50_ = 0;
							PinDef* _tmp51_ = NULL;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint* _tmp54_ = NULL;
							gint _tmp54__length1 = 0;
							gint _tmp55_ = 0;
							gfloat _tmp56_ = 0.0F;
							gfloat _tmp57_ = 0.0F;
							gint _tmp58_ = 0;
							gint _tmp59_ = 0;
							gint* _tmp60_ = NULL;
							gint _tmp60__length1 = 0;
							gint _tmp61_ = 0;
							PinDef* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							gint _tmp64_ = 0;
							gint* _tmp65_ = NULL;
							gint _tmp65__length1 = 0;
							gint _tmp66_ = 0;
							gfloat _tmp67_ = 0.0F;
							gfloat _tmp68_ = 0.0F;
							gint _tmp69_ = 0;
							gint _tmp70_ = 0;
							if (!_tmp45_) {
								gint _tmp46_ = 0;
								_tmp46_ = i;
								i = _tmp46_ + 1;
							}
							_tmp45_ = FALSE;
							_tmp47_ = i;
							_tmp48_ = self->arraySize;
							if (!(_tmp47_ < _tmp48_)) {
								break;
							}
							_tmp49_ = self->xConnect;
							_tmp49__length1 = self->xConnect_length1;
							_tmp50_ = i;
							_tmp51_ = self->pinDef;
							_tmp52_ = _tmp51_->xConnect;
							_tmp49_[_tmp50_] = _tmp52_;
							_tmp53_ = _tmp49_[_tmp50_];
							_tmp54_ = self->yConnect;
							_tmp54__length1 = self->yConnect_length1;
							_tmp55_ = i;
							_tmp56_ = yStart;
							_tmp57_ = space;
							_tmp58_ = i;
							_tmp54_[_tmp55_] = (gint) (_tmp56_ + (_tmp57_ * _tmp58_));
							_tmp59_ = _tmp54_[_tmp55_];
							_tmp60_ = self->x;
							_tmp60__length1 = self->x_length1;
							_tmp61_ = i;
							_tmp62_ = self->pinDef;
							_tmp63_ = _tmp62_->x;
							_tmp60_[_tmp61_] = _tmp63_;
							_tmp64_ = _tmp60_[_tmp61_];
							_tmp65_ = self->y;
							_tmp65__length1 = self->y_length1;
							_tmp66_ = i;
							_tmp67_ = yStart;
							_tmp68_ = space;
							_tmp69_ = i;
							_tmp65_[_tmp66_] = (gint) (_tmp67_ + (_tmp68_ * _tmp69_));
							_tmp70_ = _tmp65_[_tmp66_];
						}
					}
				}
				_tmp71_ = self->pinDef;
				_tmp72_ = _tmp71_->x;
				self->xMin = _tmp72_;
				_tmp73_ = self->pinDef;
				_tmp74_ = _tmp73_->x;
				self->xMax = _tmp74_;
				_tmp75_ = self->pinDef;
				_tmp76_ = _tmp75_->y;
				_tmp77_ = space;
				_tmp78_ = self->arraySize;
				self->yMin = _tmp76_ - ((gint) ((_tmp77_ * (_tmp78_ - 1)) / 2));
				_tmp79_ = self->pinDef;
				_tmp80_ = _tmp79_->y;
				_tmp81_ = space;
				_tmp82_ = self->arraySize;
				self->yMax = _tmp80_ + ((gint) ((_tmp81_ * (_tmp82_ - 1)) / 2));
				break;
			}
			case DIRECTION_DOWN:
			case DIRECTION_UP:
			{
				gfloat xStart = 0.0F;
				PinDef* _tmp83_ = NULL;
				gint _tmp84_ = 0;
				gfloat _tmp85_ = 0.0F;
				gint _tmp86_ = 0;
				PinDef* _tmp113_ = NULL;
				gint _tmp114_ = 0;
				gfloat _tmp115_ = 0.0F;
				gint _tmp116_ = 0;
				PinDef* _tmp117_ = NULL;
				gint _tmp118_ = 0;
				gfloat _tmp119_ = 0.0F;
				gint _tmp120_ = 0;
				PinDef* _tmp121_ = NULL;
				gint _tmp122_ = 0;
				PinDef* _tmp123_ = NULL;
				gint _tmp124_ = 0;
				_tmp83_ = self->pinDef;
				_tmp84_ = _tmp83_->x;
				_tmp85_ = space;
				_tmp86_ = self->arraySize;
				xStart = ((gfloat) _tmp84_) - ((_tmp85_ * (_tmp86_ - 1)) / 2);
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp87_ = FALSE;
						_tmp87_ = TRUE;
						while (TRUE) {
							gint _tmp89_ = 0;
							gint _tmp90_ = 0;
							gint* _tmp91_ = NULL;
							gint _tmp91__length1 = 0;
							gint _tmp92_ = 0;
							gfloat _tmp93_ = 0.0F;
							gfloat _tmp94_ = 0.0F;
							gint _tmp95_ = 0;
							gint _tmp96_ = 0;
							gint* _tmp97_ = NULL;
							gint _tmp97__length1 = 0;
							gint _tmp98_ = 0;
							PinDef* _tmp99_ = NULL;
							gint _tmp100_ = 0;
							gint _tmp101_ = 0;
							gint* _tmp102_ = NULL;
							gint _tmp102__length1 = 0;
							gint _tmp103_ = 0;
							gfloat _tmp104_ = 0.0F;
							gfloat _tmp105_ = 0.0F;
							gint _tmp106_ = 0;
							gint _tmp107_ = 0;
							gint* _tmp108_ = NULL;
							gint _tmp108__length1 = 0;
							gint _tmp109_ = 0;
							PinDef* _tmp110_ = NULL;
							gint _tmp111_ = 0;
							gint _tmp112_ = 0;
							if (!_tmp87_) {
								gint _tmp88_ = 0;
								_tmp88_ = i;
								i = _tmp88_ + 1;
							}
							_tmp87_ = FALSE;
							_tmp89_ = i;
							_tmp90_ = self->arraySize;
							if (!(_tmp89_ < _tmp90_)) {
								break;
							}
							_tmp91_ = self->xConnect;
							_tmp91__length1 = self->xConnect_length1;
							_tmp92_ = i;
							_tmp93_ = xStart;
							_tmp94_ = space;
							_tmp95_ = i;
							_tmp91_[_tmp92_] = (gint) (_tmp93_ + (_tmp94_ * _tmp95_));
							_tmp96_ = _tmp91_[_tmp92_];
							_tmp97_ = self->yConnect;
							_tmp97__length1 = self->yConnect_length1;
							_tmp98_ = i;
							_tmp99_ = self->pinDef;
							_tmp100_ = _tmp99_->yConnect;
							_tmp97_[_tmp98_] = _tmp100_;
							_tmp101_ = _tmp97_[_tmp98_];
							_tmp102_ = self->x;
							_tmp102__length1 = self->x_length1;
							_tmp103_ = i;
							_tmp104_ = xStart;
							_tmp105_ = space;
							_tmp106_ = i;
							_tmp102_[_tmp103_] = (gint) (_tmp104_ + (_tmp105_ * _tmp106_));
							_tmp107_ = _tmp102_[_tmp103_];
							_tmp108_ = self->y;
							_tmp108__length1 = self->y_length1;
							_tmp109_ = i;
							_tmp110_ = self->pinDef;
							_tmp111_ = _tmp110_->y;
							_tmp108_[_tmp109_] = _tmp111_;
							_tmp112_ = _tmp108_[_tmp109_];
						}
					}
				}
				_tmp113_ = self->pinDef;
				_tmp114_ = _tmp113_->x;
				_tmp115_ = space;
				_tmp116_ = self->arraySize;
				self->xMin = _tmp114_ - ((gint) ((_tmp115_ * (_tmp116_ - 1)) / 2));
				_tmp117_ = self->pinDef;
				_tmp118_ = _tmp117_->x;
				_tmp119_ = space;
				_tmp120_ = self->arraySize;
				self->xMax = _tmp118_ + ((gint) ((_tmp119_ * (_tmp120_ - 1)) / 2));
				_tmp121_ = self->pinDef;
				_tmp122_ = _tmp121_->y;
				self->yMin = _tmp122_;
				_tmp123_ = self->pinDef;
				_tmp124_ = _tmp123_->y;
				self->yMax = _tmp124_;
				break;
			}
			default:
			break;
		}
	}
}


void pin_inst_update_position (PinInst* self) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				PinDef* _tmp4_ = NULL;
				Direction _tmp5_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->arraySize;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = self->pinDef;
				_tmp5_ = _tmp4_->direction;
				switch (_tmp5_) {
					case DIRECTION_RIGHT:
					{
						gint* _tmp6_ = NULL;
						gint _tmp6__length1 = 0;
						gint _tmp7_ = 0;
						gint* _tmp8_ = NULL;
						gint _tmp8__length1 = 0;
						gint _tmp9_ = 0;
						gint _tmp10_ = 0;
						PinDef* _tmp11_ = NULL;
						gint _tmp12_ = 0;
						gint _tmp13_ = 0;
						gint* _tmp14_ = NULL;
						gint _tmp14__length1 = 0;
						gint _tmp15_ = 0;
						gint _tmp16_ = 0;
						_tmp6_ = self->xConnect;
						_tmp6__length1 = self->xConnect_length1;
						_tmp7_ = i;
						_tmp8_ = self->x;
						_tmp8__length1 = self->x_length1;
						_tmp9_ = i;
						_tmp10_ = _tmp8_[_tmp9_];
						_tmp11_ = self->pinDef;
						_tmp12_ = _tmp11_->length;
						_tmp6_[_tmp7_] = _tmp10_ + _tmp12_;
						_tmp13_ = _tmp6_[_tmp7_];
						_tmp14_ = self->x;
						_tmp14__length1 = self->x_length1;
						_tmp15_ = i;
						_tmp16_ = _tmp14_[_tmp15_];
						self->xLabel = _tmp16_ - 10;
						break;
					}
					case DIRECTION_DOWN:
					{
						gint* _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						gint _tmp18_ = 0;
						gint* _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						gint _tmp20_ = 0;
						gint _tmp21_ = 0;
						PinDef* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
						gint* _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						gint _tmp27_ = 0;
						_tmp17_ = self->yConnect;
						_tmp17__length1 = self->yConnect_length1;
						_tmp18_ = i;
						_tmp19_ = self->y;
						_tmp19__length1 = self->y_length1;
						_tmp20_ = i;
						_tmp21_ = _tmp19_[_tmp20_];
						_tmp22_ = self->pinDef;
						_tmp23_ = _tmp22_->length;
						_tmp17_[_tmp18_] = _tmp21_ + _tmp23_;
						_tmp24_ = _tmp17_[_tmp18_];
						_tmp25_ = self->y;
						_tmp25__length1 = self->y_length1;
						_tmp26_ = i;
						_tmp27_ = _tmp25_[_tmp26_];
						self->yLabel = _tmp27_ - 10;
						break;
					}
					case DIRECTION_LEFT:
					{
						gint* _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						gint _tmp29_ = 0;
						gint* _tmp30_ = NULL;
						gint _tmp30__length1 = 0;
						gint _tmp31_ = 0;
						gint _tmp32_ = 0;
						PinDef* _tmp33_ = NULL;
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						gint* _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						_tmp28_ = self->xConnect;
						_tmp28__length1 = self->xConnect_length1;
						_tmp29_ = i;
						_tmp30_ = self->x;
						_tmp30__length1 = self->x_length1;
						_tmp31_ = i;
						_tmp32_ = _tmp30_[_tmp31_];
						_tmp33_ = self->pinDef;
						_tmp34_ = _tmp33_->length;
						_tmp28_[_tmp29_] = _tmp32_ - _tmp34_;
						_tmp35_ = _tmp28_[_tmp29_];
						_tmp36_ = self->x;
						_tmp36__length1 = self->x_length1;
						_tmp37_ = i;
						_tmp38_ = _tmp36_[_tmp37_];
						self->xLabel = _tmp38_ + 10;
						break;
					}
					case DIRECTION_UP:
					{
						gint* _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						gint _tmp40_ = 0;
						gint* _tmp41_ = NULL;
						gint _tmp41__length1 = 0;
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						PinDef* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gint* _tmp47_ = NULL;
						gint _tmp47__length1 = 0;
						gint _tmp48_ = 0;
						gint _tmp49_ = 0;
						_tmp39_ = self->yConnect;
						_tmp39__length1 = self->yConnect_length1;
						_tmp40_ = i;
						_tmp41_ = self->y;
						_tmp41__length1 = self->y_length1;
						_tmp42_ = i;
						_tmp43_ = _tmp41_[_tmp42_];
						_tmp44_ = self->pinDef;
						_tmp45_ = _tmp44_->length;
						_tmp39_[_tmp40_] = _tmp43_ - _tmp45_;
						_tmp46_ = _tmp39_[_tmp40_];
						_tmp47_ = self->y;
						_tmp47__length1 = self->y_length1;
						_tmp48_ = i;
						_tmp49_ = _tmp47_[_tmp48_];
						self->yLabel = _tmp49_ + 10;
						break;
					}
					default:
					break;
				}
			}
		}
	}
}


/**
 * Inverts any pins at (//x//, //y//).
 */
void pin_inst_try_invert (PinInst* self, gint x, gint y) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
				gint* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->arraySize;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp5_ = x;
				_tmp6_ = self->xConnect;
				_tmp6__length1 = self->xConnect_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp5_ == _tmp8_) {
					gint _tmp9_ = 0;
					gint* _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp9_ = y;
					_tmp10_ = self->yConnect;
					_tmp10__length1 = self->yConnect_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					_tmp4_ = _tmp9_ == _tmp12_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gboolean _tmp13_ = FALSE;
					gboolean* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					gboolean _tmp16_ = FALSE;
					gboolean* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					gboolean _tmp19_ = FALSE;
					_tmp14_ = self->invert;
					_tmp14__length1 = self->invert_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					if (_tmp16_) {
						_tmp13_ = FALSE;
					} else {
						_tmp13_ = TRUE;
					}
					_tmp17_ = self->invert;
					_tmp17__length1 = self->invert_length1;
					_tmp18_ = i;
					_tmp17_[_tmp18_] = _tmp13_;
					_tmp19_ = _tmp17_[_tmp18_];
				}
			}
		}
	}
}


/**
 * Connects any pins at (//x//, //y//) to //wireInst//.
 * //componentInst// is the parent component of the pin.
 */
static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


gboolean pin_inst_try_connect (PinInst* self, gint x, gint y, WireInst* wireInst, ComponentInst* componentInst) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wireInst != NULL, FALSE);
	g_return_val_if_fail (componentInst != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				WireInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				WireInst* _tmp6_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->arraySize;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = self->wireInsts;
				_tmp4__length1 = self->wireInsts_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				if (_tmp6_ == NULL) {
					gboolean _tmp7_ = FALSE;
					gint _tmp8_ = 0;
					gint* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					_tmp8_ = x;
					_tmp9_ = self->xConnect;
					_tmp9__length1 = self->xConnect_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					if (_tmp8_ == _tmp11_) {
						gint _tmp12_ = 0;
						gint* _tmp13_ = NULL;
						gint _tmp13__length1 = 0;
						gint _tmp14_ = 0;
						gint _tmp15_ = 0;
						_tmp12_ = y;
						_tmp13_ = self->yConnect;
						_tmp13__length1 = self->yConnect_length1;
						_tmp14_ = i;
						_tmp15_ = _tmp13_[_tmp14_];
						_tmp7_ = _tmp12_ == _tmp15_;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						WireInst** _tmp16_ = NULL;
						gint _tmp16__length1 = 0;
						gint _tmp17_ = 0;
						WireInst* _tmp18_ = NULL;
						WireInst* _tmp19_ = NULL;
						WireInst* _tmp20_ = NULL;
						gint xAbsolute = 0;
						gint yAbsolute = 0;
						ComponentInst* _tmp21_ = NULL;
						gint _tmp22_ = 0;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
						gint _tmp25_ = 0;
						WireInst* _tmp26_ = NULL;
						ComponentInst* _tmp27_ = NULL;
						gint _tmp28_ = 0;
						gint _tmp29_ = 0;
						FILE* _tmp30_ = NULL;
						_tmp16_ = self->wireInsts;
						_tmp16__length1 = self->wireInsts_length1;
						_tmp17_ = i;
						_tmp18_ = wireInst;
						_tmp19_ = _wire_inst_ref0 (_tmp18_);
						_wire_inst_unref0 (_tmp16_[_tmp17_]);
						_tmp16_[_tmp17_] = _tmp19_;
						_tmp20_ = _tmp16_[_tmp17_];
						_tmp21_ = componentInst;
						_tmp22_ = x;
						_tmp23_ = y;
						component_inst_absolute_position (_tmp21_, _tmp22_, _tmp23_, &_tmp24_, &_tmp25_);
						xAbsolute = _tmp24_;
						yAbsolute = _tmp25_;
						_tmp26_ = wireInst;
						_tmp27_ = componentInst;
						_tmp28_ = xAbsolute;
						_tmp29_ = yAbsolute;
						wire_inst_register_component (_tmp26_, _tmp27_, _tmp28_, _tmp29_);
						_tmp30_ = stdout;
						fprintf (_tmp30_, "Connected Component Input\n");
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Disconnects any pins at (//x//, //y//) from wires.
 * //componentInst// is the parent component of the pin.
 */
gboolean pin_inst_try_disconnect (PinInst* self, gint x, gint y, ComponentInst* componentInst) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (componentInst != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gint _tmp6_ = 0;
				gint* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->arraySize;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp6_ = x;
				_tmp7_ = self->xConnect;
				_tmp7__length1 = self->xConnect_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				if (_tmp6_ == _tmp9_) {
					gint _tmp10_ = 0;
					gint* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					_tmp10_ = y;
					_tmp11_ = self->yConnect;
					_tmp11__length1 = self->yConnect_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					_tmp5_ = _tmp10_ == _tmp13_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					WireInst** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					WireInst* _tmp16_ = NULL;
					_tmp14_ = self->wireInsts;
					_tmp14__length1 = self->wireInsts_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp4_ = _tmp16_ != NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gint xAbsolute = 0;
					gint yAbsolute = 0;
					ComponentInst* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					WireInst** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					WireInst* _tmp24_ = NULL;
					ComponentInst* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					WireInst** _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					gint _tmp29_ = 0;
					WireInst* _tmp30_ = NULL;
					FILE* _tmp31_ = NULL;
					_tmp17_ = componentInst;
					_tmp18_ = x;
					_tmp19_ = y;
					component_inst_absolute_position (_tmp17_, _tmp18_, _tmp19_, &_tmp20_, &_tmp21_);
					xAbsolute = _tmp20_;
					yAbsolute = _tmp21_;
					_tmp22_ = self->wireInsts;
					_tmp22__length1 = self->wireInsts_length1;
					_tmp23_ = i;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = componentInst;
					_tmp26_ = xAbsolute;
					_tmp27_ = yAbsolute;
					wire_inst_unregister_component_xy (_tmp24_, _tmp25_, _tmp26_, _tmp27_);
					_tmp28_ = self->wireInsts;
					_tmp28__length1 = self->wireInsts_length1;
					_tmp29_ = i;
					_wire_inst_unref0 (_tmp28_[_tmp29_]);
					_tmp28_[_tmp29_] = NULL;
					_tmp30_ = _tmp28_[_tmp29_];
					_tmp31_ = stdout;
					fprintf (_tmp31_, "Disconnected Component Input\n");
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Disconnects all pins in the array from wires.
 * //componentInst// is the parent component of the pin.
 */
gboolean pin_inst_disconnect (PinInst* self, ComponentInst* componentInst) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (componentInst != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				WireInst** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				WireInst* _tmp6_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->arraySize;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = self->wireInsts;
				_tmp4__length1 = self->wireInsts_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				if (_tmp6_ != NULL) {
					gint xAbsolute = 0;
					gint yAbsolute = 0;
					ComponentInst* _tmp7_ = NULL;
					gint* _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					WireInst** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					WireInst* _tmp18_ = NULL;
					ComponentInst* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					WireInst** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					WireInst* _tmp24_ = NULL;
					FILE* _tmp25_ = NULL;
					_tmp7_ = componentInst;
					_tmp8_ = self->xConnect;
					_tmp8__length1 = self->xConnect_length1;
					_tmp9_ = i;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp11_ = self->yConnect;
					_tmp11__length1 = self->yConnect_length1;
					_tmp12_ = i;
					_tmp13_ = _tmp11_[_tmp12_];
					component_inst_absolute_position (_tmp7_, _tmp10_, _tmp13_, &_tmp14_, &_tmp15_);
					xAbsolute = _tmp14_;
					yAbsolute = _tmp15_;
					_tmp16_ = self->wireInsts;
					_tmp16__length1 = self->wireInsts_length1;
					_tmp17_ = i;
					_tmp18_ = _tmp16_[_tmp17_];
					_tmp19_ = componentInst;
					_tmp20_ = xAbsolute;
					_tmp21_ = yAbsolute;
					wire_inst_unregister_component_xy (_tmp18_, _tmp19_, _tmp20_, _tmp21_);
					_tmp22_ = self->wireInsts;
					_tmp22__length1 = self->wireInsts_length1;
					_tmp23_ = i;
					_wire_inst_unref0 (_tmp22_[_tmp23_]);
					_tmp22_[_tmp23_] = NULL;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = stdout;
					fprintf (_tmp25_, "Disconnected Component Input\n");
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Check that all pins that require connections have connections.
 * Return 0 on pass, 1 on failure.
 */
gint pin_inst_validate_connections (PinInst* self) {
	gint result = 0;
	PinDef* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->pinDef;
	_tmp1_ = _tmp0_->required;
	if (!_tmp1_) {
		result = 0;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				WireInst** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				WireInst* _tmp8_ = NULL;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->arraySize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->wireInsts;
				_tmp6__length1 = self->wireInsts_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp8_ == NULL) {
					result = 1;
					return result;
				}
			}
		}
	}
	result = 0;
	return result;
}


/**
 * Render the pins in the array. If //showHints// is true, any
 * unconnected pins will show in red.
 */
void pin_inst_render (PinInst* self, cairo_t* context, gboolean showHints) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->show;
	if (!_tmp0_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gboolean _tmp5_ = FALSE;
				WireInst** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				WireInst* _tmp8_ = NULL;
				cairo_matrix_t oldMatrix = {0};
				cairo_t* _tmp12_ = NULL;
				cairo_matrix_t _tmp13_ = {0};
				cairo_t* _tmp14_ = NULL;
				gint* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				PinDef* _tmp21_ = NULL;
				Direction _tmp22_ = 0;
				cairo_t* _tmp41_ = NULL;
				cairo_matrix_t _tmp42_ = {0};
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->arraySize;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp6_ = self->wireInsts;
				_tmp6__length1 = self->wireInsts_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp8_ != NULL) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					_tmp9_ = showHints;
					_tmp5_ = !_tmp9_;
				}
				if (_tmp5_) {
					cairo_t* _tmp10_ = NULL;
					_tmp10_ = context;
					cairo_set_source_rgb (_tmp10_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
				} else {
					cairo_t* _tmp11_ = NULL;
					_tmp11_ = context;
					cairo_set_source_rgb (_tmp11_, (gdouble) 1, (gdouble) 0, (gdouble) 0);
				}
				_tmp12_ = context;
				cairo_get_matrix (_tmp12_, &_tmp13_);
				oldMatrix = _tmp13_;
				_tmp14_ = context;
				_tmp15_ = self->x;
				_tmp15__length1 = self->x_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp18_ = self->y;
				_tmp18__length1 = self->y_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				cairo_translate (_tmp14_, (gdouble) _tmp17_, (gdouble) _tmp20_);
				_tmp21_ = self->pinDef;
				_tmp22_ = _tmp21_->direction;
				if (_tmp22_ != DIRECTION_NONE) {
					gdouble angle = 0.0;
					PinDef* _tmp23_ = NULL;
					Direction _tmp24_ = 0;
					cairo_t* _tmp25_ = NULL;
					gdouble _tmp26_ = 0.0;
					gboolean* _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
					gint _tmp28_ = 0;
					gboolean _tmp29_ = FALSE;
					angle = (gdouble) 0;
					_tmp23_ = self->pinDef;
					_tmp24_ = _tmp23_->direction;
					switch (_tmp24_) {
						case DIRECTION_RIGHT:
						{
							angle = (gdouble) 0;
							break;
						}
						case DIRECTION_DOWN:
						{
							angle = G_PI * 0.5;
							break;
						}
						case DIRECTION_LEFT:
						{
							angle = G_PI;
							break;
						}
						case DIRECTION_UP:
						{
							angle = G_PI * 1.5;
							break;
						}
						default:
						break;
					}
					_tmp25_ = context;
					_tmp26_ = angle;
					cairo_rotate (_tmp25_, _tmp26_);
					_tmp27_ = self->invert;
					_tmp27__length1 = self->invert_length1;
					_tmp28_ = i;
					_tmp29_ = _tmp27_[_tmp28_];
					if (_tmp29_) {
						cairo_t* _tmp30_ = NULL;
						cairo_t* _tmp31_ = NULL;
						PinDef* _tmp32_ = NULL;
						gint _tmp33_ = 0;
						cairo_t* _tmp34_ = NULL;
						cairo_t* _tmp35_ = NULL;
						_tmp30_ = context;
						cairo_move_to (_tmp30_, (gdouble) 10, (gdouble) 0);
						_tmp31_ = context;
						_tmp32_ = self->pinDef;
						_tmp33_ = _tmp32_->length;
						cairo_line_to (_tmp31_, (gdouble) _tmp33_, (gdouble) 0);
						_tmp34_ = context;
						cairo_arc (_tmp34_, (gdouble) 5, (gdouble) 0, (gdouble) 5, (gdouble) 0, G_PI * 2);
						_tmp35_ = context;
						cairo_stroke (_tmp35_);
					} else {
						cairo_t* _tmp36_ = NULL;
						cairo_t* _tmp37_ = NULL;
						PinDef* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						cairo_t* _tmp40_ = NULL;
						_tmp36_ = context;
						cairo_move_to (_tmp36_, (gdouble) 0, (gdouble) 0);
						_tmp37_ = context;
						_tmp38_ = self->pinDef;
						_tmp39_ = _tmp38_->length;
						cairo_line_to (_tmp37_, (gdouble) _tmp39_, (gdouble) 0);
						_tmp40_ = context;
						cairo_stroke (_tmp40_);
					}
				}
				_tmp41_ = context;
				_tmp42_ = oldMatrix;
				cairo_set_matrix (_tmp41_, &_tmp42_);
			}
		}
	}
}


static void value_pin_inst_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pin_inst_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pin_inst_unref (value->data[0].v_pointer);
	}
}


static void value_pin_inst_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pin_inst_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pin_inst_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pin_inst_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PinInst* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pin_inst_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pin_inst_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PinInst** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pin_inst_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPinInst* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIN_INST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pin_inst (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIN_INST), NULL);
	return value->data[0].v_pointer;
}


void value_set_pin_inst (GValue* value, gpointer v_object) {
	PinInst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIN_INST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIN_INST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pin_inst_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pin_inst_unref (old);
	}
}


void value_take_pin_inst (GValue* value, gpointer v_object) {
	PinInst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIN_INST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIN_INST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pin_inst_unref (old);
	}
}


static void pin_inst_class_init (PinInstClass * klass) {
	pin_inst_parent_class = g_type_class_peek_parent (klass);
	PIN_INST_CLASS (klass)->finalize = pin_inst_finalize;
}


static void pin_inst_instance_init (PinInst * self) {
	self->ref_count = 1;
}


static void pin_inst_finalize (PinInst* obj) {
	PinInst * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIN_INST, PinInst);
	self->x = (g_free (self->x), NULL);
	self->y = (g_free (self->y), NULL);
	self->xConnect = (g_free (self->xConnect), NULL);
	self->yConnect = (g_free (self->yConnect), NULL);
	self->wireInsts = (_vala_array_free (self->wireInsts, self->wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
	self->invert = (g_free (self->invert), NULL);
	_pin_def_unref0 (self->pinDef);
}


/**
 * An instance of a pin on a ComponentInst.
 * 
 * Stores information about a pin and its connections.
 */
GType pin_inst_get_type (void) {
	static volatile gsize pin_inst_type_id__volatile = 0;
	if (g_once_init_enter (&pin_inst_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pin_inst_init, value_pin_inst_free_value, value_pin_inst_copy_value, value_pin_inst_peek_pointer, "p", value_pin_inst_collect_value, "p", value_pin_inst_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PinInstClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pin_inst_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PinInst), 0, (GInstanceInitFunc) pin_inst_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pin_inst_type_id;
		pin_inst_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PinInst", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pin_inst_type_id__volatile, pin_inst_type_id);
	}
	return pin_inst_type_id__volatile;
}


gpointer pin_inst_ref (gpointer instance) {
	PinInst* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pin_inst_unref (gpointer instance) {
	PinInst* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PIN_INST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



