/* plugincomponentmanager.c generated by valac 0.24.0, the Vala compiler
 * generated from plugincomponentmanager.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: plugincomponentmanager.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <gmodule.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <float.h>
#include <math.h>
#include <libxml/parser.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;
typedef struct _PluginComponentManagerPrivate PluginComponentManagerPrivate;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _plugin_component_manager_unref0(var) ((var == NULL) ? NULL : (var = (plugin_component_manager_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _PluginComponentDefPrivate PluginComponentDefPrivate;
typedef struct _ParamSpecPluginComponentManager ParamSpecPluginComponentManager;

struct _PluginComponentManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PluginComponentManagerPrivate * priv;
	GModule* mainProgram;
	GModule* module;
	gchar* filename;
	gchar* name;
	Project* project;
	PluginComponentDef* pluginComponentDef;
};

struct _PluginComponentManagerClass {
	GTypeClass parent_class;
	void (*finalize) (PluginComponentManager *self);
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _PluginComponentDef {
	ComponentDef parent_instance;
	PluginComponentDefPrivate * priv;
	PluginComponentManager* manager;
};

struct _PluginComponentDefClass {
	ComponentDefClass parent_class;
};

typedef gboolean (*PluginComponentManagerinit_delegate) (PluginComponentManager* manager, void* user_data);
typedef PluginComponentDef* (*PluginComponentManagerget_def_delegate) (const gchar* infoFilename, void* user_data);
struct _ParamSpecPluginComponentManager {
	GParamSpec parent_instance;
};


static gpointer plugin_component_manager_parent_class = NULL;
static PluginComponentManager** plugin_component_manager_pluginComponentManagers;
static gint plugin_component_manager_pluginComponentManagers_length1;
static PluginComponentManager** plugin_component_manager_pluginComponentManagers = NULL;
static gint plugin_component_manager_pluginComponentManagers_length1 = 0;
static gint _plugin_component_manager_pluginComponentManagers_size_ = 0;

gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType plugin_component_def_get_type (void) G_GNUC_CONST;
enum  {
	PLUGIN_COMPONENT_MANAGER_DUMMY_PROPERTY
};
static void plugin_component_manager_register (PluginComponentManager* pluginComponentManager);
static void _vala_array_add67 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value);
void plugin_component_manager_unregister_all (void);
static void plugin_component_manager_unload (PluginComponentManager* self);
PluginComponentManager* plugin_component_manager_from_name (const gchar* name);
PluginComponentManager* plugin_component_manager_from_filename (const gchar* filename);
gchar* core_absolute_filename (const gchar* filename, const gchar* pwd);
GQuark component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
PluginComponentManager* plugin_component_manager_new_from_file (const gchar* infoFilename, Project* project, GError** error);
PluginComponentManager* plugin_component_manager_construct_from_file (GType object_type, const gchar* infoFilename, Project* project, GError** error);
static gint plugin_component_manager_load (PluginComponentManager* self, const gchar* infoFilename, GError** error);
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
ComponentDef* project_resolve_def_name (Project* self, const gchar* name);
static void plugin_component_manager_load_library (PluginComponentManager* self, const gchar* libraryPath, GError** error);
void plugin_component_manager_print_info (PluginComponentManager* self, const gchar* text);
void plugin_component_manager_print_error (PluginComponentManager* self, const gchar* text);
PluginComponentManager* plugin_component_manager_new (void);
PluginComponentManager* plugin_component_manager_construct (GType object_type);
static void plugin_component_manager_finalize (PluginComponentManager* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Adds //pluginComponentManager// to the list of loaded managers.
 */
static gpointer _plugin_component_manager_ref0 (gpointer self) {
	return self ? plugin_component_manager_ref (self) : NULL;
}


static void _vala_array_add67 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentManager*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void plugin_component_manager_register (PluginComponentManager* pluginComponentManager) {
	gint position = 0;
	PluginComponentManager** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	PluginComponentManager** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PluginComponentManager* _tmp2_ = NULL;
	PluginComponentManager* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	PluginComponentManager* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_if_fail (pluginComponentManager != NULL);
	_tmp0_ = plugin_component_manager_pluginComponentManagers;
	_tmp0__length1 = plugin_component_manager_pluginComponentManagers_length1;
	position = _tmp0__length1;
	_tmp1_ = plugin_component_manager_pluginComponentManagers;
	_tmp1__length1 = plugin_component_manager_pluginComponentManagers_length1;
	_tmp2_ = pluginComponentManager;
	_tmp3_ = _plugin_component_manager_ref0 (_tmp2_);
	_vala_array_add67 (&plugin_component_manager_pluginComponentManagers, &plugin_component_manager_pluginComponentManagers_length1, &_plugin_component_manager_pluginComponentManagers_size_, _tmp3_);
	_tmp4_ = stdout;
	_tmp5_ = pluginComponentManager;
	_tmp6_ = _tmp5_->name;
	fprintf (_tmp4_, "Registered Plugin Component Manager (%i: \"%s\").\n", position, _tmp6_);
}


/**
 * Dereference everything. Only call at program termination.
 */
void plugin_component_manager_unregister_all (void) {
	FILE* _tmp0_ = NULL;
	PluginComponentManager** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	FILE* _tmp4_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Unregistering Plugin Component Managers...\n");
	_tmp1_ = plugin_component_manager_pluginComponentManagers;
	_tmp1__length1 = plugin_component_manager_pluginComponentManagers_length1;
	{
		PluginComponentManager** pluginComponentManager_collection = NULL;
		gint pluginComponentManager_collection_length1 = 0;
		gint _pluginComponentManager_collection_size_ = 0;
		gint pluginComponentManager_it = 0;
		pluginComponentManager_collection = _tmp1_;
		pluginComponentManager_collection_length1 = _tmp1__length1;
		for (pluginComponentManager_it = 0; pluginComponentManager_it < _tmp1__length1; pluginComponentManager_it = pluginComponentManager_it + 1) {
			PluginComponentManager* _tmp2_ = NULL;
			PluginComponentManager* pluginComponentManager = NULL;
			_tmp2_ = _plugin_component_manager_ref0 (pluginComponentManager_collection[pluginComponentManager_it]);
			pluginComponentManager = _tmp2_;
			{
				PluginComponentManager* _tmp3_ = NULL;
				_tmp3_ = pluginComponentManager;
				plugin_component_manager_unload (_tmp3_);
				_plugin_component_manager_unref0 (pluginComponentManager);
			}
		}
	}
	plugin_component_manager_pluginComponentManagers = (_vala_array_free (plugin_component_manager_pluginComponentManagers, plugin_component_manager_pluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
	plugin_component_manager_pluginComponentManagers = NULL;
	plugin_component_manager_pluginComponentManagers_length1 = 0;
	_plugin_component_manager_pluginComponentManagers_size_ = plugin_component_manager_pluginComponentManagers_length1;
	_tmp4_ = stdout;
	fprintf (_tmp4_, "Unregistered Plugin Component Managers.\n");
}


/**
 * Returns a manager which is found with name //name//,
 * or null is none exists.
 */
PluginComponentManager* plugin_component_manager_from_name (const gchar* name) {
	PluginComponentManager* result = NULL;
	PluginComponentManager** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = plugin_component_manager_pluginComponentManagers;
	_tmp0__length1 = plugin_component_manager_pluginComponentManagers_length1;
	{
		PluginComponentManager** pluginComponentManager_collection = NULL;
		gint pluginComponentManager_collection_length1 = 0;
		gint _pluginComponentManager_collection_size_ = 0;
		gint pluginComponentManager_it = 0;
		pluginComponentManager_collection = _tmp0_;
		pluginComponentManager_collection_length1 = _tmp0__length1;
		for (pluginComponentManager_it = 0; pluginComponentManager_it < _tmp0__length1; pluginComponentManager_it = pluginComponentManager_it + 1) {
			PluginComponentManager* _tmp1_ = NULL;
			PluginComponentManager* pluginComponentManager = NULL;
			_tmp1_ = _plugin_component_manager_ref0 (pluginComponentManager_collection[pluginComponentManager_it]);
			pluginComponentManager = _tmp1_;
			{
				PluginComponentManager* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				_tmp2_ = pluginComponentManager;
				_tmp3_ = _tmp2_->name;
				_tmp4_ = name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					result = pluginComponentManager;
					return result;
				}
				_plugin_component_manager_unref0 (pluginComponentManager);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * Returns a manager which is found with filename //filename//,
 * or null is none exists.
 */
PluginComponentManager* plugin_component_manager_from_filename (const gchar* filename) {
	PluginComponentManager* result = NULL;
	PluginComponentManager** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = plugin_component_manager_pluginComponentManagers;
	_tmp0__length1 = plugin_component_manager_pluginComponentManagers_length1;
	{
		PluginComponentManager** pluginComponentManager_collection = NULL;
		gint pluginComponentManager_collection_length1 = 0;
		gint _pluginComponentManager_collection_size_ = 0;
		gint pluginComponentManager_it = 0;
		pluginComponentManager_collection = _tmp0_;
		pluginComponentManager_collection_length1 = _tmp0__length1;
		for (pluginComponentManager_it = 0; pluginComponentManager_it < _tmp0__length1; pluginComponentManager_it = pluginComponentManager_it + 1) {
			PluginComponentManager* _tmp1_ = NULL;
			PluginComponentManager* pluginComponentManager = NULL;
			_tmp1_ = _plugin_component_manager_ref0 (pluginComponentManager_collection[pluginComponentManager_it]);
			pluginComponentManager = _tmp1_;
			{
				FILE* _tmp2_ = NULL;
				PluginComponentManager* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				PluginComponentManager* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				_tmp2_ = stdout;
				_tmp3_ = pluginComponentManager;
				_tmp4_ = _tmp3_->filename;
				_tmp5_ = g_get_current_dir ();
				_tmp6_ = _tmp5_;
				_tmp7_ = core_absolute_filename (_tmp4_, _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = filename;
				_tmp10_ = g_get_current_dir ();
				_tmp11_ = _tmp10_;
				_tmp12_ = core_absolute_filename (_tmp9_, _tmp11_);
				_tmp13_ = _tmp12_;
				fprintf (_tmp2_, "Comparing component filenames: \n\t\"%s\"\n\t\"%s\"\n", _tmp8_, _tmp13_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp6_);
				_tmp14_ = pluginComponentManager;
				_tmp15_ = _tmp14_->filename;
				_tmp16_ = g_get_current_dir ();
				_tmp17_ = _tmp16_;
				_tmp18_ = core_absolute_filename (_tmp15_, _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = filename;
				_tmp21_ = g_get_current_dir ();
				_tmp22_ = _tmp21_;
				_tmp23_ = core_absolute_filename (_tmp20_, _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strcmp0 (_tmp19_, _tmp24_) == 0;
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				if (_tmp25_) {
					result = pluginComponentManager;
					return result;
				}
				_plugin_component_manager_unref0 (pluginComponentManager);
			}
		}
	}
	result = NULL;
	return result;
}


/**
 * Loads a PluginComponentDef from a file using libxml.
 */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


PluginComponentManager* plugin_component_manager_construct_from_file (GType object_type, const gchar* infoFilename, Project* project, GError** error) {
	PluginComponentManager* self = NULL;
	const gchar* _tmp0_ = NULL;
	PluginComponentManager* _tmp1_ = NULL;
	PluginComponentManager* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	Project* _tmp15_ = NULL;
	PluginComponentDef* _tmp19_ = NULL;
	PluginComponentManager* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (infoFilename != NULL, NULL);
	g_return_val_if_fail (project != NULL, NULL);
	self = (PluginComponentManager*) g_type_create_instance (object_type);
	_tmp0_ = infoFilename;
	_tmp1_ = plugin_component_manager_from_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_plugin_component_manager_unref0 (_tmp2_);
	if (_tmp3_) {
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		_tmp4_ = stdout;
		_tmp5_ = infoFilename;
		fprintf (_tmp4_, "Error initialising plugin: Plugin cannot load twice conflict: \"%s\".\n", _tmp5_);
		_tmp6_ = infoFilename;
		_tmp7_ = g_strconcat ("Plugin cannot load twice: \"", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "\"", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_inner_error_ = _tmp12_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_plugin_component_manager_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = infoFilename;
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (self->filename);
	self->filename = _tmp14_;
	_tmp15_ = project;
	self->project = _tmp15_;
	{
		const gchar* _tmp16_ = NULL;
		_tmp16_ = infoFilename;
		plugin_component_manager_load (self, _tmp16_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
				goto __catch55_plugin_component_def_load_error;
			}
			goto __finally55;
		}
	}
	goto __finally55;
	__catch55_plugin_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = _error_;
		_tmp18_ = _g_error_copy0 (_tmp17_);
		_inner_error_ = _tmp18_;
		_g_error_free0 (_error_);
		goto __finally55;
	}
	__finally55:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_plugin_component_manager_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	plugin_component_manager_register (self);
	_tmp19_ = self->pluginComponentDef;
	_tmp20_ = _plugin_component_manager_ref0 (self);
	_plugin_component_manager_unref0 (_tmp19_->manager);
	_tmp19_->manager = _tmp20_;
	return self;
}


PluginComponentManager* plugin_component_manager_new_from_file (const gchar* infoFilename, Project* project, GError** error) {
	return plugin_component_manager_construct_from_file (TYPE_PLUGIN_COMPONENT_MANAGER, infoFilename, project, error);
}


/**
 * Loads a component from the file //infoFilename//, using libxml.
 */
static gint plugin_component_manager_load (PluginComponentManager* self, const gchar* infoFilename, GError** error) {
	gint result = 0;
	gchar* libraryPath = NULL;
	gchar* builtLibraryPath = NULL;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	xmlDoc* xmldoc = NULL;
	xmlNode* xmlroot = NULL;
	xmlNode* xmlnode = NULL;
	const gchar* _tmp2_ = NULL;
	xmlDoc* _tmp3_ = NULL;
	xmlDoc* _tmp4_ = NULL;
	xmlDoc* _tmp15_ = NULL;
	xmlNode* _tmp16_ = NULL;
	xmlNode* _tmp17_ = NULL;
	xmlNode* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	xmlDoc* _tmp83_ = NULL;
	Project* _tmp84_ = NULL;
	const gchar* _tmp85_ = NULL;
	ComponentDef* _tmp86_ = NULL;
	ComponentDef* _tmp87_ = NULL;
	gboolean _tmp88_ = FALSE;
	const gchar* _tmp96_ = NULL;
	PluginComponentManager* _tmp97_ = NULL;
	PluginComponentManager* _tmp98_ = NULL;
	gboolean _tmp99_ = FALSE;
	const gchar* _tmp109_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (infoFilename != NULL, 0);
	libraryPath = NULL;
	builtLibraryPath = NULL;
	_tmp0_ = stdout;
	_tmp1_ = infoFilename;
	fprintf (_tmp0_, "Loading plugin component specific data from \"%s\"\n", _tmp1_);
	_tmp2_ = infoFilename;
	_tmp3_ = xmlParseFile (_tmp2_);
	xmldoc = _tmp3_;
	_tmp4_ = xmldoc;
	if (_tmp4_ == NULL) {
		FILE* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		FILE* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = infoFilename;
		fprintf (_tmp5_, "Error loading info xml file \"%s\".\n", _tmp6_);
		_tmp7_ = stdout;
		fprintf (_tmp7_, "File inaccessible.\n");
		_tmp8_ = infoFilename;
		_tmp9_ = g_strconcat ("File inaccessible: \"", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, "\"", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_FILE, _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_inner_error_ = _tmp14_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			return 0;
		} else {
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp15_ = xmldoc;
	_tmp16_ = xmlDocGetRootElement (_tmp15_);
	xmlroot = _tmp16_;
	_tmp17_ = xmlroot;
	if (_tmp17_ == NULL) {
		FILE* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		FILE* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
		_tmp18_ = stdout;
		_tmp19_ = infoFilename;
		fprintf (_tmp18_, "Error loading info xml file \"%s\".\n", _tmp19_);
		_tmp20_ = stdout;
		fprintf (_tmp20_, "File is empty.\n");
		_tmp21_ = infoFilename;
		_tmp22_ = g_strconcat ("File empty: \"", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "\"", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_FILE, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_inner_error_ = _tmp27_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			return 0;
		} else {
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp28_ = xmlroot;
	_tmp29_ = _tmp28_->name;
	if (g_strcmp0 (_tmp29_, "plugin_component") != 0) {
		FILE* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		FILE* _tmp32_ = NULL;
		xmlNode* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		xmlNode* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		GError* _tmp46_ = NULL;
		GError* _tmp47_ = NULL;
		_tmp30_ = stdout;
		_tmp31_ = infoFilename;
		fprintf (_tmp30_, "Error loading info xml file \"%s\".\n", _tmp31_);
		_tmp32_ = stdout;
		_tmp33_ = xmlroot;
		_tmp34_ = _tmp33_->name;
		fprintf (_tmp32_, "Wanted \"plugin_component\" info, but got \"%s\"\n", _tmp34_);
		_tmp35_ = xmlroot;
		_tmp36_ = _tmp35_->name;
		_tmp37_ = g_strconcat ("Wanted \"plugin_component\" info, but got \"", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, "\": \"", NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = infoFilename;
		_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN, _tmp45_);
		_tmp47_ = _tmp46_;
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_inner_error_ = _tmp47_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			return 0;
		} else {
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	{
		xmlNode* _tmp48_ = NULL;
		xmlNode* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		_tmp48_ = xmlroot;
		_tmp49_ = _tmp48_->children;
		xmlnode = _tmp49_;
		_tmp50_ = TRUE;
		while (TRUE) {
			xmlNode* _tmp53_ = NULL;
			xmlNode* _tmp54_ = NULL;
			xmlElementType _tmp55_ = 0;
			xmlNode* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GQuark _tmp60_ = 0U;
			static GQuark _tmp59_label0 = 0;
			static GQuark _tmp59_label1 = 0;
			if (!_tmp50_) {
				xmlNode* _tmp51_ = NULL;
				xmlNode* _tmp52_ = NULL;
				_tmp51_ = xmlnode;
				_tmp52_ = _tmp51_->next;
				xmlnode = _tmp52_;
			}
			_tmp50_ = FALSE;
			_tmp53_ = xmlnode;
			if (!(_tmp53_ != NULL)) {
				break;
			}
			_tmp54_ = xmlnode;
			_tmp55_ = _tmp54_->type;
			if (_tmp55_ != XML_ELEMENT_NODE) {
				continue;
			}
			_tmp56_ = xmlnode;
			_tmp57_ = _tmp56_->name;
			_tmp58_ = _tmp57_;
			_tmp60_ = (NULL == _tmp58_) ? 0 : g_quark_from_string (_tmp58_);
			if (_tmp60_ == ((0 != _tmp59_label0) ? _tmp59_label0 : (_tmp59_label0 = g_quark_from_static_string ("name")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp61_ = NULL;
								xmlNode* _tmp62_ = NULL;
								_tmp61_ = xmlnode;
								_tmp62_ = _tmp61_->children;
								xmldata = _tmp62_;
								{
									gboolean _tmp63_ = FALSE;
									_tmp63_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp66_ = NULL;
										xmlNode* _tmp67_ = NULL;
										xmlElementType _tmp68_ = 0;
										xmlNode* _tmp69_ = NULL;
										const gchar* _tmp70_ = NULL;
										gchar* _tmp71_ = NULL;
										if (!_tmp63_) {
											xmlNode* _tmp64_ = NULL;
											xmlNode* _tmp65_ = NULL;
											_tmp64_ = xmldata;
											_tmp65_ = _tmp64_->next;
											xmldata = _tmp65_;
										}
										_tmp63_ = FALSE;
										_tmp66_ = xmldata;
										if (!(_tmp66_ != NULL)) {
											break;
										}
										_tmp67_ = xmlnode;
										_tmp68_ = _tmp67_->type;
										if (_tmp68_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp69_ = xmldata;
										_tmp70_ = _tmp69_->content;
										_tmp71_ = g_strdup (_tmp70_);
										_g_free0 (self->name);
										self->name = _tmp71_;
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp60_ == ((0 != _tmp59_label1) ? _tmp59_label1 : (_tmp59_label1 = g_quark_from_static_string ("library")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp72_ = NULL;
								xmlNode* _tmp73_ = NULL;
								_tmp72_ = xmlnode;
								_tmp73_ = _tmp72_->children;
								xmldata = _tmp73_;
								{
									gboolean _tmp74_ = FALSE;
									_tmp74_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp77_ = NULL;
										xmlNode* _tmp78_ = NULL;
										xmlElementType _tmp79_ = 0;
										xmlNode* _tmp80_ = NULL;
										const gchar* _tmp81_ = NULL;
										gchar* _tmp82_ = NULL;
										if (!_tmp74_) {
											xmlNode* _tmp75_ = NULL;
											xmlNode* _tmp76_ = NULL;
											_tmp75_ = xmldata;
											_tmp76_ = _tmp75_->next;
											xmldata = _tmp76_;
										}
										_tmp74_ = FALSE;
										_tmp77_ = xmldata;
										if (!(_tmp77_ != NULL)) {
											break;
										}
										_tmp78_ = xmlnode;
										_tmp79_ = _tmp78_->type;
										if (_tmp79_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp80_ = xmldata;
										_tmp81_ = _tmp80_->content;
										_tmp82_ = g_strdup (_tmp81_);
										_g_free0 (libraryPath);
										libraryPath = _tmp82_;
									}
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	_tmp83_ = xmldoc;
	xmlFreeDoc (_tmp83_);
	_tmp84_ = self->project;
	_tmp85_ = self->name;
	_tmp86_ = project_resolve_def_name (_tmp84_, _tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = _tmp87_ != NULL;
	_component_def_unref0 (_tmp87_);
	if (_tmp88_) {
		const gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		GError* _tmp94_ = NULL;
		GError* _tmp95_ = NULL;
		_tmp89_ = self->name;
		_tmp90_ = g_strconcat ("A component with the name \"", _tmp89_, NULL);
		_tmp91_ = _tmp90_;
		_tmp92_ = g_strconcat (_tmp91_, "\" already exists. Rename the component which is already open (if it i" \
"s a custom component) using the customiser dialog, accessible via the " \
"component menu.", NULL);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT, _tmp93_);
		_tmp95_ = _tmp94_;
		_g_free0 (_tmp93_);
		_g_free0 (_tmp91_);
		_inner_error_ = _tmp95_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			return 0;
		} else {
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp96_ = self->name;
	_tmp97_ = plugin_component_manager_from_name (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = _tmp98_ != NULL;
	_plugin_component_manager_unref0 (_tmp98_);
	if (_tmp99_) {
		FILE* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		const gchar* _tmp102_ = NULL;
		gchar* _tmp103_ = NULL;
		gchar* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		gchar* _tmp106_ = NULL;
		GError* _tmp107_ = NULL;
		GError* _tmp108_ = NULL;
		_tmp100_ = stdout;
		_tmp101_ = self->name;
		fprintf (_tmp100_, "Error initialising plugin: Plugin name conflict: \"%s\".\n", _tmp101_);
		_tmp102_ = self->name;
		_tmp103_ = g_strconcat ("Plugin name conflict: \"", _tmp102_, NULL);
		_tmp104_ = _tmp103_;
		_tmp105_ = g_strconcat (_tmp104_, "\"", NULL);
		_tmp106_ = _tmp105_;
		_tmp107_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT, _tmp106_);
		_tmp108_ = _tmp107_;
		_g_free0 (_tmp106_);
		_g_free0 (_tmp104_);
		_inner_error_ = _tmp108_;
		if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			return 0;
		} else {
			_g_free0 (builtLibraryPath);
			_g_free0 (libraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp109_ = libraryPath;
	if (_tmp109_ == NULL) {
		const gchar* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_ = NULL;
		_tmp110_ = self->name;
		_tmp111_ = g_utf8_strdown (_tmp110_, (gssize) (-1));
		_tmp112_ = _tmp111_;
		_tmp113_ = g_strconcat (PACKAGE_LIBDIR, _tmp112_, NULL);
		_g_free0 (builtLibraryPath);
		builtLibraryPath = _tmp113_;
		_g_free0 (_tmp112_);
		{
			const gchar* _tmp114_ = NULL;
			_tmp114_ = builtLibraryPath;
			plugin_component_manager_load_library (self, _tmp114_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
					goto __catch56_plugin_component_def_load_error;
				}
				_g_free0 (builtLibraryPath);
				_g_free0 (libraryPath);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		goto __finally56;
		__catch56_plugin_component_def_load_error:
		{
			GError* _error_ = NULL;
			GError* _tmp115_ = NULL;
			GError* _tmp116_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp115_ = _error_;
			_tmp116_ = _g_error_copy0 (_tmp115_);
			_inner_error_ = _tmp116_;
			_g_error_free0 (_error_);
			goto __finally56;
		}
		__finally56:
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (builtLibraryPath);
				_g_free0 (libraryPath);
				return 0;
			} else {
				_g_free0 (builtLibraryPath);
				_g_free0 (libraryPath);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	} else {
		const gchar* _tmp117_ = NULL;
		gboolean _tmp118_ = FALSE;
		_tmp117_ = libraryPath;
		_tmp118_ = g_path_is_absolute (_tmp117_);
		if (_tmp118_ == FALSE) {
			const gchar* _tmp119_ = NULL;
			gchar* _tmp120_ = NULL;
			gchar* _tmp121_ = NULL;
			const gchar* _tmp122_ = NULL;
			gchar* _tmp123_ = NULL;
			gchar* _tmp124_ = NULL;
			const gchar* _tmp125_ = NULL;
			gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
			gchar* _tmp128_ = NULL;
			_tmp119_ = self->filename;
			_tmp120_ = g_path_get_dirname (_tmp119_);
			_tmp121_ = _tmp120_;
			_tmp122_ = libraryPath;
			_tmp123_ = g_path_get_dirname (_tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = libraryPath;
			_tmp126_ = g_path_get_basename (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = g_build_filename (_tmp121_, _tmp124_, _tmp127_, NULL);
			_g_free0 (builtLibraryPath);
			builtLibraryPath = _tmp128_;
			_g_free0 (_tmp127_);
			_g_free0 (_tmp124_);
			_g_free0 (_tmp121_);
		} else {
			const gchar* _tmp129_ = NULL;
			gchar* _tmp130_ = NULL;
			_tmp129_ = libraryPath;
			_tmp130_ = g_strdup (_tmp129_);
			_g_free0 (builtLibraryPath);
			builtLibraryPath = _tmp130_;
		}
		{
			const gchar* _tmp131_ = NULL;
			_tmp131_ = builtLibraryPath;
			plugin_component_manager_load_library (self, _tmp131_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
					goto __catch57_plugin_component_def_load_error;
				}
				_g_free0 (builtLibraryPath);
				_g_free0 (libraryPath);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		goto __finally57;
		__catch57_plugin_component_def_load_error:
		{
			GError* _error_ = NULL;
			GError* _tmp132_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp132_ = _error_;
			if (g_error_matches (_tmp132_, PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE)) {
				{
					const gchar* _tmp133_ = NULL;
					gchar* _tmp134_ = NULL;
					const gchar* _tmp135_ = NULL;
					_tmp133_ = libraryPath;
					_tmp134_ = g_strconcat (PACKAGE_LIBDIR, _tmp133_, NULL);
					_g_free0 (builtLibraryPath);
					builtLibraryPath = _tmp134_;
					_tmp135_ = builtLibraryPath;
					plugin_component_manager_load_library (self, _tmp135_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
							goto __catch58_plugin_component_def_load_error;
						}
						_g_error_free0 (_error_);
						_g_free0 (builtLibraryPath);
						_g_free0 (libraryPath);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				goto __finally58;
				__catch58_plugin_component_def_load_error:
				{
					GError* _error_ = NULL;
					GError* _tmp136_ = NULL;
					GError* _tmp137_ = NULL;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp136_ = _error_;
					_tmp137_ = _g_error_copy0 (_tmp136_);
					_inner_error_ = _tmp137_;
					_g_error_free0 (_error_);
					goto __finally58;
				}
				__finally58:
				if (_inner_error_ != NULL) {
					_g_error_free0 (_error_);
					goto __finally57;
				}
			} else {
				GError* _tmp138_ = NULL;
				GError* _tmp139_ = NULL;
				_tmp138_ = _error_;
				_tmp139_ = _g_error_copy0 (_tmp138_);
				_inner_error_ = _tmp139_;
				_g_error_free0 (_error_);
				goto __finally57;
			}
			_g_error_free0 (_error_);
		}
		__finally57:
		if (_inner_error_ != NULL) {
			if ((_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) || (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (builtLibraryPath);
				_g_free0 (libraryPath);
				return 0;
			} else {
				_g_free0 (builtLibraryPath);
				_g_free0 (libraryPath);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = 0;
	_g_free0 (builtLibraryPath);
	_g_free0 (libraryPath);
	return result;
}


static void plugin_component_manager_load_library (PluginComponentManager* self, const gchar* libraryPath, GError** error) {
	gchar* fullLibraryPath = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	FILE* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GModule* _tmp10_ = NULL;
	GModule* _tmp11_ = NULL;
	FILE* _tmp26_ = NULL;
	void* init_pointer = NULL;
	void* get_def_pointer = NULL;
	PluginComponentManagerinit_delegate init_function = NULL;
	void* init_function_target = NULL;
	GDestroyNotify init_function_target_destroy_notify = NULL;
	PluginComponentManagerget_def_delegate get_def_function = NULL;
	void* get_def_function_target = NULL;
	GDestroyNotify get_def_function_target_destroy_notify = NULL;
	GModule* _tmp27_ = NULL;
	void* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	void* _tmp50_ = NULL;
	GModule* _tmp52_ = NULL;
	void* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	void* _tmp57_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (libraryPath != NULL);
	_tmp0_ = libraryPath;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = libraryPath;
	_tmp4_ = g_path_get_basename (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_module_build_path (_tmp2_, _tmp5_);
	_g_free0 (fullLibraryPath);
	fullLibraryPath = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp7_ = stdout;
	_tmp8_ = fullLibraryPath;
	fprintf (_tmp7_, "Attempting to open module: %s\n", _tmp8_);
	_tmp9_ = fullLibraryPath;
	_tmp10_ = g_module_open (_tmp9_, 0);
	_g_module_close0 (self->module);
	self->module = _tmp10_;
	_tmp11_ = self->module;
	if (_tmp11_ == NULL) {
		FILE* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = g_module_error ();
		fprintf (_tmp12_, "Unable to open module: %s\n", _tmp13_);
		_tmp14_ = self->filename;
		_tmp15_ = g_strconcat ("Library could not be opened: \"", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "\": \"", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = fullLibraryPath;
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "\": ", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp25_;
		if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (fullLibraryPath);
			return;
		} else {
			_g_free0 (fullLibraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp26_ = stdout;
	fprintf (_tmp26_, "Successfully opened module.\n");
	init_pointer = NULL;
	get_def_pointer = NULL;
	init_function = NULL;
	init_function_target = NULL;
	init_function_target_destroy_notify = NULL;
	get_def_function = NULL;
	get_def_function_target = NULL;
	get_def_function_target_destroy_notify = NULL;
	_tmp27_ = self->module;
	_tmp29_ = g_module_symbol (_tmp27_, "plugin_component_init", &_tmp28_);
	init_pointer = _tmp28_;
	if (_tmp29_) {
		void* _tmp30_ = NULL;
		_tmp30_ = init_pointer;
		if (_tmp30_ != NULL) {
			FILE* _tmp31_ = NULL;
			void* _tmp32_ = NULL;
			PluginComponentManagerinit_delegate _tmp33_ = NULL;
			void* _tmp33__target = NULL;
			gboolean _tmp34_ = FALSE;
			_tmp31_ = stdout;
			fprintf (_tmp31_, "Initialising plugin... (plugin_component_init).\n");
			_tmp32_ = init_pointer;
			(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
			init_function = NULL;
			init_function_target = NULL;
			init_function_target_destroy_notify = NULL;
			init_function = (PluginComponentManagerinit_delegate) _tmp32_;
			init_function_target = NULL;
			init_function_target_destroy_notify = NULL;
			_tmp33_ = init_function;
			_tmp33__target = init_function_target;
			_tmp34_ = _tmp33_ (self, _tmp33__target);
			if (_tmp34_ == FALSE) {
				FILE* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				GError* _tmp46_ = NULL;
				GError* _tmp47_ = NULL;
				_tmp35_ = stdout;
				fprintf (_tmp35_, "Error initialising plugin: Plugin init function reported failure.\n");
				_tmp36_ = self->filename;
				_tmp37_ = g_strconcat ("Plugin init function reported failure: \"", _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strconcat (_tmp38_, "\": \"", NULL);
				_tmp40_ = _tmp39_;
				_tmp41_ = fullLibraryPath;
				_tmp42_ = g_strconcat (_tmp40_, _tmp41_, NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat (_tmp43_, "\": ", NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR, _tmp45_);
				_tmp47_ = _tmp46_;
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				_inner_error_ = _tmp47_;
				if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
					g_propagate_error (error, _inner_error_);
					(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
					get_def_function = NULL;
					get_def_function_target = NULL;
					get_def_function_target_destroy_notify = NULL;
					(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
					init_function = NULL;
					init_function_target = NULL;
					init_function_target_destroy_notify = NULL;
					_g_free0 (fullLibraryPath);
					return;
				} else {
					(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
					get_def_function = NULL;
					get_def_function_target = NULL;
					get_def_function_target_destroy_notify = NULL;
					(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
					init_function = NULL;
					init_function_target = NULL;
					init_function_target_destroy_notify = NULL;
					_g_free0 (fullLibraryPath);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			} else {
				FILE* _tmp48_ = NULL;
				_tmp48_ = stdout;
				fprintf (_tmp48_, "Initialising plugin... (plugin_component_init).\n");
			}
		} else {
			FILE* _tmp49_ = NULL;
			_tmp49_ = stdout;
			fprintf (_tmp49_, "Got null plugin_component_init function.\n");
		}
	}
	_tmp50_ = init_pointer;
	if (_tmp50_ == NULL) {
		FILE* _tmp51_ = NULL;
		_tmp51_ = stdout;
		fprintf (_tmp51_, "Plugin has no init function (plugin_component_init).\n");
	}
	_tmp52_ = self->module;
	_tmp54_ = g_module_symbol (_tmp52_, "plugin_component_get_def", &_tmp53_);
	get_def_pointer = _tmp53_;
	if (_tmp54_) {
		void* _tmp55_ = NULL;
		_tmp55_ = get_def_pointer;
		if (_tmp55_ != NULL) {
			void* _tmp56_ = NULL;
			_tmp56_ = get_def_pointer;
			(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
			get_def_function = NULL;
			get_def_function_target = NULL;
			get_def_function_target_destroy_notify = NULL;
			get_def_function = (PluginComponentManagerget_def_delegate) _tmp56_;
			get_def_function_target = NULL;
			get_def_function_target_destroy_notify = NULL;
		}
	}
	_tmp57_ = get_def_pointer;
	if (_tmp57_ == NULL) {
		FILE* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		GError* _tmp69_ = NULL;
		GError* _tmp70_ = NULL;
		_tmp58_ = stdout;
		fprintf (_tmp58_, "Error initialising plugin: Could not get component definition function" \
".\n");
		_tmp59_ = self->filename;
		_tmp60_ = g_strconcat ("Could not get component definition function: \"", _tmp59_, NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat (_tmp61_, "\": \"", NULL);
		_tmp63_ = _tmp62_;
		_tmp64_ = fullLibraryPath;
		_tmp65_ = g_strconcat (_tmp63_, _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "\": ", NULL);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE, _tmp68_);
		_tmp70_ = _tmp69_;
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
		_inner_error_ = _tmp70_;
		if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
			get_def_function = NULL;
			get_def_function_target = NULL;
			get_def_function_target_destroy_notify = NULL;
			(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
			init_function = NULL;
			init_function_target = NULL;
			init_function_target_destroy_notify = NULL;
			_g_free0 (fullLibraryPath);
			return;
		} else {
			(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
			get_def_function = NULL;
			get_def_function_target = NULL;
			get_def_function_target_destroy_notify = NULL;
			(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
			init_function = NULL;
			init_function_target = NULL;
			init_function_target_destroy_notify = NULL;
			_g_free0 (fullLibraryPath);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		PluginComponentManagerget_def_delegate _tmp71_ = NULL;
		void* _tmp71__target = NULL;
		const gchar* _tmp72_ = NULL;
		PluginComponentDef* _tmp73_ = NULL;
		PluginComponentDef* _tmp74_ = NULL;
		_tmp71_ = get_def_function;
		_tmp71__target = get_def_function_target;
		_tmp72_ = self->filename;
		_tmp73_ = _tmp71_ (_tmp72_, _tmp71__target);
		_component_def_unref0 (self->pluginComponentDef);
		self->pluginComponentDef = _tmp73_;
		_tmp74_ = self->pluginComponentDef;
		if (_tmp74_ == NULL) {
			FILE* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			gchar* _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			GError* _tmp86_ = NULL;
			GError* _tmp87_ = NULL;
			_tmp75_ = stdout;
			fprintf (_tmp75_, "Error initialising plugin: Failure getting component definition.\n");
			_tmp76_ = self->filename;
			_tmp77_ = g_strconcat ("Failure getting component definition: \"", _tmp76_, NULL);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strconcat (_tmp78_, "\": \"", NULL);
			_tmp80_ = _tmp79_;
			_tmp81_ = fullLibraryPath;
			_tmp82_ = g_strconcat (_tmp80_, _tmp81_, NULL);
			_tmp83_ = _tmp82_;
			_tmp84_ = g_strconcat (_tmp83_, "\": ", NULL);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_error_new_literal (PLUGIN_COMPONENT_DEF_LOAD_ERROR, PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR, _tmp85_);
			_tmp87_ = _tmp86_;
			_g_free0 (_tmp85_);
			_g_free0 (_tmp83_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp78_);
			_inner_error_ = _tmp87_;
			if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
				g_propagate_error (error, _inner_error_);
				(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
				get_def_function = NULL;
				get_def_function_target = NULL;
				get_def_function_target_destroy_notify = NULL;
				(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
				init_function = NULL;
				init_function_target = NULL;
				init_function_target_destroy_notify = NULL;
				_g_free0 (fullLibraryPath);
				return;
			} else {
				(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
				get_def_function = NULL;
				get_def_function_target = NULL;
				get_def_function_target_destroy_notify = NULL;
				(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
				init_function = NULL;
				init_function_target = NULL;
				init_function_target_destroy_notify = NULL;
				_g_free0 (fullLibraryPath);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	(get_def_function_target_destroy_notify == NULL) ? NULL : (get_def_function_target_destroy_notify (get_def_function_target), NULL);
	get_def_function = NULL;
	get_def_function_target = NULL;
	get_def_function_target_destroy_notify = NULL;
	(init_function_target_destroy_notify == NULL) ? NULL : (init_function_target_destroy_notify (init_function_target), NULL);
	init_function = NULL;
	init_function_target = NULL;
	init_function_target_destroy_notify = NULL;
	_g_free0 (fullLibraryPath);
}


void plugin_component_manager_print_info (PluginComponentManager* self, const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->name;
	_tmp2_ = self->filename;
	_tmp3_ = text;
	fprintf (_tmp0_, "Plugin \"%s\" (\"%s\") Info:\n\t%s\n", _tmp1_, _tmp2_, _tmp3_);
}


void plugin_component_manager_print_error (PluginComponentManager* self, const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->name;
	_tmp2_ = self->filename;
	_tmp3_ = text;
	fprintf (_tmp0_, "Plugin \"%s\" (\"%s\") Error:\n\t%s\n", _tmp1_, _tmp2_, _tmp3_);
}


static void plugin_component_manager_unload (PluginComponentManager* self) {
	PluginComponentDef* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->pluginComponentDef;
	_plugin_component_manager_unref0 (_tmp0_->manager);
	_tmp0_->manager = NULL;
	_component_def_unref0 (self->pluginComponentDef);
	self->pluginComponentDef = NULL;
}


PluginComponentManager* plugin_component_manager_construct (GType object_type) {
	PluginComponentManager* self = NULL;
	self = (PluginComponentManager*) g_type_create_instance (object_type);
	return self;
}


PluginComponentManager* plugin_component_manager_new (void) {
	return plugin_component_manager_construct (TYPE_PLUGIN_COMPONENT_MANAGER);
}


static void value_plugin_component_manager_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_plugin_component_manager_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		plugin_component_manager_unref (value->data[0].v_pointer);
	}
}


static void value_plugin_component_manager_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plugin_component_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_plugin_component_manager_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_plugin_component_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PluginComponentManager* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plugin_component_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_plugin_component_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PluginComponentManager** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plugin_component_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPluginComponentManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PLUGIN_COMPONENT_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_plugin_component_manager (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PLUGIN_COMPONENT_MANAGER), NULL);
	return value->data[0].v_pointer;
}


void value_set_plugin_component_manager (GValue* value, gpointer v_object) {
	PluginComponentManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PLUGIN_COMPONENT_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PLUGIN_COMPONENT_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plugin_component_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugin_component_manager_unref (old);
	}
}


void value_take_plugin_component_manager (GValue* value, gpointer v_object) {
	PluginComponentManager* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PLUGIN_COMPONENT_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PLUGIN_COMPONENT_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plugin_component_manager_unref (old);
	}
}


static void plugin_component_manager_class_init (PluginComponentManagerClass * klass) {
	PluginComponentManager** _tmp0_ = NULL;
	plugin_component_manager_parent_class = g_type_class_peek_parent (klass);
	PLUGIN_COMPONENT_MANAGER_CLASS (klass)->finalize = plugin_component_manager_finalize;
	_tmp0_ = g_new0 (PluginComponentManager*, 0 + 1);
	plugin_component_manager_pluginComponentManagers = _tmp0_;
	plugin_component_manager_pluginComponentManagers_length1 = 0;
}


static void plugin_component_manager_instance_init (PluginComponentManager * self) {
	GModule* _tmp0_ = NULL;
	_tmp0_ = g_module_open (NULL, 0);
	self->mainProgram = _tmp0_;
	self->module = NULL;
	self->filename = NULL;
	self->name = NULL;
	self->ref_count = 1;
}


static void plugin_component_manager_finalize (PluginComponentManager* obj) {
	PluginComponentManager * self;
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager);
	_tmp0_ = stdout;
	_tmp1_ = self->name;
	_tmp2_ = self->filename;
	fprintf (_tmp0_, "Plugin \"%s\" (\"%s\") Unloaded.\n", _tmp1_, _tmp2_);
	_g_module_close0 (self->mainProgram);
	_g_module_close0 (self->module);
	_g_free0 (self->filename);
	_g_free0 (self->name);
	_component_def_unref0 (self->pluginComponentDef);
}


/**
 * Manager and loader for a plugin component.
 * 
 * A PluginComponentManager is used to load a component from a shared
 * object / library file, DLL, etc. They greatly expand the capabilities
 * of SmartSim, but can potentially run malicious code.
 */
GType plugin_component_manager_get_type (void) {
	static volatile gsize plugin_component_manager_type_id__volatile = 0;
	if (g_once_init_enter (&plugin_component_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_plugin_component_manager_init, value_plugin_component_manager_free_value, value_plugin_component_manager_copy_value, value_plugin_component_manager_peek_pointer, "p", value_plugin_component_manager_collect_value, "p", value_plugin_component_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PluginComponentManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_component_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginComponentManager), 0, (GInstanceInitFunc) plugin_component_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType plugin_component_manager_type_id;
		plugin_component_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PluginComponentManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&plugin_component_manager_type_id__volatile, plugin_component_manager_type_id);
	}
	return plugin_component_manager_type_id__volatile;
}


gpointer plugin_component_manager_ref (gpointer instance) {
	PluginComponentManager* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void plugin_component_manager_unref (gpointer instance) {
	PluginComponentManager* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLUGIN_COMPONENT_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



