/* plugin-def-gpiopin.c generated by valac 0.24.0, the Vala compiler
 * generated from plugin-def-gpiopin.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: plugincomponents/plugin-def-gpiopin.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;
typedef struct _PluginComponentDefPrivate PluginComponentDefPrivate;

#define TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF (gpio_pin_plugin_component_def_get_type ())
#define GPIO_PIN_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF, GpioPinPluginComponentDef))
#define GPIO_PIN_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF, GpioPinPluginComponentDefClass))
#define IS_GPIO_PIN_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF))
#define IS_GPIO_PIN_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF))
#define GPIO_PIN_PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF, GpioPinPluginComponentDefClass))

typedef struct _GpioPinPluginComponentDef GpioPinPluginComponentDef;
typedef struct _GpioPinPluginComponentDefClass GpioPinPluginComponentDefClass;
typedef struct _GpioPinPluginComponentDefPrivate GpioPinPluginComponentDefPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))

#define TYPE_PROPERTY_ITEM_INT (property_item_int_get_type ())
#define PROPERTY_ITEM_INT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_INT, PropertyItemInt))
#define PROPERTY_ITEM_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_INT, PropertyItemIntClass))
#define IS_PROPERTY_ITEM_INT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_INT))
#define IS_PROPERTY_ITEM_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_INT))
#define PROPERTY_ITEM_INT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_INT, PropertyItemIntClass))

typedef struct _PropertyItemInt PropertyItemInt;
typedef struct _PropertyItemIntClass PropertyItemIntClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))

#define TYPE_PROPERTY_ITEM_SELECTION (property_item_selection_get_type ())
#define PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection))
#define PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))
#define IS_PROPERTY_ITEM_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_SELECTION))
#define IS_PROPERTY_ITEM_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_SELECTION))
#define PROPERTY_ITEM_SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelectionClass))

typedef struct _PropertyItemSelection PropertyItemSelection;
typedef struct _PropertyItemSelectionClass PropertyItemSelectionClass;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
typedef struct _PinInstPrivate PinInstPrivate;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE (gpio_pin_plugin_component_state_get_type ())
#define GPIO_PIN_PLUGIN_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentState))
#define GPIO_PIN_PLUGIN_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentStateClass))
#define IS_GPIO_PIN_PLUGIN_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE))
#define IS_GPIO_PIN_PLUGIN_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE))
#define GPIO_PIN_PLUGIN_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentStateClass))

typedef struct _GpioPinPluginComponentState GpioPinPluginComponentState;
typedef struct _GpioPinPluginComponentStateClass GpioPinPluginComponentStateClass;
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _PluginComponentDef {
	ComponentDef parent_instance;
	PluginComponentDefPrivate * priv;
	PluginComponentManager* manager;
};

struct _PluginComponentDefClass {
	ComponentDefClass parent_class;
};

struct _GpioPinPluginComponentDef {
	PluginComponentDef parent_instance;
	GpioPinPluginComponentDefPrivate * priv;
};

struct _GpioPinPluginComponentDefClass {
	PluginComponentDefClass parent_class;
};

struct _GpioPinPluginComponentDefPrivate {
	gchar* infoFilename;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
typedef enum  {
	PROPERTY_ITEM_ERROR_ITEM_NOT_FOUND
} PropertyItemError;
#define PROPERTY_ITEM_ERROR property_item_error_quark ()
struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

struct _PinInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PinInstPrivate * priv;
	gint* x;
	gint x_length1;
	gint* y;
	gint y_length1;
	gint* xConnect;
	gint xConnect_length1;
	gint* yConnect;
	gint yConnect_length1;
	gint xLabel;
	gint yLabel;
	WireInst** wireInsts;
	gint wireInsts_length1;
	gboolean* invert;
	gint invert_length1;
	PinDef* pinDef;
	gint arraySize;
	gint xMin;
	gint xMax;
	gint yMin;
	gint yMax;
	gboolean show;
};

struct _PinInstClass {
	GTypeClass parent_class;
	void (*finalize) (PinInst *self);
};

typedef enum  {
	COMPONENT_STATE_ERROR_COMPILE
} ComponentStateError;
#define COMPONENT_STATE_ERROR component_state_error_quark ()

extern PluginComponentManager* pluginManager;
PluginComponentManager* pluginManager = NULL;
static gpointer gpio_pin_plugin_component_def_parent_class = NULL;

gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
GType plugin_component_def_get_type (void) G_GNUC_CONST;
GType gpio_pin_plugin_component_def_get_type (void) G_GNUC_CONST;
#define GPIO_PIN_PLUGIN_COMPONENT_DEF_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF, GpioPinPluginComponentDefPrivate))
enum  {
	GPIO_PIN_PLUGIN_COMPONENT_DEF_DUMMY_PROPERTY
};
void plugin_component_manager_print_info (PluginComponentManager* self, const gchar* text);
GQuark component_def_load_error_quark (void);
GpioPinPluginComponentDef* gpio_pin_plugin_component_def_new (const gchar* infoFilename, GError** error);
GpioPinPluginComponentDef* gpio_pin_plugin_component_def_construct (GType object_type, const gchar* infoFilename, GError** error);
PluginComponentDef* plugin_component_def_construct (GType object_type);
GQuark custom_component_def_load_error_quark (void);
GQuark plugin_component_def_load_error_quark (void);
void component_def_load_from_file (ComponentDef* self, const gchar* infoFilename, GError** error);
static void gpio_pin_plugin_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty);
PropertyItem* property_set_get_item (PropertySet* self, const gchar* name);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
GType property_item_int_get_type (void) G_GNUC_CONST;
PropertyItemInt* property_item_int_new_copy (PropertyItemInt* source);
PropertyItemInt* property_item_int_construct_copy (GType object_type, PropertyItemInt* source);
PropertyItemInt* property_item_int_new (const gchar* name, const gchar* description, gint data, gint min, gint max);
PropertyItemInt* property_item_int_construct (GType object_type, const gchar* name, const gchar* description, gint data, gint min, gint max);
GType property_item_selection_get_type (void) G_GNUC_CONST;
PropertyItemSelection* property_item_selection_new_copy (PropertyItemSelection* source);
PropertyItemSelection* property_item_selection_construct_copy (GType object_type, PropertyItemSelection* source);
PropertyItemSelection* property_item_selection_new (const gchar* name, const gchar* description);
PropertyItemSelection* property_item_selection_construct (GType object_type, const gchar* name, const gchar* description);
void property_item_selection_add_option (PropertyItemSelection* self, const gchar* value, const gchar* text);
gint property_item_selection_set_option (PropertyItemSelection* self, const gchar* value);
static void gpio_pin_plugin_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
static void gpio_pin_plugin_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty);
static void gpio_pin_plugin_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
GQuark property_item_error_quark (void);
gint property_item_int_get_data_throw (PropertySet* propertySet, const gchar* name, GError** error);
gchar* property_item_selection_get_data_throw (PropertySet* propertySet, const gchar* name, GError** error);
static void gpio_pin_plugin_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
Connection* connection_new_fake (void);
Connection* connection_construct_fake (GType object_type);
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
WireInst* connection_get_wireInst (Connection* self);
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
GQuark component_state_error_quark (void);
GpioPinPluginComponentState* gpio_pin_plugin_component_state_new (Connection* accessWire, gint gpioNumber, const gchar* direction, gboolean activeLow, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
GpioPinPluginComponentState* gpio_pin_plugin_component_state_construct (GType object_type, Connection* accessWire, gint gpioNumber, const gchar* direction, gboolean activeLow, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
GType gpio_pin_plugin_component_state_get_type (void) G_GNUC_CONST;
void compiled_circuit_add_component (CompiledCircuit* self, ComponentState* componentState);
void compiled_circuit_appendError (CompiledCircuit* self, const gchar* errorString);
static void gpio_pin_plugin_component_def_finalize (ComponentDef* obj);
gboolean plugin_component_init (PluginComponentManager* manager);
void gpio_pin_plugin_component_state_unregister_pins (void);
PluginComponentDef* plugin_component_get_def (const gchar* infoFilename);


GpioPinPluginComponentDef* gpio_pin_plugin_component_def_construct (GType object_type, const gchar* infoFilename, GError** error) {
	GpioPinPluginComponentDef* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (infoFilename != NULL, NULL);
	self = (GpioPinPluginComponentDef*) plugin_component_def_construct (object_type);
	_tmp0_ = infoFilename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->infoFilename);
	self->priv->infoFilename = _tmp1_;
	{
		const gchar* _tmp2_ = NULL;
		_tmp2_ = infoFilename;
		component_def_load_from_file ((ComponentDef*) self, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch73_g_error;
		}
	}
	goto __finally73;
	__catch73_g_error:
	{
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp3_ = infoFilename;
		_tmp4_ = g_strconcat ("Failed to load \"", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "\"\n", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_LOAD, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp9_;
		goto __finally73;
	}
	__finally73:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_def_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


GpioPinPluginComponentDef* gpio_pin_plugin_component_def_new (const gchar* infoFilename, GError** error) {
	return gpio_pin_plugin_component_def_construct (TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF, infoFilename, error);
}


static void gpio_pin_plugin_component_def_real_add_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet* configurationProperty) {
	GpioPinPluginComponentDef * self;
	PropertyItem* gpioNumber = NULL;
	PropertySet* _tmp0_ = NULL;
	PropertyItem* _tmp1_ = NULL;
	PropertyItem* _tmp2_ = NULL;
	PropertyItem* direction = NULL;
	PropertySet* _tmp11_ = NULL;
	PropertyItem* _tmp12_ = NULL;
	PropertyItem* _tmp13_ = NULL;
	PropertyItem* activeState = NULL;
	PropertySet* _tmp25_ = NULL;
	PropertyItem* _tmp26_ = NULL;
	PropertyItem* _tmp27_ = NULL;
	self = (GpioPinPluginComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	g_return_if_fail (configurationProperty != NULL);
	_tmp0_ = configurationProperty;
	_tmp1_ = property_set_get_item (_tmp0_, "GPIO Pin Number");
	gpioNumber = _tmp1_;
	_tmp2_ = gpioNumber;
	if (_tmp2_ != NULL) {
		PropertySet* _tmp3_ = NULL;
		PropertyItem* _tmp4_ = NULL;
		PropertyItemInt* _tmp5_ = NULL;
		PropertyItemInt* _tmp6_ = NULL;
		_tmp3_ = queryProperty;
		_tmp4_ = gpioNumber;
		_tmp5_ = property_item_int_new_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PROPERTY_ITEM_INT, PropertyItemInt));
		_tmp6_ = _tmp5_;
		property_set_add_item (_tmp3_, (PropertyItem*) _tmp6_);
		_property_item_unref0 (_tmp6_);
	} else {
		PropertySet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		PropertyItemInt* _tmp9_ = NULL;
		PropertyItemInt* _tmp10_ = NULL;
		_tmp7_ = queryProperty;
		_tmp8_ = G_MAXINT;
		_tmp9_ = property_item_int_new ("GPIO Pin Number", "The pin number in the GPIO system.", 0, 0, _tmp8_);
		_tmp10_ = _tmp9_;
		property_set_add_item (_tmp7_, (PropertyItem*) _tmp10_);
		_property_item_unref0 (_tmp10_);
	}
	_tmp11_ = configurationProperty;
	_tmp12_ = property_set_get_item (_tmp11_, "Direction");
	direction = _tmp12_;
	_tmp13_ = direction;
	if (_tmp13_ != NULL) {
		PropertySet* _tmp14_ = NULL;
		PropertyItem* _tmp15_ = NULL;
		PropertyItemSelection* _tmp16_ = NULL;
		PropertyItemSelection* _tmp17_ = NULL;
		_tmp14_ = queryProperty;
		_tmp15_ = direction;
		_tmp16_ = property_item_selection_new_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection));
		_tmp17_ = _tmp16_;
		property_set_add_item (_tmp14_, (PropertyItem*) _tmp17_);
		_property_item_unref0 (_tmp17_);
	} else {
		PropertyItemSelection* selection = NULL;
		PropertyItemSelection* _tmp18_ = NULL;
		PropertyItemSelection* _tmp19_ = NULL;
		PropertyItemSelection* _tmp20_ = NULL;
		PropertyItemSelection* _tmp21_ = NULL;
		PropertyItemSelection* _tmp22_ = NULL;
		PropertySet* _tmp23_ = NULL;
		PropertyItemSelection* _tmp24_ = NULL;
		_tmp18_ = property_item_selection_new ("Direction", "Whether the port represents an output or input.");
		selection = _tmp18_;
		_tmp19_ = selection;
		property_item_selection_add_option (_tmp19_, "in", "Input to SmartSim");
		_tmp20_ = selection;
		property_item_selection_add_option (_tmp20_, "low", "Output from SmartSim - Initially Low");
		_tmp21_ = selection;
		property_item_selection_add_option (_tmp21_, "high", "Output from SmartSim - Initially High");
		_tmp22_ = selection;
		property_item_selection_set_option (_tmp22_, "in");
		_tmp23_ = queryProperty;
		_tmp24_ = selection;
		property_set_add_item (_tmp23_, (PropertyItem*) _tmp24_);
		_property_item_unref0 (selection);
	}
	_tmp25_ = configurationProperty;
	_tmp26_ = property_set_get_item (_tmp25_, "Active State");
	activeState = _tmp26_;
	_tmp27_ = activeState;
	if (_tmp27_ != NULL) {
		PropertySet* _tmp28_ = NULL;
		PropertyItem* _tmp29_ = NULL;
		PropertyItemSelection* _tmp30_ = NULL;
		PropertyItemSelection* _tmp31_ = NULL;
		_tmp28_ = queryProperty;
		_tmp29_ = activeState;
		_tmp30_ = property_item_selection_new_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection));
		_tmp31_ = _tmp30_;
		property_set_add_item (_tmp28_, (PropertyItem*) _tmp31_);
		_property_item_unref0 (_tmp31_);
	} else {
		PropertyItemSelection* selection = NULL;
		PropertyItemSelection* _tmp32_ = NULL;
		PropertyItemSelection* _tmp33_ = NULL;
		PropertyItemSelection* _tmp34_ = NULL;
		PropertyItemSelection* _tmp35_ = NULL;
		PropertySet* _tmp36_ = NULL;
		PropertyItemSelection* _tmp37_ = NULL;
		_tmp32_ = property_item_selection_new ("Active State", "Whether a high or low voltage represents 1 (true).");
		selection = _tmp32_;
		_tmp33_ = selection;
		property_item_selection_add_option (_tmp33_, "high", "Active High - High voltage = 1");
		_tmp34_ = selection;
		property_item_selection_add_option (_tmp34_, "low", "Active Low - Low voltage = 1");
		_tmp35_ = selection;
		property_item_selection_set_option (_tmp35_, "high");
		_tmp36_ = queryProperty;
		_tmp37_ = selection;
		property_set_add_item (_tmp36_, (PropertyItem*) _tmp37_);
		_property_item_unref0 (selection);
	}
	_property_item_unref0 (activeState);
	_property_item_unref0 (direction);
	_property_item_unref0 (gpioNumber);
}


static void gpio_pin_plugin_component_def_real_get_properties (ComponentDef* base, PropertySet* queryProperty, PropertySet** configurationProperty) {
	GpioPinPluginComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PropertySet* _tmp3_ = NULL;
	PropertySet* _tmp4_ = NULL;
	PropertyItem* _tmp5_ = NULL;
	PropertyItemInt* _tmp6_ = NULL;
	PropertyItemInt* _tmp7_ = NULL;
	PropertyItemInt* _tmp8_ = NULL;
	PropertySet* _tmp9_ = NULL;
	PropertyItem* _tmp10_ = NULL;
	PropertyItemSelection* _tmp11_ = NULL;
	PropertyItemSelection* _tmp12_ = NULL;
	PropertyItemSelection* _tmp13_ = NULL;
	PropertySet* _tmp14_ = NULL;
	PropertyItem* _tmp15_ = NULL;
	PropertyItemSelection* _tmp16_ = NULL;
	PropertyItemSelection* _tmp17_ = NULL;
	PropertyItemSelection* _tmp18_ = NULL;
	self = (GpioPinPluginComponentDef*) base;
	g_return_if_fail (queryProperty != NULL);
	_tmp0_ = ((ComponentDef*) self)->name;
	_tmp1_ = g_strconcat (_tmp0_, " configuration", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = property_set_new (_tmp2_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = queryProperty;
	_tmp5_ = property_set_get_item (_tmp4_, "GPIO Pin Number");
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PROPERTY_ITEM_INT, PropertyItemInt);
	_tmp7_ = property_item_int_new_copy (_tmp6_);
	_tmp8_ = _tmp7_;
	property_set_add_item (_vala_configurationProperty, (PropertyItem*) _tmp8_);
	_property_item_unref0 (_tmp8_);
	_property_item_unref0 (_tmp6_);
	_tmp9_ = queryProperty;
	_tmp10_ = property_set_get_item (_tmp9_, "Direction");
	_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection);
	_tmp12_ = property_item_selection_new_copy (_tmp11_);
	_tmp13_ = _tmp12_;
	property_set_add_item (_vala_configurationProperty, (PropertyItem*) _tmp13_);
	_property_item_unref0 (_tmp13_);
	_property_item_unref0 (_tmp11_);
	_tmp14_ = queryProperty;
	_tmp15_ = property_set_get_item (_tmp14_, "Active State");
	_tmp16_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PROPERTY_ITEM_SELECTION, PropertyItemSelection);
	_tmp17_ = property_item_selection_new_copy (_tmp16_);
	_tmp18_ = _tmp17_;
	property_set_add_item (_vala_configurationProperty, (PropertyItem*) _tmp18_);
	_property_item_unref0 (_tmp18_);
	_property_item_unref0 (_tmp16_);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void gpio_pin_plugin_component_def_real_load_properties (ComponentDef* base, xmlNode* xmlnode, PropertySet** configurationProperty) {
	GpioPinPluginComponentDef * self;
	PropertySet* _vala_configurationProperty = NULL;
	gint gpioNumber = 0;
	gchar* direction = NULL;
	gchar* _tmp0_ = NULL;
	gchar* activeState = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	PropertySet* _tmp5_ = NULL;
	PropertySet* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	PropertyItemInt* _tmp32_ = NULL;
	PropertyItemInt* _tmp33_ = NULL;
	self = (GpioPinPluginComponentDef*) base;
	gpioNumber = 0;
	_tmp0_ = g_strdup ("in");
	direction = _tmp0_;
	_tmp1_ = g_strdup ("high");
	activeState = _tmp1_;
	_tmp2_ = ((ComponentDef*) self)->name;
	_tmp3_ = g_strconcat (_tmp2_, " configuration", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = property_set_new (_tmp4_, "");
	_property_item_unref0 (_vala_configurationProperty);
	_vala_configurationProperty = _tmp5_;
	_g_free0 (_tmp4_);
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp6_ = NULL;
		xmlAttr* _tmp7_ = NULL;
		_tmp6_ = xmlnode;
		_tmp7_ = _tmp6_->properties;
		xmlattr = _tmp7_;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp11_ = NULL;
				xmlAttr* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GQuark _tmp16_ = 0U;
				static GQuark _tmp15_label0 = 0;
				static GQuark _tmp15_label1 = 0;
				static GQuark _tmp15_label2 = 0;
				if (!_tmp8_) {
					xmlAttr* _tmp9_ = NULL;
					xmlAttr* _tmp10_ = NULL;
					_tmp9_ = xmlattr;
					_tmp10_ = _tmp9_->next;
					xmlattr = _tmp10_;
				}
				_tmp8_ = FALSE;
				_tmp11_ = xmlattr;
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = xmlattr;
				_tmp13_ = _tmp12_->name;
				_tmp14_ = _tmp13_;
				_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
				if (_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("number")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp17_ = NULL;
							xmlNode* _tmp18_ = NULL;
							const gchar* _tmp19_ = NULL;
							gint _tmp20_ = 0;
							_tmp17_ = xmlattr;
							_tmp18_ = _tmp17_->children;
							_tmp19_ = _tmp18_->content;
							_tmp20_ = atoi (_tmp19_);
							gpioNumber = _tmp20_;
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("iodirection")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp21_ = NULL;
							xmlNode* _tmp22_ = NULL;
							const gchar* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							_tmp21_ = xmlattr;
							_tmp22_ = _tmp21_->children;
							_tmp23_ = _tmp22_->content;
							_tmp24_ = g_strdup (_tmp23_);
							_g_free0 (direction);
							direction = _tmp24_;
							break;
						}
					}
				} else if (_tmp16_ == ((0 != _tmp15_label2) ? _tmp15_label2 : (_tmp15_label2 = g_quark_from_static_string ("active")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp25_ = NULL;
							xmlNode* _tmp26_ = NULL;
							const gchar* _tmp27_ = NULL;
							gchar* _tmp28_ = NULL;
							_tmp25_ = xmlattr;
							_tmp26_ = _tmp25_->children;
							_tmp27_ = _tmp26_->content;
							_tmp28_ = g_strdup (_tmp27_);
							_g_free0 (activeState);
							activeState = _tmp28_;
							break;
						}
					}
				}
			}
		}
	}
	_tmp29_ = _vala_configurationProperty;
	_tmp30_ = gpioNumber;
	_tmp31_ = G_MAXINT;
	_tmp32_ = property_item_int_new ("GPIO Pin Number", "The pin number in the GPIO system.", _tmp30_, 0, _tmp31_);
	_tmp33_ = _tmp32_;
	property_set_add_item (_tmp29_, (PropertyItem*) _tmp33_);
	_property_item_unref0 (_tmp33_);
	{
		PropertyItemSelection* selection = NULL;
		PropertyItemSelection* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		PropertySet* _tmp36_ = NULL;
		_tmp34_ = property_item_selection_new ("Direction", "Whether the port represents an output or input.");
		selection = _tmp34_;
		property_item_selection_add_option (selection, "in", "Input to SmartSim");
		property_item_selection_add_option (selection, "low", "Output from SmartSim - Initially Low");
		property_item_selection_add_option (selection, "high", "Output from SmartSim - Initially High");
		_tmp35_ = direction;
		property_item_selection_set_option (selection, _tmp35_);
		_tmp36_ = _vala_configurationProperty;
		property_set_add_item (_tmp36_, (PropertyItem*) selection);
		_property_item_unref0 (selection);
	}
	{
		PropertyItemSelection* selection = NULL;
		PropertyItemSelection* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		PropertySet* _tmp39_ = NULL;
		_tmp37_ = property_item_selection_new ("Active State", "Whether a high or low voltage represents 1 (true).");
		selection = _tmp37_;
		property_item_selection_add_option (selection, "high", "Active High - High voltage = 1");
		property_item_selection_add_option (selection, "low", "Active Low - Low voltage = 1");
		_tmp38_ = activeState;
		property_item_selection_set_option (selection, _tmp38_);
		_tmp39_ = _vala_configurationProperty;
		property_set_add_item (_tmp39_, (PropertyItem*) selection);
		_property_item_unref0 (selection);
	}
	_g_free0 (activeState);
	_g_free0 (direction);
	if (configurationProperty) {
		*configurationProperty = _vala_configurationProperty;
	} else {
		_property_item_unref0 (_vala_configurationProperty);
	}
}


static void gpio_pin_plugin_component_def_real_save_properties (ComponentDef* base, xmlTextWriter* xmlWriter, PropertySet* configurationProperty) {
	GpioPinPluginComponentDef * self;
	gint gpioNumber = 0;
	gchar* direction = NULL;
	gchar* activeState = NULL;
	xmlTextWriter* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	xmlTextWriter* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	xmlTextWriter* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GpioPinPluginComponentDef*) base;
	g_return_if_fail (xmlWriter != NULL);
	g_return_if_fail (configurationProperty != NULL);
	{
		gint _tmp0_ = 0;
		PropertySet* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = configurationProperty;
		_tmp2_ = property_item_int_get_data_throw (_tmp1_, "GPIO Pin Number", &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch74_g_error;
		}
		gpioNumber = _tmp0_;
	}
	goto __finally74;
	__catch74_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		gpioNumber = 0;
	}
	__finally74:
	if (_inner_error_ != NULL) {
		_g_free0 (activeState);
		_g_free0 (direction);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp3_ = NULL;
		PropertySet* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = configurationProperty;
		_tmp5_ = property_item_selection_get_data_throw (_tmp4_, "Direction", &_inner_error_);
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch75_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (direction);
		direction = _tmp6_;
		_g_free0 (_tmp3_);
	}
	goto __finally75;
	__catch75_g_error:
	{
		gchar* _tmp7_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp7_ = g_strdup ("in");
		_g_free0 (direction);
		direction = _tmp7_;
	}
	__finally75:
	if (_inner_error_ != NULL) {
		_g_free0 (activeState);
		_g_free0 (direction);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp8_ = NULL;
		PropertySet* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = configurationProperty;
		_tmp10_ = property_item_selection_get_data_throw (_tmp9_, "Active State", &_inner_error_);
		_tmp8_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch76_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (activeState);
		activeState = _tmp11_;
		_g_free0 (_tmp8_);
	}
	goto __finally76;
	__catch76_g_error:
	{
		gchar* _tmp12_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp12_ = g_strdup ("high");
		_g_free0 (activeState);
		activeState = _tmp12_;
	}
	__finally76:
	if (_inner_error_ != NULL) {
		_g_free0 (activeState);
		_g_free0 (direction);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = xmlWriter;
	_tmp14_ = gpioNumber;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	_tmp16_ = _tmp15_;
	xmlTextWriterWriteAttribute (_tmp13_, (xmlChar*) "number", (xmlChar*) _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = xmlWriter;
	_tmp18_ = direction;
	xmlTextWriterWriteAttribute (_tmp17_, (xmlChar*) "iodirection", (xmlChar*) _tmp18_);
	_tmp19_ = xmlWriter;
	_tmp20_ = activeState;
	xmlTextWriterWriteAttribute (_tmp19_, (xmlChar*) "active", (xmlChar*) _tmp20_);
	_g_free0 (activeState);
	_g_free0 (direction);
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static void gpio_pin_plugin_component_def_real_compile_component (ComponentDef* base, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1) {
	GpioPinPluginComponentDef * self;
	Connection* accessWire = NULL;
	Connection* _tmp0_ = NULL;
	Connection** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint gpioNumber = 0;
	gchar* direction = NULL;
	gboolean activeLow = FALSE;
	GError * _inner_error_ = NULL;
	self = (GpioPinPluginComponentDef*) base;
	g_return_if_fail (compiledCircuit != NULL);
	_tmp0_ = connection_new_fake ();
	accessWire = _tmp0_;
	_tmp1_ = connections;
	_tmp1__length1 = connections_length1;
	{
		Connection** connection_collection = NULL;
		gint connection_collection_length1 = 0;
		gint _connection_collection_size_ = 0;
		gint connection_it = 0;
		connection_collection = _tmp1_;
		connection_collection_length1 = _tmp1__length1;
		for (connection_it = 0; connection_it < _tmp1__length1; connection_it = connection_it + 1) {
			Connection* _tmp2_ = NULL;
			Connection* connection = NULL;
			_tmp2_ = _connection_ref0 (connection_collection[connection_it]);
			connection = _tmp2_;
			{
				Connection* _tmp3_ = NULL;
				WireInst* _tmp4_ = NULL;
				WireInst* _tmp5_ = NULL;
				ComponentInst* _tmp6_ = NULL;
				PinInst** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				PinInst* _tmp8_ = NULL;
				WireInst** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				WireInst* _tmp10_ = NULL;
				_tmp3_ = connection;
				_tmp4_ = connection_get_wireInst (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = componentInst;
				_tmp7_ = _tmp6_->pinInsts;
				_tmp7__length1 = _tmp6_->pinInsts_length1;
				_tmp8_ = _tmp7_[0];
				_tmp9_ = _tmp8_->wireInsts;
				_tmp9__length1 = _tmp8_->wireInsts_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp5_ == _tmp10_) {
					Connection* _tmp11_ = NULL;
					Connection* _tmp12_ = NULL;
					_tmp11_ = connection;
					_tmp12_ = _connection_ref0 (_tmp11_);
					_connection_unref0 (accessWire);
					accessWire = _tmp12_;
				}
				_connection_unref0 (connection);
			}
		}
	}
	{
		gint _tmp13_ = 0;
		ComponentInst* _tmp14_ = NULL;
		PropertySet* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp14_ = componentInst;
		_tmp15_ = _tmp14_->configuration;
		_tmp16_ = property_item_int_get_data_throw (_tmp15_, "GPIO Pin Number", &_inner_error_);
		_tmp13_ = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch77_g_error;
		}
		gpioNumber = _tmp13_;
	}
	goto __finally77;
	__catch77_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		gpioNumber = 0;
	}
	__finally77:
	if (_inner_error_ != NULL) {
		_g_free0 (direction);
		_connection_unref0 (accessWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp17_ = NULL;
		ComponentInst* _tmp18_ = NULL;
		PropertySet* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp18_ = componentInst;
		_tmp19_ = _tmp18_->configuration;
		_tmp20_ = property_item_selection_get_data_throw (_tmp19_, "Direction", &_inner_error_);
		_tmp17_ = _tmp20_;
		if (_inner_error_ != NULL) {
			goto __catch78_g_error;
		}
		_tmp21_ = _tmp17_;
		_tmp17_ = NULL;
		_g_free0 (direction);
		direction = _tmp21_;
		_g_free0 (_tmp17_);
	}
	goto __finally78;
	__catch78_g_error:
	{
		gchar* _tmp22_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp22_ = g_strdup ("in");
		_g_free0 (direction);
		direction = _tmp22_;
	}
	__finally78:
	if (_inner_error_ != NULL) {
		_g_free0 (direction);
		_connection_unref0 (accessWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gboolean _tmp23_ = FALSE;
		gchar* _tmp24_ = NULL;
		ComponentInst* _tmp25_ = NULL;
		PropertySet* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		_tmp25_ = componentInst;
		_tmp26_ = _tmp25_->configuration;
		_tmp27_ = property_item_selection_get_data_throw (_tmp26_, "Active State", &_inner_error_);
		_tmp24_ = _tmp27_;
		if (_inner_error_ != NULL) {
			goto __catch79_g_error;
		}
		_tmp28_ = _tmp24_;
		_tmp24_ = NULL;
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strcmp0 (_tmp29_, "low") == 0;
		_g_free0 (_tmp29_);
		if (_tmp30_) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = FALSE;
		}
		activeLow = _tmp23_;
		_g_free0 (_tmp24_);
	}
	goto __finally79;
	__catch79_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		activeLow = FALSE;
	}
	__finally79:
	if (_inner_error_ != NULL) {
		_g_free0 (direction);
		_connection_unref0 (accessWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		ComponentState* componentState = NULL;
		Connection* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		ComponentInst** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		ComponentInst* _tmp36_ = NULL;
		GpioPinPluginComponentState* _tmp37_ = NULL;
		CompiledCircuit* _tmp38_ = NULL;
		_tmp31_ = accessWire;
		_tmp32_ = gpioNumber;
		_tmp33_ = direction;
		_tmp34_ = activeLow;
		_tmp35_ = ancestry;
		_tmp35__length1 = ancestry_length1;
		_tmp36_ = componentInst;
		_tmp37_ = gpio_pin_plugin_component_state_new (_tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp35__length1, _tmp36_, &_inner_error_);
		componentState = (ComponentState*) _tmp37_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
				goto __catch80_component_state_error;
			}
			_g_free0 (direction);
			_connection_unref0 (accessWire);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp38_ = compiledCircuit;
		compiled_circuit_add_component (_tmp38_, componentState);
		_component_state_unref0 (componentState);
	}
	goto __finally80;
	__catch80_component_state_error:
	{
		GError* _error_ = NULL;
		CompiledCircuit* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		ComponentInst* _tmp42_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp39_ = compiledCircuit;
		_tmp40_ = _error_;
		_tmp41_ = _tmp40_->message;
		compiled_circuit_appendError (_tmp39_, _tmp41_);
		_tmp42_ = componentInst;
		_tmp42_->errorMark = TRUE;
		_g_error_free0 (_error_);
	}
	__finally80:
	if (_inner_error_ != NULL) {
		_g_free0 (direction);
		_connection_unref0 (accessWire);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (direction);
	_connection_unref0 (accessWire);
}


static void gpio_pin_plugin_component_def_class_init (GpioPinPluginComponentDefClass * klass) {
	gpio_pin_plugin_component_def_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_DEF_CLASS (klass)->finalize = gpio_pin_plugin_component_def_finalize;
	g_type_class_add_private (klass, sizeof (GpioPinPluginComponentDefPrivate));
	COMPONENT_DEF_CLASS (klass)->add_properties = gpio_pin_plugin_component_def_real_add_properties;
	COMPONENT_DEF_CLASS (klass)->get_properties = gpio_pin_plugin_component_def_real_get_properties;
	COMPONENT_DEF_CLASS (klass)->load_properties = gpio_pin_plugin_component_def_real_load_properties;
	COMPONENT_DEF_CLASS (klass)->save_properties = gpio_pin_plugin_component_def_real_save_properties;
	COMPONENT_DEF_CLASS (klass)->compile_component = gpio_pin_plugin_component_def_real_compile_component;
}


static void gpio_pin_plugin_component_def_instance_init (GpioPinPluginComponentDef * self) {
	self->priv = GPIO_PIN_PLUGIN_COMPONENT_DEF_GET_PRIVATE (self);
}


static void gpio_pin_plugin_component_def_finalize (ComponentDef* obj) {
	GpioPinPluginComponentDef * self;
	PluginComponentManager* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GPIO_PIN_PLUGIN_COMPONENT_DEF, GpioPinPluginComponentDef);
	_tmp0_ = pluginManager;
	plugin_component_manager_print_info (_tmp0_, "Unloaded GPIO Pin Component Definition.\n");
	_g_free0 (self->priv->infoFilename);
	COMPONENT_DEF_CLASS (gpio_pin_plugin_component_def_parent_class)->finalize (obj);
}


GType gpio_pin_plugin_component_def_get_type (void) {
	static volatile gsize gpio_pin_plugin_component_def_type_id__volatile = 0;
	if (g_once_init_enter (&gpio_pin_plugin_component_def_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpioPinPluginComponentDefClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpio_pin_plugin_component_def_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpioPinPluginComponentDef), 0, (GInstanceInitFunc) gpio_pin_plugin_component_def_instance_init, NULL };
		GType gpio_pin_plugin_component_def_type_id;
		gpio_pin_plugin_component_def_type_id = g_type_register_static (TYPE_PLUGIN_COMPONENT_DEF, "GpioPinPluginComponentDef", &g_define_type_info, 0);
		g_once_init_leave (&gpio_pin_plugin_component_def_type_id__volatile, gpio_pin_plugin_component_def_type_id);
	}
	return gpio_pin_plugin_component_def_type_id__volatile;
}


gboolean plugin_component_init (PluginComponentManager* manager) {
	gboolean result = FALSE;
	PluginComponentManager* _tmp0_ = NULL;
	PluginComponentManager* _tmp1_ = NULL;
	g_return_val_if_fail (manager != NULL, FALSE);
	_tmp0_ = manager;
	pluginManager = _tmp0_;
	_tmp1_ = pluginManager;
	plugin_component_manager_print_info (_tmp1_, "GPIO Pin plugin component initialised.\n");
	gpio_pin_plugin_component_state_unregister_pins ();
	result = TRUE;
	return result;
}


PluginComponentDef* plugin_component_get_def (const gchar* infoFilename) {
	PluginComponentDef* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (infoFilename != NULL, NULL);
	{
		PluginComponentDef* componentDef = NULL;
		const gchar* _tmp0_ = NULL;
		GpioPinPluginComponentDef* _tmp1_ = NULL;
		_tmp0_ = infoFilename;
		_tmp1_ = gpio_pin_plugin_component_def_new (_tmp0_, &_inner_error_);
		componentDef = (PluginComponentDef*) _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch81_g_error;
		}
		result = componentDef;
		return result;
	}
	goto __finally81;
	__catch81_g_error:
	{
		PluginComponentManager* _tmp2_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp2_ = pluginManager;
		plugin_component_manager_print_info (_tmp2_, "Error during GPIO Pin plugin component def construction!\n");
		result = NULL;
		return result;
	}
	__finally81:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}



