/* plugin-state-gpiopin.c generated by valac 0.24.0, the Vala compiler
 * generated from plugin-state-gpiopin.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: plugincomponents/plugin-state-gpiopin.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>


#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;
typedef struct _ComponentStatePrivate ComponentStatePrivate;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE (gpio_pin_plugin_component_state_get_type ())
#define GPIO_PIN_PLUGIN_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentState))
#define GPIO_PIN_PLUGIN_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentStateClass))
#define IS_GPIO_PIN_PLUGIN_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE))
#define IS_GPIO_PIN_PLUGIN_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE))
#define GPIO_PIN_PLUGIN_COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentStateClass))

typedef struct _GpioPinPluginComponentState GpioPinPluginComponentState;
typedef struct _GpioPinPluginComponentStateClass GpioPinPluginComponentStateClass;
typedef struct _GpioPinPluginComponentStatePrivate GpioPinPluginComponentStatePrivate;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;

#define GPIO_PIN_PLUGIN_COMPONENT_STATE_TYPE_REGISTERED_PIN (gpio_pin_plugin_component_state_registered_pin_get_type ())
typedef struct _GpioPinPluginComponentStateRegisteredPin GpioPinPluginComponentStateRegisteredPin;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _ComponentInstPrivate ComponentInstPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_PIN_INST (pin_inst_get_type ())
#define PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_INST, PinInst))
#define PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_INST, PinInstClass))
#define IS_PIN_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_INST))
#define IS_PIN_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_INST))
#define PIN_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_INST, PinInstClass))

typedef struct _PinInst PinInst;
typedef struct _PinInstClass PinInstClass;
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))

struct _ComponentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentStatePrivate * priv;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	ComponentInst* componentInst;
	gint renderQueueID;
	gint processQueueID;
	gboolean display;
};

struct _ComponentStateClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentState *self);
	void (*update) (ComponentState* self);
	void (*click) (ComponentState* self);
	void (*render) (ComponentState* self, cairo_t* context);
	gboolean (*get_alwaysUpdate) (ComponentState* self);
};

struct _GpioPinPluginComponentState {
	ComponentState parent_instance;
	GpioPinPluginComponentStatePrivate * priv;
};

struct _GpioPinPluginComponentStateClass {
	ComponentStateClass parent_class;
};

struct _GpioPinPluginComponentStatePrivate {
	Connection* accessWire;
	gint gpioNumber;
	gboolean isInput;
	gboolean activeLow;
	gboolean value;
	gchar* gpioDirectory;
	gboolean exported;
	FILE* valueFile;
};

struct _GpioPinPluginComponentStateRegisteredPin {
	gint number;
	GpioPinPluginComponentState* state;
};

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentInstPrivate * priv;
	ComponentDef* componentDef;
	gint myID;
	gint xPosition;
	gint yPosition;
	Direction direction;
	gboolean flipped;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	PropertySet* configuration;
	gboolean selected;
	gboolean errorMark;
	PinInst** pinInsts;
	gint pinInsts_length1;
};

struct _ComponentInstClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentInst *self);
};

typedef enum  {
	COMPONENT_STATE_ERROR_COMPILE
} ComponentStateError;
#define COMPONENT_STATE_ERROR component_state_error_quark ()

static gpointer gpio_pin_plugin_component_state_parent_class = NULL;
extern PluginComponentManager* pluginManager;
static GpioPinPluginComponentStateRegisteredPin* gpio_pin_plugin_component_state_usedPins;
static gint gpio_pin_plugin_component_state_usedPins_length1;
static GpioPinPluginComponentStateRegisteredPin* gpio_pin_plugin_component_state_usedPins = NULL;
static gint gpio_pin_plugin_component_state_usedPins_length1 = 0;
static gint _gpio_pin_plugin_component_state_usedPins_size_ = 0;

gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
GType gpio_pin_plugin_component_state_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
#define GPIO_PIN_PLUGIN_COMPONENT_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentStatePrivate))
enum  {
	GPIO_PIN_PLUGIN_COMPONENT_STATE_DUMMY_PROPERTY
};
static void gpio_pin_plugin_component_state_unexport (GpioPinPluginComponentState* self);
void gpio_pin_plugin_component_state_unregister_pins (void);
gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
void plugin_component_manager_print_info (PluginComponentManager* self, const gchar* text);
static GType gpio_pin_plugin_component_state_registered_pin_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GpioPinPluginComponentStateRegisteredPin* gpio_pin_plugin_component_state_registered_pin_dup (const GpioPinPluginComponentStateRegisteredPin* self);
static void gpio_pin_plugin_component_state_registered_pin_free (GpioPinPluginComponentStateRegisteredPin* self);
static gboolean gpio_pin_plugin_component_state_register_pin (gint number, GpioPinPluginComponentState* state);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer pin_inst_ref (gpointer instance);
void pin_inst_unref (gpointer instance);
GParamSpec* param_spec_pin_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_inst (GValue* value, gpointer v_object);
void value_take_pin_inst (GValue* value, gpointer v_object);
gpointer value_get_pin_inst (const GValue* value);
GType pin_inst_get_type (void) G_GNUC_CONST;
static void _vala_array_add125 (GpioPinPluginComponentStateRegisteredPin** array, int* length, int* size, const GpioPinPluginComponentStateRegisteredPin* value);
GQuark component_state_error_quark (void);
GpioPinPluginComponentState* gpio_pin_plugin_component_state_new (Connection* accessWire, gint gpioNumber, const gchar* direction, gboolean activeLow, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
GpioPinPluginComponentState* gpio_pin_plugin_component_state_construct (GType object_type, Connection* accessWire, gint gpioNumber, const gchar* direction, gboolean activeLow, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error);
ComponentState* component_state_construct (GType object_type);
static ComponentInst** _vala_array_dup105 (ComponentInst** self, int length);
void connection_set_affects (Connection* self, ComponentState* componentState);
void plugin_component_manager_print_error (PluginComponentManager* self, const gchar* text);
static gboolean gpio_pin_plugin_component_state_read_gpio (GpioPinPluginComponentState* self);
static void gpio_pin_plugin_component_state_write_gpio (GpioPinPluginComponentState* self, gboolean value);
static void gpio_pin_plugin_component_state_real_update (ComponentState* base);
void connection_set_signalState (Connection* self, gboolean value);
gboolean connection_get_signalState (Connection* self);
static void gpio_pin_plugin_component_state_finalize (ComponentState* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_array_add125 (GpioPinPluginComponentStateRegisteredPin** array, int* length, int* size, const GpioPinPluginComponentStateRegisteredPin* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GpioPinPluginComponentStateRegisteredPin, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gboolean gpio_pin_plugin_component_state_register_pin (gint number, GpioPinPluginComponentState* state) {
	gboolean result = FALSE;
	GpioPinPluginComponentStateRegisteredPin* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GpioPinPluginComponentStateRegisteredPin newPin = {0};
	GpioPinPluginComponentState* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GpioPinPluginComponentStateRegisteredPin* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GpioPinPluginComponentStateRegisteredPin _tmp12_ = {0};
	PluginComponentManager* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GpioPinPluginComponentStateRegisteredPin* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (state != NULL, FALSE);
	_tmp0_ = gpio_pin_plugin_component_state_usedPins;
	_tmp0__length1 = gpio_pin_plugin_component_state_usedPins_length1;
	{
		GpioPinPluginComponentStateRegisteredPin* pin_collection = NULL;
		gint pin_collection_length1 = 0;
		gint _pin_collection_size_ = 0;
		gint pin_it = 0;
		pin_collection = _tmp0_;
		pin_collection_length1 = _tmp0__length1;
		for (pin_it = 0; pin_it < _tmp0__length1; pin_it = pin_it + 1) {
			GpioPinPluginComponentStateRegisteredPin pin = {0};
			pin = pin_collection[pin_it];
			{
				GpioPinPluginComponentStateRegisteredPin _tmp1_ = {0};
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				_tmp1_ = pin;
				_tmp2_ = _tmp1_.number;
				_tmp3_ = number;
				if (_tmp2_ == _tmp3_) {
					GpioPinPluginComponentStateRegisteredPin _tmp4_ = {0};
					GpioPinPluginComponentState* _tmp5_ = NULL;
					ComponentInst* _tmp6_ = NULL;
					GpioPinPluginComponentState* _tmp7_ = NULL;
					ComponentInst* _tmp8_ = NULL;
					_tmp4_ = pin;
					_tmp5_ = _tmp4_.state;
					_tmp6_ = ((ComponentState*) _tmp5_)->componentInst;
					_tmp6_->errorMark = TRUE;
					_tmp7_ = state;
					_tmp8_ = ((ComponentState*) _tmp7_)->componentInst;
					_tmp8_->errorMark = TRUE;
					result = FALSE;
					return result;
				}
			}
		}
	}
	memset (&newPin, 0, sizeof (GpioPinPluginComponentStateRegisteredPin));
	_tmp9_ = state;
	newPin.state = _tmp9_;
	_tmp10_ = number;
	newPin.number = _tmp10_;
	_tmp11_ = gpio_pin_plugin_component_state_usedPins;
	_tmp11__length1 = gpio_pin_plugin_component_state_usedPins_length1;
	_tmp12_ = newPin;
	_vala_array_add125 (&gpio_pin_plugin_component_state_usedPins, &gpio_pin_plugin_component_state_usedPins_length1, &_gpio_pin_plugin_component_state_usedPins_size_, &_tmp12_);
	_tmp13_ = pluginManager;
	_tmp14_ = number;
	_tmp15_ = gpio_pin_plugin_component_state_usedPins;
	_tmp15__length1 = gpio_pin_plugin_component_state_usedPins_length1;
	_tmp16_ = g_strdup_printf ("Registered GPIO Pin %i. Currently, %i are in use.\n", _tmp14_, _tmp15__length1);
	_tmp17_ = _tmp16_;
	plugin_component_manager_print_info (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	result = TRUE;
	return result;
}


void gpio_pin_plugin_component_state_unregister_pins (void) {
	GpioPinPluginComponentStateRegisteredPin* _tmp0_ = NULL;
	_tmp0_ = g_new0 (GpioPinPluginComponentStateRegisteredPin, 0);
	gpio_pin_plugin_component_state_usedPins = (g_free (gpio_pin_plugin_component_state_usedPins), NULL);
	gpio_pin_plugin_component_state_usedPins = _tmp0_;
	gpio_pin_plugin_component_state_usedPins_length1 = 0;
	_gpio_pin_plugin_component_state_usedPins_size_ = gpio_pin_plugin_component_state_usedPins_length1;
}


static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


static ComponentInst** _vala_array_dup105 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


GpioPinPluginComponentState* gpio_pin_plugin_component_state_construct (GType object_type, Connection* accessWire, gint gpioNumber, const gchar* direction, gboolean activeLow, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error) {
	GpioPinPluginComponentState* self = NULL;
	ComponentInst** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ComponentInst** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ComponentInst* _tmp2_ = NULL;
	ComponentInst* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	Connection* _tmp7_ = NULL;
	Connection* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp14_ = FALSE;
	PluginComponentManager* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	FILE* exportFile = NULL;
	FILE* _tmp28_ = NULL;
	FILE* _tmp29_ = NULL;
	FILE* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	FILE* activeLowFile = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	FILE* _tmp42_ = NULL;
	FILE* _tmp43_ = NULL;
	FILE* _tmp44_ = NULL;
	const gchar* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	FILE* _tmp54_ = NULL;
	FILE* directionFile = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	FILE* _tmp58_ = NULL;
	FILE* _tmp59_ = NULL;
	FILE* _tmp60_ = NULL;
	FILE* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	const gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	FILE* _tmp75_ = NULL;
	FILE* _tmp76_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (accessWire != NULL, NULL);
	g_return_val_if_fail (direction != NULL, NULL);
	g_return_val_if_fail (componentInst != NULL, NULL);
	self = (GpioPinPluginComponentState*) component_state_construct (object_type);
	_tmp0_ = ancestry;
	_tmp0__length1 = ancestry_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup105 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	((ComponentState*) self)->ancestry = (_vala_array_free (((ComponentState*) self)->ancestry, ((ComponentState*) self)->ancestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	((ComponentState*) self)->ancestry = _tmp1_;
	((ComponentState*) self)->ancestry_length1 = _tmp1__length1;
	_tmp2_ = componentInst;
	_tmp3_ = _component_inst_ref0 (_tmp2_);
	_component_inst_unref0 (((ComponentState*) self)->componentInst);
	((ComponentState*) self)->componentInst = _tmp3_;
	_tmp4_ = gpioNumber;
	_tmp5_ = gpio_pin_plugin_component_state_register_pin (_tmp4_, self);
	if (_tmp5_ == FALSE) {
		GError* _tmp6_ = NULL;
		_tmp6_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, "The circuit has conflicting GPIO Pin Components with the same pin numb" \
"er.");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_component_state_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = accessWire;
	_tmp8_ = _connection_ref0 (_tmp7_);
	_connection_unref0 (self->priv->accessWire);
	self->priv->accessWire = _tmp8_;
	_tmp9_ = gpioNumber;
	self->priv->gpioNumber = _tmp9_;
	_tmp10_ = direction;
	if (g_strcmp0 (_tmp10_, "in") == 0) {
		self->priv->isInput = TRUE;
		self->priv->value = FALSE;
	} else {
		const gchar* _tmp11_ = NULL;
		Connection* _tmp13_ = NULL;
		self->priv->isInput = FALSE;
		_tmp11_ = direction;
		if (g_strcmp0 (_tmp11_, "high") == 0) {
			self->priv->value = TRUE;
		} else {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = direction;
			if (g_strcmp0 (_tmp12_, "low") == 0) {
				self->priv->value = FALSE;
			}
		}
		_tmp13_ = accessWire;
		connection_set_affects (_tmp13_, (ComponentState*) self);
	}
	_tmp14_ = activeLow;
	self->priv->activeLow = _tmp14_;
	_tmp15_ = pluginManager;
	_tmp16_ = gpioNumber;
	_tmp17_ = activeLow;
	_tmp18_ = bool_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->isInput;
	_tmp21_ = bool_to_string (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->value;
	_tmp24_ = bool_to_string (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup_printf ("Configuring GPIO Pin %i: active_low = %s, input = %s, value = %s.\n", _tmp16_, _tmp19_, _tmp22_, _tmp25_);
	_tmp27_ = _tmp26_;
	plugin_component_manager_print_info (_tmp15_, _tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_tmp28_ = g_fopen ("/sys/class/gpio/export", "w");
	exportFile = _tmp28_;
	_tmp29_ = exportFile;
	if (_tmp29_ == NULL) {
		GError* _tmp30_ = NULL;
		_tmp30_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, "Unable to access \"/sys/class/gpio/export\". Ensure SmartSim has permi" \
"ssion to access GPIO.");
		_inner_error_ = _tmp30_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fclose0 (exportFile);
			_component_state_unref0 (self);
			return NULL;
		} else {
			_fclose0 (exportFile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp31_ = exportFile;
	_tmp32_ = gpioNumber;
	fprintf (_tmp31_, "%i", _tmp32_);
	_fclose0 (exportFile);
	exportFile = NULL;
	self->priv->exported = TRUE;
	_tmp33_ = gpioNumber;
	_tmp34_ = g_strdup_printf ("%i", _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat ("/sys/class/gpio/gpio", _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, "/", NULL);
	_g_free0 (self->priv->gpioDirectory);
	self->priv->gpioDirectory = _tmp38_;
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp39_ = self->priv->gpioDirectory;
	_tmp40_ = g_strconcat (_tmp39_, "active_low", NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_fopen (_tmp41_, "w");
	_tmp43_ = _tmp42_;
	_g_free0 (_tmp41_);
	activeLowFile = _tmp43_;
	_tmp44_ = activeLowFile;
	if (_tmp44_ == NULL) {
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		GError* _tmp50_ = NULL;
		GError* _tmp51_ = NULL;
		gpio_pin_plugin_component_state_unexport (self);
		_tmp45_ = self->priv->gpioDirectory;
		_tmp46_ = g_strconcat ("Unable to access \"", _tmp45_, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strconcat (_tmp47_, "active_low\". Ensure SmartSim has permission to access GPIO.", NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, _tmp49_);
		_tmp51_ = _tmp50_;
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_inner_error_ = _tmp51_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fclose0 (activeLowFile);
			_fclose0 (exportFile);
			_component_state_unref0 (self);
			return NULL;
		} else {
			_fclose0 (activeLowFile);
			_fclose0 (exportFile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp53_ = activeLow;
	if (_tmp53_) {
		_tmp52_ = "1";
	} else {
		_tmp52_ = "0";
	}
	_tmp54_ = activeLowFile;
	fprintf (_tmp54_, "%s", _tmp52_);
	_fclose0 (activeLowFile);
	activeLowFile = NULL;
	_tmp55_ = self->priv->gpioDirectory;
	_tmp56_ = g_strconcat (_tmp55_, "direction", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_fopen (_tmp57_, "w");
	_tmp59_ = _tmp58_;
	_g_free0 (_tmp57_);
	directionFile = _tmp59_;
	_tmp60_ = directionFile;
	if (_tmp60_ == NULL) {
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		GError* _tmp66_ = NULL;
		GError* _tmp67_ = NULL;
		gpio_pin_plugin_component_state_unexport (self);
		_tmp61_ = self->priv->gpioDirectory;
		_tmp62_ = g_strconcat ("Unable to access \"", _tmp61_, NULL);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (_tmp63_, "direction\". Ensure SmartSim has permission to access GPIO.", NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, _tmp65_);
		_tmp67_ = _tmp66_;
		_g_free0 (_tmp65_);
		_g_free0 (_tmp63_);
		_inner_error_ = _tmp67_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fclose0 (directionFile);
			_fclose0 (activeLowFile);
			_fclose0 (exportFile);
			_component_state_unref0 (self);
			return NULL;
		} else {
			_fclose0 (directionFile);
			_fclose0 (activeLowFile);
			_fclose0 (exportFile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp68_ = directionFile;
	_tmp69_ = direction;
	fprintf (_tmp68_, "%s", _tmp69_);
	_fclose0 (directionFile);
	directionFile = NULL;
	_tmp71_ = self->priv->isInput;
	if (_tmp71_) {
		_tmp70_ = "r";
	} else {
		_tmp70_ = "w";
	}
	_tmp72_ = self->priv->gpioDirectory;
	_tmp73_ = g_strconcat (_tmp72_, "value", NULL);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_fopen (_tmp74_, _tmp70_);
	_fclose0 (self->priv->valueFile);
	self->priv->valueFile = _tmp75_;
	_g_free0 (_tmp74_);
	_tmp76_ = self->priv->valueFile;
	if (_tmp76_ == NULL) {
		const gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		GError* _tmp82_ = NULL;
		GError* _tmp83_ = NULL;
		gpio_pin_plugin_component_state_unexport (self);
		_tmp77_ = self->priv->gpioDirectory;
		_tmp78_ = g_strconcat ("Unable to access \"", _tmp77_, NULL);
		_tmp79_ = _tmp78_;
		_tmp80_ = g_strconcat (_tmp79_, "value\". Ensure SmartSim has permission to access GPIO.", NULL);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_error_new_literal (COMPONENT_STATE_ERROR, COMPONENT_STATE_ERROR_COMPILE, _tmp81_);
		_tmp83_ = _tmp82_;
		_g_free0 (_tmp81_);
		_g_free0 (_tmp79_);
		_inner_error_ = _tmp83_;
		if (_inner_error_->domain == COMPONENT_STATE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_fclose0 (directionFile);
			_fclose0 (activeLowFile);
			_fclose0 (exportFile);
			_component_state_unref0 (self);
			return NULL;
		} else {
			_fclose0 (directionFile);
			_fclose0 (activeLowFile);
			_fclose0 (exportFile);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_fclose0 (directionFile);
	_fclose0 (activeLowFile);
	_fclose0 (exportFile);
	return self;
}


GpioPinPluginComponentState* gpio_pin_plugin_component_state_new (Connection* accessWire, gint gpioNumber, const gchar* direction, gboolean activeLow, ComponentInst** ancestry, int ancestry_length1, ComponentInst* componentInst, GError** error) {
	return gpio_pin_plugin_component_state_construct (TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, accessWire, gpioNumber, direction, activeLow, ancestry, ancestry_length1, componentInst, error);
}


static void gpio_pin_plugin_component_state_unexport (GpioPinPluginComponentState* self) {
	gboolean _tmp0_ = FALSE;
	FILE* unexportFile = NULL;
	FILE* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	FILE* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->exported;
	if (_tmp0_ == FALSE) {
		return;
	}
	_tmp1_ = g_fopen ("/sys/class/gpio/unexport", "w");
	unexportFile = _tmp1_;
	_tmp2_ = unexportFile;
	if (_tmp2_ == NULL) {
		PluginComponentManager* _tmp3_ = NULL;
		_tmp3_ = pluginManager;
		plugin_component_manager_print_error (_tmp3_, "THIS IS VERY BAD: Unable to access \"/sys/class/gpio/unexport\". Ensur" \
"e SmartSim has permission to access GPIO.");
	}
	_tmp4_ = unexportFile;
	_tmp5_ = self->priv->gpioNumber;
	fprintf (_tmp4_, "%i", _tmp5_);
	_fclose0 (unexportFile);
	unexportFile = NULL;
	self->priv->exported = FALSE;
	_fclose0 (unexportFile);
}


static gboolean gpio_pin_plugin_component_state_read_gpio (GpioPinPluginComponentState* self) {
	gboolean result = FALSE;
	FILE* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	FILE* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean value = FALSE;
	FILE* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->valueFile;
	fflush (_tmp0_);
	_tmp2_ = self->priv->valueFile;
	_tmp3_ = fgetc (_tmp2_);
	if (_tmp3_ == ((gint) '1')) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	value = _tmp1_;
	_tmp4_ = self->priv->valueFile;
	fseek (_tmp4_, (glong) 0, SEEK_SET);
	result = value;
	return result;
}


static void gpio_pin_plugin_component_state_write_gpio (GpioPinPluginComponentState* self, gboolean value) {
	gchar _tmp0_ = '\0';
	gboolean _tmp1_ = FALSE;
	FILE* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ == TRUE) {
		_tmp0_ = '1';
	} else {
		_tmp0_ = '0';
	}
	_tmp2_ = self->priv->valueFile;
	fputc (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->valueFile;
	fflush (_tmp3_);
}


static void gpio_pin_plugin_component_state_real_update (ComponentState* base) {
	GpioPinPluginComponentState * self;
	gboolean _tmp0_ = FALSE;
	self = (GpioPinPluginComponentState*) base;
	_tmp0_ = self->priv->isInput;
	if (_tmp0_ == TRUE) {
		gboolean _tmp1_ = FALSE;
		Connection* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = gpio_pin_plugin_component_state_read_gpio (self);
		self->priv->value = _tmp1_;
		_tmp2_ = self->priv->accessWire;
		_tmp3_ = self->priv->value;
		connection_set_signalState (_tmp2_, _tmp3_);
	} else {
		Connection* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->accessWire;
		_tmp5_ = connection_get_signalState (_tmp4_);
		_tmp6_ = _tmp5_;
		self->priv->value = _tmp6_;
		_tmp7_ = self->priv->value;
		gpio_pin_plugin_component_state_write_gpio (self, _tmp7_);
	}
}


static gboolean gpio_pin_plugin_component_state_real_get_alwaysUpdate (ComponentState* base) {
	gboolean result;
	GpioPinPluginComponentState* self;
	gboolean _tmp0_ = FALSE;
	self = (GpioPinPluginComponentState*) base;
	_tmp0_ = self->priv->isInput;
	result = _tmp0_;
	return result;
}


static GpioPinPluginComponentStateRegisteredPin* gpio_pin_plugin_component_state_registered_pin_dup (const GpioPinPluginComponentStateRegisteredPin* self) {
	GpioPinPluginComponentStateRegisteredPin* dup;
	dup = g_new0 (GpioPinPluginComponentStateRegisteredPin, 1);
	memcpy (dup, self, sizeof (GpioPinPluginComponentStateRegisteredPin));
	return dup;
}


static void gpio_pin_plugin_component_state_registered_pin_free (GpioPinPluginComponentStateRegisteredPin* self) {
	g_free (self);
}


static GType gpio_pin_plugin_component_state_registered_pin_get_type (void) {
	static volatile gsize gpio_pin_plugin_component_state_registered_pin_type_id__volatile = 0;
	if (g_once_init_enter (&gpio_pin_plugin_component_state_registered_pin_type_id__volatile)) {
		GType gpio_pin_plugin_component_state_registered_pin_type_id;
		gpio_pin_plugin_component_state_registered_pin_type_id = g_boxed_type_register_static ("GpioPinPluginComponentStateRegisteredPin", (GBoxedCopyFunc) gpio_pin_plugin_component_state_registered_pin_dup, (GBoxedFreeFunc) gpio_pin_plugin_component_state_registered_pin_free);
		g_once_init_leave (&gpio_pin_plugin_component_state_registered_pin_type_id__volatile, gpio_pin_plugin_component_state_registered_pin_type_id);
	}
	return gpio_pin_plugin_component_state_registered_pin_type_id__volatile;
}


static void gpio_pin_plugin_component_state_class_init (GpioPinPluginComponentStateClass * klass) {
	gpio_pin_plugin_component_state_parent_class = g_type_class_peek_parent (klass);
	COMPONENT_STATE_CLASS (klass)->finalize = gpio_pin_plugin_component_state_finalize;
	g_type_class_add_private (klass, sizeof (GpioPinPluginComponentStatePrivate));
	COMPONENT_STATE_CLASS (klass)->update = gpio_pin_plugin_component_state_real_update;
	COMPONENT_STATE_CLASS (klass)->get_alwaysUpdate = gpio_pin_plugin_component_state_real_get_alwaysUpdate;
}


static void gpio_pin_plugin_component_state_instance_init (GpioPinPluginComponentState * self) {
	self->priv = GPIO_PIN_PLUGIN_COMPONENT_STATE_GET_PRIVATE (self);
}


static void gpio_pin_plugin_component_state_finalize (ComponentState* obj) {
	GpioPinPluginComponentState * self;
	PluginComponentManager* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GPIO_PIN_PLUGIN_COMPONENT_STATE, GpioPinPluginComponentState);
	gpio_pin_plugin_component_state_unexport (self);
	gpio_pin_plugin_component_state_unregister_pins ();
	_tmp0_ = pluginManager;
	plugin_component_manager_print_info (_tmp0_, "Plugin GPIO Pin Deconstucted.\n");
	_connection_unref0 (self->priv->accessWire);
	_g_free0 (self->priv->gpioDirectory);
	_fclose0 (self->priv->valueFile);
	COMPONENT_STATE_CLASS (gpio_pin_plugin_component_state_parent_class)->finalize (obj);
}


GType gpio_pin_plugin_component_state_get_type (void) {
	static volatile gsize gpio_pin_plugin_component_state_type_id__volatile = 0;
	if (g_once_init_enter (&gpio_pin_plugin_component_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpioPinPluginComponentStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpio_pin_plugin_component_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpioPinPluginComponentState), 0, (GInstanceInitFunc) gpio_pin_plugin_component_state_instance_init, NULL };
		GType gpio_pin_plugin_component_state_type_id;
		gpio_pin_plugin_component_state_type_id = g_type_register_static (TYPE_COMPONENT_STATE, "GpioPinPluginComponentState", &g_define_type_info, 0);
		g_once_init_leave (&gpio_pin_plugin_component_state_type_id__volatile, gpio_pin_plugin_component_state_type_id);
	}
	return gpio_pin_plugin_component_state_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



