/* project.c generated by valac 0.24.0, the Vala compiler
 * generated from project.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: project.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gmodule.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <config.h>
#include <cairo.h>
#include <libxml/xmlwriter.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;
typedef struct _ProjectPrivate ProjectPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;

#define TYPE_DESIGNER (designer_get_type ())
#define DESIGNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER, Designer))
#define DESIGNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER, DesignerClass))
#define IS_DESIGNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER))
#define IS_DESIGNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER))
#define DESIGNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER, DesignerClass))

typedef struct _Designer Designer;
typedef struct _DesignerClass DesignerClass;
#define _component_def_unref0(var) ((var == NULL) ? NULL : (var = (component_def_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_unref0(var) ((var == NULL) ? NULL : (var = (project_unref (var), NULL)))

#define TYPE_VERSION_COMPARISON (version_comparison_get_type ())

#define TYPE_DESIGNER_WINDOW (designer_window_get_type ())
#define DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESIGNER_WINDOW, DesignerWindow))
#define DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESIGNER_WINDOW, DesignerWindowClass))
#define IS_DESIGNER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESIGNER_WINDOW))
#define IS_DESIGNER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESIGNER_WINDOW))
#define DESIGNER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESIGNER_WINDOW, DesignerWindowClass))

typedef struct _DesignerWindow DesignerWindow;
typedef struct _DesignerWindowClass DesignerWindowClass;
#define _designer_unref0(var) ((var == NULL) ? NULL : (var = (designer_unref (var), NULL)))
typedef struct _ComponentDefPrivate ComponentDefPrivate;

#define TYPE_DIRECTION (direction_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CIRCUIT_INFORMATION (circuit_information_get_type ())
#define CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformation))
#define CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))
#define IS_CIRCUIT_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CIRCUIT_INFORMATION))
#define IS_CIRCUIT_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CIRCUIT_INFORMATION))
#define CIRCUIT_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CIRCUIT_INFORMATION, CircuitInformationClass))

typedef struct _CircuitInformation CircuitInformation;
typedef struct _CircuitInformationClass CircuitInformationClass;

#define TYPE_GRAPHIC (graphic_get_type ())
#define GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRAPHIC, Graphic))
#define GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRAPHIC, GraphicClass))
#define IS_GRAPHIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRAPHIC))
#define IS_GRAPHIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRAPHIC))
#define GRAPHIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRAPHIC, GraphicClass))

typedef struct _Graphic Graphic;
typedef struct _GraphicClass GraphicClass;

#define TYPE_PIN_DEF (pin_def_get_type ())
#define PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIN_DEF, PinDef))
#define PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIN_DEF, PinDefClass))
#define IS_PIN_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIN_DEF))
#define IS_PIN_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIN_DEF))
#define PIN_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIN_DEF, PinDefClass))

typedef struct _PinDef PinDef;
typedef struct _PinDefClass PinDefClass;
typedef struct _DesignerPrivate DesignerPrivate;
typedef struct _DesignerWindowPrivate DesignerWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PluginComponentManagerPrivate PluginComponentManagerPrivate;
#define _plugin_component_manager_unref0(var) ((var == NULL) ? NULL : (var = (plugin_component_manager_unref (var), NULL)))
#define _compiled_circuit_unref0(var) ((var == NULL) ? NULL : (var = (compiled_circuit_unref (var), NULL)))

#define TYPE_SIMULATOR_WINDOW (simulator_window_get_type ())
#define SIMULATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMULATOR_WINDOW, SimulatorWindow))
#define SIMULATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMULATOR_WINDOW, SimulatorWindowClass))
#define IS_SIMULATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMULATOR_WINDOW))
#define IS_SIMULATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMULATOR_WINDOW))
#define SIMULATOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMULATOR_WINDOW, SimulatorWindowClass))

typedef struct _SimulatorWindow SimulatorWindow;
typedef struct _SimulatorWindowClass SimulatorWindowClass;
#define _xmlFreeTextWriter0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextWriter (var), NULL)))
typedef struct _CustomComponentDefPrivate CustomComponentDefPrivate;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;

#define TYPE_ANNOTATION (annotation_get_type ())
#define ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANNOTATION, Annotation))
#define ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANNOTATION, AnnotationClass))
#define IS_ANNOTATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANNOTATION))
#define IS_ANNOTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANNOTATION))
#define ANNOTATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANNOTATION, AnnotationClass))

typedef struct _Annotation Annotation;
typedef struct _AnnotationClass AnnotationClass;

#define TYPE_PROPERTY_ITEM_STRING (property_item_string_get_type ())
#define PROPERTY_ITEM_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_STRING, PropertyItemString))
#define PROPERTY_ITEM_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_STRING, PropertyItemStringClass))
#define IS_PROPERTY_ITEM_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_STRING))
#define IS_PROPERTY_ITEM_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_STRING))
#define PROPERTY_ITEM_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_STRING, PropertyItemStringClass))

typedef struct _PropertyItemString PropertyItemString;
typedef struct _PropertyItemStringClass PropertyItemStringClass;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))

#define TYPE_PROPERTIES_QUERY (properties_query_get_type ())
#define PROPERTIES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_QUERY, PropertiesQuery))
#define PROPERTIES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES_QUERY, PropertiesQueryClass))
#define IS_PROPERTIES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_QUERY))
#define IS_PROPERTIES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES_QUERY))
#define PROPERTIES_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES_QUERY, PropertiesQueryClass))

typedef struct _PropertiesQuery PropertiesQuery;
typedef struct _PropertiesQueryClass PropertiesQueryClass;
#define _properties_query_unref0(var) ((var == NULL) ? NULL : (var = (properties_query_unref (var), NULL)))
typedef struct _ParamSpecProject ParamSpecProject;

typedef enum  {
	PROJECT_LOAD_ERROR_NOT_PROJECT,
	PROJECT_LOAD_ERROR_CANCEL,
	PROJECT_LOAD_ERROR_FILE,
	PROJECT_LOAD_ERROR_LOAD
} ProjectLoadError;
#define PROJECT_LOAD_ERROR project_load_error_quark ()
struct _Project {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectPrivate * priv;
	gboolean running;
	CustomComponentDef** customComponentDefs;
	gint customComponentDefs_length1;
	PluginComponentDef** pluginComponentDefs;
	gint pluginComponentDefs_length1;
	PluginComponentManager** pluginComponentManagers;
	gint pluginComponentManagers_length1;
	CustomComponentDef* rootComponent;
	gint myID;
	gchar* description;
	gchar* filename;
};

struct _ProjectClass {
	GTypeClass parent_class;
	void (*finalize) (Project *self);
};

struct _ProjectPrivate {
	gboolean _pluginsAllowed;
	gchar* _name;
	Designer** designers;
	gint designers_length1;
	gint _designers_size_;
	gint designerCount;
};

typedef enum  {
	VERSION_COMPARISON_EQUAL,
	VERSION_COMPARISON_LESS,
	VERSION_COMPARISON_GREATER
} VersionComparison;

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _ComponentDef {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentDefPrivate * priv;
	Graphic* graphic;
	gchar* graphicReferenceFilename;
	gchar* name;
	gchar* description;
	gchar* iconFilename;
	gchar* label;
	PinDef** pinDefs;
	gint pinDefs_length1;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
	gint backgroundAlpha;
	gint backgroundRed;
	gint backgroundGreen;
	gint backgroundBlue;
	gdouble backgroundAlphaF;
	gdouble backgroundRedF;
	gdouble backgroundGreenF;
	gdouble backgroundBlueF;
	gboolean drawBox;
	gchar* filename;
};

struct _ComponentDefClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentDef *self);
	void (*extra_render) (ComponentDef* self, cairo_t* context, Direction direction, gboolean flipped, ComponentInst* componentInst);
	void (*extra_validate) (ComponentDef* self, Project* project, CustomComponentDef** componentChain, int componentChain_length1, ComponentInst* componentInst);
	void (*add_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet* configurationProperty);
	void (*get_properties) (ComponentDef* self, PropertySet* queryProperty, PropertySet** configurationProperty);
	void (*load_properties) (ComponentDef* self, xmlNode* xmlnode, PropertySet** configurationProperty);
	void (*save_properties) (ComponentDef* self, xmlTextWriter* xmlWriter, PropertySet* configurationProperty);
	void (*configure_inst) (ComponentDef* self, ComponentInst* componentInst, gboolean firstLoad);
	void (*compile_component) (ComponentDef* self, CompiledCircuit* compiledCircuit, ComponentInst* componentInst, Connection** connections, int connections_length1, ComponentInst** ancestry, int ancestry_length1);
	void (*create_information) (ComponentDef* self, CircuitInformation* circuitInformation);
};

struct _Designer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DesignerPrivate * priv;
	DesignerWindow* window;
	CustomComponentDef* customComponentDef;
	gint myID;
	ComponentDef* insertComponentDef;
	ComponentDef* lastInsertCustomComponentDef;
	ComponentDef* lastInsertPluginComponentDef;
	ComponentInst* shadowComponentInst;
};

struct _DesignerClass {
	GTypeClass parent_class;
	void (*finalize) (Designer *self);
};

struct _DesignerWindow {
	GtkWindow parent_instance;
	DesignerWindowPrivate * priv;
	gint myID;
	gchar* componentFileName;
	gint gridSize;
	gfloat zoom;
	gboolean showGrid;
	gboolean liveScrollUpdate;
	gboolean shadowComponent;
};

struct _DesignerWindowClass {
	GtkWindowClass parent_class;
};

typedef enum  {
	COMPONENT_DEF_LOAD_ERROR_NOT_COMPONENT,
	COMPONENT_DEF_LOAD_ERROR_FILE,
	COMPONENT_DEF_LOAD_ERROR_LOAD,
	COMPONENT_DEF_LOAD_ERROR_CANCEL
} ComponentDefLoadError;
#define COMPONENT_DEF_LOAD_ERROR component_def_load_error_quark ()
typedef enum  {
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NOT_CUSTOM,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_MISSING_DEPENDENCY,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	CUSTOM_COMPONENT_DEF_LOAD_ERROR_INVALID
} CustomComponentDefLoadError;
#define CUSTOM_COMPONENT_DEF_LOAD_ERROR custom_component_def_load_error_quark ()
struct _PluginComponentManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PluginComponentManagerPrivate * priv;
	GModule* mainProgram;
	GModule* module;
	gchar* filename;
	gchar* name;
	Project* project;
	PluginComponentDef* pluginComponentDef;
};

struct _PluginComponentManagerClass {
	GTypeClass parent_class;
	void (*finalize) (PluginComponentManager *self);
};

typedef enum  {
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NOT_PLUGIN,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INIT_ERROR,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_ACCESSIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_LIBRARY_NOT_COMPATIBLE,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_NAME_CONFLICT,
	PLUGIN_COMPONENT_DEF_LOAD_ERROR_INVALID
} PluginComponentDefLoadError;
#define PLUGIN_COMPONENT_DEF_LOAD_ERROR plugin_component_def_load_error_quark ()
struct _CustomComponentDef {
	ComponentDef parent_instance;
	CustomComponentDefPrivate * priv;
	ComponentInst** componentInsts;
	gint componentInsts_length1;
	WireInst** wireInsts;
	gint wireInsts_length1;
	Annotation** annotations;
	gint annotations_length1;
	ComponentDef** immediateDependencies;
	gint immediateDependencies_length1;
};

struct _CustomComponentDefClass {
	ComponentDefClass parent_class;
};

struct _ParamSpecProject {
	GParamSpec parent_instance;
};


static gpointer project_parent_class = NULL;
static Project** project_projects;
static gint project_projects_length1;
static Project** project_projects = NULL;
static gint project_projects_length1 = 0;
static gint _project_projects_size_ = 0;
static gint project_projectCount;
static gint project_projectCount = 0;
extern ComponentDef** core_standardComponentDefs;
extern gint core_standardComponentDefs_length1;

GQuark project_load_error_quark (void);
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
GType plugin_component_def_get_type (void) G_GNUC_CONST;
gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
gpointer designer_ref (gpointer instance);
void designer_unref (gpointer instance);
GParamSpec* param_spec_designer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_designer (GValue* value, gpointer v_object);
void value_take_designer (GValue* value, gpointer v_object);
gpointer value_get_designer (const GValue* value);
GType designer_get_type (void) G_GNUC_CONST;
#define PROJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROJECT, ProjectPrivate))
enum  {
	PROJECT_DUMMY_PROPERTY
};
gboolean project_plugins_allowed (Project* self, const gchar* extra);
void basic_dialog_error (GtkWindow* window, const gchar* text);
gint basic_dialog_ask_generic (GtkWindow* window, GtkMessageType messageType, const gchar* text, gchar** options, int options_length1);
void project_register (Project* project);
static void _vala_array_add68 (Project*** array, int* length, int* size, Project* value);
void project_unregister (Project* project);
static void _vala_array_add69 (Project*** array, int* length, int* size, Project* value);
static Project** _vala_array_dup55 (Project** self, int length);
void project_clean_up (void);
gboolean designer_window_project_has_windows (Project* project);
static void _vala_array_add70 (Project*** array, int* length, int* size, Project* value);
gint project_destroy_all_windows (Project* self);
static Project** _vala_array_dup56 (Project** self, int length);
Project* project_new (void);
Project* project_construct (GType object_type);
static void project_set_name (Project* self, const gchar* value);
Project* project_new_load (const gchar* filename, GError** error);
Project* project_construct_load (GType object_type, const gchar* filename, GError** error);
GType version_comparison_get_type (void) G_GNUC_CONST;
VersionComparison core_compare_versions (const gchar* whatVersion, const gchar* withVersion);
#define CORE_shortVersionString PACKAGE_VERSION
gboolean core_version_ignored (const gchar* extra);
gchar* project_absolute_filename (Project* self, const gchar* targetFilename);
CustomComponentDef* project_load_component (Project* self, const gchar* fileName);
void project_set_root_component (Project* self, CustomComponentDef* rootComponent);
PluginComponentDef* project_load_plugin_component (Project* self, const gchar* filename, const gchar* altFilename);
GType designer_window_get_type (void) G_GNUC_CONST;
Designer* project_new_designer (Project* self, DesignerWindow* window);
Designer* designer_new (DesignerWindow* viewerWindow, Project* parentProject);
Designer* designer_construct (GType object_type, DesignerWindow* viewerWindow, Project* parentProject);
void project_register_designer (Project* self, Designer* designer);
CustomComponentDef* project_new_component (Project* self);
CustomComponentDef* custom_component_def_new (Project* project);
CustomComponentDef* custom_component_def_construct (GType object_type, Project* project);
GType direction_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer circuit_information_ref (gpointer instance);
void circuit_information_unref (gpointer instance);
GParamSpec* param_spec_circuit_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_circuit_information (GValue* value, gpointer v_object);
void value_take_circuit_information (GValue* value, gpointer v_object);
gpointer value_get_circuit_information (const GValue* value);
GType circuit_information_get_type (void) G_GNUC_CONST;
gpointer graphic_ref (gpointer instance);
void graphic_unref (gpointer instance);
GParamSpec* param_spec_graphic (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_graphic (GValue* value, gpointer v_object);
void value_take_graphic (GValue* value, gpointer v_object);
gpointer value_get_graphic (const GValue* value);
GType graphic_get_type (void) G_GNUC_CONST;
gpointer pin_def_ref (gpointer instance);
void pin_def_unref (gpointer instance);
GParamSpec* param_spec_pin_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pin_def (GValue* value, gpointer v_object);
void value_take_pin_def (GValue* value, gpointer v_object);
gpointer value_get_pin_def (const GValue* value);
GType pin_def_get_type (void) G_GNUC_CONST;
ComponentDef* project_resolve_def_name (Project* self, const gchar* name);
static CustomComponentDef** _vala_array_dup57 (CustomComponentDef** self, int length);
static void _vala_array_add71 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
static CustomComponentDef** _vala_array_dup58 (CustomComponentDef** self, int length);
void project_update_custom_menus (Project* self);
void project_update_plugin_menus (Project* self);
gint project_reopen_window_from_file (Project* self, const gchar* filename);
void designer_window_register (DesignerWindow* window);
DesignerWindow* designer_window_new_with_existing_component (Project* project, CustomComponentDef* customComponentDef);
DesignerWindow* designer_window_construct_with_existing_component (GType object_type, Project* project, CustomComponentDef* customComponentDef);
gint project_reopen_window_from_component (Project* self, CustomComponentDef* customComponentDef);
static gboolean _vala_custom_component_def_array_contains (CustomComponentDef** stack, int stack_length, CustomComponentDef* needle);
void designer_window_force_destroy_window (DesignerWindow* self);
GQuark component_def_load_error_quark (void);
GQuark custom_component_def_load_error_quark (void);
CustomComponentDef* custom_component_def_new_from_file (const gchar* infoFilename, Project* project, GError** error);
CustomComponentDef* custom_component_def_construct_from_file (GType object_type, const gchar* infoFilename, Project* project, GError** error);
static CustomComponentDef** _vala_array_dup59 (CustomComponentDef** self, int length);
static void _vala_array_add72 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
static CustomComponentDef** _vala_array_dup60 (CustomComponentDef** self, int length);
PluginComponentManager* plugin_component_manager_from_filename (const gchar* filename);
static PluginComponentDef** _vala_array_dup61 (PluginComponentDef** self, int length);
static PluginComponentManager** _vala_array_dup62 (PluginComponentManager** self, int length);
static void _vala_array_add73 (PluginComponentDef*** array, int* length, int* size, PluginComponentDef* value);
static void _vala_array_add74 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value);
static PluginComponentDef** _vala_array_dup63 (PluginComponentDef** self, int length);
static PluginComponentManager** _vala_array_dup64 (PluginComponentManager** self, int length);
GQuark plugin_component_def_load_error_quark (void);
PluginComponentManager* plugin_component_manager_new_from_file (const gchar* infoFilename, Project* project, GError** error);
PluginComponentManager* plugin_component_manager_construct_from_file (GType object_type, const gchar* infoFilename, Project* project, GError** error);
static PluginComponentDef** _vala_array_dup65 (PluginComponentDef** self, int length);
static PluginComponentManager** _vala_array_dup66 (PluginComponentManager** self, int length);
static void _vala_array_add75 (PluginComponentDef*** array, int* length, int* size, PluginComponentDef* value);
static void _vala_array_add76 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value);
static PluginComponentDef** _vala_array_dup67 (PluginComponentDef** self, int length);
static PluginComponentManager** _vala_array_dup68 (PluginComponentManager** self, int length);
CustomComponentDef* project_get_default_component (Project* self);
void project_update_error_modes (Project* self, gboolean _error_);
void designer_window_update_error_mode (DesignerWindow* self, gboolean _error_);
DesignerWindow** designer_window_get_project_windows (Project* project, int* result_length1);
void designer_window_update_custom_menu (DesignerWindow* self);
void designer_window_update_plugin_menu (DesignerWindow* self);
void project_update_titles (Project* self);
void designer_window_update_title (DesignerWindow* self);
CompiledCircuit* project_validate (Project* self);
CompiledCircuit* compiled_circuit_new (Project* project, CustomComponentDef* rootComponent);
CompiledCircuit* compiled_circuit_construct (GType object_type, Project* project, CustomComponentDef* rootComponent);
gint compiled_circuit_check_validity (CompiledCircuit* self);
gboolean compiled_circuit_get_errorOccurred (CompiledCircuit* self);
void basic_dialog_warning (GtkWindow* window, const gchar* text);
const gchar* compiled_circuit_get_errorMessage (CompiledCircuit* self);
gboolean compiled_circuit_get_warningOccurred (CompiledCircuit* self);
const gchar* compiled_circuit_get_warningMessage (CompiledCircuit* self);
void basic_dialog_information (GtkWindow* window, const gchar* text);
CompiledCircuit* project_run (Project* self, gboolean* startNow);
gint compiled_circuit_compile (CompiledCircuit* self);
GType simulator_window_get_type (void) G_GNUC_CONST;
SimulatorWindow* simulator_window_new (CompiledCircuit* compiledCircuit);
SimulatorWindow* simulator_window_construct (GType object_type, CompiledCircuit* compiledCircuit);
void simulator_window_run (SimulatorWindow* self);
gint project_save (Project* self, const gchar* filename);
CustomComponentDef** custom_component_def_validate_dependencies (CustomComponentDef* self, CustomComponentDef** componentChain, int componentChain_length1, int* result_length1);
gboolean designer_window_save_component (DesignerWindow* self, gboolean saveAs);
const gchar* project_get_name (Project* self);
void project_save_component_list (Project* self, xmlTextWriter* xmlWriter);
void custom_component_def_update_immediate_dependencies (CustomComponentDef* self, gboolean includePlugins);
static void _vala_array_add77 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
gpointer annotation_ref (gpointer instance);
void annotation_unref (gpointer instance);
GParamSpec* param_spec_annotation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_annotation (GValue* value, gpointer v_object);
void value_take_annotation (GValue* value, gpointer v_object);
gpointer value_get_annotation (const GValue* value);
GType annotation_get_type (void) G_GNUC_CONST;
static void _vala_array_add78 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
static void _vala_array_add79 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
void custom_component_def_remove_immediate_dependency (CustomComponentDef* self, ComponentDef* removeComponent);
static void _vala_array_add80 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
static CustomComponentDef** _vala_array_dup69 (CustomComponentDef** self, int length);
gchar* project_relative_filename (Project* self, const gchar* rawTargetFilename);
gint project_remove_component (Project* self, CustomComponentDef* removeComponent);
CustomComponentDef** project_component_users (Project* self, ComponentDef* usedComponent, int* result_length1);
static void _vala_array_add81 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
static CustomComponentDef** _vala_array_dup70 (CustomComponentDef** self, int length);
gint project_remove_plugin_component (Project* self, PluginComponentDef* removeComponent);
static void _vala_array_add82 (PluginComponentDef*** array, int* length, int* size, PluginComponentDef* value);
static void _vala_array_add83 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value);
static PluginComponentDef** _vala_array_dup71 (PluginComponentDef** self, int length);
static PluginComponentManager** _vala_array_dup72 (PluginComponentManager** self, int length);
static gboolean _vala_component_def_array_contains (ComponentDef** stack, int stack_length, ComponentDef* needle);
static void _vala_array_add84 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value);
void project_configure (Project* self);
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
PropertyItemString* property_item_string_new (const gchar* name, const gchar* description, const gchar* data);
PropertyItemString* property_item_string_construct (GType object_type, const gchar* name, const gchar* description, const gchar* data);
GType property_item_string_get_type (void) G_GNUC_CONST;
gpointer properties_query_ref (gpointer instance);
void properties_query_unref (gpointer instance);
GParamSpec* param_spec_properties_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_properties_query (GValue* value, gpointer v_object);
void value_take_properties_query (GValue* value, gpointer v_object);
gpointer value_get_properties_query (const GValue* value);
GType properties_query_get_type (void) G_GNUC_CONST;
PropertiesQuery* properties_query_new (const gchar* title, GtkWindow* parent, PropertySet* propertySet);
PropertiesQuery* properties_query_construct (GType object_type, const gchar* title, GtkWindow* parent, PropertySet* propertySet);
gint properties_query_run (PropertiesQuery* self);
gchar* property_item_string_get_data (PropertySet* propertySet, const gchar* name);
gchar* core_absolute_filename (const gchar* filename, const gchar* pwd);
static void _vala_array_add85 (Designer*** array, int* length, int* size, Designer* value);
void project_unregister_designer (Project* self, Designer* designer);
static void _vala_array_add86 (Designer*** array, int* length, int* size, Designer* value);
static Designer** _vala_array_dup73 (Designer** self, int length);
static void project_finalize (Project* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark project_load_error_quark (void) {
	return g_quark_from_static_string ("project_load_error-quark");
}


gboolean project_plugins_allowed (Project* self, const gchar* extra) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (extra != NULL, FALSE);
	_tmp0_ = self->priv->_pluginsAllowed;
	if (_tmp0_ == TRUE) {
		result = TRUE;
		return result;
	}
	_tmp1_ = g_module_supported ();
	if (_tmp1_ == FALSE) {
		basic_dialog_error (NULL, "Error: Plugin components are not supported on your host system, and ca" \
"nnot be loaded.");
		self->priv->_pluginsAllowed = FALSE;
	}
	_tmp2_ = extra;
	_tmp3_ = g_strconcat ("Warning:\n" \
"You are about to load one or more plugin components. Plugin components" \
" can expand the capabilities of SmartSim, but allow the execution of a" \
"rbitrary code. Plugins may contain viruses or other malware, so only o" \
"pen projects and plugins that you fully trust. SmartSim and its develo" \
"pers are not responsible for any damage which results from the use of " \
"third party plugins. Allow plugins at your own risk.\n", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup ("Allow Plugin");
	_tmp6_ = g_strdup ("Allow All Plugins");
	_tmp7_ = g_strdup ("Cancel Loading");
	_tmp8_ = g_new0 (gchar*, 3 + 1);
	_tmp8_[0] = _tmp5_;
	_tmp8_[1] = _tmp6_;
	_tmp8_[2] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = basic_dialog_ask_generic (NULL, GTK_MESSAGE_WARNING, _tmp4_, _tmp9_, 3);
	_tmp11_ = _tmp10_;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp4_);
	switch (_tmp11_) {
		case 0:
		{
			result = TRUE;
			return result;
		}
		case 1:
		{
			self->priv->_pluginsAllowed = TRUE;
			result = TRUE;
			return result;
		}
		default:
		case 2:
		{
			self->priv->_pluginsAllowed = FALSE;
			result = FALSE;
			return result;
		}
	}
}


/**
 * Adds //project// to the static //projects// array.
 */
static gpointer _project_ref0 (gpointer self) {
	return self ? project_ref (self) : NULL;
}


static void _vala_array_add68 (Project*** array, int* length, int* size, Project* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Project*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void project_register (Project* project) {
	gint position = 0;
	Project** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Project** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Project* _tmp2_ = NULL;
	Project* _tmp3_ = NULL;
	Project* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	g_return_if_fail (project != NULL);
	_tmp0_ = project_projects;
	_tmp0__length1 = project_projects_length1;
	position = _tmp0__length1;
	_tmp1_ = project_projects;
	_tmp1__length1 = project_projects_length1;
	_tmp2_ = project;
	_tmp3_ = _project_ref0 (_tmp2_);
	_vala_array_add68 (&project_projects, &project_projects_length1, &_project_projects_size_, _tmp3_);
	_tmp4_ = project;
	_tmp4_->myID = position;
	_tmp5_ = stdout;
	fprintf (_tmp5_, "Registered project %i\n", position);
}


/**
 * Removes //project// from the static //projects// array.
 */
static void _vala_array_add69 (Project*** array, int* length, int* size, Project* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Project*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Project** _vala_array_dup55 (Project** self, int length) {
	Project** result;
	int i;
	result = g_new0 (Project*, length + 1);
	for (i = 0; i < length; i++) {
		Project* _tmp0_ = NULL;
		_tmp0_ = _project_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void project_unregister (Project* project) {
	Project** tempArray = NULL;
	Project** _tmp0_ = NULL;
	gint tempArray_length1 = 0;
	gint _tempArray_size_ = 0;
	gint position = 0;
	gint newID = 0;
	Project* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Project** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	Project** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	FILE* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	Project** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	g_return_if_fail (project != NULL);
	_tmp0_ = g_new0 (Project*, 0 + 1);
	tempArray = _tmp0_;
	tempArray_length1 = 0;
	_tempArray_size_ = tempArray_length1;
	newID = 0;
	_tmp1_ = project;
	_tmp2_ = _tmp1_->myID;
	position = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				Project** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = project_projects;
				_tmp6__length1 = project_projects_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = position;
				if (_tmp7_ != _tmp8_) {
					Project** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					Project* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					Project** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					Project** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					Project* _tmp16_ = NULL;
					Project* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					_tmp9_ = project_projects;
					_tmp9__length1 = project_projects_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = newID;
					_tmp11_->myID = _tmp12_;
					_tmp13_ = tempArray;
					_tmp13__length1 = tempArray_length1;
					_tmp14_ = project_projects;
					_tmp14__length1 = project_projects_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = _project_ref0 (_tmp16_);
					_vala_array_add69 (&tempArray, &tempArray_length1, &_tempArray_size_, _tmp17_);
					_tmp18_ = newID;
					newID = _tmp18_ + 1;
				}
			}
		}
	}
	_tmp19_ = tempArray;
	_tmp19__length1 = tempArray_length1;
	_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup55 (_tmp19_, _tmp19__length1) : ((gpointer) _tmp19_);
	_tmp20__length1 = _tmp19__length1;
	project_projects = (_vala_array_free (project_projects, project_projects_length1, (GDestroyNotify) project_unref), NULL);
	project_projects = _tmp20_;
	project_projects_length1 = _tmp20__length1;
	_project_projects_size_ = project_projects_length1;
	_tmp21_ = stdout;
	_tmp22_ = position;
	fprintf (_tmp21_, "Unregistered project %i\n", _tmp22_);
	_tmp23_ = project_projects;
	_tmp23__length1 = project_projects_length1;
	if (_tmp23__length1 == 0) {
		FILE* _tmp24_ = NULL;
		_tmp24_ = stdout;
		fprintf (_tmp24_, "No more open projects!\n");
	}
	tempArray = (_vala_array_free (tempArray, tempArray_length1, (GDestroyNotify) project_unref), NULL);
}


static void _vala_array_add70 (Project*** array, int* length, int* size, Project* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Project*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Project** _vala_array_dup56 (Project** self, int length) {
	Project** result;
	int i;
	result = g_new0 (Project*, length + 1);
	for (i = 0; i < length; i++) {
		Project* _tmp0_ = NULL;
		_tmp0_ = _project_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void project_clean_up (void) {
	Project** newProjects = NULL;
	Project** _tmp0_ = NULL;
	gint newProjects_length1 = 0;
	gint _newProjects_size_ = 0;
	gint newID = 0;
	Project** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Project** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	Project** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	_tmp0_ = g_new0 (Project*, 0 + 1);
	newProjects = _tmp0_;
	newProjects_length1 = 0;
	_newProjects_size_ = newProjects_length1;
	newID = 0;
	_tmp1_ = project_projects;
	_tmp1__length1 = project_projects_length1;
	{
		Project** project_collection = NULL;
		gint project_collection_length1 = 0;
		gint _project_collection_size_ = 0;
		gint project_it = 0;
		project_collection = _tmp1_;
		project_collection_length1 = _tmp1__length1;
		for (project_it = 0; project_it < _tmp1__length1; project_it = project_it + 1) {
			Project* _tmp2_ = NULL;
			Project* project = NULL;
			_tmp2_ = _project_ref0 (project_collection[project_it]);
			project = _tmp2_;
			{
				Project* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = project;
				_tmp4_ = designer_window_project_has_windows (_tmp3_);
				if (_tmp4_) {
					Project** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					Project* _tmp6_ = NULL;
					Project* _tmp7_ = NULL;
					Project* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					_tmp5_ = newProjects;
					_tmp5__length1 = newProjects_length1;
					_tmp6_ = project;
					_tmp7_ = _project_ref0 (_tmp6_);
					_vala_array_add70 (&newProjects, &newProjects_length1, &_newProjects_size_, _tmp7_);
					_tmp8_ = project;
					_tmp9_ = newID;
					_tmp8_->myID = _tmp9_;
					_tmp10_ = newID;
					newID = _tmp10_ + 1;
				} else {
					Project* _tmp11_ = NULL;
					FILE* _tmp12_ = NULL;
					Project* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					_tmp11_ = project;
					project_destroy_all_windows (_tmp11_);
					_tmp12_ = stdout;
					_tmp13_ = project;
					_tmp14_ = _tmp13_->myID;
					fprintf (_tmp12_, "Unregistered project %i (no windows)\n", _tmp14_);
				}
				_project_unref0 (project);
			}
		}
	}
	_tmp15_ = newProjects;
	_tmp15__length1 = newProjects_length1;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup56 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp15__length1;
	project_projects = (_vala_array_free (project_projects, project_projects_length1, (GDestroyNotify) project_unref), NULL);
	project_projects = _tmp16_;
	project_projects_length1 = _tmp16__length1;
	_project_projects_size_ = project_projects_length1;
	newProjects = (_vala_array_free (newProjects, newProjects_length1, (GDestroyNotify) project_unref), NULL);
}


/**
 * Creates a new project and registers it.
 */
Project* project_construct (GType object_type) {
	Project* self = NULL;
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	self = (Project*) g_type_create_instance (object_type);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "New Project Created\n");
	project_register (self);
	_tmp1_ = project_projectCount;
	project_projectCount = _tmp1_ + 1;
	_tmp2_ = project_projectCount;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("Project ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	project_set_name (self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = g_strdup ("");
	_g_free0 (self->description);
	self->description = _tmp7_;
	_tmp8_ = g_strdup ("");
	_g_free0 (self->filename);
	self->filename = _tmp8_;
	return self;
}


Project* project_new (void) {
	return project_construct (TYPE_PROJECT);
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


Project* project_construct_load (GType object_type, const gchar* filename, GError** error) {
	Project* self = NULL;
	FILE* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	xmlDoc* xmldoc = NULL;
	xmlNode* xmlroot = NULL;
	xmlNode* xmlnode = NULL;
	const gchar* _tmp10_ = NULL;
	xmlDoc* _tmp11_ = NULL;
	xmlDoc* _tmp12_ = NULL;
	xmlDoc* _tmp17_ = NULL;
	xmlNode* _tmp18_ = NULL;
	xmlNode* _tmp19_ = NULL;
	xmlNode* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (Project*) g_type_create_instance (object_type);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Loading Project...\n");
	project_register (self);
	_tmp1_ = project_projectCount;
	project_projectCount = _tmp1_ + 1;
	_tmp2_ = project_projectCount;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat ("Project ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	project_set_name (self, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = g_strdup ("");
	_g_free0 (self->description);
	self->description = _tmp7_;
	_tmp8_ = filename;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->filename);
	self->filename = _tmp9_;
	_tmp10_ = filename;
	_tmp11_ = xmlParseFile (_tmp10_);
	xmldoc = _tmp11_;
	_tmp12_ = xmldoc;
	if (_tmp12_ == NULL) {
		FILE* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = filename;
		fprintf (_tmp13_, "Error loading info xml file \"%s\".\n", _tmp14_);
		_tmp15_ = stdout;
		fprintf (_tmp15_, "File inaccessible.\n");
		_tmp16_ = g_error_new_literal (PROJECT_LOAD_ERROR, PROJECT_LOAD_ERROR_FILE, "File inaccessible");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_project_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = xmldoc;
	_tmp18_ = xmlDocGetRootElement (_tmp17_);
	xmlroot = _tmp18_;
	_tmp19_ = xmlroot;
	if (_tmp19_ == NULL) {
		FILE* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		FILE* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		_tmp20_ = stdout;
		_tmp21_ = filename;
		fprintf (_tmp20_, "Error loading info xml file \"%s\".\n", _tmp21_);
		_tmp22_ = stdout;
		fprintf (_tmp22_, "File is empty.\n");
		_tmp23_ = g_error_new_literal (PROJECT_LOAD_ERROR, PROJECT_LOAD_ERROR_FILE, "File empty");
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_project_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp24_ = xmlroot;
	_tmp25_ = _tmp24_->name;
	if (g_strcmp0 (_tmp25_, "project") != 0) {
		FILE* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		FILE* _tmp28_ = NULL;
		xmlNode* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		xmlNode* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
		GError* _tmp38_ = NULL;
		_tmp26_ = stdout;
		_tmp27_ = filename;
		fprintf (_tmp26_, "Error loading info xml file \"%s\".\n", _tmp27_);
		_tmp28_ = stdout;
		_tmp29_ = xmlroot;
		_tmp30_ = _tmp29_->name;
		fprintf (_tmp28_, "Wanted \"project\" info, but got \"%s\"\n", _tmp30_);
		_tmp31_ = xmlroot;
		_tmp32_ = _tmp31_->name;
		_tmp33_ = g_strconcat ("Wanted \"project\" info, but got \"", _tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp34_, "\"", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_error_new_literal (PROJECT_LOAD_ERROR, PROJECT_LOAD_ERROR_NOT_PROJECT, _tmp36_);
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		_inner_error_ = _tmp38_;
		if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
			g_propagate_error (error, _inner_error_);
			_project_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		xmlNode* _tmp39_ = NULL;
		xmlNode* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		_tmp39_ = xmlroot;
		_tmp40_ = _tmp39_->children;
		xmlnode = _tmp40_;
		_tmp41_ = TRUE;
		while (TRUE) {
			xmlNode* _tmp44_ = NULL;
			xmlNode* _tmp45_ = NULL;
			xmlElementType _tmp46_ = 0;
			xmlNode* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			GQuark _tmp51_ = 0U;
			static GQuark _tmp50_label0 = 0;
			static GQuark _tmp50_label1 = 0;
			static GQuark _tmp50_label2 = 0;
			static GQuark _tmp50_label3 = 0;
			static GQuark _tmp50_label4 = 0;
			if (!_tmp41_) {
				xmlNode* _tmp42_ = NULL;
				xmlNode* _tmp43_ = NULL;
				_tmp42_ = xmlnode;
				_tmp43_ = _tmp42_->next;
				xmlnode = _tmp43_;
			}
			_tmp41_ = FALSE;
			_tmp44_ = xmlnode;
			if (!(_tmp44_ != NULL)) {
				break;
			}
			_tmp45_ = xmlnode;
			_tmp46_ = _tmp45_->type;
			if (_tmp46_ != XML_ELEMENT_NODE) {
				continue;
			}
			_tmp47_ = xmlnode;
			_tmp48_ = _tmp47_->name;
			_tmp49_ = _tmp48_;
			_tmp51_ = (NULL == _tmp49_) ? 0 : g_quark_from_string (_tmp49_);
			if (_tmp51_ == ((0 != _tmp50_label0) ? _tmp50_label0 : (_tmp50_label0 = g_quark_from_static_string ("metadata")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp52_ = NULL;
								xmlNode* _tmp53_ = NULL;
								_tmp52_ = xmlnode;
								_tmp53_ = _tmp52_->children;
								xmldata = _tmp53_;
								{
									gboolean _tmp54_ = FALSE;
									_tmp54_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp57_ = NULL;
										xmlNode* _tmp58_ = NULL;
										xmlElementType _tmp59_ = 0;
										xmlNode* _tmp60_ = NULL;
										const gchar* _tmp61_ = NULL;
										const gchar* _tmp62_ = NULL;
										GQuark _tmp64_ = 0U;
										static GQuark _tmp63_label0 = 0;
										if (!_tmp54_) {
											xmlNode* _tmp55_ = NULL;
											xmlNode* _tmp56_ = NULL;
											_tmp55_ = xmldata;
											_tmp56_ = _tmp55_->next;
											xmldata = _tmp56_;
										}
										_tmp54_ = FALSE;
										_tmp57_ = xmldata;
										if (!(_tmp57_ != NULL)) {
											break;
										}
										_tmp58_ = xmldata;
										_tmp59_ = _tmp58_->type;
										if (_tmp59_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp60_ = xmldata;
										_tmp61_ = _tmp60_->name;
										_tmp62_ = _tmp61_;
										_tmp64_ = (NULL == _tmp62_) ? 0 : g_quark_from_string (_tmp62_);
										if (_tmp64_ == ((0 != _tmp63_label0) ? _tmp63_label0 : (_tmp63_label0 = g_quark_from_static_string ("version")))) {
											switch (0) {
												default:
												{
													{
														{
															xmlAttr* xmlattr = NULL;
															xmlNode* _tmp65_ = NULL;
															xmlAttr* _tmp66_ = NULL;
															_tmp65_ = xmldata;
															_tmp66_ = _tmp65_->properties;
															xmlattr = _tmp66_;
															{
																gboolean _tmp67_ = FALSE;
																_tmp67_ = TRUE;
																while (TRUE) {
																	xmlAttr* _tmp70_ = NULL;
																	xmlAttr* _tmp71_ = NULL;
																	const gchar* _tmp72_ = NULL;
																	const gchar* _tmp73_ = NULL;
																	GQuark _tmp75_ = 0U;
																	static GQuark _tmp74_label0 = 0;
																	if (!_tmp67_) {
																		xmlAttr* _tmp68_ = NULL;
																		xmlAttr* _tmp69_ = NULL;
																		_tmp68_ = xmlattr;
																		_tmp69_ = _tmp68_->next;
																		xmlattr = _tmp69_;
																	}
																	_tmp67_ = FALSE;
																	_tmp70_ = xmlattr;
																	if (!(_tmp70_ != NULL)) {
																		break;
																	}
																	_tmp71_ = xmlattr;
																	_tmp72_ = _tmp71_->name;
																	_tmp73_ = _tmp72_;
																	_tmp75_ = (NULL == _tmp73_) ? 0 : g_quark_from_string (_tmp73_);
																	if (_tmp75_ == ((0 != _tmp74_label0) ? _tmp74_label0 : (_tmp74_label0 = g_quark_from_static_string ("smartsim")))) {
																		switch (0) {
																			default:
																			{
																				xmlAttr* _tmp76_ = NULL;
																				xmlNode* _tmp77_ = NULL;
																				const gchar* _tmp78_ = NULL;
																				VersionComparison _tmp79_ = 0;
																				_tmp76_ = xmlattr;
																				_tmp77_ = _tmp76_->children;
																				_tmp78_ = _tmp77_->content;
																				_tmp79_ = core_compare_versions (_tmp78_, CORE_shortVersionString);
																				if (_tmp79_ == VERSION_COMPARISON_GREATER) {
																					const gchar* _tmp80_ = NULL;
																					gchar* _tmp81_ = NULL;
																					gchar* _tmp82_ = NULL;
																					gchar* _tmp83_ = NULL;
																					gchar* _tmp84_ = NULL;
																					gboolean _tmp85_ = FALSE;
																					gboolean _tmp86_ = FALSE;
																					_tmp80_ = filename;
																					_tmp81_ = g_strconcat ("Project File: \"", _tmp80_, NULL);
																					_tmp82_ = _tmp81_;
																					_tmp83_ = g_strconcat (_tmp82_, "\"", NULL);
																					_tmp84_ = _tmp83_;
																					_tmp85_ = core_version_ignored (_tmp84_);
																					_tmp86_ = _tmp85_ == FALSE;
																					_g_free0 (_tmp84_);
																					_g_free0 (_tmp82_);
																					if (_tmp86_) {
																						GError* _tmp87_ = NULL;
																						_tmp87_ = g_error_new_literal (PROJECT_LOAD_ERROR, PROJECT_LOAD_ERROR_CANCEL, "SmartSim version of project is higher than running version.");
																						_inner_error_ = _tmp87_;
																						if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
																							g_propagate_error (error, _inner_error_);
																							_project_unref0 (self);
																							return NULL;
																						} else {
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																							g_clear_error (&_inner_error_);
																							return NULL;
																						}
																					}
																				}
																				break;
																			}
																		}
																	}
																}
															}
														}
													}
													break;
												}
											}
										}
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp51_ == ((0 != _tmp50_label1) ? _tmp50_label1 : (_tmp50_label1 = g_quark_from_static_string ("name")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp88_ = NULL;
								xmlNode* _tmp89_ = NULL;
								_tmp88_ = xmlnode;
								_tmp89_ = _tmp88_->children;
								xmldata = _tmp89_;
								{
									gboolean _tmp90_ = FALSE;
									_tmp90_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp93_ = NULL;
										xmlNode* _tmp94_ = NULL;
										xmlElementType _tmp95_ = 0;
										xmlNode* _tmp96_ = NULL;
										const gchar* _tmp97_ = NULL;
										if (!_tmp90_) {
											xmlNode* _tmp91_ = NULL;
											xmlNode* _tmp92_ = NULL;
											_tmp91_ = xmldata;
											_tmp92_ = _tmp91_->next;
											xmldata = _tmp92_;
										}
										_tmp90_ = FALSE;
										_tmp93_ = xmldata;
										if (!(_tmp93_ != NULL)) {
											break;
										}
										_tmp94_ = xmlnode;
										_tmp95_ = _tmp94_->type;
										if (_tmp95_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp96_ = xmldata;
										_tmp97_ = _tmp96_->content;
										project_set_name (self, _tmp97_);
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp51_ == ((0 != _tmp50_label2) ? _tmp50_label2 : (_tmp50_label2 = g_quark_from_static_string ("description")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp98_ = NULL;
								xmlNode* _tmp99_ = NULL;
								_tmp98_ = xmlnode;
								_tmp99_ = _tmp98_->children;
								xmldata = _tmp99_;
								{
									gboolean _tmp100_ = FALSE;
									_tmp100_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp103_ = NULL;
										xmlNode* _tmp104_ = NULL;
										xmlElementType _tmp105_ = 0;
										xmlNode* _tmp106_ = NULL;
										const gchar* _tmp107_ = NULL;
										gchar* _tmp108_ = NULL;
										if (!_tmp100_) {
											xmlNode* _tmp101_ = NULL;
											xmlNode* _tmp102_ = NULL;
											_tmp101_ = xmldata;
											_tmp102_ = _tmp101_->next;
											xmldata = _tmp102_;
										}
										_tmp100_ = FALSE;
										_tmp103_ = xmldata;
										if (!(_tmp103_ != NULL)) {
											break;
										}
										_tmp104_ = xmlnode;
										_tmp105_ = _tmp104_->type;
										if (_tmp105_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp106_ = xmldata;
										_tmp107_ = _tmp106_->content;
										_tmp108_ = g_strdup (_tmp107_);
										_g_free0 (self->description);
										self->description = _tmp108_;
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp51_ == ((0 != _tmp50_label3) ? _tmp50_label3 : (_tmp50_label3 = g_quark_from_static_string ("component")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp109_ = NULL;
								xmlNode* _tmp110_ = NULL;
								_tmp109_ = xmlnode;
								_tmp110_ = _tmp109_->children;
								xmldata = _tmp110_;
								{
									gboolean _tmp111_ = FALSE;
									_tmp111_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp114_ = NULL;
										xmlNode* _tmp115_ = NULL;
										xmlElementType _tmp116_ = 0;
										gchar* componentFilename = NULL;
										xmlNode* _tmp117_ = NULL;
										const gchar* _tmp118_ = NULL;
										gchar* _tmp119_ = NULL;
										FILE* _tmp120_ = NULL;
										const gchar* _tmp121_ = NULL;
										const gchar* _tmp122_ = NULL;
										gchar* _tmp123_ = NULL;
										gchar* _tmp124_ = NULL;
										CustomComponentDef* component = NULL;
										const gchar* _tmp125_ = NULL;
										gchar* _tmp126_ = NULL;
										gchar* _tmp127_ = NULL;
										CustomComponentDef* _tmp128_ = NULL;
										CustomComponentDef* _tmp129_ = NULL;
										CustomComponentDef* _tmp130_ = NULL;
										if (!_tmp111_) {
											xmlNode* _tmp112_ = NULL;
											xmlNode* _tmp113_ = NULL;
											_tmp112_ = xmldata;
											_tmp113_ = _tmp112_->next;
											xmldata = _tmp113_;
										}
										_tmp111_ = FALSE;
										_tmp114_ = xmldata;
										if (!(_tmp114_ != NULL)) {
											break;
										}
										_tmp115_ = xmlnode;
										_tmp116_ = _tmp115_->type;
										if (_tmp116_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp117_ = xmldata;
										_tmp118_ = _tmp117_->content;
										_tmp119_ = g_strdup (_tmp118_);
										componentFilename = _tmp119_;
										_tmp120_ = stdout;
										_tmp121_ = componentFilename;
										_tmp122_ = componentFilename;
										_tmp123_ = project_absolute_filename (self, _tmp122_);
										_tmp124_ = _tmp123_;
										fprintf (_tmp120_, "Absolute path of file \"%s\" is \"%s\"\n", _tmp121_, _tmp124_);
										_g_free0 (_tmp124_);
										_tmp125_ = componentFilename;
										_tmp126_ = project_absolute_filename (self, _tmp125_);
										_tmp127_ = _tmp126_;
										_tmp128_ = project_load_component (self, _tmp127_);
										_tmp129_ = _tmp128_;
										_g_free0 (_tmp127_);
										component = _tmp129_;
										_tmp130_ = component;
										if (_tmp130_ != NULL) {
											{
												xmlAttr* xmlattr = NULL;
												xmlNode* _tmp131_ = NULL;
												xmlAttr* _tmp132_ = NULL;
												_tmp131_ = xmlnode;
												_tmp132_ = _tmp131_->properties;
												xmlattr = _tmp132_;
												{
													gboolean _tmp133_ = FALSE;
													_tmp133_ = TRUE;
													while (TRUE) {
														xmlAttr* _tmp136_ = NULL;
														xmlAttr* _tmp137_ = NULL;
														const gchar* _tmp138_ = NULL;
														const gchar* _tmp139_ = NULL;
														GQuark _tmp141_ = 0U;
														static GQuark _tmp140_label0 = 0;
														if (!_tmp133_) {
															xmlAttr* _tmp134_ = NULL;
															xmlAttr* _tmp135_ = NULL;
															_tmp134_ = xmlattr;
															_tmp135_ = _tmp134_->next;
															xmlattr = _tmp135_;
														}
														_tmp133_ = FALSE;
														_tmp136_ = xmlattr;
														if (!(_tmp136_ != NULL)) {
															break;
														}
														_tmp137_ = xmlattr;
														_tmp138_ = _tmp137_->name;
														_tmp139_ = _tmp138_;
														_tmp141_ = (NULL == _tmp139_) ? 0 : g_quark_from_string (_tmp139_);
														if (_tmp141_ == ((0 != _tmp140_label0) ? _tmp140_label0 : (_tmp140_label0 = g_quark_from_static_string ("root")))) {
															switch (0) {
																default:
																{
																	xmlAttr* _tmp142_ = NULL;
																	xmlNode* _tmp143_ = NULL;
																	const gchar* _tmp144_ = NULL;
																	gboolean _tmp145_ = FALSE;
																	_tmp142_ = xmlattr;
																	_tmp143_ = _tmp142_->children;
																	_tmp144_ = _tmp143_->content;
																	_tmp145_ = bool_parse (_tmp144_);
																	if (_tmp145_) {
																		CustomComponentDef* _tmp146_ = NULL;
																		_tmp146_ = component;
																		project_set_root_component (self, _tmp146_);
																	}
																	break;
																}
															}
														}
													}
												}
											}
										}
										_component_def_unref0 (component);
										_g_free0 (componentFilename);
									}
								}
							}
						}
						break;
					}
				}
			} else if (_tmp51_ == ((0 != _tmp50_label4) ? _tmp50_label4 : (_tmp50_label4 = g_quark_from_static_string ("plugin")))) {
				switch (0) {
					default:
					{
						{
							{
								xmlNode* xmldata = NULL;
								xmlNode* _tmp147_ = NULL;
								xmlNode* _tmp148_ = NULL;
								_tmp147_ = xmlnode;
								_tmp148_ = _tmp147_->children;
								xmldata = _tmp148_;
								{
									gboolean _tmp149_ = FALSE;
									_tmp149_ = TRUE;
									while (TRUE) {
										xmlNode* _tmp152_ = NULL;
										xmlNode* _tmp153_ = NULL;
										xmlElementType _tmp154_ = 0;
										gchar* componentFilename = NULL;
										xmlNode* _tmp155_ = NULL;
										const gchar* _tmp156_ = NULL;
										gchar* _tmp157_ = NULL;
										const gchar* _tmp158_ = NULL;
										gchar* _tmp159_ = NULL;
										gchar* _tmp160_ = NULL;
										gchar* _tmp161_ = NULL;
										gchar* _tmp162_ = NULL;
										gboolean _tmp163_ = FALSE;
										gboolean _tmp164_ = FALSE;
										FILE* _tmp166_ = NULL;
										const gchar* _tmp167_ = NULL;
										const gchar* _tmp168_ = NULL;
										gchar* _tmp169_ = NULL;
										gchar* _tmp170_ = NULL;
										PluginComponentDef* component = NULL;
										const gchar* _tmp171_ = NULL;
										gchar* _tmp172_ = NULL;
										gchar* _tmp173_ = NULL;
										const gchar* _tmp174_ = NULL;
										gchar* _tmp175_ = NULL;
										gchar* _tmp176_ = NULL;
										PluginComponentDef* _tmp177_ = NULL;
										PluginComponentDef* _tmp178_ = NULL;
										PluginComponentDef* _tmp179_ = NULL;
										if (!_tmp149_) {
											xmlNode* _tmp150_ = NULL;
											xmlNode* _tmp151_ = NULL;
											_tmp150_ = xmldata;
											_tmp151_ = _tmp150_->next;
											xmldata = _tmp151_;
										}
										_tmp149_ = FALSE;
										_tmp152_ = xmldata;
										if (!(_tmp152_ != NULL)) {
											break;
										}
										_tmp153_ = xmlnode;
										_tmp154_ = _tmp153_->type;
										if (_tmp154_ != XML_ELEMENT_NODE) {
											continue;
										}
										_tmp155_ = xmldata;
										_tmp156_ = _tmp155_->content;
										_tmp157_ = g_strdup (_tmp156_);
										componentFilename = _tmp157_;
										_tmp158_ = componentFilename;
										_tmp159_ = g_strconcat ("File: \"", _tmp158_, NULL);
										_tmp160_ = _tmp159_;
										_tmp161_ = g_strconcat (_tmp160_, "\"", NULL);
										_tmp162_ = _tmp161_;
										_tmp163_ = project_plugins_allowed (self, _tmp162_);
										_tmp164_ = _tmp163_ == FALSE;
										_g_free0 (_tmp162_);
										_g_free0 (_tmp160_);
										if (_tmp164_) {
											GError* _tmp165_ = NULL;
											_tmp165_ = g_error_new_literal (PROJECT_LOAD_ERROR, PROJECT_LOAD_ERROR_CANCEL, "Plugins are disabled.");
											_inner_error_ = _tmp165_;
											if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (componentFilename);
												_project_unref0 (self);
												return NULL;
											} else {
												_g_free0 (componentFilename);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_tmp166_ = stdout;
										_tmp167_ = componentFilename;
										_tmp168_ = componentFilename;
										_tmp169_ = project_absolute_filename (self, _tmp168_);
										_tmp170_ = _tmp169_;
										fprintf (_tmp166_, "Absolute path of file \"%s\" is \"%s\"\n", _tmp167_, _tmp170_);
										_g_free0 (_tmp170_);
										_tmp171_ = componentFilename;
										_tmp172_ = project_absolute_filename (self, _tmp171_);
										_tmp173_ = _tmp172_;
										_tmp174_ = componentFilename;
										_tmp175_ = g_strconcat (PACKAGE_DATADIR "plugins/", _tmp174_, NULL);
										_tmp176_ = _tmp175_;
										_tmp177_ = project_load_plugin_component (self, _tmp173_, _tmp176_);
										_tmp178_ = _tmp177_;
										_g_free0 (_tmp176_);
										_g_free0 (_tmp173_);
										component = _tmp178_;
										_tmp179_ = component;
										if (_tmp179_ == NULL) {
											const gchar* _tmp180_ = NULL;
											gchar* _tmp181_ = NULL;
											gchar* _tmp182_ = NULL;
											gchar* _tmp183_ = NULL;
											gchar* _tmp184_ = NULL;
											GError* _tmp185_ = NULL;
											GError* _tmp186_ = NULL;
											_tmp180_ = componentFilename;
											_tmp181_ = g_strconcat ("Error loading plugin from file \"", _tmp180_, NULL);
											_tmp182_ = _tmp181_;
											_tmp183_ = g_strconcat (_tmp182_, "\".", NULL);
											_tmp184_ = _tmp183_;
											_tmp185_ = g_error_new_literal (PROJECT_LOAD_ERROR, PROJECT_LOAD_ERROR_FILE, _tmp184_);
											_tmp186_ = _tmp185_;
											_g_free0 (_tmp184_);
											_g_free0 (_tmp182_);
											_inner_error_ = _tmp186_;
											if (_inner_error_->domain == PROJECT_LOAD_ERROR) {
												g_propagate_error (error, _inner_error_);
												_component_def_unref0 (component);
												_g_free0 (componentFilename);
												_project_unref0 (self);
												return NULL;
											} else {
												_component_def_unref0 (component);
												_g_free0 (componentFilename);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_component_def_unref0 (component);
										_g_free0 (componentFilename);
									}
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	return self;
}


Project* project_new_load (const gchar* filename, GError** error) {
	return project_construct_load (TYPE_PROJECT, filename, error);
}


/**
 * Creates and returns a new designer, associating it with the
 * DesignerWindow //window//.
 */
Designer* project_new_designer (Project* self, DesignerWindow* window) {
	Designer* result = NULL;
	Designer* designer = NULL;
	DesignerWindow* _tmp0_ = NULL;
	Designer* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = window;
	_tmp1_ = designer_new (_tmp0_, self);
	_designer_unref0 (designer);
	designer = _tmp1_;
	project_register_designer (self, designer);
	_tmp2_ = self->priv->designerCount;
	self->priv->designerCount = _tmp2_ + 1;
	result = designer;
	return result;
}


/**
 * Creates and returns a new custom component within the project.
 */
static gpointer _component_def_ref0 (gpointer self) {
	return self ? component_def_ref (self) : NULL;
}


static CustomComponentDef** _vala_array_dup57 (CustomComponentDef** self, int length) {
	CustomComponentDef** result;
	int i;
	result = g_new0 (CustomComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		CustomComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add71 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static CustomComponentDef** _vala_array_dup58 (CustomComponentDef** self, int length) {
	CustomComponentDef** result;
	int i;
	result = g_new0 (CustomComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		CustomComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


CustomComponentDef* project_new_component (Project* self) {
	CustomComponentDef* result = NULL;
	CustomComponentDef* newComponent = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	gint idAdd = 0;
	CustomComponentDef** newCustomComponentDefs = NULL;
	CustomComponentDef** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	CustomComponentDef** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint newCustomComponentDefs_length1 = 0;
	gint _newCustomComponentDefs_size_ = 0;
	CustomComponentDef** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	CustomComponentDef* _tmp15_ = NULL;
	CustomComponentDef* _tmp16_ = NULL;
	CustomComponentDef** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	CustomComponentDef** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = custom_component_def_new (self);
	newComponent = _tmp0_;
	idAdd = 1;
	while (TRUE) {
		CustomComponentDef* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		CustomComponentDef* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		ComponentDef* _tmp8_ = NULL;
		ComponentDef* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp1_ = newComponent;
		_tmp2_ = idAdd;
		_tmp3_ = g_strdup_printf ("%i", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("Untitled Component ", _tmp4_, NULL);
		_g_free0 (((ComponentDef*) _tmp1_)->name);
		((ComponentDef*) _tmp1_)->name = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = newComponent;
		_tmp7_ = ((ComponentDef*) _tmp6_)->name;
		_tmp8_ = project_resolve_def_name (self, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ == NULL;
		_component_def_unref0 (_tmp9_);
		if (_tmp10_) {
			break;
		} else {
			gint _tmp11_ = 0;
			_tmp11_ = idAdd;
			idAdd = _tmp11_ + 1;
		}
	}
	_tmp12_ = self->customComponentDefs;
	_tmp12__length1 = self->customComponentDefs_length1;
	_tmp13_ = (_tmp12_ != NULL) ? _vala_array_dup57 (_tmp12_, _tmp12__length1) : ((gpointer) _tmp12_);
	_tmp13__length1 = _tmp12__length1;
	newCustomComponentDefs = _tmp13_;
	newCustomComponentDefs_length1 = _tmp13__length1;
	_newCustomComponentDefs_size_ = newCustomComponentDefs_length1;
	_tmp14_ = newCustomComponentDefs;
	_tmp14__length1 = newCustomComponentDefs_length1;
	_tmp15_ = newComponent;
	_tmp16_ = _component_def_ref0 (_tmp15_);
	_vala_array_add71 (&newCustomComponentDefs, &newCustomComponentDefs_length1, &_newCustomComponentDefs_size_, _tmp16_);
	_tmp17_ = newCustomComponentDefs;
	_tmp17__length1 = newCustomComponentDefs_length1;
	_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup58 (_tmp17_, _tmp17__length1) : ((gpointer) _tmp17_);
	_tmp18__length1 = _tmp17__length1;
	self->customComponentDefs = (_vala_array_free (self->customComponentDefs, self->customComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	self->customComponentDefs = _tmp18_;
	self->customComponentDefs_length1 = _tmp18__length1;
	project_update_custom_menus (self);
	project_update_plugin_menus (self);
	result = newComponent;
	newCustomComponentDefs = (_vala_array_free (newCustomComponentDefs, newCustomComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	return result;
}


/**
 * If a window is associated with a file with filename //filename//,
 * make it visible and return 1, else return 0.
 */
static gpointer _designer_ref0 (gpointer self) {
	return self ? designer_ref (self) : NULL;
}


gint project_reopen_window_from_file (Project* self, const gchar* filename) {
	gint result = 0;
	Designer** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	CustomComponentDef** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (filename != NULL, 0);
	_tmp0_ = self->priv->designers;
	_tmp0__length1 = self->priv->designers_length1;
	{
		Designer** designer_collection = NULL;
		gint designer_collection_length1 = 0;
		gint _designer_collection_size_ = 0;
		gint designer_it = 0;
		designer_collection = _tmp0_;
		designer_collection_length1 = _tmp0__length1;
		for (designer_it = 0; designer_it < _tmp0__length1; designer_it = designer_it + 1) {
			Designer* _tmp1_ = NULL;
			Designer* designer = NULL;
			_tmp1_ = _designer_ref0 (designer_collection[designer_it]);
			designer = _tmp1_;
			{
				Designer* _tmp2_ = NULL;
				DesignerWindow* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				_tmp2_ = designer;
				_tmp3_ = _tmp2_->window;
				_tmp4_ = _tmp3_->componentFileName;
				_tmp5_ = filename;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					Designer* _tmp6_ = NULL;
					DesignerWindow* _tmp7_ = NULL;
					_tmp6_ = designer;
					_tmp7_ = _tmp6_->window;
					if (_tmp7_ != NULL) {
						Designer* _tmp8_ = NULL;
						DesignerWindow* _tmp9_ = NULL;
						gboolean _tmp10_ = FALSE;
						gboolean _tmp11_ = FALSE;
						Designer* _tmp16_ = NULL;
						DesignerWindow* _tmp17_ = NULL;
						_tmp8_ = designer;
						_tmp9_ = _tmp8_->window;
						_tmp10_ = gtk_widget_get_visible ((GtkWidget*) _tmp9_);
						_tmp11_ = _tmp10_;
						if (!_tmp11_) {
							Designer* _tmp12_ = NULL;
							DesignerWindow* _tmp13_ = NULL;
							Designer* _tmp14_ = NULL;
							DesignerWindow* _tmp15_ = NULL;
							_tmp12_ = designer;
							_tmp13_ = _tmp12_->window;
							gtk_widget_show_all ((GtkWidget*) _tmp13_);
							_tmp14_ = designer;
							_tmp15_ = _tmp14_->window;
							designer_window_register (_tmp15_);
							project_update_custom_menus (self);
							project_update_plugin_menus (self);
						}
						_tmp16_ = designer;
						_tmp17_ = _tmp16_->window;
						gtk_window_present ((GtkWindow*) _tmp17_);
						result = 1;
						_designer_unref0 (designer);
						return result;
					}
				}
				_designer_unref0 (designer);
			}
		}
	}
	_tmp18_ = self->customComponentDefs;
	_tmp18__length1 = self->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp18_;
		customComponentDef_collection_length1 = _tmp18__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp18__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp19_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp19_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp19_;
			{
				CustomComponentDef* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				_tmp20_ = customComponentDef;
				_tmp21_ = ((ComponentDef*) _tmp20_)->filename;
				_tmp22_ = filename;
				if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
					DesignerWindow* window = NULL;
					CustomComponentDef* _tmp23_ = NULL;
					DesignerWindow* _tmp24_ = NULL;
					DesignerWindow* _tmp25_ = NULL;
					_tmp23_ = customComponentDef;
					_tmp24_ = designer_window_new_with_existing_component (self, _tmp23_);
					g_object_ref_sink (_tmp24_);
					window = _tmp24_;
					_tmp25_ = window;
					gtk_window_present ((GtkWindow*) _tmp25_);
					_g_object_unref0 (window);
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	result = 0;
	return result;
}


/**
 * If a window is associated with the custom component
 * //customComponentDef//, make it visible and return 1, else
 * return 0.
 */
static gboolean _vala_custom_component_def_array_contains (CustomComponentDef** stack, int stack_length, CustomComponentDef* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


gint project_reopen_window_from_component (Project* self, CustomComponentDef* customComponentDef) {
	gint result = 0;
	Designer** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	CustomComponentDef* _tmp17_ = NULL;
	CustomComponentDef** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (customComponentDef != NULL, 0);
	_tmp0_ = self->priv->designers;
	_tmp0__length1 = self->priv->designers_length1;
	{
		Designer** designer_collection = NULL;
		gint designer_collection_length1 = 0;
		gint _designer_collection_size_ = 0;
		gint designer_it = 0;
		designer_collection = _tmp0_;
		designer_collection_length1 = _tmp0__length1;
		for (designer_it = 0; designer_it < _tmp0__length1; designer_it = designer_it + 1) {
			Designer* _tmp1_ = NULL;
			Designer* designer = NULL;
			_tmp1_ = _designer_ref0 (designer_collection[designer_it]);
			designer = _tmp1_;
			{
				Designer* _tmp2_ = NULL;
				CustomComponentDef* _tmp3_ = NULL;
				CustomComponentDef* _tmp4_ = NULL;
				_tmp2_ = designer;
				_tmp3_ = _tmp2_->customComponentDef;
				_tmp4_ = customComponentDef;
				if (_tmp3_ == _tmp4_) {
					Designer* _tmp5_ = NULL;
					DesignerWindow* _tmp6_ = NULL;
					_tmp5_ = designer;
					_tmp6_ = _tmp5_->window;
					if (_tmp6_ != NULL) {
						Designer* _tmp7_ = NULL;
						DesignerWindow* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
						gboolean _tmp10_ = FALSE;
						Designer* _tmp15_ = NULL;
						DesignerWindow* _tmp16_ = NULL;
						_tmp7_ = designer;
						_tmp8_ = _tmp7_->window;
						_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
						_tmp10_ = _tmp9_;
						if (!_tmp10_) {
							Designer* _tmp11_ = NULL;
							DesignerWindow* _tmp12_ = NULL;
							Designer* _tmp13_ = NULL;
							DesignerWindow* _tmp14_ = NULL;
							_tmp11_ = designer;
							_tmp12_ = _tmp11_->window;
							gtk_widget_show_all ((GtkWidget*) _tmp12_);
							_tmp13_ = designer;
							_tmp14_ = _tmp13_->window;
							designer_window_register (_tmp14_);
							project_update_custom_menus (self);
							project_update_plugin_menus (self);
						}
						_tmp15_ = designer;
						_tmp16_ = _tmp15_->window;
						gtk_window_present ((GtkWindow*) _tmp16_);
						result = 1;
						_designer_unref0 (designer);
						return result;
					}
				}
				_designer_unref0 (designer);
			}
		}
	}
	_tmp17_ = customComponentDef;
	_tmp18_ = self->customComponentDefs;
	_tmp18__length1 = self->customComponentDefs_length1;
	if (_vala_custom_component_def_array_contains (_tmp18_, _tmp18__length1, _tmp17_)) {
		DesignerWindow* window = NULL;
		CustomComponentDef* _tmp19_ = NULL;
		DesignerWindow* _tmp20_ = NULL;
		DesignerWindow* _tmp21_ = NULL;
		_tmp19_ = customComponentDef;
		_tmp20_ = designer_window_new_with_existing_component (self, _tmp19_);
		g_object_ref_sink (_tmp20_);
		window = _tmp20_;
		_tmp21_ = window;
		gtk_window_present ((GtkWindow*) _tmp21_);
		_g_object_unref0 (window);
	}
	result = 0;
	return result;
}


gint project_destroy_all_windows (Project* self) {
	gint result = 0;
	Designer** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->designers;
	_tmp0__length1 = self->priv->designers_length1;
	{
		Designer** designer_collection = NULL;
		gint designer_collection_length1 = 0;
		gint _designer_collection_size_ = 0;
		gint designer_it = 0;
		designer_collection = _tmp0_;
		designer_collection_length1 = _tmp0__length1;
		for (designer_it = 0; designer_it < _tmp0__length1; designer_it = designer_it + 1) {
			Designer* _tmp1_ = NULL;
			Designer* designer = NULL;
			_tmp1_ = _designer_ref0 (designer_collection[designer_it]);
			designer = _tmp1_;
			{
				Designer* _tmp2_ = NULL;
				DesignerWindow* _tmp3_ = NULL;
				_tmp2_ = designer;
				_tmp3_ = _tmp2_->window;
				if (_tmp3_ != NULL) {
					Designer* _tmp4_ = NULL;
					DesignerWindow* _tmp5_ = NULL;
					_tmp4_ = designer;
					_tmp5_ = _tmp4_->window;
					designer_window_force_destroy_window (_tmp5_);
				}
				_designer_unref0 (designer);
			}
		}
	}
	result = 0;
	return result;
}


/**
 * Loads and returns a component from the file //fileName//. Returns
 * null on failure.
 */
static CustomComponentDef** _vala_array_dup59 (CustomComponentDef** self, int length) {
	CustomComponentDef** result;
	int i;
	result = g_new0 (CustomComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		CustomComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add72 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static CustomComponentDef** _vala_array_dup60 (CustomComponentDef** self, int length) {
	CustomComponentDef** result;
	int i;
	result = g_new0 (CustomComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		CustomComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


CustomComponentDef* project_load_component (Project* self, const gchar* fileName) {
	CustomComponentDef* result = NULL;
	CustomComponentDef* newComponent = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fileName != NULL, NULL);
	{
		CustomComponentDef* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		CustomComponentDef* _tmp2_ = NULL;
		CustomComponentDef* _tmp3_ = NULL;
		CustomComponentDef** newCustomComponentDefs = NULL;
		CustomComponentDef** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		CustomComponentDef** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint newCustomComponentDefs_length1 = 0;
		gint _newCustomComponentDefs_size_ = 0;
		CustomComponentDef** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		CustomComponentDef* _tmp7_ = NULL;
		CustomComponentDef* _tmp8_ = NULL;
		CustomComponentDef** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		CustomComponentDef** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp1_ = fileName;
		_tmp2_ = custom_component_def_new_from_file (_tmp1_, self, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch59_component_def_load_error;
			}
			if (_inner_error_->domain == CUSTOM_COMPONENT_DEF_LOAD_ERROR) {
				goto __catch59_custom_component_def_load_error;
			}
			_component_def_unref0 (newComponent);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_component_def_unref0 (newComponent);
		newComponent = _tmp3_;
		_tmp4_ = self->customComponentDefs;
		_tmp4__length1 = self->customComponentDefs_length1;
		_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup59 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
		_tmp5__length1 = _tmp4__length1;
		newCustomComponentDefs = _tmp5_;
		newCustomComponentDefs_length1 = _tmp5__length1;
		_newCustomComponentDefs_size_ = newCustomComponentDefs_length1;
		_tmp6_ = newCustomComponentDefs;
		_tmp6__length1 = newCustomComponentDefs_length1;
		_tmp7_ = newComponent;
		_tmp8_ = _component_def_ref0 (_tmp7_);
		_vala_array_add72 (&newCustomComponentDefs, &newCustomComponentDefs_length1, &_newCustomComponentDefs_size_, _tmp8_);
		_tmp9_ = newCustomComponentDefs;
		_tmp9__length1 = newCustomComponentDefs_length1;
		_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup60 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
		_tmp10__length1 = _tmp9__length1;
		self->customComponentDefs = (_vala_array_free (self->customComponentDefs, self->customComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		self->customComponentDefs = _tmp10_;
		self->customComponentDefs_length1 = _tmp10__length1;
		project_update_custom_menus (self);
		project_update_plugin_menus (self);
		newCustomComponentDefs = (_vala_array_free (newCustomComponentDefs, newCustomComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		_component_def_unref0 (_tmp0_);
	}
	goto __finally59;
	__catch59_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strconcat ("Could not load custom component: \n", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		basic_dialog_error (NULL, _tmp14_);
		_g_free0 (_tmp14_);
		_component_def_unref0 (newComponent);
		newComponent = NULL;
		_g_error_free0 (_error_);
	}
	goto __finally59;
	__catch59_custom_component_def_load_error:
	{
		GError* _error_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		_tmp17_ = g_strconcat ("Could not load custom component: \n", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		basic_dialog_error (NULL, _tmp18_);
		_g_free0 (_tmp18_);
		_component_def_unref0 (newComponent);
		newComponent = NULL;
		_g_error_free0 (_error_);
	}
	__finally59:
	if (_inner_error_ != NULL) {
		_component_def_unref0 (newComponent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = newComponent;
	return result;
}


/**
 * Loads and returns a plugin component from the file //fileName//.
 * Returns null on failure.
 */
static gpointer _plugin_component_manager_ref0 (gpointer self) {
	return self ? plugin_component_manager_ref (self) : NULL;
}


static PluginComponentDef** _vala_array_dup61 (PluginComponentDef** self, int length) {
	PluginComponentDef** result;
	int i;
	result = g_new0 (PluginComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static PluginComponentManager** _vala_array_dup62 (PluginComponentManager** self, int length) {
	PluginComponentManager** result;
	int i;
	result = g_new0 (PluginComponentManager*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentManager* _tmp0_ = NULL;
		_tmp0_ = _plugin_component_manager_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add73 (PluginComponentDef*** array, int* length, int* size, PluginComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add74 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentManager*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PluginComponentDef** _vala_array_dup63 (PluginComponentDef** self, int length) {
	PluginComponentDef** result;
	int i;
	result = g_new0 (PluginComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static PluginComponentManager** _vala_array_dup64 (PluginComponentManager** self, int length) {
	PluginComponentManager** result;
	int i;
	result = g_new0 (PluginComponentManager*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentManager* _tmp0_ = NULL;
		_tmp0_ = _plugin_component_manager_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static PluginComponentDef** _vala_array_dup65 (PluginComponentDef** self, int length) {
	PluginComponentDef** result;
	int i;
	result = g_new0 (PluginComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static PluginComponentManager** _vala_array_dup66 (PluginComponentManager** self, int length) {
	PluginComponentManager** result;
	int i;
	result = g_new0 (PluginComponentManager*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentManager* _tmp0_ = NULL;
		_tmp0_ = _plugin_component_manager_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add75 (PluginComponentDef*** array, int* length, int* size, PluginComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add76 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentManager*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PluginComponentDef** _vala_array_dup67 (PluginComponentDef** self, int length) {
	PluginComponentDef** result;
	int i;
	result = g_new0 (PluginComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static PluginComponentManager** _vala_array_dup68 (PluginComponentManager** self, int length) {
	PluginComponentManager** result;
	int i;
	result = g_new0 (PluginComponentManager*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentManager* _tmp0_ = NULL;
		_tmp0_ = _plugin_component_manager_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


PluginComponentDef* project_load_plugin_component (Project* self, const gchar* filename, const gchar* altFilename) {
	PluginComponentDef* result = NULL;
	PluginComponentDef* newComponent = NULL;
	PluginComponentManager* newManager = NULL;
	PluginComponentManager** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp10_ = NULL;
	PluginComponentManager* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	PluginComponentManager* _tmp13_ = NULL;
	PluginComponentManager* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	newComponent = NULL;
	newManager = NULL;
	_tmp0_ = self->pluginComponentManagers;
	_tmp0__length1 = self->pluginComponentManagers_length1;
	{
		PluginComponentManager** pluginComponentManager_collection = NULL;
		gint pluginComponentManager_collection_length1 = 0;
		gint _pluginComponentManager_collection_size_ = 0;
		gint pluginComponentManager_it = 0;
		pluginComponentManager_collection = _tmp0_;
		pluginComponentManager_collection_length1 = _tmp0__length1;
		for (pluginComponentManager_it = 0; pluginComponentManager_it < _tmp0__length1; pluginComponentManager_it = pluginComponentManager_it + 1) {
			PluginComponentManager* _tmp1_ = NULL;
			PluginComponentManager* pluginComponentManager = NULL;
			_tmp1_ = _plugin_component_manager_ref0 (pluginComponentManager_collection[pluginComponentManager_it]);
			pluginComponentManager = _tmp1_;
			{
				PluginComponentManager* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				_tmp2_ = pluginComponentManager;
				_tmp3_ = _tmp2_->filename;
				_tmp4_ = filename;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					const gchar* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					_tmp5_ = filename;
					_tmp6_ = g_strconcat ("The plugin component with filename \"", _tmp5_, NULL);
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strconcat (_tmp7_, "\" is already loaded in this project.\n", NULL);
					_tmp9_ = _tmp8_;
					basic_dialog_error (NULL, _tmp9_);
					_g_free0 (_tmp9_);
					_g_free0 (_tmp7_);
					result = NULL;
					_plugin_component_manager_unref0 (pluginComponentManager);
					_plugin_component_manager_unref0 (newManager);
					_component_def_unref0 (newComponent);
					return result;
				}
				_plugin_component_manager_unref0 (pluginComponentManager);
			}
		}
	}
	_tmp10_ = filename;
	_tmp11_ = plugin_component_manager_from_filename (_tmp10_);
	_plugin_component_manager_unref0 (newManager);
	newManager = _tmp11_;
	_tmp13_ = newManager;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = altFilename;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp15_ = NULL;
		PluginComponentManager* _tmp16_ = NULL;
		_tmp15_ = altFilename;
		_tmp16_ = plugin_component_manager_from_filename (_tmp15_);
		_plugin_component_manager_unref0 (newManager);
		newManager = _tmp16_;
	}
	_tmp17_ = newManager;
	if (_tmp17_ != NULL) {
		PluginComponentManager* _tmp18_ = NULL;
		PluginComponentDef* _tmp19_ = NULL;
		PluginComponentDef* _tmp20_ = NULL;
		PluginComponentDef** newPluginComponentDefs = NULL;
		PluginComponentDef** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		PluginComponentDef** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		gint newPluginComponentDefs_length1 = 0;
		gint _newPluginComponentDefs_size_ = 0;
		PluginComponentManager** newPluginComponentManagers = NULL;
		PluginComponentManager** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		PluginComponentManager** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gint newPluginComponentManagers_length1 = 0;
		gint _newPluginComponentManagers_size_ = 0;
		PluginComponentDef** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		PluginComponentDef* _tmp26_ = NULL;
		PluginComponentDef* _tmp27_ = NULL;
		PluginComponentManager** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		PluginComponentManager* _tmp29_ = NULL;
		PluginComponentManager* _tmp30_ = NULL;
		PluginComponentDef** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		PluginComponentDef** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		PluginComponentManager** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		PluginComponentManager** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		_tmp18_ = newManager;
		_tmp19_ = _tmp18_->pluginComponentDef;
		_tmp20_ = _component_def_ref0 (_tmp19_);
		_component_def_unref0 (newComponent);
		newComponent = _tmp20_;
		_tmp21_ = self->pluginComponentDefs;
		_tmp21__length1 = self->pluginComponentDefs_length1;
		_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup61 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
		_tmp22__length1 = _tmp21__length1;
		newPluginComponentDefs = _tmp22_;
		newPluginComponentDefs_length1 = _tmp22__length1;
		_newPluginComponentDefs_size_ = newPluginComponentDefs_length1;
		_tmp23_ = self->pluginComponentManagers;
		_tmp23__length1 = self->pluginComponentManagers_length1;
		_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup62 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
		_tmp24__length1 = _tmp23__length1;
		newPluginComponentManagers = _tmp24_;
		newPluginComponentManagers_length1 = _tmp24__length1;
		_newPluginComponentManagers_size_ = newPluginComponentManagers_length1;
		_tmp25_ = newPluginComponentDefs;
		_tmp25__length1 = newPluginComponentDefs_length1;
		_tmp26_ = newComponent;
		_tmp27_ = _component_def_ref0 (_tmp26_);
		_vala_array_add73 (&newPluginComponentDefs, &newPluginComponentDefs_length1, &_newPluginComponentDefs_size_, _tmp27_);
		_tmp28_ = newPluginComponentManagers;
		_tmp28__length1 = newPluginComponentManagers_length1;
		_tmp29_ = newManager;
		_tmp30_ = _plugin_component_manager_ref0 (_tmp29_);
		_vala_array_add74 (&newPluginComponentManagers, &newPluginComponentManagers_length1, &_newPluginComponentManagers_size_, _tmp30_);
		_tmp31_ = newPluginComponentDefs;
		_tmp31__length1 = newPluginComponentDefs_length1;
		_tmp32_ = (_tmp31_ != NULL) ? _vala_array_dup63 (_tmp31_, _tmp31__length1) : ((gpointer) _tmp31_);
		_tmp32__length1 = _tmp31__length1;
		self->pluginComponentDefs = (_vala_array_free (self->pluginComponentDefs, self->pluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		self->pluginComponentDefs = _tmp32_;
		self->pluginComponentDefs_length1 = _tmp32__length1;
		_tmp33_ = newPluginComponentManagers;
		_tmp33__length1 = newPluginComponentManagers_length1;
		_tmp34_ = (_tmp33_ != NULL) ? _vala_array_dup64 (_tmp33_, _tmp33__length1) : ((gpointer) _tmp33_);
		_tmp34__length1 = _tmp33__length1;
		self->pluginComponentManagers = (_vala_array_free (self->pluginComponentManagers, self->pluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
		self->pluginComponentManagers = _tmp34_;
		self->pluginComponentManagers_length1 = _tmp34__length1;
		project_update_plugin_menus (self);
		result = newComponent;
		newPluginComponentManagers = (_vala_array_free (newPluginComponentManagers, newPluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
		newPluginComponentDefs = (_vala_array_free (newPluginComponentDefs, newPluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		_plugin_component_manager_unref0 (newManager);
		return result;
	}
	{
		PluginComponentManager* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		PluginComponentManager* _tmp37_ = NULL;
		PluginComponentManager* _tmp38_ = NULL;
		PluginComponentManager* _tmp39_ = NULL;
		PluginComponentDef* _tmp40_ = NULL;
		PluginComponentDef* _tmp41_ = NULL;
		PluginComponentDef** newPluginComponentDefs = NULL;
		PluginComponentDef** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		PluginComponentDef** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gint newPluginComponentDefs_length1 = 0;
		gint _newPluginComponentDefs_size_ = 0;
		PluginComponentManager** newPluginComponentManagers = NULL;
		PluginComponentManager** _tmp44_ = NULL;
		gint _tmp44__length1 = 0;
		PluginComponentManager** _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		gint newPluginComponentManagers_length1 = 0;
		gint _newPluginComponentManagers_size_ = 0;
		PluginComponentDef** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		PluginComponentDef* _tmp47_ = NULL;
		PluginComponentDef* _tmp48_ = NULL;
		PluginComponentManager** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		PluginComponentManager* _tmp50_ = NULL;
		PluginComponentManager* _tmp51_ = NULL;
		PluginComponentDef** _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		PluginComponentDef** _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		PluginComponentManager** _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		PluginComponentManager** _tmp55_ = NULL;
		gint _tmp55__length1 = 0;
		_tmp36_ = filename;
		_tmp37_ = plugin_component_manager_new_from_file (_tmp36_, self, &_inner_error_);
		_tmp35_ = _tmp37_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == COMPONENT_DEF_LOAD_ERROR) {
				goto __catch60_component_def_load_error;
			}
			if (_inner_error_->domain == PLUGIN_COMPONENT_DEF_LOAD_ERROR) {
				goto __catch60_plugin_component_def_load_error;
			}
			_plugin_component_manager_unref0 (newManager);
			_component_def_unref0 (newComponent);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp38_ = _tmp35_;
		_tmp35_ = NULL;
		_plugin_component_manager_unref0 (newManager);
		newManager = _tmp38_;
		_tmp39_ = newManager;
		_tmp40_ = _tmp39_->pluginComponentDef;
		_tmp41_ = _component_def_ref0 (_tmp40_);
		_component_def_unref0 (newComponent);
		newComponent = _tmp41_;
		_tmp42_ = self->pluginComponentDefs;
		_tmp42__length1 = self->pluginComponentDefs_length1;
		_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup65 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
		_tmp43__length1 = _tmp42__length1;
		newPluginComponentDefs = _tmp43_;
		newPluginComponentDefs_length1 = _tmp43__length1;
		_newPluginComponentDefs_size_ = newPluginComponentDefs_length1;
		_tmp44_ = self->pluginComponentManagers;
		_tmp44__length1 = self->pluginComponentManagers_length1;
		_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup66 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
		_tmp45__length1 = _tmp44__length1;
		newPluginComponentManagers = _tmp45_;
		newPluginComponentManagers_length1 = _tmp45__length1;
		_newPluginComponentManagers_size_ = newPluginComponentManagers_length1;
		_tmp46_ = newPluginComponentDefs;
		_tmp46__length1 = newPluginComponentDefs_length1;
		_tmp47_ = newComponent;
		_tmp48_ = _component_def_ref0 (_tmp47_);
		_vala_array_add75 (&newPluginComponentDefs, &newPluginComponentDefs_length1, &_newPluginComponentDefs_size_, _tmp48_);
		_tmp49_ = newPluginComponentManagers;
		_tmp49__length1 = newPluginComponentManagers_length1;
		_tmp50_ = newManager;
		_tmp51_ = _plugin_component_manager_ref0 (_tmp50_);
		_vala_array_add76 (&newPluginComponentManagers, &newPluginComponentManagers_length1, &_newPluginComponentManagers_size_, _tmp51_);
		_tmp52_ = newPluginComponentDefs;
		_tmp52__length1 = newPluginComponentDefs_length1;
		_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup67 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
		_tmp53__length1 = _tmp52__length1;
		self->pluginComponentDefs = (_vala_array_free (self->pluginComponentDefs, self->pluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		self->pluginComponentDefs = _tmp53_;
		self->pluginComponentDefs_length1 = _tmp53__length1;
		_tmp54_ = newPluginComponentManagers;
		_tmp54__length1 = newPluginComponentManagers_length1;
		_tmp55_ = (_tmp54_ != NULL) ? _vala_array_dup68 (_tmp54_, _tmp54__length1) : ((gpointer) _tmp54_);
		_tmp55__length1 = _tmp54__length1;
		self->pluginComponentManagers = (_vala_array_free (self->pluginComponentManagers, self->pluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
		self->pluginComponentManagers = _tmp55_;
		self->pluginComponentManagers_length1 = _tmp55__length1;
		project_update_plugin_menus (self);
		newPluginComponentManagers = (_vala_array_free (newPluginComponentManagers, newPluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
		newPluginComponentDefs = (_vala_array_free (newPluginComponentDefs, newPluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
		_plugin_component_manager_unref0 (_tmp35_);
	}
	goto __finally60;
	__catch60_component_def_load_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp56_ = FALSE;
		GError* _tmp57_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = _error_;
		if (g_error_matches (_tmp57_, COMPONENT_DEF_LOAD_ERROR, COMPONENT_DEF_LOAD_ERROR_FILE)) {
			const gchar* _tmp58_ = NULL;
			_tmp58_ = altFilename;
			_tmp56_ = _tmp58_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			const gchar* _tmp59_ = NULL;
			PluginComponentDef* _tmp60_ = NULL;
			PluginComponentDef* _tmp61_ = NULL;
			_tmp59_ = altFilename;
			_tmp60_ = project_load_plugin_component (self, _tmp59_, NULL);
			_component_def_unref0 (newComponent);
			newComponent = _tmp60_;
			_tmp61_ = newComponent;
			if (_tmp61_ == NULL) {
				GError* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				_tmp62_ = _error_;
				_tmp63_ = _tmp62_->message;
				_tmp64_ = g_strconcat ("Could not load local plugin component: \n", _tmp63_, NULL);
				_tmp65_ = _tmp64_;
				basic_dialog_error (NULL, _tmp65_);
				_g_free0 (_tmp65_);
			}
		} else {
			GError* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			_tmp66_ = _error_;
			_tmp67_ = _tmp66_->message;
			_tmp68_ = g_strconcat ("Could not load shared plugin component: \n", _tmp67_, NULL);
			_tmp69_ = _tmp68_;
			basic_dialog_error (NULL, _tmp69_);
			_g_free0 (_tmp69_);
		}
		_g_error_free0 (_error_);
	}
	goto __finally60;
	__catch60_plugin_component_def_load_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp70_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp70_ = altFilename;
		if (_tmp70_ == NULL) {
			GError* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_ = NULL;
			_tmp71_ = _error_;
			_tmp72_ = _tmp71_->message;
			_tmp73_ = g_strconcat ("Could not load shared plugin component: \n", _tmp72_, NULL);
			_tmp74_ = _tmp73_;
			basic_dialog_error (NULL, _tmp74_);
			_g_free0 (_tmp74_);
		} else {
			GError* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			_tmp75_ = _error_;
			_tmp76_ = _tmp75_->message;
			_tmp77_ = g_strconcat ("Could not load local plugin component: \n", _tmp76_, NULL);
			_tmp78_ = _tmp77_;
			basic_dialog_error (NULL, _tmp78_);
			_g_free0 (_tmp78_);
		}
		_g_error_free0 (_error_);
	}
	__finally60:
	if (_inner_error_ != NULL) {
		_plugin_component_manager_unref0 (newManager);
		_component_def_unref0 (newComponent);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = newComponent;
	_plugin_component_manager_unref0 (newManager);
	return result;
}


/**
 * Returns the ComponentDef with the name //name//, be it a built-in
 * or custom component.
 */
ComponentDef* project_resolve_def_name (Project* self, const gchar* name) {
	ComponentDef* result = NULL;
	ComponentDef** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	CustomComponentDef** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	PluginComponentDef** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = core_standardComponentDefs;
	_tmp0__length1 = core_standardComponentDefs_length1;
	{
		ComponentDef** componentDef_collection = NULL;
		gint componentDef_collection_length1 = 0;
		gint _componentDef_collection_size_ = 0;
		gint componentDef_it = 0;
		componentDef_collection = _tmp0_;
		componentDef_collection_length1 = _tmp0__length1;
		for (componentDef_it = 0; componentDef_it < _tmp0__length1; componentDef_it = componentDef_it + 1) {
			ComponentDef* _tmp1_ = NULL;
			ComponentDef* componentDef = NULL;
			_tmp1_ = _component_def_ref0 (componentDef_collection[componentDef_it]);
			componentDef = _tmp1_;
			{
				ComponentDef* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp2_ = componentDef;
				_tmp3_ = _tmp2_->name;
				_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) (-1));
				_tmp5_ = _tmp4_;
				_tmp6_ = name;
				_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) (-1));
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strcmp0 (_tmp5_, _tmp8_) == 0;
				_g_free0 (_tmp8_);
				_g_free0 (_tmp5_);
				if (_tmp9_) {
					result = componentDef;
					return result;
				}
				_component_def_unref0 (componentDef);
			}
		}
	}
	_tmp10_ = self->customComponentDefs;
	_tmp10__length1 = self->customComponentDefs_length1;
	{
		CustomComponentDef** componentDef_collection = NULL;
		gint componentDef_collection_length1 = 0;
		gint _componentDef_collection_size_ = 0;
		gint componentDef_it = 0;
		componentDef_collection = _tmp10_;
		componentDef_collection_length1 = _tmp10__length1;
		for (componentDef_it = 0; componentDef_it < _tmp10__length1; componentDef_it = componentDef_it + 1) {
			ComponentDef* _tmp11_ = NULL;
			ComponentDef* componentDef = NULL;
			_tmp11_ = _component_def_ref0 ((ComponentDef*) componentDef_collection[componentDef_it]);
			componentDef = _tmp11_;
			{
				ComponentDef* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				_tmp12_ = componentDef;
				_tmp13_ = _tmp12_->name;
				_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) (-1));
				_tmp15_ = _tmp14_;
				_tmp16_ = name;
				_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) (-1));
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strcmp0 (_tmp15_, _tmp18_) == 0;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				if (_tmp19_) {
					result = componentDef;
					return result;
				}
				_component_def_unref0 (componentDef);
			}
		}
	}
	_tmp20_ = self->pluginComponentDefs;
	_tmp20__length1 = self->pluginComponentDefs_length1;
	{
		PluginComponentDef** componentDef_collection = NULL;
		gint componentDef_collection_length1 = 0;
		gint _componentDef_collection_size_ = 0;
		gint componentDef_it = 0;
		componentDef_collection = _tmp20_;
		componentDef_collection_length1 = _tmp20__length1;
		for (componentDef_it = 0; componentDef_it < _tmp20__length1; componentDef_it = componentDef_it + 1) {
			ComponentDef* _tmp21_ = NULL;
			ComponentDef* componentDef = NULL;
			_tmp21_ = _component_def_ref0 ((ComponentDef*) componentDef_collection[componentDef_it]);
			componentDef = _tmp21_;
			{
				ComponentDef* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
				_tmp22_ = componentDef;
				_tmp23_ = _tmp22_->name;
				_tmp24_ = g_utf8_strdown (_tmp23_, (gssize) (-1));
				_tmp25_ = _tmp24_;
				_tmp26_ = name;
				_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) (-1));
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strcmp0 (_tmp25_, _tmp28_) == 0;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp25_);
				if (_tmp29_) {
					result = componentDef;
					return result;
				}
				_component_def_unref0 (componentDef);
			}
		}
	}
	result = NULL;
	return result;
}


CustomComponentDef* project_get_default_component (Project* self) {
	CustomComponentDef* result = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->rootComponent;
	if (_tmp0_ != NULL) {
		CustomComponentDef* _tmp1_ = NULL;
		CustomComponentDef* _tmp2_ = NULL;
		_tmp1_ = self->rootComponent;
		_tmp2_ = _component_def_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		CustomComponentDef** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp3_ = self->customComponentDefs;
		_tmp3__length1 = self->customComponentDefs_length1;
		if (_tmp3__length1 > 0) {
			CustomComponentDef** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			CustomComponentDef** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			CustomComponentDef* _tmp6_ = NULL;
			CustomComponentDef* _tmp7_ = NULL;
			_tmp4_ = self->customComponentDefs;
			_tmp4__length1 = self->customComponentDefs_length1;
			_tmp5_ = self->customComponentDefs;
			_tmp5__length1 = self->customComponentDefs_length1;
			_tmp6_ = _tmp4_[_tmp5__length1 - 1];
			_tmp7_ = _component_def_ref0 (_tmp6_);
			result = _tmp7_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
}


void project_update_error_modes (Project* self, gboolean _error_) {
	Designer** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->designers;
	_tmp0__length1 = self->priv->designers_length1;
	{
		Designer** designer_collection = NULL;
		gint designer_collection_length1 = 0;
		gint _designer_collection_size_ = 0;
		gint designer_it = 0;
		designer_collection = _tmp0_;
		designer_collection_length1 = _tmp0__length1;
		for (designer_it = 0; designer_it < _tmp0__length1; designer_it = designer_it + 1) {
			Designer* _tmp1_ = NULL;
			Designer* designer = NULL;
			_tmp1_ = _designer_ref0 (designer_collection[designer_it]);
			designer = _tmp1_;
			{
				Designer* _tmp2_ = NULL;
				DesignerWindow* _tmp3_ = NULL;
				_tmp2_ = designer;
				_tmp3_ = _tmp2_->window;
				if (_tmp3_ != NULL) {
					Designer* _tmp4_ = NULL;
					DesignerWindow* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					_tmp4_ = designer;
					_tmp5_ = _tmp4_->window;
					_tmp6_ = _error_;
					designer_window_update_error_mode (_tmp5_, _tmp6_);
				}
				_designer_unref0 (designer);
			}
		}
	}
}


/**
 * Makes all associated windows update their menus listing
 * custom components.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void project_update_custom_menus (Project* self) {
	DesignerWindow** designerWindows = NULL;
	gint _tmp0_ = 0;
	DesignerWindow** _tmp1_ = NULL;
	gint designerWindows_length1 = 0;
	gint _designerWindows_size_ = 0;
	DesignerWindow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = designer_window_get_project_windows (self, &_tmp0_);
	designerWindows = _tmp1_;
	designerWindows_length1 = _tmp0_;
	_designerWindows_size_ = designerWindows_length1;
	_tmp2_ = designerWindows;
	_tmp2__length1 = designerWindows_length1;
	{
		DesignerWindow** designerWindow_collection = NULL;
		gint designerWindow_collection_length1 = 0;
		gint _designerWindow_collection_size_ = 0;
		gint designerWindow_it = 0;
		designerWindow_collection = _tmp2_;
		designerWindow_collection_length1 = _tmp2__length1;
		for (designerWindow_it = 0; designerWindow_it < _tmp2__length1; designerWindow_it = designerWindow_it + 1) {
			DesignerWindow* _tmp3_ = NULL;
			DesignerWindow* designerWindow = NULL;
			_tmp3_ = _g_object_ref0 (designerWindow_collection[designerWindow_it]);
			designerWindow = _tmp3_;
			{
				DesignerWindow* _tmp4_ = NULL;
				_tmp4_ = designerWindow;
				designer_window_update_custom_menu (_tmp4_);
				_g_object_unref0 (designerWindow);
			}
		}
	}
	designerWindows = (_vala_array_free (designerWindows, designerWindows_length1, (GDestroyNotify) g_object_unref), NULL);
}


void project_update_plugin_menus (Project* self) {
	DesignerWindow** designerWindows = NULL;
	gint _tmp0_ = 0;
	DesignerWindow** _tmp1_ = NULL;
	gint designerWindows_length1 = 0;
	gint _designerWindows_size_ = 0;
	DesignerWindow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = designer_window_get_project_windows (self, &_tmp0_);
	designerWindows = _tmp1_;
	designerWindows_length1 = _tmp0_;
	_designerWindows_size_ = designerWindows_length1;
	_tmp2_ = designerWindows;
	_tmp2__length1 = designerWindows_length1;
	{
		DesignerWindow** designerWindow_collection = NULL;
		gint designerWindow_collection_length1 = 0;
		gint _designerWindow_collection_size_ = 0;
		gint designerWindow_it = 0;
		designerWindow_collection = _tmp2_;
		designerWindow_collection_length1 = _tmp2__length1;
		for (designerWindow_it = 0; designerWindow_it < _tmp2__length1; designerWindow_it = designerWindow_it + 1) {
			DesignerWindow* _tmp3_ = NULL;
			DesignerWindow* designerWindow = NULL;
			_tmp3_ = _g_object_ref0 (designerWindow_collection[designerWindow_it]);
			designerWindow = _tmp3_;
			{
				DesignerWindow* _tmp4_ = NULL;
				_tmp4_ = designerWindow;
				designer_window_update_plugin_menu (_tmp4_);
				_g_object_unref0 (designerWindow);
			}
		}
	}
	designerWindows = (_vala_array_free (designerWindows, designerWindows_length1, (GDestroyNotify) g_object_unref), NULL);
}


void project_update_titles (Project* self) {
	Designer** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->designers;
	_tmp0__length1 = self->priv->designers_length1;
	{
		Designer** designer_collection = NULL;
		gint designer_collection_length1 = 0;
		gint _designer_collection_size_ = 0;
		gint designer_it = 0;
		designer_collection = _tmp0_;
		designer_collection_length1 = _tmp0__length1;
		for (designer_it = 0; designer_it < _tmp0__length1; designer_it = designer_it + 1) {
			Designer* _tmp1_ = NULL;
			Designer* designer = NULL;
			_tmp1_ = _designer_ref0 (designer_collection[designer_it]);
			designer = _tmp1_;
			{
				Designer* _tmp2_ = NULL;
				DesignerWindow* _tmp3_ = NULL;
				_tmp2_ = designer;
				_tmp3_ = _tmp2_->window;
				if (_tmp3_ != NULL) {
					Designer* _tmp4_ = NULL;
					DesignerWindow* _tmp5_ = NULL;
					_tmp4_ = designer;
					_tmp5_ = _tmp4_->window;
					designer_window_update_title (_tmp5_);
				}
				_designer_unref0 (designer);
			}
		}
	}
}


/**
 * Checks the validity of the circuit and opens a message dialog to
 * provide information about the validity of the circuit.
 * Returns a CompiledCircuit which has been told to validate.
 * Returns null if there is no root component.
 */
CompiledCircuit* project_validate (Project* self) {
	CompiledCircuit* result = NULL;
	CompiledCircuit* compiledCircuit = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	CustomComponentDef* _tmp2_ = NULL;
	CompiledCircuit* _tmp3_ = NULL;
	CompiledCircuit* _tmp4_ = NULL;
	CompiledCircuit* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	CompiledCircuit* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp27_ = FALSE;
	CompiledCircuit* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->rootComponent;
	if (_tmp0_ == NULL) {
		FILE* _tmp1_ = NULL;
		_tmp1_ = stderr;
		fprintf (_tmp1_, "Cannot validate circuit. Root component unknown.\n");
		basic_dialog_error (NULL, "You must first specify a root component before you can validate your c" \
"ircuit.");
		project_update_error_modes (self, FALSE);
		result = NULL;
		_compiled_circuit_unref0 (compiledCircuit);
		return result;
	}
	_tmp2_ = self->rootComponent;
	_tmp3_ = compiled_circuit_new (self, _tmp2_);
	_compiled_circuit_unref0 (compiledCircuit);
	compiledCircuit = _tmp3_;
	_tmp4_ = compiledCircuit;
	compiled_circuit_check_validity (_tmp4_);
	_tmp5_ = compiledCircuit;
	_tmp6_ = compiled_circuit_get_errorOccurred (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		FILE* _tmp8_ = NULL;
		CompiledCircuit* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp8_ = stdout;
		fprintf (_tmp8_, "Circuit failed validation check.\n");
		_tmp9_ = compiledCircuit;
		_tmp10_ = compiled_circuit_get_errorMessage (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("Circuit failed validation:\n", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "\nNote: Unused components can still cause errors.", NULL);
		_tmp15_ = _tmp14_;
		basic_dialog_warning (NULL, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		project_update_error_modes (self, TRUE);
	}
	_tmp16_ = compiledCircuit;
	_tmp17_ = compiled_circuit_get_warningOccurred (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		FILE* _tmp19_ = NULL;
		CompiledCircuit* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "Circuit failed validation check.\n");
		_tmp20_ = compiledCircuit;
		_tmp21_ = compiled_circuit_get_warningMessage (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("Warning:\n", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "\nNote: Unused components can still cause errors.", NULL);
		_tmp26_ = _tmp25_;
		basic_dialog_warning (NULL, _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		project_update_error_modes (self, FALSE);
	}
	_tmp28_ = compiledCircuit;
	_tmp29_ = compiled_circuit_get_errorOccurred (_tmp28_);
	_tmp30_ = _tmp29_;
	if (!_tmp30_) {
		CompiledCircuit* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		_tmp31_ = compiledCircuit;
		_tmp32_ = compiled_circuit_get_warningOccurred (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp27_ = !_tmp33_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		basic_dialog_information (NULL, "Circuit has passed validation without any errors or warnings.");
		project_update_error_modes (self, FALSE);
	}
	result = compiledCircuit;
	return result;
}


/**
 * Starts the simulation of the circuit and if necessary opens a
 * message dialog to show any errors or warnings. Validates first.
 * Returns a CompiledCircuit which has been used for the simulation.
 * Returns null if there is no root component.
 */
CompiledCircuit* project_run (Project* self, gboolean* startNow) {
	CompiledCircuit* result = NULL;
	CompiledCircuit* compiledCircuit = NULL;
	FILE* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	FILE* _tmp3_ = NULL;
	CustomComponentDef* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CustomComponentDef* _tmp6_ = NULL;
	CompiledCircuit* _tmp7_ = NULL;
	FILE* _tmp8_ = NULL;
	CompiledCircuit* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	FILE* _tmp19_ = NULL;
	FILE* _tmp20_ = NULL;
	CompiledCircuit* _tmp21_ = NULL;
	CompiledCircuit* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	CompiledCircuit* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	FILE* _tmp38_ = NULL;
	SimulatorWindow* simulatorWindow = NULL;
	CompiledCircuit* _tmp39_ = NULL;
	SimulatorWindow* _tmp40_ = NULL;
	FILE* _tmp41_ = NULL;
	gboolean* _tmp42_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking whether Root Component is known...\n");
	_tmp1_ = self->rootComponent;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "Cannot run circuit. Root component unknown.\n");
		basic_dialog_error (NULL, "You must first specify a root component before you can validate your c" \
"ircuit.");
		project_update_error_modes (self, FALSE);
		result = NULL;
		_compiled_circuit_unref0 (compiledCircuit);
		return result;
	}
	_tmp3_ = stdout;
	_tmp4_ = self->rootComponent;
	_tmp5_ = ((ComponentDef*) _tmp4_)->name;
	fprintf (_tmp3_, "Root component is \"%s\".\n", _tmp5_);
	_tmp6_ = self->rootComponent;
	_tmp7_ = compiled_circuit_new (self, _tmp6_);
	_compiled_circuit_unref0 (compiledCircuit);
	compiledCircuit = _tmp7_;
	_tmp8_ = stdout;
	fprintf (_tmp8_, "Validating...\n");
	_tmp9_ = compiledCircuit;
	_tmp10_ = compiled_circuit_check_validity (_tmp9_);
	if (_tmp10_ != 0) {
		FILE* _tmp11_ = NULL;
		CompiledCircuit* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Circuit failed validation check.\n");
		_tmp12_ = compiledCircuit;
		_tmp13_ = compiled_circuit_get_errorMessage (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("Circuit failed validation:\n", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "\nNote: Unused components can still cause errors.", NULL);
		_tmp18_ = _tmp17_;
		basic_dialog_error (NULL, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		project_update_error_modes (self, TRUE);
		result = NULL;
		_compiled_circuit_unref0 (compiledCircuit);
		return result;
	}
	_tmp19_ = stdout;
	fprintf (_tmp19_, "Validated.\n");
	_tmp20_ = stdout;
	fprintf (_tmp20_, "Compiling...\n");
	_tmp21_ = compiledCircuit;
	compiled_circuit_compile (_tmp21_);
	_tmp22_ = compiledCircuit;
	_tmp23_ = compiled_circuit_get_errorOccurred (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		CompiledCircuit* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		_tmp25_ = compiledCircuit;
		_tmp26_ = compiled_circuit_get_errorMessage (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("Circuit appeared to be valid, but failed to compile:\n", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		basic_dialog_error (NULL, _tmp29_);
		_g_free0 (_tmp29_);
		project_update_error_modes (self, TRUE);
		result = NULL;
		_compiled_circuit_unref0 (compiledCircuit);
		return result;
	}
	_tmp30_ = compiledCircuit;
	_tmp31_ = compiled_circuit_get_warningOccurred (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_) {
		CompiledCircuit* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp33_ = compiledCircuit;
		_tmp34_ = compiled_circuit_get_warningMessage (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("Compiled successfully, but there are some warnings:\n", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		basic_dialog_error (NULL, _tmp37_);
		_g_free0 (_tmp37_);
		project_update_error_modes (self, FALSE);
	}
	project_update_error_modes (self, FALSE);
	_tmp38_ = stdout;
	fprintf (_tmp38_, "Compiled.\n");
	_tmp39_ = compiledCircuit;
	_tmp40_ = simulator_window_new (_tmp39_);
	g_object_ref_sink (_tmp40_);
	simulatorWindow = _tmp40_;
	_tmp41_ = stdout;
	fprintf (_tmp41_, "Running Circuit...\n");
	self->running = TRUE;
	_tmp42_ = startNow;
	if (*_tmp42_) {
		SimulatorWindow* _tmp43_ = NULL;
		_tmp43_ = simulatorWindow;
		simulator_window_run (_tmp43_);
	}
	result = compiledCircuit;
	_g_object_unref0 (simulatorWindow);
	return result;
}


/**
 * Sets the root component for the simulation to //rootComponent//.
 */
void project_set_root_component (Project* self, CustomComponentDef* rootComponent) {
	FILE* _tmp0_ = NULL;
	CustomComponentDef* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CustomComponentDef* _tmp3_ = NULL;
	CustomComponentDef* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rootComponent != NULL);
	_tmp0_ = stdout;
	_tmp1_ = rootComponent;
	_tmp2_ = ((ComponentDef*) _tmp1_)->name;
	fprintf (_tmp0_, "Set root component to \"%s\"\n", _tmp2_);
	_tmp3_ = rootComponent;
	_tmp4_ = _component_def_ref0 (_tmp3_);
	_component_def_unref0 (self->rootComponent);
	self->rootComponent = _tmp4_;
}


gint project_save (Project* self, const gchar* filename) {
	gint result = 0;
	gchar* errorMessage = NULL;
	gchar* _tmp0_ = NULL;
	CustomComponentDef** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp24_ = NULL;
	Designer** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	FILE* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	xmlTextWriter* xmlWriter = NULL;
	const gchar* _tmp50_ = NULL;
	xmlTextWriter* _tmp51_ = NULL;
	xmlTextWriter* _tmp52_ = NULL;
	xmlTextWriter* _tmp53_ = NULL;
	xmlTextWriter* _tmp54_ = NULL;
	xmlTextWriter* _tmp55_ = NULL;
	xmlTextWriter* _tmp56_ = NULL;
	xmlTextWriter* _tmp57_ = NULL;
	xmlTextWriter* _tmp58_ = NULL;
	xmlTextWriter* _tmp59_ = NULL;
	xmlTextWriter* _tmp60_ = NULL;
	FILE* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	xmlTextWriter* _tmp65_ = NULL;
	xmlTextWriter* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	FILE* _tmp68_ = NULL;
	xmlTextWriter* _tmp69_ = NULL;
	xmlTextWriter* _tmp70_ = NULL;
	xmlTextWriter* _tmp71_ = NULL;
	xmlTextWriter* _tmp72_ = NULL;
	FILE* _tmp73_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (filename != NULL, 0);
	_tmp0_ = g_strdup ("");
	errorMessage = _tmp0_;
	_tmp1_ = self->customComponentDefs;
	_tmp1__length1 = self->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp1_;
		customComponentDef_collection_length1 = _tmp1__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp1__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp2_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp2_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp2_;
			{
				CustomComponentDef** componentChain = NULL;
				CustomComponentDef* _tmp3_ = NULL;
				CustomComponentDef** _tmp4_ = NULL;
				CustomComponentDef** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				CustomComponentDef** _tmp7_ = NULL;
				CustomComponentDef** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint componentChain_length1 = 0;
				gint _componentChain_size_ = 0;
				CustomComponentDef** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				_tmp3_ = customComponentDef;
				_tmp4_ = g_new0 (CustomComponentDef*, 0 + 1);
				_tmp5_ = _tmp4_;
				_tmp5__length1 = 0;
				_tmp7_ = custom_component_def_validate_dependencies (_tmp3_, _tmp5_, 0, &_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _tmp6_;
				_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) component_def_unref), NULL);
				componentChain = _tmp8_;
				componentChain_length1 = _tmp8__length1;
				_componentChain_size_ = componentChain_length1;
				_tmp9_ = componentChain;
				_tmp9__length1 = componentChain_length1;
				if (_tmp9_ != NULL) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					CustomComponentDef** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					_tmp10_ = errorMessage;
					_tmp11_ = g_strconcat (_tmp10_, "Circuit failed cyclic dependency test. Failed ancestry:\n", NULL);
					_g_free0 (errorMessage);
					errorMessage = _tmp11_;
					_tmp12_ = componentChain;
					_tmp12__length1 = componentChain_length1;
					{
						CustomComponentDef** chainComponent_collection = NULL;
						gint chainComponent_collection_length1 = 0;
						gint _chainComponent_collection_size_ = 0;
						gint chainComponent_it = 0;
						chainComponent_collection = _tmp12_;
						chainComponent_collection_length1 = _tmp12__length1;
						for (chainComponent_it = 0; chainComponent_it < _tmp12__length1; chainComponent_it = chainComponent_it + 1) {
							CustomComponentDef* _tmp13_ = NULL;
							CustomComponentDef* chainComponent = NULL;
							_tmp13_ = _component_def_ref0 (chainComponent_collection[chainComponent_it]);
							chainComponent = _tmp13_;
							{
								const gchar* _tmp14_ = NULL;
								CustomComponentDef* _tmp15_ = NULL;
								const gchar* _tmp16_ = NULL;
								gchar* _tmp17_ = NULL;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
								gchar* _tmp21_ = NULL;
								_tmp14_ = errorMessage;
								_tmp15_ = chainComponent;
								_tmp16_ = ((ComponentDef*) _tmp15_)->name;
								_tmp17_ = g_strconcat ("  ", _tmp16_, NULL);
								_tmp18_ = _tmp17_;
								_tmp19_ = g_strconcat (_tmp18_, ".", NULL);
								_tmp20_ = _tmp19_;
								_tmp21_ = g_strconcat (_tmp14_, _tmp20_, NULL);
								_g_free0 (errorMessage);
								errorMessage = _tmp21_;
								_g_free0 (_tmp20_);
								_g_free0 (_tmp18_);
								_component_def_unref0 (chainComponent);
							}
						}
					}
					_tmp22_ = errorMessage;
					_tmp23_ = g_strconcat (_tmp22_, "\n", NULL);
					_g_free0 (errorMessage);
					errorMessage = _tmp23_;
					componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
					_component_def_unref0 (customComponentDef);
					break;
				}
				componentChain = (_vala_array_free (componentChain, componentChain_length1, (GDestroyNotify) component_def_unref), NULL);
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	_tmp24_ = errorMessage;
	if (g_strcmp0 (_tmp24_, "") != 0) {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		_tmp25_ = errorMessage;
		_tmp26_ = g_strconcat ("Could not save project:\n", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		basic_dialog_error (NULL, _tmp27_);
		_g_free0 (_tmp27_);
		result = 1;
		_g_free0 (errorMessage);
		return result;
	}
	_tmp28_ = self->priv->designers;
	_tmp28__length1 = self->priv->designers_length1;
	{
		Designer** designer_collection = NULL;
		gint designer_collection_length1 = 0;
		gint _designer_collection_size_ = 0;
		gint designer_it = 0;
		designer_collection = _tmp28_;
		designer_collection_length1 = _tmp28__length1;
		for (designer_it = 0; designer_it < _tmp28__length1; designer_it = designer_it + 1) {
			Designer* _tmp29_ = NULL;
			Designer* designer = NULL;
			_tmp29_ = _designer_ref0 (designer_collection[designer_it]);
			designer = _tmp29_;
			{
				Designer* _tmp30_ = NULL;
				CustomComponentDef* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				Designer* _tmp42_ = NULL;
				DesignerWindow* _tmp43_ = NULL;
				Designer* _tmp44_ = NULL;
				CustomComponentDef* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				_tmp30_ = designer;
				_tmp31_ = _tmp30_->customComponentDef;
				_tmp32_ = ((ComponentDef*) _tmp31_)->filename;
				if (g_strcmp0 (_tmp32_, "") == 0) {
					Designer* _tmp33_ = NULL;
					DesignerWindow* _tmp34_ = NULL;
					Designer* _tmp35_ = NULL;
					CustomComponentDef* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					_tmp33_ = designer;
					_tmp34_ = _tmp33_->window;
					gtk_window_present ((GtkWindow*) _tmp34_);
					_tmp35_ = designer;
					_tmp36_ = _tmp35_->customComponentDef;
					_tmp37_ = ((ComponentDef*) _tmp36_)->name;
					_tmp38_ = g_strconcat ("You must save \"", _tmp37_, NULL);
					_tmp39_ = _tmp38_;
					_tmp40_ = g_strconcat (_tmp39_, "\" before the project is saved.", NULL);
					_tmp41_ = _tmp40_;
					basic_dialog_information (NULL, _tmp41_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp39_);
				}
				_tmp42_ = designer;
				_tmp43_ = _tmp42_->window;
				designer_window_save_component (_tmp43_, FALSE);
				_tmp44_ = designer;
				_tmp45_ = _tmp44_->customComponentDef;
				_tmp46_ = ((ComponentDef*) _tmp45_)->filename;
				if (g_strcmp0 (_tmp46_, "") == 0) {
					basic_dialog_warning (NULL, "The project has not been saved. (Component not saved.)");
					result = 2;
					_designer_unref0 (designer);
					_g_free0 (errorMessage);
					return result;
				}
				_designer_unref0 (designer);
			}
		}
	}
	_tmp47_ = stdout;
	_tmp48_ = self->priv->_name;
	_tmp49_ = filename;
	fprintf (_tmp47_, "Saving Project \"%s\" to \"%s\"\n", _tmp48_, _tmp49_);
	_tmp50_ = filename;
	_tmp51_ = xmlNewTextWriterFilename (_tmp50_, FALSE);
	xmlWriter = _tmp51_;
	_tmp52_ = xmlWriter;
	xmlTextWriterSetIndent (_tmp52_, TRUE);
	_tmp53_ = xmlWriter;
	xmlTextWriterSetIndentString (_tmp53_, (xmlChar*) "\t");
	_tmp54_ = xmlWriter;
	xmlTextWriterStartDocument (_tmp54_, NULL, NULL, NULL);
	_tmp55_ = xmlWriter;
	xmlTextWriterStartElement (_tmp55_, (xmlChar*) "project");
	_tmp56_ = xmlWriter;
	xmlTextWriterStartElement (_tmp56_, (xmlChar*) "metadata");
	_tmp57_ = xmlWriter;
	xmlTextWriterStartElement (_tmp57_, (xmlChar*) "version");
	_tmp58_ = xmlWriter;
	xmlTextWriterWriteAttribute (_tmp58_, (xmlChar*) "smartsim", (xmlChar*) CORE_shortVersionString);
	_tmp59_ = xmlWriter;
	xmlTextWriterEndElement (_tmp59_);
	_tmp60_ = xmlWriter;
	xmlTextWriterEndElement (_tmp60_);
	_tmp61_ = stdout;
	fprintf (_tmp61_, "Saving description data...\n");
	_tmp63_ = self->priv->_name;
	if (_tmp63_ != NULL) {
		const gchar* _tmp64_ = NULL;
		_tmp64_ = self->priv->_name;
		_tmp62_ = _tmp64_;
	} else {
		_tmp62_ = "Untitled";
	}
	_tmp65_ = xmlWriter;
	xmlTextWriterWriteElement (_tmp65_, (xmlChar*) "name", (xmlChar*) _tmp62_);
	_tmp66_ = xmlWriter;
	_tmp67_ = self->description;
	xmlTextWriterWriteElement (_tmp66_, (xmlChar*) "description", (xmlChar*) _tmp67_);
	_tmp68_ = stdout;
	fprintf (_tmp68_, "Saving component list...\n");
	_tmp69_ = xmlWriter;
	project_save_component_list (self, _tmp69_);
	_tmp70_ = xmlWriter;
	xmlTextWriterEndElement (_tmp70_);
	_tmp71_ = xmlWriter;
	xmlTextWriterEndDocument (_tmp71_);
	_tmp72_ = xmlWriter;
	xmlTextWriterFlush (_tmp72_);
	_tmp73_ = stdout;
	fprintf (_tmp73_, "Saving complete...\n");
	result = 0;
	_xmlFreeTextWriter0 (xmlWriter);
	_g_free0 (errorMessage);
	return result;
}


static void _vala_array_add77 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add78 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add79 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add80 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static CustomComponentDef** _vala_array_dup69 (CustomComponentDef** self, int length) {
	CustomComponentDef** result;
	int i;
	result = g_new0 (CustomComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		CustomComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void project_save_component_list (Project* self, xmlTextWriter* xmlWriter) {
	CustomComponentDef** unsavedComponents = NULL;
	CustomComponentDef** _tmp0_ = NULL;
	gint unsavedComponents_length1 = 0;
	gint _unsavedComponents_size_ = 0;
	CustomComponentDef** saveLoadOrder = NULL;
	CustomComponentDef** _tmp1_ = NULL;
	gint saveLoadOrder_length1 = 0;
	gint _saveLoadOrder_size_ = 0;
	CustomComponentDef** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gboolean stillWorking = FALSE;
	PluginComponentManager** _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
	CustomComponentDef** _tmp50_ = NULL;
	gint _tmp50__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (xmlWriter != NULL);
	_tmp0_ = g_new0 (CustomComponentDef*, 0 + 1);
	unsavedComponents = _tmp0_;
	unsavedComponents_length1 = 0;
	_unsavedComponents_size_ = unsavedComponents_length1;
	_tmp1_ = g_new0 (CustomComponentDef*, 0 + 1);
	saveLoadOrder = _tmp1_;
	saveLoadOrder_length1 = 0;
	_saveLoadOrder_size_ = saveLoadOrder_length1;
	_tmp2_ = self->customComponentDefs;
	_tmp2__length1 = self->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp2_;
		customComponentDef_collection_length1 = _tmp2__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp2__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp3_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp3_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp3_;
			{
				CustomComponentDef* _tmp4_ = NULL;
				CustomComponentDef** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				CustomComponentDef* _tmp6_ = NULL;
				CustomComponentDef* _tmp7_ = NULL;
				_tmp4_ = customComponentDef;
				custom_component_def_update_immediate_dependencies (_tmp4_, FALSE);
				_tmp5_ = unsavedComponents;
				_tmp5__length1 = unsavedComponents_length1;
				_tmp6_ = customComponentDef;
				_tmp7_ = _component_def_ref0 (_tmp6_);
				_vala_array_add77 (&unsavedComponents, &unsavedComponents_length1, &_unsavedComponents_size_, _tmp7_);
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	stillWorking = TRUE;
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		CustomComponentDef** justAdded = NULL;
		CustomComponentDef** _tmp9_ = NULL;
		gint justAdded_length1 = 0;
		gint _justAdded_size_ = 0;
		CustomComponentDef** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		CustomComponentDef** newUnsavedComponents = NULL;
		CustomComponentDef** _tmp20_ = NULL;
		gint newUnsavedComponents_length1 = 0;
		gint _newUnsavedComponents_size_ = 0;
		CustomComponentDef** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		CustomComponentDef** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		CustomComponentDef** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		_tmp8_ = stillWorking;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = g_new0 (CustomComponentDef*, 0 + 1);
		justAdded = _tmp9_;
		justAdded_length1 = 0;
		_justAdded_size_ = justAdded_length1;
		stillWorking = FALSE;
		_tmp10_ = unsavedComponents;
		_tmp10__length1 = unsavedComponents_length1;
		{
			CustomComponentDef** customComponentDef_collection = NULL;
			gint customComponentDef_collection_length1 = 0;
			gint _customComponentDef_collection_size_ = 0;
			gint customComponentDef_it = 0;
			customComponentDef_collection = _tmp10_;
			customComponentDef_collection_length1 = _tmp10__length1;
			for (customComponentDef_it = 0; customComponentDef_it < _tmp10__length1; customComponentDef_it = customComponentDef_it + 1) {
				CustomComponentDef* _tmp11_ = NULL;
				CustomComponentDef* customComponentDef = NULL;
				_tmp11_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
				customComponentDef = _tmp11_;
				{
					CustomComponentDef* _tmp12_ = NULL;
					ComponentDef** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					_tmp12_ = customComponentDef;
					_tmp13_ = _tmp12_->immediateDependencies;
					_tmp13__length1 = _tmp12_->immediateDependencies_length1;
					if (_tmp13__length1 == 0) {
						CustomComponentDef** _tmp14_ = NULL;
						gint _tmp14__length1 = 0;
						CustomComponentDef* _tmp15_ = NULL;
						CustomComponentDef* _tmp16_ = NULL;
						CustomComponentDef** _tmp17_ = NULL;
						gint _tmp17__length1 = 0;
						CustomComponentDef* _tmp18_ = NULL;
						CustomComponentDef* _tmp19_ = NULL;
						_tmp14_ = saveLoadOrder;
						_tmp14__length1 = saveLoadOrder_length1;
						_tmp15_ = customComponentDef;
						_tmp16_ = _component_def_ref0 (_tmp15_);
						_vala_array_add78 (&saveLoadOrder, &saveLoadOrder_length1, &_saveLoadOrder_size_, _tmp16_);
						_tmp17_ = justAdded;
						_tmp17__length1 = justAdded_length1;
						_tmp18_ = customComponentDef;
						_tmp19_ = _component_def_ref0 (_tmp18_);
						_vala_array_add79 (&justAdded, &justAdded_length1, &_justAdded_size_, _tmp19_);
						stillWorking = TRUE;
					}
					_component_def_unref0 (customComponentDef);
				}
			}
		}
		_tmp20_ = g_new0 (CustomComponentDef*, 0 + 1);
		newUnsavedComponents = _tmp20_;
		newUnsavedComponents_length1 = 0;
		_newUnsavedComponents_size_ = newUnsavedComponents_length1;
		_tmp21_ = unsavedComponents;
		_tmp21__length1 = unsavedComponents_length1;
		{
			CustomComponentDef** customComponentDef_collection = NULL;
			gint customComponentDef_collection_length1 = 0;
			gint _customComponentDef_collection_size_ = 0;
			gint customComponentDef_it = 0;
			customComponentDef_collection = _tmp21_;
			customComponentDef_collection_length1 = _tmp21__length1;
			for (customComponentDef_it = 0; customComponentDef_it < _tmp21__length1; customComponentDef_it = customComponentDef_it + 1) {
				CustomComponentDef* _tmp22_ = NULL;
				CustomComponentDef* customComponentDef = NULL;
				_tmp22_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
				customComponentDef = _tmp22_;
				{
					CustomComponentDef** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					CustomComponentDef* _tmp27_ = NULL;
					CustomComponentDef** _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					_tmp23_ = justAdded;
					_tmp23__length1 = justAdded_length1;
					{
						CustomComponentDef** removeComponent_collection = NULL;
						gint removeComponent_collection_length1 = 0;
						gint _removeComponent_collection_size_ = 0;
						gint removeComponent_it = 0;
						removeComponent_collection = _tmp23_;
						removeComponent_collection_length1 = _tmp23__length1;
						for (removeComponent_it = 0; removeComponent_it < _tmp23__length1; removeComponent_it = removeComponent_it + 1) {
							CustomComponentDef* _tmp24_ = NULL;
							CustomComponentDef* removeComponent = NULL;
							_tmp24_ = _component_def_ref0 (removeComponent_collection[removeComponent_it]);
							removeComponent = _tmp24_;
							{
								CustomComponentDef* _tmp25_ = NULL;
								CustomComponentDef* _tmp26_ = NULL;
								_tmp25_ = customComponentDef;
								_tmp26_ = removeComponent;
								custom_component_def_remove_immediate_dependency (_tmp25_, (ComponentDef*) _tmp26_);
								_component_def_unref0 (removeComponent);
							}
						}
					}
					_tmp27_ = customComponentDef;
					_tmp28_ = justAdded;
					_tmp28__length1 = justAdded_length1;
					if (!_vala_custom_component_def_array_contains (_tmp28_, _tmp28__length1, _tmp27_)) {
						CustomComponentDef** _tmp29_ = NULL;
						gint _tmp29__length1 = 0;
						CustomComponentDef* _tmp30_ = NULL;
						CustomComponentDef* _tmp31_ = NULL;
						_tmp29_ = newUnsavedComponents;
						_tmp29__length1 = newUnsavedComponents_length1;
						_tmp30_ = customComponentDef;
						_tmp31_ = _component_def_ref0 (_tmp30_);
						_vala_array_add80 (&newUnsavedComponents, &newUnsavedComponents_length1, &_newUnsavedComponents_size_, _tmp31_);
					}
					_component_def_unref0 (customComponentDef);
				}
			}
		}
		_tmp32_ = newUnsavedComponents;
		_tmp32__length1 = newUnsavedComponents_length1;
		_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup69 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
		_tmp33__length1 = _tmp32__length1;
		unsavedComponents = (_vala_array_free (unsavedComponents, unsavedComponents_length1, (GDestroyNotify) component_def_unref), NULL);
		unsavedComponents = _tmp33_;
		unsavedComponents_length1 = _tmp33__length1;
		_unsavedComponents_size_ = unsavedComponents_length1;
		newUnsavedComponents = (_vala_array_free (newUnsavedComponents, newUnsavedComponents_length1, (GDestroyNotify) component_def_unref), NULL);
		justAdded = (_vala_array_free (justAdded, justAdded_length1, (GDestroyNotify) component_def_unref), NULL);
	}
	_tmp34_ = self->pluginComponentManagers;
	_tmp34__length1 = self->pluginComponentManagers_length1;
	{
		PluginComponentManager** pluginComponentManager_collection = NULL;
		gint pluginComponentManager_collection_length1 = 0;
		gint _pluginComponentManager_collection_size_ = 0;
		gint pluginComponentManager_it = 0;
		pluginComponentManager_collection = _tmp34_;
		pluginComponentManager_collection_length1 = _tmp34__length1;
		for (pluginComponentManager_it = 0; pluginComponentManager_it < _tmp34__length1; pluginComponentManager_it = pluginComponentManager_it + 1) {
			PluginComponentManager* _tmp35_ = NULL;
			PluginComponentManager* pluginComponentManager = NULL;
			_tmp35_ = _plugin_component_manager_ref0 (pluginComponentManager_collection[pluginComponentManager_it]);
			pluginComponentManager = _tmp35_;
			{
				xmlTextWriter* _tmp36_ = NULL;
				FILE* _tmp37_ = NULL;
				PluginComponentManager* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				PluginComponentManager* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				xmlTextWriter* _tmp44_ = NULL;
				PluginComponentManager* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				xmlTextWriter* _tmp49_ = NULL;
				_tmp36_ = xmlWriter;
				xmlTextWriterStartElement (_tmp36_, (xmlChar*) "plugin");
				_tmp37_ = stdout;
				_tmp38_ = pluginComponentManager;
				_tmp39_ = _tmp38_->filename;
				_tmp40_ = pluginComponentManager;
				_tmp41_ = _tmp40_->filename;
				_tmp42_ = project_relative_filename (self, _tmp41_);
				_tmp43_ = _tmp42_;
				fprintf (_tmp37_, "Relative path of file \"%s\" is \"%s\"\n", _tmp39_, _tmp43_);
				_g_free0 (_tmp43_);
				_tmp44_ = xmlWriter;
				_tmp45_ = pluginComponentManager;
				_tmp46_ = _tmp45_->filename;
				_tmp47_ = project_relative_filename (self, _tmp46_);
				_tmp48_ = _tmp47_;
				xmlTextWriterWriteString (_tmp44_, (xmlChar*) _tmp48_);
				_g_free0 (_tmp48_);
				_tmp49_ = xmlWriter;
				xmlTextWriterEndElement (_tmp49_);
				_plugin_component_manager_unref0 (pluginComponentManager);
			}
		}
	}
	_tmp50_ = saveLoadOrder;
	_tmp50__length1 = saveLoadOrder_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp50_;
		customComponentDef_collection_length1 = _tmp50__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp50__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp51_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp51_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp51_;
			{
				xmlTextWriter* _tmp52_ = NULL;
				CustomComponentDef* _tmp53_ = NULL;
				CustomComponentDef* _tmp54_ = NULL;
				FILE* _tmp56_ = NULL;
				CustomComponentDef* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				CustomComponentDef* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				gchar* _tmp62_ = NULL;
				xmlTextWriter* _tmp63_ = NULL;
				CustomComponentDef* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				gchar* _tmp67_ = NULL;
				xmlTextWriter* _tmp68_ = NULL;
				_tmp52_ = xmlWriter;
				xmlTextWriterStartElement (_tmp52_, (xmlChar*) "component");
				_tmp53_ = customComponentDef;
				_tmp54_ = self->rootComponent;
				if (_tmp53_ == _tmp54_) {
					xmlTextWriter* _tmp55_ = NULL;
					_tmp55_ = xmlWriter;
					xmlTextWriterWriteAttribute (_tmp55_, (xmlChar*) "root", (xmlChar*) "true");
				}
				_tmp56_ = stdout;
				_tmp57_ = customComponentDef;
				_tmp58_ = ((ComponentDef*) _tmp57_)->filename;
				_tmp59_ = customComponentDef;
				_tmp60_ = ((ComponentDef*) _tmp59_)->filename;
				_tmp61_ = project_relative_filename (self, _tmp60_);
				_tmp62_ = _tmp61_;
				fprintf (_tmp56_, "Relative path of file \"%s\" is \"%s\"\n", _tmp58_, _tmp62_);
				_g_free0 (_tmp62_);
				_tmp63_ = xmlWriter;
				_tmp64_ = customComponentDef;
				_tmp65_ = ((ComponentDef*) _tmp64_)->filename;
				_tmp66_ = project_relative_filename (self, _tmp65_);
				_tmp67_ = _tmp66_;
				xmlTextWriterWriteString (_tmp63_, (xmlChar*) _tmp67_);
				_g_free0 (_tmp67_);
				_tmp68_ = xmlWriter;
				xmlTextWriterEndElement (_tmp68_);
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	saveLoadOrder = (_vala_array_free (saveLoadOrder, saveLoadOrder_length1, (GDestroyNotify) component_def_unref), NULL);
	unsavedComponents = (_vala_array_free (unsavedComponents, unsavedComponents_length1, (GDestroyNotify) component_def_unref), NULL);
}


static void _vala_array_add81 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static CustomComponentDef** _vala_array_dup70 (CustomComponentDef** self, int length) {
	CustomComponentDef** result;
	int i;
	result = g_new0 (CustomComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		CustomComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint project_remove_component (Project* self, CustomComponentDef* removeComponent) {
	gint result = 0;
	gint _result_ = 0;
	CustomComponentDef** usersOfComponent = NULL;
	CustomComponentDef* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	CustomComponentDef** _tmp2_ = NULL;
	gint usersOfComponent_length1 = 0;
	gint _usersOfComponent_size_ = 0;
	CustomComponentDef** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	CustomComponentDef** newCustomComponentDefs = NULL;
	CustomComponentDef** _tmp18_ = NULL;
	gint newCustomComponentDefs_length1 = 0;
	gint _newCustomComponentDefs_size_ = 0;
	CustomComponentDef** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	CustomComponentDef** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	CustomComponentDef** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	CustomComponentDef* _tmp28_ = NULL;
	CustomComponentDef* _tmp29_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (removeComponent != NULL, 0);
	_result_ = 1;
	_tmp0_ = removeComponent;
	_tmp2_ = project_component_users (self, (ComponentDef*) _tmp0_, &_tmp1_);
	usersOfComponent = _tmp2_;
	usersOfComponent_length1 = _tmp1_;
	_usersOfComponent_size_ = usersOfComponent_length1;
	_tmp3_ = usersOfComponent;
	_tmp3__length1 = usersOfComponent_length1;
	if (_tmp3__length1 > 0) {
		gchar* usersString = NULL;
		gchar* _tmp4_ = NULL;
		CustomComponentDef** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp4_ = g_strdup ("");
		usersString = _tmp4_;
		_tmp5_ = usersOfComponent;
		_tmp5__length1 = usersOfComponent_length1;
		{
			CustomComponentDef** customComponentDef_collection = NULL;
			gint customComponentDef_collection_length1 = 0;
			gint _customComponentDef_collection_size_ = 0;
			gint customComponentDef_it = 0;
			customComponentDef_collection = _tmp5_;
			customComponentDef_collection_length1 = _tmp5__length1;
			for (customComponentDef_it = 0; customComponentDef_it < _tmp5__length1; customComponentDef_it = customComponentDef_it + 1) {
				CustomComponentDef* _tmp6_ = NULL;
				CustomComponentDef* customComponentDef = NULL;
				_tmp6_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
				customComponentDef = _tmp6_;
				{
					const gchar* _tmp7_ = NULL;
					CustomComponentDef* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp7_ = usersString;
					_tmp8_ = customComponentDef;
					_tmp9_ = ((ComponentDef*) _tmp8_)->name;
					_tmp10_ = g_strconcat ("  ", _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
					_g_free0 (usersString);
					usersString = _tmp14_;
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					_component_def_unref0 (customComponentDef);
				}
			}
		}
		_tmp15_ = usersString;
		_tmp16_ = g_strconcat ("You cannot remove this component from your project because it is used " \
"within one or more other components:\n", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		basic_dialog_error (NULL, _tmp17_);
		_g_free0 (_tmp17_);
		result = 2;
		_g_free0 (usersString);
		usersOfComponent = (_vala_array_free (usersOfComponent, usersOfComponent_length1, (GDestroyNotify) component_def_unref), NULL);
		return result;
	}
	_tmp18_ = g_new0 (CustomComponentDef*, 0 + 1);
	newCustomComponentDefs = _tmp18_;
	newCustomComponentDefs_length1 = 0;
	_newCustomComponentDefs_size_ = newCustomComponentDefs_length1;
	_tmp19_ = self->customComponentDefs;
	_tmp19__length1 = self->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp19_;
		customComponentDef_collection_length1 = _tmp19__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp19__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp20_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp20_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp20_;
			{
				CustomComponentDef* _tmp21_ = NULL;
				CustomComponentDef* _tmp22_ = NULL;
				_tmp21_ = customComponentDef;
				_tmp22_ = removeComponent;
				if (_tmp21_ == _tmp22_) {
					_result_ = 0;
				} else {
					CustomComponentDef** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					CustomComponentDef* _tmp24_ = NULL;
					CustomComponentDef* _tmp25_ = NULL;
					_tmp23_ = newCustomComponentDefs;
					_tmp23__length1 = newCustomComponentDefs_length1;
					_tmp24_ = customComponentDef;
					_tmp25_ = _component_def_ref0 (_tmp24_);
					_vala_array_add81 (&newCustomComponentDefs, &newCustomComponentDefs_length1, &_newCustomComponentDefs_size_, _tmp25_);
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	_tmp26_ = newCustomComponentDefs;
	_tmp26__length1 = newCustomComponentDefs_length1;
	_tmp27_ = (_tmp26_ != NULL) ? _vala_array_dup70 (_tmp26_, _tmp26__length1) : ((gpointer) _tmp26_);
	_tmp27__length1 = _tmp26__length1;
	self->customComponentDefs = (_vala_array_free (self->customComponentDefs, self->customComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	self->customComponentDefs = _tmp27_;
	self->customComponentDefs_length1 = _tmp27__length1;
	_tmp28_ = removeComponent;
	_tmp29_ = self->rootComponent;
	if (_tmp28_ == _tmp29_) {
		_component_def_unref0 (self->rootComponent);
		self->rootComponent = NULL;
	}
	result = _result_;
	newCustomComponentDefs = (_vala_array_free (newCustomComponentDefs, newCustomComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	usersOfComponent = (_vala_array_free (usersOfComponent, usersOfComponent_length1, (GDestroyNotify) component_def_unref), NULL);
	return result;
}


static void _vala_array_add82 (PluginComponentDef*** array, int* length, int* size, PluginComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add83 (PluginComponentManager*** array, int* length, int* size, PluginComponentManager* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PluginComponentManager*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PluginComponentDef** _vala_array_dup71 (PluginComponentDef** self, int length) {
	PluginComponentDef** result;
	int i;
	result = g_new0 (PluginComponentDef*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentDef* _tmp0_ = NULL;
		_tmp0_ = _component_def_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static PluginComponentManager** _vala_array_dup72 (PluginComponentManager** self, int length) {
	PluginComponentManager** result;
	int i;
	result = g_new0 (PluginComponentManager*, length + 1);
	for (i = 0; i < length; i++) {
		PluginComponentManager* _tmp0_ = NULL;
		_tmp0_ = _plugin_component_manager_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint project_remove_plugin_component (Project* self, PluginComponentDef* removeComponent) {
	gint result = 0;
	gint _result_ = 0;
	CustomComponentDef** usersOfComponent = NULL;
	PluginComponentDef* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	CustomComponentDef** _tmp2_ = NULL;
	gint usersOfComponent_length1 = 0;
	gint _usersOfComponent_size_ = 0;
	CustomComponentDef** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	PluginComponentDef** newPluginComponentDefs = NULL;
	PluginComponentDef** _tmp18_ = NULL;
	gint newPluginComponentDefs_length1 = 0;
	gint _newPluginComponentDefs_size_ = 0;
	PluginComponentDef** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	PluginComponentManager** newPluginComponentManagers = NULL;
	PluginComponentManager** _tmp26_ = NULL;
	gint newPluginComponentManagers_length1 = 0;
	gint _newPluginComponentManagers_size_ = 0;
	PluginComponentManager** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	PluginComponentDef** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	PluginComponentDef** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	PluginComponentManager** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	PluginComponentManager** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (removeComponent != NULL, 0);
	_result_ = 1;
	_tmp0_ = removeComponent;
	_tmp2_ = project_component_users (self, (ComponentDef*) _tmp0_, &_tmp1_);
	usersOfComponent = _tmp2_;
	usersOfComponent_length1 = _tmp1_;
	_usersOfComponent_size_ = usersOfComponent_length1;
	_tmp3_ = usersOfComponent;
	_tmp3__length1 = usersOfComponent_length1;
	if (_tmp3__length1 > 0) {
		gchar* usersString = NULL;
		gchar* _tmp4_ = NULL;
		CustomComponentDef** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp4_ = g_strdup ("");
		usersString = _tmp4_;
		_tmp5_ = usersOfComponent;
		_tmp5__length1 = usersOfComponent_length1;
		{
			CustomComponentDef** customComponentDef_collection = NULL;
			gint customComponentDef_collection_length1 = 0;
			gint _customComponentDef_collection_size_ = 0;
			gint customComponentDef_it = 0;
			customComponentDef_collection = _tmp5_;
			customComponentDef_collection_length1 = _tmp5__length1;
			for (customComponentDef_it = 0; customComponentDef_it < _tmp5__length1; customComponentDef_it = customComponentDef_it + 1) {
				CustomComponentDef* _tmp6_ = NULL;
				CustomComponentDef* customComponentDef = NULL;
				_tmp6_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
				customComponentDef = _tmp6_;
				{
					const gchar* _tmp7_ = NULL;
					CustomComponentDef* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp7_ = usersString;
					_tmp8_ = customComponentDef;
					_tmp9_ = ((ComponentDef*) _tmp8_)->name;
					_tmp10_ = g_strconcat ("  ", _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
					_g_free0 (usersString);
					usersString = _tmp14_;
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					_component_def_unref0 (customComponentDef);
				}
			}
		}
		_tmp15_ = usersString;
		_tmp16_ = g_strconcat ("You cannot remove this plugin component from your project because it i" \
"s used within one or more other components:\n", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		basic_dialog_error (NULL, _tmp17_);
		_g_free0 (_tmp17_);
		result = 2;
		_g_free0 (usersString);
		usersOfComponent = (_vala_array_free (usersOfComponent, usersOfComponent_length1, (GDestroyNotify) component_def_unref), NULL);
		return result;
	}
	_tmp18_ = g_new0 (PluginComponentDef*, 0 + 1);
	newPluginComponentDefs = _tmp18_;
	newPluginComponentDefs_length1 = 0;
	_newPluginComponentDefs_size_ = newPluginComponentDefs_length1;
	_tmp19_ = self->pluginComponentDefs;
	_tmp19__length1 = self->pluginComponentDefs_length1;
	{
		PluginComponentDef** pluginComponentDef_collection = NULL;
		gint pluginComponentDef_collection_length1 = 0;
		gint _pluginComponentDef_collection_size_ = 0;
		gint pluginComponentDef_it = 0;
		pluginComponentDef_collection = _tmp19_;
		pluginComponentDef_collection_length1 = _tmp19__length1;
		for (pluginComponentDef_it = 0; pluginComponentDef_it < _tmp19__length1; pluginComponentDef_it = pluginComponentDef_it + 1) {
			PluginComponentDef* _tmp20_ = NULL;
			PluginComponentDef* pluginComponentDef = NULL;
			_tmp20_ = _component_def_ref0 (pluginComponentDef_collection[pluginComponentDef_it]);
			pluginComponentDef = _tmp20_;
			{
				PluginComponentDef* _tmp21_ = NULL;
				PluginComponentDef* _tmp22_ = NULL;
				_tmp21_ = pluginComponentDef;
				_tmp22_ = removeComponent;
				if (_tmp21_ == _tmp22_) {
					_result_ = 0;
				} else {
					PluginComponentDef** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					PluginComponentDef* _tmp24_ = NULL;
					PluginComponentDef* _tmp25_ = NULL;
					_tmp23_ = newPluginComponentDefs;
					_tmp23__length1 = newPluginComponentDefs_length1;
					_tmp24_ = pluginComponentDef;
					_tmp25_ = _component_def_ref0 (_tmp24_);
					_vala_array_add82 (&newPluginComponentDefs, &newPluginComponentDefs_length1, &_newPluginComponentDefs_size_, _tmp25_);
				}
				_component_def_unref0 (pluginComponentDef);
			}
		}
	}
	_tmp26_ = g_new0 (PluginComponentManager*, 0 + 1);
	newPluginComponentManagers = _tmp26_;
	newPluginComponentManagers_length1 = 0;
	_newPluginComponentManagers_size_ = newPluginComponentManagers_length1;
	_tmp27_ = self->pluginComponentManagers;
	_tmp27__length1 = self->pluginComponentManagers_length1;
	{
		PluginComponentManager** pluginComponentManager_collection = NULL;
		gint pluginComponentManager_collection_length1 = 0;
		gint _pluginComponentManager_collection_size_ = 0;
		gint pluginComponentManager_it = 0;
		pluginComponentManager_collection = _tmp27_;
		pluginComponentManager_collection_length1 = _tmp27__length1;
		for (pluginComponentManager_it = 0; pluginComponentManager_it < _tmp27__length1; pluginComponentManager_it = pluginComponentManager_it + 1) {
			PluginComponentManager* _tmp28_ = NULL;
			PluginComponentManager* pluginComponentManager = NULL;
			_tmp28_ = _plugin_component_manager_ref0 (pluginComponentManager_collection[pluginComponentManager_it]);
			pluginComponentManager = _tmp28_;
			{
				PluginComponentManager* _tmp29_ = NULL;
				PluginComponentDef* _tmp30_ = NULL;
				PluginComponentDef* _tmp31_ = NULL;
				_tmp29_ = pluginComponentManager;
				_tmp30_ = _tmp29_->pluginComponentDef;
				_tmp31_ = removeComponent;
				if (_tmp30_ == _tmp31_) {
				} else {
					PluginComponentManager** _tmp32_ = NULL;
					gint _tmp32__length1 = 0;
					PluginComponentManager* _tmp33_ = NULL;
					PluginComponentManager* _tmp34_ = NULL;
					_tmp32_ = newPluginComponentManagers;
					_tmp32__length1 = newPluginComponentManagers_length1;
					_tmp33_ = pluginComponentManager;
					_tmp34_ = _plugin_component_manager_ref0 (_tmp33_);
					_vala_array_add83 (&newPluginComponentManagers, &newPluginComponentManagers_length1, &_newPluginComponentManagers_size_, _tmp34_);
				}
				_plugin_component_manager_unref0 (pluginComponentManager);
			}
		}
	}
	_tmp35_ = newPluginComponentDefs;
	_tmp35__length1 = newPluginComponentDefs_length1;
	_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup71 (_tmp35_, _tmp35__length1) : ((gpointer) _tmp35_);
	_tmp36__length1 = _tmp35__length1;
	self->pluginComponentDefs = (_vala_array_free (self->pluginComponentDefs, self->pluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	self->pluginComponentDefs = _tmp36_;
	self->pluginComponentDefs_length1 = _tmp36__length1;
	_tmp37_ = newPluginComponentManagers;
	_tmp37__length1 = newPluginComponentManagers_length1;
	_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup72 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
	_tmp38__length1 = _tmp37__length1;
	self->pluginComponentManagers = (_vala_array_free (self->pluginComponentManagers, self->pluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
	self->pluginComponentManagers = _tmp38_;
	self->pluginComponentManagers_length1 = _tmp38__length1;
	result = _result_;
	newPluginComponentManagers = (_vala_array_free (newPluginComponentManagers, newPluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
	newPluginComponentDefs = (_vala_array_free (newPluginComponentDefs, newPluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	usersOfComponent = (_vala_array_free (usersOfComponent, usersOfComponent_length1, (GDestroyNotify) component_def_unref), NULL);
	return result;
}


static gboolean _vala_component_def_array_contains (ComponentDef** stack, int stack_length, ComponentDef* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add84 (CustomComponentDef*** array, int* length, int* size, CustomComponentDef* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CustomComponentDef*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


CustomComponentDef** project_component_users (Project* self, ComponentDef* usedComponent, int* result_length1) {
	CustomComponentDef** result = NULL;
	CustomComponentDef** userList = NULL;
	CustomComponentDef** _tmp0_ = NULL;
	gint userList_length1 = 0;
	gint _userList_size_ = 0;
	CustomComponentDef** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	CustomComponentDef** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (usedComponent != NULL, NULL);
	_tmp0_ = g_new0 (CustomComponentDef*, 0 + 1);
	userList = _tmp0_;
	userList_length1 = 0;
	_userList_size_ = userList_length1;
	_tmp1_ = self->customComponentDefs;
	_tmp1__length1 = self->customComponentDefs_length1;
	{
		CustomComponentDef** customComponentDef_collection = NULL;
		gint customComponentDef_collection_length1 = 0;
		gint _customComponentDef_collection_size_ = 0;
		gint customComponentDef_it = 0;
		customComponentDef_collection = _tmp1_;
		customComponentDef_collection_length1 = _tmp1__length1;
		for (customComponentDef_it = 0; customComponentDef_it < _tmp1__length1; customComponentDef_it = customComponentDef_it + 1) {
			CustomComponentDef* _tmp2_ = NULL;
			CustomComponentDef* customComponentDef = NULL;
			_tmp2_ = _component_def_ref0 (customComponentDef_collection[customComponentDef_it]);
			customComponentDef = _tmp2_;
			{
				CustomComponentDef* _tmp3_ = NULL;
				ComponentDef* _tmp4_ = NULL;
				CustomComponentDef* _tmp5_ = NULL;
				ComponentDef** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				_tmp3_ = customComponentDef;
				custom_component_def_update_immediate_dependencies (_tmp3_, TRUE);
				_tmp4_ = usedComponent;
				_tmp5_ = customComponentDef;
				_tmp6_ = _tmp5_->immediateDependencies;
				_tmp6__length1 = _tmp5_->immediateDependencies_length1;
				if (_vala_component_def_array_contains (_tmp6_, _tmp6__length1, _tmp4_)) {
					CustomComponentDef** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					CustomComponentDef* _tmp8_ = NULL;
					CustomComponentDef* _tmp9_ = NULL;
					_tmp7_ = userList;
					_tmp7__length1 = userList_length1;
					_tmp8_ = customComponentDef;
					_tmp9_ = _component_def_ref0 (_tmp8_);
					_vala_array_add84 (&userList, &userList_length1, &_userList_size_, _tmp9_);
				}
				_component_def_unref0 (customComponentDef);
			}
		}
	}
	_tmp10_ = userList;
	_tmp10__length1 = userList_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}


void project_configure (Project* self) {
	PropertySet* configuration = NULL;
	PropertySet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PropertyItemString* _tmp2_ = NULL;
	PropertyItemString* _tmp3_ = NULL;
	PropertiesQuery* query = NULL;
	PropertiesQuery* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = property_set_new ("Project Configuration", "Project configuration");
	configuration = _tmp0_;
	_tmp1_ = self->priv->_name;
	_tmp2_ = property_item_string_new ("Name", "Project's name", _tmp1_);
	_tmp3_ = _tmp2_;
	property_set_add_item (configuration, (PropertyItem*) _tmp3_);
	_property_item_unref0 (_tmp3_);
	_tmp4_ = properties_query_new ("Project", NULL, configuration);
	query = _tmp4_;
	properties_query_run (query);
	_tmp5_ = property_item_string_get_data (configuration, "Name");
	_tmp6_ = _tmp5_;
	project_set_name (self, _tmp6_);
	_g_free0 (_tmp6_);
	_properties_query_unref0 (query);
	_property_item_unref0 (configuration);
}


gchar* project_relative_filename (Project* self, const gchar* rawTargetFilename) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (rawTargetFilename != NULL, NULL);
	_tmp0_ = rawTargetFilename;
	_tmp1_ = self->filename;
	_tmp2_ = core_absolute_filename (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gchar* project_absolute_filename (Project* self, const gchar* targetFilename) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (targetFilename != NULL, NULL);
	_tmp0_ = targetFilename;
	_tmp1_ = self->filename;
	_tmp2_ = g_path_get_dirname (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = core_absolute_filename (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


/**
 * Registers //designer// with this project.
 * Adds it to the //designers// array.
 */
static void _vala_array_add85 (Designer*** array, int* length, int* size, Designer* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Designer*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void project_register_designer (Project* self, Designer* designer) {
	gint position = 0;
	Designer** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Designer** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	Designer* _tmp2_ = NULL;
	Designer* _tmp3_ = NULL;
	Designer* _tmp4_ = NULL;
	FILE* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (designer != NULL);
	_tmp0_ = self->priv->designers;
	_tmp0__length1 = self->priv->designers_length1;
	position = _tmp0__length1;
	_tmp1_ = self->priv->designers;
	_tmp1__length1 = self->priv->designers_length1;
	_tmp2_ = designer;
	_tmp3_ = _designer_ref0 (_tmp2_);
	_vala_array_add85 (&self->priv->designers, &self->priv->designers_length1, &self->priv->_designers_size_, _tmp3_);
	_tmp4_ = designer;
	_tmp4_->myID = position;
	_tmp5_ = stdout;
	fprintf (_tmp5_, "Registered designer %i\n", position);
}


/**
 * Unregisters //designer// with this project.
 * Removes it from the //designers// array.
 */
static void _vala_array_add86 (Designer*** array, int* length, int* size, Designer* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Designer*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Designer** _vala_array_dup73 (Designer** self, int length) {
	Designer** result;
	int i;
	result = g_new0 (Designer*, length + 1);
	for (i = 0; i < length; i++) {
		Designer* _tmp0_ = NULL;
		_tmp0_ = _designer_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void project_unregister_designer (Project* self, Designer* designer) {
	Designer** tempArray = NULL;
	Designer** _tmp0_ = NULL;
	gint tempArray_length1 = 0;
	gint _tempArray_size_ = 0;
	gint position = 0;
	gint newID = 0;
	Designer* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Designer** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	Designer** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	FILE* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	Designer** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (designer != NULL);
	_tmp0_ = g_new0 (Designer*, 0 + 1);
	tempArray = _tmp0_;
	tempArray_length1 = 0;
	_tempArray_size_ = tempArray_length1;
	newID = 0;
	_tmp1_ = designer;
	_tmp2_ = _tmp1_->myID;
	position = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				Designer** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->designers;
				_tmp6__length1 = self->priv->designers_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = position;
				if (_tmp7_ != _tmp8_) {
					Designer** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					Designer* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					Designer** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					Designer** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					Designer* _tmp16_ = NULL;
					Designer* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					_tmp9_ = self->priv->designers;
					_tmp9__length1 = self->priv->designers_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = newID;
					_tmp11_->myID = _tmp12_;
					_tmp13_ = tempArray;
					_tmp13__length1 = tempArray_length1;
					_tmp14_ = self->priv->designers;
					_tmp14__length1 = self->priv->designers_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = _designer_ref0 (_tmp16_);
					_vala_array_add86 (&tempArray, &tempArray_length1, &_tempArray_size_, _tmp17_);
					_tmp18_ = newID;
					newID = _tmp18_ + 1;
				}
			}
		}
	}
	_tmp19_ = tempArray;
	_tmp19__length1 = tempArray_length1;
	_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup73 (_tmp19_, _tmp19__length1) : ((gpointer) _tmp19_);
	_tmp20__length1 = _tmp19__length1;
	self->priv->designers = (_vala_array_free (self->priv->designers, self->priv->designers_length1, (GDestroyNotify) designer_unref), NULL);
	self->priv->designers = _tmp20_;
	self->priv->designers_length1 = _tmp20__length1;
	self->priv->_designers_size_ = self->priv->designers_length1;
	_tmp21_ = stdout;
	_tmp22_ = position;
	fprintf (_tmp21_, "Unregistered designer %i\n", _tmp22_);
	_tmp23_ = self->priv->designers;
	_tmp23__length1 = self->priv->designers_length1;
	if (_tmp23__length1 == 0) {
		FILE* _tmp24_ = NULL;
		_tmp24_ = stdout;
		fprintf (_tmp24_, "No more open designers!\n");
	}
	tempArray = (_vala_array_free (tempArray, tempArray_length1, (GDestroyNotify) designer_unref), NULL);
}


const gchar* project_get_name (Project* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void project_set_name (Project* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


static void value_project_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_project_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		project_unref (value->data[0].v_pointer);
	}
}


static void value_project_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = project_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_project_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_project_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Project* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = project_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_project_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Project** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = project_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecProject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_project (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECT), NULL);
	return value->data[0].v_pointer;
}


void value_set_project (GValue* value, gpointer v_object) {
	Project* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		project_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		project_unref (old);
	}
}


void value_take_project (GValue* value, gpointer v_object) {
	Project* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		project_unref (old);
	}
}


static void project_class_init (ProjectClass * klass) {
	project_parent_class = g_type_class_peek_parent (klass);
	PROJECT_CLASS (klass)->finalize = project_finalize;
	g_type_class_add_private (klass, sizeof (ProjectPrivate));
}


static void project_instance_init (Project * self) {
	self->priv = PROJECT_GET_PRIVATE (self);
	self->priv->_pluginsAllowed = FALSE;
	self->priv->designerCount = 0;
	self->ref_count = 1;
}


static void project_finalize (Project* obj) {
	Project * self;
	FILE* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECT, Project);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Project Destroyed.\n");
	self->customComponentDefs = (_vala_array_free (self->customComponentDefs, self->customComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	self->pluginComponentDefs = (_vala_array_free (self->pluginComponentDefs, self->pluginComponentDefs_length1, (GDestroyNotify) component_def_unref), NULL);
	self->pluginComponentManagers = (_vala_array_free (self->pluginComponentManagers, self->pluginComponentManagers_length1, (GDestroyNotify) plugin_component_manager_unref), NULL);
	_component_def_unref0 (self->rootComponent);
	_g_free0 (self->priv->_name);
	_g_free0 (self->description);
	self->priv->designers = (_vala_array_free (self->priv->designers, self->priv->designers_length1, (GDestroyNotify) designer_unref), NULL);
	_g_free0 (self->filename);
}


/**
 * Container for a circuit design.
 * 
 * Stores the custom component definitions, root component details,
 * and manages initiation of simulation/validation tasks.
 */
GType project_get_type (void) {
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_project_init, value_project_free_value, value_project_copy_value, value_project_peek_pointer, "p", value_project_collect_value, "p", value_project_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) project_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Project), 0, (GInstanceInitFunc) project_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType project_type_id;
		project_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Project", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}


gpointer project_ref (gpointer instance) {
	Project* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void project_unref (gpointer instance) {
	Project* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



