/* propertyitem-propertyset.c generated by valac 0.24.0, the Vala compiler
 * generated from propertyitem-propertyset.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: propertyitem/propertyitem-propertyset.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;
typedef struct _PropertyItemPrivate PropertyItemPrivate;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;
typedef struct _PropertySetPrivate PropertySetPrivate;
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))

struct _PropertyItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PropertyItemPrivate * priv;
	gchar* name;
	gchar* description;
};

struct _PropertyItemClass {
	GTypeClass parent_class;
	void (*finalize) (PropertyItem *self);
	GtkWidget* (*create_widget) (PropertyItem* self);
	void (*read_widget) (PropertyItem* self, GtkWidget* propertyWidget);
};

struct _PropertySet {
	PropertyItem parent_instance;
	PropertySetPrivate * priv;
	PropertyItem** propertyItems;
	gint propertyItems_length1;
};

struct _PropertySetClass {
	PropertyItemClass parent_class;
};


static gpointer property_set_parent_class = NULL;

gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
enum  {
	PROPERTY_SET_DUMMY_PROPERTY
};
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
PropertyItem* property_item_construct (GType object_type, const gchar* name, const gchar* description);
PropertySet* property_set_new_copy (PropertySet* source);
PropertySet* property_set_construct_copy (GType object_type, PropertySet* source);
static void _vala_array_add91 (PropertyItem*** array, int* length, int* size, PropertyItem* value);
static PropertyItem** _vala_array_dup74 (PropertyItem** self, int length);
gint property_set_index_of_item (PropertySet* self, const gchar* name);
PropertyItem* property_set_get_item (PropertySet* self, const gchar* name);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
static PropertyItem** _vala_array_dup75 (PropertyItem** self, int length);
static void _vala_array_add92 (PropertyItem*** array, int* length, int* size, PropertyItem* value);
static PropertyItem** _vala_array_dup76 (PropertyItem** self, int length);
static void property_set_finalize (PropertyItem* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Creates a new PropertySet with a name and description.
 */
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description) {
	PropertySet* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PropertyItem** _tmp2_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = description;
	self = (PropertySet*) property_item_construct (object_type, _tmp0_, _tmp1_);
	_tmp2_ = g_new0 (PropertyItem*, 0 + 1);
	self->propertyItems = (_vala_array_free (self->propertyItems, self->propertyItems_length1, (GDestroyNotify) property_item_unref), NULL);
	self->propertyItems = _tmp2_;
	self->propertyItems_length1 = 0;
	return self;
}


PropertySet* property_set_new (const gchar* name, const gchar* description) {
	return property_set_construct (TYPE_PROPERTY_SET, name, description);
}


static gpointer _property_item_ref0 (gpointer self) {
	return self ? property_item_ref (self) : NULL;
}


static void _vala_array_add91 (PropertyItem*** array, int* length, int* size, PropertyItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PropertyItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PropertyItem** _vala_array_dup74 (PropertyItem** self, int length) {
	PropertyItem** result;
	int i;
	result = g_new0 (PropertyItem*, length + 1);
	for (i = 0; i < length; i++) {
		PropertyItem* _tmp0_ = NULL;
		_tmp0_ = _property_item_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


PropertySet* property_set_construct_copy (GType object_type, PropertySet* source) {
	PropertySet* self = NULL;
	PropertySet* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PropertySet* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	PropertyItem** newPropertyItems = NULL;
	PropertyItem** _tmp4_ = NULL;
	gint newPropertyItems_length1 = 0;
	gint _newPropertyItems_size_ = 0;
	PropertySet* _tmp5_ = NULL;
	PropertyItem** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	PropertyItem** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	PropertyItem** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = source;
	_tmp1_ = ((PropertyItem*) _tmp0_)->name;
	_tmp2_ = source;
	_tmp3_ = ((PropertyItem*) _tmp2_)->description;
	self = (PropertySet*) property_item_construct (object_type, _tmp1_, _tmp3_);
	_tmp4_ = g_new0 (PropertyItem*, 0 + 1);
	newPropertyItems = _tmp4_;
	newPropertyItems_length1 = 0;
	_newPropertyItems_size_ = newPropertyItems_length1;
	_tmp5_ = source;
	_tmp6_ = _tmp5_->propertyItems;
	_tmp6__length1 = _tmp5_->propertyItems_length1;
	{
		PropertyItem** propertyItem_collection = NULL;
		gint propertyItem_collection_length1 = 0;
		gint _propertyItem_collection_size_ = 0;
		gint propertyItem_it = 0;
		propertyItem_collection = _tmp6_;
		propertyItem_collection_length1 = _tmp6__length1;
		for (propertyItem_it = 0; propertyItem_it < _tmp6__length1; propertyItem_it = propertyItem_it + 1) {
			PropertyItem* _tmp7_ = NULL;
			PropertyItem* propertyItem = NULL;
			_tmp7_ = _property_item_ref0 (propertyItem_collection[propertyItem_it]);
			propertyItem = _tmp7_;
			{
				PropertyItem** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				PropertyItem* _tmp9_ = NULL;
				PropertyItem* _tmp10_ = NULL;
				_tmp8_ = newPropertyItems;
				_tmp8__length1 = newPropertyItems_length1;
				_tmp9_ = propertyItem;
				_tmp10_ = _property_item_ref0 (_tmp9_);
				_vala_array_add91 (&newPropertyItems, &newPropertyItems_length1, &_newPropertyItems_size_, _tmp10_);
				_property_item_unref0 (propertyItem);
			}
		}
	}
	_tmp11_ = newPropertyItems;
	_tmp11__length1 = newPropertyItems_length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup74 (_tmp11_, _tmp11__length1) : ((gpointer) _tmp11_);
	_tmp12__length1 = _tmp11__length1;
	self->propertyItems = (_vala_array_free (self->propertyItems, self->propertyItems_length1, (GDestroyNotify) property_item_unref), NULL);
	self->propertyItems = _tmp12_;
	self->propertyItems_length1 = _tmp12__length1;
	newPropertyItems = (_vala_array_free (newPropertyItems, newPropertyItems_length1, (GDestroyNotify) property_item_unref), NULL);
	return self;
}


PropertySet* property_set_new_copy (PropertySet* source) {
	return property_set_construct_copy (TYPE_PROPERTY_SET, source);
}


/**
 * Returns the ID of the property with name //name//. Returns -1 if
 * there is no property with that name.
 */
gint property_set_index_of_item (PropertySet* self, const gchar* name) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				PropertyItem** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				const gchar* _tmp4_ = NULL;
				PropertyItem** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				PropertyItem* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->propertyItems;
				_tmp3__length1 = self->propertyItems_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = name;
				_tmp5_ = self->propertyItems;
				_tmp5__length1 = self->propertyItems_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = _tmp7_->name;
				if (g_strcmp0 (_tmp4_, _tmp8_) == 0) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


PropertyItem* property_set_get_item (PropertySet* self, const gchar* name) {
	PropertyItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				PropertyItem** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				const gchar* _tmp4_ = NULL;
				PropertyItem** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				PropertyItem* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->propertyItems;
				_tmp3__length1 = self->propertyItems_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = name;
				_tmp5_ = self->propertyItems;
				_tmp5__length1 = self->propertyItems_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = _tmp7_->name;
				if (g_strcmp0 (_tmp4_, _tmp8_) == 0) {
					PropertyItem** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					PropertyItem* _tmp11_ = NULL;
					PropertyItem* _tmp12_ = NULL;
					_tmp9_ = self->propertyItems;
					_tmp9__length1 = self->propertyItems_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = _property_item_ref0 (_tmp11_);
					result = _tmp12_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static PropertyItem** _vala_array_dup75 (PropertyItem** self, int length) {
	PropertyItem** result;
	int i;
	result = g_new0 (PropertyItem*, length + 1);
	for (i = 0; i < length; i++) {
		PropertyItem* _tmp0_ = NULL;
		_tmp0_ = _property_item_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add92 (PropertyItem*** array, int* length, int* size, PropertyItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PropertyItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static PropertyItem** _vala_array_dup76 (PropertyItem** self, int length) {
	PropertyItem** result;
	int i;
	result = g_new0 (PropertyItem*, length + 1);
	for (i = 0; i < length; i++) {
		PropertyItem* _tmp0_ = NULL;
		_tmp0_ = _property_item_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem) {
	gint result = 0;
	PropertyItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	PropertyItem** newPropertyItems = NULL;
	PropertyItem** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	PropertyItem** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint newPropertyItems_length1 = 0;
	gint _newPropertyItems_size_ = 0;
	PropertyItem** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	PropertyItem* _tmp6_ = NULL;
	PropertyItem* _tmp7_ = NULL;
	PropertyItem** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	PropertyItem** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (propertyItem != NULL, 0);
	_tmp0_ = propertyItem;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = property_set_index_of_item (self, _tmp1_);
	if (_tmp2_ != (-1)) {
		result = 1;
		return result;
	}
	_tmp3_ = self->propertyItems;
	_tmp3__length1 = self->propertyItems_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup75 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	newPropertyItems = _tmp4_;
	newPropertyItems_length1 = _tmp4__length1;
	_newPropertyItems_size_ = newPropertyItems_length1;
	_tmp5_ = newPropertyItems;
	_tmp5__length1 = newPropertyItems_length1;
	_tmp6_ = propertyItem;
	_tmp7_ = _property_item_ref0 (_tmp6_);
	_vala_array_add92 (&newPropertyItems, &newPropertyItems_length1, &_newPropertyItems_size_, _tmp7_);
	_tmp8_ = newPropertyItems;
	_tmp8__length1 = newPropertyItems_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup76 (_tmp8_, _tmp8__length1) : ((gpointer) _tmp8_);
	_tmp9__length1 = _tmp8__length1;
	self->propertyItems = (_vala_array_free (self->propertyItems, self->propertyItems_length1, (GDestroyNotify) property_item_unref), NULL);
	self->propertyItems = _tmp9_;
	self->propertyItems_length1 = _tmp9__length1;
	result = 0;
	newPropertyItems = (_vala_array_free (newPropertyItems, newPropertyItems_length1, (GDestroyNotify) property_item_unref), NULL);
	return result;
}


static void property_set_class_init (PropertySetClass * klass) {
	property_set_parent_class = g_type_class_peek_parent (klass);
	PROPERTY_ITEM_CLASS (klass)->finalize = property_set_finalize;
}


static void property_set_instance_init (PropertySet * self) {
}


static void property_set_finalize (PropertyItem* obj) {
	PropertySet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTY_SET, PropertySet);
	self->propertyItems = (_vala_array_free (self->propertyItems, self->propertyItems_length1, (GDestroyNotify) property_item_unref), NULL);
	PROPERTY_ITEM_CLASS (property_set_parent_class)->finalize (obj);
}


/**
 * Stores a range of different data types.
 * 
 * Can be used as both a storage medium for data, and as a method of
 * obtaining a variety of data from the user using a PropertiesQuery.
 */
GType property_set_get_type (void) {
	static volatile gsize property_set_type_id__volatile = 0;
	if (g_once_init_enter (&property_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropertySetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) property_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropertySet), 0, (GInstanceInitFunc) property_set_instance_init, NULL };
		GType property_set_type_id;
		property_set_type_id = g_type_register_static (TYPE_PROPERTY_ITEM, "PropertySet", &g_define_type_info, 0);
		g_once_init_leave (&property_set_type_id__volatile, property_set_type_id);
	}
	return property_set_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



