/* simulatorwindow.c generated by valac 0.24.0, the Vala compiler
 * generated from simulatorwindow.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: simulatorwindow.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <config.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_SIMULATOR_WINDOW (simulator_window_get_type ())
#define SIMULATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMULATOR_WINDOW, SimulatorWindow))
#define SIMULATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMULATOR_WINDOW, SimulatorWindowClass))
#define IS_SIMULATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMULATOR_WINDOW))
#define IS_SIMULATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMULATOR_WINDOW))
#define SIMULATOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMULATOR_WINDOW, SimulatorWindowClass))

typedef struct _SimulatorWindow SimulatorWindow;
typedef struct _SimulatorWindowClass SimulatorWindowClass;
typedef struct _SimulatorWindowPrivate SimulatorWindowPrivate;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define SIMULATOR_WINDOW_TYPE_MOUSE_MODE (simulator_window_mouse_mode_get_type ())

#define SIMULATOR_WINDOW_TYPE_RUN_STATE (simulator_window_run_state_get_type ())

#define TYPE_TIMING_DIAGRAM (timing_diagram_get_type ())
#define TIMING_DIAGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMING_DIAGRAM, TimingDiagram))
#define TIMING_DIAGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMING_DIAGRAM, TimingDiagramClass))
#define IS_TIMING_DIAGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMING_DIAGRAM))
#define IS_TIMING_DIAGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMING_DIAGRAM))
#define TIMING_DIAGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMING_DIAGRAM, TimingDiagramClass))

typedef struct _TimingDiagram TimingDiagram;
typedef struct _TimingDiagramClass TimingDiagramClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _compiled_circuit_unref0(var) ((var == NULL) ? NULL : (var = (compiled_circuit_unref (var), NULL)))
typedef struct _CompiledCircuitPrivate CompiledCircuitPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_UPDATE_QUEUE (update_queue_get_type ())
#define UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPDATE_QUEUE, UpdateQueue))
#define UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPDATE_QUEUE, UpdateQueueClass))
#define IS_UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPDATE_QUEUE))
#define IS_UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPDATE_QUEUE))
#define UPDATE_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPDATE_QUEUE, UpdateQueueClass))

typedef struct _UpdateQueue UpdateQueue;
typedef struct _UpdateQueueClass UpdateQueueClass;

#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _wire_state_unref0(var) ((var == NULL) ? NULL : (var = (wire_state_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _ProjectPrivate ProjectPrivate;

#define TYPE_PLUGIN_COMPONENT_DEF (plugin_component_def_get_type ())
#define PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDef))
#define PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))
#define IS_PLUGIN_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_DEF))
#define IS_PLUGIN_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_DEF))
#define PLUGIN_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_DEF, PluginComponentDefClass))

typedef struct _PluginComponentDef PluginComponentDef;
typedef struct _PluginComponentDefClass PluginComponentDefClass;

#define TYPE_PLUGIN_COMPONENT_MANAGER (plugin_component_manager_get_type ())
#define PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManager))
#define PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))
#define IS_PLUGIN_COMPONENT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLUGIN_COMPONENT_MANAGER))
#define IS_PLUGIN_COMPONENT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLUGIN_COMPONENT_MANAGER))
#define PLUGIN_COMPONENT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLUGIN_COMPONENT_MANAGER, PluginComponentManagerClass))

typedef struct _PluginComponentManager PluginComponentManager;
typedef struct _PluginComponentManagerClass PluginComponentManagerClass;

struct _SimulatorWindow {
	GtkWindow parent_instance;
	SimulatorWindowPrivate * priv;
	gint gridSize;
	gfloat zoom;
};

struct _SimulatorWindowClass {
	GtkWindowClass parent_class;
};

typedef enum  {
	SIMULATOR_WINDOW_MOUSE_MODE_SCROLL,
	SIMULATOR_WINDOW_MOUSE_MODE_ZOOM,
	SIMULATOR_WINDOW_MOUSE_MODE_CONTEXT,
	SIMULATOR_WINDOW_MOUSE_MODE_INTERACT,
	SIMULATOR_WINDOW_MOUSE_MODE_EXPLORE,
	SIMULATOR_WINDOW_MOUSE_MODE_WATCH
} SimulatorWindowMouseMode;

typedef enum  {
	SIMULATOR_WINDOW_RUN_STATE_PAUSED,
	SIMULATOR_WINDOW_RUN_STATE_STEPPING,
	SIMULATOR_WINDOW_RUN_STATE_RUNNING,
	SIMULATOR_WINDOW_RUN_STATE_HALTING,
	SIMULATOR_WINDOW_RUN_STATE_ERROR
} SimulatorWindowRunState;

struct _SimulatorWindowPrivate {
	GtkBox* vBox;
	GtkMenuBar* menubar;
	GtkMenuItem* menuSimulation;
	GtkMenu* menuSimulationMenu;
	GtkCheckMenuItem* menuSimulationRun;
	GtkMenuItem* menuSimulationSeparator1;
	GtkMenuItem* menuSimulationExit;
	GtkMenuItem* menuView;
	GtkMenu* menuViewMenu;
	GtkMenuItem* menuViewFitdesign;
	GtkCheckMenuItem* menuViewAutofitdesign;
	GtkMenuItem* menuViewSeparator1;
	GtkMenuItem* menuViewTimingdiagram;
	GtkToolbar* toolbar;
	GtkRadioToolButton* toolScroll;
	GtkImage* toolScrollImage;
	GtkRadioToolButton* toolZoom;
	GtkImage* toolZoomImage;
	GtkSeparatorToolItem* toolSeparator1;
	GtkRadioToolButton* toolContext;
	GtkImage* toolContextImage;
	GtkRadioToolButton* toolInteract;
	GtkImage* toolInteractImage;
	GtkRadioToolButton* toolExplore;
	GtkImage* toolExploreImage;
	GtkRadioToolButton* toolWatch;
	GtkImage* toolWatchImage;
	GtkSeparatorToolItem* toolSeparator2;
	GtkToolButton* toolShrink;
	GtkImage* toolShrinkImage;
	GtkSeparatorToolItem* toolSeparator3;
	GtkToggleToolButton* toolRun;
	GtkImage* toolRunImage;
	GtkToolButton* toolSinglestep;
	GtkImage* toolSinglestepImage;
	GtkToolButton* toolMultistep;
	GtkImage* toolMultistepImage;
	GtkSeparatorToolItem* toolSeparator4;
	GtkToggleToolButton* toolMaxspeed;
	GtkImage* toolMaxspeedImage;
	GtkToolItem* toolSpeed;
	GtkBox* toolSpeedBox;
	GtkLabel* toolSpeedLabel;
	GtkSpinButton* toolSpeedSpin;
	GtkSeparatorToolItem* toolSeparator5;
	GtkToolItem* toolStepsize;
	GtkBox* toolStepsizeBox;
	GtkLabel* toolStepsizeLabel;
	GtkSpinButton* toolStepsizeSpin;
	GtkEventBox* controller;
	GtkDrawingArea* display;
	CompiledCircuit* compiledCircuit;
	gint xMouseStart;
	gint yMouseStart;
	SimulatorWindowMouseMode mouseMode;
	gint xView;
	gint yView;
	SimulatorWindowRunState runState;
	gint cycleDelay;
	gint multistepSize;
	gint stepsLeft;
	guint cycleSourceID;
	guint refreshSourceID;
	gint microCycleDelay;
	gdouble timeBeforeRender;
	gboolean inhibitRender;
	gboolean autoFitDesign;
	TimingDiagram* timingDiagram;
};

struct _CompiledCircuit {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompiledCircuitPrivate * priv;
	CustomComponentDef* rootComponent;
	Project* project;
	UpdateQueue* renderWireStates;
	UpdateQueue* renderComponentStates;
	UpdateQueue* processWireStates;
	UpdateQueue* processComponentStates;
	CustomComponentDef* viewedComponent;
	gint iterationCount;
};

struct _CompiledCircuitClass {
	GTypeClass parent_class;
	void (*finalize) (CompiledCircuit *self);
};

struct _Project {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectPrivate * priv;
	gboolean running;
	CustomComponentDef** customComponentDefs;
	gint customComponentDefs_length1;
	PluginComponentDef** pluginComponentDefs;
	gint pluginComponentDefs_length1;
	PluginComponentManager** pluginComponentManagers;
	gint pluginComponentManagers_length1;
	CustomComponentDef* rootComponent;
	gint myID;
	gchar* description;
	gchar* filename;
};

struct _ProjectClass {
	GTypeClass parent_class;
	void (*finalize) (Project *self);
};


static gpointer simulator_window_parent_class = NULL;

GType simulator_window_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
static GType simulator_window_mouse_mode_get_type (void) G_GNUC_UNUSED;
GType simulator_window_run_state_get_type (void) G_GNUC_CONST;
GType timing_diagram_get_type (void) G_GNUC_CONST;
#define SIMULATOR_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMULATOR_WINDOW, SimulatorWindowPrivate))
enum  {
	SIMULATOR_WINDOW_DUMMY_PROPERTY
};
void timing_diagram_close_diagram (TimingDiagram* self);
SimulatorWindow* simulator_window_new (CompiledCircuit* compiledCircuit);
SimulatorWindow* simulator_window_construct (GType object_type, CompiledCircuit* compiledCircuit);
void simulator_window_populate (SimulatorWindow* self);
void simulator_window_close_simulation (SimulatorWindow* self);
static void _simulator_window_close_simulation_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
#define CORE_programName "SmartSim"
static void __lambda38_ (SimulatorWindow* self);
static void simulator_window_run_toggle (SimulatorWindow* self, GtkWidget* widget);
static void ___lambda38__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda39_ (SimulatorWindow* self);
static void ___lambda39__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda40_ (SimulatorWindow* self);
static void simulator_window_fit_design (SimulatorWindow* self);
static void ___lambda40__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda41_ (SimulatorWindow* self, GtkCheckMenuItem* menuItem);
static void ___lambda41__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda42_ (SimulatorWindow* self);
static void simulator_window_show_timing_diagram (SimulatorWindow* self);
static void ___lambda42__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda43_ (SimulatorWindow* self);
static void ___lambda43__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda44_ (SimulatorWindow* self);
static void ___lambda44__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda45_ (SimulatorWindow* self);
static void ___lambda45__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda46_ (SimulatorWindow* self);
static void ___lambda46__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda47_ (SimulatorWindow* self);
static void ___lambda47__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda48_ (SimulatorWindow* self);
static void ___lambda48__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda49_ (SimulatorWindow* self);
void compiled_circuit_shrink_component (CompiledCircuit* self);
gboolean simulator_window_render (SimulatorWindow* self, gboolean fullRefresh, gboolean cancelIfRunning, cairo_t* passedDisplayContext);
static void ___lambda49__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda50_ (SimulatorWindow* self);
static void ___lambda50__gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void __lambda51_ (SimulatorWindow* self);
static void simulator_window_step (SimulatorWindow* self, gboolean multistep);
static void ___lambda51__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda52_ (SimulatorWindow* self);
static void ___lambda52__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda53_ (SimulatorWindow* self);
static void simulator_window_change_speed (SimulatorWindow* self, gint newCycleDelay);
static void ___lambda53__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void __lambda54_ (SimulatorWindow* self);
static void ___lambda54__gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void __lambda55_ (SimulatorWindow* self);
static void ___lambda55__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static gboolean simulator_window_mouse_down (SimulatorWindow* self, GdkEventButton* event);
static gboolean _simulator_window_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean simulator_window_mouse_up (SimulatorWindow* self, GdkEventButton* event);
static gboolean _simulator_window_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda56_ (SimulatorWindow* self, cairo_t* context);
static gboolean ___lambda56__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
TimingDiagram* timing_diagram_new (CompiledCircuit* compiledCircuit);
TimingDiagram* timing_diagram_construct (GType object_type, CompiledCircuit* compiledCircuit);
void simulator_window_pause (SimulatorWindow* self);
void simulator_window_run (SimulatorWindow* self);
static gboolean simulator_window_update_cycle (SimulatorWindow* self);
static gboolean _simulator_window_update_cycle_gsource_func (gpointer self);
static gboolean simulator_window_refresh_cycle (SimulatorWindow* self);
static gboolean _simulator_window_refresh_cycle_gsource_func (gpointer self);
gboolean timing_diagram_render (TimingDiagram* self, gboolean fullRefresh, cairo_t* passedDisplayContext);
void timing_diagram_show_diagram (TimingDiagram* self);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer update_queue_ref (gpointer instance);
void update_queue_unref (gpointer instance);
GParamSpec* param_spec_update_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_update_queue (GValue* value, gpointer v_object);
void value_take_update_queue (GValue* value, gpointer v_object);
gpointer value_get_update_queue (const GValue* value);
GType update_queue_get_type (void) G_GNUC_CONST;
gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
void custom_component_def_get_design_bounds (CustomComponentDef* self, gint* right, gint* down, gint* left, gint* up);
gint compiled_circuit_update_cycle (CompiledCircuit* self);
const gchar* compiled_circuit_get_errorMessage (CompiledCircuit* self);
void basic_dialog_error (GtkWindow* window, const gchar* text);
void compiled_circuit_interact_components (CompiledCircuit* self, gint xInteract, gint yInteract);
gint compiled_circuit_expand_component (CompiledCircuit* self, gint x, gint y);
WireState* compiled_circuit_find_wire (CompiledCircuit* self, gint x, gint y);
void timing_diagram_add_wire (TimingDiagram* self, WireState* newWireState);
void compiled_circuit_render (CompiledCircuit* self, cairo_t* context, gboolean fullRender, gfloat zoom);
void basic_dialog_information (GtkWindow* window, const gchar* text);
GType plugin_component_def_get_type (void) G_GNUC_CONST;
gpointer plugin_component_manager_ref (gpointer instance);
void plugin_component_manager_unref (gpointer instance);
GParamSpec* param_spec_plugin_component_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_plugin_component_manager (GValue* value, gpointer v_object);
void value_take_plugin_component_manager (GValue* value, gpointer v_object);
gpointer value_get_plugin_component_manager (const GValue* value);
GType plugin_component_manager_get_type (void) G_GNUC_CONST;
static void simulator_window_finalize (GObject* obj);


/**
 * Actions to perform when the mouse button is released.
 */
static GType simulator_window_mouse_mode_get_type (void) {
	static volatile gsize simulator_window_mouse_mode_type_id__volatile = 0;
	if (g_once_init_enter (&simulator_window_mouse_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SIMULATOR_WINDOW_MOUSE_MODE_SCROLL, "SIMULATOR_WINDOW_MOUSE_MODE_SCROLL", "scroll"}, {SIMULATOR_WINDOW_MOUSE_MODE_ZOOM, "SIMULATOR_WINDOW_MOUSE_MODE_ZOOM", "zoom"}, {SIMULATOR_WINDOW_MOUSE_MODE_CONTEXT, "SIMULATOR_WINDOW_MOUSE_MODE_CONTEXT", "context"}, {SIMULATOR_WINDOW_MOUSE_MODE_INTERACT, "SIMULATOR_WINDOW_MOUSE_MODE_INTERACT", "interact"}, {SIMULATOR_WINDOW_MOUSE_MODE_EXPLORE, "SIMULATOR_WINDOW_MOUSE_MODE_EXPLORE", "explore"}, {SIMULATOR_WINDOW_MOUSE_MODE_WATCH, "SIMULATOR_WINDOW_MOUSE_MODE_WATCH", "watch"}, {0, NULL, NULL}};
		GType simulator_window_mouse_mode_type_id;
		simulator_window_mouse_mode_type_id = g_enum_register_static ("SimulatorWindowMouseMode", values);
		g_once_init_leave (&simulator_window_mouse_mode_type_id__volatile, simulator_window_mouse_mode_type_id);
	}
	return simulator_window_mouse_mode_type_id__volatile;
}


/**
 * The states the simulation can be in. (e.g. running, paused...)
 */
GType simulator_window_run_state_get_type (void) {
	static volatile gsize simulator_window_run_state_type_id__volatile = 0;
	if (g_once_init_enter (&simulator_window_run_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SIMULATOR_WINDOW_RUN_STATE_PAUSED, "SIMULATOR_WINDOW_RUN_STATE_PAUSED", "paused"}, {SIMULATOR_WINDOW_RUN_STATE_STEPPING, "SIMULATOR_WINDOW_RUN_STATE_STEPPING", "stepping"}, {SIMULATOR_WINDOW_RUN_STATE_RUNNING, "SIMULATOR_WINDOW_RUN_STATE_RUNNING", "running"}, {SIMULATOR_WINDOW_RUN_STATE_HALTING, "SIMULATOR_WINDOW_RUN_STATE_HALTING", "halting"}, {SIMULATOR_WINDOW_RUN_STATE_ERROR, "SIMULATOR_WINDOW_RUN_STATE_ERROR", "error"}, {0, NULL, NULL}};
		GType simulator_window_run_state_type_id;
		simulator_window_run_state_type_id = g_enum_register_static ("SimulatorWindowRunState", values);
		g_once_init_leave (&simulator_window_run_state_type_id__volatile, simulator_window_run_state_type_id);
	}
	return simulator_window_run_state_type_id__volatile;
}


/**
 * Creates a new Simulator window associated with the
 * CompiledCircuit //compiledCircuit//.
 */
static gpointer _compiled_circuit_ref0 (gpointer self) {
	return self ? compiled_circuit_ref (self) : NULL;
}


SimulatorWindow* simulator_window_construct (GType object_type, CompiledCircuit* compiledCircuit) {
	SimulatorWindow * self = NULL;
	CompiledCircuit* _tmp0_ = NULL;
	CompiledCircuit* _tmp1_ = NULL;
	g_return_val_if_fail (compiledCircuit != NULL, NULL);
	self = (SimulatorWindow*) g_object_new (object_type, NULL);
	_tmp0_ = compiledCircuit;
	_tmp1_ = _compiled_circuit_ref0 (_tmp0_);
	_compiled_circuit_unref0 (self->priv->compiledCircuit);
	self->priv->compiledCircuit = _tmp1_;
	self->priv->runState = SIMULATOR_WINDOW_RUN_STATE_PAUSED;
	simulator_window_populate (self);
	return self;
}


SimulatorWindow* simulator_window_new (CompiledCircuit* compiledCircuit) {
	return simulator_window_construct (TYPE_SIMULATOR_WINDOW, compiledCircuit);
}


/**
 * Populate the window with widgets.
 */
static void _simulator_window_close_simulation_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	simulator_window_close_simulation ((SimulatorWindow*) self);
}


static void __lambda38_ (SimulatorWindow* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	_tmp0_ = self->priv->menuSimulationRun;
	simulator_window_run_toggle (self, (GtkWidget*) _tmp0_);
}


static void ___lambda38__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda38_ ((SimulatorWindow*) self);
}


static void __lambda39_ (SimulatorWindow* self) {
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda39__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda39_ ((SimulatorWindow*) self);
}


static void __lambda40_ (SimulatorWindow* self) {
	simulator_window_fit_design (self);
}


static void ___lambda40__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda40_ ((SimulatorWindow*) self);
}


static void __lambda41_ (SimulatorWindow* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->autoFitDesign = _tmp2_;
}


static void ___lambda41__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda41_ ((SimulatorWindow*) self, _sender);
}


static void __lambda42_ (SimulatorWindow* self) {
	simulator_window_show_timing_diagram (self);
}


static void ___lambda42__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda42_ ((SimulatorWindow*) self);
}


static void __lambda43_ (SimulatorWindow* self) {
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_SCROLL;
}


static void ___lambda43__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda43_ ((SimulatorWindow*) self);
}


static void __lambda44_ (SimulatorWindow* self) {
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_ZOOM;
}


static void ___lambda44__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda44_ ((SimulatorWindow*) self);
}


static void __lambda45_ (SimulatorWindow* self) {
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_CONTEXT;
}


static void ___lambda45__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda45_ ((SimulatorWindow*) self);
}


static void __lambda46_ (SimulatorWindow* self) {
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_INTERACT;
}


static void ___lambda46__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda46_ ((SimulatorWindow*) self);
}


static void __lambda47_ (SimulatorWindow* self) {
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_EXPLORE;
}


static void ___lambda47__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda47_ ((SimulatorWindow*) self);
}


static void __lambda48_ (SimulatorWindow* self) {
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_WATCH;
}


static void ___lambda48__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda48_ ((SimulatorWindow*) self);
}


static void __lambda49_ (SimulatorWindow* self) {
	CompiledCircuit* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = self->priv->compiledCircuit;
	compiled_circuit_shrink_component (_tmp0_);
	_tmp1_ = self->priv->autoFitDesign;
	if (_tmp1_) {
		simulator_window_fit_design (self);
	}
	simulator_window_render (self, TRUE, FALSE, NULL);
}


static void ___lambda49__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda49_ ((SimulatorWindow*) self);
}


static void __lambda50_ (SimulatorWindow* self) {
	GtkToggleToolButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->toolRun;
	simulator_window_run_toggle (self, (GtkWidget*) _tmp0_);
}


static void ___lambda50__gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	__lambda50_ ((SimulatorWindow*) self);
}


static void __lambda51_ (SimulatorWindow* self) {
	simulator_window_step (self, FALSE);
}


static void ___lambda51__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda51_ ((SimulatorWindow*) self);
}


static void __lambda52_ (SimulatorWindow* self) {
	simulator_window_step (self, TRUE);
}


static void ___lambda52__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda52_ ((SimulatorWindow*) self);
}


static void __lambda53_ (SimulatorWindow* self) {
	GtkToggleToolButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->toolMaxspeed;
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkSpinButton* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = self->priv->toolSpeedSpin;
		_tmp4_ = gtk_spin_button_get_value (_tmp3_);
		simulator_window_change_speed (self, (gint) (1000.0 / _tmp4_));
	}
}


static void ___lambda53__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	__lambda53_ ((SimulatorWindow*) self);
}


static void __lambda54_ (SimulatorWindow* self) {
	GtkToggleToolButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->toolMaxspeed;
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkSpinButton* _tmp3_ = NULL;
		_tmp3_ = self->priv->toolSpeedSpin;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		simulator_window_change_speed (self, 0);
	} else {
		GtkSpinButton* _tmp4_ = NULL;
		GtkSpinButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		_tmp4_ = self->priv->toolSpeedSpin;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
		_tmp5_ = self->priv->toolSpeedSpin;
		_tmp6_ = gtk_spin_button_get_value (_tmp5_);
		simulator_window_change_speed (self, (gint) (1000.0 / _tmp6_));
	}
}


static void ___lambda54__gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
	__lambda54_ ((SimulatorWindow*) self);
}


static void __lambda55_ (SimulatorWindow* self) {
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	_tmp0_ = self->priv->toolStepsizeSpin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	self->priv->multistepSize = _tmp1_;
}


static void ___lambda55__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	__lambda55_ ((SimulatorWindow*) self);
}


static gboolean _simulator_window_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = simulator_window_mouse_down ((SimulatorWindow*) self, event);
	return result;
}


static gboolean _simulator_window_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = simulator_window_mouse_up ((SimulatorWindow*) self, event);
	return result;
}


static gboolean __lambda56_ (SimulatorWindow* self, cairo_t* context) {
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	simulator_window_render (self, TRUE, FALSE, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda56__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = __lambda56_ ((SimulatorWindow*) self, cr);
	return result;
}


void simulator_window_populate (SimulatorWindow* self) {
	FILE* _tmp0_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkMenuBar* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkMenuBar* _tmp8_ = NULL;
	GtkMenuItem* _tmp9_ = NULL;
	GtkMenuBar* _tmp10_ = NULL;
	GtkMenuItem* _tmp11_ = NULL;
	GtkMenu* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_ = NULL;
	GtkMenu* _tmp14_ = NULL;
	GtkCheckMenuItem* _tmp15_ = NULL;
	GtkMenu* _tmp16_ = NULL;
	GtkCheckMenuItem* _tmp17_ = NULL;
	GtkCheckMenuItem* _tmp18_ = NULL;
	GtkSeparatorMenuItem* _tmp19_ = NULL;
	GtkMenu* _tmp20_ = NULL;
	GtkMenuItem* _tmp21_ = NULL;
	GtkMenuItem* _tmp22_ = NULL;
	GtkMenu* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_ = NULL;
	GtkMenuItem* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_ = NULL;
	GtkMenuBar* _tmp27_ = NULL;
	GtkMenuItem* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
	GtkMenuItem* _tmp30_ = NULL;
	GtkMenu* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_ = NULL;
	GtkMenu* _tmp33_ = NULL;
	GtkMenuItem* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_ = NULL;
	GtkCheckMenuItem* _tmp36_ = NULL;
	GtkMenu* _tmp37_ = NULL;
	GtkCheckMenuItem* _tmp38_ = NULL;
	GtkCheckMenuItem* _tmp39_ = NULL;
	GtkCheckMenuItem* _tmp40_ = NULL;
	GtkSeparatorMenuItem* _tmp41_ = NULL;
	GtkMenu* _tmp42_ = NULL;
	GtkMenuItem* _tmp43_ = NULL;
	GtkMenuItem* _tmp44_ = NULL;
	GtkMenu* _tmp45_ = NULL;
	GtkMenuItem* _tmp46_ = NULL;
	GtkMenuItem* _tmp47_ = NULL;
	GtkToolbar* _tmp48_ = NULL;
	GtkToolbar* _tmp49_ = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkToolbar* _tmp51_ = NULL;
	GtkImage* _tmp52_ = NULL;
	GtkRadioToolButton* _tmp53_ = NULL;
	GtkRadioToolButton* _tmp54_ = NULL;
	GtkRadioToolButton* _tmp55_ = NULL;
	GtkImage* _tmp56_ = NULL;
	GtkToolbar* _tmp57_ = NULL;
	GtkRadioToolButton* _tmp58_ = NULL;
	GtkRadioToolButton* _tmp59_ = NULL;
	GtkRadioToolButton* _tmp60_ = NULL;
	GtkImage* _tmp61_ = NULL;
	GtkRadioToolButton* _tmp62_ = NULL;
	GtkRadioToolButton* _tmp63_ = NULL;
	GtkRadioToolButton* _tmp64_ = NULL;
	GtkRadioToolButton* _tmp65_ = NULL;
	GtkImage* _tmp66_ = NULL;
	GtkToolbar* _tmp67_ = NULL;
	GtkRadioToolButton* _tmp68_ = NULL;
	GtkRadioToolButton* _tmp69_ = NULL;
	GtkRadioToolButton* _tmp70_ = NULL;
	GtkSeparatorToolItem* _tmp71_ = NULL;
	GtkToolbar* _tmp72_ = NULL;
	GtkSeparatorToolItem* _tmp73_ = NULL;
	GtkImage* _tmp74_ = NULL;
	GtkRadioToolButton* _tmp75_ = NULL;
	GtkRadioToolButton* _tmp76_ = NULL;
	GtkRadioToolButton* _tmp77_ = NULL;
	GtkRadioToolButton* _tmp78_ = NULL;
	GtkImage* _tmp79_ = NULL;
	GtkToolbar* _tmp80_ = NULL;
	GtkRadioToolButton* _tmp81_ = NULL;
	GtkRadioToolButton* _tmp82_ = NULL;
	GtkRadioToolButton* _tmp83_ = NULL;
	GtkRadioToolButton* _tmp84_ = NULL;
	GtkImage* _tmp85_ = NULL;
	GtkRadioToolButton* _tmp86_ = NULL;
	GtkRadioToolButton* _tmp87_ = NULL;
	GtkRadioToolButton* _tmp88_ = NULL;
	GtkRadioToolButton* _tmp89_ = NULL;
	GtkImage* _tmp90_ = NULL;
	GtkToolbar* _tmp91_ = NULL;
	GtkRadioToolButton* _tmp92_ = NULL;
	GtkRadioToolButton* _tmp93_ = NULL;
	GtkRadioToolButton* _tmp94_ = NULL;
	GtkImage* _tmp95_ = NULL;
	GtkRadioToolButton* _tmp96_ = NULL;
	GtkRadioToolButton* _tmp97_ = NULL;
	GtkRadioToolButton* _tmp98_ = NULL;
	GtkRadioToolButton* _tmp99_ = NULL;
	GtkImage* _tmp100_ = NULL;
	GtkToolbar* _tmp101_ = NULL;
	GtkRadioToolButton* _tmp102_ = NULL;
	GtkRadioToolButton* _tmp103_ = NULL;
	GtkRadioToolButton* _tmp104_ = NULL;
	GtkImage* _tmp105_ = NULL;
	GtkRadioToolButton* _tmp106_ = NULL;
	GtkRadioToolButton* _tmp107_ = NULL;
	GtkRadioToolButton* _tmp108_ = NULL;
	GtkRadioToolButton* _tmp109_ = NULL;
	GtkImage* _tmp110_ = NULL;
	GtkToolbar* _tmp111_ = NULL;
	GtkRadioToolButton* _tmp112_ = NULL;
	GtkRadioToolButton* _tmp113_ = NULL;
	GtkRadioToolButton* _tmp114_ = NULL;
	GtkSeparatorToolItem* _tmp115_ = NULL;
	GtkToolbar* _tmp116_ = NULL;
	GtkSeparatorToolItem* _tmp117_ = NULL;
	GtkImage* _tmp118_ = NULL;
	GtkImage* _tmp119_ = NULL;
	GtkToolButton* _tmp120_ = NULL;
	GtkToolbar* _tmp121_ = NULL;
	GtkToolButton* _tmp122_ = NULL;
	GtkToolButton* _tmp123_ = NULL;
	GtkToolButton* _tmp124_ = NULL;
	GtkSeparatorToolItem* _tmp125_ = NULL;
	GtkToolbar* _tmp126_ = NULL;
	GtkSeparatorToolItem* _tmp127_ = NULL;
	GtkImage* _tmp128_ = NULL;
	GtkToggleToolButton* _tmp129_ = NULL;
	GtkToggleToolButton* _tmp130_ = NULL;
	GtkToggleToolButton* _tmp131_ = NULL;
	GtkImage* _tmp132_ = NULL;
	GtkToolbar* _tmp133_ = NULL;
	GtkToggleToolButton* _tmp134_ = NULL;
	GtkToggleToolButton* _tmp135_ = NULL;
	GtkToggleToolButton* _tmp136_ = NULL;
	GtkImage* _tmp137_ = NULL;
	GtkImage* _tmp138_ = NULL;
	GtkToolButton* _tmp139_ = NULL;
	GtkToolbar* _tmp140_ = NULL;
	GtkToolButton* _tmp141_ = NULL;
	GtkToolButton* _tmp142_ = NULL;
	GtkToolButton* _tmp143_ = NULL;
	GtkImage* _tmp144_ = NULL;
	GtkImage* _tmp145_ = NULL;
	GtkToolButton* _tmp146_ = NULL;
	GtkToolbar* _tmp147_ = NULL;
	GtkToolButton* _tmp148_ = NULL;
	GtkToolButton* _tmp149_ = NULL;
	GtkToolButton* _tmp150_ = NULL;
	GtkSeparatorToolItem* _tmp151_ = NULL;
	GtkToolbar* _tmp152_ = NULL;
	GtkSeparatorToolItem* _tmp153_ = NULL;
	GtkToolItem* _tmp154_ = NULL;
	GtkToolbar* _tmp155_ = NULL;
	GtkToolItem* _tmp156_ = NULL;
	GtkBox* _tmp157_ = NULL;
	GtkToolItem* _tmp158_ = NULL;
	GtkBox* _tmp159_ = NULL;
	GtkLabel* _tmp160_ = NULL;
	GtkBox* _tmp161_ = NULL;
	GtkLabel* _tmp162_ = NULL;
	GtkSpinButton* _tmp163_ = NULL;
	GtkBox* _tmp164_ = NULL;
	GtkSpinButton* _tmp165_ = NULL;
	GtkSpinButton* _tmp166_ = NULL;
	GtkSpinButton* _tmp167_ = NULL;
	GtkSpinButton* _tmp168_ = NULL;
	GtkSpinButton* _tmp169_ = NULL;
	GtkSpinButton* _tmp170_ = NULL;
	GtkImage* _tmp171_ = NULL;
	GtkToggleToolButton* _tmp172_ = NULL;
	GtkToggleToolButton* _tmp173_ = NULL;
	GtkToggleToolButton* _tmp174_ = NULL;
	GtkImage* _tmp175_ = NULL;
	GtkToolbar* _tmp176_ = NULL;
	GtkToggleToolButton* _tmp177_ = NULL;
	GtkToggleToolButton* _tmp178_ = NULL;
	GtkToggleToolButton* _tmp179_ = NULL;
	GtkToggleToolButton* _tmp180_ = NULL;
	GtkSeparatorToolItem* _tmp181_ = NULL;
	GtkToolbar* _tmp182_ = NULL;
	GtkSeparatorToolItem* _tmp183_ = NULL;
	GtkToolItem* _tmp184_ = NULL;
	GtkToolbar* _tmp185_ = NULL;
	GtkToolItem* _tmp186_ = NULL;
	GtkBox* _tmp187_ = NULL;
	GtkToolItem* _tmp188_ = NULL;
	GtkBox* _tmp189_ = NULL;
	GtkLabel* _tmp190_ = NULL;
	GtkBox* _tmp191_ = NULL;
	GtkLabel* _tmp192_ = NULL;
	GtkSpinButton* _tmp193_ = NULL;
	GtkBox* _tmp194_ = NULL;
	GtkSpinButton* _tmp195_ = NULL;
	GtkSpinButton* _tmp196_ = NULL;
	GtkSpinButton* _tmp197_ = NULL;
	GtkEventBox* _tmp198_ = NULL;
	GtkBox* _tmp199_ = NULL;
	GtkEventBox* _tmp200_ = NULL;
	GtkEventBox* _tmp201_ = NULL;
	GtkEventBox* _tmp202_ = NULL;
	GtkDrawingArea* _tmp203_ = NULL;
	GtkEventBox* _tmp204_ = NULL;
	GtkDrawingArea* _tmp205_ = NULL;
	GtkDrawingArea* _tmp206_ = NULL;
	CompiledCircuit* _tmp207_ = NULL;
	TimingDiagram* _tmp208_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Simulation Window Created\n");
	gtk_window_set_default_size ((GtkWindow*) self, 800, 600);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) _simulator_window_close_simulation_gtk_widget_destroy, self, 0);
	gtk_window_set_title ((GtkWindow*) self, CORE_programName " - Simulation");
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		_tmp2_ = gdk_pixbuf_new_from_file (PACKAGE_DATADIR "images/icons/smartsim64.png", &_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch71_g_error;
		}
		gtk_window_set_icon ((GtkWindow*) self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally71;
	__catch71_g_error:
	{
		FILE* _tmp3_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "Could not load window image.\n");
	}
	__finally71:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->vBox);
	self->priv->vBox = _tmp4_;
	_tmp5_ = self->priv->vBox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkMenuBar*) gtk_menu_bar_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp6_;
	_tmp7_ = self->priv->vBox;
	_tmp8_ = self->priv->menubar;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Simulation");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->menuSimulation);
	self->priv->menuSimulation = _tmp9_;
	_tmp10_ = self->priv->menubar;
	_tmp11_ = self->priv->menuSimulation;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->menuSimulationMenu);
	self->priv->menuSimulationMenu = _tmp12_;
	_tmp13_ = self->priv->menuSimulation;
	_tmp14_ = self->priv->menuSimulationMenu;
	gtk_menu_item_set_submenu (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Run");
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->menuSimulationRun);
	self->priv->menuSimulationRun = _tmp15_;
	_tmp16_ = self->priv->menuSimulationMenu;
	_tmp17_ = self->priv->menuSimulationRun;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp16_, (GtkWidget*) ((GtkMenuItem*) _tmp17_));
	_tmp18_ = self->priv->menuSimulationRun;
	g_signal_connect_object (_tmp18_, "toggled", (GCallback) ___lambda38__gtk_check_menu_item_toggled, self, 0);
	_tmp19_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->menuSimulationSeparator1);
	self->priv->menuSimulationSeparator1 = (GtkMenuItem*) _tmp19_;
	_tmp20_ = self->priv->menuSimulationMenu;
	_tmp21_ = self->priv->menuSimulationSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Close Simulation");
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->menuSimulationExit);
	self->priv->menuSimulationExit = _tmp22_;
	_tmp23_ = self->priv->menuSimulationMenu;
	_tmp24_ = self->priv->menuSimulationExit;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->menuSimulationExit;
	g_signal_connect_object (_tmp25_, "activate", (GCallback) ___lambda39__gtk_menu_item_activate, self, 0);
	_tmp26_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("View");
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->menuView);
	self->priv->menuView = _tmp26_;
	_tmp27_ = self->priv->menubar;
	_tmp28_ = self->priv->menuView;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->menuViewMenu);
	self->priv->menuViewMenu = _tmp29_;
	_tmp30_ = self->priv->menuView;
	_tmp31_ = self->priv->menuViewMenu;
	gtk_menu_item_set_submenu (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Fit Design to Display");
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->menuViewFitdesign);
	self->priv->menuViewFitdesign = _tmp32_;
	_tmp33_ = self->priv->menuViewMenu;
	_tmp34_ = self->priv->menuViewFitdesign;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->menuViewFitdesign;
	g_signal_connect_object (_tmp35_, "activate", (GCallback) ___lambda40__gtk_menu_item_activate, self, 0);
	_tmp36_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Auto Fit When Exploring");
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->menuViewAutofitdesign);
	self->priv->menuViewAutofitdesign = _tmp36_;
	_tmp37_ = self->priv->menuViewMenu;
	_tmp38_ = self->priv->menuViewAutofitdesign;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp37_, (GtkWidget*) ((GtkMenuItem*) _tmp38_));
	_tmp39_ = self->priv->menuViewAutofitdesign;
	gtk_check_menu_item_set_active (_tmp39_, TRUE);
	_tmp40_ = self->priv->menuViewAutofitdesign;
	g_signal_connect_object (_tmp40_, "toggled", (GCallback) ___lambda41__gtk_check_menu_item_toggled, self, 0);
	_tmp41_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->menuViewSeparator1);
	self->priv->menuViewSeparator1 = (GtkMenuItem*) _tmp41_;
	_tmp42_ = self->priv->menuViewMenu;
	_tmp43_ = self->priv->menuViewSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Show Timing Diagram");
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->menuViewTimingdiagram);
	self->priv->menuViewTimingdiagram = _tmp44_;
	_tmp45_ = self->priv->menuViewMenu;
	_tmp46_ = self->priv->menuViewTimingdiagram;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->menuViewTimingdiagram;
	g_signal_connect_object (_tmp47_, "activate", (GCallback) ___lambda42__gtk_menu_item_activate, self, 0);
	_tmp48_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp48_;
	_tmp49_ = self->priv->toolbar;
	g_object_set (_tmp49_, "toolbar-style", GTK_TOOLBAR_ICONS, NULL);
	_tmp50_ = self->priv->vBox;
	_tmp51_ = self->priv->toolbar;
	gtk_box_pack_start (_tmp50_, (GtkWidget*) _tmp51_, FALSE, TRUE, (guint) 0);
	_tmp52_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/scroll.png");
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->toolScrollImage);
	self->priv->toolScrollImage = _tmp52_;
	_tmp53_ = (GtkRadioToolButton*) gtk_radio_tool_button_new (NULL);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->toolScroll);
	self->priv->toolScroll = _tmp53_;
	_tmp54_ = self->priv->toolScroll;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp54_, "Scroll");
	_tmp55_ = self->priv->toolScroll;
	_tmp56_ = self->priv->toolScrollImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = self->priv->toolbar;
	_tmp58_ = self->priv->toolScroll;
	gtk_toolbar_insert (_tmp57_, (GtkToolItem*) _tmp58_, -1);
	_tmp59_ = self->priv->toolScroll;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp59_, "Scroll: Move your view of the circuit with click and drag.");
	_tmp60_ = self->priv->toolScroll;
	g_signal_connect_object ((GtkToolButton*) _tmp60_, "clicked", (GCallback) ___lambda43__gtk_tool_button_clicked, self, 0);
	_tmp61_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/zoom.png");
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->toolZoomImage);
	self->priv->toolZoomImage = _tmp61_;
	_tmp62_ = self->priv->toolScroll;
	_tmp63_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp62_);
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->toolZoom);
	self->priv->toolZoom = _tmp63_;
	_tmp64_ = self->priv->toolZoom;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp64_, "Zoom");
	_tmp65_ = self->priv->toolZoom;
	_tmp66_ = self->priv->toolZoomImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = self->priv->toolbar;
	_tmp68_ = self->priv->toolZoom;
	gtk_toolbar_insert (_tmp67_, (GtkToolItem*) _tmp68_, -1);
	_tmp69_ = self->priv->toolZoom;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp69_, "Zoom: Drag downward to zoom in or upward to zoom out.");
	_tmp70_ = self->priv->toolZoom;
	g_signal_connect_object ((GtkToolButton*) _tmp70_, "clicked", (GCallback) ___lambda44__gtk_tool_button_clicked, self, 0);
	_tmp71_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->toolSeparator1);
	self->priv->toolSeparator1 = _tmp71_;
	_tmp72_ = self->priv->toolbar;
	_tmp73_ = self->priv->toolSeparator1;
	gtk_toolbar_insert (_tmp72_, (GtkToolItem*) _tmp73_, -1);
	_tmp74_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/context.png");
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->toolContextImage);
	self->priv->toolContextImage = _tmp74_;
	_tmp75_ = self->priv->toolScroll;
	_tmp76_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp75_);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->toolContext);
	self->priv->toolContext = _tmp76_;
	_tmp77_ = self->priv->toolContext;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp77_, "Context");
	_tmp78_ = self->priv->toolContext;
	_tmp79_ = self->priv->toolContextImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp78_, (GtkWidget*) _tmp79_);
	_tmp80_ = self->priv->toolbar;
	_tmp81_ = self->priv->toolContext;
	gtk_toolbar_insert (_tmp80_, (GtkToolItem*) _tmp81_, -1);
	_tmp82_ = self->priv->toolContext;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp82_, "Context: Interact or explore depending on what you click on. See Inter" \
"act and Explore tools.");
	_tmp83_ = self->priv->toolContext;
	g_signal_connect_object ((GtkToolButton*) _tmp83_, "clicked", (GCallback) ___lambda45__gtk_tool_button_clicked, self, 0);
	_tmp84_ = self->priv->toolContext;
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) _tmp84_, TRUE);
	_tmp85_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/interact.png");
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->toolInteractImage);
	self->priv->toolInteractImage = _tmp85_;
	_tmp86_ = self->priv->toolScroll;
	_tmp87_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp86_);
	g_object_ref_sink (_tmp87_);
	_g_object_unref0 (self->priv->toolInteract);
	self->priv->toolInteract = _tmp87_;
	_tmp88_ = self->priv->toolInteract;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp88_, "Interact");
	_tmp89_ = self->priv->toolInteract;
	_tmp90_ = self->priv->toolInteractImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = self->priv->toolbar;
	_tmp92_ = self->priv->toolInteract;
	gtk_toolbar_insert (_tmp91_, (GtkToolItem*) _tmp92_, -1);
	_tmp93_ = self->priv->toolInteract;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp93_, "Interact: Click on an interactive component to interact with it.");
	_tmp94_ = self->priv->toolInteract;
	g_signal_connect_object ((GtkToolButton*) _tmp94_, "clicked", (GCallback) ___lambda46__gtk_tool_button_clicked, self, 0);
	_tmp95_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/explore.png");
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->priv->toolExploreImage);
	self->priv->toolExploreImage = _tmp95_;
	_tmp96_ = self->priv->toolScroll;
	_tmp97_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp96_);
	g_object_ref_sink (_tmp97_);
	_g_object_unref0 (self->priv->toolExplore);
	self->priv->toolExplore = _tmp97_;
	_tmp98_ = self->priv->toolExplore;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp98_, "Explore");
	_tmp99_ = self->priv->toolExplore;
	_tmp100_ = self->priv->toolExploreImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = self->priv->toolbar;
	_tmp102_ = self->priv->toolExplore;
	gtk_toolbar_insert (_tmp101_, (GtkToolItem*) _tmp102_, -1);
	_tmp103_ = self->priv->toolExplore;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp103_, "Explore: Click on sub components to expand them and look at the activi" \
"ty inside them. Click on the background (or use the shrink tool) to go" \
" back to the higher level.");
	_tmp104_ = self->priv->toolExplore;
	g_signal_connect_object ((GtkToolButton*) _tmp104_, "clicked", (GCallback) ___lambda47__gtk_tool_button_clicked, self, 0);
	_tmp105_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/watch.png");
	g_object_ref_sink (_tmp105_);
	_g_object_unref0 (self->priv->toolWatchImage);
	self->priv->toolWatchImage = _tmp105_;
	_tmp106_ = self->priv->toolScroll;
	_tmp107_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp106_);
	g_object_ref_sink (_tmp107_);
	_g_object_unref0 (self->priv->toolWatch);
	self->priv->toolWatch = _tmp107_;
	_tmp108_ = self->priv->toolWatch;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp108_, "Watch");
	_tmp109_ = self->priv->toolWatch;
	_tmp110_ = self->priv->toolWatchImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp109_, (GtkWidget*) _tmp110_);
	_tmp111_ = self->priv->toolbar;
	_tmp112_ = self->priv->toolWatch;
	gtk_toolbar_insert (_tmp111_, (GtkToolItem*) _tmp112_, -1);
	_tmp113_ = self->priv->toolWatch;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp113_, "Watch: Click on a wire to add it to the logic timing diagram.");
	_tmp114_ = self->priv->toolWatch;
	g_signal_connect_object ((GtkToolButton*) _tmp114_, "clicked", (GCallback) ___lambda48__gtk_tool_button_clicked, self, 0);
	_tmp115_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp115_);
	_g_object_unref0 (self->priv->toolSeparator2);
	self->priv->toolSeparator2 = _tmp115_;
	_tmp116_ = self->priv->toolbar;
	_tmp117_ = self->priv->toolSeparator2;
	gtk_toolbar_insert (_tmp116_, (GtkToolItem*) _tmp117_, -1);
	_tmp118_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/shrink.png");
	g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->toolShrinkImage);
	self->priv->toolShrinkImage = _tmp118_;
	_tmp119_ = self->priv->toolShrinkImage;
	_tmp120_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp119_, "Shrink");
	g_object_ref_sink (_tmp120_);
	_g_object_unref0 (self->priv->toolShrink);
	self->priv->toolShrink = _tmp120_;
	_tmp121_ = self->priv->toolbar;
	_tmp122_ = self->priv->toolShrink;
	gtk_toolbar_insert (_tmp121_, (GtkToolItem*) _tmp122_, -1);
	_tmp123_ = self->priv->toolShrink;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp123_, "Shrink: Explore the immediately higher level component (the component " \
"containing the currently viewed one).");
	_tmp124_ = self->priv->toolShrink;
	g_signal_connect_object (_tmp124_, "clicked", (GCallback) ___lambda49__gtk_tool_button_clicked, self, 0);
	_tmp125_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp125_);
	_g_object_unref0 (self->priv->toolSeparator3);
	self->priv->toolSeparator3 = _tmp125_;
	_tmp126_ = self->priv->toolbar;
	_tmp127_ = self->priv->toolSeparator3;
	gtk_toolbar_insert (_tmp126_, (GtkToolItem*) _tmp127_, -1);
	_tmp128_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/run.png");
	g_object_ref_sink (_tmp128_);
	_g_object_unref0 (self->priv->toolRunImage);
	self->priv->toolRunImage = _tmp128_;
	_tmp129_ = (GtkToggleToolButton*) gtk_toggle_tool_button_new ();
	g_object_ref_sink (_tmp129_);
	_g_object_unref0 (self->priv->toolRun);
	self->priv->toolRun = _tmp129_;
	_tmp130_ = self->priv->toolRun;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp130_, "Run");
	_tmp131_ = self->priv->toolRun;
	_tmp132_ = self->priv->toolRunImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp131_, (GtkWidget*) _tmp132_);
	_tmp133_ = self->priv->toolbar;
	_tmp134_ = self->priv->toolRun;
	gtk_toolbar_insert (_tmp133_, (GtkToolItem*) _tmp134_, -1);
	_tmp135_ = self->priv->toolRun;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp135_, "Run: Toggle between a running and paused simulation.");
	_tmp136_ = self->priv->toolRun;
	g_signal_connect_object (_tmp136_, "toggled", (GCallback) ___lambda50__gtk_toggle_tool_button_toggled, self, 0);
	_tmp137_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/singlestep.png");
	g_object_ref_sink (_tmp137_);
	_g_object_unref0 (self->priv->toolSinglestepImage);
	self->priv->toolSinglestepImage = _tmp137_;
	_tmp138_ = self->priv->toolSinglestepImage;
	_tmp139_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp138_, "Single Step");
	g_object_ref_sink (_tmp139_);
	_g_object_unref0 (self->priv->toolSinglestep);
	self->priv->toolSinglestep = _tmp139_;
	_tmp140_ = self->priv->toolbar;
	_tmp141_ = self->priv->toolSinglestep;
	gtk_toolbar_insert (_tmp140_, (GtkToolItem*) _tmp141_, -1);
	_tmp142_ = self->priv->toolSinglestep;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp142_, "Single Step: Step through the simulation a single iteration at a time.");
	_tmp143_ = self->priv->toolSinglestep;
	g_signal_connect_object (_tmp143_, "clicked", (GCallback) ___lambda51__gtk_tool_button_clicked, self, 0);
	_tmp144_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/multistep.png");
	g_object_ref_sink (_tmp144_);
	_g_object_unref0 (self->priv->toolMultistepImage);
	self->priv->toolMultistepImage = _tmp144_;
	_tmp145_ = self->priv->toolMultistepImage;
	_tmp146_ = (GtkToolButton*) gtk_tool_button_new ((GtkWidget*) _tmp145_, "Multi Step");
	g_object_ref_sink (_tmp146_);
	_g_object_unref0 (self->priv->toolMultistep);
	self->priv->toolMultistep = _tmp146_;
	_tmp147_ = self->priv->toolbar;
	_tmp148_ = self->priv->toolMultistep;
	gtk_toolbar_insert (_tmp147_, (GtkToolItem*) _tmp148_, -1);
	_tmp149_ = self->priv->toolMultistep;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp149_, "Multi Step: Step through the simulation by a specified number of itera" \
"tions.");
	_tmp150_ = self->priv->toolMultistep;
	g_signal_connect_object (_tmp150_, "clicked", (GCallback) ___lambda52__gtk_tool_button_clicked, self, 0);
	_tmp151_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp151_);
	_g_object_unref0 (self->priv->toolSeparator4);
	self->priv->toolSeparator4 = _tmp151_;
	_tmp152_ = self->priv->toolbar;
	_tmp153_ = self->priv->toolSeparator4;
	gtk_toolbar_insert (_tmp152_, (GtkToolItem*) _tmp153_, -1);
	_tmp154_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp154_);
	_g_object_unref0 (self->priv->toolSpeed);
	self->priv->toolSpeed = _tmp154_;
	_tmp155_ = self->priv->toolbar;
	_tmp156_ = self->priv->toolSpeed;
	gtk_toolbar_insert (_tmp155_, _tmp156_, -1);
	_tmp157_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp157_);
	_g_object_unref0 (self->priv->toolSpeedBox);
	self->priv->toolSpeedBox = _tmp157_;
	_tmp158_ = self->priv->toolSpeed;
	_tmp159_ = self->priv->toolSpeedBox;
	gtk_container_add ((GtkContainer*) _tmp158_, (GtkWidget*) _tmp159_);
	_tmp160_ = (GtkLabel*) gtk_label_new ("Speed (Hz):");
	g_object_ref_sink (_tmp160_);
	_g_object_unref0 (self->priv->toolSpeedLabel);
	self->priv->toolSpeedLabel = _tmp160_;
	_tmp161_ = self->priv->toolSpeedBox;
	_tmp162_ = self->priv->toolSpeedLabel;
	gtk_box_pack_start (_tmp161_, (GtkWidget*) _tmp162_, FALSE, TRUE, (guint) 0);
	_tmp163_ = (GtkSpinButton*) gtk_spin_button_new_with_range (0.1, 1000.0, 1.0);
	g_object_ref_sink (_tmp163_);
	_g_object_unref0 (self->priv->toolSpeedSpin);
	self->priv->toolSpeedSpin = _tmp163_;
	_tmp164_ = self->priv->toolSpeedBox;
	_tmp165_ = self->priv->toolSpeedSpin;
	gtk_box_pack_start (_tmp164_, (GtkWidget*) _tmp165_, FALSE, TRUE, (guint) 0);
	_tmp166_ = self->priv->toolSpeedSpin;
	gtk_spin_button_set_value (_tmp166_, 50.0);
	_tmp167_ = self->priv->toolSpeedSpin;
	gtk_spin_button_set_snap_to_ticks (_tmp167_, FALSE);
	_tmp168_ = self->priv->toolSpeedSpin;
	gtk_spin_button_set_digits (_tmp168_, (guint) 1);
	_tmp169_ = self->priv->toolSpeedSpin;
	g_signal_connect_object (_tmp169_, "value-changed", (GCallback) ___lambda53__gtk_spin_button_value_changed, self, 0);
	_tmp170_ = self->priv->toolSpeedSpin;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp170_, FALSE);
	_tmp171_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/fastest.png");
	g_object_ref_sink (_tmp171_);
	_g_object_unref0 (self->priv->toolMaxspeedImage);
	self->priv->toolMaxspeedImage = _tmp171_;
	_tmp172_ = (GtkToggleToolButton*) gtk_toggle_tool_button_new ();
	g_object_ref_sink (_tmp172_);
	_g_object_unref0 (self->priv->toolMaxspeed);
	self->priv->toolMaxspeed = _tmp172_;
	_tmp173_ = self->priv->toolMaxspeed;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp173_, "Maximum Speed");
	_tmp174_ = self->priv->toolMaxspeed;
	_tmp175_ = self->priv->toolMaxspeedImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp174_, (GtkWidget*) _tmp175_);
	_tmp176_ = self->priv->toolbar;
	_tmp177_ = self->priv->toolMaxspeed;
	gtk_toolbar_insert (_tmp176_, (GtkToolItem*) _tmp177_, -1);
	_tmp178_ = self->priv->toolMaxspeed;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp178_, "Maximum Speed: Toggle between running as fast as possible and running " \
"at a specified speed.");
	_tmp179_ = self->priv->toolMaxspeed;
	gtk_toggle_tool_button_set_active (_tmp179_, TRUE);
	_tmp180_ = self->priv->toolMaxspeed;
	g_signal_connect_object (_tmp180_, "toggled", (GCallback) ___lambda54__gtk_toggle_tool_button_toggled, self, 0);
	_tmp181_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp181_);
	_g_object_unref0 (self->priv->toolSeparator5);
	self->priv->toolSeparator5 = _tmp181_;
	_tmp182_ = self->priv->toolbar;
	_tmp183_ = self->priv->toolSeparator5;
	gtk_toolbar_insert (_tmp182_, (GtkToolItem*) _tmp183_, -1);
	_tmp184_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp184_);
	_g_object_unref0 (self->priv->toolStepsize);
	self->priv->toolStepsize = _tmp184_;
	_tmp185_ = self->priv->toolbar;
	_tmp186_ = self->priv->toolStepsize;
	gtk_toolbar_insert (_tmp185_, _tmp186_, -1);
	_tmp187_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp187_);
	_g_object_unref0 (self->priv->toolStepsizeBox);
	self->priv->toolStepsizeBox = _tmp187_;
	_tmp188_ = self->priv->toolStepsize;
	_tmp189_ = self->priv->toolStepsizeBox;
	gtk_container_add ((GtkContainer*) _tmp188_, (GtkWidget*) _tmp189_);
	_tmp190_ = (GtkLabel*) gtk_label_new ("Multi Step:");
	g_object_ref_sink (_tmp190_);
	_g_object_unref0 (self->priv->toolStepsizeLabel);
	self->priv->toolStepsizeLabel = _tmp190_;
	_tmp191_ = self->priv->toolStepsizeBox;
	_tmp192_ = self->priv->toolStepsizeLabel;
	gtk_box_pack_start (_tmp191_, (GtkWidget*) _tmp192_, FALSE, TRUE, (guint) 0);
	_tmp193_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 1000000, 1.0);
	g_object_ref_sink (_tmp193_);
	_g_object_unref0 (self->priv->toolStepsizeSpin);
	self->priv->toolStepsizeSpin = _tmp193_;
	_tmp194_ = self->priv->toolStepsizeBox;
	_tmp195_ = self->priv->toolStepsizeSpin;
	gtk_box_pack_start (_tmp194_, (GtkWidget*) _tmp195_, FALSE, TRUE, (guint) 0);
	_tmp196_ = self->priv->toolStepsizeSpin;
	gtk_spin_button_set_value (_tmp196_, 50.0);
	_tmp197_ = self->priv->toolStepsizeSpin;
	g_signal_connect_object (_tmp197_, "value-changed", (GCallback) ___lambda55__gtk_spin_button_value_changed, self, 0);
	_tmp198_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp198_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp198_;
	_tmp199_ = self->priv->vBox;
	_tmp200_ = self->priv->controller;
	gtk_box_pack_start (_tmp199_, (GtkWidget*) _tmp200_, TRUE, TRUE, (guint) 0);
	_tmp201_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp201_, "button-press-event", (GCallback) _simulator_window_mouse_down_gtk_widget_button_press_event, self, 0);
	_tmp202_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp202_, "button-release-event", (GCallback) _simulator_window_mouse_up_gtk_widget_button_release_event, self, 0);
	_tmp203_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp203_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp203_;
	_tmp204_ = self->priv->controller;
	_tmp205_ = self->priv->display;
	gtk_container_add ((GtkContainer*) _tmp204_, (GtkWidget*) _tmp205_);
	_tmp206_ = self->priv->display;
	g_signal_connect_object ((GtkWidget*) _tmp206_, "draw", (GCallback) ___lambda56__gtk_widget_draw, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp207_ = self->priv->compiledCircuit;
	_tmp208_ = timing_diagram_new (_tmp207_);
	g_object_ref_sink (_tmp208_);
	_g_object_unref0 (self->priv->timingDiagram);
	self->priv->timingDiagram = _tmp208_;
}


static void simulator_window_change_speed (SimulatorWindow* self, gint newCycleDelay) {
	gboolean running = FALSE;
	SimulatorWindowRunState _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->runState;
	running = _tmp0_ == SIMULATOR_WINDOW_RUN_STATE_RUNNING;
	simulator_window_pause (self);
	_tmp1_ = newCycleDelay;
	self->priv->cycleDelay = _tmp1_;
	_tmp2_ = running;
	if (_tmp2_) {
		simulator_window_run (self);
	}
	_tmp3_ = self->priv->cycleDelay;
	if (_tmp3_ < 0) {
		self->priv->cycleDelay = 0;
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = self->priv->cycleDelay;
		if (_tmp4_ > 10000) {
			self->priv->cycleDelay = 10000;
		}
	}
	_tmp5_ = self->priv->cycleDelay;
	self->priv->microCycleDelay = _tmp5_ * 1000;
}


/**
 * Toggles whether the simulation is running or paused. Does nothing
 * if the circuit is in the ERROR state.
 */
static void simulator_window_run_toggle (SimulatorWindow* self, GtkWidget* widget) {
	gboolean doRun = FALSE;
	GtkWidget* _tmp0_ = NULL;
	GtkCheckMenuItem* _tmp1_ = NULL;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	doRun = FALSE;
	_tmp0_ = widget;
	_tmp1_ = self->priv->menuSimulationRun;
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_WIDGET, GtkWidget)) {
		GtkCheckMenuItem* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->menuSimulationRun;
		_tmp3_ = gtk_check_menu_item_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		doRun = _tmp4_;
	} else {
		GtkWidget* _tmp5_ = NULL;
		GtkToggleToolButton* _tmp6_ = NULL;
		_tmp5_ = widget;
		_tmp6_ = self->priv->toolRun;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_WIDGET, GtkWidget)) {
			GtkToggleToolButton* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			_tmp7_ = self->priv->toolRun;
			_tmp8_ = gtk_toggle_tool_button_get_active (_tmp7_);
			_tmp9_ = _tmp8_;
			doRun = _tmp9_;
		}
	}
	_tmp10_ = doRun;
	if (_tmp10_) {
		simulator_window_run (self);
	} else {
		simulator_window_pause (self);
	}
}


static void simulator_window_step (SimulatorWindow* self, gboolean multistep) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = multistep;
	if (_tmp1_) {
		gint _tmp2_ = 0;
		_tmp2_ = self->priv->multistepSize;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = 1;
	}
	self->priv->stepsLeft = _tmp0_;
	simulator_window_run (self);
	self->priv->runState = SIMULATOR_WINDOW_RUN_STATE_STEPPING;
}


/**
 * Sets the simulation state to running. Does nothing if the circuit
 * is in the ERROR state.
 */
static gboolean _simulator_window_update_cycle_gsource_func (gpointer self) {
	gboolean result;
	result = simulator_window_update_cycle ((SimulatorWindow*) self);
	return result;
}


static gboolean _simulator_window_refresh_cycle_gsource_func (gpointer self) {
	gboolean result;
	result = simulator_window_refresh_cycle ((SimulatorWindow*) self);
	return result;
}


void simulator_window_run (SimulatorWindow* self) {
	SimulatorWindowRunState _tmp0_ = 0;
	SimulatorWindowRunState _tmp1_ = 0;
	GtkCheckMenuItem* _tmp12_ = NULL;
	GtkToggleToolButton* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->runState;
	if (_tmp0_ == SIMULATOR_WINDOW_RUN_STATE_ERROR) {
		return;
	}
	_tmp1_ = self->priv->runState;
	if (_tmp1_ != SIMULATOR_WINDOW_RUN_STATE_RUNNING) {
		gint refreshDelay = 0;
		gint _tmp2_ = 0;
		guint _tmp4_ = 0U;
		guint _tmp6_ = 0U;
		gint _tmp8_ = 0;
		guint _tmp9_ = 0U;
		gint _tmp10_ = 0;
		guint _tmp11_ = 0U;
		_tmp2_ = self->priv->cycleDelay;
		if (_tmp2_ > 100) {
			gint _tmp3_ = 0;
			_tmp3_ = self->priv->cycleDelay;
			refreshDelay = _tmp3_;
		} else {
			refreshDelay = 100;
		}
		_tmp4_ = self->priv->cycleSourceID;
		if (_tmp4_ != ((guint) 0)) {
			guint _tmp5_ = 0U;
			_tmp5_ = self->priv->cycleSourceID;
			g_source_remove (_tmp5_);
		}
		_tmp6_ = self->priv->refreshSourceID;
		if (_tmp6_ != ((guint) 0)) {
			guint _tmp7_ = 0U;
			_tmp7_ = self->priv->refreshSourceID;
			g_source_remove (_tmp7_);
		}
		_tmp8_ = self->priv->cycleDelay;
		_tmp9_ = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) _tmp8_, _simulator_window_update_cycle_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->cycleSourceID = _tmp9_;
		_tmp10_ = refreshDelay;
		_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp10_, _simulator_window_refresh_cycle_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->refreshSourceID = _tmp11_;
	}
	self->priv->runState = SIMULATOR_WINDOW_RUN_STATE_RUNNING;
	_tmp12_ = self->priv->menuSimulationRun;
	gtk_check_menu_item_set_active (_tmp12_, TRUE);
	_tmp13_ = self->priv->toolRun;
	gtk_toggle_tool_button_set_active (_tmp13_, TRUE);
	self->priv->timeBeforeRender = (gdouble) 0;
}


/**
 * Sets the simulation state to paused. Does nothing if the circuit
 * is in the ERROR state.
 */
void simulator_window_pause (SimulatorWindow* self) {
	SimulatorWindowRunState _tmp0_ = 0;
	guint _tmp1_ = 0U;
	guint _tmp3_ = 0U;
	GtkCheckMenuItem* _tmp5_ = NULL;
	GtkToggleToolButton* _tmp6_ = NULL;
	TimingDiagram* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->runState;
	if (_tmp0_ == SIMULATOR_WINDOW_RUN_STATE_ERROR) {
		return;
	}
	_tmp1_ = self->priv->cycleSourceID;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->cycleSourceID;
		g_source_remove (_tmp2_);
		self->priv->cycleSourceID = (guint) 0;
	}
	_tmp3_ = self->priv->refreshSourceID;
	if (_tmp3_ != ((guint) 0)) {
		guint _tmp4_ = 0U;
		_tmp4_ = self->priv->refreshSourceID;
		g_source_remove (_tmp4_);
		self->priv->refreshSourceID = (guint) 0;
	}
	self->priv->runState = SIMULATOR_WINDOW_RUN_STATE_PAUSED;
	_tmp5_ = self->priv->menuSimulationRun;
	gtk_check_menu_item_set_active (_tmp5_, FALSE);
	_tmp6_ = self->priv->toolRun;
	gtk_toggle_tool_button_set_active (_tmp6_, FALSE);
	simulator_window_render (self, TRUE, FALSE, NULL);
	_tmp7_ = self->priv->timingDiagram;
	timing_diagram_render (_tmp7_, TRUE, NULL);
}


static void simulator_window_show_timing_diagram (SimulatorWindow* self) {
	TimingDiagram* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timingDiagram;
	timing_diagram_show_diagram (_tmp0_);
}


static void simulator_window_fit_design (SimulatorWindow* self) {
	GtkAllocation areaAllocation = {0};
	GtkEventBox* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint height = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint rightBound = 0;
	gint downBound = 0;
	gint leftBound = 0;
	gint upBound = 0;
	gint boundWidth = 0;
	gint boundHeight = 0;
	gfloat altZoom = 0.0F;
	CompiledCircuit* _tmp6_ = NULL;
	CustomComponentDef* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gfloat _tmp33_ = 0.0F;
	gfloat _tmp34_ = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->controller;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = self->priv->compiledCircuit;
	_tmp7_ = _tmp6_->viewedComponent;
	custom_component_def_get_design_bounds (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	rightBound = _tmp8_;
	downBound = _tmp9_;
	leftBound = _tmp10_;
	upBound = _tmp11_;
	_tmp13_ = rightBound;
	_tmp14_ = leftBound;
	if (_tmp13_ == _tmp14_) {
		_tmp12_ = TRUE;
	} else {
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp15_ = downBound;
		_tmp16_ = upBound;
		_tmp12_ = _tmp15_ == _tmp16_;
	}
	if (_tmp12_) {
		return;
	}
	_tmp17_ = rightBound;
	rightBound = _tmp17_ + 10;
	_tmp18_ = downBound;
	downBound = _tmp18_ + 10;
	_tmp19_ = leftBound;
	leftBound = _tmp19_ - 10;
	_tmp20_ = upBound;
	upBound = _tmp20_ - 10;
	_tmp21_ = rightBound;
	_tmp22_ = leftBound;
	self->priv->xView = (_tmp21_ + _tmp22_) / 2;
	_tmp23_ = downBound;
	_tmp24_ = upBound;
	self->priv->yView = (_tmp23_ + _tmp24_) / 2;
	_tmp25_ = rightBound;
	_tmp26_ = leftBound;
	boundWidth = _tmp25_ - _tmp26_;
	_tmp27_ = downBound;
	_tmp28_ = upBound;
	boundHeight = _tmp27_ - _tmp28_;
	_tmp29_ = width;
	_tmp30_ = boundWidth;
	self->zoom = ((gfloat) _tmp29_) / ((gfloat) _tmp30_);
	_tmp31_ = height;
	_tmp32_ = boundHeight;
	altZoom = ((gfloat) _tmp31_) / ((gfloat) _tmp32_);
	_tmp33_ = altZoom;
	_tmp34_ = self->zoom;
	if (_tmp33_ < _tmp34_) {
		gfloat _tmp35_ = 0.0F;
		_tmp35_ = altZoom;
		self->zoom = _tmp35_;
	}
	simulator_window_render (self, TRUE, FALSE, NULL);
}


/**
 * Run periodically using a timer. Updates the display.
 */
static gboolean simulator_window_refresh_cycle (SimulatorWindow* self) {
	gboolean result = FALSE;
	GTimer* renderingTimer = NULL;
	GTimer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	SimulatorWindowRunState _tmp2_ = 0;
	gboolean _tmp9_ = FALSE;
	SimulatorWindowRunState _tmp10_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_timer_new ();
	renderingTimer = _tmp0_;
	_tmp2_ = self->priv->runState;
	if (_tmp2_ != SIMULATOR_WINDOW_RUN_STATE_HALTING) {
		gdouble _tmp3_ = 0.0;
		_tmp3_ = self->priv->timeBeforeRender;
		_tmp1_ = _tmp3_ <= 0.0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GTimer* _tmp4_ = NULL;
		TimingDiagram* _tmp5_ = NULL;
		GTimer* _tmp6_ = NULL;
		GTimer* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
		_tmp4_ = renderingTimer;
		g_timer_start (_tmp4_);
		simulator_window_render (self, FALSE, FALSE, NULL);
		_tmp5_ = self->priv->timingDiagram;
		timing_diagram_render (_tmp5_, FALSE, NULL);
		_tmp6_ = renderingTimer;
		g_timer_stop (_tmp6_);
		_tmp7_ = renderingTimer;
		_tmp8_ = g_timer_elapsed (_tmp7_, NULL);
		self->priv->timeBeforeRender = _tmp8_;
	}
	_tmp10_ = self->priv->runState;
	if (_tmp10_ == SIMULATOR_WINDOW_RUN_STATE_RUNNING) {
		_tmp9_ = TRUE;
	} else {
		SimulatorWindowRunState _tmp11_ = 0;
		_tmp11_ = self->priv->runState;
		_tmp9_ = _tmp11_ == SIMULATOR_WINDOW_RUN_STATE_STEPPING;
	}
	if (_tmp9_) {
		result = TRUE;
		_g_timer_destroy0 (renderingTimer);
		return result;
	} else {
		result = FALSE;
		_g_timer_destroy0 (renderingTimer);
		return result;
	}
	_g_timer_destroy0 (renderingTimer);
}


/**
 * Run periodically using a timer. Runs an single iteration of the
 * simulation.
 */
static gboolean simulator_window_update_cycle (SimulatorWindow* self) {
	gboolean result = FALSE;
	GTimer* simulationTimer = NULL;
	GTimer* _tmp0_ = NULL;
	GTimer* _tmp1_ = NULL;
	gint _result_ = 0;
	CompiledCircuit* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GTimer* _tmp4_ = NULL;
	GTimer* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gint _tmp7_ = 0;
	gint _tmp13_ = 0;
	SimulatorWindowRunState _tmp25_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_timer_new ();
	simulationTimer = _tmp0_;
	_tmp1_ = simulationTimer;
	g_timer_start (_tmp1_);
	_tmp2_ = self->priv->compiledCircuit;
	_tmp3_ = compiled_circuit_update_cycle (_tmp2_);
	_result_ = _tmp3_;
	_tmp4_ = simulationTimer;
	g_timer_stop (_tmp4_);
	_tmp5_ = simulationTimer;
	_tmp6_ = g_timer_elapsed (_tmp5_, NULL);
	_tmp7_ = self->priv->microCycleDelay;
	if (_tmp6_ < ((gdouble) _tmp7_)) {
		gdouble _tmp8_ = 0.0;
		gint _tmp9_ = 0;
		_tmp8_ = self->priv->timeBeforeRender;
		_tmp9_ = self->priv->microCycleDelay;
		self->priv->timeBeforeRender = _tmp8_ - ((gdouble) _tmp9_);
	} else {
		gdouble _tmp10_ = 0.0;
		GTimer* _tmp11_ = NULL;
		gdouble _tmp12_ = 0.0;
		_tmp10_ = self->priv->timeBeforeRender;
		_tmp11_ = simulationTimer;
		_tmp12_ = g_timer_elapsed (_tmp11_, NULL);
		self->priv->timeBeforeRender = _tmp10_ - _tmp12_;
	}
	_tmp13_ = _result_;
	if (_tmp13_ == 1) {
		FILE* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		FILE* _tmp16_ = NULL;
		CompiledCircuit* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		CompiledCircuit* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		self->priv->runState = SIMULATOR_WINDOW_RUN_STATE_ERROR;
		simulator_window_render (self, TRUE, FALSE, NULL);
		_tmp14_ = stdout;
		fprintf (_tmp14_, "Simulation Error!\n");
		_tmp15_ = stdout;
		fflush (_tmp15_);
		_tmp16_ = stderr;
		_tmp17_ = self->priv->compiledCircuit;
		_tmp18_ = compiled_circuit_get_errorMessage (_tmp17_);
		_tmp19_ = _tmp18_;
		fprintf (_tmp16_, "Error Messages:\n%s\n", _tmp19_);
		_tmp20_ = self->priv->compiledCircuit;
		_tmp21_ = compiled_circuit_get_errorMessage (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("Circuit Runtime Error:\n", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		basic_dialog_error (NULL, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp25_ = self->priv->runState;
	if (_tmp25_ == SIMULATOR_WINDOW_RUN_STATE_RUNNING) {
		result = TRUE;
		_g_timer_destroy0 (simulationTimer);
		return result;
	} else {
		SimulatorWindowRunState _tmp26_ = 0;
		_tmp26_ = self->priv->runState;
		if (_tmp26_ == SIMULATOR_WINDOW_RUN_STATE_STEPPING) {
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			_tmp27_ = self->priv->stepsLeft;
			self->priv->stepsLeft = _tmp27_ - 1;
			_tmp28_ = self->priv->stepsLeft;
			if (_tmp28_ <= 0) {
				simulator_window_pause (self);
				result = FALSE;
				_g_timer_destroy0 (simulationTimer);
				return result;
			} else {
				result = TRUE;
				_g_timer_destroy0 (simulationTimer);
				return result;
			}
		} else {
			result = FALSE;
			_g_timer_destroy0 (simulationTimer);
			return result;
		}
	}
	_g_timer_destroy0 (simulationTimer);
}


/**
 * Handles mouse button down in the work area. Records mouse
 * (drag) starting point.
 */
static gboolean simulator_window_mouse_down (SimulatorWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->x;
	self->priv->xMouseStart = (gint) _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->y;
	self->priv->yMouseStart = (gint) _tmp3_;
	result = FALSE;
	return result;
}


/**
 * Handles mouse button up in the work area. Performs an action
 * which is determined by //mouseMode//.
 */
static gboolean simulator_window_mouse_up (SimulatorWindow* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkAllocation areaAllocation = {0};
	GtkEventBox* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint height = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint xCentre = 0;
	gint _tmp6_ = 0;
	gint yCentre = 0;
	gint _tmp7_ = 0;
	gint xStart = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint yStart = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint xEnd = 0;
	GdkEventButton* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gint _tmp14_ = 0;
	gint yEnd = 0;
	GdkEventButton* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	gint _tmp17_ = 0;
	gint yDiff = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint xBoardStart = 0;
	gint _tmp20_ = 0;
	gfloat _tmp21_ = 0.0F;
	gint _tmp22_ = 0;
	gint yBoardStart = 0;
	gint _tmp23_ = 0;
	gfloat _tmp24_ = 0.0F;
	gint _tmp25_ = 0;
	gint xBoardEnd = 0;
	gint _tmp26_ = 0;
	gfloat _tmp27_ = 0.0F;
	gint _tmp28_ = 0;
	gint yBoardEnd = 0;
	gint _tmp29_ = 0;
	gfloat _tmp30_ = 0.0F;
	gint _tmp31_ = 0;
	gboolean snapGridStart = FALSE;
	gboolean snapGridEnd = FALSE;
	gint halfGridSize = 0;
	gint _tmp32_ = 0;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gint xBoardDiff = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gint yBoardDiff = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint yDiffAbs = 0;
	SimulatorWindowMouseMode _tmp75_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->controller;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = width;
	xCentre = _tmp6_ / 2;
	_tmp7_ = height;
	yCentre = _tmp7_ / 2;
	_tmp8_ = self->priv->xMouseStart;
	_tmp9_ = xCentre;
	xStart = _tmp8_ - _tmp9_;
	_tmp10_ = self->priv->yMouseStart;
	_tmp11_ = yCentre;
	yStart = _tmp10_ - _tmp11_;
	_tmp12_ = event;
	_tmp13_ = _tmp12_->x;
	_tmp14_ = xCentre;
	xEnd = ((gint) _tmp13_) - _tmp14_;
	_tmp15_ = event;
	_tmp16_ = _tmp15_->y;
	_tmp17_ = yCentre;
	yEnd = ((gint) _tmp16_) - _tmp17_;
	_tmp18_ = yEnd;
	_tmp19_ = yStart;
	yDiff = _tmp18_ - _tmp19_;
	_tmp20_ = xStart;
	_tmp21_ = self->zoom;
	_tmp22_ = self->priv->xView;
	xBoardStart = (gint) ((((gfloat) _tmp20_) / _tmp21_) + ((gfloat) _tmp22_));
	_tmp23_ = yStart;
	_tmp24_ = self->zoom;
	_tmp25_ = self->priv->yView;
	yBoardStart = (gint) ((((gfloat) _tmp23_) / _tmp24_) + ((gfloat) _tmp25_));
	_tmp26_ = xEnd;
	_tmp27_ = self->zoom;
	_tmp28_ = self->priv->xView;
	xBoardEnd = (gint) ((((gfloat) _tmp26_) / _tmp27_) + ((gfloat) _tmp28_));
	_tmp29_ = yEnd;
	_tmp30_ = self->zoom;
	_tmp31_ = self->priv->yView;
	yBoardEnd = (gint) ((((gfloat) _tmp29_) / _tmp30_) + ((gfloat) _tmp31_));
	snapGridStart = TRUE;
	snapGridEnd = TRUE;
	_tmp32_ = self->gridSize;
	halfGridSize = _tmp32_ / 2;
	_tmp33_ = snapGridStart;
	if (_tmp33_) {
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		_tmp35_ = xBoardStart;
		if (_tmp35_ > 0) {
			gint _tmp36_ = 0;
			_tmp36_ = halfGridSize;
			_tmp34_ = _tmp36_;
		} else {
			gint _tmp37_ = 0;
			_tmp37_ = halfGridSize;
			_tmp34_ = -_tmp37_;
		}
		_tmp38_ = xBoardStart;
		xBoardStart = _tmp38_ + _tmp34_;
		_tmp40_ = yBoardStart;
		if (_tmp40_ > 0) {
			gint _tmp41_ = 0;
			_tmp41_ = halfGridSize;
			_tmp39_ = _tmp41_;
		} else {
			gint _tmp42_ = 0;
			_tmp42_ = halfGridSize;
			_tmp39_ = -_tmp42_;
		}
		_tmp43_ = yBoardStart;
		yBoardStart = _tmp43_ + _tmp39_;
		_tmp44_ = xBoardStart;
		_tmp45_ = self->gridSize;
		_tmp46_ = self->gridSize;
		xBoardStart = (_tmp44_ / _tmp45_) * _tmp46_;
		_tmp47_ = yBoardStart;
		_tmp48_ = self->gridSize;
		_tmp49_ = self->gridSize;
		yBoardStart = (_tmp47_ / _tmp48_) * _tmp49_;
	}
	_tmp50_ = snapGridEnd;
	if (_tmp50_) {
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		_tmp52_ = xBoardEnd;
		if (_tmp52_ > 0) {
			gint _tmp53_ = 0;
			_tmp53_ = halfGridSize;
			_tmp51_ = _tmp53_;
		} else {
			gint _tmp54_ = 0;
			_tmp54_ = halfGridSize;
			_tmp51_ = -_tmp54_;
		}
		_tmp55_ = xBoardEnd;
		xBoardEnd = _tmp55_ + _tmp51_;
		_tmp57_ = yBoardEnd;
		if (_tmp57_ > 0) {
			gint _tmp58_ = 0;
			_tmp58_ = halfGridSize;
			_tmp56_ = _tmp58_;
		} else {
			gint _tmp59_ = 0;
			_tmp59_ = halfGridSize;
			_tmp56_ = -_tmp59_;
		}
		_tmp60_ = yBoardEnd;
		yBoardEnd = _tmp60_ + _tmp56_;
		_tmp61_ = xBoardEnd;
		_tmp62_ = self->gridSize;
		_tmp63_ = self->gridSize;
		xBoardEnd = (_tmp61_ / _tmp62_) * _tmp63_;
		_tmp64_ = yBoardEnd;
		_tmp65_ = self->gridSize;
		_tmp66_ = self->gridSize;
		yBoardEnd = (_tmp64_ / _tmp65_) * _tmp66_;
	}
	_tmp67_ = xBoardEnd;
	_tmp68_ = xBoardStart;
	xBoardDiff = _tmp67_ - _tmp68_;
	_tmp69_ = yBoardEnd;
	_tmp70_ = yBoardStart;
	yBoardDiff = _tmp69_ - _tmp70_;
	_tmp72_ = yDiff;
	if (_tmp72_ > 0) {
		gint _tmp73_ = 0;
		_tmp73_ = yDiff;
		_tmp71_ = _tmp73_;
	} else {
		gint _tmp74_ = 0;
		_tmp74_ = yDiff;
		_tmp71_ = -_tmp74_;
	}
	yDiffAbs = _tmp71_;
	_tmp75_ = self->priv->mouseMode;
	switch (_tmp75_) {
		case SIMULATOR_WINDOW_MOUSE_MODE_SCROLL:
		{
			gint _tmp76_ = 0;
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
			gint _tmp79_ = 0;
			_tmp76_ = self->priv->xView;
			_tmp77_ = xBoardDiff;
			self->priv->xView = _tmp76_ - _tmp77_;
			_tmp78_ = self->priv->yView;
			_tmp79_ = yBoardDiff;
			self->priv->yView = _tmp78_ - _tmp79_;
			simulator_window_render (self, TRUE, FALSE, NULL);
			break;
		}
		case SIMULATOR_WINDOW_MOUSE_MODE_ZOOM:
		{
			gint _tmp80_ = 0;
			_tmp80_ = yDiff;
			if (_tmp80_ > 0) {
				gfloat _tmp81_ = 0.0F;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				_tmp81_ = self->zoom;
				_tmp82_ = yDiffAbs;
				_tmp83_ = height;
				self->zoom = _tmp81_ * (1.0f + (((gfloat) _tmp82_) / ((gfloat) _tmp83_)));
			} else {
				gfloat _tmp84_ = 0.0F;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				_tmp84_ = self->zoom;
				_tmp85_ = yDiffAbs;
				_tmp86_ = height;
				self->zoom = _tmp84_ / (1.0f + (((gfloat) _tmp85_) / ((gfloat) _tmp86_)));
			}
			simulator_window_render (self, TRUE, FALSE, NULL);
			break;
		}
		case SIMULATOR_WINDOW_MOUSE_MODE_INTERACT:
		{
			CompiledCircuit* _tmp87_ = NULL;
			gint _tmp88_ = 0;
			gint _tmp89_ = 0;
			_tmp87_ = self->priv->compiledCircuit;
			_tmp88_ = xBoardEnd;
			_tmp89_ = yBoardEnd;
			compiled_circuit_interact_components (_tmp87_, _tmp88_, _tmp89_);
			simulator_window_render (self, TRUE, TRUE, NULL);
			break;
		}
		case SIMULATOR_WINDOW_MOUSE_MODE_CONTEXT:
		{
			gint _result_ = 0;
			CompiledCircuit* _tmp90_ = NULL;
			gint _tmp91_ = 0;
			gint _tmp92_ = 0;
			gint _tmp93_ = 0;
			gint _tmp94_ = 0;
			_tmp90_ = self->priv->compiledCircuit;
			_tmp91_ = xBoardEnd;
			_tmp92_ = yBoardEnd;
			_tmp93_ = compiled_circuit_expand_component (_tmp90_, _tmp91_, _tmp92_);
			_result_ = _tmp93_;
			_tmp94_ = _result_;
			switch (_tmp94_) {
				case 0:
				{
					gboolean _tmp95_ = FALSE;
					_tmp95_ = self->priv->autoFitDesign;
					if (_tmp95_) {
						simulator_window_fit_design (self);
					}
					simulator_window_render (self, TRUE, FALSE, NULL);
					break;
				}
				case 1:
				{
					CompiledCircuit* _tmp96_ = NULL;
					gboolean _tmp97_ = FALSE;
					_tmp96_ = self->priv->compiledCircuit;
					compiled_circuit_shrink_component (_tmp96_);
					_tmp97_ = self->priv->autoFitDesign;
					if (_tmp97_) {
						simulator_window_fit_design (self);
					}
					simulator_window_render (self, TRUE, FALSE, NULL);
					break;
				}
				case 2:
				{
					CompiledCircuit* _tmp98_ = NULL;
					gint _tmp99_ = 0;
					gint _tmp100_ = 0;
					_tmp98_ = self->priv->compiledCircuit;
					_tmp99_ = xBoardEnd;
					_tmp100_ = yBoardEnd;
					compiled_circuit_interact_components (_tmp98_, _tmp99_, _tmp100_);
					simulator_window_render (self, TRUE, TRUE, NULL);
					break;
				}
				default:
				break;
			}
			break;
		}
		case SIMULATOR_WINDOW_MOUSE_MODE_EXPLORE:
		{
			gint _result_ = 0;
			CompiledCircuit* _tmp101_ = NULL;
			gint _tmp102_ = 0;
			gint _tmp103_ = 0;
			gint _tmp104_ = 0;
			gint _tmp105_ = 0;
			_tmp101_ = self->priv->compiledCircuit;
			_tmp102_ = xBoardEnd;
			_tmp103_ = yBoardEnd;
			_tmp104_ = compiled_circuit_expand_component (_tmp101_, _tmp102_, _tmp103_);
			_result_ = _tmp104_;
			_tmp105_ = _result_;
			switch (_tmp105_) {
				case 0:
				{
					gboolean _tmp106_ = FALSE;
					_tmp106_ = self->priv->autoFitDesign;
					if (_tmp106_) {
						simulator_window_fit_design (self);
					}
					simulator_window_render (self, TRUE, FALSE, NULL);
					break;
				}
				case 1:
				{
					CompiledCircuit* _tmp107_ = NULL;
					gboolean _tmp108_ = FALSE;
					_tmp107_ = self->priv->compiledCircuit;
					compiled_circuit_shrink_component (_tmp107_);
					_tmp108_ = self->priv->autoFitDesign;
					if (_tmp108_) {
						simulator_window_fit_design (self);
					}
					simulator_window_render (self, TRUE, FALSE, NULL);
					break;
				}
				case 2:
				{
					break;
				}
				default:
				break;
			}
			break;
		}
		case SIMULATOR_WINDOW_MOUSE_MODE_WATCH:
		{
			WireState* wireState = NULL;
			CompiledCircuit* _tmp109_ = NULL;
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			WireState* _tmp112_ = NULL;
			WireState* _tmp113_ = NULL;
			_tmp109_ = self->priv->compiledCircuit;
			_tmp110_ = xBoardEnd;
			_tmp111_ = yBoardEnd;
			_tmp112_ = compiled_circuit_find_wire (_tmp109_, _tmp110_, _tmp111_);
			wireState = _tmp112_;
			_tmp113_ = wireState;
			if (_tmp113_ != NULL) {
				TimingDiagram* _tmp114_ = NULL;
				WireState* _tmp115_ = NULL;
				_tmp114_ = self->priv->timingDiagram;
				_tmp115_ = wireState;
				timing_diagram_add_wire (_tmp114_, _tmp115_);
			}
			_wire_state_unref0 (wireState);
			break;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


/**
 * Renders the currently viewed part of the simulation. If
 * //fullRefresh// is false, then the circuit design is not redrawn.
 */
static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


gboolean simulator_window_render (SimulatorWindow* self, gboolean fullRefresh, gboolean cancelIfRunning, cairo_t* passedDisplayContext) {
	gboolean result = FALSE;
	cairo_t* displayContext = NULL;
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	SimulatorWindowRunState _tmp3_ = 0;
	GtkDrawingArea* _tmp6_ = NULL;
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	cairo_t* _tmp12_ = NULL;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = cancelIfRunning;
	if (_tmp1_) {
		SimulatorWindowRunState _tmp2_ = 0;
		_tmp2_ = self->priv->runState;
		_tmp0_ = _tmp2_ == SIMULATOR_WINDOW_RUN_STATE_RUNNING;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		_cairo_destroy0 (displayContext);
		return result;
	}
	_tmp3_ = self->priv->runState;
	if (_tmp3_ == SIMULATOR_WINDOW_RUN_STATE_PAUSED) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->inhibitRender;
		if (_tmp4_) {
			result = FALSE;
			_cairo_destroy0 (displayContext);
			return result;
		}
		self->priv->inhibitRender = TRUE;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = gtk_events_pending ();
			if (!_tmp5_) {
				break;
			}
			gtk_main_iteration ();
		}
		self->priv->inhibitRender = FALSE;
	}
	_tmp6_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp6_, &_tmp7_);
	areaAllocation = _tmp7_;
	_tmp8_ = areaAllocation;
	_tmp9_ = _tmp8_.width;
	width = _tmp9_;
	_tmp10_ = areaAllocation;
	_tmp11_ = _tmp10_.height;
	height = _tmp11_;
	_tmp12_ = passedDisplayContext;
	if (_tmp12_ == NULL) {
		GtkDrawingArea* _tmp13_ = NULL;
		GdkWindow* _tmp14_ = NULL;
		cairo_t* _tmp15_ = NULL;
		_tmp13_ = self->priv->display;
		_tmp14_ = gtk_widget_get_window ((GtkWidget*) _tmp13_);
		_tmp15_ = gdk_cairo_create (_tmp14_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp15_;
	} else {
		cairo_t* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		_tmp16_ = passedDisplayContext;
		_tmp17_ = _cairo_reference0 (_tmp16_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp17_;
	}
	_tmp18_ = fullRefresh;
	if (_tmp18_) {
		cairo_surface_t* offScreenSurface = NULL;
		cairo_t* _tmp19_ = NULL;
		cairo_surface_t* _tmp20_ = NULL;
		cairo_t* _tmp21_ = NULL;
		cairo_surface_t* _tmp22_ = NULL;
		cairo_content_t _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		cairo_surface_t* _tmp26_ = NULL;
		cairo_t* context = NULL;
		cairo_surface_t* _tmp27_ = NULL;
		cairo_t* _tmp28_ = NULL;
		cairo_t* _tmp29_ = NULL;
		cairo_t* _tmp30_ = NULL;
		cairo_t* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		cairo_t* _tmp34_ = NULL;
		gfloat _tmp35_ = 0.0F;
		gfloat _tmp36_ = 0.0F;
		cairo_t* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		CompiledCircuit* _tmp40_ = NULL;
		cairo_t* _tmp41_ = NULL;
		gfloat _tmp42_ = 0.0F;
		cairo_t* _tmp43_ = NULL;
		cairo_surface_t* _tmp44_ = NULL;
		cairo_t* _tmp45_ = NULL;
		_tmp19_ = displayContext;
		_tmp20_ = cairo_get_target (_tmp19_);
		_tmp21_ = displayContext;
		_tmp22_ = cairo_get_target (_tmp21_);
		_tmp23_ = cairo_surface_get_content (_tmp22_);
		_tmp24_ = width;
		_tmp25_ = height;
		_tmp26_ = cairo_surface_create_similar (_tmp20_, _tmp23_, _tmp24_, _tmp25_);
		offScreenSurface = _tmp26_;
		_tmp27_ = offScreenSurface;
		_tmp28_ = cairo_create (_tmp27_);
		context = _tmp28_;
		_tmp29_ = context;
		cairo_set_source_rgb (_tmp29_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp30_ = context;
		cairo_paint (_tmp30_);
		_tmp31_ = context;
		_tmp32_ = width;
		_tmp33_ = height;
		cairo_translate (_tmp31_, (gdouble) (_tmp32_ / 2), (gdouble) (_tmp33_ / 2));
		_tmp34_ = context;
		_tmp35_ = self->zoom;
		_tmp36_ = self->zoom;
		cairo_scale (_tmp34_, (gdouble) _tmp35_, (gdouble) _tmp36_);
		_tmp37_ = context;
		_tmp38_ = self->priv->xView;
		_tmp39_ = self->priv->yView;
		cairo_translate (_tmp37_, (gdouble) (-_tmp38_), (gdouble) (-_tmp39_));
		_tmp40_ = self->priv->compiledCircuit;
		_tmp41_ = context;
		_tmp42_ = self->zoom;
		compiled_circuit_render (_tmp40_, _tmp41_, TRUE, _tmp42_);
		_tmp43_ = displayContext;
		_tmp44_ = offScreenSurface;
		cairo_set_source_surface (_tmp43_, _tmp44_, (gdouble) 0, (gdouble) 0);
		_tmp45_ = displayContext;
		cairo_paint (_tmp45_);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (offScreenSurface);
	} else {
		cairo_t* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		cairo_t* _tmp49_ = NULL;
		gfloat _tmp50_ = 0.0F;
		gfloat _tmp51_ = 0.0F;
		cairo_t* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		CompiledCircuit* _tmp55_ = NULL;
		cairo_t* _tmp56_ = NULL;
		gfloat _tmp57_ = 0.0F;
		_tmp46_ = displayContext;
		_tmp47_ = width;
		_tmp48_ = height;
		cairo_translate (_tmp46_, (gdouble) (_tmp47_ / 2), (gdouble) (_tmp48_ / 2));
		_tmp49_ = displayContext;
		_tmp50_ = self->zoom;
		_tmp51_ = self->zoom;
		cairo_scale (_tmp49_, (gdouble) _tmp50_, (gdouble) _tmp51_);
		_tmp52_ = displayContext;
		_tmp53_ = self->priv->xView;
		_tmp54_ = self->priv->yView;
		cairo_translate (_tmp52_, (gdouble) (-_tmp53_), (gdouble) (-_tmp54_));
		_tmp55_ = self->priv->compiledCircuit;
		_tmp56_ = displayContext;
		_tmp57_ = self->zoom;
		compiled_circuit_render (_tmp55_, _tmp56_, FALSE, _tmp57_);
	}
	result = FALSE;
	_cairo_destroy0 (displayContext);
	return result;
}


/**
 * Ends the simulation. Presenting a summary.
 */
void simulator_window_close_simulation (SimulatorWindow* self) {
	FILE* _tmp0_ = NULL;
	TimingDiagram* _tmp1_ = NULL;
	CompiledCircuit* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	CompiledCircuit* _tmp8_ = NULL;
	Project* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Ending Simulation.\n");
	self->priv->runState = SIMULATOR_WINDOW_RUN_STATE_HALTING;
	_tmp1_ = self->priv->timingDiagram;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->compiledCircuit;
	_tmp3_ = _tmp2_->iterationCount;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Simulation Summary:\nIterations: ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	basic_dialog_information (NULL, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->priv->compiledCircuit;
	_tmp9_ = _tmp8_->project;
	_tmp9_->running = FALSE;
}


static void simulator_window_class_init (SimulatorWindowClass * klass) {
	simulator_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SimulatorWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = simulator_window_finalize;
}


static void simulator_window_instance_init (SimulatorWindow * self) {
	self->priv = SIMULATOR_WINDOW_GET_PRIVATE (self);
	self->priv->mouseMode = SIMULATOR_WINDOW_MOUSE_MODE_CONTEXT;
	self->gridSize = 5;
	self->priv->xView = 0;
	self->priv->yView = 0;
	self->zoom = (gfloat) 1;
	self->priv->cycleDelay = 0;
	self->priv->multistepSize = 50;
	self->priv->stepsLeft = 0;
	self->priv->cycleSourceID = (guint) 0;
	self->priv->refreshSourceID = (guint) 0;
	self->priv->microCycleDelay = 0;
	self->priv->inhibitRender = FALSE;
	self->priv->autoFitDesign = TRUE;
}


static void simulator_window_finalize (GObject* obj) {
	SimulatorWindow * self;
	TimingDiagram* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMULATOR_WINDOW, SimulatorWindow);
	_tmp0_ = self->priv->timingDiagram;
	timing_diagram_close_diagram (_tmp0_);
	_g_object_unref0 (self->priv->vBox);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->menuSimulation);
	_g_object_unref0 (self->priv->menuSimulationMenu);
	_g_object_unref0 (self->priv->menuSimulationRun);
	_g_object_unref0 (self->priv->menuSimulationSeparator1);
	_g_object_unref0 (self->priv->menuSimulationExit);
	_g_object_unref0 (self->priv->menuView);
	_g_object_unref0 (self->priv->menuViewMenu);
	_g_object_unref0 (self->priv->menuViewFitdesign);
	_g_object_unref0 (self->priv->menuViewAutofitdesign);
	_g_object_unref0 (self->priv->menuViewSeparator1);
	_g_object_unref0 (self->priv->menuViewTimingdiagram);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->toolScroll);
	_g_object_unref0 (self->priv->toolScrollImage);
	_g_object_unref0 (self->priv->toolZoom);
	_g_object_unref0 (self->priv->toolZoomImage);
	_g_object_unref0 (self->priv->toolSeparator1);
	_g_object_unref0 (self->priv->toolContext);
	_g_object_unref0 (self->priv->toolContextImage);
	_g_object_unref0 (self->priv->toolInteract);
	_g_object_unref0 (self->priv->toolInteractImage);
	_g_object_unref0 (self->priv->toolExplore);
	_g_object_unref0 (self->priv->toolExploreImage);
	_g_object_unref0 (self->priv->toolWatch);
	_g_object_unref0 (self->priv->toolWatchImage);
	_g_object_unref0 (self->priv->toolSeparator2);
	_g_object_unref0 (self->priv->toolShrink);
	_g_object_unref0 (self->priv->toolShrinkImage);
	_g_object_unref0 (self->priv->toolSeparator3);
	_g_object_unref0 (self->priv->toolRun);
	_g_object_unref0 (self->priv->toolRunImage);
	_g_object_unref0 (self->priv->toolSinglestep);
	_g_object_unref0 (self->priv->toolSinglestepImage);
	_g_object_unref0 (self->priv->toolMultistep);
	_g_object_unref0 (self->priv->toolMultistepImage);
	_g_object_unref0 (self->priv->toolSeparator4);
	_g_object_unref0 (self->priv->toolMaxspeed);
	_g_object_unref0 (self->priv->toolMaxspeedImage);
	_g_object_unref0 (self->priv->toolSpeed);
	_g_object_unref0 (self->priv->toolSpeedBox);
	_g_object_unref0 (self->priv->toolSpeedLabel);
	_g_object_unref0 (self->priv->toolSpeedSpin);
	_g_object_unref0 (self->priv->toolSeparator5);
	_g_object_unref0 (self->priv->toolStepsize);
	_g_object_unref0 (self->priv->toolStepsizeBox);
	_g_object_unref0 (self->priv->toolStepsizeLabel);
	_g_object_unref0 (self->priv->toolStepsizeSpin);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->display);
	_compiled_circuit_unref0 (self->priv->compiledCircuit);
	_g_object_unref0 (self->priv->timingDiagram);
	G_OBJECT_CLASS (simulator_window_parent_class)->finalize (obj);
}


/**
 * Interface for the user when running a circuit.
 * 
 * Allows a user to control and explore a circuit, using the
 * CompiledCircuit as a back-end.
 */
GType simulator_window_get_type (void) {
	static volatile gsize simulator_window_type_id__volatile = 0;
	if (g_once_init_enter (&simulator_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimulatorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simulator_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimulatorWindow), 0, (GInstanceInitFunc) simulator_window_instance_init, NULL };
		GType simulator_window_type_id;
		simulator_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "SimulatorWindow", &g_define_type_info, 0);
		g_once_init_leave (&simulator_window_type_id__volatile, simulator_window_type_id);
	}
	return simulator_window_type_id__volatile;
}



