/* timingdiagram.c generated by valac 0.24.0, the Vala compiler
 * generated from timingdiagram.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: timingdiagram.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <config.h>
#include <cairo-pdf.h>
#include <cairo-svg.h>


#define TYPE_TIMING_DIAGRAM (timing_diagram_get_type ())
#define TIMING_DIAGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMING_DIAGRAM, TimingDiagram))
#define TIMING_DIAGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMING_DIAGRAM, TimingDiagramClass))
#define IS_TIMING_DIAGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMING_DIAGRAM))
#define IS_TIMING_DIAGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMING_DIAGRAM))
#define TIMING_DIAGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMING_DIAGRAM, TimingDiagramClass))

typedef struct _TimingDiagram TimingDiagram;
typedef struct _TimingDiagramClass TimingDiagramClass;
typedef struct _TimingDiagramPrivate TimingDiagramPrivate;

#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;

#define TIMING_DIAGRAM_TYPE_MOUSE_MODE (timing_diagram_mouse_mode_get_type ())

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _compiled_circuit_unref0(var) ((var == NULL) ? NULL : (var = (compiled_circuit_unref (var), NULL)))
#define _wire_state_unref0(var) ((var == NULL) ? NULL : (var = (wire_state_unref (var), NULL)))

#define TYPE_PROPERTY_ITEM (property_item_get_type ())
#define PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM, PropertyItem))
#define PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM, PropertyItemClass))
#define IS_PROPERTY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM))
#define IS_PROPERTY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM))
#define PROPERTY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM, PropertyItemClass))

typedef struct _PropertyItem PropertyItem;
typedef struct _PropertyItemClass PropertyItemClass;

#define TYPE_PROPERTY_SET (property_set_get_type ())
#define PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_SET, PropertySet))
#define PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_SET, PropertySetClass))
#define IS_PROPERTY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_SET))
#define IS_PROPERTY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_SET))
#define PROPERTY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_SET, PropertySetClass))

typedef struct _PropertySet PropertySet;
typedef struct _PropertySetClass PropertySetClass;

#define TYPE_PROPERTY_ITEM_STRING (property_item_string_get_type ())
#define PROPERTY_ITEM_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_ITEM_STRING, PropertyItemString))
#define PROPERTY_ITEM_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_ITEM_STRING, PropertyItemStringClass))
#define IS_PROPERTY_ITEM_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_ITEM_STRING))
#define IS_PROPERTY_ITEM_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_ITEM_STRING))
#define PROPERTY_ITEM_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_ITEM_STRING, PropertyItemStringClass))

typedef struct _PropertyItemString PropertyItemString;
typedef struct _PropertyItemStringClass PropertyItemStringClass;

#define TYPE_PROPERTIES_QUERY (properties_query_get_type ())
#define PROPERTIES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_QUERY, PropertiesQuery))
#define PROPERTIES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTIES_QUERY, PropertiesQueryClass))
#define IS_PROPERTIES_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_QUERY))
#define IS_PROPERTIES_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTIES_QUERY))
#define PROPERTIES_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTIES_QUERY, PropertiesQueryClass))

typedef struct _PropertiesQuery PropertiesQuery;
typedef struct _PropertiesQueryClass PropertiesQueryClass;
typedef struct _PropertyItemPrivate PropertyItemPrivate;
typedef struct _PropertyItemStringPrivate PropertyItemStringPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CompiledCircuitPrivate CompiledCircuitPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_UPDATE_QUEUE (update_queue_get_type ())
#define UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPDATE_QUEUE, UpdateQueue))
#define UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPDATE_QUEUE, UpdateQueueClass))
#define IS_UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPDATE_QUEUE))
#define IS_UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPDATE_QUEUE))
#define UPDATE_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPDATE_QUEUE, UpdateQueueClass))

typedef struct _UpdateQueue UpdateQueue;
typedef struct _UpdateQueueClass UpdateQueueClass;

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;
#define _properties_query_unref0(var) ((var == NULL) ? NULL : (var = (properties_query_unref (var), NULL)))
#define _property_item_unref0(var) ((var == NULL) ? NULL : (var = (property_item_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define IMAGE_EXPORTER_TYPE_IMAGE_FORMAT (image_exporter_image_format_get_type ())

struct _TimingDiagram {
	GtkWindow parent_instance;
	TimingDiagramPrivate * priv;
	gboolean alwaysOnTop;
};

struct _TimingDiagramClass {
	GtkWindowClass parent_class;
};

typedef enum  {
	TIMING_DIAGRAM_MOUSE_MODE_SCROLL,
	TIMING_DIAGRAM_MOUSE_MODE_ZOOM,
	TIMING_DIAGRAM_MOUSE_MODE_MOVE,
	TIMING_DIAGRAM_MOUSE_MODE_DELETE,
	TIMING_DIAGRAM_MOUSE_MODE_ADJUST
} TimingDiagramMouseMode;

struct _TimingDiagramPrivate {
	GtkBox* vBox;
	GtkMenuBar* menubar;
	GtkMenuItem* menuFile;
	GtkMenu* menuFileMenu;
	GtkMenuItem* menuFileExport;
	GtkMenu* menuFileExportMenu;
	GtkMenuItem* menuFileExportPng;
	GtkMenuItem* menuFileExportPdf;
	GtkMenuItem* menuFileExportSvg;
	GtkMenuItem* menuFileSeparator1;
	GtkMenuItem* menuFileExit;
	GtkMenuItem* menuRecording;
	GtkMenu* menuRecordingMenu;
	GtkMenuItem* menuRecordingReset;
	GtkMenuItem* menuView;
	GtkMenu* menuViewMenu;
	GtkCheckMenuItem* menuViewAlwaysontop;
	GtkMenuItem* menuViewSeparator1;
	GtkCheckMenuItem* menuViewShowgrid;
	GtkMenuItem* menuViewSeparator2;
	GtkMenuItem* menuViewReset;
	GtkToolbar* toolbar;
	GtkRadioToolButton* toolScroll;
	GtkImage* toolScrollImage;
	GtkRadioToolButton* toolZoom;
	GtkImage* toolZoomImage;
	GtkSeparatorToolItem* toolSeparator1;
	GtkRadioToolButton* toolMove;
	GtkImage* toolMoveImage;
	GtkRadioToolButton* toolDelete;
	GtkImage* toolDeleteImage;
	GtkRadioToolButton* toolAdjust;
	GtkImage* toolAdjustImage;
	GtkEventBox* controller;
	GtkDrawingArea* display;
	cairo_surface_t* diagramCache;
	cairo_surface_t* offScreenSurface;
	gint largestLengthCache;
	WireState** wireStates;
	gint wireStates_length1;
	gint _wireStates_size_;
	gchar** labels;
	gint labels_length1;
	gint _labels_size_;
	gint xMouseStart;
	gint yMouseStart;
	TimingDiagramMouseMode mouseMode;
	gboolean showGrid;
	gint xView;
	gint yView;
	gfloat xZoom;
	gfloat yZoom;
	gdouble barPosition;
	CompiledCircuit* compiledCircuit;
	gint iterationCountOffset;
};

struct _PropertyItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PropertyItemPrivate * priv;
	gchar* name;
	gchar* description;
};

struct _PropertyItemClass {
	GTypeClass parent_class;
	void (*finalize) (PropertyItem *self);
	GtkWidget* (*create_widget) (PropertyItem* self);
	void (*read_widget) (PropertyItem* self, GtkWidget* propertyWidget);
};

struct _PropertyItemString {
	PropertyItem parent_instance;
	PropertyItemStringPrivate * priv;
	gchar* data;
};

struct _PropertyItemStringClass {
	PropertyItemClass parent_class;
};

struct _CompiledCircuit {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompiledCircuitPrivate * priv;
	CustomComponentDef* rootComponent;
	Project* project;
	UpdateQueue* renderWireStates;
	UpdateQueue* renderComponentStates;
	UpdateQueue* processWireStates;
	UpdateQueue* processComponentStates;
	CustomComponentDef* viewedComponent;
	gint iterationCount;
};

struct _CompiledCircuitClass {
	GTypeClass parent_class;
	void (*finalize) (CompiledCircuit *self);
};

typedef enum  {
	IMAGE_EXPORTER_IMAGE_FORMAT_PNG_RGB,
	IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB,
	IMAGE_EXPORTER_IMAGE_FORMAT_PDF,
	IMAGE_EXPORTER_IMAGE_FORMAT_SVG,
	IMAGE_EXPORTER_IMAGE_FORMAT_SVG_CLEAR
} ImageExporterImageFormat;

typedef void (*ImageExporterRenderer) (const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution, void* user_data);

static gpointer timing_diagram_parent_class = NULL;

GType timing_diagram_get_type (void) G_GNUC_CONST;
gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
static GType timing_diagram_mouse_mode_get_type (void) G_GNUC_UNUSED;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
#define TIMING_DIAGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TIMING_DIAGRAM, TimingDiagramPrivate))
enum  {
	TIMING_DIAGRAM_DUMMY_PROPERTY
};
TimingDiagram* timing_diagram_new (CompiledCircuit* compiledCircuit);
TimingDiagram* timing_diagram_construct (GType object_type, CompiledCircuit* compiledCircuit);
void timing_diagram_populate (TimingDiagram* self);
gboolean timing_diagram_hide_diagram (TimingDiagram* self);
static gboolean _timing_diagram_hide_diagram_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
#define CORE_programName "SmartSim"
void timing_diagram_export_png (TimingDiagram* self);
static void _timing_diagram_export_png_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void timing_diagram_export_pdf (TimingDiagram* self);
static void _timing_diagram_export_pdf_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void timing_diagram_export_svg (TimingDiagram* self);
static void _timing_diagram_export_svg_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda26_ (TimingDiagram* self);
static void ___lambda26__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda27_ (TimingDiagram* self);
void timing_diagram_reset_timings (TimingDiagram* self);
static void ___lambda27__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda28_ (TimingDiagram* self, GtkCheckMenuItem* menuItem);
static void ___lambda28__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda29_ (TimingDiagram* self, GtkCheckMenuItem* menuItem);
gboolean timing_diagram_render (TimingDiagram* self, gboolean fullRefresh, cairo_t* passedDisplayContext);
static void ___lambda29__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void __lambda30_ (TimingDiagram* self);
void timing_diagram_reset_view (TimingDiagram* self);
static void ___lambda30__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda31_ (TimingDiagram* self);
static void ___lambda31__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda32_ (TimingDiagram* self);
static void ___lambda32__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda33_ (TimingDiagram* self);
static void ___lambda33__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda34_ (TimingDiagram* self);
static void ___lambda34__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda35_ (TimingDiagram* self);
static void ___lambda35__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static gboolean timing_diagram_mouse_down (TimingDiagram* self, GdkEventButton* event);
static gboolean _timing_diagram_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean timing_diagram_mouse_move (TimingDiagram* self, GdkEventMotion* event);
static gboolean _timing_diagram_mouse_move_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean timing_diagram_mouse_up (TimingDiagram* self, GdkEventButton* event);
static gboolean _timing_diagram_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda36_ (TimingDiagram* self, cairo_t* context);
static gboolean ___lambda36__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean __lambda37_ (TimingDiagram* self);
static gboolean ___lambda37__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
void timing_diagram_close_diagram (TimingDiagram* self);
void timing_diagram_show_diagram (TimingDiagram* self);
void timing_diagram_add_wire (TimingDiagram* self, WireState* newWireState);
gpointer property_item_ref (gpointer instance);
void property_item_unref (gpointer instance);
GParamSpec* param_spec_property_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_item (GValue* value, gpointer v_object);
void value_take_property_item (GValue* value, gpointer v_object);
gpointer value_get_property_item (const GValue* value);
GType property_item_get_type (void) G_GNUC_CONST;
GType property_set_get_type (void) G_GNUC_CONST;
PropertySet* property_set_new (const gchar* name, const gchar* description);
PropertySet* property_set_construct (GType object_type, const gchar* name, const gchar* description);
GType property_item_string_get_type (void) G_GNUC_CONST;
PropertyItemString* property_item_string_new (const gchar* name, const gchar* description, const gchar* data);
PropertyItemString* property_item_string_construct (GType object_type, const gchar* name, const gchar* description, const gchar* data);
gint property_set_add_item (PropertySet* self, PropertyItem* propertyItem);
gpointer properties_query_ref (gpointer instance);
void properties_query_unref (gpointer instance);
GParamSpec* param_spec_properties_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_properties_query (GValue* value, gpointer v_object);
void value_take_properties_query (GValue* value, gpointer v_object);
gpointer value_get_properties_query (const GValue* value);
GType properties_query_get_type (void) G_GNUC_CONST;
PropertiesQuery* properties_query_new (const gchar* title, GtkWindow* parent, PropertySet* propertySet);
PropertiesQuery* properties_query_construct (GType object_type, const gchar* title, GtkWindow* parent, PropertySet* propertySet);
gint properties_query_run (PropertiesQuery* self);
static void _vala_array_add114 (WireState*** array, int* length, int* size, WireState* value);
static void _vala_array_add115 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add116 (gchar*** array, int* length, int* size, gchar* value);
void wire_state_start_recording (WireState* self, gint unknownTime);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer update_queue_ref (gpointer instance);
void update_queue_unref (gpointer instance);
GParamSpec* param_spec_update_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_update_queue (GValue* value, gpointer v_object);
void value_take_update_queue (GValue* value, gpointer v_object);
gpointer value_get_update_queue (const GValue* value);
GType update_queue_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
static void timing_diagram_forget_wire (TimingDiagram* self, gint wireNumber);
static void _vala_array_add117 (WireState*** array, int* length, int* size, WireState* value);
static void _vala_array_add118 (gchar*** array, int* length, int* size, gchar* value);
void wire_state_stop_recording (WireState* self);
static WireState** _vala_array_dup94 (WireState** self, int length);
static gchar** _vala_array_dup95 (gchar** self, int length);
static void timing_diagram_move_wire (TimingDiagram* self, gint fromNumber, gint toNumber);
static void _vala_array_add119 (WireState*** array, int* length, int* size, WireState* value);
static void _vala_array_add120 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add121 (WireState*** array, int* length, int* size, WireState* value);
static void _vala_array_add122 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add123 (WireState*** array, int* length, int* size, WireState* value);
static void _vala_array_add124 (gchar*** array, int* length, int* size, gchar* value);
static WireState** _vala_array_dup96 (WireState** self, int length);
static gchar** _vala_array_dup97 (gchar** self, int length);
static void timing_diagram_adjust_wire (TimingDiagram* self, gint wireNumber);
gint timing_diagram_text_length (TimingDiagram* self);
void timing_diagram_render_labels (TimingDiagram* self, cairo_t* context, gboolean fullRender, gint width, gint* largestLength);
void timing_diagram_render_graphs (TimingDiagram* self, cairo_t* context, gboolean fullRender, gint width, gint largestLength);
void wire_state_render_history (WireState* self, cairo_t* context, gint xStart, gint xEnd, gfloat height, gfloat stretch);
void timing_diagram_render_ruler (TimingDiagram* self, cairo_t* context, gboolean fullRender, gint width, gint height, gint largestLength);
static void timing_diagram_render_bar (TimingDiagram* self, cairo_t* context, gint height, gint largestLength);
GType image_exporter_image_format_get_type (void) G_GNUC_CONST;
void image_exporter_export_png (ImageExporterRenderer renderer, void* renderer_target);
static void timing_diagram_file_render (TimingDiagram* self, const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution);
static void _timing_diagram_file_render_image_exporter_renderer (const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution, gpointer self);
void image_exporter_export_pdf (ImageExporterRenderer renderer, void* renderer_target);
void image_exporter_export_svg (ImageExporterRenderer renderer, void* renderer_target);
static void timing_diagram_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Actions to perform when the mouse button is released.
 */
static GType timing_diagram_mouse_mode_get_type (void) {
	static volatile gsize timing_diagram_mouse_mode_type_id__volatile = 0;
	if (g_once_init_enter (&timing_diagram_mouse_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{TIMING_DIAGRAM_MOUSE_MODE_SCROLL, "TIMING_DIAGRAM_MOUSE_MODE_SCROLL", "scroll"}, {TIMING_DIAGRAM_MOUSE_MODE_ZOOM, "TIMING_DIAGRAM_MOUSE_MODE_ZOOM", "zoom"}, {TIMING_DIAGRAM_MOUSE_MODE_MOVE, "TIMING_DIAGRAM_MOUSE_MODE_MOVE", "move"}, {TIMING_DIAGRAM_MOUSE_MODE_DELETE, "TIMING_DIAGRAM_MOUSE_MODE_DELETE", "delete"}, {TIMING_DIAGRAM_MOUSE_MODE_ADJUST, "TIMING_DIAGRAM_MOUSE_MODE_ADJUST", "adjust"}, {0, NULL, NULL}};
		GType timing_diagram_mouse_mode_type_id;
		timing_diagram_mouse_mode_type_id = g_enum_register_static ("TimingDiagramMouseMode", values);
		g_once_init_leave (&timing_diagram_mouse_mode_type_id__volatile, timing_diagram_mouse_mode_type_id);
	}
	return timing_diagram_mouse_mode_type_id__volatile;
}


static gpointer _compiled_circuit_ref0 (gpointer self) {
	return self ? compiled_circuit_ref (self) : NULL;
}


TimingDiagram* timing_diagram_construct (GType object_type, CompiledCircuit* compiledCircuit) {
	TimingDiagram * self = NULL;
	CompiledCircuit* _tmp0_ = NULL;
	CompiledCircuit* _tmp1_ = NULL;
	g_return_val_if_fail (compiledCircuit != NULL, NULL);
	self = (TimingDiagram*) g_object_new (object_type, NULL);
	_tmp0_ = compiledCircuit;
	_tmp1_ = _compiled_circuit_ref0 (_tmp0_);
	_compiled_circuit_unref0 (self->priv->compiledCircuit);
	self->priv->compiledCircuit = _tmp1_;
	timing_diagram_populate (self);
	return self;
}


TimingDiagram* timing_diagram_new (CompiledCircuit* compiledCircuit) {
	return timing_diagram_construct (TYPE_TIMING_DIAGRAM, compiledCircuit);
}


/**
 * Populate the window with widgets.
 */
static gboolean _timing_diagram_hide_diagram_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = timing_diagram_hide_diagram ((TimingDiagram*) self);
	return result;
}


static void _timing_diagram_export_png_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	timing_diagram_export_png ((TimingDiagram*) self);
}


static void _timing_diagram_export_pdf_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	timing_diagram_export_pdf ((TimingDiagram*) self);
}


static void _timing_diagram_export_svg_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	timing_diagram_export_svg ((TimingDiagram*) self);
}


static void __lambda26_ (TimingDiagram* self) {
	timing_diagram_hide_diagram (self);
}


static void ___lambda26__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda26_ ((TimingDiagram*) self);
}


static void __lambda27_ (TimingDiagram* self) {
	timing_diagram_reset_timings (self);
}


static void ___lambda27__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda27_ ((TimingDiagram*) self);
}


static void __lambda28_ (TimingDiagram* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkCheckMenuItem* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp2_);
	_tmp3_ = menuItem;
	_tmp4_ = gtk_check_menu_item_get_active (_tmp3_);
	_tmp5_ = _tmp4_;
	self->alwaysOnTop = _tmp5_;
}


static void ___lambda28__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda28_ ((TimingDiagram*) self, _sender);
}


static void __lambda29_ (TimingDiagram* self, GtkCheckMenuItem* menuItem) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (menuItem != NULL);
	_tmp0_ = menuItem;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->showGrid = _tmp2_;
	_cairo_surface_destroy0 (self->priv->diagramCache);
	self->priv->diagramCache = NULL;
	timing_diagram_render (self, TRUE, NULL);
}


static void ___lambda29__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	__lambda29_ ((TimingDiagram*) self, _sender);
}


static void __lambda30_ (TimingDiagram* self) {
	timing_diagram_reset_view (self);
}


static void ___lambda30__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda30_ ((TimingDiagram*) self);
}


static void __lambda31_ (TimingDiagram* self) {
	self->priv->mouseMode = TIMING_DIAGRAM_MOUSE_MODE_SCROLL;
}


static void ___lambda31__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda31_ ((TimingDiagram*) self);
}


static void __lambda32_ (TimingDiagram* self) {
	self->priv->mouseMode = TIMING_DIAGRAM_MOUSE_MODE_ZOOM;
}


static void ___lambda32__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda32_ ((TimingDiagram*) self);
}


static void __lambda33_ (TimingDiagram* self) {
	self->priv->mouseMode = TIMING_DIAGRAM_MOUSE_MODE_MOVE;
}


static void ___lambda33__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda33_ ((TimingDiagram*) self);
}


static void __lambda34_ (TimingDiagram* self) {
	self->priv->mouseMode = TIMING_DIAGRAM_MOUSE_MODE_DELETE;
}


static void ___lambda34__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda34_ ((TimingDiagram*) self);
}


static void __lambda35_ (TimingDiagram* self) {
	self->priv->mouseMode = TIMING_DIAGRAM_MOUSE_MODE_ADJUST;
}


static void ___lambda35__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda35_ ((TimingDiagram*) self);
}


static gboolean _timing_diagram_mouse_down_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = timing_diagram_mouse_down ((TimingDiagram*) self, event);
	return result;
}


static gboolean _timing_diagram_mouse_move_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = timing_diagram_mouse_move ((TimingDiagram*) self, event);
	return result;
}


static gboolean _timing_diagram_mouse_up_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = timing_diagram_mouse_up ((TimingDiagram*) self, event);
	return result;
}


static gboolean __lambda36_ (TimingDiagram* self, cairo_t* context) {
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	timing_diagram_render (self, TRUE, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda36__gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = __lambda36_ ((TimingDiagram*) self, cr);
	return result;
}


static gboolean __lambda37_ (TimingDiagram* self) {
	gboolean result = FALSE;
	_cairo_surface_destroy0 (self->priv->diagramCache);
	self->priv->diagramCache = NULL;
	timing_diagram_render (self, TRUE, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda37__gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = __lambda37_ ((TimingDiagram*) self);
	return result;
}


void timing_diagram_populate (TimingDiagram* self) {
	FILE* _tmp0_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkMenuBar* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkMenuBar* _tmp8_ = NULL;
	GtkMenuItem* _tmp9_ = NULL;
	GtkMenuBar* _tmp10_ = NULL;
	GtkMenuItem* _tmp11_ = NULL;
	GtkMenu* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_ = NULL;
	GtkMenu* _tmp14_ = NULL;
	GtkMenuItem* _tmp15_ = NULL;
	GtkMenu* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_ = NULL;
	GtkMenu* _tmp18_ = NULL;
	GtkMenuItem* _tmp19_ = NULL;
	GtkMenu* _tmp20_ = NULL;
	GtkMenuItem* _tmp21_ = NULL;
	GtkMenu* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_ = NULL;
	GtkMenuItem* _tmp24_ = NULL;
	GtkMenuItem* _tmp25_ = NULL;
	GtkMenu* _tmp26_ = NULL;
	GtkMenuItem* _tmp27_ = NULL;
	GtkMenuItem* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_ = NULL;
	GtkMenu* _tmp30_ = NULL;
	GtkMenuItem* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_ = NULL;
	GtkSeparatorMenuItem* _tmp33_ = NULL;
	GtkMenu* _tmp34_ = NULL;
	GtkMenuItem* _tmp35_ = NULL;
	GtkMenuItem* _tmp36_ = NULL;
	GtkMenu* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_ = NULL;
	GtkMenuItem* _tmp39_ = NULL;
	GtkMenuItem* _tmp40_ = NULL;
	GtkMenuBar* _tmp41_ = NULL;
	GtkMenuItem* _tmp42_ = NULL;
	GtkMenu* _tmp43_ = NULL;
	GtkMenuItem* _tmp44_ = NULL;
	GtkMenu* _tmp45_ = NULL;
	GtkMenuItem* _tmp46_ = NULL;
	GtkMenu* _tmp47_ = NULL;
	GtkMenuItem* _tmp48_ = NULL;
	GtkMenuItem* _tmp49_ = NULL;
	GtkMenuItem* _tmp50_ = NULL;
	GtkMenuBar* _tmp51_ = NULL;
	GtkMenuItem* _tmp52_ = NULL;
	GtkMenu* _tmp53_ = NULL;
	GtkMenuItem* _tmp54_ = NULL;
	GtkMenu* _tmp55_ = NULL;
	GtkCheckMenuItem* _tmp56_ = NULL;
	GtkMenu* _tmp57_ = NULL;
	GtkCheckMenuItem* _tmp58_ = NULL;
	GtkCheckMenuItem* _tmp59_ = NULL;
	GtkCheckMenuItem* _tmp60_ = NULL;
	GtkSeparatorMenuItem* _tmp61_ = NULL;
	GtkMenu* _tmp62_ = NULL;
	GtkMenuItem* _tmp63_ = NULL;
	GtkCheckMenuItem* _tmp64_ = NULL;
	GtkMenu* _tmp65_ = NULL;
	GtkCheckMenuItem* _tmp66_ = NULL;
	GtkCheckMenuItem* _tmp67_ = NULL;
	GtkCheckMenuItem* _tmp68_ = NULL;
	GtkSeparatorMenuItem* _tmp69_ = NULL;
	GtkMenu* _tmp70_ = NULL;
	GtkMenuItem* _tmp71_ = NULL;
	GtkMenuItem* _tmp72_ = NULL;
	GtkMenu* _tmp73_ = NULL;
	GtkMenuItem* _tmp74_ = NULL;
	GtkMenuItem* _tmp75_ = NULL;
	GtkToolbar* _tmp76_ = NULL;
	GtkToolbar* _tmp77_ = NULL;
	GtkBox* _tmp78_ = NULL;
	GtkToolbar* _tmp79_ = NULL;
	GtkImage* _tmp80_ = NULL;
	GtkRadioToolButton* _tmp81_ = NULL;
	GtkRadioToolButton* _tmp82_ = NULL;
	GtkRadioToolButton* _tmp83_ = NULL;
	GtkImage* _tmp84_ = NULL;
	GtkToolbar* _tmp85_ = NULL;
	GtkRadioToolButton* _tmp86_ = NULL;
	GtkRadioToolButton* _tmp87_ = NULL;
	GtkRadioToolButton* _tmp88_ = NULL;
	GtkImage* _tmp89_ = NULL;
	GtkRadioToolButton* _tmp90_ = NULL;
	GtkRadioToolButton* _tmp91_ = NULL;
	GtkRadioToolButton* _tmp92_ = NULL;
	GtkRadioToolButton* _tmp93_ = NULL;
	GtkImage* _tmp94_ = NULL;
	GtkToolbar* _tmp95_ = NULL;
	GtkRadioToolButton* _tmp96_ = NULL;
	GtkRadioToolButton* _tmp97_ = NULL;
	GtkRadioToolButton* _tmp98_ = NULL;
	GtkSeparatorToolItem* _tmp99_ = NULL;
	GtkToolbar* _tmp100_ = NULL;
	GtkSeparatorToolItem* _tmp101_ = NULL;
	GtkImage* _tmp102_ = NULL;
	GtkRadioToolButton* _tmp103_ = NULL;
	GtkRadioToolButton* _tmp104_ = NULL;
	GtkRadioToolButton* _tmp105_ = NULL;
	GtkRadioToolButton* _tmp106_ = NULL;
	GtkImage* _tmp107_ = NULL;
	GtkToolbar* _tmp108_ = NULL;
	GtkRadioToolButton* _tmp109_ = NULL;
	GtkRadioToolButton* _tmp110_ = NULL;
	GtkRadioToolButton* _tmp111_ = NULL;
	GtkImage* _tmp112_ = NULL;
	GtkRadioToolButton* _tmp113_ = NULL;
	GtkRadioToolButton* _tmp114_ = NULL;
	GtkRadioToolButton* _tmp115_ = NULL;
	GtkRadioToolButton* _tmp116_ = NULL;
	GtkImage* _tmp117_ = NULL;
	GtkToolbar* _tmp118_ = NULL;
	GtkRadioToolButton* _tmp119_ = NULL;
	GtkRadioToolButton* _tmp120_ = NULL;
	GtkRadioToolButton* _tmp121_ = NULL;
	GtkImage* _tmp122_ = NULL;
	GtkRadioToolButton* _tmp123_ = NULL;
	GtkRadioToolButton* _tmp124_ = NULL;
	GtkRadioToolButton* _tmp125_ = NULL;
	GtkRadioToolButton* _tmp126_ = NULL;
	GtkImage* _tmp127_ = NULL;
	GtkToolbar* _tmp128_ = NULL;
	GtkRadioToolButton* _tmp129_ = NULL;
	GtkRadioToolButton* _tmp130_ = NULL;
	GtkRadioToolButton* _tmp131_ = NULL;
	GtkEventBox* _tmp132_ = NULL;
	GtkBox* _tmp133_ = NULL;
	GtkEventBox* _tmp134_ = NULL;
	GtkEventBox* _tmp135_ = NULL;
	GtkEventBox* _tmp136_ = NULL;
	GtkEventBox* _tmp137_ = NULL;
	GtkEventBox* _tmp138_ = NULL;
	GtkDrawingArea* _tmp139_ = NULL;
	GtkEventBox* _tmp140_ = NULL;
	GtkDrawingArea* _tmp141_ = NULL;
	GtkDrawingArea* _tmp142_ = NULL;
	GtkDrawingArea* _tmp143_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Timing Diagram Window Created\n");
	gtk_window_set_default_size ((GtkWindow*) self, 800, 400);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _timing_diagram_hide_diagram_gtk_widget_delete_event, self, 0);
	gtk_window_set_title ((GtkWindow*) self, CORE_programName " - Timing Diagram");
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		_tmp2_ = gdk_pixbuf_new_from_file (PACKAGE_DATADIR "images/icons/smartsim64.png", &_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch72_g_error;
		}
		gtk_window_set_icon ((GtkWindow*) self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally72;
	__catch72_g_error:
	{
		FILE* _tmp3_ = NULL;
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		fprintf (_tmp3_, "Could not load window image.\n");
	}
	__finally72:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->vBox);
	self->priv->vBox = _tmp4_;
	_tmp5_ = self->priv->vBox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkMenuBar*) gtk_menu_bar_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->menubar);
	self->priv->menubar = _tmp6_;
	_tmp7_ = self->priv->vBox;
	_tmp8_ = self->priv->menubar;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("File");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->menuFile);
	self->priv->menuFile = _tmp9_;
	_tmp10_ = self->priv->menubar;
	_tmp11_ = self->priv->menuFile;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->menuFileMenu);
	self->priv->menuFileMenu = _tmp12_;
	_tmp13_ = self->priv->menuFile;
	_tmp14_ = self->priv->menuFileMenu;
	gtk_menu_item_set_submenu (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Export");
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->menuFileExport);
	self->priv->menuFileExport = _tmp15_;
	_tmp16_ = self->priv->menuFileMenu;
	_tmp17_ = self->priv->menuFileExport;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->menuFileExportMenu);
	self->priv->menuFileExportMenu = _tmp18_;
	_tmp19_ = self->priv->menuFileExport;
	_tmp20_ = self->priv->menuFileExportMenu;
	gtk_menu_item_set_submenu (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Diagram Image as PNG Image");
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->menuFileExportPng);
	self->priv->menuFileExportPng = _tmp21_;
	_tmp22_ = self->priv->menuFileExportMenu;
	_tmp23_ = self->priv->menuFileExportPng;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->menuFileExportPng;
	g_signal_connect_object (_tmp24_, "activate", (GCallback) _timing_diagram_export_png_gtk_menu_item_activate, self, 0);
	_tmp25_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Diagram Image as PDF Document");
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->menuFileExportPdf);
	self->priv->menuFileExportPdf = _tmp25_;
	_tmp26_ = self->priv->menuFileExportMenu;
	_tmp27_ = self->priv->menuFileExportPdf;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->menuFileExportPdf;
	g_signal_connect_object (_tmp28_, "activate", (GCallback) _timing_diagram_export_pdf_gtk_menu_item_activate, self, 0);
	_tmp29_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Diagram Image as SVG Image");
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->menuFileExportSvg);
	self->priv->menuFileExportSvg = _tmp29_;
	_tmp30_ = self->priv->menuFileExportMenu;
	_tmp31_ = self->priv->menuFileExportSvg;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->menuFileExportSvg;
	g_signal_connect_object (_tmp32_, "activate", (GCallback) _timing_diagram_export_svg_gtk_menu_item_activate, self, 0);
	_tmp33_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->menuFileSeparator1);
	self->priv->menuFileSeparator1 = (GtkMenuItem*) _tmp33_;
	_tmp34_ = self->priv->menuFileMenu;
	_tmp35_ = self->priv->menuFileSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Close Timing Diagram");
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->menuFileExit);
	self->priv->menuFileExit = _tmp36_;
	_tmp37_ = self->priv->menuFileMenu;
	_tmp38_ = self->priv->menuFileExit;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->menuFileExit;
	g_signal_connect_object (_tmp39_, "activate", (GCallback) ___lambda26__gtk_menu_item_activate, self, 0);
	_tmp40_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Recording");
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->priv->menuRecording);
	self->priv->menuRecording = _tmp40_;
	_tmp41_ = self->priv->menubar;
	_tmp42_ = self->priv->menuRecording;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->menuRecordingMenu);
	self->priv->menuRecordingMenu = _tmp43_;
	_tmp44_ = self->priv->menuRecording;
	_tmp45_ = self->priv->menuRecordingMenu;
	gtk_menu_item_set_submenu (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Reset");
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->menuRecordingReset);
	self->priv->menuRecordingReset = _tmp46_;
	_tmp47_ = self->priv->menuRecordingMenu;
	_tmp48_ = self->priv->menuRecordingReset;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->menuRecordingReset;
	g_signal_connect_object (_tmp49_, "activate", (GCallback) ___lambda27__gtk_menu_item_activate, self, 0);
	_tmp50_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("View");
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->menuView);
	self->priv->menuView = _tmp50_;
	_tmp51_ = self->priv->menubar;
	_tmp52_ = self->priv->menuView;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->menuViewMenu);
	self->priv->menuViewMenu = _tmp53_;
	_tmp54_ = self->priv->menuView;
	_tmp55_ = self->priv->menuViewMenu;
	gtk_menu_item_set_submenu (_tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Always On Top");
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->menuViewAlwaysontop);
	self->priv->menuViewAlwaysontop = _tmp56_;
	_tmp57_ = self->priv->menuViewMenu;
	_tmp58_ = self->priv->menuViewAlwaysontop;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp57_, (GtkWidget*) ((GtkMenuItem*) _tmp58_));
	_tmp59_ = self->priv->menuViewAlwaysontop;
	gtk_check_menu_item_set_active (_tmp59_, TRUE);
	_tmp60_ = self->priv->menuViewAlwaysontop;
	g_signal_connect_object (_tmp60_, "toggled", (GCallback) ___lambda28__gtk_check_menu_item_toggled, self, 0);
	_tmp61_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->menuViewSeparator1);
	self->priv->menuViewSeparator1 = (GtkMenuItem*) _tmp61_;
	_tmp62_ = self->priv->menuViewMenu;
	_tmp63_ = self->priv->menuViewSeparator1;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Show Grid");
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->menuViewShowgrid);
	self->priv->menuViewShowgrid = _tmp64_;
	_tmp65_ = self->priv->menuViewMenu;
	_tmp66_ = self->priv->menuViewShowgrid;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp65_, (GtkWidget*) ((GtkMenuItem*) _tmp66_));
	_tmp67_ = self->priv->menuViewShowgrid;
	gtk_check_menu_item_set_active (_tmp67_, TRUE);
	_tmp68_ = self->priv->menuViewShowgrid;
	g_signal_connect_object (_tmp68_, "toggled", (GCallback) ___lambda29__gtk_check_menu_item_toggled, self, 0);
	_tmp69_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->menuViewSeparator2);
	self->priv->menuViewSeparator2 = (GtkMenuItem*) _tmp69_;
	_tmp70_ = self->priv->menuViewMenu;
	_tmp71_ = self->priv->menuViewSeparator2;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Reset View");
	g_object_ref_sink (_tmp72_);
	_g_object_unref0 (self->priv->menuViewReset);
	self->priv->menuViewReset = _tmp72_;
	_tmp73_ = self->priv->menuViewMenu;
	_tmp74_ = self->priv->menuViewReset;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = self->priv->menuViewReset;
	g_signal_connect_object (_tmp75_, "activate", (GCallback) ___lambda30__gtk_menu_item_activate, self, 0);
	_tmp76_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp76_;
	_tmp77_ = self->priv->toolbar;
	g_object_set (_tmp77_, "toolbar-style", GTK_TOOLBAR_ICONS, NULL);
	_tmp78_ = self->priv->vBox;
	_tmp79_ = self->priv->toolbar;
	gtk_box_pack_start (_tmp78_, (GtkWidget*) _tmp79_, FALSE, TRUE, (guint) 0);
	_tmp80_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/scroll.png");
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->priv->toolScrollImage);
	self->priv->toolScrollImage = _tmp80_;
	_tmp81_ = (GtkRadioToolButton*) gtk_radio_tool_button_new (NULL);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->toolScroll);
	self->priv->toolScroll = _tmp81_;
	_tmp82_ = self->priv->toolScroll;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp82_, "Scroll");
	_tmp83_ = self->priv->toolScroll;
	_tmp84_ = self->priv->toolScrollImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp83_, (GtkWidget*) _tmp84_);
	_tmp85_ = self->priv->toolbar;
	_tmp86_ = self->priv->toolScroll;
	gtk_toolbar_insert (_tmp85_, (GtkToolItem*) _tmp86_, -1);
	_tmp87_ = self->priv->toolScroll;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp87_, "Scroll: Move your view of the timing diagram with click and drag.");
	_tmp88_ = self->priv->toolScroll;
	g_signal_connect_object ((GtkToolButton*) _tmp88_, "clicked", (GCallback) ___lambda31__gtk_tool_button_clicked, self, 0);
	_tmp89_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/zoom.png");
	g_object_ref_sink (_tmp89_);
	_g_object_unref0 (self->priv->toolZoomImage);
	self->priv->toolZoomImage = _tmp89_;
	_tmp90_ = self->priv->toolScroll;
	_tmp91_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp90_);
	g_object_ref_sink (_tmp91_);
	_g_object_unref0 (self->priv->toolZoom);
	self->priv->toolZoom = _tmp91_;
	_tmp92_ = self->priv->toolZoom;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp92_, "Zoom");
	_tmp93_ = self->priv->toolZoom;
	_tmp94_ = self->priv->toolZoomImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = self->priv->toolbar;
	_tmp96_ = self->priv->toolZoom;
	gtk_toolbar_insert (_tmp95_, (GtkToolItem*) _tmp96_, -1);
	_tmp97_ = self->priv->toolZoom;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp97_, "Zoom: Drag downward to stretch vertically, rightward to stretch horizo" \
"ntally.");
	_tmp98_ = self->priv->toolZoom;
	g_signal_connect_object ((GtkToolButton*) _tmp98_, "clicked", (GCallback) ___lambda32__gtk_tool_button_clicked, self, 0);
	_tmp99_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->toolSeparator1);
	self->priv->toolSeparator1 = _tmp99_;
	_tmp100_ = self->priv->toolbar;
	_tmp101_ = self->priv->toolSeparator1;
	gtk_toolbar_insert (_tmp100_, (GtkToolItem*) _tmp101_, -1);
	_tmp102_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/move.png");
	g_object_ref_sink (_tmp102_);
	_g_object_unref0 (self->priv->toolMoveImage);
	self->priv->toolMoveImage = _tmp102_;
	_tmp103_ = self->priv->toolScroll;
	_tmp104_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp103_);
	g_object_ref_sink (_tmp104_);
	_g_object_unref0 (self->priv->toolMove);
	self->priv->toolMove = _tmp104_;
	_tmp105_ = self->priv->toolMove;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp105_, "Move");
	_tmp106_ = self->priv->toolMove;
	_tmp107_ = self->priv->toolMoveImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp106_, (GtkWidget*) _tmp107_);
	_tmp108_ = self->priv->toolbar;
	_tmp109_ = self->priv->toolMove;
	gtk_toolbar_insert (_tmp108_, (GtkToolItem*) _tmp109_, -1);
	_tmp110_ = self->priv->toolMove;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp110_, "Move: Click and drag a trace to reorder it.");
	_tmp111_ = self->priv->toolMove;
	g_signal_connect_object ((GtkToolButton*) _tmp111_, "clicked", (GCallback) ___lambda33__gtk_tool_button_clicked, self, 0);
	_tmp112_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/delete.png");
	g_object_ref_sink (_tmp112_);
	_g_object_unref0 (self->priv->toolDeleteImage);
	self->priv->toolDeleteImage = _tmp112_;
	_tmp113_ = self->priv->toolScroll;
	_tmp114_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp113_);
	g_object_ref_sink (_tmp114_);
	_g_object_unref0 (self->priv->toolDelete);
	self->priv->toolDelete = _tmp114_;
	_tmp115_ = self->priv->toolDelete;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp115_, "Delete");
	_tmp116_ = self->priv->toolDelete;
	_tmp117_ = self->priv->toolDeleteImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = self->priv->toolbar;
	_tmp119_ = self->priv->toolDelete;
	gtk_toolbar_insert (_tmp118_, (GtkToolItem*) _tmp119_, -1);
	_tmp120_ = self->priv->toolDelete;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp120_, "Delete: Click on a trace to delete it.");
	_tmp121_ = self->priv->toolDelete;
	g_signal_connect_object ((GtkToolButton*) _tmp121_, "clicked", (GCallback) ___lambda34__gtk_tool_button_clicked, self, 0);
	_tmp122_ = (GtkImage*) gtk_image_new_from_file (PACKAGE_DATADIR "images/toolbar/adjust.png");
	g_object_ref_sink (_tmp122_);
	_g_object_unref0 (self->priv->toolAdjustImage);
	self->priv->toolAdjustImage = _tmp122_;
	_tmp123_ = self->priv->toolScroll;
	_tmp124_ = (GtkRadioToolButton*) gtk_radio_tool_button_new_from_widget (_tmp123_);
	g_object_ref_sink (_tmp124_);
	_g_object_unref0 (self->priv->toolAdjust);
	self->priv->toolAdjust = _tmp124_;
	_tmp125_ = self->priv->toolAdjust;
	gtk_tool_button_set_label ((GtkToolButton*) _tmp125_, "Adjust");
	_tmp126_ = self->priv->toolAdjust;
	_tmp127_ = self->priv->toolAdjustImage;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) _tmp126_, (GtkWidget*) _tmp127_);
	_tmp128_ = self->priv->toolbar;
	_tmp129_ = self->priv->toolAdjust;
	gtk_toolbar_insert (_tmp128_, (GtkToolItem*) _tmp129_, -1);
	_tmp130_ = self->priv->toolAdjust;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp130_, "Adjust: Click on a trace to change its properties.");
	_tmp131_ = self->priv->toolAdjust;
	g_signal_connect_object ((GtkToolButton*) _tmp131_, "clicked", (GCallback) ___lambda35__gtk_tool_button_clicked, self, 0);
	_tmp132_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp132_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp132_;
	_tmp133_ = self->priv->vBox;
	_tmp134_ = self->priv->controller;
	gtk_box_pack_start (_tmp133_, (GtkWidget*) _tmp134_, TRUE, TRUE, (guint) 0);
	_tmp135_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp135_, "button-press-event", (GCallback) _timing_diagram_mouse_down_gtk_widget_button_press_event, self, 0);
	_tmp136_ = self->priv->controller;
	gtk_widget_set_events ((GtkWidget*) _tmp136_, (gint) GDK_POINTER_MOTION_MASK);
	_tmp137_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp137_, "motion-notify-event", (GCallback) _timing_diagram_mouse_move_gtk_widget_motion_notify_event, self, 0);
	_tmp138_ = self->priv->controller;
	g_signal_connect_object ((GtkWidget*) _tmp138_, "button-release-event", (GCallback) _timing_diagram_mouse_up_gtk_widget_button_release_event, self, 0);
	_tmp139_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp139_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp139_;
	_tmp140_ = self->priv->controller;
	_tmp141_ = self->priv->display;
	gtk_container_add ((GtkContainer*) _tmp140_, (GtkWidget*) _tmp141_);
	_tmp142_ = self->priv->display;
	g_signal_connect_object ((GtkWidget*) _tmp142_, "draw", (GCallback) ___lambda36__gtk_widget_draw, self, 0);
	_tmp143_ = self->priv->display;
	g_signal_connect_object ((GtkWidget*) _tmp143_, "configure-event", (GCallback) ___lambda37__gtk_widget_configure_event, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_hide ((GtkWidget*) self);
	timing_diagram_render (self, TRUE, NULL);
}


void timing_diagram_close_diagram (TimingDiagram* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}


gboolean timing_diagram_hide_diagram (TimingDiagram* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self);
	result = TRUE;
	return result;
}


void timing_diagram_show_diagram (TimingDiagram* self) {
	GtkCheckMenuItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_window_present ((GtkWindow*) self);
	_tmp0_ = self->priv->menuViewAlwaysontop;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp2_);
	timing_diagram_render (self, TRUE, NULL);
}


static gpointer _wire_state_ref0 (gpointer self) {
	return self ? wire_state_ref (self) : NULL;
}


static void _vala_array_add114 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add115 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add116 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void timing_diagram_add_wire (TimingDiagram* self, WireState* newWireState) {
	WireState** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	PropertySet* propertySet = NULL;
	PropertySet* _tmp4_ = NULL;
	PropertyItemString* labelProperty = NULL;
	PropertyItemString* _tmp5_ = NULL;
	PropertySet* _tmp6_ = NULL;
	PropertyItemString* _tmp7_ = NULL;
	PropertiesQuery* propertiesQuery = NULL;
	PropertySet* _tmp8_ = NULL;
	PropertiesQuery* _tmp9_ = NULL;
	PropertiesQuery* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp31_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (newWireState != NULL);
	_tmp0_ = self->priv->wireStates;
	_tmp0__length1 = self->priv->wireStates_length1;
	{
		WireState** wireState_collection = NULL;
		gint wireState_collection_length1 = 0;
		gint _wireState_collection_size_ = 0;
		gint wireState_it = 0;
		wireState_collection = _tmp0_;
		wireState_collection_length1 = _tmp0__length1;
		for (wireState_it = 0; wireState_it < _tmp0__length1; wireState_it = wireState_it + 1) {
			WireState* _tmp1_ = NULL;
			WireState* wireState = NULL;
			_tmp1_ = _wire_state_ref0 (wireState_collection[wireState_it]);
			wireState = _tmp1_;
			{
				WireState* _tmp2_ = NULL;
				WireState* _tmp3_ = NULL;
				_tmp2_ = wireState;
				_tmp3_ = newWireState;
				if (_tmp2_ == _tmp3_) {
					_wire_state_unref0 (wireState);
					return;
				}
				_wire_state_unref0 (wireState);
			}
		}
	}
	_tmp4_ = property_set_new ("Watch Wire", "Record this wire in the timing diagram.");
	propertySet = _tmp4_;
	_tmp5_ = property_item_string_new ("Label", "Display this text next to the graph.", "");
	labelProperty = _tmp5_;
	_tmp6_ = propertySet;
	_tmp7_ = labelProperty;
	property_set_add_item (_tmp6_, (PropertyItem*) _tmp7_);
	_tmp8_ = propertySet;
	_tmp9_ = properties_query_new ("Watch Wire", (GtkWindow*) self, _tmp8_);
	propertiesQuery = _tmp9_;
	gtk_window_set_keep_above ((GtkWindow*) self, FALSE);
	_tmp10_ = propertiesQuery;
	_tmp11_ = properties_query_run (_tmp10_);
	if (_tmp11_ == ((gint) GTK_RESPONSE_APPLY)) {
		gchar* label = NULL;
		PropertyItemString* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		WireState** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		WireState* _tmp16_ = NULL;
		WireState* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		WireState* _tmp27_ = NULL;
		CompiledCircuit* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp12_ = labelProperty;
		_tmp13_ = _tmp12_->data;
		_tmp14_ = g_strdup (_tmp13_);
		label = _tmp14_;
		_tmp15_ = self->priv->wireStates;
		_tmp15__length1 = self->priv->wireStates_length1;
		_tmp16_ = newWireState;
		_tmp17_ = _wire_state_ref0 (_tmp16_);
		_vala_array_add114 (&self->priv->wireStates, &self->priv->wireStates_length1, &self->priv->_wireStates_size_, _tmp17_);
		_tmp18_ = label;
		if (g_strcmp0 (_tmp18_, "") == 0) {
			gchar** _tmp19_ = NULL;
			gint _tmp19__length1 = 0;
			WireState** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp19_ = self->priv->labels;
			_tmp19__length1 = self->priv->labels_length1;
			_tmp20_ = self->priv->wireStates;
			_tmp20__length1 = self->priv->wireStates_length1;
			_tmp21_ = g_strdup_printf ("%i", _tmp20__length1);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat ("Wire ", _tmp22_, NULL);
			_vala_array_add115 (&self->priv->labels, &self->priv->labels_length1, &self->priv->_labels_size_, _tmp23_);
			_g_free0 (_tmp22_);
		} else {
			gchar** _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			_tmp24_ = self->priv->labels;
			_tmp24__length1 = self->priv->labels_length1;
			_tmp25_ = label;
			_tmp26_ = g_strdup (_tmp25_);
			_vala_array_add116 (&self->priv->labels, &self->priv->labels_length1, &self->priv->_labels_size_, _tmp26_);
		}
		_tmp27_ = newWireState;
		_tmp28_ = self->priv->compiledCircuit;
		_tmp29_ = _tmp28_->iterationCount;
		_tmp30_ = self->priv->iterationCountOffset;
		wire_state_start_recording (_tmp27_, _tmp29_ - _tmp30_);
		_cairo_surface_destroy0 (self->priv->diagramCache);
		self->priv->diagramCache = NULL;
		timing_diagram_render (self, TRUE, NULL);
		_g_free0 (label);
	}
	_tmp31_ = self->alwaysOnTop;
	gtk_window_set_keep_above ((GtkWindow*) self, _tmp31_);
	_properties_query_unref0 (propertiesQuery);
	_property_item_unref0 (labelProperty);
	_property_item_unref0 (propertySet);
}


static void _vala_array_add117 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add118 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireState** _vala_array_dup94 (WireState** self, int length) {
	WireState** result;
	int i;
	result = g_new0 (WireState*, length + 1);
	for (i = 0; i < length; i++) {
		WireState* _tmp0_ = NULL;
		_tmp0_ = _wire_state_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup95 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void timing_diagram_forget_wire (TimingDiagram* self, gint wireNumber) {
	WireState** newWireStates = NULL;
	WireState** _tmp0_ = NULL;
	gint newWireStates_length1 = 0;
	gint _newWireStates_size_ = 0;
	gchar** newLabels = NULL;
	gchar** _tmp1_ = NULL;
	gint newLabels_length1 = 0;
	gint _newLabels_size_ = 0;
	WireState** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	WireState** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (WireState*, 0 + 1);
	newWireStates = _tmp0_;
	newWireStates_length1 = 0;
	_newWireStates_size_ = newWireStates_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	newLabels = _tmp1_;
	newLabels_length1 = 0;
	_newLabels_size_ = newLabels_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				WireState** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->wireStates;
				_tmp5__length1 = self->priv->wireStates_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = wireNumber;
				if (_tmp6_ != _tmp7_) {
					WireState** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					WireState** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					WireState* _tmp11_ = NULL;
					WireState* _tmp12_ = NULL;
					gchar** _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gchar** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					_tmp8_ = newWireStates;
					_tmp8__length1 = newWireStates_length1;
					_tmp9_ = self->priv->wireStates;
					_tmp9__length1 = self->priv->wireStates_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = _wire_state_ref0 (_tmp11_);
					_vala_array_add117 (&newWireStates, &newWireStates_length1, &_newWireStates_size_, _tmp12_);
					_tmp13_ = newLabels;
					_tmp13__length1 = newLabels_length1;
					_tmp14_ = self->priv->labels;
					_tmp14__length1 = self->priv->labels_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = g_strdup (_tmp16_);
					_vala_array_add118 (&newLabels, &newLabels_length1, &_newLabels_size_, _tmp17_);
				} else {
					WireState** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp19_ = 0;
					WireState* _tmp20_ = NULL;
					_tmp18_ = self->priv->wireStates;
					_tmp18__length1 = self->priv->wireStates_length1;
					_tmp19_ = i;
					_tmp20_ = _tmp18_[_tmp19_];
					wire_state_stop_recording (_tmp20_);
				}
			}
		}
	}
	_tmp21_ = newWireStates;
	_tmp21__length1 = newWireStates_length1;
	_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup94 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
	_tmp22__length1 = _tmp21__length1;
	self->priv->wireStates = (_vala_array_free (self->priv->wireStates, self->priv->wireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	self->priv->wireStates = _tmp22_;
	self->priv->wireStates_length1 = _tmp22__length1;
	self->priv->_wireStates_size_ = self->priv->wireStates_length1;
	_tmp23_ = newLabels;
	_tmp23__length1 = newLabels_length1;
	_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup95 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
	_tmp24__length1 = _tmp23__length1;
	self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_free), NULL);
	self->priv->labels = _tmp24_;
	self->priv->labels_length1 = _tmp24__length1;
	self->priv->_labels_size_ = self->priv->labels_length1;
	newLabels = (_vala_array_free (newLabels, newLabels_length1, (GDestroyNotify) g_free), NULL);
	newWireStates = (_vala_array_free (newWireStates, newWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
}


static void _vala_array_add119 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add120 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add121 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add122 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add123 (WireState*** array, int* length, int* size, WireState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add124 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static WireState** _vala_array_dup96 (WireState** self, int length) {
	WireState** result;
	int i;
	result = g_new0 (WireState*, length + 1);
	for (i = 0; i < length; i++) {
		WireState* _tmp0_ = NULL;
		_tmp0_ = _wire_state_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup97 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void timing_diagram_move_wire (TimingDiagram* self, gint fromNumber, gint toNumber) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp3_ = fromNumber;
	if (0 <= _tmp3_) {
		gint _tmp4_ = 0;
		WireState** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp4_ = fromNumber;
		_tmp5_ = self->priv->wireStates;
		_tmp5__length1 = self->priv->wireStates_length1;
		_tmp2_ = _tmp4_ < _tmp5__length1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp6_ = 0;
		_tmp6_ = toNumber;
		_tmp1_ = 0 <= _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp7_ = 0;
		WireState** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		_tmp7_ = toNumber;
		_tmp8_ = self->priv->wireStates;
		_tmp8__length1 = self->priv->wireStates_length1;
		_tmp0_ = _tmp7_ < _tmp8__length1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		WireState** newWireStates = NULL;
		WireState** _tmp9_ = NULL;
		gint newWireStates_length1 = 0;
		gint _newWireStates_size_ = 0;
		gchar** newLabels = NULL;
		gchar** _tmp10_ = NULL;
		gint newLabels_length1 = 0;
		gint _newLabels_size_ = 0;
		WireState* movingWire = NULL;
		WireState** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp12_ = 0;
		WireState* _tmp13_ = NULL;
		WireState* _tmp14_ = NULL;
		gchar* movingLabel = NULL;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gint _tmp16_ = 0;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gint insertCount = 0;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		WireState** _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		WireState** _tmp55_ = NULL;
		gint _tmp55__length1 = 0;
		gchar** _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		gchar** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		_tmp9_ = g_new0 (WireState*, 0 + 1);
		newWireStates = _tmp9_;
		newWireStates_length1 = 0;
		_newWireStates_size_ = newWireStates_length1;
		_tmp10_ = g_new0 (gchar*, 0 + 1);
		newLabels = _tmp10_;
		newLabels_length1 = 0;
		_newLabels_size_ = newLabels_length1;
		_tmp11_ = self->priv->wireStates;
		_tmp11__length1 = self->priv->wireStates_length1;
		_tmp12_ = fromNumber;
		_tmp13_ = _tmp11_[_tmp12_];
		_tmp14_ = _wire_state_ref0 (_tmp13_);
		movingWire = _tmp14_;
		_tmp15_ = self->priv->labels;
		_tmp15__length1 = self->priv->labels_length1;
		_tmp16_ = fromNumber;
		_tmp17_ = _tmp15_[_tmp16_];
		_tmp18_ = g_strdup (_tmp17_);
		movingLabel = _tmp18_;
		insertCount = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					gint _tmp21_ = 0;
					WireState** _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					if (!_tmp19_) {
						gint _tmp20_ = 0;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = self->priv->wireStates;
					_tmp22__length1 = self->priv->wireStates_length1;
					if (!(_tmp21_ < _tmp22__length1)) {
						break;
					}
					_tmp23_ = insertCount;
					_tmp24_ = toNumber;
					if (_tmp23_ == _tmp24_) {
						WireState** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						WireState* _tmp26_ = NULL;
						WireState* _tmp27_ = NULL;
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						_tmp25_ = newWireStates;
						_tmp25__length1 = newWireStates_length1;
						_tmp26_ = movingWire;
						_tmp27_ = _wire_state_ref0 (_tmp26_);
						_vala_array_add119 (&newWireStates, &newWireStates_length1, &_newWireStates_size_, _tmp27_);
						_tmp28_ = newLabels;
						_tmp28__length1 = newLabels_length1;
						_tmp29_ = movingLabel;
						_tmp30_ = g_strdup (_tmp29_);
						_vala_array_add120 (&newLabels, &newLabels_length1, &_newLabels_size_, _tmp30_);
						_tmp31_ = insertCount;
						insertCount = _tmp31_ + 1;
					}
					_tmp32_ = i;
					_tmp33_ = fromNumber;
					if (_tmp32_ != _tmp33_) {
						WireState** _tmp34_ = NULL;
						gint _tmp34__length1 = 0;
						WireState** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp36_ = 0;
						WireState* _tmp37_ = NULL;
						WireState* _tmp38_ = NULL;
						gchar** _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						gchar** _tmp40_ = NULL;
						gint _tmp40__length1 = 0;
						gint _tmp41_ = 0;
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						_tmp34_ = newWireStates;
						_tmp34__length1 = newWireStates_length1;
						_tmp35_ = self->priv->wireStates;
						_tmp35__length1 = self->priv->wireStates_length1;
						_tmp36_ = i;
						_tmp37_ = _tmp35_[_tmp36_];
						_tmp38_ = _wire_state_ref0 (_tmp37_);
						_vala_array_add121 (&newWireStates, &newWireStates_length1, &_newWireStates_size_, _tmp38_);
						_tmp39_ = newLabels;
						_tmp39__length1 = newLabels_length1;
						_tmp40_ = self->priv->labels;
						_tmp40__length1 = self->priv->labels_length1;
						_tmp41_ = i;
						_tmp42_ = _tmp40_[_tmp41_];
						_tmp43_ = g_strdup (_tmp42_);
						_vala_array_add122 (&newLabels, &newLabels_length1, &_newLabels_size_, _tmp43_);
						_tmp44_ = insertCount;
						insertCount = _tmp44_ + 1;
					}
				}
			}
		}
		_tmp45_ = insertCount;
		_tmp46_ = toNumber;
		if (_tmp45_ == _tmp46_) {
			WireState** _tmp47_ = NULL;
			gint _tmp47__length1 = 0;
			WireState* _tmp48_ = NULL;
			WireState* _tmp49_ = NULL;
			gchar** _tmp50_ = NULL;
			gint _tmp50__length1 = 0;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			_tmp47_ = newWireStates;
			_tmp47__length1 = newWireStates_length1;
			_tmp48_ = movingWire;
			_tmp49_ = _wire_state_ref0 (_tmp48_);
			_vala_array_add123 (&newWireStates, &newWireStates_length1, &_newWireStates_size_, _tmp49_);
			_tmp50_ = newLabels;
			_tmp50__length1 = newLabels_length1;
			_tmp51_ = movingLabel;
			_tmp52_ = g_strdup (_tmp51_);
			_vala_array_add124 (&newLabels, &newLabels_length1, &_newLabels_size_, _tmp52_);
			_tmp53_ = insertCount;
			insertCount = _tmp53_ + 1;
		}
		_tmp54_ = newWireStates;
		_tmp54__length1 = newWireStates_length1;
		_tmp55_ = (_tmp54_ != NULL) ? _vala_array_dup96 (_tmp54_, _tmp54__length1) : ((gpointer) _tmp54_);
		_tmp55__length1 = _tmp54__length1;
		self->priv->wireStates = (_vala_array_free (self->priv->wireStates, self->priv->wireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
		self->priv->wireStates = _tmp55_;
		self->priv->wireStates_length1 = _tmp55__length1;
		self->priv->_wireStates_size_ = self->priv->wireStates_length1;
		_tmp56_ = newLabels;
		_tmp56__length1 = newLabels_length1;
		_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup97 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
		_tmp57__length1 = _tmp56__length1;
		self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_free), NULL);
		self->priv->labels = _tmp57_;
		self->priv->labels_length1 = _tmp57__length1;
		self->priv->_labels_size_ = self->priv->labels_length1;
		_g_free0 (movingLabel);
		_wire_state_unref0 (movingWire);
		newLabels = (_vala_array_free (newLabels, newLabels_length1, (GDestroyNotify) g_free), NULL);
		newWireStates = (_vala_array_free (newWireStates, newWireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	}
}


static void timing_diagram_adjust_wire (TimingDiagram* self, gint wireNumber) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = wireNumber;
	if (0 <= _tmp1_) {
		gint _tmp2_ = 0;
		WireState** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = wireNumber;
		_tmp3_ = self->priv->wireStates;
		_tmp3__length1 = self->priv->wireStates_length1;
		_tmp0_ = _tmp2_ < _tmp3__length1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PropertySet* propertySet = NULL;
		PropertySet* _tmp4_ = NULL;
		PropertyItemString* labelProperty = NULL;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		PropertyItemString* _tmp8_ = NULL;
		PropertySet* _tmp9_ = NULL;
		PropertyItemString* _tmp10_ = NULL;
		PropertiesQuery* propertiesQuery = NULL;
		PropertySet* _tmp11_ = NULL;
		PropertiesQuery* _tmp12_ = NULL;
		PropertiesQuery* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gboolean _tmp31_ = FALSE;
		_tmp4_ = property_set_new ("Watch Wire", "Record this wire in the timing diagram.");
		propertySet = _tmp4_;
		_tmp5_ = self->priv->labels;
		_tmp5__length1 = self->priv->labels_length1;
		_tmp6_ = wireNumber;
		_tmp7_ = _tmp5_[_tmp6_];
		_tmp8_ = property_item_string_new ("Label", "Display this text next to the graph.", _tmp7_);
		labelProperty = _tmp8_;
		_tmp9_ = propertySet;
		_tmp10_ = labelProperty;
		property_set_add_item (_tmp9_, (PropertyItem*) _tmp10_);
		_tmp11_ = propertySet;
		_tmp12_ = properties_query_new ("Watch Wire", (GtkWindow*) self, _tmp11_);
		propertiesQuery = _tmp12_;
		gtk_window_set_keep_above ((GtkWindow*) self, FALSE);
		_tmp13_ = propertiesQuery;
		_tmp14_ = properties_query_run (_tmp13_);
		if (_tmp14_ == ((gint) GTK_RESPONSE_APPLY)) {
			gchar* label = NULL;
			PropertyItemString* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			_tmp15_ = labelProperty;
			_tmp16_ = _tmp15_->data;
			_tmp17_ = g_strdup (_tmp16_);
			label = _tmp17_;
			_tmp18_ = label;
			if (g_strcmp0 (_tmp18_, "") == 0) {
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				_tmp19_ = self->priv->labels;
				_tmp19__length1 = self->priv->labels_length1;
				_tmp20_ = wireNumber;
				_tmp21_ = wireNumber;
				_tmp22_ = g_strdup_printf ("%i", _tmp21_ + 1);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat ("Wire ", _tmp23_, NULL);
				_g_free0 (_tmp19_[_tmp20_]);
				_tmp19_[_tmp20_] = _tmp24_;
				_tmp25_ = _tmp19_[_tmp20_];
				_g_free0 (_tmp23_);
			} else {
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				const gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				_tmp26_ = self->priv->labels;
				_tmp26__length1 = self->priv->labels_length1;
				_tmp27_ = wireNumber;
				_tmp28_ = label;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_tmp26_[_tmp27_]);
				_tmp26_[_tmp27_] = _tmp29_;
				_tmp30_ = _tmp26_[_tmp27_];
			}
			_cairo_surface_destroy0 (self->priv->diagramCache);
			self->priv->diagramCache = NULL;
			timing_diagram_render (self, TRUE, NULL);
			_g_free0 (label);
		}
		_tmp31_ = self->alwaysOnTop;
		gtk_window_set_keep_above ((GtkWindow*) self, _tmp31_);
		_properties_query_unref0 (propertiesQuery);
		_property_item_unref0 (labelProperty);
		_property_item_unref0 (propertySet);
	}
}


void timing_diagram_reset_timings (TimingDiagram* self) {
	WireState** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	CompiledCircuit* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wireStates;
	_tmp0__length1 = self->priv->wireStates_length1;
	{
		WireState** wireState_collection = NULL;
		gint wireState_collection_length1 = 0;
		gint _wireState_collection_size_ = 0;
		gint wireState_it = 0;
		wireState_collection = _tmp0_;
		wireState_collection_length1 = _tmp0__length1;
		for (wireState_it = 0; wireState_it < _tmp0__length1; wireState_it = wireState_it + 1) {
			WireState* _tmp1_ = NULL;
			WireState* wireState = NULL;
			_tmp1_ = _wire_state_ref0 (wireState_collection[wireState_it]);
			wireState = _tmp1_;
			{
				WireState* _tmp2_ = NULL;
				_tmp2_ = wireState;
				wire_state_start_recording (_tmp2_, 0);
				_wire_state_unref0 (wireState);
			}
		}
	}
	self->priv->xView = 0;
	_tmp3_ = self->priv->compiledCircuit;
	_tmp4_ = _tmp3_->iterationCount;
	self->priv->iterationCountOffset = _tmp4_;
	_cairo_surface_destroy0 (self->priv->diagramCache);
	self->priv->diagramCache = NULL;
	timing_diagram_render (self, TRUE, NULL);
}


void timing_diagram_reset_view (TimingDiagram* self) {
	g_return_if_fail (self != NULL);
	self->priv->xView = 0;
	self->priv->yView = 0;
	self->priv->xZoom = (gfloat) 1;
	self->priv->yZoom = (gfloat) 25;
	_cairo_surface_destroy0 (self->priv->diagramCache);
	self->priv->diagramCache = NULL;
	timing_diagram_render (self, TRUE, NULL);
}


/**
 * Handles mouse button down in the work area. Records mouse
 * (drag) starting point.
 */
static gboolean timing_diagram_mouse_down (TimingDiagram* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->x;
	self->priv->xMouseStart = (gint) _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->y;
	self->priv->yMouseStart = (gint) _tmp3_;
	result = FALSE;
	return result;
}


static gboolean timing_diagram_mouse_move (TimingDiagram* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventMotion* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_events_pending ();
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->x;
	self->priv->barPosition = _tmp2_;
	timing_diagram_render (self, FALSE, NULL);
	result = FALSE;
	return result;
}


/**
 * Handles mouse button up in the work area. Performs an action
 * which is determined by //mouseMode//.
 */
static gboolean timing_diagram_mouse_up (TimingDiagram* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkAllocation areaAllocation = {0};
	GtkEventBox* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint height = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint xStart = 0;
	gint _tmp6_ = 0;
	gint yStart = 0;
	gint _tmp7_ = 0;
	gint xEnd = 0;
	GdkEventButton* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gint yEnd = 0;
	GdkEventButton* _tmp10_ = NULL;
	gdouble _tmp11_ = 0.0;
	gint xDiff = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint yDiff = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint wireStart = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp19_ = 0.0F;
	gint wireEnd = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint xDiffAbs = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint yDiffAbs = 0;
	TimingDiagramMouseMode _tmp32_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->controller;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	areaAllocation = _tmp1_;
	_tmp2_ = areaAllocation;
	_tmp3_ = _tmp2_.width;
	width = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.height;
	height = _tmp5_;
	_tmp6_ = self->priv->xMouseStart;
	xStart = _tmp6_;
	_tmp7_ = self->priv->yMouseStart;
	yStart = _tmp7_ - 20;
	_tmp8_ = event;
	_tmp9_ = _tmp8_->x;
	xEnd = (gint) _tmp9_;
	_tmp10_ = event;
	_tmp11_ = _tmp10_->y;
	yEnd = ((gint) _tmp11_) - 20;
	_tmp12_ = xEnd;
	_tmp13_ = xStart;
	xDiff = _tmp12_ - _tmp13_;
	_tmp14_ = yEnd;
	_tmp15_ = yStart;
	yDiff = _tmp14_ - _tmp15_;
	_tmp16_ = yStart;
	_tmp17_ = self->priv->yView;
	_tmp18_ = self->priv->yZoom;
	_tmp19_ = floorf ((gfloat) (((gfloat) (_tmp16_ + _tmp17_)) / (_tmp18_ * 2.4)));
	wireStart = (gint) _tmp19_;
	_tmp20_ = yEnd;
	_tmp21_ = self->priv->yView;
	_tmp22_ = self->priv->yZoom;
	_tmp23_ = floorf ((gfloat) (((gfloat) (_tmp20_ + _tmp21_)) / (_tmp22_ * 2.4)));
	wireEnd = (gint) _tmp23_;
	_tmp25_ = xDiff;
	if (_tmp25_ > 0) {
		gint _tmp26_ = 0;
		_tmp26_ = xDiff;
		_tmp24_ = _tmp26_;
	} else {
		gint _tmp27_ = 0;
		_tmp27_ = xDiff;
		_tmp24_ = -_tmp27_;
	}
	xDiffAbs = _tmp24_;
	_tmp29_ = yDiff;
	if (_tmp29_ > 0) {
		gint _tmp30_ = 0;
		_tmp30_ = yDiff;
		_tmp28_ = _tmp30_;
	} else {
		gint _tmp31_ = 0;
		_tmp31_ = yDiff;
		_tmp28_ = -_tmp31_;
	}
	yDiffAbs = _tmp28_;
	_tmp32_ = self->priv->mouseMode;
	switch (_tmp32_) {
		case TIMING_DIAGRAM_MOUSE_MODE_SCROLL:
		{
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gfloat _tmp35_ = 0.0F;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			_tmp33_ = self->priv->xView;
			_tmp34_ = xDiff;
			_tmp35_ = self->priv->xZoom;
			self->priv->xView = _tmp33_ - ((gint) (((gfloat) _tmp34_) / _tmp35_));
			_tmp36_ = self->priv->yView;
			_tmp37_ = yDiff;
			self->priv->yView = _tmp36_ - _tmp37_;
			break;
		}
		case TIMING_DIAGRAM_MOUSE_MODE_ZOOM:
		{
			gint _tmp38_ = 0;
			gint _tmp45_ = 0;
			_tmp38_ = xDiff;
			if (_tmp38_ > 0) {
				gfloat _tmp39_ = 0.0F;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				_tmp39_ = self->priv->xZoom;
				_tmp40_ = xDiffAbs;
				_tmp41_ = width;
				self->priv->xZoom = _tmp39_ * (1.0f + (((gfloat) _tmp40_) / ((gfloat) _tmp41_)));
			} else {
				gfloat _tmp42_ = 0.0F;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				_tmp42_ = self->priv->xZoom;
				_tmp43_ = xDiffAbs;
				_tmp44_ = width;
				self->priv->xZoom = _tmp42_ / (1.0f + (((gfloat) _tmp43_) / ((gfloat) _tmp44_)));
			}
			_tmp45_ = yDiff;
			if (_tmp45_ > 0) {
				gfloat _tmp46_ = 0.0F;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				_tmp46_ = self->priv->yZoom;
				_tmp47_ = yDiffAbs;
				_tmp48_ = height;
				self->priv->yZoom = _tmp46_ * (1.0f + (((gfloat) _tmp47_) / ((gfloat) _tmp48_)));
			} else {
				gfloat _tmp49_ = 0.0F;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				_tmp49_ = self->priv->yZoom;
				_tmp50_ = yDiffAbs;
				_tmp51_ = height;
				self->priv->yZoom = _tmp49_ / (1.0f + (((gfloat) _tmp50_) / ((gfloat) _tmp51_)));
			}
			break;
		}
		case TIMING_DIAGRAM_MOUSE_MODE_MOVE:
		{
			gint _tmp52_ = 0;
			gint _tmp53_ = 0;
			_tmp52_ = wireStart;
			_tmp53_ = wireEnd;
			timing_diagram_move_wire (self, _tmp52_, _tmp53_);
			break;
		}
		case TIMING_DIAGRAM_MOUSE_MODE_DELETE:
		{
			gint _tmp54_ = 0;
			_tmp54_ = wireEnd;
			timing_diagram_forget_wire (self, _tmp54_);
			break;
		}
		case TIMING_DIAGRAM_MOUSE_MODE_ADJUST:
		{
			gint _tmp55_ = 0;
			_tmp55_ = wireEnd;
			timing_diagram_adjust_wire (self, _tmp55_);
			break;
		}
		default:
		break;
	}
	_cairo_surface_destroy0 (self->priv->diagramCache);
	self->priv->diagramCache = NULL;
	timing_diagram_render (self, TRUE, NULL);
	result = FALSE;
	return result;
}


gint timing_diagram_text_length (TimingDiagram* self) {
	gint result = 0;
	gint largestLength = 0;
	cairo_text_extents_t textExtents = {0};
	cairo_surface_t* imageSurface = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	largestLength = 0;
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 0, 0);
	imageSurface = _tmp0_;
	_tmp1_ = imageSurface;
	_tmp2_ = cairo_create (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	cairo_set_font_size (_tmp3_, (gdouble) 16);
	_tmp4_ = self->priv->labels;
	_tmp4__length1 = self->priv->labels_length1;
	{
		gchar** label_collection = NULL;
		gint label_collection_length1 = 0;
		gint _label_collection_size_ = 0;
		gint label_it = 0;
		label_collection = _tmp4_;
		label_collection_length1 = _tmp4__length1;
		for (label_it = 0; label_it < _tmp4__length1; label_it = label_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* label = NULL;
			_tmp5_ = g_strdup (label_collection[label_it]);
			label = _tmp5_;
			{
				cairo_t* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				cairo_text_extents_t _tmp8_ = {0};
				gint _tmp9_ = 0;
				cairo_text_extents_t _tmp10_ = {0};
				gdouble _tmp11_ = 0.0;
				_tmp6_ = context;
				_tmp7_ = label;
				cairo_text_extents (_tmp6_, _tmp7_, &_tmp8_);
				textExtents = _tmp8_;
				_tmp9_ = largestLength;
				_tmp10_ = textExtents;
				_tmp11_ = _tmp10_.width;
				if (_tmp9_ < ((gint) _tmp11_)) {
					cairo_text_extents_t _tmp12_ = {0};
					gdouble _tmp13_ = 0.0;
					_tmp12_ = textExtents;
					_tmp13_ = _tmp12_.width;
					largestLength = (gint) _tmp13_;
				}
				_g_free0 (label);
			}
		}
	}
	result = largestLength;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (imageSurface);
	return result;
}


void timing_diagram_render_labels (TimingDiagram* self, cairo_t* context, gboolean fullRender, gint width, gint* largestLength) {
	gint _vala_largestLength = 0;
	cairo_matrix_t oldMatrix = {0};
	cairo_text_extents_t textExtents = {0};
	cairo_t* _tmp0_ = NULL;
	cairo_matrix_t _tmp1_ = {0};
	cairo_t* _tmp2_ = NULL;
	gfloat _tmp3_ = 0.0F;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	cairo_t* _tmp30_ = NULL;
	cairo_matrix_t _tmp31_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_vala_largestLength = 0;
	_tmp0_ = context;
	cairo_get_matrix (_tmp0_, &_tmp1_);
	oldMatrix = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = self->priv->yZoom;
	_tmp4_ = self->priv->yView;
	cairo_translate (_tmp2_, (gdouble) 10, ((_tmp3_ * 1.2) - _tmp4_) + 20);
	_tmp5_ = self->priv->labels;
	_tmp5__length1 = self->priv->labels_length1;
	{
		gchar** label_collection = NULL;
		gint label_collection_length1 = 0;
		gint _label_collection_size_ = 0;
		gint label_it = 0;
		label_collection = _tmp5_;
		label_collection_length1 = _tmp5__length1;
		for (label_it = 0; label_it < _tmp5__length1; label_it = label_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* label = NULL;
			_tmp6_ = g_strdup (label_collection[label_it]);
			label = _tmp6_;
			{
				cairo_t* _tmp7_ = NULL;
				cairo_t* _tmp8_ = NULL;
				cairo_t* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				cairo_text_extents_t _tmp11_ = {0};
				gint _tmp12_ = 0;
				cairo_text_extents_t _tmp13_ = {0};
				gdouble _tmp14_ = 0.0;
				gboolean _tmp17_ = FALSE;
				_tmp7_ = context;
				cairo_set_source_rgb (_tmp7_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
				_tmp8_ = context;
				cairo_set_font_size (_tmp8_, (gdouble) 16);
				_tmp9_ = context;
				_tmp10_ = label;
				cairo_text_extents (_tmp9_, _tmp10_, &_tmp11_);
				textExtents = _tmp11_;
				_tmp12_ = _vala_largestLength;
				_tmp13_ = textExtents;
				_tmp14_ = _tmp13_.width;
				if (_tmp12_ < ((gint) _tmp14_)) {
					cairo_text_extents_t _tmp15_ = {0};
					gdouble _tmp16_ = 0.0;
					_tmp15_ = textExtents;
					_tmp16_ = _tmp15_.width;
					_vala_largestLength = (gint) _tmp16_;
				}
				_tmp17_ = fullRender;
				if (_tmp17_) {
					cairo_t* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					cairo_t* _tmp20_ = NULL;
					cairo_t* _tmp21_ = NULL;
					cairo_t* _tmp22_ = NULL;
					gfloat _tmp23_ = 0.0F;
					cairo_t* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gfloat _tmp26_ = 0.0F;
					cairo_t* _tmp27_ = NULL;
					cairo_t* _tmp28_ = NULL;
					gfloat _tmp29_ = 0.0F;
					_tmp18_ = context;
					_tmp19_ = label;
					cairo_show_text (_tmp18_, _tmp19_);
					_tmp20_ = context;
					cairo_stroke (_tmp20_);
					_tmp21_ = context;
					cairo_set_source_rgba (_tmp21_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
					_tmp22_ = context;
					_tmp23_ = self->priv->yZoom;
					cairo_move_to (_tmp22_, (gdouble) (-10), (-_tmp23_) * 1.2);
					_tmp24_ = context;
					_tmp25_ = width;
					_tmp26_ = self->priv->yZoom;
					cairo_line_to (_tmp24_, (gdouble) _tmp25_, (-_tmp26_) * 1.2);
					_tmp27_ = context;
					cairo_stroke (_tmp27_);
					_tmp28_ = context;
					_tmp29_ = self->priv->yZoom;
					cairo_translate (_tmp28_, (gdouble) 0, _tmp29_ * 2.4);
				}
				_g_free0 (label);
			}
		}
	}
	_tmp30_ = context;
	_tmp31_ = oldMatrix;
	cairo_set_matrix (_tmp30_, &_tmp31_);
	if (largestLength) {
		*largestLength = _vala_largestLength;
	}
}


void timing_diagram_render_graphs (TimingDiagram* self, cairo_t* context, gboolean fullRender, gint width, gint largestLength) {
	cairo_matrix_t oldMatrix = {0};
	cairo_t* _tmp0_ = NULL;
	cairo_matrix_t _tmp1_ = {0};
	cairo_t* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	gint _tmp7_ = 0;
	gint xLimit = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gfloat _tmp11_ = 0.0F;
	WireState** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	cairo_t* _tmp22_ = NULL;
	cairo_matrix_t _tmp23_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	cairo_get_matrix (_tmp0_, &_tmp1_);
	oldMatrix = _tmp1_;
	_tmp2_ = context;
	_tmp3_ = largestLength;
	_tmp4_ = self->priv->xView;
	_tmp5_ = self->priv->xZoom;
	_tmp6_ = self->priv->yZoom;
	_tmp7_ = self->priv->yView;
	cairo_translate (_tmp2_, (gdouble) ((_tmp3_ + 20) - (((gfloat) _tmp4_) * _tmp5_)), ((_tmp6_ * 1.2) - _tmp7_) + 20);
	_tmp8_ = width;
	_tmp9_ = largestLength;
	_tmp10_ = self->priv->xView;
	_tmp11_ = self->priv->xZoom;
	xLimit = (gint) (((gfloat) ((_tmp8_ - (_tmp9_ + 20)) + _tmp10_)) / _tmp11_);
	_tmp12_ = self->priv->wireStates;
	_tmp12__length1 = self->priv->wireStates_length1;
	{
		WireState** wireState_collection = NULL;
		gint wireState_collection_length1 = 0;
		gint _wireState_collection_size_ = 0;
		gint wireState_it = 0;
		wireState_collection = _tmp12_;
		wireState_collection_length1 = _tmp12__length1;
		for (wireState_it = 0; wireState_it < _tmp12__length1; wireState_it = wireState_it + 1) {
			WireState* _tmp13_ = NULL;
			WireState* wireState = NULL;
			_tmp13_ = _wire_state_ref0 (wireState_collection[wireState_it]);
			wireState = _tmp13_;
			{
				WireState* _tmp14_ = NULL;
				cairo_t* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gfloat _tmp18_ = 0.0F;
				gfloat _tmp19_ = 0.0F;
				cairo_t* _tmp20_ = NULL;
				gfloat _tmp21_ = 0.0F;
				_tmp14_ = wireState;
				_tmp15_ = context;
				_tmp16_ = self->priv->xView;
				_tmp17_ = xLimit;
				_tmp18_ = self->priv->yZoom;
				_tmp19_ = self->priv->xZoom;
				wire_state_render_history (_tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
				_tmp20_ = context;
				_tmp21_ = self->priv->yZoom;
				cairo_translate (_tmp20_, (gdouble) 0, _tmp21_ * 2.4);
				_wire_state_unref0 (wireState);
			}
		}
	}
	_tmp22_ = context;
	_tmp23_ = oldMatrix;
	cairo_set_matrix (_tmp22_, &_tmp23_);
}


void timing_diagram_render_ruler (TimingDiagram* self, cairo_t* context, gboolean fullRender, gint width, gint height, gint largestLength) {
	gfloat xLabel = 0.0F;
	gint labelValue = 0;
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	cairo_t* _tmp3_ = NULL;
	cairo_t* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	cairo_set_source_rgb (_tmp0_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp1_ = context;
	_tmp2_ = width;
	cairo_rectangle (_tmp1_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp2_, (gdouble) 20);
	_tmp3_ = context;
	cairo_fill (_tmp3_);
	_tmp4_ = context;
	cairo_stroke (_tmp4_);
	_tmp5_ = self->priv->xView;
	if (_tmp5_ < 0) {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gfloat _tmp8_ = 0.0F;
		_tmp6_ = largestLength;
		_tmp7_ = self->priv->xView;
		_tmp8_ = self->priv->xZoom;
		xLabel = (_tmp6_ + 20) - (((gfloat) _tmp7_) * _tmp8_);
		labelValue = 0;
	} else {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gfloat _tmp11_ = 0.0F;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp9_ = largestLength;
		_tmp10_ = self->priv->xView;
		_tmp11_ = self->priv->xZoom;
		xLabel = (_tmp9_ + 20) - (((gfloat) (_tmp10_ % 50)) * _tmp11_);
		_tmp12_ = self->priv->xView;
		_tmp13_ = self->priv->xView;
		labelValue = _tmp12_ - (_tmp13_ % 50);
	}
	{
		gboolean _tmp14_ = FALSE;
		_tmp14_ = TRUE;
		while (TRUE) {
			gfloat _tmp18_ = 0.0F;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			if (!_tmp14_) {
				gfloat _tmp15_ = 0.0F;
				gfloat _tmp16_ = 0.0F;
				gint _tmp17_ = 0;
				_tmp15_ = xLabel;
				_tmp16_ = self->priv->xZoom;
				xLabel = _tmp15_ + (5 * _tmp16_);
				_tmp17_ = labelValue;
				labelValue = _tmp17_ + 5;
			}
			_tmp14_ = FALSE;
			_tmp18_ = xLabel;
			_tmp19_ = width;
			if (!(_tmp18_ < ((gfloat) _tmp19_))) {
				break;
			}
			_tmp20_ = labelValue;
			if ((_tmp20_ % 50) == 0) {
				cairo_t* _tmp21_ = NULL;
				cairo_t* _tmp22_ = NULL;
				gfloat _tmp23_ = 0.0F;
				cairo_t* _tmp24_ = NULL;
				gfloat _tmp25_ = 0.0F;
				cairo_t* _tmp26_ = NULL;
				cairo_t* _tmp27_ = NULL;
				gfloat _tmp28_ = 0.0F;
				cairo_t* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				cairo_t* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				gboolean _tmp36_ = FALSE;
				_tmp21_ = context;
				cairo_set_source_rgba (_tmp21_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
				_tmp22_ = context;
				_tmp23_ = xLabel;
				cairo_move_to (_tmp22_, (gdouble) _tmp23_, (gdouble) 0);
				_tmp24_ = context;
				_tmp25_ = xLabel;
				cairo_line_to (_tmp24_, (gdouble) _tmp25_, (gdouble) 19);
				_tmp26_ = context;
				cairo_set_font_size (_tmp26_, (gdouble) 12);
				_tmp27_ = context;
				_tmp28_ = xLabel;
				cairo_move_to (_tmp27_, (gdouble) (_tmp28_ + 2), (gdouble) 16);
				_tmp29_ = context;
				_tmp30_ = labelValue;
				_tmp31_ = g_strdup_printf ("%i", _tmp30_);
				_tmp32_ = _tmp31_;
				cairo_show_text (_tmp29_, _tmp32_);
				_g_free0 (_tmp32_);
				_tmp33_ = context;
				cairo_stroke (_tmp33_);
				_tmp36_ = fullRender;
				if (_tmp36_) {
					gboolean _tmp37_ = FALSE;
					_tmp37_ = self->priv->showGrid;
					_tmp35_ = _tmp37_;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					gfloat _tmp38_ = 0.0F;
					gint _tmp39_ = 0;
					_tmp38_ = xLabel;
					_tmp39_ = largestLength;
					_tmp34_ = _tmp38_ >= ((gfloat) (_tmp39_ + 20));
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					cairo_t* _tmp40_ = NULL;
					cairo_t* _tmp41_ = NULL;
					gfloat _tmp42_ = 0.0F;
					cairo_t* _tmp43_ = NULL;
					gfloat _tmp44_ = 0.0F;
					gint _tmp45_ = 0;
					cairo_t* _tmp46_ = NULL;
					_tmp40_ = context;
					cairo_set_source_rgba (_tmp40_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
					_tmp41_ = context;
					_tmp42_ = xLabel;
					cairo_move_to (_tmp41_, (gdouble) _tmp42_, (gdouble) 20);
					_tmp43_ = context;
					_tmp44_ = xLabel;
					_tmp45_ = height;
					cairo_line_to (_tmp43_, (gdouble) _tmp44_, (gdouble) _tmp45_);
					_tmp46_ = context;
					cairo_stroke (_tmp46_);
				}
			} else {
				cairo_t* _tmp47_ = NULL;
				cairo_t* _tmp48_ = NULL;
				gfloat _tmp49_ = 0.0F;
				cairo_t* _tmp50_ = NULL;
				gfloat _tmp51_ = 0.0F;
				cairo_t* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				gboolean _tmp55_ = FALSE;
				_tmp47_ = context;
				cairo_set_source_rgba (_tmp47_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
				_tmp48_ = context;
				_tmp49_ = xLabel;
				cairo_move_to (_tmp48_, (gdouble) _tmp49_, (gdouble) 5);
				_tmp50_ = context;
				_tmp51_ = xLabel;
				cairo_line_to (_tmp50_, (gdouble) _tmp51_, (gdouble) 15);
				_tmp52_ = context;
				cairo_stroke (_tmp52_);
				_tmp55_ = fullRender;
				if (_tmp55_) {
					gboolean _tmp56_ = FALSE;
					_tmp56_ = self->priv->showGrid;
					_tmp54_ = _tmp56_;
				} else {
					_tmp54_ = FALSE;
				}
				if (_tmp54_) {
					gfloat _tmp57_ = 0.0F;
					gint _tmp58_ = 0;
					_tmp57_ = xLabel;
					_tmp58_ = largestLength;
					_tmp53_ = _tmp57_ >= ((gfloat) (_tmp58_ + 20));
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					cairo_t* _tmp59_ = NULL;
					cairo_t* _tmp60_ = NULL;
					gfloat _tmp61_ = 0.0F;
					cairo_t* _tmp62_ = NULL;
					gfloat _tmp63_ = 0.0F;
					gint _tmp64_ = 0;
					cairo_t* _tmp65_ = NULL;
					_tmp59_ = context;
					cairo_set_source_rgba (_tmp59_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.125);
					_tmp60_ = context;
					_tmp61_ = xLabel;
					cairo_move_to (_tmp60_, (gdouble) _tmp61_, (gdouble) 20);
					_tmp62_ = context;
					_tmp63_ = xLabel;
					_tmp64_ = height;
					cairo_line_to (_tmp62_, (gdouble) _tmp63_, (gdouble) _tmp64_);
					_tmp65_ = context;
					cairo_stroke (_tmp65_);
				}
			}
		}
	}
}


static void timing_diagram_render_bar (TimingDiagram* self, cairo_t* context, gint height, gint largestLength) {
	gdouble _tmp0_ = 0.0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->barPosition;
	_tmp1_ = largestLength;
	if (_tmp0_ > ((gdouble) (_tmp1_ + 20))) {
		cairo_t* _tmp2_ = NULL;
		cairo_t* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		cairo_t* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gint _tmp7_ = 0;
		cairo_t* _tmp8_ = NULL;
		_tmp2_ = context;
		cairo_set_source_rgba (_tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.25);
		_tmp3_ = context;
		_tmp4_ = self->priv->barPosition;
		cairo_move_to (_tmp3_, _tmp4_, (gdouble) 0);
		_tmp5_ = context;
		_tmp6_ = self->priv->barPosition;
		_tmp7_ = height;
		cairo_line_to (_tmp5_, _tmp6_, (gdouble) _tmp7_);
		_tmp8_ = context;
		cairo_stroke (_tmp8_);
	}
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


gboolean timing_diagram_render (TimingDiagram* self, gboolean fullRefresh, cairo_t* passedDisplayContext) {
	gboolean result = FALSE;
	cairo_t* displayContext = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint width = 0;
	gint height = 0;
	GtkAllocation areaAllocation = {0};
	GtkDrawingArea* _tmp2_ = NULL;
	GtkAllocation _tmp3_ = {0};
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	cairo_t* _tmp8_ = NULL;
	gint largestLength = 0;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		_cairo_destroy0 (displayContext);
		return result;
	}
	_tmp2_ = self->priv->display;
	gtk_widget_get_allocation ((GtkWidget*) _tmp2_, &_tmp3_);
	areaAllocation = _tmp3_;
	_tmp4_ = areaAllocation;
	_tmp5_ = _tmp4_.width;
	width = _tmp5_;
	_tmp6_ = areaAllocation;
	_tmp7_ = _tmp6_.height;
	height = _tmp7_;
	_tmp8_ = passedDisplayContext;
	if (_tmp8_ == NULL) {
		GtkDrawingArea* _tmp9_ = NULL;
		GdkWindow* _tmp10_ = NULL;
		cairo_t* _tmp11_ = NULL;
		_tmp9_ = self->priv->display;
		_tmp10_ = gtk_widget_get_window ((GtkWidget*) _tmp9_);
		_tmp11_ = gdk_cairo_create (_tmp10_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp11_;
	} else {
		cairo_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		_tmp12_ = passedDisplayContext;
		_tmp13_ = _cairo_reference0 (_tmp12_);
		_cairo_destroy0 (displayContext);
		displayContext = _tmp13_;
	}
	_tmp14_ = self->priv->largestLengthCache;
	if (_tmp14_ == 0) {
		fullRefresh = TRUE;
	}
	_tmp16_ = fullRefresh;
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		cairo_surface_t* _tmp17_ = NULL;
		_tmp17_ = self->priv->offScreenSurface;
		_tmp15_ = _tmp17_ == NULL;
	}
	if (_tmp15_) {
		cairo_surface_t* offScreenSurface = NULL;
		cairo_t* _tmp18_ = NULL;
		cairo_surface_t* _tmp19_ = NULL;
		cairo_t* _tmp20_ = NULL;
		cairo_surface_t* _tmp21_ = NULL;
		cairo_content_t _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		cairo_surface_t* _tmp25_ = NULL;
		cairo_t* context = NULL;
		cairo_surface_t* _tmp26_ = NULL;
		cairo_t* _tmp27_ = NULL;
		cairo_t* _tmp28_ = NULL;
		cairo_t* _tmp29_ = NULL;
		cairo_surface_t* _tmp30_ = NULL;
		cairo_t* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		cairo_t* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		cairo_t* _tmp57_ = NULL;
		cairo_surface_t* _tmp58_ = NULL;
		cairo_t* _tmp59_ = NULL;
		cairo_t* _tmp60_ = NULL;
		cairo_surface_t* _tmp61_ = NULL;
		cairo_t* _tmp62_ = NULL;
		_tmp18_ = displayContext;
		_tmp19_ = cairo_get_target (_tmp18_);
		_tmp20_ = displayContext;
		_tmp21_ = cairo_get_target (_tmp20_);
		_tmp22_ = cairo_surface_get_content (_tmp21_);
		_tmp23_ = width;
		_tmp24_ = height;
		_tmp25_ = cairo_surface_create_similar (_tmp19_, _tmp22_, _tmp23_, _tmp24_);
		offScreenSurface = _tmp25_;
		_tmp26_ = offScreenSurface;
		_tmp27_ = cairo_create (_tmp26_);
		context = _tmp27_;
		_tmp28_ = context;
		cairo_set_source_rgb (_tmp28_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp29_ = context;
		cairo_paint (_tmp29_);
		_tmp30_ = self->priv->diagramCache;
		if (_tmp30_ == NULL) {
			cairo_t* _tmp31_ = NULL;
			cairo_surface_t* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			cairo_surface_t* _tmp35_ = NULL;
			cairo_t* cacheContext = NULL;
			cairo_surface_t* _tmp36_ = NULL;
			cairo_t* _tmp37_ = NULL;
			cairo_t* _tmp38_ = NULL;
			cairo_t* _tmp39_ = NULL;
			cairo_t* _tmp40_ = NULL;
			cairo_t* _tmp41_ = NULL;
			cairo_t* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			cairo_t* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			_tmp31_ = context;
			_tmp32_ = cairo_get_target (_tmp31_);
			_tmp33_ = width;
			_tmp34_ = height;
			_tmp35_ = cairo_surface_create_similar (_tmp32_, CAIRO_CONTENT_COLOR_ALPHA, _tmp33_, _tmp34_);
			_cairo_surface_destroy0 (self->priv->diagramCache);
			self->priv->diagramCache = _tmp35_;
			_tmp36_ = self->priv->diagramCache;
			_tmp37_ = cairo_create (_tmp36_);
			cacheContext = _tmp37_;
			_tmp38_ = cacheContext;
			cairo_set_operator (_tmp38_, CAIRO_OPERATOR_SOURCE);
			_tmp39_ = cacheContext;
			cairo_set_source_rgba (_tmp39_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp40_ = cacheContext;
			cairo_paint (_tmp40_);
			_tmp41_ = cacheContext;
			cairo_set_operator (_tmp41_, CAIRO_OPERATOR_OVER);
			_tmp42_ = cacheContext;
			_tmp43_ = width;
			timing_diagram_render_labels (self, _tmp42_, TRUE, _tmp43_, &_tmp44_);
			largestLength = _tmp44_;
			_tmp45_ = cacheContext;
			_tmp46_ = width;
			_tmp47_ = height;
			_tmp48_ = largestLength;
			timing_diagram_render_ruler (self, _tmp45_, TRUE, _tmp46_, _tmp47_, _tmp48_);
			_tmp49_ = largestLength;
			self->priv->largestLengthCache = _tmp49_;
			_cairo_destroy0 (cacheContext);
		} else {
			gint _tmp50_ = 0;
			_tmp50_ = self->priv->largestLengthCache;
			largestLength = _tmp50_;
		}
		_tmp51_ = context;
		_tmp52_ = width;
		_tmp53_ = largestLength;
		timing_diagram_render_graphs (self, _tmp51_, TRUE, _tmp52_, _tmp53_);
		_tmp54_ = context;
		_tmp55_ = height;
		_tmp56_ = largestLength;
		timing_diagram_render_bar (self, _tmp54_, _tmp55_, _tmp56_);
		_tmp57_ = context;
		_tmp58_ = self->priv->diagramCache;
		cairo_set_source_surface (_tmp57_, _tmp58_, (gdouble) 0, (gdouble) 0);
		_tmp59_ = context;
		cairo_paint (_tmp59_);
		_tmp60_ = displayContext;
		_tmp61_ = offScreenSurface;
		cairo_set_source_surface (_tmp60_, _tmp61_, (gdouble) 0, (gdouble) 0);
		_tmp62_ = displayContext;
		cairo_paint (_tmp62_);
		_cairo_destroy0 (context);
		_cairo_surface_destroy0 (offScreenSurface);
	} else {
		cairo_t* context = NULL;
		cairo_surface_t* _tmp63_ = NULL;
		cairo_t* _tmp64_ = NULL;
		cairo_t* _tmp65_ = NULL;
		cairo_t* _tmp66_ = NULL;
		cairo_surface_t* _tmp67_ = NULL;
		cairo_t* _tmp88_ = NULL;
		gint _tmp89_ = 0;
		gint _tmp90_ = 0;
		cairo_t* _tmp91_ = NULL;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		cairo_t* _tmp94_ = NULL;
		cairo_surface_t* _tmp95_ = NULL;
		cairo_t* _tmp96_ = NULL;
		cairo_t* _tmp97_ = NULL;
		cairo_surface_t* _tmp98_ = NULL;
		cairo_t* _tmp99_ = NULL;
		_tmp63_ = self->priv->offScreenSurface;
		_tmp64_ = cairo_create (_tmp63_);
		context = _tmp64_;
		_tmp65_ = context;
		cairo_set_source_rgb (_tmp65_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp66_ = context;
		cairo_paint (_tmp66_);
		_tmp67_ = self->priv->diagramCache;
		if (_tmp67_ == NULL) {
			cairo_t* _tmp68_ = NULL;
			cairo_surface_t* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			cairo_surface_t* _tmp72_ = NULL;
			cairo_t* cacheContext = NULL;
			cairo_surface_t* _tmp73_ = NULL;
			cairo_t* _tmp74_ = NULL;
			cairo_t* _tmp75_ = NULL;
			cairo_t* _tmp76_ = NULL;
			cairo_t* _tmp77_ = NULL;
			cairo_t* _tmp78_ = NULL;
			cairo_t* _tmp79_ = NULL;
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			cairo_t* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			_tmp68_ = context;
			_tmp69_ = cairo_get_target (_tmp68_);
			_tmp70_ = width;
			_tmp71_ = height;
			_tmp72_ = cairo_surface_create_similar (_tmp69_, CAIRO_CONTENT_COLOR_ALPHA, _tmp70_, _tmp71_);
			_cairo_surface_destroy0 (self->priv->diagramCache);
			self->priv->diagramCache = _tmp72_;
			_tmp73_ = self->priv->diagramCache;
			_tmp74_ = cairo_create (_tmp73_);
			cacheContext = _tmp74_;
			_tmp75_ = cacheContext;
			cairo_set_operator (_tmp75_, CAIRO_OPERATOR_SOURCE);
			_tmp76_ = cacheContext;
			cairo_set_source_rgba (_tmp76_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp77_ = cacheContext;
			cairo_paint (_tmp77_);
			_tmp78_ = cacheContext;
			cairo_set_operator (_tmp78_, CAIRO_OPERATOR_OVER);
			_tmp79_ = cacheContext;
			_tmp80_ = width;
			timing_diagram_render_labels (self, _tmp79_, FALSE, _tmp80_, &_tmp81_);
			largestLength = _tmp81_;
			_tmp82_ = cacheContext;
			_tmp83_ = width;
			_tmp84_ = height;
			_tmp85_ = largestLength;
			timing_diagram_render_ruler (self, _tmp82_, FALSE, _tmp83_, _tmp84_, _tmp85_);
			_tmp86_ = largestLength;
			self->priv->largestLengthCache = _tmp86_;
			_cairo_destroy0 (cacheContext);
		} else {
			gint _tmp87_ = 0;
			_tmp87_ = self->priv->largestLengthCache;
			largestLength = _tmp87_;
		}
		_tmp88_ = context;
		_tmp89_ = width;
		_tmp90_ = largestLength;
		timing_diagram_render_graphs (self, _tmp88_, FALSE, _tmp89_, _tmp90_);
		_tmp91_ = context;
		_tmp92_ = height;
		_tmp93_ = largestLength;
		timing_diagram_render_bar (self, _tmp91_, _tmp92_, _tmp93_);
		_tmp94_ = context;
		_tmp95_ = self->priv->diagramCache;
		cairo_set_source_surface (_tmp94_, _tmp95_, (gdouble) 0, (gdouble) 0);
		_tmp96_ = context;
		cairo_paint (_tmp96_);
		_tmp97_ = displayContext;
		_tmp98_ = self->priv->offScreenSurface;
		cairo_set_source_surface (_tmp97_, _tmp98_, (gdouble) 0, (gdouble) 0);
		_tmp99_ = displayContext;
		cairo_paint (_tmp99_);
		_cairo_destroy0 (context);
	}
	result = FALSE;
	_cairo_destroy0 (displayContext);
	return result;
}


static void _timing_diagram_file_render_image_exporter_renderer (const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution, gpointer self) {
	timing_diagram_file_render ((TimingDiagram*) self, filename, imageFormat, resolution);
}


void timing_diagram_export_png (TimingDiagram* self) {
	g_return_if_fail (self != NULL);
	image_exporter_export_png (_timing_diagram_file_render_image_exporter_renderer, self);
}


void timing_diagram_export_pdf (TimingDiagram* self) {
	g_return_if_fail (self != NULL);
	image_exporter_export_pdf (_timing_diagram_file_render_image_exporter_renderer, self);
}


void timing_diagram_export_svg (TimingDiagram* self) {
	g_return_if_fail (self != NULL);
	image_exporter_export_svg (_timing_diagram_file_render_image_exporter_renderer, self);
}


/**
 * Passed to ImageExporter as a delegate and called by an export
 * function to render to a file.
 */
static void timing_diagram_file_render (TimingDiagram* self, const gchar* filename, ImageExporterImageFormat imageFormat, gdouble resolution) {
	cairo_surface_t* surface = NULL;
	gint duration = 0;
	CompiledCircuit* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gfloat _tmp5_ = 0.0F;
	gint _tmp6_ = 0;
	WireState** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gfloat _tmp8_ = 0.0F;
	gint _tmp9_ = 0;
	gint imageWidth = 0;
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	gint imageHeight = 0;
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	gdouble imageXZoom = 0.0;
	gfloat _tmp14_ = 0.0F;
	gdouble _tmp15_ = 0.0;
	gdouble imageYZoom = 0.0;
	gfloat _tmp16_ = 0.0F;
	gdouble _tmp17_ = 0.0;
	ImageExporterImageFormat _tmp18_ = 0;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	ImageExporterImageFormat _tmp36_ = 0;
	cairo_t* _tmp43_ = NULL;
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	cairo_t* _tmp46_ = NULL;
	FILE* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gdouble _tmp50_ = 0.0;
	gdouble _tmp51_ = 0.0;
	gint largestLength = 0;
	cairo_t* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	cairo_t* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	cairo_t* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	ImageExporterImageFormat _tmp62_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = self->priv->compiledCircuit;
	_tmp1_ = _tmp0_->iterationCount;
	_tmp2_ = self->priv->iterationCountOffset;
	duration = _tmp1_ - _tmp2_;
	_tmp3_ = duration;
	_tmp4_ = self->priv->xView;
	_tmp5_ = self->priv->xZoom;
	_tmp6_ = timing_diagram_text_length (self);
	width = (((gint) (((gfloat) (_tmp3_ - _tmp4_)) * _tmp5_)) + _tmp6_) + 21;
	_tmp7_ = self->priv->wireStates;
	_tmp7__length1 = self->priv->wireStates_length1;
	_tmp8_ = self->priv->yZoom;
	_tmp9_ = self->priv->yView;
	height = (((gint) (((gfloat) _tmp7__length1) * (_tmp8_ * 2.4))) - _tmp9_) + 21;
	_tmp10_ = width;
	_tmp11_ = resolution;
	imageWidth = (gint) (((gdouble) _tmp10_) * _tmp11_);
	_tmp12_ = height;
	_tmp13_ = resolution;
	imageHeight = (gint) (((gdouble) _tmp12_) * _tmp13_);
	_tmp14_ = self->priv->xZoom;
	_tmp15_ = resolution;
	imageXZoom = _tmp14_ * _tmp15_;
	_tmp16_ = self->priv->yZoom;
	_tmp17_ = resolution;
	imageYZoom = (_tmp16_ * _tmp17_) / 25;
	_tmp18_ = imageFormat;
	switch (_tmp18_) {
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_RGB:
		{
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			cairo_surface_t* _tmp21_ = NULL;
			_tmp19_ = imageWidth;
			_tmp20_ = imageHeight;
			_tmp21_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, _tmp19_, _tmp20_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp21_;
			break;
		}
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB:
		{
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			cairo_surface_t* _tmp24_ = NULL;
			_tmp22_ = imageWidth;
			_tmp23_ = imageHeight;
			_tmp24_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp22_, _tmp23_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp24_;
			break;
		}
		case IMAGE_EXPORTER_IMAGE_FORMAT_PDF:
		{
			const gchar* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			cairo_surface_t* _tmp28_ = NULL;
			_tmp25_ = filename;
			_tmp26_ = imageWidth;
			_tmp27_ = imageHeight;
			_tmp28_ = cairo_pdf_surface_create (_tmp25_, (gdouble) _tmp26_, (gdouble) _tmp27_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp28_;
			break;
		}
		case IMAGE_EXPORTER_IMAGE_FORMAT_SVG:
		case IMAGE_EXPORTER_IMAGE_FORMAT_SVG_CLEAR:
		{
			const gchar* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			cairo_surface_t* _tmp32_ = NULL;
			_tmp29_ = filename;
			_tmp30_ = imageWidth;
			_tmp31_ = imageHeight;
			_tmp32_ = cairo_svg_surface_create (_tmp29_, (gdouble) _tmp30_, (gdouble) _tmp31_);
			_cairo_surface_destroy0 (surface);
			surface = _tmp32_;
			break;
		}
		default:
		{
			FILE* _tmp33_ = NULL;
			_tmp33_ = stderr;
			fprintf (_tmp33_, "Error: Unknown Export Format!\n");
			_cairo_surface_destroy0 (surface);
			return;
		}
	}
	_tmp34_ = surface;
	_tmp35_ = cairo_create (_tmp34_);
	context = _tmp35_;
	_tmp36_ = imageFormat;
	switch (_tmp36_) {
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB:
		case IMAGE_EXPORTER_IMAGE_FORMAT_SVG_CLEAR:
		{
			cairo_t* _tmp37_ = NULL;
			cairo_t* _tmp38_ = NULL;
			cairo_t* _tmp39_ = NULL;
			cairo_t* _tmp40_ = NULL;
			_tmp37_ = context;
			cairo_set_operator (_tmp37_, CAIRO_OPERATOR_SOURCE);
			_tmp38_ = context;
			cairo_set_source_rgba (_tmp38_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp39_ = context;
			cairo_paint (_tmp39_);
			_tmp40_ = context;
			cairo_set_operator (_tmp40_, CAIRO_OPERATOR_OVER);
			break;
		}
		default:
		{
			cairo_t* _tmp41_ = NULL;
			cairo_t* _tmp42_ = NULL;
			_tmp41_ = context;
			cairo_set_source_rgb (_tmp41_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
			_tmp42_ = context;
			cairo_paint (_tmp42_);
			break;
		}
	}
	_tmp43_ = context;
	_tmp44_ = imageXZoom;
	_tmp45_ = imageYZoom;
	cairo_scale (_tmp43_, _tmp44_, _tmp45_);
	_tmp46_ = context;
	cairo_set_line_width (_tmp46_, (gdouble) 1);
	_tmp47_ = stdout;
	_tmp48_ = imageWidth;
	_tmp49_ = imageHeight;
	_tmp50_ = imageXZoom;
	_tmp51_ = imageYZoom;
	fprintf (_tmp47_, "Exporting timing diagram (render size = %i x %i, scale = %f x %f)\n", _tmp48_, _tmp49_, _tmp50_, _tmp51_);
	_tmp52_ = context;
	_tmp53_ = width;
	timing_diagram_render_labels (self, _tmp52_, TRUE, _tmp53_, &_tmp54_);
	largestLength = _tmp54_;
	_tmp55_ = context;
	_tmp56_ = width;
	_tmp57_ = largestLength;
	timing_diagram_render_graphs (self, _tmp55_, TRUE, _tmp56_, _tmp57_);
	_tmp58_ = context;
	_tmp59_ = width;
	_tmp60_ = height;
	_tmp61_ = largestLength;
	timing_diagram_render_ruler (self, _tmp58_, TRUE, _tmp59_, _tmp60_, _tmp61_);
	_tmp62_ = imageFormat;
	switch (_tmp62_) {
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_RGB:
		case IMAGE_EXPORTER_IMAGE_FORMAT_PNG_ARGB:
		{
			cairo_surface_t* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			_tmp63_ = surface;
			_tmp64_ = filename;
			cairo_surface_write_to_png (_tmp63_, _tmp64_);
			break;
		}
		default:
		break;
	}
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
}


static void timing_diagram_class_init (TimingDiagramClass * klass) {
	timing_diagram_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TimingDiagramPrivate));
	G_OBJECT_CLASS (klass)->finalize = timing_diagram_finalize;
}


static void timing_diagram_instance_init (TimingDiagram * self) {
	self->priv = TIMING_DIAGRAM_GET_PRIVATE (self);
	self->priv->mouseMode = TIMING_DIAGRAM_MOUSE_MODE_SCROLL;
	self->priv->showGrid = TRUE;
	self->alwaysOnTop = TRUE;
	self->priv->xView = 0;
	self->priv->yView = 0;
	self->priv->xZoom = (gfloat) 1;
	self->priv->yZoom = (gfloat) 25;
	self->priv->barPosition = (gdouble) 0;
	self->priv->iterationCountOffset = 0;
}


static void timing_diagram_finalize (GObject* obj) {
	TimingDiagram * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIMING_DIAGRAM, TimingDiagram);
	_g_object_unref0 (self->priv->vBox);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->menuFile);
	_g_object_unref0 (self->priv->menuFileMenu);
	_g_object_unref0 (self->priv->menuFileExport);
	_g_object_unref0 (self->priv->menuFileExportMenu);
	_g_object_unref0 (self->priv->menuFileExportPng);
	_g_object_unref0 (self->priv->menuFileExportPdf);
	_g_object_unref0 (self->priv->menuFileExportSvg);
	_g_object_unref0 (self->priv->menuFileSeparator1);
	_g_object_unref0 (self->priv->menuFileExit);
	_g_object_unref0 (self->priv->menuRecording);
	_g_object_unref0 (self->priv->menuRecordingMenu);
	_g_object_unref0 (self->priv->menuRecordingReset);
	_g_object_unref0 (self->priv->menuView);
	_g_object_unref0 (self->priv->menuViewMenu);
	_g_object_unref0 (self->priv->menuViewAlwaysontop);
	_g_object_unref0 (self->priv->menuViewSeparator1);
	_g_object_unref0 (self->priv->menuViewShowgrid);
	_g_object_unref0 (self->priv->menuViewSeparator2);
	_g_object_unref0 (self->priv->menuViewReset);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->toolScroll);
	_g_object_unref0 (self->priv->toolScrollImage);
	_g_object_unref0 (self->priv->toolZoom);
	_g_object_unref0 (self->priv->toolZoomImage);
	_g_object_unref0 (self->priv->toolSeparator1);
	_g_object_unref0 (self->priv->toolMove);
	_g_object_unref0 (self->priv->toolMoveImage);
	_g_object_unref0 (self->priv->toolDelete);
	_g_object_unref0 (self->priv->toolDeleteImage);
	_g_object_unref0 (self->priv->toolAdjust);
	_g_object_unref0 (self->priv->toolAdjustImage);
	_g_object_unref0 (self->priv->controller);
	_g_object_unref0 (self->priv->display);
	_cairo_surface_destroy0 (self->priv->diagramCache);
	_cairo_surface_destroy0 (self->priv->offScreenSurface);
	self->priv->wireStates = (_vala_array_free (self->priv->wireStates, self->priv->wireStates_length1, (GDestroyNotify) wire_state_unref), NULL);
	self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_free), NULL);
	_compiled_circuit_unref0 (self->priv->compiledCircuit);
	G_OBJECT_CLASS (timing_diagram_parent_class)->finalize (obj);
}


GType timing_diagram_get_type (void) {
	static volatile gsize timing_diagram_type_id__volatile = 0;
	if (g_once_init_enter (&timing_diagram_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TimingDiagramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timing_diagram_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimingDiagram), 0, (GInstanceInitFunc) timing_diagram_instance_init, NULL };
		GType timing_diagram_type_id;
		timing_diagram_type_id = g_type_register_static (GTK_TYPE_WINDOW, "TimingDiagram", &g_define_type_info, 0);
		g_once_init_leave (&timing_diagram_type_id__volatile, timing_diagram_type_id);
	}
	return timing_diagram_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



