/* wireinst.c generated by valac 0.24.0, the Vala compiler
 * generated from wireinst.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: wireinst.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <libxml/tree.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <libxml/xmlwriter.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;
typedef struct _WireInstPrivate WireInstPrivate;

#define WIRE_INST_TYPE_REGISTERED_COMPONENT (wire_inst_registered_component_get_type ())

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define WIRE_INST_TYPE_MARKER (wire_inst_marker_get_type ())
typedef struct _WireInstMarker WireInstMarker;
typedef struct _WireInstRegisteredComponent WireInstRegisteredComponent;

#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define WIRE_INST_TYPE_PRESET_SIGNAL (wire_inst_preset_signal_get_type ())
#define _tag_unref0(var) ((var == NULL) ? NULL : (var = (tag_unref (var), NULL)))
#define _path_unref0(var) ((var == NULL) ? NULL : (var = (path_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FLOW (flow_get_type ())
typedef struct _TagPrivate TagPrivate;

#define TYPE_DIRECTION (direction_get_type ())
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))
#define _component_inst_unref0(var) ((var == NULL) ? NULL : (var = (component_inst_unref (var), NULL)))
typedef struct _PathPrivate PathPrivate;

#define PATH_TYPE_LINE (path_line_get_type ())
typedef struct _PathLine PathLine;
typedef struct _ParamSpecWireInst ParamSpecWireInst;

struct _WireInstMarker {
	gint x;
	gint y;
	gboolean display;
};

struct _WireInstRegisteredComponent {
	ComponentInst* componentInst;
	WireInstMarker marker;
};

typedef enum  {
	WIRE_INST_PRESET_SIGNAL_DEFAULT,
	WIRE_INST_PRESET_SIGNAL_FALSE,
	WIRE_INST_PRESET_SIGNAL_TRUE
} WireInstPresetSignal;

struct _WireInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireInstPrivate * priv;
	WireInstRegisteredComponent* registeredComponents;
	gint registeredComponents_length1;
	gint myID;
	gboolean selected;
	WireInstMarker* markers;
	gint markers_length1;
	Path** paths;
	gint paths_length1;
	Tag* interfaceTag;
	WireInstPresetSignal presetSignal;
};

struct _WireInstClass {
	GTypeClass parent_class;
	void (*finalize) (WireInst *self);
};

typedef enum  {
	FLOW_NONE,
	FLOW_IN,
	FLOW_OUT,
	FLOW_BIDIRECTIONAL
} Flow;

typedef enum  {
	DIRECTION_NONE,
	DIRECTION_RIGHT,
	DIRECTION_DOWN,
	DIRECTION_LEFT,
	DIRECTION_UP,
	DIRECTION_HORIZONTAL,
	DIRECTION_VERTICAL,
	DIRECTION_DIAGONAL
} Direction;

struct _Tag {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TagPrivate * priv;
	gchar* text;
	gint xTag;
	gint yTag;
	gint xWire;
	gint yWire;
	gint pinid;
	Flow flow;
	Direction direction;
	gint rightBound;
	gint downBound;
	gint leftBound;
	gint upBound;
};

struct _TagClass {
	GTypeClass parent_class;
	void (*finalize) (Tag *self);
};

struct _PathLine {
	gint x1;
	gint y1;
	gint x2;
	gint y2;
	Direction dir;
};

struct _Path {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PathPrivate * priv;
	PathLine* lines;
	gint lines_length1;
	gint last;
	gint xLast;
	gint yLast;
	gint xLineStart;
	gint yLineStart;
	Direction dirLast;
};

struct _PathClass {
	GTypeClass parent_class;
	void (*finalize) (Path *self);
};

struct _ParamSpecWireInst {
	GParamSpec parent_instance;
};


static gpointer wire_inst_parent_class = NULL;

gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
GType wire_inst_registered_component_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
GType wire_inst_marker_get_type (void) G_GNUC_CONST;
WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self);
void wire_inst_marker_free (WireInstMarker* self);
WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self);
void wire_inst_registered_component_free (WireInstRegisteredComponent* self);
gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
GType wire_inst_preset_signal_get_type (void) G_GNUC_CONST;
enum  {
	WIRE_INST_DUMMY_PROPERTY
};
WireInst* wire_inst_new (void);
WireInst* wire_inst_construct (GType object_type);
WireInst* wire_inst_new_load (xmlNode* xmlnode);
WireInst* wire_inst_construct_load (GType object_type, xmlNode* xmlnode);
Path* path_new (gint xStart, gint yStart);
Path* path_construct (GType object_type, gint xStart, gint yStart);
gint path_append (Path* self, gint x, gint y, gfloat diagonalThreshold);
void wire_inst_import_path (WireInst* self, Path* path);
void wire_inst_mark (WireInst* self, gint x, gint y);
Tag* tag_new (gint xWire, gint yWire, gint xTag, gint yTag);
Tag* tag_construct (GType object_type, gint xWire, gint yWire, gint xTag, gint yTag);
GType flow_get_type (void) G_GNUC_CONST;
GType direction_get_type (void) G_GNUC_CONST;
static Path** _vala_array_dup77 (Path** self, int length);
static void _vala_array_add96 (Path*** array, int* length, int* size, Path* value);
static Path** _vala_array_dup78 (Path** self, int length);
void wire_inst_register_component (WireInst* self, ComponentInst* newComponentInst, gint x, gint y);
static WireInstRegisteredComponent* _vala_array_dup79 (WireInstRegisteredComponent* self, int length);
gint path_find (Path* self, gint x, gint y);
static void _vala_array_add97 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value);
static WireInstRegisteredComponent* _vala_array_dup80 (WireInstRegisteredComponent* self, int length);
void wire_inst_unregister_component (WireInst* self, ComponentInst* oldComponentInst);
static void _vala_array_add98 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value);
static WireInstRegisteredComponent* _vala_array_dup81 (WireInstRegisteredComponent* self, int length);
void wire_inst_unregister_component_xy (WireInst* self, ComponentInst* oldComponentInst, gint x, gint y);
static void _vala_array_add99 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value);
static WireInstRegisteredComponent* _vala_array_dup82 (WireInstRegisteredComponent* self, int length);
void wire_inst_disconnect_components (WireInst* self);
void component_inst_disconnect_wire (ComponentInst* self, WireInst* wireInst, gboolean callWire);
void wire_inst_merge (WireInst* self, WireInst* sourceWireInst);
static Path** _vala_array_dup83 (Path** self, int length);
static WireInstMarker* _vala_array_dup84 (WireInstMarker* self, int length);
static WireInstRegisteredComponent* _vala_array_dup85 (WireInstRegisteredComponent* self, int length);
gboolean wire_inst_try_merge_paths (WireInst* self, Path* checkPath);
static void _vala_array_add100 (Path*** array, int* length, int* size, Path* value);
static void _vala_array_add101 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value);
void component_inst_change_wire (ComponentInst* self, WireInst* replaceWhat, WireInst* replaceWith);
static void _vala_array_add102 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value);
static Path** _vala_array_dup86 (Path** self, int length);
static WireInstMarker* _vala_array_dup87 (WireInstMarker* self, int length);
static WireInstRegisteredComponent* _vala_array_dup88 (WireInstRegisteredComponent* self, int length);
WireInst** wire_inst_unmerge (WireInst* self, gint x, gint y, int* result_length1);
static void _vala_array_add103 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value);
static void _vala_array_add104 (WireInst*** array, int* length, int* size, WireInst* value);
static void _vala_array_add105 (Path*** array, int* length, int* size, Path* value);
Path* wire_inst_find (WireInst* self, gint x, gint y);
static void _vala_array_add106 (Path*** array, int* length, int* size, Path* value);
static Path** _vala_array_dup89 (Path** self, int length);
static void _vala_array_add107 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value);
static WireInstMarker* _vala_array_dup90 (WireInstMarker* self, int length);
gboolean component_inst_try_connect (ComponentInst* self, gint x, gint y, WireInst* wireInst);
static WireInstMarker* _vala_array_dup91 (WireInstMarker* self, int length);
static void _vala_array_add108 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value);
static WireInstMarker* _vala_array_dup92 (WireInstMarker* self, int length);
gint wire_inst_find_tag (WireInst* self, gint x, gint y);
gint wire_inst_count_find (WireInst* self, gint x, gint y);
GType path_line_get_type (void) G_GNUC_CONST;
PathLine* path_line_dup (const PathLine* self);
void path_line_free (PathLine* self);
void path_merge (Path* self, Path* extraPath, gboolean prepend, gboolean reverse);
Tag* wire_inst_set_tag (WireInst* self, gint x1, gint y1, gint x2, gint y2);
void wire_inst_try_select (WireInst* self, gint x, gint y, gboolean toggle, gboolean includeTag);
void wire_inst_move (WireInst* self, gint x, gint y, gboolean ignoreSelect);
void path_move (Path* self, gint x, gint y);
void tag_calculate_bounds (Tag* self);
void wire_inst_save (WireInst* self, xmlTextWriter* xmlWriter);
void wire_inst_render (WireInst* self, cairo_t* context, gboolean showHints, gboolean showErrors);
void wire_inst_render_colour (WireInst* self, cairo_t* context, gfloat r, gfloat g, gfloat b);
void path_render (Path* self, cairo_t* context);
void tag_render (Tag* self, cairo_t* context);
static void wire_inst_finalize (WireInst* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType wire_inst_preset_signal_get_type (void) {
	static volatile gsize wire_inst_preset_signal_type_id__volatile = 0;
	if (g_once_init_enter (&wire_inst_preset_signal_type_id__volatile)) {
		static const GEnumValue values[] = {{WIRE_INST_PRESET_SIGNAL_DEFAULT, "WIRE_INST_PRESET_SIGNAL_DEFAULT", "default"}, {WIRE_INST_PRESET_SIGNAL_FALSE, "WIRE_INST_PRESET_SIGNAL_FALSE", "false"}, {WIRE_INST_PRESET_SIGNAL_TRUE, "WIRE_INST_PRESET_SIGNAL_TRUE", "true"}, {0, NULL, NULL}};
		GType wire_inst_preset_signal_type_id;
		wire_inst_preset_signal_type_id = g_enum_register_static ("WireInstPresetSignal", values);
		g_once_init_leave (&wire_inst_preset_signal_type_id__volatile, wire_inst_preset_signal_type_id);
	}
	return wire_inst_preset_signal_type_id__volatile;
}


/**
 * Creates a new WireInst.
 */
WireInst* wire_inst_construct (GType object_type) {
	WireInst* self = NULL;
	self = (WireInst*) g_type_create_instance (object_type);
	return self;
}


WireInst* wire_inst_new (void) {
	return wire_inst_construct (TYPE_WIRE_INST);
}


/**
 * Loads a WireInst from a file using libxml.
 */
static gpointer _tag_ref0 (gpointer self) {
	return self ? tag_ref (self) : NULL;
}


WireInst* wire_inst_construct_load (GType object_type, xmlNode* xmlnode) {
	WireInst* self = NULL;
	self = (WireInst*) g_type_create_instance (object_type);
	{
		xmlAttr* xmlattr = NULL;
		xmlNode* _tmp0_ = NULL;
		xmlAttr* _tmp1_ = NULL;
		_tmp0_ = xmlnode;
		_tmp1_ = _tmp0_->properties;
		xmlattr = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_ = NULL;
				xmlAttr* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				GQuark _tmp10_ = 0U;
				static GQuark _tmp9_label0 = 0;
				static GQuark _tmp9_label1 = 0;
				if (!_tmp2_) {
					xmlAttr* _tmp3_ = NULL;
					xmlAttr* _tmp4_ = NULL;
					_tmp3_ = xmlattr;
					_tmp4_ = _tmp3_->next;
					xmlattr = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = xmlattr;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = xmlattr;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = _tmp7_;
				_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
				if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("id")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp11_ = NULL;
							xmlNode* _tmp12_ = NULL;
							const gchar* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							_tmp11_ = xmlattr;
							_tmp12_ = _tmp11_->children;
							_tmp13_ = _tmp12_->content;
							_tmp14_ = atoi (_tmp13_);
							self->myID = _tmp14_;
							break;
						}
					}
				} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("preset")))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp15_ = NULL;
							xmlNode* _tmp16_ = NULL;
							const gchar* _tmp17_ = NULL;
							const gchar* _tmp18_ = NULL;
							GQuark _tmp20_ = 0U;
							static GQuark _tmp19_label0 = 0;
							static GQuark _tmp19_label1 = 0;
							_tmp15_ = xmlattr;
							_tmp16_ = _tmp15_->children;
							_tmp17_ = _tmp16_->content;
							_tmp18_ = _tmp17_;
							_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
							if (_tmp20_ == ((0 != _tmp19_label0) ? _tmp19_label0 : (_tmp19_label0 = g_quark_from_static_string ("true")))) {
								switch (0) {
									default:
									{
										self->presetSignal = WIRE_INST_PRESET_SIGNAL_TRUE;
										break;
									}
								}
							} else if (_tmp20_ == ((0 != _tmp19_label1) ? _tmp19_label1 : (_tmp19_label1 = g_quark_from_static_string ("false")))) {
								switch (0) {
									default:
									{
										self->presetSignal = WIRE_INST_PRESET_SIGNAL_FALSE;
										break;
									}
								}
							}
							break;
						}
					}
				}
			}
		}
	}
	{
		xmlNode* xmlnodeWire = NULL;
		xmlNode* _tmp21_ = NULL;
		xmlNode* _tmp22_ = NULL;
		_tmp21_ = xmlnode;
		_tmp22_ = _tmp21_->children;
		xmlnodeWire = _tmp22_;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp26_ = NULL;
				xmlNode* _tmp27_ = NULL;
				xmlElementType _tmp28_ = 0;
				xmlNode* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				GQuark _tmp33_ = 0U;
				static GQuark _tmp32_label0 = 0;
				static GQuark _tmp32_label1 = 0;
				static GQuark _tmp32_label2 = 0;
				if (!_tmp23_) {
					xmlNode* _tmp24_ = NULL;
					xmlNode* _tmp25_ = NULL;
					_tmp24_ = xmlnodeWire;
					_tmp25_ = _tmp24_->next;
					xmlnodeWire = _tmp25_;
				}
				_tmp23_ = FALSE;
				_tmp26_ = xmlnodeWire;
				if (!(_tmp26_ != NULL)) {
					break;
				}
				_tmp27_ = xmlnodeWire;
				_tmp28_ = _tmp27_->type;
				if (_tmp28_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp29_ = xmlnodeWire;
				_tmp30_ = _tmp29_->name;
				_tmp31_ = _tmp30_;
				_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
				if (_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("path")))) {
					switch (0) {
						default:
						{
							{
								Path* path = NULL;
								gboolean firstLine = FALSE;
								gboolean _tmp73_ = FALSE;
								Path* _tmp74_ = NULL;
								path = NULL;
								firstLine = TRUE;
								{
									xmlNode* xmlnodePath = NULL;
									xmlNode* _tmp34_ = NULL;
									xmlNode* _tmp35_ = NULL;
									_tmp34_ = xmlnodeWire;
									_tmp35_ = _tmp34_->children;
									xmlnodePath = _tmp35_;
									{
										gboolean _tmp36_ = FALSE;
										_tmp36_ = TRUE;
										while (TRUE) {
											xmlNode* _tmp39_ = NULL;
											xmlNode* _tmp40_ = NULL;
											xmlElementType _tmp41_ = 0;
											xmlNode* _tmp42_ = NULL;
											const gchar* _tmp43_ = NULL;
											const gchar* _tmp44_ = NULL;
											GQuark _tmp46_ = 0U;
											static GQuark _tmp45_label0 = 0;
											if (!_tmp36_) {
												xmlNode* _tmp37_ = NULL;
												xmlNode* _tmp38_ = NULL;
												_tmp37_ = xmlnodePath;
												_tmp38_ = _tmp37_->next;
												xmlnodePath = _tmp38_;
											}
											_tmp36_ = FALSE;
											_tmp39_ = xmlnodePath;
											if (!(_tmp39_ != NULL)) {
												break;
											}
											_tmp40_ = xmlnodePath;
											_tmp41_ = _tmp40_->type;
											if (_tmp41_ != XML_ELEMENT_NODE) {
												continue;
											}
											_tmp42_ = xmlnodePath;
											_tmp43_ = _tmp42_->name;
											_tmp44_ = _tmp43_;
											_tmp46_ = (NULL == _tmp44_) ? 0 : g_quark_from_string (_tmp44_);
											if (_tmp46_ == ((0 != _tmp45_label0) ? _tmp45_label0 : (_tmp45_label0 = g_quark_from_static_string ("point")))) {
												switch (0) {
													default:
													{
														{
															gint x = 0;
															gint y = 0;
															Path* _tmp66_ = NULL;
															x = 0;
															y = 0;
															{
																xmlAttr* xmlattr = NULL;
																xmlNode* _tmp47_ = NULL;
																xmlAttr* _tmp48_ = NULL;
																_tmp47_ = xmlnodePath;
																_tmp48_ = _tmp47_->properties;
																xmlattr = _tmp48_;
																{
																	gboolean _tmp49_ = FALSE;
																	_tmp49_ = TRUE;
																	while (TRUE) {
																		xmlAttr* _tmp52_ = NULL;
																		xmlAttr* _tmp53_ = NULL;
																		const gchar* _tmp54_ = NULL;
																		const gchar* _tmp55_ = NULL;
																		GQuark _tmp57_ = 0U;
																		static GQuark _tmp56_label0 = 0;
																		static GQuark _tmp56_label1 = 0;
																		if (!_tmp49_) {
																			xmlAttr* _tmp50_ = NULL;
																			xmlAttr* _tmp51_ = NULL;
																			_tmp50_ = xmlattr;
																			_tmp51_ = _tmp50_->next;
																			xmlattr = _tmp51_;
																		}
																		_tmp49_ = FALSE;
																		_tmp52_ = xmlattr;
																		if (!(_tmp52_ != NULL)) {
																			break;
																		}
																		_tmp53_ = xmlattr;
																		_tmp54_ = _tmp53_->name;
																		_tmp55_ = _tmp54_;
																		_tmp57_ = (NULL == _tmp55_) ? 0 : g_quark_from_string (_tmp55_);
																		if (_tmp57_ == ((0 != _tmp56_label0) ? _tmp56_label0 : (_tmp56_label0 = g_quark_from_static_string ("x")))) {
																			switch (0) {
																				default:
																				{
																					xmlAttr* _tmp58_ = NULL;
																					xmlNode* _tmp59_ = NULL;
																					const gchar* _tmp60_ = NULL;
																					gint _tmp61_ = 0;
																					_tmp58_ = xmlattr;
																					_tmp59_ = _tmp58_->children;
																					_tmp60_ = _tmp59_->content;
																					_tmp61_ = atoi (_tmp60_);
																					x = _tmp61_;
																					break;
																				}
																			}
																		} else if (_tmp57_ == ((0 != _tmp56_label1) ? _tmp56_label1 : (_tmp56_label1 = g_quark_from_static_string ("y")))) {
																			switch (0) {
																				default:
																				{
																					xmlAttr* _tmp62_ = NULL;
																					xmlNode* _tmp63_ = NULL;
																					const gchar* _tmp64_ = NULL;
																					gint _tmp65_ = 0;
																					_tmp62_ = xmlattr;
																					_tmp63_ = _tmp62_->children;
																					_tmp64_ = _tmp63_->content;
																					_tmp65_ = atoi (_tmp64_);
																					y = _tmp65_;
																					break;
																				}
																			}
																		}
																	}
																}
															}
															_tmp66_ = path;
															if (_tmp66_ == NULL) {
																gint _tmp67_ = 0;
																gint _tmp68_ = 0;
																Path* _tmp69_ = NULL;
																_tmp67_ = x;
																_tmp68_ = y;
																_tmp69_ = path_new (_tmp67_, _tmp68_);
																_path_unref0 (path);
																path = _tmp69_;
															} else {
																Path* _tmp70_ = NULL;
																gint _tmp71_ = 0;
																gint _tmp72_ = 0;
																_tmp70_ = path;
																_tmp71_ = x;
																_tmp72_ = y;
																path_append (_tmp70_, _tmp71_, _tmp72_, (gfloat) 0);
																firstLine = FALSE;
															}
														}
														break;
													}
												}
											}
										}
									}
								}
								_tmp74_ = path;
								if (_tmp74_ != NULL) {
									gboolean _tmp75_ = FALSE;
									_tmp75_ = firstLine;
									_tmp73_ = !_tmp75_;
								} else {
									_tmp73_ = FALSE;
								}
								if (_tmp73_) {
									Path* _tmp76_ = NULL;
									_tmp76_ = path;
									wire_inst_import_path (self, _tmp76_);
								} else {
									FILE* _tmp77_ = NULL;
									_tmp77_ = stderr;
									fprintf (_tmp77_, "Warning: Could not load path from points!\n");
								}
								_path_unref0 (path);
							}
							break;
						}
					}
				} else if (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("marker")))) {
					switch (0) {
						default:
						{
							{
								gint x = 0;
								gint y = 0;
								gint _tmp97_ = 0;
								gint _tmp98_ = 0;
								x = 0;
								y = 0;
								{
									xmlAttr* xmlattr = NULL;
									xmlNode* _tmp78_ = NULL;
									xmlAttr* _tmp79_ = NULL;
									_tmp78_ = xmlnodeWire;
									_tmp79_ = _tmp78_->properties;
									xmlattr = _tmp79_;
									{
										gboolean _tmp80_ = FALSE;
										_tmp80_ = TRUE;
										while (TRUE) {
											xmlAttr* _tmp83_ = NULL;
											xmlAttr* _tmp84_ = NULL;
											const gchar* _tmp85_ = NULL;
											const gchar* _tmp86_ = NULL;
											GQuark _tmp88_ = 0U;
											static GQuark _tmp87_label0 = 0;
											static GQuark _tmp87_label1 = 0;
											if (!_tmp80_) {
												xmlAttr* _tmp81_ = NULL;
												xmlAttr* _tmp82_ = NULL;
												_tmp81_ = xmlattr;
												_tmp82_ = _tmp81_->next;
												xmlattr = _tmp82_;
											}
											_tmp80_ = FALSE;
											_tmp83_ = xmlattr;
											if (!(_tmp83_ != NULL)) {
												break;
											}
											_tmp84_ = xmlattr;
											_tmp85_ = _tmp84_->name;
											_tmp86_ = _tmp85_;
											_tmp88_ = (NULL == _tmp86_) ? 0 : g_quark_from_string (_tmp86_);
											if (_tmp88_ == ((0 != _tmp87_label0) ? _tmp87_label0 : (_tmp87_label0 = g_quark_from_static_string ("x")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp89_ = NULL;
														xmlNode* _tmp90_ = NULL;
														const gchar* _tmp91_ = NULL;
														gint _tmp92_ = 0;
														_tmp89_ = xmlattr;
														_tmp90_ = _tmp89_->children;
														_tmp91_ = _tmp90_->content;
														_tmp92_ = atoi (_tmp91_);
														x = _tmp92_;
														break;
													}
												}
											} else if (_tmp88_ == ((0 != _tmp87_label1) ? _tmp87_label1 : (_tmp87_label1 = g_quark_from_static_string ("y")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp93_ = NULL;
														xmlNode* _tmp94_ = NULL;
														const gchar* _tmp95_ = NULL;
														gint _tmp96_ = 0;
														_tmp93_ = xmlattr;
														_tmp94_ = _tmp93_->children;
														_tmp95_ = _tmp94_->content;
														_tmp96_ = atoi (_tmp95_);
														y = _tmp96_;
														break;
													}
												}
											}
										}
									}
								}
								_tmp97_ = x;
								_tmp98_ = y;
								wire_inst_mark (self, _tmp97_, _tmp98_);
							}
							break;
						}
					}
				} else if (_tmp33_ == ((0 != _tmp32_label2) ? _tmp32_label2 : (_tmp32_label2 = g_quark_from_static_string ("tag")))) {
					switch (0) {
						default:
						{
							{
								gchar* typeString = NULL;
								gchar* _tmp99_ = NULL;
								gchar* flowString = NULL;
								gchar* _tmp100_ = NULL;
								gint xWire = 0;
								gint yWire = 0;
								gint xTag = 0;
								gint yTag = 0;
								gint pinid = 0;
								gchar* text = NULL;
								gchar* _tmp101_ = NULL;
								Tag* newTag = NULL;
								gint _tmp145_ = 0;
								gint _tmp146_ = 0;
								gint _tmp147_ = 0;
								gint _tmp148_ = 0;
								Tag* _tmp149_ = NULL;
								const gchar* _tmp150_ = NULL;
								const gchar* _tmp151_ = NULL;
								GQuark _tmp153_ = 0U;
								static GQuark _tmp152_label0 = 0;
								static GQuark _tmp152_label1 = 0;
								static GQuark _tmp152_label2 = 0;
								const gchar* _tmp157_ = NULL;
								const gchar* _tmp158_ = NULL;
								GQuark _tmp160_ = 0U;
								static GQuark _tmp159_label0 = 0;
								Tag* _tmp163_ = NULL;
								const gchar* _tmp164_ = NULL;
								gchar* _tmp165_ = NULL;
								Tag* _tmp166_ = NULL;
								gint _tmp167_ = 0;
								_tmp99_ = g_strdup ("");
								typeString = _tmp99_;
								_tmp100_ = g_strdup ("");
								flowString = _tmp100_;
								xWire = 0;
								yWire = 0;
								xTag = 0;
								yTag = 0;
								pinid = 0;
								_tmp101_ = g_strdup ("");
								text = _tmp101_;
								{
									xmlAttr* xmlattr = NULL;
									xmlNode* _tmp102_ = NULL;
									xmlAttr* _tmp103_ = NULL;
									_tmp102_ = xmlnodeWire;
									_tmp103_ = _tmp102_->properties;
									xmlattr = _tmp103_;
									{
										gboolean _tmp104_ = FALSE;
										_tmp104_ = TRUE;
										while (TRUE) {
											xmlAttr* _tmp107_ = NULL;
											xmlAttr* _tmp108_ = NULL;
											const gchar* _tmp109_ = NULL;
											const gchar* _tmp110_ = NULL;
											GQuark _tmp112_ = 0U;
											static GQuark _tmp111_label0 = 0;
											static GQuark _tmp111_label1 = 0;
											static GQuark _tmp111_label2 = 0;
											static GQuark _tmp111_label3 = 0;
											static GQuark _tmp111_label4 = 0;
											static GQuark _tmp111_label5 = 0;
											static GQuark _tmp111_label6 = 0;
											static GQuark _tmp111_label7 = 0;
											if (!_tmp104_) {
												xmlAttr* _tmp105_ = NULL;
												xmlAttr* _tmp106_ = NULL;
												_tmp105_ = xmlattr;
												_tmp106_ = _tmp105_->next;
												xmlattr = _tmp106_;
											}
											_tmp104_ = FALSE;
											_tmp107_ = xmlattr;
											if (!(_tmp107_ != NULL)) {
												break;
											}
											_tmp108_ = xmlattr;
											_tmp109_ = _tmp108_->name;
											_tmp110_ = _tmp109_;
											_tmp112_ = (NULL == _tmp110_) ? 0 : g_quark_from_string (_tmp110_);
											if (_tmp112_ == ((0 != _tmp111_label0) ? _tmp111_label0 : (_tmp111_label0 = g_quark_from_static_string ("type")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp113_ = NULL;
														xmlNode* _tmp114_ = NULL;
														const gchar* _tmp115_ = NULL;
														gchar* _tmp116_ = NULL;
														_tmp113_ = xmlattr;
														_tmp114_ = _tmp113_->children;
														_tmp115_ = _tmp114_->content;
														_tmp116_ = g_strdup (_tmp115_);
														_g_free0 (typeString);
														typeString = _tmp116_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label1) ? _tmp111_label1 : (_tmp111_label1 = g_quark_from_static_string ("xwire")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp117_ = NULL;
														xmlNode* _tmp118_ = NULL;
														const gchar* _tmp119_ = NULL;
														gint _tmp120_ = 0;
														_tmp117_ = xmlattr;
														_tmp118_ = _tmp117_->children;
														_tmp119_ = _tmp118_->content;
														_tmp120_ = atoi (_tmp119_);
														xWire = _tmp120_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label2) ? _tmp111_label2 : (_tmp111_label2 = g_quark_from_static_string ("ywire")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp121_ = NULL;
														xmlNode* _tmp122_ = NULL;
														const gchar* _tmp123_ = NULL;
														gint _tmp124_ = 0;
														_tmp121_ = xmlattr;
														_tmp122_ = _tmp121_->children;
														_tmp123_ = _tmp122_->content;
														_tmp124_ = atoi (_tmp123_);
														yWire = _tmp124_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label3) ? _tmp111_label3 : (_tmp111_label3 = g_quark_from_static_string ("xtag")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp125_ = NULL;
														xmlNode* _tmp126_ = NULL;
														const gchar* _tmp127_ = NULL;
														gint _tmp128_ = 0;
														_tmp125_ = xmlattr;
														_tmp126_ = _tmp125_->children;
														_tmp127_ = _tmp126_->content;
														_tmp128_ = atoi (_tmp127_);
														xTag = _tmp128_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label4) ? _tmp111_label4 : (_tmp111_label4 = g_quark_from_static_string ("ytag")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp129_ = NULL;
														xmlNode* _tmp130_ = NULL;
														const gchar* _tmp131_ = NULL;
														gint _tmp132_ = 0;
														_tmp129_ = xmlattr;
														_tmp130_ = _tmp129_->children;
														_tmp131_ = _tmp130_->content;
														_tmp132_ = atoi (_tmp131_);
														yTag = _tmp132_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label5) ? _tmp111_label5 : (_tmp111_label5 = g_quark_from_static_string ("flow")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp133_ = NULL;
														xmlNode* _tmp134_ = NULL;
														const gchar* _tmp135_ = NULL;
														gchar* _tmp136_ = NULL;
														_tmp133_ = xmlattr;
														_tmp134_ = _tmp133_->children;
														_tmp135_ = _tmp134_->content;
														_tmp136_ = g_strdup (_tmp135_);
														_g_free0 (flowString);
														flowString = _tmp136_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label6) ? _tmp111_label6 : (_tmp111_label6 = g_quark_from_static_string ("pinid")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp137_ = NULL;
														xmlNode* _tmp138_ = NULL;
														const gchar* _tmp139_ = NULL;
														gint _tmp140_ = 0;
														_tmp137_ = xmlattr;
														_tmp138_ = _tmp137_->children;
														_tmp139_ = _tmp138_->content;
														_tmp140_ = atoi (_tmp139_);
														pinid = _tmp140_;
														break;
													}
												}
											} else if (_tmp112_ == ((0 != _tmp111_label7) ? _tmp111_label7 : (_tmp111_label7 = g_quark_from_static_string ("text")))) {
												switch (0) {
													default:
													{
														xmlAttr* _tmp141_ = NULL;
														xmlNode* _tmp142_ = NULL;
														const gchar* _tmp143_ = NULL;
														gchar* _tmp144_ = NULL;
														_tmp141_ = xmlattr;
														_tmp142_ = _tmp141_->children;
														_tmp143_ = _tmp142_->content;
														_tmp144_ = g_strdup (_tmp143_);
														_g_free0 (text);
														text = _tmp144_;
														break;
													}
												}
											}
										}
									}
								}
								_tmp145_ = xWire;
								_tmp146_ = yWire;
								_tmp147_ = xTag;
								_tmp148_ = yTag;
								_tmp149_ = tag_new (_tmp145_, _tmp146_, _tmp147_, _tmp148_);
								_tag_unref0 (newTag);
								newTag = _tmp149_;
								_tmp150_ = flowString;
								_tmp151_ = _tmp150_;
								_tmp153_ = (NULL == _tmp151_) ? 0 : g_quark_from_string (_tmp151_);
								if (_tmp153_ == ((0 != _tmp152_label0) ? _tmp152_label0 : (_tmp152_label0 = g_quark_from_static_string ("in")))) {
									switch (0) {
										default:
										{
											Tag* _tmp154_ = NULL;
											_tmp154_ = newTag;
											_tmp154_->flow = FLOW_IN;
											break;
										}
									}
								} else if (_tmp153_ == ((0 != _tmp152_label1) ? _tmp152_label1 : (_tmp152_label1 = g_quark_from_static_string ("out")))) {
									switch (0) {
										default:
										{
											Tag* _tmp155_ = NULL;
											_tmp155_ = newTag;
											_tmp155_->flow = FLOW_OUT;
											break;
										}
									}
								} else if (_tmp153_ == ((0 != _tmp152_label2) ? _tmp152_label2 : (_tmp152_label2 = g_quark_from_static_string ("bi")))) {
									switch (0) {
										default:
										{
											Tag* _tmp156_ = NULL;
											_tmp156_ = newTag;
											_tmp156_->flow = FLOW_BIDIRECTIONAL;
											break;
										}
									}
								}
								_tmp157_ = typeString;
								_tmp158_ = _tmp157_;
								_tmp160_ = (NULL == _tmp158_) ? 0 : g_quark_from_string (_tmp158_);
								if (_tmp160_ == ((0 != _tmp159_label0) ? _tmp159_label0 : (_tmp159_label0 = g_quark_from_static_string ("interface")))) {
									switch (0) {
										default:
										{
											Tag* _tmp161_ = NULL;
											Tag* _tmp162_ = NULL;
											_tmp161_ = newTag;
											_tmp162_ = _tag_ref0 (_tmp161_);
											_tag_unref0 (self->interfaceTag);
											self->interfaceTag = _tmp162_;
											break;
										}
									}
								}
								_tmp163_ = newTag;
								_tmp164_ = text;
								_tmp165_ = g_strdup (_tmp164_);
								_g_free0 (_tmp163_->text);
								_tmp163_->text = _tmp165_;
								_tmp166_ = newTag;
								_tmp167_ = pinid;
								_tmp166_->pinid = _tmp167_;
								_tag_unref0 (newTag);
								_g_free0 (text);
								_g_free0 (flowString);
								_g_free0 (typeString);
							}
							break;
						}
					}
				}
			}
		}
	}
	return self;
}


WireInst* wire_inst_new_load (xmlNode* xmlnode) {
	return wire_inst_construct_load (TYPE_WIRE_INST, xmlnode);
}


/**
 * Adds a path to the wire.
 */
static gpointer _path_ref0 (gpointer self) {
	return self ? path_ref (self) : NULL;
}


static Path** _vala_array_dup77 (Path** self, int length) {
	Path** result;
	int i;
	result = g_new0 (Path*, length + 1);
	for (i = 0; i < length; i++) {
		Path* _tmp0_ = NULL;
		_tmp0_ = _path_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add96 (Path*** array, int* length, int* size, Path* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Path*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Path** _vala_array_dup78 (Path** self, int length) {
	Path** result;
	int i;
	result = g_new0 (Path*, length + 1);
	for (i = 0; i < length; i++) {
		Path* _tmp0_ = NULL;
		_tmp0_ = _path_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void wire_inst_import_path (WireInst* self, Path* path) {
	Path** newPaths = NULL;
	Path** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Path** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint newPaths_length1 = 0;
	gint _newPaths_size_ = 0;
	Path** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Path* _tmp3_ = NULL;
	Path* _tmp4_ = NULL;
	Path** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Path** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->paths;
	_tmp0__length1 = self->paths_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup77 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	newPaths = _tmp1_;
	newPaths_length1 = _tmp1__length1;
	_newPaths_size_ = newPaths_length1;
	_tmp2_ = newPaths;
	_tmp2__length1 = newPaths_length1;
	_tmp3_ = path;
	_tmp4_ = _path_ref0 (_tmp3_);
	_vala_array_add96 (&newPaths, &newPaths_length1, &_newPaths_size_, _tmp4_);
	_tmp5_ = newPaths;
	_tmp5__length1 = newPaths_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup78 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	self->paths = (_vala_array_free (self->paths, self->paths_length1, (GDestroyNotify) path_unref), NULL);
	self->paths = _tmp6_;
	self->paths_length1 = _tmp6__length1;
	newPaths = (_vala_array_free (newPaths, newPaths_length1, (GDestroyNotify) path_unref), NULL);
}


/**
 * Registers the component //newComponentInst//, which connects with
 * the wire at (//x//, //y//).
 */
static WireInstRegisteredComponent* _vala_array_dup79 (WireInstRegisteredComponent* self, int length) {
	return g_memdup (self, length * sizeof (WireInstRegisteredComponent));
}


static void _vala_array_add97 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstRegisteredComponent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static WireInstRegisteredComponent* _vala_array_dup80 (WireInstRegisteredComponent* self, int length) {
	return g_memdup (self, length * sizeof (WireInstRegisteredComponent));
}


void wire_inst_register_component (WireInst* self, ComponentInst* newComponentInst, gint x, gint y) {
	WireInstRegisteredComponent* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	WireInstRegisteredComponent* newRegisteredComponents = NULL;
	WireInstRegisteredComponent* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	WireInstRegisteredComponent* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gint newRegisteredComponents_length1 = 0;
	gint _newRegisteredComponents_size_ = 0;
	WireInstRegisteredComponent newRegisteredComponent = {0};
	WireInstMarker newMarker = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	Path** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	ComponentInst* _tmp24_ = NULL;
	WireInstMarker _tmp25_ = {0};
	WireInstRegisteredComponent* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	WireInstRegisteredComponent _tmp27_ = {0};
	WireInstRegisteredComponent* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	WireInstRegisteredComponent* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (newComponentInst != NULL);
	_tmp0_ = self->registeredComponents;
	_tmp0__length1 = self->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp0_;
		registeredComponent_collection_length1 = _tmp0__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp0__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstRegisteredComponent _tmp1_ = {0};
				ComponentInst* _tmp2_ = NULL;
				ComponentInst* _tmp3_ = NULL;
				_tmp1_ = registeredComponent;
				_tmp2_ = _tmp1_.componentInst;
				_tmp3_ = newComponentInst;
				if (_tmp2_ == _tmp3_) {
					WireInstMarker marker = {0};
					WireInstRegisteredComponent _tmp4_ = {0};
					WireInstMarker _tmp5_ = {0};
					gboolean _tmp6_ = FALSE;
					WireInstMarker _tmp7_ = {0};
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					_tmp4_ = registeredComponent;
					_tmp5_ = _tmp4_.marker;
					marker = _tmp5_;
					_tmp7_ = marker;
					_tmp8_ = _tmp7_.x;
					_tmp9_ = x;
					if (_tmp8_ == _tmp9_) {
						WireInstMarker _tmp10_ = {0};
						gint _tmp11_ = 0;
						gint _tmp12_ = 0;
						_tmp10_ = marker;
						_tmp11_ = _tmp10_.y;
						_tmp12_ = y;
						_tmp6_ = _tmp11_ == _tmp12_;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						return;
					}
				}
			}
		}
	}
	_tmp13_ = self->registeredComponents;
	_tmp13__length1 = self->registeredComponents_length1;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup79 (_tmp13_, _tmp13__length1) : ((gpointer) _tmp13_);
	_tmp14__length1 = _tmp13__length1;
	newRegisteredComponents = _tmp14_;
	newRegisteredComponents_length1 = _tmp14__length1;
	_newRegisteredComponents_size_ = newRegisteredComponents_length1;
	memset (&newRegisteredComponent, 0, sizeof (WireInstRegisteredComponent));
	memset (&newMarker, 0, sizeof (WireInstMarker));
	_tmp15_ = x;
	newMarker.x = _tmp15_;
	_tmp16_ = y;
	newMarker.y = _tmp16_;
	newMarker.display = FALSE;
	_tmp17_ = self->paths;
	_tmp17__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp17_;
		path_collection_length1 = _tmp17__length1;
		for (path_it = 0; path_it < _tmp17__length1; path_it = path_it + 1) {
			Path* _tmp18_ = NULL;
			Path* path = NULL;
			_tmp18_ = _path_ref0 (path_collection[path_it]);
			path = _tmp18_;
			{
				gint _result_ = 0;
				Path* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				_tmp19_ = path;
				_tmp20_ = x;
				_tmp21_ = y;
				_tmp22_ = path_find (_tmp19_, _tmp20_, _tmp21_);
				_result_ = _tmp22_;
				_tmp23_ = _result_;
				if (_tmp23_ == 1) {
					newMarker.display = TRUE;
				}
				_path_unref0 (path);
			}
		}
	}
	_tmp24_ = newComponentInst;
	newRegisteredComponent.componentInst = _tmp24_;
	_tmp25_ = newMarker;
	newRegisteredComponent.marker = _tmp25_;
	_tmp26_ = newRegisteredComponents;
	_tmp26__length1 = newRegisteredComponents_length1;
	_tmp27_ = newRegisteredComponent;
	_vala_array_add97 (&newRegisteredComponents, &newRegisteredComponents_length1, &_newRegisteredComponents_size_, &_tmp27_);
	_tmp28_ = newRegisteredComponents;
	_tmp28__length1 = newRegisteredComponents_length1;
	_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup80 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
	_tmp29__length1 = _tmp28__length1;
	self->registeredComponents = (g_free (self->registeredComponents), NULL);
	self->registeredComponents = _tmp29_;
	self->registeredComponents_length1 = _tmp29__length1;
	newRegisteredComponents = (g_free (newRegisteredComponents), NULL);
}


/**
 * Unregisters all connections to component //oldComponentInst//.
 */
static void _vala_array_add98 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstRegisteredComponent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static WireInstRegisteredComponent* _vala_array_dup81 (WireInstRegisteredComponent* self, int length) {
	return g_memdup (self, length * sizeof (WireInstRegisteredComponent));
}


void wire_inst_unregister_component (WireInst* self, ComponentInst* oldComponentInst) {
	WireInstRegisteredComponent* newRegisteredComponents = NULL;
	WireInstRegisteredComponent* _tmp0_ = NULL;
	gint newRegisteredComponents_length1 = 0;
	gint _newRegisteredComponents_size_ = 0;
	WireInstRegisteredComponent* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	WireInstRegisteredComponent* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	WireInstRegisteredComponent* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (oldComponentInst != NULL);
	_tmp0_ = g_new0 (WireInstRegisteredComponent, 0);
	newRegisteredComponents = _tmp0_;
	newRegisteredComponents_length1 = 0;
	_newRegisteredComponents_size_ = newRegisteredComponents_length1;
	_tmp1_ = self->registeredComponents;
	_tmp1__length1 = self->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp1_;
		registeredComponent_collection_length1 = _tmp1__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp1__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstRegisteredComponent _tmp2_ = {0};
				ComponentInst* _tmp3_ = NULL;
				ComponentInst* _tmp4_ = NULL;
				_tmp2_ = registeredComponent;
				_tmp3_ = _tmp2_.componentInst;
				_tmp4_ = oldComponentInst;
				if (_tmp3_ != _tmp4_) {
					WireInstRegisteredComponent* _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					WireInstRegisteredComponent _tmp6_ = {0};
					_tmp5_ = newRegisteredComponents;
					_tmp5__length1 = newRegisteredComponents_length1;
					_tmp6_ = registeredComponent;
					_vala_array_add98 (&newRegisteredComponents, &newRegisteredComponents_length1, &_newRegisteredComponents_size_, &_tmp6_);
				}
			}
		}
	}
	_tmp7_ = newRegisteredComponents;
	_tmp7__length1 = newRegisteredComponents_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup81 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	self->registeredComponents = (g_free (self->registeredComponents), NULL);
	self->registeredComponents = _tmp8_;
	self->registeredComponents_length1 = _tmp8__length1;
	newRegisteredComponents = (g_free (newRegisteredComponents), NULL);
}


/**
 * Unregisters the connection to the component //oldComponentInst//
 * which is at (//x//, //y//).
 */
static void _vala_array_add99 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstRegisteredComponent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static WireInstRegisteredComponent* _vala_array_dup82 (WireInstRegisteredComponent* self, int length) {
	return g_memdup (self, length * sizeof (WireInstRegisteredComponent));
}


void wire_inst_unregister_component_xy (WireInst* self, ComponentInst* oldComponentInst, gint x, gint y) {
	WireInstRegisteredComponent* newRegisteredComponents = NULL;
	WireInstRegisteredComponent* _tmp0_ = NULL;
	gint newRegisteredComponents_length1 = 0;
	gint _newRegisteredComponents_size_ = 0;
	WireInstRegisteredComponent* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	WireInstRegisteredComponent* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	WireInstRegisteredComponent* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (oldComponentInst != NULL);
	_tmp0_ = g_new0 (WireInstRegisteredComponent, 0);
	newRegisteredComponents = _tmp0_;
	newRegisteredComponents_length1 = 0;
	_newRegisteredComponents_size_ = newRegisteredComponents_length1;
	_tmp1_ = self->registeredComponents;
	_tmp1__length1 = self->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp1_;
		registeredComponent_collection_length1 = _tmp1__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp1__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstMarker marker = {0};
				WireInstRegisteredComponent _tmp2_ = {0};
				WireInstMarker _tmp3_ = {0};
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				WireInstRegisteredComponent _tmp6_ = {0};
				ComponentInst* _tmp7_ = NULL;
				ComponentInst* _tmp8_ = NULL;
				_tmp2_ = registeredComponent;
				_tmp3_ = _tmp2_.marker;
				marker = _tmp3_;
				_tmp6_ = registeredComponent;
				_tmp7_ = _tmp6_.componentInst;
				_tmp8_ = oldComponentInst;
				if (_tmp7_ != _tmp8_) {
					_tmp5_ = TRUE;
				} else {
					WireInstMarker _tmp9_ = {0};
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					_tmp9_ = marker;
					_tmp10_ = _tmp9_.x;
					_tmp11_ = x;
					_tmp5_ = _tmp10_ != _tmp11_;
				}
				if (_tmp5_) {
					_tmp4_ = TRUE;
				} else {
					WireInstMarker _tmp12_ = {0};
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					_tmp12_ = marker;
					_tmp13_ = _tmp12_.y;
					_tmp14_ = y;
					_tmp4_ = _tmp13_ != _tmp14_;
				}
				if (_tmp4_) {
					WireInstRegisteredComponent* _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					WireInstRegisteredComponent _tmp16_ = {0};
					_tmp15_ = newRegisteredComponents;
					_tmp15__length1 = newRegisteredComponents_length1;
					_tmp16_ = registeredComponent;
					_vala_array_add99 (&newRegisteredComponents, &newRegisteredComponents_length1, &_newRegisteredComponents_size_, &_tmp16_);
				}
			}
		}
	}
	_tmp17_ = newRegisteredComponents;
	_tmp17__length1 = newRegisteredComponents_length1;
	_tmp18_ = (_tmp17_ != NULL) ? _vala_array_dup82 (_tmp17_, _tmp17__length1) : ((gpointer) _tmp17_);
	_tmp18__length1 = _tmp17__length1;
	self->registeredComponents = (g_free (self->registeredComponents), NULL);
	self->registeredComponents = _tmp18_;
	self->registeredComponents_length1 = _tmp18__length1;
	newRegisteredComponents = (g_free (newRegisteredComponents), NULL);
}


/**
 * Disconnects from all components. Calls all diconnecting
 * components to lose their connection to the wire.
 */
void wire_inst_disconnect_components (WireInst* self) {
	WireInstRegisteredComponent* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	WireInstRegisteredComponent* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->registeredComponents;
	_tmp0__length1 = self->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp0_;
		registeredComponent_collection_length1 = _tmp0__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp0__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstRegisteredComponent _tmp1_ = {0};
				ComponentInst* _tmp2_ = NULL;
				_tmp1_ = registeredComponent;
				_tmp2_ = _tmp1_.componentInst;
				component_inst_disconnect_wire (_tmp2_, self, FALSE);
			}
		}
	}
	_tmp3_ = g_new0 (WireInstRegisteredComponent, 0);
	self->registeredComponents = (g_free (self->registeredComponents), NULL);
	self->registeredComponents = _tmp3_;
	self->registeredComponents_length1 = 0;
}


/**
 * Merges the data of the WireInst //sourceWireInst// into this
 * WireInst. Paths and connections will be merged, and the interface
 * tag of this component will take priority when merging.
 */
static Path** _vala_array_dup83 (Path** self, int length) {
	Path** result;
	int i;
	result = g_new0 (Path*, length + 1);
	for (i = 0; i < length; i++) {
		Path* _tmp0_ = NULL;
		_tmp0_ = _path_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static WireInstMarker* _vala_array_dup84 (WireInstMarker* self, int length) {
	return g_memdup (self, length * sizeof (WireInstMarker));
}


static WireInstRegisteredComponent* _vala_array_dup85 (WireInstRegisteredComponent* self, int length) {
	return g_memdup (self, length * sizeof (WireInstRegisteredComponent));
}


static void _vala_array_add100 (Path*** array, int* length, int* size, Path* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Path*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add101 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstMarker, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add102 (WireInstRegisteredComponent** array, int* length, int* size, const WireInstRegisteredComponent* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstRegisteredComponent, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static Path** _vala_array_dup86 (Path** self, int length) {
	Path** result;
	int i;
	result = g_new0 (Path*, length + 1);
	for (i = 0; i < length; i++) {
		Path* _tmp0_ = NULL;
		_tmp0_ = _path_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static WireInstMarker* _vala_array_dup87 (WireInstMarker* self, int length) {
	return g_memdup (self, length * sizeof (WireInstMarker));
}


static WireInstRegisteredComponent* _vala_array_dup88 (WireInstRegisteredComponent* self, int length) {
	return g_memdup (self, length * sizeof (WireInstRegisteredComponent));
}


void wire_inst_merge (WireInst* self, WireInst* sourceWireInst) {
	Path** newPaths = NULL;
	Path** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	Path** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint newPaths_length1 = 0;
	gint _newPaths_size_ = 0;
	WireInstMarker* newMarkers = NULL;
	WireInstMarker* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	WireInstMarker* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint newMarkers_length1 = 0;
	gint _newMarkers_size_ = 0;
	WireInstRegisteredComponent* newRegisteredComponents = NULL;
	WireInstRegisteredComponent* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	WireInstRegisteredComponent* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint newRegisteredComponents_length1 = 0;
	gint _newRegisteredComponents_size_ = 0;
	WireInst* _tmp6_ = NULL;
	Path** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	WireInst* _tmp15_ = NULL;
	WireInstMarker* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	WireInst* _tmp19_ = NULL;
	WireInstRegisteredComponent* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	Path** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	Path** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	WireInstMarker* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	WireInstMarker* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	WireInstRegisteredComponent* _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	WireInstRegisteredComponent* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	Tag* _tmp32_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sourceWireInst != NULL);
	_tmp0_ = self->paths;
	_tmp0__length1 = self->paths_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup83 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	newPaths = _tmp1_;
	newPaths_length1 = _tmp1__length1;
	_newPaths_size_ = newPaths_length1;
	_tmp2_ = self->markers;
	_tmp2__length1 = self->markers_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup84 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	newMarkers = _tmp3_;
	newMarkers_length1 = _tmp3__length1;
	_newMarkers_size_ = newMarkers_length1;
	_tmp4_ = self->registeredComponents;
	_tmp4__length1 = self->registeredComponents_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup85 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	newRegisteredComponents = _tmp5_;
	newRegisteredComponents_length1 = _tmp5__length1;
	_newRegisteredComponents_size_ = newRegisteredComponents_length1;
	_tmp6_ = sourceWireInst;
	_tmp7_ = _tmp6_->paths;
	_tmp7__length1 = _tmp6_->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp7_;
		path_collection_length1 = _tmp7__length1;
		for (path_it = 0; path_it < _tmp7__length1; path_it = path_it + 1) {
			Path* _tmp8_ = NULL;
			Path* path = NULL;
			_tmp8_ = _path_ref0 (path_collection[path_it]);
			path = _tmp8_;
			{
				Path* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = path;
				_tmp10_ = wire_inst_try_merge_paths (self, _tmp9_);
				if (!_tmp10_) {
					Path** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					Path* _tmp12_ = NULL;
					Path* _tmp13_ = NULL;
					_tmp11_ = newPaths;
					_tmp11__length1 = newPaths_length1;
					_tmp12_ = path;
					_tmp13_ = _path_ref0 (_tmp12_);
					_vala_array_add100 (&newPaths, &newPaths_length1, &_newPaths_size_, _tmp13_);
				} else {
					FILE* _tmp14_ = NULL;
					_tmp14_ = stdout;
					fprintf (_tmp14_, "Merged Paths\n");
				}
				_path_unref0 (path);
			}
		}
	}
	_tmp15_ = sourceWireInst;
	_tmp16_ = _tmp15_->markers;
	_tmp16__length1 = _tmp15_->markers_length1;
	{
		WireInstMarker* marker_collection = NULL;
		gint marker_collection_length1 = 0;
		gint _marker_collection_size_ = 0;
		gint marker_it = 0;
		marker_collection = _tmp16_;
		marker_collection_length1 = _tmp16__length1;
		for (marker_it = 0; marker_it < _tmp16__length1; marker_it = marker_it + 1) {
			WireInstMarker marker = {0};
			marker = marker_collection[marker_it];
			{
				WireInstMarker* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				WireInstMarker _tmp18_ = {0};
				_tmp17_ = newMarkers;
				_tmp17__length1 = newMarkers_length1;
				_tmp18_ = marker;
				_vala_array_add101 (&newMarkers, &newMarkers_length1, &_newMarkers_size_, &_tmp18_);
			}
		}
	}
	_tmp19_ = sourceWireInst;
	_tmp20_ = _tmp19_->registeredComponents;
	_tmp20__length1 = _tmp19_->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp20_;
		registeredComponent_collection_length1 = _tmp20__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp20__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstRegisteredComponent _tmp21_ = {0};
				ComponentInst* _tmp22_ = NULL;
				WireInst* _tmp23_ = NULL;
				WireInstRegisteredComponent* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				WireInstRegisteredComponent _tmp25_ = {0};
				_tmp21_ = registeredComponent;
				_tmp22_ = _tmp21_.componentInst;
				_tmp23_ = sourceWireInst;
				component_inst_change_wire (_tmp22_, _tmp23_, self);
				_tmp24_ = newRegisteredComponents;
				_tmp24__length1 = newRegisteredComponents_length1;
				_tmp25_ = registeredComponent;
				_vala_array_add102 (&newRegisteredComponents, &newRegisteredComponents_length1, &_newRegisteredComponents_size_, &_tmp25_);
			}
		}
	}
	_tmp26_ = newPaths;
	_tmp26__length1 = newPaths_length1;
	_tmp27_ = (_tmp26_ != NULL) ? _vala_array_dup86 (_tmp26_, _tmp26__length1) : ((gpointer) _tmp26_);
	_tmp27__length1 = _tmp26__length1;
	self->paths = (_vala_array_free (self->paths, self->paths_length1, (GDestroyNotify) path_unref), NULL);
	self->paths = _tmp27_;
	self->paths_length1 = _tmp27__length1;
	_tmp28_ = newMarkers;
	_tmp28__length1 = newMarkers_length1;
	_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup87 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
	_tmp29__length1 = _tmp28__length1;
	self->markers = (g_free (self->markers), NULL);
	self->markers = _tmp29_;
	self->markers_length1 = _tmp29__length1;
	_tmp30_ = newRegisteredComponents;
	_tmp30__length1 = newRegisteredComponents_length1;
	_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup88 (_tmp30_, _tmp30__length1) : ((gpointer) _tmp30_);
	_tmp31__length1 = _tmp30__length1;
	self->registeredComponents = (g_free (self->registeredComponents), NULL);
	self->registeredComponents = _tmp31_;
	self->registeredComponents_length1 = _tmp31__length1;
	_tmp32_ = self->interfaceTag;
	if (_tmp32_ == NULL) {
		WireInst* _tmp33_ = NULL;
		Tag* _tmp34_ = NULL;
		Tag* _tmp35_ = NULL;
		_tmp33_ = sourceWireInst;
		_tmp34_ = _tmp33_->interfaceTag;
		_tmp35_ = _tag_ref0 (_tmp34_);
		_tag_unref0 (self->interfaceTag);
		self->interfaceTag = _tmp35_;
	}
	newRegisteredComponents = (g_free (newRegisteredComponents), NULL);
	newMarkers = (g_free (newMarkers), NULL);
	newPaths = (_vala_array_free (newPaths, newPaths_length1, (GDestroyNotify) path_unref), NULL);
}


/**
 * Splits the up a wire at the binding point (//x//, //y//).
 * The new WireInsts created are returned in an array.
 * Paths and connections are reassigned based on where they are.
 * Components are updated to reference the new wires.
 */
static void _vala_array_add103 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstMarker, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


static void _vala_array_add104 (WireInst*** array, int* length, int* size, WireInst* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInst*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add105 (Path*** array, int* length, int* size, Path* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Path*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add106 (Path*** array, int* length, int* size, Path* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Path*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Path** _vala_array_dup89 (Path** self, int length) {
	Path** result;
	int i;
	result = g_new0 (Path*, length + 1);
	for (i = 0; i < length; i++) {
		Path* _tmp0_ = NULL;
		_tmp0_ = _path_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add107 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstMarker, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static WireInstMarker* _vala_array_dup90 (WireInstMarker* self, int length) {
	return g_memdup (self, length * sizeof (WireInstMarker));
}


static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


WireInst** wire_inst_unmerge (WireInst* self, gint x, gint y, int* result_length1) {
	WireInst** result = NULL;
	gboolean foundMarker = FALSE;
	WireInstMarker unmergeMarker = {0};
	WireInst** wireInsts = NULL;
	WireInst** _tmp0_ = NULL;
	gint wireInsts_length1 = 0;
	gint _wireInsts_size_ = 0;
	Path** availablePaths = NULL;
	Path** _tmp1_ = NULL;
	gint availablePaths_length1 = 0;
	gint _availablePaths_size_ = 0;
	WireInstMarker* availableMarkers = NULL;
	WireInstMarker* _tmp2_ = NULL;
	gint availableMarkers_length1 = 0;
	gint _availableMarkers_size_ = 0;
	WireInstMarker* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gboolean _tmp14_ = FALSE;
	Path** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gboolean keepGoing = FALSE;
	WireInstRegisteredComponent* _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	Tag* _tmp96_ = NULL;
	WireInst** _tmp110_ = NULL;
	gint _tmp110__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	foundMarker = FALSE;
	memset (&unmergeMarker, 0, sizeof (WireInstMarker));
	_tmp0_ = g_new0 (WireInst*, 0 + 1);
	wireInsts = _tmp0_;
	wireInsts_length1 = 0;
	_wireInsts_size_ = wireInsts_length1;
	_tmp1_ = g_new0 (Path*, 0 + 1);
	availablePaths = _tmp1_;
	availablePaths_length1 = 0;
	_availablePaths_size_ = availablePaths_length1;
	_tmp2_ = g_new0 (WireInstMarker, 0);
	availableMarkers = _tmp2_;
	availableMarkers_length1 = 0;
	_availableMarkers_size_ = availableMarkers_length1;
	_tmp3_ = self->markers;
	_tmp3__length1 = self->markers_length1;
	{
		WireInstMarker* marker_collection = NULL;
		gint marker_collection_length1 = 0;
		gint _marker_collection_size_ = 0;
		gint marker_it = 0;
		marker_collection = _tmp3_;
		marker_collection_length1 = _tmp3__length1;
		for (marker_it = 0; marker_it < _tmp3__length1; marker_it = marker_it + 1) {
			WireInstMarker marker = {0};
			marker = marker_collection[marker_it];
			{
				gboolean _tmp4_ = FALSE;
				WireInstMarker _tmp5_ = {0};
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				_tmp5_ = marker;
				_tmp6_ = _tmp5_.x;
				_tmp7_ = x;
				if (_tmp6_ == _tmp7_) {
					WireInstMarker _tmp8_ = {0};
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					_tmp8_ = marker;
					_tmp9_ = _tmp8_.y;
					_tmp10_ = y;
					_tmp4_ = _tmp9_ == _tmp10_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					WireInstMarker _tmp11_ = {0};
					_tmp11_ = marker;
					unmergeMarker = _tmp11_;
					foundMarker = TRUE;
				} else {
					WireInstMarker* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					WireInstMarker _tmp13_ = {0};
					_tmp12_ = availableMarkers;
					_tmp12__length1 = availableMarkers_length1;
					_tmp13_ = marker;
					_vala_array_add103 (&availableMarkers, &availableMarkers_length1, &_availableMarkers_size_, &_tmp13_);
				}
			}
		}
	}
	_tmp14_ = foundMarker;
	if (!_tmp14_) {
		WireInst* _tmp15_ = NULL;
		WireInst** _tmp16_ = NULL;
		WireInst** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		_tmp15_ = _wire_inst_ref0 (self);
		_tmp16_ = g_new0 (WireInst*, 1 + 1);
		_tmp16_[0] = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp17__length1;
		}
		result = _tmp17_;
		availableMarkers = (g_free (availableMarkers), NULL);
		availablePaths = (_vala_array_free (availablePaths, availablePaths_length1, (GDestroyNotify) path_unref), NULL);
		wireInsts = (_vala_array_free (wireInsts, wireInsts_length1, (GDestroyNotify) wire_inst_unref), NULL);
		return result;
	}
	_tmp18_ = self->paths;
	_tmp18__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp18_;
		path_collection_length1 = _tmp18__length1;
		for (path_it = 0; path_it < _tmp18__length1; path_it = path_it + 1) {
			Path* _tmp19_ = NULL;
			Path* path = NULL;
			_tmp19_ = _path_ref0 (path_collection[path_it]);
			path = _tmp19_;
			{
				Path* _tmp20_ = NULL;
				WireInstMarker _tmp21_ = {0};
				gint _tmp22_ = 0;
				WireInstMarker _tmp23_ = {0};
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				_tmp20_ = path;
				_tmp21_ = unmergeMarker;
				_tmp22_ = _tmp21_.x;
				_tmp23_ = unmergeMarker;
				_tmp24_ = _tmp23_.y;
				_tmp25_ = path_find (_tmp20_, _tmp22_, _tmp24_);
				if (_tmp25_ != 0) {
					WireInst* wireInst = NULL;
					WireInst* _tmp26_ = NULL;
					WireInst* _tmp27_ = NULL;
					Path* _tmp28_ = NULL;
					WireInst** _tmp29_ = NULL;
					gint _tmp29__length1 = 0;
					WireInst* _tmp30_ = NULL;
					WireInst* _tmp31_ = NULL;
					_tmp26_ = wire_inst_new ();
					wireInst = _tmp26_;
					_tmp27_ = wireInst;
					_tmp28_ = path;
					wire_inst_import_path (_tmp27_, _tmp28_);
					_tmp29_ = wireInsts;
					_tmp29__length1 = wireInsts_length1;
					_tmp30_ = wireInst;
					_tmp31_ = _wire_inst_ref0 (_tmp30_);
					_vala_array_add104 (&wireInsts, &wireInsts_length1, &_wireInsts_size_, _tmp31_);
					_wire_inst_unref0 (wireInst);
				} else {
					Path** _tmp32_ = NULL;
					gint _tmp32__length1 = 0;
					Path* _tmp33_ = NULL;
					Path* _tmp34_ = NULL;
					_tmp32_ = availablePaths;
					_tmp32__length1 = availablePaths_length1;
					_tmp33_ = path;
					_tmp34_ = _path_ref0 (_tmp33_);
					_vala_array_add105 (&availablePaths, &availablePaths_length1, &_availablePaths_size_, _tmp34_);
				}
				_path_unref0 (path);
			}
		}
	}
	keepGoing = TRUE;
	while (TRUE) {
		gboolean _tmp35_ = FALSE;
		WireInst** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		_tmp35_ = keepGoing;
		if (!_tmp35_) {
			break;
		}
		keepGoing = FALSE;
		_tmp36_ = wireInsts;
		_tmp36__length1 = wireInsts_length1;
		{
			WireInst** wireInst_collection = NULL;
			gint wireInst_collection_length1 = 0;
			gint _wireInst_collection_size_ = 0;
			gint wireInst_it = 0;
			wireInst_collection = _tmp36_;
			wireInst_collection_length1 = _tmp36__length1;
			for (wireInst_it = 0; wireInst_it < _tmp36__length1; wireInst_it = wireInst_it + 1) {
				WireInst* _tmp37_ = NULL;
				WireInst* wireInst = NULL;
				_tmp37_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
				wireInst = _tmp37_;
				{
					WireInstMarker* newAvailableMarkers = NULL;
					WireInstMarker* _tmp38_ = NULL;
					gint newAvailableMarkers_length1 = 0;
					gint _newAvailableMarkers_size_ = 0;
					WireInstMarker* _tmp39_ = NULL;
					gint _tmp39__length1 = 0;
					WireInstMarker* _tmp71_ = NULL;
					gint _tmp71__length1 = 0;
					WireInstMarker* _tmp72_ = NULL;
					gint _tmp72__length1 = 0;
					_tmp38_ = g_new0 (WireInstMarker, 0);
					newAvailableMarkers = _tmp38_;
					newAvailableMarkers_length1 = 0;
					_newAvailableMarkers_size_ = newAvailableMarkers_length1;
					_tmp39_ = availableMarkers;
					_tmp39__length1 = availableMarkers_length1;
					{
						WireInstMarker* marker_collection = NULL;
						gint marker_collection_length1 = 0;
						gint _marker_collection_size_ = 0;
						gint marker_it = 0;
						marker_collection = _tmp39_;
						marker_collection_length1 = _tmp39__length1;
						for (marker_it = 0; marker_it < _tmp39__length1; marker_it = marker_it + 1) {
							WireInstMarker marker = {0};
							marker = marker_collection[marker_it];
							{
								WireInst* _tmp40_ = NULL;
								WireInstMarker _tmp41_ = {0};
								gint _tmp42_ = 0;
								WireInstMarker _tmp43_ = {0};
								gint _tmp44_ = 0;
								Path* _tmp45_ = NULL;
								Path* _tmp46_ = NULL;
								gboolean _tmp47_ = FALSE;
								_tmp40_ = wireInst;
								_tmp41_ = marker;
								_tmp42_ = _tmp41_.x;
								_tmp43_ = marker;
								_tmp44_ = _tmp43_.y;
								_tmp45_ = wire_inst_find (_tmp40_, _tmp42_, _tmp44_);
								_tmp46_ = _tmp45_;
								_tmp47_ = _tmp46_ != NULL;
								_path_unref0 (_tmp46_);
								if (_tmp47_) {
									Path** newAvailablePaths = NULL;
									Path** _tmp48_ = NULL;
									gint newAvailablePaths_length1 = 0;
									gint _newAvailablePaths_size_ = 0;
									Path** _tmp49_ = NULL;
									gint _tmp49__length1 = 0;
									WireInst* _tmp62_ = NULL;
									WireInstMarker _tmp63_ = {0};
									gint _tmp64_ = 0;
									WireInstMarker _tmp65_ = {0};
									gint _tmp66_ = 0;
									Path** _tmp67_ = NULL;
									gint _tmp67__length1 = 0;
									Path** _tmp68_ = NULL;
									gint _tmp68__length1 = 0;
									_tmp48_ = g_new0 (Path*, 0 + 1);
									newAvailablePaths = _tmp48_;
									newAvailablePaths_length1 = 0;
									_newAvailablePaths_size_ = newAvailablePaths_length1;
									_tmp49_ = availablePaths;
									_tmp49__length1 = availablePaths_length1;
									{
										Path** path_collection = NULL;
										gint path_collection_length1 = 0;
										gint _path_collection_size_ = 0;
										gint path_it = 0;
										path_collection = _tmp49_;
										path_collection_length1 = _tmp49__length1;
										for (path_it = 0; path_it < _tmp49__length1; path_it = path_it + 1) {
											Path* _tmp50_ = NULL;
											Path* path = NULL;
											_tmp50_ = _path_ref0 (path_collection[path_it]);
											path = _tmp50_;
											{
												Path* _tmp51_ = NULL;
												WireInstMarker _tmp52_ = {0};
												gint _tmp53_ = 0;
												WireInstMarker _tmp54_ = {0};
												gint _tmp55_ = 0;
												gint _tmp56_ = 0;
												_tmp51_ = path;
												_tmp52_ = marker;
												_tmp53_ = _tmp52_.x;
												_tmp54_ = marker;
												_tmp55_ = _tmp54_.y;
												_tmp56_ = path_find (_tmp51_, _tmp53_, _tmp55_);
												if (_tmp56_ != 0) {
													WireInst* _tmp57_ = NULL;
													Path* _tmp58_ = NULL;
													_tmp57_ = wireInst;
													_tmp58_ = path;
													wire_inst_import_path (_tmp57_, _tmp58_);
													keepGoing = TRUE;
												} else {
													Path** _tmp59_ = NULL;
													gint _tmp59__length1 = 0;
													Path* _tmp60_ = NULL;
													Path* _tmp61_ = NULL;
													_tmp59_ = newAvailablePaths;
													_tmp59__length1 = newAvailablePaths_length1;
													_tmp60_ = path;
													_tmp61_ = _path_ref0 (_tmp60_);
													_vala_array_add106 (&newAvailablePaths, &newAvailablePaths_length1, &_newAvailablePaths_size_, _tmp61_);
												}
												_path_unref0 (path);
											}
										}
									}
									_tmp62_ = wireInst;
									_tmp63_ = marker;
									_tmp64_ = _tmp63_.x;
									_tmp65_ = marker;
									_tmp66_ = _tmp65_.y;
									wire_inst_mark (_tmp62_, _tmp64_, _tmp66_);
									_tmp67_ = newAvailablePaths;
									_tmp67__length1 = newAvailablePaths_length1;
									_tmp68_ = (_tmp67_ != NULL) ? _vala_array_dup89 (_tmp67_, _tmp67__length1) : ((gpointer) _tmp67_);
									_tmp68__length1 = _tmp67__length1;
									availablePaths = (_vala_array_free (availablePaths, availablePaths_length1, (GDestroyNotify) path_unref), NULL);
									availablePaths = _tmp68_;
									availablePaths_length1 = _tmp68__length1;
									_availablePaths_size_ = availablePaths_length1;
									newAvailablePaths = (_vala_array_free (newAvailablePaths, newAvailablePaths_length1, (GDestroyNotify) path_unref), NULL);
								} else {
									WireInstMarker* _tmp69_ = NULL;
									gint _tmp69__length1 = 0;
									WireInstMarker _tmp70_ = {0};
									_tmp69_ = newAvailableMarkers;
									_tmp69__length1 = newAvailableMarkers_length1;
									_tmp70_ = marker;
									_vala_array_add107 (&newAvailableMarkers, &newAvailableMarkers_length1, &_newAvailableMarkers_size_, &_tmp70_);
								}
							}
						}
					}
					_tmp71_ = newAvailableMarkers;
					_tmp71__length1 = newAvailableMarkers_length1;
					_tmp72_ = (_tmp71_ != NULL) ? _vala_array_dup90 (_tmp71_, _tmp71__length1) : ((gpointer) _tmp71_);
					_tmp72__length1 = _tmp71__length1;
					availableMarkers = (g_free (availableMarkers), NULL);
					availableMarkers = _tmp72_;
					availableMarkers_length1 = _tmp72__length1;
					_availableMarkers_size_ = availableMarkers_length1;
					newAvailableMarkers = (g_free (newAvailableMarkers), NULL);
					_wire_inst_unref0 (wireInst);
				}
			}
		}
	}
	_tmp73_ = self->registeredComponents;
	_tmp73__length1 = self->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp73_;
		registeredComponent_collection_length1 = _tmp73__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp73__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstMarker marker = {0};
				WireInstRegisteredComponent _tmp74_ = {0};
				WireInstMarker _tmp75_ = {0};
				ComponentInst* componentInst = NULL;
				WireInstRegisteredComponent _tmp76_ = {0};
				ComponentInst* _tmp77_ = NULL;
				ComponentInst* _tmp78_ = NULL;
				ComponentInst* _tmp79_ = NULL;
				WireInst** _tmp80_ = NULL;
				gint _tmp80__length1 = 0;
				_tmp74_ = registeredComponent;
				_tmp75_ = _tmp74_.marker;
				marker = _tmp75_;
				_tmp76_ = registeredComponent;
				_tmp77_ = _tmp76_.componentInst;
				_tmp78_ = _component_inst_ref0 (_tmp77_);
				componentInst = _tmp78_;
				_tmp79_ = componentInst;
				component_inst_disconnect_wire (_tmp79_, self, FALSE);
				_tmp80_ = wireInsts;
				_tmp80__length1 = wireInsts_length1;
				{
					WireInst** wireInst_collection = NULL;
					gint wireInst_collection_length1 = 0;
					gint _wireInst_collection_size_ = 0;
					gint wireInst_it = 0;
					wireInst_collection = _tmp80_;
					wireInst_collection_length1 = _tmp80__length1;
					for (wireInst_it = 0; wireInst_it < _tmp80__length1; wireInst_it = wireInst_it + 1) {
						WireInst* _tmp81_ = NULL;
						WireInst* wireInst = NULL;
						_tmp81_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
						wireInst = _tmp81_;
						{
							WireInst* _tmp82_ = NULL;
							WireInstMarker _tmp83_ = {0};
							gint _tmp84_ = 0;
							WireInstMarker _tmp85_ = {0};
							gint _tmp86_ = 0;
							Path* _tmp87_ = NULL;
							Path* _tmp88_ = NULL;
							gboolean _tmp89_ = FALSE;
							_tmp82_ = wireInst;
							_tmp83_ = marker;
							_tmp84_ = _tmp83_.x;
							_tmp85_ = marker;
							_tmp86_ = _tmp85_.y;
							_tmp87_ = wire_inst_find (_tmp82_, _tmp84_, _tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = _tmp88_ != NULL;
							_path_unref0 (_tmp88_);
							if (_tmp89_) {
								ComponentInst* _tmp90_ = NULL;
								WireInstMarker _tmp91_ = {0};
								gint _tmp92_ = 0;
								WireInstMarker _tmp93_ = {0};
								gint _tmp94_ = 0;
								WireInst* _tmp95_ = NULL;
								_tmp90_ = componentInst;
								_tmp91_ = marker;
								_tmp92_ = _tmp91_.x;
								_tmp93_ = marker;
								_tmp94_ = _tmp93_.y;
								_tmp95_ = wireInst;
								component_inst_try_connect (_tmp90_, _tmp92_, _tmp94_, _tmp95_);
							}
							_wire_inst_unref0 (wireInst);
						}
					}
				}
				_component_inst_unref0 (componentInst);
			}
		}
	}
	_tmp96_ = self->interfaceTag;
	if (_tmp96_ != NULL) {
		WireInst** _tmp97_ = NULL;
		gint _tmp97__length1 = 0;
		_tmp97_ = wireInsts;
		_tmp97__length1 = wireInsts_length1;
		{
			WireInst** wireInst_collection = NULL;
			gint wireInst_collection_length1 = 0;
			gint _wireInst_collection_size_ = 0;
			gint wireInst_it = 0;
			wireInst_collection = _tmp97_;
			wireInst_collection_length1 = _tmp97__length1;
			for (wireInst_it = 0; wireInst_it < _tmp97__length1; wireInst_it = wireInst_it + 1) {
				WireInst* _tmp98_ = NULL;
				WireInst* wireInst = NULL;
				_tmp98_ = _wire_inst_ref0 (wireInst_collection[wireInst_it]);
				wireInst = _tmp98_;
				{
					WireInst* _tmp99_ = NULL;
					Tag* _tmp100_ = NULL;
					gint _tmp101_ = 0;
					Tag* _tmp102_ = NULL;
					gint _tmp103_ = 0;
					Path* _tmp104_ = NULL;
					Path* _tmp105_ = NULL;
					gboolean _tmp106_ = FALSE;
					_tmp99_ = wireInst;
					_tmp100_ = self->interfaceTag;
					_tmp101_ = _tmp100_->xWire;
					_tmp102_ = self->interfaceTag;
					_tmp103_ = _tmp102_->yWire;
					_tmp104_ = wire_inst_find (_tmp99_, _tmp101_, _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = _tmp105_ != NULL;
					_path_unref0 (_tmp105_);
					if (_tmp106_) {
						WireInst* _tmp107_ = NULL;
						Tag* _tmp108_ = NULL;
						Tag* _tmp109_ = NULL;
						_tmp107_ = wireInst;
						_tmp108_ = self->interfaceTag;
						_tmp109_ = _tag_ref0 (_tmp108_);
						_tag_unref0 (_tmp107_->interfaceTag);
						_tmp107_->interfaceTag = _tmp109_;
						_wire_inst_unref0 (wireInst);
						break;
					}
					_wire_inst_unref0 (wireInst);
				}
			}
		}
	}
	_tmp110_ = wireInsts;
	_tmp110__length1 = wireInsts_length1;
	if (result_length1) {
		*result_length1 = _tmp110__length1;
	}
	result = _tmp110_;
	availableMarkers = (g_free (availableMarkers), NULL);
	availablePaths = (_vala_array_free (availablePaths, availablePaths_length1, (GDestroyNotify) path_unref), NULL);
	return result;
}


/**
 * Creates a marker at the point (//x//, //y//).
 */
static WireInstMarker* _vala_array_dup91 (WireInstMarker* self, int length) {
	return g_memdup (self, length * sizeof (WireInstMarker));
}


static void _vala_array_add108 (WireInstMarker** array, int* length, int* size, const WireInstMarker* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireInstMarker, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static WireInstMarker* _vala_array_dup92 (WireInstMarker* self, int length) {
	return g_memdup (self, length * sizeof (WireInstMarker));
}


void wire_inst_mark (WireInst* self, gint x, gint y) {
	WireInstMarker* newMarkers = NULL;
	WireInstMarker* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	WireInstMarker* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint newMarkers_length1 = 0;
	gint _newMarkers_size_ = 0;
	WireInstMarker marker = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	WireInstMarker* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	WireInstMarker _tmp5_ = {0};
	WireInstMarker* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	WireInstMarker* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->markers;
	_tmp0__length1 = self->markers_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup91 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	newMarkers = _tmp1_;
	newMarkers_length1 = _tmp1__length1;
	_newMarkers_size_ = newMarkers_length1;
	memset (&marker, 0, sizeof (WireInstMarker));
	_tmp2_ = x;
	marker.x = _tmp2_;
	_tmp3_ = y;
	marker.y = _tmp3_;
	marker.display = TRUE;
	_tmp4_ = newMarkers;
	_tmp4__length1 = newMarkers_length1;
	_tmp5_ = marker;
	_vala_array_add108 (&newMarkers, &newMarkers_length1, &_newMarkers_size_, &_tmp5_);
	_tmp6_ = newMarkers;
	_tmp6__length1 = newMarkers_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup92 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->markers = (g_free (self->markers), NULL);
	self->markers = _tmp7_;
	self->markers_length1 = _tmp7__length1;
	newMarkers = (g_free (newMarkers), NULL);
}


/**
 * Return the Path which is at (//x//, //y//), or null if there
 * isn't one.
 */
gint wire_inst_find_tag (WireInst* self, gint x, gint y) {
	gint result = 0;
	Tag* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->interfaceTag;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		Tag* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp4_ = x;
		_tmp5_ = self->interfaceTag;
		_tmp6_ = _tmp5_->leftBound;
		if (_tmp4_ >= _tmp6_) {
			gint _tmp7_ = 0;
			Tag* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			_tmp7_ = x;
			_tmp8_ = self->interfaceTag;
			_tmp9_ = _tmp8_->rightBound;
			_tmp3_ = _tmp7_ <= _tmp9_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp10_ = 0;
			Tag* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp10_ = y;
			_tmp11_ = self->interfaceTag;
			_tmp12_ = _tmp11_->upBound;
			_tmp2_ = _tmp10_ >= _tmp12_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp13_ = 0;
			Tag* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			_tmp13_ = y;
			_tmp14_ = self->interfaceTag;
			_tmp15_ = _tmp14_->downBound;
			_tmp1_ = _tmp13_ <= _tmp15_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = 1;
			return result;
		}
	}
	result = 0;
	return result;
}


Path* wire_inst_find (WireInst* self, gint x, gint y) {
	Path* result = NULL;
	Path** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->paths;
	_tmp0__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp0_;
		path_collection_length1 = _tmp0__length1;
		for (path_it = 0; path_it < _tmp0__length1; path_it = path_it + 1) {
			Path* _tmp1_ = NULL;
			Path* path = NULL;
			_tmp1_ = _path_ref0 (path_collection[path_it]);
			path = _tmp1_;
			{
				Path* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp2_ = path;
				_tmp3_ = x;
				_tmp4_ = y;
				_tmp5_ = path_find (_tmp2_, _tmp3_, _tmp4_);
				if (_tmp5_ != 0) {
					result = path;
					return result;
				}
				_path_unref0 (path);
			}
		}
	}
	result = NULL;
	return result;
}


gint wire_inst_count_find (WireInst* self, gint x, gint y) {
	gint result = 0;
	gint count = 0;
	Path** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	_tmp0_ = self->paths;
	_tmp0__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp0_;
		path_collection_length1 = _tmp0__length1;
		for (path_it = 0; path_it < _tmp0__length1; path_it = path_it + 1) {
			Path* _tmp1_ = NULL;
			Path* path = NULL;
			_tmp1_ = _path_ref0 (path_collection[path_it]);
			path = _tmp1_;
			{
				Path* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				_tmp2_ = path;
				_tmp3_ = x;
				_tmp4_ = y;
				_tmp5_ = path_find (_tmp2_, _tmp3_, _tmp4_);
				if (_tmp5_ != 0) {
					gint _tmp6_ = 0;
					_tmp6_ = count;
					count = _tmp6_ + 1;
				}
				_path_unref0 (path);
			}
		}
	}
	result = count;
	return result;
}


gboolean wire_inst_try_merge_paths (WireInst* self, Path* checkPath) {
	gboolean result = FALSE;
	Path* _tmp0_ = NULL;
	PathLine* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint xFirstCheckPath = 0;
	Path* _tmp2_ = NULL;
	PathLine* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	PathLine _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint yFirstCheckPath = 0;
	Path* _tmp6_ = NULL;
	PathLine* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	PathLine _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint xLastCheckPath = 0;
	Path* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint yLastCheckPath = 0;
	Path* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Path** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (checkPath != NULL, FALSE);
	_tmp0_ = checkPath;
	_tmp1_ = _tmp0_->lines;
	_tmp1__length1 = _tmp0_->lines_length1;
	if (_tmp1__length1 == 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = checkPath;
	_tmp3_ = _tmp2_->lines;
	_tmp3__length1 = _tmp2_->lines_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = _tmp4_.x1;
	xFirstCheckPath = _tmp5_;
	_tmp6_ = checkPath;
	_tmp7_ = _tmp6_->lines;
	_tmp7__length1 = _tmp6_->lines_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = _tmp8_.y1;
	yFirstCheckPath = _tmp9_;
	_tmp10_ = checkPath;
	_tmp11_ = _tmp10_->xLast;
	xLastCheckPath = _tmp11_;
	_tmp12_ = checkPath;
	_tmp13_ = _tmp12_->yLast;
	yLastCheckPath = _tmp13_;
	_tmp14_ = self->paths;
	_tmp14__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp14_;
		path_collection_length1 = _tmp14__length1;
		for (path_it = 0; path_it < _tmp14__length1; path_it = path_it + 1) {
			Path* _tmp15_ = NULL;
			Path* path = NULL;
			_tmp15_ = _path_ref0 (path_collection[path_it]);
			path = _tmp15_;
			{
				Path* _tmp16_ = NULL;
				PathLine* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint xFirstPath = 0;
				Path* _tmp18_ = NULL;
				PathLine* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				PathLine _tmp20_ = {0};
				gint _tmp21_ = 0;
				gint yFirstPath = 0;
				Path* _tmp22_ = NULL;
				PathLine* _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				PathLine _tmp24_ = {0};
				gint _tmp25_ = 0;
				gint xLastPath = 0;
				Path* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gint yLastPath = 0;
				Path* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gboolean _tmp30_ = FALSE;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gboolean _tmp37_ = FALSE;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gboolean _tmp44_ = FALSE;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gboolean _tmp51_ = FALSE;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				_tmp16_ = path;
				_tmp17_ = _tmp16_->lines;
				_tmp17__length1 = _tmp16_->lines_length1;
				if (_tmp17__length1 == 0) {
					_path_unref0 (path);
					continue;
				}
				_tmp18_ = path;
				_tmp19_ = _tmp18_->lines;
				_tmp19__length1 = _tmp18_->lines_length1;
				_tmp20_ = _tmp19_[0];
				_tmp21_ = _tmp20_.x1;
				xFirstPath = _tmp21_;
				_tmp22_ = path;
				_tmp23_ = _tmp22_->lines;
				_tmp23__length1 = _tmp22_->lines_length1;
				_tmp24_ = _tmp23_[0];
				_tmp25_ = _tmp24_.y1;
				yFirstPath = _tmp25_;
				_tmp26_ = path;
				_tmp27_ = _tmp26_->xLast;
				xLastPath = _tmp27_;
				_tmp28_ = path;
				_tmp29_ = _tmp28_->yLast;
				yLastPath = _tmp29_;
				_tmp31_ = xFirstCheckPath;
				_tmp32_ = xFirstPath;
				if (_tmp31_ == _tmp32_) {
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					_tmp33_ = yFirstCheckPath;
					_tmp34_ = yFirstPath;
					_tmp30_ = _tmp33_ == _tmp34_;
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					Path* _tmp35_ = NULL;
					Path* _tmp36_ = NULL;
					_tmp35_ = path;
					_tmp36_ = checkPath;
					path_merge (_tmp35_, _tmp36_, TRUE, TRUE);
					result = TRUE;
					_path_unref0 (path);
					return result;
				}
				_tmp38_ = xLastCheckPath;
				_tmp39_ = xFirstPath;
				if (_tmp38_ == _tmp39_) {
					gint _tmp40_ = 0;
					gint _tmp41_ = 0;
					_tmp40_ = yLastCheckPath;
					_tmp41_ = yFirstPath;
					_tmp37_ = _tmp40_ == _tmp41_;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					Path* _tmp42_ = NULL;
					Path* _tmp43_ = NULL;
					_tmp42_ = path;
					_tmp43_ = checkPath;
					path_merge (_tmp42_, _tmp43_, TRUE, FALSE);
					result = TRUE;
					_path_unref0 (path);
					return result;
				}
				_tmp45_ = xFirstCheckPath;
				_tmp46_ = xLastPath;
				if (_tmp45_ == _tmp46_) {
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					_tmp47_ = yFirstCheckPath;
					_tmp48_ = yLastPath;
					_tmp44_ = _tmp47_ == _tmp48_;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					Path* _tmp49_ = NULL;
					Path* _tmp50_ = NULL;
					_tmp49_ = path;
					_tmp50_ = checkPath;
					path_merge (_tmp49_, _tmp50_, FALSE, FALSE);
					result = TRUE;
					_path_unref0 (path);
					return result;
				}
				_tmp52_ = xLastCheckPath;
				_tmp53_ = xLastPath;
				if (_tmp52_ == _tmp53_) {
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					_tmp54_ = yLastCheckPath;
					_tmp55_ = yLastPath;
					_tmp51_ = _tmp54_ == _tmp55_;
				} else {
					_tmp51_ = FALSE;
				}
				if (_tmp51_) {
					Path* _tmp56_ = NULL;
					Path* _tmp57_ = NULL;
					_tmp56_ = path;
					_tmp57_ = checkPath;
					path_merge (_tmp56_, _tmp57_, FALSE, TRUE);
					result = TRUE;
					_path_unref0 (path);
					return result;
				}
				_path_unref0 (path);
			}
		}
	}
	result = FALSE;
	return result;
}


/**
 * Creates a tag going from (//x1//, //y1//) to (//x2//, //y2//).
 */
Tag* wire_inst_set_tag (WireInst* self, gint x1, gint y1, gint x2, gint y2) {
	Tag* result = NULL;
	gboolean found1 = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Path* _tmp2_ = NULL;
	Path* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean found2 = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Path* _tmp7_ = NULL;
	Path* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	Tag* _tmp51_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = x1;
	_tmp1_ = y1;
	_tmp2_ = wire_inst_find (self, _tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_path_unref0 (_tmp3_);
	found1 = _tmp4_;
	_tmp5_ = x2;
	_tmp6_ = y2;
	_tmp7_ = wire_inst_find (self, _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_path_unref0 (_tmp8_);
	found2 = _tmp9_;
	_tmp11_ = found1;
	if (_tmp11_) {
		gboolean _tmp12_ = FALSE;
		_tmp12_ = found2;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tag_unref0 (self->interfaceTag);
		self->interfaceTag = NULL;
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp14_ = found1;
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			gboolean _tmp15_ = FALSE;
			_tmp15_ = found2;
			_tmp13_ = _tmp15_;
		}
		if (_tmp13_) {
			gint xDiff = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint yDiff = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint xDiffAbs = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint yDiffAbs = 0;
			gboolean _tmp28_ = FALSE;
			Tag* _tmp49_ = NULL;
			Tag* _tmp50_ = NULL;
			_tmp16_ = x2;
			_tmp17_ = x1;
			xDiff = _tmp16_ - _tmp17_;
			_tmp18_ = y2;
			_tmp19_ = y1;
			yDiff = _tmp18_ - _tmp19_;
			_tmp21_ = xDiff;
			if (_tmp21_ > 0) {
				gint _tmp22_ = 0;
				_tmp22_ = xDiff;
				_tmp20_ = _tmp22_;
			} else {
				gint _tmp23_ = 0;
				_tmp23_ = xDiff;
				_tmp20_ = -_tmp23_;
			}
			xDiffAbs = _tmp20_;
			_tmp25_ = yDiff;
			if (_tmp25_ > 0) {
				gint _tmp26_ = 0;
				_tmp26_ = yDiff;
				_tmp24_ = _tmp26_;
			} else {
				gint _tmp27_ = 0;
				_tmp27_ = yDiff;
				_tmp24_ = -_tmp27_;
			}
			yDiffAbs = _tmp24_;
			_tmp28_ = found1;
			if (_tmp28_) {
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				Tag* _tmp37_ = NULL;
				Tag* _tmp38_ = NULL;
				_tmp29_ = xDiffAbs;
				_tmp30_ = yDiffAbs;
				if (_tmp29_ < _tmp30_) {
					gint _tmp31_ = 0;
					_tmp31_ = x1;
					x2 = _tmp31_;
				} else {
					gint _tmp32_ = 0;
					_tmp32_ = y1;
					y2 = _tmp32_;
				}
				_tmp33_ = x1;
				_tmp34_ = y1;
				_tmp35_ = x2;
				_tmp36_ = y2;
				_tmp37_ = tag_new (_tmp33_, _tmp34_, _tmp35_, _tmp36_);
				_tag_unref0 (self->interfaceTag);
				self->interfaceTag = _tmp37_;
				_tmp38_ = self->interfaceTag;
				_tmp38_->flow = FLOW_OUT;
			} else {
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				Tag* _tmp47_ = NULL;
				Tag* _tmp48_ = NULL;
				_tmp39_ = xDiffAbs;
				_tmp40_ = yDiffAbs;
				if (_tmp39_ < _tmp40_) {
					gint _tmp41_ = 0;
					_tmp41_ = x2;
					x1 = _tmp41_;
				} else {
					gint _tmp42_ = 0;
					_tmp42_ = y2;
					y1 = _tmp42_;
				}
				_tmp43_ = x2;
				_tmp44_ = y2;
				_tmp45_ = x1;
				_tmp46_ = y1;
				_tmp47_ = tag_new (_tmp43_, _tmp44_, _tmp45_, _tmp46_);
				_tag_unref0 (self->interfaceTag);
				self->interfaceTag = _tmp47_;
				_tmp48_ = self->interfaceTag;
				_tmp48_->flow = FLOW_IN;
			}
			_tmp49_ = self->interfaceTag;
			_tmp50_ = _tag_ref0 (_tmp49_);
			result = _tmp50_;
			return result;
		}
	}
	_tmp51_ = _tag_ref0 (G_TYPE_CHECK_INSTANCE_CAST (NULL, TYPE_TAG, Tag));
	result = _tmp51_;
	return result;
}


/**
 * Selects if the WireInst is on the point (//x//, //y//), else
 * it deselects.
 * If //toggle// is true, it toggles if on (//x//, //y//) instead.
 */
void wire_inst_try_select (WireInst* self, gint x, gint y, gboolean toggle, gboolean includeTag) {
	gboolean affect = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Path* _tmp2_ = NULL;
	Path* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	affect = FALSE;
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = wire_inst_find (self, _tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_path_unref0 (_tmp3_);
	if (_tmp4_) {
		affect = TRUE;
	}
	_tmp5_ = includeTag;
	if (_tmp5_) {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp6_ = x;
		_tmp7_ = y;
		_tmp8_ = wire_inst_find_tag (self, _tmp6_, _tmp7_);
		if (_tmp8_ == 1) {
			affect = TRUE;
		}
	}
	_tmp9_ = toggle;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		_tmp10_ = affect;
		if (_tmp10_) {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			_tmp12_ = self->selected;
			if (_tmp12_) {
				_tmp11_ = FALSE;
			} else {
				_tmp11_ = TRUE;
			}
			self->selected = _tmp11_;
		}
	} else {
		gboolean _tmp13_ = FALSE;
		_tmp13_ = affect;
		if (_tmp13_) {
			self->selected = TRUE;
		} else {
			self->selected = FALSE;
		}
	}
}


/**
 * Translates the wire instance //x// right, //y// down.
 * If //ignoreSelect// is true, it will move without being selected.
 */
void wire_inst_move (WireInst* self, gint x, gint y, gboolean ignoreSelect) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = ignoreSelect;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->selected;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		Path** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		Tag* _tmp24_ = NULL;
		wire_inst_disconnect_components (self);
		_tmp3_ = self->paths;
		_tmp3__length1 = self->paths_length1;
		{
			Path** path_collection = NULL;
			gint path_collection_length1 = 0;
			gint _path_collection_size_ = 0;
			gint path_it = 0;
			path_collection = _tmp3_;
			path_collection_length1 = _tmp3__length1;
			for (path_it = 0; path_it < _tmp3__length1; path_it = path_it + 1) {
				Path* _tmp4_ = NULL;
				Path* path = NULL;
				_tmp4_ = _path_ref0 (path_collection[path_it]);
				path = _tmp4_;
				{
					Path* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					_tmp5_ = path;
					_tmp6_ = x;
					_tmp7_ = y;
					path_move (_tmp5_, _tmp6_, _tmp7_);
					_path_unref0 (path);
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					gint _tmp10_ = 0;
					WireInstMarker* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					WireInstMarker* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gint _tmp13_ = 0;
					WireInstMarker* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					WireInstMarker* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gint _tmp19_ = 0;
					WireInstMarker* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					if (!_tmp8_) {
						gint _tmp9_ = 0;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp10_ = i;
					_tmp11_ = self->markers;
					_tmp11__length1 = self->markers_length1;
					if (!(_tmp10_ < _tmp11__length1)) {
						break;
					}
					_tmp12_ = self->markers;
					_tmp12__length1 = self->markers_length1;
					_tmp13_ = i;
					_tmp14_ = self->markers;
					_tmp14__length1 = self->markers_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_].x;
					_tmp17_ = x;
					_tmp14_[_tmp15_].x = _tmp16_ + _tmp17_;
					_tmp18_ = self->markers;
					_tmp18__length1 = self->markers_length1;
					_tmp19_ = i;
					_tmp20_ = self->markers;
					_tmp20__length1 = self->markers_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_].y;
					_tmp23_ = y;
					_tmp20_[_tmp21_].y = _tmp22_ + _tmp23_;
				}
			}
		}
		_tmp24_ = self->interfaceTag;
		if (_tmp24_ != NULL) {
			Tag* _tmp25_ = NULL;
			Tag* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Tag* _tmp29_ = NULL;
			Tag* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			Tag* _tmp33_ = NULL;
			Tag* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			Tag* _tmp37_ = NULL;
			Tag* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			Tag* _tmp41_ = NULL;
			_tmp25_ = self->interfaceTag;
			_tmp26_ = self->interfaceTag;
			_tmp27_ = _tmp26_->xTag;
			_tmp28_ = x;
			_tmp26_->xTag = _tmp27_ + _tmp28_;
			_tmp29_ = self->interfaceTag;
			_tmp30_ = self->interfaceTag;
			_tmp31_ = _tmp30_->yTag;
			_tmp32_ = y;
			_tmp30_->yTag = _tmp31_ + _tmp32_;
			_tmp33_ = self->interfaceTag;
			_tmp34_ = self->interfaceTag;
			_tmp35_ = _tmp34_->xWire;
			_tmp36_ = x;
			_tmp34_->xWire = _tmp35_ + _tmp36_;
			_tmp37_ = self->interfaceTag;
			_tmp38_ = self->interfaceTag;
			_tmp39_ = _tmp38_->yWire;
			_tmp40_ = y;
			_tmp38_->yWire = _tmp39_ + _tmp40_;
			_tmp41_ = self->interfaceTag;
			tag_calculate_bounds (_tmp41_);
		}
	}
}


/**
 * Saves the WireInst to a file using libxml.
 */
void wire_inst_save (WireInst* self, xmlTextWriter* xmlWriter) {
	xmlTextWriter* _tmp0_ = NULL;
	xmlTextWriter* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	WireInstPresetSignal _tmp5_ = 0;
	Path** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	WireInstMarker* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	Tag* _tmp51_ = NULL;
	xmlTextWriter* _tmp92_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (xmlWriter != NULL);
	_tmp0_ = xmlWriter;
	xmlTextWriterStartElement (_tmp0_, (xmlChar*) "wire");
	_tmp1_ = xmlWriter;
	_tmp2_ = self->myID;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	xmlTextWriterWriteAttribute (_tmp1_, (xmlChar*) "id", (xmlChar*) _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->presetSignal;
	switch (_tmp5_) {
		case WIRE_INST_PRESET_SIGNAL_FALSE:
		{
			xmlTextWriter* _tmp6_ = NULL;
			_tmp6_ = xmlWriter;
			xmlTextWriterWriteAttribute (_tmp6_, (xmlChar*) "preset", (xmlChar*) "false");
			break;
		}
		case WIRE_INST_PRESET_SIGNAL_TRUE:
		{
			xmlTextWriter* _tmp7_ = NULL;
			_tmp7_ = xmlWriter;
			xmlTextWriterWriteAttribute (_tmp7_, (xmlChar*) "preset", (xmlChar*) "true");
			break;
		}
		default:
		break;
	}
	_tmp8_ = self->paths;
	_tmp8__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp8_;
		path_collection_length1 = _tmp8__length1;
		for (path_it = 0; path_it < _tmp8__length1; path_it = path_it + 1) {
			Path* _tmp9_ = NULL;
			Path* path = NULL;
			_tmp9_ = _path_ref0 (path_collection[path_it]);
			path = _tmp9_;
			{
				xmlTextWriter* _tmp10_ = NULL;
				Path* _tmp11_ = NULL;
				PathLine* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				xmlTextWriter* _tmp25_ = NULL;
				xmlTextWriter* _tmp26_ = NULL;
				Path* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				xmlTextWriter* _tmp31_ = NULL;
				Path* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				xmlTextWriter* _tmp36_ = NULL;
				xmlTextWriter* _tmp37_ = NULL;
				_tmp10_ = xmlWriter;
				xmlTextWriterStartElement (_tmp10_, (xmlChar*) "path");
				_tmp11_ = path;
				_tmp12_ = _tmp11_->lines;
				_tmp12__length1 = _tmp11_->lines_length1;
				{
					PathLine* line_collection = NULL;
					gint line_collection_length1 = 0;
					gint _line_collection_size_ = 0;
					gint line_it = 0;
					line_collection = _tmp12_;
					line_collection_length1 = _tmp12__length1;
					for (line_it = 0; line_it < _tmp12__length1; line_it = line_it + 1) {
						PathLine line = {0};
						line = line_collection[line_it];
						{
							xmlTextWriter* _tmp13_ = NULL;
							xmlTextWriter* _tmp14_ = NULL;
							PathLine _tmp15_ = {0};
							gint _tmp16_ = 0;
							gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							xmlTextWriter* _tmp19_ = NULL;
							PathLine _tmp20_ = {0};
							gint _tmp21_ = 0;
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							xmlTextWriter* _tmp24_ = NULL;
							_tmp13_ = xmlWriter;
							xmlTextWriterStartElement (_tmp13_, (xmlChar*) "point");
							_tmp14_ = xmlWriter;
							_tmp15_ = line;
							_tmp16_ = _tmp15_.x1;
							_tmp17_ = g_strdup_printf ("%i", _tmp16_);
							_tmp18_ = _tmp17_;
							xmlTextWriterWriteAttribute (_tmp14_, (xmlChar*) "x", (xmlChar*) _tmp18_);
							_g_free0 (_tmp18_);
							_tmp19_ = xmlWriter;
							_tmp20_ = line;
							_tmp21_ = _tmp20_.y1;
							_tmp22_ = g_strdup_printf ("%i", _tmp21_);
							_tmp23_ = _tmp22_;
							xmlTextWriterWriteAttribute (_tmp19_, (xmlChar*) "y", (xmlChar*) _tmp23_);
							_g_free0 (_tmp23_);
							_tmp24_ = xmlWriter;
							xmlTextWriterEndElement (_tmp24_);
						}
					}
				}
				_tmp25_ = xmlWriter;
				xmlTextWriterStartElement (_tmp25_, (xmlChar*) "point");
				_tmp26_ = xmlWriter;
				_tmp27_ = path;
				_tmp28_ = _tmp27_->xLast;
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
				_tmp30_ = _tmp29_;
				xmlTextWriterWriteAttribute (_tmp26_, (xmlChar*) "x", (xmlChar*) _tmp30_);
				_g_free0 (_tmp30_);
				_tmp31_ = xmlWriter;
				_tmp32_ = path;
				_tmp33_ = _tmp32_->yLast;
				_tmp34_ = g_strdup_printf ("%i", _tmp33_);
				_tmp35_ = _tmp34_;
				xmlTextWriterWriteAttribute (_tmp31_, (xmlChar*) "y", (xmlChar*) _tmp35_);
				_g_free0 (_tmp35_);
				_tmp36_ = xmlWriter;
				xmlTextWriterEndElement (_tmp36_);
				_tmp37_ = xmlWriter;
				xmlTextWriterEndElement (_tmp37_);
				_path_unref0 (path);
			}
		}
	}
	_tmp38_ = self->markers;
	_tmp38__length1 = self->markers_length1;
	{
		WireInstMarker* marker_collection = NULL;
		gint marker_collection_length1 = 0;
		gint _marker_collection_size_ = 0;
		gint marker_it = 0;
		marker_collection = _tmp38_;
		marker_collection_length1 = _tmp38__length1;
		for (marker_it = 0; marker_it < _tmp38__length1; marker_it = marker_it + 1) {
			WireInstMarker marker = {0};
			marker = marker_collection[marker_it];
			{
				xmlTextWriter* _tmp39_ = NULL;
				xmlTextWriter* _tmp40_ = NULL;
				WireInstMarker _tmp41_ = {0};
				gint _tmp42_ = 0;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				xmlTextWriter* _tmp45_ = NULL;
				WireInstMarker _tmp46_ = {0};
				gint _tmp47_ = 0;
				gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				xmlTextWriter* _tmp50_ = NULL;
				_tmp39_ = xmlWriter;
				xmlTextWriterStartElement (_tmp39_, (xmlChar*) "marker");
				_tmp40_ = xmlWriter;
				_tmp41_ = marker;
				_tmp42_ = _tmp41_.x;
				_tmp43_ = g_strdup_printf ("%i", _tmp42_);
				_tmp44_ = _tmp43_;
				xmlTextWriterWriteAttribute (_tmp40_, (xmlChar*) "x", (xmlChar*) _tmp44_);
				_g_free0 (_tmp44_);
				_tmp45_ = xmlWriter;
				_tmp46_ = marker;
				_tmp47_ = _tmp46_.y;
				_tmp48_ = g_strdup_printf ("%i", _tmp47_);
				_tmp49_ = _tmp48_;
				xmlTextWriterWriteAttribute (_tmp45_, (xmlChar*) "y", (xmlChar*) _tmp49_);
				_g_free0 (_tmp49_);
				_tmp50_ = xmlWriter;
				xmlTextWriterEndElement (_tmp50_);
			}
		}
	}
	_tmp51_ = self->interfaceTag;
	if (_tmp51_ != NULL) {
		xmlTextWriter* _tmp52_ = NULL;
		xmlTextWriter* _tmp53_ = NULL;
		xmlTextWriter* _tmp54_ = NULL;
		Tag* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		xmlTextWriter* _tmp59_ = NULL;
		Tag* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		xmlTextWriter* _tmp64_ = NULL;
		Tag* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		xmlTextWriter* _tmp69_ = NULL;
		Tag* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* tmpString = NULL;
		gchar* _tmp74_ = NULL;
		Tag* _tmp75_ = NULL;
		Flow _tmp76_ = 0;
		const gchar* _tmp80_ = NULL;
		xmlTextWriter* _tmp83_ = NULL;
		Tag* _tmp84_ = NULL;
		gint _tmp85_ = 0;
		gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		xmlTextWriter* _tmp88_ = NULL;
		Tag* _tmp89_ = NULL;
		const gchar* _tmp90_ = NULL;
		xmlTextWriter* _tmp91_ = NULL;
		_tmp52_ = xmlWriter;
		xmlTextWriterStartElement (_tmp52_, (xmlChar*) "tag");
		_tmp53_ = xmlWriter;
		xmlTextWriterWriteAttribute (_tmp53_, (xmlChar*) "type", (xmlChar*) "interface");
		_tmp54_ = xmlWriter;
		_tmp55_ = self->interfaceTag;
		_tmp56_ = _tmp55_->xWire;
		_tmp57_ = g_strdup_printf ("%i", _tmp56_);
		_tmp58_ = _tmp57_;
		xmlTextWriterWriteAttribute (_tmp54_, (xmlChar*) "xwire", (xmlChar*) _tmp58_);
		_g_free0 (_tmp58_);
		_tmp59_ = xmlWriter;
		_tmp60_ = self->interfaceTag;
		_tmp61_ = _tmp60_->yWire;
		_tmp62_ = g_strdup_printf ("%i", _tmp61_);
		_tmp63_ = _tmp62_;
		xmlTextWriterWriteAttribute (_tmp59_, (xmlChar*) "ywire", (xmlChar*) _tmp63_);
		_g_free0 (_tmp63_);
		_tmp64_ = xmlWriter;
		_tmp65_ = self->interfaceTag;
		_tmp66_ = _tmp65_->xTag;
		_tmp67_ = g_strdup_printf ("%i", _tmp66_);
		_tmp68_ = _tmp67_;
		xmlTextWriterWriteAttribute (_tmp64_, (xmlChar*) "xtag", (xmlChar*) _tmp68_);
		_g_free0 (_tmp68_);
		_tmp69_ = xmlWriter;
		_tmp70_ = self->interfaceTag;
		_tmp71_ = _tmp70_->yTag;
		_tmp72_ = g_strdup_printf ("%i", _tmp71_);
		_tmp73_ = _tmp72_;
		xmlTextWriterWriteAttribute (_tmp69_, (xmlChar*) "ytag", (xmlChar*) _tmp73_);
		_g_free0 (_tmp73_);
		_tmp74_ = g_strdup ("");
		tmpString = _tmp74_;
		_tmp75_ = self->interfaceTag;
		_tmp76_ = _tmp75_->flow;
		switch (_tmp76_) {
			case FLOW_IN:
			{
				gchar* _tmp77_ = NULL;
				_tmp77_ = g_strdup ("in");
				_g_free0 (tmpString);
				tmpString = _tmp77_;
				break;
			}
			case FLOW_OUT:
			{
				gchar* _tmp78_ = NULL;
				_tmp78_ = g_strdup ("out");
				_g_free0 (tmpString);
				tmpString = _tmp78_;
				break;
			}
			case FLOW_BIDIRECTIONAL:
			{
				gchar* _tmp79_ = NULL;
				_tmp79_ = g_strdup ("bi");
				_g_free0 (tmpString);
				tmpString = _tmp79_;
				break;
			}
			default:
			break;
		}
		_tmp80_ = tmpString;
		if (g_strcmp0 (_tmp80_, "") != 0) {
			xmlTextWriter* _tmp81_ = NULL;
			const gchar* _tmp82_ = NULL;
			_tmp81_ = xmlWriter;
			_tmp82_ = tmpString;
			xmlTextWriterWriteAttribute (_tmp81_, (xmlChar*) "flow", (xmlChar*) _tmp82_);
		}
		_tmp83_ = xmlWriter;
		_tmp84_ = self->interfaceTag;
		_tmp85_ = _tmp84_->pinid;
		_tmp86_ = g_strdup_printf ("%i", _tmp85_);
		_tmp87_ = _tmp86_;
		xmlTextWriterWriteAttribute (_tmp83_, (xmlChar*) "pinid", (xmlChar*) _tmp87_);
		_g_free0 (_tmp87_);
		_tmp88_ = xmlWriter;
		_tmp89_ = self->interfaceTag;
		_tmp90_ = _tmp89_->text;
		xmlTextWriterWriteAttribute (_tmp88_, (xmlChar*) "text", (xmlChar*) _tmp90_);
		_tmp91_ = xmlWriter;
		xmlTextWriterEndElement (_tmp91_);
		_g_free0 (tmpString);
	}
	_tmp92_ = xmlWriter;
	xmlTextWriterEndElement (_tmp92_);
}


/**
 * Renders the wire, using render_colour.
 */
void wire_inst_render (WireInst* self, cairo_t* context, gboolean showHints, gboolean showErrors) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = showHints;
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = self->selected;
		if (_tmp1_) {
			cairo_t* _tmp2_ = NULL;
			_tmp2_ = context;
			wire_inst_render_colour (self, _tmp2_, (gfloat) 0, (gfloat) 0, (gfloat) 1);
		} else {
			WireInstPresetSignal _tmp3_ = 0;
			_tmp3_ = self->presetSignal;
			if (_tmp3_ != WIRE_INST_PRESET_SIGNAL_DEFAULT) {
				cairo_t* _tmp4_ = NULL;
				cairo_t* _tmp5_ = NULL;
				gdouble* _tmp6_ = NULL;
				gdouble* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				cairo_t* _tmp8_ = NULL;
				WireInstPresetSignal _tmp9_ = 0;
				cairo_t* _tmp12_ = NULL;
				cairo_t* _tmp13_ = NULL;
				_tmp4_ = context;
				wire_inst_render_colour (self, _tmp4_, (gfloat) 0, (gfloat) 0, (gfloat) 0);
				_tmp5_ = context;
				_tmp6_ = g_new0 (gdouble, 2);
				_tmp6_[0] = 5.0;
				_tmp6_[1] = 5.0;
				_tmp7_ = _tmp6_;
				_tmp7__length1 = 2;
				cairo_set_dash (_tmp5_, _tmp7_, 2, (gdouble) 0);
				_tmp7_ = (g_free (_tmp7_), NULL);
				_tmp8_ = context;
				cairo_set_line_width (_tmp8_, (gdouble) 2);
				_tmp9_ = self->presetSignal;
				switch (_tmp9_) {
					case WIRE_INST_PRESET_SIGNAL_TRUE:
					{
						cairo_t* _tmp10_ = NULL;
						_tmp10_ = context;
						wire_inst_render_colour (self, _tmp10_, 0.8f, (gfloat) 0, (gfloat) 0);
						break;
					}
					case WIRE_INST_PRESET_SIGNAL_FALSE:
					{
						cairo_t* _tmp11_ = NULL;
						_tmp11_ = context;
						wire_inst_render_colour (self, _tmp11_, (gfloat) 0, (gfloat) 0, 0.8f);
						break;
					}
					default:
					break;
				}
				_tmp12_ = context;
				cairo_set_dash (_tmp12_, NULL, 0, (gdouble) 0);
				_tmp13_ = context;
				cairo_set_line_width (_tmp13_, (gdouble) 1);
			} else {
				cairo_t* _tmp14_ = NULL;
				_tmp14_ = context;
				wire_inst_render_colour (self, _tmp14_, (gfloat) 0, (gfloat) 0, (gfloat) 0);
			}
		}
	} else {
		cairo_t* _tmp15_ = NULL;
		_tmp15_ = context;
		wire_inst_render_colour (self, _tmp15_, (gfloat) 0, (gfloat) 0, (gfloat) 0);
	}
}


/**
 * Renders the wire in a given colour, drawing paths and
 * dot juntion markers.
 */
void wire_inst_render_colour (WireInst* self, cairo_t* context, gfloat r, gfloat g, gfloat b) {
	cairo_t* _tmp0_ = NULL;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_ = 0.0F;
	Path** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	WireInstMarker* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	WireInstRegisteredComponent* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	Tag* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = r;
	_tmp2_ = g;
	_tmp3_ = b;
	cairo_set_source_rgba (_tmp0_, (gdouble) _tmp1_, (gdouble) _tmp2_, (gdouble) _tmp3_, (gdouble) 1);
	_tmp4_ = self->paths;
	_tmp4__length1 = self->paths_length1;
	{
		Path** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp4_;
		path_collection_length1 = _tmp4__length1;
		for (path_it = 0; path_it < _tmp4__length1; path_it = path_it + 1) {
			Path* _tmp5_ = NULL;
			Path* path = NULL;
			_tmp5_ = _path_ref0 (path_collection[path_it]);
			path = _tmp5_;
			{
				Path* _tmp6_ = NULL;
				cairo_t* _tmp7_ = NULL;
				_tmp6_ = path;
				_tmp7_ = context;
				path_render (_tmp6_, _tmp7_);
				_path_unref0 (path);
			}
		}
	}
	_tmp8_ = self->markers;
	_tmp8__length1 = self->markers_length1;
	{
		WireInstMarker* marker_collection = NULL;
		gint marker_collection_length1 = 0;
		gint _marker_collection_size_ = 0;
		gint marker_it = 0;
		marker_collection = _tmp8_;
		marker_collection_length1 = _tmp8__length1;
		for (marker_it = 0; marker_it < _tmp8__length1; marker_it = marker_it + 1) {
			WireInstMarker marker = {0};
			marker = marker_collection[marker_it];
			{
				WireInstMarker _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				_tmp9_ = marker;
				_tmp10_ = _tmp9_.display;
				if (_tmp10_) {
					cairo_t* _tmp11_ = NULL;
					WireInstMarker _tmp12_ = {0};
					gint _tmp13_ = 0;
					WireInstMarker _tmp14_ = {0};
					gint _tmp15_ = 0;
					cairo_t* _tmp16_ = NULL;
					cairo_t* _tmp17_ = NULL;
					_tmp11_ = context;
					_tmp12_ = marker;
					_tmp13_ = _tmp12_.x;
					_tmp14_ = marker;
					_tmp15_ = _tmp14_.y;
					cairo_arc (_tmp11_, (gdouble) _tmp13_, (gdouble) _tmp15_, 2.5, (gdouble) 0, G_PI * 2);
					_tmp16_ = context;
					cairo_fill (_tmp16_);
					_tmp17_ = context;
					cairo_stroke (_tmp17_);
				}
			}
		}
	}
	_tmp18_ = self->registeredComponents;
	_tmp18__length1 = self->registeredComponents_length1;
	{
		WireInstRegisteredComponent* registeredComponent_collection = NULL;
		gint registeredComponent_collection_length1 = 0;
		gint _registeredComponent_collection_size_ = 0;
		gint registeredComponent_it = 0;
		registeredComponent_collection = _tmp18_;
		registeredComponent_collection_length1 = _tmp18__length1;
		for (registeredComponent_it = 0; registeredComponent_it < _tmp18__length1; registeredComponent_it = registeredComponent_it + 1) {
			WireInstRegisteredComponent registeredComponent = {0};
			registeredComponent = registeredComponent_collection[registeredComponent_it];
			{
				WireInstMarker marker = {0};
				WireInstRegisteredComponent _tmp19_ = {0};
				WireInstMarker _tmp20_ = {0};
				WireInstMarker _tmp21_ = {0};
				gboolean _tmp22_ = FALSE;
				_tmp19_ = registeredComponent;
				_tmp20_ = _tmp19_.marker;
				marker = _tmp20_;
				_tmp21_ = marker;
				_tmp22_ = _tmp21_.display;
				if (_tmp22_) {
					cairo_t* _tmp23_ = NULL;
					WireInstMarker _tmp24_ = {0};
					gint _tmp25_ = 0;
					WireInstMarker _tmp26_ = {0};
					gint _tmp27_ = 0;
					cairo_t* _tmp28_ = NULL;
					cairo_t* _tmp29_ = NULL;
					_tmp23_ = context;
					_tmp24_ = marker;
					_tmp25_ = _tmp24_.x;
					_tmp26_ = marker;
					_tmp27_ = _tmp26_.y;
					cairo_arc (_tmp23_, (gdouble) _tmp25_, (gdouble) _tmp27_, 2.5, (gdouble) 0, G_PI * 2);
					_tmp28_ = context;
					cairo_fill (_tmp28_);
					_tmp29_ = context;
					cairo_stroke (_tmp29_);
				}
			}
		}
	}
	_tmp30_ = self->interfaceTag;
	if (_tmp30_ != NULL) {
		Tag* _tmp31_ = NULL;
		cairo_t* _tmp32_ = NULL;
		_tmp31_ = self->interfaceTag;
		_tmp32_ = context;
		tag_render (_tmp31_, _tmp32_);
	}
}


WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self) {
	WireInstRegisteredComponent* dup;
	dup = g_new0 (WireInstRegisteredComponent, 1);
	memcpy (dup, self, sizeof (WireInstRegisteredComponent));
	return dup;
}


void wire_inst_registered_component_free (WireInstRegisteredComponent* self) {
	g_free (self);
}


GType wire_inst_registered_component_get_type (void) {
	static volatile gsize wire_inst_registered_component_type_id__volatile = 0;
	if (g_once_init_enter (&wire_inst_registered_component_type_id__volatile)) {
		GType wire_inst_registered_component_type_id;
		wire_inst_registered_component_type_id = g_boxed_type_register_static ("WireInstRegisteredComponent", (GBoxedCopyFunc) wire_inst_registered_component_dup, (GBoxedFreeFunc) wire_inst_registered_component_free);
		g_once_init_leave (&wire_inst_registered_component_type_id__volatile, wire_inst_registered_component_type_id);
	}
	return wire_inst_registered_component_type_id__volatile;
}


WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self) {
	WireInstMarker* dup;
	dup = g_new0 (WireInstMarker, 1);
	memcpy (dup, self, sizeof (WireInstMarker));
	return dup;
}


void wire_inst_marker_free (WireInstMarker* self) {
	g_free (self);
}


GType wire_inst_marker_get_type (void) {
	static volatile gsize wire_inst_marker_type_id__volatile = 0;
	if (g_once_init_enter (&wire_inst_marker_type_id__volatile)) {
		GType wire_inst_marker_type_id;
		wire_inst_marker_type_id = g_boxed_type_register_static ("WireInstMarker", (GBoxedCopyFunc) wire_inst_marker_dup, (GBoxedFreeFunc) wire_inst_marker_free);
		g_once_init_leave (&wire_inst_marker_type_id__volatile, wire_inst_marker_type_id);
	}
	return wire_inst_marker_type_id__volatile;
}


static void value_wire_inst_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_wire_inst_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		wire_inst_unref (value->data[0].v_pointer);
	}
}


static void value_wire_inst_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = wire_inst_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_wire_inst_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_wire_inst_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		WireInst* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = wire_inst_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_wire_inst_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	WireInst** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = wire_inst_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecWireInst* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_WIRE_INST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_wire_inst (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WIRE_INST), NULL);
	return value->data[0].v_pointer;
}


void value_set_wire_inst (GValue* value, gpointer v_object) {
	WireInst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WIRE_INST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WIRE_INST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		wire_inst_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		wire_inst_unref (old);
	}
}


void value_take_wire_inst (GValue* value, gpointer v_object) {
	WireInst* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WIRE_INST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WIRE_INST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		wire_inst_unref (old);
	}
}


static void wire_inst_class_init (WireInstClass * klass) {
	wire_inst_parent_class = g_type_class_peek_parent (klass);
	WIRE_INST_CLASS (klass)->finalize = wire_inst_finalize;
}


static void wire_inst_instance_init (WireInst * self) {
	self->selected = FALSE;
	self->presetSignal = WIRE_INST_PRESET_SIGNAL_DEFAULT;
	self->ref_count = 1;
}


static void wire_inst_finalize (WireInst* obj) {
	WireInst * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WIRE_INST, WireInst);
	self->registeredComponents = (g_free (self->registeredComponents), NULL);
	self->markers = (g_free (self->markers), NULL);
	self->paths = (_vala_array_free (self->paths, self->paths_length1, (GDestroyNotify) path_unref), NULL);
	_tag_unref0 (self->interfaceTag);
}


/**
 * An instance of a wire in a design.
 * 
 * Holds information about an instance of a wire in a design.
 */
GType wire_inst_get_type (void) {
	static volatile gsize wire_inst_type_id__volatile = 0;
	if (g_once_init_enter (&wire_inst_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_wire_inst_init, value_wire_inst_free_value, value_wire_inst_copy_value, value_wire_inst_peek_pointer, "p", value_wire_inst_collect_value, "p", value_wire_inst_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (WireInstClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wire_inst_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WireInst), 0, (GInstanceInitFunc) wire_inst_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType wire_inst_type_id;
		wire_inst_type_id = g_type_register_fundamental (g_type_fundamental_next (), "WireInst", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&wire_inst_type_id__volatile, wire_inst_type_id);
	}
	return wire_inst_type_id__volatile;
}


gpointer wire_inst_ref (gpointer instance) {
	WireInst* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void wire_inst_unref (gpointer instance) {
	WireInst* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		WIRE_INST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



