/* wirestate.c generated by valac 0.24.0, the Vala compiler
 * generated from wirestate.vala, do not modify */

/* 
 * SmartSim - Digital Logic Circuit Designer and Simulator
 *   
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *   
 *   Filename: wirestate.vala
 *   
 *   Copyright Ashley Newson 2013
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_WIRE_STATE (wire_state_get_type ())
#define WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_STATE, WireState))
#define WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_STATE, WireStateClass))
#define IS_WIRE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_STATE))
#define IS_WIRE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_STATE))
#define WIRE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_STATE, WireStateClass))

typedef struct _WireState WireState;
typedef struct _WireStateClass WireStateClass;
typedef struct _WireStatePrivate WireStatePrivate;

#define TYPE_COMPILED_CIRCUIT (compiled_circuit_get_type ())
#define COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuit))
#define COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))
#define IS_COMPILED_CIRCUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPILED_CIRCUIT))
#define IS_COMPILED_CIRCUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPILED_CIRCUIT))
#define COMPILED_CIRCUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPILED_CIRCUIT, CompiledCircuitClass))

typedef struct _CompiledCircuit CompiledCircuit;
typedef struct _CompiledCircuitClass CompiledCircuitClass;

#define TYPE_COMPONENT_INST (component_inst_get_type ())
#define COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_INST, ComponentInst))
#define COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_INST, ComponentInstClass))
#define IS_COMPONENT_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_INST))
#define IS_COMPONENT_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_INST))
#define COMPONENT_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_INST, ComponentInstClass))

typedef struct _ComponentInst ComponentInst;
typedef struct _ComponentInstClass ComponentInstClass;

#define TYPE_WIRE_INST (wire_inst_get_type ())
#define WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRE_INST, WireInst))
#define WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRE_INST, WireInstClass))
#define IS_WIRE_INST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRE_INST))
#define IS_WIRE_INST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRE_INST))
#define WIRE_INST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRE_INST, WireInstClass))

typedef struct _WireInst WireInst;
typedef struct _WireInstClass WireInstClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_COMPONENT_STATE (component_state_get_type ())
#define COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_STATE, ComponentState))
#define COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_STATE, ComponentStateClass))
#define IS_COMPONENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_STATE))
#define IS_COMPONENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_STATE))
#define COMPONENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_STATE, ComponentStateClass))

typedef struct _ComponentState ComponentState;
typedef struct _ComponentStateClass ComponentStateClass;

#define WIRE_STATE_TYPE_STATE_HISTORY (wire_state_state_history_get_type ())
typedef struct _WireStateStateHistory WireStateStateHistory;

#define WIRE_STATE_TYPE_STATE (wire_state_state_get_type ())
#define _wire_inst_unref0(var) ((var == NULL) ? NULL : (var = (wire_inst_unref (var), NULL)))
typedef struct _WireInstPrivate WireInstPrivate;

#define WIRE_INST_TYPE_REGISTERED_COMPONENT (wire_inst_registered_component_get_type ())

#define WIRE_INST_TYPE_MARKER (wire_inst_marker_get_type ())
typedef struct _WireInstMarker WireInstMarker;
typedef struct _WireInstRegisteredComponent WireInstRegisteredComponent;

#define TYPE_PATH (path_get_type ())
#define PATH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH, Path))
#define PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH, PathClass))
#define IS_PATH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH))
#define IS_PATH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH))
#define PATH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH, PathClass))

typedef struct _Path Path;
typedef struct _PathClass PathClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define WIRE_INST_TYPE_PRESET_SIGNAL (wire_inst_preset_signal_get_type ())
typedef struct _CompiledCircuitPrivate CompiledCircuitPrivate;

#define TYPE_COMPONENT_DEF (component_def_get_type ())
#define COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPONENT_DEF, ComponentDef))
#define COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPONENT_DEF, ComponentDefClass))
#define IS_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPONENT_DEF))
#define IS_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPONENT_DEF))
#define COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPONENT_DEF, ComponentDefClass))

typedef struct _ComponentDef ComponentDef;
typedef struct _ComponentDefClass ComponentDefClass;

#define TYPE_CUSTOM_COMPONENT_DEF (custom_component_def_get_type ())
#define CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDef))
#define CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))
#define IS_CUSTOM_COMPONENT_DEF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_COMPONENT_DEF))
#define IS_CUSTOM_COMPONENT_DEF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_COMPONENT_DEF))
#define CUSTOM_COMPONENT_DEF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_COMPONENT_DEF, CustomComponentDefClass))

typedef struct _CustomComponentDef CustomComponentDef;
typedef struct _CustomComponentDefClass CustomComponentDefClass;

#define TYPE_PROJECT (project_get_type ())
#define PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECT, Project))
#define PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECT, ProjectClass))
#define IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECT))
#define IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECT))
#define PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECT, ProjectClass))

typedef struct _Project Project;
typedef struct _ProjectClass ProjectClass;

#define TYPE_UPDATE_QUEUE (update_queue_get_type ())
#define UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPDATE_QUEUE, UpdateQueue))
#define UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPDATE_QUEUE, UpdateQueueClass))
#define IS_UPDATE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPDATE_QUEUE))
#define IS_UPDATE_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPDATE_QUEUE))
#define UPDATE_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPDATE_QUEUE, UpdateQueueClass))

typedef struct _UpdateQueue UpdateQueue;
typedef struct _UpdateQueueClass UpdateQueueClass;
typedef struct _ComponentStatePrivate ComponentStatePrivate;
#define _component_state_unref0(var) ((var == NULL) ? NULL : (var = (component_state_unref (var), NULL)))
typedef struct _ConnectionPrivate ConnectionPrivate;
#define _connection_unref0(var) ((var == NULL) ? NULL : (var = (connection_unref (var), NULL)))
typedef struct _ParamSpecWireState ParamSpecWireState;

struct _WireState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireStatePrivate * priv;
	gint renderQueueID;
	gint processQueueID;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	gboolean display;
	gboolean errorMark;
	WireInst* wireInst;
	gint users;
	gint previousUsers;
};

struct _WireStateClass {
	GTypeClass parent_class;
	void (*finalize) (WireState *self);
};

struct _WireStateStateHistory {
	guint duration;
	guchar state;
};

struct _WireStatePrivate {
	gboolean* _signalState;
	gint _signalState_length1;
	gint __signalState_size_;
	gint readBuffer;
	gint writeBuffer;
	Connection** interfaces;
	gint interfaces_length1;
	gint _interfaces_size_;
	ComponentState** affectedComponents;
	gint affectedComponents_length1;
	gint _affectedComponents_size_;
	WireStateStateHistory* stateHistory;
	gint stateHistory_length1;
	gint _stateHistory_size_;
};

typedef enum  {
	WIRE_STATE_STATE_UNKNOWN = 0,
	WIRE_STATE_STATE_Z = 1,
	WIRE_STATE_STATE_TRUE = 2,
	WIRE_STATE_STATE_FALSE = 3
} WireStateState;

struct _WireInstMarker {
	gint x;
	gint y;
	gboolean display;
};

struct _WireInstRegisteredComponent {
	ComponentInst* componentInst;
	WireInstMarker marker;
};

typedef enum  {
	WIRE_INST_PRESET_SIGNAL_DEFAULT,
	WIRE_INST_PRESET_SIGNAL_FALSE,
	WIRE_INST_PRESET_SIGNAL_TRUE
} WireInstPresetSignal;

struct _WireInst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WireInstPrivate * priv;
	WireInstRegisteredComponent* registeredComponents;
	gint registeredComponents_length1;
	gint myID;
	gboolean selected;
	WireInstMarker* markers;
	gint markers_length1;
	Path** paths;
	gint paths_length1;
	Tag* interfaceTag;
	WireInstPresetSignal presetSignal;
};

struct _WireInstClass {
	GTypeClass parent_class;
	void (*finalize) (WireInst *self);
};

struct _CompiledCircuit {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompiledCircuitPrivate * priv;
	CustomComponentDef* rootComponent;
	Project* project;
	UpdateQueue* renderWireStates;
	UpdateQueue* renderComponentStates;
	UpdateQueue* processWireStates;
	UpdateQueue* processComponentStates;
	CustomComponentDef* viewedComponent;
	gint iterationCount;
};

struct _CompiledCircuitClass {
	GTypeClass parent_class;
	void (*finalize) (CompiledCircuit *self);
};

struct _ComponentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ComponentStatePrivate * priv;
	CompiledCircuit* compiledCircuit;
	ComponentInst** ancestry;
	gint ancestry_length1;
	ComponentInst* componentInst;
	gint renderQueueID;
	gint processQueueID;
	gboolean display;
};

struct _ComponentStateClass {
	GTypeClass parent_class;
	void (*finalize) (ComponentState *self);
	void (*update) (ComponentState* self);
	void (*click) (ComponentState* self);
	void (*render) (ComponentState* self, cairo_t* context);
	gboolean (*get_alwaysUpdate) (ComponentState* self);
};

struct _Connection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ConnectionPrivate * priv;
	WireState* wireState;
	gboolean invert;
	gboolean isFake;
	gboolean active;
};

struct _ConnectionClass {
	GTypeClass parent_class;
	void (*finalize) (Connection *self);
};

struct _ParamSpecWireState {
	GParamSpec parent_instance;
};


static gpointer wire_state_parent_class = NULL;

gpointer wire_state_ref (gpointer instance);
void wire_state_unref (gpointer instance);
GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_state (GValue* value, gpointer v_object);
void value_take_wire_state (GValue* value, gpointer v_object);
gpointer value_get_wire_state (const GValue* value);
GType wire_state_get_type (void) G_GNUC_CONST;
gpointer compiled_circuit_ref (gpointer instance);
void compiled_circuit_unref (gpointer instance);
GParamSpec* param_spec_compiled_circuit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_compiled_circuit (GValue* value, gpointer v_object);
void value_take_compiled_circuit (GValue* value, gpointer v_object);
gpointer value_get_compiled_circuit (const GValue* value);
GType compiled_circuit_get_type (void) G_GNUC_CONST;
gpointer component_inst_ref (gpointer instance);
void component_inst_unref (gpointer instance);
GParamSpec* param_spec_component_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_inst (GValue* value, gpointer v_object);
void value_take_component_inst (GValue* value, gpointer v_object);
gpointer value_get_component_inst (const GValue* value);
GType component_inst_get_type (void) G_GNUC_CONST;
gpointer wire_inst_ref (gpointer instance);
void wire_inst_unref (gpointer instance);
GParamSpec* param_spec_wire_inst (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wire_inst (GValue* value, gpointer v_object);
void value_take_wire_inst (GValue* value, gpointer v_object);
gpointer value_get_wire_inst (const GValue* value);
GType wire_inst_get_type (void) G_GNUC_CONST;
gpointer connection_ref (gpointer instance);
void connection_unref (gpointer instance);
GParamSpec* param_spec_connection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_connection (GValue* value, gpointer v_object);
void value_take_connection (GValue* value, gpointer v_object);
gpointer value_get_connection (const GValue* value);
GType connection_get_type (void) G_GNUC_CONST;
gpointer component_state_ref (gpointer instance);
void component_state_unref (gpointer instance);
GParamSpec* param_spec_component_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_state (GValue* value, gpointer v_object);
void value_take_component_state (GValue* value, gpointer v_object);
gpointer value_get_component_state (const GValue* value);
GType component_state_get_type (void) G_GNUC_CONST;
GType wire_state_state_history_get_type (void) G_GNUC_CONST;
WireStateStateHistory* wire_state_state_history_dup (const WireStateStateHistory* self);
void wire_state_state_history_free (WireStateStateHistory* self);
#define WIRE_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WIRE_STATE, WireStatePrivate))
enum  {
	WIRE_STATE_DUMMY_PROPERTY
};
GType wire_state_state_get_type (void) G_GNUC_CONST;
WireState* wire_state_new (WireInst* wireInst, ComponentInst** ancestry, int ancestry_length1);
WireState* wire_state_construct (GType object_type, WireInst* wireInst, ComponentInst** ancestry, int ancestry_length1);
static ComponentInst** _vala_array_dup93 (ComponentInst** self, int length);
GType wire_inst_registered_component_get_type (void) G_GNUC_CONST;
GType wire_inst_marker_get_type (void) G_GNUC_CONST;
WireInstMarker* wire_inst_marker_dup (const WireInstMarker* self);
void wire_inst_marker_free (WireInstMarker* self);
WireInstRegisteredComponent* wire_inst_registered_component_dup (const WireInstRegisteredComponent* self);
void wire_inst_registered_component_free (WireInstRegisteredComponent* self);
gpointer path_ref (gpointer instance);
void path_unref (gpointer instance);
GParamSpec* param_spec_path (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_path (GValue* value, gpointer v_object);
void value_take_path (GValue* value, gpointer v_object);
gpointer value_get_path (const GValue* value);
GType path_get_type (void) G_GNUC_CONST;
gpointer tag_ref (gpointer instance);
void tag_unref (gpointer instance);
GParamSpec* param_spec_tag (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tag (GValue* value, gpointer v_object);
void value_take_tag (GValue* value, gpointer v_object);
gpointer value_get_tag (const GValue* value);
GType tag_get_type (void) G_GNUC_CONST;
GType wire_inst_preset_signal_get_type (void) G_GNUC_CONST;
void wire_state_swap_buffers (WireState* self);
gpointer component_def_ref (gpointer instance);
void component_def_unref (gpointer instance);
GParamSpec* param_spec_component_def (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_component_def (GValue* value, gpointer v_object);
void value_take_component_def (GValue* value, gpointer v_object);
gpointer value_get_component_def (const GValue* value);
GType component_def_get_type (void) G_GNUC_CONST;
GType custom_component_def_get_type (void) G_GNUC_CONST;
gpointer project_ref (gpointer instance);
void project_unref (gpointer instance);
GParamSpec* param_spec_project (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_project (GValue* value, gpointer v_object);
void value_take_project (GValue* value, gpointer v_object);
gpointer value_get_project (const GValue* value);
GType project_get_type (void) G_GNUC_CONST;
gpointer update_queue_ref (gpointer instance);
void update_queue_unref (gpointer instance);
GParamSpec* param_spec_update_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_update_queue (GValue* value, gpointer v_object);
void value_take_update_queue (GValue* value, gpointer v_object);
gpointer value_get_update_queue (const GValue* value);
GType update_queue_get_type (void) G_GNUC_CONST;
void update_queue_add_element (UpdateQueue* self, gint elementNumber);
void wire_state_record (WireState* self);
gboolean wire_state_get_signalState (WireState* self);
static void _vala_array_add109 (WireStateStateHistory** array, int* length, int* size, const WireStateStateHistory* value);
void wire_state_update_interfaces (WireState* self, WireState* updater);
void wire_state_add_interface (WireState* self, Connection* connection);
static void _vala_array_add110 (Connection*** array, int* length, int* size, Connection* value);
void wire_state_add_affected (WireState* self, ComponentState* componentState);
static void _vala_array_add111 (ComponentState*** array, int* length, int* size, ComponentState* value);
void wire_state_start_recording (WireState* self, gint unknownTime);
static void _vala_array_add112 (WireStateStateHistory** array, int* length, int* size, const WireStateStateHistory* value);
static void _vala_array_add113 (WireStateStateHistory** array, int* length, int* size, const WireStateStateHistory* value);
void compiled_circuit_add_watch (CompiledCircuit* self, WireState* wireState);
void wire_state_stop_recording (WireState* self);
void compiled_circuit_remove_watch (CompiledCircuit* self, WireState* wireState);
void wire_state_render (WireState* self, cairo_t* context);
void wire_inst_render_colour (WireInst* self, cairo_t* context, gfloat r, gfloat g, gfloat b);
void wire_state_render_history (WireState* self, cairo_t* context, gint xStart, gint xEnd, gfloat height, gfloat stretch);
void wire_state_set_signalState (WireState* self, gboolean value);
static void wire_state_finalize (WireState* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType wire_state_state_get_type (void) {
	static volatile gsize wire_state_state_type_id__volatile = 0;
	if (g_once_init_enter (&wire_state_state_type_id__volatile)) {
		static const GEnumValue values[] = {{WIRE_STATE_STATE_UNKNOWN, "WIRE_STATE_STATE_UNKNOWN", "unknown"}, {WIRE_STATE_STATE_Z, "WIRE_STATE_STATE_Z", "z"}, {WIRE_STATE_STATE_TRUE, "WIRE_STATE_STATE_TRUE", "true"}, {WIRE_STATE_STATE_FALSE, "WIRE_STATE_STATE_FALSE", "false"}, {0, NULL, NULL}};
		GType wire_state_state_type_id;
		wire_state_state_type_id = g_enum_register_static ("WireStateState", values);
		g_once_init_leave (&wire_state_state_type_id__volatile, wire_state_state_type_id);
	}
	return wire_state_state_type_id__volatile;
}


/**
 * Creates a new WireState from a WireInst with the given ancestry.
 */
static gpointer _wire_inst_ref0 (gpointer self) {
	return self ? wire_inst_ref (self) : NULL;
}


static gpointer _component_inst_ref0 (gpointer self) {
	return self ? component_inst_ref (self) : NULL;
}


static ComponentInst** _vala_array_dup93 (ComponentInst** self, int length) {
	ComponentInst** result;
	int i;
	result = g_new0 (ComponentInst*, length + 1);
	for (i = 0; i < length; i++) {
		ComponentInst* _tmp0_ = NULL;
		_tmp0_ = _component_inst_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


WireState* wire_state_construct (GType object_type, WireInst* wireInst, ComponentInst** ancestry, int ancestry_length1) {
	WireState* self = NULL;
	WireInst* _tmp0_ = NULL;
	WireInst* _tmp1_ = NULL;
	ComponentInst** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	ComponentInst** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gboolean presetSignal = FALSE;
	WireInst* _tmp5_ = NULL;
	WireInstPresetSignal _tmp6_ = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (wireInst != NULL, NULL);
	self = (WireState*) g_type_create_instance (object_type);
	_tmp0_ = wireInst;
	_tmp1_ = _wire_inst_ref0 (_tmp0_);
	_wire_inst_unref0 (self->wireInst);
	self->wireInst = _tmp1_;
	_tmp2_ = ancestry;
	_tmp2__length1 = ancestry_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup93 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->ancestry = (_vala_array_free (self->ancestry, self->ancestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->ancestry = _tmp3_;
	self->ancestry_length1 = _tmp3__length1;
	self->display = FALSE;
	_tmp4_ = 2;
	self->priv->_signalState = g_renew (gboolean, self->priv->_signalState, 2);
	(_tmp4_ > self->priv->_signalState_length1) ? memset (self->priv->_signalState + self->priv->_signalState_length1, 0, sizeof (gboolean) * (_tmp4_ - self->priv->_signalState_length1)) : NULL;
	self->priv->_signalState_length1 = _tmp4_;
	self->priv->__signalState_size_ = _tmp4_;
	self->users = 0;
	self->previousUsers = 0;
	_tmp5_ = wireInst;
	_tmp6_ = _tmp5_->presetSignal;
	switch (_tmp6_) {
		case WIRE_INST_PRESET_SIGNAL_TRUE:
		{
			presetSignal = TRUE;
			self->previousUsers = 1;
			break;
		}
		case WIRE_INST_PRESET_SIGNAL_FALSE:
		{
			presetSignal = FALSE;
			self->previousUsers = 1;
			break;
		}
		default:
		{
			presetSignal = FALSE;
			break;
		}
	}
	_tmp7_ = self->priv->_signalState;
	_tmp7__length1 = self->priv->_signalState_length1;
	_tmp8_ = presetSignal;
	_tmp7_[0] = _tmp8_;
	_tmp9_ = _tmp7_[0];
	_tmp10_ = self->priv->_signalState;
	_tmp10__length1 = self->priv->_signalState_length1;
	_tmp11_ = presetSignal;
	_tmp10_[1] = _tmp11_;
	_tmp12_ = _tmp10_[1];
	self->priv->readBuffer = 1;
	self->priv->writeBuffer = 0;
	self->errorMark = FALSE;
	return self;
}


WireState* wire_state_new (WireInst* wireInst, ComponentInst** ancestry, int ancestry_length1) {
	return wire_state_construct (TYPE_WIRE_STATE, wireInst, ancestry, ancestry_length1);
}


/**
 * Swap //readBuffer// and //writeBuffer// values.
 */
static gpointer _component_state_ref0 (gpointer self) {
	return self ? component_state_ref (self) : NULL;
}


void wire_state_swap_buffers (WireState* self) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
	gboolean* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->readBuffer;
	switch (_tmp0_) {
		case 0:
		{
			self->priv->readBuffer = 1;
			self->priv->writeBuffer = 0;
			break;
		}
		case 1:
		{
			self->priv->readBuffer = 0;
			self->priv->writeBuffer = 1;
			break;
		}
		default:
		break;
	}
	_tmp2_ = self->priv->_signalState;
	_tmp2__length1 = self->priv->_signalState_length1;
	_tmp3_ = self->priv->readBuffer;
	_tmp4_ = _tmp2_[_tmp3_];
	_tmp5_ = self->priv->_signalState;
	_tmp5__length1 = self->priv->_signalState_length1;
	_tmp6_ = self->priv->writeBuffer;
	_tmp7_ = _tmp5_[_tmp6_];
	if (_tmp4_ != _tmp7_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp8_ = self->users;
		_tmp9_ = self->previousUsers;
		_tmp1_ = _tmp8_ != _tmp9_;
	}
	if (_tmp1_) {
		gboolean _tmp10_ = FALSE;
		ComponentState** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		_tmp10_ = self->display;
		if (_tmp10_) {
			CompiledCircuit* _tmp11_ = NULL;
			UpdateQueue* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			_tmp11_ = self->compiledCircuit;
			_tmp12_ = _tmp11_->renderWireStates;
			_tmp13_ = self->renderQueueID;
			update_queue_add_element (_tmp12_, _tmp13_);
		}
		_tmp14_ = self->priv->affectedComponents;
		_tmp14__length1 = self->priv->affectedComponents_length1;
		{
			ComponentState** componentState_collection = NULL;
			gint componentState_collection_length1 = 0;
			gint _componentState_collection_size_ = 0;
			gint componentState_it = 0;
			componentState_collection = _tmp14_;
			componentState_collection_length1 = _tmp14__length1;
			for (componentState_it = 0; componentState_it < _tmp14__length1; componentState_it = componentState_it + 1) {
				ComponentState* _tmp15_ = NULL;
				ComponentState* componentState = NULL;
				_tmp15_ = _component_state_ref0 (componentState_collection[componentState_it]);
				componentState = _tmp15_;
				{
					CompiledCircuit* _tmp16_ = NULL;
					UpdateQueue* _tmp17_ = NULL;
					ComponentState* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					_tmp16_ = self->compiledCircuit;
					_tmp17_ = _tmp16_->processComponentStates;
					_tmp18_ = componentState;
					_tmp19_ = _tmp18_->processQueueID;
					update_queue_add_element (_tmp17_, _tmp19_);
					_component_state_unref0 (componentState);
				}
			}
		}
	}
	_tmp20_ = self->priv->_signalState;
	_tmp20__length1 = self->priv->_signalState_length1;
	_tmp21_ = self->priv->writeBuffer;
	_tmp22_ = self->priv->_signalState;
	_tmp22__length1 = self->priv->_signalState_length1;
	_tmp23_ = self->priv->readBuffer;
	_tmp24_ = _tmp22_[_tmp23_];
	_tmp20_[_tmp21_] = _tmp24_;
	_tmp25_ = _tmp20_[_tmp21_];
	_tmp26_ = self->users;
	self->previousUsers = _tmp26_;
}


static void _vala_array_add109 (WireStateStateHistory** array, int* length, int* size, const WireStateStateHistory* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireStateStateHistory, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


void wire_state_record (WireState* self) {
	WireStateState state = 0;
	gint _tmp0_ = 0;
	gint lastState = 0;
	WireStateStateHistory* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	WireStateState _tmp4_ = 0;
	WireStateStateHistory* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp6_ = 0;
	WireStateStateHistory _tmp7_ = {0};
	guchar _tmp8_ = '\0';
	g_return_if_fail (self != NULL);
	_tmp0_ = self->previousUsers;
	if (_tmp0_ != 0) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = wire_state_get_signalState (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			state = WIRE_STATE_STATE_TRUE;
		} else {
			state = WIRE_STATE_STATE_FALSE;
		}
	} else {
		state = WIRE_STATE_STATE_Z;
	}
	_tmp3_ = self->priv->stateHistory;
	_tmp3__length1 = self->priv->stateHistory_length1;
	lastState = _tmp3__length1 - 1;
	_tmp4_ = state;
	_tmp5_ = self->priv->stateHistory;
	_tmp5__length1 = self->priv->stateHistory_length1;
	_tmp6_ = lastState;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp8_ = _tmp7_.state;
	if (_tmp4_ == _tmp8_) {
		WireStateStateHistory* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gint _tmp10_ = 0;
		guint _tmp11_ = 0U;
		_tmp9_ = self->priv->stateHistory;
		_tmp9__length1 = self->priv->stateHistory_length1;
		_tmp10_ = lastState;
		_tmp11_ = _tmp9_[_tmp10_].duration;
		_tmp9_[_tmp10_].duration = _tmp11_ + 1;
	} else {
		WireStateStateHistory newState = {0};
		WireStateState _tmp12_ = 0;
		WireStateStateHistory* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		WireStateStateHistory _tmp14_ = {0};
		memset (&newState, 0, sizeof (WireStateStateHistory));
		_tmp12_ = state;
		newState.state = (guchar) _tmp12_;
		newState.duration = (guint) 1;
		_tmp13_ = self->priv->stateHistory;
		_tmp13__length1 = self->priv->stateHistory_length1;
		_tmp14_ = newState;
		_vala_array_add109 (&self->priv->stateHistory, &self->priv->stateHistory_length1, &self->priv->_stateHistory_size_, &_tmp14_);
	}
}


/**
 * Updates all wires connected via high/low level interfaces,
 * except for //updater//, which told this wire to do so.
 */
static gpointer _connection_ref0 (gpointer self) {
	return self ? connection_ref (self) : NULL;
}


void wire_state_update_interfaces (WireState* self, WireState* updater) {
	Connection** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	CompiledCircuit* _tmp20_ = NULL;
	UpdateQueue* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp0__length1 = self->priv->interfaces_length1;
	{
		Connection** connection_collection = NULL;
		gint connection_collection_length1 = 0;
		gint _connection_collection_size_ = 0;
		gint connection_it = 0;
		connection_collection = _tmp0_;
		connection_collection_length1 = _tmp0__length1;
		for (connection_it = 0; connection_it < _tmp0__length1; connection_it = connection_it + 1) {
			Connection* _tmp1_ = NULL;
			Connection* connection = NULL;
			_tmp1_ = _connection_ref0 (connection_collection[connection_it]);
			connection = _tmp1_;
			{
				Connection* _tmp2_ = NULL;
				WireState* _tmp3_ = NULL;
				WireState* _tmp4_ = NULL;
				_tmp2_ = connection;
				_tmp3_ = _tmp2_->wireState;
				_tmp4_ = updater;
				if (_tmp3_ != _tmp4_) {
					Connection* _tmp5_ = NULL;
					WireState* _tmp6_ = NULL;
					gboolean* _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					gint _tmp8_ = 0;
					gboolean* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					gboolean _tmp11_ = FALSE;
					Connection* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					Connection* _tmp15_ = NULL;
					WireState* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					Connection* _tmp18_ = NULL;
					WireState* _tmp19_ = NULL;
					_tmp5_ = connection;
					_tmp6_ = _tmp5_->wireState;
					_tmp7_ = _tmp6_->priv->_signalState;
					_tmp7__length1 = _tmp6_->priv->_signalState_length1;
					_tmp8_ = self->priv->writeBuffer;
					_tmp9_ = self->priv->_signalState;
					_tmp9__length1 = self->priv->_signalState_length1;
					_tmp10_ = self->priv->writeBuffer;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = connection;
					_tmp13_ = _tmp12_->invert;
					_tmp7_[_tmp8_] = _tmp11_ != _tmp13_;
					_tmp14_ = _tmp7_[_tmp8_];
					_tmp15_ = connection;
					_tmp16_ = _tmp15_->wireState;
					_tmp17_ = self->users;
					_tmp16_->users = _tmp17_;
					_tmp18_ = connection;
					_tmp19_ = _tmp18_->wireState;
					wire_state_update_interfaces (_tmp19_, self);
				}
				_connection_unref0 (connection);
			}
		}
	}
	_tmp20_ = self->compiledCircuit;
	_tmp21_ = _tmp20_->processWireStates;
	_tmp22_ = self->processQueueID;
	update_queue_add_element (_tmp21_, _tmp22_);
}


/**
 * Adds an wire to the list of interfaces.
 */
static void _vala_array_add110 (Connection*** array, int* length, int* size, Connection* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Connection*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void wire_state_add_interface (WireState* self, Connection* connection) {
	Connection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	_tmp0_ = connection;
	_tmp1_ = _tmp0_->isFake;
	if (!_tmp1_) {
		Connection** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		Connection* _tmp3_ = NULL;
		Connection* _tmp4_ = NULL;
		_tmp2_ = self->priv->interfaces;
		_tmp2__length1 = self->priv->interfaces_length1;
		_tmp3_ = connection;
		_tmp4_ = _connection_ref0 (_tmp3_);
		_vala_array_add110 (&self->priv->interfaces, &self->priv->interfaces_length1, &self->priv->_interfaces_size_, _tmp4_);
	}
}


static void _vala_array_add111 (ComponentState*** array, int* length, int* size, ComponentState* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ComponentState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void wire_state_add_affected (WireState* self, ComponentState* componentState) {
	ComponentState** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ComponentState* _tmp1_ = NULL;
	ComponentState* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (componentState != NULL);
	_tmp0_ = self->priv->affectedComponents;
	_tmp0__length1 = self->priv->affectedComponents_length1;
	_tmp1_ = componentState;
	_tmp2_ = _component_state_ref0 (_tmp1_);
	_vala_array_add111 (&self->priv->affectedComponents, &self->priv->affectedComponents_length1, &self->priv->_affectedComponents_size_, _tmp2_);
}


static void _vala_array_add112 (WireStateStateHistory** array, int* length, int* size, const WireStateStateHistory* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireStateStateHistory, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add113 (WireStateStateHistory** array, int* length, int* size, const WireStateStateHistory* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WireStateStateHistory, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


void wire_state_start_recording (WireState* self, gint unknownTime) {
	WireStateStateHistory* _tmp0_ = NULL;
	WireStateStateHistory unknownState = {0};
	gint _tmp1_ = 0;
	WireStateStateHistory initialState = {0};
	gint _tmp2_ = 0;
	WireStateStateHistory* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	WireStateStateHistory _tmp6_ = {0};
	WireStateStateHistory* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	WireStateStateHistory _tmp8_ = {0};
	CompiledCircuit* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (WireStateStateHistory, 0);
	self->priv->stateHistory = (g_free (self->priv->stateHistory), NULL);
	self->priv->stateHistory = _tmp0_;
	self->priv->stateHistory_length1 = 0;
	self->priv->_stateHistory_size_ = self->priv->stateHistory_length1;
	memset (&unknownState, 0, sizeof (WireStateStateHistory));
	_tmp1_ = unknownTime;
	unknownState.duration = (guint) _tmp1_;
	unknownState.state = (guchar) WIRE_STATE_STATE_UNKNOWN;
	memset (&initialState, 0, sizeof (WireStateStateHistory));
	_tmp2_ = self->previousUsers;
	if (_tmp2_ != 0) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = wire_state_get_signalState (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			initialState.state = (guchar) WIRE_STATE_STATE_TRUE;
		} else {
			initialState.state = (guchar) WIRE_STATE_STATE_FALSE;
		}
	} else {
		initialState.state = (guchar) WIRE_STATE_STATE_Z;
	}
	initialState.duration = (guint) 1;
	_tmp5_ = self->priv->stateHistory;
	_tmp5__length1 = self->priv->stateHistory_length1;
	_tmp6_ = unknownState;
	_vala_array_add112 (&self->priv->stateHistory, &self->priv->stateHistory_length1, &self->priv->_stateHistory_size_, &_tmp6_);
	_tmp7_ = self->priv->stateHistory;
	_tmp7__length1 = self->priv->stateHistory_length1;
	_tmp8_ = initialState;
	_vala_array_add113 (&self->priv->stateHistory, &self->priv->stateHistory_length1, &self->priv->_stateHistory_size_, &_tmp8_);
	_tmp9_ = self->compiledCircuit;
	compiled_circuit_add_watch (_tmp9_, self);
}


void wire_state_stop_recording (WireState* self) {
	CompiledCircuit* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->stateHistory = (g_free (self->priv->stateHistory), NULL);
	self->priv->stateHistory = NULL;
	self->priv->stateHistory_length1 = 0;
	self->priv->_stateHistory_size_ = self->priv->stateHistory_length1;
	_tmp0_ = self->compiledCircuit;
	compiled_circuit_remove_watch (_tmp0_, self);
}


/**
 * Renders the WireState.
 */
void wire_state_render (WireState* self, cairo_t* context) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->errorMark;
	if (_tmp0_ == TRUE) {
		WireInst* _tmp1_ = NULL;
		cairo_t* _tmp2_ = NULL;
		_tmp1_ = self->wireInst;
		_tmp2_ = context;
		wire_inst_render_colour (_tmp1_, _tmp2_, 1.f, 1.f, 0.f);
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = self->previousUsers;
		if (_tmp3_ == 0) {
			WireInst* _tmp4_ = NULL;
			cairo_t* _tmp5_ = NULL;
			_tmp4_ = self->wireInst;
			_tmp5_ = context;
			wire_inst_render_colour (_tmp4_, _tmp5_, 0.f, 1.f, 0.f);
		} else {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			_tmp6_ = wire_state_get_signalState (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ == TRUE) {
				WireInst* _tmp8_ = NULL;
				cairo_t* _tmp9_ = NULL;
				_tmp8_ = self->wireInst;
				_tmp9_ = context;
				wire_inst_render_colour (_tmp8_, _tmp9_, 1.f, 0.f, 0.f);
			} else {
				WireInst* _tmp10_ = NULL;
				cairo_t* _tmp11_ = NULL;
				_tmp10_ = self->wireInst;
				_tmp11_ = context;
				wire_inst_render_colour (_tmp10_, _tmp11_, 0.f, 0.f, 1.f);
			}
		}
	}
}


void wire_state_render_history (WireState* self, cairo_t* context, gint xStart, gint xEnd, gfloat height, gfloat stretch) {
	gint x = 0;
	gfloat y = 0.0F;
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	x = 0;
	y = (gfloat) 0;
	_tmp0_ = context;
	cairo_set_source_rgb (_tmp0_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				WireStateStateHistory* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint xNew = 0;
				gint _tmp5_ = 0;
				WireStateStateHistory* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				WireStateStateHistory _tmp8_ = {0};
				guint _tmp9_ = 0U;
				WireStateStateHistory* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				WireStateStateHistory _tmp12_ = {0};
				guchar _tmp13_ = '\0';
				WireStateStateHistory* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				WireStateStateHistory _tmp18_ = {0};
				guchar _tmp19_ = '\0';
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp48_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->stateHistory;
				_tmp4__length1 = self->priv->stateHistory_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = x;
				_tmp6_ = self->priv->stateHistory;
				_tmp6__length1 = self->priv->stateHistory_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				_tmp9_ = _tmp8_.duration;
				xNew = _tmp5_ + ((gint) _tmp9_);
				_tmp10_ = self->priv->stateHistory;
				_tmp10__length1 = self->priv->stateHistory_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = _tmp12_.state;
				switch (_tmp13_) {
					case WIRE_STATE_STATE_FALSE:
					{
						gfloat _tmp14_ = 0.0F;
						_tmp14_ = height;
						y = _tmp14_;
						break;
					}
					case WIRE_STATE_STATE_TRUE:
					{
						gfloat _tmp15_ = 0.0F;
						_tmp15_ = height;
						y = -_tmp15_;
						break;
					}
					case WIRE_STATE_STATE_Z:
					{
						y = (gfloat) 0;
						break;
					}
					default:
					break;
				}
				_tmp16_ = self->priv->stateHistory;
				_tmp16__length1 = self->priv->stateHistory_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp19_ = _tmp18_.state;
				if (_tmp19_ == WIRE_STATE_STATE_UNKNOWN) {
					gint _tmp20_ = 0;
					_tmp20_ = xNew;
					x = _tmp20_;
					continue;
				}
				_tmp21_ = xNew;
				_tmp22_ = xStart;
				if (_tmp21_ > _tmp22_) {
					gboolean _tmp23_ = FALSE;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					_tmp24_ = x;
					_tmp25_ = xStart;
					if (_tmp24_ <= _tmp25_) {
						gint _tmp26_ = 0;
						gint _tmp27_ = 0;
						_tmp26_ = xStart;
						_tmp27_ = xNew;
						_tmp23_ = _tmp26_ < _tmp27_;
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						cairo_t* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						gfloat _tmp30_ = 0.0F;
						gfloat _tmp31_ = 0.0F;
						_tmp28_ = context;
						_tmp29_ = xStart;
						_tmp30_ = stretch;
						_tmp31_ = y;
						cairo_move_to (_tmp28_, (gdouble) (((gfloat) _tmp29_) * _tmp30_), (gdouble) _tmp31_);
					} else {
						cairo_t* _tmp32_ = NULL;
						gint _tmp33_ = 0;
						gfloat _tmp34_ = 0.0F;
						gfloat _tmp35_ = 0.0F;
						_tmp32_ = context;
						_tmp33_ = x;
						_tmp34_ = stretch;
						_tmp35_ = y;
						cairo_line_to (_tmp32_, (gdouble) (((gfloat) _tmp33_) * _tmp34_), (gdouble) _tmp35_);
					}
				} else {
					gint _tmp36_ = 0;
					_tmp36_ = xNew;
					x = _tmp36_;
					continue;
				}
				_tmp37_ = x;
				_tmp38_ = xNew;
				if (_tmp37_ > _tmp38_) {
					cairo_t* _tmp39_ = NULL;
					gint _tmp40_ = 0;
					gfloat _tmp41_ = 0.0F;
					gfloat _tmp42_ = 0.0F;
					gint _tmp43_ = 0;
					_tmp39_ = context;
					_tmp40_ = xEnd;
					_tmp41_ = stretch;
					_tmp42_ = y;
					cairo_line_to (_tmp39_, (gdouble) (((gfloat) _tmp40_) * _tmp41_), (gdouble) _tmp42_);
					_tmp43_ = xNew;
					x = _tmp43_;
					break;
				} else {
					cairo_t* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					gfloat _tmp46_ = 0.0F;
					gfloat _tmp47_ = 0.0F;
					_tmp44_ = context;
					_tmp45_ = xNew;
					_tmp46_ = stretch;
					_tmp47_ = y;
					cairo_line_to (_tmp44_, (gdouble) (((gfloat) _tmp45_) * _tmp46_), (gdouble) _tmp47_);
				}
				_tmp48_ = xNew;
				x = _tmp48_;
			}
		}
	}
	_tmp49_ = context;
	cairo_stroke (_tmp49_);
}


gboolean wire_state_get_signalState (WireState* self) {
	gboolean result;
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_signalState;
	_tmp0__length1 = self->priv->_signalState_length1;
	_tmp1_ = self->priv->readBuffer;
	_tmp2_ = _tmp0_[_tmp1_];
	result = _tmp2_;
	return result;
}


void wire_state_set_signalState (WireState* self, gboolean value) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_signalState;
	_tmp0__length1 = self->priv->_signalState_length1;
	_tmp1_ = self->priv->writeBuffer;
	_tmp2_ = value;
	_tmp0_[_tmp1_] = _tmp2_;
	_tmp3_ = _tmp0_[_tmp1_];
}


WireStateStateHistory* wire_state_state_history_dup (const WireStateStateHistory* self) {
	WireStateStateHistory* dup;
	dup = g_new0 (WireStateStateHistory, 1);
	memcpy (dup, self, sizeof (WireStateStateHistory));
	return dup;
}


void wire_state_state_history_free (WireStateStateHistory* self) {
	g_free (self);
}


GType wire_state_state_history_get_type (void) {
	static volatile gsize wire_state_state_history_type_id__volatile = 0;
	if (g_once_init_enter (&wire_state_state_history_type_id__volatile)) {
		GType wire_state_state_history_type_id;
		wire_state_state_history_type_id = g_boxed_type_register_static ("WireStateStateHistory", (GBoxedCopyFunc) wire_state_state_history_dup, (GBoxedFreeFunc) wire_state_state_history_free);
		g_once_init_leave (&wire_state_state_history_type_id__volatile, wire_state_state_history_type_id);
	}
	return wire_state_state_history_type_id__volatile;
}


static void value_wire_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_wire_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		wire_state_unref (value->data[0].v_pointer);
	}
}


static void value_wire_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = wire_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_wire_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_wire_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		WireState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = wire_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_wire_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	WireState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = wire_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_wire_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecWireState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_WIRE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_wire_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WIRE_STATE), NULL);
	return value->data[0].v_pointer;
}


void value_set_wire_state (GValue* value, gpointer v_object) {
	WireState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WIRE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WIRE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		wire_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		wire_state_unref (old);
	}
}


void value_take_wire_state (GValue* value, gpointer v_object) {
	WireState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WIRE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WIRE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		wire_state_unref (old);
	}
}


static void wire_state_class_init (WireStateClass * klass) {
	wire_state_parent_class = g_type_class_peek_parent (klass);
	WIRE_STATE_CLASS (klass)->finalize = wire_state_finalize;
	g_type_class_add_private (klass, sizeof (WireStatePrivate));
}


static void wire_state_instance_init (WireState * self) {
	self->priv = WIRE_STATE_GET_PRIVATE (self);
	self->priv->readBuffer = 0;
	self->priv->writeBuffer = 1;
	self->ref_count = 1;
}


static void wire_state_finalize (WireState* obj) {
	WireState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WIRE_STATE, WireState);
	self->ancestry = (_vala_array_free (self->ancestry, self->ancestry_length1, (GDestroyNotify) component_inst_unref), NULL);
	self->priv->_signalState = (g_free (self->priv->_signalState), NULL);
	_wire_inst_unref0 (self->wireInst);
	self->priv->interfaces = (_vala_array_free (self->priv->interfaces, self->priv->interfaces_length1, (GDestroyNotify) connection_unref), NULL);
	self->priv->affectedComponents = (_vala_array_free (self->priv->affectedComponents, self->priv->affectedComponents_length1, (GDestroyNotify) component_state_unref), NULL);
	self->priv->stateHistory = (g_free (self->priv->stateHistory), NULL);
}


/**
 * A compiled wire.
 * 
 * A WireState is a compiled wire component as part of a compiled
 * circuit.
 * They act as signal storage. They are required to update each other
 * between high-low level inferfaces.
 * They are constructed with the aid of a corrisponding WireInst.
 */
GType wire_state_get_type (void) {
	static volatile gsize wire_state_type_id__volatile = 0;
	if (g_once_init_enter (&wire_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_wire_state_init, value_wire_state_free_value, value_wire_state_copy_value, value_wire_state_peek_pointer, "p", value_wire_state_collect_value, "p", value_wire_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (WireStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wire_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WireState), 0, (GInstanceInitFunc) wire_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType wire_state_type_id;
		wire_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "WireState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&wire_state_type_id__volatile, wire_state_type_id);
	}
	return wire_state_type_id__volatile;
}


gpointer wire_state_ref (gpointer instance) {
	WireState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void wire_state_unref (gpointer instance) {
	WireState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		WIRE_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



