# Contributors

We would like to express our sincerest thanks and gratitude to everyone
that has helped with either the development of Sonic Pi or supported its
use in any capacity. On its own Sonic Pi is just a piece of
software. Only when combined with our kind and generous community does
it become a powerful tool for sharing and celebrating the creativity of
code. Thank-you everyone.


## A humble beginning 

The start of any project is a fragile period which relies heavily on the
generous support of others. We would like to offer our considered
gratitude to the following people who provided support in the early days
of Sonic Pi with their time, advice, and wisdom:

* [Carrie Anne Philbin](https://twitter.com/missphilbin)
* [Robert Mullins](https://www.cl.cam.ac.uk/~rdm34/)
* [Alex Bradbury](https://twitter.com/asbradbury)
* [Alan Blackwell](https://www.cl.cam.ac.uk/~afb21/)
* [Rachel Drury](https://twitter.com/Rachel_Drury)
* [Juneau Projects](http://www.juneauprojects.co.uk)
* Stephan Lachowsky
* [Jonathan Graham](https://twitter.com/graham_jp)


## Organisations

The following organisations have kindly contributed to Sonic Pi:

* [The Raspberry Pi Foundation](https://www.raspberrypi.org)
* [The Broadcom Foundation](https://www.broadcomfoundation.org)
* [The University of Cambridge Computer Laboratory](https://www.cl.cam.ac.uk)
* [Arts Council England](http://www.artscouncil.org.uk)
* [Nesta](https://www.nesta.org.uk)
* [pi-top](https://pi-top.com)


## Patreon Supporters

Sonic Pi development is increasingly funded by a growing number of very
kind and generous people via [Patreon](https://patreon.com/samaaron). We
would like to thank everyone who has supported Sonic Pi in this way -
especially the following individuals who have been remarkably generous:

* [Alexandre Enkerli](https://twitter.com/enkerli)
* [Anderson Reinkordt](https://soundcloud.com/april-club-music)
* [Chih-Chun Chen](http://abmcet.net/Chih-Chun_Chen/home.html)
* [Darin Wilson](https://twitter.com/darinwilson/)
* [James Abley](https://twitter.com/jabley)
* [Justin Worrall](https://twitter.com/juzbo)
* [Mark Rendle](https://twitter.com/markrendle)
* [Martin McDermott](https://twitter.com/marv_mcd)
* [Michael Hunger](http://twitter.com/mesirii)
* [Scott Turner](https://twitter.com/scottturneruon)
* Terry Wisniewski
* [thattommyhall](https://twitter.com/thattommyhall)


## Outstanding Community Contributions

We would like to recognise the following individuals for their important
contributions which have supported the Sonic Pi Community:

* [Paul Winstanley](https://twitter.com/SCCMentor)
* [Robin Newman](https://twitter.com/rbnman)
* Ethan Crawford


## Guidance and Advice

We would like to thank the following people for their time providing
valuable advice, feedback and suggestions on a wide variety of aspects
of Sonic Pi - from technical development, to artistic
conceptualisations, to musical production and performance.

* [Dago Sondervan](https://twitter.com/sondervan1)
* [Sam Conran](https://twitter.com/samconran)
* [Ben Smith](https://twitter.com/bensmithguitar)
* [Steve Hellier](https://twitter.com/steveguyhellier)
* [Pit Noack](https://twitter.com/maschinennah)

## Core Team

Much of the development, distribution and support work for Sonic Pi is
carried out by the Core Team. This is a group of dedicated volunteers
(with the exception of Sam Aaron who works full time on the project) who
kindly donate their time to continue to improve Sonic Pi.

Current members: 

* [Sam Aaron](https://github.com/samaaron)
* [Xavier Riley](https://github.com/xavriley)
* [Joseph Wilk](https://github.com/josephwilk)
* [Hanno Zulla](https://github.com/hzulla)
* [Adrian Cheater](https://github.com/factoid)
* [Luis Lloret](https://github.com/llloret/)
* [Robin Newman](https://github.com/rbnpi)
* [Ethan Crawford](https://github.com/ethancrawford)


Previous members:

* [Jeremy Weatherford](https://github.com/jweather)


## Developer Contributions

In addition to the Sonic Pi Core Team, we would like to extend our
thanks to the following developers who have donated their time and
effort to help grow and improve the Sonic Pi code base:

* [Sam Aaron](https://github.com/samaaron/sonic-pi/commits?author=samaaron) (4630)
* [Ethan Crawford](https://github.com/samaaron/sonic-pi/commits?author=ethancrawford) (181)
* [Joseph Wilk](https://github.com/samaaron/sonic-pi/commits?author=josephwilk) (160)
* [Jeremy Weatherford](https://github.com/samaaron/sonic-pi/commits?author=jweather) (127)
* [Hanno Zulla](https://github.com/samaaron/sonic-pi/commits?author=hzulla) (127)
* [Xavier Riley](https://github.com/samaaron/sonic-pi/commits?author=xavriley) (91)
* [Adrian Cheater](https://github.com/samaaron/sonic-pi/commits?author=factoid) (74)
* [Martin Keegan](https://github.com/samaaron/sonic-pi/commits?author=mk270) (47)
* [Robin Newman](https://github.com/samaaron/sonic-pi/commits?author=rbnpi) (37)
* [Luis Lloret](https://github.com/samaaron/sonic-pi/commits?author=llloret/) (36)
* [Nicolas Dermine](https://github.com/samaaron/sonic-pi/commits?author=nicoder) (36)
* [Joseph Burnett](https://github.com/samaaron/sonic-pi/commits?author=josephburnett) (15)
* [Łukasz Siwiński](https://github.com/samaaron/sonic-pi/commits?author=hopbit) (13)
* [Emlyn Corrin](https://github.com/samaaron/sonic-pi/commits?author=emlyn) (12)
* [Clare Macrae](https://github.com/samaaron/sonic-pi/commits?author=claremacrae) (7)
* [Jeroen Castelein](https://github.com/samaaron/sonic-pi/commits?author=JeroennC) (6)
* [Kenichi Kanai](https://github.com/samaaron/sonic-pi/commits?author=kn1kn1) (6)
* [Christoph Scholtes](https://github.com/samaaron/sonic-pi/commits?author=cschol) (5)
* [Antonio Bonifacio](https://github.com/samaaron/sonic-pi/commits?author=neuromancer85) (4)
* [Sebastien Rannou](https://github.com/samaaron/sonic-pi/commits?author=aimxhaisse) (3)
* [Mark Paton](https://github.com/samaaron/sonic-pi/commits?author=frobby) (3)
* [Edward Andrews-Hodgson](https://github.com/samaaron/sonic-pi/commits?author=aldreth) (3)
* [Katie Miller](https://github.com/samaaron/sonic-pi/commits?author=codemiller) (3)
* [Mariano Guerra](https://github.com/samaaron/sonic-pi/commits?author=marianoguerra) (3)
* [Chris Ford](https://github.com/samaaron/sonic-pi/commits?author=ctford) (3)
* [Steve Traylen](https://github.com/samaaron/sonic-pi/commits?author=traylenator) (3)
* [Petter Reinholdtsen](https://github.com/samaaron/sonic-pi/commits?author=petterreinholdtsen) (3)
* [Scott Kitterman](https://github.com/samaaron/sonic-pi/commits?author=kitterma) (2)
* [William W. Wu](https://github.com/samaaron/sonic-pi/commits?author=willy-vvu) (2)
* [Mistral Contrastin](https://github.com/samaaron/sonic-pi/commits?author=madgen) (2)
* [Domingo Gómez](https://github.com/samaaron/sonic-pi/commits?author=domgomcom) (2)
* [Louis Pilfold](https://github.com/samaaron/sonic-pi/commits?author=lpil) (2)
* [Will Stephenson](https://github.com/samaaron/sonic-pi/commits?author=wstephenson) (2)
* [Daniel Canelhas](https://github.com/samaaron/sonic-pi/commits?author=dcanelhas) (2)
* [Franz Laügt](https://github.com/samaaron/sonic-pi/commits?author=znarf94) (2)
* [Michael Henry](https://github.com/samaaron/sonic-pi/commits?author=neoCrimeLabs) (2)
* [Phil Hagelberg](https://github.com/samaaron/sonic-pi/commits?author=technomancy) (2)
* [Sunder Bal](https://github.com/samaaron/sonic-pi/commits?author=SunderB) (2)
* [Bruce Adams](https://github.com/samaaron/sonic-pi/commits?author=bruceadams) (2)
* [Ben Nuttall](https://github.com/samaaron/sonic-pi/commits?author=bennuttall) (2)
* [Tommi Toivonen](https://github.com/samaaron/sonic-pi/commits?author=hullum) (1)
* [Uriel Corfa](https://github.com/samaaron/sonic-pi/commits?author=korfuri) (1)
* [Veith Roethlingshoefer](https://github.com/samaaron/sonic-pi/commits?author=RunOrVeith) (1)
* [Enrike Hurtado](https://github.com/samaaron/sonic-pi/commits?author=enrike) (1)
* [Kevin Chau](https://github.com/samaaron/sonic-pi/commits?author=kevinchau321) (1)
* [Linda van der Pal](https://github.com/samaaron/sonic-pi/commits?author=lvdpal) (1)
* [Sam Conran](https://github.com/samaaron/sonic-pi/commits?author=sampointone) (1)
* [Paul Winstanley](https://github.com/samaaron/sonic-pi/commits?author=sccmentor) (1)
* [Tom Holford](https://github.com/samaaron/sonic-pi/commits?author=tomholford) (1)
* [Aspasia Beneti](https://github.com/samaaron/sonic-pi/commits?author=aspasia) (1)
* [Björn Ekström](https://github.com/samaaron/sonic-pi/commits?author=bjornekstrom) (1)
* [Brujo Rojas](https://github.com/samaaron/sonic-pi/commits?author=brujo-rojas) (1)
* [Sebastian Stahn](https://github.com/samaaron/sonic-pi/commits?author=stahnirockt) (1)
* [Christoph B. Wurzinger](https://github.com/samaaron/sonic-pi/commits?author=chbw) (1)
* [Jose Añasco](https://github.com/samaaron/sonic-pi/commits?author=merongivian) (1)
* [Adlai](https://github.com/samaaron/sonic-pi/commits?author=adlai) (1)
* [Alex McLean](https://github.com/samaaron/sonic-pi/commits?author=yaxu) (1)
* [Christian Perfect](https://github.com/samaaron/sonic-pi/commits?author=christianp) (1)
* [Cosmin Stroe](https://github.com/samaaron/sonic-pi/commits?author=cstroe) (1)
* [Dionysis Zindros](https://github.com/samaaron/sonic-pi/commits?author=dionyziz) (1)
* [Eugene Kovalev](https://github.com/samaaron/sonic-pi/commits?author=wl8dr3) (1)
* [Graham Taylor](https://github.com/samaaron/sonic-pi/commits?author=vinnievg) (1)
* [Ivan Zarea](https://github.com/samaaron/sonic-pi/commits?author=minivan) (1)
* [James Smith](https://github.com/samaaron/sonic-pi/commits?author=nanomancer) (1)
* [James Watson](https://github.com/samaaron/sonic-pi/commits?author=jawatson) (1)
* [Jamie Brandon](https://github.com/samaaron/sonic-pi/commits?author=jamii) (1)
* [Joe Armstrong](https://github.com/samaaron/sonic-pi/commits?author=joearms) (1)
* [Joseph Haig](https://github.com/samaaron/sonic-pi/commits?author=jrmhaig) (1)
* [John Lawrence Aspden](https://github.com/samaaron/sonic-pi/commits?author=johnlawrenceaspden) (1)
* [Karl Hiner](https://github.com/samaaron/sonic-pi/commits?author=khiner) (1)
* [Michel Kraaijeveld](https://github.com/samaaron/sonic-pi/commits?author=LandDragoon) (1)
* [Marko Peltola](https://github.com/samaaron/sonic-pi/commits?author=markopeltola) (1)
* [Matthew Gilliard](https://github.com/samaaron/sonic-pi/commits?author=mjg123) (1)
* [Michał Lewandowski](https://github.com/samaaron/sonic-pi/commits?author=mlevvy) (1)
* [Morgan Owens](https://github.com/samaaron/sonic-pi/commits?author=equiamos) (1)
* [Neal McBurnett](https://github.com/samaaron/sonic-pi/commits?author=nealmcb) (1)
* [Nigel Michki](https://github.com/samaaron/sonic-pi/commits?author=nigeil) (1)
* [Pierre De Wilde](https://github.com/samaaron/sonic-pi/commits?author=pierredewilde) (1)
* [Piotr Jagielski](https://github.com/samaaron/sonic-pi/commits?author=pjagielski) (1)
* [Reuben Brown](https://github.com/samaaron/sonic-pi/commits?author=reubenbrown) (1)
* [Roland Schmid](https://github.com/samaaron/sonic-pi/commits?author=Pr0gm4n) (1)
* [Roman Milovskiy](https://github.com/samaaron/sonic-pi/commits?author=dcromster) (1)
* [Russell Jones](https://github.com/samaaron/sonic-pi/commits?author=Russell-Jones) (1)
* [Ruzsa Balázs](https://github.com/samaaron/sonic-pi/commits?author=cellux) (1)
* [Ryan Bigg](https://github.com/samaaron/sonic-pi/commits?author=radar) (1)
* [Sandy Maguire](https://github.com/samaaron/sonic-pi/commits?author=isovector) (1)
* [Siim Põder](https://github.com/samaaron/sonic-pi/commits?author=windo) (1)
* [Thibaut Barrère](https://github.com/samaaron/sonic-pi/commits?author=thbar) (1)
* [Tom den Braber](https://github.com/samaaron/sonic-pi/commits?author=tomdenbraber) (1)
* [Tomek Rabczak](https://github.com/samaaron/sonic-pi/commits?author=tomekr) (1)

## Translation

The following volunteers have generously helped to translate Sonic Pi
into additional languages:


* Łukasz Siwiński (148)
* Kenichi Kanai (119)
* Hanno Zulla (118)
* Nico Staelens (82)
* Sam Aaron (40)
* Nicolas Dermine (39)
* Olympia Brikis (35)
* Cindy Dallaire (32)
* Federico Pepe (30)
* Mircea Patrascu (29)
* Daria Szatan (26)
* Petter Reinholdtsen (25)
* Ricardo Pozo (23)
* Mauro João Salgado Figueira (23)
* Giovanni Mori (21)
* Yann Pavlenko (20)
* Ruben Tobalina (17)
* Wolfgang Werner (14)
* Pau Monfort (13)
* Álvaro Cáceres Muñoz (12)
* G. Martin Butz (12)
* Ole Erik Yrvin (8)
* Elena Ogaderova (8)
* Tiago Morais Morgado (8)
* Paulo Chiliguano (7)
* Berkin Kadiroğlu (7)
* Rachid Ben Moussa (7)
* Jan Lund (7)
* Kristjan Räts (7)
* Oto Popis (7)
* Stanislav Senveter (6)
* Hong Lees (6)
* Rekc@h (6)
* Олексій Овдієнко (6)
* Keiko Machiya (6)
* Timo Dankert (6)
* Daniele Paradiso (6)
* Mahmutcan İlhandağ (6)
* Matthieu Ottaviani (6)
* Francisco Llaryora (5)
* Surajnath Sidh (5)
* Björn Ekström (5)
* Nur Sodik (5)
* Theodore Tsirpanis (5)
* Nicolas Limage (5)
* Carlos Arturo Guerra Parra (5)
* Hayato Osanai (5)
* Ettore Atalan (5)
* Michiel Leegwater (5)
* Sebastian Stahn (5)
* Hannes Fritz (5)
* Muamer Ribica (5)
* Diego Gurnari (4)
* Servaas Tilkin (4)
* Allan Nordhøy (4)
* artyomisflash@mail.ru (4)
* Marco Giordano (4)
* Jakob Bo Kristensen (4)
* Edson Cunha (4)
* Miroslav Hrabal (4)
* João Medeiros (4)
* Thomas G. Kristensen (4)
* Esteban Betancur (3)
* Adrian Nöthlich (3)
* Lupa Lupin (3)
* Daria Szatan (3)
* Madis Liias (3)
* Alban Vidal (3)
* Dago Sondervan (3)
* Juhyun Lee (3)
* Hou Chen Zhong (3)
* Tasos Protopapas (3)
* Nathan Van der Auwera (3)
* Yang Wanjun (3)
* Jiaxi Gu (3)
* Tuomas Pyylampi (3)
* Sebastien van der Kwast (3)
* Moisés Cachay Tello (3)
* Andreas Linz (3)
* Raúl Jiménez Martín (3)
* Anton Shestakov (3)
* Martin Zeilinger (3)
* snoop13@gmail.com (3)
* Sander Kesting (3)
* Chenebel Dorian (3)
* Michel Echevres (3)
* László van den Hoek (3)
* Gabriel Barba Gonzalez (2)
* Joschka Heinrich (2)
* Szymon Jakubiak (2)
* Hugo Vila (2)
* Evgeni Latuhin (2)
* Louis Wolf (2)
* André Sá (2)
* Nicolas Cosson (2)
* Pierre Pintado (2)
* Sugahara Masayuki (2)
* Ivan Decard (2)
* Duarte Botelho (2)
* Rodrigo Muniz (2)
* Sebastian Rasmussen (2)
* Serge Stinckwich (2)
* Stefan Höhn (2)
* Vincent Renard (2)
* Haowen You (2)
* Samuel El-Borai (2)
* Tomás Vilariño (2)
* Luis Lloret (2)
* Giovanni Domeneghini (2)
* Emlyn Corrin (2)
* Fabian Aussems (2)
* Genek Tomashko (2)
* Dimitris Panokostas (2)
* Franz Laügt (2)
* Anders Berggren (2)
* Rodrigo Iglesias (2)
* Brujo Rojas (2)
* Martin Solheim (1)
* Luis Garcia (1)
* Leonardo Mendes Miraglia (1)
* ladyalgo@outlook.com (1)
* Lu Lecocq (1)
* Kurushina Margarita (1)
* Tom Julux (1)
* Ivan Krylov (1)
* Italo Adler (1)
* Fernando Alberto Ribeiro Tavar (1)
* Feodor Aleksandrov (1)
* Eugene Kovalev (1)
* Carlos David Perales Cejudo (1)
* Arnaud BOS (1)
* Matthias Cavigelli (1)
* Christoph B. Wurzinger (1)
* Andrey Raspopov (1)
* Mateusz Bielec (1)
* Michael Fulton (1)
* Иван Лавриков (1)
* Federico Saccà (1)
* Diemesleno Souza Carvalho (1)
* Ethan Crawford (1)
* Tomasz Nurkiewicz (1)
* wimjaap@gmail.com (1)
* Aaro Hillilä (1)
* Alessandro Kiefer (1)
* Andras Nemeth (1)
* Aron Birkir Gudmundsson (1)
* Artem Blinov (1)
* Baran Umut Mutlu (1)
* Cem Olcay (1)
* David Pilato (1)
* Gabriel Macedo (1)
* Guillaume Gautier (1)
* Hyemin Shim (1)
* Cyprien Huissoud (1)
* Hrafnkell Eiríksson (1)
* Ingrid Yrvin (1)
* Jeff Huang (1)
* Jesper Juellund Jensen (1)
* Joek van Montfort (1)
* joosts.playground@gmail.com (1)
* Jose Añasco (1)
* Lari Oesch (1)
* Martin-Zack Mekkaoui (1)
* Mattias Roos (1)
* Mikkel Gravgaard (1)
* Nadezhda Ratckevich (1)
* Paulo Amaral (1)
* Xavier Riley (1)
* Rogério Pimentel (1)
* Sıtkı Bağdat (1)
* Thodoris Bais (1)
* Tommi Toivonen (1)
* Veres Károly (1)
* Vitezslav Homolka (1)
* Aaro Asikainen (1)
* Huiting Milewski (1)
* Cristian Cabrera (1)
* André Klöpfel (1)
* Abdeselam El-Haman (1)
* Filip Faste (1)
* Enrike Hurtado (1)
* Wilson Dashing (1)
* Davide Giovannini (1)
* Vladimir Knyazev (1)
* Stephan Schuster (1)
* Rafael Capaci Pereira (1)
* Peter Bolch (1)
* Per-Erik Westerberg (1)
* Pedro Fernandes (1)
* Miguel García (1)
* Martin Gondermann (1)



## Inspiration

The following is a far from complete list of some of the individuals who
have provided inspiration for the creation of Sonic Pi through their own
projects:

* _why (why the lucky stiff) - [Shoes](https://en.wikipedia.org/wiki/Shoes_(GUI_toolkit))
* Andrew Sorensen  - [Extempore](http://extempore.moso.com.au)
* James McCartney - [SuperCollider](https://supercollider.github.io)
* Jeff Rose - [Overtone](https://overtone.github.com)
* Linda Liukas - [Hello Ruby](http://www.helloruby.com/)
* Matz (Yukihiro Matsumoto まつもとゆきひろ) - [Ruby](https://www.ruby-lang.org)
* Rich Hickey - [Clojure](https://clojure.org)
* Seymour Papert - [Logo](https://en.wikipedia.org/wiki/Logo_(programming_language))
* The Scratch Team - [Scratch](https://scratch.mit.edu)
* Thor Magnusson - [ixi lang](http://www.ixi-audio.net/content/body_software_ixilang.html) 


## Core Team Thanks

Sam Aaron would like to express his deep thanks to his family and
friends who have supported him over the years and given him the strength
to continue on this strange and often unforgiving path. He would
particularly like to thank his friend and partner Susanna and also his
fab Mum.

Luis Lloret wants to thank his wonderful family for their understanding
and support while working on this. Specially Marina, you are my reason
to live. Mar and Darío, keep being so special and giving us so much joy.

Xavier Riley would like to thank his wife Emily, and he'd like to
reassure her that he definitely loves her more than any computer. Also
big thanks to conference organizers, in particular Simon Starr for
putting on the awesome Bath Ruby conferences and letting me rock out
there not [once](https://youtu.be/Jp0VKD_7pmw?t=10m1s), but
[twice](https://www.youtube.com/watch?v=L06FlSoiBi4). Lastly I'd like to
thank Scott Wilson for teaching me some programming as part of a music
degree, and my good friend David Bamber for helping me get started as a
programmer.

Adrian Cheater dedicates this space in loving memory of her mother,
Katherine Cheater. Mom shared her passion for music and performance
and equipped me with all the tools I needed to live life fully. She was
kind, but did not let the opinions of strangers deter her from her path.
Though mom never met me as her daughter, I know she would have been proud
that I chose to embrace my truth as it became known to me.
My wish is that you, fellow musician, will also choose to never dampen your
light, and that you will encourage and empower others to shine bright.

Robin Newman would like to thank Sam for producing such inspirational
software as Sonic Pi. Both the sounds that it can produce and the
intricate programming beneath the surface are a work of art. To work
with Sonic Pi gives me such a buzz as I have not experienced since
working with Music on a network of BBC Micros in the 1980s. Then as now
my Wife Julia describes herself as a computer widow. I thank her for
putting up with my passion for musical programming over the years.

Ethan Crawford is grateful to his parents for giving him the opportunity
of music lessons as a young boy, and all the skills and interests that
this helped to develop. He'd also like to thank Sam for creating Sonic
Pi and the ease and fun with which it combines two of his favourite
interests - music and programming.
