// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import * as m from 'mithril';

import {showModal} from '../modal';
import {FORCE_RESET_MESSAGE} from './recording_ui_utils';

export function couldNotClaimInterface(
    onReset: () => Promise<void>, onCancel: () => void) {
  let hasPressedAButton = false;
  showModal({
    title: 'Could not claim the USB interface',
    content: m(
        'div',
        m('text',
          'This can happen if you have the Android Debug Bridge ' +
              '(adb) running on your workstation or any other tool which is ' +
              'taking exclusive access of the USB interface.'),
        m('br'),
        m('br'),
        m('text.small-font',
          'Resetting will cause the ADB server to disconnect and ' +
              'will try to reassign the interface to the current browser.'),
        ),
    buttons: [
      {
        text: FORCE_RESET_MESSAGE,
        primary: true,
        id: 'force_USB_interface',
        action: () => {
          hasPressedAButton = true;
          onReset();
        },
      },
      {
        text: 'Cancel',
        primary: false,
        id: 'cancel_USB_interface',
        action: () => {
          hasPressedAButton = true;
          onCancel();
        },
      },
    ],
  }).then(() => {
    // If the user has clicked away from the modal, we interpret that as a
    // 'Cancel'.
    if (!hasPressedAButton) {
      onCancel();
    }
  });
}
