/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGICSTI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgCreateStringINI(char *name, char *string)
	int cfgCreateExpandINI(char *name, char *string)

	Write new string into the currently opened INI file for writing.
	'ExpandINI()' creates an expandable string (a string which may
	contain environment variables, which are expanded when read)

ob(ject): cfgCreateExpandINI
su(bsystem): inifile/1
sh(ort description):  Append an expandable string value to the INI file
lo(ng description): Append an expandable string value to the INI file currently opened for writing.
pr: \para{name} != NULL
re(lated to): cfgCreateStringINI
fi(le): cfgicsti.c
in(itialized by): cfgCreateINI cfgCreateSectionINI cfgEraseSection

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGICSTI.C 1.5 2001/02/27 01:27:25 ska Exp ska $";
#endif

static int mkString(const char * const name
	, const char * const string, int expandable)
{	int rv;
	char *newstring;

	DBG_ENTER("cfgicsti.c<mkString>", Suppl_inifile1)
	DBG_ARGUMENTS( ("name=\"%s\", str=\"%s\", expandable=%d", name, string, expandable) )

	chkHeap
	if(string == 0)
		newstring = 0;
	else if((newstring = cfgi_quoteString(string)) == 0)
		DBG_RETURN_I( CFG_ERR_MEM)

	chkHeap
	rv = cfgi_putValue(name, expandable
		? CFG_TEXPSTRING: CFG_TSTRING, newstring);
	chkHeap
	free(newstring);
	chkHeap
	DBG_RETURN_I( rv)
}

int cfgCreateStringINI(const char * const name, const char * const string)
{	DBG_ENTER("cfgCreateStringINI", Suppl_inifile1)
	DBG_ARGUMENTS( ("name=\"%s\", str=\"%s\"", name, string) )
	DBG_RETURN_BI( mkString(name, string, 0))
}

int cfgCreateExpandINI(const char * const name, const char * const string)
{	DBG_ENTER("cfgCreateExpandINI", Suppl_inifile1)
	DBG_ARGUMENTS( ("name=\"%s\", str=\"%s\"", name, string) )
	DBG_RETURN_BI(  mkString(name, string, 1))
}

