/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.binpack;

import com.kreative.binpack.ColorFormat;
import com.kreative.binpack.DFExpression;
import com.kreative.binpack.DFExpressionLexer;
import com.kreative.binpack.DFExpressionParser;
import com.kreative.binpack.DataField;
import com.kreative.binpack.DataType;
import com.kreative.binpack.DateFormat;
import com.kreative.binpack.ElaborationType;
import com.kreative.binpack.FPUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class DataFormatParser {
    private static final int LOOKAHEAD_LIMIT = 65536;
    private static final List<DataField> POINT = new Vector<DataField>();
    private static final List<DataField> RECT = new Vector<DataField>();
    private static final List<DataField> COLOR = new Vector<DataField>();
    private static final Object[][] TYPES;
    private Reader reader;

    static {
        POINT.add(new DataField(DataType.SINT, 16, false, null, null, "y", "Y coordinate"));
        POINT.add(new DataField(DataType.SINT, 16, false, null, null, "x", "X coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "top", "top Y coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "left", "left X coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "bottom", "bottom Y coordinate"));
        RECT.add(new DataField(DataType.SINT, 16, false, null, null, "right", "right X coordinate"));
        COLOR.add(new DataField(DataType.UINT, 16, false, null, null, "red", "red channel intensity"));
        COLOR.add(new DataField(DataType.UINT, 16, false, null, null, "green", "green channel intensity"));
        COLOR.add(new DataField(DataType.UINT, 16, false, null, null, "blue", "blue channel intensity"));
        TYPES = new Object[][]{{"character", DataType.CHAR}, {"rectangle", DataType.STRUCT, 0, false, RECT}, {"rgbcolour", DataType.STRUCT, 0, false, COLOR}, {"bitfield", DataType.BITFIELD}, {"datetime", DataType.DATE}, {"rgbcolor", DataType.STRUCT, 0, false, COLOR}, {"boolean", DataType.BOOLEAN}, {"complex", DataType.COMPLEX}, {"pstring", DataType.PSTRING}, {"cstring", DataType.CSTRING}, {"eightcc", DataType.CHAR, 64}, {"wstring", DataType.PSTRING, 16}, {"lstring", DataType.PSTRING, 32}, {"wcharbe", DataType.CHAR, 16, false, "UTF-16BE"}, {"wcharle", DataType.CHAR, 16, true, "UTF-16BE"}, {"ufixed", DataType.UFIXED}, {"sfixed", DataType.SFIXED}, {"filler", DataType.FILLER}, {"binary", DataType.BINARY}, {"struct", DataType.STRUCT}, {"offset", DataType.OFFSET}, {"string", DataType.CSTRING}, {"colour", DataType.COLOR}, {"bshort", DataType.BINT, 16}, {"oshort", DataType.OINT, 16}, {"hshort", DataType.HINT, 16}, {"ushort", DataType.UINT, 16}, {"sshort", DataType.SINT, 16}, {"single", DataType.FLOAT, 32}, {"double", DataType.FLOAT, 64}, {"fourcc", DataType.CHAR, 32}, {"ostype", DataType.CHAR, 32, false, "MACROMAN"}, {"symbol", DataType.CHAR, 64, false, "ISO-8859-1"}, {"float", DataType.FLOAT}, {"color", DataType.COLOR}, {"magic", DataType.MAGIC}, {"align", DataType.ALIGN}, {"fixed", DataType.SFIXED}, {"bbyte", DataType.BINT, 8}, {"obyte", DataType.OINT, 8}, {"hbyte", DataType.HINT, 8}, {"ubyte", DataType.UINT, 8}, {"sbyte", DataType.SINT, 8}, {"short", DataType.SINT, 16}, {"blong", DataType.BINT, 64}, {"olong", DataType.OINT, 64}, {"hlong", DataType.HINT, 64}, {"ulong", DataType.UINT, 64}, {"slong", DataType.SINT, 64}, {"onecc", DataType.CHAR, 8}, {"twocc", DataType.CHAR, 16}, {"wchar", DataType.CHAR, 16, false, "UTF-16BE"}, {"point", DataType.STRUCT, 0, false, POINT}, {"enum", DataType.ENUM}, {"bint", DataType.BINT}, {"oint", DataType.OINT}, {"hint", DataType.HINT}, {"uint", DataType.UINT}, {"sint", DataType.SINT}, {"char", DataType.CHAR}, {"date", DataType.DATE}, {"bool", DataType.BOOLEAN}, {"time", DataType.DATE}, {"blob", DataType.BINARY}, {"byte", DataType.SINT, 8}, {"long", DataType.SINT, 64}, {"half", DataType.FLOAT, 16}, {"real", DataType.FLOAT, 32}, {"quad", DataType.FLOAT, 128}, {"rect", DataType.STRUCT, 0, false, RECT}, {"int", DataType.SINT}, {"occ", DataType.CHAR, 8}, {"tcc", DataType.CHAR, 16}, {"fcc", DataType.CHAR, 32}, {"ecc", DataType.CHAR, 64}};
    }

    public DataFormatParser(Reader r) {
        this.reader = r;
    }

    public boolean isShortForm() throws IOException {
        this.parseWhitespace();
        this.reader.mark(65536);
        int numchars = 0;
        while (Character.isLetter(this.reader.read())) {
            ++numchars;
        }
        this.reader.reset();
        return numchars < 2;
    }

    public List<DataField> parseAuto() throws IOException {
        if (this.isShortForm()) {
            return this.parseShortForm();
        }
        return this.parseLongForm();
    }

    public List<DataField> parseLongForm() throws IOException {
        Vector<DataField> format = new Vector<DataField>();
        while (!this.atEnd()) {
            Object elaboration;
            boolean littleEndian;
            int size;
            Object[] dt = this.parseDataType();
            DataType datatype = (DataType)((Object)dt[1]);
            if (dt.length > 2) {
                size = ((Number)dt[2]).intValue();
            } else if (datatype.usesSize()) {
                this.parseWhitespace();
                size = this.parseFieldSize(datatype.defaultSize());
            } else {
                size = 0;
            }
            if (dt.length > 3) {
                littleEndian = (Boolean)dt[3];
            } else if (datatype.usesEndianness()) {
                this.parseWhitespace();
                littleEndian = this.parseEndianness();
            } else {
                littleEndian = false;
            }
            if (dt.length > 4) {
                elaboration = dt[4];
            } else if (datatype.usesElaboration()) {
                this.parseWhitespace();
                elaboration = this.parseElaboration(size, datatype.elaborationType());
            } else {
                elaboration = null;
            }
            this.parseWhitespace();
            DFExpression count = this.parseItemCount();
            this.parseWhitespace();
            String name = this.parseFieldName();
            this.parseWhitespace();
            String description = this.parseFieldDescription();
            this.parseWhitespace();
            this.parseTerminator();
            format.add(new DataField(datatype, size, littleEndian, elaboration, count, name, description));
        }
        return format;
    }

    public List<DataField> parseShortForm() throws IOException {
        Vector<DataField> format = new Vector<DataField>();
        while (!this.atEnd()) {
            Object elaboration;
            int size;
            Object[] dt = this.parseShortDataType();
            DataType datatype = (DataType)((Object)dt[0]);
            if (datatype.usesSize()) {
                this.parseWhitespace();
                size = this.parseFieldSize(datatype.defaultSize());
            } else {
                size = 0;
            }
            boolean littleEndian = datatype.usesEndianness() ? (Boolean)dt[1] : false;
            if (datatype.usesElaboration()) {
                this.parseWhitespace();
                elaboration = this.parseElaboration(size, datatype.elaborationType());
            } else {
                elaboration = null;
            }
            this.parseWhitespace();
            DFExpression count = this.parseItemCount();
            this.parseWhitespace();
            String name = this.parseShortFieldName();
            this.parseWhitespace();
            String description = this.parseShortFieldDescription();
            format.add(new DataField(datatype, size, littleEndian, elaboration, count, name, description));
        }
        return format;
    }

    public static String toLongString(List<DataField> format) {
        StringBuffer s = new StringBuffer();
        for (DataField df : format) {
            DataType dt = df.type();
            s.append(dt.toString());
            if (dt.usesSize()) {
                s.append(df.size());
            }
            if (dt.usesEndianness()) {
                s.append(DataFormatParser.endiannessToString(df.littleEndian()));
            }
            if (dt.usesElaboration() && df.elaboration() != null) {
                s.append(" ");
                s.append(DataFormatParser.elaborationToString(dt.elaborationType(), df.elaboration()));
            }
            if (df.count() != null) {
                s.append(" ");
                s.append(DataFormatParser.itemCountToString(df.count()));
            }
            if (df.name() != null) {
                s.append(" ");
                s.append(DataFormatParser.fieldNameToString(df.name()));
            }
            if (df.description() != null) {
                s.append(" ");
                s.append(DataFormatParser.fieldDescriptionToString(df.description()));
            }
            s.append(";\n");
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }

    public static String toShortString(List<DataField> format) {
        StringBuffer s = new StringBuffer();
        for (DataField df : format) {
            DataType dt = df.type();
            if (dt.usesEndianness()) {
                if (df.littleEndian()) {
                    s.append(dt.toShortString().toLowerCase());
                } else {
                    s.append(dt.toShortString().toUpperCase());
                }
            } else {
                s.append(dt.toShortString());
            }
            if (dt.usesSize()) {
                s.append(df.size());
            }
            if (dt.usesElaboration() && df.elaboration() != null) {
                s.append(DataFormatParser.elaborationToShortString(dt.elaborationType(), df.elaboration()));
            }
            if (df.count() != null) {
                s.append(DataFormatParser.itemCountToString(df.count()));
            }
            if (df.name() != null) {
                s.append(DataFormatParser.fieldNameToShortString(df.name()));
            }
            if (df.description() == null) continue;
            s.append(DataFormatParser.fieldDescriptionToShortString(df.description()));
        }
        return s.toString();
    }

    private boolean atEnd() throws IOException {
        this.reader.mark(65536);
        while (true) {
            int ch;
            if ((ch = this.reader.read()) < 0) {
                return true;
            }
            if (!Character.isWhitespace(ch)) break;
            this.reader.mark(65536);
        }
        this.reader.reset();
        return false;
    }

    private void parseWhitespace() throws IOException {
        this.reader.mark(65536);
        while (Character.isWhitespace(this.reader.read())) {
            this.reader.mark(65536);
        }
        this.reader.reset();
    }

    private Object[] parseDataType() throws IOException {
        this.reader.mark(65536);
        Object[][] objectArray = TYPES;
        int n = TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] dt = objectArray[n2];
            char[] nc = new char[dt[0].toString().length()];
            this.reader.read(nc);
            if (new String(nc).equalsIgnoreCase(dt[0].toString())) {
                return dt;
            }
            this.reader.reset();
            ++n2;
        }
        throw new RuntimeException("Parse error: expected data type");
    }

    private Object[] parseShortDataType() throws IOException {
        this.reader.mark(65536);
        int ch = this.reader.read();
        DataType dt = DataType.fromChar((char)ch);
        if (dt == null) {
            this.reader.reset();
            throw new RuntimeException("Parse error: expected data type");
        }
        return new Object[]{dt, Character.isLowerCase(ch)};
    }

    private int parseFieldSize(int def) throws IOException {
        this.reader.mark(65536);
        int numchars = 0;
        while (Character.isDigit(this.reader.read())) {
            ++numchars;
        }
        this.reader.reset();
        if (numchars == 0) {
            return def;
        }
        int size = 0;
        while (numchars-- > 0) {
            size *= 10;
            size += Character.digit(this.reader.read(), 10);
        }
        return size;
    }

    private boolean parseEndianness() throws IOException {
        this.reader.mark(65536);
        int char1 = this.reader.read();
        int char2 = this.reader.read();
        if (!(char1 != 98 && char1 != 66 || char2 != 101 && char2 != 69)) {
            return false;
        }
        if (!(char1 != 108 && char1 != 76 || char2 != 101 && char2 != 69)) {
            return true;
        }
        this.reader.reset();
        return false;
    }

    private static String endiannessToString(boolean littleEndian) {
        return littleEndian ? "le" : "be";
    }

    private Object parseElaboration(int size, ElaborationType elabType) throws IOException {
        this.reader.mark(65536);
        if (this.reader.read() == 123) {
            int ch;
            int level = 0;
            StringBuffer e = new StringBuffer();
            while ((ch = this.reader.read()) >= 0) {
                if (ch == 123) {
                    e.append(Character.toChars(ch));
                    ++level;
                    continue;
                }
                if (ch == 125) {
                    if (level == 0) break;
                    e.append(Character.toChars(ch));
                    --level;
                    continue;
                }
                e.append(Character.toChars(ch));
            }
            String es = e.toString();
            switch (elabType) {
                case TEXT_ENCODING: {
                    return es.trim().toUpperCase();
                }
                case DATE_FORMAT: {
                    return this.parseDateFormat(es);
                }
                case COLOR_FORMAT: {
                    return new ColorFormat(size, es);
                }
                case FP_FORMAT: {
                    return this.parseFPFormat(es);
                }
                case VALUE: {
                    return this.parseInt(es);
                }
                case KV_SIGNED: {
                    return this.parseIntStringMap(-1, es);
                }
                case KV_UNSIGNED: {
                    return this.parseIntStringMap(size, es);
                }
                case STRUCT: {
                    return new DataFormatParser(new StringReader(es)).parseAuto();
                }
            }
            return es;
        }
        this.reader.reset();
        switch (elabType) {
            case TEXT_ENCODING: {
                return "ISO-8859-1";
            }
            case DATE_FORMAT: {
                return new DateFormat(DateFormat.UNIX);
            }
            case COLOR_FORMAT: {
                return new ColorFormat(size, "ARGB");
            }
            case FP_FORMAT: {
                return new int[]{FPUtilities.optimalSignWidth(size), FPUtilities.optimalExponentWidth(size), FPUtilities.optimalMantissaWidth(size), FPUtilities.optimalBias(FPUtilities.optimalExponentWidth(size))};
            }
            case VALUE: {
                return BigInteger.ZERO;
            }
            case KV_SIGNED: {
                return new HashMap();
            }
            case KV_UNSIGNED: {
                return new HashMap();
            }
            case STRUCT: {
                return new Vector();
            }
        }
        return "";
    }

    private static String elaborationToString(ElaborationType elabType, Object elab) {
        StringBuffer s = new StringBuffer();
        s.append("{");
        switch (elabType) {
            case TEXT_ENCODING: {
                s.append(elab.toString().toUpperCase());
                break;
            }
            case DATE_FORMAT: {
                s.append(DataFormatParser.dateFormatToString((DateFormat)elab));
                break;
            }
            case COLOR_FORMAT: {
                s.append(((ColorFormat)elab).toString());
                break;
            }
            case FP_FORMAT: {
                s.append(DataFormatParser.fpFormatToString((int[])elab));
                break;
            }
            case VALUE: {
                s.append(elab.toString());
                break;
            }
            case KV_SIGNED: 
            case KV_UNSIGNED: {
                Map m = (Map)elab;
                s.append("\n\t");
                s.append(DataFormatParser.mapToString(m).trim().replace("\n", "\n\t"));
                s.append("\n");
                break;
            }
            case STRUCT: {
                List format = (List)elab;
                s.append("\n\t");
                s.append(DataFormatParser.toLongString(format).trim().replace("\n", "\n\t"));
                s.append("\n");
                break;
            }
            default: {
                s.append(elab.toString());
            }
        }
        s.append("}");
        return s.toString();
    }

    private static String elaborationToShortString(ElaborationType elabType, Object elab) {
        StringBuffer s = new StringBuffer();
        s.append("{");
        switch (elabType) {
            case TEXT_ENCODING: {
                s.append(elab.toString().toUpperCase());
                break;
            }
            case DATE_FORMAT: {
                s.append(DataFormatParser.dateFormatToString((DateFormat)elab));
                break;
            }
            case COLOR_FORMAT: {
                s.append(((ColorFormat)elab).toString());
                break;
            }
            case FP_FORMAT: {
                s.append(DataFormatParser.fpFormatToString((int[])elab));
                break;
            }
            case VALUE: {
                s.append(elab.toString());
                break;
            }
            case KV_SIGNED: 
            case KV_UNSIGNED: {
                Map m = (Map)elab;
                s.append(DataFormatParser.mapToShortString(m));
                break;
            }
            case STRUCT: {
                List format = (List)elab;
                s.append(DataFormatParser.toShortString(format));
                break;
            }
            default: {
                s.append(elab.toString());
            }
        }
        s.append("}");
        return s.toString();
    }

    private DFExpression parseItemCount() throws IOException {
        this.reader.mark(65536);
        if (this.reader.read() == 91) {
            String cs;
            int ch;
            int level = 0;
            StringBuffer c = new StringBuffer();
            while ((ch = this.reader.read()) >= 0) {
                if (ch == 91) {
                    c.append(Character.toChars(ch));
                    ++level;
                    continue;
                }
                if (ch == 93) {
                    if (level == 0) break;
                    c.append(Character.toChars(ch));
                    --level;
                    continue;
                }
                c.append(Character.toChars(ch));
            }
            if ((cs = c.toString().trim()).length() == 0) {
                return null;
            }
            return new DFExpressionParser(new DFExpressionLexer(new StringReader(cs))).parse();
        }
        this.reader.reset();
        return null;
    }

    private static String itemCountToString(DFExpression expr) {
        return "[" + expr.toString() + "]";
    }

    private String parseFieldName() throws IOException {
        this.reader.mark(65536);
        int firstChar = this.reader.read();
        if (firstChar == 96) {
            int nextChar;
            StringBuffer s = new StringBuffer();
            while ((nextChar = this.reader.read()) >= 0 && nextChar != 96) {
                s.append(Character.toChars(nextChar));
            }
            return s.toString();
        }
        if (firstChar == 95 || Character.isLetter(firstChar)) {
            int nextChar;
            this.reader.mark(65536);
            int numChars = 0;
            while ((nextChar = this.reader.read()) >= 0 && (Character.isDigit(nextChar) || Character.isLetter(nextChar) || nextChar == 95)) {
                ++numChars;
            }
            this.reader.reset();
            StringBuffer s = new StringBuffer();
            s.append(Character.toChars(firstChar));
            while (numChars-- > 0) {
                s.append(Character.toChars(this.reader.read()));
            }
            return s.toString();
        }
        this.reader.reset();
        return null;
    }

    private String parseShortFieldName() throws IOException {
        this.reader.mark(65536);
        int firstChar = this.reader.read();
        if (firstChar == 96) {
            int nextChar;
            StringBuffer s = new StringBuffer();
            while ((nextChar = this.reader.read()) >= 0 && nextChar != 96) {
                s.append(Character.toChars(nextChar));
            }
            return s.toString();
        }
        this.reader.reset();
        return null;
    }

    private static String fieldNameToString(String s) {
        if (s.matches("^[A-Za-z_][A-Za-z0-9_]*$")) {
            return s;
        }
        return "`" + s.replace("`", "") + "`";
    }

    private static String fieldNameToShortString(String s) {
        return "`" + s.replace("`", "") + "`";
    }

    private String parseFieldDescription() throws IOException {
        int nextChar;
        this.reader.mark(65536);
        int firstChar = this.reader.read();
        if (firstChar == 34 || firstChar == 39) {
            int nextChar2;
            StringBuffer s = new StringBuffer();
            while ((nextChar2 = this.reader.read()) >= 0 && nextChar2 != firstChar) {
                s.append(Character.toChars(nextChar2));
            }
            return s.toString();
        }
        if (firstChar < 0 || firstChar == 59) {
            this.reader.reset();
            return null;
        }
        this.reader.mark(65536);
        int numChars = 0;
        while ((nextChar = this.reader.read()) >= 0 && nextChar != 59) {
            ++numChars;
        }
        this.reader.reset();
        StringBuffer s = new StringBuffer();
        s.append(Character.toChars(firstChar));
        while (numChars-- > 0) {
            s.append(Character.toChars(this.reader.read()));
        }
        String ds = s.toString().trim();
        if (ds.length() == 0) {
            return null;
        }
        return ds;
    }

    private String parseShortFieldDescription() throws IOException {
        this.reader.mark(65536);
        int firstChar = this.reader.read();
        if (firstChar == 34 || firstChar == 39) {
            int nextChar;
            StringBuffer s = new StringBuffer();
            while ((nextChar = this.reader.read()) >= 0 && nextChar != firstChar) {
                s.append(Character.toChars(nextChar));
            }
            return s.toString();
        }
        this.reader.reset();
        return null;
    }

    private static String fieldDescriptionToString(String s) {
        if (!s.contains("\"")) {
            return "\"" + s + "\"";
        }
        if (!s.contains("'")) {
            return "'" + s + "'";
        }
        if (!s.contains(";")) {
            return s;
        }
        return "\"" + s.replace("\"", "") + "\"";
    }

    private static String fieldDescriptionToShortString(String s) {
        if (!s.contains("\"")) {
            return "\"" + s + "\"";
        }
        if (!s.contains("'")) {
            return "'" + s + "'";
        }
        return "\"" + s.replace("\"", "") + "\"";
    }

    private void parseTerminator() throws IOException {
        this.reader.mark(65536);
        int ch = this.reader.read();
        if (ch >= 0 && ch != 59) {
            this.reader.reset();
            throw new RuntimeException("Parse error: expected terminator");
        }
    }

    private DateFormat parseDateFormat(String s) {
        String[] ss = s.trim().split("\\s*[.,:;]\\s*");
        switch (ss.length) {
            case 7: {
                return new DateFormat(Integer.parseInt(ss[0]), 0 + Integer.parseInt(ss[1]) - 1, Integer.parseInt(ss[2]), Integer.parseInt(ss[3]), Integer.parseInt(ss[4]), Integer.parseInt(ss[5]), Integer.parseInt(ss[6]));
            }
            case 6: {
                return new DateFormat(Integer.parseInt(ss[0]), 0 + Integer.parseInt(ss[1]) - 1, Integer.parseInt(ss[2]), Integer.parseInt(ss[3]), Integer.parseInt(ss[4]), Integer.parseInt(ss[5]));
            }
            case 4: {
                return new DateFormat(Integer.parseInt(ss[0]), 0 + Integer.parseInt(ss[1]) - 1, Integer.parseInt(ss[2]), Integer.parseInt(ss[3]));
            }
            case 3: {
                return new DateFormat(Integer.parseInt(ss[0]), 0 + Integer.parseInt(ss[1]) - 1, Integer.parseInt(ss[2]));
            }
            case 2: {
                return new DateFormat(Integer.parseInt(ss[0]), Integer.parseInt(ss[1]));
            }
            case 1: {
                return new DateFormat(Integer.parseInt(ss[0]));
            }
        }
        throw new RuntimeException("Invalid date format");
    }

    private static String dateFormatToString(DateFormat df) {
        Calendar epoch = df.getEpoch();
        int scale = df.getScale();
        StringBuffer s = new StringBuffer();
        s.append(epoch.get(1));
        s.append(",");
        s.append(epoch.get(2) - 0 + 1);
        s.append(",");
        s.append(epoch.get(5));
        s.append(",");
        s.append(epoch.get(11));
        s.append(",");
        s.append(epoch.get(12));
        s.append(",");
        s.append(epoch.get(13));
        s.append(",");
        s.append(scale);
        return s.toString();
    }

    private int[] parseFPFormat(String s) {
        String[] ss = s.trim().split("\\s*[.,:;]\\s*");
        switch (ss.length) {
            case 4: {
                return new int[]{Integer.parseInt(ss[0]), Integer.parseInt(ss[1]), Integer.parseInt(ss[2]), Integer.parseInt(ss[3])};
            }
            case 3: {
                return new int[]{Integer.parseInt(ss[0]), Integer.parseInt(ss[1]), Integer.parseInt(ss[2]), FPUtilities.optimalBias(Integer.parseInt(ss[1]))};
            }
        }
        throw new RuntimeException("Invalid FP format");
    }

    private static String fpFormatToString(int[] i) {
        StringBuffer s = new StringBuffer();
        s.append(i[0]);
        s.append(".");
        s.append(i[1]);
        s.append(".");
        s.append(i[2]);
        s.append(".");
        s.append(i[3]);
        return s.toString();
    }

    private BigInteger parseInt(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'")) {
            BigInteger r = BigInteger.ZERO;
            char[] cArray = s.substring(1, s.length() - 1).toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                r = r.shiftLeft(8);
                r = r.or(BigInteger.valueOf((long)ch & 0xFFL));
                ++n2;
            }
            return r;
        }
        if (s.startsWith("0x") || s.startsWith("0X") || s.startsWith("U+") || s.startsWith("U-") || s.startsWith("u+") || s.startsWith("u-")) {
            return new BigInteger(s.substring(2).trim(), 16);
        }
        if (s.startsWith("0o") || s.startsWith("0O")) {
            return new BigInteger(s.substring(2).trim(), 8);
        }
        if (s.startsWith("0b") || s.startsWith("0B")) {
            return new BigInteger(s.substring(2).trim(), 2);
        }
        if (s.startsWith("$")) {
            return new BigInteger(s.substring(1).trim(), 16);
        }
        if (s.startsWith("0") && s.length() > 1) {
            return new BigInteger(s.substring(1).trim(), 8);
        }
        return new BigInteger(s);
    }

    private Map<BigInteger, String> parseIntStringMap(int width, String s) {
        BigInteger km = width > 0 ? BigInteger.ONE.shiftLeft(width).subtract(BigInteger.ONE) : null;
        HashMap<BigInteger, String> kvm = new HashMap<BigInteger, String>();
        String[] kvs = s.trim().split("\\s*[,;]\\s*");
        BigInteger klast = BigInteger.ONE.negate();
        String[] stringArray = kvs;
        int n = kvs.length;
        int n2 = 0;
        while (n2 < n) {
            String kvl = stringArray[n2];
            String[] kvf = kvl.split("\\s*[.:=]\\s*", 2);
            if (kvf.length > 1) {
                klast = this.parseInt(kvf[0]);
                if (km != null) {
                    klast = klast.and(km);
                }
                kvm.put(klast, kvf[1]);
            } else {
                klast = klast.add(BigInteger.ONE);
                if (km != null) {
                    klast = klast.and(km);
                }
                kvm.put(klast, kvf[0]);
            }
            ++n2;
        }
        return kvm;
    }

    private static String mapToString(Map<?, ?> m) {
        TreeMap tm = new TreeMap();
        for (Map.Entry<?, ?> e : m.entrySet()) {
            if (e.getKey() instanceof Comparable) {
                tm.put((Comparable)e.getKey(), e.getValue());
                continue;
            }
            tm = null;
            break;
        }
        if (tm != null) {
            m = tm;
        }
        StringBuffer s = new StringBuffer();
        for (Map.Entry<?, ?> e : m.entrySet()) {
            s.append(e.getKey().toString());
            s.append(" = ");
            s.append(e.getValue().toString());
            s.append(";\n");
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }

    private static String mapToShortString(Map<?, ?> m) {
        TreeMap tm = new TreeMap();
        for (Map.Entry<?, ?> e : m.entrySet()) {
            if (e.getKey() instanceof Comparable) {
                tm.put((Comparable)e.getKey(), e.getValue());
                continue;
            }
            tm = null;
            break;
        }
        if (tm != null) {
            m = tm;
        }
        StringBuffer s = new StringBuffer();
        for (Map.Entry<?, ?> e : m.entrySet()) {
            s.append(e.getKey().toString());
            s.append("=");
            s.append(e.getValue().toString());
            s.append(";");
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == ';') {
            s.deleteCharAt(s.length() - 1);
        }
        return s.toString();
    }
}

