# CiviCRM 5.33.0

Released January 6, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Feature to provide most used countries in top section of Country select
  list ([19025](https://github.com/civicrm/civicrm-core/pull/19025))**

  A new option for Pinned Countries allows administrators to specify one or more
  commonly-used countries to appear at the top of the select list of countries
  when it appears on forms.

- **Send email to contacts when clicking on their email address on the contact's
  card (Work Towards
  [dev/core#1790](https://lab.civicrm.org/dev/core/-/issues/1790):
  [19082](https://github.com/civicrm/civicrm-core/pull/19082))**

  This improves user experience by preventing tooltips from closing as long as
  the user's mouse is inside of the tooltip element.

- **Unhide oauth extension
  ([19107](https://github.com/civicrm/civicrm-core/pull/19107))**

  Makes the Oauth extension available for upgrade on the extensions form.

- **Support utf8mb4 so notes can save Emojis and other good things (Work Towards
  [dev/core#339](https://lab.civicrm.org/dev/core/-/issues/339):
  [18960](https://github.com/civicrm/civicrm-core/pull/18960))**

  When installing CiviCRM, this makes it so mysql tables are created as
  utf8mb4 instead of utf8 by default.

- **crm-ui-debug - If in debug mode, then load pretty-printer for JSON data
  ([18994](https://github.com/civicrm/civicrm-core/pull/18994))**

  Improves debugging experience on AngularJS-based pages by printing debug data
  formatted nicely instead of as a large text blob.

- **afform_html - Include Monaco dependencies
  ([dev/core#2197](https://lab.civicrm.org/dev/core/-/issues/2197):
  [18988](https://github.com/civicrm/civicrm-core/pull/18988))**

  The afform_html extension depends upon the Monaco Editor.  This loads the
  Monaco library as part of core CiviCRM using Composer.

- **API - Finer-grained permissions for the dashboard & dashlet entities
  ([18962](https://github.com/civicrm/civicrm-core/pull/18962))**

  The API no longer requires the "administer CiviCRM" permission to access
  dashboard records.  Contacts with "access CiviCRM" can read dashboard records
  for contacts they have access to, and write permissions for non-admins are
  restricted to editing only their own dashboard.

- **Improve APIv4 metadata for RelationshipCache and Bridge entities in general
  ([19101](https://github.com/civicrm/civicrm-core/pull/19101))**

  Core changes needed so that Search Kit can support joins.

- **Use trait instead of class for Entity Bridges; add OptionList trait
  ([19010](https://github.com/civicrm/civicrm-core/pull/19010))**

  Improves APIv4 categorization of entities, which is then used to improve the
  Search Kit UI.

- **Improve schema metadata for Search Kit
  ([19075](https://github.com/civicrm/civicrm-core/pull/19075))**

  Improves the relevance of entities listed in Search Kit by only displaying
  entities designated as searchable.

- **Search kit joins
  ([19150](https://github.com/civicrm/civicrm-core/pull/19150) and
  [19105](https://github.com/civicrm/civicrm-core/pull/19105))**

  Adds support for multiple and multi-layered joins in Search Kit.

- **Afform - Update fields and HTML mode in web-based editors
  ([19053](https://github.com/civicrm/civicrm-core/pull/19053))**

  Improves Afform administration screens by adding descriptions for the inputs
  and a way to view/edit the HTML formulation.

- **Afform - Generate dashlets based on `Afform.is_dashlet` property.
  ([19005](https://github.com/civicrm/civicrm-core/pull/19005))**

  Makes it easier to expose a custom form on the CiviCRM dashboard by making it
  so each Afform can be flagged with is_dashlet=1; when toggled, it will
  register or unregister the dashlet.

- **Update Resource URL Helptext
  ([19046](https://github.com/civicrm/civicrm-core/pull/19046))**

  Updates Resource URL field help text to accurately reflect today's best
  practice.

- **Improve bootstrap3 checkbox theming
  ([19006](https://github.com/civicrm/civicrm-core/pull/19006))**

  Adds some reusable styling for check boxes in Bootstrap.

- **changes social media iframes/scripts to links, simplifies markup, adds email
  & bootstrap classes
  ([18880](https://github.com/civicrm/civicrm-core/pull/18880))**

  Improves the display of the "Help Spread the word" section for sites using the
  standard theme (Greenwich).

- **Add standard Contact fields to the Bookkeeping report template
  ([19008](https://github.com/civicrm/civicrm-core/pull/19008))**

  Improves the Bookkeeping report template by adding standard contact fields.

- **Allow Angular modules to require Resource bundles
  ([18987](https://github.com/civicrm/civicrm-core/pull/18987))**

  Permits Angular modules to require "bundles" from Civi::Resources.

- **Extensions UI tweak
  ([18981](https://github.com/civicrm/civicrm-core/pull/18981))**

  The subheader for extensions in the listing is now the description rather than
  the key.  The details in the expanded listing are also reordered.

### CiviContribute

- **Cancel first contribution associated to membership, cancels the
  membership (Work Towards
  [dev/core#927](https://lab.civicrm.org/dev/core/-/issues/927):
  [19012](https://github.com/civicrm/civicrm-core/pull/19012)
  [19014](https://github.com/civicrm/civicrm-core/pull/19014) and
  [19015](https://github.com/civicrm/civicrm-core/pull/19015))**

  Extends the contributioncancelactions extension to also work for Failed
  contributions, cleans up related code and adds a test.

- **Deprecate BaseIPN functions validateData & LoadObject
  (Work Towards [dev/financial#148](https://lab.civicrm.org/dev/financial/-/issues/148):
  [19033](https://github.com/civicrm/civicrm-core/pull/19033),
  [19034](https://github.com/civicrm/civicrm-core/pull/19034),
  [19035](https://github.com/civicrm/civicrm-core/pull/19035),
  [18947](https://github.com/civicrm/civicrm-core/pull/18947) and
  [19043](https://github.com/civicrm/civicrm-core/pull/19043))**

  Work towards simplifying the CiviContribute code.

- **Remove detail about updating related components when editing a
  contribution status
  ([dev/core#2158](https://lab.civicrm.org/dev/core/-/issues/2158):
  [18961](https://github.com/civicrm/civicrm-core/pull/18961))**

  Removes some details from the message when editing a contribution status which
  improves performance.

### CiviGrant

- **Add Grant v4 api
  ([19020](https://github.com/civicrm/civicrm-core/pull/19020))**

  Makes the Grant entity available in APIv4.

### CiviMember

- **Remove 'onlinePendingContribution' payment support from membership edit form
  ([dev/core#2155](https://lab.civicrm.org/dev/core/-/issues/2155):
  [18964](https://github.com/civicrm/civicrm-core/pull/18964))**

  Removes "Update Payment Status" checkbox from Membership Edit Form to improve
  user experience by simplifying the UI.

### WordPress Integration

- **Add action parameter to PCP shortcode
  ([dev/wordpress#63](https://lab.civicrm.org/dev/wordpress/-/issues/63):
  [19058](https://github.com/civicrm/civicrm-core/pull/19058) and
  [226](https://github.com/civicrm/civicrm-wordpress/pull/226))**

  Improves the PCP short code by adding an action parameter for which the options
  are "info" and "transact". When the action parameter is set to "info" the page
  displays the PCP info page, when it is set as "transact" the page displays the
  relevant PCP contribution form.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Multiple available languages disables kcfinder
  ([dev/core#2263](https://lab.civicrm.org/dev/core/-/issues/2263):
  [19245](https://github.com/civicrm/civicrm-core/pull/19245))**

- **upgrade can't find service
  ([dev/core#2232](https://lab.civicrm.org/dev/core/-/issues/2232):
  [19141](https://github.com/civicrm/civicrm-core/pull/19141) and
  [19192](https://github.com/civicrm/civicrm-core/pull/19192))**

  Fixes an upgrade bug where `CachedCiviContainer` has stale data after an
  upgrade.

- **Can't export contacts
  ([dev/core#2230](https://lab.civicrm.org/dev/core/-/issues/2230):
  [19104](https://github.com/civicrm/civicrm-core/pull/19104))**

  Fixes DB Error when you try to export contacts without selecting "All Primary
  Fields".

- **APIv4 - Fix dynamic bridge joins (used by Search Kit)
  ([19159](https://github.com/civicrm/civicrm-core/pull/19159))**

  Fixes a few bugs in Search Kit where extra rows were returned due to a
  misconstructed join in APIv4, or in some cases the join would completely fail.

- **afform - Get default field `<label>` from `label` instead of `title`
  ([18989](https://github.com/civicrm/civicrm-core/pull/18989))**

  Updates afform/core and afform/gui to use better default labels -- e.g.
  when you add the gender_id field, it should default to "Gender" (label)
  instead of "Gender ID" (title).

- **afform/gui - Fix rendering of the "Form Settings"
  ([18990](https://github.com/civicrm/civicrm-core/pull/18990))**

  Ensures that "URL" and "Permissions" are displayed on the Afform Form Settings
  form.

- **Fix undeclared afform requirement of ngRoute
  ([18975](https://github.com/civicrm/civicrm-core/pull/18975))**

  Fixes a crash when embedding an afform directive on other Angular pages.

- **Do not attempt to obsolete primary key on log tables (Work Towards
  [dev/core#2120](https://lab.civicrm.org/dev/core/-/issues/2120):
  [18748](https://github.com/civicrm/civicrm-core/pull/18748))**

- **BUG: when changing a group option value CiviCRM does not update existing
  records ([dev/core#2153](https://lab.civicrm.org/dev/core/-/issues/2153):
  [18959](https://github.com/civicrm/civicrm-core/pull/18959) and
  [18912](https://github.com/civicrm/civicrm-core/pull/18912))**

- **Reports cannot filter for Contacts with multiple selections in a
  multi-select Custom Field
  ([dev/core#2162](https://lab.civicrm.org/dev/core/-/issues/2162):
  [18978](https://github.com/civicrm/civicrm-core/pull/18978))**

- **Custom fields of type "Integer" with radio buttons can cause Advanced Search
  to break ([dev/core#2188](https://lab.civicrm.org/dev/core/-/issues/2188):
  [19123](https://github.com/civicrm/civicrm-core/pull/19123) and
  [18970](https://github.com/civicrm/civicrm-core/pull/18970))**

- **E_NOTICE when calling CRM_Core_BAO_SchemaHandler::createTable with logging
  turned on ([dev/core#2190](https://lab.civicrm.org/dev/core/-/issues/2190):
  [18985](https://github.com/civicrm/civicrm-core/pull/18985))**

- **E_NOTICE when creating custom field of type select
  ([dev/core#2196](https://lab.civicrm.org/dev/core/-/issues/2196):
  [18991](https://github.com/civicrm/civicrm-core/pull/18991))**

- **APIv3 - Fix legacy handling for html_type Autocomplete-Select
  ([18949](https://github.com/civicrm/civicrm-core/pull/18949))**

- **Fix Invalid argument PHP warning
  ([19219](https://github.com/civicrm/civicrm-core/pull/19219))**

- **DispatchPolicy - Actively report any upgrade problems with
  hook_civicrm_permission
  ([19217](https://github.com/civicrm/civicrm-core/pull/19217))**

- **Fix failure to assign view tpl variables to view page if context=search is
  in the url ([19189](https://github.com/civicrm/civicrm-core/pull/19189))**

- **Check for membership type fee before applying tax
  ([19007](https://github.com/civicrm/civicrm-core/pull/19007))**

- **Don't break clickthrough URLs when there's leading whitespace
  ([18965](https://github.com/civicrm/civicrm-core/pull/18965))**

- **Add a way to choose between nl_NL and nl_BE
  ([18963](https://github.com/civicrm/civicrm-core/pull/18963))**

- **Ensure "civicrm_initialized" action only fires once
  ([221](https://github.com/civicrm/civicrm-wordpress/pull/221))**

- **Search kit - fix bugs introduced during refactoring
  ([19261](https://github.com/civicrm/civicrm-core/pull/19261))**

- **Fix "Save Matching Contact" button ([dev/core#2287](https://lab.civicrm.org/dev/core/-/issues/2287):
  [19328](https://github.com/civicrm/civicrm-core/pull/19328))**

### CiviCampaign

- **Campaigns > Reserve Respondents causes SQL error
  ([dev/core#2172](https://lab.civicrm.org/dev/core/-/issues/2172):
  [18948](https://github.com/civicrm/civicrm-core/pull/18948))**

  Fixes a bug where searching for respondents to a campaign resulted in a SQL
  error.

### CiviContribute

- **Next scheduled recurring date set to 0 - details emerging (Work Towards
  [dev/core#2231](https://lab.civicrm.org/dev/core/-/issues/2231):
  [19119](https://github.com/civicrm/civicrm-core/pull/19119))**

  Fixes failure to calculate next_scheduled_date for contribution series
  initiated on CiviCRM 5.29 or later.

- **Paypal Standard IPNs not being correctly handled leaving contributions as
  Pending (incomplete transaction) (Work Towards
  [dev/core#1931](https://lab.civicrm.org/dev/core/-/issues/1931):
  [18980](https://github.com/civicrm/civicrm-core/pull/18980))**

  Prevents PayPal from double-encoding the IPN Notify URL.

- **Orange Paypal Pro button not redirecting properly after reCaptcha on Paypal
  ([dev/financial#153](https://lab.civicrm.org/dev/financial/-/issues/153):
  [18993](https://github.com/civicrm/civicrm-core/pull/18993))**

- **civicrm_api3_contribution_transact deprecation message has broken docs link
  ([dev/core#2235](https://lab.civicrm.org/dev/core/-/issues/2235):
  [19139](https://github.com/civicrm/civicrm-core/pull/19139))**

- **Handle possibility of fee_amount = ''
  ([19120](https://github.com/civicrm/civicrm-core/pull/19120))**

### CiviEvent

- **"Self-service eligibility" has incorrect behavior when "hours to cancel" is
  zero ([dev/event#44](https://lab.civicrm.org/dev/event/-/issues/44):
  [18950](https://github.com/civicrm/civicrm-core/pull/18950))**

  Don't allow self-service cancelling after an event when 'hours to cancel' is
  zero.

- **Find Participants: Broken "Edit" button
  ([dev/core#2248](https://lab.civicrm.org/dev/core/-/issues/2248):
  [19183](https://github.com/civicrm/civicrm-core/pull/19183))**

- **E_NOTICE when deleting participant
  ([19011](https://github.com/civicrm/civicrm-core/pull/19011))**

- **CiviEvent - Error registering participants via search task
  ([19125](https://github.com/civicrm/civicrm-core/pull/19125))**

- **Event Full: fix translation regression
  ([19027](https://github.com/civicrm/civicrm-core/pull/19027))**

### CiviMember

- **Export selected entries in Membership search results when selecting fields:
  all results are returned, not selected entries
  ([dev/core#2246](https://lab.civicrm.org/dev/core/-/issues/2246):
  [19176](https://github.com/civicrm/civicrm-core/pull/19176))**

### Drupal Integration

- **Wrong link to Drupal's permissions page
  ([dev/drupal#146](https://lab.civicrm.org/dev/drupal/-/issues/146):
  [18986](https://github.com/civicrm/civicrm-core/pull/18986))**

  Ensure that the link to Drupal Access Control points to the right place
  regardless of which Drupal version you are using (it was broken for Drupal 8
  integrations).

- **D8/D9 Fix Session Start Handling
  ([dev/drupal#149](https://lab.civicrm.org/dev/drupal/-/issues/149):
  [19044](https://github.com/civicrm/civicrm-core/pull/19044))**

- **Update civicrm.module install links
  ([630](https://github.com/civicrm/civicrm-drupal/pull/630) and
  [629](https://github.com/civicrm/civicrm-drupal/pull/629))**

### WordPress Integration

- **Upgrade CiviCRM 5.28.3 to 5.30.0 with Clean URLs and WordPress Base Page
  "CiviCRM" breaks Mosaico IMG URLs and Email Tracked URLs (Partial Fix For
  [dev/core#2213](https://lab.civicrm.org/dev/core/-/issues/2213):
  [19063](https://github.com/civicrm/civicrm-core/pull/19063))**

  Ensures WordPress does not show a 404 when wpBasePage is saved in mixed-case
  (e.g. "CiviCRM") and that it renders CiviCRM content as expected.

- **Fix assignment of base page template
  ([227](https://github.com/civicrm/civicrm-wordpress/pull/227))**

## <a name="misc"></a>Miscellany

- **Standardise more params in completeOrder
  ([18952](https://github.com/civicrm/civicrm-core/pull/18952))**

- **Fix mglaman mapping
  ([19134](https://github.com/civicrm/civicrm-core/pull/19134))**

- **Fix APIv4 test to assert an exception is thrown
  ([19009](https://github.com/civicrm/civicrm-core/pull/19009))**

- **Menu links for Petitions, Surveys do not open correct tab (Cleanup towards
  [dev/core#2215](https://lab.civicrm.org/dev/core/-/issues/2215):
  [19065](https://github.com/civicrm/civicrm-core/pull/19065))**

- **Handle emojis less fatally where not supported (Test for
  [dev/core#2165](https://lab.civicrm.org/dev/core/-/issues/2165):
  [18918](https://github.com/civicrm/civicrm-core/pull/18918))**

- **Clean up search actions in core to make them available from search builder
  (Clean Up Towards [dev/core#2066](https://lab.civicrm.org/dev/core/-/issues/2066):
  [18772](https://github.com/civicrm/civicrm-core/pull/18772))**

- **finish 'this round' of completeOrder
  cleanup(Work Towards [dev/financial#152](https://lab.civicrm.org/dev/financial/-/issues/152):
  [19016](https://github.com/civicrm/civicrm-core/pull/19016))**

- **Minor code cleanup - dedupe isNull checks
  ([18819](https://github.com/civicrm/civicrm-core/pull/18819))**

- **Rewrite jquery.dashboard.js as Angular app
  ([18971](https://github.com/civicrm/civicrm-core/pull/18971))**

- **Delete outdated/unused crmExample Angular module
  ([19049](https://github.com/civicrm/civicrm-core/pull/19049))**

- **Deprecate UFGroup::add parameter ids
  ([19060](https://github.com/civicrm/civicrm-core/pull/19060))**

- **Extract function that generates upgrade link for extensions
  ([19070](https://github.com/civicrm/civicrm-core/pull/19070))**

- **[REF] For the time being have phpcs ignore eval usages
  ([225](https://github.com/civicrm/civicrm-wordpress/pull/225))**

- **[REF] Remove xssString as it is providing a false sense of security
  ([312](https://github.com/civicrm/civicrm-packages/pull/312))**

- **[REF] Minor variable cleanup
  ([18935](https://github.com/civicrm/civicrm-core/pull/18935))**

- **[Ref] Use variables directly
  ([18936](https://github.com/civicrm/civicrm-core/pull/18936))**

- **[REF] Remove always FALSE variable from transitionComponents
  ([18983](https://github.com/civicrm/civicrm-core/pull/18983))**

- **[REF] Decouple crmD3 angular module from CiviMail
  ([19047](https://github.com/civicrm/civicrm-core/pull/19047))**

- **[REF] Remove xssString as it is providing a false sense of security
  ([19045](https://github.com/civicrm/civicrm-core/pull/19045))**

- **[REF] remove obscure use of objects from A.net
  ([19040](https://github.com/civicrm/civicrm-core/pull/19040))**

- **[REF] Simplify sendNotification determination
  ([19054](https://github.com/civicrm/civicrm-core/pull/19054))**

- **[REF] Stop passing objects to recur in paypal pro - pass specific objects
  ([19041](https://github.com/civicrm/civicrm-core/pull/19041))**

- **[REF] remove obscure use of objects from Anet.ipn
  ([19039](https://github.com/civicrm/civicrm-core/pull/19039))**

- **[REF] Remove code Coleman hates
  ([19038](https://github.com/civicrm/civicrm-core/pull/19038))**

- **[REF] Simplify single function to receive contribution not objects
  ([19032](https://github.com/civicrm/civicrm-core/pull/19032))**

- **REF Simplify tokenProcessor code
  ([18612](https://github.com/civicrm/civicrm-core/pull/18612))**

- **[REF] Cleanup Ang modules in core to follow conventions
  ([19052](https://github.com/civicrm/civicrm-core/pull/19052))**

- **[REF] Remove excess handling around contact_id
  ([19050](https://github.com/civicrm/civicrm-core/pull/19050))**

- **Remove extra handling around contact id
  ([19051](https://github.com/civicrm/civicrm-core/pull/19051))**

- **Remove unused hook_civicrm_crudLink and switch to using metadata for
  crudLinks ([18916](https://github.com/civicrm/civicrm-core/pull/18916))**

- **Remove use of nullArray in delete hooks
  ([19059](https://github.com/civicrm/civicrm-core/pull/19059))**

- **Remove legacy check
  ([19042](https://github.com/civicrm/civicrm-core/pull/19042))**

- **Remove some deprecated code
  ([19037](https://github.com/civicrm/civicrm-core/pull/19037))**

- **Remove support for pre 4.2 Civi in drush
  ([628](https://github.com/civicrm/civicrm-drupal/pull/628))**

- **Remove always-true if
  ([18934](https://github.com/civicrm/civicrm-core/pull/18934))**

- **Remove always true if
  ([18946](https://github.com/civicrm/civicrm-core/pull/18946))**

- **Remove return value on transitionComponents
  ([18979](https://github.com/civicrm/civicrm-core/pull/18979))**

- **Remove unused params, return params from processFail
  ([18998](https://github.com/civicrm/civicrm-core/pull/18998))**

- **Remove unused parameters from cancel
  ([18997](https://github.com/civicrm/civicrm-core/pull/18997))**

- **[NFC] Add in an Emoji test for APIv3 as per Eileen's PR
  ([19078](https://github.com/civicrm/civicrm-core/pull/19078))**

- **[NFC] Remove boilerplate comment from .ang.php files
  ([19048](https://github.com/civicrm/civicrm-core/pull/19048))**

- **[NFC] Minor margin tidy up
  ([19013](https://github.com/civicrm/civicrm-core/pull/19013))**

- **[NFC] Follow-on to 18963 to add example setting in civicrm.settings template
  for setting CMS inheritance for nl_BE
  ([18966](https://github.com/civicrm/civicrm-core/pull/18966))**

- **[NFC] Make all files conform to CiviCRM code styling
  ([223](https://github.com/civicrm/civicrm-wordpress/pull/223))**

- **[NFC] Housekeeping
  ([222](https://github.com/civicrm/civicrm-wordpress/pull/222))**

- **[NFC] Refactor plugin for greater clarity
  ([228](https://github.com/civicrm/civicrm-wordpress/pull/228))**

- **MembershipRenewalTest - Address assertions that started failing circa Jan 1,
  2021 ([19310](https://github.com/civicrm/civicrm-core/pull/19310))**

- **Fix various `ts()` strings ([19333](https://github.com/civicrm/civicrm-core/pull/19333))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Alexy Mikhailichenko; Asylum Seekers
Centre; Bluehorn Digital - Matt Glaman; Christian Wach; CiviCRM - Coleman Watts,
Tim Otten; CiviDesk - Sunil Pawar, Yashodha Chaku; CompuCorp - René Olivo; Coop
SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave D; enCircle Solutions Ltd. -
Darren Woods; Giant Rabbit - Peter Haight; JMA Consulting - Seamus Lee;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
Nicol Wistreich; Squiffle Consulting - Aidan Saunders; Tadpole Collective -
Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

a-n The Artists Information Company - William Mortada; Agileware - Justin
Freeman; CiviDesk - Nicolas Ganivet; Freeform Solutions - Herb van den Dool;
MJCO - Mikey O'Toole; Semper IT - Karin Gerritsen

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
