# CiviCRM 5.42.0

Released October 6, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Edit Contact: Hide email signatures for contacts that do not have a user/CMS
  account
  ([dev/user-interface#38](https://lab.civicrm.org/dev/user-interface/-/issues/38):
  [21103](https://github.com/civicrm/civicrm-core/pull/21103))**

  Improves the user interface by hiding the email signature section for contacts
  for whom it is not relevant.

- **Option to rename the file before downloading
  ([dev/core#2121](https://lab.civicrm.org/dev/core/-/issues/2121):
  [21006](https://github.com/civicrm/civicrm-core/pull/21006))**

  Gives the user the option to change the PDF file name on the "Print/Merge
  Document" screen.

- **Add Settings, Disable, Delete buttons to group contacts listing page
  (Work Towards [dev/core#2546](https://lab.civicrm.org/dev/core/-/issues/2546):
  [20135](https://github.com/civicrm/civicrm-core/pull/20135))**

  Adds a "Edit Group Settings" button that pops up the group settings edit
  overlay to the smog group page.

- **On logging detail report show the words not the numbers
  ([dev/core#2691](https://lab.civicrm.org/dev/core/-/issues/2691):
  [20907](https://github.com/civicrm/civicrm-core/pull/20907))**

  Improves logging by displaying more context.

- **Tokens - contributions - could we show them all?
  (Work Towards [dev/core#2745](https://lab.civicrm.org/dev/core/-/issues/2745):
  [21134](https://github.com/civicrm/civicrm-core/pull/21134))**

  Ensures support for the Contribution Token "contributionId".

- **Allow dedupe by websites
  ([dev/core#2770](https://lab.civicrm.org/dev/core/-/issues/2770):
  [21168](https://github.com/civicrm/civicrm-core/pull/21168))**

  Makes it so one can dedupe based on websites.

- **APIv4 pseudoconstant improvements
  ([21184](https://github.com/civicrm/civicrm-core/pull/21184))**

  Makes SearchKit handle large option lists more efficiently, and adds APIv4
  field metadata about available suffixes.

- **SearchKit - Add placeholder to token select
  ([21172](https://github.com/civicrm/civicrm-core/pull/21172))**

  Adds placeholder text to the token select dropdown in SearchKit.

- **Searchkit - Add grid display layout
  ([dev/core#2776](https://lab.civicrm.org/dev/core/-/issues/2776):
  [21194](https://github.com/civicrm/civicrm-core/pull/21194))**

  Adds support to display SearchKit results in a grid format.

- **SearchKit - Merge admin results table with searchDisplay code
  ([21069](https://github.com/civicrm/civicrm-core/pull/21069) and
  [21488](https://github.com/civicrm/civicrm-core/pull/21488))**

  Improves and streamlines the SearchKit Angular code to reconcile two
  different ways of fetching, formatting & displaying results. This reduces code
  duplication, while adding a few features from the admin table to all search
  display tables.

- **SearchKit - Add download CSV action
  ([21328](https://github.com/civicrm/civicrm-core/pull/21328))**

  Adds an option to SearchKit to download a CSV.

- **SearchKit - Add links to admin table and refresh after popups
  ([21343](https://github.com/civicrm/civicrm-core/pull/21343))**

  Adds quick-action links to the SearchKit admin results table.

- **SearchKit - Use a search display to display searches
  ([21270](https://github.com/civicrm/civicrm-core/pull/21270))**

  Simplifies code by using a SearchKit display to display searches.

- **Include random as an option when sorting displays
  ([dev/report#75](https://lab.civicrm.org/dev/report/-/issues/75):
  [21177](https://github.com/civicrm/civicrm-core/pull/21177))**

  Adds a sort option of random to SearchKit.

- **Searchkit: Add image field handler
  ([dev/core#2781](https://lab.civicrm.org/dev/core/-/issues/2781):
  [21300](https://github.com/civicrm/civicrm-core/pull/21300))**

  Makes it possible to show images in SearchKit displays.

- **SearchKit - Allow tokens in menu button text
  ([21217](https://github.com/civicrm/civicrm-core/pull/21217))**

  Makes it so users can include tokens in SearchKit menu button text.

- **TokenProcessor - Allow defining Smarty variables which are populated via
  token ([21336](https://github.com/civicrm/civicrm-core/pull/21336))**

  Allows more interoperability between Smarty expressions and tokens.

- **Token Parser - Allow tokens with multiple dots (eg
  {contribution.contribution_recur_id.amount})
  ([21076](https://github.com/civicrm/civicrm-core/pull/21076))**

  Adjusts the naming/parsing rules for Civi-style tokens so that tokens may
  include dots and colons.

- **Afform - support file uploads
  ([21150](https://github.com/civicrm/civicrm-core/pull/21150))**

  Supports file fields as part of Afform.

- **Not possible to set the location type (address, mail, telephone) to a
  specific value
  ([dev/core#2703](https://lab.civicrm.org/dev/core/-/issues/2703):
  [21254](https://github.com/civicrm/civicrm-core/pull/21254))**

  Makes it possible in Afform to select a single location type for an address,
  email, phone etc. block instead of having the field on the form.

- **Afform - Store submissions in a new database table
  ([21105](https://github.com/civicrm/civicrm-core/pull/21105))**

  Adds a Afform setting "log submissions", when checked, Afform submissions are
  stored in the database.

- **Move financial acl setting to the extension
  ([21120](https://github.com/civicrm/civicrm-core/pull/21120))**

  Moves financial ACL settings to the financial ACL extension.

- **SavedSearch - Add pseudoconstant for api_entity field
  ([21312](https://github.com/civicrm/civicrm-core/pull/21312))**

  Adds a pseudoconstant to facilitate display in the UI of what a search is for,
  e.g. ->addSelect('api_entity:label') would return "Contacts" for a search of
  Contacts.

- **Change the default PDF file name from "CiviLetter.pdf" to use the Activity
  Subject, if available
  ([21220](https://github.com/civicrm/civicrm-core/pull/21220))**

  Improves PDF file naming to be more specific.

- **Change PDF file name from "civicrmContributionReceipt.pdf" to use the
  standard "receipt.pdf" file name
  ([21221](https://github.com/civicrm/civicrm-core/pull/21221))**

  Improves PDF file naming.

- **Scheduled Reminders UI - Show more activity tokens in admin GUI
  ([21091](https://github.com/civicrm/civicrm-core/pull/21091))**

  Adds more Activity Tokens to the Scheduled Reminders UI.

### CiviContribute

- **Logging improvements for "Failed to update contribution in database"
  ([21243](https://github.com/civicrm/civicrm-core/pull/21243))**

  Improves logging when contribution fails.

- **Add recurring contributions to contribution reports
  (Work Towards [dev/report#63](https://lab.civicrm.org/dev/report/-/issues/63):
  [20168](https://github.com/civicrm/civicrm-core/pull/20168))**

  Adds "Contribution Recurring" as a filter, column and group by to the
  Contribution Summary Report.

### CiviMail

- **System Workflow Messages - Improve localization experience (Work Towards
  [dev/mail#83](https://lab.civicrm.org/dev/mail/-/issues/83):
  [21139](https://github.com/civicrm/civicrm-core/pull/21139))**

  Introduces a class contracts for system workflow messages which will enable
  richer APIs and UIs.

### CiviMember

- **Membership api for v4
  ([dev/core#2634](https://lab.civicrm.org/dev/core/-/issues/2634):
  [21106](https://github.com/civicrm/civicrm-core/pull/21106))**

  Adds the Membership entity to APIv4.

- **Fix code to use Order api to create Memberships in core forms
  (Work Towards [dev/core#2717](https://lab.civicrm.org/dev/core/-/issues/2717):
  [20936](https://github.com/civicrm/civicrm-core/pull/20936),
  [21126](https://github.com/civicrm/civicrm-core/pull/21126) and
  [20935](https://github.com/civicrm/civicrm-core/pull/20935))**

  Work towards using the Order API to create Memberships in core forms.

### Joomla Integration

- **CiviCRM-Joomla should accept web-service calls
  ([58](https://github.com/civicrm/civicrm-joomla/pull/58))**

  Ensures that on a stock configuration of CiviCRM-Joomla, it is possible to
  create a page-route for accepting web-service calls.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Multi-lingual: Contact Type label is cached regardless of language
  ([dev/translation#70](https://lab.civicrm.org/dev/translation/-/issues/70):
  [21268](https://github.com/civicrm/civicrm-core/pull/21268))**

  Fixes loading multiple translations within same page-view (OptionValues,
  ContactTypes).

- **Activity export broken - takes you to some other screen instead
  ([dev/core#2835](https://lab.civicrm.org/dev/core/-/issues/2835):
  [21456](https://github.com/civicrm/civicrm-core/pull/21456))**

- **APIv4 - entityBatch linkage
  ([dev/core#2682](https://lab.civicrm.org/dev/core/-/issues/2682):
  [21241](https://github.com/civicrm/civicrm-core/pull/21241))**

  Work Towards APIv4 entity parity. Ensures that the values for entity_table are
  discoverable.

- **Consider replacing fopen() call in CRM_Utils_File::isIncludable with
  stream_resolve_include_path()
  ([dev/core#2730](https://lab.civicrm.org/dev/core/-/issues/2730):
  [21060](https://github.com/civicrm/civicrm-core/pull/21060))**

  Replaces fopen call in CRM_Utils_File::isIncludable with one that doesn't need
  error-supression to avoid problems in php8.

- **SearchKit: have a quick Export task
  (Work Towards [dev/core#2732](https://lab.civicrm.org/dev/core/-/issues/2732):
  [21320](https://github.com/civicrm/civicrm-core/pull/21320))**

  Refactoring work towards making it possible to have a direct export feature in
  SearchKit.

- **SearchKit - Fix deleting search displays
  ([21444](https://github.com/civicrm/civicrm-core/pull/21444))**

- **SearchKit - Fix anonymous access to running search displays
  #([21752](https://github.com/civicrm/civicrm-core/pull/21752))**

  Recently SearchKit added the ability for anonymous users to access search
  displays. However, due to an oversight the feature doesn't actually work for
  anonymous users. This fixes the problem.

- **Afform - ensure dragging classes are removed when not sorting
  ([21750](https://github.com/civicrm/civicrm-core/pull/21750))**

  Fixes an annoying UI glitch in Afform where the screen can appear "locked" or
  "frozen" after dragging fields into a fieldset.

- **Expose Contribution token processor
  ([dev/core#2747](https://lab.civicrm.org/dev/core/-/issues/2747):
  [21046](https://github.com/civicrm/civicrm-core/pull/21046) and
  [21057](https://github.com/civicrm/civicrm-core/pull/21057))**

  Reconciles contribution legacy tokens and scheduled reminders tokens.

- **CRM_Core_BAO_CustomField::getChangeSerialize always returns a change
  ([dev/core#2762](https://lab.civicrm.org/dev/core/-/issues/2762):
  [21160](https://github.com/civicrm/civicrm-core/pull/21160))**

- **Caching issue on apiv4 + install
  ([dev/core#2763](https://lab.civicrm.org/dev/core/-/issues/2763):
  [21166](https://github.com/civicrm/civicrm-core/pull/21166))**

- **CiviCRM email validation failing incorrectly
  ([dev/core#2769](https://lab.civicrm.org/dev/core/-/issues/2769):
  [329](https://github.com/civicrm/civicrm-packages/pull/329) and
  [21169](https://github.com/civicrm/civicrm-core/pull/21169))**

- **Sort by date column on multirecord field listing section on profile edit
  mode doesn't work
  ([dev/core#2774](https://lab.civicrm.org/dev/core/-/issues/2774):
  [21191](https://github.com/civicrm/civicrm-core/pull/21191))**

- **Error when using search in 'Find and Merge Duplicate Contacts' page
  ([dev/core#2778](https://lab.civicrm.org/dev/core/-/issues/2778):
  [21223](https://github.com/civicrm/civicrm-core/pull/21223))**

- **Print/merge document has awkward filename if activity subject uses
  non-english letters
  ([dev/core#2789](https://lab.civicrm.org/dev/core/-/issues/2789):
  [21259](https://github.com/civicrm/civicrm-core/pull/21259))**

- **Contribution custom field tokens are duplicated in the dropdown
  ([dev/core#2806](https://lab.civicrm.org/dev/core/-/issues/2806):
  [21337](https://github.com/civicrm/civicrm-core/pull/21337))**

- **[regression] Search forms with entities that include File custom fields
  don't render in Afform Admin screen
  ([dev/core#2751](https://lab.civicrm.org/dev/core/-/issues/2751):
  [21084](https://github.com/civicrm/civicrm-core/pull/21084))**

- **APIv4 - Throw exception instead of munging illegal join aliases
  ([21072](https://github.com/civicrm/civicrm-core/pull/21072))**

  Improves APIv4 validation of explicit join aliases.

- **Fix deprecated API4 Join on Email in dynamic profile
  ([21308](https://github.com/civicrm/civicrm-core/pull/21308))**

- **Search Kit doesn't display related contact custom fields
  ([dev/report#73](https://lab.civicrm.org/dev/report/-/issues/73):
  [21071](https://github.com/civicrm/civicrm-core/pull/21071))**

- **SearchKit - Misc bulk action bug fixes
  ([21159](https://github.com/civicrm/civicrm-core/pull/21159))**

- **SearchKit - Fix aggregated joins
  ([21411](https://github.com/civicrm/civicrm-core/pull/21411))**

- **SearchKit - Fix pager count and add 'None Found' text in empty tables
  ([21333](https://github.com/civicrm/civicrm-core/pull/21333))**

- **Fix Searchkit "Add" columns button UI
  ([21315](https://github.com/civicrm/civicrm-core/pull/21315))**

- **Afform - Fix button appearance and block form during submission
  ([21287](https://github.com/civicrm/civicrm-core/pull/21287))**

- **Afform - fix contact source field & field defaults
  ([21228](https://github.com/civicrm/civicrm-core/pull/21228))**

- **Fix support link just added in oauth-client extension info.xml
  ([21256](https://github.com/civicrm/civicrm-core/pull/21256))**

- **better target multivalue checkbox and multiselect import validation
  ([21317](https://github.com/civicrm/civicrm-core/pull/21317))**

- **Do not add tracking to internal anchor URLs
  ([20115](https://github.com/civicrm/civicrm-core/pull/20115))**

- **Fix for new prefetch key
  ([21292](https://github.com/civicrm/civicrm-core/pull/21292))**

- **Do not enable custom activity search on new installs
  ([21260](https://github.com/civicrm/civicrm-core/pull/21260))**

- **Add date metadata for email.on_hold, reset_date
  ([21233](https://github.com/civicrm/civicrm-core/pull/21233))**

- **Add no-prefetch campaign pseudoconstants
  ([21185](https://github.com/civicrm/civicrm-core/pull/21185))**

- **Replace extension key with label during install/upgrade/disable/uninstall
  ([21094](https://github.com/civicrm/civicrm-core/pull/21094))**

- **ActionSchedule - Pass real batches into TokenProcessor. Simplify
  CRM_Activity_Tokens.
  ([21088](https://github.com/civicrm/civicrm-core/pull/21088))**

- **MessageTemplate::sendTemplate() - Accept `array $messageTemplate` and `array
  $tokenContext` ([21073](https://github.com/civicrm/civicrm-core/pull/21073))**

- **Alternate to 20131 - Avoid crash during import for blank lines in a
  one-column csv file
  ([21216](https://github.com/civicrm/civicrm-core/pull/21216))**

- **CRM_Queue_Service - Use ?? instead of error-supression operator
  ([21207](https://github.com/civicrm/civicrm-core/pull/21207))**

- **Respect http_timeout core setting for Guzzle HTTP requests
  ([21096](https://github.com/civicrm/civicrm-core/pull/21096))**

- **Smarty notice - Explicitly set hideRelativeLabel var on Find Cases form
  ([21070](https://github.com/civicrm/civicrm-core/pull/21070))**

- **(Smart Group) is being constantly added while editing the smart group title
  from 'Manage Group' page
  ([20898](https://github.com/civicrm/civicrm-core/pull/20898))**

- **Enotice fixes in tpl
  ([21170](https://github.com/civicrm/civicrm-core/pull/21170))**

- **Template fixes - notices, syntax
  ([21257](https://github.com/civicrm/civicrm-core/pull/21257))**

- **Fix invalid parameter giving E_WARNING
  ([21255](https://github.com/civicrm/civicrm-core/pull/21255))**

- **Fix search display access for non-admin users
  ([21082](https://github.com/civicrm/civicrm-core/pull/21082))**

- **Use convenience function for one-off token evaluations to avoid too-long
  filenames and possible privacy issues
  ([21140](https://github.com/civicrm/civicrm-core/pull/21140))**

- **Replace deprecated calls to `renderMessageTemplate()`
  ([21121](https://github.com/civicrm/civicrm-core/pull/21121))**

- **Scheduled Reminders - Pass locale through to TokenProcessor
  ([21085](https://github.com/civicrm/civicrm-core/pull/21085))**

### CiviCampaign

- **Fix caching on campaign pseudoconstant
  ([21083](https://github.com/civicrm/civicrm-core/pull/21083))**

### CiviContribute

- **Fix the check to see if the financialAclExtension is installed
  ([21077](https://github.com/civicrm/civicrm-core/pull/21077))**

- **Simplify ContributionView form. Always display "lineitems"
  ([21285](https://github.com/civicrm/civicrm-core/pull/21285))**

- **Can we re-order the 'recur links'
  ([dev/core#2843](https://lab.civicrm.org/dev/core/-/issues/2843):
  [21559](https://github.com/civicrm/civicrm-core/pull/21559))**

  The new link to View Template on a recurring contribution row is now moved to
  the end, allowing the Edit link to return to the second spot.

- **When a recurring contribution template has no line items, the contact
  contribution tab crashes
  ([dev/financial#187](https://lab.civicrm.org/dev/financial/-/issues/187):
  [21734](https://github.com/civicrm/civicrm-core/pull/21734))**

- **Call line item pre hook after tax amount is calculated
  ([21731](https://github.com/civicrm/civicrm-core/pull/21731))**

  `hook_civicrm_pre` is now invoked on a line item entity after the tax amount
  has been calculated for it.

### CiviMail

- **CiviCRM Mailing, function unsub_from_mailing has spelling error,
  "experiement" impacts A/B Mailing unsubscribes
  ([21245](https://github.com/civicrm/civicrm-core/pull/21245))**

- **In an email, a token from an extension in a subject will inhibits the same
  token group in the email body
  ([dev/core#2673](https://lab.civicrm.org/dev/core/-/issues/2673):
  [21080](https://github.com/civicrm/civicrm-core/pull/21080))**

- **Log details of mailing error and don't display details to end user
  ([21173](https://github.com/civicrm/civicrm-core/pull/21173))**

### CiviMember

- **Fix Membership.create in BAO to respect passed in status_id
  ([20976](https://github.com/civicrm/civicrm-core/pull/20976))**

- **Membership Dashboard - Fatal Error starting with 5.41.beta1
  ([dev/core#2758](https://lab.civicrm.org/dev/core/-/issues/2758):
  [21171](https://github.com/civicrm/civicrm-core/pull/21171) and
  [21167](https://github.com/civicrm/civicrm-core/pull/21167))**

- **Update MembershipType.duration and MembershipStatus.name to be required
  ([21119](https://github.com/civicrm/civicrm-core/pull/21119))**

- **Fix missing value of End Adjustment column from Membership status page
  ([21664](https://github.com/civicrm/civicrm-core/pull/21664))**

### Drupal Integration

- **Syntax errors when loading sample data
  ([dev/drupal#161](https://lab.civicrm.org/dev/drupal/-/issues/161):
  [648](https://github.com/civicrm/civicrm-drupal/pull/648))**

  Removes drush sample data install option that doesn't work.

- **Replace Drupal 9 user function, function getUsername is no more valid
  ([328](https://github.com/civicrm/civicrm-packages/pull/328))**

### Joomla Integration

- **Fixes unusable modals in Joomla 4
  ([21286](https://github.com/civicrm/civicrm-core/pull/21286))**

- **Tidies Joomla 4 integration (menu, padding) after final release
  ([21342](https://github.com/civicrm/civicrm-core/pull/21342))**

## <a name="misc"></a>Miscellany

- **MessageTemplate - Add renderTemplate(). Deprecate renderMessageTemplate().
  ([21115](https://github.com/civicrm/civicrm-core/pull/21115))**

- **Provided standard links in ext/oauth-client/info.xml, fixed typo
  ([21252](https://github.com/civicrm/civicrm-core/pull/21252))**

- **Use getter to get subscription id
  ([21309](https://github.com/civicrm/civicrm-core/pull/21309))**

- **Extract ACL contact cache clearing part out
  ([21219](https://github.com/civicrm/civicrm-core/pull/21219))**

- **Update quickform original
  ([330](https://github.com/civicrm/civicrm-packages/pull/330))**

- **Afform - Rename blocks and joins for clarity
  ([21218](https://github.com/civicrm/civicrm-core/pull/21218))**

- **Afform - Optimize Get by checking type
  ([21316](https://github.com/civicrm/civicrm-core/pull/21316))**

- **[REF] Cleanup pdf classes to use a trait like we do for email classes
  ([dev/core#2790](https://lab.civicrm.org/dev/core/-/issues/2790):
  [21334](https://github.com/civicrm/civicrm-core/pull/21334),
  [21305](https://github.com/civicrm/civicrm-core/pull/21305),
  [21310](https://github.com/civicrm/civicrm-core/pull/21310),
  [21276](https://github.com/civicrm/civicrm-core/pull/21276),
  [21297](https://github.com/civicrm/civicrm-core/pull/21297),
  [21331](https://github.com/civicrm/civicrm-core/pull/21331) and
  [21290](https://github.com/civicrm/civicrm-core/pull/21290))**

- **Upgrade angular-file-uploader to v2.6.1
  ([21081](https://github.com/civicrm/civicrm-core/pull/21081))**

- **Upgrade Pear/DB package to be version 1.11.0
  ([21087](https://github.com/civicrm/civicrm-core/pull/21087))**

- **CRM_Core_Component - Remove unused code
  ([21086](https://github.com/civicrm/civicrm-core/pull/21086))**

- **Move make-sure-single-set out of shared function
  ([21062](https://github.com/civicrm/civicrm-core/pull/21062))**

- **Remove unused, duplicate functions getEntitiesByTag
  ([21209](https://github.com/civicrm/civicrm-core/pull/21209))**

- **Remove deprecated function
  ([21179](https://github.com/civicrm/civicrm-core/pull/21179))**

- **Remove extraneous buildQuickForm
  ([21325](https://github.com/civicrm/civicrm-core/pull/21325))**

- **Remove unused assignment
  ([21061](https://github.com/civicrm/civicrm-core/pull/21061))**

- **Remove no longer used variable in Email.tpl / smarty warning
  ([21074](https://github.com/civicrm/civicrm-core/pull/21074))**

- **Remove deprecated isDevelopment() function
  ([21269](https://github.com/civicrm/civicrm-core/pull/21269))**

- **[REF] Move acl delete logic to an event listener
  ([dev/core#2757](https://lab.civicrm.org/dev/core/-/issues/2757):
  [21201](https://github.com/civicrm/civicrm-core/pull/21201) and
  [21213](https://github.com/civicrm/civicrm-core/pull/21213))**

- **[REF] Remove references to contribution_invoice_settings (Work Towards
  [dev/core#2719](https://lab.civicrm.org/dev/core/-/issues/2719):
  [20991](https://github.com/civicrm/civicrm-core/pull/20991))**

- **[REF] Afform - Code cleanup in LoadAdminData API action
  ([21089](https://github.com/civicrm/civicrm-core/pull/21089))**

- **[REF] SearchKit - Refactor search task code to share a trait
  ([21156](https://github.com/civicrm/civicrm-core/pull/21156))**

- **[REF] SearchKit - display code refactor + pager options
  ([21049](https://github.com/civicrm/civicrm-core/pull/21049))**

- **[REF] SearchKit - Use non-deprecated join syntax when loading standalone
  displays ([21095](https://github.com/civicrm/civicrm-core/pull/21095))**

- **[REF] APIv4 Notes - Ensure child notes are deleted with parent, and hooks
  are called ([21208](https://github.com/civicrm/civicrm-core/pull/21208))**

- **[REF] Remove unused/unneeded variables from Note View page
  ([21226](https://github.com/civicrm/civicrm-core/pull/21226))**

- **[REF] CRM_Utils_Recent - Use hook listener to delete items
  ([21204](https://github.com/civicrm/civicrm-core/pull/21204) and
  [21492](https://github.com/civicrm/civicrm-core/pull/21492))**

- **[REF] Deprecate unnecessary del() functions
  ([21200](https://github.com/civicrm/civicrm-core/pull/21200))**

- **REF Switch to CRM_Core_Form::setTitle() instead of
  CRM_Utils_System::setTitle() part 1
  ([21193](https://github.com/civicrm/civicrm-core/pull/21193))**

- **[Ref] remove unused variable
  ([21161](https://github.com/civicrm/civicrm-core/pull/21161))**

- **[Ref] Move id fetching to the classes
  ([21075](https://github.com/civicrm/civicrm-core/pull/21075))**

- **(REF) ReflectionUtils - Add findStandardProperties() and findMethodHelpers()
  ([21114](https://github.com/civicrm/civicrm-core/pull/21114))**

- **[Ref] Simplify IF clause
  ([21078](https://github.com/civicrm/civicrm-core/pull/21078))**

- **[Ref] extract function to getEmailDefaults
  ([21067](https://github.com/civicrm/civicrm-core/pull/21067))**

- **[Ref] Clarify what parameters are passed in
  ([21063](https://github.com/civicrm/civicrm-core/pull/21063))**

- **[Ref] Move rule to email trait
  ([21066](https://github.com/civicrm/civicrm-core/pull/21066))**

- **[Ref] cleanup alterActionSchedule
  ([21047](https://github.com/civicrm/civicrm-core/pull/21047))**

- **[Ref] Copy emailcommon function back to email trait
  ([21251](https://github.com/civicrm/civicrm-core/pull/21251))**

- **[REF] Update a few references to invoicing
  ([21101](https://github.com/civicrm/civicrm-core/pull/21101))**

- **[Ref] intial testing on case tokens, make knownTokens optional
  ([21289](https://github.com/civicrm/civicrm-core/pull/21289))**

- **[Ref] Deprecate Core_Error handling
  ([21279](https://github.com/civicrm/civicrm-core/pull/21279))**

- **[REF] Fix Page Hook test on php8 by putting in guard into customDataB…
  ([21344](https://github.com/civicrm/civicrm-core/pull/21344))**

- **[REF] Fix undefined smarty vars in Advanced Search
  ([21321](https://github.com/civicrm/civicrm-core/pull/21321))**

- **[REF] Improve Custom data insert performance when using the copyCusto…
  ([21313](https://github.com/civicrm/civicrm-core/pull/21313))**

- **[REF] Copy preProcessFromAddress back into the pdf function
  ([21306](https://github.com/civicrm/civicrm-core/pull/21306))**

- **[REF] Remove duplicate IF
  ([21298](https://github.com/civicrm/civicrm-core/pull/21298))**

- **[REF] Minor extraction
  ([21296](https://github.com/civicrm/civicrm-core/pull/21296))**

- **[REF] Remove unreachable code
  ([21294](https://github.com/civicrm/civicrm-core/pull/21294))**

- **[Ref] Minor extraction
  ([21293](https://github.com/civicrm/civicrm-core/pull/21293))**

- **REF Don't check if id is set in ContributionView form - it's required
  ([21274](https://github.com/civicrm/civicrm-core/pull/21274))**

- **[REF] Remove meaningless if
  ([21273](https://github.com/civicrm/civicrm-core/pull/21273))**

- **[NFC] Fix APIv4 Conformance tests on php8
  ([21302](https://github.com/civicrm/civicrm-core/pull/21302))**

- **[NFC] - Replace deprecated function in AngularLoaderTest
  ([21244](https://github.com/civicrm/civicrm-core/pull/21244))**

- **[NFC] CRM_Utils_SystemTest - Call to Uri->withPath() using deprecated format
  ([21215](https://github.com/civicrm/civicrm-core/pull/21215))**

- **[NFC] CRM_Extension_Manager_ModuleUpgTest - use ?? instead of
  error-suppression operator
  ([21214](https://github.com/civicrm/civicrm-core/pull/21214))**

- **[NFC] CRM_Extension_Manager_ModuleTest - use ?? instead of error-suppression
  operator ([21206](https://github.com/civicrm/civicrm-core/pull/21206))**

- **[NFC] Update CRM_Core_RegionTest so it doesn't need the error-suppression
  operator ([21155](https://github.com/civicrm/civicrm-core/pull/21155))**

- **[NFC] Update testCaseActivityCopyTemplate to provide variable that would
  usually be present
  ([21146](https://github.com/civicrm/civicrm-core/pull/21146))**

- **NFC - Fix docblock in CRM_Core_Transaction
  ([21125](https://github.com/civicrm/civicrm-core/pull/21125))**

- **[NFC] {Test} Minor cleanup
  ([21116](https://github.com/civicrm/civicrm-core/pull/21116))**

- **[NFC] Fix UpdateSubscriptionTest on php8 by creating a Payment Processor
  ([21324](https://github.com/civicrm/civicrm-core/pull/21324))**

- **(NFC) Expand test coverage for scheduled-reminders with `{activity.*}`
  tokens ([21092](https://github.com/civicrm/civicrm-core/pull/21092))**

- **(NFC) TokenProcessorTest - Add scenario inspired by dev/core#2673
  ([21090](https://github.com/civicrm/civicrm-core/pull/21090))**

- **[NFC] Fix E-notice in Afform unit tests
  ([21345](https://github.com/civicrm/civicrm-core/pull/21345))**

- **[NFC] Cleanup boilerplate code in extension upgrader classes
  ([21340](https://github.com/civicrm/civicrm-core/pull/21340))**

- **[NFC/Unit test] Update flaky test
  CRM_Utils_TokenConsistencyTest::testCaseTokenConsistency
  ([21341](https://github.com/civicrm/civicrm-core/pull/21341))**

- **(NFC) MailingQueryEvent - Add more docblocks about query-writing and
  `tokenContext_*`
  ([21098](https://github.com/civicrm/civicrm-core/pull/21098))**

- **[NFC] Fix undefined array key when running CRM unit test suite in php8
  ([21314](https://github.com/civicrm/civicrm-core/pull/21314))**

- **Add test to UpdateSubscription form
  ([21282](https://github.com/civicrm/civicrm-core/pull/21282))**

- **Improve test for CRM_Utils_Recent
  ([21222](https://github.com/civicrm/civicrm-core/pull/21222))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
Australian Greens - John Twyman; Benjamin W; CiviCRM - Coleman Watts, Tim Otten;
CompuCorp - Debarshi Bhaumik, Lisandro; Coop SymbioTIC - Mathieu Lutfy; Dave D;
Fuzion - Jitendra Purohit; Greenpeace Central and Eastern Europe - Patrick
Figel; JMA Consulting - Joe Murray, Monish Deb, Seamus Lee; Joinery - Allen
Shaw; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew
Wire; Nicol Wistreich; Skvare - Sunil Pawar; Tadpole Collective - Kevin
Cristiano; Third Sector Design - Kurund Jalmi, Michael McAndrew; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Black Brick Software - David Hayes; CiviCoop - Jaap Jansma; Joinery - Allen
Shaw; Lighthouse Consulting and Design - Brian Shaughnessy; redcuillin

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
