# CiviCRM 5.44.0

Released December 1, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **APIv4 - Add managed entity functionality
  ([21955](https://github.com/civicrm/civicrm-core/pull/21955))**

  APIv4 support for managed entities.

- **APIv4 - Add 'match' param to save action
  ([21857](https://github.com/civicrm/civicrm-core/pull/21857))**

  Adds a 'match' param to the APIv4 save action.

- **RelationshipCache - Add case_id column
  ([21845](https://github.com/civicrm/civicrm-core/pull/21845))**

  Makes it possible to show case relationships in SearchKit.

- **SearchKit - Support download formats xlsx, ods, pdf
  ([21351](https://github.com/civicrm/civicrm-core/pull/21351))**

  Extends download format support for SearchKit to include xlsx, ods and pdf.

- **SearchKit - default displays and ACL-aware links
  ([21929](https://github.com/civicrm/civicrm-core/pull/21929) and
  [22108](https://github.com/civicrm/civicrm-core/pull/22108))**

  Gives every SavedSearch an auto-generated table display, and makes use
  of it in the UI to more conveniently view or embed a saved search without
  needing to manually create a display. In the UI it's referred to as the
  "Search results table" to emphasize the fact that it's the same table as
  shown on the "compose search" screen, and is not configurable like other
  displays.

- **SearchKit server-side rendering
  ([21820](https://github.com/civicrm/civicrm-core/pull/21820))**

  Improves SearchKit by doing more of the rendering work server-side. This
  allows for more nuanced permission checks of actions, better rendering of
  spreadsheets, and opens the door for advanced token formatting.

- **User experience improvement - CiviCRM Manage Events page, expand the Find
  Events criteria by default
  ([21953](https://github.com/civicrm/civicrm-core/pull/21953))**

  Improves user experience on the Manage Events page by making the Find Events
  Criteria open by default.

- **add 'minute' as recurring unit
  ([21893](https://github.com/civicrm/civicrm-core/pull/21893))**

  Adds minute as a recurring unit option.

  ### Wordpress Integration

- **Introduce "Shortcode Display Mode" setting and functionality
  ([258](https://github.com/civicrm/civicrm-wordpress/pull/258))**

  Introduces a new metabox with a "Shortcode Display Mode" setting.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **DB upgrade fails for 5.15->5.36
  ([dev/core#2550](https://lab.civicrm.org/dev/core/-/issues/2550):
  [21997](https://github.com/civicrm/civicrm-core/pull/21997))**

- **Meta - token usage 5.43 standardisation effort (Work Towards
  [dev/core#2864](https://lab.civicrm.org/dev/core/-/issues/2864):
  [21816](https://github.com/civicrm/civicrm-core/pull/21816) and
  [21847](https://github.com/civicrm/civicrm-core/pull/21847)**

  Removes call to getTokenDetails from Contribute pdf letter and standardizes
  two pledge templates to use tokens.

- **Message about dependent extensions when installing an extension uses "key"
  instead of label
  ([dev/core#2876](https://lab.civicrm.org/dev/core/-/issues/2876):
  [21852](https://github.com/civicrm/civicrm-core/pull/21852))**

- **Emails can't resolve tokens for non-contact components for recipients added
  to the list after email form was opened
  ([dev/core#2895](https://lab.civicrm.org/dev/core/-/issues/2895):
  [21815](https://github.com/civicrm/civicrm-core/pull/21815))**

- **Remove reference to CiviCRM forum in HTTP error message
  ([dev/core#2903](https://lab.civicrm.org/dev/core/-/issues/2903):
  [21844](https://github.com/civicrm/civicrm-core/pull/21844))**

- **Repair "Norwegian Bokmål"
  ([dev/core#2909](https://lab.civicrm.org/dev/core/-/issues/2909):
  [21974](https://github.com/civicrm/civicrm-core/pull/21974) and
  [21813](https://github.com/civicrm/civicrm-core/pull/21813))**

- **APIv4 - Add backticks around fields in join criteria
  ([22051](https://github.com/civicrm/civicrm-core/pull/22051))**

- **APIv4 - Fix performance drag caused by getInfoItem calling the API
  ([21920](https://github.com/civicrm/civicrm-core/pull/21920))**

- **SearchKit - Fix permission to access default display and download
  spreadsheets ([21977](https://github.com/civicrm/civicrm-core/pull/21977))**

- **SearchKit - Fix incorrect pager count when using filters
  ([21967](https://github.com/civicrm/civicrm-core/pull/21967))**

- **SearchKit - Conditional style rules for rows/cells
  ([21947](https://github.com/civicrm/civicrm-core/pull/21947))**

- **Use null variables rather than isset in Core_Block
  ([21957](https://github.com/civicrm/civicrm-core/pull/21957))**

- **GroupContactCache: Drop temp table *after* releasing lock
  ([21942](https://github.com/civicrm/civicrm-core/pull/21942))**

- **Ensure no_licence is assigned for drop.tpl
  ([21934](https://github.com/civicrm/civicrm-core/pull/21934))**

- **Handling for intermittent Im->getfields error
  ([21952](https://github.com/civicrm/civicrm-core/pull/21952))**

- **Avoid hardcoded text in error strings; make translatable
  ([21948](https://github.com/civicrm/civicrm-core/pull/21948))**

- **Don't hardcode Period Type in Manage Premiums template.
  ([21954](https://github.com/civicrm/civicrm-core/pull/21954))**

- **Avoid harcoded text in setStatus calls; make translatable
  ([21949](https://github.com/civicrm/civicrm-core/pull/21949))**

- **Make miscellaneous strings translatable
  ([21950](https://github.com/civicrm/civicrm-core/pull/21950))**

- **Make hardcoded labels passed to setTitle translatable
  ([21917](https://github.com/civicrm/civicrm-core/pull/21917))**

- **Remove use of hardcoded strings in Dedupe templates
  ([21843](https://github.com/civicrm/civicrm-core/pull/21843))**

- **Makes hardcoded placeholder strings translatable
  ([21842](https://github.com/civicrm/civicrm-core/pull/21842))**

- **Make hardcoded strings translatable.
  ([21810](https://github.com/civicrm/civicrm-core/pull/21810))**

- **Make error message translatable - remove tag tasks.
  ([21904](https://github.com/civicrm/civicrm-core/pull/21904))**

- **Make error messages translatable.
  ([21905](https://github.com/civicrm/civicrm-core/pull/21905))**

- **Ensure communityMessages is assigned to the template.
  ([21951](https://github.com/civicrm/civicrm-core/pull/21951))**

- **Accessibility: Fix label associations for DepupeFind template.
  ([21946](https://github.com/civicrm/civicrm-core/pull/21946))**

- **Searchkit: can't use HAVING
  ([dev/core#2954](https://lab.civicrm.org/dev/core/-/issues/2954):
  [22130](https://github.com/civicrm/civicrm-core/pull/22130) and
  [dev/report#83](https://lab.civicrm.org/dev/report/-/issues/83):
  [22170](https://github.com/civicrm/civicrm-core/pull/22170))**

  This resolves a 5.43.0 regression in the SearchKit UI where the `HAVING`
  clause could not handle functions.

- **Updates centering of text and tables for Workflow Message Templates
  ([21888](https://github.com/civicrm/civicrm-core/pull/21888),
  [21890](https://github.com/civicrm/civicrm-core/pull/21890),
  [21889](https://github.com/civicrm/civicrm-core/pull/21889),
  [21861](https://github.com/civicrm/civicrm-core/pull/21861),
  [21887](https://github.com/civicrm/civicrm-core/pull/21887),
  [21860](https://github.com/civicrm/civicrm-core/pull/21860),
  [21886](https://github.com/civicrm/civicrm-core/pull/21886),
  [21859](https://github.com/civicrm/civicrm-core/pull/21859),
  [21883](https://github.com/civicrm/civicrm-core/pull/21883),
  [21881](https://github.com/civicrm/civicrm-core/pull/21881),
  [21885](https://github.com/civicrm/civicrm-core/pull/21885),
  [21862](https://github.com/civicrm/civicrm-core/pull/21862),
  [21884](https://github.com/civicrm/civicrm-core/pull/21884),
  [21882](https://github.com/civicrm/civicrm-core/pull/21882),
  [21871](https://github.com/civicrm/civicrm-core/pull/21871),
  [21879](https://github.com/civicrm/civicrm-core/pull/21879),
  [21870](https://github.com/civicrm/civicrm-core/pull/21870),
  [21880](https://github.com/civicrm/civicrm-core/pull/21880),
  [21869](https://github.com/civicrm/civicrm-core/pull/21869),
  [21877](https://github.com/civicrm/civicrm-core/pull/21877),
  [21872](https://github.com/civicrm/civicrm-core/pull/21872),
  [21875](https://github.com/civicrm/civicrm-core/pull/21875),
  [21873](https://github.com/civicrm/civicrm-core/pull/21873),
  [21874](https://github.com/civicrm/civicrm-core/pull/21874),
  [21876](https://github.com/civicrm/civicrm-core/pull/21876),
  [21878](https://github.com/civicrm/civicrm-core/pull/21878),
  [21850](https://github.com/civicrm/civicrm-core/pull/21850) and
  [21863](https://github.com/civicrm/civicrm-core/pull/21863))**

- **Add help tip to comment block
  ([21902](https://github.com/civicrm/civicrm-core/pull/21902))**

- **Use HTML_Purifier from composer and rely on autoloader
  ([334](https://github.com/civicrm/civicrm-packages/pull/334))**

- **Use HTMLPurifier from composer instead of packages
  ([21620](https://github.com/civicrm/civicrm-core/pull/21620))**

- **Change DAO's that have `'default' => 'NULL'` into `'default' => NULL`,
  i.e. true NULL ([21573](https://github.com/civicrm/civicrm-core/pull/21573))**

- **Correct CMS name on profile UF group types
  ([21900](https://github.com/civicrm/civicrm-core/pull/21900))**

- **Prevent Undefined Index PHP notices with Afform entity metadata without an
  icon ([21898](https://github.com/civicrm/civicrm-core/pull/21898))**

- **Export - Fix undefined tpl var
  ([21891](https://github.com/civicrm/civicrm-core/pull/21891))**

- **typo fixes ([21868](https://github.com/civicrm/civicrm-core/pull/21868))**

- **Add alt attribute to image on PCPInfo template.
  ([21808](https://github.com/civicrm/civicrm-core/pull/21808))**

- **Miscellaneous spelling fixes
 ([21918](https://github.com/civicrm/civicrm-core/pull/21918))**

- **Fix unreplaced template vars in civicrm.settings.php when using wp-cli
  installer ([257](https://github.com/civicrm/civicrm-wordpress/pull/257))**

- **$sid doesn't get set on upgrade runFinish
  ([21798](https://github.com/civicrm/civicrm-core/pull/21798))**

- **Do not find references for empty values
  ([21799](https://github.com/civicrm/civicrm-core/pull/21799))**

- **Fix hookTokens to be clearable outside the class
  ([21836](https://github.com/civicrm/civicrm-core/pull/21836))**

- **Use SVG for 'Empowered by' logo
  ([21841](https://github.com/civicrm/civicrm-core/pull/21841))**

### CiviCampaign

- **Stop flushing caches on enable civiCampaign
  ([21833](https://github.com/civicrm/civicrm-core/pull/21833))**

### CiviContribute

- **Financial record processing - extract to new class to faciliate cleanup
  (Work Towards [dev/core#2715](https://lab.civicrm.org/dev/core/-/issues/2715):
  [21391](https://github.com/civicrm/civicrm-core/pull/21391))**

  Removes the mystery `self::_trxns` property.

- **Add financial validation check (to the extent we can)
  ([21848](https://github.com/civicrm/civicrm-core/pull/21848))**

### CiviEvent

- **ensure events with single quotes can be share via social
  ([21811](https://github.com/civicrm/civicrm-core/pull/21811))**

- **event token values missing from pdf export from participant search
  ([dev/core#2947](https://lab.civicrm.org/dev/core/-/issues/2947):
  [22046](https://github.com/civicrm/civicrm-core/pull/22046))**

### CiviMail

- **Handle checking smartgroups when generating list of groups to unsubscribe
  ([21176](https://github.com/civicrm/civicrm-core/pull/21176))**

- **CiviCRM APIv3, Improve API Exception error message when trying to subscribe
  to a non-Public Mailing Group
  ([21697](https://github.com/civicrm/civicrm-core/pull/21697))**

- **OAUTH2 account creation broken
  ([dev/mail#105](https://lab.civicrm.org/dev/mail/-/issues/105):
  [22169](https://github.com/civicrm/civicrm-core/pull/22169))**

### CiviMember

- **Membership status update breaks if override is removed
  ([dev/core#2974](https://lab.civicrm.org/dev/core/-/issues/2974):
  [22182](https://github.com/civicrm/civicrm-core/pull/22182))**

### Drupal Integration

- **"Your browser session has expired and we are unable to complete your form
  submission" on all D9.2 anonymous sessions
  ([dev/drupal#169](https://lab.civicrm.org/dev/drupal/-/issues/169):
  [22071](https://github.com/civicrm/civicrm-core/pull/22071))**

- **Prevent autoload conflicts if HTML_Purifier is already in Drupal libraries
  ([649](https://github.com/civicrm/civicrm-drupal/pull/649))**

### Joomla Integration

- **Fatal error on visiting CiviCRM paths having `task` query param in it twice
  ([dev/joomla#36](https://lab.civicrm.org/dev/joomla/-/issues/36):
  [21922](https://github.com/civicrm/civicrm-core/pull/21922))**

### WordPress Integration

- **Displaying map for contact address causes WP error
  ([dev/core#2942](https://lab.civicrm.org/dev/core/-/issues/2942):
  [21980](https://github.com/civicrm/civicrm-core/pull/21980))**

- **Resources are not loaded for nested shortcodes - breaks usage
  with Divi, Avada, etc.
  ([dev/wordpress#105](https://lab.civicrm.org/dev/wordpress/-/issues/105):
  [259](https://github.com/civicrm/civicrm-wordpress/pull/259))**

## <a name="misc"></a>Miscellany

- **Switch replaceGreetingTokens over
  ([21790](https://github.com/civicrm/civicrm-core/pull/21790))**

- **Simplify usage of getting domain from email
  ([21925](https://github.com/civicrm/civicrm-core/pull/21925))**

- **AllCoreTables - Allow virtual entities to share a DAO class
  ([21853](https://github.com/civicrm/civicrm-core/pull/21853))**

- **Restrict "Oops" to administrative errors
  ([21838](https://github.com/civicrm/civicrm-core/pull/21838))**

- **Update docblock for alterPaymentProcessorParams because rawParams might be
  a payment propertyBag
  ([21897](https://github.com/civicrm/civicrm-core/pull/21897))**

- **Fix cleanup on test, also NFC cleanup
  ([21910](https://github.com/civicrm/civicrm-core/pull/21910))**

- **Fix unreplaced template vars in civicrm.settings.php when using legacy
  installer ([21692](https://github.com/civicrm/civicrm-core/pull/21692))**

- **Remove use of spacer.gif img elements in CRM_Utils_Weight
  ([21807](https://github.com/civicrm/civicrm-core/pull/21807))**

- **Remove reference to CiviCRM forum in HTTP error message
  ([21840](https://github.com/civicrm/civicrm-core/pull/21840))**

- **Remove unnecessary pass-by-reference
  ([21903](https://github.com/civicrm/civicrm-core/pull/21903))**

- **Remove unused function
  ([21928](https://github.com/civicrm/civicrm-core/pull/21928))**

- **Remove unused function from GroupContactCache
  ([21938](https://github.com/civicrm/civicrm-core/pull/21938))**

- **Remove "Connections" from navigation menu
  ([21930](https://github.com/civicrm/civicrm-core/pull/21930))**

- **Remove calls to CRM_Utils_Token::getDomainTokenReplacement
  ([21964](https://github.com/civicrm/civicrm-core/pull/21964))**

- **Remove remaining usages of contact & domain values in participant templates
  ([21963](https://github.com/civicrm/civicrm-core/pull/21963))**

- **Remove call to getTokenDetails
  ([21972](https://github.com/civicrm/civicrm-core/pull/21972))**

- **Remove another call to getTokenDetails
  ([21794](https://github.com/civicrm/civicrm-core/pull/21794))**

- **Add in 5.43.1 and 5.43.2 Release Notes
  ([22085](https://github.com/civicrm/civicrm-core/pull/22085))**

- **[REF] Parameter simplification
  ([21804](https://github.com/civicrm/civicrm-core/pull/21804))**

- **[Ref] Make functions private to protect them
  ([21915](https://github.com/civicrm/civicrm-core/pull/21915))**

- **[REF] Move another function to the FinancialProcessor
  ([21914](https://github.com/civicrm/civicrm-core/pull/21914))**

- **[REF] Update date formatting in the html template to match the text
  template and regenerate civicrm_generated file
  ([21961](https://github.com/civicrm/civicrm-core/pull/21961))**

- **[REF] Regenerate generated civicrm file after recent template updates
  ([21970](https://github.com/civicrm/civicrm-core/pull/21970))**

- **[REF] Skip testCutesyTokenData on php8 for the moment
  ([22043](https://github.com/civicrm/civicrm-core/pull/22043))**

- **[REF] Upgrade CKEditor to 4.17
  ([22092](https://github.com/civicrm/civicrm-core/pull/22092))**

- **[REF] CRM_Core_Menu - Fix syntax, undefined variables, unused code,
  pass-by-ref ([21926](https://github.com/civicrm/civicrm-core/pull/21926))**

- **Improve tests around the Order.create API and membership
  ([21892](https://github.com/civicrm/civicrm-core/pull/21892))**

- **Convert more tests to use full form flow
  ([21931](https://github.com/civicrm/civicrm-core/pull/21931))**

- **Fix test to use postProcess flow
  ([21849](https://github.com/civicrm/civicrm-core/pull/21849))**

- **Preparatory cleanup in test class
  ([21846](https://github.com/civicrm/civicrm-core/pull/21846))**

- **Add test for selvSvcUpdate, switch to using tokens
  ([21937](https://github.com/civicrm/civicrm-core/pull/21937))**

- **Add test for selvsvctransfer, remove use of `$contact` from template
  ([21855](https://github.com/civicrm/civicrm-core/pull/21855))**

- **[NFC] [Tests] remove code smell - unnecessary double quotes
  ([21932](https://github.com/civicrm/civicrm-core/pull/21932))**

- **[NFC] [REF] Test class cleanup
  ([21921](https://github.com/civicrm/civicrm-core/pull/21921))**

- **(NFC) Fix quote style for valid HTML - notifications.tpl
  ([21791](https://github.com/civicrm/civicrm-core/pull/21791))**

- **Fix a few more tests to use a more realistic flow
  ([21907](https://github.com/civicrm/civicrm-core/pull/21907))**

- **Fix more tests to use the full form flow
  ([21906](https://github.com/civicrm/civicrm-core/pull/21906))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Francis Whittle,
Justin Freeman; BrightMinded Ltd - Bradley Taylor; Christian Wach;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Dave D;
Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit;
Jens Schuppe; JMA Consulting - Seamus Lee; Maria; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Progressive
Technology Project - Jamie McClelland; Skvare - Sunil Pawar;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Australian Greens - John Twyman;
Coop SymbioTIC - Mathieu Lutfy; Fuzion - Peter Davis;
JMA Consulting - Monish Deb; Semper IT - Karin Gerritsen;
Tadpole Collective - Kevin Cristiano; Third Sector Design - Kurund Jalmi

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
