# CiviCRM 5.49.0

Released May 4, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add created & modified dates to "View Relationship" screen
  ([22909](https://github.com/civicrm/civicrm-core/pull/22909))**

  Adds created and modified dates to the "View Relationship" screen.

- **Replace entity icons
  ([dev/user-interface#26](https://lab.civicrm.org/dev/user-interface/-/issues/26):
  [23094](https://github.com/civicrm/civicrm-core/pull/23094) and
  [23073](https://github.com/civicrm/civicrm-core/pull/23073))**

  Displays font-awesome icons instead of the old image gifs in the user
  interface for contact types and recent items.

- **Raise number of websites available to inline edit
  ([dev/core#3106](https://lab.civicrm.org/dev/core/-/issues/3106):
  [22908](https://github.com/civicrm/civicrm-core/pull/22908))**

  Raises the max number of inline editable websites from 5 to 25.

- **Add in APIv4 Logging Entity
  ([23129](https://github.com/civicrm/civicrm-core/pull/23129))**

  Exposes the civicrm_log table to APIv4.

- **Add APIv4 for RecentItems
  ([23099](https://github.com/civicrm/civicrm-core/pull/23099))**

  Exposes the list of recently viewed items to APIv4.

- **Enable APIv4 export action on UFGroup and UFField.
  ([22832](https://github.com/civicrm/civicrm-core/pull/22832))**

  Makes the export action available on the UFGroup and UFField Entities in
  APIv4.

- **SearchKit - Allow creation of new records via in-place edit
  ([22376](https://github.com/civicrm/civicrm-core/pull/22376))**

  Allows e.g. an email record to be created if one does not already exist via
  in-place edit.

- **SearchKit - mark stable
  ([23010](https://github.com/civicrm/civicrm-core/pull/23010))**

  Marks SearchKit as stable.

- **Search Kit - Auto-enable during normal installation
  ([22952](https://github.com/civicrm/civicrm-core/pull/22952))**

  Auto-enables SearchKit during installation.

- **SearchKit - Add CiviMail integration
  ([22808](https://github.com/civicrm/civicrm-core/pull/22808))**

  Makes it so SearchKit works with CiviMail.

- **SearchKit - Improve checkbox UX for bulk actions
  ([22906](https://github.com/civicrm/civicrm-core/pull/22906))**

  Improves user experience for SearchKit bulk actions.

- **SearchKit - Add icon support
  ([23034](https://github.com/civicrm/civicrm-core/pull/23034))**

  Adds Icon support to SearchKit.

- **Afform - compose layouts with multiple SearchKit displays
  ([22887](https://github.com/civicrm/civicrm-core/pull/22887))**

  Allows multiple search displays on an afform, which permits composing a
  dashboard-like layout.

- **Afform - Easier layout creation with predefined container styles and
  built-in title ([22975](https://github.com/civicrm/civicrm-core/pull/22975))**

  This makes layouts easier to make, by adding predefined "Panel Pane" and
  "Collapsible" styles which can be applied to any container element. It also
  makes container titles easier to work with, and fixes some issues with saving
  blocks.

- **Add option_value_fields metadata
  ([22996](https://github.com/civicrm/civicrm-core/pull/22996))**

  Adds metadata for OptionValues.

- **Add action links for group.
  ([22912](https://github.com/civicrm/civicrm-core/pull/22912))**

  Add links for group.

### CiviCase

- **Add case ID and make subject optional for case detail report
  ([22973](https://github.com/civicrm/civicrm-core/pull/22973))**

  Improves case detail report by making the case ID available and making the
  subject field optional.

### CiviContribute

- **Add support for financial account custom fields
  ([23067](https://github.com/civicrm/civicrm-core/pull/23067))**

  Enables support for custom fields on Financial Accounts.

- **Add page id and template type as data attributes in contribution templates
  ([21945](https://github.com/civicrm/civicrm-core/pull/21945))**

  Adds more details about the page id and template type to the html of the
  contribution templates.

- **Proposal - make future recurring contribution instances modifiable & not
  fail if the only contribution is deleted. (Work towards
  [dev/financial#6](https://lab.civicrm.org/dev/financial/-/issues/6):
  [21473](https://github.com/civicrm/civicrm-core/pull/21473) and
  [21470](https://github.com/civicrm/civicrm-core/pull/21470))**

  Update the recurring contribution when the template contribution is edited.
  Fixes the creation of the template contribution when it has custom data.

### CiviMember

- **Add membership_id as a reference to the row
  ([23049](https://github.com/civicrm/civicrm-core/pull/23049))**

  Add membership id as a reference to each row on contact dashboard.

### Drupal Integration

- **What if we stopped publishing Drupal 6 releases in 2022?
  ([22960](https://github.com/civicrm/civicrm-core/pull/22960))**

  Ends support for Drupal6 integration.

- **civicrm.drush.inc - Add 'civicrm-pipe' subcommand
  ([652](https://github.com/civicrm/civicrm-drupal/pull/652))**

  Adds support for subcommand `drush civicrm-pipe` (`drush cvpipe`).

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM


- **Preserve previous tab when navigating to and from contact page
  ([dev/core#3003](https://lab.civicrm.org/dev/core/-/issues/3003):
  [22316](https://github.com/civicrm/civicrm-core/pull/22316))**

- **cannot set serialize=0 via api3 when creating custom fields
  ([dev/core#2524](https://lab.civicrm.org/dev/core/-/issues/2524):
  [22934](https://github.com/civicrm/civicrm-core/pull/22934))**

- **Cannot remove Group Organisation selection in multisite setup
  ([dev/core#2633](https://lab.civicrm.org/dev/core/-/issues/2633):
  [20437](https://github.com/civicrm/civicrm-core/pull/20437))**

- **Contact Type get Changed after renewal with credit card
  ([dev/core#2833](https://lab.civicrm.org/dev/core/-/issues/2833):
  [21467](https://github.com/civicrm/civicrm-core/pull/21467))**

- **Users cannot be created if no unsupervised deduping rule exists
  ([dev/core#2918](https://lab.civicrm.org/dev/core/-/issues/2918):
  [22804](https://github.com/civicrm/civicrm-core/pull/22804))**

- **Filename in content-disposition should have extension
  ([dev/core#3034](https://lab.civicrm.org/dev/core/-/issues/3034):
  [22532](https://github.com/civicrm/civicrm-core/pull/22532) and
  [23083](https://github.com/civicrm/civicrm-core/pull/23083))**

  Ensures that filename contains the file extension for PDFs.

- **Enhance EntityRef to widget to show create new option when contacts are
  restricted by multiple contact type
  ([dev/core#3082](https://lab.civicrm.org/dev/core/-/issues/3082):
  [22830](https://github.com/civicrm/civicrm-core/pull/22830))**

- **Checkbox fields on profile admin page can't be unchecked
  ([dev/core#3085](https://lab.civicrm.org/dev/core/-/issues/3085):
  [22916](https://github.com/civicrm/civicrm-core/pull/22916))**

- **CRM_Core_BAO_Address::addGeocoderData mishandling NULL geocodes
  ([dev/core#3132](https://lab.civicrm.org/dev/core/-/issues/3132):
  [23009](https://github.com/civicrm/civicrm-core/pull/23009))**

- **Gender field no longer working
  ([dev/core#3142](https://lab.civicrm.org/dev/core/-/issues/3142):
  [23053](https://github.com/civicrm/civicrm-core/pull/23053))**

- **Upgrade to CiviCRM 5.48.0 fails with No such Table
  ([dev/core#3166](https://lab.civicrm.org/dev/core/-/issues/3166):
  [23148](https://github.com/civicrm/civicrm-core/pull/23148))**

- **Allow API4 match to match an empty value
  ([22882](https://github.com/civicrm/civicrm-core/pull/22882))**

- **Fix copy button float in APIv4 Explorer
  ([22978](https://github.com/civicrm/civicrm-core/pull/22978))**

- **APIv4 - Get dynamic list of entity types
  ([22826](https://github.com/civicrm/civicrm-core/pull/22826))**

  Switches APIv4 Entity.get to dynamically fetch a list of entity types instead
  of using a hardcoded list.

- **APIv4 Explorer - Adjust 'Index' field to fit better on narrow screens
  ([23146](https://github.com/civicrm/civicrm-core/pull/23146))**

- **SearchKit - Fix joins when RelationshipCache is base search entity
  ([23066](https://github.com/civicrm/civicrm-core/pull/23066))**

- **SearchKit - Fix page size size
  ([22927](https://github.com/civicrm/civicrm-core/pull/22927))**

  Shrinks the page size input to fit on smaller screens or dashboards.

- **SearchKit - Fix "all selected" checkbox when selecting a single page
  ([23003](https://github.com/civicrm/civicrm-core/pull/23003))**

- **SearchKit - Ensure filters work with multiple search displays on a form
  ([23018](https://github.com/civicrm/civicrm-core/pull/23018))**

- **Afform - Fix collapsible style
  ([23011](https://github.com/civicrm/civicrm-core/pull/23011))**

- **Afform - reset managed entities when deleting a dashlet
  ([22957](https://github.com/civicrm/civicrm-core/pull/22957))**

- **Link to Google Maps over HTTPs
  ([23044](https://github.com/civicrm/civicrm-core/pull/23044))**

- **noexpand seems to never be assigned
  ([23005](https://github.com/civicrm/civicrm-core/pull/23005))**

- **During upgrade log that it ran the sql when there is just a sql file and no
  corresponding task
  ([22939](https://github.com/civicrm/civicrm-core/pull/22939))**

- **Fix OptionValue BAO to call pre/post hooks to prevent force-reset of managed
  option values ([23130](https://github.com/civicrm/civicrm-core/pull/23130))**

- **Copy Clear value in batch update process for radio button field
  ([22941](https://github.com/civicrm/civicrm-core/pull/22941))**

- **[WIP] Schema - Fix boolean fields in various tables
  ([22954](https://github.com/civicrm/civicrm-core/pull/22954))**

- **Prevent escaping on cancelInfo_show_ids
  ([23077](https://github.com/civicrm/civicrm-core/pull/23077))**

- **Do not default-escape upgrade linkes + Enotice fix on Extension screen
  ([23058](https://github.com/civicrm/civicrm-core/pull/23058))**

- **Fix notices on Task.tpl (grumpy mode)
  ([23006](https://github.com/civicrm/civicrm-core/pull/23006))**

- **Remove isset(taxAmount) from membership online receipt
  ([23017](https://github.com/civicrm/civicrm-core/pull/23017))**

- **SampleData - Fix missing option value names
  ([23000](https://github.com/civicrm/civicrm-core/pull/23000))**

- **Fix undefined index by making sure that is_template is always defined
  ([22993](https://github.com/civicrm/civicrm-core/pull/22993))**

- **Don't lose search criteria for smart group built with search builder
  ([23052](https://github.com/civicrm/civicrm-core/pull/23052))**

- **Fix double encoding of document title on Contact view form
  ([22928](https://github.com/civicrm/civicrm-core/pull/22928))**

- **Group Contact create -> fix to use post hook for subscription records
  ([22419](https://github.com/civicrm/civicrm-core/pull/22419))**

- **Make note date required when creating note
  ([22987](https://github.com/civicrm/civicrm-core/pull/22987))**

- **Respect zero value
  ([23016](https://github.com/civicrm/civicrm-core/pull/23016))**

- **E-notice fix on pdfLetter
  ([23007](https://github.com/civicrm/civicrm-core/pull/23007))**

- **Add chartEnabled to expectedSmartyVariables for reports
  ([23045](https://github.com/civicrm/civicrm-core/pull/23045))**

  Avoids another Smarty notice on reports which do not have charts enabled.

- **Re-fix enotice on templateSelected
  ([23008](https://github.com/civicrm/civicrm-core/pull/23008))**

- **Notices on import - consolidate mapping variables
  ([23119](https://github.com/civicrm/civicrm-core/pull/23119))**

- **Emit deprecated warning for typo version of hook_civicrm_links
  ([23117](https://github.com/civicrm/civicrm-core/pull/23117))**

- **Fix enotice, simplify text on Saved field mapping
  ([23114](https://github.com/civicrm/civicrm-core/pull/23114))**

- **Fixes issue with duplicate is_billing on inline address forms.
  ([22850](https://github.com/civicrm/civicrm-core/pull/22850))**

- **Fix incorrect use of icon argument for crmButton function
  ([23145](https://github.com/civicrm/civicrm-core/pull/23145))**

- **Fix smarty notices in billing form
  ([22992](https://github.com/civicrm/civicrm-core/pull/22992))**

- **Avoid PHP notices in activity search
  ([23093](https://github.com/civicrm/civicrm-core/pull/23093))**

- **Notice fixes in advanced search
  ([22956](https://github.com/civicrm/civicrm-core/pull/22956))**

- **Avoid trailing spaces in trigger output
  ([23069](https://github.com/civicrm/civicrm-core/pull/23069))**

- **Ensure formType is assigned to the template
  ([23078](https://github.com/civicrm/civicrm-core/pull/23078))**

- **Ensure pay_later variables assigned to template
  ([22971](https://github.com/civicrm/civicrm-core/pull/22971))**

- **Ensure some variables are assigned to the template
  ([22972](https://github.com/civicrm/civicrm-core/pull/22972))**

- **Ensure soft credit types are assigned to the template
  ([23037](https://github.com/civicrm/civicrm-core/pull/23037))**

- **Keep "EntityFile" records until after Symfony "delete" hooks fire
  ([23002](https://github.com/civicrm/civicrm-core/pull/23002))**

- **Fix property declarations
  ([22965](https://github.com/civicrm/civicrm-core/pull/22965))**

- **Schema - Fix boolean fields in civicrm_event and civicrm_contribution
  ([22925](https://github.com/civicrm/civicrm-core/pull/22925))**

- **Do not default escape 'create new' links
  ([22969](https://github.com/civicrm/civicrm-core/pull/22969))**

- **Do not escape hierarchical select
  ([22991](https://github.com/civicrm/civicrm-core/pull/22991))**

- **Enotice fix in grumpy smarty mode
 ([22970](https://github.com/civicrm/civicrm-core/pull/22970))**

- **Enotice fix (grumpy smarty)
  ([22988](https://github.com/civicrm/civicrm-core/pull/22988))**

- **Enotice fixes
  ([22989](https://github.com/civicrm/civicrm-core/pull/22989))**

- **Grumpy smarty - Never escape 'initHideBoxes'
  ([22990](https://github.com/civicrm/civicrm-core/pull/22990))**

- **Remove bad use of PHP assert, removed in PHP 8.0
  ([22981](https://github.com/civicrm/civicrm-core/pull/22981))**

- **Split mailing label formatting out from main format
  ([22463](https://github.com/civicrm/civicrm-core/pull/22463))**

### CiviCase

- **Fix issues with case sorting/searching from case dashboard
  ([21514](https://github.com/civicrm/civicrm-core/pull/21514))**

### CiviContribute

- **Accounting entries incorrect in a number of cases... especially with pending
  refunds and overpayments (Work towards
  [dev/financial#186](https://lab.civicrm.org/dev/financial/-/issues/186):
  [23076](https://github.com/civicrm/civicrm-core/pull/23076))**

  Do not display partially paid & partially refunded for selection on edit.

- **PCP: Account creation profile does not support contact image
  ([dev/core#2986](https://lab.civicrm.org/dev/core/-/issues/2986):
  [22223](https://github.com/civicrm/civicrm-core/pull/22223))**

- **Avoid PHP notices from smarty on pricefield table
  ([23046](https://github.com/civicrm/civicrm-core/pull/23046))**

- **Remove more isset from offline receipt
  ([23072](https://github.com/civicrm/civicrm-core/pull/23072))**

- **do not URL Encode parameters for PayFlowPro
  ([23054](https://github.com/civicrm/civicrm-core/pull/23054))**

- **Remove grumpy-mode-incompatible isset in payment notification
  ([23014](https://github.com/civicrm/civicrm-core/pull/23014))**

- **Cleanup variable assigns in ContributionPage confirm
  ([22902](https://github.com/civicrm/civicrm-core/pull/22902))**

- **First recurring payment (paypal ipn) - remove redundant status set,
  start_date change
  ([23081](https://github.com/civicrm/civicrm-core/pull/23081))**

- **Remove issets on pay_later_receipt
  ([23004](https://github.com/civicrm/civicrm-core/pull/23004))**

- **Simplify fix for smarty/php notice on contributionview
  ([22886](https://github.com/civicrm/civicrm-core/pull/22886))**

- **Add paymentstatus helpers for doPayment and separate return params
  ([22680](https://github.com/civicrm/civicrm-core/pull/22680))**

- **Expose payment processor error from PaymentProcessor.pay
  ([22900](https://github.com/civicrm/civicrm-core/pull/22900))**

- **Ensure pay_later_text is always assigned
  ([22977](https://github.com/civicrm/civicrm-core/pull/22977))**

- **Stop passing settings into getTaxLabel
  ([23040](https://github.com/civicrm/civicrm-core/pull/23040))**

- **Assign totalTaxAmount more consistently
  ([23038](https://github.com/civicrm/civicrm-core/pull/23038))**

### CiviEvent

- **Remove isset from event registration receipt
  ([23064](https://github.com/civicrm/civicrm-core/pull/23064))**

- **Add workflow template for offline event
  ([22904](https://github.com/civicrm/civicrm-core/pull/22904))**

- **Event Location fixes
  ([23041](https://github.com/civicrm/civicrm-core/pull/23041))**

- **Remove issets from event_offline_receipt pay_later_text
  ([23060](https://github.com/civicrm/civicrm-core/pull/23060))**

### CiviMail

- **After upgrade to 5.48.0 Error: Mailing cannot be sent. There are missing or
  invalid fields (subject,name,from_name,from_email,body)
  ([dev/mail#107](https://lab.civicrm.org/dev/mail/-/issues/107):
  [23141](https://github.com/civicrm/civicrm-core/pull/23141))**

- **CiviMail - Remove deprecated variable only used by Mosaico
  ([22689](https://github.com/civicrm/civicrm-core/pull/22689))**

- **Set limit to 0 when processing send sms task
  ([23166](https://github.com/civicrm/civicrm-core/pull/23166))**

### CiviMember

- **Recurring membership term is incorrect when using price sets
  ([dev/membership#41](https://lab.civicrm.org/dev/membership/-/issues/41):
  [22825](https://github.com/civicrm/civicrm-core/pull/22825))**

- **Calculate lifetime memberships more accurately
  ([22255](https://github.com/civicrm/civicrm-core/pull/22255))**

- **Enotice fix - membership search
  ([23136](https://github.com/civicrm/civicrm-core/pull/23136))**

## <a name="misc"></a>Miscellany

- **Add utils for managing schema to extension upgrader base class
  ([22955](https://github.com/civicrm/civicrm-core/pull/22955))**

- **add classes to the membership userdashboard page
  ([23021](https://github.com/civicrm/civicrm-core/pull/23021))**

- **Replace incorrect class comment
  ([23043](https://github.com/civicrm/civicrm-core/pull/23043))**

- **Finish conversion of static function to non-static
  ([23042](https://github.com/civicrm/civicrm-core/pull/23042))**

- **Bump minimist from 1.2.5 to 1.2.6
  ([23090](https://github.com/civicrm/civicrm-core/pull/23090))**

- **Optimise isCustomDateField
  ([22943](https://github.com/civicrm/civicrm-core/pull/22943))**

- **Access invoice_prefix setting directly
  ([23039](https://github.com/civicrm/civicrm-core/pull/23039))**

- **Fix function calls to be non-static
  ([23122](https://github.com/civicrm/civicrm-core/pull/23122))**

- **Fully deprecate `getTokenDetails`
  ([22483](https://github.com/civicrm/civicrm-core/pull/22483))**

- **regenerate civicrm_generated
  ([22917](https://github.com/civicrm/civicrm-core/pull/22917))**

- **Test cleanup (minor)
  ([23112](https://github.com/civicrm/civicrm-core/pull/23112))**

- **Simplify class inheritance
  ([23121](https://github.com/civicrm/civicrm-core/pull/23121))**

- **Tpl cleanup - whitespace, wrong closing tag
  ([23124](https://github.com/civicrm/civicrm-core/pull/23124))**

- **Consolidate MapTable.tpl
  ([23138](https://github.com/civicrm/civicrm-core/pull/23138))**

- **Test cleanup, deprecate ContributionSoft::retrieve
  ([23106](https://github.com/civicrm/civicrm-core/pull/23106))**

- **Cleanup unnecessary variables
  ([23111](https://github.com/civicrm/civicrm-core/pull/23111))**

- **Remove use of deprecated FILTER_SANITIZE_STRING
  ([22982](https://github.com/civicrm/civicrm-core/pull/22982))**

- **Remove unnecessary pass-by-ref
  ([23110](https://github.com/civicrm/civicrm-core/pull/23110))**

- **Remove unused variable
  ([23113](https://github.com/civicrm/civicrm-core/pull/23113))**

- **Remove double return statement
  ([23108](https://github.com/civicrm/civicrm-core/pull/23108))**

- **Remove use of overrideDefaultCurrency method from eventInfo page.
  ([22802](https://github.com/civicrm/civicrm-core/pull/22802))**

- **Remove good intentions
  ([23126](https://github.com/civicrm/civicrm-core/pull/23126))**

- **Remove unused private variables
  ([23123](https://github.com/civicrm/civicrm-core/pull/23123))**

- **Remove 'in-between' class
  ([23133](https://github.com/civicrm/civicrm-core/pull/23133))**

- **Remove unused property
  ([23137](https://github.com/civicrm/civicrm-core/pull/23137))**

- **Remove unnecessary pass-by-ref
  ([23132](https://github.com/civicrm/civicrm-core/pull/23132))**

- **Rename test class to reflect form
  ([22903](https://github.com/civicrm/civicrm-core/pull/22903))**

- **Test usability fix
  ([23096](https://github.com/civicrm/civicrm-core/pull/23096))**

- **Cleanup FinancialAccount BAO to use `writeRecord` and deprecate `add`
  ([23079](https://github.com/civicrm/civicrm-core/pull/23079))**

- **[REF] Update Composer compile plugin
  ([23088](https://github.com/civicrm/civicrm-core/pull/23088))**

- **[REF] Create polyfill function for array_key_first which only exists in
  php7.3 and onwards
  ([23095](https://github.com/civicrm/civicrm-core/pull/23095))**

- **[REF] Extract & stdise AmountBlockIsActive
  ([22291](https://github.com/civicrm/civicrm-core/pull/22291))**

- **(REF) Schema - Fix boolean fields in various tables - Split commits
  ([23134](https://github.com/civicrm/civicrm-core/pull/23134))**

- **REF - Split upgrade SQL into multiple tasks
  ([22950](https://github.com/civicrm/civicrm-core/pull/22950))**

- **[REF] APIv4 - Use new class_args metadata to remove special handing
  ([22853](https://github.com/civicrm/civicrm-core/pull/22853))**

- **REF Cleanup activity getBespokeTokens()
  ([22974](https://github.com/civicrm/civicrm-core/pull/22974))**

- **[REF] Deprecate BAO_Contact::retrieve
  ([22966](https://github.com/civicrm/civicrm-core/pull/22966))**

- **[NFC] - Compatibility for PHP-7.4/PHP-8
  ([22962](https://github.com/civicrm/civicrm-core/pull/22962))**

- **[NFC] Superficial cleanup
  ([22907](https://github.com/civicrm/civicrm-core/pull/22907))**

- **[NFC] Fix URL documenting Batch entity
  ([23062](https://github.com/civicrm/civicrm-core/pull/23062))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Blackfly Solutions - Alan Dixon;
BrightMinded Ltd - Bradley Taylor; Christian Wach; Circle Interactive -
Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; Dave D; Future Processing - Adrian; Fuzion - Luke
Stewart; Ginkgo Street Labs - Michael Z Daryabeygi; iXiam - Vangelis Pantazis;
JMA Consulting - Monish Deb, Seamus Lee; Klangsoft - David Reedy Jr; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Oxfam
Germany - Thomas Schüttler; PERORA SRL - Samuele Masetto; Progressive Technology
Project - Jamie McClelland; Skvare - Sunil Pawar; Tadpole Collective - Kevin
Cristiano; Third Sector Design - Kurund Jalmi; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; ALL IN APPLI; Artful Robot - Rich Lott;
Australian Greens - John Twyman; Betty Dolfing; Coop SymbioTIC - Mathieu Lutfy,
Samuel Vanhove, Shane Bill; Francesc Bassas i Bullich; JMA Consulting - Joe
Murray; Richard van Oosterhout; Semper IT - Karin Gerritsen;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
