# CiviCRM 5.23.0

Released March 4, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add PDF letter functionality for Activities using new token processor
  ([14662](https://github.com/civicrm/civicrm-core/pull/14662))**

  Adds the ability to create PDF letters that include activity tokens from the
  activity search.

- **Add utf8 to utfmb8 conversion api command
  ([15969](https://github.com/civicrm/civicrm-core/pull/15969))**

  Adds an API to convert the database from utf8 to utf8mb4. This is intended to
  help early adopters using the utf8mb4 standard (which includes support for
  emojis) with CiviCRM.

- **Move exportui extension into core
  ([16335](https://github.com/civicrm/civicrm-core/pull/16335))**

  Updates the 'Select Fields' screen on step 3 of the Export wizard.

- **Allow setting a custom L10n/I18n resource directory
  ([dev/translation#30](https://lab.civicrm.org/dev/translation/issues/30):
  [15408](https://github.com/civicrm/civicrm-core/pull/15408) and
  [16583](https://github.com/civicrm/civicrm-core/pull/16583))**

  Adds a new setting for the "L10n/I18n resource directory" which allows site
  administrators to specify the location of the l10n directory (and allows the
  directory to be outside of the main code base).

- **Proposal to add a new hook_civicrm_alterExternUrl
  ([dev/core#1100](https://lab.civicrm.org/dev/core/issues/1100):
  [15475](https://github.com/civicrm/civicrm-core/pull/15475))**

  Adds a new hook `hook_civicrm_alterExternUrl` which can be used by extension
  developers to alter Extern scripts.

- **Support MySQL 8.0 now that it is GA
  (Work Towards [dev/core#392](https://lab.civicrm.org/dev/core/issues/392):
  [16204](https://github.com/civicrm/civicrm-core/pull/16204),
  [16202](https://github.com/civicrm/civicrm-core/pull/16202) and
  [16207](https://github.com/civicrm/civicrm-core/pull/16207))**

  Works toward supporting MySQL 8.0 by:
    + Ensuring that the log_date column on logging tables is NOT NULL in MySQL 8.
    + Ensuring that `CRM_Utils_QueryFormatterTest` passes on MySQL 8.
    + Fixing the handling of dates in `getMembershipStarts` function to ensure
    date is passed to query as yyyy-mm-dd to fix test failure on MySQL 8.

- **Field Names now Reserved Words in MySQL8
  ([dev/core#1143](https://lab.civicrm.org/dev/core/issues/1143):
  [16206](https://github.com/civicrm/civicrm-core/pull/16206),
  [16203](https://github.com/civicrm/civicrm-core/pull/16203),
  [16201](https://github.com/civicrm/civicrm-core/pull/16201),
  [16193](https://github.com/civicrm/civicrm-core/pull/16193) and
  [16214](https://github.com/civicrm/civicrm-core/pull/16214))**

  MySQL8 reserves the words "description" and "grouping" which CiviCRM uses as
  field names. These changes work to ensure that these fields play nicely when
  using MySQL8.

- **CQ: Migrate simple Preferences & Settings forms to using a Generic class.
  (Work Towards [dev/core#495](https://lab.civicrm.org/dev/core/issues/495):
  [16224](https://github.com/civicrm/civicrm-core/pull/16224),
  [16234](https://github.com/civicrm/civicrm-core/pull/16234),
  [16235](https://github.com/civicrm/civicrm-core/pull/16235),
  [16236](https://github.com/civicrm/civicrm-core/pull/16236),
  [16237](https://github.com/civicrm/civicrm-core/pull/16237),
  [16233](https://github.com/civicrm/civicrm-core/pull/16233),
  [16232](https://github.com/civicrm/civicrm-core/pull/16232),
  [16228](https://github.com/civicrm/civicrm-core/pull/16228),
  [16229](https://github.com/civicrm/civicrm-core/pull/16229) and
  [16227](https://github.com/civicrm/civicrm-core/pull/16227))**

  Makes admin settings field labels translatable.

- **composer.json - Update civicrm-setup
  ([16423](https://github.com/civicrm/civicrm-core/pull/16423))**

  Improves civicrm-setup for scripted installations of Druapl8 with `cv` and GUI
  based installations on WordPress.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  (Work Towards [dev/core#560](https://lab.civicrm.org/dev/core/issues/560):
  [16433](https://github.com/civicrm/civicrm-core/pull/16433))**

  Work towards throwing exceptions instead of fatal errors.

- **Google+ references should be removed as it phases out (Work Towards
  [dev/core#711](https://lab.civicrm.org/dev/core/issues/711):
  [16099](https://github.com/civicrm/civicrm-core/pull/16099) and
  [16185](https://github.com/civicrm/civicrm-core/pull/16185))**

  Google is phasing out Google+ this begins work to remove all visible
  references to Google+ from CiviCRM.

- **"config_backend" should be thoroughly removed (Work Towards
  [dev/core#1387](https://lab.civicrm.org/dev/core/issues/1387):
  [15842](https://github.com/civicrm/civicrm-core/pull/15842))**

  Ensures that the column `civicrm_domain.config_backend` is not created on new
  sites and drops the column `civicrm_domain.config_backend` for sites that
  started on 4.7-5.20. Additionally, this deprecates some functions related to
  the setting `civicrm_domain.config_backend`.

- **Address ID field should be exportable
  ([dev/core#1512](https://lab.civicrm.org/dev/core/issues/1512):
  [16240](https://github.com/civicrm/civicrm-core/pull/16240))**

  Makes Address ID an exportable field.

- **APIv3 - Only scan files for deprecation checks in Entity.get
  ([16460](https://github.com/civicrm/civicrm-core/pull/16460))**

  Improves performance of APIv3 by stopping scanning nonexistent files.

- **Add debug info to api4 output
  ([16351](https://github.com/civicrm/civicrm-core/pull/16351))**

  Improves API4 by adding debug info and displaying the query.

- **APIv4 - don't throw exception when updating/deleting 0 items
  ([16374](https://github.com/civicrm/civicrm-core/pull/16374))**

  Improves APIv4's update and delete actions when operating on 0 items so that
  they do not throw exceptions, instead they return 0 results.

- **APIv4 - Variable substitution in docblocks
  ([16449](https://github.com/civicrm/civicrm-core/pull/16449))**

  Makes the help text more meaningful in the APIv4 Explorer by always referring to
  the correct entity & action names.

- **APIv4 Explorer css tweaks
  ([16431](https://github.com/civicrm/civicrm-core/pull/16431))**

  Makes the checkboxes in the APIv4 explorer line up better and makes them bold
  when checked.

- **APIv4 docs improvements
  ([16411](https://github.com/civicrm/civicrm-core/pull/16411))**

  Improves APIv4 docs and their display in the explorer.

- **APIv4 Explorer - Better UI for defaults param
  ([16454](https://github.com/civicrm/civicrm-core/pull/16454))**

  Improves APIv4 so that it handles defaults param with select2 instead of a
  text box. Also shows the new way of using the variadic addSelect function.

- **Api4 - improve docblocks & display links in explorer
  ([16373](https://github.com/civicrm/civicrm-core/pull/16373))**

  Improves documentation for most APIv4 entities by adding clickable links
  to documentation displayed in the APIv4 explorer.

- **Implement PaymentProcessor and PaymentProcessorType APIv4 Entities
  ([15624](https://github.com/civicrm/civicrm-core/pull/15624))**

  Adds `PaymentProcesor` and `PaymentProcessorType` entities to APIv4.

- **Update function to repair indexes to take table as a parameter
  ([16146](https://github.com/civicrm/civicrm-core/pull/16146))**

  Makes it so the `System.getmissingindices` and `System.updateindexes` APIs
  accept 'tables' as a parameter (array or string) and limits the results to the
  specified tables if supplied.

- **Api4 - Support wildcard * in select clause
  ([16302](https://github.com/civicrm/civicrm-core/pull/16302))**

  Adds support for the * wildcard in the SELECT clause of APIv4 Get actions.

- **Api4 - Filter returned fields by contact type
  ([16300](https://github.com/civicrm/civicrm-core/pull/16300))**

  Ensures that civicrm_api4('Contact', 'get' ...) filters the fields returned
  based on contact type.

- **Api4 - Convert field values to correct data type
  ([16274](https://github.com/civicrm/civicrm-core/pull/16274))**

  Ensures that Api4 returns field values as the correct data type (instead of
  always as a raw string).

- **Api4 - format output consistently across get/create/update.
  ([16305](https://github.com/civicrm/civicrm-core/pull/16305))**

  Improves consistency of output in Api4.

- **Add more functionality to the api4 $index param
  ([16257](https://github.com/civicrm/civicrm-core/pull/16257))**

  Improves APIv4 by making the `$index` param support 4 modes: Integer, String,
  Non-associative array and Associative array and documenting them more clearly.

- **Use markdown in php docblocks & display in APIv4 Explorer
  ([16425](https://github.com/civicrm/civicrm-core/pull/16425))**

  Reformats some docblocks to use markdown, and uses the marked.js library to
  display the docblocks clearly in the APIv4 Explorer.

- **Civi\Test - Allow `headless()->apply()` (etc) to execute without setup.sh
  ([16405](https://github.com/civicrm/civicrm-core/pull/16405))**

  Makes it possible to run the headless test suites without running setup.sh.

- **Allow most values of $civicrm_paths['XXX']['url'] to be relative
  ([16403](https://github.com/civicrm/civicrm-core/pull/16403))**

  Allows system administrators to override various path and URL computations
  using a relative URL.

- **composer.json - Explicitly set target PHP platform
  ([16421](https://github.com/civicrm/civicrm-core/pull/16421))**

  Refines the way in which composer resolves dependencies - so as to prefer
  packages that are compatible with CiviCRM's declared minimum requirement.

- **Add function to set entitySubType for entity forms
  ([16017](https://github.com/civicrm/civicrm-core/pull/16017))**

  Makes it so entity subtype can be set in a standard way and is used if set.

- **Add metadata to is_primary fields
  ([16113](https://github.com/civicrm/civicrm-core/pull/16113))**

  Improves field information for `is_primary` for the sake of Form Builder.

- **Check field to carry over custom data by default when the other contact has
  none ([16246](https://github.com/civicrm/civicrm-core/pull/16246))**

  Improves the contact merge screen by defaulting to checking the box to
  carryover any custom data fields where the contact being merged into has no
  data.

 - **Add resolved to return array for get_conflicts
   ([15829](https://github.com/civicrm/civicrm-core/pull/15829))**

   Enhances the `Contact.get_merge_conflicts` API call to also include an array
   of resolved conflicts.

### CiviCase

- **Add case tokens to email activities
  ([dev/core#522](https://lab.civicrm.org/dev/core/issues/522):
  [16105](https://github.com/civicrm/civicrm-core/pull/16105))**

  Adds the ability to use case tokens in PDF Letters and single emails.

- **Restrict case roles by group
  ([15570](https://github.com/civicrm/civicrm-core/pull/15570))**

  Adds a setting to restrict contacts available to be selected for a case role
  by group.

### CiviContribute

- **Add columns to Contribution Detail report: Employer, Location Type,
  Preferred Communication Method
  ([dev/core#1573](https://lab.civicrm.org/dev/core/issues/1573):
  [16458](https://github.com/civicrm/civicrm-core/pull/16458))**

  Improves the Contribution Detail report by making the fields 'Employer',
  'Location Type', 'Preferred Communication Method' available as columns.

- **Add "Contributor Name" to Offline Contribution Receipts
  ([16286](https://github.com/civicrm/civicrm-core/pull/16286))**

  Adds the display name of the contributor to Offline Contribution Receipts.

- **Add pre/post hooks on ContributionSoft entity
  ([16264](https://github.com/civicrm/civicrm-core/pull/16264))**

  Add Pre and post hooks for the `ContributionSoft` entity.

- **Deprecate creating partially paid contributions, other than by partially
  paying a contribution.
  ([15855](https://github.com/civicrm/civicrm-core/pull/15855))**

  Adds deprecation noise when an attempt is made to set a contribution to
  partially paid other than by adding a payment (using Payment.create). This is
  necessary not only because we have a preferred workflow but also because
  setting to "Partially Paid" doesn't actually create the  `financial_trxn` that
  is required if done via `Contribution.create` flow.

### CiviEvent

- **Expose "is_show_location" to control display of event locations
  ([dev/core#1511](https://lab.civicrm.org/dev/core/issues/1511):
  [16230](https://github.com/civicrm/civicrm-core/pull/16230))**

  Exposes an option to show event location on the event configuration tab.

### CiviMail

- **Make Deja Vu Sans the default font for mailing labels
  ([dev/core#1502](https://lab.civicrm.org/dev/core/issues/1502):
  [16216](https://github.com/civicrm/civicrm-core/pull/16216))**

  Updates the default font for mailing labels to be "Deja Vu Sans" which is a
  font that supports unicode characters.

- **Pass through mailing id to alterMailContent hook
  ([dev/core#1253](https://lab.civicrm.org/dev/core/issues/1253):
  [15306](https://github.com/civicrm/civicrm-core/pull/15306))**

  Improves the `hook_civicrm_alterMailContent` hook by passing the mailing ID to
  it so that developers can access data about the mailing that the content is
  part of.

- **Eventually google will require OAUTH for bounce processing and may require
  it for outbound SMTP through gmail servers
  (Work Towards [dev/mail#59](https://lab.civicrm.org/dev/mail/issues/59):
  [16231](https://github.com/civicrm/civicrm-core/pull/16231),
  [16518](https://github.com/civicrm/civicrm-core/pull/16518),
  [16307](https://github.com/civicrm/civicrm-core/pull/16307) and
  [16306](https://github.com/civicrm/civicrm-core/pull/16306))**

  Adds the ability to connect to IMAP server using XOAUTH2 protocol. Updates the
  version of zetacomponents/mail package to a version that will support XAUTH2.

- **Allow personalised 'view in browser' links for mass emails
  ([dev/core#1064](https://lab.civicrm.org/dev/core/issues/1064):
  [14591](https://github.com/civicrm/civicrm-core/pull/14591))**

  Improves the CiviMail "view in browser" experience by allowing personalized
  links.

### CiviMember

- **When viewing a membership show if the status is overridden
  ([16341](https://github.com/civicrm/civicrm-core/pull/16341))**

  Adds the text "(Overridden)" next to the membership status when viewing a
  membership for which the status has been overridden.

- **Auto renew text appears at top of membership edit form
  ([dev/core#1519](https://lab.civicrm.org/dev/core/issues/1519):
  [16269](https://github.com/civicrm/civicrm-core/pull/16269))**

  Improves the placement of the Auto Renew help text on the Membership edit
  form.

- **Improve accessibility of membership edit form
  ([dev/core#1520](https://lab.civicrm.org/dev/core/issues/1520):
  [16272](https://github.com/civicrm/civicrm-core/pull/16272))**

  Updates the help text link text on the membership edit form to be meaningful
  to improve accessibility.

- **Permit modified_id as a parameter for membership create api
  ([16166](https://github.com/civicrm/civicrm-core/pull/16166))**

  Adds `modified_id` as a parameter for APIv3 `membership.create`.

### Wordpress Integration

- **WordPress Version Update
  ([dev/wordpress#2](https://lab.civicrm.org/dev/wordpress/issues/2):
  [16211](https://github.com/civicrm/civicrm-core/pull/16211))**

  Ensures the WordPress plugin version is updated by distmaker.

- **Pass language code to CiviCRM for Wordpress
  ([16446](https://github.com/civicrm/civicrm-core/pull/16446))**

  Ensures CiviCRM will always pick up the language that WordPress is configured
  to use instead of having to configure the language in both CiviCRM and
  WordPress.

- **Update civicrm.settings.php.template to default to CLEANURL for WP
  ([16284](https://github.com/civicrm/civicrm-core/pull/16284))**

  Makes it so that new WordPress/CiviCRM sites default to having CleanUrls.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **No Household Member Relationship Created when an Individual shares a
  relationship with a household
  ([dev/core#1319](https://lab.civicrm.org/dev/core/issues/1319):
  [16447](https://github.com/civicrm/civicrm-core/pull/16447))**

  Fixes a regression in core where sharing an address with a household stopped
  creating a household member relationship so that there is a checkbox (that
  defaults to checked) to create a household member relationship when sharing
  an address with a household.

- **Add mechanism for avoiding conflicts when deduping
  ([dev/core#1355](https://lab.civicrm.org/dev/core/issues/1355):
  [15670](https://github.com/civicrm/civicrm-core/pull/15670))**

  Improves dedupe functionality so that it aborts early if two (or more)
  dedupe jobs are running at the same time and attempt to act on the same
  contact.

- **Clear asset builder cache when clearing cache
  ([dev/core#1395](https://lab.civicrm.org/dev/core/issues/1395):
  [15857](https://github.com/civicrm/civicrm-core/pull/15857))**

  Ensures the "dyn" folder gets cleared when clearing CiviCRM caches.

- **Smart groups with deleted/disabled custom fields throw fatal error on its
  usage. (Work Towards [dev/core#1471](https://lab.civicrm.org/dev/core/issues/1471):
  [16267](https://github.com/civicrm/civicrm-core/pull/16267))**

  Adds an alert on the system status page when deleted custom fields are used in
  a smart group.

- **Invalid links to extension directory
  ([dev/core#1550](https://lab.civicrm.org/dev/core/issues/1550):
  [16394](https://github.com/civicrm/civicrm-core/pull/16394))**

  Fixes an invalid link to the extension directory in help text.

- **CQ: Eliminate 'contribution_invoice_settings' 'Setting' in favour of
  following our standard (Work Towards
  [dev/core#1558](https://lab.civicrm.org/dev/core/issues/1558):
  [16397](https://github.com/civicrm/civicrm-core/pull/16397),
  [16398](https://github.com/civicrm/civicrm-core/pull/16398),
  [16412](https://github.com/civicrm/civicrm-core/pull/16412) and
  [16424](https://github.com/civicrm/civicrm-core/pull/16424))**

  Works towards eliminating the 'contribution_invoice_settings' 'Setting' in
  favor of following the CiviCRM standard by ensuring the `credit_notes_prefix`
  is retrieved the standard way, refactoring some old code and adding some data
  conversion code for the non-standard setting.

- **Errors in link ReCaptcha and Extension Directory
  ([dev/translation#33](https://lab.civicrm.org/dev/translation/issues/33):
  [16387](https://github.com/civicrm/civicrm-core/pull/16387))**

  Fixes a link with incorrect quoting leading to malformed html and a link with
  an incorrect anchor.

- **Incorrect Contact Reference option for Postal Code in civicrm_data.sql
  ([dev/translation#34](https://lab.civicrm.org/dev/translation/issues/34):
  [16352](https://github.com/civicrm/civicrm-core/pull/16352))**

  Fixes a bug where custom fields of the type "contact reference" would
  display the country instead of the postal code so that they show the country
  as expected.

- **Getting Started dashlet does not cache per language
  ([dev/translation#35](https://lab.civicrm.org/dev/translation/issues/35):
  [16354](https://github.com/civicrm/civicrm-core/pull/16354))**

  Ensures the CiviCRM Resources dashlet displays in the user's language.

- **Call hook_civicrm_copy for RecurringEntity
  ([16466](https://github.com/civicrm/civicrm-core/pull/16466))**

  Ensures that `hook_civicrm_copy` is called when entities are copied via
  RecurringEntity.

- **CRM_Utils_XML::parseFile() - Fix obscure segfault
  ([16463](https://github.com/civicrm/civicrm-core/pull/16463))**

  Fixes a Segfault error for users with a very specific config (Macs running php
  7.4.1 or 7.3.9 MAMP 5.6).

- **Add require_once to api3TestTrait
  ([16461](https://github.com/civicrm/civicrm-core/pull/16461))**

  Ensures the `api3TestTrait` includes the file for the
  `_civicrm_api3_get_options_from_params` function instead of relying on it
  being loaded tangentially.

- **Cleanup API_Exception usage
  ([16432](https://github.com/civicrm/civicrm-core/pull/16432))**

  Fixes mis-capitalized exception class name, and moves a APIv3-only check to the
  right place.

- **IconPicker widget improvements
  ([15760](https://github.com/civicrm/civicrm-core/pull/15760))**

  Fixes some style issues with the icon picker widget and adds some controls to
  the dialog.

- **CRM_Core_Menu - Fix warnings during local test run
  ([16406](https://github.com/civicrm/civicrm-core/pull/16406))**

  Fixes the warning `Warning: simplexml_load_file(): I/O warning : failed to
  load external entity` when running the test suite on Drupal 8 sites on OSX.

- **Add user friendly error message on merge error
  ([dev/core#1540](https://lab.civicrm.org/dev/core/issues/1540):
  [16340](https://github.com/civicrm/civicrm-core/pull/16340))**

  Adds a user friendly error when attempting to merge two contacts from the
  Advanced Search Screen when no Supervised rule is present on the site, before
  this change a fatal error was thrown.

- **Enotice fix ([16293](https://github.com/civicrm/civicrm-core/pull/16293))**

  Fixes an "Warning: Invalid argument supplied foreach()" e-notice on the edit
  smart group screen.

- **Force reCaptcha is not working when pay later enabled
  ([16282](https://github.com/civicrm/civicrm-core/pull/16282))**

  Ensures that ReCaptcha is always on even if only pay later is enabled as a
  payment method.

- **Dedupe rules don't work with custom fields/Variable type error during import
  process ([dev/core#1597](https://lab.civicrm.org/dev/core/issues/1597) and
  [dev/core#1595](https://lab.civicrm.org/dev/core/issues/1595):
  [16558](https://github.com/civicrm/civicrm-core/pull/16558))**

  Fixes a regression where dedupe rules were failing when attempting to use a
  custom field as the match field.

- **Select_string only accepts integers: 1
  ([dev/translation#36](https://lab.civicrm.org/dev/translation/issues/36):
  [16599](https://github.com/civicrm/civicrm-core/pull/16599))**

  Fixes an error for translated sites when trying to perform a contact search.

- **Advanced Search: "active period" filter regression
  ([dev/core#1592](https://lab.civicrm.org/dev/core/issues/1592):
  [16535](https://github.com/civicrm/civicrm-core/pull/16535))**

  Fixes a bug in Advanced Search where the filter "active period" (for
  relationships) is not respected.

- **Advanced search links on mailing reports page give "DB Error: syntax error"
  ([dev/core#1551](https://lab.civicrm.org/dev/core/issues/1551):
  [16534](https://github.com/civicrm/civicrm-core/pull/16534))**

  Fixes a regression where this url
  "civicrm/contact/search/advanced?force=1&mailing_id=1" throws a fatal error.

- **Upgrade fails when civicrm_managed table contains a row including
  entity_type='PaymentProcessorType';
  ([dev/core#1498](https://lab.civicrm.org/dev/core/issues/1498):
  [16521](https://github.com/civicrm/civicrm-core/pull/16521))**

- **Fix loading with alternate packages path (system-level)
  ([16407](https://github.com/civicrm/civicrm-core/pull/16407))**

- **Fix loading with alternate packages path (UI-level)
  ([16409](https://github.com/civicrm/civicrm-core/pull/16409))**

- **setup.sh - Fixes for running in basic composer file-structure
  ([16408](https://github.com/civicrm/civicrm-core/pull/16408))**

- **Make $civicrm_paths less sensitive to trailing slashes. Add tests.
  ([16404](https://github.com/civicrm/civicrm-core/pull/16404))**

- **Prevent PropertBag from being so noisy about deprecation warnings
  ([16390](https://github.com/civicrm/civicrm-core/pull/16390))**

- **Wrong parameter passed to executeQuery function
  ([16353](https://github.com/civicrm/civicrm-core/pull/16353))**

- **Update temp table handler to support utf8mb4 if that is the db collation
  ([15992](https://github.com/civicrm/civicrm-core/pull/15992))**

- **Enforce isSkipLineItem for membership payment entity in Order.create
  ([15891](https://github.com/civicrm/civicrm-core/pull/15891))**

- **Fetch Only Active Custom Group Extend Values
  ([15759](https://github.com/civicrm/civicrm-core/pull/15759))**

- **Ensure that we always return a raw urlencoded url for extenal urls to fix
  Flexmailer tests
  ([16265](https://github.com/civicrm/civicrm-core/pull/16265))**

- **Country/State PseudoConstant not sorted according to the locale
  ([16258](https://github.com/civicrm/civicrm-core/pull/16258))**

- **Change check.gif to an actual gif (was a PNG)
  ([16220](https://github.com/civicrm/civicrm-core/pull/16220))**

- **Fix Error handling following DB Package upgrade
  ([16213](https://github.com/civicrm/civicrm-core/pull/16213))**

- **Do not escape html in report header and footers on API create
  ([dev/core#1286](https://lab.civicrm.org/dev/core/issues/1286):
  [15383](https://github.com/civicrm/civicrm-core/pull/15383))**

- **Editing a group description inline causes the recent items list to display
  blank instead of the group title
  ([dev/core#1506](https://lab.civicrm.org/dev/core/issues/1506):
  [16197](https://github.com/civicrm/civicrm-core/pull/16197))**

- **Recent items list has blank entry and E_NOTICE's when viewing an Email
  activity from activities tab
  ([dev/core#1507](https://lab.civicrm.org/dev/core/issues/1507):
  [16195](https://github.com/civicrm/civicrm-core/pull/16195))**

- **'Merge All Contacts with the Same Address' doesn't consider Household
  replace individuals that share same address. ([CRM-21858
  ](https://issues.civicrm.org/jira/browse/CRM-21858) and
  [dev/core#1364](https://lab.civicrm.org/dev/core/issues/1364):
  [16369](https://github.com/civicrm/civicrm-core/pull/16369))**

- **Scheduled reminder emails sent to contacts with do_not_email set or with
  email on hold ([dev/core#1378](https://lab.civicrm.org/dev/core/issues/1378):
  [15778](https://github.com/civicrm/civicrm-core/pull/15778))**

- **Update BAO_Acl internal functions to protected & unused to deprecated
  ([16189](https://github.com/civicrm/civicrm-core/pull/16189))**

- **Deactivating CiviContribute causes SQL error
  ([dev/core#547](https://lab.civicrm.org/dev/core/issues/547):
  [16365](https://github.com/civicrm/civicrm-core/pull/16365))**

### CiviCase

- **Changing a civicase activity's label breaks the max_instances check
  ([dev/core#1116](https://lab.civicrm.org/dev/core/issues/1116):
  [16347](https://github.com/civicrm/civicrm-core/pull/16347))**

- **Case Resource shows contact names that are not accessible to logged in user
  ([dev/core#1499](https://lab.civicrm.org/dev/core/issues/1499):
  [16150](https://github.com/civicrm/civicrm-core/pull/16150))**

- **Fix activity.case_id token to always display the first case ID
  ([16208](https://github.com/civicrm/civicrm-core/pull/16208))**

### CiviContribute

- **Positive integer expected for recurring interval even when user is not
  making a recurring contribution
  ([dev/core#1588](https://lab.civicrm.org/dev/core/issues/1588):
  [16532](https://github.com/civicrm/civicrm-core/pull/16532))**

  Fixes a Fatal error when the recurring option "Support recurring intervals" is
  enabled on a contribution page.

- **Make getTotalPayments return 0 instead of NULL
  ([16129](https://github.com/civicrm/civicrm-core/pull/16129))**

- **Email address token on the confirmation message not working for a pay later
  contribution. ([dev/core#1255](https://lab.civicrm.org/dev/core/issues/1255):
  [15314](https://github.com/civicrm/civicrm-core/pull/15314))**

- **Paypal IPN fails when contact is merged
  ([dev/core#1249](https://lab.civicrm.org/dev/core/issues/1249):
  [15307](https://github.com/civicrm/civicrm-core/pull/15307))**

- **`,` as decimal separator, and [space] as thousand separators leads to api
  errors ([dev/core#1522](https://lab.civicrm.org/dev/core/issues/1522):
  [16392](https://github.com/civicrm/civicrm-core/pull/16392))**

- **Fix retrieving contribution_status_id for manual payment processor
  ([16018](https://github.com/civicrm/civicrm-core/pull/16018))**

- **Set contribution status to refunded when it has been refunded
  ([16148](https://github.com/civicrm/civicrm-core/pull/16148))**

### CiviEvent

- **"Confirm Event Invitation" message template has a bad variable
  ([dev/event#32](https://lab.civicrm.org/dev/event/issues/32):
  [16367](https://github.com/civicrm/civicrm-core/pull/16367))**

  Fixes the URL for self-service updates links in the "Confirm Event Invitation"
  message template to include the participant ID so that they link correctly.

- **Respect form value for register_date on participant form
  ([16439](https://github.com/civicrm/civicrm-core/pull/16439))**

  Fixes a bug where the participant registration date is exposed on the
  backoffice event form, but when a credit card payment is being submitted it is
  ignored.

- **Scheduled reminders are incorrectly sent from event templates when
  "additional group" is selected
  ([dev/event#28](https://lab.civicrm.org/dev/event/issues/28):
  [16311](https://github.com/civicrm/civicrm-core/pull/16311))**

- **"Confirm from waitlist" doesn't consider whether participant roles are
  counted. ([dev/event#23](https://lab.civicrm.org/dev/event/issues/23):
  [16098](https://github.com/civicrm/civicrm-core/pull/16098))**

- **Event registration form doesn't prevent multiple signups for waitlisted
  participants. ([dev/event#30](https://lab.civicrm.org/dev/event/issues/30):
  [16358](https://github.com/civicrm/civicrm-core/pull/16358))**

- **Permission error on event info page for anonymous users
  ([dev/core#1517](https://lab.civicrm.org/dev/core/issues/1517):
  [16266](https://github.com/civicrm/civicrm-core/pull/16266))**

### CiviMember

- **Changing the membership type causes multiple copies of related membership
  text on edit membership page
  ([dev/core#1537](https://lab.civicrm.org/dev/core/issues/1537):
  [16326](https://github.com/civicrm/civicrm-core/pull/16326))**

- **search builder: member since field ignored
  ([dev/core#1602](https://lab.civicrm.org/dev/core/issues/1602):
  [16578](https://github.com/civicrm/civicrm-core/pull/16578))**

  Ensures that "Search Builder" respects the "Member Since" field.

### Drupal Integration

- **composer.json - Relax psr/log constraint. Improve D8 compatibility.
  ([16471](https://github.com/civicrm/civicrm-core/pull/16471))**

  Fixes a composer conflict when installing CiviCRM on Drupal 8.7.

- **Drupal8: Enabling language breaks a fresh CiviCRM install
  ([dev/drupal#85](https://lab.civicrm.org/dev/drupal/issues/85):
  [15912](https://github.com/civicrm/civicrm-core/pull/15912))**

- **Drupal8 - Contact Report does not load any values in the ACL Group/Role
  field ([dev/drupal#89](https://lab.civicrm.org/dev/drupal/issues/89):
  [16273](https://github.com/civicrm/civicrm-core/pull/16273) and
  [15318](https://github.com/civicrm/civicrm-core/pull/15318))**

- **CiviCRM session instance not working when Masquerading in Drupal 7
  ([dev/drupal#98](https://lab.civicrm.org/dev/drupal/issues/98):
  [16177](https://github.com/civicrm/civicrm-core/pull/16177))**

- **Wiki link in OG Sync module description gives a 404
  ([dev/drupal#102](https://lab.civicrm.org/dev/drupal/issues/102):
  [595](https://github.com/civicrm/civicrm-drupal/pull/595))**

## <a name="misc"></a>Miscellany

- **Duplicate code (for real)
  ([16363](https://github.com/civicrm/civicrm-core/pull/16363) and
  [16567](https://github.com/civicrm/civicrm-core/pull/16567))**

- **Mailing Subscribe Form: remove nbsp from descriptions
  ([16186](https://github.com/civicrm/civicrm-core/pull/16186))**

- **Remove SymfonyComponents/YAML package
  ([285](https://github.com/civicrm/civicrm-packages/pull/285))**

- **Update DB_Object
  ([280](https://github.com/civicrm/civicrm-packages/pull/280))**

- **Update gettext to latest tagged release
  ([227](https://github.com/civicrm/civicrm-packages/pull/227))**

- **Upgrade DB package to be version 1.9.3
  ([276](https://github.com/civicrm/civicrm-packages/pull/276))**

- **Update copyright headers following merge of #14662
  ([16199](https://github.com/civicrm/civicrm-core/pull/16199))**

- **Add tax rates to metadata
  ([16253](https://github.com/civicrm/civicrm-core/pull/16253))**

- **Add helper for getting participantValues
  ([16355](https://github.com/civicrm/civicrm-core/pull/16355))**

- **Update docs link for edit scheduled job parameters
  ([16299](https://github.com/civicrm/civicrm-core/pull/16299))**

- **Start to use function rather than multiple queries for event details add
  test ([16329](https://github.com/civicrm/civicrm-core/pull/16329))**

- **Simplify event title retrieval, use cache, add test
  ([16345](https://github.com/civicrm/civicrm-core/pull/16345))**

- **Change function buildEventFeeForm to non-static
  ([16337](https://github.com/civicrm/civicrm-core/pull/16337))**

- **Finish removal of deferred_revenue_enabled from non-standard setting
  ([16395](https://github.com/civicrm/civicrm-core/pull/16395))**

- **Api4 - Improve Entity::get
  ([16346](https://github.com/civicrm/civicrm-core/pull/16346))**

- **Api4 - Make abstract function abstract
  ([16343](https://github.com/civicrm/civicrm-core/pull/16343))**

- **Api4 - Use explicit adder functions rather than magicMethod
  ([16372](https://github.com/civicrm/civicrm-core/pull/16372))**

- **Update contributor-key.yml
  ([16268](https://github.com/civicrm/civicrm-core/pull/16268))**

- **Update my contributor details
  ([16184](https://github.com/civicrm/civicrm-core/pull/16184))**

- **APIv4 documentation & code cleanup
  ([16457](https://github.com/civicrm/civicrm-core/pull/16457))**

- **Fix minor typo in help text.
  ([16303](https://github.com/civicrm/civicrm-core/pull/16303))**

- **Extract code for isPaymentOnExistingContribution.
  ([16327](https://github.com/civicrm/civicrm-core/pull/16327))**

- **Remove function that exactly matches parent class.
  ([16316](https://github.com/civicrm/civicrm-core/pull/16316))**

- **Remove unsupported and unused package DB_Table
  ([277](https://github.com/civicrm/civicrm-packages/pull/277))**

- **Remove  $ids as parameter for Membership::add
  ([16192](https://github.com/civicrm/civicrm-core/pull/16192))**

- **Remove unused code in Case/Form/Activity postProcess
  ([16304](https://github.com/civicrm/civicrm-core/pull/16304))**

- **Remove never passed-in parameter from addPayments
  ([16262](https://github.com/civicrm/civicrm-core/pull/16262))**

- **Remove duplicate line of code
  ([16317](https://github.com/civicrm/civicrm-core/pull/16317))**

- **Remove unreachable code lines.
  ([16349](https://github.com/civicrm/civicrm-core/pull/16349))**

- **Remove unused code
  ([16371](https://github.com/civicrm/civicrm-core/pull/16371))**

- **Remove irrelevant code.
  ([16348](https://github.com/civicrm/civicrm-core/pull/16348))**

- **Remove unindexed join from getACLRoles query
  ([16183](https://github.com/civicrm/civicrm-core/pull/16183))**

- **Remove unmaintained unsupported System_Command package
  ([283](https://github.com/civicrm/civicrm-packages/pull/283))**

- **fix typo's in the text
  ([16361](https://github.com/civicrm/civicrm-core/pull/16361))**

- **fix more typo's in the text
  ([16368](https://github.com/civicrm/civicrm-core/pull/16368))**

- **Fix unit tests after gettext merge
  ([282](https://github.com/civicrm/civicrm-packages/pull/282))**

- **Update recently-added PathUrlTest to be more representative
  ([16607](https://github.com/civicrm/civicrm-core/pull/16607))**

- **Fix tests to use buildFeeFn
  ([16389](https://github.com/civicrm/civicrm-core/pull/16389))**

- **Add unit test to back office form when a payment is made against a partially
  paid contribution
  ([16437](https://github.com/civicrm/civicrm-core/pull/16437))**

- **Revised version of test from #15725
  ([15948](https://github.com/civicrm/civicrm-core/pull/15948))**

- **Update failing test to match intervening changes elsewhere
  ([16270](https://github.com/civicrm/civicrm-core/pull/16270))**

- **Fix unit test so price set params are valid
  ([16344](https://github.com/civicrm/civicrm-core/pull/16344))**

- **Update Export unit test to pass on MySQL 8
  ([16375](https://github.com/civicrm/civicrm-core/pull/16375))**

- **Basic extraction of paid event processing
  ([16281](https://github.com/civicrm/civicrm-core/pull/16281))**

- **Refactor CRM_Contact_BAO_Contact::importableFields() to use metadata
  ([16222](https://github.com/civicrm/civicrm-core/pull/16222))**

- **[REF] Remove setting of unused function.
  ([16315](https://github.com/civicrm/civicrm-core/pull/16315))**

- **[REF] Remove apparent copy & paste code.
  ([16308](https://github.com/civicrm/civicrm-core/pull/16308))**

- **[REF] Move the bounce to the start of the form submit
  ([16333](https://github.com/civicrm/civicrm-core/pull/16333))**

- **[REF] Eliminate silly parameter from function signature.
  ([16330](https://github.com/civicrm/civicrm-core/pull/16330))**

- **[REF] Extract code that assigns event variables to the tpl
  ([16325](https://github.com/civicrm/civicrm-core/pull/16325))**

- **[REF] Fix return value on deleting financial type
  ([16280](https://github.com/civicrm/civicrm-core/pull/16280))**

- **[REF] Move handling of default payment instrument for a payment proc…
  ([16279](https://github.com/civicrm/civicrm-core/pull/16279))**

- **[REF] Move use of priceSetID & amount_override to where they are used
  ([16252](https://github.com/civicrm/civicrm-core/pull/16252))**

- **[REF] Cleanup CRM_Member_BAO_Membership::buildMembershipTypeValues
  ([16059](https://github.com/civicrm/civicrm-core/pull/16059))**

- **[REF] Remove enclosed & escaped variables
  ([16249](https://github.com/civicrm/civicrm-core/pull/16249))**

- **[REF] Minor code simplification in dedupe.
  ([16245](https://github.com/civicrm/civicrm-core/pull/16245))**

- **[REF] move sessionStart functionality to System subclass
  ([16241](https://github.com/civicrm/civicrm-core/pull/16241))**

- **[REF] Update fetchAll function signature to match parent function
  ([16198](https://github.com/civicrm/civicrm-core/pull/16198))**

- **REF Simplify if statement on case activity form
  ([16210](https://github.com/civicrm/civicrm-core/pull/16210))**

- **[REF] Eliminate ['userID'] as an input for BAO_Membership::create
  ([16196](https://github.com/civicrm/civicrm-core/pull/16196))**

- **[REF] Move the storing of custom data into the add function rather th…
  ([16191](https://github.com/civicrm/civicrm-core/pull/16191))**

- **[REF] Remove never-passed param from getLineItems
  ([16251](https://github.com/civicrm/civicrm-core/pull/16251))**

- **[REF] Extract location wrangling code.
  ([16247](https://github.com/civicrm/civicrm-core/pull/16247))**

- **[REF] rename lineItem & lineItems variable
  ([16254](https://github.com/civicrm/civicrm-core/pull/16254))**

- **[REF] Activate fetchAll function in DataObject file
  ([281](https://github.com/civicrm/civicrm-packages/pull/281))**

- **[REF] Reduce places where we pass ids into Mailing::create
  ([16263](https://github.com/civicrm/civicrm-core/pull/16263))**

- **[REF] Remove ids and fully deprecate passing it to Contribution::create
  ([16256](https://github.com/civicrm/civicrm-core/pull/16256))**

- **[REF] Pass params into function rather than this weird check for whether
  params exists. ([16438](https://github.com/civicrm/civicrm-core/pull/16438))**

- **[REF] Move assignment of BalanceAmount
  ([16334](https://github.com/civicrm/civicrm-core/pull/16334))**

- **[REF] Fix CRM_Core_BAO_UFGroup::createUFJoin to not receive by reference.
  ([16260](https://github.com/civicrm/civicrm-core/pull/16260))**

- **[REF] Interim code cleanup - make the usage of addPayments clearer
  ([16441](https://github.com/civicrm/civicrm-core/pull/16441))**

- **[REF] Remove unused variable
  ([16434](https://github.com/civicrm/civicrm-core/pull/16434))**

- **[REF] Add test for line item, extract fn
  ([16402](https://github.com/civicrm/civicrm-core/pull/16402))**

- **[REF] Ensure that the from is correctly modified in both the main que…
  ([16422](https://github.com/civicrm/civicrm-core/pull/16422))**

- **[REF] Remove some unused variables
  ([16414](https://github.com/civicrm/civicrm-core/pull/16414))**

- **REF Extract code to build pcp_supporter_text and enable translation
  ([16271](https://github.com/civicrm/civicrm-core/pull/16271))**

- **[REF] Remove unused variables
  ([16396](https://github.com/civicrm/civicrm-core/pull/16396))**

- **[REF] Extract function to export header row
  ([16364](https://github.com/civicrm/civicrm-core/pull/16364))**

- **[REF] Extract & share code to determine revenue recognition date.
  ([16388](https://github.com/civicrm/civicrm-core/pull/16388))**

- **[NFC] code cleanup
  ([16310](https://github.com/civicrm/civicrm-core/pull/16310))**

- **[NFC] Code cleanup
  ([16309](https://github.com/civicrm/civicrm-core/pull/16309))**

- **[NFC] code cleanup
  ([16301](https://github.com/civicrm/civicrm-core/pull/16301))**

- **[NFC] Minor code cleanup
  ([16290](https://github.com/civicrm/civicrm-core/pull/16290))**

- **[NFC] Extend unit test to cover for recent refactor by eileen to ensure sup…
  ([16332](https://github.com/civicrm/civicrm-core/pull/16332))**

- **[NFC] Code formatting
  ([16331](https://github.com/civicrm/civicrm-core/pull/16331))**

- **[NFC] Code cleanup
  ([16314](https://github.com/civicrm/civicrm-core/pull/16314))**

- **NFC Convert Manage PCP page to short array syntax
  ([16320](https://github.com/civicrm/civicrm-core/pull/16320))**

- **[NFC] Add in more assertions around the content of line items and tot…
  ([16218](https://github.com/civicrm/civicrm-core/pull/16218))**

- **[NFC] Doc Block fix should be bool no boolean as per coding standards
  ([596](https://github.com/civicrm/civicrm-drupal/pull/596))**

- **[NFC] Code comments
  ([16248](https://github.com/civicrm/civicrm-core/pull/16248))**

- **[NFC] Minor cleanup in test class
  ([16250](https://github.com/civicrm/civicrm-core/pull/16250))**

- **[NFC] Skip utf8mb4 test on MySQL versions lower than 5.7
  ([16483](https://github.com/civicrm/civicrm-core/pull/16483))**

- **[NFC] Test update following PR #16150, assertEquals first param is th…
  ([16219](https://github.com/civicrm/civicrm-core/pull/16219))**

- **[NFC] Explicitly specify that it is the Payment processor Type Name n…
  ([16275](https://github.com/civicrm/civicrm-core/pull/16275))**

- **NFC Fix TokenRow docblock
  ([16452](https://github.com/civicrm/civicrm-core/pull/16452))**

- **[NFC] Minor test cleanup.
  ([16450](https://github.com/civicrm/civicrm-core/pull/16450))**

- **[NFC] Remove unused local variables from
  CRM_Contribute_Form_AdditionalPayment::processCreditCard
  ([16342](https://github.com/civicrm/civicrm-core/pull/16342))**

- **[NFC] throw exceptions, single quotes, declare exceptions, remove unused
  param ([16415](https://github.com/civicrm/civicrm-core/pull/16415))**

- **(NFC) Update Var declaration to be standard in CRM folder
  ([16382](https://github.com/civicrm/civicrm-core/pull/16382))**

- **(NFC) Civi/*.php - Update for
  Drupal.Commenting.VariableComment.IncorrectVarType
  ([16379](https://github.com/civicrm/civicrm-core/pull/16379))**

- **NFC Add parameter definition to membershipstatus.calc
  ([16370](https://github.com/civicrm/civicrm-core/pull/16370))**

- **[NFC] Ensure that annon permissions are correctly assigned when enabling
  civicrm webtest module in backdrop
  ([16547](https://github.com/civicrm/civicrm-core/pull/16547))**

- **[NFC] Fix style error
  ([16549](https://github.com/civicrm/civicrm-core/pull/16549))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

a-n The Artists Information Company - William Mortada; AGH Strategies - Andrew
Hunt; Agileware - Pengyi Zhang; Andrei Mondoc; British Humanist Association -
Andrew West; Caltha - Tomasz Pietrzkowski; Chris Burgess; Circle Interactive -
Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; CompuCorp - Vinu Varshith Sekar; Coop SymbioTIC -
Mathieu Lutfy, Samuel Vanhove; Dave D; Electronic Frontier Foundation - Mark
Burdett; Fuzion - Jitendra Purohit; GMCVO Databases - Jade Gaunt; JMA Consulting - 
Seamus Lee; John Kingsnorth; Joinery - Allen Shaw; Joris Vercammen; Megaphone
Technology Consulting - Jon Goldberg; MJCO - Mikey O'Toole; MJW Consulting -
Matthew Wire; myDropWizard - David Snopek; Progressive Technology Project -
Jamie McClelland; Squiffle Consulting - Aidan Saunders; Tadpole Collective -
Kevin Cristiano; Third Sector Design - Michael McAndrew; Timbsoft Technologies -
Tunbola Ogunwande; Web Access - Kurund Jalmi; Wikimedia Foundation - Eileen
McNaughton, Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Alice Frumin; Agileware - Justin Freeman; Andrew
Cormick-Dockery; Artful Robot - Rich Lott; Christian Wach; CiviDesk - Nicolas
Ganivet; CompuCorp - Shitij Gugnani; Francesc Bassas i Bullich; Fuzion - Luke
Stewart, Peter Davis; Greenpeace Central and Eastern Europe - Patrick Figel; JMA
Consulting - Joe Murray, Monish Deb; Korlon - Stuart Gaston; Lighthouse Design
and Consulting - Brian Shaughnessy; mikantchap; Richard van Oosterhout; SYSTOPIA
Organisationsberatung - Björn Endres; tapashdatta;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
