# CiviCRM 5.60.0

Released April 5, 2023

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### CiviCRM Core

- **Add Entity Reference custom field type (implementing EntityRef QuickForm
  element type)
  ([dev/core#3721](https://lab.civicrm.org/dev/core/-/issues/3721):
  [25471](https://github.com/civicrm/civicrm-core/pull/25471))**

  Adds a new type of custom field "EntityReference" which creates an
  autocomplete widget.

- **Add 'SavePoint' to import to statusBounce back to
  ([25602](https://github.com/civicrm/civicrm-core/pull/25602))**

  Adds a 'SavePoint' to import so that the user can be bounced back to the save
  point if the import fails later down the road.

- **SearchKit: Decide on available actions per display (funded)
  ([dev/core#4118](https://lab.civicrm.org/dev/core/-/issues/4118):
  [25521](https://github.com/civicrm/civicrm-core/pull/25521))**

  Allows the admin to limit the available choices of bulk actions (tasks) in a
  Search Display.

- **Make dedupe exceptions searchable in SearchKit
  ([25522](https://github.com/civicrm/civicrm-core/pull/25522))**

  Makes dedupe exceptions searchable in SearchKit.

- **Filter Searches by 'is_current' / expires_date (Work Towards
  [dev/core#4117](https://lab.civicrm.org/dev/core/-/issues/4117):
  [25516](https://github.com/civicrm/civicrm-core/pull/25516))**

  Adds `is_current` filter to searches.

- **Log Smarty debug to it's own channel
  ([25682](https://github.com/civicrm/civicrm-core/pull/25682))**

   Makes it so output from smarty secure mode goes into it's own file.

- **Allow OAuth redirect URI to be overridden in client or provider config
  ([25445](https://github.com/civicrm/civicrm-core/pull/25445))**

  Makes the oauth-client extension respect whatever Redirect URI is set in the
  "client" or "provider" configuration.

- **Make `activity_type_id` available to `links` hook, test
  ([25565](https://github.com/civicrm/civicrm-core/pull/25565))**

  Improves hook_civicrm_links by making activity_type_id available (in relevant
  contexts).

- **Add setting to disable Smarty in Scheduled reminders
  ([dev/core#4100](https://lab.civicrm.org/dev/core/-/issues/4100):
  [25444](https://github.com/civicrm/civicrm-core/pull/25444))**

  Adds a setting to disable Smarty in Scheduled reminders.

### CiviCase

- **Afform: Allow selecting case for relationship
  ([25618](https://github.com/civicrm/civicrm-core/pull/25618))**

  Makes it so one can select a case for a relationship on Afforms.

### CiviContribute

- **Add filter on pledge payment in contribution report templates
  ([dev/core#4106](https://lab.civicrm.org/dev/core/-/issues/4106):
  [25629](https://github.com/civicrm/civicrm-core/pull/25629))**

  Adds a pledge payment filter to the Contribution Detail and Summary reports.

- **PaymentProcessor - Use ajax refresh
  ([25512](https://github.com/civicrm/civicrm-core/pull/25512))**

  Makes page refresh a bit nicer when changing payment processor types on the
  admin form.

### CiviMail

- **HTML definition for subscription history date
  ([25655](https://github.com/civicrm/civicrm-core/pull/25655))**

  Adds an HTML type to the "Group Membership Action Date" field so it can be
  used in FormBuilder as a filter.

### Drupal Integration

- **Epic: Drupal 10 readiness (Work Towards
  [dev/drupal#176](https://lab.civicrm.org/dev/drupal/-/issues/176):
  [25499](https://github.com/civicrm/civicrm-core/pull/25499) and
  [25054](https://github.com/civicrm/civicrm-core/pull/25054))**

  Work towards drupal 10 readiness by allowing symfony 6.

- **CMS Database Integration - Per-table prefixes are no longer supported
  ([dev/core#4028](https://lab.civicrm.org/dev/core/-/issues/4028):
  [25328](https://github.com/civicrm/civicrm-core/pull/25328))**

  Makes the CRM_Admin_Form_Setting_UF more CMS agnostic by removing the Drupal
  7 mapping table.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Make 5.60 upgrade rerunnable
  ([25950](https://github.com/civicrm/civicrm-core/pull/25950))**

- **Import search authorization issues
  ([dev/core#4184](https://lab.civicrm.org/dev/core/-/issues/4184):
  [25810](https://github.com/civicrm/civicrm-core/pull/25810))**

- **Individual's Employer and Membership by Relationship Are Not Updated After
  Merging Their Organization
  ([dev/core#4156](https://lab.civicrm.org/dev/core/-/issues/4156):
  [25778](https://github.com/civicrm/civicrm-core/pull/25778))**

- **Fatal error on merge
  ([dev/core#4197](https://lab.civicrm.org/dev/core/-/issues/4197):
  [25912](https://github.com/civicrm/civicrm-core/pull/25912))**

- **Finish making legacycustomsearches optional (Work Towards
  [dev/core#4112](https://lab.civicrm.org/dev/core/-/issues/4112):
  [25392](https://github.com/civicrm/civicrm-core/pull/25392))**

  Privatize `prevNextCache` functions.

- **Administrator > Communications > Schedule Reminders error when CiviEvent
  disabled ([dev/core#4145](https://lab.civicrm.org/dev/core/-/issues/4145):
  [25703](https://github.com/civicrm/civicrm-core/pull/25703))**

- **Upgrade Smarty
  (Work Towards [dev/core#4146](https://lab.civicrm.org/dev/core/-/issues/4146):
  [25669](https://github.com/civicrm/civicrm-core/pull/25669))**

  Removes (old) Smarty-forward incompatible syntax from Address.tpl.

- **When using PHP 8.1, the Contact token for the Address State / Province field
  returns no value when used in Message Templates. Works fine on PHP 7.4
  ([dev/core#4147](https://lab.civicrm.org/dev/core/-/issues/4147):
  [25704](https://github.com/civicrm/civicrm-core/pull/25704))**

- **Fix for 5.59 upgrade on multilingual
  ([25733](https://github.com/civicrm/civicrm-core/pull/25733))**

- **Load submitted `fieldSeparator` on back on `Import Datasource` screen
  ([25758](https://github.com/civicrm/civicrm-core/pull/25758))**

- **API4: Allow save() to match on null values
  ([24971](https://github.com/civicrm/civicrm-core/pull/24971))**

- **API v4 explorer: boolean params don't render correctly for CV (short)
  ([dev/core#4129](https://lab.civicrm.org/dev/core/-/issues/4129):
  [25589](https://github.com/civicrm/civicrm-core/pull/25589))**

- **Stricter typing in Apiv4
  ([25706](https://github.com/civicrm/civicrm-core/pull/25706))**

- **Afform - Fix validateBySavedSearch
  ([25822](https://github.com/civicrm/civicrm-core/pull/25822))**

- **Afform: Fix broken syntax for saving reciprocal relationships
  ([25620](https://github.com/civicrm/civicrm-core/pull/25620))**

- **Afform - Fix editing search filters nested within multiple containers
  ([25742](https://github.com/civicrm/civicrm-core/pull/25742))**

- **Form Builder - autocomplete input does not use configured filtering
  ([dev/core#4138](https://lab.civicrm.org/dev/core/-/issues/4138):
  [25646](https://github.com/civicrm/civicrm-core/pull/25646))**

- **Filter expired searches from search kit results
  ([25568](https://github.com/civicrm/civicrm-core/pull/25568))**

- **SearchKit - Fix handling of new Custom EntityReference fields
  ([25927](https://github.com/civicrm/civicrm-core/pull/25927))**

- **SearchKit - Clarify how to view SQL output
  ([25671](https://github.com/civicrm/civicrm-core/pull/25671))**

- **Always show "add more buttons" dropdown in searchkit view
  ([25596](https://github.com/civicrm/civicrm-core/pull/25596))**

- **Make job ID accessible to searchkit for joblog
  ([24746](https://github.com/civicrm/civicrm-core/pull/24746))**

- **Add Activity Target consistently
  ([dev/core#4142](https://lab.civicrm.org/dev/core/-/issues/4142):
  [25650](https://github.com/civicrm/civicrm-core/pull/25650))**

- **Allow (some) permissions with colons
  ([23782](https://github.com/civicrm/civicrm-core/pull/23782))**

- **Update Smarty addTemplateDir function signature to future smarty
  ([25248](https://github.com/civicrm/civicrm-core/pull/25248))**

- **Add `crmUrl function` to smarty in the standard way
  ([25661](https://github.com/civicrm/civicrm-core/pull/25661))**

- **Reduce unneeded DNS queries during OAuth flow
  ([25446](https://github.com/civicrm/civicrm-core/pull/25446))**

- **Angular Coder: Fix unescaping of quotes breaking attributes  
  ([25630](https://github.com/civicrm/civicrm-core/pull/25630))**

- **EntityRef - Format custom field display value on QuickForms
  ([25632](https://github.com/civicrm/civicrm-core/pull/25632))**

- **getStatus() should be returning a string
  ([25441](https://github.com/civicrm/civicrm-core/pull/25441))**

- **Regression: Fix DB syntax error on Parse address scheduled  job
  ([25616](https://github.com/civicrm/civicrm-core/pull/25616))**

- **update entity mapping logic for profile fields to include contact subtypes
  ([25570](https://github.com/civicrm/civicrm-core/pull/25570))**

- **Smarty {ts} - For extensions, use fallback similar to E::ts() and JS ts()
  ([25383](https://github.com/civicrm/civicrm-core/pull/25383))**

- **Disambiguate `Address.state_province_id:abbr` (PHP asort)
  ([25552](https://github.com/civicrm/civicrm-core/pull/25552) and
  [25550](https://github.com/civicrm/civicrm-core/pull/25550))**

- **Default to supporting partial locales
  ([25063](https://github.com/civicrm/civicrm-core/pull/25063))**

- **Do not use reference for Object parameter, death to `_NULLObject`
  ([25541](https://github.com/civicrm/civicrm-core/pull/25541))**

- **only load dedupe rules for the chosen entity
  ([25515](https://github.com/civicrm/civicrm-core/pull/25515))**

- **A couple of minor smarty notice fixes
  ([25514](https://github.com/civicrm/civicrm-core/pull/25514))**

- **Use mysql DATABASE() function instead of php code
  ([25530](https://github.com/civicrm/civicrm-core/pull/25530))**

- **Use `DATABASE()` function rather than lossa code
  ([25528](https://github.com/civicrm/civicrm-core/pull/25528))**

- **Fix more schema checks to use mysql DATABASE() function, deprecate php
  function ([25593](https://github.com/civicrm/civicrm-core/pull/25593))**

- **Fix a couple more places to use mysql DATABASE() function
  ([25537](https://github.com/civicrm/civicrm-core/pull/25537))**

- **Fix Scheduled reminders form to use tokenProcessor to get token list
  ([25052](https://github.com/civicrm/civicrm-core/pull/25052))**

- **fix the id help instead use class help
  ([25487](https://github.com/civicrm/civicrm-core/pull/25487))**

- **Fix user profile file fields not saving.
  ([80](https://github.com/civicrm/civicrm-drupal-8/pull/80))**

- **Fix fatal error on upgrade success screen
  ([25554](https://github.com/civicrm/civicrm-core/pull/25554))**

- **Typo executequery => executeQuery
  ([25539](https://github.com/civicrm/civicrm-core/pull/25539))**

- **Smarty - Fix warnings about 'mb_truncate' modifier
  ([25651](https://github.com/civicrm/civicrm-core/pull/25651))**

- **Smarty - {htxt} blocks should not be evaluated unless needed
  ([25653](https://github.com/civicrm/civicrm-core/pull/25653))**

- **Smarty notice fix
  ([25544](https://github.com/civicrm/civicrm-core/pull/25544))**

- **E-notice fix Ical display
  ([25612](https://github.com/civicrm/civicrm-core/pull/25612))**

- **Fix e-notice pattern around location not defined in formButtons.tpl
  ([25668](https://github.com/civicrm/civicrm-core/pull/25668))**

- **Fix Contact import e-notice on preview screen
  ([25302](https://github.com/civicrm/civicrm-core/pull/25302))**

- **Fix mixin to use `addTemplateDir`
  ([25667](https://github.com/civicrm/civicrm-core/pull/25667))**

- **Fix add version for civicrm_custom_field.fk_entity
  ([25642](https://github.com/civicrm/civicrm-core/pull/25642))**

- **Fix handling of invalid sql query during import
  ([25600](https://github.com/civicrm/civicrm-core/pull/25600))**

- **Enotice fix, pledge block on UserDashboard
  ([25546](https://github.com/civicrm/civicrm-core/pull/25546))**

- **Notice fix on preferred_language, when null
  ([25656](https://github.com/civicrm/civicrm-core/pull/25656))**

### CiviCase

- **PHP8: Delete Case link causes fatal error
  ([dev/core#4190](https://lab.civicrm.org/dev/core/-/issues/4190):
  [25849](https://github.com/civicrm/civicrm-core/pull/25849))**

- **CiviCase Dashboard exports all records instead of the results
  ([dev/core#4126](https://lab.civicrm.org/dev/core/-/issues/4126):
  [25649](https://github.com/civicrm/civicrm-core/pull/25649))**

### CiviContribute

- **Around 5.49 pan_truncation and card_type_id (containing card type VISA/MC
  and last 4 digits last four digits stopped getting recorded
  ([dev/core#4029](https://lab.civicrm.org/dev/core/-/issues/4029):
  [25963](https://github.com/civicrm/civicrm-core/pull/25963))**

- **Contribution Confirm incorrectly debit card information even if using
  credit card ([dev/core#4189](https://lab.civicrm.org/dev/core/-/issues/4189):
  [25910](https://github.com/civicrm/civicrm-core/pull/25910))**

- **Import contribution fails if using soft-credit and a row has an empty field
  ([dev/core#4166](https://lab.civicrm.org/dev/core/-/issues/4166):
  [25806](https://github.com/civicrm/civicrm-core/pull/25806))**

- **Fix empty values of Note on Import contribution
  ([25569](https://github.com/civicrm/civicrm-core/pull/25569))**

- **Fix for issue when optional contact_id is blank importing contributions
  ([25897](https://github.com/civicrm/civicrm-core/pull/25897))**

- **New PaypalPro Recurring Payments (PPRP) creating duplicate contributions
  and inaccurate status
  ([dev/core#4158](https://lab.civicrm.org/dev/core/-/issues/4158):
  [25775](https://github.com/civicrm/civicrm-core/pull/25775))**

- **PayPal Prp IPN - Fix incorrect option_group update
  ([25724](https://github.com/civicrm/civicrm-core/pull/25724))**

- **CiviContribute - Fix warning about 'suppressedEmails' when generating PDF
  ([25576](https://github.com/civicrm/civicrm-core/pull/25576))**

- **Contribution pages crash for logged-in users when CiviMember is disabled
  ([25729](https://github.com/civicrm/civicrm-core/pull/25729))**

- **Enotice fix on userDashboard with contributions, replace deprecated
  functions with api4v calls
  ([24861](https://github.com/civicrm/civicrm-core/pull/24861))**

- **Smarty notice fix on bank_account_number
  ([25680](https://github.com/civicrm/civicrm-core/pull/25680))**

- **AJAX error when sorting soft credit by name or date
  ([dev/core#4187](https://lab.civicrm.org/dev/core/-/issues/4187):
  [25846](https://github.com/civicrm/civicrm-core/pull/25846))**

### CiviEvent

- **Can't create new events from a template using the API
  ([dev/core#4205](https://lab.civicrm.org/dev/core/-/issues/4205):
  [25932](https://github.com/civicrm/civicrm-core/pull/25932))**

### CiviMail

- **Mailing Summary Report: support pseudofields
  ([25560](https://github.com/civicrm/civicrm-core/pull/25560))**

- **FlexMailer: Default Return Path not respected
  ([dev/core#4070](https://lab.civicrm.org/dev/core/-/issues/4070):
  [25309](https://github.com/civicrm/civicrm-core/pull/25309))**

### Drupal Integration

- **is_drupal: move functionality that calls this deprecated variable to System
  classes ([dev/core#4127](https://lab.civicrm.org/dev/core/-/issues/4127):
  [25585](https://github.com/civicrm/civicrm-core/pull/25585),
  [25571](https://github.com/civicrm/civicrm-core/pull/25571),
  [25587](https://github.com/civicrm/civicrm-core/pull/25587),
  [25573](https://github.com/civicrm/civicrm-core/pull/25573),
  [25586](https://github.com/civicrm/civicrm-core/pull/25586) and
  [25572](https://github.com/civicrm/civicrm-core/pull/25572))**

### WordPress Integration

- **distmaker - Fix export of WordPress patches
  ([25599](https://github.com/civicrm/civicrm-core/pull/25599))**

## <a name="misc"></a>Miscellany

- **Simplify steps of loading SimpleCacheTest from cache/integration-tests
  ([25942](https://github.com/civicrm/civicrm-core/pull/25942))**

- **composer require --dev yoast/phpunit-polyfills
  ([25631](https://github.com/civicrm/civicrm-core/pull/25631))**

- **Move form specific code to the form
  ([25457](https://github.com/civicrm/civicrm-core/pull/25457))**

- **Make private function private
  ([25604](https://github.com/civicrm/civicrm-core/pull/25604))**

- **Make unshared `getTree` function private, remove never passed params
  ([25517](https://github.com/civicrm/civicrm-core/pull/25517))**

- **APIv4 - Limited support for casting
  ([25595](https://github.com/civicrm/civicrm-core/pull/25595))**

- **Split up CRM_Utils_System_Base::theme
  ([dev/core#4076](https://lab.civicrm.org/dev/core/-/issues/4076):
  [25329](https://github.com/civicrm/civicrm-core/pull/25329))**

- **Preliminary cleanup, comments, type hints
  ([25564](https://github.com/civicrm/civicrm-core/pull/25564))**

- **run `civix update` on `recaptcha`, `legacyCustomSearches`, `financialacls`
  ([25663](https://github.com/civicrm/civicrm-core/pull/25663))**

- **ext - General update to civix v23.02.0
  ([25659](https://github.com/civicrm/civicrm-core/pull/25659))**

- **CiviCRM Stable Version bump
  ([291](https://github.com/civicrm/civicrm-wordpress/pull/291))**

- **Post divide code tidy up
  ([25195](https://github.com/civicrm/civicrm-core/pull/25195))**

- **Add gentle deprecation to `debug_log_message`
  ([25683](https://github.com/civicrm/civicrm-core/pull/25683))**

- **Stop loading unused `relatedObjects`
  ([25617](https://github.com/civicrm/civicrm-core/pull/25617))**

- **Bump dompdf/dompdf from 2.0.2 to 2.0.3
  ([25520](https://github.com/civicrm/civicrm-core/pull/25520))**

- **Add noisy deprecation to `replaceHookTokens`
  ([25510](https://github.com/civicrm/civicrm-core/pull/25510))**

- **Deprecate unused, exception class with non-standard name-spacing
  ([25641](https://github.com/civicrm/civicrm-core/pull/25641))**

- **Fully deprecate `CRM_Utils_Token::getMembershipTokenDetails`,
  `CRM_Utils_Token::replaceEntityTokens`
  ([25507](https://github.com/civicrm/civicrm-core/pull/25507))**

- **Extra deprecation for clarity on token function
  `convertPseudoConstantsUsingMetadata`
  ([25511](https://github.com/civicrm/civicrm-core/pull/25511))**

- **Pull over a few more deprecations + blockDelete deprecation
  ([25695](https://github.com/civicrm/civicrm-core/pull/25695))**

- **Address portions of deprecated code replacement
  ([25693](https://github.com/civicrm/civicrm-core/pull/25693))**

- **Deprecate unused `CRM_Core_BAO_UFField::copy()` function
  ([25594](https://github.com/civicrm/civicrm-core/pull/25594))**

- **Deprecations for Mailing::delete functions
  ([25691](https://github.com/civicrm/civicrm-core/pull/25691))**

- **Deprecations for delete on ACL entities
  ([25690](https://github.com/civicrm/civicrm-core/pull/25690))**

- **Fully deprecate legacy contributionTokens
  ([25505](https://github.com/civicrm/civicrm-core/pull/25505))**

- **Fully deprecate `CRM_Core_SelectValues::eventTokens()`
  ([25509](https://github.com/civicrm/civicrm-core/pull/25509))**

- **Fully deprecate `CRM_Core_SelectValues::membershipTokens()`
  ([25506](https://github.com/civicrm/civicrm-core/pull/25506))**

- **Add noisy deprecation to deprecated function, after universe search
  ([25662](https://github.com/civicrm/civicrm-core/pull/25662))**

- **Remove legacy handling of locks for discontinued mysql/mariaDB versions
  ([25654](https://github.com/civicrm/civicrm-core/pull/25654))**

- **Remove forward incompatible syntax from template  
  ([25664](https://github.com/civicrm/civicrm-core/pull/25664))**

- **Remove conditional assignment around `is_deductible`
  ([25237](https://github.com/civicrm/civicrm-core/pull/25237))**

- **Remove unnecessary pass-by-reference
  ([25678](https://github.com/civicrm/civicrm-core/pull/25678))**

- **Remove empty on location - it should always be set now
  ([25675](https://github.com/civicrm/civicrm-core/pull/25675))**

- **Remove always-NULL `$singleRecord` variable
  ([25519](https://github.com/civicrm/civicrm-core/pull/25519))**

- **Remove 2020-deprecated handling of `legacyAddressCreate`
  ([25686](https://github.com/civicrm/civicrm-core/pull/25686))**

- **Remove code deprecated in 2018
  ([25679](https://github.com/civicrm/civicrm-core/pull/25679))**

- **Remove function noisily deprecated when the world was young (2020)
  ([25685](https://github.com/civicrm/civicrm-core/pull/25685))**

- **Remove deprecated function call
  ([25684](https://github.com/civicrm/civicrm-core/pull/25684))**

- **Remove deprecated functions from tests
  ([25688](https://github.com/civicrm/civicrm-core/pull/25688))**

- **Remove deprecated function calls to Event::del, Membership functions del,
  OptionValue ([25705](https://github.com/civicrm/civicrm-core/pull/25705))**

- **Remove function deprecated a year ago
  ([25615](https://github.com/civicrm/civicrm-core/pull/25615))**

- **Remove deprecated use of $ids
  ([25698](https://github.com/civicrm/civicrm-core/pull/25698))**

- **Delete long-deprecated functions
  ([25696](https://github.com/civicrm/civicrm-core/pull/25696))**

- **Remove the correct extraneous field separator field
  ([25753](https://github.com/civicrm/civicrm-core/pull/25753))**

- **Remove never-true IF
  ([25518](https://github.com/civicrm/civicrm-core/pull/25518))**

- **Remove unused constants left over from import cleanup
  ([25601](https://github.com/civicrm/civicrm-core/pull/25601))**

- **Remove interaction with complex legacy `getTree` function
  ([25395](https://github.com/civicrm/civicrm-core/pull/25395))**

- **Remove empty function
  ([25592](https://github.com/civicrm/civicrm-core/pull/25592))**

- **Remove unused variable
  ([25508](https://github.com/civicrm/civicrm-core/pull/25508))**

- **Remove unused variables
  ([25670](https://github.com/civicrm/civicrm-core/pull/25670))**

- **Remove unused property - not used since import code refactor `_lineCount`
  ([25466](https://github.com/civicrm/civicrm-core/pull/25466))**

- **(REF) Tidy up unused params in api_v3_ContributionSoftTest
  ([25322](https://github.com/civicrm/civicrm-core/pull/25322))**

- **[REF] Fix undefined variable notice in WordPress tests
  ([25591](https://github.com/civicrm/civicrm-core/pull/25591))**

- **(REF) Remove test reference to property which no longer exists
  ([25624](https://github.com/civicrm/civicrm-core/pull/25624))**

- **(REF) Remove unused setup from AdhocMailingTest
  ([25500](https://github.com/civicrm/civicrm-core/pull/25500))**

- **[REF] Add support for composer installers v2 which seems to be needed for
  d10 ([79](https://github.com/civicrm/civicrm-drupal-8/pull/79))**

- **Php8.x compatibility - do not try to count NULL
  ([25652](https://github.com/civicrm/civicrm-core/pull/25652))**

- **[REF][PHP8.2] Remove use of dynamic properties in
  CRM_Contact_Form_Task_EmailTest
  ([25562](https://github.com/civicrm/civicrm-core/pull/25562))**

- **[REF][PHP8.2] Get rid of dynamic properties in
  CRM_Core_Payment_AuthorizeNetTest
  ([25561](https://github.com/civicrm/civicrm-core/pull/25561))**

- **[REF][PHP8.2] Stop use of dynamic property in AdditionalPaymentTest
  ([25559](https://github.com/civicrm/civicrm-core/pull/25559))**

- **[REF][PHP8.2] Use variable instead of dynmaic property
  (CRM_Group_Page_AjaxTest)
  ([25558](https://github.com/civicrm/civicrm-core/pull/25558))**

- **[REF][PHP8.2] Declare property in CRM_Pledge_BAO_PledgeBlockTest
  ([25557](https://github.com/civicrm/civicrm-core/pull/25557))**

- **[REF][PHP8.2] Declare property in CRM_Utils_FakeObject
  ([25556](https://github.com/civicrm/civicrm-core/pull/25556))**

- **[REF][PHP8.2] Refactor properties on CRM_Event_Form_SearchTest
  ([25501](https://github.com/civicrm/civicrm-core/pull/25501))**

- **[REF][PHP8.2] Declare dynamic property in two SMS tests
  ([25502](https://github.com/civicrm/civicrm-core/pull/25502))**

- **[REF][PHP8.2] Remove unnecessary dynamic property
  ([25622](https://github.com/civicrm/civicrm-core/pull/25622))**

- **[REF][PHP8.2] Fix use of self in callables deprecation
  ([25625](https://github.com/civicrm/civicrm-core/pull/25625))**

- **[REF][PHP8.2] Tidy up properties on api_v3_GroupContactTest
  ([25626](https://github.com/civicrm/civicrm-core/pull/25626))**

- **[REF][PHP8.2] Tidy up properties in CRM_Event_BAO_EventPermissionsTest
  ([25623](https://github.com/civicrm/civicrm-core/pull/25623))**

- **update CiviCrmTestBase setup() method declaration to match BrowserTestBase
  ([78](https://github.com/civicrm/civicrm-drupal-8/pull/78))**

- **(NFC) crmURL - Add examples and whitespace. Crosslink docs.
  ([25665](https://github.com/civicrm/civicrm-core/pull/25665))**

- **[NFC] php8.2 support in test class `ActivitySearchTest`
  ([25607](https://github.com/civicrm/civicrm-core/pull/25607))**

- **NFC cleanup in test class
  ([25524](https://github.com/civicrm/civicrm-core/pull/25524))**

- **(NFC) Version Check Test - Fix multi-user and concurrent execution
  [25909](https://github.com/civicrm/civicrm-core/pull/25909)**

- **[NFC] doc block fix
  ([25610](https://github.com/civicrm/civicrm-core/pull/25610))**

- **Fix test to test the thing it was written to test
  ([25608](https://github.com/civicrm/civicrm-core/pull/25608))**

- **Event test cleanup, fix test to use submitted form values, rather than
  require a lot of contorting
  ([25621](https://github.com/civicrm/civicrm-core/pull/25621))**

- **Remove invalid  'world_region' => 'India' from test
  ([25540](https://github.com/civicrm/civicrm-core/pull/25540))**

- **Php8.2 test fix, remove one instance of undeclared property
  ([25619](https://github.com/civicrm/civicrm-core/pull/25619))**

- **Extend testing for ContributionConfirm & consolidate
  `isSeparateMembershipPayment`
  ([25270](https://github.com/civicrm/civicrm-core/pull/25270))**

- **Upgrade test to use more recent methodology for testing forms
  ([25551](https://github.com/civicrm/civicrm-core/pull/25551))**

- **Add extra test, comment how it could be used to fix bug
  ([25503](https://github.com/civicrm/civicrm-core/pull/25503))**

- **Reduce processing load in test `assertAPIFailure`
  ([25648](https://github.com/civicrm/civicrm-core/pull/25648))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; BrightMinded Ltd - Bradley Taylor;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC -
Mathieu Lutfy; Dave D; ES-Progress - Sandor Semsey; Freeform Solutions - Herb
van den Dool; Fuzion - Jitendra Purohit; Giant Rabbit - Anthony Nemirovsky;
iXiam - Luciano Spiegel; JMA Consulting - Seamus Lee; Lemniscus - Noah Miller;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
PERORA SRL - Samuele Masetto; Progressive Technology Project - Jamie McClelland;
Skvare - Mark Hanna; Tadpole Collective - Kevin Cristiano; Third Sector
Design - Kurund Jalmi, Michael McAndrew; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Francis Whittle, Justin Freeman; Andreas Howiller; Becca Tregenna;
Blackfly Solutions - Alan Dixon; Fuzion - Luke Stewart; Jens Schuppe;
JMA Consulting - Joe Murray; Megaphone Technology Consulting - Brienne Kordis;
Squiffle Consulting - Aidan Saunders; Stephen Palmstrom

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
