# CiviCRM 5.66.0

Released October 4, 2023

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add "phpstorm" extension ([27168](https://github.com/civicrm/civicrm-core/pull/27168),
  [27175](https://github.com/civicrm/civicrm-core/pull/27175),
  [27178](https://github.com/civicrm/civicrm-core/pull/27178),
  [27179](https://github.com/civicrm/civicrm-core/pull/27179),
  [27239](https://github.com/civicrm/civicrm-core/pull/27239), and [27262](https://github.com/civicrm/civicrm-core/pull/27262))**

  Adds a "phpstorm" extension which implements a process for integrating some
  dynamic data into PhpStorm.

- **Improve FormBuilder handling of non logged in flows
  (Work Towards [dev/core#4232](https://lab.civicrm.org/dev/core/-/issues/4232):
  [27041](https://github.com/civicrm/civicrm-core/pull/27041))**

  Improves FormBuilder schema to better handle form flows for anonymous users.

- **New core extension for scheduled reminders using criteria from
  search-kit
  ([dev/core#2644](https://lab.civicrm.org/dev/core/-/issues/2644):
  [27081](https://github.com/civicrm/civicrm-core/pull/27081))**

  Adds the Scheduled Communications extension which makes it so one can set up
  scheduled reminders using criteria from search-kit.

- **User experience improvement, hide by default the Latitude and Longitude
  fields, users can enable display if needed
  ([dev/core#2640](https://lab.civicrm.org/dev/core/-/issues/2640):
  [27100](https://github.com/civicrm/civicrm-core/pull/27100))**

  Hides the Latitude and Longitude fields by default.

- **Pass html text through a formatter when translating it to tokens
  ([27204](https://github.com/civicrm/civicrm-core/pull/27204) and
  [27203](https://github.com/civicrm/civicrm-core/pull/27203))**

  Converts new lines to page breaks when rendering text tokens to html.

- **Add custom data when creating smart group
  ([23312](https://github.com/civicrm/civicrm-core/pull/23312))**

  Adds group custom fields when creating a new smart group from search action
  Group -> Create Smart Group.

- **Add sort for country/state fields in reports
  ([dev/core#4532](https://lab.civicrm.org/dev/core/-/issues/4532):
  [27135](https://github.com/civicrm/civicrm-core/pull/27135))**

  Adds sort for country/state fields in reports.

- **Add system check for missing component extensions
  ([27453](https://github.com/civicrm/civicrm-core/pull/27453))**

  Expands the system check for required extensions to also cover component
  extensions.

- **Bump search_autocomplete_count default from 10 to 15
  ([27116](https://github.com/civicrm/civicrm-core/pull/27116))**

  Improves the overall responsiveness of Autocompletes by fetching more results
  at a time.

- **Schema - Improve pseudoconstant metadata for `prefetch` and `controlField`
  ([27054](https://github.com/civicrm/civicrm-core/pull/27054))**

  Improves schema metadata with an eye toward optimizing APIv4 pseudoconstant
  lookups.

- **Afform - Support multiple permissions in the GUI
  ([27272](https://github.com/civicrm/civicrm-core/pull/27272))**

  Allows multiple permissions to be set for an Afform.

- **Afform - Allow submissions to be disabled and limited
  ([27211](https://github.com/civicrm/civicrm-core/pull/27211))**

  Adds FormBuilder settings to disable submissions or limit the number of
  submissions.

- **SearchKit - Improve handling of money currency
  ([27202](https://github.com/civicrm/civicrm-core/pull/27202))**

  Improves SearchKit support for different types of monetary entities (e.g. the
  Expenses extension).

- **SearchKit - Expose sql functions provided by extensions
  ([27197](https://github.com/civicrm/civicrm-core/pull/27197))**

  Allows extensions to contribute SqlFunctions to SearchKit.

- **SearchKit - In-place edit without refreshing results
  ([27105](https://github.com/civicrm/civicrm-core/pull/27105))**

  Speeds up the process of in-place-editing on a SearchKit display.

- **Afform - Add Note as an afformEntity
  ([27110](https://github.com/civicrm/civicrm-core/pull/27110))**

  Adds the Note entity to Form Builder.

- **APIv4 Explorer - Keep list of suffixes in-sync
  ([27109](https://github.com/civicrm/civicrm-core/pull/27109))**

  Keeps the list of available pseudoconstant suffixes in APIv4 Explorer
  consistent with the master list.

- **API - Switched to cached function for looking up pemissioned groups
  ([27140](https://github.com/civicrm/civicrm-core/pull/27140))**

  Performance improvement for looking up acl groups.

- **Afform - Enhance returned values from AfformSubmission.afform_name options
  ([27108](https://github.com/civicrm/civicrm-core/pull/27108))**

  Improves the psueudoconstant options list returned from
  AfformSubmission.afform_name so that more attributes of the afform can be
  accessed.

- **Allow for configuration of activity contacts, type and campaign for
  email-to-activity
  ([26905](https://github.com/civicrm/civicrm-core/pull/26905))**

  Adds more options when setting up email-to-activity.

- **APIv4 - Proper ACLs for relationship entity
  ([27183](https://github.com/civicrm/civicrm-core/pull/27183))**

  Improves v4 Relationship API to use fine-grained ACLs instead of
  coarse-grained permission check which was too restrictive.

- **APIv4 - Add missing input type options
  ([27236](https://github.com/civicrm/civicrm-core/pull/27236))**

  Makes APIv4 aware of a couple more input types (both core and custom fields
  can have these types).

- **Add API-based EntityLookupTrait
  ([27257](https://github.com/civicrm/civicrm-core/pull/27257))**

  Adds a helper class to make it easy to lookup entity values.

- **Distmaker: add CiviCRM Standalone support
  ([27104](https://github.com/civicrm/civicrm-core/pull/27104))**

  Adds support for building CiviCRM Standalone tar.gz archives for
  nightly/rc/stable releases.

- **Standalone: add error handler
  ([26965](https://github.com/civicrm/civicrm-core/pull/26965))**

  Adds error handling for standalone implementations.

- **Update a couple more tpl variables to tokens
  ([27372](https://github.com/civicrm/civicrm-core/pull/27372),
  [27004](https://github.com/civicrm/civicrm-core/pull/27004) and
  [27017](https://github.com/civicrm/civicrm-core/pull/27017))**

  Updates a couple smarty template variables to use tokens instead.

- **SearchKit - Use Contact.sort_name instead of display_name for searches and
  Autocompletes ([27112](https://github.com/civicrm/civicrm-core/pull/27112))**

  Improves searchkit user experience by using contact sort name instead of
  display name for searches and autocompletes.

### CiviCase

- **Be able to remove clients from a case from the manage case view
  ([27200](https://github.com/civicrm/civicrm-core/pull/27200))**

  Makes it so users can remove clients from a case from the manage case view.

### CiviContribute

- **Add `Discount` to APIv4
  ([27122](https://github.com/civicrm/civicrm-core/pull/27122))**

  Adds APIv4 Discount entity.

### CiviEvent

- **Afform - Enable creating event from a template
  ([27058](https://github.com/civicrm/civicrm-core/pull/27058))**

  Enables selecting an event template when using Afform to create a new event.

### CiviMail

- **Update SMS cannot send message to specify that a mobile phone number is
  required ([27194](https://github.com/civicrm/civicrm-core/pull/27194))**

  Improves the error message when SMS cannot be sent to phone number because it
  is not a mobile phone.

### CiviMember

- **Membership Detail improvements (Work towards
  [dev/core#4522](https://lab.civicrm.org/dev/core/-/issues/4522):
  [27118](https://github.com/civicrm/civicrm-core/pull/27118) and
  [27249](https://github.com/civicrm/civicrm-core/pull/27249))**

  Improves the Membership detail report by adding: Membership Status,
  Auto-Renew, Auto-Renew Subscription Status, Start Date and End Date to the
  sorting tab.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Admin UI: Attempting to delete custom field group with custom fields opens
  the listing page in modal window
  ([dev/core#4094](https://lab.civicrm.org/dev/core/-/issues/4094):
  [27056](https://github.com/civicrm/civicrm-core/pull/27056))**

  Use statusBounce instead of redirect when a custom group cannot be deleted.

- **Standalone: language change does not stick (Work towards
  [dev/core#4425](https://lab.civicrm.org/dev/core/-/issues/4425):
  [27040](https://github.com/civicrm/civicrm-core/pull/27040), [27639](https://github.com/civicrm/civicrm-core/pull/27639))**

  Ensures currentPath for Standalone implementations does not return empty so
  that language-switcher extension can work.

- **Import caching issue (Work towards
  [dev/core#4467](https://lab.civicrm.org/dev/core/-/issues/4467):
  [27076](https://github.com/civicrm/civicrm-core/pull/27076))**

  Ensure saving and updating an import field mapping saves correctly.

- **Redis performance issue on delete contact
  ([dev/core#4501](https://lab.civicrm.org/dev/core/-/issues/4501):
  [27115](https://github.com/civicrm/civicrm-core/pull/27115))**

- **Search Kit - Links conditional doesn't work with domain_id or domain =
  current domain
  ([dev/core#4509](https://lab.civicrm.org/dev/core/-/issues/4509):
  [27093](https://github.com/civicrm/civicrm-core/pull/27093))**

- **ACLs' priority sometimes does the opposite of what it says it does
  ([dev/core#4542](https://lab.civicrm.org/dev/core/-/issues/4542):
  [27381](https://github.com/civicrm/civicrm-core/pull/27381))**

- **ACLs - Fix recent regression handling "edit all contacts" ([27409](https://github.com/civicrm/civicrm-core/pull/27409))**

- **Autocomplete - Fix search-by-id for entities without a numeric id  ([27629](https://github.com/civicrm/civicrm-core/pull/27629))**

- **When using a Contribution Page with a Membership Price Set, the contribution
  amount information never shows on the thank you page
  ([dev/core#4555](https://lab.civicrm.org/dev/core/-/issues/4555):
  [27330](https://github.com/civicrm/civicrm-core/pull/27330))**

- **SearchKit: Totals include test, template and deleted entities, while rows do
  not, leading to mismatch
  ([dev/core#4559](https://lab.civicrm.org/dev/core/-/issues/4559):
  [27383](https://github.com/civicrm/civicrm-core/pull/27383))**

- **Auto-complete option values aren't available to anonymous users
  ([dev/core#3049](https://lab.civicrm.org/dev/core/-/issues/3049):
  [26841](https://github.com/civicrm/civicrm-core/pull/26841))**

- **Add weights on profile fields page to fix notices
  ([27452](https://github.com/civicrm/civicrm-core/pull/27452))**

- **Upgrader - Skip snapshots on some MariaDB env's (roughly: 10.6.0-10.6.5)
  ([27404](https://github.com/civicrm/civicrm-core/pull/27404), [27464](https://github.com/civicrm/civicrm-core/pull/27464))**

- **APIv4: Implicit joins for email_primary, etc cause error
  ([dev/core#4562](https://lab.civicrm.org/dev/core/-/issues/4562):
  [27399](https://github.com/civicrm/civicrm-core/pull/27399))**

- **APIv4 - Fix setting nullable/required/default_value field metadata
  ([27302](https://github.com/civicrm/civicrm-core/pull/27302))**

- **Let unset weights give an e-notice
  ([26243](https://github.com/civicrm/civicrm-core/pull/26243))**

- **Add weight to a few more links
  ([27216](https://github.com/civicrm/civicrm-core/pull/27216),
  [27323](https://github.com/civicrm/civicrm-core/pull/27323),
  [27229](https://github.com/civicrm/civicrm-core/pull/27229),
  [27283](https://github.com/civicrm/civicrm-core/pull/27283),
  [27284](https://github.com/civicrm/civicrm-core/pull/27284) and
  [27230](https://github.com/civicrm/civicrm-core/pull/27230))**

- **Standalone: Fix ACL help/links, tweak Users and Permissions menu
  ([27119](https://github.com/civicrm/civicrm-core/pull/27119))**

- **Improve error handling by using civicrm_api3 not civicrm_api
  ([27321](https://github.com/civicrm/civicrm-core/pull/27321))**

- **Switch to using token for trxn_id, online contribution receipt
  ([27295](https://github.com/civicrm/civicrm-core/pull/27295))**

- **Delete probably-unused TrackingFields.tpl and adds a pre-upgrade message to
  warn people ([27233](https://github.com/civicrm/civicrm-core/pull/27233) and
  [27276](https://github.com/civicrm/civicrm-core/pull/27276))**

- **Re-enable any queues that were disabled for background processing, on end
  ([27023](https://github.com/civicrm/civicrm-core/pull/27023))**

- **Update one of our complex confirm tests to use full form flow, fix
  discovered failure to send to additional participants
  ([27277](https://github.com/civicrm/civicrm-core/pull/27277))**

- **Replace deprecated RegExp PHPUnit functions for v9
  ([27139](https://github.com/civicrm/civicrm-core/pull/27139))**

- **Switch menubar search to use APIv4 & delete deprecated v3 'getquick' action
  ([26676](https://github.com/civicrm/civicrm-core/pull/26676) and
  [27263](https://github.com/civicrm/civicrm-core/pull/27263))**

- **EntityLookupTrait - Skip queries when looking up id
  ([27261](https://github.com/civicrm/civicrm-core/pull/27261))**

- **PHP8 date range not rendered correctly
  ([27228](https://github.com/civicrm/civicrm-core/pull/27228))**

- **standaloneusers: logout function must be static
  ([27265](https://github.com/civicrm/civicrm-core/pull/27265))**s

- **Afform - make summary tab names less weird
  ([27196](https://github.com/civicrm/civicrm-core/pull/27196))**

- **Afform - Ensure prefill entities are populated correctly ([27615](https://github.com/civicrm/civicrm-core/pull/27615))**

- **Improve initialization crash message
  ([27138](https://github.com/civicrm/civicrm-core/pull/27138))**

- **Set weight on Note Form
  ([27106](https://github.com/civicrm/civicrm-core/pull/27106))**

- **Make import parser external ID error message more helpful
  ([27103](https://github.com/civicrm/civicrm-core/pull/27103))**

- **Show which extension has a parse error in info.xml
  ([27028](https://github.com/civicrm/civicrm-core/pull/27028))**

- **E:: to make it look after the extension's translation
  ([27027](https://github.com/civicrm/civicrm-core/pull/27027))**

- **Use phpunit when running on PHP 7.3+
  ([27036](https://github.com/civicrm/civicrm-core/pull/27036))**

- **ScheduledJob - Clean up form code & improve validation
  ([26879](https://github.com/civicrm/civicrm-core/pull/26879))**

- **Fix Domain Organization form for notices & PHP 8 compliance
  ([27190](https://github.com/civicrm/civicrm-core/pull/27190))**

- **Flush Redis `prevnext` cache when clearing `civicrm_cache`
  ([27113](https://github.com/civicrm/civicrm-core/pull/27113))**

- **Pass specific ids rather than ids array
  ([27274](https://github.com/civicrm/civicrm-core/pull/27274))**

- **Fix fatal on Manage Extensions caused by financialacls links
  ([27264](https://github.com/civicrm/civicrm-core/pull/27264))**

- **Fix weight notices on ActivityType (option values) pages
  ([27395](https://github.com/civicrm/civicrm-core/pull/27395))**

- **PseudoConstant - Prevent fatal when entity not available
  ([27358](https://github.com/civicrm/civicrm-core/pull/27358))**

- **SearchKit - Fix autocomplete filters on in-place-edit fields
  ([27253](https://github.com/civicrm/civicrm-core/pull/27253))**

- **Fix sort groups on PHP 8
  ([27210](https://github.com/civicrm/civicrm-core/pull/27210))**

- **ContactSummary - Fix smarty notices in communication preferences section
  ([27209](https://github.com/civicrm/civicrm-core/pull/27209))**

- **Afform - Fix broken prefill functionality
  ([27121](https://github.com/civicrm/civicrm-core/pull/27121))**

- **E-notice fix - switch order of and params check around
  ([27188](https://github.com/civicrm/civicrm-core/pull/27188))**

- **Fix deprecation notice on ExecuteJob screen
  ([27157](https://github.com/civicrm/civicrm-core/pull/27157))**

- **Fix PHP8.1 repeated notice errors in Table.tpl
  ([27137](https://github.com/civicrm/civicrm-core/pull/27137))**

- **Fix notices, PHP errors on event location tab
  ([27212](https://github.com/civicrm/civicrm-core/pull/27212))**

- **Fix notices on domain.tpl by just adding what we need
  ([27189](https://github.com/civicrm/civicrm-core/pull/27189))**

- **Notice fix - schedule reminders
  ([27154](https://github.com/civicrm/civicrm-core/pull/27154))**

- **Undefined property fix
  ([27148](https://github.com/civicrm/civicrm-core/pull/27148))**

- **Notice fix on contact types browse
  ([27153](https://github.com/civicrm/civicrm-core/pull/27153))**

- **Fix e-notice by removing conditionality
  ([27152](https://github.com/civicrm/civicrm-core/pull/27152))**

- **Windows fix for CRM_Utils_File::isChildPath
  ([27102](https://github.com/civicrm/civicrm-core/pull/27102))**

- **Fix Standalone error handler: remove 5th argument
  ([27099](https://github.com/civicrm/civicrm-core/pull/27099))**

- **Fatal error fixes in PHP 8.1
  ([27077](https://github.com/civicrm/civicrm-core/pull/27077))**

- **Path fixes
  ([27026](https://github.com/civicrm/civicrm-core/pull/27026))**

- **Fix warning caused by passing null to strpos
  ([300](https://github.com/civicrm/civicrm-wordpress/pull/300))**

- **kcfinder - Fix PHP 8.1 warnings from fastImage
  ([368](https://github.com/civicrm/civicrm-packages/pull/368))**

- **kcfinder - Fix cookies when running on alt HTTP port
  ([367](https://github.com/civicrm/civicrm-packages/pull/367))**

- **Smarty - Fix e-notice in modifier.escape.php
  ([366](https://github.com/civicrm/civicrm-packages/pull/366))**

- **Enotice fix ([27002](https://github.com/civicrm/civicrm-core/pull/27002))**

- **E-notice fix ([27001](https://github.com/civicrm/civicrm-core/pull/27001))**

- **E-notice fix, don't skip loading NULL fields
  ([27048](https://github.com/civicrm/civicrm-core/pull/27048))**

- **Fix missing weights on Custom data screen (notices)
  ([27428](https://github.com/civicrm/civicrm-core/pull/27428))**

- **Add weights on profile links (remove notices)
  ([27432](https://github.com/civicrm/civicrm-core/pull/27432))**

- **Fix mistake in just-merged email processor code
  ([27408](https://github.com/civicrm/civicrm-core/pull/27408))**

- **Fix undeclared properties in crufty old report
  ([27220](https://github.com/civicrm/civicrm-core/pull/27220))**

- **ajax.js - Fix undeclared variable
  ([27269](https://github.com/civicrm/civicrm-core/pull/27269))**

- **Move smarty assign to be always assigned (notices)
  ([27207](https://github.com/civicrm/civicrm-core/pull/27207))**

- **Fix undeclared property - use locally scoped variable
  ([27090](https://github.com/civicrm/civicrm-core/pull/27090))**

- **Smarty-notice fix - use array_key_exists
  ([27117](https://github.com/civicrm/civicrm-core/pull/27117))**

- **PHP 8.x fatal fix + bonus smarty consistency
  ([27091](https://github.com/civicrm/civicrm-core/pull/27091))**

### CiviCampaign

- **avoid double clicks on petition page
  ([27251](https://github.com/civicrm/civicrm-core/pull/27251))**

### CiviCase

- **Set link weight on manage case
  ([27327](https://github.com/civicrm/civicrm-core/pull/27327))**

- **Cannot add case type in multilingual installation with MariaDB 10.2 strict
  mode ([dev/core#2581](https://lab.civicrm.org/dev/core/-/issues/2581):
  [27226](https://github.com/civicrm/civicrm-core/pull/27226))**

### CiviContribute

- **Add contribution page tokens to contribution tokens
  ([27201](https://github.com/civicrm/civicrm-core/pull/27201))**

  Adds contribution page tokens to contribution tokens.

- **Fix Financial Items incorrectly recorded when using Payment API
  ([26987](https://github.com/civicrm/civicrm-core/pull/26987))**

- **Contribution pages with extra URL parameters lead to incorrect AJAX URL
  constructed in buildPaymentBlock – users cannot proceed to pay
  ([dev/core#4487](https://lab.civicrm.org/dev/core/-/issues/4487):
  [27037](https://github.com/civicrm/civicrm-core/pull/27037))**

- **Ensure tax_amount is not null
  ([26993](https://github.com/civicrm/civicrm-core/pull/26993))**

- **Fix permission check on Contribution form, clarify underlying functions
  ([27013](https://github.com/civicrm/civicrm-core/pull/27013))**

- **Fix PHP 8.0 implode on ContributionBase
  ([27053](https://github.com/civicrm/civicrm-core/pull/27053))**

- **Show Contribution Page receipt text in offline contribution receipt
  ([27173](https://github.com/civicrm/civicrm-core/pull/27173))**

- **Fix Contribution_Tab links to have weight, improve test
  ([27227](https://github.com/civicrm/civicrm-core/pull/27227))**

### CiviEvent

- **Registering a participant with Pending event payment gives misleading
  information. ([dev/core#3410](https://lab.civicrm.org/dev/core/-/issues/3410):
  [27288](https://github.com/civicrm/civicrm-core/pull/27288))**

  Show 0 rather than nothing when paid amount is zero

- **Event Dashboard: show events that have not ended yet
  ([27329](https://github.com/civicrm/civicrm-core/pull/27329))**

  Ensure events that span more than 7 days don't disappear from the Event
  Dashboard before the event ends.

- **Crash when saving repeating event
  ([dev/core#4550](https://lab.civicrm.org/dev/core/-/issues/4550):
  [27315](https://github.com/civicrm/civicrm-core/pull/27315))**

- **Replace Event Total with Total Amount on confirm/thankyou pages
  ([dev/core#4485](https://lab.civicrm.org/dev/core/-/issues/4485):
  [27024](https://github.com/civicrm/civicrm-core/pull/27024))**

- **View and Edit links for event participants are inconsistent and in some
  cases do not allow editing
  ([dev/core/#3361](https://lab.civicrm.org/dev/core/-/issues/3361):
  [24657](https://github.com/civicrm/civicrm-core/pull/24657))**

- **Fix variable leakage in online event receipt
  ([27443](https://github.com/civicrm/civicrm-core/pull/27443))**

- **Fix notice on unpaid event
  ([27367](https://github.com/civicrm/civicrm-core/pull/27367))**

- **Fix incorrect event receipt regression
  ([27159](https://github.com/civicrm/civicrm-core/pull/27159))**

- **Fix Manage Events breadcrumb regression
  ([27095](https://github.com/civicrm/civicrm-core/pull/27095))**

- **Manage event - fix too many brackets
  ([27061](https://github.com/civicrm/civicrm-core/pull/27061))**

- **Fix event templates to use end_date token
  ([27005](https://github.com/civicrm/civicrm-core/pull/27005))**

- **Ensure event ID is an integer
  ([27363](https://github.com/civicrm/civicrm-core/pull/27363))**

- **Also add event confirm text as default receipt_text for edit Participant
  ([27160](https://github.com/civicrm/civicrm-core/pull/27160))**

- **Online Event Receipt - Remove deprecated backticks ([27671](https://github.com/civicrm/civicrm-core/pull/27671))**

### CiviMail

- **Scheduled Job, fetch_bounces with is_create_activities=1 parameter creates
  a new Contact using the Return-path email address which is incorrect
  (Work towards [dev/core#2800](https://lab.civicrm.org/dev/core/-/issues/2800):
  [27356](https://github.com/civicrm/civicrm-core/pull/27356))**

  Fixes bounce processing to handle verp emails.

- **Wording changes in the Unsubscribe form
  ([27022](https://github.com/civicrm/civicrm-core/pull/27022))**

- **"New Mailing" - Unsubscribe field doesn't appear ([27626](https://github.com/civicrm/civicrm-core/pull/27626))**

- **Finish CiviCRM 2.1 deprecation - old-style VERP
  ([27318](https://github.com/civicrm/civicrm-core/pull/27318))**

### CiviMember

- **Report improvements (Work towards
  [dev/core#4536](https://lab.civicrm.org/dev/core/-/issues/4536):
  [27169](https://github.com/civicrm/civicrm-core/pull/27169))**

  Fixes the 'Primary Membership' filter options in the Membership Details report
  template.

- **Membership renewal on Feb 29 of a leap year is calculated incorrectly
  ([dev/core#4541](https://lab.civicrm.org/dev/core/-/issues/4541):
  [27198](https://github.com/civicrm/civicrm-core/pull/27198))**

- **Add weights to membership type links
  ([27231](https://github.com/civicrm/civicrm-core/pull/27231))**

### Backdrop Integration

- **Global $language should be an object, not a string
  ([dev/backdrop#80](https://lab.civicrm.org/dev/backdrop/-/issues/80):
  [27038](https://github.com/civicrm/civicrm-core/pull/27038))**

### Drupal Integration

- **phpunit.xml.dist - Fix compatibility with phpunit9
  ([670](https://github.com/civicrm/civicrm-drupal/pull/670))**

### WordPress Integration

- **E2E_Core_PathUrlTest::testGetUrl_WpAdmin() fails because CiviCRM routing is
  confusing (Work towards
  [dev/core#4433](https://lab.civicrm.org/dev/core/-/issues/4433):
  [26861](https://github.com/civicrm/civicrm-core/pull/26861))**

- **Plugin compatibility architecture and loss of locale on "Secondary URLs"
  when using Polylang
  ([dev/wordpress#143](https://lab.civicrm.org/dev/wordpress/-/issues/143):
  [27128](https://github.com/civicrm/civicrm-core/pull/27128) and
  [301](https://github.com/civicrm/civicrm-wordpress/pull/301))**

## <a name="misc"></a>Miscellany

- **phpunit.xml.dist - Update extensions to use phpunit9 format
  ([27133](https://github.com/civicrm/civicrm-core/pull/27133))**

- **APIv3 - Delete API examples
  ([27174](https://github.com/civicrm/civicrm-core/pull/27174))**

- **EntityLookupTrait - Add isDefined and getDefinition methods
  ([27275](https://github.com/civicrm/civicrm-core/pull/27275))**

- **API - Soft-deprecate civicrm_api() wrapper
  ([27180](https://github.com/civicrm/civicrm-core/pull/27180))**

- **APIv3 Explorer - Delete unused code
  ([27181](https://github.com/civicrm/civicrm-core/pull/27181))**

- **Pass in function values, rather than handling by form-name
  ([27092](https://github.com/civicrm/civicrm-core/pull/27092))**

- **Use new lookup trait to eliminate use of undefined properties
  `userDisplayName`
  ([27259](https://github.com/civicrm/civicrm-core/pull/27259))**


- **Joomla - Add placeholder to fix errors related to deleted file ([27591](https://github.com/civicrm/civicrm-core/pull/27591))**

- **Upgrader - Add breadcrumb guard ([27518](https://github.com/civicrm/civicrm-core/pull/27518))**

- **Upgrader - Add multilingual schema updates ([27446](https://github.com/civicrm/civicrm-core/pull/27446))**

- **CiviCampaign - Refactor civicrm_survey.recontact_interval
  ([27268](https://github.com/civicrm/civicrm-core/pull/27268))**

- **Move regex processing in EmailProcessor to handling class
  ([27337](https://github.com/civicrm/civicrm-core/pull/27337))**

- **Bump recommended PHP version to 8.1, min recommendation to 8.0
  ([26985](https://github.com/civicrm/civicrm-core/pull/26985))**

- **Add code comments re the cleanup I didn't do
  ([27451](https://github.com/civicrm/civicrm-core/pull/27451))**

- **Fold deprecated function back into the caller
  ([27345](https://github.com/civicrm/civicrm-core/pull/27345))**

- **Replace another badly named undeclared property
  ([27215](https://github.com/civicrm/civicrm-core/pull/27215))**

- **Move no-longer-shared function back to it's form
  ([27213](https://github.com/civicrm/civicrm-core/pull/27213))**

- **Fold private function back into calling function
  ([27145](https://github.com/civicrm/civicrm-core/pull/27145))**

- **Further fix forms to full form flow
  ([27256](https://github.com/civicrm/civicrm-core/pull/27256))**

- **Move form specific code to relevant form (rather than access
  mostly-undeclared property)
  ([27069](https://github.com/civicrm/civicrm-core/pull/27069))**

- **Extract `getDiscountID()`
  ([27049](https://github.com/civicrm/civicrm-core/pull/27049) and
  [27050](https://github.com/civicrm/civicrm-core/pull/27050))**

- **ScheduledReminders - Rewrite entire form using metadata
  ([27003](https://github.com/civicrm/civicrm-core/pull/27003))**

- **Move form-specific check to form
  ([27068](https://github.com/civicrm/civicrm-core/pull/27068))**

- **Simplify queries of NOT NULL fields
  ([27008](https://github.com/civicrm/civicrm-core/pull/27008))**

- **Clarify doc-block for form variable
  ([27051](https://github.com/civicrm/civicrm-core/pull/27051))**

- **Separate getStatusMessage function
  ([27015](https://github.com/civicrm/civicrm-core/pull/27015))**

- **Added details for sebalis in contributor-key.xml
  ([27039](https://github.com/civicrm/civicrm-core/pull/27039))**

- **Move function to only form that calls it
  ([27299](https://github.com/civicrm/civicrm-core/pull/27299))**

- **Unconditionally assign smarty variable
  ([27300](https://github.com/civicrm/civicrm-core/pull/27300))**

- **Unconditionally assign smarty-var, remove unused variables
  ([26051](https://github.com/civicrm/civicrm-core/pull/26051))**

- **Make function private, after universe search in EmailProcessor
  ([27309](https://github.com/civicrm/civicrm-core/pull/27309))**

- **Make function private to reflect usage
  ([27308](https://github.com/civicrm/civicrm-core/pull/27308))**

- **Declare CRM_Core_Exception in cleanDir, add type hints
  ([27306](https://github.com/civicrm/civicrm-core/pull/27306))**

- **Make splitjob function static & private, Remove a couple of unused variables
  ([27304](https://github.com/civicrm/civicrm-core/pull/27304))**

- **Do the todo (move the function to the trait as suggested
  ([27063](https://github.com/civicrm/civicrm-core/pull/27063))**

- **Api4 - Remove unused key from getFields
  ([27060](https://github.com/civicrm/civicrm-core/pull/27060))**

- **CRM_Core_Form - Remove unused protected properties
  ([27191](https://github.com/civicrm/civicrm-core/pull/27191))**

- **Remove isset from Arb.xml
  ([27224](https://github.com/civicrm/civicrm-core/pull/27224))**

- **Remove some copy & paste code
  ([27214](https://github.com/civicrm/civicrm-core/pull/27214))**

- **Remove Html2text security check, package deleted
  ([27218](https://github.com/civicrm/civicrm-core/pull/27218))**

- **Remove decade-only typo
  ([27219](https://github.com/civicrm/civicrm-core/pull/27219))**

- **Remove some unnecessary variables & pass by ref
  ([27273](https://github.com/civicrm/civicrm-core/pull/27273))**

- **Remove unused profiles from offline event receipts
  ([27150](https://github.com/civicrm/civicrm-core/pull/27150))**

- **Remove unused CONST
  ([27301](https://github.com/civicrm/civicrm-core/pull/27301))**

- **Remove always-true empty check
  ([27193](https://github.com/civicrm/civicrm-core/pull/27193))**

- **Remove unusable assigns (copy & paste I believe)
  ([26952](https://github.com/civicrm/civicrm-core/pull/26952))**

- **Remove broken deprecated function
  ([27163](https://github.com/civicrm/civicrm-core/pull/27163))**

- **Remove use of sometimes-php8-warning causing `_quickConfig` property… (use
  `isQuickConfig()` function)
  ([27070](https://github.com/civicrm/civicrm-core/pull/27070))**

- **Remove line that gives error & does nothing
  ([27064](https://github.com/civicrm/civicrm-core/pull/27064))**

- **Remove long-broken function
  ([27317](https://github.com/civicrm/civicrm-core/pull/27317))**

- **Remove unused variable
  ([27350](https://github.com/civicrm/civicrm-core/pull/27350))**

- **Remove unused parameter, pass by reference in private function with one
  caller ([27320](https://github.com/civicrm/civicrm-core/pull/27320))**

- **Remove some unused undefined properties from participant export
  ([27298](https://github.com/civicrm/civicrm-core/pull/27298))**

- **Remove unneeded descriptions and clean up on search forms
  ([26292](https://github.com/civicrm/civicrm-core/pull/26292))**

- **Remove do-nothing code.
  ([27047](https://github.com/civicrm/civicrm-core/pull/27047))**

- **Remove excessive data handling & some unused variables
  ([27019](https://github.com/civicrm/civicrm-core/pull/27019))**

- **Remove unused parse function for Incoming Mail
  ([27011](https://github.com/civicrm/civicrm-core/pull/27011))**

- **Remove unreachable page
  ([27305](https://github.com/civicrm/civicrm-core/pull/27305))**

- **Remove, extraneous: punctuation?
  ([27297](https://github.com/civicrm/civicrm-core/pull/27297))**

- **Delete html2text, not in use
  ([370](https://github.com/civicrm/civicrm-packages/pull/370))**

- **[REF] SearchKit - Cleanup upgrade code
  ([27042](https://github.com/civicrm/civicrm-core/pull/27042))**

- **(REF) civicrm_data.tpl - Stop using Smarty's {php}
  ([27052](https://github.com/civicrm/civicrm-core/pull/27052))**

- **[REF] APIv4 - Simplify entity name gathering
  ([27177](https://github.com/civicrm/civicrm-core/pull/27177))**

- **[REF] Remove unreachable handling
  ([27192](https://github.com/civicrm/civicrm-core/pull/27192))**

- **[REF] - Cleanup managed entities to all go through `hook_civicrm_managed`
  and deprecate unnamed entities
  ([27254](https://github.com/civicrm/civicrm-core/pull/27254))**

- **[REF] Convert from session status to deprecation warning
  ([27255](https://github.com/civicrm/civicrm-core/pull/27255))**

- **[REF] Fix Notice Errors on ACL listing page by assigning fields consistently
  ([27164](https://github.com/civicrm/civicrm-core/pull/27164))**

- **[REF] Update Zetacomponents/mail to be 1.9.5 to fix email validation
  handling ([27344](https://github.com/civicrm/civicrm-core/pull/27344))**

- **Revert "[REF] Update Zetacomponents/mail to be 1.9.5 to fix email validation
  handling" ([27394](https://github.com/civicrm/civicrm-core/pull/27394))**

- **REF - Simplify inline conditionals with Elvis
  ([27141](https://github.com/civicrm/civicrm-core/pull/27141))**

- **[REF] Ensure that any NULL values in the title field are fixed prior to
  changing the column
  ([27368](https://github.com/civicrm/civicrm-core/pull/27368))**

- **[REF] Improve cron job handling when there is an invalid report instance id
  passed to mail_report job
  ([27185](https://github.com/civicrm/civicrm-core/pull/27185))**

- **[REF] Fix infinite loop when trying to load a report instance with an id
  that does not exist
  ([27184](https://github.com/civicrm/civicrm-core/pull/27184))**

- **[REF] PCP - Update BAO to use writeRecord/deleteRecord
  ([27127](https://github.com/civicrm/civicrm-core/pull/27127))**

- **[REF] Add pseudoconstant suffixes to xml/dao
  ([27172](https://github.com/civicrm/civicrm-core/pull/27172))**

- **[REF] 🏌️ CRM_Utils_Array cleanup
  ([27187](https://github.com/civicrm/civicrm-core/pull/27187))**

- **[NFC] Be more confident and informative in the comment for
  CRM_Core_Session::set()
  ([27313](https://github.com/civicrm/civicrm-core/pull/27313))**

- **[NFC] Test - Add return type hints to test functions
  ([27186](https://github.com/civicrm/civicrm-core/pull/27186))**

- **(NFC) Test class - Fix inconsistent namespace
  ([27055](https://github.com/civicrm/civicrm-core/pull/27055))**

- **[NFC] Add some email processor hooks tests
  ([27097](https://github.com/civicrm/civicrm-core/pull/27097))**

- **(NFC) Fix random test failures ([27574](https://github.com/civicrm/civicrm-core/pull/27574))**

- **(NFC) Fix test failure on PHP 7.3 ([27714](https://github.com/civicrm/civicrm-core/pull/27714))**

- **Update ca-config for better PHP 8.2 support ([27550](https://github.com/civicrm/civicrm-core/pull/27550))**

- **Add missing weights for `hook_civicrm_links` ([27528](https://github.com/civicrm/civicrm-core/pull/27528), [27544](https://github.com/civicrm/civicrm-core/pull/27544), [27566](https://github.com/civicrm/civicrm-core/pull/27566), [27710](https://github.com/civicrm/civicrm-core/pull/27710))**

- **Remove old tests that only test test functions
  ([27208](https://github.com/civicrm/civicrm-core/pull/27208))**

- **Concurrency Tests - Update ExternalBatch for symfony/proces v4.1+ (esp
    Drupal 10) ([27072](https://github.com/civicrm/civicrm-core/pull/27072))**

- **Simplify test
  ([27205](https://github.com/civicrm/civicrm-core/pull/27205))**

- **Test fix, towards full form flow
  ([27067](https://github.com/civicrm/civicrm-core/pull/27067))**

- **Remove never called testCleanUp function
  ([27206](https://github.com/civicrm/civicrm-core/pull/27206))**

- **Add test & fix for getOptions on options with a domain id
  ([27161](https://github.com/civicrm/civicrm-core/pull/27161))**

- **Test Cleanup - Refactor out uses of deprecated `callAPIAndDocument()`
  ([27176](https://github.com/civicrm/civicrm-core/pull/27176))**

- **Remove some unused parameters in test class
  ([27166](https://github.com/civicrm/civicrm-core/pull/27166))**

- **ActionScheduleTest - Update for compatibility with PHPUnit 9
  ([27101](https://github.com/civicrm/civicrm-core/pull/27101))**

- **Unit tests - replace deprecated function with newer one
  ([27032](https://github.com/civicrm/civicrm-core/pull/27032))**

- **Fix forms to call full form flow
  ([27250](https://github.com/civicrm/civicrm-core/pull/27250))**

- **Add form helper for tests
  ([27267](https://github.com/civicrm/civicrm-core/pull/27267))**

- **Fix participantTest to not use transactions
  ([27260](https://github.com/civicrm/civicrm-core/pull/27260))**

- **Participant Form Test fixes
  ([27245](https://github.com/civicrm/civicrm-core/pull/27245))**

- **Superficial clean up in test class
  ([27238](https://github.com/civicrm/civicrm-core/pull/27238))**

- **Cleanup signature for test function `getFormObject`
  ([27225](https://github.com/civicrm/civicrm-core/pull/27225))**

- **Switch tests to use createTestEntity for payment processor
  ([27217](https://github.com/civicrm/civicrm-core/pull/27217))**

- **Add email helper to new form test helper
  ([27384](https://github.com/civicrm/civicrm-core/pull/27384))**

- **Fix financial transfer test to use form flow, allow all pending to transfer
  ([27281](https://github.com/civicrm/civicrm-core/pull/27281))**

- **Fix token consistency test with new lines and <br>s
  ([27314](https://github.com/civicrm/civicrm-core/pull/27314))**

- **Trivial cleanup in EmailProcessorTest
  ([27307](https://github.com/civicrm/civicrm-core/pull/27307))**

- **[test] [cleanup] Move _REQUEST cleanup to tearDown
  ([27285](https://github.com/civicrm/civicrm-core/pull/27285))**

- **Update further tests to additional form flow, lock in bug fix
  ([27279](https://github.com/civicrm/civicrm-core/pull/27279))**

- **Minor cleanup in test
  ([27282](https://github.com/civicrm/civicrm-core/pull/27282))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; ALL IN APPLI admin; Artful Robot -
Rich Lott; cdhassell; Christian Wach; Circle Interactive - Pradeep Nayak;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; civiservice.de -
Sebastian Lisken; Coop SymbioTIC - Mathieu Lutfy; Dave D; Humanists UK - Andrew
West; JMA Consulting - Seamus Lee; Just Hope - Phil Morice Brubaker; Lemniscus -
Noah Miller; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; Progressive Technology Project - Jamie McClelland; Robert J. Lang;
SebastianLisken; Squiffle Consulting - Aidan Saunders; Third Sector Design -
Kurund Jalmi; Wikimedia Foundation - Damilare Adedoyin, Eileen McNaughton,
Wenjun Fan; Wildsight - Lars Sander-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Andy Clark; ASMAC (American Society of Music
Arrangers and Composers) - Jeff Kellem; Australian Greens - Andrew
Cormick-Dockery, John Twyman; Francesc Bassas i Bullich; Freeform Solutions -
Herb van den Dool; Guydn; JMA Consulting - Joe Murray, Monish Deb; Korlon -
Stuart Gaston; Megaphone Technology Consulting - Brienne Kordis; Tadpole
Collective - Kevin Cristiano; Third Sector Design - William Mortada; Tobias
Voigt; yurg

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
