<div dir="rtl" markdown="1">

# Enum

Enum8 یا Enum16، به شما اجازه ی ذخیره سازی مجموعه ای محدود از رشته ها را می دهد که کارآمادتر از String می باشد.

مثال:

</div>

```
Enum8('hello' = 1, 'world' = 2)
```

<div dir="rtl" markdown="1">

- مقدار داخل این ستون می تواند یکی از دو مقدار 'hello' یا 'world' باشد.

هرکدام از مقادیر یک عدد در محدوده ی `-128 ... 127` برتی `Enum8` و در محدوده ی `-32768 ... 32767` برای `Enum16` می باشد. تمام رشته ها و اعداد باید متفاوت باشند. رشته ی خالی مجاز است. اگر این type مشخص شده باشد (در تعریف جدول)، اعداد می توانند به صورت دلخواه مرتب شوند. با این حال، ترتیب در اینجا مهم نیست.

در RAM، این type مشابه `Int8` یا `Int16` ذخیره می شود. هنگام خواندن در فرم متنی، ClickHouse مقدار را به صورت String پارس می کند و رشته ی مربوطه را در مقادیر Enum جستجو می کند. اگر رشته را پیدا کند یک expection پرتاب می شود. در هنگام خواندن در فرمت text، رشته خواند می شود و مقدار عددی مربوطه مورد بررسی قرار می گیرد. اگر مقدار پیدا نشود expection پرتاب می شود. هنگام نوشتن، مقدار با رشته ی مربوط نوشته می شود. اگر داده ی ستون دارای garbage باشد، (اعدادی که از مجموعه ی معتبرنیستند)، یک expection پرتاب می شود. هنگام خواندن و نوشتن به صورت باینری، این type شبیه به Int8 و Int16 کار می کند. The implicit default value is the value with the lowest number.

در حین `ORDER BY`, `GROUP BY`, `IN`, `DISTINCT` و...، این type رفتاری مشابه با اعداد دارد. برای مثال ORDER BY به صورت عددی اینها رو مرتب می کند.اپراتور های مقایسه ای و مساوی عمل مشابهی در Enums دارند.

مقادیر Enum نمیتوانند با اعداد مقایسه شوند. مقادیر Enum را می توان با رشته ی ثابت مقایسه کرد. اگر رشته ی مقایسه، مقدار معتبری برای مقایس به Enum نداشته باشد، یک expetion رخ می دهد. اپراتور IN در Enum پشتیبانی می شود؛ به این صورت که ستون enum در سمت چپ و مجموعه از رشته ها در سمت راست قرار می گیرند. رشته ها مقادیر مربوط به Enum هستند.

خیلی از اپراتورهای عددی و رشته ای برای مقادیر Enum تعریف نشده اند. برای مثال جمع یک عدد با Enum یا کانکت کردن یک رشته با Enum. با این حال Enum دارای تابعی به نام `toString` برای برگشت داده به صورت رشته می باشد.

همچنین مقادیر Enum با استفاده از تابع `toT` قابل تبدیل به type های عددی هستند. جایی که T یک type عددی است. زمانی که T به نوع عددی Enum مربوط می شود، این تبدیل هیچ هزینه ای ندارد. اگر فقط مجموعه از مقادیر تغییر کند، Enum بدون هیچ هزینه ای می تواند ALTER شود. اضافه یا حذف کردن عضوهای Enum با استفاده از Alter ممکن است (حذف یک عضو به شرطی که تا الان در جدول از آن استفاده نشده باشد امن است). به عنوان یک محافظ، تغییر مقدار عددی که قبلا توسط اعضای Enum تعریف شده است منجر به expection می شود.

استفاده از ALTER برای تبدیل Enum8 به Enum16 یا برعکس، ممکن است، دقیقا شبیه به Int8 به Int16.

</div>
[مقاله اصلی](https://clickhouse.yandex/docs/fa/data_types/enum/) <!--hide-->
