/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.SchemaDateTimeException;

public class MonthDayDatatypeValidator
extends DateTimeValidator {
    private static final int MONTHDAY_SIZE = 7;

    public MonthDayDatatypeValidator() throws InvalidDatatypeFacetException {
    }

    public MonthDayDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append(nArray[1]);
        this.message.append('-');
        this.message.append(nArray[2]);
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }

    protected int[] parse(String string, int[] nArray) throws SchemaDateTimeException {
        this.resetBuffer(string);
        if (nArray == null) {
            nArray = new int[8];
        }
        this.resetDateObj(nArray);
        nArray[0] = 2000;
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string);
        }
        nArray[1] = this.parseInt(this.fStart + 2, this.fStart + 4);
        this.fStart += 4;
        if (this.fBuffer.charAt(this.fStart++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string);
        }
        nArray[2] = this.parseInt(this.fStart, this.fStart + 2);
        if (this.fEnd > 7) {
            int n = this.findUTCSign(7, this.fEnd);
            if (n < 0) {
                throw new SchemaDateTimeException("Error in month parsing:" + string);
            }
            this.getTimeZone(nArray, n);
        }
        this.validateDateTime(nArray);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray);
        }
        return nArray;
    }
}

