Components.utils.import("chrome://flashblock/content/Flashblock.jsm"); // FBlockUtils, FBlockState

const ios = Components.classes["@mozilla.org/network/io-service;1"]
      .getService(Components.interfaces.nsIIOService);

function log(s) {
  content.console.log(s);
}

function getTargetURI(node) {
  var targetURI;
  try {
    // Get object URI in the same way as nsObjectLoadingContent::LoadObject()
    var relativeURI;
    switch (node.localName.toLowerCase()) {
      case "object":
        relativeURI = node.getAttribute("data") || node.getAttribute("src") || "";
        if (!relativeURI) {
          var params = node.getElementsByTagName("param");

          for (var ii = 0; ii < params.length; ii++) {
            var name = params[ii].getAttribute("name");
            switch (name) {
              case "movie":
              case "src":
                relativeURI = params[ii].getAttribute("value");
                break;
            }
          }
        }
        break;
      case "embed":
        relativeURI = node.getAttribute("src") || "";
        break;
    }


    var baseURI = ios.newURI(node.baseURI, null, null);
    var codeBase = node.getAttribute("codebase");
    if (codeBase) {
      try {
        baseURI = ios.newURI(codeBase, node.ownerDocument.characterSet, baseURI);
      } catch (e) {}  // Ignore invalid codebase attribute
    }
    if (node.ownerDocument)
      targetURI = ios.newURI(relativeURI, node.ownerDocument.characterSet, baseURI);
    else
      targetURI = ios.newURI(relativeURI, null, baseURI);
  }
  catch (e) {
    Components.utils.reportError(e);
  }
  return targetURI;
}

function blockedByContentPolicy(node) {
  try {
    var uri = getTargetURI(node);
    // Ask content policy whether this object is already blocked
    var requestOrigin = ios.newURI(node.ownerDocument.location, null, null);
    var contentPolicy = Components.classes["@mozilla.org/layout/content-policy;1"]
      .getService(Components.interfaces.nsIContentPolicy);
    var blockType = contentPolicy.shouldLoad(Components.interfaces.nsIContentPolicy.TYPE_OBJECT,
          uri, requestOrigin, node,
          node.getAttribute("type"), null);
    return blockType != Components.interfaces.nsIContentPolicy.ACCEPT;
  }
  catch (e) {
    Components.utils.reportError(e);
    return false;
  }
}


function check(e, featureEnabled) {
  log(e.type + ", " + FBlockState.enabled + ", " + featureEnabled + ", " + FBlockState.checkWhitelist(e.target.ownerDocument.location));
  const attrName = "data-flashblockWhitelisted";

  let node = e.target;
  node.removeAttribute(attrName);
  if (!FBlockState.enabled ||
      !featureEnabled ||
      (e.target &&
        (e.target.ownerDocument && e.target.ownerDocument.location && (FBlockState.checkWhitelist(e.target.ownerDocument.location)) ||
        (FBlockState.targetEnabled && FBlockState.checkWhitelist(getTargetURI(e.target))) ||
        blockedByContentPolicy(e.target)))
      ) {
      log(e.type + ": preventing");
      node.setAttribute(attrName, "true");
      e.preventDefault();
      log(e.type + ": prevented " + e.defaultPrevented  + ", " + e.cancelable + ", " + e.timeStamp);
    }
    e.stopPropagation();
}

addEventListener("flashblockCheckLoad", function(e) { check(e, FBlockState.enabled) }, true, true)
addEventListener("HTML5VideoCheckLoad", function(e) { check(e, FBlockState.videoblockEnabled) }, true, true)
addEventListener("silverblockCheckLoad", function(e) { check(e, FBlockState.silverblockEnabled) }, true, true)
