/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

package org.apache.fop.render.intermediate;

/**
 * Exception thrown by code dealing with FOP's intermediate format.
 */
public class IFException extends Exception {

    private static final long serialVersionUID = 0L;

    /**
     * Constructs a new exception with the specified detail message and cause.  <p>Note that the
     * detail message associated with <code>cause</code> is <i>not</i> automatically incorporated in
     * this exception's detail message.
     *
     * @param  message the detail message (which is saved for later retrieval by the
     * {@link #getMessage()} method).
     * @param  cause the cause (which is saved for later retrieval by the {@link #getCause()}
     * method).  (A <code>null</code> value is permitted, and indicates that the cause is
     * nonexistent or unknown.)
     */
    public IFException(String message, Exception cause) {
        super(message, cause);
    }

    /**
     * Constructs a new exception with the specified detail message.
     *
     * @param  message the detail message (which is saved for later retrieval by the
     * {@link #getMessage()} method).
     */
    public IFException(String message) {
        super(message);
    }
}
