// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/discoveryengine/v1alpha/schema.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Field value type in the Schema.
type FieldConfig_FieldType int32

const (
	// Field type is unspecified.
	FieldConfig_FIELD_TYPE_UNSPECIFIED FieldConfig_FieldType = 0
	// Field value type is Object.
	FieldConfig_OBJECT FieldConfig_FieldType = 1
	// Field value type is String.
	FieldConfig_STRING FieldConfig_FieldType = 2
	// Field value type is Number.
	FieldConfig_NUMBER FieldConfig_FieldType = 3
	// Field value type is Integer.
	FieldConfig_INTEGER FieldConfig_FieldType = 4
	// Field value type is Boolean.
	FieldConfig_BOOLEAN FieldConfig_FieldType = 5
	// Field value type is Geolocation.
	FieldConfig_GEOLOCATION FieldConfig_FieldType = 6
	// Field value type is Datetime.
	FieldConfig_DATETIME FieldConfig_FieldType = 7
)

// Enum value maps for FieldConfig_FieldType.
var (
	FieldConfig_FieldType_name = map[int32]string{
		0: "FIELD_TYPE_UNSPECIFIED",
		1: "OBJECT",
		2: "STRING",
		3: "NUMBER",
		4: "INTEGER",
		5: "BOOLEAN",
		6: "GEOLOCATION",
		7: "DATETIME",
	}
	FieldConfig_FieldType_value = map[string]int32{
		"FIELD_TYPE_UNSPECIFIED": 0,
		"OBJECT":                 1,
		"STRING":                 2,
		"NUMBER":                 3,
		"INTEGER":                4,
		"BOOLEAN":                5,
		"GEOLOCATION":            6,
		"DATETIME":               7,
	}
)

func (x FieldConfig_FieldType) Enum() *FieldConfig_FieldType {
	p := new(FieldConfig_FieldType)
	*p = x
	return p
}

func (x FieldConfig_FieldType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_FieldType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[0].Descriptor()
}

func (FieldConfig_FieldType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[0]
}

func (x FieldConfig_FieldType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_FieldType.Descriptor instead.
func (FieldConfig_FieldType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 0}
}

// The setting of Indexable options in schema.
type FieldConfig_IndexableOption int32

const (
	// Value used when unset.
	FieldConfig_INDEXABLE_OPTION_UNSPECIFIED FieldConfig_IndexableOption = 0
	// Indexable option enabled for a schema field.
	FieldConfig_INDEXABLE_ENABLED FieldConfig_IndexableOption = 1
	// Indexable option disabled for a schema field.
	FieldConfig_INDEXABLE_DISABLED FieldConfig_IndexableOption = 2
)

// Enum value maps for FieldConfig_IndexableOption.
var (
	FieldConfig_IndexableOption_name = map[int32]string{
		0: "INDEXABLE_OPTION_UNSPECIFIED",
		1: "INDEXABLE_ENABLED",
		2: "INDEXABLE_DISABLED",
	}
	FieldConfig_IndexableOption_value = map[string]int32{
		"INDEXABLE_OPTION_UNSPECIFIED": 0,
		"INDEXABLE_ENABLED":            1,
		"INDEXABLE_DISABLED":           2,
	}
)

func (x FieldConfig_IndexableOption) Enum() *FieldConfig_IndexableOption {
	p := new(FieldConfig_IndexableOption)
	*p = x
	return p
}

func (x FieldConfig_IndexableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_IndexableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[1].Descriptor()
}

func (FieldConfig_IndexableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[1]
}

func (x FieldConfig_IndexableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_IndexableOption.Descriptor instead.
func (FieldConfig_IndexableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 1}
}

// The status of the dynamic facetable option of a schema field.
type FieldConfig_DynamicFacetableOption int32

const (
	// Value used when unset.
	FieldConfig_DYNAMIC_FACETABLE_OPTION_UNSPECIFIED FieldConfig_DynamicFacetableOption = 0
	// Dynamic facetable option enabled for a schema field.
	FieldConfig_DYNAMIC_FACETABLE_ENABLED FieldConfig_DynamicFacetableOption = 1
	// Dynamic facetable option disabled for a schema field.
	FieldConfig_DYNAMIC_FACETABLE_DISABLED FieldConfig_DynamicFacetableOption = 2
)

// Enum value maps for FieldConfig_DynamicFacetableOption.
var (
	FieldConfig_DynamicFacetableOption_name = map[int32]string{
		0: "DYNAMIC_FACETABLE_OPTION_UNSPECIFIED",
		1: "DYNAMIC_FACETABLE_ENABLED",
		2: "DYNAMIC_FACETABLE_DISABLED",
	}
	FieldConfig_DynamicFacetableOption_value = map[string]int32{
		"DYNAMIC_FACETABLE_OPTION_UNSPECIFIED": 0,
		"DYNAMIC_FACETABLE_ENABLED":            1,
		"DYNAMIC_FACETABLE_DISABLED":           2,
	}
)

func (x FieldConfig_DynamicFacetableOption) Enum() *FieldConfig_DynamicFacetableOption {
	p := new(FieldConfig_DynamicFacetableOption)
	*p = x
	return p
}

func (x FieldConfig_DynamicFacetableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_DynamicFacetableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[2].Descriptor()
}

func (FieldConfig_DynamicFacetableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[2]
}

func (x FieldConfig_DynamicFacetableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_DynamicFacetableOption.Descriptor instead.
func (FieldConfig_DynamicFacetableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 2}
}

// The setting of Searchable options in schema.
type FieldConfig_SearchableOption int32

const (
	// Value used when unset.
	FieldConfig_SEARCHABLE_OPTION_UNSPECIFIED FieldConfig_SearchableOption = 0
	// Searchable option enabled for a schema field.
	FieldConfig_SEARCHABLE_ENABLED FieldConfig_SearchableOption = 1
	// Searchable option disabled for a schema field.
	FieldConfig_SEARCHABLE_DISABLED FieldConfig_SearchableOption = 2
)

// Enum value maps for FieldConfig_SearchableOption.
var (
	FieldConfig_SearchableOption_name = map[int32]string{
		0: "SEARCHABLE_OPTION_UNSPECIFIED",
		1: "SEARCHABLE_ENABLED",
		2: "SEARCHABLE_DISABLED",
	}
	FieldConfig_SearchableOption_value = map[string]int32{
		"SEARCHABLE_OPTION_UNSPECIFIED": 0,
		"SEARCHABLE_ENABLED":            1,
		"SEARCHABLE_DISABLED":           2,
	}
)

func (x FieldConfig_SearchableOption) Enum() *FieldConfig_SearchableOption {
	p := new(FieldConfig_SearchableOption)
	*p = x
	return p
}

func (x FieldConfig_SearchableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_SearchableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[3].Descriptor()
}

func (FieldConfig_SearchableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[3]
}

func (x FieldConfig_SearchableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_SearchableOption.Descriptor instead.
func (FieldConfig_SearchableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 3}
}

// The setting of Retrievable options in schema.
type FieldConfig_RetrievableOption int32

const (
	// Value used when unset.
	FieldConfig_RETRIEVABLE_OPTION_UNSPECIFIED FieldConfig_RetrievableOption = 0
	// Retrievable option enabled for a schema field.
	FieldConfig_RETRIEVABLE_ENABLED FieldConfig_RetrievableOption = 1
	// Retrievable option disabled for a schema field.
	FieldConfig_RETRIEVABLE_DISABLED FieldConfig_RetrievableOption = 2
)

// Enum value maps for FieldConfig_RetrievableOption.
var (
	FieldConfig_RetrievableOption_name = map[int32]string{
		0: "RETRIEVABLE_OPTION_UNSPECIFIED",
		1: "RETRIEVABLE_ENABLED",
		2: "RETRIEVABLE_DISABLED",
	}
	FieldConfig_RetrievableOption_value = map[string]int32{
		"RETRIEVABLE_OPTION_UNSPECIFIED": 0,
		"RETRIEVABLE_ENABLED":            1,
		"RETRIEVABLE_DISABLED":           2,
	}
)

func (x FieldConfig_RetrievableOption) Enum() *FieldConfig_RetrievableOption {
	p := new(FieldConfig_RetrievableOption)
	*p = x
	return p
}

func (x FieldConfig_RetrievableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_RetrievableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[4].Descriptor()
}

func (FieldConfig_RetrievableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[4]
}

func (x FieldConfig_RetrievableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_RetrievableOption.Descriptor instead.
func (FieldConfig_RetrievableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 4}
}

// The setting of Completable options in schema.
type FieldConfig_CompletableOption int32

const (
	// Value used when unset.
	FieldConfig_COMPLETABLE_OPTION_UNSPECIFIED FieldConfig_CompletableOption = 0
	// Completable option enabled for a schema field.
	FieldConfig_COMPLETABLE_ENABLED FieldConfig_CompletableOption = 1
	// Completable option disabled for a schema field.
	FieldConfig_COMPLETABLE_DISABLED FieldConfig_CompletableOption = 2
)

// Enum value maps for FieldConfig_CompletableOption.
var (
	FieldConfig_CompletableOption_name = map[int32]string{
		0: "COMPLETABLE_OPTION_UNSPECIFIED",
		1: "COMPLETABLE_ENABLED",
		2: "COMPLETABLE_DISABLED",
	}
	FieldConfig_CompletableOption_value = map[string]int32{
		"COMPLETABLE_OPTION_UNSPECIFIED": 0,
		"COMPLETABLE_ENABLED":            1,
		"COMPLETABLE_DISABLED":           2,
	}
)

func (x FieldConfig_CompletableOption) Enum() *FieldConfig_CompletableOption {
	p := new(FieldConfig_CompletableOption)
	*p = x
	return p
}

func (x FieldConfig_CompletableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_CompletableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[5].Descriptor()
}

func (FieldConfig_CompletableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[5]
}

func (x FieldConfig_CompletableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_CompletableOption.Descriptor instead.
func (FieldConfig_CompletableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 5}
}

// Sets the filterable option for schema fields.
type FieldConfig_FilterableOption int32

const (
	// Value used when unset.
	FieldConfig_FILTERABLE_OPTION_UNSPECIFIED FieldConfig_FilterableOption = 0
	// Filterable option enabled for a schema field.
	FieldConfig_FILTERABLE_ENABLED FieldConfig_FilterableOption = 1
	// Filterable option disabled for a schema field.
	FieldConfig_FILTERABLE_DISABLED FieldConfig_FilterableOption = 2
)

// Enum value maps for FieldConfig_FilterableOption.
var (
	FieldConfig_FilterableOption_name = map[int32]string{
		0: "FILTERABLE_OPTION_UNSPECIFIED",
		1: "FILTERABLE_ENABLED",
		2: "FILTERABLE_DISABLED",
	}
	FieldConfig_FilterableOption_value = map[string]int32{
		"FILTERABLE_OPTION_UNSPECIFIED": 0,
		"FILTERABLE_ENABLED":            1,
		"FILTERABLE_DISABLED":           2,
	}
)

func (x FieldConfig_FilterableOption) Enum() *FieldConfig_FilterableOption {
	p := new(FieldConfig_FilterableOption)
	*p = x
	return p
}

func (x FieldConfig_FilterableOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldConfig_FilterableOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[6].Descriptor()
}

func (FieldConfig_FilterableOption) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes[6]
}

func (x FieldConfig_FilterableOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldConfig_FilterableOption.Descriptor instead.
func (FieldConfig_FilterableOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1, 6}
}

// Defines the structure and layout of a type of document data.
type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema representation. One of
	// [struct_schema][google.cloud.discoveryengine.v1alpha.Schema.struct_schema]
	// or [json_schema][google.cloud.discoveryengine.v1alpha.Schema.json_schema]
	// should be provided otherwise an `INVALID_ARGUMENT` error is thrown.
	//
	// Types that are assignable to Schema:
	//
	//	*Schema_StructSchema
	//	*Schema_JsonSchema
	Schema isSchema_Schema `protobuf_oneof:"schema"`
	// Immutable. The full resource name of the schema, in the format of
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/schemas/{schema}`.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Configurations for fields of the schema.
	FieldConfigs []*FieldConfig `protobuf:"bytes,4,rep,name=field_configs,json=fieldConfigs,proto3" json:"field_configs,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{0}
}

func (m *Schema) GetSchema() isSchema_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (x *Schema) GetStructSchema() *structpb.Struct {
	if x, ok := x.GetSchema().(*Schema_StructSchema); ok {
		return x.StructSchema
	}
	return nil
}

func (x *Schema) GetJsonSchema() string {
	if x, ok := x.GetSchema().(*Schema_JsonSchema); ok {
		return x.JsonSchema
	}
	return ""
}

func (x *Schema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema) GetFieldConfigs() []*FieldConfig {
	if x != nil {
		return x.FieldConfigs
	}
	return nil
}

type isSchema_Schema interface {
	isSchema_Schema()
}

type Schema_StructSchema struct {
	// The structured representation of the schema.
	StructSchema *structpb.Struct `protobuf:"bytes,2,opt,name=struct_schema,json=structSchema,proto3,oneof"`
}

type Schema_JsonSchema struct {
	// The JSON representation of the schema.
	JsonSchema string `protobuf:"bytes,3,opt,name=json_schema,json=jsonSchema,proto3,oneof"`
}

func (*Schema_StructSchema) isSchema_Schema() {}

func (*Schema_JsonSchema) isSchema_Schema() {}

// Configurations for fields of a schema. For example, configuring a field is
// indexable, or searchable.
type FieldConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field path of the schema field.
	// For example: `title`, `description`, `release_info.release_year`.
	FieldPath string `protobuf:"bytes,1,opt,name=field_path,json=fieldPath,proto3" json:"field_path,omitempty"`
	// Output only. Raw type of the field.
	FieldType FieldConfig_FieldType `protobuf:"varint,2,opt,name=field_type,json=fieldType,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_FieldType" json:"field_type,omitempty"`
	// If
	// [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
	// is
	// [INDEXABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_ENABLED],
	// field values are indexed so that it can be filtered or faceted in
	// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
	//
	// If
	// [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
	// is unset, the server behavior defaults to
	// [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED]
	// for fields that support setting indexable options. For those fields that do
	// not support setting indexable options, such as `object` and `boolean` and
	// key properties, the server will skip
	// [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
	// setting, and setting
	// [indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
	// for those fields will throw `INVALID_ARGUMENT` error.
	IndexableOption FieldConfig_IndexableOption `protobuf:"varint,3,opt,name=indexable_option,json=indexableOption,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_IndexableOption" json:"indexable_option,omitempty"`
	// If
	// [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
	// is
	// [DYNAMIC_FACETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_ENABLED],
	// field values are available for dynamic facet. Could only be
	// [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
	// if
	// [FieldConfig.indexable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option]
	// is
	// [INDEXABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption.INDEXABLE_DISABLED].
	// Otherwise, an `INVALID_ARGUMENT` error will be returned.
	//
	// If
	// [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
	// is unset, the server behavior defaults to
	// [DYNAMIC_FACETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption.DYNAMIC_FACETABLE_DISABLED]
	// for fields that support setting dynamic facetable options. For those fields
	// that do not support setting dynamic facetable options, such as `object` and
	// `boolean`, the server will skip dynamic facetable option setting, and
	// setting
	// [dynamic_facetable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option]
	// for those fields will throw `INVALID_ARGUMENT` error.
	DynamicFacetableOption FieldConfig_DynamicFacetableOption `protobuf:"varint,4,opt,name=dynamic_facetable_option,json=dynamicFacetableOption,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_DynamicFacetableOption" json:"dynamic_facetable_option,omitempty"`
	// If
	// [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
	// is
	// [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED],
	// field values are searchable by text queries in
	// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search].
	//
	// If
	// [SEARCHABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_ENABLED]
	// but field type is numerical, field values will not be searchable by text
	// queries in
	// [SearchService.Search][google.cloud.discoveryengine.v1alpha.SearchService.Search],
	// as there are no text values associated to numerical fields.
	//
	// If
	// [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
	// is unset, the server behavior defaults to
	// [SEARCHABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption.SEARCHABLE_DISABLED]
	// for fields that support setting searchable options. Only `string` fields
	// that have no key property mapping support setting
	// [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option].
	//
	// For those fields that do not support setting searchable options, the server
	// will skip searchable option setting, and setting
	// [searchable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option]
	// for those fields will throw `INVALID_ARGUMENT` error.
	SearchableOption FieldConfig_SearchableOption `protobuf:"varint,5,opt,name=searchable_option,json=searchableOption,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_SearchableOption" json:"searchable_option,omitempty"`
	// If
	// [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
	// is
	// [RETRIEVABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_ENABLED],
	// field values are included in the search results.
	//
	// If
	// [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
	// is unset, the server behavior defaults to
	// [RETRIEVABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption.RETRIEVABLE_DISABLED]
	// for fields that support setting retrievable options. For those fields
	// that do not support setting retrievable options, such as `object` and
	// `boolean`, the server will skip retrievable option setting, and setting
	// [retrievable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option]
	// for those fields will throw `INVALID_ARGUMENT` error.
	RetrievableOption FieldConfig_RetrievableOption `protobuf:"varint,6,opt,name=retrievable_option,json=retrievableOption,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_RetrievableOption" json:"retrievable_option,omitempty"`
	// If
	// [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
	// is
	// [COMPLETABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_ENABLED],
	// field values are directly used and returned as suggestions for Autocomplete
	// in
	// [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1alpha.CompletionService.CompleteQuery].
	//
	// If
	// [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
	// is unset, the server behavior defaults to
	// [COMPLETABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption.COMPLETABLE_DISABLED]
	// for fields that support setting completable options, which are just
	// `string` fields. For those fields that do not support setting completable
	// options, the server will skip completable option setting, and setting
	// [completable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option]
	// for those fields will throw `INVALID_ARGUMENT` error.
	CompletableOption FieldConfig_CompletableOption `protobuf:"varint,8,opt,name=completable_option,json=completableOption,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_CompletableOption" json:"completable_option,omitempty"`
	// If
	// [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
	// is
	// [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED],
	// field values are filterable by filter expression in
	// [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
	//
	// If
	// [FILTERABLE_ENABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_ENABLED]
	// but the field type is numerical, field values are not filterable by text
	// queries in
	// [RecommendationService.Recommend][google.cloud.discoveryengine.v1alpha.RecommendationService.Recommend].
	// Only textual fields are supported.
	//
	// If
	// [recs_filterable_option][google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option]
	// is unset, the default setting is
	// [FILTERABLE_DISABLED][google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption.FILTERABLE_DISABLED]
	// for fields that support setting filterable options.
	//
	// When a field set to [FILTERABLE_DISABLED] is filtered, a warning is
	// generated and an empty result is returned.
	RecsFilterableOption FieldConfig_FilterableOption `protobuf:"varint,9,opt,name=recs_filterable_option,json=recsFilterableOption,proto3,enum=google.cloud.discoveryengine.v1alpha.FieldConfig_FilterableOption" json:"recs_filterable_option,omitempty"`
	// Output only. Type of the key property that this field is mapped to. Empty
	// string if this is not annotated as mapped to a key property.
	//
	// Example types are `title`, `description`. Full list is defined
	// by `keyPropertyMapping` in the schema field annotation.
	//
	// If the schema field has a `KeyPropertyMapping` annotation,
	// `indexable_option` and `searchable_option` of this field cannot be
	// modified.
	KeyPropertyType string `protobuf:"bytes,7,opt,name=key_property_type,json=keyPropertyType,proto3" json:"key_property_type,omitempty"`
}

func (x *FieldConfig) Reset() {
	*x = FieldConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldConfig) ProtoMessage() {}

func (x *FieldConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldConfig.ProtoReflect.Descriptor instead.
func (*FieldConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP(), []int{1}
}

func (x *FieldConfig) GetFieldPath() string {
	if x != nil {
		return x.FieldPath
	}
	return ""
}

func (x *FieldConfig) GetFieldType() FieldConfig_FieldType {
	if x != nil {
		return x.FieldType
	}
	return FieldConfig_FIELD_TYPE_UNSPECIFIED
}

func (x *FieldConfig) GetIndexableOption() FieldConfig_IndexableOption {
	if x != nil {
		return x.IndexableOption
	}
	return FieldConfig_INDEXABLE_OPTION_UNSPECIFIED
}

func (x *FieldConfig) GetDynamicFacetableOption() FieldConfig_DynamicFacetableOption {
	if x != nil {
		return x.DynamicFacetableOption
	}
	return FieldConfig_DYNAMIC_FACETABLE_OPTION_UNSPECIFIED
}

func (x *FieldConfig) GetSearchableOption() FieldConfig_SearchableOption {
	if x != nil {
		return x.SearchableOption
	}
	return FieldConfig_SEARCHABLE_OPTION_UNSPECIFIED
}

func (x *FieldConfig) GetRetrievableOption() FieldConfig_RetrievableOption {
	if x != nil {
		return x.RetrievableOption
	}
	return FieldConfig_RETRIEVABLE_OPTION_UNSPECIFIED
}

func (x *FieldConfig) GetCompletableOption() FieldConfig_CompletableOption {
	if x != nil {
		return x.CompletableOption
	}
	return FieldConfig_COMPLETABLE_OPTION_UNSPECIFIED
}

func (x *FieldConfig) GetRecsFilterableOption() FieldConfig_FilterableOption {
	if x != nil {
		return x.RecsFilterableOption
	}
	return FieldConfig_FILTERABLE_OPTION_UNSPECIFIED
}

func (x *FieldConfig) GetKeyPropertyType() string {
	if x != nil {
		return x.KeyPropertyType
	}
	return ""
}

var File_google_cloud_discoveryengine_v1alpha_schema_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xd6, 0x03, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3e,
	0x0a, 0x0d, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00,
	0x52, 0x0c, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x21,
	0x0a, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x6a, 0x73, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0d, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0xe8, 0x01, 0xea, 0x41, 0xe4, 0x01, 0x0a, 0x25,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x7b,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x7d, 0x12, 0x69, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x7d, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x7b, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0xa0, 0x0d, 0x0a,
	0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x5f, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x6c, 0x0a, 0x10, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x82, 0x01, 0x0a, 0x18, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x66, 0x61, 0x63, 0x65,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63,
	0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x64, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46, 0x61, 0x63, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x11, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x12, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a,
	0x16, 0x72, 0x65, 0x63, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x14, 0x72, 0x65, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x6b, 0x65, 0x79, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6b, 0x65, 0x79, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x84, 0x01, 0x0a, 0x09, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55,
	0x4d, 0x42, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x45,
	0x52, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x05,
	0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x45, 0x4f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x06, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x07, 0x22,
	0x62, 0x0a, 0x0f, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x49,
	0x4e, 0x44, 0x45, 0x58, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x22, 0x81, 0x01, 0x0a, 0x16, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x46,
	0x61, 0x63, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28,
	0x0a, 0x24, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x46, 0x41, 0x43, 0x45, 0x54, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x59, 0x4e, 0x41,
	0x4d, 0x49, 0x43, 0x5f, 0x46, 0x41, 0x43, 0x45, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x59, 0x4e, 0x41, 0x4d,
	0x49, 0x43, 0x5f, 0x46, 0x41, 0x43, 0x45, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x66, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16,
	0x0a, 0x12, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22,
	0x6a, 0x0a, 0x11, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x54, 0x52,
	0x49, 0x45, 0x56, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x6a, 0x0a, 0x11, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x18, 0x0a,
	0x14, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x22, 0x66, 0x0a, 0x10, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x46,
	0x49, 0x4c, 0x54, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16,
	0x0a, 0x12, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42,
	0x97, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0b, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2,
	0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e,
	0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0xea,
	0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_discoveryengine_v1alpha_schema_proto_goTypes = []interface{}{
	(FieldConfig_FieldType)(0),              // 0: google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType
	(FieldConfig_IndexableOption)(0),        // 1: google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption
	(FieldConfig_DynamicFacetableOption)(0), // 2: google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption
	(FieldConfig_SearchableOption)(0),       // 3: google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption
	(FieldConfig_RetrievableOption)(0),      // 4: google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption
	(FieldConfig_CompletableOption)(0),      // 5: google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption
	(FieldConfig_FilterableOption)(0),       // 6: google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption
	(*Schema)(nil),                          // 7: google.cloud.discoveryengine.v1alpha.Schema
	(*FieldConfig)(nil),                     // 8: google.cloud.discoveryengine.v1alpha.FieldConfig
	(*structpb.Struct)(nil),                 // 9: google.protobuf.Struct
}
var file_google_cloud_discoveryengine_v1alpha_schema_proto_depIdxs = []int32{
	9, // 0: google.cloud.discoveryengine.v1alpha.Schema.struct_schema:type_name -> google.protobuf.Struct
	8, // 1: google.cloud.discoveryengine.v1alpha.Schema.field_configs:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig
	0, // 2: google.cloud.discoveryengine.v1alpha.FieldConfig.field_type:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.FieldType
	1, // 3: google.cloud.discoveryengine.v1alpha.FieldConfig.indexable_option:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.IndexableOption
	2, // 4: google.cloud.discoveryengine.v1alpha.FieldConfig.dynamic_facetable_option:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.DynamicFacetableOption
	3, // 5: google.cloud.discoveryengine.v1alpha.FieldConfig.searchable_option:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.SearchableOption
	4, // 6: google.cloud.discoveryengine.v1alpha.FieldConfig.retrievable_option:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.RetrievableOption
	5, // 7: google.cloud.discoveryengine.v1alpha.FieldConfig.completable_option:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.CompletableOption
	6, // 8: google.cloud.discoveryengine.v1alpha.FieldConfig.recs_filterable_option:type_name -> google.cloud.discoveryengine.v1alpha.FieldConfig.FilterableOption
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_schema_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_schema_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_schema_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Schema_StructSchema)(nil),
		(*Schema_JsonSchema)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_schema_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_schema_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_schema_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_schema_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_schema_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_schema_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_schema_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_schema_proto_depIdxs = nil
}
