//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatalakestore

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountProperties.
func (a *AccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &a.AccountID)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "currentTier":
			err = unpopulate(val, "CurrentTier", &a.CurrentTier)
			delete(rawMsg, key)
		case "defaultGroup":
			err = unpopulate(val, "DefaultGroup", &a.DefaultGroup)
			delete(rawMsg, key)
		case "encryptionConfig":
			err = unpopulate(val, "EncryptionConfig", &a.EncryptionConfig)
			delete(rawMsg, key)
		case "encryptionProvisioningState":
			err = unpopulate(val, "EncryptionProvisioningState", &a.EncryptionProvisioningState)
			delete(rawMsg, key)
		case "encryptionState":
			err = unpopulate(val, "EncryptionState", &a.EncryptionState)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "firewallAllowAzureIps":
			err = unpopulate(val, "FirewallAllowAzureIPs", &a.FirewallAllowAzureIPs)
			delete(rawMsg, key)
		case "firewallRules":
			err = unpopulate(val, "FirewallRules", &a.FirewallRules)
			delete(rawMsg, key)
		case "firewallState":
			err = unpopulate(val, "FirewallState", &a.FirewallState)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "newTier":
			err = unpopulate(val, "NewTier", &a.NewTier)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "trustedIdProviderState":
			err = unpopulate(val, "TrustedIDProviderState", &a.TrustedIDProviderState)
			delete(rawMsg, key)
		case "trustedIdProviders":
			err = unpopulate(val, "TrustedIDProviders", &a.TrustedIDProviders)
			delete(rawMsg, key)
		case "virtualNetworkRules":
			err = unpopulate(val, "VirtualNetworkRules", &a.VirtualNetworkRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountPropertiesBasic.
func (a *AccountPropertiesBasic) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountId":
			err = unpopulate(val, "AccountID", &a.AccountID)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateTimeRFC3339(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &a.LastModifiedTime)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateDataLakeStoreAccountParameters.
func (c CreateDataLakeStoreAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type CreateDataLakeStoreAccountProperties.
func (c CreateDataLakeStoreAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultGroup", c.DefaultGroup)
	populate(objectMap, "encryptionConfig", c.EncryptionConfig)
	populate(objectMap, "encryptionState", c.EncryptionState)
	populate(objectMap, "firewallAllowAzureIps", c.FirewallAllowAzureIPs)
	populate(objectMap, "firewallRules", c.FirewallRules)
	populate(objectMap, "firewallState", c.FirewallState)
	populate(objectMap, "newTier", c.NewTier)
	populate(objectMap, "trustedIdProviderState", c.TrustedIDProviderState)
	populate(objectMap, "trustedIdProviders", c.TrustedIDProviders)
	populate(objectMap, "virtualNetworkRules", c.VirtualNetworkRules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateDataLakeStoreAccountParameters.
func (u UpdateDataLakeStoreAccountParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateDataLakeStoreAccountProperties.
func (u UpdateDataLakeStoreAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultGroup", u.DefaultGroup)
	populate(objectMap, "encryptionConfig", u.EncryptionConfig)
	populate(objectMap, "firewallAllowAzureIps", u.FirewallAllowAzureIPs)
	populate(objectMap, "firewallRules", u.FirewallRules)
	populate(objectMap, "firewallState", u.FirewallState)
	populate(objectMap, "newTier", u.NewTier)
	populate(objectMap, "trustedIdProviderState", u.TrustedIDProviderState)
	populate(objectMap, "trustedIdProviders", u.TrustedIDProviders)
	populate(objectMap, "virtualNetworkRules", u.VirtualNetworkRules)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateFirewallRuleParameters.
func (u UpdateFirewallRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateTrustedIDProviderParameters.
func (u UpdateTrustedIDProviderParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type UpdateVirtualNetworkRuleParameters.
func (u UpdateVirtualNetworkRuleParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
