//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import "time"

// AdministratorListResult - A list of active directory administrators.
type AdministratorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerAzureADAdministrator `json:"value,omitempty" azure:"ro"`
}

// AdministratorProperties - Properties of a active directory administrator.
type AdministratorProperties struct {
	// REQUIRED; Type of the sever administrator.
	AdministratorType *AdministratorType `json:"administratorType,omitempty"`

	// REQUIRED; Login name of the server administrator.
	Login *string `json:"login,omitempty"`

	// REQUIRED; SID (object ID) of the server administrator.
	Sid *string `json:"sid,omitempty"`

	// Tenant ID of the administrator.
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty" azure:"ro"`
}

// AdvancedThreatProtectionProperties - Properties of an Advanced Threat Protection state.
type AdvancedThreatProtectionProperties struct {
	// REQUIRED; Specifies the state of the Advanced Threat Protection, whether it is enabled or disabled or a state has not been
	// applied yet on the specific database or server.
	State *AdvancedThreatProtectionState `json:"state,omitempty"`

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`
}

// Advisor - Database, Server or Elastic Pool Advisor.
type Advisor struct {
	// Resource properties.
	Properties *AdvisorProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AdvisorProperties - Properties for a Database, Server or Elastic Pool Advisor.
type AdvisorProperties struct {
	// REQUIRED; Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible
	// values are 'Enabled' and 'Disabled'
	AutoExecuteStatus *AutoExecuteStatus `json:"autoExecuteStatus,omitempty"`

	// READ-ONLY; Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview', 'LimitedPublicPreview'
	// and 'PrivatePreview'.
	AdvisorStatus *AdvisorStatus `json:"advisorStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource from which current value of auto-execute status is inherited. Auto-execute status can be set
	// on (and inherited from) different levels in the resource hierarchy. Possible values are
	// 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
	AutoExecuteStatusInheritedFrom *AutoExecuteStatusInheritedFrom `json:"autoExecuteStatusInheritedFrom,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time when the current resource was analyzed for recommendations by this advisor.
	LastChecked *time.Time `json:"lastChecked,omitempty" azure:"ro"`

	// READ-ONLY; Gets that status of recommendations for this advisor and reason for not having any recommendations. Possible
	// values include, but are not limited to, 'Ok' (Recommendations available),LowActivity (not
	// enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
	RecommendationsStatus *string `json:"recommendationsStatus,omitempty" azure:"ro"`

	// READ-ONLY; Gets the recommended actions for this advisor.
	RecommendedActions []*RecommendedAction `json:"recommendedActions,omitempty" azure:"ro"`
}

// AgentClientCreateOrUpdateOptions contains the optional parameters for the AgentClient.CreateOrUpdate method.
type AgentClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AgentClientGetOptions contains the optional parameters for the AgentClient.Get method.
type AgentClientGetOptions struct {
	// placeholder for future optional parameters
}

// AgentConfiguration - A recoverable managed database resource.
type AgentConfiguration struct {
	// Resource properties.
	Properties *AgentConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AgentConfigurationProperties - Sql agent configuration properties.
type AgentConfigurationProperties struct {
	// The state of Sql Agent.
	State *SQLAgentConfigurationPropertiesState `json:"state,omitempty"`
}

// AutoPauseDelayTimeRange - Supported auto pause delay time range
type AutoPauseDelayTimeRange struct {
	// READ-ONLY; Default value is no value is provided
	Default *int32 `json:"default,omitempty" azure:"ro"`

	// READ-ONLY; Value that is used to not pause (infinite delay before pause)
	DoNotPauseValue *int32 `json:"doNotPauseValue,omitempty" azure:"ro"`

	// READ-ONLY; Maximum value
	MaxValue *int32 `json:"maxValue,omitempty" azure:"ro"`

	// READ-ONLY; Minimum value
	MinValue *int32 `json:"minValue,omitempty" azure:"ro"`

	// READ-ONLY; Step value for discrete values between the minimum value and the maximum value.
	StepSize *int32 `json:"stepSize,omitempty" azure:"ro"`

	// READ-ONLY; Unit of time that delay is expressed in
	Unit *PauseDelayTimeUnit `json:"unit,omitempty" azure:"ro"`
}

// AutomaticTuningOptions - Automatic tuning properties for individual advisors.
type AutomaticTuningOptions struct {
	// Automatic tuning option desired state.
	DesiredState *AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`

	// READ-ONLY; Automatic tuning option actual state.
	ActualState *AutomaticTuningOptionModeActual `json:"actualState,omitempty" azure:"ro"`

	// READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; Reason description if desired and actual state are different.
	ReasonDesc *AutomaticTuningDisabledReason `json:"reasonDesc,omitempty" azure:"ro"`
}

// AutomaticTuningServerOptions - Automatic tuning properties for individual advisors.
type AutomaticTuningServerOptions struct {
	// Automatic tuning option desired state.
	DesiredState *AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`

	// READ-ONLY; Automatic tuning option actual state.
	ActualState *AutomaticTuningOptionModeActual `json:"actualState,omitempty" azure:"ro"`

	// READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty" azure:"ro"`

	// READ-ONLY; Reason description if desired and actual state are different.
	ReasonDesc *AutomaticTuningServerReason `json:"reasonDesc,omitempty" azure:"ro"`
}

// AutomaticTuningServerProperties - Server-level Automatic Tuning properties.
type AutomaticTuningServerProperties struct {
	// Automatic tuning desired state.
	DesiredState *AutomaticTuningServerMode `json:"desiredState,omitempty"`

	// Automatic tuning options definition.
	Options map[string]*AutomaticTuningServerOptions `json:"options,omitempty"`

	// READ-ONLY; Automatic tuning actual state.
	ActualState *AutomaticTuningServerMode `json:"actualState,omitempty" azure:"ro"`
}

// AzureADOnlyAuthListResult - A list of active directory only authentications.
type AzureADOnlyAuthListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerAzureADOnlyAuthentication `json:"value,omitempty" azure:"ro"`
}

// AzureADOnlyAuthProperties - Properties of a active directory only authentication.
type AzureADOnlyAuthProperties struct {
	// REQUIRED; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// BackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the BackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate
// method.
type BackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupShortTermRetentionPoliciesClientBeginUpdateOptions contains the optional parameters for the BackupShortTermRetentionPoliciesClient.BeginUpdate
// method.
type BackupShortTermRetentionPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// BackupShortTermRetentionPoliciesClientGetOptions contains the optional parameters for the BackupShortTermRetentionPoliciesClient.Get
// method.
type BackupShortTermRetentionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BackupShortTermRetentionPoliciesClientListByDatabaseOptions contains the optional parameters for the BackupShortTermRetentionPoliciesClient.ListByDatabase
// method.
type BackupShortTermRetentionPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// BackupShortTermRetentionPolicy - A short term retention policy.
type BackupShortTermRetentionPolicy struct {
	// Resource properties.
	Properties *BackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupShortTermRetentionPolicyListResult - A list of short term retention policies.
type BackupShortTermRetentionPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*BackupShortTermRetentionPolicy `json:"value,omitempty" azure:"ro"`
}

// BackupShortTermRetentionPolicyProperties - Properties of a short term retention policy
type BackupShortTermRetentionPolicyProperties struct {
	// The differential backup interval in hours. This is how many interval hours between each differential backup will be supported.
	// This is only applicable to live databases but not dropped databases.
	DiffBackupIntervalInHours *DiffBackupIntervalInHours `json:"diffBackupIntervalInHours,omitempty"`

	// The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// BaseLongTermRetentionPolicyProperties - Properties of a long term retention policy
type BaseLongTermRetentionPolicyProperties struct {
	// The monthly retention policy for an LTR backup in an ISO 8601 format.
	MonthlyRetention *string `json:"monthlyRetention,omitempty"`

	// The week of year to take the yearly backup in an ISO 8601 format.
	WeekOfYear *int32 `json:"weekOfYear,omitempty"`

	// The weekly retention policy for an LTR backup in an ISO 8601 format.
	WeeklyRetention *string `json:"weeklyRetention,omitempty"`

	// The yearly retention policy for an LTR backup in an ISO 8601 format.
	YearlyRetention *string `json:"yearlyRetention,omitempty"`
}

// CapabilitiesClientListByLocationOptions contains the optional parameters for the CapabilitiesClient.ListByLocation method.
type CapabilitiesClientListByLocationOptions struct {
	// If specified, restricts the response to only include the selected item.
	Include *CapabilityGroup
}

// CheckNameAvailabilityRequest - A request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	// REQUIRED
	Name *string `json:"name,omitempty"`

	// REQUIRED
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse - The result of a name availability check.
type CheckNameAvailabilityResponse struct {
	// READ-ONLY; True if the name is available, otherwise false.
	Available *bool `json:"available,omitempty" azure:"ro"`

	// READ-ONLY; A message explaining why the name is unavailable. Will be undefined if the name is available.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The name whose availability was checked.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The reason code explaining why the name is unavailable. Will be undefined if the name is available.
	Reason *CheckNameAvailabilityReason `json:"reason,omitempty" azure:"ro"`
}

// CompleteDatabaseRestoreDefinition - Contains the information necessary to perform a complete database restore operation.
type CompleteDatabaseRestoreDefinition struct {
	// REQUIRED; The last backup name to apply
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// CopyLongTermRetentionBackupParameters - Contains the information necessary to perform long term retention backup copy operation.
type CopyLongTermRetentionBackupParameters struct {
	// Resource properties.
	Properties *CopyLongTermRetentionBackupParametersProperties `json:"properties,omitempty"`
}

// CopyLongTermRetentionBackupParametersProperties - Contains the properties to perform long term retention backup copy operation.
type CopyLongTermRetentionBackupParametersProperties struct {
	// The storage redundancy type of the copied backup
	TargetBackupStorageRedundancy *BackupStorageRedundancy `json:"targetBackupStorageRedundancy,omitempty"`

	// The name of the database owns the copied backup.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`

	// The resource group that owns the target server
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`

	// The fully qualified domain name of the target server
	TargetServerFullyQualifiedDomainName *string `json:"targetServerFullyQualifiedDomainName,omitempty"`

	// The resource Id of the target server that owns the database
	TargetServerResourceID *string `json:"targetServerResourceId,omitempty"`

	// The subscription that owns the target server
	TargetSubscriptionID *string `json:"targetSubscriptionId,omitempty"`
}

// CreateDatabaseRestorePointDefinition - Contains the information necessary to perform a create database restore point operation.
type CreateDatabaseRestorePointDefinition struct {
	// REQUIRED; The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// DNSRefreshConfigurationProperties - DNS refresh configuration properties.
type DNSRefreshConfigurationProperties struct {
	// READ-ONLY; The status of the DNS refresh operation.
	Status *DNSRefreshConfigurationPropertiesStatus `json:"status,omitempty" azure:"ro"`
}

// DataMaskingPoliciesClientCreateOrUpdateOptions contains the optional parameters for the DataMaskingPoliciesClient.CreateOrUpdate
// method.
type DataMaskingPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataMaskingPoliciesClientGetOptions contains the optional parameters for the DataMaskingPoliciesClient.Get method.
type DataMaskingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataMaskingPolicy - Represents a database data masking policy.
type DataMaskingPolicy struct {
	// The properties of the data masking policy.
	Properties *DataMaskingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataMaskingPolicyProperties - The properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// REQUIRED; The state of the data masking policy.
	DataMaskingState *DataMaskingState `json:"dataMaskingState,omitempty"`

	// The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking
	// policy does not apply. The specified users receive data results without masking
	// for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`

	// READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty" azure:"ro"`

	// READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty" azure:"ro"`
}

// DataMaskingRule - Represents a database data masking rule.
type DataMaskingRule struct {
	// The properties of the resource.
	Properties *DataMaskingRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataMaskingRuleListResult - The response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	// The list of database data masking rules.
	Value []*DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties - The properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	// REQUIRED; The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`

	// REQUIRED; The masking function that is used for the data masking rule.
	MaskingFunction *DataMaskingFunction `json:"maskingFunction,omitempty"`

	// REQUIRED; The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`

	// The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`

	// The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will
	// be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`

	// The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter
	// will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`

	// If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise,
	// this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`

	// If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter
	// will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`

	// The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction,
	// and specify ruleState as disabled. However, if the rule doesn't
	// already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState.
	RuleState *DataMaskingRuleState `json:"ruleState,omitempty"`

	// If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this
	// parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`

	// READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// DataMaskingRulesClientCreateOrUpdateOptions contains the optional parameters for the DataMaskingRulesClient.CreateOrUpdate
// method.
type DataMaskingRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DataMaskingRulesClientListByDatabaseOptions contains the optional parameters for the DataMaskingRulesClient.ListByDatabase
// method.
type DataMaskingRulesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DataWarehouseUserActivities - User activities of a data warehouse
type DataWarehouseUserActivities struct {
	// Resource properties.
	Properties *DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataWarehouseUserActivitiesClientGetOptions contains the optional parameters for the DataWarehouseUserActivitiesClient.Get
// method.
type DataWarehouseUserActivitiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataWarehouseUserActivitiesClientListByDatabaseOptions contains the optional parameters for the DataWarehouseUserActivitiesClient.ListByDatabase
// method.
type DataWarehouseUserActivitiesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DataWarehouseUserActivitiesListResult - User activities of a data warehouse
type DataWarehouseUserActivitiesListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DataWarehouseUserActivities `json:"value,omitempty" azure:"ro"`
}

// DataWarehouseUserActivitiesProperties - User activities of a data warehouse. This currently includes the count of running
// or suspended queries. For more information, please view the sys.dmpdwexec_requests dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty" azure:"ro"`
}

// Database - A database resource.
type Database struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// The Azure Active Directory identity of the database.
	Identity *DatabaseIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *DatabaseProperties `json:"properties,omitempty"`

	// The database SKU.
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family,
	// and capacity) that are available to your subscription in an Azure region,
	// use the Capabilities_ListByLocation REST API or one of the following commands:
	// az sql db list-editions -l <location> -o table
	// `
	// Get-AzSqlServerServiceObjective -Location <location>
	// `
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of database. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource that manages the database.
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseAdvancedThreatProtection - A database Advanced Threat Protection.
type DatabaseAdvancedThreatProtection struct {
	// Resource properties.
	Properties *AdvancedThreatProtectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of AdvancedThreatProtectionResource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseAdvancedThreatProtectionListResult - A list of the database's Advanced Threat Protection configurations.
type DatabaseAdvancedThreatProtectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseAdvancedThreatProtection `json:"value,omitempty" azure:"ro"`
}

// DatabaseAdvancedThreatProtectionSettingsClientCreateOrUpdateOptions contains the optional parameters for the DatabaseAdvancedThreatProtectionSettingsClient.CreateOrUpdate
// method.
type DatabaseAdvancedThreatProtectionSettingsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAdvancedThreatProtectionSettingsClientGetOptions contains the optional parameters for the DatabaseAdvancedThreatProtectionSettingsClient.Get
// method.
type DatabaseAdvancedThreatProtectionSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAdvancedThreatProtectionSettingsClientListByDatabaseOptions contains the optional parameters for the DatabaseAdvancedThreatProtectionSettingsClient.ListByDatabase
// method.
type DatabaseAdvancedThreatProtectionSettingsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAdvisorsClientGetOptions contains the optional parameters for the DatabaseAdvisorsClient.Get method.
type DatabaseAdvisorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAdvisorsClientListByDatabaseOptions contains the optional parameters for the DatabaseAdvisorsClient.ListByDatabase
// method.
type DatabaseAdvisorsClientListByDatabaseOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// DatabaseAdvisorsClientUpdateOptions contains the optional parameters for the DatabaseAdvisorsClient.Update method.
type DatabaseAdvisorsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAutomaticTuning - Database-level Automatic Tuning.
type DatabaseAutomaticTuning struct {
	// Resource properties.
	Properties *DatabaseAutomaticTuningProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseAutomaticTuningClientGetOptions contains the optional parameters for the DatabaseAutomaticTuningClient.Get method.
type DatabaseAutomaticTuningClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAutomaticTuningClientUpdateOptions contains the optional parameters for the DatabaseAutomaticTuningClient.Update
// method.
type DatabaseAutomaticTuningClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseAutomaticTuningProperties - Database-level Automatic Tuning properties.
type DatabaseAutomaticTuningProperties struct {
	// Automatic tuning desired state.
	DesiredState *AutomaticTuningMode `json:"desiredState,omitempty"`

	// Automatic tuning options definition.
	Options map[string]*AutomaticTuningOptions `json:"options,omitempty"`

	// READ-ONLY; Automatic tuning actual state.
	ActualState *AutomaticTuningMode `json:"actualState,omitempty" azure:"ro"`
}

// DatabaseBlobAuditingPoliciesClientCreateOrUpdateOptions contains the optional parameters for the DatabaseBlobAuditingPoliciesClient.CreateOrUpdate
// method.
type DatabaseBlobAuditingPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseBlobAuditingPoliciesClientGetOptions contains the optional parameters for the DatabaseBlobAuditingPoliciesClient.Get
// method.
type DatabaseBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseBlobAuditingPoliciesClientListByDatabaseOptions contains the optional parameters for the DatabaseBlobAuditingPoliciesClient.ListByDatabase
// method.
type DatabaseBlobAuditingPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseBlobAuditingPolicy - A database blob auditing policy.
type DatabaseBlobAuditingPolicy struct {
	// Resource properties.
	Properties *DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseBlobAuditingPolicyListResult - A list of database auditing settings.
type DatabaseBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// DatabaseBlobAuditingPolicyProperties - Properties of a database blob auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETEDGROUP DBCCGROUP DATABASE
	// OWNERSHIPCHANGEGROUP DATABASECHANGEGROUP LEDGEROPERATION_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'State'
	// as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// DatabaseColumn - A database column resource.
type DatabaseColumn struct {
	// Resource properties.
	Properties *DatabaseColumnProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseColumnListResult - A list of database columns.
type DatabaseColumnListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseColumn `json:"value,omitempty" azure:"ro"`
}

// DatabaseColumnProperties - Database column properties.
type DatabaseColumnProperties struct {
	// The column data type.
	ColumnType *ColumnDataType `json:"columnType,omitempty"`

	// Whether or not the column is computed.
	IsComputed *bool `json:"isComputed,omitempty"`

	// Whether or not the column belongs to a memory optimized table.
	MemoryOptimized *bool `json:"memoryOptimized,omitempty"`

	// The table temporal type.
	TemporalType *TableTemporalType `json:"temporalType,omitempty"`
}

// DatabaseColumnsClientGetOptions contains the optional parameters for the DatabaseColumnsClient.Get method.
type DatabaseColumnsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseColumnsClientListByDatabaseOptions contains the optional parameters for the DatabaseColumnsClient.ListByDatabase
// method.
type DatabaseColumnsClientListByDatabaseOptions struct {
	Column  []string
	OrderBy []string
	Schema  []string
	// An opaque token that identifies a starting point in the collection.
	Skiptoken *string
	Table     []string
}

// DatabaseColumnsClientListByTableOptions contains the optional parameters for the DatabaseColumnsClient.ListByTable method.
type DatabaseColumnsClientListByTableOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// DatabaseExtensions - An export managed database operation result resource.
type DatabaseExtensions struct {
	// Resource properties.
	Properties *DatabaseExtensionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseExtensionsClientBeginCreateOrUpdateOptions contains the optional parameters for the DatabaseExtensionsClient.BeginCreateOrUpdate
// method.
type DatabaseExtensionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseExtensionsClientGetOptions contains the optional parameters for the DatabaseExtensionsClient.Get method.
type DatabaseExtensionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseExtensionsClientListByDatabaseOptions contains the optional parameters for the DatabaseExtensionsClient.ListByDatabase
// method.
type DatabaseExtensionsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseExtensionsProperties - Contains the database information after successful export.
type DatabaseExtensionsProperties struct {
	// REQUIRED; Operation Mode.
	OperationMode *OperationMode `json:"operationMode,omitempty"`

	// REQUIRED; Storage key.
	StorageKey *string `json:"storageKey,omitempty"`

	// REQUIRED; Storage key type.
	StorageKeyType *StorageKeyType `json:"storageKeyType,omitempty"`

	// REQUIRED; Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`
}

// DatabaseIdentity - Azure Active Directory identity configuration for a resource.
type DatabaseIdentity struct {
	// The identity type
	Type *DatabaseIdentityType `json:"type,omitempty"`

	// The resource ids of the user assigned identities to use
	UserAssignedIdentities map[string]*DatabaseUserIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The Azure Active Directory tenant id.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// DatabaseListResult - A list of databases.
type DatabaseListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Database `json:"value,omitempty" azure:"ro"`
}

// DatabaseOperation - A database operation.
type DatabaseOperation struct {
	// Resource properties.
	Properties *DatabaseOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseOperationListResult - The response to a list database operations request
type DatabaseOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseOperation `json:"value,omitempty" azure:"ro"`
}

// DatabaseOperationProperties - The properties of a database operation.
type DatabaseOperationProperties struct {
	// READ-ONLY; The name of the database the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty" azure:"ro"`

	// READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *time.Time `json:"estimatedCompletionTime,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty" azure:"ro"`

	// READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The operation start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation state.
	State *ManagementOperationState `json:"state,omitempty" azure:"ro"`
}

// DatabaseOperationsClientCancelOptions contains the optional parameters for the DatabaseOperationsClient.Cancel method.
type DatabaseOperationsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// DatabaseOperationsClientListByDatabaseOptions contains the optional parameters for the DatabaseOperationsClient.ListByDatabase
// method.
type DatabaseOperationsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseProperties - The database's properties.
type DatabaseProperties struct {
	// Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
	AutoPauseDelay *int32 `json:"autoPauseDelay,omitempty"`

	// Collation of the metadata catalog.
	CatalogCollation *CatalogCollationType `json:"catalogCollation,omitempty"`

	// The collation of the database.
	Collation *string `json:"collation,omitempty"`

	// Specifies the mode of database creation.
	// Default: regular database creation.
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the
	// source database.
	// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the
	// resource ID of the existing primary database.
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must
	// be specified as the resource ID of the existing database, and
	// restorePointInTime must be specified.
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable
	// database resource ID to restore.
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId
	// is the database's original resource ID, then sourceDatabaseDeletionDate
	// must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate
	// is ignored. restorePointInTime may also be specified to restore from an
	// earlier point in time.
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId
	// must be specified as the recovery point resource ID.
	// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// The resource identifier of the elastic pool containing this database.
	ElasticPoolID *string `json:"elasticPoolId,omitempty"`

	// The Client id used for cross tenant per database CMK scenario
	FederatedClientID *string `json:"federatedClientId,omitempty"`

	// The number of secondary replicas associated with the database that are used to provide high availability. Not applicable
	// to a Hyperscale database within an elastic pool.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`

	// Whether or not this database is a ledger database, which means all tables in the database are ledger tables. Note: the
	// value of this property cannot be changed after the database has been created.
	IsLedgerOn *bool `json:"isLedgerOn,omitempty"`

	// The license type to apply for this database. LicenseIncluded if you need a license, or BasePrice if you have a license
	// and are eligible for the Azure Hybrid Benefit.
	LicenseType *DatabaseLicenseType `json:"licenseType,omitempty"`

	// The resource identifier of the long term retention backup associated with create operation of this database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`

	// Maintenance configuration id assigned to the database. This configuration defines the period when the maintenance updates
	// will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`

	// The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`

	// Minimal capacity that database will always have allocated, if not paused
	MinCapacity *float64 `json:"minCapacity,omitempty"`

	// The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection
	// string may be routed to a readonly secondary replica in the same region. Not
	// applicable to a Hyperscale database within an elastic pool.
	ReadScale *DatabaseReadScale `json:"readScale,omitempty"`

	// The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`

	// The resource identifier of the recovery point associated with create operation of this database.
	RecoveryServicesRecoveryPointID *string `json:"recoveryServicesRecoveryPointId,omitempty"`

	// The storage account type to be used to store backups for this database.
	RequestedBackupStorageRedundancy *BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`

	// The resource identifier of the restorable dropped database associated with create operation of this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`

	// Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *time.Time `json:"restorePointInTime,omitempty"`

	// The name of the sample schema to apply when creating this database.
	SampleName *SampleName `json:"sampleName,omitempty"`

	// The secondary type of the database if it is a secondary. Valid values are Geo and Named.
	SecondaryType *SecondaryType `json:"secondaryType,omitempty"`

	// Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *time.Time `json:"sourceDatabaseDeletionDate,omitempty"`

	// The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`

	// The resource identifier of the source associated with the create operation of this database.
	// When sourceResourceId is specified, sourceDatabaseId, recoverableDatabaseId, restorableDroppedDatabaseId and sourceDatabaseDeletionDate
	// must not be specified and CreateMode must be PointInTimeRestore,
	// Restore or Recover.
	// When createMode is PointInTimeRestore, sourceResourceId must be the resource ID of an existing database or existing sql
	// pool, and restorePointInTime must be specified.
	// When createMode is Restore, sourceResourceId must be the resource ID of restorable dropped database or restorable dropped
	// sql pool.
	// When createMode is Recover, sourceResourceId must be the resource ID of recoverable database or recoverable sql pool.
	// This property allows to restore across subscriptions which is only supported for DataWarehouse edition.
	// When source subscription belongs to a different tenant than target subscription, “x-ms-authorization-auxiliary” header
	// must contain authentication token for the source tenant. For more details about
	// “x-ms-authorization-auxiliary” header see https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/authenticate-multi-tenant
	SourceResourceID *string `json:"sourceResourceId,omitempty"`

	// Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple
	// availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The storage account type used to store backups for this database.
	CurrentBackupStorageRedundancy *BackupStorageRedundancy `json:"currentBackupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; The name and tier of the SKU.
	CurrentSKU *SKU `json:"currentSku,omitempty" azure:"ro"`

	// READ-ONLY; The current service level objective name of the database.
	CurrentServiceObjectiveName *string `json:"currentServiceObjectiveName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the database.
	DatabaseID *string `json:"databaseId,omitempty" azure:"ro"`

	// READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`

	// READ-ONLY; Failover Group resource identifier that this database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty" azure:"ro"`

	// READ-ONLY; Infra encryption is enabled for this database.
	IsInfraEncryptionEnabled *bool `json:"isInfraEncryptionEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The max log size for this database.
	MaxLogSizeBytes *int64 `json:"maxLogSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; The date when database was paused by user configuration or action(ISO8601 format). Null if the database is ready.
	PausedDate *time.Time `json:"pausedDate,omitempty" azure:"ro"`

	// READ-ONLY; The requested service level objective name of the database.
	RequestedServiceObjectiveName *string `json:"requestedServiceObjectiveName,omitempty" azure:"ro"`

	// READ-ONLY; The date when database was resumed by user action or database login (ISO8601 format). Null if the database is
	// paused.
	ResumedDate *time.Time `json:"resumedDate,omitempty" azure:"ro"`

	// READ-ONLY; The status of the database.
	Status *DatabaseStatus `json:"status,omitempty" azure:"ro"`
}

// DatabaseRecommendedActionsClientGetOptions contains the optional parameters for the DatabaseRecommendedActionsClient.Get
// method.
type DatabaseRecommendedActionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseRecommendedActionsClientListByDatabaseAdvisorOptions contains the optional parameters for the DatabaseRecommendedActionsClient.ListByDatabaseAdvisor
// method.
type DatabaseRecommendedActionsClientListByDatabaseAdvisorOptions struct {
	// placeholder for future optional parameters
}

// DatabaseRecommendedActionsClientUpdateOptions contains the optional parameters for the DatabaseRecommendedActionsClient.Update
// method.
type DatabaseRecommendedActionsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseSchema - A database schema resource.
type DatabaseSchema struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseSchemaListResult - A list of database schemas.
type DatabaseSchemaListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseSchema `json:"value,omitempty" azure:"ro"`
}

// DatabaseSchemasClientGetOptions contains the optional parameters for the DatabaseSchemasClient.Get method.
type DatabaseSchemasClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseSchemasClientListByDatabaseOptions contains the optional parameters for the DatabaseSchemasClient.ListByDatabase
// method.
type DatabaseSchemasClientListByDatabaseOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// DatabaseSecurityAlertListResult - A list of the database's security alert policies.
type DatabaseSecurityAlertListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// DatabaseSecurityAlertPoliciesClientCreateOrUpdateOptions contains the optional parameters for the DatabaseSecurityAlertPoliciesClient.CreateOrUpdate
// method.
type DatabaseSecurityAlertPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseSecurityAlertPoliciesClientGetOptions contains the optional parameters for the DatabaseSecurityAlertPoliciesClient.Get
// method.
type DatabaseSecurityAlertPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseSecurityAlertPoliciesClientListByDatabaseOptions contains the optional parameters for the DatabaseSecurityAlertPoliciesClient.ListByDatabase
// method.
type DatabaseSecurityAlertPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseSecurityAlertPolicy - A database security alert policy.
type DatabaseSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertsPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of SecurityAlertPolicyResource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseTable - A database table resource.
type DatabaseTable struct {
	// Resource properties.
	Properties *DatabaseTableProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseTableListResult - A list of database tables.
type DatabaseTableListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseTable `json:"value,omitempty" azure:"ro"`
}

// DatabaseTableProperties - Database table properties.
type DatabaseTableProperties struct {
	// Whether or not the table is memory optimized.
	MemoryOptimized *bool `json:"memoryOptimized,omitempty"`

	// The table temporal type.
	TemporalType *TableTemporalType `json:"temporalType,omitempty"`
}

// DatabaseTablesClientGetOptions contains the optional parameters for the DatabaseTablesClient.Get method.
type DatabaseTablesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseTablesClientListBySchemaOptions contains the optional parameters for the DatabaseTablesClient.ListBySchema method.
type DatabaseTablesClientListBySchemaOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// DatabaseUpdate - A database update resource.
type DatabaseUpdate struct {
	// Database identity
	Identity *DatabaseIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *DatabaseUpdateProperties `json:"properties,omitempty"`

	// The name and tier of the SKU.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DatabaseUpdateProperties - A database update properties.
type DatabaseUpdateProperties struct {
	// Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
	AutoPauseDelay *int32 `json:"autoPauseDelay,omitempty"`

	// Collation of the metadata catalog.
	CatalogCollation *CatalogCollationType `json:"catalogCollation,omitempty"`

	// The collation of the database.
	Collation *string `json:"collation,omitempty"`

	// Specifies the mode of database creation.
	// Default: regular database creation.
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the
	// source database.
	// Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the
	// resource ID of the existing primary database.
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must
	// be specified as the resource ID of the existing database, and
	// restorePointInTime must be specified.
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable
	// database resource ID to restore.
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId
	// is the database's original resource ID, then sourceDatabaseDeletionDate
	// must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate
	// is ignored. restorePointInTime may also be specified to restore from an
	// earlier point in time.
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId
	// must be specified as the recovery point resource ID.
	// Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// The resource identifier of the elastic pool containing this database.
	ElasticPoolID *string `json:"elasticPoolId,omitempty"`

	// The Client id used for cross tenant per database CMK scenario
	FederatedClientID *string `json:"federatedClientId,omitempty"`

	// The number of secondary replicas associated with the database that are used to provide high availability. Not applicable
	// to a Hyperscale database within an elastic pool.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`

	// Whether or not this database is a ledger database, which means all tables in the database are ledger tables. Note: the
	// value of this property cannot be changed after the database has been created.
	IsLedgerOn *bool `json:"isLedgerOn,omitempty"`

	// The license type to apply for this database. LicenseIncluded if you need a license, or BasePrice if you have a license
	// and are eligible for the Azure Hybrid Benefit.
	LicenseType *DatabaseLicenseType `json:"licenseType,omitempty"`

	// The resource identifier of the long term retention backup associated with create operation of this database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`

	// Maintenance configuration id assigned to the database. This configuration defines the period when the maintenance updates
	// will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`

	// The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`

	// Minimal capacity that database will always have allocated, if not paused
	MinCapacity *float64 `json:"minCapacity,omitempty"`

	// The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection
	// string may be routed to a readonly secondary replica in the same region. Not
	// applicable to a Hyperscale database within an elastic pool.
	ReadScale *DatabaseReadScale `json:"readScale,omitempty"`

	// The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`

	// The resource identifier of the recovery point associated with create operation of this database.
	RecoveryServicesRecoveryPointID *string `json:"recoveryServicesRecoveryPointId,omitempty"`

	// The storage account type to be used to store backups for this database.
	RequestedBackupStorageRedundancy *BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`

	// The resource identifier of the restorable dropped database associated with create operation of this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`

	// Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *time.Time `json:"restorePointInTime,omitempty"`

	// The name of the sample schema to apply when creating this database.
	SampleName *SampleName `json:"sampleName,omitempty"`

	// The secondary type of the database if it is a secondary. Valid values are Geo and Named.
	SecondaryType *SecondaryType `json:"secondaryType,omitempty"`

	// Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *time.Time `json:"sourceDatabaseDeletionDate,omitempty"`

	// The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`

	// Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple
	// availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The storage account type used to store backups for this database.
	CurrentBackupStorageRedundancy *BackupStorageRedundancy `json:"currentBackupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; The name and tier of the SKU.
	CurrentSKU *SKU `json:"currentSku,omitempty" azure:"ro"`

	// READ-ONLY; The current service level objective name of the database.
	CurrentServiceObjectiveName *string `json:"currentServiceObjectiveName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the database.
	DatabaseID *string `json:"databaseId,omitempty" azure:"ro"`

	// READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`

	// READ-ONLY; Failover Group resource identifier that this database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty" azure:"ro"`

	// READ-ONLY; Infra encryption is enabled for this database.
	IsInfraEncryptionEnabled *bool `json:"isInfraEncryptionEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The max log size for this database.
	MaxLogSizeBytes *int64 `json:"maxLogSizeBytes,omitempty" azure:"ro"`

	// READ-ONLY; The date when database was paused by user configuration or action(ISO8601 format). Null if the database is ready.
	PausedDate *time.Time `json:"pausedDate,omitempty" azure:"ro"`

	// READ-ONLY; The requested service level objective name of the database.
	RequestedServiceObjectiveName *string `json:"requestedServiceObjectiveName,omitempty" azure:"ro"`

	// READ-ONLY; The date when database was resumed by user action or database login (ISO8601 format). Null if the database is
	// paused.
	ResumedDate *time.Time `json:"resumedDate,omitempty" azure:"ro"`

	// READ-ONLY; The status of the database.
	Status *DatabaseStatus `json:"status,omitempty" azure:"ro"`
}

// DatabaseUsage - Usage metric of a database.
type DatabaseUsage struct {
	// Resource properties.
	Properties *DatabaseUsageProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseUsageListResult - A list of database usage metrics.
type DatabaseUsageListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseUsage `json:"value,omitempty" azure:"ro"`
}

// DatabaseUsageProperties - Properties of a database usage.
type DatabaseUsageProperties struct {
	// READ-ONLY; Current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; User-readable name of the metric.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Boundary value of the metric.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// DatabaseUsagesClientListByDatabaseOptions contains the optional parameters for the DatabaseUsagesClient.ListByDatabase
// method.
type DatabaseUsagesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseUserIdentity - Azure Active Directory identity configuration for a resource.
type DatabaseUserIdentity struct {
	// READ-ONLY; The Azure Active Directory client id.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// DatabaseVulnerabilityAssessment - A database vulnerability assessment.
type DatabaseVulnerabilityAssessment struct {
	// Resource properties.
	Properties *DatabaseVulnerabilityAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseVulnerabilityAssessmentListResult - A list of the database's vulnerability assessments.
type DatabaseVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DatabaseVulnerabilityAssessment `json:"value,omitempty" azure:"ro"`
}

// DatabaseVulnerabilityAssessmentProperties - Properties of a database Vulnerability Assessment.
type DatabaseVulnerabilityAssessmentProperties struct {
	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/). It is required
	// if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`

	// A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter.
	// If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
	// required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaseline - A database vulnerability assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaseline struct {
	// Resource properties.
	Properties *DatabaseVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineItem - Properties for an Azure SQL Database Vulnerability Assessment rule baseline's
// result.
type DatabaseVulnerabilityAssessmentRuleBaselineItem struct {
	// REQUIRED; The rule baseline result
	Result []*string `json:"result,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineProperties - Properties of a database Vulnerability Assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaselineProperties struct {
	// REQUIRED; The rule baseline result
	BaselineResults []*DatabaseVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate
// method.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete
// method.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentRuleBaselinesClient.Get
// method.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentScanExportProperties - Properties of the export operation's result.
type DatabaseVulnerabilityAssessmentScanExportProperties struct {
	// READ-ONLY; Location of the exported report (e.g. https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
	ExportedReportLocation *string `json:"exportedReportLocation,omitempty" azure:"ro"`
}

// DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan
// method.
type DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabaseVulnerabilityAssessmentScansClientExportOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.Export
// method.
type DatabaseVulnerabilityAssessmentScansClientExportOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.Get
// method.
type DatabaseVulnerabilityAssessmentScansClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentScansClient.ListByDatabase
// method.
type DatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentScansExport - A database Vulnerability Assessment scan export resource.
type DatabaseVulnerabilityAssessmentScansExport struct {
	// Resource properties.
	Properties *DatabaseVulnerabilityAssessmentScanExportProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatabaseVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
type DatabaseVulnerabilityAssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentsClient.Delete
// method.
type DatabaseVulnerabilityAssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentsClient.Get
// method.
type DatabaseVulnerabilityAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabaseVulnerabilityAssessmentsClientListByDatabaseOptions contains the optional parameters for the DatabaseVulnerabilityAssessmentsClient.ListByDatabase
// method.
type DatabaseVulnerabilityAssessmentsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientBeginCreateOrUpdateOptions contains the optional parameters for the DatabasesClient.BeginCreateOrUpdate
// method.
type DatabasesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginDeleteOptions contains the optional parameters for the DatabasesClient.BeginDelete method.
type DatabasesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginExportOptions contains the optional parameters for the DatabasesClient.BeginExport method.
type DatabasesClientBeginExportOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginFailoverOptions contains the optional parameters for the DatabasesClient.BeginFailover method.
type DatabasesClientBeginFailoverOptions struct {
	// The type of replica to be failed over.
	ReplicaType *ReplicaType
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginImportOptions contains the optional parameters for the DatabasesClient.BeginImport method.
type DatabasesClientBeginImportOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginPauseOptions contains the optional parameters for the DatabasesClient.BeginPause method.
type DatabasesClientBeginPauseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginResumeOptions contains the optional parameters for the DatabasesClient.BeginResume method.
type DatabasesClientBeginResumeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginUpdateOptions contains the optional parameters for the DatabasesClient.BeginUpdate method.
type DatabasesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientBeginUpgradeDataWarehouseOptions contains the optional parameters for the DatabasesClient.BeginUpgradeDataWarehouse
// method.
type DatabasesClientBeginUpgradeDataWarehouseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DatabasesClientGetOptions contains the optional parameters for the DatabasesClient.Get method.
type DatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListByElasticPoolOptions contains the optional parameters for the DatabasesClient.ListByElasticPool method.
type DatabasesClientListByElasticPoolOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListByServerOptions contains the optional parameters for the DatabasesClient.ListByServer method.
type DatabasesClientListByServerOptions struct {
	SkipToken *string
}

// DatabasesClientListInaccessibleByServerOptions contains the optional parameters for the DatabasesClient.ListInaccessibleByServer
// method.
type DatabasesClientListInaccessibleByServerOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListMetricDefinitionsOptions contains the optional parameters for the DatabasesClient.ListMetricDefinitions
// method.
type DatabasesClientListMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientListMetricsOptions contains the optional parameters for the DatabasesClient.ListMetrics method.
type DatabasesClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// DatabasesClientRenameOptions contains the optional parameters for the DatabasesClient.Rename method.
type DatabasesClientRenameOptions struct {
	// placeholder for future optional parameters
}

// DeletedServer - A deleted server.
type DeletedServer struct {
	// Resource properties.
	Properties *DeletedServerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedServerListResult - A list of deleted servers.
type DeletedServerListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DeletedServer `json:"value,omitempty" azure:"ro"`
}

// DeletedServerProperties - The properties of a deleted server.
type DeletedServerProperties struct {
	// READ-ONLY; The deletion time of the deleted server.
	DeletionTime *time.Time `json:"deletionTime,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty" azure:"ro"`

	// READ-ONLY; The original ID of the server before deletion.
	OriginalID *string `json:"originalId,omitempty" azure:"ro"`

	// READ-ONLY; The version of the deleted server.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// DeletedServersClientBeginRecoverOptions contains the optional parameters for the DeletedServersClient.BeginRecover method.
type DeletedServersClientBeginRecoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DeletedServersClientGetOptions contains the optional parameters for the DeletedServersClient.Get method.
type DeletedServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeletedServersClientListByLocationOptions contains the optional parameters for the DeletedServersClient.ListByLocation
// method.
type DeletedServersClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// DeletedServersClientListOptions contains the optional parameters for the DeletedServersClient.List method.
type DeletedServersClientListOptions struct {
	// placeholder for future optional parameters
}

// DistributedAvailabilityGroup - Distributed availability group between box and Sql Managed Instance.
type DistributedAvailabilityGroup struct {
	// Resource properties.
	Properties *DistributedAvailabilityGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DistributedAvailabilityGroupProperties - The properties of a distributed availability group.
type DistributedAvailabilityGroupProperties struct {
	// The primary availability group name
	PrimaryAvailabilityGroupName *string `json:"primaryAvailabilityGroupName,omitempty"`

	// The replication mode of a distributed availability group. Parameter will be ignored during link creation.
	ReplicationMode *ReplicationMode `json:"replicationMode,omitempty"`

	// The secondary availability group name
	SecondaryAvailabilityGroupName *string `json:"secondaryAvailabilityGroupName,omitempty"`

	// The source endpoint
	SourceEndpoint *string `json:"sourceEndpoint,omitempty"`

	// The name of the target database
	TargetDatabase *string `json:"targetDatabase,omitempty"`

	// READ-ONLY; The distributed availability group id
	DistributedAvailabilityGroupID *string `json:"distributedAvailabilityGroupId,omitempty" azure:"ro"`

	// READ-ONLY; The last hardened lsn
	LastHardenedLsn *string `json:"lastHardenedLsn,omitempty" azure:"ro"`

	// READ-ONLY; The link state
	LinkState *string `json:"linkState,omitempty" azure:"ro"`

	// READ-ONLY; The source replica id
	SourceReplicaID *string `json:"sourceReplicaId,omitempty" azure:"ro"`

	// READ-ONLY; The target replica id
	TargetReplicaID *string `json:"targetReplicaId,omitempty" azure:"ro"`
}

// DistributedAvailabilityGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the DistributedAvailabilityGroupsClient.BeginCreateOrUpdate
// method.
type DistributedAvailabilityGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DistributedAvailabilityGroupsClientBeginDeleteOptions contains the optional parameters for the DistributedAvailabilityGroupsClient.BeginDelete
// method.
type DistributedAvailabilityGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DistributedAvailabilityGroupsClientBeginUpdateOptions contains the optional parameters for the DistributedAvailabilityGroupsClient.BeginUpdate
// method.
type DistributedAvailabilityGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DistributedAvailabilityGroupsClientGetOptions contains the optional parameters for the DistributedAvailabilityGroupsClient.Get
// method.
type DistributedAvailabilityGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DistributedAvailabilityGroupsClientListByInstanceOptions contains the optional parameters for the DistributedAvailabilityGroupsClient.ListByInstance
// method.
type DistributedAvailabilityGroupsClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// DistributedAvailabilityGroupsListResult - A list of distributed availability groups in instance.
type DistributedAvailabilityGroupsListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*DistributedAvailabilityGroup `json:"value,omitempty" azure:"ro"`
}

// EditionCapability - The edition capability.
type EditionCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The database edition name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The read scale capability for the edition.
	ReadScale *ReadScaleCapability `json:"readScale,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives []*ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported storage capabilities for this edition
	SupportedStorageCapabilities []*StorageCapability `json:"supportedStorageCapabilities,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty" azure:"ro"`
}

// ElasticPool - An elastic pool.
type ElasticPool struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *ElasticPoolProperties `json:"properties,omitempty"`

	// The elastic pool SKU.
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family,
	// and capacity) that are available to your subscription in an Azure region,
	// use the Capabilities_ListByLocation REST API or the following command:
	// az sql elastic-pool list-editions -l <location> -o table
	// `
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of elastic pool. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ElasticPoolActivitiesClientListByElasticPoolOptions contains the optional parameters for the ElasticPoolActivitiesClient.ListByElasticPool
// method.
type ElasticPoolActivitiesClientListByElasticPoolOptions struct {
	// placeholder for future optional parameters
}

// ElasticPoolActivity - Represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties representing the resource.
	Properties *ElasticPoolActivityProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ElasticPoolActivityListResult - Represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	// REQUIRED; The list of elastic pool activities.
	Value []*ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties - Represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	// READ-ONLY; The name of the elastic pool.
	ElasticPoolName *string `json:"elasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The unique operation ID.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`

	// READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The requested per database DTU cap.
	RequestedDatabaseDtuCap *int32 `json:"requestedDatabaseDtuCap,omitempty" azure:"ro"`

	// READ-ONLY; The requested per database DTU guarantee.
	RequestedDatabaseDtuGuarantee *int32 `json:"requestedDatabaseDtuGuarantee,omitempty" azure:"ro"`

	// READ-ONLY; The requested max DTU per database if available.
	RequestedDatabaseDtuMax *int32 `json:"requestedDatabaseDtuMax,omitempty" azure:"ro"`

	// READ-ONLY; The requested min DTU per database if available.
	RequestedDatabaseDtuMin *int32 `json:"requestedDatabaseDtuMin,omitempty" azure:"ro"`

	// READ-ONLY; The requested DTU for the pool if available.
	RequestedDtu *int32 `json:"requestedDtu,omitempty" azure:"ro"`

	// READ-ONLY; The requested DTU guarantee.
	RequestedDtuGuarantee *int32 `json:"requestedDtuGuarantee,omitempty" azure:"ro"`

	// READ-ONLY; The requested name for the elastic pool if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The requested storage limit for the pool in GB if available.
	RequestedStorageLimitInGB *int64 `json:"requestedStorageLimitInGB,omitempty" azure:"ro"`

	// READ-ONLY; The requested storage limit in MB.
	RequestedStorageLimitInMB *int32 `json:"requestedStorageLimitInMB,omitempty" azure:"ro"`

	// READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ElasticPoolDatabaseActivitiesClientListByElasticPoolOptions contains the optional parameters for the ElasticPoolDatabaseActivitiesClient.ListByElasticPool
// method.
type ElasticPoolDatabaseActivitiesClientListByElasticPoolOptions struct {
	// placeholder for future optional parameters
}

// ElasticPoolDatabaseActivity - Represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties representing the resource.
	Properties *ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ElasticPoolDatabaseActivityListResult - Represents the response to a list elastic pool database activity request.
type ElasticPoolDatabaseActivityListResult struct {
	// REQUIRED; The list of elastic pool database activities.
	Value []*ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties - Represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	// READ-ONLY; The name of the current elastic pool the database is in if available.
	CurrentElasticPoolName *string `json:"currentElasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the current service objective if available.
	CurrentServiceObjective *string `json:"currentServiceObjective,omitempty" azure:"ro"`

	// READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The unique operation ID.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`

	// READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The name for the elastic pool the database is moving into if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the requested service objective if available.
	RequestedServiceObjective *string `json:"requestedServiceObjective,omitempty" azure:"ro"`

	// READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ElasticPoolEditionCapability - The elastic pool edition capability.
type ElasticPoolEditionCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The elastic pool edition name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolPerformanceLevels []*ElasticPoolPerformanceLevelCapability `json:"supportedElasticPoolPerformanceLevels,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty" azure:"ro"`
}

// ElasticPoolListResult - The result of an elastic pool list request.
type ElasticPoolListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ElasticPool `json:"value,omitempty" azure:"ro"`
}

// ElasticPoolOperation - A elastic pool operation.
type ElasticPoolOperation struct {
	// Resource properties.
	Properties *ElasticPoolOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ElasticPoolOperationListResult - The response to a list elastic pool operations request
type ElasticPoolOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ElasticPoolOperation `json:"value,omitempty" azure:"ro"`
}

// ElasticPoolOperationProperties - The properties of a elastic pool operation.
type ElasticPoolOperationProperties struct {
	// READ-ONLY; The operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The name of the elastic pool the operation is being performed on.
	ElasticPoolName *string `json:"elasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty" azure:"ro"`

	// READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *time.Time `json:"estimatedCompletionTime,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty" azure:"ro"`

	// READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The operation start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation state.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ElasticPoolOperationsClientCancelOptions contains the optional parameters for the ElasticPoolOperationsClient.Cancel method.
type ElasticPoolOperationsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// ElasticPoolOperationsClientListByElasticPoolOptions contains the optional parameters for the ElasticPoolOperationsClient.ListByElasticPool
// method.
type ElasticPoolOperationsClientListByElasticPoolOptions struct {
	// placeholder for future optional parameters
}

// ElasticPoolPerDatabaseMaxPerformanceLevelCapability - The max per-database performance level capability.
type ElasticPoolPerDatabaseMaxPerformanceLevelCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The maximum performance level per database.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported min database performance levels.
	SupportedPerDatabaseMinPerformanceLevels []*ElasticPoolPerDatabaseMinPerformanceLevelCapability `json:"supportedPerDatabaseMinPerformanceLevels,omitempty" azure:"ro"`

	// READ-ONLY; Unit type used to measure performance level.
	Unit *PerformanceLevelUnit `json:"unit,omitempty" azure:"ro"`
}

// ElasticPoolPerDatabaseMinPerformanceLevelCapability - The minimum per-database performance level capability.
type ElasticPoolPerDatabaseMinPerformanceLevelCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The minimum performance level per database.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Unit type used to measure performance level.
	Unit *PerformanceLevelUnit `json:"unit,omitempty" azure:"ro"`
}

// ElasticPoolPerDatabaseSettings - Per database settings of an elastic pool.
type ElasticPoolPerDatabaseSettings struct {
	// The maximum capacity any one database can consume.
	MaxCapacity *float64 `json:"maxCapacity,omitempty"`

	// The minimum capacity all databases are guaranteed.
	MinCapacity *float64 `json:"minCapacity,omitempty"`
}

// ElasticPoolPerformanceLevelCapability - The Elastic Pool performance level capability.
type ElasticPoolPerformanceLevelCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The included (free) max size for this performance level.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty" azure:"ro"`

	// READ-ONLY; The maximum number of databases supported.
	MaxDatabaseCount *int32 `json:"maxDatabaseCount,omitempty" azure:"ro"`

	// READ-ONLY; The performance level for the pool.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty" azure:"ro"`

	// READ-ONLY; The sku.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; List of supported license types.
	SupportedLicenseTypes []*LicenseTypeCapability `json:"supportedLicenseTypes,omitempty" azure:"ro"`

	// READ-ONLY; List of supported maintenance configurations
	SupportedMaintenanceConfigurations []*MaintenanceConfigurationCapability `json:"supportedMaintenanceConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported max sizes.
	SupportedMaxSizes []*MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported per database max performance levels.
	SupportedPerDatabaseMaxPerformanceLevels []*ElasticPoolPerDatabaseMaxPerformanceLevelCapability `json:"supportedPerDatabaseMaxPerformanceLevels,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported per database max sizes.
	SupportedPerDatabaseMaxSizes []*MaxSizeRangeCapability `json:"supportedPerDatabaseMaxSizes,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not zone redundancy is supported for the performance level.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty" azure:"ro"`
}

// ElasticPoolProperties - Properties of an elastic pool
type ElasticPoolProperties struct {
	// The number of secondary replicas associated with the elastic pool that are used to provide high availability.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`

	// The license type to apply for this elastic pool.
	LicenseType *ElasticPoolLicenseType `json:"licenseType,omitempty"`

	// Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates
	// will will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`

	// The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`

	// The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`

	// Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across
	// multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The creation date of the elastic pool (ISO8601 format).
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The state of the elastic pool.
	State *ElasticPoolState `json:"state,omitempty" azure:"ro"`
}

// ElasticPoolUpdate - An elastic pool update.
type ElasticPoolUpdate struct {
	// Resource properties.
	Properties *ElasticPoolUpdateProperties `json:"properties,omitempty"`

	// An ARM Resource SKU.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ElasticPoolUpdateProperties - Properties of an elastic pool
type ElasticPoolUpdateProperties struct {
	// The number of secondary replicas associated with the elastic pool that are used to provide high availability. Applicable
	// only to Hyperscale elastic pools.
	HighAvailabilityReplicaCount *int32 `json:"highAvailabilityReplicaCount,omitempty"`

	// The license type to apply for this elastic pool.
	LicenseType *ElasticPoolLicenseType `json:"licenseType,omitempty"`

	// Maintenance configuration id assigned to the elastic pool. This configuration defines the period when the maintenance updates
	// will will occur.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`

	// The storage limit for the database elastic pool in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty"`

	// The per database settings for the elastic pool.
	PerDatabaseSettings *ElasticPoolPerDatabaseSettings `json:"perDatabaseSettings,omitempty"`

	// Whether or not this elastic pool is zone redundant, which means the replicas of this elastic pool will be spread across
	// multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// ElasticPoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the ElasticPoolsClient.BeginCreateOrUpdate
// method.
type ElasticPoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticPoolsClientBeginDeleteOptions contains the optional parameters for the ElasticPoolsClient.BeginDelete method.
type ElasticPoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticPoolsClientBeginFailoverOptions contains the optional parameters for the ElasticPoolsClient.BeginFailover method.
type ElasticPoolsClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticPoolsClientBeginUpdateOptions contains the optional parameters for the ElasticPoolsClient.BeginUpdate method.
type ElasticPoolsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ElasticPoolsClientGetOptions contains the optional parameters for the ElasticPoolsClient.Get method.
type ElasticPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ElasticPoolsClientListByServerOptions contains the optional parameters for the ElasticPoolsClient.ListByServer method.
type ElasticPoolsClientListByServerOptions struct {
	// The number of elements in the collection to skip.
	Skip *int64
}

// ElasticPoolsClientListMetricDefinitionsOptions contains the optional parameters for the ElasticPoolsClient.ListMetricDefinitions
// method.
type ElasticPoolsClientListMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// ElasticPoolsClientListMetricsOptions contains the optional parameters for the ElasticPoolsClient.ListMetrics method.
type ElasticPoolsClientListMetricsOptions struct {
	// placeholder for future optional parameters
}

// EncryptionProtector - The server encryption protector.
type EncryptionProtector struct {
	// Resource properties.
	Properties *EncryptionProtectorProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EncryptionProtectorListResult - A list of server encryption protectors.
type EncryptionProtectorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*EncryptionProtector `json:"value,omitempty" azure:"ro"`
}

// EncryptionProtectorProperties - Properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// REQUIRED; The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
	ServerKeyType *ServerKeyType `json:"serverKeyType,omitempty"`

	// Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty"`

	// The name of the server key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`

	// READ-ONLY; Subregion of the encryption protector.
	Subregion *string `json:"subregion,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty" azure:"ro"`
}

// EncryptionProtectorsClientBeginCreateOrUpdateOptions contains the optional parameters for the EncryptionProtectorsClient.BeginCreateOrUpdate
// method.
type EncryptionProtectorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EncryptionProtectorsClientBeginRevalidateOptions contains the optional parameters for the EncryptionProtectorsClient.BeginRevalidate
// method.
type EncryptionProtectorsClientBeginRevalidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EncryptionProtectorsClientGetOptions contains the optional parameters for the EncryptionProtectorsClient.Get method.
type EncryptionProtectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EncryptionProtectorsClientListByServerOptions contains the optional parameters for the EncryptionProtectorsClient.ListByServer
// method.
type EncryptionProtectorsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// EndpointCertificate - Certificate used on an endpoint on the Managed Instance.
type EndpointCertificate struct {
	// Resource properties.
	Properties *EndpointCertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EndpointCertificateListResult - A list of endpoint certificates on the target instance.
type EndpointCertificateListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*EndpointCertificate `json:"value,omitempty" azure:"ro"`
}

// EndpointCertificateProperties - The properties of an endpoint certificate.
type EndpointCertificateProperties struct {
	// The certificate public blob
	PublicBlob *string `json:"publicBlob,omitempty"`
}

// EndpointCertificatesClientGetOptions contains the optional parameters for the EndpointCertificatesClient.Get method.
type EndpointCertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EndpointCertificatesClientListByInstanceOptions contains the optional parameters for the EndpointCertificatesClient.ListByInstance
// method.
type EndpointCertificatesClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ExportDatabaseDefinition - Contains the information necessary to perform export database operation.
type ExportDatabaseDefinition struct {
	// REQUIRED; Administrator login name.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// REQUIRED; Administrator login password.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// REQUIRED; Storage key.
	StorageKey *string `json:"storageKey,omitempty"`

	// REQUIRED; Storage key type.
	StorageKeyType *StorageKeyType `json:"storageKeyType,omitempty"`

	// REQUIRED; Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`

	// Authentication type.
	AuthenticationType *string `json:"authenticationType,omitempty"`

	// Optional resource information to enable network isolation for request.
	NetworkIsolation *NetworkIsolationSettings `json:"networkIsolation,omitempty"`
}

// ExtendedDatabaseBlobAuditingPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ExtendedDatabaseBlobAuditingPoliciesClient.CreateOrUpdate
// method.
type ExtendedDatabaseBlobAuditingPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ExtendedDatabaseBlobAuditingPoliciesClientGetOptions contains the optional parameters for the ExtendedDatabaseBlobAuditingPoliciesClient.Get
// method.
type ExtendedDatabaseBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExtendedDatabaseBlobAuditingPoliciesClientListByDatabaseOptions contains the optional parameters for the ExtendedDatabaseBlobAuditingPoliciesClient.ListByDatabase
// method.
type ExtendedDatabaseBlobAuditingPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ExtendedDatabaseBlobAuditingPolicy - An extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ExtendedDatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtendedDatabaseBlobAuditingPolicyListResult - A list of database extended auditing settings.
type ExtendedDatabaseBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ExtendedDatabaseBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// ExtendedDatabaseBlobAuditingPolicyProperties - Properties of an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETEDGROUP DBCCGROUP DATABASE
	// OWNERSHIPCHANGEGROUP DATABASECHANGEGROUP LEDGEROPERATION_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'State'
	// as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// ExtendedServerBlobAuditingPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ExtendedServerBlobAuditingPoliciesClient.BeginCreateOrUpdate
// method.
type ExtendedServerBlobAuditingPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ExtendedServerBlobAuditingPoliciesClientGetOptions contains the optional parameters for the ExtendedServerBlobAuditingPoliciesClient.Get
// method.
type ExtendedServerBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ExtendedServerBlobAuditingPoliciesClientListByServerOptions contains the optional parameters for the ExtendedServerBlobAuditingPoliciesClient.ListByServer
// method.
type ExtendedServerBlobAuditingPoliciesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ExtendedServerBlobAuditingPolicy - An extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ExtendedServerBlobAuditingPolicyListResult - A list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ExtendedServerBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// ExtendedServerBlobAuditingPolicyProperties - Properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETEDGROUP DBCCGROUP DATABASE
	// OWNERSHIPCHANGEGROUP DATABASECHANGEGROUP LEDGEROPERATION_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'State'
	// as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor. In order to send the
	// events to Azure Monitor, specify 'State' as 'Enabled',
	// 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on
	// the master database should also be created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsDevopsAuditEnabled *bool `json:"isDevopsAuditEnabled,omitempty"`

	// Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// FailoverGroup - A failover group.
type FailoverGroup struct {
	// Resource properties.
	Properties *FailoverGroupProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FailoverGroupListResult - A list of failover groups.
type FailoverGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*FailoverGroup `json:"value,omitempty" azure:"ro"`
}

// FailoverGroupProperties - Properties of a failover group.
type FailoverGroupProperties struct {
	// REQUIRED; List of partner server information for the failover group.
	PartnerServers []*PartnerInfo `json:"partnerServers,omitempty"`

	// REQUIRED; Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`

	// List of databases in the failover group.
	Databases []*string `json:"databases,omitempty"`

	// Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`

	// READ-ONLY; Local replication role of the failover group instance.
	ReplicationRole *FailoverGroupReplicationRole `json:"replicationRole,omitempty" azure:"ro"`

	// READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty" azure:"ro"`
}

// FailoverGroupReadOnlyEndpoint - Read-only endpoint of the failover group instance.
type FailoverGroupReadOnlyEndpoint struct {
	// Failover policy of the read-only endpoint for the failover group.
	FailoverPolicy *ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// FailoverGroupReadWriteEndpoint - Read-write endpoint of the failover group instance.
type FailoverGroupReadWriteEndpoint struct {
	// REQUIRED; Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes
	// is required.
	FailoverPolicy *ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`

	// Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then
	// failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// FailoverGroupUpdate - A failover group update request.
type FailoverGroupUpdate struct {
	// Resource properties.
	Properties *FailoverGroupUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// FailoverGroupUpdateProperties - Properties of a failover group update.
type FailoverGroupUpdateProperties struct {
	// List of databases in the failover group.
	Databases []*string `json:"databases,omitempty"`

	// Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`

	// Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
}

// FailoverGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the FailoverGroupsClient.BeginCreateOrUpdate
// method.
type FailoverGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FailoverGroupsClientBeginDeleteOptions contains the optional parameters for the FailoverGroupsClient.BeginDelete method.
type FailoverGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FailoverGroupsClientBeginFailoverOptions contains the optional parameters for the FailoverGroupsClient.BeginFailover method.
type FailoverGroupsClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FailoverGroupsClientBeginForceFailoverAllowDataLossOptions contains the optional parameters for the FailoverGroupsClient.BeginForceFailoverAllowDataLoss
// method.
type FailoverGroupsClientBeginForceFailoverAllowDataLossOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FailoverGroupsClientBeginUpdateOptions contains the optional parameters for the FailoverGroupsClient.BeginUpdate method.
type FailoverGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// FailoverGroupsClientGetOptions contains the optional parameters for the FailoverGroupsClient.Get method.
type FailoverGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FailoverGroupsClientListByServerOptions contains the optional parameters for the FailoverGroupsClient.ListByServer method.
type FailoverGroupsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// FirewallRule - A server firewall rule.
type FirewallRule struct {
	// Resource name.
	Name *string `json:"name,omitempty"`

	// Resource properties.
	Properties *ServerFirewallRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FirewallRuleList - A list of server firewall rules.
type FirewallRuleList struct {
	Values []*FirewallRule `json:"values,omitempty"`
}

// FirewallRuleListResult - The response to a list firewall rules request
type FirewallRuleListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*FirewallRule `json:"value,omitempty" azure:"ro"`
}

// FirewallRulesClientCreateOrUpdateOptions contains the optional parameters for the FirewallRulesClient.CreateOrUpdate method.
type FirewallRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientDeleteOptions contains the optional parameters for the FirewallRulesClient.Delete method.
type FirewallRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientGetOptions contains the optional parameters for the FirewallRulesClient.Get method.
type FirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientListByServerOptions contains the optional parameters for the FirewallRulesClient.ListByServer method.
type FirewallRulesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// FirewallRulesClientReplaceOptions contains the optional parameters for the FirewallRulesClient.Replace method.
type FirewallRulesClientReplaceOptions struct {
	// placeholder for future optional parameters
}

// GeoBackupPoliciesClientCreateOrUpdateOptions contains the optional parameters for the GeoBackupPoliciesClient.CreateOrUpdate
// method.
type GeoBackupPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// GeoBackupPoliciesClientGetOptions contains the optional parameters for the GeoBackupPoliciesClient.Get method.
type GeoBackupPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// GeoBackupPoliciesClientListByDatabaseOptions contains the optional parameters for the GeoBackupPoliciesClient.ListByDatabase
// method.
type GeoBackupPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// GeoBackupPolicy - A database geo backup policy.
type GeoBackupPolicy struct {
	// REQUIRED; The properties of the geo backup policy.
	Properties *GeoBackupPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of geo backup policy. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GeoBackupPolicyListResult - The response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	// The list of geo backup policies.
	Value []*GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties - The properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// REQUIRED; The state of the geo backup policy.
	State *GeoBackupPolicyState `json:"state,omitempty"`

	// READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty" azure:"ro"`
}

// IPv6FirewallRule - An IPv6 server firewall rule.
type IPv6FirewallRule struct {
	// Resource name.
	Name *string `json:"name,omitempty"`

	// Resource properties.
	Properties *IPv6ServerFirewallRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPv6FirewallRuleListResult - The response to a list IPv6 firewall rules request
type IPv6FirewallRuleListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*IPv6FirewallRule `json:"value,omitempty" azure:"ro"`
}

// IPv6FirewallRulesClientCreateOrUpdateOptions contains the optional parameters for the IPv6FirewallRulesClient.CreateOrUpdate
// method.
type IPv6FirewallRulesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// IPv6FirewallRulesClientDeleteOptions contains the optional parameters for the IPv6FirewallRulesClient.Delete method.
type IPv6FirewallRulesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IPv6FirewallRulesClientGetOptions contains the optional parameters for the IPv6FirewallRulesClient.Get method.
type IPv6FirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// IPv6FirewallRulesClientListByServerOptions contains the optional parameters for the IPv6FirewallRulesClient.ListByServer
// method.
type IPv6FirewallRulesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// IPv6ServerFirewallRuleProperties - The properties of an IPv6 server firewall rule.
type IPv6ServerFirewallRuleProperties struct {
	// The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
	EndIPv6Address *string `json:"endIPv6Address,omitempty"`

	// The start IP address of the firewall rule. Must be IPv6 format.
	StartIPv6Address *string `json:"startIPv6Address,omitempty"`
}

// ImportExistingDatabaseDefinition - Contains the information necessary to perform import operation for existing database.
type ImportExistingDatabaseDefinition struct {
	// REQUIRED; Administrator login name.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// REQUIRED; Administrator login password.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// REQUIRED; Storage key.
	StorageKey *string `json:"storageKey,omitempty"`

	// REQUIRED; Storage key type.
	StorageKeyType *StorageKeyType `json:"storageKeyType,omitempty"`

	// REQUIRED; Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`

	// Authentication type.
	AuthenticationType *string `json:"authenticationType,omitempty"`

	// Optional resource information to enable network isolation for request.
	NetworkIsolation *NetworkIsolationSettings `json:"networkIsolation,omitempty"`
}

// ImportExportExtensionsOperationListResult - Import export operation extensions list.
type ImportExportExtensionsOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ImportExportExtensionsOperationResult `json:"value,omitempty" azure:"ro"`
}

// ImportExportExtensionsOperationResult - An Extension operation result resource.
type ImportExportExtensionsOperationResult struct {
	// Resource properties.
	Properties *ImportExportExtensionsOperationResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImportExportExtensionsOperationResultProperties - Contains the operation result properties for import/export operation.
type ImportExportExtensionsOperationResultProperties struct {
	// READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Request Id.
	RequestID *string `json:"requestId,omitempty" azure:"ro"`

	// READ-ONLY; Request type.
	RequestType *string `json:"requestType,omitempty" azure:"ro"`

	// READ-ONLY; Server name.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; Operation status.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ImportExportOperationResult - An ImportExport operation result resource.
type ImportExportOperationResult struct {
	// Resource properties.
	Properties *ImportExportOperationResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ImportExportOperationResultProperties - Contains the operation result properties for import/export operation.
type ImportExportOperationResultProperties struct {
	// READ-ONLY; Blob Uri.
	BlobURI *string `json:"blobUri,omitempty" azure:"ro"`

	// READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Error message.
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status of private endpoints associated with this request.
	PrivateEndpointConnections []*PrivateEndpointConnectionRequestStatus `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Queued time.
	QueuedTime *string `json:"queuedTime,omitempty" azure:"ro"`

	// READ-ONLY; Request Id.
	RequestID *string `json:"requestId,omitempty" azure:"ro"`

	// READ-ONLY; Request type.
	RequestType *string `json:"requestType,omitempty" azure:"ro"`

	// READ-ONLY; Server name.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; Operation status.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ImportNewDatabaseDefinition - Contains the information necessary to perform import operation for new database.
type ImportNewDatabaseDefinition struct {
	// REQUIRED; Administrator login name.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// REQUIRED; Administrator login password.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// REQUIRED; Storage key.
	StorageKey *string `json:"storageKey,omitempty"`

	// REQUIRED; Storage key type.
	StorageKeyType *StorageKeyType `json:"storageKeyType,omitempty"`

	// REQUIRED; Storage Uri.
	StorageURI *string `json:"storageUri,omitempty"`

	// Authentication type.
	AuthenticationType *string `json:"authenticationType,omitempty"`

	// Name of the import database.
	DatabaseName *string `json:"databaseName,omitempty"`

	// Edition of the import database.
	Edition *string `json:"edition,omitempty"`

	// Max size in bytes for the import database.
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`

	// Optional resource information to enable network isolation for request.
	NetworkIsolation *NetworkIsolationSettings `json:"networkIsolation,omitempty"`

	// Service level objective name of the import database.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
}

// InstanceFailoverGroup - An instance failover group.
type InstanceFailoverGroup struct {
	// Resource properties.
	Properties *InstanceFailoverGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InstanceFailoverGroupListResult - A list of instance failover groups.
type InstanceFailoverGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*InstanceFailoverGroup `json:"value,omitempty" azure:"ro"`
}

// InstanceFailoverGroupProperties - Properties of a instance failover group.
type InstanceFailoverGroupProperties struct {
	// REQUIRED; List of managed instance pairs in the failover group.
	ManagedInstancePairs []*ManagedInstancePairInfo `json:"managedInstancePairs,omitempty"`

	// REQUIRED; Partner region information for the failover group.
	PartnerRegions []*PartnerRegionInfo `json:"partnerRegions,omitempty"`

	// REQUIRED; Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *InstanceFailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`

	// Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *InstanceFailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`

	// READ-ONLY; Local replication role of the failover group instance.
	ReplicationRole *InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty" azure:"ro"`

	// READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty" azure:"ro"`
}

// InstanceFailoverGroupReadOnlyEndpoint - Read-only endpoint of the failover group instance.
type InstanceFailoverGroupReadOnlyEndpoint struct {
	// Failover policy of the read-only endpoint for the failover group.
	FailoverPolicy *ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// InstanceFailoverGroupReadWriteEndpoint - Read-write endpoint of the failover group instance.
type InstanceFailoverGroupReadWriteEndpoint struct {
	// REQUIRED; Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes
	// is required.
	FailoverPolicy *ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`

	// Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then
	// failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// InstanceFailoverGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the InstanceFailoverGroupsClient.BeginCreateOrUpdate
// method.
type InstanceFailoverGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstanceFailoverGroupsClientBeginDeleteOptions contains the optional parameters for the InstanceFailoverGroupsClient.BeginDelete
// method.
type InstanceFailoverGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstanceFailoverGroupsClientBeginFailoverOptions contains the optional parameters for the InstanceFailoverGroupsClient.BeginFailover
// method.
type InstanceFailoverGroupsClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstanceFailoverGroupsClientBeginForceFailoverAllowDataLossOptions contains the optional parameters for the InstanceFailoverGroupsClient.BeginForceFailoverAllowDataLoss
// method.
type InstanceFailoverGroupsClientBeginForceFailoverAllowDataLossOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstanceFailoverGroupsClientGetOptions contains the optional parameters for the InstanceFailoverGroupsClient.Get method.
type InstanceFailoverGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InstanceFailoverGroupsClientListByLocationOptions contains the optional parameters for the InstanceFailoverGroupsClient.ListByLocation
// method.
type InstanceFailoverGroupsClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// InstancePool - An Azure SQL instance pool.
type InstancePool struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *InstancePoolProperties `json:"properties,omitempty"`

	// The name and tier of the SKU.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InstancePoolEditionCapability - The instance pool capability
type InstancePoolEditionCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The instance pool version name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The supported families.
	SupportedFamilies []*InstancePoolFamilyCapability `json:"supportedFamilies,omitempty" azure:"ro"`
}

// InstancePoolFamilyCapability - The instance pool family capability.
type InstancePoolFamilyCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; Family name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; List of supported license types.
	SupportedLicenseTypes []*LicenseTypeCapability `json:"supportedLicenseTypes,omitempty" azure:"ro"`

	// READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues []*InstancePoolVcoresCapability `json:"supportedVcoresValues,omitempty" azure:"ro"`
}

// InstancePoolListResult - A list of Azure SQL instance pools.
type InstancePoolListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*InstancePool `json:"value,omitempty" azure:"ro"`
}

// InstancePoolProperties - Properties of an instance pool.
type InstancePoolProperties struct {
	// REQUIRED; The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without
	// SQL license price).
	LicenseType *InstancePoolLicenseType `json:"licenseType,omitempty"`

	// REQUIRED; Resource ID of the subnet to place this instance pool in.
	SubnetID *string `json:"subnetId,omitempty"`

	// REQUIRED; Count of vCores belonging to this instance pool.
	VCores *int32 `json:"vCores,omitempty"`
}

// InstancePoolUpdate - An update to an Instance pool.
type InstancePoolUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// InstancePoolVcoresCapability - The managed instance virtual cores capability.
type InstancePoolVcoresCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Storage limit.
	StorageLimit *MaxSizeCapability `json:"storageLimit,omitempty" azure:"ro"`

	// READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty" azure:"ro"`
}

// InstancePoolsClientBeginCreateOrUpdateOptions contains the optional parameters for the InstancePoolsClient.BeginCreateOrUpdate
// method.
type InstancePoolsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstancePoolsClientBeginDeleteOptions contains the optional parameters for the InstancePoolsClient.BeginDelete method.
type InstancePoolsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstancePoolsClientBeginUpdateOptions contains the optional parameters for the InstancePoolsClient.BeginUpdate method.
type InstancePoolsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InstancePoolsClientGetOptions contains the optional parameters for the InstancePoolsClient.Get method.
type InstancePoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InstancePoolsClientListByResourceGroupOptions contains the optional parameters for the InstancePoolsClient.ListByResourceGroup
// method.
type InstancePoolsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// InstancePoolsClientListOptions contains the optional parameters for the InstancePoolsClient.List method.
type InstancePoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// Job - A job.
type Job struct {
	// Resource properties.
	Properties *JobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobAgent - An Azure SQL job agent.
type JobAgent struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *JobAgentProperties `json:"properties,omitempty"`

	// The name and tier of the SKU.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobAgentListResult - A list of Azure SQL job agents.
type JobAgentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*JobAgent `json:"value,omitempty" azure:"ro"`
}

// JobAgentProperties - Properties of a job agent.
type JobAgentProperties struct {
	// REQUIRED; Resource ID of the database to store job metadata in.
	DatabaseID *string `json:"databaseId,omitempty"`

	// READ-ONLY; The state of the job agent.
	State *JobAgentState `json:"state,omitempty" azure:"ro"`
}

// JobAgentUpdate - An update to an Azure SQL job agent.
type JobAgentUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// JobAgentsClientBeginCreateOrUpdateOptions contains the optional parameters for the JobAgentsClient.BeginCreateOrUpdate
// method.
type JobAgentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobAgentsClientBeginDeleteOptions contains the optional parameters for the JobAgentsClient.BeginDelete method.
type JobAgentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobAgentsClientBeginUpdateOptions contains the optional parameters for the JobAgentsClient.BeginUpdate method.
type JobAgentsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobAgentsClientGetOptions contains the optional parameters for the JobAgentsClient.Get method.
type JobAgentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobAgentsClientListByServerOptions contains the optional parameters for the JobAgentsClient.ListByServer method.
type JobAgentsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// JobCredential - A stored credential that can be used by a job to connect to target databases.
type JobCredential struct {
	// Resource properties.
	Properties *JobCredentialProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobCredentialListResult - A list of job credentials.
type JobCredentialListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*JobCredential `json:"value,omitempty" azure:"ro"`
}

// JobCredentialProperties - Properties of a job credential.
type JobCredentialProperties struct {
	// REQUIRED; The credential password.
	Password *string `json:"password,omitempty"`

	// REQUIRED; The credential user name.
	Username *string `json:"username,omitempty"`
}

// JobCredentialsClientCreateOrUpdateOptions contains the optional parameters for the JobCredentialsClient.CreateOrUpdate
// method.
type JobCredentialsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JobCredentialsClientDeleteOptions contains the optional parameters for the JobCredentialsClient.Delete method.
type JobCredentialsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobCredentialsClientGetOptions contains the optional parameters for the JobCredentialsClient.Get method.
type JobCredentialsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobCredentialsClientListByAgentOptions contains the optional parameters for the JobCredentialsClient.ListByAgent method.
type JobCredentialsClientListByAgentOptions struct {
	// placeholder for future optional parameters
}

// JobExecution - An execution of a job
type JobExecution struct {
	// Resource properties.
	Properties *JobExecutionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobExecutionListResult - A list of job executions.
type JobExecutionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*JobExecution `json:"value,omitempty" azure:"ro"`
}

// JobExecutionProperties - Properties for an Azure SQL Database Elastic job execution.
type JobExecutionProperties struct {
	// Number of times the job execution has been attempted.
	CurrentAttempts *int32 `json:"currentAttempts,omitempty"`

	// READ-ONLY; The time that the job execution was created.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; Start time of the current attempt.
	CurrentAttemptStartTime *time.Time `json:"currentAttemptStartTime,omitempty" azure:"ro"`

	// READ-ONLY; The time that the job execution completed.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The unique identifier of the job execution.
	JobExecutionID *string `json:"jobExecutionId,omitempty" azure:"ro"`

	// READ-ONLY; The job version number.
	JobVersion *int32 `json:"jobVersion,omitempty" azure:"ro"`

	// READ-ONLY; The last status or error message.
	LastMessage *string `json:"lastMessage,omitempty" azure:"ro"`

	// READ-ONLY; The detailed state of the job execution.
	Lifecycle *JobExecutionLifecycle `json:"lifecycle,omitempty" azure:"ro"`

	// READ-ONLY; The ARM provisioning state of the job execution.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The time that the job execution started.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The job step id.
	StepID *int32 `json:"stepId,omitempty" azure:"ro"`

	// READ-ONLY; The job step name.
	StepName *string `json:"stepName,omitempty" azure:"ro"`

	// READ-ONLY; The target that this execution is executed on.
	Target *JobExecutionTarget `json:"target,omitempty" azure:"ro"`
}

// JobExecutionTarget - The target that a job execution is executed on.
type JobExecutionTarget struct {
	// READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The server name.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The type of the target.
	Type *JobTargetType `json:"type,omitempty" azure:"ro"`
}

// JobExecutionsClientBeginCreateOptions contains the optional parameters for the JobExecutionsClient.BeginCreate method.
type JobExecutionsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobExecutionsClientBeginCreateOrUpdateOptions contains the optional parameters for the JobExecutionsClient.BeginCreateOrUpdate
// method.
type JobExecutionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobExecutionsClientCancelOptions contains the optional parameters for the JobExecutionsClient.Cancel method.
type JobExecutionsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// JobExecutionsClientGetOptions contains the optional parameters for the JobExecutionsClient.Get method.
type JobExecutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobExecutionsClientListByAgentOptions contains the optional parameters for the JobExecutionsClient.ListByAgent method.
type JobExecutionsClientListByAgentOptions struct {
	// If specified, only job executions created before the specified time are included.
	CreateTimeMax *time.Time
	// If specified, only job executions created at or after the specified time are included.
	CreateTimeMin *time.Time
	// If specified, only job executions completed before the specified time are included.
	EndTimeMax *time.Time
	// If specified, only job executions completed at or after the specified time are included.
	EndTimeMin *time.Time
	// If specified, only active or only completed job executions are included.
	IsActive *bool
	// The number of elements in the collection to skip.
	Skip *int32
	// The number of elements to return from the collection.
	Top *int32
}

// JobExecutionsClientListByJobOptions contains the optional parameters for the JobExecutionsClient.ListByJob method.
type JobExecutionsClientListByJobOptions struct {
	// If specified, only job executions created before the specified time are included.
	CreateTimeMax *time.Time
	// If specified, only job executions created at or after the specified time are included.
	CreateTimeMin *time.Time
	// If specified, only job executions completed before the specified time are included.
	EndTimeMax *time.Time
	// If specified, only job executions completed at or after the specified time are included.
	EndTimeMin *time.Time
	// If specified, only active or only completed job executions are included.
	IsActive *bool
	// The number of elements in the collection to skip.
	Skip *int32
	// The number of elements to return from the collection.
	Top *int32
}

// JobListResult - A list of jobs.
type JobListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Job `json:"value,omitempty" azure:"ro"`
}

// JobProperties - Properties of a job.
type JobProperties struct {
	// User-defined description of the job.
	Description *string `json:"description,omitempty"`

	// Schedule properties of the job.
	Schedule *JobSchedule `json:"schedule,omitempty"`

	// READ-ONLY; The job version number.
	Version *int32 `json:"version,omitempty" azure:"ro"`
}

// JobSchedule - Scheduling properties of a job.
type JobSchedule struct {
	// Whether or not the schedule is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Schedule end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Value of the schedule's recurring interval, if the ScheduleType is recurring. ISO8601 duration format.
	Interval *string `json:"interval,omitempty"`

	// Schedule start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Schedule interval type
	Type *JobScheduleType `json:"type,omitempty"`
}

// JobStep - A job step.
type JobStep struct {
	// Resource properties.
	Properties *JobStepProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobStepAction - The action to be executed by a job step.
type JobStepAction struct {
	// REQUIRED; The action value, for example the text of the T-SQL script to execute.
	Value *string `json:"value,omitempty"`

	// The source of the action to execute.
	Source *JobStepActionSource `json:"source,omitempty"`

	// Type of action being executed by the job step.
	Type *JobStepActionType `json:"type,omitempty"`
}

// JobStepExecutionOptions - The execution options of a job step.
type JobStepExecutionOptions struct {
	// Initial delay between retries for job step execution.
	InitialRetryIntervalSeconds *int32 `json:"initialRetryIntervalSeconds,omitempty"`

	// The maximum amount of time to wait between retries for job step execution.
	MaximumRetryIntervalSeconds *int32 `json:"maximumRetryIntervalSeconds,omitempty"`

	// Maximum number of times the job step will be reattempted if the first attempt fails.
	RetryAttempts *int32 `json:"retryAttempts,omitempty"`

	// The backoff multiplier for the time between retries.
	RetryIntervalBackoffMultiplier *float32 `json:"retryIntervalBackoffMultiplier,omitempty"`

	// Execution timeout for the job step.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
}

// JobStepExecutionsClientGetOptions contains the optional parameters for the JobStepExecutionsClient.Get method.
type JobStepExecutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobStepExecutionsClientListByJobExecutionOptions contains the optional parameters for the JobStepExecutionsClient.ListByJobExecution
// method.
type JobStepExecutionsClientListByJobExecutionOptions struct {
	// If specified, only job executions created before the specified time are included.
	CreateTimeMax *time.Time
	// If specified, only job executions created at or after the specified time are included.
	CreateTimeMin *time.Time
	// If specified, only job executions completed before the specified time are included.
	EndTimeMax *time.Time
	// If specified, only job executions completed at or after the specified time are included.
	EndTimeMin *time.Time
	// If specified, only active or only completed job executions are included.
	IsActive *bool
	// The number of elements in the collection to skip.
	Skip *int32
	// The number of elements to return from the collection.
	Top *int32
}

// JobStepListResult - A list of job steps.
type JobStepListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*JobStep `json:"value,omitempty" azure:"ro"`
}

// JobStepOutput - The output configuration of a job step.
type JobStepOutput struct {
	// REQUIRED; The resource ID of the credential to use to connect to the output destination.
	Credential *string `json:"credential,omitempty"`

	// REQUIRED; The output destination database.
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; The output destination server name.
	ServerName *string `json:"serverName,omitempty"`

	// REQUIRED; The output destination table.
	TableName *string `json:"tableName,omitempty"`

	// The output destination resource group.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`

	// The output destination schema.
	SchemaName *string `json:"schemaName,omitempty"`

	// The output destination subscription id.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// The output destination type.
	Type *JobStepOutputType `json:"type,omitempty"`
}

// JobStepProperties - Properties of a job step.
type JobStepProperties struct {
	// REQUIRED; The action payload of the job step.
	Action *JobStepAction `json:"action,omitempty"`

	// REQUIRED; The resource ID of the job credential that will be used to connect to the targets.
	Credential *string `json:"credential,omitempty"`

	// REQUIRED; The resource ID of the target group that the job step will be executed on.
	TargetGroup *string `json:"targetGroup,omitempty"`

	// Execution options for the job step.
	ExecutionOptions *JobStepExecutionOptions `json:"executionOptions,omitempty"`

	// Output destination properties of the job step.
	Output *JobStepOutput `json:"output,omitempty"`

	// The job step's index within the job. If not specified when creating the job step, it will be created as the last step.
	// If not specified when updating the job step, the step id is not modified.
	StepID *int32 `json:"stepId,omitempty"`
}

// JobStepsClientCreateOrUpdateOptions contains the optional parameters for the JobStepsClient.CreateOrUpdate method.
type JobStepsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JobStepsClientDeleteOptions contains the optional parameters for the JobStepsClient.Delete method.
type JobStepsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobStepsClientGetByVersionOptions contains the optional parameters for the JobStepsClient.GetByVersion method.
type JobStepsClientGetByVersionOptions struct {
	// placeholder for future optional parameters
}

// JobStepsClientGetOptions contains the optional parameters for the JobStepsClient.Get method.
type JobStepsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobStepsClientListByJobOptions contains the optional parameters for the JobStepsClient.ListByJob method.
type JobStepsClientListByJobOptions struct {
	// placeholder for future optional parameters
}

// JobStepsClientListByVersionOptions contains the optional parameters for the JobStepsClient.ListByVersion method.
type JobStepsClientListByVersionOptions struct {
	// placeholder for future optional parameters
}

// JobTarget - A job target, for example a specific database or a container of databases that is evaluated during job execution.
type JobTarget struct {
	// REQUIRED; The target type.
	Type *JobTargetType `json:"type,omitempty"`

	// The target database name.
	DatabaseName *string `json:"databaseName,omitempty"`

	// The target elastic pool name.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`

	// Whether the target is included or excluded from the group.
	MembershipType *JobTargetGroupMembershipType `json:"membershipType,omitempty"`

	// The resource ID of the credential that is used during job execution to connect to the target and determine the list of
	// databases inside the target.
	RefreshCredential *string `json:"refreshCredential,omitempty"`

	// The target server name.
	ServerName *string `json:"serverName,omitempty"`

	// The target shard map.
	ShardMapName *string `json:"shardMapName,omitempty"`
}

// JobTargetExecutionsClientGetOptions contains the optional parameters for the JobTargetExecutionsClient.Get method.
type JobTargetExecutionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobTargetExecutionsClientListByJobExecutionOptions contains the optional parameters for the JobTargetExecutionsClient.ListByJobExecution
// method.
type JobTargetExecutionsClientListByJobExecutionOptions struct {
	// If specified, only job executions created before the specified time are included.
	CreateTimeMax *time.Time
	// If specified, only job executions created at or after the specified time are included.
	CreateTimeMin *time.Time
	// If specified, only job executions completed before the specified time are included.
	EndTimeMax *time.Time
	// If specified, only job executions completed at or after the specified time are included.
	EndTimeMin *time.Time
	// If specified, only active or only completed job executions are included.
	IsActive *bool
	// The number of elements in the collection to skip.
	Skip *int32
	// The number of elements to return from the collection.
	Top *int32
}

// JobTargetExecutionsClientListByStepOptions contains the optional parameters for the JobTargetExecutionsClient.ListByStep
// method.
type JobTargetExecutionsClientListByStepOptions struct {
	// If specified, only job executions created before the specified time are included.
	CreateTimeMax *time.Time
	// If specified, only job executions created at or after the specified time are included.
	CreateTimeMin *time.Time
	// If specified, only job executions completed before the specified time are included.
	EndTimeMax *time.Time
	// If specified, only job executions completed at or after the specified time are included.
	EndTimeMin *time.Time
	// If specified, only active or only completed job executions are included.
	IsActive *bool
	// The number of elements in the collection to skip.
	Skip *int32
	// The number of elements to return from the collection.
	Top *int32
}

// JobTargetGroup - A group of job targets.
type JobTargetGroup struct {
	// Resource properties.
	Properties *JobTargetGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobTargetGroupListResult - A list of target groups.
type JobTargetGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*JobTargetGroup `json:"value,omitempty" azure:"ro"`
}

// JobTargetGroupProperties - Properties of job target group.
type JobTargetGroupProperties struct {
	// REQUIRED; Members of the target group.
	Members []*JobTarget `json:"members,omitempty"`
}

// JobTargetGroupsClientCreateOrUpdateOptions contains the optional parameters for the JobTargetGroupsClient.CreateOrUpdate
// method.
type JobTargetGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JobTargetGroupsClientDeleteOptions contains the optional parameters for the JobTargetGroupsClient.Delete method.
type JobTargetGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobTargetGroupsClientGetOptions contains the optional parameters for the JobTargetGroupsClient.Get method.
type JobTargetGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobTargetGroupsClientListByAgentOptions contains the optional parameters for the JobTargetGroupsClient.ListByAgent method.
type JobTargetGroupsClientListByAgentOptions struct {
	// placeholder for future optional parameters
}

// JobVersion - A job version.
type JobVersion struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// JobVersionListResult - A list of job versions.
type JobVersionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*JobVersion `json:"value,omitempty" azure:"ro"`
}

// JobVersionsClientGetOptions contains the optional parameters for the JobVersionsClient.Get method.
type JobVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobVersionsClientListByJobOptions contains the optional parameters for the JobVersionsClient.ListByJob method.
type JobVersionsClientListByJobOptions struct {
	// placeholder for future optional parameters
}

// JobsClientCreateOrUpdateOptions contains the optional parameters for the JobsClient.CreateOrUpdate method.
type JobsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JobsClientDeleteOptions contains the optional parameters for the JobsClient.Delete method.
type JobsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListByAgentOptions contains the optional parameters for the JobsClient.ListByAgent method.
type JobsClientListByAgentOptions struct {
	// placeholder for future optional parameters
}

// LedgerDigestUploads - Azure SQL Database ledger digest upload settings.
type LedgerDigestUploads struct {
	// Resource properties.
	Properties *LedgerDigestUploadsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LedgerDigestUploadsClientBeginCreateOrUpdateOptions contains the optional parameters for the LedgerDigestUploadsClient.BeginCreateOrUpdate
// method.
type LedgerDigestUploadsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LedgerDigestUploadsClientBeginDisableOptions contains the optional parameters for the LedgerDigestUploadsClient.BeginDisable
// method.
type LedgerDigestUploadsClientBeginDisableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LedgerDigestUploadsClientGetOptions contains the optional parameters for the LedgerDigestUploadsClient.Get method.
type LedgerDigestUploadsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LedgerDigestUploadsClientListByDatabaseOptions contains the optional parameters for the LedgerDigestUploadsClient.ListByDatabase
// method.
type LedgerDigestUploadsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// LedgerDigestUploadsListResult - A list of ledger digest upload settings.
type LedgerDigestUploadsListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*LedgerDigestUploads `json:"value,omitempty" azure:"ro"`
}

// LedgerDigestUploadsProperties - The properties of a database ledger digest upload settings.
type LedgerDigestUploadsProperties struct {
	// The digest storage endpoint, which must be either an Azure blob storage endpoint or an URI for Azure Confidential Ledger.
	DigestStorageEndpoint *string `json:"digestStorageEndpoint,omitempty"`

	// READ-ONLY; Specifies the state of ledger digest upload.
	State *LedgerDigestUploadsState `json:"state,omitempty" azure:"ro"`
}

// LicenseTypeCapability - The license type capability
type LicenseTypeCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; License type identifier.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`
}

// LocationCapabilities - The location capability.
type LocationCapabilities struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The location name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported managed instance versions.
	SupportedManagedInstanceVersions []*ManagedInstanceVersionCapability `json:"supportedManagedInstanceVersions,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported server versions.
	SupportedServerVersions []*ServerVersionCapability `json:"supportedServerVersions,omitempty" azure:"ro"`
}

// LogSizeCapability - The log size capability.
type LogSizeCapability struct {
	// READ-ONLY; The log size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The units that the limit is expressed in.
	Unit *LogSizeUnit `json:"unit,omitempty" azure:"ro"`
}

// LogicalDatabaseTransparentDataEncryption - A logical database transparent data encryption state.
type LogicalDatabaseTransparentDataEncryption struct {
	// Resource properties.
	Properties *TransparentDataEncryptionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LogicalDatabaseTransparentDataEncryptionListResult - A list of transparent data encryptions
type LogicalDatabaseTransparentDataEncryptionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*LogicalDatabaseTransparentDataEncryption `json:"value,omitempty" azure:"ro"`
}

// LogicalServerAdvancedThreatProtectionListResult - A list of the server's Advanced Threat Protection configurations.
type LogicalServerAdvancedThreatProtectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerAdvancedThreatProtection `json:"value,omitempty" azure:"ro"`
}

// LogicalServerSecurityAlertPolicyListResult - A list of the server's security alert policies.
type LogicalServerSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// LongTermRetentionBackup - A long term retention backup.
type LongTermRetentionBackup struct {
	// Resource properties.
	Properties *LongTermRetentionBackupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LongTermRetentionBackupListResult - A list of long term retention backups.
type LongTermRetentionBackupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*LongTermRetentionBackup `json:"value,omitempty" azure:"ro"`
}

// LongTermRetentionBackupOperationResult - A LongTermRetentionBackup operation result resource.
type LongTermRetentionBackupOperationResult struct {
	// Resource properties.
	Properties *LongTermRetentionOperationResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LongTermRetentionBackupProperties - Properties of a long term retention backup
type LongTermRetentionBackupProperties struct {
	// The storage redundancy type of the backup
	RequestedBackupStorageRedundancy *BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`

	// READ-ONLY; The time the long term retention backup will expire.
	BackupExpirationTime *time.Time `json:"backupExpirationTime,omitempty" azure:"ro"`

	// READ-ONLY; The storage redundancy type of the backup
	BackupStorageRedundancy *BackupStorageRedundancy `json:"backupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; The time the backup was taken
	BackupTime *time.Time `json:"backupTime,omitempty" azure:"ro"`

	// READ-ONLY; The delete time of the database
	DatabaseDeletionTime *time.Time `json:"databaseDeletionTime,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database the backup belong to
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The create time of the server.
	ServerCreateTime *time.Time `json:"serverCreateTime,omitempty" azure:"ro"`

	// READ-ONLY; The server name that the backup database belong to.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`
}

// LongTermRetentionBackupsClientBeginCopyByResourceGroupOptions contains the optional parameters for the LongTermRetentionBackupsClient.BeginCopyByResourceGroup
// method.
type LongTermRetentionBackupsClientBeginCopyByResourceGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionBackupsClientBeginCopyOptions contains the optional parameters for the LongTermRetentionBackupsClient.BeginCopy
// method.
type LongTermRetentionBackupsClientBeginCopyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionBackupsClientBeginDeleteByResourceGroupOptions contains the optional parameters for the LongTermRetentionBackupsClient.BeginDeleteByResourceGroup
// method.
type LongTermRetentionBackupsClientBeginDeleteByResourceGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionBackupsClientBeginDeleteOptions contains the optional parameters for the LongTermRetentionBackupsClient.BeginDelete
// method.
type LongTermRetentionBackupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionBackupsClientBeginUpdateByResourceGroupOptions contains the optional parameters for the LongTermRetentionBackupsClient.BeginUpdateByResourceGroup
// method.
type LongTermRetentionBackupsClientBeginUpdateByResourceGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionBackupsClientBeginUpdateOptions contains the optional parameters for the LongTermRetentionBackupsClient.BeginUpdate
// method.
type LongTermRetentionBackupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionBackupsClientGetByResourceGroupOptions contains the optional parameters for the LongTermRetentionBackupsClient.GetByResourceGroup
// method.
type LongTermRetentionBackupsClientGetByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// LongTermRetentionBackupsClientGetOptions contains the optional parameters for the LongTermRetentionBackupsClient.Get method.
type LongTermRetentionBackupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LongTermRetentionBackupsClientListByDatabaseOptions contains the optional parameters for the LongTermRetentionBackupsClient.ListByDatabase
// method.
type LongTermRetentionBackupsClientListByDatabaseOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionBackupsClientListByLocationOptions contains the optional parameters for the LongTermRetentionBackupsClient.ListByLocation
// method.
type LongTermRetentionBackupsClientListByLocationOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionBackupsClientListByResourceGroupDatabaseOptions contains the optional parameters for the LongTermRetentionBackupsClient.ListByResourceGroupDatabase
// method.
type LongTermRetentionBackupsClientListByResourceGroupDatabaseOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionBackupsClientListByResourceGroupLocationOptions contains the optional parameters for the LongTermRetentionBackupsClient.ListByResourceGroupLocation
// method.
type LongTermRetentionBackupsClientListByResourceGroupLocationOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionBackupsClientListByResourceGroupServerOptions contains the optional parameters for the LongTermRetentionBackupsClient.ListByResourceGroupServer
// method.
type LongTermRetentionBackupsClientListByResourceGroupServerOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionBackupsClientListByServerOptions contains the optional parameters for the LongTermRetentionBackupsClient.ListByServer
// method.
type LongTermRetentionBackupsClientListByServerOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionManagedInstanceBackupsClientBeginDeleteByResourceGroupOptions contains the optional parameters for the
// LongTermRetentionManagedInstanceBackupsClient.BeginDeleteByResourceGroup method.
type LongTermRetentionManagedInstanceBackupsClientBeginDeleteByResourceGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionManagedInstanceBackupsClientBeginDeleteOptions contains the optional parameters for the LongTermRetentionManagedInstanceBackupsClient.BeginDelete
// method.
type LongTermRetentionManagedInstanceBackupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionManagedInstanceBackupsClientGetByResourceGroupOptions contains the optional parameters for the LongTermRetentionManagedInstanceBackupsClient.GetByResourceGroup
// method.
type LongTermRetentionManagedInstanceBackupsClientGetByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// LongTermRetentionManagedInstanceBackupsClientGetOptions contains the optional parameters for the LongTermRetentionManagedInstanceBackupsClient.Get
// method.
type LongTermRetentionManagedInstanceBackupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LongTermRetentionManagedInstanceBackupsClientListByDatabaseOptions contains the optional parameters for the LongTermRetentionManagedInstanceBackupsClient.ListByDatabase
// method.
type LongTermRetentionManagedInstanceBackupsClientListByDatabaseOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionManagedInstanceBackupsClientListByInstanceOptions contains the optional parameters for the LongTermRetentionManagedInstanceBackupsClient.ListByInstance
// method.
type LongTermRetentionManagedInstanceBackupsClientListByInstanceOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionManagedInstanceBackupsClientListByLocationOptions contains the optional parameters for the LongTermRetentionManagedInstanceBackupsClient.ListByLocation
// method.
type LongTermRetentionManagedInstanceBackupsClientListByLocationOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseOptions contains the optional parameters for the
// LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupDatabase method.
type LongTermRetentionManagedInstanceBackupsClientListByResourceGroupDatabaseOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceOptions contains the optional parameters for the
// LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupInstance method.
type LongTermRetentionManagedInstanceBackupsClientListByResourceGroupInstanceOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationOptions contains the optional parameters for the
// LongTermRetentionManagedInstanceBackupsClient.ListByResourceGroupLocation method.
type LongTermRetentionManagedInstanceBackupsClientListByResourceGroupLocationOptions struct {
	// Whether to query against just live databases, just deleted databases, or all databases.
	DatabaseState *DatabaseState
	// Whether or not to only get the latest backup for each database.
	OnlyLatestPerDatabase *bool
}

// LongTermRetentionOperationResultProperties - Contains the operation result properties for long term retention backup operation.
type LongTermRetentionOperationResultProperties struct {
	// READ-ONLY; Source backup resource id
	FromBackupResourceID *string `json:"fromBackupResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Progress message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Operation type.
	OperationType *string `json:"operationType,omitempty" azure:"ro"`

	// READ-ONLY; Request Id.
	RequestID *string `json:"requestId,omitempty" azure:"ro"`

	// READ-ONLY; Operation status
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The storage redundancy type of the copied backup
	TargetBackupStorageRedundancy *BackupStorageRedundancy `json:"targetBackupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; Target backup resource id
	ToBackupResourceID *string `json:"toBackupResourceId,omitempty" azure:"ro"`
}

// LongTermRetentionPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the LongTermRetentionPoliciesClient.BeginCreateOrUpdate
// method.
type LongTermRetentionPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LongTermRetentionPoliciesClientGetOptions contains the optional parameters for the LongTermRetentionPoliciesClient.Get
// method.
type LongTermRetentionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LongTermRetentionPoliciesClientListByDatabaseOptions contains the optional parameters for the LongTermRetentionPoliciesClient.ListByDatabase
// method.
type LongTermRetentionPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// LongTermRetentionPolicy - A long term retention policy.
type LongTermRetentionPolicy struct {
	// Resource properties.
	Properties *BaseLongTermRetentionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LongTermRetentionPolicyListResult - A list of long term retention policies.
type LongTermRetentionPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*LongTermRetentionPolicy `json:"value,omitempty" azure:"ro"`
}

// MaintenanceConfigurationCapability - The maintenance configuration capability
type MaintenanceConfigurationCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; Maintenance configuration name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not zone redundancy is supported for the maintenance configuration.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty" azure:"ro"`
}

// MaintenanceWindowOptions - Maintenance window options.
type MaintenanceWindowOptions struct {
	// Resource properties.
	Properties *MaintenanceWindowOptionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MaintenanceWindowOptionsClientGetOptions contains the optional parameters for the MaintenanceWindowOptionsClient.Get method.
type MaintenanceWindowOptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceWindowOptionsProperties - Maintenance window options properties.
type MaintenanceWindowOptionsProperties struct {
	// Whether we allow multiple maintenance windows per cycle.
	AllowMultipleMaintenanceWindowsPerCycle *bool `json:"allowMultipleMaintenanceWindowsPerCycle,omitempty"`

	// Default duration for maintenance window.
	DefaultDurationInMinutes *int32 `json:"defaultDurationInMinutes,omitempty"`

	// Whether maintenance windows are enabled for the database.
	IsEnabled *bool `json:"isEnabled,omitempty"`

	// Available maintenance cycles e.g. {Saturday, 0, 4860}, {Wednesday, 0, 2460}.
	MaintenanceWindowCycles []*MaintenanceWindowTimeRange `json:"maintenanceWindowCycles,omitempty"`

	// Minimum number of maintenance windows cycles to be set on the database.
	MinCycles *int32 `json:"minCycles,omitempty"`

	// Minimum duration of maintenance window.
	MinDurationInMinutes *int32 `json:"minDurationInMinutes,omitempty"`

	// Time granularity in minutes for maintenance windows.
	TimeGranularityInMinutes *int32 `json:"timeGranularityInMinutes,omitempty"`
}

// MaintenanceWindowTimeRange - Maintenance window time range.
type MaintenanceWindowTimeRange struct {
	// Day of maintenance window.
	DayOfWeek *DayOfWeek `json:"dayOfWeek,omitempty"`

	// Duration of maintenance window in minutes.
	Duration *string `json:"duration,omitempty"`

	// Start time minutes offset from 12am.
	StartTime *string `json:"startTime,omitempty"`
}

// MaintenanceWindows - Maintenance windows.
type MaintenanceWindows struct {
	// Resource properties.
	Properties *MaintenanceWindowsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MaintenanceWindowsClientCreateOrUpdateOptions contains the optional parameters for the MaintenanceWindowsClient.CreateOrUpdate
// method.
type MaintenanceWindowsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceWindowsClientGetOptions contains the optional parameters for the MaintenanceWindowsClient.Get method.
type MaintenanceWindowsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MaintenanceWindowsProperties - Maintenance windows resource properties.
type MaintenanceWindowsProperties struct {
	TimeRanges []*MaintenanceWindowTimeRange `json:"timeRanges,omitempty"`
}

// ManagedBackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedBackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate
// method.
type ManagedBackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedBackupShortTermRetentionPoliciesClientBeginUpdateOptions contains the optional parameters for the ManagedBackupShortTermRetentionPoliciesClient.BeginUpdate
// method.
type ManagedBackupShortTermRetentionPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedBackupShortTermRetentionPoliciesClientGetOptions contains the optional parameters for the ManagedBackupShortTermRetentionPoliciesClient.Get
// method.
type ManagedBackupShortTermRetentionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedBackupShortTermRetentionPoliciesClientListByDatabaseOptions contains the optional parameters for the ManagedBackupShortTermRetentionPoliciesClient.ListByDatabase
// method.
type ManagedBackupShortTermRetentionPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedBackupShortTermRetentionPolicy - A short term retention policy.
type ManagedBackupShortTermRetentionPolicy struct {
	// Resource properties.
	Properties *ManagedBackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedBackupShortTermRetentionPolicyListResult - A list of short term retention policies.
type ManagedBackupShortTermRetentionPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedBackupShortTermRetentionPolicy `json:"value,omitempty" azure:"ro"`
}

// ManagedBackupShortTermRetentionPolicyProperties - Properties of a short term retention policy
type ManagedBackupShortTermRetentionPolicyProperties struct {
	// The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// ManagedDatabase - A managed database resource.
type ManagedDatabase struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *ManagedDatabaseProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedDatabaseColumnsClientGetOptions contains the optional parameters for the ManagedDatabaseColumnsClient.Get method.
type ManagedDatabaseColumnsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseColumnsClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseColumnsClient.ListByDatabase
// method.
type ManagedDatabaseColumnsClientListByDatabaseOptions struct {
	Column  []string
	OrderBy []string
	Schema  []string
	// An opaque token that identifies a starting point in the collection.
	Skiptoken *string
	Table     []string
}

// ManagedDatabaseColumnsClientListByTableOptions contains the optional parameters for the ManagedDatabaseColumnsClient.ListByTable
// method.
type ManagedDatabaseColumnsClientListByTableOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// ManagedDatabaseListResult - A list of managed databases.
type ManagedDatabaseListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedDatabase `json:"value,omitempty" azure:"ro"`
}

// ManagedDatabaseProperties - The managed database's properties.
type ManagedDatabaseProperties struct {
	// Whether to auto complete restore of this managed database.
	AutoCompleteRestore *bool `json:"autoCompleteRestore,omitempty"`

	// Collation of the metadata catalog.
	CatalogCollation *CatalogCollationType `json:"catalogCollation,omitempty"`

	// Collation of the managed database.
	Collation *string `json:"collation,omitempty"`

	// Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing
	// database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be
	// specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri
	// and StorageContainerSasToken must be specified. Recovery: Creates a database
	// by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to
	// restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
	// long term retention backup (longTermRetentionBackupResourceId required).
	CreateMode *ManagedDatabaseCreateMode `json:"createMode,omitempty"`

	// Last backup file name for restore of this managed database.
	LastBackupName *string `json:"lastBackupName,omitempty"`

	// The name of the Long Term Retention backup to be used for restore of this managed database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`

	// The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`

	// The restorable dropped database resource id to restore when creating this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`

	// Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format)
	// of the source database that will be restored to create the new database.
	RestorePointInTime *time.Time `json:"restorePointInTime,omitempty"`

	// The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`

	// Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
	StorageContainerSasToken *string `json:"storageContainerSasToken,omitempty"`

	// Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container
	// where backups for this restore are stored.
	StorageContainerURI *string `json:"storageContainerUri,omitempty"`

	// READ-ONLY; Creation date of the database.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Geo paired region.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty" azure:"ro"`

	// READ-ONLY; Earliest restore point in time for point in time restore.
	EarliestRestorePoint *time.Time `json:"earliestRestorePoint,omitempty" azure:"ro"`

	// READ-ONLY; Instance Failover Group resource identifier that this managed database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty" azure:"ro"`

	// READ-ONLY; Status of the database.
	Status *ManagedDatabaseStatus `json:"status,omitempty" azure:"ro"`
}

// ManagedDatabaseQueriesClientGetOptions contains the optional parameters for the ManagedDatabaseQueriesClient.Get method.
type ManagedDatabaseQueriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseQueriesClientListByQueryOptions contains the optional parameters for the ManagedDatabaseQueriesClient.ListByQuery
// method.
type ManagedDatabaseQueriesClientListByQueryOptions struct {
	// End time for observed period.
	EndTime *string
	// The time step to be used to summarize the metric values.
	Interval *QueryTimeGrainType
	// Start time for observed period.
	StartTime *string
}

// ManagedDatabaseRecommendedSensitivityLabelsClientUpdateOptions contains the optional parameters for the ManagedDatabaseRecommendedSensitivityLabelsClient.Update
// method.
type ManagedDatabaseRecommendedSensitivityLabelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseRestoreDetailsClientGetOptions contains the optional parameters for the ManagedDatabaseRestoreDetailsClient.Get
// method.
type ManagedDatabaseRestoreDetailsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseRestoreDetailsProperties - The managed database's restore details properties.
type ManagedDatabaseRestoreDetailsProperties struct {
	// READ-ONLY; The reason why restore is in Blocked state.
	BlockReason *string `json:"blockReason,omitempty" azure:"ro"`

	// READ-ONLY; Current restoring file name.
	CurrentRestoringFileName *string `json:"currentRestoringFileName,omitempty" azure:"ro"`

	// READ-ONLY; Last restored file name.
	LastRestoredFileName *string `json:"lastRestoredFileName,omitempty" azure:"ro"`

	// READ-ONLY; Last restored file time.
	LastRestoredFileTime *time.Time `json:"lastRestoredFileTime,omitempty" azure:"ro"`

	// READ-ONLY; Last uploaded file name.
	LastUploadedFileName *string `json:"lastUploadedFileName,omitempty" azure:"ro"`

	// READ-ONLY; Last uploaded file time.
	LastUploadedFileTime *time.Time `json:"lastUploadedFileTime,omitempty" azure:"ro"`

	// READ-ONLY; Number of files detected.
	NumberOfFilesDetected *int64 `json:"numberOfFilesDetected,omitempty" azure:"ro"`

	// READ-ONLY; Percent completed.
	PercentCompleted *float64 `json:"percentCompleted,omitempty" azure:"ro"`

	// READ-ONLY; Restore status.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; List of unrestorable files.
	UnrestorableFiles []*string `json:"unrestorableFiles,omitempty" azure:"ro"`
}

// ManagedDatabaseRestoreDetailsResult - A managed database restore details.
type ManagedDatabaseRestoreDetailsResult struct {
	// Resource properties.
	Properties *ManagedDatabaseRestoreDetailsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedDatabaseSchemasClientGetOptions contains the optional parameters for the ManagedDatabaseSchemasClient.Get method.
type ManagedDatabaseSchemasClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSchemasClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseSchemasClient.ListByDatabase
// method.
type ManagedDatabaseSchemasClientListByDatabaseOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// ManagedDatabaseSecurityAlertPoliciesClientCreateOrUpdateOptions contains the optional parameters for the ManagedDatabaseSecurityAlertPoliciesClient.CreateOrUpdate
// method.
type ManagedDatabaseSecurityAlertPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSecurityAlertPoliciesClientGetOptions contains the optional parameters for the ManagedDatabaseSecurityAlertPoliciesClient.Get
// method.
type ManagedDatabaseSecurityAlertPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSecurityAlertPoliciesClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseSecurityAlertPoliciesClient.ListByDatabase
// method.
type ManagedDatabaseSecurityAlertPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSecurityAlertPolicy - A managed database security alert policy.
type ManagedDatabaseSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedDatabaseSecurityAlertPolicyListResult - A list of the managed database's security alert policies.
type ManagedDatabaseSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedDatabaseSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// ManagedDatabaseSecurityEventsClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseSecurityEventsClient.ListByDatabase
// method.
type ManagedDatabaseSecurityEventsClientListByDatabaseOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
	// The number of elements in the collection to skip.
	Skip *int32
	// An opaque token that identifies a starting point in the collection.
	Skiptoken *string
	// The number of elements to return from the collection.
	Top *int32
}

// ManagedDatabaseSensitivityLabelsClientCreateOrUpdateOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.CreateOrUpdate
// method.
type ManagedDatabaseSensitivityLabelsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSensitivityLabelsClientDeleteOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.Delete
// method.
type ManagedDatabaseSensitivityLabelsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSensitivityLabelsClientDisableRecommendationOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.DisableRecommendation
// method.
type ManagedDatabaseSensitivityLabelsClientDisableRecommendationOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSensitivityLabelsClientEnableRecommendationOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.EnableRecommendation
// method.
type ManagedDatabaseSensitivityLabelsClientEnableRecommendationOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSensitivityLabelsClientGetOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.Get
// method.
type ManagedDatabaseSensitivityLabelsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseSensitivityLabelsClientListCurrentByDatabaseOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.ListCurrentByDatabase
// method.
type ManagedDatabaseSensitivityLabelsClientListCurrentByDatabaseOptions struct {
	Count *bool
	// An OData filter expression that filters elements in the collection.
	Filter    *string
	SkipToken *string
}

// ManagedDatabaseSensitivityLabelsClientListRecommendedByDatabaseOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.ListRecommendedByDatabase
// method.
type ManagedDatabaseSensitivityLabelsClientListRecommendedByDatabaseOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
	// Specifies whether to include disabled recommendations or not.
	IncludeDisabledRecommendations *bool
	SkipToken                      *string
}

// ManagedDatabaseSensitivityLabelsClientUpdateOptions contains the optional parameters for the ManagedDatabaseSensitivityLabelsClient.Update
// method.
type ManagedDatabaseSensitivityLabelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseTablesClientGetOptions contains the optional parameters for the ManagedDatabaseTablesClient.Get method.
type ManagedDatabaseTablesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseTablesClientListBySchemaOptions contains the optional parameters for the ManagedDatabaseTablesClient.ListBySchema
// method.
type ManagedDatabaseTablesClientListBySchemaOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// ManagedDatabaseTransparentDataEncryptionClientCreateOrUpdateOptions contains the optional parameters for the ManagedDatabaseTransparentDataEncryptionClient.CreateOrUpdate
// method.
type ManagedDatabaseTransparentDataEncryptionClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseTransparentDataEncryptionClientGetOptions contains the optional parameters for the ManagedDatabaseTransparentDataEncryptionClient.Get
// method.
type ManagedDatabaseTransparentDataEncryptionClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseTransparentDataEncryptionClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseTransparentDataEncryptionClient.ListByDatabase
// method.
type ManagedDatabaseTransparentDataEncryptionClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseUpdate - An managed database update.
type ManagedDatabaseUpdate struct {
	// Resource properties.
	Properties *ManagedDatabaseProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions contains the optional parameters for the
// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate method.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Delete
// method.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.Get
// method.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan
// method.
type ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedDatabaseVulnerabilityAssessmentScansClientExportOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentScansClient.Export
// method.
type ManagedDatabaseVulnerabilityAssessmentScansClientExportOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentScansClient.Get
// method.
type ManagedDatabaseVulnerabilityAssessmentScansClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentScansClient.ListByDatabase
// method.
type ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
type ManagedDatabaseVulnerabilityAssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentsClient.Delete
// method.
type ManagedDatabaseVulnerabilityAssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentsClient.Get
// method.
type ManagedDatabaseVulnerabilityAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabaseVulnerabilityAssessmentsClientListByDatabaseOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentsClient.ListByDatabase
// method.
type ManagedDatabaseVulnerabilityAssessmentsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabasesClientBeginCompleteRestoreOptions contains the optional parameters for the ManagedDatabasesClient.BeginCompleteRestore
// method.
type ManagedDatabasesClientBeginCompleteRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedDatabasesClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedDatabasesClient.BeginCreateOrUpdate
// method.
type ManagedDatabasesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedDatabasesClientBeginDeleteOptions contains the optional parameters for the ManagedDatabasesClient.BeginDelete method.
type ManagedDatabasesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedDatabasesClientBeginUpdateOptions contains the optional parameters for the ManagedDatabasesClient.BeginUpdate method.
type ManagedDatabasesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedDatabasesClientGetOptions contains the optional parameters for the ManagedDatabasesClient.Get method.
type ManagedDatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabasesClientListByInstanceOptions contains the optional parameters for the ManagedDatabasesClient.ListByInstance
// method.
type ManagedDatabasesClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedDatabasesClientListInaccessibleByInstanceOptions contains the optional parameters for the ManagedDatabasesClient.ListInaccessibleByInstance
// method.
type ManagedDatabasesClientListInaccessibleByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstance - An Azure SQL managed instance.
type ManagedInstance struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// The Azure Active Directory identity of the managed instance.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *ManagedInstanceProperties `json:"properties,omitempty"`

	// Managed instance SKU. Allowed values for sku.name: GPGen4, GPGen5, BCGen4, BCGen5
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceAdministrator - An Azure SQL managed instance administrator.
type ManagedInstanceAdministrator struct {
	// Resource properties.
	Properties *ManagedInstanceAdministratorProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceAdministratorListResult - A list of managed instance administrators.
type ManagedInstanceAdministratorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceAdministrator `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceAdministratorProperties - The properties of a managed instance administrator.
type ManagedInstanceAdministratorProperties struct {
	// REQUIRED; Type of the managed instance administrator.
	AdministratorType *ManagedInstanceAdministratorType `json:"administratorType,omitempty"`

	// REQUIRED; Login name of the managed instance administrator.
	Login *string `json:"login,omitempty"`

	// REQUIRED; SID (object ID) of the managed instance administrator.
	Sid *string `json:"sid,omitempty"`

	// Tenant ID of the managed instance administrator.
	TenantID *string `json:"tenantId,omitempty"`
}

// ManagedInstanceAdministratorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceAdministratorsClient.BeginCreateOrUpdate
// method.
type ManagedInstanceAdministratorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceAdministratorsClientBeginDeleteOptions contains the optional parameters for the ManagedInstanceAdministratorsClient.BeginDelete
// method.
type ManagedInstanceAdministratorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceAdministratorsClientGetOptions contains the optional parameters for the ManagedInstanceAdministratorsClient.Get
// method.
type ManagedInstanceAdministratorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceAdministratorsClientListByInstanceOptions contains the optional parameters for the ManagedInstanceAdministratorsClient.ListByInstance
// method.
type ManagedInstanceAdministratorsClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceAzureADOnlyAuthListResult - A list of active directory only authentications.
type ManagedInstanceAzureADOnlyAuthListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceAzureADOnlyAuthentication `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceAzureADOnlyAuthProperties - Properties of a active directory only authentication for Managed Instance.
type ManagedInstanceAzureADOnlyAuthProperties struct {
	// REQUIRED; Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`
}

// ManagedInstanceAzureADOnlyAuthentication - Azure Active Directory only authentication.
type ManagedInstanceAzureADOnlyAuthentication struct {
	// Resource properties.
	Properties *ManagedInstanceAzureADOnlyAuthProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceAzureADOnlyAuthenticationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceAzureADOnlyAuthenticationsClient.BeginCreateOrUpdate
// method.
type ManagedInstanceAzureADOnlyAuthenticationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceAzureADOnlyAuthenticationsClientBeginDeleteOptions contains the optional parameters for the ManagedInstanceAzureADOnlyAuthenticationsClient.BeginDelete
// method.
type ManagedInstanceAzureADOnlyAuthenticationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceAzureADOnlyAuthenticationsClientGetOptions contains the optional parameters for the ManagedInstanceAzureADOnlyAuthenticationsClient.Get
// method.
type ManagedInstanceAzureADOnlyAuthenticationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceAzureADOnlyAuthenticationsClientListByInstanceOptions contains the optional parameters for the ManagedInstanceAzureADOnlyAuthenticationsClient.ListByInstance
// method.
type ManagedInstanceAzureADOnlyAuthenticationsClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceEditionCapability - The managed server capability
type ManagedInstanceEditionCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The managed server version name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The supported families.
	SupportedFamilies []*ManagedInstanceFamilyCapability `json:"supportedFamilies,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported storage capabilities for this edition
	SupportedStorageCapabilities []*StorageCapability `json:"supportedStorageCapabilities,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty" azure:"ro"`
}

// ManagedInstanceEncryptionProtector - The managed instance encryption protector.
type ManagedInstanceEncryptionProtector struct {
	// Resource properties.
	Properties *ManagedInstanceEncryptionProtectorProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceEncryptionProtectorListResult - A list of managed instance encryption protectors.
type ManagedInstanceEncryptionProtectorListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceEncryptionProtector `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceEncryptionProtectorProperties - Properties for an encryption protector execution.
type ManagedInstanceEncryptionProtectorProperties struct {
	// REQUIRED; The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
	ServerKeyType *ServerKeyType `json:"serverKeyType,omitempty"`

	// Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty"`

	// The name of the managed instance key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`

	// READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty" azure:"ro"`
}

// ManagedInstanceEncryptionProtectorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceEncryptionProtectorsClient.BeginCreateOrUpdate
// method.
type ManagedInstanceEncryptionProtectorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceEncryptionProtectorsClientBeginRevalidateOptions contains the optional parameters for the ManagedInstanceEncryptionProtectorsClient.BeginRevalidate
// method.
type ManagedInstanceEncryptionProtectorsClientBeginRevalidateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceEncryptionProtectorsClientGetOptions contains the optional parameters for the ManagedInstanceEncryptionProtectorsClient.Get
// method.
type ManagedInstanceEncryptionProtectorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceEncryptionProtectorsClientListByInstanceOptions contains the optional parameters for the ManagedInstanceEncryptionProtectorsClient.ListByInstance
// method.
type ManagedInstanceEncryptionProtectorsClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceExternalAdministrator - Properties of a active directory administrator.
type ManagedInstanceExternalAdministrator struct {
	// Type of the sever administrator.
	AdministratorType *AdministratorType `json:"administratorType,omitempty"`

	// Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`

	// Login name of the server administrator.
	Login *string `json:"login,omitempty"`

	// Principal Type of the sever administrator.
	PrincipalType *PrincipalType `json:"principalType,omitempty"`

	// SID (object ID) of the server administrator.
	Sid *string `json:"sid,omitempty"`

	// Tenant ID of the administrator.
	TenantID *string `json:"tenantId,omitempty"`
}

// ManagedInstanceFamilyCapability - The managed server family capability.
type ManagedInstanceFamilyCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; Family name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SKU name.
	SKU *string `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; List of supported license types.
	SupportedLicenseTypes []*LicenseTypeCapability `json:"supportedLicenseTypes,omitempty" azure:"ro"`

	// READ-ONLY; List of supported virtual cores values.
	SupportedVcoresValues []*ManagedInstanceVcoresCapability `json:"supportedVcoresValues,omitempty" azure:"ro"`
}

// ManagedInstanceKey - A managed instance key.
type ManagedInstanceKey struct {
	// Resource properties.
	Properties *ManagedInstanceKeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceKeyListResult - A list of managed instance keys.
type ManagedInstanceKeyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceKey `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceKeyProperties - Properties for a key execution.
type ManagedInstanceKeyProperties struct {
	// REQUIRED; The key type like 'ServiceManaged', 'AzureKeyVault'.
	ServerKeyType *ServerKeyType `json:"serverKeyType,omitempty"`

	// The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
	URI *string `json:"uri,omitempty"`

	// READ-ONLY; Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The key creation date.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of the key.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// ManagedInstanceKeysClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceKeysClient.BeginCreateOrUpdate
// method.
type ManagedInstanceKeysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceKeysClientBeginDeleteOptions contains the optional parameters for the ManagedInstanceKeysClient.BeginDelete
// method.
type ManagedInstanceKeysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceKeysClientGetOptions contains the optional parameters for the ManagedInstanceKeysClient.Get method.
type ManagedInstanceKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceKeysClientListByInstanceOptions contains the optional parameters for the ManagedInstanceKeysClient.ListByInstance
// method.
type ManagedInstanceKeysClientListByInstanceOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
}

// ManagedInstanceListResult - A list of managed instances.
type ManagedInstanceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstance `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceLongTermRetentionBackup - A long term retention backup for a managed database.
type ManagedInstanceLongTermRetentionBackup struct {
	// Resource properties.
	Properties *ManagedInstanceLongTermRetentionBackupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceLongTermRetentionBackupListResult - A list of long term retention backups for managed database(s).
type ManagedInstanceLongTermRetentionBackupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceLongTermRetentionBackup `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceLongTermRetentionBackupProperties - Properties of a long term retention backup
type ManagedInstanceLongTermRetentionBackupProperties struct {
	// READ-ONLY; The time the long term retention backup will expire.
	BackupExpirationTime *time.Time `json:"backupExpirationTime,omitempty" azure:"ro"`

	// READ-ONLY; The storage redundancy type of the backup
	BackupStorageRedundancy *BackupStorageRedundancy `json:"backupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; The time the backup was taken
	BackupTime *time.Time `json:"backupTime,omitempty" azure:"ro"`

	// READ-ONLY; The delete time of the database
	DatabaseDeletionTime *time.Time `json:"databaseDeletionTime,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database the backup belong to
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The create time of the instance.
	ManagedInstanceCreateTime *time.Time `json:"managedInstanceCreateTime,omitempty" azure:"ro"`

	// READ-ONLY; The managed instance that the backup database belongs to.
	ManagedInstanceName *string `json:"managedInstanceName,omitempty" azure:"ro"`
}

// ManagedInstanceLongTermRetentionPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceLongTermRetentionPoliciesClient.BeginCreateOrUpdate
// method.
type ManagedInstanceLongTermRetentionPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceLongTermRetentionPoliciesClientGetOptions contains the optional parameters for the ManagedInstanceLongTermRetentionPoliciesClient.Get
// method.
type ManagedInstanceLongTermRetentionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceLongTermRetentionPoliciesClientListByDatabaseOptions contains the optional parameters for the ManagedInstanceLongTermRetentionPoliciesClient.ListByDatabase
// method.
type ManagedInstanceLongTermRetentionPoliciesClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceLongTermRetentionPolicy - A long term retention policy.
type ManagedInstanceLongTermRetentionPolicy struct {
	// Resource properties.
	Properties *BaseLongTermRetentionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceLongTermRetentionPolicyListResult - A list of long term retention policies.
type ManagedInstanceLongTermRetentionPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceLongTermRetentionPolicy `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceMaintenanceConfigurationCapability - The maintenance configuration capability
type ManagedInstanceMaintenanceConfigurationCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; Maintenance configuration name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`
}

// ManagedInstanceOperation - A managed instance operation.
type ManagedInstanceOperation struct {
	// Resource properties.
	Properties *ManagedInstanceOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceOperationListResult - The response to a list managed instance operations request
type ManagedInstanceOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceOperation `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceOperationParametersPair - The parameters of a managed instance operation.
type ManagedInstanceOperationParametersPair struct {
	// READ-ONLY; The current parameters.
	CurrentParameters *UpsertManagedServerOperationParameters `json:"currentParameters,omitempty" azure:"ro"`

	// READ-ONLY; The requested parameters.
	RequestedParameters *UpsertManagedServerOperationParameters `json:"requestedParameters,omitempty" azure:"ro"`
}

// ManagedInstanceOperationProperties - The properties of a managed instance operation.
type ManagedInstanceOperationProperties struct {
	// READ-ONLY; The operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty" azure:"ro"`

	// READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *time.Time `json:"estimatedCompletionTime,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed instance the operation is being performed on.
	ManagedInstanceName *string `json:"managedInstanceName,omitempty" azure:"ro"`

	// READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The operation parameters.
	OperationParameters *ManagedInstanceOperationParametersPair `json:"operationParameters,omitempty" azure:"ro"`

	// READ-ONLY; The operation steps.
	OperationSteps *ManagedInstanceOperationSteps `json:"operationSteps,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The operation start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation state.
	State *ManagementOperationState `json:"state,omitempty" azure:"ro"`
}

// ManagedInstanceOperationSteps - The steps of a managed instance operation.
type ManagedInstanceOperationSteps struct {
	// READ-ONLY; The number of current operation steps.
	CurrentStep *int32 `json:"currentStep,omitempty" azure:"ro"`

	// READ-ONLY; The operation steps list.
	StepsList []*UpsertManagedServerOperationStep `json:"stepsList,omitempty" azure:"ro"`

	// READ-ONLY; The total number of operation steps.
	TotalSteps *string `json:"totalSteps,omitempty" azure:"ro"`
}

// ManagedInstanceOperationsClientCancelOptions contains the optional parameters for the ManagedInstanceOperationsClient.Cancel
// method.
type ManagedInstanceOperationsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceOperationsClientGetOptions contains the optional parameters for the ManagedInstanceOperationsClient.Get
// method.
type ManagedInstanceOperationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceOperationsClientListByManagedInstanceOptions contains the optional parameters for the ManagedInstanceOperationsClient.ListByManagedInstance
// method.
type ManagedInstanceOperationsClientListByManagedInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstancePairInfo - Pairs of Managed Instances in the failover group.
type ManagedInstancePairInfo struct {
	// Id of Partner Managed Instance in pair.
	PartnerManagedInstanceID *string `json:"partnerManagedInstanceId,omitempty"`

	// Id of Primary Managed Instance in pair.
	PrimaryManagedInstanceID *string `json:"primaryManagedInstanceId,omitempty"`
}

// ManagedInstancePecProperty - A private endpoint connection under a managed instance
type ManagedInstancePecProperty struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint connection properties
	Properties *ManagedInstancePrivateEndpointConnectionProperties `json:"properties,omitempty" azure:"ro"`
}

// ManagedInstancePrivateEndpointConnection - A private endpoint connection
type ManagedInstancePrivateEndpointConnection struct {
	// Resource properties.
	Properties *ManagedInstancePrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstancePrivateEndpointConnectionListResult - A list of private endpoint connections.
type ManagedInstancePrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstancePrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// ManagedInstancePrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type ManagedInstancePrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *ManagedInstancePrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *ManagedInstancePrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; State of the Private Endpoint Connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedInstancePrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstancePrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type ManagedInstancePrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstancePrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the ManagedInstancePrivateEndpointConnectionsClient.BeginDelete
// method.
type ManagedInstancePrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstancePrivateEndpointConnectionsClientGetOptions contains the optional parameters for the ManagedInstancePrivateEndpointConnectionsClient.Get
// method.
type ManagedInstancePrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstancePrivateEndpointConnectionsClientListByManagedInstanceOptions contains the optional parameters for the ManagedInstancePrivateEndpointConnectionsClient.ListByManagedInstance
// method.
type ManagedInstancePrivateEndpointConnectionsClientListByManagedInstanceOptions struct {
	// placeholder for future optional parameters
}

type ManagedInstancePrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// ManagedInstancePrivateLink - A private link resource
type ManagedInstancePrivateLink struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource group id.
	Properties *ManagedInstancePrivateLinkProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstancePrivateLinkListResult - A list of private link resources
type ManagedInstancePrivateLinkListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstancePrivateLink `json:"value,omitempty" azure:"ro"`
}

// ManagedInstancePrivateLinkProperties - Properties of a private link resource.
type ManagedInstancePrivateLinkProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// ManagedInstancePrivateLinkResourcesClientGetOptions contains the optional parameters for the ManagedInstancePrivateLinkResourcesClient.Get
// method.
type ManagedInstancePrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstancePrivateLinkResourcesClientListByManagedInstanceOptions contains the optional parameters for the ManagedInstancePrivateLinkResourcesClient.ListByManagedInstance
// method.
type ManagedInstancePrivateLinkResourcesClientListByManagedInstanceOptions struct {
	// placeholder for future optional parameters
}

type ManagedInstancePrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; The private link service connection description.
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ManagedInstanceProperties - The properties of a managed instance.
type ManagedInstanceProperties struct {
	// Administrator username for the managed instance. Can only be specified when the managed instance is being created (and
	// is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// The administrator login password (required for managed instance creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// The Azure Active Directory administrator of the server.
	Administrators *ManagedInstanceExternalAdministrator `json:"administrators,omitempty"`

	// Collation of the managed instance.
	Collation *string `json:"collation,omitempty"`

	// The resource id of another managed instance whose DNS zone this managed instance will share after creation.
	DNSZonePartner *string `json:"dnsZonePartner,omitempty"`

	// The Id of the instance pool this managed server belongs to.
	InstancePoolID *string `json:"instancePoolId,omitempty"`

	// A CMK URI of the key to use for encryption.
	KeyID *string `json:"keyId,omitempty"`

	// The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice'
	// (discounted AHB price for bringing your own SQL licenses).
	LicenseType *ManagedInstanceLicenseType `json:"licenseType,omitempty"`

	// Specifies maintenance configuration id to apply to this managed instance.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`

	// Specifies the mode of database creation.
	// Default: Regular instance creation.
	// Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId
	// must be specified.
	ManagedInstanceCreateMode *ManagedServerCreateMode `json:"managedInstanceCreateMode,omitempty"`

	// Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`

	// The resource id of a user assigned identity to be used by default.
	PrimaryUserAssignedIdentityID *string `json:"primaryUserAssignedIdentityId,omitempty"`

	// Connection type used for connecting to the instance.
	ProxyOverride *ManagedInstanceProxyOverride `json:"proxyOverride,omitempty"`

	// Whether or not the public data endpoint is enabled.
	PublicDataEndpointEnabled *bool `json:"publicDataEndpointEnabled,omitempty"`

	// The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage),
	// Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and
	// GeoZone(GeoZoneRedundantStorage)
	RequestedBackupStorageRedundancy *BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`

	// Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *time.Time `json:"restorePointInTime,omitempty"`

	// The managed instance's service principal.
	ServicePrincipal *ServicePrincipal `json:"servicePrincipal,omitempty"`

	// The resource identifier of the source managed instance associated with create operation of this instance.
	SourceManagedInstanceID *string `json:"sourceManagedInstanceId,omitempty"`

	// Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB allowed only.
	StorageSizeInGB *int32 `json:"storageSizeInGB,omitempty"`

	// Subnet resource ID for the managed instance.
	SubnetID *string `json:"subnetId,omitempty"`

	// Id of the timezone. Allowed values are timezones supported by Windows. Windows keeps details on supported timezones, including
	// the id, in registry under KEYLOCALMACHINE\SOFTWARE\Microsoft\Windows
	// NT\CurrentVersion\Time Zones. You can get those registry values via SQL Server by querying SELECT name AS timezoneid FROM
	// sys.timezone_info. List of Ids can also be obtained by executing
	// [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. An example of valid timezone id is "Pacific Standard Time" or
	// "W. Europe Standard Time".
	TimezoneID *string `json:"timezoneId,omitempty"`

	// The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
	VCores *int32 `json:"vCores,omitempty"`

	// Whether or not the multi-az is enabled.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The storage account type used to store backups for this instance. The options are Local (LocallyRedundantStorage),
	// Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and
	// GeoZone(GeoZoneRedundantStorage)
	CurrentBackupStorageRedundancy *BackupStorageRedundancy `json:"currentBackupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; The Dns Zone that the managed instance is in.
	DNSZone *string `json:"dnsZone,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified domain name of the managed instance.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections on a managed instance.
	PrivateEndpointConnections []*ManagedInstancePecProperty `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY
	ProvisioningState *ManagedInstancePropertiesProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The state of the managed instance.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ManagedInstanceQuery - Database query.
type ManagedInstanceQuery struct {
	// Resource properties.
	Properties *QueryProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceQueryStatistics - Execution statistics for one particular query
type ManagedInstanceQueryStatistics struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*QueryStatistics `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceTdeCertificatesClientBeginCreateOptions contains the optional parameters for the ManagedInstanceTdeCertificatesClient.BeginCreate
// method.
type ManagedInstanceTdeCertificatesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstanceUpdate - An update request for an Azure SQL Database managed instance.
type ManagedInstanceUpdate struct {
	// Managed instance identity
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *ManagedInstanceProperties `json:"properties,omitempty"`

	// Managed instance sku
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ManagedInstanceVcoresCapability - The managed instance virtual cores capability.
type ManagedInstanceVcoresCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; Included size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty" azure:"ro"`

	// READ-ONLY; True if this service objective is supported for managed instances in an instance pool.
	InstancePoolSupported *bool `json:"instancePoolSupported,omitempty" azure:"ro"`

	// READ-ONLY; The virtual cores identifier.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; True if this service objective is supported for standalone managed instances.
	StandaloneSupported *bool `json:"standaloneSupported,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; List of supported maintenance configurations
	SupportedMaintenanceConfigurations []*ManagedInstanceMaintenanceConfigurationCapability `json:"supportedMaintenanceConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; Storage size ranges.
	SupportedStorageSizes []*MaxSizeRangeCapability `json:"supportedStorageSizes,omitempty" azure:"ro"`

	// READ-ONLY; The virtual cores value.
	Value *int32 `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceVersionCapability - The managed instance capability
type ManagedInstanceVersionCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The server version name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported managed instance editions.
	SupportedEditions []*ManagedInstanceEditionCapability `json:"supportedEditions,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported instance pool editions.
	SupportedInstancePoolEditions []*InstancePoolEditionCapability `json:"supportedInstancePoolEditions,omitempty" azure:"ro"`
}

// ManagedInstanceVulnerabilityAssessment - A managed instance vulnerability assessment.
type ManagedInstanceVulnerabilityAssessment struct {
	// Resource properties.
	Properties *ManagedInstanceVulnerabilityAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedInstanceVulnerabilityAssessmentListResult - A list of the ManagedInstance's vulnerability assessments.
type ManagedInstanceVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedInstanceVulnerabilityAssessment `json:"value,omitempty" azure:"ro"`
}

// ManagedInstanceVulnerabilityAssessmentProperties - Properties of a managed instance vulnerability assessment.
type ManagedInstanceVulnerabilityAssessmentProperties struct {
	// REQUIRED; A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`

	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required. Applies only if the
	// storage account is not behind a Vnet or a firewall
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter.
	// If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
	// required. Applies only if the storage account is not behind a Vnet or a firewall
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
}

// ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
type ManagedInstanceVulnerabilityAssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.Delete
// method.
type ManagedInstanceVulnerabilityAssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.Get
// method.
type ManagedInstanceVulnerabilityAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstanceVulnerabilityAssessmentsClientListByInstanceOptions contains the optional parameters for the ManagedInstanceVulnerabilityAssessmentsClient.ListByInstance
// method.
type ManagedInstanceVulnerabilityAssessmentsClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedInstancesClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedInstancesClient.BeginCreateOrUpdate
// method.
type ManagedInstancesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstancesClientBeginDeleteOptions contains the optional parameters for the ManagedInstancesClient.BeginDelete method.
type ManagedInstancesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstancesClientBeginFailoverOptions contains the optional parameters for the ManagedInstancesClient.BeginFailover
// method.
type ManagedInstancesClientBeginFailoverOptions struct {
	// The type of replica to be failed over.
	ReplicaType *ReplicaType
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstancesClientBeginUpdateOptions contains the optional parameters for the ManagedInstancesClient.BeginUpdate method.
type ManagedInstancesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedInstancesClientGetOptions contains the optional parameters for the ManagedInstancesClient.Get method.
type ManagedInstancesClientGetOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ManagedInstancesClientListByInstancePoolOptions contains the optional parameters for the ManagedInstancesClient.ListByInstancePool
// method.
type ManagedInstancesClientListByInstancePoolOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ManagedInstancesClientListByManagedInstanceOptions contains the optional parameters for the ManagedInstancesClient.ListByManagedInstance
// method.
type ManagedInstancesClientListByManagedInstanceOptions struct {
	// Aggregation function to be used, default value is 'sum'
	AggregationFunction *AggregationFunctionType
	// Comma separated list of databases to be included into search. All DB's are included if this parameter is not specified.
	Databases *string
	// End time for observed period.
	EndTime *string
	// The time step to be used to summarize the metric values. Default value is PT1H
	Interval *QueryTimeGrainType
	// How many 'top queries' to return. Default is 5.
	NumberOfQueries *int32
	// Metric to be used for ranking top queries. Default is 'cpu'
	ObservationMetric *MetricType
	// Start time for observed period.
	StartTime *string
}

// ManagedInstancesClientListByResourceGroupOptions contains the optional parameters for the ManagedInstancesClient.ListByResourceGroup
// method.
type ManagedInstancesClientListByResourceGroupOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ManagedInstancesClientListOptions contains the optional parameters for the ManagedInstancesClient.List method.
type ManagedInstancesClientListOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions contains the optional
// parameters for the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginCreateOrUpdate method.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientBeginUpdateOptions contains the optional parameters
// for the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.BeginUpdate method.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientGetOptions contains the optional parameters for the
// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.Get method.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseOptions contains the
// optional parameters for the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient.ListByRestorableDroppedDatabase
// method.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientListByRestorableDroppedDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ManagedServerSecurityAlertPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedServerSecurityAlertPoliciesClient.BeginCreateOrUpdate
// method.
type ManagedServerSecurityAlertPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedServerSecurityAlertPoliciesClientGetOptions contains the optional parameters for the ManagedServerSecurityAlertPoliciesClient.Get
// method.
type ManagedServerSecurityAlertPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedServerSecurityAlertPoliciesClientListByInstanceOptions contains the optional parameters for the ManagedServerSecurityAlertPoliciesClient.ListByInstance
// method.
type ManagedServerSecurityAlertPoliciesClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ManagedServerSecurityAlertPolicy - A managed server security alert policy.
type ManagedServerSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertsPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of SecurityAlertPolicyResource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedServerSecurityAlertPolicyListResult - A list of the managed Server's security alert policies.
type ManagedServerSecurityAlertPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedServerSecurityAlertPolicy `json:"value,omitempty" azure:"ro"`
}

// ManagedTransparentDataEncryption - A managed database transparent data encryption state.
type ManagedTransparentDataEncryption struct {
	// Resource properties.
	Properties *ManagedTransparentDataEncryptionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedTransparentDataEncryptionListResult - A list of managed transparent data encryptions
type ManagedTransparentDataEncryptionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ManagedTransparentDataEncryption `json:"value,omitempty" azure:"ro"`
}

// ManagedTransparentDataEncryptionProperties - Properties of a transparent data encryption.
type ManagedTransparentDataEncryptionProperties struct {
	// REQUIRED; Specifies the state of the transparent data encryption.
	State *TransparentDataEncryptionState `json:"state,omitempty"`
}

// MaxSizeCapability - The maximum size capability.
type MaxSizeCapability struct {
	// READ-ONLY; The maximum size limit (see 'unit' for the units).
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The units that the limit is expressed in.
	Unit *MaxSizeUnit `json:"unit,omitempty" azure:"ro"`
}

// MaxSizeRangeCapability - The maximum size range capability.
type MaxSizeRangeCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; Size of transaction log.
	LogSize *LogSizeCapability `json:"logSize,omitempty" azure:"ro"`

	// READ-ONLY; Maximum value.
	MaxValue *MaxSizeCapability `json:"maxValue,omitempty" azure:"ro"`

	// READ-ONLY; Minimum value.
	MinValue *MaxSizeCapability `json:"minValue,omitempty" azure:"ro"`

	// READ-ONLY; Scale/step size for discrete values between the minimum value and the maximum value.
	ScaleSize *MaxSizeCapability `json:"scaleSize,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`
}

// Metric - Database metrics.
type Metric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues []*MetricValue `json:"metricValues,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The time step to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitType `json:"unit,omitempty" azure:"ro"`
}

// MetricAvailability - A metric availability value.
type MetricAvailability struct {
	// READ-ONLY; The length of retention for the database metric.
	Retention *string `json:"retention,omitempty" azure:"ro"`

	// READ-ONLY; The granularity of the database metric.
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`
}

// MetricDefinition - A database metric definition.
type MetricDefinition struct {
	// READ-ONLY; The list of database metric availabilities for the metric.
	MetricAvailabilities []*MetricAvailability `json:"metricAvailabilities,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The primary aggregation type defining how metric values are displayed.
	PrimaryAggregationType *PrimaryAggregationType `json:"primaryAggregationType,omitempty" azure:"ro"`

	// READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *UnitDefinitionType `json:"unit,omitempty" azure:"ro"`
}

// MetricDefinitionListResult - The response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	// REQUIRED; The list of metric definitions for the database.
	Value []*MetricDefinition `json:"value,omitempty"`
}

// MetricListResult - The response to a list database metrics request.
type MetricListResult struct {
	// REQUIRED; The list of metrics for the database.
	Value []*Metric `json:"value,omitempty"`
}

// MetricName - A database metric name.
type MetricName struct {
	// READ-ONLY; The friendly name of the database metric.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database metric.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// MetricValue - Represents database metrics.
type MetricValue struct {
	// READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty" azure:"ro"`

	// READ-ONLY; The number of values for the metric.
	Count *int32 `json:"count,omitempty" azure:"ro"`

	// READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty" azure:"ro"`

	// READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty" azure:"ro"`

	// READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty" azure:"ro"`
}

// MinCapacityCapability - The min capacity capability
type MinCapacityCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Min capacity value
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// Name - ARM Usage Name
type Name struct {
	// Usage name localized value.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// Usage name value
	Value *string `json:"value,omitempty"`
}

// NetworkIsolationSettings - Contains the ARM resources for which to create private endpoint connection.
type NetworkIsolationSettings struct {
	// The resource id for the SQL server which is the target of this request. If set, private endpoint connection will be created
	// for the SQL server. Must match server which is target of the operation.
	SQLServerResourceID *string `json:"sqlServerResourceId,omitempty"`

	// The resource id for the storage account used to store BACPAC file. If set, private endpoint connection will be created
	// for the storage account. Must match storage account used for StorageUri
	// parameter.
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
}

// Operation - SQL REST API operation definition.
type Operation struct {
	// READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationImpact - The impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	// READ-ONLY; The absolute impact to dimension.
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty" azure:"ro"`

	// READ-ONLY; The relative impact to dimension (null if not applicable)
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty" azure:"ro"`

	// READ-ONLY; The name of the impact dimension.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The unit in which estimated impact to dimension is measured.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list SQL operations.
type OperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutboundFirewallRule - An Azure SQL DB Server Outbound Firewall Rule.
type OutboundFirewallRule struct {
	// Resource properties.
	Properties *OutboundFirewallRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OutboundFirewallRuleListResult - A list of outbound rules.
type OutboundFirewallRuleListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*OutboundFirewallRule `json:"value,omitempty" azure:"ro"`
}

// OutboundFirewallRuleProperties - The properties of an outbound firewall rule.
type OutboundFirewallRuleProperties struct {
	// READ-ONLY; The state of the outbound rule.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// OutboundFirewallRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the OutboundFirewallRulesClient.BeginCreateOrUpdate
// method.
type OutboundFirewallRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OutboundFirewallRulesClientBeginDeleteOptions contains the optional parameters for the OutboundFirewallRulesClient.BeginDelete
// method.
type OutboundFirewallRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OutboundFirewallRulesClientGetOptions contains the optional parameters for the OutboundFirewallRulesClient.Get method.
type OutboundFirewallRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// OutboundFirewallRulesClientListByServerOptions contains the optional parameters for the OutboundFirewallRulesClient.ListByServer
// method.
type OutboundFirewallRulesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// PartnerInfo - Partner server information for the failover group.
type PartnerInfo struct {
	// REQUIRED; Resource identifier of the partner server.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Geo location of the partner server.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Replication role of the partner server.
	ReplicationRole *FailoverGroupReplicationRole `json:"replicationRole,omitempty" azure:"ro"`
}

// PartnerRegionInfo - Partner region information for the failover group.
type PartnerRegionInfo struct {
	// Geo location of the partner managed instances.
	Location *string `json:"location,omitempty"`

	// READ-ONLY; Replication role of the partner managed instances.
	ReplicationRole *InstanceFailoverGroupReplicationRole `json:"replicationRole,omitempty" azure:"ro"`
}

// PerformanceLevelCapability - The performance level capability.
type PerformanceLevelCapability struct {
	// READ-ONLY; Unit type used to measure performance level.
	Unit *PerformanceLevelUnit `json:"unit,omitempty" azure:"ro"`

	// READ-ONLY; Performance level value.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *PrivateEndpointProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionRequestStatus - Contains the private endpoint connection requests status.
type PrivateEndpointConnectionRequestStatus struct {
	// READ-ONLY; The connection name for the private endpoint.
	PrivateEndpointConnectionName *string `json:"privateEndpointConnectionName,omitempty" azure:"ro"`

	// READ-ONLY; Resource id for which the private endpoint is created.
	PrivateLinkServiceID *string `json:"privateLinkServiceId,omitempty" azure:"ro"`

	// READ-ONLY; Status of this private endpoint connection.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByServerOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByServer
// method.
type PrivateEndpointConnectionsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource group id.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource `json:"value,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required zone names.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByServerOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByServer
// method.
type PrivateLinkResourcesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

type PrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The private link service connection status.
	Status *PrivateLinkServiceConnectionStateStatus `json:"status,omitempty"`

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *PrivateLinkServiceConnectionStateActionsRequire `json:"actionsRequired,omitempty" azure:"ro"`
}

// ProxyResource - ARM proxy resource.
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProxyResourceWithWritableName - ARM proxy resource.
type ProxyResourceWithWritableName struct {
	// Resource name.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueryMetricInterval - Properties of a query metrics interval.
type QueryMetricInterval struct {
	// List of metric objects for this interval
	Metrics []*QueryMetricProperties `json:"metrics,omitempty"`

	// READ-ONLY; Execution count of a query in this interval.
	ExecutionCount *int64 `json:"executionCount,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric interval (ISO-8601 format).
	IntervalStartTime *string `json:"intervalStartTime,omitempty" azure:"ro"`

	// READ-ONLY; Interval type (length).
	IntervalType *QueryTimeGrainType `json:"intervalType,omitempty" azure:"ro"`
}

// QueryMetricProperties - Properties of a topquery metric in one interval.
type QueryMetricProperties struct {
	// READ-ONLY; Metric value when avg() aggregate function is used over the interval.
	Avg *float64 `json:"avg,omitempty" azure:"ro"`

	// READ-ONLY; The UI appropriate name for the metric.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Metric value when max() aggregate function is used over the interval.
	Max *float64 `json:"max,omitempty" azure:"ro"`

	// READ-ONLY; Metric value when min() aggregate function is used over the interval.
	Min *float64 `json:"min,omitempty" azure:"ro"`

	// READ-ONLY; The name information for the metric.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metric value when stdev aggregate function is used over the interval.
	Stdev *float64 `json:"stdev,omitempty" azure:"ro"`

	// READ-ONLY; Metric value when sum() aggregate function is used over the interval.
	Sum *float64 `json:"sum,omitempty" azure:"ro"`

	// READ-ONLY; The unit of the metric.
	Unit *QueryMetricUnitType `json:"unit,omitempty" azure:"ro"`

	// READ-ONLY; The value of the metric.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// QueryProperties - Properties of a database query.
type QueryProperties struct {
	// Query text.
	QueryText *string `json:"queryText,omitempty"`
}

type QueryStatistics struct {
	// Resource properties.
	Properties *QueryStatisticsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueryStatisticsProperties - Properties of a query execution statistics.
type QueryStatisticsProperties struct {
	// List of intervals with appropriate metric data
	Intervals []*QueryMetricInterval `json:"intervals,omitempty"`

	// READ-ONLY; Database name of the database in which this query was executed.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *string `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Unique query id (unique within one database).
	QueryID *string `json:"queryId,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *string `json:"startTime,omitempty" azure:"ro"`
}

// ReadScaleCapability - The read scale capability.
type ReadScaleCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The maximum number of read scale replicas.
	MaxNumberOfReplicas *int32 `json:"maxNumberOfReplicas,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`
}

// RecommendedAction - Database, Server or Elastic Pool Recommended Action.
type RecommendedAction struct {
	// Resource properties.
	Properties *RecommendedActionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendedActionErrorInfo - Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended Action.
type RecommendedActionErrorInfo struct {
	// READ-ONLY; Gets the reason why the recommended action was put to error state. e.g., DatabaseHasQdsOff, IndexAlreadyExists
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No
	IsRetryable *IsRetryable `json:"isRetryable,omitempty" azure:"ro"`
}

// RecommendedActionImpactRecord - Contains information of estimated or observed impact on various metrics for an Azure SQL
// Database, Server or Elastic Pool Recommended Action.
type RecommendedActionImpactRecord struct {
	// READ-ONLY; Gets the absolute value of this dimension if applicable. e.g., Number of Queries affected
	AbsoluteValue *float64 `json:"absoluteValue,omitempty" azure:"ro"`

	// READ-ONLY; Gets the absolute change in the value of this dimension. e.g., Absolute Disk space change in Megabytes
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty" azure:"ro"`

	// READ-ONLY; Gets the relative change in the value of this dimension. e.g., Relative Disk space change in Percentage
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
	DimensionName *string `json:"dimensionName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange, NumberOfQueriesAffected.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// RecommendedActionImplementationInfo - Contains information for manual implementation for an Azure SQL Database, Server
// or Elastic Pool Recommended Action.
type RecommendedActionImplementationInfo struct {
	// READ-ONLY; Gets the method in which this recommended action can be manually implemented. e.g., TSql, AzurePowerShell.
	Method *ImplementationMethod `json:"method,omitempty" azure:"ro"`

	// READ-ONLY; Gets the manual implementation script. e.g., T-SQL script that could be executed on the database.
	Script *string `json:"script,omitempty" azure:"ro"`
}

// RecommendedActionMetricInfo - Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic
// Pool Recommended Action.
type RecommendedActionMetricInfo struct {
	// READ-ONLY; Gets the name of the metric. e.g., CPU, Number of Queries.
	MetricName *string `json:"metricName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time of time interval given by this MetricInfo.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the duration of time interval for the value given by this MetricInfo. e.g., PT1H (1 hour)
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`

	// READ-ONLY; Gets the unit in which metric is measured. e.g., DTU, Frequency
	Unit *string `json:"unit,omitempty" azure:"ro"`

	// READ-ONLY; Gets the value of the metric in the time interval given by this MetricInfo.
	Value *float64 `json:"value,omitempty" azure:"ro"`
}

// RecommendedActionProperties - Properties for a Database, Server or Elastic Pool Recommended Action.
type RecommendedActionProperties struct {
	// REQUIRED; Gets the info of the current state the recommended action is in.
	State *RecommendedActionStateInfo `json:"state,omitempty"`

	// READ-ONLY; Gets additional details specific to this recommended action.
	Details map[string]interface{} `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error details if and why this recommended action is put to error state.
	ErrorDetails *RecommendedActionErrorInfo `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; Gets the estimated impact info for this recommended action e.g., Estimated CPU gain, Estimated Disk Space change
	EstimatedImpact []*RecommendedActionImpactRecord `json:"estimatedImpact,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time taken for applying this recommended action on user resource. e.g., time taken for index creation
	ExecuteActionDuration *string `json:"executeActionDuration,omitempty" azure:"ro"`

	// READ-ONLY; Gets if approval for applying this recommended action was given by user/system.
	ExecuteActionInitiatedBy *RecommendedActionInitiatedBy `json:"executeActionInitiatedBy,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time when this recommended action was approved for execution.
	ExecuteActionInitiatedTime *time.Time `json:"executeActionInitiatedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time when system started applying this recommended action on the user resource. e.g., index creation
	// start time
	ExecuteActionStartTime *time.Time `json:"executeActionStartTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the implementation details of this recommended action for user to apply it manually.
	ImplementationDetails *RecommendedActionImplementationInfo `json:"implementationDetails,omitempty" azure:"ro"`

	// READ-ONLY; Gets if this recommended action was suggested some time ago but user chose to ignore this and system added a
	// new recommended action again.
	IsArchivedAction *bool `json:"isArchivedAction,omitempty" azure:"ro"`

	// READ-ONLY; Gets if this recommended action is actionable by user
	IsExecutableAction *bool `json:"isExecutableAction,omitempty" azure:"ro"`

	// READ-ONLY; Gets if changes applied by this recommended action can be reverted by user
	IsRevertableAction *bool `json:"isRevertableAction,omitempty" azure:"ro"`

	// READ-ONLY; Gets time when this recommended action was last refreshed.
	LastRefresh *time.Time `json:"lastRefresh,omitempty" azure:"ro"`

	// READ-ONLY; Gets the linked objects, if any.
	LinkedObjects []*string `json:"linkedObjects,omitempty" azure:"ro"`

	// READ-ONLY; Gets the observed/actual impact info for this recommended action e.g., Actual CPU gain, Actual Disk Space change
	ObservedImpact []*RecommendedActionImpactRecord `json:"observedImpact,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reason for recommending this action. e.g., DuplicateIndex
	RecommendationReason *string `json:"recommendationReason,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time taken for reverting changes of this recommended action on user resource. e.g., time taken for
	// dropping the created index.
	RevertActionDuration *string `json:"revertActionDuration,omitempty" azure:"ro"`

	// READ-ONLY; Gets if approval for reverting this recommended action was given by user/system.
	RevertActionInitiatedBy *RecommendedActionInitiatedBy `json:"revertActionInitiatedBy,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time when this recommended action was approved for revert.
	RevertActionInitiatedTime *time.Time `json:"revertActionInitiatedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time when system started reverting changes of this recommended action on user resource. e.g., time
	// when index drop is executed.
	RevertActionStartTime *time.Time `json:"revertActionStartTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the impact of this recommended action. Possible values are 1 - Low impact, 2 - Medium Impact and 3 - High
	// Impact
	Score *int32 `json:"score,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time series info of metrics for this recommended action e.g., CPU consumption time series
	TimeSeries []*RecommendedActionMetricInfo `json:"timeSeries,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time since when this recommended action is valid.
	ValidSince *time.Time `json:"validSince,omitempty" azure:"ro"`
}

// RecommendedActionStateInfo - Contains information of current state for an Azure SQL Database, Server or Elastic Pool Recommended
// Action.
type RecommendedActionStateInfo struct {
	// REQUIRED; Current state the recommended action is in. Some commonly used states are: Active -> recommended action is active
	// and no action has been taken yet. Pending -> recommended action is approved for and is
	// awaiting execution. Executing -> recommended action is being applied on the user database. Verifying -> recommended action
	// was applied and is being verified of its usefulness by the system. Success ->
	// recommended action was applied and improvement found during verification. Pending Revert -> verification found little or
	// no improvement so recommended action is queued for revert or user has manually
	// reverted. Reverting -> changes made while applying recommended action are being reverted on the user database. Reverted
	// -> successfully reverted the changes made by recommended action on user
	// database. Ignored -> user explicitly ignored/discarded the recommended action.
	CurrentValue *RecommendedActionCurrentState `json:"currentValue,omitempty"`

	// READ-ONLY; Gets who initiated the execution of this recommended action. Possible Value are: User -> When user explicity
	// notified system to apply the recommended action. System -> When auto-execute status of this
	// advisor was set to 'Enabled', in which case the system applied it.
	ActionInitiatedBy *RecommendedActionInitiatedBy `json:"actionInitiatedBy,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time when the state was last modified
	LastModified *time.Time `json:"lastModified,omitempty" azure:"ro"`
}

// RecommendedSensitivityLabelUpdate - A recommended sensitivity label update operation.
type RecommendedSensitivityLabelUpdate struct {
	// Resource properties.
	Properties *RecommendedSensitivityLabelUpdateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendedSensitivityLabelUpdateList - A list of recommended sensitivity label update operations.
type RecommendedSensitivityLabelUpdateList struct {
	Operations []*RecommendedSensitivityLabelUpdate `json:"operations,omitempty"`
}

// RecommendedSensitivityLabelUpdateProperties - Properties of an operation executed on a recommended sensitivity label.
type RecommendedSensitivityLabelUpdateProperties struct {
	// REQUIRED; Column name to update.
	Column *string `json:"column,omitempty"`

	// REQUIRED
	Op *RecommendedSensitivityLabelUpdateKind `json:"op,omitempty"`

	// REQUIRED; Schema name of the column to update.
	Schema *string `json:"schema,omitempty"`

	// REQUIRED; Table name of the column to update.
	Table *string `json:"table,omitempty"`
}

// RecommendedSensitivityLabelsClientUpdateOptions contains the optional parameters for the RecommendedSensitivityLabelsClient.Update
// method.
type RecommendedSensitivityLabelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// RecoverableDatabase - A recoverable database
type RecoverableDatabase struct {
	// The properties of a recoverable database
	Properties *RecoverableDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoverableDatabaseListResult - The response to a list recoverable databases request
type RecoverableDatabaseListResult struct {
	// REQUIRED; A list of recoverable databases
	Value []*RecoverableDatabase `json:"value,omitempty"`
}

// RecoverableDatabaseProperties - The properties of a recoverable database
type RecoverableDatabaseProperties struct {
	// READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty" azure:"ro"`

	// READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty" azure:"ro"`

	// READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *time.Time `json:"lastAvailableBackupDate,omitempty" azure:"ro"`

	// READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty" azure:"ro"`
}

// RecoverableDatabasesClientGetOptions contains the optional parameters for the RecoverableDatabasesClient.Get method.
type RecoverableDatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecoverableDatabasesClientListByServerOptions contains the optional parameters for the RecoverableDatabasesClient.ListByServer
// method.
type RecoverableDatabasesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// RecoverableManagedDatabase - A recoverable managed database resource.
type RecoverableManagedDatabase struct {
	// Resource properties.
	Properties *RecoverableManagedDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecoverableManagedDatabaseListResult - A list of recoverable managed databases.
type RecoverableManagedDatabaseListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*RecoverableManagedDatabase `json:"value,omitempty" azure:"ro"`
}

// RecoverableManagedDatabaseProperties - The recoverable managed database's properties.
type RecoverableManagedDatabaseProperties struct {
	// READ-ONLY; The last available backup date.
	LastAvailableBackupDate *string `json:"lastAvailableBackupDate,omitempty" azure:"ro"`
}

// RecoverableManagedDatabasesClientGetOptions contains the optional parameters for the RecoverableManagedDatabasesClient.Get
// method.
type RecoverableManagedDatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RecoverableManagedDatabasesClientListByInstanceOptions contains the optional parameters for the RecoverableManagedDatabasesClient.ListByInstance
// method.
type RecoverableManagedDatabasesClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ReplicationLink - A replication link.
type ReplicationLink struct {
	// Resource properties.
	Properties *ReplicationLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicationLinkListResult - A list of replication links.
type ReplicationLinkListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ReplicationLink `json:"value,omitempty" azure:"ro"`
}

// ReplicationLinkProperties - Properties of a replication link.
type ReplicationLinkProperties struct {
	// READ-ONLY; Whether the user is currently allowed to terminate the link.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty" azure:"ro"`

	// READ-ONLY; Link type (GEO, NAMED).
	LinkType *ReplicationLinkType `json:"linkType,omitempty" azure:"ro"`

	// READ-ONLY; Resource partner database.
	PartnerDatabase *string `json:"partnerDatabase,omitempty" azure:"ro"`

	// READ-ONLY; Resource partner location.
	PartnerLocation *string `json:"partnerLocation,omitempty" azure:"ro"`

	// READ-ONLY; Partner replication role.
	PartnerRole *ReplicationRole `json:"partnerRole,omitempty" azure:"ro"`

	// READ-ONLY; Resource partner server.
	PartnerServer *string `json:"partnerServer,omitempty" azure:"ro"`

	// READ-ONLY; Seeding completion percentage for the link.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; Replication mode.
	ReplicationMode *string `json:"replicationMode,omitempty" azure:"ro"`

	// READ-ONLY; Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED).
	ReplicationState *ReplicationState `json:"replicationState,omitempty" azure:"ro"`

	// READ-ONLY; Local replication role.
	Role *ReplicationRole `json:"role,omitempty" azure:"ro"`

	// READ-ONLY; Time at which the link was created.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// ReplicationLinksClientBeginFailoverAllowDataLossOptions contains the optional parameters for the ReplicationLinksClient.BeginFailoverAllowDataLoss
// method.
type ReplicationLinksClientBeginFailoverAllowDataLossOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationLinksClientBeginFailoverOptions contains the optional parameters for the ReplicationLinksClient.BeginFailover
// method.
type ReplicationLinksClientBeginFailoverOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ReplicationLinksClientDeleteOptions contains the optional parameters for the ReplicationLinksClient.Delete method.
type ReplicationLinksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ReplicationLinksClientGetOptions contains the optional parameters for the ReplicationLinksClient.Get method.
type ReplicationLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReplicationLinksClientListByDatabaseOptions contains the optional parameters for the ReplicationLinksClient.ListByDatabase
// method.
type ReplicationLinksClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// ReplicationLinksClientListByServerOptions contains the optional parameters for the ReplicationLinksClient.ListByServer
// method.
type ReplicationLinksClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// Resource - ARM resource.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceIdentity - Azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal
	// for the resource.
	Type *IdentityType `json:"type,omitempty"`

	// The resource ids of the user assigned identities to use
	UserAssignedIdentities map[string]*UserIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory tenant id.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ResourceMoveDefinition - Contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// REQUIRED; The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// ResourceWithWritableName - ARM resource.
type ResourceWithWritableName struct {
	// Resource name.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableDroppedDatabase - A restorable dropped database resource.
type RestorableDroppedDatabase struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *RestorableDroppedDatabaseProperties `json:"properties,omitempty"`

	// The name and tier of the SKU.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableDroppedDatabaseListResult - A list of restorable dropped databases.
type RestorableDroppedDatabaseListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*RestorableDroppedDatabase `json:"value,omitempty" azure:"ro"`
}

// RestorableDroppedDatabaseProperties - The restorable dropped database's properties.
type RestorableDroppedDatabaseProperties struct {
	// READ-ONLY; The storage account type used to store backups for this database.
	BackupStorageRedundancy *BackupStorageRedundancy `json:"backupStorageRedundancy,omitempty" azure:"ro"`

	// READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The deletion date of the database (ISO8601 format).
	DeletionDate *time.Time `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; The earliest restore date of the database (ISO8601 format).
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`

	// READ-ONLY; The max size of the database expressed in bytes.
	MaxSizeBytes *int64 `json:"maxSizeBytes,omitempty" azure:"ro"`
}

// RestorableDroppedDatabasesClientGetOptions contains the optional parameters for the RestorableDroppedDatabasesClient.Get
// method.
type RestorableDroppedDatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RestorableDroppedDatabasesClientListByServerOptions contains the optional parameters for the RestorableDroppedDatabasesClient.ListByServer
// method.
type RestorableDroppedDatabasesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// RestorableDroppedManagedDatabase - A restorable dropped managed database resource.
type RestorableDroppedManagedDatabase struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *RestorableDroppedManagedDatabaseProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorableDroppedManagedDatabaseListResult - A list of restorable dropped managed databases.
type RestorableDroppedManagedDatabaseListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*RestorableDroppedManagedDatabase `json:"value,omitempty" azure:"ro"`
}

// RestorableDroppedManagedDatabaseProperties - The restorable dropped managed database's properties.
type RestorableDroppedManagedDatabaseProperties struct {
	// READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; The deletion date of the database (ISO8601 format).
	DeletionDate *time.Time `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; The earliest restore date of the database (ISO8601 format).
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`
}

// RestorableDroppedManagedDatabasesClientGetOptions contains the optional parameters for the RestorableDroppedManagedDatabasesClient.Get
// method.
type RestorableDroppedManagedDatabasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RestorableDroppedManagedDatabasesClientListByInstanceOptions contains the optional parameters for the RestorableDroppedManagedDatabasesClient.ListByInstance
// method.
type RestorableDroppedManagedDatabasesClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// RestorePoint - Database restore points.
type RestorePoint struct {
	// Resource properties.
	Properties *RestorePointProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestorePointListResult - A list of long term retention backups.
type RestorePointListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*RestorePoint `json:"value,omitempty" azure:"ro"`
}

// RestorePointProperties - Properties of a database restore point
type RestorePointProperties struct {
	// READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *time.Time `json:"earliestRestoreDate,omitempty" azure:"ro"`

	// READ-ONLY; The time the backup was taken
	RestorePointCreationDate *time.Time `json:"restorePointCreationDate,omitempty" azure:"ro"`

	// READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty" azure:"ro"`

	// READ-ONLY; The type of restore point
	RestorePointType *RestorePointType `json:"restorePointType,omitempty" azure:"ro"`
}

// RestorePointsClientBeginCreateOptions contains the optional parameters for the RestorePointsClient.BeginCreate method.
type RestorePointsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RestorePointsClientDeleteOptions contains the optional parameters for the RestorePointsClient.Delete method.
type RestorePointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// RestorePointsClientGetOptions contains the optional parameters for the RestorePointsClient.Get method.
type RestorePointsClientGetOptions struct {
	// placeholder for future optional parameters
}

// RestorePointsClientListByDatabaseOptions contains the optional parameters for the RestorePointsClient.ListByDatabase method.
type RestorePointsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// SKU - An ARM Resource SKU.
type SKU struct {
	// REQUIRED; The name of the SKU, typically, a letter + Number code, e.g. P3.
	Name *string `json:"name,omitempty"`

	// Capacity of the particular SKU.
	Capacity *int32 `json:"capacity,omitempty"`

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// Size of the particular SKU
	Size *string `json:"size,omitempty"`

	// The tier or edition of the particular SKU, e.g. Basic, Premium.
	Tier *string `json:"tier,omitempty"`
}

// SecurityAlertPolicyProperties - Properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on
	// the specific database.
	State *SecurityAlertPolicyState `json:"state,omitempty"`

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly,
	// DataExfiltration, UnsafeAction, Brute_Force
	DisabledAlerts []*string `json:"disabledAlerts,omitempty"`

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string `json:"emailAddresses,omitempty"`

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`
}

// SecurityAlertsPolicyProperties - Properties of a security alert policy.
type SecurityAlertsPolicyProperties struct {
	// REQUIRED; Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on
	// the specific database.
	State *SecurityAlertsPolicyState `json:"state,omitempty"`

	// Specifies an array of alerts that are disabled. Allowed values are: SqlInjection, SqlInjectionVulnerability, AccessAnomaly,
	// DataExfiltration, UnsafeAction, Brute_Force
	DisabledAlerts []*string `json:"disabledAlerts,omitempty"`

	// Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses []*string `json:"emailAddresses,omitempty"`

	// Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat
	// Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`

	// READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`
}

// SecurityEvent - A security event.
type SecurityEvent struct {
	// Resource properties.
	Properties *SecurityEventProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityEventCollection - A list of security events.
type SecurityEventCollection struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SecurityEvent `json:"value,omitempty" azure:"ro"`
}

// SecurityEventProperties - The properties of a security event.
type SecurityEventProperties struct {
	// READ-ONLY; The application used to execute the statement.
	ApplicationName *string `json:"applicationName,omitempty" azure:"ro"`

	// READ-ONLY; The IP address of the client who executed the statement.
	ClientIP *string `json:"clientIp,omitempty" azure:"ro"`

	// READ-ONLY; The database name
	Database *string `json:"database,omitempty" azure:"ro"`

	// READ-ONLY; The time when the security event occurred.
	EventTime *time.Time `json:"eventTime,omitempty" azure:"ro"`

	// READ-ONLY; The principal user who executed the statement
	PrincipalName *string `json:"principalName,omitempty" azure:"ro"`

	// READ-ONLY; The sql injection additional properties, populated only if the type of the security event is sql injection.
	SecurityEventSQLInjectionAdditionalProperties *SecurityEventSQLInjectionAdditionalProperties `json:"securityEventSqlInjectionAdditionalProperties,omitempty" azure:"ro"`

	// READ-ONLY; The type of the security event.
	SecurityEventType *SecurityEventType `json:"securityEventType,omitempty" azure:"ro"`

	// READ-ONLY; The server name
	Server *string `json:"server,omitempty" azure:"ro"`

	// READ-ONLY; The subscription name
	Subscription *string `json:"subscription,omitempty" azure:"ro"`
}

// SecurityEventSQLInjectionAdditionalProperties - The properties of a security event sql injection additional properties.
type SecurityEventSQLInjectionAdditionalProperties struct {
	// READ-ONLY; The sql error code
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The sql error message
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The sql error severity
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The statement
	Statement *string `json:"statement,omitempty" azure:"ro"`

	// READ-ONLY; The statement highlight length
	StatementHighlightLength *int32 `json:"statementHighlightLength,omitempty" azure:"ro"`

	// READ-ONLY; The statement highlight offset
	StatementHighlightOffset *int32 `json:"statementHighlightOffset,omitempty" azure:"ro"`

	// READ-ONLY; The threat ID.
	ThreatID *string `json:"threatId,omitempty" azure:"ro"`
}

// SecurityEventsFilterParameters - The properties that are supported in the $filter operation.
type SecurityEventsFilterParameters struct {
	// Filter on the event time.
	EventTime *time.Time `json:"eventTime,omitempty"`

	// Whether to show server records or not.
	ShowServerRecords *bool `json:"showServerRecords,omitempty"`
}

// SensitivityLabel - A sensitivity label.
type SensitivityLabel struct {
	// Resource properties.
	Properties *SensitivityLabelProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource that manages the sensitivity label.
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SensitivityLabelListResult - A list of sensitivity labels.
type SensitivityLabelListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SensitivityLabel `json:"value,omitempty" azure:"ro"`
}

// SensitivityLabelProperties - Properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// The information type.
	InformationType *string `json:"informationType,omitempty"`

	// The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`

	// The label ID.
	LabelID *string `json:"labelId,omitempty"`

	// The label name.
	LabelName *string               `json:"labelName,omitempty"`
	Rank      *SensitivityLabelRank `json:"rank,omitempty"`

	// READ-ONLY; The column name.
	ColumnName *string `json:"columnName,omitempty" azure:"ro"`

	// READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether
	// the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool `json:"isDisabled,omitempty" azure:"ro"`

	// READ-ONLY; The schema name.
	SchemaName *string `json:"schemaName,omitempty" azure:"ro"`

	// READ-ONLY; The table name.
	TableName *string `json:"tableName,omitempty" azure:"ro"`
}

// SensitivityLabelUpdate - A sensitivity label update operation.
type SensitivityLabelUpdate struct {
	// Resource properties.
	Properties *SensitivityLabelUpdateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SensitivityLabelUpdateList - A list of sensitivity label update operations.
type SensitivityLabelUpdateList struct {
	Operations []*SensitivityLabelUpdate `json:"operations,omitempty"`
}

// SensitivityLabelUpdateProperties - Properties of an operation executed on a sensitivity label.
type SensitivityLabelUpdateProperties struct {
	// REQUIRED; Column name to update.
	Column *string `json:"column,omitempty"`

	// REQUIRED
	Op *SensitivityLabelUpdateKind `json:"op,omitempty"`

	// REQUIRED; Schema name of the column to update.
	Schema *string `json:"schema,omitempty"`

	// REQUIRED; Table name of the column to update.
	Table *string `json:"table,omitempty"`

	// The sensitivity label information to apply on a column.
	SensitivityLabel *SensitivityLabel `json:"sensitivityLabel,omitempty"`
}

// SensitivityLabelsClientCreateOrUpdateOptions contains the optional parameters for the SensitivityLabelsClient.CreateOrUpdate
// method.
type SensitivityLabelsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SensitivityLabelsClientDeleteOptions contains the optional parameters for the SensitivityLabelsClient.Delete method.
type SensitivityLabelsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SensitivityLabelsClientDisableRecommendationOptions contains the optional parameters for the SensitivityLabelsClient.DisableRecommendation
// method.
type SensitivityLabelsClientDisableRecommendationOptions struct {
	// placeholder for future optional parameters
}

// SensitivityLabelsClientEnableRecommendationOptions contains the optional parameters for the SensitivityLabelsClient.EnableRecommendation
// method.
type SensitivityLabelsClientEnableRecommendationOptions struct {
	// placeholder for future optional parameters
}

// SensitivityLabelsClientGetOptions contains the optional parameters for the SensitivityLabelsClient.Get method.
type SensitivityLabelsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SensitivityLabelsClientListCurrentByDatabaseOptions contains the optional parameters for the SensitivityLabelsClient.ListCurrentByDatabase
// method.
type SensitivityLabelsClientListCurrentByDatabaseOptions struct {
	Count *bool
	// An OData filter expression that filters elements in the collection.
	Filter    *string
	SkipToken *string
}

// SensitivityLabelsClientListRecommendedByDatabaseOptions contains the optional parameters for the SensitivityLabelsClient.ListRecommendedByDatabase
// method.
type SensitivityLabelsClientListRecommendedByDatabaseOptions struct {
	// An OData filter expression that filters elements in the collection.
	Filter *string
	// Specifies whether to include disabled recommendations or not.
	IncludeDisabledRecommendations *bool
	SkipToken                      *string
}

// SensitivityLabelsClientUpdateOptions contains the optional parameters for the SensitivityLabelsClient.Update method.
type SensitivityLabelsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Server - An Azure SQL Database server.
type Server struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *ServerProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of sql server. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAdvancedThreatProtection - A server Advanced Threat Protection.
type ServerAdvancedThreatProtection struct {
	// Resource properties.
	Properties *AdvancedThreatProtectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of AdvancedThreatProtectionResource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAdvancedThreatProtectionSettingsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerAdvancedThreatProtectionSettingsClient.BeginCreateOrUpdate
// method.
type ServerAdvancedThreatProtectionSettingsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAdvancedThreatProtectionSettingsClientGetOptions contains the optional parameters for the ServerAdvancedThreatProtectionSettingsClient.Get
// method.
type ServerAdvancedThreatProtectionSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerAdvancedThreatProtectionSettingsClientListByServerOptions contains the optional parameters for the ServerAdvancedThreatProtectionSettingsClient.ListByServer
// method.
type ServerAdvancedThreatProtectionSettingsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerAdvisorsClientGetOptions contains the optional parameters for the ServerAdvisorsClient.Get method.
type ServerAdvisorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerAdvisorsClientListByServerOptions contains the optional parameters for the ServerAdvisorsClient.ListByServer method.
type ServerAdvisorsClientListByServerOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ServerAdvisorsClientUpdateOptions contains the optional parameters for the ServerAdvisorsClient.Update method.
type ServerAdvisorsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServerAutomaticTuning - Server-level Automatic Tuning.
type ServerAutomaticTuning struct {
	// Resource properties.
	Properties *AutomaticTuningServerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAutomaticTuningClientGetOptions contains the optional parameters for the ServerAutomaticTuningClient.Get method.
type ServerAutomaticTuningClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerAutomaticTuningClientUpdateOptions contains the optional parameters for the ServerAutomaticTuningClient.Update method.
type ServerAutomaticTuningClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServerAzureADAdministrator - Azure Active Directory administrator.
type ServerAzureADAdministrator struct {
	// Resource properties.
	Properties *AdministratorProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAzureADAdministratorsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerAzureADAdministratorsClient.BeginCreateOrUpdate
// method.
type ServerAzureADAdministratorsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAzureADAdministratorsClientBeginDeleteOptions contains the optional parameters for the ServerAzureADAdministratorsClient.BeginDelete
// method.
type ServerAzureADAdministratorsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAzureADAdministratorsClientGetOptions contains the optional parameters for the ServerAzureADAdministratorsClient.Get
// method.
type ServerAzureADAdministratorsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerAzureADAdministratorsClientListByServerOptions contains the optional parameters for the ServerAzureADAdministratorsClient.ListByServer
// method.
type ServerAzureADAdministratorsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerAzureADOnlyAuthentication - Azure Active Directory only authentication.
type ServerAzureADOnlyAuthentication struct {
	// Resource properties.
	Properties *AzureADOnlyAuthProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerAzureADOnlyAuthenticationsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerAzureADOnlyAuthenticationsClient.BeginCreateOrUpdate
// method.
type ServerAzureADOnlyAuthenticationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAzureADOnlyAuthenticationsClientBeginDeleteOptions contains the optional parameters for the ServerAzureADOnlyAuthenticationsClient.BeginDelete
// method.
type ServerAzureADOnlyAuthenticationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerAzureADOnlyAuthenticationsClientGetOptions contains the optional parameters for the ServerAzureADOnlyAuthenticationsClient.Get
// method.
type ServerAzureADOnlyAuthenticationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerAzureADOnlyAuthenticationsClientListByServerOptions contains the optional parameters for the ServerAzureADOnlyAuthenticationsClient.ListByServer
// method.
type ServerAzureADOnlyAuthenticationsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerBlobAuditingPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerBlobAuditingPoliciesClient.BeginCreateOrUpdate
// method.
type ServerBlobAuditingPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerBlobAuditingPoliciesClientGetOptions contains the optional parameters for the ServerBlobAuditingPoliciesClient.Get
// method.
type ServerBlobAuditingPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerBlobAuditingPoliciesClientListByServerOptions contains the optional parameters for the ServerBlobAuditingPoliciesClient.ListByServer
// method.
type ServerBlobAuditingPoliciesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerBlobAuditingPolicy - A server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	// Resource properties.
	Properties *ServerBlobAuditingPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerBlobAuditingPolicyListResult - A list of server auditing settings.
type ServerBlobAuditingPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerBlobAuditingPolicy `json:"value,omitempty" azure:"ro"`
}

// ServerBlobAuditingPolicyProperties - Properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// REQUIRED; Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies the Actions-Groups and Actions to audit.
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures
	// executed against the database, as well as successful and failed logins:
	// BATCHCOMPLETEDGROUP, SUCCESSFULDATABASEAUTHENTICATIONGROUP, FAILEDDATABASEAUTHENTICATIONGROUP.
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary
	// groups could lead to very large quantities of audit records):
	// APPLICATIONROLECHANGEPASSWORDGROUP BACKUPRESTOREGROUP DATABASELOGOUTGROUP DATABASEOBJECTCHANGEGROUP DATABASEOBJECTOWNERSHIPCHANGEGROUP
	// DATABASEOBJECTPERMISSIONCHANGEGROUP DATABASEOPERATIONGROUP
	// DATABASEPERMISSIONCHANGEGROUP DATABASEPRINCIPALCHANGEGROUP DATABASEPRINCIPALIMPERSONATIONGROUP DATABASEROLEMEMBERCHANGEGROUP
	// FAILEDDATABASEAUTHENTICATIONGROUP SCHEMAOBJECTACCESSGROUP SCHEMAOBJECT
	// CHANGEGROUP SCHEMAOBJECTOWNERSHIPCHANGEGROUP SCHEMAOBJECTPERMISSIONCHANGEGROUP SUCCESSFULDATABASEAUTHENTICATIONGROUP USERCHANGEPASSWORDGROUP
	// BATCHSTARTEDGROUP BATCHCOMPLETEDGROUP DBCCGROUP DATABASE
	// OWNERSHIPCHANGEGROUP DATABASECHANGEGROUP LEDGEROPERATION_GROUP
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used
	// in combination with other groups as this will result in duplicate audit logs.
	// For more information, see Database-Level Audit Action Groups
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups].
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server
	// auditing policy). The supported actions to audit are: SELECT UPDATE INSERT DELETE
	// EXECUTE RECEIVE REFERENCES
	// The general form for defining an action to be audited is: {action} ON {object} BY {principal}
	// Note that in the above format can refer to an object like a table, view, or stored procedure, or an entire database or
	// schema. For the latter cases, the forms DATABASE::{dbname} and SCHEMA::{schema
	// name} are used, respectively.
	// For example: SELECT on dbo.myTable by public SELECT on DATABASE::myDatabase by public SELECT on SCHEMA::mySchema by public
	// For more information, see Database-Level Audit Actions
	// [https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions]
	AuditActionsAndGroups []*string `json:"auditActionsAndGroups,omitempty"`

	// Specifies whether audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify 'State'
	// as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on
	// the database should be also created. Note that for server level audit you
	// should use the 'master' database as {databaseName}.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies the state of devops audit. If state is Enabled, devops logs will be sent to Azure Monitor. In order to send the
	// events to Azure Monitor, specify 'State' as 'Enabled',
	// 'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true
	// When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category on
	// the master database should also be created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsDevopsAuditEnabled *bool `json:"isDevopsAuditEnabled,omitempty"`

	// Specifies whether Managed Identity is used to access blob storage
	IsManagedIdentityInUse *bool `json:"isManagedIdentityInUse,omitempty"`

	// Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`

	// Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed. The default
	// minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`

	// Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// ServerCommunicationLink - Server communication link.
type ServerCommunicationLink struct {
	// The properties of resource.
	Properties *ServerCommunicationLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Communication link kind. This property is used for Azure Portal metadata.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Communication link location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerCommunicationLinkListResult - A list of server communication links.
type ServerCommunicationLinkListResult struct {
	// The list of server communication links.
	Value []*ServerCommunicationLink `json:"value,omitempty"`
}

// ServerCommunicationLinkProperties - The properties of a server communication link.
type ServerCommunicationLinkProperties struct {
	// REQUIRED; The name of the partner server.
	PartnerServer *string `json:"partnerServer,omitempty"`

	// READ-ONLY; The state.
	State *string `json:"state,omitempty" azure:"ro"`
}

// ServerCommunicationLinksClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerCommunicationLinksClient.BeginCreateOrUpdate
// method.
type ServerCommunicationLinksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerCommunicationLinksClientDeleteOptions contains the optional parameters for the ServerCommunicationLinksClient.Delete
// method.
type ServerCommunicationLinksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServerCommunicationLinksClientGetOptions contains the optional parameters for the ServerCommunicationLinksClient.Get method.
type ServerCommunicationLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerCommunicationLinksClientListByServerOptions contains the optional parameters for the ServerCommunicationLinksClient.ListByServer
// method.
type ServerCommunicationLinksClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerConnectionPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerConnectionPoliciesClient.BeginCreateOrUpdate
// method.
type ServerConnectionPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerConnectionPoliciesClientGetOptions contains the optional parameters for the ServerConnectionPoliciesClient.Get method.
type ServerConnectionPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerConnectionPoliciesClientListByServerOptions contains the optional parameters for the ServerConnectionPoliciesClient.ListByServer
// method.
type ServerConnectionPoliciesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerConnectionPolicy - A server connection policy
type ServerConnectionPolicy struct {
	// Resource properties.
	Properties *ServerConnectionPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerConnectionPolicyListResult - A list of server connection policy objects.
type ServerConnectionPolicyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerConnectionPolicy `json:"value,omitempty" azure:"ro"`
}

// ServerConnectionPolicyProperties - The properties of a server connection policy.
type ServerConnectionPolicyProperties struct {
	// REQUIRED; The server connection type.
	ConnectionType *ServerConnectionType `json:"connectionType,omitempty"`
}

// ServerDNSAlias - A server DNS alias.
type ServerDNSAlias struct {
	// Resource properties.
	Properties *ServerDNSAliasProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerDNSAliasAcquisition - A server dns alias acquisition request.
type ServerDNSAliasAcquisition struct {
	// REQUIRED; The id of the server alias that will be acquired to point to this server instead.
	OldServerDNSAliasID *string `json:"oldServerDnsAliasId,omitempty"`
}

// ServerDNSAliasListResult - A list of server DNS aliases.
type ServerDNSAliasListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerDNSAlias `json:"value,omitempty" azure:"ro"`
}

// ServerDNSAliasProperties - Properties of a server DNS alias.
type ServerDNSAliasProperties struct {
	// READ-ONLY; The fully qualified DNS record for alias
	AzureDNSRecord *string `json:"azureDnsRecord,omitempty" azure:"ro"`
}

// ServerDNSAliasesClientBeginAcquireOptions contains the optional parameters for the ServerDNSAliasesClient.BeginAcquire
// method.
type ServerDNSAliasesClientBeginAcquireOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerDNSAliasesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerDNSAliasesClient.BeginCreateOrUpdate
// method.
type ServerDNSAliasesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerDNSAliasesClientBeginDeleteOptions contains the optional parameters for the ServerDNSAliasesClient.BeginDelete method.
type ServerDNSAliasesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerDNSAliasesClientGetOptions contains the optional parameters for the ServerDNSAliasesClient.Get method.
type ServerDNSAliasesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerDNSAliasesClientListByServerOptions contains the optional parameters for the ServerDNSAliasesClient.ListByServer
// method.
type ServerDNSAliasesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerDevOpsAuditSettingsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerDevOpsAuditSettingsClient.BeginCreateOrUpdate
// method.
type ServerDevOpsAuditSettingsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerDevOpsAuditSettingsClientGetOptions contains the optional parameters for the ServerDevOpsAuditSettingsClient.Get
// method.
type ServerDevOpsAuditSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerDevOpsAuditSettingsClientListByServerOptions contains the optional parameters for the ServerDevOpsAuditSettingsClient.ListByServer
// method.
type ServerDevOpsAuditSettingsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerDevOpsAuditSettingsListResult - A list of server DevOps audit settings.
type ServerDevOpsAuditSettingsListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerDevOpsAuditingSettings `json:"value,omitempty" azure:"ro"`
}

// ServerDevOpsAuditSettingsProperties - Properties of a server DevOps audit settings.
type ServerDevOpsAuditSettingsProperties struct {
	// REQUIRED; Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
	State *BlobAuditingPolicyState `json:"state,omitempty"`

	// Specifies whether DevOps audit events are sent to Azure Monitor. In order to send the events to Azure Monitor, specify
	// 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	// When using REST API to configure DevOps audit, Diagnostic Settings with 'DevOpsOperationsAudit' diagnostic logs category
	// on the master database should be also created.
	// Diagnostic Settings URI format: PUT
	// https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	// For more information, see Diagnostic Settings REST API [https://go.microsoft.com/fwlink/?linkid=2033207]or Diagnostic Settings
	// PowerShell [https://go.microsoft.com/fwlink/?linkid=2033043]
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`

	// Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, not
	// specifying the storageAccountAccessKey will use SQL server system-assigned
	// managed identity to access the storage. Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server
	// identity. For more information, see Auditing to storage using Managed
	// Identity authentication [https://go.microsoft.com/fwlink/?linkid=2114355]
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *string `json:"storageAccountSubscriptionId,omitempty"`

	// Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint
	// or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
}

// ServerDevOpsAuditingSettings - A server DevOps auditing settings.
type ServerDevOpsAuditingSettings struct {
	// Resource properties.
	Properties *ServerDevOpsAuditSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of ServerDevOpsAuditSettingsResource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerExternalAdministrator - Properties of a active directory administrator.
type ServerExternalAdministrator struct {
	// Type of the sever administrator.
	AdministratorType *AdministratorType `json:"administratorType,omitempty"`

	// Azure Active Directory only Authentication enabled.
	AzureADOnlyAuthentication *bool `json:"azureADOnlyAuthentication,omitempty"`

	// Login name of the server administrator.
	Login *string `json:"login,omitempty"`

	// Principal Type of the sever administrator.
	PrincipalType *PrincipalType `json:"principalType,omitempty"`

	// SID (object ID) of the server administrator.
	Sid *string `json:"sid,omitempty"`

	// Tenant ID of the administrator.
	TenantID *string `json:"tenantId,omitempty"`
}

// ServerFirewallRuleProperties - The properties of a server firewall rule.
type ServerFirewallRuleProperties struct {
	// The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value
	// '0.0.0.0' for all Azure-internal IP addresses.
	EndIPAddress *string `json:"endIpAddress,omitempty"`

	// The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' for all Azure-internal IP addresses.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
}

// ServerInfo - Server info for the server trust group.
type ServerInfo struct {
	// REQUIRED; Server Id.
	ServerID *string `json:"serverId,omitempty"`
}

// ServerKey - A server key.
type ServerKey struct {
	// Resource properties.
	Properties *ServerKeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; Resource location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerKeyListResult - A list of server keys.
type ServerKeyListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerKey `json:"value,omitempty" azure:"ro"`
}

// ServerKeyProperties - Properties for a server key execution.
type ServerKeyProperties struct {
	// REQUIRED; The server key type like 'ServiceManaged', 'AzureKeyVault'.
	ServerKeyType *ServerKeyType `json:"serverKeyType,omitempty"`

	// The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required.
	URI *string `json:"uri,omitempty"`

	// READ-ONLY; Key auto rotation opt-in flag. Either true or false.
	AutoRotationEnabled *bool `json:"autoRotationEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The server key creation date.
	CreationDate *time.Time `json:"creationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subregion of the server key.
	Subregion *string `json:"subregion,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// ServerKeysClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerKeysClient.BeginCreateOrUpdate
// method.
type ServerKeysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerKeysClientBeginDeleteOptions contains the optional parameters for the ServerKeysClient.BeginDelete method.
type ServerKeysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerKeysClientGetOptions contains the optional parameters for the ServerKeysClient.Get method.
type ServerKeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerKeysClientListByServerOptions contains the optional parameters for the ServerKeysClient.ListByServer method.
type ServerKeysClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerListResult - A list of servers.
type ServerListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Server `json:"value,omitempty" azure:"ro"`
}

// ServerOperation - A server operation.
type ServerOperation struct {
	// Resource properties.
	Properties *ServerOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerOperationListResult - The response to a list server operations request
type ServerOperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerOperation `json:"value,omitempty" azure:"ro"`
}

// ServerOperationProperties - The properties of a server operation.
type ServerOperationProperties struct {
	// READ-ONLY; The operation description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty" azure:"ro"`

	// READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty" azure:"ro"`

	// READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *time.Time `json:"estimatedCompletionTime,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty" azure:"ro"`

	// READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty" azure:"ro"`

	// READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty" azure:"ro"`

	// READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; The operation start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation state.
	State *ManagementOperationState `json:"state,omitempty" azure:"ro"`
}

// ServerOperationsClientListByServerOptions contains the optional parameters for the ServerOperationsClient.ListByServer
// method.
type ServerOperationsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerPrivateEndpointConnection - A private endpoint connection under a server
type ServerPrivateEndpointConnection struct {
	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint connection properties
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty" azure:"ro"`
}

// ServerProperties - The properties of a server.
type ServerProperties struct {
	// Administrator username for the server. Once created it cannot be changed.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`

	// The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`

	// The Azure Active Directory identity of the server.
	Administrators *ServerExternalAdministrator `json:"administrators,omitempty"`

	// The Client id used for cross tenant CMK scenario
	FederatedClientID *string `json:"federatedClientId,omitempty"`

	// A CMK URI of the key to use for encryption.
	KeyID *string `json:"keyId,omitempty"`

	// Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`

	// The resource id of a user assigned identity to be used by default.
	PrimaryUserAssignedIdentityID *string `json:"primaryUserAssignedIdentityId,omitempty"`

	// Whether or not public endpoint access is allowed for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	PublicNetworkAccess *ServerNetworkAccessFlag `json:"publicNetworkAccess,omitempty"`

	// Whether or not to restrict outbound network access for this server. Value is optional but if passed in, must be 'Enabled'
	// or 'Disabled'
	RestrictOutboundNetworkAccess *ServerNetworkAccessFlag `json:"restrictOutboundNetworkAccess,omitempty"`

	// The version of the server.
	Version *string `json:"version,omitempty"`

	// READ-ONLY; The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections on a server
	PrivateEndpointConnections []*ServerPrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The state of the server.
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not existing server has a workspace created and if it allows connection from workspace
	WorkspaceFeature *ServerWorkspaceFeature `json:"workspaceFeature,omitempty" azure:"ro"`
}

// ServerSecurityAlertPoliciesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerSecurityAlertPoliciesClient.BeginCreateOrUpdate
// method.
type ServerSecurityAlertPoliciesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerSecurityAlertPoliciesClientGetOptions contains the optional parameters for the ServerSecurityAlertPoliciesClient.Get
// method.
type ServerSecurityAlertPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerSecurityAlertPoliciesClientListByServerOptions contains the optional parameters for the ServerSecurityAlertPoliciesClient.ListByServer
// method.
type ServerSecurityAlertPoliciesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerSecurityAlertPolicy - A server security alert policy.
type ServerSecurityAlertPolicy struct {
	// Resource properties.
	Properties *SecurityAlertsPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; SystemData of SecurityAlertPolicyResource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerTrustCertificate - Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
type ServerTrustCertificate struct {
	// Resource properties.
	Properties *ServerTrustCertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerTrustCertificateProperties - The properties of a server trust certificate.
type ServerTrustCertificateProperties struct {
	// The certificate public blob
	PublicBlob *string `json:"publicBlob,omitempty"`

	// READ-ONLY; The certificate name
	CertificateName *string `json:"certificateName,omitempty" azure:"ro"`

	// READ-ONLY; The certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// ServerTrustCertificatesClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerTrustCertificatesClient.BeginCreateOrUpdate
// method.
type ServerTrustCertificatesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerTrustCertificatesClientBeginDeleteOptions contains the optional parameters for the ServerTrustCertificatesClient.BeginDelete
// method.
type ServerTrustCertificatesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerTrustCertificatesClientGetOptions contains the optional parameters for the ServerTrustCertificatesClient.Get method.
type ServerTrustCertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerTrustCertificatesClientListByInstanceOptions contains the optional parameters for the ServerTrustCertificatesClient.ListByInstance
// method.
type ServerTrustCertificatesClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ServerTrustCertificatesListResult - A list of server trust certificates in instance.
type ServerTrustCertificatesListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerTrustCertificate `json:"value,omitempty" azure:"ro"`
}

// ServerTrustGroup - A server trust group.
type ServerTrustGroup struct {
	// Resource properties.
	Properties *ServerTrustGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerTrustGroupListResult - A list of server trust groups.
type ServerTrustGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerTrustGroup `json:"value,omitempty" azure:"ro"`
}

// ServerTrustGroupProperties - Properties of a server trust group.
type ServerTrustGroupProperties struct {
	// REQUIRED; Group members information for the server trust group.
	GroupMembers []*ServerInfo `json:"groupMembers,omitempty"`

	// REQUIRED; Trust scope of the server trust group.
	TrustScopes []*ServerTrustGroupPropertiesTrustScopesItem `json:"trustScopes,omitempty"`
}

// ServerTrustGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the ServerTrustGroupsClient.BeginCreateOrUpdate
// method.
type ServerTrustGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerTrustGroupsClientBeginDeleteOptions contains the optional parameters for the ServerTrustGroupsClient.BeginDelete
// method.
type ServerTrustGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServerTrustGroupsClientGetOptions contains the optional parameters for the ServerTrustGroupsClient.Get method.
type ServerTrustGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerTrustGroupsClientListByInstanceOptions contains the optional parameters for the ServerTrustGroupsClient.ListByInstance
// method.
type ServerTrustGroupsClientListByInstanceOptions struct {
	// placeholder for future optional parameters
}

// ServerTrustGroupsClientListByLocationOptions contains the optional parameters for the ServerTrustGroupsClient.ListByLocation
// method.
type ServerTrustGroupsClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// ServerUpdate - An update request for an Azure SQL Database server.
type ServerUpdate struct {
	// Server identity
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *ServerProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServerUsage - Represents server metrics.
type ServerUsage struct {
	// READ-ONLY; The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The current limit of the metric.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Name of the server usage metric.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *time.Time `json:"nextResetTime,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty" azure:"ro"`

	// READ-ONLY; The units of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// ServerUsageListResult - Represents the response to a list server metrics request.
type ServerUsageListResult struct {
	// REQUIRED; The list of server metrics for the server.
	Value []*ServerUsage `json:"value,omitempty"`
}

// ServerUsagesClientListByServerOptions contains the optional parameters for the ServerUsagesClient.ListByServer method.
type ServerUsagesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServerVersionCapability - The server capability
type ServerVersionCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The server version name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported database editions.
	SupportedEditions []*EditionCapability `json:"supportedEditions,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported elastic pool editions.
	SupportedElasticPoolEditions []*ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessment - A server vulnerability assessment.
type ServerVulnerabilityAssessment struct {
	// Resource properties.
	Properties *ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessmentListResult - A list of the server's vulnerability assessments.
type ServerVulnerabilityAssessmentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*ServerVulnerabilityAssessment `json:"value,omitempty" azure:"ro"`
}

// ServerVulnerabilityAssessmentProperties - Properties of a server Vulnerability Assessment.
type ServerVulnerabilityAssessmentProperties struct {
	// REQUIRED; A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`

	// The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`

	// Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey'
	// isn't specified, storageAccountAccessKey is required. Applies only if the
	// storage account is not behind a Vnet or a firewall
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`

	// A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter.
	// If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
	// required. Applies only if the storage account is not behind a Vnet or a firewall
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
}

// ServerVulnerabilityAssessmentsClientCreateOrUpdateOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.CreateOrUpdate
// method.
type ServerVulnerabilityAssessmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServerVulnerabilityAssessmentsClientDeleteOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.Delete
// method.
type ServerVulnerabilityAssessmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServerVulnerabilityAssessmentsClientGetOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.Get
// method.
type ServerVulnerabilityAssessmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServerVulnerabilityAssessmentsClientListByServerOptions contains the optional parameters for the ServerVulnerabilityAssessmentsClient.ListByServer
// method.
type ServerVulnerabilityAssessmentsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServersClientBeginCreateOrUpdateOptions contains the optional parameters for the ServersClient.BeginCreateOrUpdate method.
type ServersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginDeleteOptions contains the optional parameters for the ServersClient.BeginDelete method.
type ServersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginImportDatabaseOptions contains the optional parameters for the ServersClient.BeginImportDatabase method.
type ServersClientBeginImportDatabaseOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientBeginUpdateOptions contains the optional parameters for the ServersClient.BeginUpdate method.
type ServersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ServersClientCheckNameAvailabilityOptions contains the optional parameters for the ServersClient.CheckNameAvailability
// method.
type ServersClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServersClientGetOptions contains the optional parameters for the ServersClient.Get method.
type ServersClientGetOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ServersClientListByResourceGroupOptions contains the optional parameters for the ServersClient.ListByResourceGroup method.
type ServersClientListByResourceGroupOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ServersClientListOptions contains the optional parameters for the ServersClient.List method.
type ServersClientListOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// ServiceObjective - Represents a database service objective.
type ServiceObjective struct {
	// Represents the properties of the resource.
	Properties *ServiceObjectiveProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceObjectiveCapability - The service objectives capability.
type ServiceObjectiveCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The compute model
	ComputeModel *string `json:"computeModel,omitempty" azure:"ro"`

	// READ-ONLY; The unique ID of the service objective.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The included (free) max size.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty" azure:"ro"`

	// READ-ONLY; The service objective name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The performance level.
	PerformanceLevel *PerformanceLevelCapability `json:"performanceLevel,omitempty" azure:"ro"`

	// READ-ONLY; The sku.
	SKU *SKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Supported time range for auto pause delay
	SupportedAutoPauseDelay *AutoPauseDelayTimeRange `json:"supportedAutoPauseDelay,omitempty" azure:"ro"`

	// READ-ONLY; List of supported license types.
	SupportedLicenseTypes []*LicenseTypeCapability `json:"supportedLicenseTypes,omitempty" azure:"ro"`

	// READ-ONLY; List of supported maintenance configurations
	SupportedMaintenanceConfigurations []*MaintenanceConfigurationCapability `json:"supportedMaintenanceConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The list of supported maximum database sizes.
	SupportedMaxSizes []*MaxSizeRangeCapability `json:"supportedMaxSizes,omitempty" azure:"ro"`

	// READ-ONLY; List of supported min capacities
	SupportedMinCapacities []*MinCapacityCapability `json:"supportedMinCapacities,omitempty" azure:"ro"`

	// READ-ONLY; Whether or not zone redundancy is supported for the service objective.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty" azure:"ro"`
}

// ServiceObjectiveListResult - Represents the response to a get database service objectives request.
type ServiceObjectiveListResult struct {
	// REQUIRED; The list of database service objectives.
	Value []*ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties - Represents the properties of a database service objective.
type ServiceObjectiveProperties struct {
	// READ-ONLY; The description for the service level objective.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Gets whether the service level objective is enabled.
	Enabled *bool `json:"enabled,omitempty" azure:"ro"`

	// READ-ONLY; Gets whether the service level objective is the default service objective.
	IsDefault *bool `json:"isDefault,omitempty" azure:"ro"`

	// READ-ONLY; Gets whether the service level objective is a system service objective.
	IsSystem *bool `json:"isSystem,omitempty" azure:"ro"`

	// READ-ONLY; The name for the service objective.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty" azure:"ro"`
}

// ServiceObjectivesClientGetOptions contains the optional parameters for the ServiceObjectivesClient.Get method.
type ServiceObjectivesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceObjectivesClientListByServerOptions contains the optional parameters for the ServiceObjectivesClient.ListByServer
// method.
type ServiceObjectivesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// ServicePrincipal - The managed instance's service principal configuration for a resource.
type ServicePrincipal struct {
	// Service principal type.
	Type *ServicePrincipalType `json:"type,omitempty"`

	// READ-ONLY; The Azure Active Directory application client id.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory application object id.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory tenant id.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SloUsageMetric - A Slo Usage Metric.
type SloUsageMetric struct {
	// READ-ONLY; Gets or sets inRangeTimeRatio for SLO usage metric.
	InRangeTimeRatio *float64 `json:"inRangeTimeRatio,omitempty" azure:"ro"`

	// READ-ONLY; The serviceLevelObjective for SLO usage metric.
	ServiceLevelObjective *ServiceObjectiveName `json:"serviceLevelObjective,omitempty" azure:"ro"`

	// READ-ONLY; The serviceLevelObjectiveId for SLO usage metric.
	ServiceLevelObjectiveID *string `json:"serviceLevelObjectiveId,omitempty" azure:"ro"`
}

// StorageCapability - The storage account type capability.
type StorageCapability struct {
	// The reason for the capability not being available.
	Reason *string `json:"reason,omitempty"`

	// READ-ONLY; The status of the capability.
	Status *CapabilityStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The storage account type for the database's backups.
	StorageAccountType *StorageCapabilityStorageAccountType `json:"storageAccountType,omitempty" azure:"ro"`
}

// SubscriptionUsage - Usage Metric of a Subscription in a Location.
type SubscriptionUsage struct {
	// Resource properties.
	Properties *SubscriptionUsageProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubscriptionUsageListResult - A list of subscription usage metrics in a location.
type SubscriptionUsageListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SubscriptionUsage `json:"value,omitempty" azure:"ro"`
}

// SubscriptionUsageProperties - Properties of a subscription usage.
type SubscriptionUsageProperties struct {
	// READ-ONLY; Current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; User-readable name of the metric.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Boundary value of the metric.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// SubscriptionUsagesClientGetOptions contains the optional parameters for the SubscriptionUsagesClient.Get method.
type SubscriptionUsagesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SubscriptionUsagesClientListByLocationOptions contains the optional parameters for the SubscriptionUsagesClient.ListByLocation
// method.
type SubscriptionUsagesClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// SyncAgent - An Azure SQL Database sync agent.
type SyncAgent struct {
	// Resource properties.
	Properties *SyncAgentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SyncAgentKeyProperties - Properties of an Azure SQL Database sync agent key.
type SyncAgentKeyProperties struct {
	// READ-ONLY; Key of sync agent.
	SyncAgentKey *string `json:"syncAgentKey,omitempty" azure:"ro"`
}

// SyncAgentLinkedDatabase - An Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabase struct {
	// Resource properties.
	Properties *SyncAgentLinkedDatabaseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SyncAgentLinkedDatabaseListResult - A list of sync agent linked databases.
type SyncAgentLinkedDatabaseListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncAgentLinkedDatabase `json:"value,omitempty" azure:"ro"`
}

// SyncAgentLinkedDatabaseProperties - Properties of an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabaseProperties struct {
	// READ-ONLY; Id of the sync agent linked database.
	DatabaseID *string `json:"databaseId,omitempty" azure:"ro"`

	// READ-ONLY; Database name of the sync agent linked database.
	DatabaseName *string `json:"databaseName,omitempty" azure:"ro"`

	// READ-ONLY; Type of the sync agent linked database.
	DatabaseType *SyncMemberDbType `json:"databaseType,omitempty" azure:"ro"`

	// READ-ONLY; Description of the sync agent linked database.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Server name of the sync agent linked database.
	ServerName *string `json:"serverName,omitempty" azure:"ro"`

	// READ-ONLY; User name of the sync agent linked database.
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// SyncAgentListResult - A list of sync agents.
type SyncAgentListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncAgent `json:"value,omitempty" azure:"ro"`
}

// SyncAgentProperties - Properties of an Azure SQL Database sync agent.
type SyncAgentProperties struct {
	// ARM resource id of the sync database in the sync agent.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`

	// READ-ONLY; Expiration time of the sync agent version.
	ExpiryTime *time.Time `json:"expiryTime,omitempty" azure:"ro"`

	// READ-ONLY; If the sync agent version is up to date.
	IsUpToDate *bool `json:"isUpToDate,omitempty" azure:"ro"`

	// READ-ONLY; Last alive time of the sync agent.
	LastAliveTime *time.Time `json:"lastAliveTime,omitempty" azure:"ro"`

	// READ-ONLY; Name of the sync agent.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; State of the sync agent.
	State *SyncAgentState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Version of the sync agent.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// SyncAgentsClientBeginCreateOrUpdateOptions contains the optional parameters for the SyncAgentsClient.BeginCreateOrUpdate
// method.
type SyncAgentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncAgentsClientBeginDeleteOptions contains the optional parameters for the SyncAgentsClient.BeginDelete method.
type SyncAgentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncAgentsClientGenerateKeyOptions contains the optional parameters for the SyncAgentsClient.GenerateKey method.
type SyncAgentsClientGenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// SyncAgentsClientGetOptions contains the optional parameters for the SyncAgentsClient.Get method.
type SyncAgentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SyncAgentsClientListByServerOptions contains the optional parameters for the SyncAgentsClient.ListByServer method.
type SyncAgentsClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// SyncAgentsClientListLinkedDatabasesOptions contains the optional parameters for the SyncAgentsClient.ListLinkedDatabases
// method.
type SyncAgentsClientListLinkedDatabasesOptions struct {
	// placeholder for future optional parameters
}

// SyncDatabaseIDListResult - A list of sync database ID properties.
type SyncDatabaseIDListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncDatabaseIDProperties `json:"value,omitempty" azure:"ro"`
}

// SyncDatabaseIDProperties - Properties of the sync database id.
type SyncDatabaseIDProperties struct {
	// READ-ONLY; ARM resource id of sync database.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SyncFullSchemaProperties - Properties of the database full schema.
type SyncFullSchemaProperties struct {
	// READ-ONLY; Last update time of the database schema.
	LastUpdateTime *time.Time `json:"lastUpdateTime,omitempty" azure:"ro"`

	// READ-ONLY; List of tables in the database full schema.
	Tables []*SyncFullSchemaTable `json:"tables,omitempty" azure:"ro"`
}

// SyncFullSchemaPropertiesListResult - A list of sync schema properties.
type SyncFullSchemaPropertiesListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncFullSchemaProperties `json:"value,omitempty" azure:"ro"`
}

// SyncFullSchemaTable - Properties of the table in the database full schema.
type SyncFullSchemaTable struct {
	// READ-ONLY; List of columns in the table of database full schema.
	Columns []*SyncFullSchemaTableColumn `json:"columns,omitempty" azure:"ro"`

	// READ-ONLY; Error id of the table.
	ErrorID *string `json:"errorId,omitempty" azure:"ro"`

	// READ-ONLY; If there is error in the table.
	HasError *bool `json:"hasError,omitempty" azure:"ro"`

	// READ-ONLY; Name of the table.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Quoted name of the table.
	QuotedName *string `json:"quotedName,omitempty" azure:"ro"`
}

// SyncFullSchemaTableColumn - Properties of the column in the table of database full schema.
type SyncFullSchemaTableColumn struct {
	// READ-ONLY; Data size of the column.
	DataSize *string `json:"dataSize,omitempty" azure:"ro"`

	// READ-ONLY; Data type of the column.
	DataType *string `json:"dataType,omitempty" azure:"ro"`

	// READ-ONLY; Error id of the column.
	ErrorID *string `json:"errorId,omitempty" azure:"ro"`

	// READ-ONLY; If there is error in the table.
	HasError *bool `json:"hasError,omitempty" azure:"ro"`

	// READ-ONLY; If it is the primary key of the table.
	IsPrimaryKey *bool `json:"isPrimaryKey,omitempty" azure:"ro"`

	// READ-ONLY; Name of the column.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Quoted name of the column.
	QuotedName *string `json:"quotedName,omitempty" azure:"ro"`
}

// SyncGroup - An Azure SQL Database sync group.
type SyncGroup struct {
	// Resource properties.
	Properties *SyncGroupProperties `json:"properties,omitempty"`

	// The name and capacity of the SKU.
	SKU *SKU `json:"sku,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SyncGroupListResult - A list of sync groups.
type SyncGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncGroup `json:"value,omitempty" azure:"ro"`
}

// SyncGroupLogListResult - A list of sync group log properties.
type SyncGroupLogListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncGroupLogProperties `json:"value,omitempty" azure:"ro"`
}

// SyncGroupLogProperties - Properties of an Azure SQL Database sync group log.
type SyncGroupLogProperties struct {
	// READ-ONLY; Details of the sync group log.
	Details *string `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; OperationStatus of the sync group log.
	OperationStatus *string `json:"operationStatus,omitempty" azure:"ro"`

	// READ-ONLY; Source of the sync group log.
	Source *string `json:"source,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of the sync group log.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; TracingId of the sync group log.
	TracingID *string `json:"tracingId,omitempty" azure:"ro"`

	// READ-ONLY; Type of the sync group log.
	Type *SyncGroupLogType `json:"type,omitempty" azure:"ro"`
}

// SyncGroupProperties - Properties of a sync group.
type SyncGroupProperties struct {
	// Conflict logging retention period.
	ConflictLoggingRetentionInDays *int32 `json:"conflictLoggingRetentionInDays,omitempty"`

	// Conflict resolution policy of the sync group.
	ConflictResolutionPolicy *SyncConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`

	// If conflict logging is enabled.
	EnableConflictLogging *bool `json:"enableConflictLogging,omitempty"`

	// Password for the sync group hub database credential.
	HubDatabasePassword *string `json:"hubDatabasePassword,omitempty"`

	// User name for the sync group hub database credential.
	HubDatabaseUserName *string `json:"hubDatabaseUserName,omitempty"`

	// Sync interval of the sync group.
	Interval *int32 `json:"interval,omitempty"`

	// Sync schema of the sync group.
	Schema *SyncGroupSchema `json:"schema,omitempty"`

	// ARM resource id of the sync database in the sync group.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`

	// If use private link connection is enabled.
	UsePrivateLinkConnection *bool `json:"usePrivateLinkConnection,omitempty"`

	// READ-ONLY; Last sync time of the sync group.
	LastSyncTime *time.Time `json:"lastSyncTime,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint name of the sync group if use private link connection is enabled.
	PrivateEndpointName *string `json:"privateEndpointName,omitempty" azure:"ro"`

	// READ-ONLY; Sync state of the sync group.
	SyncState *SyncGroupState `json:"syncState,omitempty" azure:"ro"`
}

// SyncGroupSchema - Properties of sync group schema.
type SyncGroupSchema struct {
	// Name of master sync member where the schema is from.
	MasterSyncMemberName *string `json:"masterSyncMemberName,omitempty"`

	// List of tables in sync group schema.
	Tables []*SyncGroupSchemaTable `json:"tables,omitempty"`
}

// SyncGroupSchemaTable - Properties of table in sync group schema.
type SyncGroupSchemaTable struct {
	// List of columns in sync group schema.
	Columns []*SyncGroupSchemaTableColumn `json:"columns,omitempty"`

	// Quoted name of sync group schema table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroupSchemaTableColumn - Properties of column in sync group table.
type SyncGroupSchemaTableColumn struct {
	// Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`

	// Data type of the column.
	DataType *string `json:"dataType,omitempty"`

	// Quoted name of sync group table column.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the SyncGroupsClient.BeginCreateOrUpdate
// method.
type SyncGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncGroupsClientBeginDeleteOptions contains the optional parameters for the SyncGroupsClient.BeginDelete method.
type SyncGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncGroupsClientBeginRefreshHubSchemaOptions contains the optional parameters for the SyncGroupsClient.BeginRefreshHubSchema
// method.
type SyncGroupsClientBeginRefreshHubSchemaOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncGroupsClientBeginUpdateOptions contains the optional parameters for the SyncGroupsClient.BeginUpdate method.
type SyncGroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncGroupsClientCancelSyncOptions contains the optional parameters for the SyncGroupsClient.CancelSync method.
type SyncGroupsClientCancelSyncOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientGetOptions contains the optional parameters for the SyncGroupsClient.Get method.
type SyncGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientListByDatabaseOptions contains the optional parameters for the SyncGroupsClient.ListByDatabase method.
type SyncGroupsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientListHubSchemasOptions contains the optional parameters for the SyncGroupsClient.ListHubSchemas method.
type SyncGroupsClientListHubSchemasOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientListLogsOptions contains the optional parameters for the SyncGroupsClient.ListLogs method.
type SyncGroupsClientListLogsOptions struct {
	// The continuation token for this operation.
	ContinuationToken *string
}

// SyncGroupsClientListSyncDatabaseIDsOptions contains the optional parameters for the SyncGroupsClient.ListSyncDatabaseIDs
// method.
type SyncGroupsClientListSyncDatabaseIDsOptions struct {
	// placeholder for future optional parameters
}

// SyncGroupsClientTriggerSyncOptions contains the optional parameters for the SyncGroupsClient.TriggerSync method.
type SyncGroupsClientTriggerSyncOptions struct {
	// placeholder for future optional parameters
}

// SyncMember - An Azure SQL Database sync member.
type SyncMember struct {
	// Resource properties.
	Properties *SyncMemberProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SyncMemberListResult - A list of Azure SQL Database sync members.
type SyncMemberListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SyncMember `json:"value,omitempty" azure:"ro"`
}

// SyncMemberProperties - Properties of a sync member.
type SyncMemberProperties struct {
	// Database name of the member database in the sync member.
	DatabaseName *string `json:"databaseName,omitempty"`

	// Database type of the sync member.
	DatabaseType *SyncMemberDbType `json:"databaseType,omitempty"`

	// Password of the member database in the sync member.
	Password *string `json:"password,omitempty"`

	// SQL Server database id of the sync member.
	SQLServerDatabaseID *string `json:"sqlServerDatabaseId,omitempty"`

	// Server name of the member database in the sync member
	ServerName *string `json:"serverName,omitempty"`

	// ARM resource id of the sync agent in the sync member.
	SyncAgentID *string `json:"syncAgentId,omitempty"`

	// Sync direction of the sync member.
	SyncDirection *SyncDirection `json:"syncDirection,omitempty"`

	// ARM resource id of the sync member logical database, for sync members in Azure.
	SyncMemberAzureDatabaseResourceID *string `json:"syncMemberAzureDatabaseResourceId,omitempty"`

	// Whether to use private link connection.
	UsePrivateLinkConnection *bool `json:"usePrivateLinkConnection,omitempty"`

	// User name of the member database in the sync member.
	UserName *string `json:"userName,omitempty"`

	// READ-ONLY; Private endpoint name of the sync member if use private link connection is enabled, for sync members in Azure.
	PrivateEndpointName *string `json:"privateEndpointName,omitempty" azure:"ro"`

	// READ-ONLY; Sync state of the sync member.
	SyncState *SyncMemberState `json:"syncState,omitempty" azure:"ro"`
}

// SyncMembersClientBeginCreateOrUpdateOptions contains the optional parameters for the SyncMembersClient.BeginCreateOrUpdate
// method.
type SyncMembersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncMembersClientBeginDeleteOptions contains the optional parameters for the SyncMembersClient.BeginDelete method.
type SyncMembersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncMembersClientBeginRefreshMemberSchemaOptions contains the optional parameters for the SyncMembersClient.BeginRefreshMemberSchema
// method.
type SyncMembersClientBeginRefreshMemberSchemaOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncMembersClientBeginUpdateOptions contains the optional parameters for the SyncMembersClient.BeginUpdate method.
type SyncMembersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SyncMembersClientGetOptions contains the optional parameters for the SyncMembersClient.Get method.
type SyncMembersClientGetOptions struct {
	// placeholder for future optional parameters
}

// SyncMembersClientListBySyncGroupOptions contains the optional parameters for the SyncMembersClient.ListBySyncGroup method.
type SyncMembersClientListBySyncGroupOptions struct {
	// placeholder for future optional parameters
}

// SyncMembersClientListMemberSchemasOptions contains the optional parameters for the SyncMembersClient.ListMemberSchemas
// method.
type SyncMembersClientListMemberSchemasOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TdeCertificate - A TDE certificate that can be uploaded into a server.
type TdeCertificate struct {
	// Resource properties.
	Properties *TdeCertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TdeCertificateProperties - Properties of a TDE certificate.
type TdeCertificateProperties struct {
	// REQUIRED; The base64 encoded certificate private blob.
	PrivateBlob *string `json:"privateBlob,omitempty"`

	// The certificate password.
	CertPassword *string `json:"certPassword,omitempty"`
}

// TdeCertificatesClientBeginCreateOptions contains the optional parameters for the TdeCertificatesClient.BeginCreate method.
type TdeCertificatesClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TimeZone - Time Zone.
type TimeZone struct {
	// Resource properties.
	Properties *TimeZoneProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TimeZoneListResult - A list of time zones.
type TimeZoneListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*TimeZone `json:"value,omitempty" azure:"ro"`
}

// TimeZoneProperties - The properties of a time zone.
type TimeZoneProperties struct {
	// READ-ONLY; The time zone display name
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The time zone id
	TimeZoneID *string `json:"timeZoneId,omitempty" azure:"ro"`
}

// TimeZonesClientGetOptions contains the optional parameters for the TimeZonesClient.Get method.
type TimeZonesClientGetOptions struct {
	// placeholder for future optional parameters
}

// TimeZonesClientListByLocationOptions contains the optional parameters for the TimeZonesClient.ListByLocation method.
type TimeZonesClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

type TopQueries struct {
	// List of top resource consuming queries with appropriate metric data
	Queries []*QueryStatisticsProperties `json:"queries,omitempty"`

	// READ-ONLY; Aggregation function used to calculate query metrics.
	AggregationFunction *string `json:"aggregationFunction,omitempty" azure:"ro"`

	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *string `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Interval type (length).
	IntervalType *QueryTimeGrainType `json:"intervalType,omitempty" azure:"ro"`

	// READ-ONLY; Requested number of top queries.
	NumberOfQueries *int32 `json:"numberOfQueries,omitempty" azure:"ro"`

	// READ-ONLY; Metric used to rank queries.
	ObservationMetric *string `json:"observationMetric,omitempty" azure:"ro"`

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *string `json:"startTime,omitempty" azure:"ro"`
}

// TopQueriesListResult - A list of top resource consuming queries on managed instance
type TopQueriesListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*TopQueries `json:"value,omitempty" azure:"ro"`
}

// TrackedResource - ARM tracked top level resource.
type TrackedResource struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TransparentDataEncryptionProperties - Properties of a transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// REQUIRED; Specifies the state of the transparent data encryption.
	State *TransparentDataEncryptionState `json:"state,omitempty"`
}

// TransparentDataEncryptionsClientCreateOrUpdateOptions contains the optional parameters for the TransparentDataEncryptionsClient.CreateOrUpdate
// method.
type TransparentDataEncryptionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TransparentDataEncryptionsClientGetOptions contains the optional parameters for the TransparentDataEncryptionsClient.Get
// method.
type TransparentDataEncryptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TransparentDataEncryptionsClientListByDatabaseOptions contains the optional parameters for the TransparentDataEncryptionsClient.ListByDatabase
// method.
type TransparentDataEncryptionsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}

// UpdateLongTermRetentionBackupParameters - Contains the information necessary to perform long term retention backup update
// operation.
type UpdateLongTermRetentionBackupParameters struct {
	// Resource properties.
	Properties *UpdateLongTermRetentionBackupParametersProperties `json:"properties,omitempty"`
}

// UpdateLongTermRetentionBackupParametersProperties - Contains the properties to perform long term retention backup copy
// operation.
type UpdateLongTermRetentionBackupParametersProperties struct {
	// The storage redundancy type of the copied backup
	RequestedBackupStorageRedundancy *BackupStorageRedundancy `json:"requestedBackupStorageRedundancy,omitempty"`
}

// UpdateManagedInstanceDNSServersOperation - A recoverable managed database resource.
type UpdateManagedInstanceDNSServersOperation struct {
	// Resource properties.
	Properties *DNSRefreshConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type UpsertManagedServerOperationParameters struct {
	Family          *string `json:"family,omitempty"`
	StorageSizeInGB *int32  `json:"storageSizeInGB,omitempty"`
	Tier            *string `json:"tier,omitempty"`
	VCores          *int32  `json:"vCores,omitempty"`
}

type UpsertManagedServerOperationStep struct {
	Name   *string                                 `json:"name,omitempty"`
	Order  *int32                                  `json:"order,omitempty"`
	Status *UpsertManagedServerOperationStepStatus `json:"status,omitempty"`
}

// Usage - ARM usage.
type Usage struct {
	// READ-ONLY; Usage current value.
	CurrentValue *int32 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Usage limit.
	Limit *int32 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *Name `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Usage requested limit.
	RequestedLimit *int32 `json:"requestedLimit,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`

	// READ-ONLY; Usage unit.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// UsageListResult - A list of usages.
type UsageListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Usage `json:"value,omitempty" azure:"ro"`
}

// UsagesClientListByInstancePoolOptions contains the optional parameters for the UsagesClient.ListByInstancePool method.
type UsagesClientListByInstancePoolOptions struct {
	// Optional request parameter to include managed instance usages within the instance pool.
	ExpandChildren *bool
}

// UserIdentity - Azure Active Directory identity configuration for a resource.
type UserIdentity struct {
	// READ-ONLY; The Azure Active Directory client id.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VirtualCluster - An Azure SQL virtual cluster.
type VirtualCluster struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *VirtualClusterProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualClusterListResult - A list of virtual clusters.
type VirtualClusterListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*VirtualCluster `json:"value,omitempty" azure:"ro"`
}

// VirtualClusterProperties - The properties of a virtual cluster.
type VirtualClusterProperties struct {
	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`

	// Specifies maintenance configuration id to apply to this virtual cluster.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`

	// READ-ONLY; List of resources in this virtual cluster.
	ChildResources []*string `json:"childResources,omitempty" azure:"ro"`

	// READ-ONLY; Subnet resource ID for the virtual cluster.
	SubnetID *string `json:"subnetId,omitempty" azure:"ro"`
}

// VirtualClusterUpdate - An update request for an Azure SQL Database virtual cluster.
type VirtualClusterUpdate struct {
	// Resource properties.
	Properties *VirtualClusterProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualClustersClientBeginDeleteOptions contains the optional parameters for the VirtualClustersClient.BeginDelete method.
type VirtualClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualClustersClientBeginUpdateOptions contains the optional parameters for the VirtualClustersClient.BeginUpdate method.
type VirtualClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualClustersClientGetOptions contains the optional parameters for the VirtualClustersClient.Get method.
type VirtualClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualClustersClientListByResourceGroupOptions contains the optional parameters for the VirtualClustersClient.ListByResourceGroup
// method.
type VirtualClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VirtualClustersClientListOptions contains the optional parameters for the VirtualClustersClient.List method.
type VirtualClustersClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualClustersClientUpdateDNSServersOptions contains the optional parameters for the VirtualClustersClient.UpdateDNSServers
// method.
type VirtualClustersClientUpdateDNSServersOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkRule - A virtual network rule.
type VirtualNetworkRule struct {
	// Resource properties.
	Properties *VirtualNetworkRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkRuleListResult - A list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*VirtualNetworkRule `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworkRuleProperties - Properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// REQUIRED; The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`

	// Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`

	// READ-ONLY; Virtual Network Rule State
	State *VirtualNetworkRuleState `json:"state,omitempty" azure:"ro"`
}

// VirtualNetworkRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkRulesClient.BeginCreateOrUpdate
// method.
type VirtualNetworkRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkRulesClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkRulesClient.BeginDelete
// method.
type VirtualNetworkRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkRulesClientGetOptions contains the optional parameters for the VirtualNetworkRulesClient.Get method.
type VirtualNetworkRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkRulesClientListByServerOptions contains the optional parameters for the VirtualNetworkRulesClient.ListByServer
// method.
type VirtualNetworkRulesClientListByServerOptions struct {
	// placeholder for future optional parameters
}

// VulnerabilityAssessmentRecurringScansProperties - Properties of a Vulnerability Assessment recurring scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`

	// Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails []*string `json:"emails,omitempty"`

	// Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// VulnerabilityAssessmentScanError - Properties of a vulnerability assessment scan error.
type VulnerabilityAssessmentScanError struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// VulnerabilityAssessmentScanRecord - A vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecord struct {
	// Resource properties.
	Properties *VulnerabilityAssessmentScanRecordProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VulnerabilityAssessmentScanRecordListResult - A list of vulnerability assessment scan records.
type VulnerabilityAssessmentScanRecordListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*VulnerabilityAssessmentScanRecord `json:"value,omitempty" azure:"ro"`
}

// VulnerabilityAssessmentScanRecordProperties - Properties of a vulnerability assessment scan record.
type VulnerabilityAssessmentScanRecordProperties struct {
	// READ-ONLY; The scan end time (UTC).
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The scan errors.
	Errors []*VulnerabilityAssessmentScanError `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; The number of failed security checks.
	NumberOfFailedSecurityChecks *int32 `json:"numberOfFailedSecurityChecks,omitempty" azure:"ro"`

	// READ-ONLY; The scan ID.
	ScanID *string `json:"scanId,omitempty" azure:"ro"`

	// READ-ONLY; The scan start time (UTC).
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The scan status.
	State *VulnerabilityAssessmentScanState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; The scan results storage container path.
	StorageContainerPath *string `json:"storageContainerPath,omitempty" azure:"ro"`

	// READ-ONLY; The scan trigger type.
	TriggerType *VulnerabilityAssessmentScanTriggerType `json:"triggerType,omitempty" azure:"ro"`
}

// WorkloadClassifier - Workload classifier operations for a data warehouse
type WorkloadClassifier struct {
	// Resource properties.
	Properties *WorkloadClassifierProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadClassifierListResult - A list of workload classifiers for a workload group.
type WorkloadClassifierListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*WorkloadClassifier `json:"value,omitempty" azure:"ro"`
}

// WorkloadClassifierProperties - Workload classifier definition. For more information look at sys.workloadmanagementworkload_classifiers
// (DMV).
type WorkloadClassifierProperties struct {
	// REQUIRED; The workload classifier member name.
	MemberName *string `json:"memberName,omitempty"`

	// The workload classifier context.
	Context *string `json:"context,omitempty"`

	// The workload classifier end time for classification.
	EndTime *string `json:"endTime,omitempty"`

	// The workload classifier importance.
	Importance *string `json:"importance,omitempty"`

	// The workload classifier label.
	Label *string `json:"label,omitempty"`

	// The workload classifier start time for classification.
	StartTime *string `json:"startTime,omitempty"`
}

// WorkloadClassifiersClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkloadClassifiersClient.BeginCreateOrUpdate
// method.
type WorkloadClassifiersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadClassifiersClientBeginDeleteOptions contains the optional parameters for the WorkloadClassifiersClient.BeginDelete
// method.
type WorkloadClassifiersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadClassifiersClientGetOptions contains the optional parameters for the WorkloadClassifiersClient.Get method.
type WorkloadClassifiersClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkloadClassifiersClientListByWorkloadGroupOptions contains the optional parameters for the WorkloadClassifiersClient.ListByWorkloadGroup
// method.
type WorkloadClassifiersClientListByWorkloadGroupOptions struct {
	// placeholder for future optional parameters
}

// WorkloadGroup - Workload group operations for a data warehouse
type WorkloadGroup struct {
	// Resource properties.
	Properties *WorkloadGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadGroupListResult - A list of workload groups.
type WorkloadGroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*WorkloadGroup `json:"value,omitempty" azure:"ro"`
}

// WorkloadGroupProperties - Workload group definition. For more information look at sys.workloadmanagementworkload_groups
// (DMV).
type WorkloadGroupProperties struct {
	// REQUIRED; The workload group cap percentage resource.
	MaxResourcePercent *int32 `json:"maxResourcePercent,omitempty"`

	// REQUIRED; The workload group minimum percentage resource.
	MinResourcePercent *int32 `json:"minResourcePercent,omitempty"`

	// REQUIRED; The workload group request minimum grant percentage.
	MinResourcePercentPerRequest *float64 `json:"minResourcePercentPerRequest,omitempty"`

	// The workload group importance level.
	Importance *string `json:"importance,omitempty"`

	// The workload group request maximum grant percentage.
	MaxResourcePercentPerRequest *float64 `json:"maxResourcePercentPerRequest,omitempty"`

	// The workload group query execution timeout.
	QueryExecutionTimeout *int32 `json:"queryExecutionTimeout,omitempty"`
}

// WorkloadGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the WorkloadGroupsClient.BeginCreateOrUpdate
// method.
type WorkloadGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadGroupsClientBeginDeleteOptions contains the optional parameters for the WorkloadGroupsClient.BeginDelete method.
type WorkloadGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkloadGroupsClientGetOptions contains the optional parameters for the WorkloadGroupsClient.Get method.
type WorkloadGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkloadGroupsClientListByDatabaseOptions contains the optional parameters for the WorkloadGroupsClient.ListByDatabase
// method.
type WorkloadGroupsClientListByDatabaseOptions struct {
	// placeholder for future optional parameters
}
