// Code generated by smithy-go-codegen DO NOT EDIT.

package arczonalshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arczonalshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get information about a resource that's been registered for zonal shifts with
// Amazon Route 53 Application Recovery Controller in this Amazon Web Services
// Region. Resources that are registered for zonal shifts are managed resources in
// Route 53 ARC. You can start zonal shifts and configure zonal autoshift for
// managed resources.
//
// At this time, you can only start a zonal shift or configure zonal autoshift for
// Network Load Balancers and Application Load Balancers with cross-zone load
// balancing turned off.
func (c *Client) GetManagedResource(ctx context.Context, params *GetManagedResourceInput, optFns ...func(*Options)) (*GetManagedResourceOutput, error) {
	if params == nil {
		params = &GetManagedResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetManagedResource", params, optFns, c.addOperationGetManagedResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetManagedResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetManagedResourceInput struct {

	// The identifier for the resource to shift away traffic for. The identifier is
	// the Amazon Resource Name (ARN) for the resource.
	//
	// At this time, supported resources are Network Load Balancers and Application
	// Load Balancers with cross-zone load balancing turned off.
	//
	// This member is required.
	ResourceIdentifier *string

	noSmithyDocumentSerde
}

type GetManagedResourceOutput struct {

	// A collection of key-value pairs that indicate whether resources are active in
	// Availability Zones or not. The key name is the Availability Zone where the
	// resource is deployed. The value is 1 or 0.
	//
	// This member is required.
	AppliedWeights map[string]float32

	// The zonal shifts that are currently active for a resource.
	//
	// This member is required.
	ZonalShifts []types.ZonalShiftInResource

	// The Amazon Resource Name (ARN) for the resource.
	Arn *string

	// An array of the autoshifts that are active for the resource.
	Autoshifts []types.AutoshiftInResource

	// The name of the resource.
	Name *string

	// The practice run configuration for zonal autoshift that's associated with the
	// resource.
	PracticeRunConfiguration *types.PracticeRunConfiguration

	// The status for zonal autoshift for a resource. When the autoshift status is
	// ENABLED , Amazon Web Services shifts traffic for a resource away from an
	// Availability Zone, on your behalf, when Amazon Web Services determines that
	// there's an issue in the Availability Zone that could potentially affect
	// customers.
	ZonalAutoshiftStatus types.ZonalAutoshiftStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetManagedResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetManagedResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetManagedResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetManagedResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetManagedResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetManagedResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetManagedResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetManagedResource",
	}
}
