// Code generated by protoc-gen-go.
// source: google/api/monitored_resource.proto
// DO NOT EDIT!

package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A descriptor that describes the schema of [MonitoredResource][google.api.MonitoredResource].
type MonitoredResourceDescriptor struct {
	// The monitored resource type. For example, the type `"cloudsql_database"`
	// represents databases in Google Cloud SQL.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// A concise name for the monitored resource type that can be displayed in
	// user interfaces. For example, `"Google Cloud SQL Database"`.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// A detailed description of the monitored resource type that can be used in
	// documentation.
	Description string `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	// A set of labels that can be used to describe instances of this monitored
	// resource type. For example, Google Cloud SQL databases can be labeled with
	// their `"database_id"` and their `"zone"`.
	Labels []*LabelDescriptor `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty"`
}

func (m *MonitoredResourceDescriptor) Reset()                    { *m = MonitoredResourceDescriptor{} }
func (m *MonitoredResourceDescriptor) String() string            { return proto.CompactTextString(m) }
func (*MonitoredResourceDescriptor) ProtoMessage()               {}
func (*MonitoredResourceDescriptor) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *MonitoredResourceDescriptor) GetLabels() []*LabelDescriptor {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A monitored resource describes a resource that can be used for monitoring
// purpose. It can also be used for logging, billing, and other purposes. Each
// resource has a `type` and a set of `labels`. The labels contain information
// that identifies the resource and describes attributes of it. For example,
// you can use monitored resource to describe a normal file, where the resource
// has `type` as `"file"`, the label `path` identifies the file, and the label
// `size` describes the file size. The monitoring system can use a set of
// monitored resources of files to generate file size distribution.
type MonitoredResource struct {
	// The monitored resource type. This field must match the corresponding
	// [MonitoredResourceDescriptor.type][google.api.MonitoredResourceDescriptor.type] to this resource..  For example,
	// `"cloudsql_database"` represents Cloud SQL databases.
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	// Values for some or all of the labels listed in the associated monitored
	// resource descriptor. For example, you specify a specific Cloud SQL database
	// by supplying values for both the `"database_id"` and `"zone"` labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MonitoredResource) Reset()                    { *m = MonitoredResource{} }
func (m *MonitoredResource) String() string            { return proto.CompactTextString(m) }
func (*MonitoredResource) ProtoMessage()               {}
func (*MonitoredResource) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *MonitoredResource) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*MonitoredResourceDescriptor)(nil), "google.api.MonitoredResourceDescriptor")
	proto.RegisterType((*MonitoredResource)(nil), "google.api.MonitoredResource")
}

func init() { proto.RegisterFile("google/api/monitored_resource.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 300 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x6c, 0x51, 0xcf, 0x4b, 0xfb, 0x30,
	0x14, 0x27, 0xeb, 0xbe, 0x83, 0xef, 0xab, 0x88, 0x06, 0x19, 0x65, 0xbb, 0xd4, 0x79, 0xd9, 0x0e,
	0x6b, 0xc1, 0x5d, 0xd4, 0x9b, 0x43, 0x6f, 0x2a, 0xa3, 0xe0, 0xc5, 0xcb, 0xe8, 0x8f, 0x50, 0x83,
	0x69, 0x53, 0x92, 0x54, 0xe8, 0x1f, 0xe4, 0xc9, 0x7f, 0xd2, 0x36, 0x4d, 0x6d, 0xa1, 0xde, 0x92,
	0xcf, 0xfb, 0xfc, 0xe2, 0x3d, 0xb8, 0x4a, 0x39, 0x4f, 0x19, 0xf1, 0xc3, 0x82, 0xfa, 0x19, 0xcf,
	0xa9, 0xe2, 0x82, 0x24, 0x47, 0x41, 0x24, 0x2f, 0x45, 0x4c, 0xbc, 0x42, 0x70, 0xc5, 0x31, 0xb4,
	0x24, 0xaf, 0x26, 0x2d, 0xe6, 0x03, 0x01, 0x0b, 0x23, 0xc2, 0x5a, 0xce, 0xea, 0x1b, 0xc1, 0xf2,
	0xb9, 0x33, 0x08, 0x8c, 0xfe, 0x81, 0xc8, 0x58, 0xd0, 0xa2, 0xc6, 0x30, 0x86, 0xa9, 0xaa, 0x0a,
	0xe2, 0x20, 0x17, 0xad, 0xff, 0x07, 0xfa, 0x8d, 0x2f, 0xe1, 0x24, 0xa1, 0xb2, 0x60, 0x61, 0x75,
	0xcc, 0xc3, 0x8c, 0x38, 0x13, 0x3d, 0xb3, 0x0d, 0xf6, 0x52, 0x43, 0xd8, 0x05, 0x3b, 0x31, 0x26,
	0x94, 0xe7, 0x8e, 0x65, 0x18, 0x3d, 0x84, 0x77, 0x30, 0xd3, 0x3d, 0xa4, 0x33, 0x75, 0xad, 0xb5,
	0x7d, 0xbd, 0xf4, 0xfa, 0xb6, 0xde, 0x53, 0x33, 0xe9, 0x5b, 0x04, 0x86, 0xba, 0xfa, 0x42, 0x70,
	0x3e, 0x6a, 0xfb, 0x67, 0xc7, 0xfb, 0x5f, 0xfb, 0x89, 0xb6, 0xdf, 0x0c, 0xed, 0x47, 0x16, 0x6d,
	0xa0, 0x7c, 0xcc, 0x95, 0xa8, 0xba, 0xb0, 0xc5, 0x2d, 0xd8, 0x03, 0x18, 0x9f, 0x81, 0xf5, 0x41,
	0x2a, 0x13, 0xd2, 0x3c, 0xf1, 0x05, 0xfc, 0xfb, 0x0c, 0x59, 0xd9, 0x2d, 0xa0, 0xfd, 0xdc, 0x4d,
	0x6e, 0xd0, 0xfe, 0x15, 0x4e, 0x63, 0x9e, 0x0d, 0x22, 0xf7, 0xf3, 0x51, 0xe6, 0xa1, 0xd9, 0xff,
	0x01, 0xbd, 0x6d, 0x52, 0xaa, 0xde, 0xcb, 0xc8, 0xab, 0x05, 0x7e, 0x2b, 0xa8, 0xf9, 0xd2, 0xd7,
	0xe7, 0xd9, 0xc6, 0x8c, 0x92, 0x5c, 0x6d, 0x53, 0xde, 0x1c, 0x2e, 0x9a, 0x69, 0x70, 0xf7, 0x13,
	0x00, 0x00, 0xff, 0xff, 0xca, 0x0d, 0x92, 0x46, 0xfe, 0x01, 0x00, 0x00,
}
