// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/campaign_budget.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A campaign budget.
type CampaignBudget struct {
	// Immutable. The resource name of the campaign budget.
	// Campaign budget resource names have the form:
	//
	// `customers/{customer_id}/campaignBudgets/{budget_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the campaign budget.
	//
	// A campaign budget is created using the CampaignBudgetService create
	// operation and is assigned a budget ID. A budget ID can be shared across
	// different campaigns; the system will then allocate the campaign budget
	// among different campaigns to get optimum results.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign budget.
	//
	// When creating a campaign budget through CampaignBudgetService, every
	// explicitly shared campaign budget must have a non-null, non-empty name.
	// Campaign budgets that are not explicitly shared derive their name from the
	// attached campaign's name.
	//
	// The length of this string must be between 1 and 255, inclusive,
	// in UTF-8 bytes, (trimmed).
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit. Monthly spend is capped at 30.4 times this amount.
	AmountMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=amount_micros,json=amountMicros,proto3" json:"amount_micros,omitempty"`
	// The lifetime amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,10,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// Output only. The status of this campaign budget. This field is read-only.
	Status enums.BudgetStatusEnum_BudgetStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.BudgetStatusEnum_BudgetStatus" json:"status,omitempty"`
	// The delivery method that determines the rate at which the campaign budget
	// is spent.
	//
	// Defaults to STANDARD if unspecified in a create operation.
	DeliveryMethod enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod `protobuf:"varint,7,opt,name=delivery_method,json=deliveryMethod,proto3,enum=google.ads.googleads.v3.enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod" json:"delivery_method,omitempty"`
	// Specifies whether the budget is explicitly shared. Defaults to true if
	// unspecified in a create operation.
	//
	// If true, the budget was created with the purpose of sharing
	// across one or more campaigns.
	//
	// If false, the budget was created with the intention of only being used
	// with a single campaign. The budget's name and status will stay in sync
	// with the campaign's name and status. Attempting to share the budget with a
	// second campaign will result in an error.
	//
	// A non-shared budget can become an explicitly shared. The same operation
	// must also assign the budget a name.
	//
	// A shared campaign budget can never become non-shared.
	ExplicitlyShared *wrappers.BoolValue `protobuf:"bytes,8,opt,name=explicitly_shared,json=explicitlyShared,proto3" json:"explicitly_shared,omitempty"`
	// Output only. The number of campaigns actively using the budget.
	//
	// This field is read-only.
	ReferenceCount *wrappers.Int64Value `protobuf:"bytes,9,opt,name=reference_count,json=referenceCount,proto3" json:"reference_count,omitempty"`
	// Output only. Indicates whether there is a recommended budget for this campaign budget.
	//
	// This field is read-only.
	HasRecommendedBudget *wrappers.BoolValue `protobuf:"bytes,11,opt,name=has_recommended_budget,json=hasRecommendedBudget,proto3" json:"has_recommended_budget,omitempty"`
	// Output only. The recommended budget amount. If no recommendation is available, this will
	// be set to the budget amount.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	//
	// This field is read-only.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,12,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// Immutable. Period over which to spend the budget. Defaults to DAILY if not specified.
	Period enums.BudgetPeriodEnum_BudgetPeriod `protobuf:"varint,13,opt,name=period,proto3,enum=google.ads.googleads.v3.enums.BudgetPeriodEnum_BudgetPeriod" json:"period,omitempty"`
	// Output only. The estimated change in weekly clicks if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyClicks *wrappers.Int64Value `protobuf:"bytes,14,opt,name=recommended_budget_estimated_change_weekly_clicks,json=recommendedBudgetEstimatedChangeWeeklyClicks,proto3" json:"recommended_budget_estimated_change_weekly_clicks,omitempty"`
	// Output only. The estimated change in weekly cost in micros if the recommended budget is
	// applied. One million is equivalent to one currency unit.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyCostMicros *wrappers.Int64Value `protobuf:"bytes,15,opt,name=recommended_budget_estimated_change_weekly_cost_micros,json=recommendedBudgetEstimatedChangeWeeklyCostMicros,proto3" json:"recommended_budget_estimated_change_weekly_cost_micros,omitempty"`
	// Output only. The estimated change in weekly interactions if the recommended budget is
	// applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyInteractions *wrappers.Int64Value `protobuf:"bytes,16,opt,name=recommended_budget_estimated_change_weekly_interactions,json=recommendedBudgetEstimatedChangeWeeklyInteractions,proto3" json:"recommended_budget_estimated_change_weekly_interactions,omitempty"`
	// Output only. The estimated change in weekly views if the recommended budget is applied.
	//
	// This field is read-only.
	RecommendedBudgetEstimatedChangeWeeklyViews *wrappers.Int64Value `protobuf:"bytes,17,opt,name=recommended_budget_estimated_change_weekly_views,json=recommendedBudgetEstimatedChangeWeeklyViews,proto3" json:"recommended_budget_estimated_change_weekly_views,omitempty"`
	// Immutable. The type of the campaign budget.
	Type                 enums.BudgetTypeEnum_BudgetType `protobuf:"varint,18,opt,name=type,proto3,enum=google.ads.googleads.v3.enums.BudgetTypeEnum_BudgetType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *CampaignBudget) Reset()         { *m = CampaignBudget{} }
func (m *CampaignBudget) String() string { return proto.CompactTextString(m) }
func (*CampaignBudget) ProtoMessage()    {}
func (*CampaignBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_3160509214176301, []int{0}
}

func (m *CampaignBudget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignBudget.Unmarshal(m, b)
}
func (m *CampaignBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignBudget.Marshal(b, m, deterministic)
}
func (m *CampaignBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignBudget.Merge(m, src)
}
func (m *CampaignBudget) XXX_Size() int {
	return xxx_messageInfo_CampaignBudget.Size(m)
}
func (m *CampaignBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignBudget.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignBudget proto.InternalMessageInfo

func (m *CampaignBudget) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *CampaignBudget) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *CampaignBudget) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CampaignBudget) GetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.AmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetStatus() enums.BudgetStatusEnum_BudgetStatus {
	if m != nil {
		return m.Status
	}
	return enums.BudgetStatusEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetDeliveryMethod() enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod {
	if m != nil {
		return m.DeliveryMethod
	}
	return enums.BudgetDeliveryMethodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetExplicitlyShared() *wrappers.BoolValue {
	if m != nil {
		return m.ExplicitlyShared
	}
	return nil
}

func (m *CampaignBudget) GetReferenceCount() *wrappers.Int64Value {
	if m != nil {
		return m.ReferenceCount
	}
	return nil
}

func (m *CampaignBudget) GetHasRecommendedBudget() *wrappers.BoolValue {
	if m != nil {
		return m.HasRecommendedBudget
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetPeriod() enums.BudgetPeriodEnum_BudgetPeriod {
	if m != nil {
		return m.Period
	}
	return enums.BudgetPeriodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyClicks() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyClicks
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyCostMicros
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyInteractions
	}
	return nil
}

func (m *CampaignBudget) GetRecommendedBudgetEstimatedChangeWeeklyViews() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetEstimatedChangeWeeklyViews
	}
	return nil
}

func (m *CampaignBudget) GetType() enums.BudgetTypeEnum_BudgetType {
	if m != nil {
		return m.Type
	}
	return enums.BudgetTypeEnum_UNSPECIFIED
}

func init() {
	proto.RegisterType((*CampaignBudget)(nil), "google.ads.googleads.v3.resources.CampaignBudget")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/campaign_budget.proto", fileDescriptor_3160509214176301)
}

var fileDescriptor_3160509214176301 = []byte{
	// 846 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0xdf, 0x6e, 0xdc, 0x44,
	0x14, 0xc6, 0xe5, 0xcd, 0x1f, 0xe8, 0x34, 0xd9, 0x34, 0x53, 0x84, 0x4c, 0x28, 0x90, 0x22, 0x55,
	0x04, 0x81, 0xec, 0x34, 0x8b, 0x52, 0x64, 0xb8, 0xc0, 0x1b, 0xaa, 0x28, 0x40, 0x51, 0xd8, 0x94,
	0x45, 0xa0, 0x48, 0xd6, 0xc4, 0x73, 0xe2, 0x1d, 0xd5, 0x9e, 0xb1, 0x66, 0xc6, 0x1b, 0x56, 0xa8,
	0x12, 0x77, 0x88, 0x5b, 0x24, 0x5e, 0x80, 0x4b, 0x1e, 0x85, 0x27, 0xe0, 0xb2, 0xd7, 0x7d, 0x04,
	0xae, 0x90, 0x67, 0x6c, 0x67, 0x37, 0x21, 0xac, 0xf7, 0xee, 0x78, 0xcf, 0xf9, 0x7d, 0xe7, 0xf3,
	0xf1, 0x59, 0x7b, 0xd0, 0xa3, 0x44, 0x88, 0x24, 0x05, 0x9f, 0x50, 0xe5, 0xdb, 0xb0, 0x8c, 0xc6,
	0x3d, 0x5f, 0x82, 0x12, 0x85, 0x8c, 0x41, 0xf9, 0x31, 0xc9, 0x72, 0xc2, 0x12, 0x1e, 0x9d, 0x15,
	0x34, 0x01, 0xed, 0xe5, 0x52, 0x68, 0x81, 0xef, 0xdb, 0x6a, 0x8f, 0x50, 0xe5, 0x35, 0xa0, 0x37,
	0xee, 0x79, 0x0d, 0xb8, 0x15, 0xdc, 0xa4, 0x0d, 0xbc, 0xc8, 0x94, 0x6f, 0xe5, 0x22, 0x0a, 0x29,
	0x1b, 0x83, 0x9c, 0x44, 0x19, 0xe8, 0x91, 0xa0, 0x56, 0x7e, 0xeb, 0x61, 0x2b, 0x36, 0x07, 0xc9,
	0x16, 0x44, 0x94, 0x26, 0xba, 0x50, 0x15, 0xe2, 0xb7, 0x42, 0xf4, 0x24, 0x87, 0x0a, 0x78, 0xa7,
	0x06, 0x72, 0xe6, 0x9f, 0x33, 0x48, 0x69, 0x74, 0x06, 0x23, 0x32, 0x66, 0x42, 0x56, 0x05, 0x6f,
	0x4c, 0x15, 0xd4, 0x93, 0xa8, 0x52, 0x6f, 0x57, 0x29, 0x73, 0x75, 0x56, 0x9c, 0xfb, 0x17, 0x92,
	0xe4, 0x39, 0xc8, 0xda, 0xcc, 0xbd, 0x29, 0x94, 0x70, 0x2e, 0x34, 0xd1, 0x4c, 0xf0, 0x2a, 0xfb,
	0xee, 0xdf, 0xeb, 0xa8, 0x7b, 0x50, 0x3d, 0x89, 0xbe, 0xf1, 0x85, 0x9f, 0xa2, 0xf5, 0xba, 0x45,
	0xc4, 0x49, 0x06, 0xae, 0xb3, 0xed, 0xec, 0xdc, 0xea, 0xfb, 0x2f, 0xc2, 0x95, 0x7f, 0xc2, 0xf7,
	0xd1, 0x7b, 0x97, 0x8f, 0xa5, 0x8a, 0x72, 0xa6, 0xbc, 0x58, 0x64, 0xfe, 0xac, 0xce, 0x60, 0xad,
	0x56, 0xf9, 0x9a, 0x64, 0x80, 0x77, 0x51, 0x87, 0x51, 0x77, 0x69, 0xdb, 0xd9, 0xb9, 0xbd, 0xf7,
	0x66, 0x45, 0x7a, 0xb5, 0x67, 0xef, 0x88, 0xeb, 0xfd, 0x8f, 0x86, 0x24, 0x2d, 0xa0, 0xbf, 0xf4,
	0x22, 0x5c, 0x1a, 0x74, 0x18, 0xc5, 0xbb, 0x68, 0xd9, 0xb4, 0x5f, 0x36, 0xcc, 0xbd, 0x6b, 0xcc,
	0x89, 0x96, 0x8c, 0x27, 0x06, 0x1a, 0x98, 0x4a, 0xfc, 0x19, 0x5a, 0x27, 0x99, 0x28, 0xb8, 0x8e,
	0x32, 0x16, 0x4b, 0xa1, 0xdc, 0x95, 0xb9, 0xed, 0x06, 0x6b, 0x96, 0x78, 0x62, 0x00, 0xfc, 0x25,
	0xba, 0xab, 0x85, 0x26, 0x69, 0x34, 0xab, 0x83, 0xe6, 0xeb, 0x6c, 0x1a, 0x2e, 0x9c, 0x16, 0xfb,
	0x1e, 0xad, 0xda, 0xb5, 0x70, 0x57, 0xb7, 0x9d, 0x9d, 0xee, 0xde, 0xa7, 0xde, 0x4d, 0xcb, 0x6d,
	0xf6, 0xc2, 0xb3, 0x73, 0x3b, 0x31, 0xc8, 0x63, 0x5e, 0x64, 0x33, 0x3f, 0xd8, 0xb9, 0x54, 0x82,
	0xb8, 0x40, 0x1b, 0x57, 0x16, 0xdc, 0x7d, 0xc5, 0xf4, 0xf8, 0xaa, 0x55, 0x8f, 0xcf, 0x2b, 0xf6,
	0x89, 0x41, 0xa7, 0x7a, 0xcd, 0x26, 0x06, 0x5d, 0x3a, 0x73, 0x8d, 0x0f, 0xd1, 0x26, 0xfc, 0x98,
	0xa7, 0x2c, 0x66, 0x3a, 0x9d, 0x44, 0x6a, 0x44, 0x24, 0x50, 0xf7, 0x55, 0x33, 0x9c, 0xad, 0x6b,
	0xc3, 0xe9, 0x0b, 0x91, 0xda, 0xd9, 0xdc, 0xb9, 0x84, 0x4e, 0x0c, 0x83, 0x8f, 0xd0, 0x86, 0x84,
	0x73, 0x90, 0xc0, 0x63, 0x88, 0xe2, 0x72, 0x66, 0xee, 0xad, 0x96, 0xab, 0xd1, 0x6d, 0xc0, 0x83,
	0x92, 0xc3, 0xdf, 0xa2, 0xd7, 0x47, 0x44, 0x45, 0x12, 0x62, 0x91, 0x65, 0xc0, 0x29, 0xd0, 0xea,
	0x8d, 0xe2, 0xde, 0x9e, 0x67, 0xcc, 0x0a, 0xbe, 0x36, 0x22, 0x6a, 0x70, 0x49, 0x57, 0xff, 0x02,
	0x86, 0xb6, 0xaf, 0x4b, 0x5e, 0x59, 0x8b, 0xb5, 0x96, 0x96, 0xdf, 0x92, 0x57, 0xe5, 0xaf, 0xee,
	0x89, 0x7d, 0xe3, 0xb8, 0xeb, 0x0b, 0xec, 0xc9, 0xb1, 0x41, 0xa6, 0x9e, 0x9d, 0xfd, 0xa1, 0xec,
	0xb8, 0x32, 0xa8, 0x04, 0xf1, 0xaf, 0x0e, 0x7a, 0xf8, 0x1f, 0xb7, 0x01, 0x4a, 0xb3, 0x8c, 0x68,
	0xa0, 0x51, 0x3c, 0x22, 0x3c, 0x81, 0xe8, 0x02, 0xe0, 0x59, 0x3a, 0x89, 0xe2, 0x94, 0xc5, 0xcf,
	0x94, 0xdb, 0x6d, 0x79, 0x5f, 0x1f, 0x5e, 0xbb, 0xaf, 0xc7, 0xb5, 0xf0, 0x81, 0xd1, 0xfd, 0xce,
	0xc8, 0x1e, 0x18, 0x55, 0xfc, 0x9b, 0x83, 0xf6, 0x17, 0xf1, 0x22, 0x54, 0x33, 0xe8, 0x8d, 0x96,
	0x86, 0x76, 0x5b, 0x1a, 0x12, 0xaa, 0x9e, 0xfd, 0xef, 0x0e, 0x7a, 0xb4, 0x80, 0x29, 0xc6, 0x35,
	0x48, 0x12, 0x9b, 0x37, 0xa8, 0x7b, 0xa7, 0xa5, 0xab, 0xbd, 0x76, 0xae, 0x8e, 0xa6, 0xb4, 0xf1,
	0x2f, 0x0e, 0xda, 0x5d, 0xc0, 0xd7, 0x98, 0xc1, 0x85, 0x72, 0x37, 0x5b, 0x1a, 0xfa, 0xa0, 0x9d,
	0xa1, 0x61, 0x29, 0x8a, 0xbf, 0x41, 0xcb, 0xe5, 0x97, 0xca, 0xc5, 0x66, 0x37, 0x3f, 0x6e, 0xb5,
	0x9b, 0x4f, 0x27, 0x39, 0x4c, 0x6d, 0x66, 0x79, 0x69, 0xf7, 0xd2, 0x48, 0x05, 0xf4, 0x65, 0x48,
	0x5a, 0x7f, 0x47, 0xf0, 0x7e, 0x5c, 0x28, 0x2d, 0x32, 0x90, 0xca, 0xff, 0xa9, 0x0e, 0x9f, 0x37,
	0xc7, 0x07, 0x5b, 0x54, 0xa6, 0x66, 0xcf, 0x13, 0xcf, 0xfb, 0x3f, 0x77, 0xd0, 0x83, 0x58, 0x64,
	0xde, 0xdc, 0x13, 0x45, 0xff, 0xee, 0x6c, 0xc7, 0xe3, 0x72, 0x6e, 0xc7, 0xce, 0x0f, 0x5f, 0x54,
	0x64, 0x22, 0x52, 0xc2, 0x13, 0x4f, 0xc8, 0xc4, 0x4f, 0x80, 0x9b, 0xa9, 0xfa, 0x97, 0x96, 0xff,
	0xe7, 0x8c, 0xf3, 0x49, 0x13, 0xfd, 0xd1, 0x59, 0x3a, 0x0c, 0xc3, 0x3f, 0x3b, 0xf7, 0x0f, 0xad,
	0x64, 0x48, 0x95, 0x67, 0xc3, 0x32, 0x1a, 0xf6, 0xbc, 0x41, 0x5d, 0xf9, 0x57, 0x5d, 0x73, 0x1a,
	0x52, 0x75, 0xda, 0xd4, 0x9c, 0x0e, 0x7b, 0xa7, 0x4d, 0xcd, 0xcb, 0xce, 0x03, 0x9b, 0x08, 0x82,
	0x90, 0xaa, 0x20, 0x68, 0xaa, 0x82, 0x60, 0xd8, 0x0b, 0x82, 0xa6, 0xee, 0x6c, 0xd5, 0x98, 0xed,
	0xfd, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xe2, 0x32, 0x68, 0x69, 0x8f, 0x09, 0x00, 0x00,
}
