(**
 * Copyright (c) 2017, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the "hack" directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
*)

type error_type = ParseError | RuntimeError

type t = {
  child        : t option;
  start_offset : int;
  end_offset   : int;
  error_type   : error_type;
  message      : string;
}

exception ParserFatal of t

val make :
  ?child:t option -> ?error_type:error_type -> int -> int -> string -> t

val to_positioned_string : t -> (int -> int * int) -> string

val compare : t -> t -> int

val exactly_equal : t -> t -> bool

val error_type : t -> error_type

val message : t -> string

val start_offset : t -> int
val end_offset : t -> int

val error0001 : string
val error0002 : string
val error0003 : string
val error0004 : string
val error0005 : string
val error0006 : string
val error0007 : string
val error0008 : string
val error0009 : string
val error0010 : string
val error0011 : string
val error0012 : string
val error0013 : string
val error0014 : string

(* Syntactic errors *)
val error1001 : string
val error1002 : string
val error1003 : string
val error1004 : string
val error1006 : string
val error1007 : string
val error1008 : string
val error1009 : string
val error1010 : string
val error1011 : string
val error1012 : string
val error1013 : string
val error1014 : string
val error1015 : string
val error1016 : string
val error1017 : string
val error1018 : string
val error1019 : string
val error1020 : string
val error1021 : string
val error1022 : string
val error1023 : string
val error1024 : string
val error1025 : string
val error1026 : string
val error1027 : string
val error1028 : string
val error1029 : string
val error1030 : string
val error1031 : string
val error1032 : string
val error1033 : string
val error1034 : string
val error1035 : string
val error1036 : string
val error1037 : string
val error1038 : string
val error1039 : string
val error1040 : string
val error1041 : string
val error1042 : string
val error1043 : string
val error1044 : string
val error1045 : string
val error1046 : string
val error1047 : string
val error1048 : string
val error1050 : string
val error1051 : string
val error1052 : string
val error1053 : string
val error1054 : string
val error1055 : string
val error1056 : string
val error1057 : string -> string
val error1058 : string -> string -> string

val error2001 : string
val error2003 : string
val error2004 : string
val error2005 : string
val error2006 : string
val error2007 : string
val error2008 : string
val error2009 : string
val error2010 : string
val error2011 : string
val error2012 : string
val error2013 : string
val error2014 : string
val error2015 : string
val error2016 : string
val error2017 : string
val error2018 : string
val error2019 : string
val error2020 : string
val error2021 : string
val error2022 : string

val error2029 : string
val error2030 : string
val error2031 : string
val error2032 : string
val error2033 : string
val error2034 : string
val error2035 : string
val error2036 : string
val error2037 : string
val error2038 : string -> string
val error2039 : string -> string -> string -> string
val error2040 : string
val error2041 : string
val error2042 : string
val error2043 : string
val error2044 : string -> string -> string
val error2045 : string
val error2046 : string
val error2047 : string -> string
val error2048 : string
val error2049 : string
val error2050 : string
val error2051 : string
val error2052 : string
val error2053 : string
val error2054 : string
val error2055 : string
val error2056 : string
val error2057 : string
val error2058 : string
val error2059 : string
val error2060 : string
val error2061 : string
val error2062 : string
val error2063 : string
val error2064 : string
val error2065 : string
val error2066 : string
val error2067 : string
val error2068 : string
val error2069 : string
val error2070 : open_tag:string -> close_tag:string -> string
val error2071 : string -> string
val error2072 : string -> string
val error2073 : string
val error2074 : string -> string
val error2075 : string -> string
val error2076 : string

(* Start giving names rather than numbers *)
val hsl_in_php : string
val vdarray_in_php : string
val using_st_function_scoped_top_level : string
val const_in_trait : string
val strict_namespace_hh : string
val strict_namespace_not_hh : string
val original_definition : string
val name_is_already_in_use : name:string -> short_name:string -> string
val namespace_name_is_already_in_use : name:string -> short_name:string -> string
val function_name_is_already_in_use : name:string -> short_name:string -> string
val const_name_is_already_in_use : name:string -> short_name:string -> string
val type_name_is_already_in_use : name:string -> short_name:string -> string
val variadic_reference : string
val double_variadic : string
val double_reference : string
val global_in_const_decl : string
val conflicting_trait_require_clauses : name:string -> string
val yield_in_magic_methods : string
val reference_not_allowed_on_key : string
val reference_not_allowed_on_value : string
val reference_not_allowed_on_element : string
val yield_in_finally_block : string
val coloncolonclass_on_dynamic : string
val enum_elem_name_is_class : string
val safe_member_selection_in_write : string
val xhp_member_selection_in_write : string
val reassign_this : string
val strict_types_first_statement : string
val async_magic_method : string
val reserved_keyword_as_class_name : string
val inout_param_in_async_generator : string
val inout_param_in_generator : string
val inout_param_in_async : string
val inout_param_in_construct : string
val fun_arg_inout_set : string
val fun_arg_inout_const : string
val fun_arg_invalid_arg : string
val fun_arg_inout_containers : string
val memoize_with_inout : string
val fn_with_inout_and_ref_params : string
val method_calls_on_xhp_attributes : string
val invalid_constant_initializer : string
val no_args_in_halt_compiler : string
val halt_compiler_top_level_only : string
val trait_alias_rule_allows_only_final_and_visibility_modifiers : string
val namespace_decl_first_statement : string
val code_outside_namespace : string
val strict_types_in_declare_block_mode : string
val invalid_number_of_args : string -> int -> string
val redeclation_of_const : string -> string
val reference_to_static_scope_resolution : string
val class_with_abstract_method : string -> string
val interface_has_non_public_method : string
val redeclaration_of_function : name:string -> loc:string -> string
val redeclaration_of_method : name:string -> string
