/*
 *  Copyright (c) 2017, Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 *
 */

/*
 *  THIS FILE IS AUTOGENERATED. DO NOT MODIFY IT; ALL CHANGES WILL BE LOST IN
 *  VAIN.
 *
 *  @generated
 */
#pragma once

#include <memory>
#include <string>
#include <utility>

#include <folly/Optional.h>
#include <folly/io/IOBuf.h>
#include <mcrouter/lib/carbon/CarbonProtocolReader.h>
#include <mcrouter/lib/carbon/CarbonProtocolWriter.h>
#include <mcrouter/lib/carbon/CommonSerializationTraits.h>
#include <mcrouter/lib/carbon/Keys.h>
#include <mcrouter/lib/carbon/ReplyCommon.h>
#include <mcrouter/lib/carbon/RequestCommon.h>
#include <mcrouter/lib/carbon/RequestReplyUtil.h>
#include <mcrouter/lib/carbon/Result.h>
#include <mcrouter/lib/carbon/TypeList.h>
#include <mcrouter/lib/carbon/Variant.h>

#include "mcrouter/lib/network/gen/CommonMessages.h"

namespace facebook {
namespace memcache {

class McGetReply;

class McGetRequest : public carbon::RequestCommon {
 public:
  using reply_type = McGetReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 1;
  static constexpr const char* name = "get";

  McGetRequest() = default;
  McGetRequest(const McGetRequest&) = default;
  McGetRequest& operator=(const McGetRequest&) = default;
  McGetRequest(McGetRequest&&) = default;
  McGetRequest& operator=(McGetRequest&&) = default;
  explicit McGetRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McGetRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
};

class McGetReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 2;

  McGetReply() = default;
  McGetReply(const McGetReply&) = default;
  McGetReply& operator=(const McGetReply&) = default;
  McGetReply(McGetReply&&) = default;
  McGetReply& operator=(McGetReply&&) = default;
  explicit McGetReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const folly::Optional<folly::IOBuf>& value() const {
    return value_;
  }
  folly::Optional<folly::IOBuf>& value() {
    return value_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  folly::Optional<folly::IOBuf> value_;
  uint64_t flags_{0};
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McSetReply;

class McSetRequest : public carbon::RequestCommon {
 public:
  using reply_type = McSetReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 3;
  static constexpr const char* name = "set";

  McSetRequest() = default;
  McSetRequest(const McSetRequest&) = default;
  McSetRequest& operator=(const McSetRequest&) = default;
  McSetRequest(McSetRequest&&) = default;
  McSetRequest& operator=(McSetRequest&&) = default;
  explicit McSetRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McSetRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int32_t exptime_{0};
};

class McSetReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 4;

  McSetReply() = default;
  McSetReply(const McSetReply&) = default;
  McSetReply& operator=(const McSetReply&) = default;
  McSetReply(McSetReply&&) = default;
  McSetReply& operator=(McSetReply&&) = default;
  explicit McSetReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  uint64_t flags_{0};
  folly::IOBuf value_;
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McDeleteReply;

class McDeleteRequest : public carbon::RequestCommon {
 public:
  using reply_type = McDeleteReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 5;
  static constexpr const char* name = "delete";

  McDeleteRequest() = default;
  McDeleteRequest(const McDeleteRequest&) = default;
  McDeleteRequest& operator=(const McDeleteRequest&) = default;
  McDeleteRequest(McDeleteRequest&&) = default;
  McDeleteRequest& operator=(McDeleteRequest&&) = default;
  explicit McDeleteRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McDeleteRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int32_t exptime_{0};
};

class McDeleteReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 6;

  McDeleteReply() = default;
  McDeleteReply(const McDeleteReply&) = default;
  McDeleteReply& operator=(const McDeleteReply&) = default;
  McDeleteReply(McDeleteReply&&) = default;
  McDeleteReply& operator=(McDeleteReply&&) = default;
  explicit McDeleteReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  uint64_t flags_{0};
  folly::IOBuf value_;
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McLeaseGetReply;

class McLeaseGetRequest : public carbon::RequestCommon {
 public:
  using reply_type = McLeaseGetReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 7;
  static constexpr const char* name = "lease-get";

  McLeaseGetRequest() = default;
  McLeaseGetRequest(const McLeaseGetRequest&) = default;
  McLeaseGetRequest& operator=(const McLeaseGetRequest&) = default;
  McLeaseGetRequest(McLeaseGetRequest&&) = default;
  McLeaseGetRequest& operator=(McLeaseGetRequest&&) = default;
  explicit McLeaseGetRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McLeaseGetRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
};

class McLeaseGetReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 8;

  McLeaseGetReply() = default;
  McLeaseGetReply(const McLeaseGetReply&) = default;
  McLeaseGetReply& operator=(const McLeaseGetReply&) = default;
  McLeaseGetReply(McLeaseGetReply&&) = default;
  McLeaseGetReply& operator=(McLeaseGetReply&&) = default;
  explicit McLeaseGetReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  int64_t leaseToken() const {
    return leaseToken_;
  }
  int64_t& leaseToken() {
    return leaseToken_;
  }
  const folly::Optional<folly::IOBuf>& value() const {
    return value_;
  }
  folly::Optional<folly::IOBuf>& value() {
    return value_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  int64_t leaseToken_{0};
  folly::Optional<folly::IOBuf> value_;
  uint64_t flags_{0};
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McLeaseSetReply;

class McLeaseSetRequest : public carbon::RequestCommon {
 public:
  using reply_type = McLeaseSetReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 9;
  static constexpr const char* name = "lease-set";

  McLeaseSetRequest() = default;
  McLeaseSetRequest(const McLeaseSetRequest&) = default;
  McLeaseSetRequest& operator=(const McLeaseSetRequest&) = default;
  McLeaseSetRequest(McLeaseSetRequest&&) = default;
  McLeaseSetRequest& operator=(McLeaseSetRequest&&) = default;
  explicit McLeaseSetRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McLeaseSetRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  int64_t leaseToken() const {
    return leaseToken_;
  }
  int64_t& leaseToken() {
    return leaseToken_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int64_t leaseToken_{0};
  int32_t exptime_{0};
};

class McLeaseSetReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 10;

  McLeaseSetReply() = default;
  McLeaseSetReply(const McLeaseSetReply&) = default;
  McLeaseSetReply& operator=(const McLeaseSetReply&) = default;
  McLeaseSetReply(McLeaseSetReply&&) = default;
  McLeaseSetReply& operator=(McLeaseSetReply&&) = default;
  explicit McLeaseSetReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McAddReply;

class McAddRequest : public carbon::RequestCommon {
 public:
  using reply_type = McAddReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 11;
  static constexpr const char* name = "add";

  McAddRequest() = default;
  McAddRequest(const McAddRequest&) = default;
  McAddRequest& operator=(const McAddRequest&) = default;
  McAddRequest(McAddRequest&&) = default;
  McAddRequest& operator=(McAddRequest&&) = default;
  explicit McAddRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McAddRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int32_t exptime_{0};
};

class McAddReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 12;

  McAddReply() = default;
  McAddReply(const McAddReply&) = default;
  McAddReply& operator=(const McAddReply&) = default;
  McAddReply(McAddReply&&) = default;
  McAddReply& operator=(McAddReply&&) = default;
  explicit McAddReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McReplaceReply;

class McReplaceRequest : public carbon::RequestCommon {
 public:
  using reply_type = McReplaceReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 13;
  static constexpr const char* name = "replace";

  McReplaceRequest() = default;
  McReplaceRequest(const McReplaceRequest&) = default;
  McReplaceRequest& operator=(const McReplaceRequest&) = default;
  McReplaceRequest(McReplaceRequest&&) = default;
  McReplaceRequest& operator=(McReplaceRequest&&) = default;
  explicit McReplaceRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McReplaceRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int32_t exptime_{0};
};

class McReplaceReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 14;

  McReplaceReply() = default;
  McReplaceReply(const McReplaceReply&) = default;
  McReplaceReply& operator=(const McReplaceReply&) = default;
  McReplaceReply(McReplaceReply&&) = default;
  McReplaceReply& operator=(McReplaceReply&&) = default;
  explicit McReplaceReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McGetsReply;

class McGetsRequest : public carbon::RequestCommon {
 public:
  using reply_type = McGetsReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 15;
  static constexpr const char* name = "gets";

  McGetsRequest() = default;
  McGetsRequest(const McGetsRequest&) = default;
  McGetsRequest& operator=(const McGetsRequest&) = default;
  McGetsRequest(McGetsRequest&&) = default;
  McGetsRequest& operator=(McGetsRequest&&) = default;
  explicit McGetsRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McGetsRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
};

class McGetsReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 16;

  McGetsReply() = default;
  McGetsReply(const McGetsReply&) = default;
  McGetsReply& operator=(const McGetsReply&) = default;
  McGetsReply(McGetsReply&&) = default;
  McGetsReply& operator=(McGetsReply&&) = default;
  explicit McGetsReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  uint64_t casToken() const {
    return casToken_;
  }
  uint64_t& casToken() {
    return casToken_;
  }
  const folly::Optional<folly::IOBuf>& value() const {
    return value_;
  }
  folly::Optional<folly::IOBuf>& value() {
    return value_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  uint64_t casToken_{0};
  folly::Optional<folly::IOBuf> value_;
  uint64_t flags_{0};
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McCasReply;

class McCasRequest : public carbon::RequestCommon {
 public:
  using reply_type = McCasReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 17;
  static constexpr const char* name = "cas";

  McCasRequest() = default;
  McCasRequest(const McCasRequest&) = default;
  McCasRequest& operator=(const McCasRequest&) = default;
  McCasRequest(McCasRequest&&) = default;
  McCasRequest& operator=(McCasRequest&&) = default;
  explicit McCasRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McCasRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  uint64_t casToken() const {
    return casToken_;
  }
  uint64_t& casToken() {
    return casToken_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  uint64_t casToken_{0};
  int32_t exptime_{0};
};

class McCasReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 18;

  McCasReply() = default;
  McCasReply(const McCasReply&) = default;
  McCasReply& operator=(const McCasReply&) = default;
  McCasReply(McCasReply&&) = default;
  McCasReply& operator=(McCasReply&&) = default;
  explicit McCasReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McIncrReply;

class McIncrRequest : public carbon::RequestCommon {
 public:
  using reply_type = McIncrReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 19;
  static constexpr const char* name = "incr";

  McIncrRequest() = default;
  McIncrRequest(const McIncrRequest&) = default;
  McIncrRequest& operator=(const McIncrRequest&) = default;
  McIncrRequest(McIncrRequest&&) = default;
  McIncrRequest& operator=(McIncrRequest&&) = default;
  explicit McIncrRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McIncrRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int64_t delta() const {
    return delta_;
  }
  int64_t& delta() {
    return delta_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  int64_t delta_{0};
};

class McIncrReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 20;

  McIncrReply() = default;
  McIncrReply(const McIncrReply&) = default;
  McIncrReply& operator=(const McIncrReply&) = default;
  McIncrReply(McIncrReply&&) = default;
  McIncrReply& operator=(McIncrReply&&) = default;
  explicit McIncrReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  int64_t delta() const {
    return delta_;
  }
  int64_t& delta() {
    return delta_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  int64_t delta_{0};
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McDecrReply;

class McDecrRequest : public carbon::RequestCommon {
 public:
  using reply_type = McDecrReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 21;
  static constexpr const char* name = "decr";

  McDecrRequest() = default;
  McDecrRequest(const McDecrRequest&) = default;
  McDecrRequest& operator=(const McDecrRequest&) = default;
  McDecrRequest(McDecrRequest&&) = default;
  McDecrRequest& operator=(McDecrRequest&&) = default;
  explicit McDecrRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McDecrRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int64_t delta() const {
    return delta_;
  }
  int64_t& delta() {
    return delta_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  int64_t delta_{0};
};

class McDecrReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 22;

  McDecrReply() = default;
  McDecrReply(const McDecrReply&) = default;
  McDecrReply& operator=(const McDecrReply&) = default;
  McDecrReply(McDecrReply&&) = default;
  McDecrReply& operator=(McDecrReply&&) = default;
  explicit McDecrReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  int64_t delta() const {
    return delta_;
  }
  int64_t& delta() {
    return delta_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  int64_t delta_{0};
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McMetagetReply;

class McMetagetRequest : public carbon::RequestCommon {
 public:
  using reply_type = McMetagetReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 23;
  static constexpr const char* name = "metaget";

  McMetagetRequest() = default;
  McMetagetRequest(const McMetagetRequest&) = default;
  McMetagetRequest& operator=(const McMetagetRequest&) = default;
  McMetagetRequest(McMetagetRequest&&) = default;
  McMetagetRequest& operator=(McMetagetRequest&&) = default;
  explicit McMetagetRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McMetagetRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
};

class McMetagetReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 24;

  McMetagetReply() = default;
  McMetagetReply(const McMetagetReply&) = default;
  McMetagetReply& operator=(const McMetagetReply&) = default;
  McMetagetReply(McMetagetReply&&) = default;
  McMetagetReply& operator=(McMetagetReply&&) = default;
  explicit McMetagetReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  int32_t age() const {
    return age_;
  }
  int32_t& age() {
    return age_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  int16_t ipv() const {
    return ipv_;
  }
  int16_t& ipv() {
    return ipv_;
  }
  const std::string& ipAddress() const {
    return ipAddress_;
  }
  std::string& ipAddress() {
    return ipAddress_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string ipAddress_;
  std::string message_;
  int32_t age_{0};
  int32_t exptime_{0};
  carbon::Result result_{mc_res_unknown};
  int16_t ipv_{0};
  int16_t appSpecificErrorCode_{0};
};

class McAppendReply;

class McAppendRequest : public carbon::RequestCommon {
 public:
  using reply_type = McAppendReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 27;
  static constexpr const char* name = "append";

  McAppendRequest() = default;
  McAppendRequest(const McAppendRequest&) = default;
  McAppendRequest& operator=(const McAppendRequest&) = default;
  McAppendRequest(McAppendRequest&&) = default;
  McAppendRequest& operator=(McAppendRequest&&) = default;
  explicit McAppendRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McAppendRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int32_t exptime_{0};
};

class McAppendReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 28;

  McAppendReply() = default;
  McAppendReply(const McAppendReply&) = default;
  McAppendReply& operator=(const McAppendReply&) = default;
  McAppendReply(McAppendReply&&) = default;
  McAppendReply& operator=(McAppendReply&&) = default;
  explicit McAppendReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McPrependReply;

class McPrependRequest : public carbon::RequestCommon {
 public:
  using reply_type = McPrependReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = true;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = true;
  static constexpr size_t typeId = 29;
  static constexpr const char* name = "prepend";

  McPrependRequest() = default;
  McPrependRequest(const McPrependRequest&) = default;
  McPrependRequest& operator=(const McPrependRequest&) = default;
  McPrependRequest(McPrependRequest&&) = default;
  McPrependRequest& operator=(McPrependRequest&&) = default;
  explicit McPrependRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McPrependRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return flags_;
  }
  uint64_t& flags() {
    return flags_;
  }
  const folly::IOBuf& value() const {
    return value_;
  }
  folly::IOBuf& value() {
    return value_;
  }
  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  uint64_t flags_{0};
  folly::IOBuf value_;
  int32_t exptime_{0};
};

class McPrependReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 30;

  McPrependReply() = default;
  McPrependReply(const McPrependReply&) = default;
  McPrependReply& operator=(const McPrependReply&) = default;
  McPrependReply(McPrependReply&&) = default;
  McPrependReply& operator=(McPrependReply&&) = default;
  explicit McPrependReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McTouchReply;

class McTouchRequest : public carbon::RequestCommon {
 public:
  using reply_type = McTouchReply;
  static constexpr bool hasExptime = true;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 31;
  static constexpr const char* name = "touch";

  McTouchRequest() = default;
  McTouchRequest(const McTouchRequest&) = default;
  McTouchRequest& operator=(const McTouchRequest&) = default;
  McTouchRequest(McTouchRequest&&) = default;
  McTouchRequest& operator=(McTouchRequest&&) = default;
  explicit McTouchRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McTouchRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t exptime() const {
    return exptime_;
  }
  int32_t& exptime() {
    return exptime_;
  }
  uint64_t flags() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  int32_t exptime_{0};
};

class McTouchReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 32;

  McTouchReply() = default;
  McTouchReply(const McTouchReply&) = default;
  McTouchReply& operator=(const McTouchReply&) = default;
  McTouchReply(McTouchReply&&) = default;
  McTouchReply& operator=(McTouchReply&&) = default;
  explicit McTouchReply(carbon::Result carbonResult) : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McFlushReReply;

class McFlushReRequest : public carbon::RequestCommon {
 public:
  using reply_type = McFlushReReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 41;
  static constexpr const char* name = "flushre";

  McFlushReRequest() = default;
  McFlushReRequest(const McFlushReRequest&) = default;
  McFlushReRequest& operator=(const McFlushReRequest&) = default;
  McFlushReRequest(McFlushReRequest&&) = default;
  McFlushReRequest& operator=(McFlushReRequest&&) = default;
  explicit McFlushReRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McFlushReRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
};

class McFlushReReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 42;

  McFlushReReply() = default;
  McFlushReReply(const McFlushReReply&) = default;
  McFlushReReply& operator=(const McFlushReReply&) = default;
  McFlushReReply(McFlushReReply&&) = default;
  McFlushReReply& operator=(McFlushReReply&&) = default;
  explicit McFlushReReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

class McFlushAllReply;

class McFlushAllRequest : public carbon::RequestCommon {
 public:
  using reply_type = McFlushAllReply;
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = true;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 43;
  static constexpr const char* name = "flushall";

  McFlushAllRequest() = default;
  McFlushAllRequest(const McFlushAllRequest&) = default;
  McFlushAllRequest& operator=(const McFlushAllRequest&) = default;
  McFlushAllRequest(McFlushAllRequest&&) = default;
  McFlushAllRequest& operator=(McFlushAllRequest&&) = default;
  explicit McFlushAllRequest(folly::StringPiece sp) : key_(sp) {}
  explicit McFlushAllRequest(folly::IOBuf&& carbonKey)
      : key_(std::move(carbonKey)) {}

  const carbon::Keys<folly::IOBuf>& key() const {
    return key_;
  }
  carbon::Keys<folly::IOBuf>& key() {
    return key_;
  }
  int32_t delay() const {
    return delay_;
  }
  int32_t& delay() {
    return delay_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  carbon::Keys<folly::IOBuf> key_;
  int32_t delay_{0};
};

class McFlushAllReply : public carbon::ReplyCommon {
 public:
  static constexpr bool hasExptime = false;
  static constexpr bool hasFlags = false;
  static constexpr bool hasKey = false;
  static constexpr bool hasValue = false;
  static constexpr size_t typeId = 44;

  McFlushAllReply() = default;
  McFlushAllReply(const McFlushAllReply&) = default;
  McFlushAllReply& operator=(const McFlushAllReply&) = default;
  McFlushAllReply(McFlushAllReply&&) = default;
  McFlushAllReply& operator=(McFlushAllReply&&) = default;
  explicit McFlushAllReply(carbon::Result carbonResult)
      : result_(carbonResult) {}

  carbon::Result result() const {
    return result_;
  }
  carbon::Result& result() {
    return result_;
  }
  const std::string& message() const {
    return message_;
  }
  std::string& message() {
    return message_;
  }
  int16_t appSpecificErrorCode() const {
    return appSpecificErrorCode_;
  }
  int16_t& appSpecificErrorCode() {
    return appSpecificErrorCode_;
  }
  uint64_t flags() const {
    return 0;
  }
  int32_t exptime() const {
    return 0;
  }

  void serialize(carbon::CarbonProtocolWriter& writer) const;

  void deserialize(carbon::CarbonProtocolReader& reader);

  template <class V>
  void visitFields(V&& v);
  template <class V>
  void visitFields(V&& v) const;

 private:
  std::string message_;
  carbon::Result result_{mc_res_unknown};
  int16_t appSpecificErrorCode_{0};
};

} // namespace memcache
} // namespace facebook

#include "MemcacheMessages-inl.h"
