/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com)
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * TrackInfoWindow.java
 *
 * Created on May 10, 2008, 12:42 PM
 * 
 */

package org.danizmax.jsymphonic.gui.TrackInfo;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.naurd.media.jsymphonic.title.Title;

/**
 * @author  danizmax - Daniel Žalar (danizmax@gmail.com)
 */
public class TrackInfoWindow extends javax.swing.JFrame {

     private static Logger logger = Logger.getLogger("org.danizmax.jsymphonic.gui.TrackInfo.TrackInfoWindow");
     private NumberFormat nf = NumberFormat.getInstance();
    
   /**
    * Creates new form TrackInfoWindow  
    * @param trackobject the track object that represents the file
    */
    public TrackInfoWindow(Title trackobject) {
        initComponents();
        this.setIconImage(new ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/js_logo16.png")).getImage());
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(10);
        fillFields(trackobject);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        summaryPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jSeparator7 = new javax.swing.JSeparator();
        jPanel3 = new javax.swing.JPanel();
        lenghtLabel = new javax.swing.JLabel();
        lenghtTextLabel = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        bitrateLabel = new javax.swing.JLabel();
        bitrateTextLabel = new javax.swing.JLabel();
        jSeparator3 = new javax.swing.JSeparator();
        jPanel4 = new javax.swing.JPanel();
        sizeLabel = new javax.swing.JLabel();
        sizeTextLabel = new javax.swing.JLabel();
        jSeparator2 = new javax.swing.JSeparator();
        samplerateLabel = new javax.swing.JLabel();
        samplerateTextLabel = new javax.swing.JLabel();
        jSeparator4 = new javax.swing.JSeparator();
        jPanel5 = new javax.swing.JPanel();
        formatLabel = new javax.swing.JLabel();
        formatTextLabel = new javax.swing.JLabel();
        jSeparator5 = new javax.swing.JSeparator();
        locationLabel = new javax.swing.JLabel();
        locationTextLabel = new javax.swing.JLabel();
        jSeparator6 = new javax.swing.JSeparator();
        jSeparator8 = new javax.swing.JSeparator();
        artistSummaryLabel = new javax.swing.JLabel();
        titleSummaryLabel = new javax.swing.JLabel();
        albumSummaryLabel = new javax.swing.JLabel();
        id3Panel = new javax.swing.JPanel();
        artistLabel1 = new javax.swing.JLabel();
        titleLabel = new javax.swing.JLabel();
        albumLabel = new javax.swing.JLabel();
        yearLabel = new javax.swing.JLabel();
        trackLabel = new javax.swing.JLabel();
        diskLabel = new javax.swing.JLabel();
        genreLabel = new javax.swing.JLabel();
        artistTextField = new javax.swing.JTextField();
        titleTextField = new javax.swing.JTextField();
        albumTextField = new javax.swing.JTextField();
        yearTextField = new javax.swing.JTextField();
        trackTextField = new javax.swing.JTextField();
        diskTextField = new javax.swing.JTextField();
        genreTextField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(545, 566));
        setName("Form"); // NOI18N

        okButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/ok.png"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/misc"); // NOI18N
        okButton.setText(bundle.getString("global.OK")); // NOI18N
        okButton.setName("okButton"); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/cancel.png"))); // NOI18N
        cancelButton.setText(bundle.getString("global.Cancel")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jTabbedPane1.setMinimumSize(new java.awt.Dimension(650, 310));
        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        summaryPanel.setName("summaryPanel"); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setPreferredSize(new java.awt.Dimension(74, 74));

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/icons/optical-audio.png"))); // NOI18N
        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("localization/trackinfowindow"); // NOI18N
        jLabel1.setText(bundle1.getString("TrackInfoWindow.jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 48, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jPanel2.setName("jPanel2"); // NOI18N

        jSeparator7.setName("jSeparator7"); // NOI18N

        jPanel3.setName("jPanel3"); // NOI18N

        lenghtLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        lenghtLabel.setText(bundle1.getString("TrackInfoWindow.lenghtLabel.text")); // NOI18N
        lenghtLabel.setName("lenghtLabel"); // NOI18N

        lenghtTextLabel.setName("lenghtTextLabel"); // NOI18N
        lenghtTextLabel.setPreferredSize(new java.awt.Dimension(0, 15));

        jSeparator1.setName("jSeparator1"); // NOI18N

        bitrateLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        bitrateLabel.setText(bundle1.getString("TrackInfoWindow.bitrateLabel.text")); // NOI18N
        bitrateLabel.setName("bitrateLabel"); // NOI18N

        bitrateTextLabel.setName("bitrateTextLabel"); // NOI18N
        bitrateTextLabel.setPreferredSize(new java.awt.Dimension(0, 15));

        jSeparator3.setName("jSeparator3"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(bitrateLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 206, Short.MAX_VALUE)
                            .add(lenghtLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 206, Short.MAX_VALUE)
                            .add(jPanel3Layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)
                                    .add(lenghtTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)))))
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, jSeparator3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)
                            .add(bitrateTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(lenghtLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lenghtTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bitrateLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bitrateTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 9, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        jPanel4.setName("jPanel4"); // NOI18N

        sizeLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        sizeLabel.setText(bundle1.getString("TrackInfoWindow.sizeLabel.text")); // NOI18N
        sizeLabel.setName("sizeLabel"); // NOI18N

        sizeTextLabel.setName("sizeTextLabel"); // NOI18N

        jSeparator2.setName("jSeparator2"); // NOI18N

        samplerateLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        samplerateLabel.setText(bundle1.getString("TrackInfoWindow.samplerateLabel.text")); // NOI18N
        samplerateLabel.setName("samplerateLabel"); // NOI18N

        samplerateTextLabel.setName("samplerateTextLabel"); // NOI18N
        samplerateTextLabel.setPreferredSize(new java.awt.Dimension(0, 15));

        jSeparator4.setName("jSeparator4"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel4Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(samplerateLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 206, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, sizeLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 206, Short.MAX_VALUE)
                            .add(jPanel4Layout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jSeparator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)
                                    .add(sizeTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)))))
                    .add(jPanel4Layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, samplerateTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE)
                            .add(jSeparator4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 194, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(sizeLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sizeTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(samplerateLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(samplerateTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        jPanel5.setName("jPanel5"); // NOI18N

        formatLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        formatLabel.setText(bundle1.getString("TrackInfoWindow.formatLabel.text")); // NOI18N
        formatLabel.setName("formatLabel"); // NOI18N

        formatTextLabel.setName("formatTextLabel"); // NOI18N
        formatTextLabel.setPreferredSize(new java.awt.Dimension(0, 15));

        jSeparator5.setName("jSeparator5"); // NOI18N

        locationLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        locationLabel.setText(bundle1.getString("TrackInfoWindow.locationLabel.text")); // NOI18N
        locationLabel.setName("locationLabel"); // NOI18N

        locationTextLabel.setName("locationTextLabel"); // NOI18N
        locationTextLabel.setPreferredSize(new java.awt.Dimension(0, 15));

        jSeparator6.setName("jSeparator6"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(locationLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 442, Short.MAX_VALUE)
                    .add(formatLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 442, Short.MAX_VALUE)
                    .add(jPanel5Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jSeparator6, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE)
                            .add(locationTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE)))
                    .add(jPanel5Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, jSeparator5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE)
                            .add(formatTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 430, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .add(formatLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(formatTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 9, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(locationLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(locationTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        jSeparator8.setName("jSeparator8"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2Layout.createSequentialGroup()
                        .add(jSeparator7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jSeparator8, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE))
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jPanel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jSeparator7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jSeparator8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        artistSummaryLabel.setText(bundle1.getString("TrackInfoWindow.artistSummaryLabel.text")); // NOI18N
        artistSummaryLabel.setName("artistSummaryLabel"); // NOI18N

        titleSummaryLabel.setText(bundle1.getString("TrackInfoWindow.titleSummaryLabel.text")); // NOI18N
        titleSummaryLabel.setName("titleSummaryLabel"); // NOI18N

        albumSummaryLabel.setText(bundle1.getString("TrackInfoWindow.albumSummaryLabel.text")); // NOI18N
        albumSummaryLabel.setName("albumSummaryLabel"); // NOI18N

        org.jdesktop.layout.GroupLayout summaryPanelLayout = new org.jdesktop.layout.GroupLayout(summaryPanel);
        summaryPanel.setLayout(summaryPanelLayout);
        summaryPanelLayout.setHorizontalGroup(
            summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, summaryPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(summaryPanelLayout.createSequentialGroup()
                        .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(summaryPanelLayout.createSequentialGroup()
                                .add(36, 36, 36)
                                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(artistSummaryLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                                    .add(albumSummaryLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)))
                            .add(summaryPanelLayout.createSequentialGroup()
                                .add(24, 24, 24)
                                .add(titleSummaryLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 394, Short.MAX_VALUE)))))
                .addContainerGap())
        );
        summaryPanelLayout.setVerticalGroup(
            summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(summaryPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(summaryPanelLayout.createSequentialGroup()
                        .add(titleSummaryLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(artistSummaryLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(albumSummaryLabel)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(17, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(bundle1.getString("TrackInfoWindow.summaryPanel.TabConstraints.tabTitle"), summaryPanel); // NOI18N

        id3Panel.setName("id3Panel"); // NOI18N

        artistLabel1.setFont(new java.awt.Font("SansSerif", 1, 12));
        artistLabel1.setText(bundle1.getString("TrackInfoWindow.artistLabel1.text")); // NOI18N
        artistLabel1.setName("artistLabel1"); // NOI18N

        titleLabel.setFont(new java.awt.Font("SansSerif", 1, 12));
        titleLabel.setText(bundle1.getString("TrackInfoWindow.titleLabel.text")); // NOI18N
        titleLabel.setName("titleLabel"); // NOI18N

        albumLabel.setFont(new java.awt.Font("SansSerif", 1, 12));
        albumLabel.setText(bundle1.getString("TrackInfoWindow.albumLabel.text")); // NOI18N
        albumLabel.setName("albumLabel"); // NOI18N

        yearLabel.setFont(new java.awt.Font("SansSerif", 1, 12));
        yearLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        yearLabel.setText(bundle1.getString("TrackInfoWindow.yearLabel.text")); // NOI18N
        yearLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        yearLabel.setName("yearLabel"); // NOI18N

        trackLabel.setFont(new java.awt.Font("SansSerif", 1, 12));
        trackLabel.setText(bundle1.getString("TrackInfoWindow.trackLabel.text")); // NOI18N
        trackLabel.setName("trackLabel"); // NOI18N

        diskLabel.setFont(new java.awt.Font("SansSerif", 1, 12));
        diskLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        diskLabel.setText(bundle1.getString("TrackInfoWindow.diskLabel.text")); // NOI18N
        diskLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        diskLabel.setName("diskLabel"); // NOI18N

        genreLabel.setFont(new java.awt.Font("SansSerif", 1, 12));
        genreLabel.setText(bundle1.getString("TrackInfoWindow.genreLabel.text")); // NOI18N
        genreLabel.setName("genreLabel"); // NOI18N

        artistTextField.setName("artistTextField"); // NOI18N

        titleTextField.setName("titleTextField"); // NOI18N

        albumTextField.setName("albumTextField"); // NOI18N

        yearTextField.setMaximumSize(new java.awt.Dimension(2147483647, 80));
        yearTextField.setMinimumSize(new java.awt.Dimension(4, 80));
        yearTextField.setName("yearTextField"); // NOI18N

        trackTextField.setName("trackTextField"); // NOI18N

        diskTextField.setName("diskTextField"); // NOI18N

        genreTextField.setName("genreTextField"); // NOI18N

        org.jdesktop.layout.GroupLayout id3PanelLayout = new org.jdesktop.layout.GroupLayout(id3Panel);
        id3Panel.setLayout(id3PanelLayout);
        id3PanelLayout.setHorizontalGroup(
            id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(id3PanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(id3PanelLayout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(artistTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 480, Short.MAX_VALUE))
                    .add(titleLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 492, Short.MAX_VALUE)
                    .add(artistLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 492, Short.MAX_VALUE)
                    .add(id3PanelLayout.createSequentialGroup()
                        .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(id3PanelLayout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(trackTextField))
                            .add(trackLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(id3PanelLayout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(diskTextField))
                            .add(diskLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 68, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(id3PanelLayout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(yearTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .add(yearLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 66, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, id3PanelLayout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(titleTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 480, Short.MAX_VALUE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, id3PanelLayout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(albumTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 480, Short.MAX_VALUE))
                    .add(albumLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 492, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, id3PanelLayout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(genreTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 480, Short.MAX_VALUE))
                    .add(genreLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 492, Short.MAX_VALUE))
                .addContainerGap())
        );

        id3PanelLayout.linkSize(new java.awt.Component[] {diskLabel, trackLabel, yearLabel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        id3PanelLayout.setVerticalGroup(
            id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(id3PanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(artistLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(artistTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(titleLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(titleTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(albumLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(albumTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(genreLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(genreTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(trackLabel)
                    .add(diskLabel)
                    .add(yearLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(trackTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(yearTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(diskTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(117, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(bundle1.getString("TrackInfoWindow.id3Panel.TabConstraints.tabTitle"), id3Panel); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(okButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cancelButton))
                    .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 521, Short.MAX_VALUE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {cancelButton, okButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 404, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cancelButton)
                    .add(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void fillFields(Title trackObject){
        artistTextField.setText(trackObject.getArtist());
        titleTextField.setText(trackObject.getTitle());
        albumTextField.setText(trackObject.getAlbum());
        genreTextField.setText(trackObject.getGenre());
        trackTextField.setText(String.valueOf(trackObject.getTitleNumber()));
        //diskTextField.setText(trackObject.get);
        yearTextField.setText(String.valueOf(trackObject.getYear()));
        
        titleSummaryLabel.setText(trackObject.getTitle());
        artistSummaryLabel.setText(java.util.ResourceBundle.getBundle("localization/trackinfowindow").getString("TrackInfoWindow.by") +" "+ trackObject.getArtist());
        albumSummaryLabel.setText(java.util.ResourceBundle.getBundle("localization/trackinfowindow").getString("TrackInfoWindow.on") +" " + trackObject.getAlbum());
        this.setTitle(titleLabel.getText() + " " + artistSummaryLabel.getText() +" " + albumSummaryLabel.getText());
        
        lenghtTextLabel.setText(longToTime(trackObject.getLength())); //TODO check if the method getLength() give a correct information!
        bitrateTextLabel.setText(String.valueOf(trackObject.getBitRate()) + " " + "kbps");
        samplerateTextLabel.setText(String.valueOf(trackObject.getFrequency()) + " " + "kHz");
        sizeTextLabel.setText(String.valueOf(trackObject.size()/1024) + " " + "kB");
        try {
            formatTextLabel.setText(trackObject.getFormatAsString());
            locationTextLabel.setText(trackObject.getSourceFile().getCanonicalPath());
        } catch (IOException ex) {
            Logger.getLogger(TrackInfoWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    /** convert milliseconds to d+ HH:MM:SS
     * @param t time
     * @return returns date in the form d+ HH:MM:SS
     */
    private String longToTime(long t){
        int hours=0, minutes = 0, seconds =0, days =0;
        String out ="";
        while(t>=3600000){
            hours++;
            t -=3600000;
        }

        while(hours>=24){
            days++;
            hours-=24;
        }

        while(t>=60000){
            minutes++;
            t -=60000;
        }

        seconds=(int)t/1000;
        if(days>0){
            out = days+ " dni, " + nf.format(hours)+":"+nf.format(minutes)+":"+nf.format(seconds);
        }else{
            out = nf.format(hours)+":"+nf.format(minutes)+":"+nf.format(seconds);
        }

        return  out;
    }
    
private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
this.dispose();
}//GEN-LAST:event_okButtonActionPerformed

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
this.dispose();
}//GEN-LAST:event_cancelButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel albumLabel;
    private javax.swing.JLabel albumSummaryLabel;
    private javax.swing.JTextField albumTextField;
    private javax.swing.JLabel artistLabel1;
    private javax.swing.JLabel artistSummaryLabel;
    private javax.swing.JTextField artistTextField;
    private javax.swing.JLabel bitrateLabel;
    private javax.swing.JLabel bitrateTextLabel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel diskLabel;
    private javax.swing.JTextField diskTextField;
    private javax.swing.JLabel formatLabel;
    private javax.swing.JLabel formatTextLabel;
    private javax.swing.JLabel genreLabel;
    private javax.swing.JTextField genreTextField;
    private javax.swing.JPanel id3Panel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel lenghtLabel;
    private javax.swing.JLabel lenghtTextLabel;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JLabel locationTextLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel samplerateLabel;
    private javax.swing.JLabel samplerateTextLabel;
    private javax.swing.JLabel sizeLabel;
    private javax.swing.JLabel sizeTextLabel;
    private javax.swing.JPanel summaryPanel;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JLabel titleSummaryLabel;
    private javax.swing.JTextField titleTextField;
    private javax.swing.JLabel trackLabel;
    private javax.swing.JTextField trackTextField;
    private javax.swing.JLabel yearLabel;
    private javax.swing.JTextField yearTextField;
    // End of variables declaration//GEN-END:variables

    
    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger aLogger) {
        logger = aLogger;
    }
    
    public static void setParentLogger(Logger aLogger) {
        logger.setParent(aLogger);
    }
}
