/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_iio (IcelakeX Uncore IIO)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */
static const intel_x86_umask_t icx_unc_iio_bandwidth_in[]={
  { .uname   = "PART0_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART1_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART2_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART3_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART4_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART5_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART6_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART7_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_bandwidth_out[]={
  { .uname   = "PART0_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART1_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART2_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART3_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART4_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART5_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART6_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PART7_FREERUN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_comp_buf_occupancy[]={
  { .uname   = "CMPD_ALL",
    .udesc   = "Part 0-7 (experimental)",
    .ucode   = 0x400000000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_ALL_PARTS",
    .udesc   = "Part 0-7",
    .ucode   = 0x400000000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART0",
    .udesc   = "Part 0",
    .ucode   = 0x4000000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART1",
    .udesc   = "Part 1",
    .ucode   = 0x4000000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART2",
    .udesc   = "Part 2",
    .ucode   = 0x4000000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART3",
    .udesc   = "Part 3",
    .ucode   = 0x4000000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART4",
    .udesc   = "Part 4",
    .ucode   = 0x4000000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART5",
    .udesc   = "Part 5",
    .ucode   = 0x4000000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART6",
    .udesc   = "Part 6",
    .ucode   = 0x4000000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART7",
    .udesc   = "Part 7",
    .ucode   = 0x4000000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_data_req_by_cpu[]={
  { .uname   = "CFG_READ_IOMMU0",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7100000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_IOMMU1",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7200000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART0",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7001000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART1",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7002000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART2",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7004000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART3",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7008000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART4",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7010000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART5",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7020000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART6",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7040000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART7",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7080000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_IOMMU0",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7100000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_IOMMU1",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7200000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART0",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7001000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART1",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7002000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART2",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7004000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART3",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7008000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART4",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7010000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART5",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7020000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART6",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7040000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART7",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7080000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_IOMMU0",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7100000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_IOMMU1",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7200000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART0",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7001000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART1",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7002000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART2",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7004000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART3",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7008000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART4",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7010000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART5",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7020000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART6",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7040000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART7",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7080000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_IOMMU0",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7100000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_IOMMU1",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7200000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART0",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7001000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART1",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7002000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART2",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7004000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART3",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7008000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART4",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7010000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART5",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7020000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART6",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7040000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART7",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7080000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU0",
    .udesc   = "Core reporting completion of Card read from Core DRAM (experimental)",
    .ucode   = 0x7100000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU1",
    .udesc   = "Core reporting completion of Card read from Core DRAM (experimental)",
    .ucode   = 0x7200000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART0",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7001000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART1",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7002000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART2",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7004000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART3",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7008000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART4",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7010000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART5",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7020000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART6",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7040000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART7",
    .udesc   = "Core reporting completion of Card read from Core DRAM",
    .ucode   = 0x7080000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU0",
    .udesc   = "Core writing to Card's MMIO space (experimental)",
    .ucode   = 0x7100000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU1",
    .udesc   = "Core writing to Card's MMIO space (experimental)",
    .ucode   = 0x7200000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART0",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7001000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART1",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7002000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART2",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7004000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART3",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7008000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART4",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7010000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART5",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7020000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART6",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7040000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART7",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7080000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU0",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7100000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU1",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7200000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART0",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7001000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART1",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7002000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART2",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7004000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART3",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7008000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART4",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7010000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART5",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7020000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART6",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7040000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART7",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7080000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU0",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7100000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU1",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7200000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART0",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7001000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART1",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7002000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART2",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7004000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART3",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7008000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART4",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7010000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART5",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7020000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART6",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7040000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART7",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7080000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_data_req_of_cpu[]={
  { .uname   = "ATOMIC_IOMMU0",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7100000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_IOMMU1",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7200000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART0",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7001000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART1",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7002000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART2",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7004000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART3",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7008000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART4",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7010000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART5",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7020000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART6",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7040000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART7",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7080000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_IOMMU0",
    .udesc   = "CmpD - device sending completion to CPU request (experimental)",
    .ucode   = 0x7100000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_IOMMU1",
    .udesc   = "CmpD - device sending completion to CPU request (experimental)",
    .ucode   = 0x7200000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART0",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7001000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART1",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7002000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART2",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7004000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART3",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7008000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART4",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7010000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART5",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7020000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART6",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7040000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART7",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7080000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU0",
    .udesc   = "Card reading from DRAM (experimental)",
    .ucode   = 0x7100000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU1",
    .udesc   = "Card reading from DRAM (experimental)",
    .ucode   = 0x7200000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART0",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7001000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART1",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7002000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART2",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7004000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART3",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7008000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART4",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7010000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART5",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7020000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART6",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7040000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART7",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7080000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU0",
    .udesc   = "Card writing to DRAM (experimental)",
    .ucode   = 0x7100000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU1",
    .udesc   = "Card writing to DRAM (experimental)",
    .ucode   = 0x7200000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART0",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7001000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART1",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7002000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART2",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7004000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART3",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7008000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART4",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7010000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART5",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7020000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART6",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7040000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART7",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7080000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_IOMMU0",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7100000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_IOMMU1",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7200000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART0",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7001000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART1",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7002000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART2",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7004000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART3",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7008000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART4",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7010000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART5",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7020000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART6",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7040000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART7",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7080000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU0",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7100000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU1",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7200000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART0",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7001000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART1",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7002000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART2",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7004000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART3",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7008000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART4",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7010000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART5",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7020000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART6",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7040000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART7",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7080000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU0",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7100000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU1",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7200000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART0",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7001000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART1",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7002000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART2",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7004000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART3",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7008000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART4",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7010000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART5",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7020000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART6",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7040000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART7",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7080000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_inbound_arb_won[]={
  { .uname   = "DATA",
    .udesc   = "Passing data to be written (experimental)",
    .ucode   = 0x70ff000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FINAL_RD_WR",
    .udesc   = "Issuing final read or write of line (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IOMMU_HIT",
    .udesc   = "Processing response from IOMMU (experimental)",
    .ucode   = 0x70ff000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IOMMU_REQ",
    .udesc   = "Issuing to IOMMU (experimental)",
    .ucode   = 0x70ff000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ_OWN",
    .udesc   = "Request Ownership (experimental)",
    .ucode   = 0x70ff000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "Writing line (experimental)",
    .ucode   = 0x70ff000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_iommu0[]={
  { .uname   = "1G_HITS",
    .udesc   = "IOTLB Hits to a 1G Page (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "2M_HITS",
    .udesc   = "IOTLB Hits to a 2M Page (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "4K_HITS",
    .udesc   = "IOTLB Hits to a 4K Page (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_LOOKUPS",
    .udesc   = "IOTLB lookups all (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CTXT_CACHE_HITS",
    .udesc   = "Context cache hits (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CTXT_CACHE_LOOKUPS",
    .udesc   = "Context cache lookups (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FIRST_LOOKUPS",
    .udesc   = "IOTLB lookups first (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISSES",
    .udesc   = "IOTLB Fills (same as IOTLB miss) (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_iommu1[]={
  { .uname   = "CYC_PWT_FULL",
    .udesc   = "Cycles PWT full (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_MEM_ACCESSES",
    .udesc   = "IOMMU memory access (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PWC_1G_HITS",
    .udesc   = "PWC Hit to a 1G page (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PWC_2M_HITS",
    .udesc   = "PWC Hit to a 2M page (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PWC_4K_HITS",
    .udesc   = "PWC Hit to a 4K page (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PWC_512G_HITS",
    .udesc   = "PWT Hit to a 256T page (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PWC_CACHE_FILLS",
    .udesc   = "PageWalk cache fill (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PWT_CACHE_LOOKUPS",
    .udesc   = "PageWalk cache lookup (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_iommu3[]={
  { .uname   = "INT_CACHE_HITS",
    .udesc   = "Interrupt Entry cache hit (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "INT_CACHE_LOOKUPS",
    .udesc   = "Interrupt Entry cache lookup (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_CTXT_CACHE_INVAL_DEVICE",
    .udesc   = "Device-selective Context cache invalidation cycles (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_CTXT_CACHE_INVAL_DOMAIN",
    .udesc   = "Domain-selective Context cache invalidation cycles (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_CTXT_CACHE_INVAL_GBL",
    .udesc   = "Context cache global invalidation cycles (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_INVAL_DOMAIN",
    .udesc   = "Domain-selective IOTLB invalidation cycles (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_INVAL_GBL",
    .udesc   = "Global IOTLB invalidation cycles (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NUM_INVAL_PAGE",
    .udesc   = "Page-selective IOTLB invalidation cycles (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_mask_match_or[]={
  { .uname   = "BUS0",
    .udesc   = "Non-PCIE bus (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BUS0_BUS1",
    .udesc   = "Non-PCIE bus and PCIE bus (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BUS0_NOT_BUS1",
    .udesc   = "Non-PCIE bus and !(PCIE bus) (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BUS1",
    .udesc   = "PCIE bus (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_BUS0_BUS1",
    .udesc   = "!(Non-PCIE bus) and PCIE bus (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_BUS0_NOT_BUS1",
    .udesc   = "!(Non-PCIE bus) and !(PCIE bus) (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_num_oustanding_req_from_cpu[]={
  { .uname   = "TO_IO",
    .udesc   = "To device (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_DFL,
  },
};

static const intel_x86_umask_t icx_unc_iio_num_outstanding_req_of_cpu[]={
  { .uname   = "DATA",
    .udesc   = "Passing data to be written (experimental)",
    .ucode   = 0x70ff000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FINAL_RD_WR",
    .udesc   = "Issuing final read or write of line (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IOMMU_HIT",
    .udesc   = "Processing response from IOMMU (experimental)",
    .ucode   = 0x70ff000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IOMMU_REQ",
    .udesc   = "Issuing to IOMMU (experimental)",
    .ucode   = 0x70ff000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ_OWN",
    .udesc   = "Request Ownership (experimental)",
    .ucode   = 0x70ff000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "Writing line (experimental)",
    .ucode   = 0x70ff000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_num_req_from_cpu[]={
  { .uname   = "IRP",
    .udesc   = "From IRP (experimental)",
    .ucode   = 0x70ff000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ITC",
    .udesc   = "From ITC (experimental)",
    .ucode   = 0x70ff000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PREALLOC",
    .udesc   = "Completion allocations (experimental)",
    .ucode   = 0x70ff000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_num_req_of_cpu[]={
  { .uname   = "ALL_DROP",
    .udesc   = "Drop request (experimental)",
    .ucode   = 0x70ff000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "COMMIT_ALL",
    .udesc   = "All",
    .ucode   = 0x70ff000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_num_req_of_cpu_by_tgt[]={
  { .uname   = "ABORT",
    .udesc   = "Abort (experimental)",
    .ucode   = 0x70ff000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CONFINED_P2P",
    .udesc   = "Confined P2P (experimental)",
    .ucode   = 0x70ff000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_P2P",
    .udesc   = "Local P2P (experimental)",
    .ucode   = 0x70ff000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MCAST",
    .udesc   = "Multi-cast (experimental)",
    .ucode   = 0x70ff000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM",
    .udesc   = "Memory (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSGB",
    .udesc   = "MsgB (experimental)",
    .ucode   = 0x70ff000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REM_P2P",
    .udesc   = "Remote P2P (experimental)",
    .ucode   = 0x70ff000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UBOX",
    .udesc   = "Ubox (experimental)",
    .ucode   = 0x70ff000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_outbound_cl_reqs_issued[]={
  { .uname   = "TO_IO",
    .udesc   = "64B requests issued to device (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_DFL,
  },
};

static const intel_x86_umask_t icx_unc_iio_outbound_tlp_reqs_issued[]={
  { .uname   = "TO_IO",
    .udesc   = "To device (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_DFL,
  },
};

static const intel_x86_umask_t icx_unc_iio_req_from_pcie_cmpl[]={
  { .uname   = "DATA",
    .udesc   = "Passing data to be written (experimental)",
    .ucode   = 0x70ff000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FINAL_RD_WR",
    .udesc   = "Issuing final read or write of line (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IOMMU_HIT",
    .udesc   = "Processing response from IOMMU (experimental)",
    .ucode   = 0x70ff000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IOMMU_REQ",
    .udesc   = "Issuing to IOMMU (experimental)",
    .ucode   = 0x70ff000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ_OWN",
    .udesc   = "Request Ownership (experimental)",
    .ucode   = 0x70ff000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "Writing line (experimental)",
    .ucode   = 0x70ff000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_req_from_pcie_pass_cmpl[]={
  { .uname   = "DATA",
    .udesc   = "Passing data to be written (experimental)",
    .ucode   = 0x70ff000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FINAL_RD_WR",
    .udesc   = "Issuing final read or write of line (experimental)",
    .ucode   = 0x70ff000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ_OWN",
    .udesc   = "Request Ownership (experimental)",
    .ucode   = 0x70ff000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WR",
    .udesc   = "Writing line (experimental)",
    .ucode   = 0x70ff000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_txn_req_by_cpu[]={
  { .uname   = "CFG_READ_IOMMU0",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7100000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_IOMMU1",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7200000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART0",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7001000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART1",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7002000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART2",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7004000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART3",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7008000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART4",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7010000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART5",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7020000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART6",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7040000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_READ_PART7",
    .udesc   = "Core reading from Card's PCICFG space (experimental)",
    .ucode   = 0x7080000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_IOMMU0",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7100000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_IOMMU1",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7200000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART0",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7001000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART1",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7002000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART2",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7004000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART3",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7008000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART4",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7010000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART5",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7020000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART6",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7040000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CFG_WRITE_PART7",
    .udesc   = "Core writing to Card's PCICFG space (experimental)",
    .ucode   = 0x7080000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_IOMMU0",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7100000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_IOMMU1",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7200000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART0",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7001000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART1",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7002000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART2",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7004000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART3",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7008000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART4",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7010000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART5",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7020000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART6",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7040000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_READ_PART7",
    .udesc   = "Core reading from Card's IO space (experimental)",
    .ucode   = 0x7080000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_IOMMU0",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7100000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_IOMMU1",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7200000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART0",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7001000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART1",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7002000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART2",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7004000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART3",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7008000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART4",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7010000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART5",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7020000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART6",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7040000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WRITE_PART7",
    .udesc   = "Core writing to Card's IO space (experimental)",
    .ucode   = 0x7080000002000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU0",
    .udesc   = "Core reading from Card's MMIO space (experimental)",
    .ucode   = 0x7100000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU1",
    .udesc   = "Core reading from Card's MMIO space (experimental)",
    .ucode   = 0x7200000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART0",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7001000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART1",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7002000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART2",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7004000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART3",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7008000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART4",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7010000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART5",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7020000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART6",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7040000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART7",
    .udesc   = "Core reading from Card's MMIO space",
    .ucode   = 0x7080000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU0",
    .udesc   = "Core writing to Card's MMIO space (experimental)",
    .ucode   = 0x7100000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU1",
    .udesc   = "Core writing to Card's MMIO space (experimental)",
    .ucode   = 0x7200000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART0",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7001000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART1",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7002000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART2",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7004000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART3",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7008000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART4",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7010000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART5",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7020000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART6",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7040000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART7",
    .udesc   = "Core writing to Card's MMIO space",
    .ucode   = 0x7080000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU0",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7100000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU1",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7200000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART0",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7001000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART1",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7002000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART2",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7004000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART3",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7008000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART4",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7010000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART5",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7020000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART6",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7040000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART7",
    .udesc   = "Another card (different IIO stack) reading from this card. (experimental)",
    .ucode   = 0x7080000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU0",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7200000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART0",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7001000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART1",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7002000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART2",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7004000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART3",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7008000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART4",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7010000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART5",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7020000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART6",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7040000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART7",
    .udesc   = "Another card (different IIO stack) writing to this card. (experimental)",
    .ucode   = 0x7080000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_iio_txn_req_of_cpu[]={
  { .uname   = "ATOMIC_IOMMU0",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7100000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_IOMMU1",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7200000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART0",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7001000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART1",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7002000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART2",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7004000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART3",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7008000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART4",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7010000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART5",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7020000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART6",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7040000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ATOMIC_PART7",
    .udesc   = "Atomic requests targeting DRAM (experimental)",
    .ucode   = 0x7080000001000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_IOMMU0",
    .udesc   = "CmpD - device sending completion to CPU request (experimental)",
    .ucode   = 0x7100000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_IOMMU1",
    .udesc   = "CmpD - device sending completion to CPU request (experimental)",
    .ucode   = 0x7200000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART0",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7001000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART1",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7002000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART2",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7004000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART3",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7008000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART4",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7010000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART5",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7020000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART6",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7040000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CMPD_PART7",
    .udesc   = "CmpD - device sending completion to CPU request",
    .ucode   = 0x7080000008000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU0",
    .udesc   = "Card reading from DRAM (experimental)",
    .ucode   = 0x7100000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_IOMMU1",
    .udesc   = "Card reading from DRAM (experimental)",
    .ucode   = 0x7200000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART0",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7001000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART1",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7002000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART2",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7004000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART3",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7008000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART4",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7010000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART5",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7020000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART6",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7040000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_READ_PART7",
    .udesc   = "Card reading from DRAM",
    .ucode   = 0x7080000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU0",
    .udesc   = "Card writing to DRAM (experimental)",
    .ucode   = 0x7100000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_IOMMU1",
    .udesc   = "Card writing to DRAM (experimental)",
    .ucode   = 0x7200000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART0",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7001000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART1",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7002000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART2",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7004000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART3",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7008000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART4",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7010000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART5",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7020000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART6",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7040000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM_WRITE_PART7",
    .udesc   = "Card writing to DRAM",
    .ucode   = 0x7080000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_IOMMU0",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7100000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_IOMMU1",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7200000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART0",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7001000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART1",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7002000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART2",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7004000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART3",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7008000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART4",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7010000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART5",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7020000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART6",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7040000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MSG_PART7",
    .udesc   = "Messages (experimental)",
    .ucode   = 0x7080000004000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU0",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7100000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_IOMMU1",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7200000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART0",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7001000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART1",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7002000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART2",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7004000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART3",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7008000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART4",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7010000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART5",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7020000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART6",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7040000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_READ_PART7",
    .udesc   = "Card reading from another Card (same or different stack) (experimental)",
    .ucode   = 0x7080000000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU0",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7100000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_IOMMU1",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7200000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART0",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7001000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART1",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7002000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART2",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7004000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART3",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7008000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART4",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7010000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART5",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7020000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART6",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7040000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PEER_WRITE_PART7",
    .udesc   = "Card writing to another Card (same or different stack) (experimental)",
    .ucode   = 0x7080000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_iio_pe[]={
  { .name   = "UNC_IIO_BANDWIDTH_IN",
    .desc   = "Free running counter that increments for every 32 bytes of data sent from the IO agent to the SOC",
    .code   = 0x0000,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0x2ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_bandwidth_in),
    .umasks = icx_unc_iio_bandwidth_in,
  },
  { .name   = "UNC_IIO_BANDWIDTH_OUT",
    .desc   = "Free running counter that increments for every 32 bytes of data sent from the IO agent to the SOC",
    .code   = 0x0000,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0x200ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_bandwidth_out),
    .umasks = icx_unc_iio_bandwidth_out,
  },
  { .name   = "UNC_IIO_CLOCKTICKS",
    .desc   = "Clockticks of the integrated IO (IIO) traffic controller",
    .code   = 0x0001,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_IIO_CLOCKTICKS_FREERUN",
    .desc   = "Free running counter that increments for IIO clocktick",
    .code   = 0x0000,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0x1ull,
  },
  { .name   = "UNC_IIO_COMP_BUF_OCCUPANCY",
    .desc   = "PCIe Completion Buffer Occupancy of completions with data",
    .code   = 0x00d5,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xcull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_comp_buf_occupancy),
    .umasks = icx_unc_iio_comp_buf_occupancy,
  },
  { .name   = "UNC_IIO_DATA_REQ_BY_CPU",
    .desc   = "Data requested by the CPU",
    .code   = 0x00c0,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xcull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_data_req_by_cpu),
    .umasks = icx_unc_iio_data_req_by_cpu,
  },
  { .name   = "UNC_IIO_DATA_REQ_OF_CPU",
    .desc   = "Four byte data request of the CPU",
    .code   = 0x0083,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_data_req_of_cpu),
    .umasks = icx_unc_iio_data_req_of_cpu,
  },
  { .name   = "UNC_IIO_INBOUND_ARB_REQ",
    .desc   = "Incoming arbitration requests",
    .code   = 0x0086,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_inbound_arb_won), /* shared */
    .umasks = icx_unc_iio_inbound_arb_won,
  },
  { .name   = "UNC_IIO_INBOUND_ARB_WON",
    .desc   = "Incoming arbitration requests granted",
    .code   = 0x0087,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_inbound_arb_won),
    .umasks = icx_unc_iio_inbound_arb_won,
  },
  { .name   = "UNC_IIO_IOMMU0",
    .desc   = "TBD",
    .code   = 0x0040,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_iommu0),
    .umasks = icx_unc_iio_iommu0,
  },
  { .name   = "UNC_IIO_IOMMU1",
    .desc   = "TBD",
    .code   = 0x0041,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_iommu1),
    .umasks = icx_unc_iio_iommu1,
  },
  { .name   = "UNC_IIO_IOMMU3",
    .desc   = "TBD",
    .code   = 0x0043,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_iommu3),
    .umasks = icx_unc_iio_iommu3,
  },
  { .name   = "UNC_IIO_MASK_MATCH_AND",
    .desc   = "AND Mask/match for debug bus",
    .code   = 0x0002,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_mask_match_or), /* shared */
    .umasks = icx_unc_iio_mask_match_or,
  },
  { .name   = "UNC_IIO_MASK_MATCH_OR",
    .desc   = "OR Mask/match for debug bus",
    .code   = 0x0003,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_mask_match_or),
    .umasks = icx_unc_iio_mask_match_or,
  },
  { .name   = "UNC_IIO_NOTHING",
    .desc   = "Counting disabled (experimental)",
    .code   = 0x0080,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_IIO_NUM_OUSTANDING_REQ_FROM_CPU",
    .desc   = "Occupancy of outbound request queue",
    .code   = 0x00c5,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xcull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_num_oustanding_req_from_cpu),
    .umasks = icx_unc_iio_num_oustanding_req_from_cpu,
  },
  { .name   = "UNC_IIO_NUM_OUTSTANDING_REQ_OF_CPU",
    .desc   = "TBD",
    .code   = 0x0088,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xcull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_num_outstanding_req_of_cpu),
    .umasks = icx_unc_iio_num_outstanding_req_of_cpu,
  },
  { .name   = "UNC_IIO_NUM_REQ_FROM_CPU",
    .desc   = "Number requests sent to PCIe from main die",
    .code   = 0x00c2,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_num_req_from_cpu),
    .umasks = icx_unc_iio_num_req_from_cpu,
  },
  { .name   = "UNC_IIO_NUM_REQ_OF_CPU",
    .desc   = "Number requests PCIe makes of the main die",
    .code   = 0x0085,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_num_req_of_cpu),
    .umasks = icx_unc_iio_num_req_of_cpu,
  },
  { .name   = "UNC_IIO_NUM_REQ_OF_CPU_BY_TGT",
    .desc   = "Num requests sent by PCIe - by target",
    .code   = 0x008e,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_num_req_of_cpu_by_tgt),
    .umasks = icx_unc_iio_num_req_of_cpu_by_tgt,
  },
  { .name   = "UNC_IIO_NUM_TGT_MATCHED_REQ_OF_CPU",
    .desc   = "ITC address map 1 (experimental)",
    .code   = 0x008f,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_IIO_OUTBOUND_CL_REQS_ISSUED",
    .desc   = "Outbound cacheline requests issued",
    .code   = 0x00d0,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_outbound_cl_reqs_issued),
    .umasks = icx_unc_iio_outbound_cl_reqs_issued,
  },
  { .name   = "UNC_IIO_OUTBOUND_TLP_REQS_ISSUED",
    .desc   = "Outbound TLP (transaction layer packet) requests issued",
    .code   = 0x00d1,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_outbound_tlp_reqs_issued),
    .umasks = icx_unc_iio_outbound_tlp_reqs_issued,
  },
  { .name   = "UNC_IIO_PWT_OCCUPANCY",
    .desc   = "PWT occupancy (experimental)",
    .code   = 0x0042,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_IIO_REQ_FROM_PCIE_CL_CMPL",
    .desc   = "PCIe Request - cacheline complete",
    .code   = 0x0091,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_req_from_pcie_pass_cmpl), /* shared */
    .umasks = icx_unc_iio_req_from_pcie_pass_cmpl,
  },
  { .name   = "UNC_IIO_REQ_FROM_PCIE_CMPL",
    .desc   = "PCIe Request complete",
    .code   = 0x0092,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_req_from_pcie_cmpl),
    .umasks = icx_unc_iio_req_from_pcie_cmpl,
  },
  { .name   = "UNC_IIO_REQ_FROM_PCIE_PASS_CMPL",
    .desc   = "PCIe Request - pass complete",
    .code   = 0x0090,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_req_from_pcie_pass_cmpl),
    .umasks = icx_unc_iio_req_from_pcie_pass_cmpl,
  },
  { .name   = "UNC_IIO_SYMBOL_TIMES",
    .desc   = "Symbol Times on Link (experimental)",
    .code   = 0x0082,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_IIO_TXN_REQ_BY_CPU",
    .desc   = "Number Transactions requested by the CPU",
    .code   = 0x00c1,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_txn_req_by_cpu),
    .umasks = icx_unc_iio_txn_req_by_cpu,
  },
  { .name   = "UNC_IIO_TXN_REQ_OF_CPU",
    .desc   = "Number Transactions requested of the CPU",
    .code   = 0x0084,
    .modmsk = ICX_UNC_IIO_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_iio_txn_req_of_cpu),
    .umasks = icx_unc_iio_txn_req_of_cpu,
  },
};
/* 31 events available */
