/*
 * Copyright 2003-2007 Keith Seymour.
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file was auto-generated by the org.netlib.generate.JavaGenerator
 * program, a part of netlib-java.
 * 
 * @see http://code.google.com/p/netlib-java/
 */
package org.netlib.lapack;

import java.util.logging.Logger;
import org.netlib.util.StringW;
import org.netlib.util.booleanW;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

/**
 * LAPACK provider which will attempt to access a native implementation
 * and falling back to use F2J if none is available.
 *
 * @see http://sourceforge.net/projects/f2j
 * @see http://www.netlib.org/lapack/
 * @author Samuel Halliday
 */
public abstract class LAPACK {

	static private final LAPACK current;
	static {
		Logger logger = Logger.getLogger("org.netlib.lapack");
		if (NativeLAPACK.INSTANCE.isLoaded) {
			current = NativeLAPACK.INSTANCE;
			logger.config("Using JNI for LAPACK");
		} else {
			current = JLAPACK.INSTANCE;
			logger.config("Using F2J as JNI failed for LAPACK");
		}
		current.slamch("E");
		current.dlamch("E");
	}

	public static LAPACK getInstance() {
		return current;
	}

	/**
<pre>

     ..

  Purpose
  =======

  DBDSDC computes the singular value decomposition (SVD) of a real
  N-by-N (upper or lower) bidiagonal matrix B:  B = U * S * VT,
  using a divide and conquer method, where S is a diagonal matrix
  with non-negative diagonal elements (the singular values of B), and
  U and VT are orthogonal matrices of left and right singular vectors,

  respectively. DBDSDC can be used to compute all singular values,
  and optionally, singular vectors or singular vectors in compact form.

  This code makes very mild assumptions about floating point
  arithmetic. It will work on machines with a guard digit in
  add/subtract, or on those binary machines without guard digits
  which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.
  It could conceivably fail on hexadecimal or decimal machines
  without guard digits, but we know of none.  See DLASD3 for details.

  The code currently calls DLASDQ if singular values only are desired.

  However, it can be slightly modified to compute singular values
  using the divide and conquer method.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  B is upper bidiagonal.
          = 'L':  B is lower bidiagonal.

  COMPQ   (input) CHARACTER*1
          Specifies whether singular vectors are to be computed
          as follows:
          = 'N':  Compute singular values only;
          = 'P':  Compute singular values and compute singular
                  vectors in compact form;
          = 'I':  Compute singular values and singular vectors.

  N       (input) INTEGER
          The order of the matrix B.  N >= 0.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the n diagonal elements of the bidiagonal matrix B.
          On exit, if INFO=0, the singular values of B.

  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, the elements of E contain the offdiagonal
          elements of the bidiagonal matrix whose SVD is desired.
          On exit, E has been destroyed.

  U       (output) DOUBLE PRECISION array, dimension (LDU,N)
          If  COMPQ = 'I', then:
             On exit, if INFO = 0, U contains the left singular vectors
             of the bidiagonal matrix.
          For other values of COMPQ, U is not referenced.

  LDU     (input) INTEGER
          The leading dimension of the array U.  LDU >= 1.
          If singular vectors are desired, then LDU >= max( 1, N ).

  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
          If  COMPQ = 'I', then:
             On exit, if INFO = 0, VT' contains the right singular
             vectors of the bidiagonal matrix.
          For other values of COMPQ, VT is not referenced.

  LDVT    (input) INTEGER
          The leading dimension of the array VT.  LDVT >= 1.
          If singular vectors are desired, then LDVT >= max( 1, N ).

  Q       (output) DOUBLE PRECISION array, dimension (LDQ)
          If  COMPQ = 'P', then:
             On exit, if INFO = 0, Q and IQ contain the left
             and right singular vectors in a compact form,
             requiring O(N log N) space instead of 2*N**2.
             In particular, Q contains all the DOUBLE PRECISION data in
             LDQ >= N*(11 + 2*SMLSIZ + 8*INT(LOG_2(N/(SMLSIZ+1))))
             words of memory, where SMLSIZ is returned by ILAENV and
             is equal to the maximum size of the subproblems at the
             bottom of the computation tree (usually about 25).
          For other values of COMPQ, Q is not referenced.

  IQ      (output) INTEGER array, dimension (LDIQ)
          If  COMPQ = 'P', then:
             On exit, if INFO = 0, Q and IQ contain the left
             and right singular vectors in a compact form,
             requiring O(N log N) space instead of 2*N**2.
             In particular, IQ contains all INTEGER data in
             LDIQ >= N*(3 + 3*INT(LOG_2(N/(SMLSIZ+1))))
             words of memory, where SMLSIZ is returned by ILAENV and
             is equal to the maximum size of the subproblems at the
             bottom of the computation tree (usually about 25).
          For other values of COMPQ, IQ is not referenced.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK))

          If COMPQ = 'N' then LWORK >= (4 * N).
          If COMPQ = 'P' then LWORK >= (6 * N).
          If COMPQ = 'I' then LWORK >= (3 * N**2 + 4 * N).

  IWORK   (workspace) INTEGER array, dimension (8*N)

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  The algorithm failed to compute an singular value.
                The update process of divide and conquer failed.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================
  Changed dimension statement in comment describing E from (N) to
  (N-1).  Sven, 17 Feb 05.
  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param compq
	 * @param n
	 * @param d
	 * @param e
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param ldvt
	 * @param q
	 * @param iq
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dbdsdc(String uplo, String compq, int n, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, double[] q, int[] iq, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DBDSQR computes the singular values and, optionally, the right and/or
  left singular vectors from the singular value decomposition (SVD) of

  a real N-by-N (upper or lower) bidiagonal matrix B using the implicit
  zero-shift QR algorithm.  The SVD of B has the form
 
     B = Q * S * P**T
 
  where S is the diagonal matrix of singular values, Q is an orthogonal
  matrix of left singular vectors, and P is an orthogonal matrix of
  right singular vectors.  If left singular vectors are requested, this
  subroutine actually returns U*Q instead of Q, and, if right singular

  vectors are requested, this subroutine returns P**T*VT instead of
  P**T, for given real input matrices U and VT.  When U and VT are the

  orthogonal matrices that reduce a general matrix A to bidiagonal
  form:  A = U*B*VT, as computed by DGEBRD, then

     A = (U*Q) * S * (P**T*VT)

  is the SVD of A.  Optionally, the subroutine may also compute Q**T*C

  for a given real input matrix C.

  See "Computing  Small Singular Values of Bidiagonal Matrices With
  Guaranteed High Relative Accuracy," by J. Demmel and W. Kahan,
  LAPACK Working Note #3 (or SIAM J. Sci. Statist. Comput. vol. 11,
  no. 5, pp. 873-912, Sept 1990) and
  "Accurate singular values and differential qd algorithms," by
  B. Parlett and V. Fernando, Technical Report CPAM-554, Mathematics
  Department, University of California at Berkeley, July 1992
  for a detailed description of the algorithm.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  B is upper bidiagonal;
          = 'L':  B is lower bidiagonal.

  N       (input) INTEGER
          The order of the matrix B.  N >= 0.

  NCVT    (input) INTEGER
          The number of columns of the matrix VT. NCVT >= 0.

  NRU     (input) INTEGER
          The number of rows of the matrix U. NRU >= 0.

  NCC     (input) INTEGER
          The number of columns of the matrix C. NCC >= 0.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the n diagonal elements of the bidiagonal matrix B.
          On exit, if INFO=0, the singular values of B in decreasing
          order.

  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, the N-1 offdiagonal elements of the bidiagonal
          matrix B. 
          On exit, if INFO = 0, E is destroyed; if INFO > 0, D and E
          will contain the diagonal and superdiagonal elements of a
          bidiagonal matrix orthogonally equivalent to the one given
          as input.

  VT      (input/output) DOUBLE PRECISION array, dimension (LDVT, NCVT)
          On entry, an N-by-NCVT matrix VT.
          On exit, VT is overwritten by P**T * VT.
          Not referenced if NCVT = 0.

  LDVT    (input) INTEGER
          The leading dimension of the array VT.
          LDVT >= max(1,N) if NCVT > 0; LDVT >= 1 if NCVT = 0.

  U       (input/output) DOUBLE PRECISION array, dimension (LDU, N)
          On entry, an NRU-by-N matrix U.
          On exit, U is overwritten by U * Q.
          Not referenced if NRU = 0.

  LDU     (input) INTEGER
          The leading dimension of the array U.  LDU >= max(1,NRU).

  C       (input/output) DOUBLE PRECISION array, dimension (LDC, NCC)
          On entry, an N-by-NCC matrix C.
          On exit, C is overwritten by Q**T * C.
          Not referenced if NCC = 0.

  LDC     (input) INTEGER
          The leading dimension of the array C.
          LDC >= max(1,N) if NCC > 0; LDC >=1 if NCC = 0.

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
          if NCVT = NRU = NCC = 0, (max(1, 4*N)) otherwise

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  If INFO = -i, the i-th argument had an illegal value
          > 0:  the algorithm did not converge; D and E contain the
                elements of a bidiagonal matrix which is orthogonally
                similar to the input matrix B;  if INFO = i, i
                elements of E have not converged to zero.

  Internal Parameters
  ===================

  TOLMUL  DOUBLE PRECISION, default = max(10,min(100,EPS**(-1/8)))
          TOLMUL controls the convergence criterion of the QR loop.
          If it is positive, TOLMUL*EPS is the desired relative
             precision in the computed singular values.
          If it is negative, abs(TOLMUL*EPS*sigma_max) is the
             desired absolute accuracy in the computed singular
             values (corresponds to relative accuracy
             abs(TOLMUL*EPS) in the largest singular value.
          abs(TOLMUL) should be between 1 and 1/EPS, and preferably
             between 10 (for fast convergence) and .1/EPS
             (for there to be some accuracy in the results).
          Default is to lose at either one eighth or 2 of the
             available decimal digits in each computed singular value
             (whichever is smaller).

  MAXITR  INTEGER, default = 6
          MAXITR controls the maximum number of passes of the
          algorithm through its inner loop. The algorithms stops
          (and so fails to converge) if the number of passes
          through the inner loop exceeds MAXITR*N**2.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ncvt
	 * @param nru
	 * @param ncc
	 * @param d
	 * @param e
	 * @param vt
	 * @param ldvt
	 * @param u
	 * @param ldu
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dbdsqr(String uplo, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DDISNA computes the reciprocal condition numbers for the eigenvectors
  of a real symmetric or complex Hermitian matrix or for the left or
  right singular vectors of a general m-by-n matrix. The reciprocal
  condition number is the 'gap' between the corresponding eigenvalue or
  singular value and the nearest other one.

  The bound on the error, measured by angle in radians, in the I-th
  computed vector is given by

         DLAMCH( 'E' ) * ( ANORM / SEP( I ) )

  where ANORM = 2-norm(A) = max( abs( D(j) ) ).  SEP(I) is not allowed

  to be smaller than DLAMCH( 'E' )*ANORM in order to limit the size of

  the error bound.

  DDISNA may also be used to compute error bounds for eigenvectors of
  the generalized symmetric definite eigenproblem.

  Arguments
  =========

  JOB     (input) CHARACTER*1
          Specifies for which problem the reciprocal condition numbers

          should be computed:
          = 'E':  the eigenvectors of a symmetric/Hermitian matrix;
          = 'L':  the left singular vectors of a general matrix;
          = 'R':  the right singular vectors of a general matrix.

  M       (input) INTEGER
          The number of rows of the matrix. M >= 0.

  N       (input) INTEGER
          If JOB = 'L' or 'R', the number of columns of the matrix,
          in which case N >= 0. Ignored if JOB = 'E'.

  D       (input) DOUBLE PRECISION array, dimension (M) if JOB = 'E'
                              dimension (min(M,N)) if JOB = 'L' or 'R'

          The eigenvalues (if JOB = 'E') or singular values (if JOB =
          'L' or 'R') of the matrix, in either increasing or decreasing
          order. If singular values, they must be non-negative.

  SEP     (output) DOUBLE PRECISION array, dimension (M) if JOB = 'E'
                               dimension (min(M,N)) if JOB = 'L' or 'R'
          The reciprocal condition numbers of the vectors.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param job
	 * @param m
	 * @param n
	 * @param d
	 * @param sep
	 * @param info
	 */
	public abstract void ddisna(String job, int m, int n, double[] d, double[] sep, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBBRD reduces a real general m-by-n band matrix A to upper
  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

  The routine computes B, and optionally forms Q or P', or computes
  Q'*C for a given matrix C.

  Arguments
  =========

  VECT    (input) CHARACTER*1
          Specifies whether or not the matrices Q and P' are to be
          formed.
          = 'N': do not form Q or P';
          = 'Q': form Q only;
          = 'P': form P' only;
          = 'B': form both.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  NCC     (input) INTEGER
          The number of columns of the matrix C.  NCC >= 0.

  KL      (input) INTEGER
          The number of subdiagonals of the matrix A. KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals of the matrix A. KU >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the m-by-n band matrix A, stored in rows 1 to
          KL+KU+1. The j-th column of A is stored in the j-th column of
          the array AB as follows:
          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).
          On exit, A is overwritten by values generated during the
          reduction.

  LDAB    (input) INTEGER
          The leading dimension of the array A. LDAB >= KL+KU+1.

  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The diagonal elements of the bidiagonal matrix B.

  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
          The superdiagonal elements of the bidiagonal matrix B.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ,M)
          If VECT = 'Q' or 'B', the m-by-m orthogonal matrix Q.
          If VECT = 'N' or 'P', the array Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.
          LDQ >= max(1,M) if VECT = 'Q' or 'B'; LDQ >= 1 otherwise.

  PT      (output) DOUBLE PRECISION array, dimension (LDPT,N)
          If VECT = 'P' or 'B', the n-by-n orthogonal matrix P'.
          If VECT = 'N' or 'Q', the array PT is not referenced.

  LDPT    (input) INTEGER
          The leading dimension of the array PT.
          LDPT >= max(1,N) if VECT = 'P' or 'B'; LDPT >= 1 otherwise.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,NCC)
          On entry, an m-by-ncc matrix C.
          On exit, C is overwritten by Q'*C.
          C is not referenced if NCC = 0.

  LDC     (input) INTEGER
          The leading dimension of the array C.
          LDC >= max(1,M) if NCC > 0; LDC >= 1 if NCC = 0.

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*max(M,N))

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param vect
	 * @param m
	 * @param n
	 * @param ncc
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param d
	 * @param e
	 * @param q
	 * @param ldq
	 * @param pt
	 * @param ldpt
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dgbbrd(String vect, int m, int n, int ncc, int kl, int ku, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] pt, int ldpt, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBCON estimates the reciprocal of the condition number of a real
  general band matrix A, in either the 1-norm or the infinity-norm,
  using the LU factorization computed by DGBTRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as
     RCOND = 1 / ( norm(A) * norm(inv(A)) ).

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies whether the 1-norm condition number or the
          infinity-norm condition number is required:
          = '1' or 'O':  1-norm;
          = 'I':         Infinity-norm.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          Details of the LU factorization of the band matrix A, as
          computed by DGBTRF.  U is stored as an upper triangular band

          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
          the multipliers used during the factorization are stored in
          rows KL+KU+2 to 2*KL+KU+1.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= N, row i of the matrix was
          interchanged with row IPIV(i).

  ANORM   (input) DOUBLE PRECISION
          If NORM = '1' or 'O', the 1-norm of the original matrix A.
          If NORM = 'I', the infinity-norm of the original matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(norm(A) * norm(inv(A))).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param ipiv
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgbcon(String norm, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBEQU computes row and column scalings intended to equilibrate an
  M-by-N band matrix A and reduce its condition number.  R returns the

  row scale factors and C the column scale factors, chosen to try to
  make the largest element in each row and column of the matrix B with

  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

  R(i) and C(j) are restricted to be between SMLNUM = smallest safe
  number and BIGNUM = largest safe number.  Use of these scaling
  factors is not guaranteed to reduce the condition number of A but
  works well in practice.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The band matrix A, stored in rows 1 to KL+KU+1.  The j-th
          column of A is stored in the j-th column of the array AB as
          follows:
          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KL+KU+1.

  R       (output) DOUBLE PRECISION array, dimension (M)
          If INFO = 0, or INFO > M, R contains the row scale factors
          for A.

  C       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, C contains the column scale factors for A.

  ROWCND  (output) DOUBLE PRECISION
          If INFO = 0 or INFO > M, ROWCND contains the ratio of the
          smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and
          AMAX is neither too large nor too small, it is not worth
          scaling by R.

  COLCND  (output) DOUBLE PRECISION
          If INFO = 0, COLCND contains the ratio of the smallest
          C(i) to the largest C(i).  If COLCND >= 0.1, it is not
          worth scaling by C.

  AMAX    (output) DOUBLE PRECISION
          Absolute value of largest matrix element.  If AMAX is very
          close to overflow or very close to underflow, the matrix
          should be scaled.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= M:  the i-th row of A is exactly zero
                >  M:  the (i-M)-th column of A is exactly zero

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param r
	 * @param c
	 * @param rowcnd
	 * @param colcnd
	 * @param amax
	 * @param info
	 */
	public abstract void dgbequ(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, doubleW rowcnd, doubleW colcnd, doubleW amax, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBRFS improves the computed solution to a system of linear
  equations when the coefficient matrix is banded, and provides
  error bounds and backward error estimates for the solution.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations:
          = 'N':  A * X = B     (No transpose)
          = 'T':  A**T * X = B  (Transpose)
          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The original band matrix A, stored in rows 1 to KL+KU+1.
          The j-th column of A is stored in the j-th column of the
          array AB as follows:
          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(n,j+kl).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KL+KU+1.

  AFB     (input) DOUBLE PRECISION array, dimension (LDAFB,N)
          Details of the LU factorization of the band matrix A, as
          computed by DGBTRF.  U is stored as an upper triangular band

          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
          the multipliers used during the factorization are stored in
          rows KL+KU+2 to 2*KL+KU+1.

  LDAFB   (input) INTEGER
          The leading dimension of the array AFB.  LDAFB >= 2*KL*KU+1.


  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices from DGBTRF; for 1<=i<=N, row i of the
          matrix was interchanged with row IPIV(i).

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DGBTRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param n
	 * @param kl
	 * @param ku
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param afb
	 * @param ldafb
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgbrfs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBSV computes the solution to a real system of linear equations
  A * X = B, where A is a band matrix of order N with KL subdiagonals
  and KU superdiagonals, and X and B are N-by-NRHS matrices.

  The LU decomposition with partial pivoting and row interchanges is
  used to factor A as A = L * U, where L is a product of permutation
  and unit lower triangular matrices with KL subdiagonals, and U is
  upper triangular with KL+KU superdiagonals.  The factored form of A
  is then used to solve the system of equations A * X = B.

  Arguments
  =========

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the matrix A in band storage, in rows KL+1 to
          2*KL+KU+1; rows 1 to KL of the array need not be set.
          The j-th column of A is stored in the j-th column of the
          array AB as follows:
          AB(KL+KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+KL)
          On exit, details of the factorization: U is stored as an
          upper triangular band matrix with KL+KU superdiagonals in
          rows 1 to KL+KU+1, and the multipliers used during the
          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
          See below for further details.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.

  IPIV    (output) INTEGER array, dimension (N)
          The pivot indices that define the permutation matrix P;
          row i of the matrix was interchanged with row IPIV(i).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if INFO = 0, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
                has been completed, but the factor U is exactly
                singular, and the solution has not been computed.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  M = N = 6, KL = 2, KU = 1:

  On entry:                       On exit:

      *    *    *    +    +    +       *    *    *   u14  u25  u36
      *    *    +    +    +    +       *    *   u13  u24  u35  u46
      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *

  Array elements marked * are not used by the routine; elements marked

  + need not be set on entry, but are required by the routine to store

  elements of U because of fill-in resulting from the row interchanges.

  =====================================================================

     .. External Subroutines ..
</pre>
	 * @param n
	 * @param kl
	 * @param ku
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBSVX uses the LU factorization to compute the solution to a real
  system of linear equations A * X = B, A**T * X = B, or A**H * X = B,

  where A is a band matrix of order N with KL subdiagonals and KU
  superdiagonals, and X and B are N-by-NRHS matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed by this subroutine:

  1. If FACT = 'E', real scaling factors are computed to equilibrate
     the system:
        TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B
        TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B
        TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B
     Whether or not the system will be equilibrated depends on the
     scaling of the matrix A, but if equilibration is used, A is
     overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N')
     or diag(C)*B (if TRANS = 'T' or 'C').

  2. If FACT = 'N' or 'E', the LU decomposition is used to factor the
     matrix A (after equilibration if FACT = 'E') as
        A = L * U,
     where L is a product of permutation and unit lower triangular
     matrices with KL subdiagonals, and U is upper triangular with
     KL+KU superdiagonals.

  3. If some U(i,i)=0, so that U is exactly singular, then the routine

     returns with INFO = i. Otherwise, the factored form of A is used
     to estimate the condition number of the matrix A.  If the
     reciprocal of the condition number is less than machine precision,
     INFO = N+1 is returned as a warning, but the routine still goes on
     to solve for X and compute error bounds as described below.

  4. The system of equations is solved for X using the factored form
     of A.

  5. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  6. If equilibration was used, the matrix X is premultiplied by
     diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so
     that it solves the original system before equilibration.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of the matrix A is
          supplied on entry, and if not, whether the matrix A should be
          equilibrated before it is factored.
          = 'F':  On entry, AFB and IPIV contain the factored form of
                  A.  If EQUED is not 'N', the matrix A has been
                  equilibrated with scaling factors given by R and C.
                  AB, AFB, and IPIV are not modified.
          = 'N':  The matrix A will be copied to AFB and factored.
          = 'E':  The matrix A will be equilibrated if necessary, then

                  copied to AFB and factored.

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations.
          = 'N':  A * X = B     (No transpose)
          = 'T':  A**T * X = B  (Transpose)
          = 'C':  A**H * X = B  (Transpose)

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the matrix A in band storage, in rows 1 to KL+KU+1.
          The j-th column of A is stored in the j-th column of the
          array AB as follows:
          AB(KU+1+i-j,j) = A(i,j) for max(1,j-KU)<=i<=min(N,j+kl)

          If FACT = 'F' and EQUED is not 'N', then A must have been
          equilibrated by the scaling factors in R and/or C.  AB is not
          modified if FACT = 'F' or 'N', or if FACT = 'E' and
          EQUED = 'N' on exit.

          On exit, if EQUED .ne. 'N', A is scaled as follows:
          EQUED = 'R':  A := diag(R) * A
          EQUED = 'C':  A := A * diag(C)
          EQUED = 'B':  A := diag(R) * A * diag(C).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KL+KU+1.

  AFB     (input or output) DOUBLE PRECISION array, dimension (LDAFB,N)
          If FACT = 'F', then AFB is an input argument and on entry
          contains details of the LU factorization of the band matrix
          A, as computed by DGBTRF.  U is stored as an upper triangular
          band matrix with KL+KU superdiagonals in rows 1 to KL+KU+1,
          and the multipliers used during the factorization are stored

          in rows KL+KU+2 to 2*KL+KU+1.  If EQUED .ne. 'N', then AFB is
          the factored form of the equilibrated matrix A.

          If FACT = 'N', then AFB is an output argument and on exit
          returns details of the LU factorization of A.

          If FACT = 'E', then AFB is an output argument and on exit
          returns details of the LU factorization of the equilibrated
          matrix A (see the description of AB for the form of the
          equilibrated matrix).

  LDAFB   (input) INTEGER
          The leading dimension of the array AFB.  LDAFB >= 2*KL+KU+1.


  IPIV    (input or output) INTEGER array, dimension (N)
          If FACT = 'F', then IPIV is an input argument and on entry
          contains the pivot indices from the factorization A = L*U
          as computed by DGBTRF; row i of the matrix was interchanged
          with row IPIV(i).

          If FACT = 'N', then IPIV is an output argument and on exit
          contains the pivot indices from the factorization A = L*U
          of the original matrix A.

          If FACT = 'E', then IPIV is an output argument and on exit
          contains the pivot indices from the factorization A = L*U
          of the equilibrated matrix A.

  EQUED   (input or output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration (always true if FACT = 'N').
          = 'R':  Row equilibration, i.e., A has been premultiplied by

                  diag(R).
          = 'C':  Column equilibration, i.e., A has been postmultiplied
                  by diag(C).
          = 'B':  Both row and column equilibration, i.e., A has been
                  replaced by diag(R) * A * diag(C).
          EQUED is an input argument if FACT = 'F'; otherwise, it is an
          output argument.

  R       (input or output) DOUBLE PRECISION array, dimension (N)
          The row scale factors for A.  If EQUED = 'R' or 'B', A is
          multiplied on the left by diag(R); if EQUED = 'N' or 'C', R
          is not accessed.  R is an input argument if FACT = 'F';
          otherwise, R is an output argument.  If FACT = 'F' and
          EQUED = 'R' or 'B', each element of R must be positive.

  C       (input or output) DOUBLE PRECISION array, dimension (N)
          The column scale factors for A.  If EQUED = 'C' or 'B', A is

          multiplied on the right by diag(C); if EQUED = 'N' or 'R', C

          is not accessed.  C is an input argument if FACT = 'F';
          otherwise, C is an output argument.  If FACT = 'F' and
          EQUED = 'C' or 'B', each element of C must be positive.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side matrix B.
          On exit,
          if EQUED = 'N', B is not modified;
          if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by
          diag(R)*B;
          if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is
          overwritten by diag(C)*B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X
          to the original system of equations.  Note that A and B are
          modified on exit if EQUED .ne. 'N', and the solution to the
          equilibrated system is inv(diag(C))*X if TRANS = 'N' and
          EQUED = 'C' or 'B', or inv(diag(R))*X if TRANS = 'T' or 'C'
          and EQUED = 'R' or 'B'.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The estimate of the reciprocal condition number of the matrix
          A after equilibration (if done).  If RCOND is less than the
          machine precision (in particular, if RCOND = 0), the matrix
          is singular to working precision.  This condition is
          indicated by a return code of INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (3*N)
          On exit, WORK(1) contains the reciprocal pivot growth
          factor norm(A)/norm(U). The "max absolute element" norm is
          used. If WORK(1) is much less than 1, then the stability
          of the LU factorization of the (equilibrated) matrix A
          could be poor. This also means that the solution X, condition
          estimator RCOND, and forward error bound FERR could be
          unreliable. If factorization fails with 0<INFO<=N, then
          WORK(1) contains the reciprocal pivot growth factor for the
          leading INFO columns of A.

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= N:  U(i,i) is exactly zero.  The factorization
                       has been completed, but the factor U is exactly

                       singular, so the solution and error bounds
                       could not be computed. RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param trans
	 * @param n
	 * @param kl
	 * @param ku
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param afb
	 * @param ldafb
	 * @param ipiv
	 * @param equed
	 * @param r
	 * @param c
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgbsvx(String fact, String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBTF2 computes an LU factorization of a real m-by-n band matrix A
  using partial pivoting with row interchanges.

  This is the unblocked version of the algorithm, calling Level 2 BLAS.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the matrix A in band storage, in rows KL+1 to
          2*KL+KU+1; rows 1 to KL of the array need not be set.
          The j-th column of A is stored in the j-th column of the
          array AB as follows:
          AB(kl+ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)

          On exit, details of the factorization: U is stored as an
          upper triangular band matrix with KL+KU superdiagonals in
          rows 1 to KL+KU+1, and the multipliers used during the
          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
          See below for further details.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.

  IPIV    (output) INTEGER array, dimension (min(M,N))
          The pivot indices; for 1 <= i <= min(M,N), row i of the
          matrix was interchanged with row IPIV(i).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value
          > 0: if INFO = +i, U(i,i) is exactly zero. The factorization

               has been completed, but the factor U is exactly
               singular, and division by zero will occur if it is used

               to solve a system of equations.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  M = N = 6, KL = 2, KU = 1:

  On entry:                       On exit:

      *    *    *    +    +    +       *    *    *   u14  u25  u36
      *    *    +    +    +    +       *    *   u13  u24  u35  u46
      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *

  Array elements marked * are not used by the routine; elements marked

  + need not be set on entry, but are required by the routine to store

  elements of U, because of fill-in resulting from the row
  interchanges.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param ipiv
	 * @param info
	 */
	public abstract void dgbtf2(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBTRF computes an LU factorization of a real m-by-n band matrix A
  using partial pivoting with row interchanges.

  This is the blocked version of the algorithm, calling Level 3 BLAS.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the matrix A in band storage, in rows KL+1 to
          2*KL+KU+1; rows 1 to KL of the array need not be set.
          The j-th column of A is stored in the j-th column of the
          array AB as follows:
          AB(kl+ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)

          On exit, details of the factorization: U is stored as an
          upper triangular band matrix with KL+KU superdiagonals in
          rows 1 to KL+KU+1, and the multipliers used during the
          factorization are stored in rows KL+KU+2 to 2*KL+KU+1.
          See below for further details.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.

  IPIV    (output) INTEGER array, dimension (min(M,N))
          The pivot indices; for 1 <= i <= min(M,N), row i of the
          matrix was interchanged with row IPIV(i).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value
          > 0: if INFO = +i, U(i,i) is exactly zero. The factorization

               has been completed, but the factor U is exactly
               singular, and division by zero will occur if it is used

               to solve a system of equations.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  M = N = 6, KL = 2, KU = 1:

  On entry:                       On exit:

      *    *    *    +    +    +       *    *    *   u14  u25  u36
      *    *    +    +    +    +       *    *   u13  u24  u35  u46
      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66
     a21  a32  a43  a54  a65   *      m21  m32  m43  m54  m65   *
     a31  a42  a53  a64   *    *      m31  m42  m53  m64   *    *

  Array elements marked * are not used by the routine; elements marked

  + need not be set on entry, but are required by the routine to store

  elements of U because of fill-in resulting from the row interchanges.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param ipiv
	 * @param info
	 */
	public abstract void dgbtrf(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGBTRS solves a system of linear equations
     A * X = B  or  A' * X = B
  with a general band matrix A using the LU factorization computed
  by DGBTRF.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations.
          = 'N':  A * X = B  (No transpose)
          = 'T':  A'* X = B  (Transpose)
          = 'C':  A'* X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          Details of the LU factorization of the band matrix A, as
          computed by DGBTRF.  U is stored as an upper triangular band

          matrix with KL+KU superdiagonals in rows 1 to KL+KU+1, and
          the multipliers used during the factorization are stored in
          rows KL+KU+2 to 2*KL+KU+1.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= 2*KL+KU+1.

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= N, row i of the matrix was
          interchanged with row IPIV(i).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side matrix B.
          On exit, the solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param n
	 * @param kl
	 * @param ku
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dgbtrs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEBAK forms the right or left eigenvectors of a real general matrix

  by backward transformation on the computed eigenvectors of the
  balanced matrix output by DGEBAL.

  Arguments
  =========

  JOB     (input) CHARACTER*1
          Specifies the type of backward transformation required:
          = 'N', do nothing, return immediately;
          = 'P', do backward transformation for permutation only;
          = 'S', do backward transformation for scaling only;
          = 'B', do backward transformations for both permutation and
                 scaling.
          JOB must be the same as the argument JOB supplied to DGEBAL.


  SIDE    (input) CHARACTER*1
          = 'R':  V contains right eigenvectors;
          = 'L':  V contains left eigenvectors.

  N       (input) INTEGER
          The number of rows of the matrix V.  N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          The integers ILO and IHI determined by DGEBAL.
          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.

  SCALE   (input) DOUBLE PRECISION array, dimension (N)
          Details of the permutation and scaling factors, as returned
          by DGEBAL.

  M       (input) INTEGER
          The number of columns of the matrix V.  M >= 0.

  V       (input/output) DOUBLE PRECISION array, dimension (LDV,M)
          On entry, the matrix of right or left eigenvectors to be
          transformed, as returned by DHSEIN or DTREVC.
          On exit, V is overwritten by the transformed eigenvectors.

  LDV     (input) INTEGER
          The leading dimension of the array V. LDV >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param job
	 * @param side
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param scale
	 * @param m
	 * @param v
	 * @param ldv
	 * @param info
	 */
	public abstract void dgebak(String job, String side, int n, int ilo, int ihi, double[] scale, int m, double[] v, int ldv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEBAL balances a general real matrix A.  This involves, first,
  permuting A by a similarity transformation to isolate eigenvalues
  in the first 1 to ILO-1 and last IHI+1 to N elements on the
  diagonal; and second, applying a diagonal similarity transformation
  to rows and columns ILO to IHI to make the rows and columns as
  close in norm as possible.  Both steps are optional.

  Balancing may reduce the 1-norm of the matrix, and improve the
  accuracy of the computed eigenvalues and/or eigenvectors.

  Arguments
  =========

  JOB     (input) CHARACTER*1
          Specifies the operations to be performed on A:
          = 'N':  none:  simply set ILO = 1, IHI = N, SCALE(I) = 1.0
                  for i = 1,...,N;
          = 'P':  permute only;
          = 'S':  scale only;
          = 'B':  both permute and scale.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the input matrix A.
          On exit,  A is overwritten by the balanced matrix.
          If JOB = 'N', A is not referenced.
          See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  ILO     (output) INTEGER
  IHI     (output) INTEGER
          ILO and IHI are set to integers such that on exit
          A(i,j) = 0 if i > j and j = 1,...,ILO-1 or I = IHI+1,...,N.
          If JOB = 'N' or 'S', ILO = 1 and IHI = N.

  SCALE   (output) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and scaling factors applied to
          A.  If P(j) is the index of the row and column interchanged
          with row and column j and D(j) is the scaling factor
          applied to row and column j, then
          SCALE(j) = P(j)    for j = 1,...,ILO-1
                   = D(j)    for j = ILO,...,IHI
                   = P(j)    for j = IHI+1,...,N.
          The order in which the interchanges are made is N to IHI+1,
          then 1 to ILO-1.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The permutations consist of row and column interchanges which put
  the matrix in the form

             ( T1   X   Y  )
     P A P = (  0   B   Z  )
             (  0   0   T2 )

  where T1 and T2 are upper triangular matrices whose eigenvalues lie
  along the diagonal.  The column indices ILO and IHI mark the starting
  and ending columns of the submatrix B. Balancing consists of applying
  a diagonal similarity transformation inv(D) * B * D to make the
  1-norms of each row of B and its corresponding column nearly equal.
  The output matrix is

     ( T1     X*D          Y    )
     (  0  inv(D)*B*D  inv(D)*Z ).
     (  0      0           T2   )

  Information about the permutations P and the diagonal matrix D is
  returned in the vector SCALE.

  This subroutine is based on the EISPACK routine BALANC.

  Modified by Tzu-Yi Chen, Computer Science Division, University of
    California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param job
	 * @param n
	 * @param a
	 * @param lda
	 * @param ilo
	 * @param ihi
	 * @param scale
	 * @param info
	 */
	public abstract void dgebal(String job, int n, double[] a, int lda, intW ilo, intW ihi, double[] scale, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEBD2 reduces a real general m by n matrix A to upper or lower
  bidiagonal form B by an orthogonal transformation: Q' * A * P = B.

  If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows in the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns in the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n general matrix to be reduced.
          On exit,
          if m >= n, the diagonal and the first superdiagonal are
            overwritten with the upper bidiagonal matrix B; the
            elements below the diagonal, with the array TAUQ, represent
            the orthogonal matrix Q as a product of elementary
            reflectors, and the elements above the first superdiagonal,
            with the array TAUP, represent the orthogonal matrix P as
            a product of elementary reflectors;
          if m < n, the diagonal and the first subdiagonal are
            overwritten with the lower bidiagonal matrix B; the
            elements below the first subdiagonal, with the array TAUQ,

            represent the orthogonal matrix Q as a product of
            elementary reflectors, and the elements above the diagonal,
            with the array TAUP, represent the orthogonal matrix P as
            a product of elementary reflectors.
          See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The diagonal elements of the bidiagonal matrix B:
          D(i) = A(i,i).

  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
          The off-diagonal elements of the bidiagonal matrix B:
          if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;
          if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1.

  TAUQ    (output) DOUBLE PRECISION array dimension (min(M,N))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Q. See Further Details.

  TAUP    (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix P. See Further Details.

  WORK    (workspace) DOUBLE PRECISION array, dimension (max(M,N))

  INFO    (output) INTEGER
          = 0: successful exit.
          < 0: if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrices Q and P are represented as products of elementary
  reflectors:

  If m >= n,

     Q = H(1) H(2) . . . H(n)  and  P = G(1) G(2) . . . G(n-1)

  Each H(i) and G(i) has the form:

     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'

  where tauq and taup are real scalars, and v and u are real vectors;
  v(1:i-1) = 0, v(i) = 1, and v(i+1:m) is stored on exit in A(i+1:m,i);
  u(1:i) = 0, u(i+1) = 1, and u(i+2:n) is stored on exit in A(i,i+2:n);
  tauq is stored in TAUQ(i) and taup in TAUP(i).

  If m < n,

     Q = H(1) H(2) . . . H(m-1)  and  P = G(1) G(2) . . . G(m)

  Each H(i) and G(i) has the form:

     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'

  where tauq and taup are real scalars, and v and u are real vectors;
  v(1:i) = 0, v(i+1) = 1, and v(i+2:m) is stored on exit in A(i+2:m,i);
  u(1:i-1) = 0, u(i) = 1, and u(i+1:n) is stored on exit in A(i,i+1:n);
  tauq is stored in TAUQ(i) and taup in TAUP(i).

  The contents of A on exit are illustrated by the following examples:


  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):

    (  d   e   u1  u1  u1 )           (  d   u1  u1  u1  u1  u1 )
    (  v1  d   e   u2  u2 )           (  e   d   u2  u2  u2  u2 )
    (  v1  v2  d   e   u3 )           (  v1  e   d   u3  u3  u3 )
    (  v1  v2  v3  d   e  )           (  v1  v2  e   d   u4  u4 )
    (  v1  v2  v3  v4  d  )           (  v1  v2  v3  e   d   u5 )
    (  v1  v2  v3  v4  v5 )

  where d and e denote diagonal and off-diagonal elements of B, vi
  denotes an element of the vector defining H(i), and ui an element of

  the vector defining G(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param d
	 * @param e
	 * @param tauq
	 * @param taup
	 * @param work
	 * @param info
	 */
	public abstract void dgebd2(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEBRD reduces a general real M-by-N matrix A to upper or lower
  bidiagonal form B by an orthogonal transformation: Q**T * A * P = B.


  If m >= n, B is upper bidiagonal; if m < n, B is lower bidiagonal.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows in the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns in the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N general matrix to be reduced.
          On exit,
          if m >= n, the diagonal and the first superdiagonal are
            overwritten with the upper bidiagonal matrix B; the
            elements below the diagonal, with the array TAUQ, represent
            the orthogonal matrix Q as a product of elementary
            reflectors, and the elements above the first superdiagonal,
            with the array TAUP, represent the orthogonal matrix P as
            a product of elementary reflectors;
          if m < n, the diagonal and the first subdiagonal are
            overwritten with the lower bidiagonal matrix B; the
            elements below the first subdiagonal, with the array TAUQ,

            represent the orthogonal matrix Q as a product of
            elementary reflectors, and the elements above the diagonal,
            with the array TAUP, represent the orthogonal matrix P as
            a product of elementary reflectors.
          See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  D       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The diagonal elements of the bidiagonal matrix B:
          D(i) = A(i,i).

  E       (output) DOUBLE PRECISION array, dimension (min(M,N)-1)
          The off-diagonal elements of the bidiagonal matrix B:
          if m >= n, E(i) = A(i,i+1) for i = 1,2,...,n-1;
          if m < n, E(i) = A(i+1,i) for i = 1,2,...,m-1.

  TAUQ    (output) DOUBLE PRECISION array dimension (min(M,N))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Q. See Further Details.

  TAUP    (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix P. See Further Details.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The length of the array WORK.  LWORK >= max(1,M,N).
          For optimum performance LWORK >= (M+N)*NB, where NB
          is the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrices Q and P are represented as products of elementary
  reflectors:

  If m >= n,

     Q = H(1) H(2) . . . H(n)  and  P = G(1) G(2) . . . G(n-1)

  Each H(i) and G(i) has the form:

     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'

  where tauq and taup are real scalars, and v and u are real vectors;
  v(1:i-1) = 0, v(i) = 1, and v(i+1:m) is stored on exit in A(i+1:m,i);
  u(1:i) = 0, u(i+1) = 1, and u(i+2:n) is stored on exit in A(i,i+2:n);
  tauq is stored in TAUQ(i) and taup in TAUP(i).

  If m < n,

     Q = H(1) H(2) . . . H(m-1)  and  P = G(1) G(2) . . . G(m)

  Each H(i) and G(i) has the form:

     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'

  where tauq and taup are real scalars, and v and u are real vectors;
  v(1:i) = 0, v(i+1) = 1, and v(i+2:m) is stored on exit in A(i+2:m,i);
  u(1:i-1) = 0, u(i) = 1, and u(i+1:n) is stored on exit in A(i,i+1:n);
  tauq is stored in TAUQ(i) and taup in TAUP(i).

  The contents of A on exit are illustrated by the following examples:


  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):

    (  d   e   u1  u1  u1 )           (  d   u1  u1  u1  u1  u1 )
    (  v1  d   e   u2  u2 )           (  e   d   u2  u2  u2  u2 )
    (  v1  v2  d   e   u3 )           (  v1  e   d   u3  u3  u3 )
    (  v1  v2  v3  d   e  )           (  v1  v2  e   d   u4  u4 )
    (  v1  v2  v3  v4  d  )           (  v1  v2  v3  e   d   u5 )
    (  v1  v2  v3  v4  v5 )

  where d and e denote diagonal and off-diagonal elements of B, vi
  denotes an element of the vector defining H(i), and ui an element of

  the vector defining G(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param d
	 * @param e
	 * @param tauq
	 * @param taup
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgebrd(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGECON estimates the reciprocal of the condition number of a general

  real matrix A, in either the 1-norm or the infinity-norm, using
  the LU factorization computed by DGETRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as
     RCOND = 1 / ( norm(A) * norm(inv(A)) ).

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies whether the 1-norm condition number or the
          infinity-norm condition number is required:
          = '1' or 'O':  1-norm;
          = 'I':         Infinity-norm.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The factors L and U from the factorization A = P*L*U
          as computed by DGETRF.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  ANORM   (input) DOUBLE PRECISION
          If NORM = '1' or 'O', the 1-norm of the original matrix A.
          If NORM = 'I', the infinity-norm of the original matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(norm(A) * norm(inv(A))).

  WORK    (workspace) DOUBLE PRECISION array, dimension (4*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param a
	 * @param lda
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgecon(String norm, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEEQU computes row and column scalings intended to equilibrate an
  M-by-N matrix A and reduce its condition number.  R returns the row
  scale factors and C the column scale factors, chosen to try to make
  the largest element in each row and column of the matrix B with
  elements B(i,j)=R(i)*A(i,j)*C(j) have absolute value 1.

  R(i) and C(j) are restricted to be between SMLNUM = smallest safe
  number and BIGNUM = largest safe number.  Use of these scaling
  factors is not guaranteed to reduce the condition number of A but
  works well in practice.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The M-by-N matrix whose equilibration factors are
          to be computed.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  R       (output) DOUBLE PRECISION array, dimension (M)
          If INFO = 0 or INFO > M, R contains the row scale factors
          for A.

  C       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0,  C contains the column scale factors for A.

  ROWCND  (output) DOUBLE PRECISION
          If INFO = 0 or INFO > M, ROWCND contains the ratio of the
          smallest R(i) to the largest R(i).  If ROWCND >= 0.1 and
          AMAX is neither too large nor too small, it is not worth
          scaling by R.

  COLCND  (output) DOUBLE PRECISION
          If INFO = 0, COLCND contains the ratio of the smallest
          C(i) to the largest C(i).  If COLCND >= 0.1, it is not
          worth scaling by C.

  AMAX    (output) DOUBLE PRECISION
          Absolute value of largest matrix element.  If AMAX is very
          close to overflow or very close to underflow, the matrix
          should be scaled.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i,  and i is
                <= M:  the i-th row of A is exactly zero
                >  M:  the (i-M)-th column of A is exactly zero

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param r
	 * @param c
	 * @param rowcnd
	 * @param colcnd
	 * @param amax
	 * @param info
	 */
	public abstract void dgeequ(int m, int n, double[] a, int lda, double[] r, double[] c, doubleW rowcnd, doubleW colcnd, doubleW amax, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DGEES computes for an N-by-N real nonsymmetric matrix A, the
  eigenvalues, the real Schur form T, and, optionally, the matrix of
  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).


  Optionally, it also orders the eigenvalues on the diagonal of the
  real Schur form so that selected eigenvalues are at the top left.
  The leading columns of Z then form an orthonormal basis for the
  invariant subspace corresponding to the selected eigenvalues.

  A matrix is in real Schur form if it is upper quasi-triangular with
  1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in the
  form
          [  a  b  ]
          [  c  a  ]

  where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc).

  Arguments
  =========

  JOBVS   (input) CHARACTER*1
          = 'N': Schur vectors are not computed;
          = 'V': Schur vectors are computed.

  SORT    (input) CHARACTER*1
          Specifies whether or not to order the eigenvalues on the
          diagonal of the Schur form.
          = 'N': Eigenvalues are not ordered;
          = 'S': Eigenvalues are ordered (see SELECT).

  SELECT  (external procedure) LOGICAL FUNCTION of two DOUBLE PRECISION
          SELECT must be declared EXTERNAL in the calling subroutine.
          If SORT = 'S', SELECT is used to select eigenvalues to sort
          to the top left of the Schur form.
          If SORT = 'N', SELECT is not referenced.
          An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if
          SELECT(WR(j),WI(j)) is true; i.e., if either one of a complex
          conjugate pair of eigenvalues is selected, then both complex

          eigenvalues are selected.
          Note that a selected complex eigenvalue may no longer
          satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since
          ordering may change the value of complex eigenvalues
          (especially if the eigenvalue is ill-conditioned); in this
          case INFO is set to N+2 (see INFO below).

  N       (input) INTEGER
          The order of the matrix A. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the N-by-N matrix A.
          On exit, A has been overwritten by its real Schur form T.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  SDIM    (output) INTEGER
          If SORT = 'N', SDIM = 0.
          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
                         for which SELECT is true. (Complex conjugate
                         pairs for which SELECT is true for either
                         eigenvalue count as 2.)

  WR      (output) DOUBLE PRECISION array, dimension (N)
  WI      (output) DOUBLE PRECISION array, dimension (N)
          WR and WI contain the real and imaginary parts,
          respectively, of the computed eigenvalues in the same order
          that they appear on the diagonal of the output Schur form T.

          Complex conjugate pairs of eigenvalues will appear
          consecutively with the eigenvalue having the positive
          imaginary part first.

  VS      (output) DOUBLE PRECISION array, dimension (LDVS,N)
          If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur

          vectors.
          If JOBVS = 'N', VS is not referenced.

  LDVS    (input) INTEGER
          The leading dimension of the array VS.  LDVS >= 1; if
          JOBVS = 'V', LDVS >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) contains the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,3*N).
          For good performance, LWORK must generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  BWORK   (workspace) LOGICAL array, dimension (N)
          Not referenced if SORT = 'N'.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value.
          > 0: if INFO = i, and i is
             <= N: the QR algorithm failed to compute all the
                   eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI
                   contain those eigenvalues which have converged; if
                   JOBVS = 'V', VS contains the matrix which reduces A

                   to its partially converged Schur form.
             = N+1: the eigenvalues could not be reordered because some
                   eigenvalues were too close to separate (the problem

                   is very ill-conditioned);
             = N+2: after reordering, roundoff changed values of some
                   complex eigenvalues so that leading eigenvalues in
                   the Schur form no longer satisfy SELECT=.TRUE.  This
                   could also be caused by underflow due to scaling.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvs
	 * @param sort
	 * @param select
	 * @param n
	 * @param a
	 * @param lda
	 * @param sdim
	 * @param wr
	 * @param wi
	 * @param vs
	 * @param ldvs
	 * @param work
	 * @param lwork
	 * @param bwork
	 * @param info
	 */
	public void dgees(String jobvs, String sort, Object select, int n, double[] a, int lda, intW sdim, double[] wr, double[] wi, double[] vs, int ldvs, double[] work, int lwork, boolean[] bwork, intW info) {
		org.netlib.lapack.Dgees.dgees(jobvs, sort, select, n, a, 0, lda, sdim, wr, 0, wi, 0, vs, 0, ldvs, work, 0, lwork, bwork, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DGEESX computes for an N-by-N real nonsymmetric matrix A, the
  eigenvalues, the real Schur form T, and, optionally, the matrix of
  Schur vectors Z.  This gives the Schur factorization A = Z*T*(Z**T).


  Optionally, it also orders the eigenvalues on the diagonal of the
  real Schur form so that selected eigenvalues are at the top left;
  computes a reciprocal condition number for the average of the
  selected eigenvalues (RCONDE); and computes a reciprocal condition
  number for the right invariant subspace corresponding to the
  selected eigenvalues (RCONDV).  The leading columns of Z form an
  orthonormal basis for this invariant subspace.

  For further explanation of the reciprocal condition numbers RCONDE
  and RCONDV, see Section 4.10 of the LAPACK Users' Guide (where
  these quantities are called s and sep respectively).

  A real matrix is in real Schur form if it is upper quasi-triangular
  with 1-by-1 and 2-by-2 blocks. 2-by-2 blocks will be standardized in

  the form
            [  a  b  ]
            [  c  a  ]

  where b*c < 0. The eigenvalues of such a block are a +- sqrt(bc).

  Arguments
  =========

  JOBVS   (input) CHARACTER*1
          = 'N': Schur vectors are not computed;
          = 'V': Schur vectors are computed.

  SORT    (input) CHARACTER*1
          Specifies whether or not to order the eigenvalues on the
          diagonal of the Schur form.
          = 'N': Eigenvalues are not ordered;
          = 'S': Eigenvalues are ordered (see SELECT).

  SELECT  (external procedure) LOGICAL FUNCTION of two DOUBLE PRECISION
          SELECT must be declared EXTERNAL in the calling subroutine.
          If SORT = 'S', SELECT is used to select eigenvalues to sort
          to the top left of the Schur form.
          If SORT = 'N', SELECT is not referenced.
          An eigenvalue WR(j)+sqrt(-1)*WI(j) is selected if
          SELECT(WR(j),WI(j)) is true; i.e., if either one of a
          complex conjugate pair of eigenvalues is selected, then both

          are.  Note that a selected complex eigenvalue may no longer
          satisfy SELECT(WR(j),WI(j)) = .TRUE. after ordering, since
          ordering may change the value of complex eigenvalues
          (especially if the eigenvalue is ill-conditioned); in this
          case INFO may be set to N+3 (see INFO below).

  SENSE   (input) CHARACTER*1
          Determines which reciprocal condition numbers are computed.
          = 'N': None are computed;
          = 'E': Computed for average of selected eigenvalues only;
          = 'V': Computed for selected right invariant subspace only;
          = 'B': Computed for both.
          If SENSE = 'E', 'V' or 'B', SORT must equal 'S'.

  N       (input) INTEGER
          The order of the matrix A. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the N-by-N matrix A.
          On exit, A is overwritten by its real Schur form T.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  SDIM    (output) INTEGER
          If SORT = 'N', SDIM = 0.
          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
                         for which SELECT is true. (Complex conjugate
                         pairs for which SELECT is true for either
                         eigenvalue count as 2.)

  WR      (output) DOUBLE PRECISION array, dimension (N)
  WI      (output) DOUBLE PRECISION array, dimension (N)
          WR and WI contain the real and imaginary parts, respectively,
          of the computed eigenvalues, in the same order that they
          appear on the diagonal of the output Schur form T.  Complex
          conjugate pairs of eigenvalues appear consecutively with the

          eigenvalue having the positive imaginary part first.

  VS      (output) DOUBLE PRECISION array, dimension (LDVS,N)
          If JOBVS = 'V', VS contains the orthogonal matrix Z of Schur

          vectors.
          If JOBVS = 'N', VS is not referenced.

  LDVS    (input) INTEGER
          The leading dimension of the array VS.  LDVS >= 1, and if
          JOBVS = 'V', LDVS >= N.

  RCONDE  (output) DOUBLE PRECISION
          If SENSE = 'E' or 'B', RCONDE contains the reciprocal
          condition number for the average of the selected eigenvalues.
          Not referenced if SENSE = 'N' or 'V'.

  RCONDV  (output) DOUBLE PRECISION
          If SENSE = 'V' or 'B', RCONDV contains the reciprocal
          condition number for the selected right invariant subspace.
          Not referenced if SENSE = 'N' or 'E'.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,3*N).
          Also, if SENSE = 'E' or 'V' or 'B',
          LWORK >= N+2*SDIM*(N-SDIM), where SDIM is the number of
          selected eigenvalues computed by this routine.  Note that
          N+2*SDIM*(N-SDIM) <= N+N*N/2. Note also that an error is only
          returned if LWORK < max(1,3*N), but if SENSE = 'E' or 'V' or

          'B' this may not be large enough.
          For good performance, LWORK must generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates upper bounds on the optimal sizes of the
          arrays WORK and IWORK, returns these values as the first
          entries of the WORK and IWORK arrays, and no error messages
          related to LWORK or LIWORK are issued by XERBLA.

  IWORK   (workspace/output) INTEGER array, dimension (MAX(1,LIWORK))
          On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.

  LIWORK  (input) INTEGER
          The dimension of the array IWORK.
          LIWORK >= 1; if SENSE = 'V' or 'B', LIWORK >= SDIM*(N-SDIM).

          Note that SDIM*(N-SDIM) <= N*N/4. Note also that an error is

          only returned if LIWORK < 1, but if SENSE = 'V' or 'B' this
          may not be large enough.

          If LIWORK = -1, then a workspace query is assumed; the
          routine only calculates upper bounds on the optimal sizes of

          the arrays WORK and IWORK, returns these values as the first

          entries of the WORK and IWORK arrays, and no error messages
          related to LWORK or LIWORK are issued by XERBLA.

  BWORK   (workspace) LOGICAL array, dimension (N)
          Not referenced if SORT = 'N'.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value.
          > 0: if INFO = i, and i is
             <= N: the QR algorithm failed to compute all the
                   eigenvalues; elements 1:ILO-1 and i+1:N of WR and WI
                   contain those eigenvalues which have converged; if
                   JOBVS = 'V', VS contains the transformation which
                   reduces A to its partially converged Schur form.
             = N+1: the eigenvalues could not be reordered because some
                   eigenvalues were too close to separate (the problem

                   is very ill-conditioned);
             = N+2: after reordering, roundoff changed values of some
                   complex eigenvalues so that leading eigenvalues in
                   the Schur form no longer satisfy SELECT=.TRUE.  This
                   could also be caused by underflow due to scaling.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvs
	 * @param sort
	 * @param select
	 * @param sense
	 * @param n
	 * @param a
	 * @param lda
	 * @param sdim
	 * @param wr
	 * @param wi
	 * @param vs
	 * @param ldvs
	 * @param rconde
	 * @param rcondv
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param liwork
	 * @param bwork
	 * @param info
	 */
	public void dgeesx(String jobvs, String sort, Object select, String sense, int n, double[] a, int lda, intW sdim, double[] wr, double[] wi, double[] vs, int ldvs, doubleW rconde, doubleW rcondv, double[] work, int lwork, int[] iwork, int liwork, boolean[] bwork, intW info) {
		org.netlib.lapack.Dgeesx.dgeesx(jobvs, sort, select, sense, n, a, 0, lda, sdim, wr, 0, wi, 0, vs, 0, ldvs, rconde, rcondv, work, 0, lwork, iwork, 0, liwork, bwork, 0, info);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DGEEV computes for an N-by-N real nonsymmetric matrix A, the
  eigenvalues and, optionally, the left and/or right eigenvectors.

  The right eigenvector v(j) of A satisfies
                   A * v(j) = lambda(j) * v(j)
  where lambda(j) is its eigenvalue.
  The left eigenvector u(j) of A satisfies
                u(j)**H * A = lambda(j) * u(j)**H
  where u(j)**H denotes the conjugate transpose of u(j).

  The computed eigenvectors are normalized to have Euclidean norm
  equal to 1 and largest component real.

  Arguments
  =========

  JOBVL   (input) CHARACTER*1
          = 'N': left eigenvectors of A are not computed;
          = 'V': left eigenvectors of A are computed.

  JOBVR   (input) CHARACTER*1
          = 'N': right eigenvectors of A are not computed;
          = 'V': right eigenvectors of A are computed.

  N       (input) INTEGER
          The order of the matrix A. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the N-by-N matrix A.
          On exit, A has been overwritten.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  WR      (output) DOUBLE PRECISION array, dimension (N)
  WI      (output) DOUBLE PRECISION array, dimension (N)
          WR and WI contain the real and imaginary parts,
          respectively, of the computed eigenvalues.  Complex
          conjugate pairs of eigenvalues appear consecutively
          with the eigenvalue having the positive imaginary part
          first.

  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
          If JOBVL = 'V', the left eigenvectors u(j) are stored one
          after another in the columns of VL, in the same order
          as their eigenvalues.
          If JOBVL = 'N', VL is not referenced.
          If the j-th eigenvalue is real, then u(j) = VL(:,j),
          the j-th column of VL.
          If the j-th and (j+1)-st eigenvalues form a complex
          conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
          u(j+1) = VL(:,j) - i*VL(:,j+1).

  LDVL    (input) INTEGER
          The leading dimension of the array VL.  LDVL >= 1; if
          JOBVL = 'V', LDVL >= N.

  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
          If JOBVR = 'V', the right eigenvectors v(j) are stored one
          after another in the columns of VR, in the same order
          as their eigenvalues.
          If JOBVR = 'N', VR is not referenced.
          If the j-th eigenvalue is real, then v(j) = VR(:,j),
          the j-th column of VR.
          If the j-th and (j+1)-st eigenvalues form a complex
          conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and
          v(j+1) = VR(:,j) - i*VR(:,j+1).

  LDVR    (input) INTEGER
          The leading dimension of the array VR.  LDVR >= 1; if
          JOBVR = 'V', LDVR >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,3*N), and
          if JOBVL = 'V' or JOBVR = 'V', LWORK >= 4*N.  For good
          performance, LWORK must generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = i, the QR algorithm failed to compute all the
                eigenvalues, and no eigenvectors have been computed;
                elements i+1:N of WR and WI contain eigenvalues which
                have converged.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvl
	 * @param jobvr
	 * @param n
	 * @param a
	 * @param lda
	 * @param wr
	 * @param wi
	 * @param vl
	 * @param ldvl
	 * @param vr
	 * @param ldvr
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgeev(String jobvl, String jobvr, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEEVX computes for an N-by-N real nonsymmetric matrix A, the
  eigenvalues and, optionally, the left and/or right eigenvectors.

  Optionally also, it computes a balancing transformation to improve
  the conditioning of the eigenvalues and eigenvectors (ILO, IHI,
  SCALE, and ABNRM), reciprocal condition numbers for the eigenvalues
  (RCONDE), and reciprocal condition numbers for the right
  eigenvectors (RCONDV).

  The right eigenvector v(j) of A satisfies
                   A * v(j) = lambda(j) * v(j)
  where lambda(j) is its eigenvalue.
  The left eigenvector u(j) of A satisfies
                u(j)**H * A = lambda(j) * u(j)**H
  where u(j)**H denotes the conjugate transpose of u(j).

  The computed eigenvectors are normalized to have Euclidean norm
  equal to 1 and largest component real.

  Balancing a matrix means permuting the rows and columns to make it
  more nearly upper triangular, and applying a diagonal similarity
  transformation D * A * D**(-1), where D is a diagonal matrix, to
  make its rows and columns closer in norm and the condition numbers
  of its eigenvalues and eigenvectors smaller.  The computed
  reciprocal condition numbers correspond to the balanced matrix.
  Permuting rows and columns will not change the condition numbers
  (in exact arithmetic) but diagonal scaling will.  For further
  explanation of balancing, see section 4.10.2 of the LAPACK
  Users' Guide.

  Arguments
  =========

  BALANC  (input) CHARACTER*1
          Indicates how the input matrix should be diagonally scaled
          and/or permuted to improve the conditioning of its
          eigenvalues.
          = 'N': Do not diagonally scale or permute;
          = 'P': Perform permutations to make the matrix more nearly
                 upper triangular. Do not diagonally scale;
          = 'S': Diagonally scale the matrix, i.e. replace A by
                 D*A*D**(-1), where D is a diagonal matrix chosen
                 to make the rows and columns of A more equal in
                 norm. Do not permute;
          = 'B': Both diagonally scale and permute A.

          Computed reciprocal condition numbers will be for the matrix

          after balancing and/or permuting. Permuting does not change
          condition numbers (in exact arithmetic), but balancing does.


  JOBVL   (input) CHARACTER*1
          = 'N': left eigenvectors of A are not computed;
          = 'V': left eigenvectors of A are computed.
          If SENSE = 'E' or 'B', JOBVL must = 'V'.

  JOBVR   (input) CHARACTER*1
          = 'N': right eigenvectors of A are not computed;
          = 'V': right eigenvectors of A are computed.
          If SENSE = 'E' or 'B', JOBVR must = 'V'.

  SENSE   (input) CHARACTER*1
          Determines which reciprocal condition numbers are computed.
          = 'N': None are computed;
          = 'E': Computed for eigenvalues only;
          = 'V': Computed for right eigenvectors only;
          = 'B': Computed for eigenvalues and right eigenvectors.

          If SENSE = 'E' or 'B', both left and right eigenvectors
          must also be computed (JOBVL = 'V' and JOBVR = 'V').

  N       (input) INTEGER
          The order of the matrix A. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the N-by-N matrix A.
          On exit, A has been overwritten.  If JOBVL = 'V' or
          JOBVR = 'V', A contains the real Schur form of the balanced
          version of the input matrix A.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  WR      (output) DOUBLE PRECISION array, dimension (N)
  WI      (output) DOUBLE PRECISION array, dimension (N)
          WR and WI contain the real and imaginary parts,
          respectively, of the computed eigenvalues.  Complex
          conjugate pairs of eigenvalues will appear consecutively
          with the eigenvalue having the positive imaginary part
          first.

  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
          If JOBVL = 'V', the left eigenvectors u(j) are stored one
          after another in the columns of VL, in the same order
          as their eigenvalues.
          If JOBVL = 'N', VL is not referenced.
          If the j-th eigenvalue is real, then u(j) = VL(:,j),
          the j-th column of VL.
          If the j-th and (j+1)-st eigenvalues form a complex
          conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
          u(j+1) = VL(:,j) - i*VL(:,j+1).

  LDVL    (input) INTEGER
          The leading dimension of the array VL.  LDVL >= 1; if
          JOBVL = 'V', LDVL >= N.

  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
          If JOBVR = 'V', the right eigenvectors v(j) are stored one
          after another in the columns of VR, in the same order
          as their eigenvalues.
          If JOBVR = 'N', VR is not referenced.
          If the j-th eigenvalue is real, then v(j) = VR(:,j),
          the j-th column of VR.
          If the j-th and (j+1)-st eigenvalues form a complex
          conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and
          v(j+1) = VR(:,j) - i*VR(:,j+1).

  LDVR    (input) INTEGER
          The leading dimension of the array VR.  LDVR >= 1, and if
          JOBVR = 'V', LDVR >= N.

  ILO     (output) INTEGER
  IHI     (output) INTEGER
          ILO and IHI are integer values determined when A was
          balanced.  The balanced A(i,j) = 0 if I > J and
          J = 1,...,ILO-1 or I = IHI+1,...,N.

  SCALE   (output) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and scaling factors applied
          when balancing A.  If P(j) is the index of the row and column
          interchanged with row and column j, and D(j) is the scaling
          factor applied to row and column j, then
          SCALE(J) = P(J),    for J = 1,...,ILO-1
                   = D(J),    for J = ILO,...,IHI
                   = P(J)     for J = IHI+1,...,N.
          The order in which the interchanges are made is N to IHI+1,
          then 1 to ILO-1.

  ABNRM   (output) DOUBLE PRECISION
          The one-norm of the balanced matrix (the maximum
          of the sum of absolute values of elements of any column).

  RCONDE  (output) DOUBLE PRECISION array, dimension (N)
          RCONDE(j) is the reciprocal condition number of the j-th
          eigenvalue.

  RCONDV  (output) DOUBLE PRECISION array, dimension (N)
          RCONDV(j) is the reciprocal condition number of the j-th
          right eigenvector.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.   If SENSE = 'N' or 'E',
          LWORK >= max(1,2*N), and if JOBVL = 'V' or JOBVR = 'V',
          LWORK >= 3*N.  If SENSE = 'V' or 'B', LWORK >= N*(N+6).
          For good performance, LWORK must generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  IWORK   (workspace) INTEGER array, dimension (2*N-2)
          If SENSE = 'N' or 'E', not referenced.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = i, the QR algorithm failed to compute all the
                eigenvalues, and no eigenvectors or condition numbers
                have been computed; elements 1:ILO-1 and i+1:N of WR
                and WI contain eigenvalues which have converged.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param balanc
	 * @param jobvl
	 * @param jobvr
	 * @param sense
	 * @param n
	 * @param a
	 * @param lda
	 * @param wr
	 * @param wi
	 * @param vl
	 * @param ldvl
	 * @param vr
	 * @param ldvr
	 * @param ilo
	 * @param ihi
	 * @param scale
	 * @param abnrm
	 * @param rconde
	 * @param rcondv
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param info
	 */
	public abstract void dgeevx(String balanc, String jobvl, String jobvr, String sense, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, intW ilo, intW ihi, double[] scale, doubleW abnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This routine is deprecated and has been replaced by routine DGGES.

  DGEGS computes the eigenvalues, real Schur form, and, optionally,
  left and or/right Schur vectors of a real matrix pair (A,B).
  Given two square matrices A and B, the generalized real Schur
  factorization has the form

    A = Q*S*Z**T,  B = Q*T*Z**T

  where Q and Z are orthogonal matrices, T is upper triangular, and S
  is an upper quasi-triangular matrix with 1-by-1 and 2-by-2 diagonal
  blocks, the 2-by-2 blocks corresponding to complex conjugate pairs
  of eigenvalues of (A,B).  The columns of Q are the left Schur vectors
  and the columns of Z are the right Schur vectors.

  If only the eigenvalues of (A,B) are needed, the driver routine
  DGEGV should be used instead.  See DGEGV for a description of the
  eigenvalues of the generalized nonsymmetric eigenvalue problem
  (GNEP).

  Arguments
  =========

  JOBVSL  (input) CHARACTER*1
          = 'N':  do not compute the left Schur vectors;
          = 'V':  compute the left Schur vectors (returned in VSL).

  JOBVSR  (input) CHARACTER*1
          = 'N':  do not compute the right Schur vectors;
          = 'V':  compute the right Schur vectors (returned in VSR).

  N       (input) INTEGER
          The order of the matrices A, B, VSL, and VSR.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the matrix A.
          On exit, the upper quasi-triangular matrix S from the
          generalized real Schur factorization.

  LDA     (input) INTEGER
          The leading dimension of A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the matrix B.
          On exit, the upper triangular matrix T from the generalized
          real Schur factorization.

  LDB     (input) INTEGER
          The leading dimension of B.  LDB >= max(1,N).

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
          The real parts of each scalar alpha defining an eigenvalue
          of GNEP.

  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
          The imaginary parts of each scalar alpha defining an
          eigenvalue of GNEP.  If ALPHAI(j) is zero, then the j-th
          eigenvalue is real; if positive, then the j-th and (j+1)-st
          eigenvalues are a complex conjugate pair, with
          ALPHAI(j+1) = -ALPHAI(j).

  BETA    (output) DOUBLE PRECISION array, dimension (N)
          The scalars beta that define the eigenvalues of GNEP.
          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
          beta = BETA(j) represent the j-th eigenvalue of the matrix
          pair (A,B), in one of the forms lambda = alpha/beta or
          mu = beta/alpha.  Since either lambda or mu may overflow,
          they should not, in general, be computed.

  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
          If JOBVSL = 'V', the matrix of left Schur vectors Q.
          Not referenced if JOBVSL = 'N'.

  LDVSL   (input) INTEGER
          The leading dimension of the matrix VSL. LDVSL >=1, and
          if JOBVSL = 'V', LDVSL >= N.

  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
          If JOBVSR = 'V', the matrix of right Schur vectors Z.
          Not referenced if JOBVSR = 'N'.

  LDVSR   (input) INTEGER
          The leading dimension of the matrix VSR. LDVSR >= 1, and
          if JOBVSR = 'V', LDVSR >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,4*N).
          For good performance, LWORK must generally be larger.
          To compute the optimal value of LWORK, call ILAENV to get
          blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
          NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR
          The optimal LWORK is  2*N + N*(NB+1).

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1,...,N:
                The QZ iteration failed.  (A,B) are not in Schur
                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
                be correct for j=INFO+1,...,N.
          > N:  errors that usually indicate LAPACK problems:
                =N+1: error return from DGGBAL
                =N+2: error return from DGEQRF
                =N+3: error return from DORMQR
                =N+4: error return from DORGQR
                =N+5: error return from DGGHRD
                =N+6: error return from DHGEQZ (other than failed
                                                iteration)
                =N+7: error return from DGGBAK (computing VSL)
                =N+8: error return from DGGBAK (computing VSR)
                =N+9: error return from DLASCL (various places)

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvsl
	 * @param jobvsr
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param vsl
	 * @param ldvsl
	 * @param vsr
	 * @param ldvsr
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgegs(String jobvsl, String jobvsr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This routine is deprecated and has been replaced by routine DGGEV.

  DGEGV computes the eigenvalues and, optionally, the left and/or right
  eigenvectors of a real matrix pair (A,B).
  Given two square matrices A and B,
  the generalized nonsymmetric eigenvalue problem (GNEP) is to find the
  eigenvalues lambda and corresponding (non-zero) eigenvectors x such
  that

     A*x = lambda*B*x.

  An alternate form is to find the eigenvalues mu and corresponding
  eigenvectors y such that

     mu*A*y = B*y.

  These two forms are equivalent with mu = 1/lambda and x = y if
  neither lambda nor mu is zero.  In order to deal with the case that
  lambda or mu is zero or small, two values alpha and beta are returned
  for each eigenvalue, such that lambda = alpha/beta and
  mu = beta/alpha.

  The vectors x and y in the above equations are right eigenvectors of

  the matrix pair (A,B).  Vectors u and v satisfying

     u**H*A = lambda*u**H*B  or  mu*v**H*A = v**H*B

  are left eigenvectors of (A,B).

  Note: this routine performs "full balancing" on A and B -- see
  "Further Details", below.

  Arguments
  =========

  JOBVL   (input) CHARACTER*1
          = 'N':  do not compute the left generalized eigenvectors;
          = 'V':  compute the left generalized eigenvectors (returned
                  in VL).

  JOBVR   (input) CHARACTER*1
          = 'N':  do not compute the right generalized eigenvectors;
          = 'V':  compute the right generalized eigenvectors (returned

                  in VR).

  N       (input) INTEGER
          The order of the matrices A, B, VL, and VR.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the matrix A.
          If JOBVL = 'V' or JOBVR = 'V', then on exit A
          contains the real Schur form of A from the generalized Schur

          factorization of the pair (A,B) after balancing.
          If no eigenvectors were computed, then only the diagonal
          blocks from the Schur form will be correct.  See DGGHRD and
          DHGEQZ for details.

  LDA     (input) INTEGER
          The leading dimension of A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the matrix B.
          If JOBVL = 'V' or JOBVR = 'V', then on exit B contains the
          upper triangular matrix obtained from B in the generalized
          Schur factorization of the pair (A,B) after balancing.
          If no eigenvectors were computed, then only those elements of
          B corresponding to the diagonal blocks from the Schur form of
          A will be correct.  See DGGHRD and DHGEQZ for details.

  LDB     (input) INTEGER
          The leading dimension of B.  LDB >= max(1,N).

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
          The real parts of each scalar alpha defining an eigenvalue of
          GNEP.

  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
          The imaginary parts of each scalar alpha defining an
          eigenvalue of GNEP.  If ALPHAI(j) is zero, then the j-th
          eigenvalue is real; if positive, then the j-th and
          (j+1)-st eigenvalues are a complex conjugate pair, with
          ALPHAI(j+1) = -ALPHAI(j).

  BETA    (output) DOUBLE PRECISION array, dimension (N)
          The scalars beta that define the eigenvalues of GNEP.
          
          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
          beta = BETA(j) represent the j-th eigenvalue of the matrix
          pair (A,B), in one of the forms lambda = alpha/beta or
          mu = beta/alpha.  Since either lambda or mu may overflow,
          they should not, in general, be computed.

  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
          If JOBVL = 'V', the left eigenvectors u(j) are stored
          in the columns of VL, in the same order as their eigenvalues.
          If the j-th eigenvalue is real, then u(j) = VL(:,j).
          If the j-th and (j+1)-st eigenvalues form a complex conjugate
          pair, then
             u(j) = VL(:,j) + i*VL(:,j+1)
          and
            u(j+1) = VL(:,j) - i*VL(:,j+1).

          Each eigenvector is scaled so that its largest component has

          abs(real part) + abs(imag. part) = 1, except for eigenvectors
          corresponding to an eigenvalue with alpha = beta = 0, which
          are set to zero.
          Not referenced if JOBVL = 'N'.

  LDVL    (input) INTEGER
          The leading dimension of the matrix VL. LDVL >= 1, and
          if JOBVL = 'V', LDVL >= N.

  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
          If JOBVR = 'V', the right eigenvectors x(j) are stored
          in the columns of VR, in the same order as their eigenvalues.
          If the j-th eigenvalue is real, then x(j) = VR(:,j).
          If the j-th and (j+1)-st eigenvalues form a complex conjugate
          pair, then
            x(j) = VR(:,j) + i*VR(:,j+1)
          and
            x(j+1) = VR(:,j) - i*VR(:,j+1).

          Each eigenvector is scaled so that its largest component has

          abs(real part) + abs(imag. part) = 1, except for eigenvalues

          corresponding to an eigenvalue with alpha = beta = 0, which
          are set to zero.
          Not referenced if JOBVR = 'N'.

  LDVR    (input) INTEGER
          The leading dimension of the matrix VR. LDVR >= 1, and
          if JOBVR = 'V', LDVR >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,8*N).
          For good performance, LWORK must generally be larger.
          To compute the optimal value of LWORK, call ILAENV to get
          blocksizes (for DGEQRF, DORMQR, and DORGQR.)  Then compute:
          NB  -- MAX of the blocksizes for DGEQRF, DORMQR, and DORGQR;

          The optimal LWORK is:
              2*N + MAX( 6*N, N*(NB+1) ).

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1,...,N:
                The QZ iteration failed.  No eigenvectors have been
                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
                should be correct for j=INFO+1,...,N.
          > N:  errors that usually indicate LAPACK problems:
                =N+1: error return from DGGBAL
                =N+2: error return from DGEQRF
                =N+3: error return from DORMQR
                =N+4: error return from DORGQR
                =N+5: error return from DGGHRD
                =N+6: error return from DHGEQZ (other than failed
                                                iteration)
                =N+7: error return from DTGEVC
                =N+8: error return from DGGBAK (computing VL)
                =N+9: error return from DGGBAK (computing VR)
                =N+10: error return from DLASCL (various calls)

  Further Details
  ===============

  Balancing
  ---------

  This driver calls DGGBAL to both permute and scale rows and columns
  of A and B.  The permutations PL and PR are chosen so that PL*A*PR
  and PL*B*R will be upper triangular except for the diagonal blocks
  A(i:j,i:j) and B(i:j,i:j), with i and j as close together as
  possible.  The diagonal scaling matrices DL and DR are chosen so
  that the pair  DL*PL*A*PR*DR, DL*PL*B*PR*DR have elements close to
  one (except for the elements that start out zero.)

  After the eigenvalues and eigenvectors of the balanced matrices
  have been computed, DGGBAK transforms the eigenvectors back to what
  they would have been (in perfect arithmetic) if they had not been
  balanced.

  Contents of A and B on Exit
  -------- -- - --- - -- ----

  If any eigenvectors are computed (either JOBVL='V' or JOBVR='V' or
  both), then on exit the arrays A and B will contain the real Schur
  form[*] of the "balanced" versions of A and B.  If no eigenvectors
  are computed, then only the diagonal blocks will be correct.

  [*] See DHGEQZ, DGEGS, or read the book "Matrix Computations",
      by Golub & van Loan, pub. by Johns Hopkins U. Press.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvl
	 * @param jobvr
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param vl
	 * @param ldvl
	 * @param vr
	 * @param ldvr
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgegv(String jobvl, String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEHD2 reduces a real general matrix A to upper Hessenberg form H by

  an orthogonal similarity transformation:  Q' * A * Q = H .

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          It is assumed that A is already upper triangular in rows
          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
          set by a previous call to DGEBAL; otherwise they should be
          set to 1 and N respectively. See Further Details.
          1 <= ILO <= IHI <= max(1,N).

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the n by n general matrix to be reduced.
          On exit, the upper triangle and the first subdiagonal of A
          are overwritten with the upper Hessenberg matrix H, and the
          elements below the first subdiagonal, with the array TAU,
          represent the orthogonal matrix Q as a product of elementary

          reflectors. See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrix Q is represented as a product of (ihi-ilo) elementary
  reflectors

     Q = H(ilo) H(ilo+1) . . . H(ihi-1).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i) = 0, v(i+1) = 1 and v(ihi+1:n) = 0; v(i+2:ihi) is stored on
  exit in A(i+2:ihi,i), and tau in TAU(i).

  The contents of A are illustrated by the following example, with
  n = 7, ilo = 2 and ihi = 6:

  on entry,                        on exit,

  ( a   a   a   a   a   a   a )    (  a   a   h   h   h   h   a )
  (     a   a   a   a   a   a )    (      a   h   h   h   h   a )
  (     a   a   a   a   a   a )    (      h   h   h   h   h   h )
  (     a   a   a   a   a   a )    (      v2  h   h   h   h   h )
  (     a   a   a   a   a   a )    (      v2  v3  h   h   h   h )
  (     a   a   a   a   a   a )    (      v2  v3  v4  h   h   h )
  (                         a )    (                          a )

  where a denotes an element of the original matrix A, h denotes a
  modified element of the upper Hessenberg matrix H, and vi denotes an

  element of the vector defining H(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dgehd2(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEHRD reduces a real general matrix A to upper Hessenberg form H by

  an orthogonal similarity transformation:  Q' * A * Q = H .

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          It is assumed that A is already upper triangular in rows
          and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
          set by a previous call to DGEBAL; otherwise they should be
          set to 1 and N respectively. See Further Details.
          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the N-by-N general matrix to be reduced.
          On exit, the upper triangle and the first subdiagonal of A
          are overwritten with the upper Hessenberg matrix H, and the
          elements below the first subdiagonal, with the array TAU,
          represent the orthogonal matrix Q as a product of elementary

          reflectors. See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
          The scalar factors of the elementary reflectors (see Further

          Details). Elements 1:ILO-1 and IHI:N-1 of TAU are set to
          zero.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (LWORK)

          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The length of the array WORK.  LWORK >= max(1,N).
          For optimum performance LWORK >= N*NB, where NB is the
          optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrix Q is represented as a product of (ihi-ilo) elementary
  reflectors

     Q = H(ilo) H(ilo+1) . . . H(ihi-1).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i) = 0, v(i+1) = 1 and v(ihi+1:n) = 0; v(i+2:ihi) is stored on
  exit in A(i+2:ihi,i), and tau in TAU(i).

  The contents of A are illustrated by the following example, with
  n = 7, ilo = 2 and ihi = 6:

  on entry,                        on exit,

  ( a   a   a   a   a   a   a )    (  a   a   h   h   h   h   a )
  (     a   a   a   a   a   a )    (      a   h   h   h   h   a )
  (     a   a   a   a   a   a )    (      h   h   h   h   h   h )
  (     a   a   a   a   a   a )    (      v2  h   h   h   h   h )
  (     a   a   a   a   a   a )    (      v2  v3  h   h   h   h )
  (     a   a   a   a   a   a )    (      v2  v3  v4  h   h   h )
  (                         a )    (                          a )

  where a denotes an element of the original matrix A, h denotes a
  modified element of the upper Hessenberg matrix H, and vi denotes an

  element of the vector defining H(i).

  This file is a slight modification of LAPACK-3.0's DGEHRD
  subroutine incorporating improvements proposed by Quintana-Orti and
  Van de Geijn (2005). 

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgehrd(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGELQ2 computes an LQ factorization of a real m by n matrix A:
  A = L * Q.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n matrix A.
          On exit, the elements on and below the diagonal of the array

          contain the m by min(m,n) lower trapezoidal matrix L (L is
          lower triangular if m <= n); the elements above the diagonal,
          with the array TAU, represent the orthogonal matrix Q as a
          product of elementary reflectors (see Further Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace) DOUBLE PRECISION array, dimension (M)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(k) . . . H(2) H(1), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i,i+1:n),

  and tau in TAU(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dgelq2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGELQF computes an LQ factorization of a real M-by-N matrix A:
  A = L * Q.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the elements on and below the diagonal of the array

          contain the m-by-min(m,n) lower trapezoidal matrix L (L is
          lower triangular if m <= n); the elements above the diagonal,
          with the array TAU, represent the orthogonal matrix Q as a
          product of elementary reflectors (see Further Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,M).
          For optimum performance LWORK >= M*NB, where NB is the
          optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(k) . . . H(2) H(1), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i,i+1:n),

  and tau in TAU(i).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgelqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGELS solves overdetermined or underdetermined real linear systems
  involving an M-by-N matrix A, or its transpose, using a QR or LQ
  factorization of A.  It is assumed that A has full rank.

  The following options are provided:

  1. If TRANS = 'N' and m >= n:  find the least squares solution of
     an overdetermined system, i.e., solve the least squares problem
                  minimize || B - A*X ||.

  2. If TRANS = 'N' and m < n:  find the minimum norm solution of
     an underdetermined system A * X = B.

  3. If TRANS = 'T' and m >= n:  find the minimum norm solution of
     an undetermined system A**T * X = B.

  4. If TRANS = 'T' and m < n:  find the least squares solution of
     an overdetermined system, i.e., solve the least squares problem
                  minimize || B - A**T * X ||.

  Several right hand side vectors b and solution vectors x can be
  handled in a single call; they are stored as the columns of the
  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
  matrix X.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          = 'N': the linear system involves A;
          = 'T': the linear system involves A**T.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of
          columns of the matrices B and X. NRHS >=0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit,
            if M >= N, A is overwritten by details of its QR
                       factorization as returned by DGEQRF;
            if M <  N, A is overwritten by details of its LQ
                       factorization as returned by DGELQF.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the matrix B of right hand side vectors, stored
          columnwise; B is M-by-NRHS if TRANS = 'N', or N-by-NRHS
          if TRANS = 'T'.
          On exit, if INFO = 0, B is overwritten by the solution
          vectors, stored columnwise:
          if TRANS = 'N' and m >= n, rows 1 to n of B contain the least
          squares solution vectors; the residual sum of squares for the
          solution in each column is given by the sum of squares of
          elements N+1 to M in that column;
          if TRANS = 'N' and m < n, rows 1 to N of B contain the
          minimum norm solution vectors;
          if TRANS = 'T' and m >= n, rows 1 to M of B contain the
          minimum norm solution vectors;
          if TRANS = 'T' and m < n, rows 1 to M of B contain the
          least squares solution vectors; the residual sum of squares
          for the solution in each column is given by the sum of
          squares of elements M+1 to N in that column.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= MAX(1,M,N).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          LWORK >= max( 1, MN + max( MN, NRHS ) ).
          For optimal performance,
          LWORK >= max( 1, MN + max( MN, NRHS )*NB ).
          where MN = min(M,N) and NB is the optimum block size.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO =  i, the i-th diagonal element of the
                triangular factor of A is zero, so that A does not have
                full rank; the least squares solution could not be
                computed.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param m
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgels(String trans, int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGELSD computes the minimum-norm solution to a real linear least
  squares problem:
      minimize 2-norm(| b - A*x |)
  using the singular value decomposition (SVD) of A. A is an M-by-N
  matrix which may be rank-deficient.

  Several right hand side vectors b and solution vectors x can be
  handled in a single call; they are stored as the columns of the
  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
  matrix X.

  The problem is solved in three steps:
  (1) Reduce the coefficient matrix A to bidiagonal form with
      Householder transformations, reducing the original problem
      into a "bidiagonal least squares problem" (BLS)
  (2) Solve the BLS using a divide and conquer approach.
  (3) Apply back all the Householder tranformations to solve
      the original least squares problem.

  The effective rank of A is determined by treating as zero those
  singular values which are less than RCOND times the largest singular

  value.

  The divide and conquer algorithm makes very mild assumptions about
  floating point arithmetic. It will work on machines with a guard
  digit in add/subtract, or on those binary machines without guard
  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
  Cray-2. It could conceivably fail on hexadecimal or decimal machines

  without guard digits, but we know of none.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of A. M >= 0.

  N       (input) INTEGER
          The number of columns of A. N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X. NRHS >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, A has been destroyed.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the M-by-NRHS right hand side matrix B.
          On exit, B is overwritten by the N-by-NRHS solution
          matrix X.  If m >= n and RANK = n, the residual
          sum-of-squares for the solution in the i-th column is given
          by the sum of squares of elements n+1:m in that column.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,max(M,N)).

  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The singular values of A in decreasing order.
          The condition number of A in the 2-norm = S(1)/S(min(m,n)).

  RCOND   (input) DOUBLE PRECISION
          RCOND is used to determine the effective rank of A.
          Singular values S(i) <= RCOND*S(1) are treated as zero.
          If RCOND < 0, machine precision is used instead.

  RANK    (output) INTEGER
          The effective rank of A, i.e., the number of singular values

          which are greater than RCOND*S(1).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK must be at least 1.
          The exact minimum amount of workspace needed depends on M,
          N and NRHS. As long as LWORK is at least
              12*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS + (SMLSIZ+1)**2,
          if M is greater than or equal to N or
              12*M + 2*M*SMLSIZ + 8*M*NLVL + M*NRHS + (SMLSIZ+1)**2,
          if M is less than N, the code will execute correctly.
          SMLSIZ is returned by ILAENV and is equal to the maximum
          size of the subproblems at the bottom of the computation
          tree (usually about 25), and
             NLVL = MAX( 0, INT( LOG_2( MIN( M,N )/(SMLSIZ+1) ) ) + 1 )
          For good performance, LWORK should generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  IWORK   (workspace) INTEGER array, dimension (MAX(1,LIWORK))
          LIWORK >= 3 * MINMN * NLVL + 11 * MINMN,
          where MINMN = MIN( M,N ).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  the algorithm for computing the SVD failed to converge;
                if INFO = i, i off-diagonal elements of an intermediate
                bidiagonal form did not converge to zero.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Ren-Cang Li, Computer Science Division, University of

       California at Berkeley, USA
     Osni Marques, LBNL/NERSC, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param s
	 * @param rcond
	 * @param rank
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param info
	 */
	public abstract void dgelsd(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, intW rank, double[] work, int lwork, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGELSS computes the minimum norm solution to a real linear least
  squares problem:

  Minimize 2-norm(| b - A*x |).

  using the singular value decomposition (SVD) of A. A is an M-by-N
  matrix which may be rank-deficient.

  Several right hand side vectors b and solution vectors x can be
  handled in a single call; they are stored as the columns of the
  M-by-NRHS right hand side matrix B and the N-by-NRHS solution matrix

  X.

  The effective rank of A is determined by treating as zero those
  singular values which are less than RCOND times the largest singular

  value.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A. N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X. NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the first min(m,n) rows of A are overwritten with
          its right singular vectors, stored rowwise.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the M-by-NRHS right hand side matrix B.
          On exit, B is overwritten by the N-by-NRHS solution
          matrix X.  If m >= n and RANK = n, the residual
          sum-of-squares for the solution in the i-th column is given
          by the sum of squares of elements n+1:m in that column.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,max(M,N)).

  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The singular values of A in decreasing order.
          The condition number of A in the 2-norm = S(1)/S(min(m,n)).

  RCOND   (input) DOUBLE PRECISION
          RCOND is used to determine the effective rank of A.
          Singular values S(i) <= RCOND*S(1) are treated as zero.
          If RCOND < 0, machine precision is used instead.

  RANK    (output) INTEGER
          The effective rank of A, i.e., the number of singular values

          which are greater than RCOND*S(1).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= 1, and also:
          LWORK >= 3*min(M,N) + max( 2*min(M,N), max(M,N), NRHS )
          For good performance, LWORK should generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  the algorithm for computing the SVD failed to converge;
                if INFO = i, i off-diagonal elements of an intermediate
                bidiagonal form did not converge to zero.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param s
	 * @param rcond
	 * @param rank
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgelss(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, intW rank, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This routine is deprecated and has been replaced by routine DGELSY.

  DGELSX computes the minimum-norm solution to a real linear least
  squares problem:
      minimize || A * X - B ||
  using a complete orthogonal factorization of A.  A is an M-by-N
  matrix which may be rank-deficient.

  Several right hand side vectors b and solution vectors x can be
  handled in a single call; they are stored as the columns of the
  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
  matrix X.

  The routine first computes a QR factorization with column pivoting:
      A * P = Q * [ R11 R12 ]
                  [  0  R22 ]
  with R11 defined as the largest leading submatrix whose estimated
  condition number is less than 1/RCOND.  The order of R11, RANK,
  is the effective rank of A.

  Then, R22 is considered to be negligible, and R12 is annihilated
  by orthogonal transformations from the right, arriving at the
  complete orthogonal factorization:
     A * P = Q * [ T11 0 ] * Z
                 [  0  0 ]
  The minimum-norm solution is then
     X = P * Z' [ inv(T11)*Q1'*B ]
                [        0       ]
  where Q1 consists of the first RANK columns of Q.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of
          columns of matrices B and X. NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, A has been overwritten by details of its
          complete orthogonal factorization.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the M-by-NRHS right hand side matrix B.
          On exit, the N-by-NRHS solution matrix X.
          If m >= n and RANK = n, the residual sum-of-squares for
          the solution in the i-th column is given by the sum of
          squares of elements N+1:M in that column.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,M,N).

  JPVT    (input/output) INTEGER array, dimension (N)
          On entry, if JPVT(i) .ne. 0, the i-th column of A is an
          initial column, otherwise it is a free column.  Before
          the QR factorization of A, all initial columns are
          permuted to the leading positions; only the remaining
          free columns are moved as a result of column pivoting
          during the factorization.
          On exit, if JPVT(i) = k, then the i-th column of A*P
          was the k-th column of A.

  RCOND   (input) DOUBLE PRECISION
          RCOND is used to determine the effective rank of A, which
          is defined as the order of the largest leading triangular
          submatrix R11 in the QR factorization with pivoting of A,
          whose estimated condition number < 1/RCOND.

  RANK    (output) INTEGER
          The effective rank of A, i.e., the order of the submatrix
          R11.  This is the same as the order of the submatrix T11
          in the complete orthogonal factorization of A.

  WORK    (workspace) DOUBLE PRECISION array, dimension
                      (max( min(M,N)+3*N, 2*min(M,N)+NRHS )),

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param jpvt
	 * @param rcond
	 * @param rank
	 * @param work
	 * @param info
	 */
	public abstract void dgelsx(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, intW rank, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGELSY computes the minimum-norm solution to a real linear least
  squares problem:
      minimize || A * X - B ||
  using a complete orthogonal factorization of A.  A is an M-by-N
  matrix which may be rank-deficient.

  Several right hand side vectors b and solution vectors x can be
  handled in a single call; they are stored as the columns of the
  M-by-NRHS right hand side matrix B and the N-by-NRHS solution
  matrix X.

  The routine first computes a QR factorization with column pivoting:
      A * P = Q * [ R11 R12 ]
                  [  0  R22 ]
  with R11 defined as the largest leading submatrix whose estimated
  condition number is less than 1/RCOND.  The order of R11, RANK,
  is the effective rank of A.

  Then, R22 is considered to be negligible, and R12 is annihilated
  by orthogonal transformations from the right, arriving at the
  complete orthogonal factorization:
     A * P = Q * [ T11 0 ] * Z
                 [  0  0 ]
  The minimum-norm solution is then
     X = P * Z' [ inv(T11)*Q1'*B ]
                [        0       ]
  where Q1 consists of the first RANK columns of Q.

  This routine is basically identical to the original xGELSX except
  three differences:
    o The call to the subroutine xGEQPF has been substituted by the
      the call to the subroutine xGEQP3. This subroutine is a Blas-3
      version of the QR factorization with column pivoting.
    o Matrix B (the right hand side) is updated with Blas-3.
    o The permutation of matrix B (the right hand side) is faster and
      more simple.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of
          columns of matrices B and X. NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, A has been overwritten by details of its
          complete orthogonal factorization.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the M-by-NRHS right hand side matrix B.
          On exit, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,M,N).

  JPVT    (input/output) INTEGER array, dimension (N)
          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
          to the front of AP, otherwise column i is a free column.
          On exit, if JPVT(i) = k, then the i-th column of AP
          was the k-th column of A.

  RCOND   (input) DOUBLE PRECISION
          RCOND is used to determine the effective rank of A, which
          is defined as the order of the largest leading triangular
          submatrix R11 in the QR factorization with pivoting of A,
          whose estimated condition number < 1/RCOND.

  RANK    (output) INTEGER
          The effective rank of A, i.e., the order of the submatrix
          R11.  This is the same as the order of the submatrix T11
          in the complete orthogonal factorization of A.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          The unblocked strategy requires that:
             LWORK >= MAX( MN+3*N+1, 2*MN+NRHS ),
          where MN = min( M, N ).
          The block algorithm requires that:
             LWORK >= MAX( MN+2*N+NB*(N+1), 2*MN+NB*NRHS ),
          where NB is an upper bound on the blocksize returned
          by ILAENV for the routines DGEQP3, DTZRZF, STZRQF, DORMQR,
          and DORMRZ.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: If INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA

    E. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param jpvt
	 * @param rcond
	 * @param rank
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgelsy(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, intW rank, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEQL2 computes a QL factorization of a real m by n matrix A:
  A = Q * L.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n matrix A.
          On exit, if m >= n, the lower triangle of the subarray
          A(m-n+1:m,1:n) contains the n by n lower triangular matrix L;
          if m <= n, the elements on and below the (n-m)-th
          superdiagonal contain the m by n lower trapezoidal matrix L;

          the remaining elements, with the array TAU, represent the
          orthogonal matrix Q as a product of elementary reflectors
          (see Further Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(k) . . . H(2) H(1), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(m-k+i+1:m) = 0 and v(m-k+i) = 1; v(1:m-k+i-1) is stored on exit in

  A(1:m-k+i-1,n-k+i), and tau in TAU(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dgeql2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEQLF computes a QL factorization of a real M-by-N matrix A:
  A = Q * L.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit,
          if m >= n, the lower triangle of the subarray
          A(m-n+1:m,1:n) contains the N-by-N lower triangular matrix L;
          if m <= n, the elements on and below the (n-m)-th
          superdiagonal contain the M-by-N lower trapezoidal matrix L;

          the remaining elements, with the array TAU, represent the
          orthogonal matrix Q as a product of elementary reflectors
          (see Further Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,N).
          For optimum performance LWORK >= N*NB, where NB is the
          optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(k) . . . H(2) H(1), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(m-k+i+1:m) = 0 and v(m-k+i) = 1; v(1:m-k+i-1) is stored on exit in

  A(1:m-k+i-1,n-k+i), and tau in TAU(i).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgeqlf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEQP3 computes a QR factorization with column pivoting of a
  matrix A:  A*P = Q*R  using Level 3 BLAS.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the upper triangle of the array contains the
          min(M,N)-by-N upper trapezoidal matrix R; the elements below

          the diagonal, together with the array TAU, represent the
          orthogonal matrix Q as a product of min(M,N) elementary
          reflectors.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  JPVT    (input/output) INTEGER array, dimension (N)
          On entry, if JPVT(J).ne.0, the J-th column of A is permuted
          to the front of A*P (a leading column); if JPVT(J)=0,
          the J-th column of A is a free column.
          On exit, if JPVT(J)=K, then the J-th column of A*P was the
          the K-th column of A.

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO=0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= 3*N+1.
          For optimal performance LWORK >= 2*N+( N+1 )*NB, where NB
          is the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0: successful exit.
          < 0: if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real/complex scalar, and v is a real/complex vector
  with v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in
  A(i+1:m,i), and tau in TAU(i).

  Based on contributions by
    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
    X. Sun, Computer Science Dept., Duke University, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param jpvt
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgeqp3(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This routine is deprecated and has been replaced by routine DGEQP3.

  DGEQPF computes a QR factorization with column pivoting of a
  real M-by-N matrix A: A*P = Q*R.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A. N >= 0

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the upper triangle of the array contains the
          min(M,N)-by-N upper triangular matrix R; the elements
          below the diagonal, together with the array TAU,
          represent the orthogonal matrix Q as a product of
          min(m,n) elementary reflectors.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  JPVT    (input/output) INTEGER array, dimension (N)
          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
          to the front of A*P (a leading column); if JPVT(i) = 0,
          the i-th column of A is a free column.
          On exit, if JPVT(i) = k, then the i-th column of A*P
          was the k-th column of A.

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors.

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(n)

  Each H(i) has the form

     H = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i).


  The matrix P is represented in jpvt as follows: If
     jpvt(j) = i
  then the jth column of P is the ith canonical unit vector.

  Partial column norm updating strategy modified by
    Z. Drmac and Z. Bujanovic, Dept. of Mathematics,
    University of Zagreb, Croatia.
    June 2006.
  For more details see LAPACK Working Note 176.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param jpvt
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dgeqpf(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEQR2 computes a QR factorization of a real m by n matrix A:
  A = Q * R.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n matrix A.
          On exit, the elements on and above the diagonal of the array

          contain the min(m,n) by n upper trapezoidal matrix R (R is
          upper triangular if m >= n); the elements below the diagonal,
          with the array TAU, represent the orthogonal matrix Q as a
          product of elementary reflectors (see Further Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),

  and tau in TAU(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dgeqr2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGEQRF computes a QR factorization of a real M-by-N matrix A:
  A = Q * R.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the elements on and above the diagonal of the array

          contain the min(M,N)-by-N upper trapezoidal matrix R (R is
          upper triangular if m >= n); the elements below the diagonal,
          with the array TAU, represent the orthogonal matrix Q as a
          product of min(m,n) elementary reflectors (see Further
          Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,N).
          For optimum performance LWORK >= N*NB, where NB is
          the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:m) is stored on exit in A(i+1:m,i),

  and tau in TAU(i).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgeqrf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGERFS improves the computed solution to a system of linear
  equations and provides error bounds and backward error estimates for

  the solution.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations:
          = 'N':  A * X = B     (No transpose)
          = 'T':  A**T * X = B  (Transpose)
          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The original N-by-N matrix A.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  AF      (input) DOUBLE PRECISION array, dimension (LDAF,N)
          The factors L and U from the factorization A = P*L*U
          as computed by DGETRF.

  LDAF    (input) INTEGER
          The leading dimension of the array AF.  LDAF >= max(1,N).

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices from DGETRF; for 1<=i<=N, row i of the
          matrix was interchanged with row IPIV(i).

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DGETRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param af
	 * @param ldaf
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgerfs(String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGERQ2 computes an RQ factorization of a real m by n matrix A:
  A = R * Q.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n matrix A.
          On exit, if m <= n, the upper triangle of the subarray
          A(1:m,n-m+1:n) contains the m by m upper triangular matrix R;
          if m >= n, the elements on and above the (m-n)-th subdiagonal
          contain the m by n upper trapezoidal matrix R; the remaining

          elements, with the array TAU, represent the orthogonal matrix
          Q as a product of elementary reflectors (see Further
          Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace) DOUBLE PRECISION array, dimension (M)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in

  A(m-k+i,1:n-k+i-1), and tau in TAU(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dgerq2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGERQF computes an RQ factorization of a real M-by-N matrix A:
  A = R * Q.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit,
          if m <= n, the upper triangle of the subarray
          A(1:m,n-m+1:n) contains the M-by-M upper triangular matrix R;
          if m >= n, the elements on and above the (m-n)-th subdiagonal
          contain the M-by-N upper trapezoidal matrix R;
          the remaining elements, with the array TAU, represent the
          orthogonal matrix Q as a product of min(m,n) elementary
          reflectors (see Further Details).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors (see Further

          Details).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,M).
          For optimum performance LWORK >= M*NB, where NB is
          the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in

  A(m-k+i,1:n-k+i-1), and tau in TAU(i).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgerqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGESC2 solves a system of linear equations

            A * X = scale* RHS

  with a general N-by-N matrix A using the LU factorization with
  complete pivoting computed by DGETC2.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the  LU part of the factorization of the n-by-n
          matrix A computed by DGETC2:  A = P * L * U * Q

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1, N).

  RHS     (input/output) DOUBLE PRECISION array, dimension (N).
          On entry, the right hand side vector b.
          On exit, the solution vector X.

  IPIV    (input) INTEGER array, dimension (N).
          The pivot indices; for 1 <= i <= N, row i of the
          matrix has been interchanged with row IPIV(i).

  JPIV    (input) INTEGER array, dimension (N).
          The pivot indices; for 1 <= j <= N, column j of the
          matrix has been interchanged with column JPIV(j).

  SCALE    (output) DOUBLE PRECISION
           On exit, SCALE contains the scale factor. SCALE is chosen
           0 <= SCALE <= 1 to prevent owerflow in the solution.

  Further Details
  ===============

  Based on contributions by
     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
     Umea University, S-901 87 Umea, Sweden.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param a
	 * @param lda
	 * @param rhs
	 * @param ipiv
	 * @param jpiv
	 * @param scale
	 */
	public abstract void dgesc2(int n, double[] a, int lda, double[] rhs, int[] ipiv, int[] jpiv, doubleW scale);

	/**
<pre>

     ..

  Purpose
  =======

  DGESDD computes the singular value decomposition (SVD) of a real
  M-by-N matrix A, optionally computing the left and right singular
  vectors.  If singular vectors are desired, it uses a
  divide-and-conquer algorithm.

  The SVD is written

       A = U * SIGMA * transpose(V)

  where SIGMA is an M-by-N matrix which is zero except for its
  min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and
  V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA
  are the singular values of A; they are real and non-negative, and
  are returned in descending order.  The first min(m,n) columns of
  U and V are the left and right singular vectors of A.

  Note that the routine returns VT = V**T, not V.

  The divide and conquer algorithm makes very mild assumptions about
  floating point arithmetic. It will work on machines with a guard
  digit in add/subtract, or on those binary machines without guard
  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
  Cray-2. It could conceivably fail on hexadecimal or decimal machines

  without guard digits, but we know of none.

  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          Specifies options for computing all or part of the matrix U:

          = 'A':  all M columns of U and all N rows of V**T are
                  returned in the arrays U and VT;
          = 'S':  the first min(M,N) columns of U and the first
                  min(M,N) rows of V**T are returned in the arrays U
                  and VT;
          = 'O':  If M >= N, the first N columns of U are overwritten
                  on the array A and all rows of V**T are returned in
                  the array VT;
                  otherwise, all columns of U are returned in the
                  array U and the first M rows of V**T are overwritten

                  in the array A;
          = 'N':  no columns of U or rows of V**T are computed.

  M       (input) INTEGER
          The number of rows of the input matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the input matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit,
          if JOBZ = 'O',  A is overwritten with the first N columns
                          of U (the left singular vectors, stored
                          columnwise) if M >= N;
                          A is overwritten with the first M rows
                          of V**T (the right singular vectors, stored
                          rowwise) otherwise.
          if JOBZ .ne. 'O', the contents of A are destroyed.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The singular values of A, sorted so that S(i) >= S(i+1).

  U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)
          UCOL = M if JOBZ = 'A' or JOBZ = 'O' and M < N;
          UCOL = min(M,N) if JOBZ = 'S'.
          If JOBZ = 'A' or JOBZ = 'O' and M < N, U contains the M-by-M

          orthogonal matrix U;
          if JOBZ = 'S', U contains the first min(M,N) columns of U
          (the left singular vectors, stored columnwise);
          if JOBZ = 'O' and M >= N, or JOBZ = 'N', U is not referenced.

  LDU     (input) INTEGER
          The leading dimension of the array U.  LDU >= 1; if
          JOBZ = 'S' or 'A' or JOBZ = 'O' and M < N, LDU >= M.

  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
          If JOBZ = 'A' or JOBZ = 'O' and M >= N, VT contains the
          N-by-N orthogonal matrix V**T;
          if JOBZ = 'S', VT contains the first min(M,N) rows of
          V**T (the right singular vectors, stored rowwise);
          if JOBZ = 'O' and M < N, or JOBZ = 'N', VT is not referenced.

  LDVT    (input) INTEGER
          The leading dimension of the array VT.  LDVT >= 1; if
          JOBZ = 'A' or JOBZ = 'O' and M >= N, LDVT >= N;
          if JOBZ = 'S', LDVT >= min(M,N).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK;

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= 1.
          If JOBZ = 'N',
            LWORK >= 3*min(M,N) + max(max(M,N),7*min(M,N)).
          If JOBZ = 'O',
            LWORK >= 3*min(M,N)*min(M,N) + 
                     max(max(M,N),5*min(M,N)*min(M,N)+4*min(M,N)).
          If JOBZ = 'S' or 'A'
            LWORK >= 3*min(M,N)*min(M,N) +
                     max(max(M,N),4*min(M,N)*min(M,N)+4*min(M,N)).
          For good performance, LWORK should generally be larger.
          If LWORK = -1 but other input arguments are legal, WORK(1)
          returns the optimal LWORK.

  IWORK   (workspace) INTEGER array, dimension (8*min(M,N))

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  DBDSDC did not converge, updating process failed.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobz
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param s
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param ldvt
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param info
	 */
	public abstract void dgesdd(String jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGESV computes the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

  The LU decomposition with partial pivoting and row interchanges is
  used to factor A as
     A = P * L * U,
  where P is a permutation matrix, L is unit lower triangular, and U is
  upper triangular.  The factored form of A is then used to solve the
  system of equations A * X = B.

  Arguments
  =========

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the N-by-N coefficient matrix A.
          On exit, the factors L and U from the factorization
          A = P*L*U; the unit diagonal elements of L are not stored.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  IPIV    (output) INTEGER array, dimension (N)
          The pivot indices that define the permutation matrix P;
          row i of the matrix was interchanged with row IPIV(i).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS matrix of right hand side matrix B.
          On exit, if INFO = 0, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, U(i,i) is exactly zero.  The factorization
                has been completed, but the factor U is exactly
                singular, so the solution could not be computed.

  =====================================================================

     .. External Subroutines ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGESVD computes the singular value decomposition (SVD) of a real
  M-by-N matrix A, optionally computing the left and/or right singular

  vectors. The SVD is written

       A = U * SIGMA * transpose(V)

  where SIGMA is an M-by-N matrix which is zero except for its
  min(m,n) diagonal elements, U is an M-by-M orthogonal matrix, and
  V is an N-by-N orthogonal matrix.  The diagonal elements of SIGMA
  are the singular values of A; they are real and non-negative, and
  are returned in descending order.  The first min(m,n) columns of
  U and V are the left and right singular vectors of A.

  Note that the routine returns V**T, not V.

  Arguments
  =========

  JOBU    (input) CHARACTER*1
          Specifies options for computing all or part of the matrix U:

          = 'A':  all M columns of U are returned in array U:
          = 'S':  the first min(m,n) columns of U (the left singular
                  vectors) are returned in the array U;
          = 'O':  the first min(m,n) columns of U (the left singular
                  vectors) are overwritten on the array A;
          = 'N':  no columns of U (no left singular vectors) are
                  computed.

  JOBVT   (input) CHARACTER*1
          Specifies options for computing all or part of the matrix
          V**T:
          = 'A':  all N rows of V**T are returned in the array VT;
          = 'S':  the first min(m,n) rows of V**T (the right singular
                  vectors) are returned in the array VT;
          = 'O':  the first min(m,n) rows of V**T (the right singular
                  vectors) are overwritten on the array A;
          = 'N':  no rows of V**T (no right singular vectors) are
                  computed.

          JOBVT and JOBU cannot both be 'O'.

  M       (input) INTEGER
          The number of rows of the input matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the input matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit,
          if JOBU = 'O',  A is overwritten with the first min(m,n)
                          columns of U (the left singular vectors,
                          stored columnwise);
          if JOBVT = 'O', A is overwritten with the first min(m,n)
                          rows of V**T (the right singular vectors,
                          stored rowwise);
          if JOBU .ne. 'O' and JOBVT .ne. 'O', the contents of A
                          are destroyed.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  S       (output) DOUBLE PRECISION array, dimension (min(M,N))
          The singular values of A, sorted so that S(i) >= S(i+1).

  U       (output) DOUBLE PRECISION array, dimension (LDU,UCOL)
          (LDU,M) if JOBU = 'A' or (LDU,min(M,N)) if JOBU = 'S'.
          If JOBU = 'A', U contains the M-by-M orthogonal matrix U;
          if JOBU = 'S', U contains the first min(m,n) columns of U
          (the left singular vectors, stored columnwise);
          if JOBU = 'N' or 'O', U is not referenced.

  LDU     (input) INTEGER
          The leading dimension of the array U.  LDU >= 1; if
          JOBU = 'S' or 'A', LDU >= M.

  VT      (output) DOUBLE PRECISION array, dimension (LDVT,N)
          If JOBVT = 'A', VT contains the N-by-N orthogonal matrix
          V**T;
          if JOBVT = 'S', VT contains the first min(m,n) rows of
          V**T (the right singular vectors, stored rowwise);
          if JOBVT = 'N' or 'O', VT is not referenced.

  LDVT    (input) INTEGER
          The leading dimension of the array VT.  LDVT >= 1; if
          JOBVT = 'A', LDVT >= N; if JOBVT = 'S', LDVT >= min(M,N).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK;
          if INFO > 0, WORK(2:MIN(M,N)) contains the unconverged
          superdiagonal elements of an upper bidiagonal matrix B
          whose diagonal is in S (not necessarily sorted). B
          satisfies A = U * B * VT, so it has the same singular values

          as A, and singular vectors related by U and VT.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          LWORK >= MAX(1,3*MIN(M,N)+MAX(M,N),5*MIN(M,N)).
          For good performance, LWORK should generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if DBDSQR did not converge, INFO specifies how many
                superdiagonals of an intermediate bidiagonal form B
                did not converge to zero. See the description of WORK
                above for details.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobu
	 * @param jobvt
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param s
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param ldvt
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgesvd(String jobu, String jobvt, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGESVX uses the LU factorization to compute the solution to a real
  system of linear equations
     A * X = B,
  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed:

  1. If FACT = 'E', real scaling factors are computed to equilibrate
     the system:
        TRANS = 'N':  diag(R)*A*diag(C)     *inv(diag(C))*X = diag(R)*B
        TRANS = 'T': (diag(R)*A*diag(C))**T *inv(diag(R))*X = diag(C)*B
        TRANS = 'C': (diag(R)*A*diag(C))**H *inv(diag(R))*X = diag(C)*B
     Whether or not the system will be equilibrated depends on the
     scaling of the matrix A, but if equilibration is used, A is
     overwritten by diag(R)*A*diag(C) and B by diag(R)*B (if TRANS='N')
     or diag(C)*B (if TRANS = 'T' or 'C').

  2. If FACT = 'N' or 'E', the LU decomposition is used to factor the
     matrix A (after equilibration if FACT = 'E') as
        A = P * L * U,
     where P is a permutation matrix, L is a unit lower triangular
     matrix, and U is upper triangular.

  3. If some U(i,i)=0, so that U is exactly singular, then the routine

     returns with INFO = i. Otherwise, the factored form of A is used
     to estimate the condition number of the matrix A.  If the
     reciprocal of the condition number is less than machine precision,
     INFO = N+1 is returned as a warning, but the routine still goes on
     to solve for X and compute error bounds as described below.

  4. The system of equations is solved for X using the factored form
     of A.

  5. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  6. If equilibration was used, the matrix X is premultiplied by
     diag(C) (if TRANS = 'N') or diag(R) (if TRANS = 'T' or 'C') so
     that it solves the original system before equilibration.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of the matrix A is
          supplied on entry, and if not, whether the matrix A should be
          equilibrated before it is factored.
          = 'F':  On entry, AF and IPIV contain the factored form of A.
                  If EQUED is not 'N', the matrix A has been
                  equilibrated with scaling factors given by R and C.
                  A, AF, and IPIV are not modified.
          = 'N':  The matrix A will be copied to AF and factored.
          = 'E':  The matrix A will be equilibrated if necessary, then

                  copied to AF and factored.

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations:
          = 'N':  A * X = B     (No transpose)
          = 'T':  A**T * X = B  (Transpose)
          = 'C':  A**H * X = B  (Transpose)

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the N-by-N matrix A.  If FACT = 'F' and EQUED is
          not 'N', then A must have been equilibrated by the scaling
          factors in R and/or C.  A is not modified if FACT = 'F' or
          'N', or if FACT = 'E' and EQUED = 'N' on exit.

          On exit, if EQUED .ne. 'N', A is scaled as follows:
          EQUED = 'R':  A := diag(R) * A
          EQUED = 'C':  A := A * diag(C)
          EQUED = 'B':  A := diag(R) * A * diag(C).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  AF      (input or output) DOUBLE PRECISION array, dimension (LDAF,N)

          If FACT = 'F', then AF is an input argument and on entry
          contains the factors L and U from the factorization
          A = P*L*U as computed by DGETRF.  If EQUED .ne. 'N', then
          AF is the factored form of the equilibrated matrix A.

          If FACT = 'N', then AF is an output argument and on exit
          returns the factors L and U from the factorization A = P*L*U

          of the original matrix A.

          If FACT = 'E', then AF is an output argument and on exit
          returns the factors L and U from the factorization A = P*L*U

          of the equilibrated matrix A (see the description of A for
          the form of the equilibrated matrix).

  LDAF    (input) INTEGER
          The leading dimension of the array AF.  LDAF >= max(1,N).

  IPIV    (input or output) INTEGER array, dimension (N)
          If FACT = 'F', then IPIV is an input argument and on entry
          contains the pivot indices from the factorization A = P*L*U
          as computed by DGETRF; row i of the matrix was interchanged
          with row IPIV(i).

          If FACT = 'N', then IPIV is an output argument and on exit
          contains the pivot indices from the factorization A = P*L*U
          of the original matrix A.

          If FACT = 'E', then IPIV is an output argument and on exit
          contains the pivot indices from the factorization A = P*L*U
          of the equilibrated matrix A.

  EQUED   (input or output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration (always true if FACT = 'N').
          = 'R':  Row equilibration, i.e., A has been premultiplied by

                  diag(R).
          = 'C':  Column equilibration, i.e., A has been postmultiplied
                  by diag(C).
          = 'B':  Both row and column equilibration, i.e., A has been
                  replaced by diag(R) * A * diag(C).
          EQUED is an input argument if FACT = 'F'; otherwise, it is an
          output argument.

  R       (input or output) DOUBLE PRECISION array, dimension (N)
          The row scale factors for A.  If EQUED = 'R' or 'B', A is
          multiplied on the left by diag(R); if EQUED = 'N' or 'C', R
          is not accessed.  R is an input argument if FACT = 'F';
          otherwise, R is an output argument.  If FACT = 'F' and
          EQUED = 'R' or 'B', each element of R must be positive.

  C       (input or output) DOUBLE PRECISION array, dimension (N)
          The column scale factors for A.  If EQUED = 'C' or 'B', A is

          multiplied on the right by diag(C); if EQUED = 'N' or 'R', C

          is not accessed.  C is an input argument if FACT = 'F';
          otherwise, C is an output argument.  If FACT = 'F' and
          EQUED = 'C' or 'B', each element of C must be positive.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit,
          if EQUED = 'N', B is not modified;
          if TRANS = 'N' and EQUED = 'R' or 'B', B is overwritten by
          diag(R)*B;
          if TRANS = 'T' or 'C' and EQUED = 'C' or 'B', B is
          overwritten by diag(C)*B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X
          to the original system of equations.  Note that A and B are
          modified on exit if EQUED .ne. 'N', and the solution to the
          equilibrated system is inv(diag(C))*X if TRANS = 'N' and
          EQUED = 'C' or 'B', or inv(diag(R))*X if TRANS = 'T' or 'C'
          and EQUED = 'R' or 'B'.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The estimate of the reciprocal condition number of the matrix
          A after equilibration (if done).  If RCOND is less than the
          machine precision (in particular, if RCOND = 0), the matrix
          is singular to working precision.  This condition is
          indicated by a return code of INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (4*N)
          On exit, WORK(1) contains the reciprocal pivot growth
          factor norm(A)/norm(U). The "max absolute element" norm is
          used. If WORK(1) is much less than 1, then the stability
          of the LU factorization of the (equilibrated) matrix A
          could be poor. This also means that the solution X, condition
          estimator RCOND, and forward error bound FERR could be
          unreliable. If factorization fails with 0<INFO<=N, then
          WORK(1) contains the reciprocal pivot growth factor for the
          leading INFO columns of A.

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= N:  U(i,i) is exactly zero.  The factorization has
                       been completed, but the factor U is exactly
                       singular, so the solution and error bounds
                       could not be computed. RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param af
	 * @param ldaf
	 * @param ipiv
	 * @param equed
	 * @param r
	 * @param c
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgesvx(String fact, String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGETC2 computes an LU factorization with complete pivoting of the
  n-by-n matrix A. The factorization has the form A = P * L * U * Q,
  where P and Q are permutation matrices, L is lower triangular with
  unit diagonal elements and U is upper triangular.

  This is the Level 2 BLAS algorithm.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the n-by-n matrix A to be factored.
          On exit, the factors L and U from the factorization
          A = P*L*U*Q; the unit diagonal elements of L are not stored.

          If U(k, k) appears to be less than SMIN, U(k, k) is given the
          value of SMIN, i.e., giving a nonsingular perturbed system.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  IPIV    (output) INTEGER array, dimension(N).
          The pivot indices; for 1 <= i <= N, row i of the
          matrix has been interchanged with row IPIV(i).

  JPIV    (output) INTEGER array, dimension(N).
          The pivot indices; for 1 <= j <= N, column j of the
          matrix has been interchanged with column JPIV(j).

  INFO    (output) INTEGER
           = 0: successful exit
           > 0: if INFO = k, U(k, k) is likely to produce owerflow if
                we try to solve for x in Ax = b. So U is perturbed to
                avoid the overflow.

  Further Details
  ===============

  Based on contributions by
     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
     Umea University, S-901 87 Umea, Sweden.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param jpiv
	 * @param info
	 */
	public abstract void dgetc2(int n, double[] a, int lda, int[] ipiv, int[] jpiv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGETF2 computes an LU factorization of a general m-by-n matrix A
  using partial pivoting with row interchanges.

  The factorization has the form
     A = P * L * U
  where P is a permutation matrix, L is lower triangular with unit
  diagonal elements (lower trapezoidal if m > n), and U is upper
  triangular (upper trapezoidal if m < n).

  This is the right-looking Level 2 BLAS version of the algorithm.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n matrix to be factored.
          On exit, the factors L and U from the factorization
          A = P*L*U; the unit diagonal elements of L are not stored.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  IPIV    (output) INTEGER array, dimension (min(M,N))
          The pivot indices; for 1 <= i <= min(M,N), row i of the
          matrix was interchanged with row IPIV(i).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value
          > 0: if INFO = k, U(k,k) is exactly zero. The factorization
               has been completed, but the factor U is exactly
               singular, and division by zero will occur if it is used

               to solve a system of equations.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param info
	 */
	public abstract void dgetf2(int m, int n, double[] a, int lda, int[] ipiv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGETRF computes an LU factorization of a general M-by-N matrix A
  using partial pivoting with row interchanges.

  The factorization has the form
     A = P * L * U
  where P is a permutation matrix, L is lower triangular with unit
  diagonal elements (lower trapezoidal if m > n), and U is upper
  triangular (upper trapezoidal if m < n).

  This is the right-looking Level 3 BLAS version of the algorithm.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix to be factored.
          On exit, the factors L and U from the factorization
          A = P*L*U; the unit diagonal elements of L are not stored.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  IPIV    (output) INTEGER array, dimension (min(M,N))
          The pivot indices; for 1 <= i <= min(M,N), row i of the
          matrix was interchanged with row IPIV(i).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, U(i,i) is exactly zero. The factorization

                has been completed, but the factor U is exactly
                singular, and division by zero will occur if it is used
                to solve a system of equations.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param info
	 */
	public abstract void dgetrf(int m, int n, double[] a, int lda, int[] ipiv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGETRI computes the inverse of a matrix using the LU factorization
  computed by DGETRF.

  This method inverts U and then computes inv(A) by solving the system

  inv(A)*L = inv(U) for inv(A).

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the factors L and U from the factorization
          A = P*L*U as computed by DGETRF.
          On exit, if INFO = 0, the inverse of the original matrix A.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices from DGETRF; for 1<=i<=N, row i of the
          matrix was interchanged with row IPIV(i).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO=0, then WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,N).
          For optimal performance LWORK >= N*NB, where NB is
          the optimal blocksize returned by ILAENV.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, U(i,i) is exactly zero; the matrix is
                singular and its inverse could not be computed.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgetri(int n, double[] a, int lda, int[] ipiv, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGETRS solves a system of linear equations
     A * X = B  or  A' * X = B
  with a general N-by-N matrix A using the LU factorization computed
  by DGETRF.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations:
          = 'N':  A * X = B  (No transpose)
          = 'T':  A'* X = B  (Transpose)
          = 'C':  A'* X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The factors L and U from the factorization A = P*L*U
          as computed by DGETRF.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices from DGETRF; for 1<=i<=N, row i of the
          matrix was interchanged with row IPIV(i).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side matrix B.
          On exit, the solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dgetrs(String trans, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGBAK forms the right or left eigenvectors of a real generalized
  eigenvalue problem A*x = lambda*B*x, by backward transformation on
  the computed eigenvectors of the balanced pair of matrices output by

  DGGBAL.

  Arguments
  =========

  JOB     (input) CHARACTER*1
          Specifies the type of backward transformation required:
          = 'N':  do nothing, return immediately;
          = 'P':  do backward transformation for permutation only;
          = 'S':  do backward transformation for scaling only;
          = 'B':  do backward transformations for both permutation and

                  scaling.
          JOB must be the same as the argument JOB supplied to DGGBAL.


  SIDE    (input) CHARACTER*1
          = 'R':  V contains right eigenvectors;
          = 'L':  V contains left eigenvectors.

  N       (input) INTEGER
          The number of rows of the matrix V.  N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          The integers ILO and IHI determined by DGGBAL.
          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.

  LSCALE  (input) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and/or scaling factors applied
          to the left side of A and B, as returned by DGGBAL.

  RSCALE  (input) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and/or scaling factors applied
          to the right side of A and B, as returned by DGGBAL.

  M       (input) INTEGER
          The number of columns of the matrix V.  M >= 0.

  V       (input/output) DOUBLE PRECISION array, dimension (LDV,M)
          On entry, the matrix of right or left eigenvectors to be
          transformed, as returned by DTGEVC.
          On exit, V is overwritten by the transformed eigenvectors.

  LDV     (input) INTEGER
          The leading dimension of the matrix V. LDV >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  See R.C. Ward, Balancing the generalized eigenvalue problem,
                 SIAM J. Sci. Stat. Comp. 2 (1981), 141-152.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param job
	 * @param side
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param lscale
	 * @param rscale
	 * @param m
	 * @param v
	 * @param ldv
	 * @param info
	 */
	public abstract void dggbak(String job, String side, int n, int ilo, int ihi, double[] lscale, double[] rscale, int m, double[] v, int ldv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGBAL balances a pair of general real matrices (A,B).  This
  involves, first, permuting A and B by similarity transformations to
  isolate eigenvalues in the first 1 to ILO$-$1 and last IHI+1 to N
  elements on the diagonal; and second, applying a diagonal similarity

  transformation to rows and columns ILO to IHI to make the rows
  and columns as close in norm as possible. Both steps are optional.

  Balancing may reduce the 1-norm of the matrices, and improve the
  accuracy of the computed eigenvalues and/or eigenvectors in the
  generalized eigenvalue problem A*x = lambda*B*x.

  Arguments
  =========

  JOB     (input) CHARACTER*1
          Specifies the operations to be performed on A and B:
          = 'N':  none:  simply set ILO = 1, IHI = N, LSCALE(I) = 1.0
                  and RSCALE(I) = 1.0 for i = 1,...,N.
          = 'P':  permute only;
          = 'S':  scale only;
          = 'B':  both permute and scale.

  N       (input) INTEGER
          The order of the matrices A and B.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the input matrix A.
          On exit,  A is overwritten by the balanced matrix.
          If JOB = 'N', A is not referenced.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
          On entry, the input matrix B.
          On exit,  B is overwritten by the balanced matrix.
          If JOB = 'N', B is not referenced.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,N).

  ILO     (output) INTEGER
  IHI     (output) INTEGER
          ILO and IHI are set to integers such that on exit
          A(i,j) = 0 and B(i,j) = 0 if i > j and
          j = 1,...,ILO-1 or i = IHI+1,...,N.
          If JOB = 'N' or 'S', ILO = 1 and IHI = N.

  LSCALE  (output) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and scaling factors applied
          to the left side of A and B.  If P(j) is the index of the
          row interchanged with row j, and D(j)
          is the scaling factor applied to row j, then
            LSCALE(j) = P(j)    for J = 1,...,ILO-1
                      = D(j)    for J = ILO,...,IHI
                      = P(j)    for J = IHI+1,...,N.
          The order in which the interchanges are made is N to IHI+1,
          then 1 to ILO-1.

  RSCALE  (output) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and scaling factors applied
          to the right side of A and B.  If P(j) is the index of the
          column interchanged with column j, and D(j)
          is the scaling factor applied to column j, then
            LSCALE(j) = P(j)    for J = 1,...,ILO-1
                      = D(j)    for J = ILO,...,IHI
                      = P(j)    for J = IHI+1,...,N.
          The order in which the interchanges are made is N to IHI+1,
          then 1 to ILO-1.

  WORK    (workspace) REAL array, dimension (lwork)
          lwork must be at least max(1,6*N) when JOB = 'S' or 'B', and

          at least 1 when JOB = 'N' or 'P'.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  See R.C. WARD, Balancing the generalized eigenvalue problem,
                 SIAM J. Sci. Stat. Comp. 2 (1981), 141-152.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param job
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param ilo
	 * @param ihi
	 * @param lscale
	 * @param rscale
	 * @param work
	 * @param info
	 */
	public abstract void dggbal(String job, int n, double[] a, int lda, double[] b, int ldb, intW ilo, intW ihi, double[] lscale, double[] rscale, double[] work, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DGGES computes for a pair of N-by-N real nonsymmetric matrices (A,B),
  the generalized eigenvalues, the generalized real Schur form (S,T),
  optionally, the left and/or right matrices of Schur vectors (VSL and

  VSR). This gives the generalized Schur factorization

           (A,B) = ( (VSL)*S*(VSR)**T, (VSL)*T*(VSR)**T )

  Optionally, it also orders the eigenvalues so that a selected cluster
  of eigenvalues appears in the leading diagonal blocks of the upper
  quasi-triangular matrix S and the upper triangular matrix T.The
  leading columns of VSL and VSR then form an orthonormal basis for the
  corresponding left and right eigenspaces (deflating subspaces).

  (If only the generalized eigenvalues are needed, use the driver
  DGGEV instead, which is faster.)

  A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
  or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
  usually represented as the pair (alpha,beta), as there is a
  reasonable interpretation for beta=0 or both being zero.

  A pair of matrices (S,T) is in generalized real Schur form if T is
  upper triangular with non-negative diagonal and S is block upper
  triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
  to real generalized eigenvalues, while 2-by-2 blocks of S will be
  "standardized" by making the corresponding elements of T have the
  form:
          [  a  0  ]
          [  0  b  ]

  and the pair of corresponding 2-by-2 blocks in S and T will have a
  complex conjugate pair of generalized eigenvalues.


  Arguments
  =========

  JOBVSL  (input) CHARACTER*1
          = 'N':  do not compute the left Schur vectors;
          = 'V':  compute the left Schur vectors.

  JOBVSR  (input) CHARACTER*1
          = 'N':  do not compute the right Schur vectors;
          = 'V':  compute the right Schur vectors.

  SORT    (input) CHARACTER*1
          Specifies whether or not to order the eigenvalues on the
          diagonal of the generalized Schur form.
          = 'N':  Eigenvalues are not ordered;
          = 'S':  Eigenvalues are ordered (see SELCTG);

  SELCTG  (external procedure) LOGICAL FUNCTION of three DOUBLE PRECISI
          SELCTG must be declared EXTERNAL in the calling subroutine.
          If SORT = 'N', SELCTG is not referenced.
          If SORT = 'S', SELCTG is used to select eigenvalues to sort
          to the top left of the Schur form.
          An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if
          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either
          one of a complex conjugate pair of eigenvalues is selected,
          then both complex eigenvalues are selected.

          Note that in the ill-conditioned case, a selected complex
          eigenvalue may no longer satisfy SELCTG(ALPHAR(j),ALPHAI(j),

          BETA(j)) = .TRUE. after ordering. INFO is to be set to N+2
          in this case.

  N       (input) INTEGER
          The order of the matrices A, B, VSL, and VSR.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the first of the pair of matrices.
          On exit, A has been overwritten by its generalized Schur
          form S.

  LDA     (input) INTEGER
          The leading dimension of A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the second of the pair of matrices.
          On exit, B has been overwritten by its generalized Schur
          form T.

  LDB     (input) INTEGER
          The leading dimension of B.  LDB >= max(1,N).

  SDIM    (output) INTEGER
          If SORT = 'N', SDIM = 0.
          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
          for which SELCTG is true.  (Complex conjugate pairs for which
          SELCTG is true for either eigenvalue count as 2.)

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
  BETA    (output) DOUBLE PRECISION array, dimension (N)
          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
          be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i,
          and  BETA(j),j=1,...,N are the diagonals of the complex Schur
          form (S,T) that would result if the 2-by-2 diagonal blocks of
          the real Schur form of (A,B) were further reduced to
          triangular form using 2-by-2 complex unitary transformations.
          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
          positive, then the j-th and (j+1)-st eigenvalues are a
          complex conjugate pair, with ALPHAI(j+1) negative.

          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
          may easily over- or underflow, and BETA(j) may even be zero.

          Thus, the user should avoid naively computing the ratio.
          However, ALPHAR and ALPHAI will be always less than and
          usually comparable with norm(A) in magnitude, and BETA always
          less than and usually comparable with norm(B).

  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
          If JOBVSL = 'V', VSL will contain the left Schur vectors.
          Not referenced if JOBVSL = 'N'.

  LDVSL   (input) INTEGER
          The leading dimension of the matrix VSL. LDVSL >=1, and
          if JOBVSL = 'V', LDVSL >= N.

  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
          If JOBVSR = 'V', VSR will contain the right Schur vectors.
          Not referenced if JOBVSR = 'N'.

  LDVSR   (input) INTEGER
          The leading dimension of the matrix VSR. LDVSR >= 1, and
          if JOBVSR = 'V', LDVSR >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If N = 0, LWORK >= 1, else LWORK >= 8*N+16.
          For good performance , LWORK must generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  BWORK   (workspace) LOGICAL array, dimension (N)
          Not referenced if SORT = 'N'.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1,...,N:
                The QZ iteration failed.  (A,B) are not in Schur
                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
                be correct for j=INFO+1,...,N.
          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
                =N+2: after reordering, roundoff changed values of
                      some complex eigenvalues so that leading
                      eigenvalues in the Generalized Schur form no
                      longer satisfy SELCTG=.TRUE.  This could also
                      be caused due to scaling.
                =N+3: reordering failed in DTGSEN.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvsl
	 * @param jobvsr
	 * @param sort
	 * @param selctg
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param sdim
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param vsl
	 * @param ldvsl
	 * @param vsr
	 * @param ldvsr
	 * @param work
	 * @param lwork
	 * @param bwork
	 * @param info
	 */
	public void dgges(String jobvsl, String jobvsr, String sort, Object selctg, int n, double[] a, int lda, double[] b, int ldb, intW sdim, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] work, int lwork, boolean[] bwork, intW info) {
		org.netlib.lapack.Dgges.dgges(jobvsl, jobvsr, sort, selctg, n, a, 0, lda, b, 0, ldb, sdim, alphar, 0, alphai, 0, beta, 0, vsl, 0, ldvsl, vsr, 0, ldvsr, work, 0, lwork, bwork, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DGGESX computes for a pair of N-by-N real nonsymmetric matrices
  (A,B), the generalized eigenvalues, the real Schur form (S,T), and,
  optionally, the left and/or right matrices of Schur vectors (VSL and

  VSR).  This gives the generalized Schur factorization

       (A,B) = ( (VSL) S (VSR)**T, (VSL) T (VSR)**T )

  Optionally, it also orders the eigenvalues so that a selected cluster
  of eigenvalues appears in the leading diagonal blocks of the upper
  quasi-triangular matrix S and the upper triangular matrix T; computes
  a reciprocal condition number for the average of the selected
  eigenvalues (RCONDE); and computes a reciprocal condition number for

  the right and left deflating subspaces corresponding to the selected

  eigenvalues (RCONDV). The leading columns of VSL and VSR then form
  an orthonormal basis for the corresponding left and right eigenspaces
  (deflating subspaces).

  A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
  or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
  usually represented as the pair (alpha,beta), as there is a
  reasonable interpretation for beta=0 or for both being zero.

  A pair of matrices (S,T) is in generalized real Schur form if T is
  upper triangular with non-negative diagonal and S is block upper
  triangular with 1-by-1 and 2-by-2 blocks.  1-by-1 blocks correspond
  to real generalized eigenvalues, while 2-by-2 blocks of S will be
  "standardized" by making the corresponding elements of T have the
  form:
          [  a  0  ]
          [  0  b  ]

  and the pair of corresponding 2-by-2 blocks in S and T will have a
  complex conjugate pair of generalized eigenvalues.


  Arguments
  =========

  JOBVSL  (input) CHARACTER*1
          = 'N':  do not compute the left Schur vectors;
          = 'V':  compute the left Schur vectors.

  JOBVSR  (input) CHARACTER*1
          = 'N':  do not compute the right Schur vectors;
          = 'V':  compute the right Schur vectors.

  SORT    (input) CHARACTER*1
          Specifies whether or not to order the eigenvalues on the
          diagonal of the generalized Schur form.
          = 'N':  Eigenvalues are not ordered;
          = 'S':  Eigenvalues are ordered (see SELCTG).

  SELCTG  (external procedure) LOGICAL FUNCTION of three DOUBLE PRECISI
          SELCTG must be declared EXTERNAL in the calling subroutine.
          If SORT = 'N', SELCTG is not referenced.
          If SORT = 'S', SELCTG is used to select eigenvalues to sort
          to the top left of the Schur form.
          An eigenvalue (ALPHAR(j)+ALPHAI(j))/BETA(j) is selected if
          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) is true; i.e. if either
          one of a complex conjugate pair of eigenvalues is selected,
          then both complex eigenvalues are selected.
          Note that a selected complex eigenvalue may no longer satisfy
          SELCTG(ALPHAR(j),ALPHAI(j),BETA(j)) = .TRUE. after ordering,

          since ordering may change the value of complex eigenvalues
          (especially if the eigenvalue is ill-conditioned), in this
          case INFO is set to N+3.

  SENSE   (input) CHARACTER*1
          Determines which reciprocal condition numbers are computed.
          = 'N' : None are computed;
          = 'E' : Computed for average of selected eigenvalues only;
          = 'V' : Computed for selected deflating subspaces only;
          = 'B' : Computed for both.
          If SENSE = 'E', 'V', or 'B', SORT must equal 'S'.

  N       (input) INTEGER
          The order of the matrices A, B, VSL, and VSR.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the first of the pair of matrices.
          On exit, A has been overwritten by its generalized Schur
          form S.

  LDA     (input) INTEGER
          The leading dimension of A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the second of the pair of matrices.
          On exit, B has been overwritten by its generalized Schur
          form T.

  LDB     (input) INTEGER
          The leading dimension of B.  LDB >= max(1,N).

  SDIM    (output) INTEGER
          If SORT = 'N', SDIM = 0.
          If SORT = 'S', SDIM = number of eigenvalues (after sorting)
          for which SELCTG is true.  (Complex conjugate pairs for which
          SELCTG is true for either eigenvalue count as 2.)

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
  BETA    (output) DOUBLE PRECISION array, dimension (N)
          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
          be the generalized eigenvalues.  ALPHAR(j) + ALPHAI(j)*i
          and BETA(j),j=1,...,N  are the diagonals of the complex Schur
          form (S,T) that would result if the 2-by-2 diagonal blocks of
          the real Schur form of (A,B) were further reduced to
          triangular form using 2-by-2 complex unitary transformations.
          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
          positive, then the j-th and (j+1)-st eigenvalues are a
          complex conjugate pair, with ALPHAI(j+1) negative.

          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
          may easily over- or underflow, and BETA(j) may even be zero.

          Thus, the user should avoid naively computing the ratio.
          However, ALPHAR and ALPHAI will be always less than and
          usually comparable with norm(A) in magnitude, and BETA always
          less than and usually comparable with norm(B).

  VSL     (output) DOUBLE PRECISION array, dimension (LDVSL,N)
          If JOBVSL = 'V', VSL will contain the left Schur vectors.
          Not referenced if JOBVSL = 'N'.

  LDVSL   (input) INTEGER
          The leading dimension of the matrix VSL. LDVSL >=1, and
          if JOBVSL = 'V', LDVSL >= N.

  VSR     (output) DOUBLE PRECISION array, dimension (LDVSR,N)
          If JOBVSR = 'V', VSR will contain the right Schur vectors.
          Not referenced if JOBVSR = 'N'.

  LDVSR   (input) INTEGER
          The leading dimension of the matrix VSR. LDVSR >= 1, and
          if JOBVSR = 'V', LDVSR >= N.

  RCONDE  (output) DOUBLE PRECISION array, dimension ( 2 )
          If SENSE = 'E' or 'B', RCONDE(1) and RCONDE(2) contain the
          reciprocal condition numbers for the average of the selected

          eigenvalues.
          Not referenced if SENSE = 'N' or 'V'.

  RCONDV  (output) DOUBLE PRECISION array, dimension ( 2 )
          If SENSE = 'V' or 'B', RCONDV(1) and RCONDV(2) contain the
          reciprocal condition numbers for the selected deflating
          subspaces.
          Not referenced if SENSE = 'N' or 'E'.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If N = 0, LWORK >= 1, else if SENSE = 'E', 'V', or 'B',
          LWORK >= max( 8*N, 6*N+16, 2*SDIM*(N-SDIM) ), else
          LWORK >= max( 8*N, 6*N+16 ).
          Note that 2*SDIM*(N-SDIM) <= N*N/2.
          Note also that an error is only returned if
          LWORK < max( 8*N, 6*N+16), but if SENSE = 'E' or 'V' or 'B'
          this may not be large enough.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the bound on the optimal size of the WORK
          array and the minimum size of the IWORK array, returns these

          values as the first entries of the WORK and IWORK arrays, and
          no error message related to LWORK or LIWORK is issued by
          XERBLA.

  IWORK   (workspace) INTEGER array, dimension (MAX(1,LIWORK))
          On exit, if INFO = 0, IWORK(1) returns the minimum LIWORK.

  LIWORK  (input) INTEGER
          The dimension of the array IWORK.
          If SENSE = 'N' or N = 0, LIWORK >= 1, otherwise
          LIWORK >= N+6.

          If LIWORK = -1, then a workspace query is assumed; the
          routine only calculates the bound on the optimal size of the

          WORK array and the minimum size of the IWORK array, returns
          these values as the first entries of the WORK and IWORK
          arrays, and no error message related to LWORK or LIWORK is
          issued by XERBLA.

  BWORK   (workspace) LOGICAL array, dimension (N)
          Not referenced if SORT = 'N'.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1,...,N:
                The QZ iteration failed.  (A,B) are not in Schur
                form, but ALPHAR(j), ALPHAI(j), and BETA(j) should
                be correct for j=INFO+1,...,N.
          > N:  =N+1: other than QZ iteration failed in DHGEQZ
                =N+2: after reordering, roundoff changed values of
                      some complex eigenvalues so that leading
                      eigenvalues in the Generalized Schur form no
                      longer satisfy SELCTG=.TRUE.  This could also
                      be caused due to scaling.
                =N+3: reordering failed in DTGSEN.

  Further details
  ===============

  An approximate (asymptotic) bound on the average absolute error of
  the selected eigenvalues is

       EPS * norm((A, B)) / RCONDE( 1 ).

  An approximate (asymptotic) bound on the maximum angular error in
  the computed deflating subspaces is

       EPS * norm((A, B)) / RCONDV( 2 ).

  See LAPACK User's Guide, section 4.11 for more information.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvsl
	 * @param jobvsr
	 * @param sort
	 * @param selctg
	 * @param sense
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param sdim
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param vsl
	 * @param ldvsl
	 * @param vsr
	 * @param ldvsr
	 * @param rconde
	 * @param rcondv
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param liwork
	 * @param bwork
	 * @param info
	 */
	public void dggesx(String jobvsl, String jobvsr, String sort, Object selctg, String sense, int n, double[] a, int lda, double[] b, int ldb, intW sdim, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, int liwork, boolean[] bwork, intW info) {
		org.netlib.lapack.Dggesx.dggesx(jobvsl, jobvsr, sort, selctg, sense, n, a, 0, lda, b, 0, ldb, sdim, alphar, 0, alphai, 0, beta, 0, vsl, 0, ldvsl, vsr, 0, ldvsr, rconde, 0, rcondv, 0, work, 0, lwork, iwork, 0, liwork, bwork, 0, info);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DGGEV computes for a pair of N-by-N real nonsymmetric matrices (A,B)

  the generalized eigenvalues, and optionally, the left and/or right
  generalized eigenvectors.

  A generalized eigenvalue for a pair of matrices (A,B) is a scalar
  lambda or a ratio alpha/beta = lambda, such that A - lambda*B is
  singular. It is usually represented as the pair (alpha,beta), as
  there is a reasonable interpretation for beta=0, and even for both
  being zero.

  The right eigenvector v(j) corresponding to the eigenvalue lambda(j)

  of (A,B) satisfies

                   A * v(j) = lambda(j) * B * v(j).

  The left eigenvector u(j) corresponding to the eigenvalue lambda(j)
  of (A,B) satisfies

                   u(j)**H * A  = lambda(j) * u(j)**H * B .

  where u(j)**H is the conjugate-transpose of u(j).


  Arguments
  =========

  JOBVL   (input) CHARACTER*1
          = 'N':  do not compute the left generalized eigenvectors;
          = 'V':  compute the left generalized eigenvectors.

  JOBVR   (input) CHARACTER*1
          = 'N':  do not compute the right generalized eigenvectors;
          = 'V':  compute the right generalized eigenvectors.

  N       (input) INTEGER
          The order of the matrices A, B, VL, and VR.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the matrix A in the pair (A,B).
          On exit, A has been overwritten.

  LDA     (input) INTEGER
          The leading dimension of A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the matrix B in the pair (A,B).
          On exit, B has been overwritten.

  LDB     (input) INTEGER
          The leading dimension of B.  LDB >= max(1,N).

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
  BETA    (output) DOUBLE PRECISION array, dimension (N)
          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
          be the generalized eigenvalues.  If ALPHAI(j) is zero, then
          the j-th eigenvalue is real; if positive, then the j-th and
          (j+1)-st eigenvalues are a complex conjugate pair, with
          ALPHAI(j+1) negative.

          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
          may easily over- or underflow, and BETA(j) may even be zero.

          Thus, the user should avoid naively computing the ratio
          alpha/beta.  However, ALPHAR and ALPHAI will be always less
          than and usually comparable with norm(A) in magnitude, and
          BETA always less than and usually comparable with norm(B).

  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
          If JOBVL = 'V', the left eigenvectors u(j) are stored one
          after another in the columns of VL, in the same order as
          their eigenvalues. If the j-th eigenvalue is real, then
          u(j) = VL(:,j), the j-th column of VL. If the j-th and
          (j+1)-th eigenvalues form a complex conjugate pair, then
          u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).

          Each eigenvector is scaled so the largest component has
          abs(real part)+abs(imag. part)=1.
          Not referenced if JOBVL = 'N'.

  LDVL    (input) INTEGER
          The leading dimension of the matrix VL. LDVL >= 1, and
          if JOBVL = 'V', LDVL >= N.

  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
          If JOBVR = 'V', the right eigenvectors v(j) are stored one
          after another in the columns of VR, in the same order as
          their eigenvalues. If the j-th eigenvalue is real, then
          v(j) = VR(:,j), the j-th column of VR. If the j-th and
          (j+1)-th eigenvalues form a complex conjugate pair, then
          v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).

          Each eigenvector is scaled so the largest component has
          abs(real part)+abs(imag. part)=1.
          Not referenced if JOBVR = 'N'.

  LDVR    (input) INTEGER
          The leading dimension of the matrix VR. LDVR >= 1, and
          if JOBVR = 'V', LDVR >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,8*N).
          For good performance, LWORK must generally be larger.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1,...,N:
                The QZ iteration failed.  No eigenvectors have been
                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
                should be correct for j=INFO+1,...,N.
          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
                =N+2: error return from DTGEVC.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobvl
	 * @param jobvr
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param vl
	 * @param ldvl
	 * @param vr
	 * @param ldvr
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dggev(String jobvl, String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGEVX computes for a pair of N-by-N real nonsymmetric matrices (A,B)
  the generalized eigenvalues, and optionally, the left and/or right
  generalized eigenvectors.

  Optionally also, it computes a balancing transformation to improve
  the conditioning of the eigenvalues and eigenvectors (ILO, IHI,
  LSCALE, RSCALE, ABNRM, and BBNRM), reciprocal condition numbers for
  the eigenvalues (RCONDE), and reciprocal condition numbers for the
  right eigenvectors (RCONDV).

  A generalized eigenvalue for a pair of matrices (A,B) is a scalar
  lambda or a ratio alpha/beta = lambda, such that A - lambda*B is
  singular. It is usually represented as the pair (alpha,beta), as
  there is a reasonable interpretation for beta=0, and even for both
  being zero.

  The right eigenvector v(j) corresponding to the eigenvalue lambda(j)

  of (A,B) satisfies

                   A * v(j) = lambda(j) * B * v(j) .

  The left eigenvector u(j) corresponding to the eigenvalue lambda(j)
  of (A,B) satisfies

                   u(j)**H * A  = lambda(j) * u(j)**H * B.

  where u(j)**H is the conjugate-transpose of u(j).


  Arguments
  =========

  BALANC  (input) CHARACTER*1
          Specifies the balance option to be performed.
          = 'N':  do not diagonally scale or permute;
          = 'P':  permute only;
          = 'S':  scale only;
          = 'B':  both permute and scale.
          Computed reciprocal condition numbers will be for the
          matrices after permuting and/or balancing. Permuting does
          not change condition numbers (in exact arithmetic), but
          balancing does.

  JOBVL   (input) CHARACTER*1
          = 'N':  do not compute the left generalized eigenvectors;
          = 'V':  compute the left generalized eigenvectors.

  JOBVR   (input) CHARACTER*1
          = 'N':  do not compute the right generalized eigenvectors;
          = 'V':  compute the right generalized eigenvectors.

  SENSE   (input) CHARACTER*1
          Determines which reciprocal condition numbers are computed.
          = 'N': none are computed;
          = 'E': computed for eigenvalues only;
          = 'V': computed for eigenvectors only;
          = 'B': computed for eigenvalues and eigenvectors.

  N       (input) INTEGER
          The order of the matrices A, B, VL, and VR.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the matrix A in the pair (A,B).
          On exit, A has been overwritten. If JOBVL='V' or JOBVR='V'
          or both, then A contains the first part of the real Schur
          form of the "balanced" versions of the input A and B.

  LDA     (input) INTEGER
          The leading dimension of A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the matrix B in the pair (A,B).
          On exit, B has been overwritten. If JOBVL='V' or JOBVR='V'
          or both, then B contains the second part of the real Schur
          form of the "balanced" versions of the input A and B.

  LDB     (input) INTEGER
          The leading dimension of B.  LDB >= max(1,N).

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
  BETA    (output) DOUBLE PRECISION array, dimension (N)
          On exit, (ALPHAR(j) + ALPHAI(j)*i)/BETA(j), j=1,...,N, will
          be the generalized eigenvalues.  If ALPHAI(j) is zero, then
          the j-th eigenvalue is real; if positive, then the j-th and
          (j+1)-st eigenvalues are a complex conjugate pair, with
          ALPHAI(j+1) negative.

          Note: the quotients ALPHAR(j)/BETA(j) and ALPHAI(j)/BETA(j)
          may easily over- or underflow, and BETA(j) may even be zero.

          Thus, the user should avoid naively computing the ratio
          ALPHA/BETA. However, ALPHAR and ALPHAI will be always less
          than and usually comparable with norm(A) in magnitude, and
          BETA always less than and usually comparable with norm(B).

  VL      (output) DOUBLE PRECISION array, dimension (LDVL,N)
          If JOBVL = 'V', the left eigenvectors u(j) are stored one
          after another in the columns of VL, in the same order as
          their eigenvalues. If the j-th eigenvalue is real, then
          u(j) = VL(:,j), the j-th column of VL. If the j-th and
          (j+1)-th eigenvalues form a complex conjugate pair, then
          u(j) = VL(:,j)+i*VL(:,j+1) and u(j+1) = VL(:,j)-i*VL(:,j+1).

          Each eigenvector will be scaled so the largest component have
          abs(real part) + abs(imag. part) = 1.
          Not referenced if JOBVL = 'N'.

  LDVL    (input) INTEGER
          The leading dimension of the matrix VL. LDVL >= 1, and
          if JOBVL = 'V', LDVL >= N.

  VR      (output) DOUBLE PRECISION array, dimension (LDVR,N)
          If JOBVR = 'V', the right eigenvectors v(j) are stored one
          after another in the columns of VR, in the same order as
          their eigenvalues. If the j-th eigenvalue is real, then
          v(j) = VR(:,j), the j-th column of VR. If the j-th and
          (j+1)-th eigenvalues form a complex conjugate pair, then
          v(j) = VR(:,j)+i*VR(:,j+1) and v(j+1) = VR(:,j)-i*VR(:,j+1).

          Each eigenvector will be scaled so the largest component have
          abs(real part) + abs(imag. part) = 1.
          Not referenced if JOBVR = 'N'.

  LDVR    (input) INTEGER
          The leading dimension of the matrix VR. LDVR >= 1, and
          if JOBVR = 'V', LDVR >= N.

  ILO     (output) INTEGER
  IHI     (output) INTEGER
          ILO and IHI are integer values such that on exit
          A(i,j) = 0 and B(i,j) = 0 if i > j and
          j = 1,...,ILO-1 or i = IHI+1,...,N.
          If BALANC = 'N' or 'S', ILO = 1 and IHI = N.

  LSCALE  (output) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and scaling factors applied
          to the left side of A and B.  If PL(j) is the index of the
          row interchanged with row j, and DL(j) is the scaling
          factor applied to row j, then
            LSCALE(j) = PL(j)  for j = 1,...,ILO-1
                      = DL(j)  for j = ILO,...,IHI
                      = PL(j)  for j = IHI+1,...,N.
          The order in which the interchanges are made is N to IHI+1,
          then 1 to ILO-1.

  RSCALE  (output) DOUBLE PRECISION array, dimension (N)
          Details of the permutations and scaling factors applied
          to the right side of A and B.  If PR(j) is the index of the
          column interchanged with column j, and DR(j) is the scaling
          factor applied to column j, then
            RSCALE(j) = PR(j)  for j = 1,...,ILO-1
                      = DR(j)  for j = ILO,...,IHI
                      = PR(j)  for j = IHI+1,...,N
          The order in which the interchanges are made is N to IHI+1,
          then 1 to ILO-1.

  ABNRM   (output) DOUBLE PRECISION
          The one-norm of the balanced matrix A.

  BBNRM   (output) DOUBLE PRECISION
          The one-norm of the balanced matrix B.

  RCONDE  (output) DOUBLE PRECISION array, dimension (N)
          If SENSE = 'E' or 'B', the reciprocal condition numbers of
          the eigenvalues, stored in consecutive elements of the array.
          For a complex conjugate pair of eigenvalues two consecutive
          elements of RCONDE are set to the same value. Thus RCONDE(j),
          RCONDV(j), and the j-th columns of VL and VR all correspond
          to the j-th eigenpair.
          If SENSE = 'N or 'V', RCONDE is not referenced.

  RCONDV  (output) DOUBLE PRECISION array, dimension (N)
          If SENSE = 'V' or 'B', the estimated reciprocal condition
          numbers of the eigenvectors, stored in consecutive elements
          of the array. For a complex eigenvector two consecutive
          elements of RCONDV are set to the same value. If the
          eigenvalues cannot be reordered to compute RCONDV(j),
          RCONDV(j) is set to 0; this can only occur when the true
          value would be very small anyway.
          If SENSE = 'N' or 'E', RCONDV is not referenced.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,2*N).
          If BALANC = 'S' or 'B', or JOBVL = 'V', or JOBVR = 'V',
          LWORK >= max(1,6*N).
          If SENSE = 'E' or 'B', LWORK >= max(1,10*N).
          If SENSE = 'V' or 'B', LWORK >= 2*N*N+8*N+16.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  IWORK   (workspace) INTEGER array, dimension (N+6)
          If SENSE = 'E', IWORK is not referenced.

  BWORK   (workspace) LOGICAL array, dimension (N)
          If SENSE = 'N', BWORK is not referenced.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1,...,N:
                The QZ iteration failed.  No eigenvectors have been
                calculated, but ALPHAR(j), ALPHAI(j), and BETA(j)
                should be correct for j=INFO+1,...,N.
          > N:  =N+1: other than QZ iteration failed in DHGEQZ.
                =N+2: error return from DTGEVC.

  Further Details
  ===============

  Balancing a matrix pair (A,B) includes, first, permuting rows and
  columns to isolate eigenvalues, second, applying diagonal similarity

  transformation to the rows and columns to make the rows and columns
  as close in norm as possible. The computed reciprocal condition
  numbers correspond to the balanced matrix. Permuting rows and columns
  will not change the condition numbers (in exact arithmetic) but
  diagonal scaling will.  For further explanation of balancing, see
  section 4.11.1.2 of LAPACK Users' Guide.

  An approximate error bound on the chordal distance between the i-th
  computed generalized eigenvalue w and the corresponding exact
  eigenvalue lambda is

       chord(w, lambda) <= EPS * norm(ABNRM, BBNRM) / RCONDE(I)

  An approximate error bound for the angle between the i-th computed
  eigenvector VL(i) or VR(i) is given by

       EPS * norm(ABNRM, BBNRM) / DIF(i).

  For further explanation of the reciprocal condition numbers RCONDE
  and RCONDV, see section 4.11 of LAPACK User's Guide.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param balanc
	 * @param jobvl
	 * @param jobvr
	 * @param sense
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param vl
	 * @param ldvl
	 * @param vr
	 * @param ldvr
	 * @param ilo
	 * @param ihi
	 * @param lscale
	 * @param rscale
	 * @param abnrm
	 * @param bbnrm
	 * @param rconde
	 * @param rcondv
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param bwork
	 * @param info
	 */
	public abstract void dggevx(String balanc, String jobvl, String jobvr, String sense, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, intW ilo, intW ihi, double[] lscale, double[] rscale, doubleW abnrm, doubleW bbnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, boolean[] bwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGGLM solves a general Gauss-Markov linear model (GLM) problem:

          minimize || y ||_2   subject to   d = A*x + B*y
              x

  where A is an N-by-M matrix, B is an N-by-P matrix, and d is a
  given N-vector. It is assumed that M <= N <= M+P, and

             rank(A) = M    and    rank( A B ) = N.

  Under these assumptions, the constrained equation is always
  consistent, and there is a unique solution x and a minimal 2-norm
  solution y, which is obtained using a generalized QR factorization
  of the matrices (A, B) given by

     A = Q*(R),   B = Q*T*Z.
           (0)

  In particular, if matrix B is square nonsingular, then the problem
  GLM is equivalent to the following weighted linear least squares
  problem

               minimize || inv(B)*(d-A*x) ||_2
                   x

  where inv(B) denotes the inverse of B.

  Arguments
  =========

  N       (input) INTEGER
          The number of rows of the matrices A and B.  N >= 0.

  M       (input) INTEGER
          The number of columns of the matrix A.  0 <= M <= N.

  P       (input) INTEGER
          The number of columns of the matrix B.  P >= N-M.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,M)
          On entry, the N-by-M matrix A.
          On exit, the upper triangular part of the array A contains
          the M-by-M upper triangular matrix R.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,P)
          On entry, the N-by-P matrix B.
          On exit, if N <= P, the upper triangle of the subarray
          B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;
          if N > P, the elements on and above the (N-P)th subdiagonal
          contain the N-by-P upper trapezoidal matrix T.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,N).

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, D is the left hand side of the GLM equation.
          On exit, D is destroyed.

  X       (output) DOUBLE PRECISION array, dimension (M)
  Y       (output) DOUBLE PRECISION array, dimension (P)
          On exit, X and Y are the solutions of the GLM problem.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,N+M+P).
          For optimum performance, LWORK >= M+min(N,P)+max(N,P)*NB,
          where NB is an upper bound for the optimal blocksizes for
          DGEQRF, SGERQF, DORMQR and SORMRQ.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1:  the upper triangular factor R associated with A in the

                generalized QR factorization of the pair (A, B) is
                singular, so that rank(A) < M; the least squares
                solution could not be computed.
          = 2:  the bottom (N-M) by (N-M) part of the upper trapezoidal
                factor T associated with B in the generalized QR
                factorization of the pair (A, B) is singular, so that
                rank( A B ) < N; the least squares solution could not
                be computed.

  ===================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param m
	 * @param p
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param d
	 * @param x
	 * @param y
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dggglm(int n, int m, int p, double[] a, int lda, double[] b, int ldb, double[] d, double[] x, double[] y, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGHRD reduces a pair of real matrices (A,B) to generalized upper
  Hessenberg form using orthogonal transformations, where A is a
  general matrix and B is upper triangular.  The form of the
  generalized eigenvalue problem is
     A*x = lambda*B*x,
  and B is typically made upper triangular by computing its QR
  factorization and moving the orthogonal matrix Q to the left side
  of the equation.

  This subroutine simultaneously reduces A to a Hessenberg matrix H:
     Q**T*A*Z = H
  and transforms B to another upper triangular matrix T:
     Q**T*B*Z = T
  in order to reduce the problem to its standard form
     H*y = lambda*T*y
  where y = Z**T*x.

  The orthogonal matrices Q and Z are determined as products of Givens

  rotations.  They may either be formed explicitly, or they may be
  postmultiplied into input matrices Q1 and Z1, so that

       Q1 * A * Z1**T = (Q1*Q) * H * (Z1*Z)**T

       Q1 * B * Z1**T = (Q1*Q) * T * (Z1*Z)**T

  If Q1 is the orthogonal matrix from the QR factorization of B in the

  original equation A*x = lambda*B*x, then DGGHRD reduces the original

  problem to generalized Hessenberg form.

  Arguments
  =========

  COMPQ   (input) CHARACTER*1
          = 'N': do not compute Q;
          = 'I': Q is initialized to the unit matrix, and the
                 orthogonal matrix Q is returned;
          = 'V': Q must contain an orthogonal matrix Q1 on entry,
                 and the product Q1*Q is returned.

  COMPZ   (input) CHARACTER*1
          = 'N': do not compute Z;
          = 'I': Z is initialized to the unit matrix, and the
                 orthogonal matrix Z is returned;
          = 'V': Z must contain an orthogonal matrix Z1 on entry,
                 and the product Z1*Z is returned.

  N       (input) INTEGER
          The order of the matrices A and B.  N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          ILO and IHI mark the rows and columns of A which are to be
          reduced.  It is assumed that A is already upper triangular
          in rows and columns 1:ILO-1 and IHI+1:N.  ILO and IHI are
          normally set by a previous call to SGGBAL; otherwise they
          should be set to 1 and N respectively.
          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, N)
          On entry, the N-by-N general matrix to be reduced.
          On exit, the upper triangle and the first subdiagonal of A
          are overwritten with the upper Hessenberg matrix H, and the
          rest is set to zero.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, N)
          On entry, the N-by-N upper triangular matrix B.
          On exit, the upper triangular matrix T = Q**T B Z.  The
          elements below the diagonal are set to zero.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
          On entry, if COMPQ = 'V', the orthogonal matrix Q1,
          typically from the QR factorization of B.
          On exit, if COMPQ='I', the orthogonal matrix Q, and if
          COMPQ = 'V', the product Q1*Q.
          Not referenced if COMPQ='N'.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.
          LDQ >= N if COMPQ='V' or 'I'; LDQ >= 1 otherwise.

  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
          On entry, if COMPZ = 'V', the orthogonal matrix Z1.
          On exit, if COMPZ='I', the orthogonal matrix Z, and if
          COMPZ = 'V', the product Z1*Z.
          Not referenced if COMPZ='N'.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.
          LDZ >= N if COMPZ='V' or 'I'; LDZ >= 1 otherwise.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  This routine reduces A to Hessenberg and B to triangular form by
  an unblocked reduction, as described in _Matrix_Computations_,
  by Golub and Van Loan (Johns Hopkins Press.)

  =====================================================================

     .. Parameters ..
</pre>
	 * @param compq
	 * @param compz
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param q
	 * @param ldq
	 * @param z
	 * @param ldz
	 * @param info
	 */
	public abstract void dgghrd(String compq, String compz, int n, int ilo, int ihi, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGLSE solves the linear equality-constrained least squares (LSE)
  problem:

          minimize || c - A*x ||_2   subject to   B*x = d

  where A is an M-by-N matrix, B is a P-by-N matrix, c is a given
  M-vector, and d is a given P-vector. It is assumed that
  P <= N <= M+P, and

           rank(B) = P and  rank( (A) ) = N.
                                ( (B) )

  These conditions ensure that the LSE problem has a unique solution,
  which is obtained using a generalized RQ factorization of the
  matrices (B, A) given by

     B = (0 R)*Q,   A = Z*T*Q.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrices A and B. N >= 0.

  P       (input) INTEGER
          The number of rows of the matrix B. 0 <= P <= N <= M+P.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the elements on and above the diagonal of the array

          contain the min(M,N)-by-N upper trapezoidal matrix T.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
          On entry, the P-by-N matrix B.
          On exit, the upper triangle of the subarray B(1:P,N-P+1:N)
          contains the P-by-P upper triangular matrix R.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,P).

  C       (input/output) DOUBLE PRECISION array, dimension (M)
          On entry, C contains the right hand side vector for the
          least squares part of the LSE problem.
          On exit, the residual sum of squares for the solution
          is given by the sum of squares of elements N-P+1 to M of
          vector C.

  D       (input/output) DOUBLE PRECISION array, dimension (P)
          On entry, D contains the right hand side vector for the
          constrained equation.
          On exit, D is destroyed.

  X       (output) DOUBLE PRECISION array, dimension (N)
          On exit, X is the solution of the LSE problem.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,M+N+P).
          For optimum performance LWORK >= P+min(M,N)+max(M,N)*NB,
          where NB is an upper bound for the optimal blocksizes for
          DGEQRF, SGERQF, DORMQR and SORMRQ.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          = 1:  the upper triangular factor R associated with B in the

                generalized RQ factorization of the pair (B, A) is
                singular, so that rank(B) < P; the least squares
                solution could not be computed.
          = 2:  the (N-P) by (N-P) part of the upper trapezoidal factor
                T associated with A in the generalized RQ factorization
                of the pair (B, A) is singular, so that
                rank( (A) ) < N; the least squares solution could not
                    ( (B) )
                be computed.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param p
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param c
	 * @param d
	 * @param x
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dgglse(int m, int n, int p, double[] a, int lda, double[] b, int ldb, double[] c, double[] d, double[] x, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGQRF computes a generalized QR factorization of an N-by-M matrix A

  and an N-by-P matrix B:

              A = Q*R,        B = Q*T*Z,

  where Q is an N-by-N orthogonal matrix, Z is a P-by-P orthogonal
  matrix, and R and T assume one of the forms:

  if N >= M,  R = ( R11 ) M  ,   or if N < M,  R = ( R11  R12 ) N,
                  (  0  ) N-M                         N   M-N
                     M

  where R11 is upper triangular, and

  if N <= P,  T = ( 0  T12 ) N,   or if N > P,  T = ( T11 ) N-P,
                   P-N  N                           ( T21 ) P
                                                       P

  where T12 or T21 is upper triangular.

  In particular, if B is square and nonsingular, the GQR factorization

  of A and B implicitly gives the QR factorization of inv(B)*A:

               inv(B)*A = Z'*(inv(T)*R)

  where inv(B) denotes the inverse of the matrix B, and Z' denotes the

  transpose of the matrix Z.

  Arguments
  =========

  N       (input) INTEGER
          The number of rows of the matrices A and B. N >= 0.

  M       (input) INTEGER
          The number of columns of the matrix A.  M >= 0.

  P       (input) INTEGER
          The number of columns of the matrix B.  P >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,M)
          On entry, the N-by-M matrix A.
          On exit, the elements on and above the diagonal of the array

          contain the min(N,M)-by-M upper trapezoidal matrix R (R is
          upper triangular if N >= M); the elements below the diagonal,
          with the array TAUA, represent the orthogonal matrix Q as a
          product of min(N,M) elementary reflectors (see Further
          Details).

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,N).

  TAUA    (output) DOUBLE PRECISION array, dimension (min(N,M))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Q (see Further Details).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,P)
          On entry, the N-by-P matrix B.
          On exit, if N <= P, the upper triangle of the subarray
          B(1:N,P-N+1:P) contains the N-by-N upper triangular matrix T;
          if N > P, the elements on and above the (N-P)-th subdiagonal

          contain the N-by-P upper trapezoidal matrix T; the remaining

          elements, with the array TAUB, represent the orthogonal
          matrix Z as a product of elementary reflectors (see Further
          Details).

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,N).

  TAUB    (output) DOUBLE PRECISION array, dimension (min(N,P))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Z (see Further Details).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,N,M,P).
          For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),
          where NB1 is the optimal blocksize for the QR factorization
          of an N-by-M matrix, NB2 is the optimal blocksize for the
          RQ factorization of an N-by-P matrix, and NB3 is the optimal

          blocksize for a call of DORMQR.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(n,m).

  Each H(i) has the form

     H(i) = I - taua * v * v'

  where taua is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:n) is stored on exit in A(i+1:n,i),

  and taua in TAUA(i).
  To form Q explicitly, use LAPACK subroutine DORGQR.
  To use Q to update another matrix, use LAPACK subroutine DORMQR.

  The matrix Z is represented as a product of elementary reflectors

     Z = H(1) H(2) . . . H(k), where k = min(n,p).

  Each H(i) has the form

     H(i) = I - taub * v * v'

  where taub is a real scalar, and v is a real vector with
  v(p-k+i+1:p) = 0 and v(p-k+i) = 1; v(1:p-k+i-1) is stored on exit in

  B(n-k+i,1:p-k+i-1), and taub in TAUB(i).
  To form Z explicitly, use LAPACK subroutine DORGRQ.
  To use Z to update another matrix, use LAPACK subroutine DORMRQ.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param m
	 * @param p
	 * @param a
	 * @param lda
	 * @param taua
	 * @param b
	 * @param ldb
	 * @param taub
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dggqrf(int n, int m, int p, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGRQF computes a generalized RQ factorization of an M-by-N matrix A

  and a P-by-N matrix B:

              A = R*Q,        B = Z*T*Q,

  where Q is an N-by-N orthogonal matrix, Z is a P-by-P orthogonal
  matrix, and R and T assume one of the forms:

  if M <= N,  R = ( 0  R12 ) M,   or if M > N,  R = ( R11 ) M-N,
                   N-M  M                           ( R21 ) N
                                                       N

  where R12 or R21 is upper triangular, and

  if P >= N,  T = ( T11 ) N  ,   or if P < N,  T = ( T11  T12 ) P,
                  (  0  ) P-N                         P   N-P
                     N

  where T11 is upper triangular.

  In particular, if B is square and nonsingular, the GRQ factorization

  of A and B implicitly gives the RQ factorization of A*inv(B):

               A*inv(B) = (R*inv(T))*Z'

  where inv(B) denotes the inverse of the matrix B, and Z' denotes the

  transpose of the matrix Z.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  P       (input) INTEGER
          The number of rows of the matrix B.  P >= 0.

  N       (input) INTEGER
          The number of columns of the matrices A and B. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, if M <= N, the upper triangle of the subarray
          A(1:M,N-M+1:N) contains the M-by-M upper triangular matrix R;
          if M > N, the elements on and above the (M-N)-th subdiagonal

          contain the M-by-N upper trapezoidal matrix R; the remaining

          elements, with the array TAUA, represent the orthogonal
          matrix Q as a product of elementary reflectors (see Further
          Details).

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  TAUA    (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Q (see Further Details).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
          On entry, the P-by-N matrix B.
          On exit, the elements on and above the diagonal of the array

          contain the min(P,N)-by-N upper trapezoidal matrix T (T is
          upper triangular if P >= N); the elements below the diagonal,
          with the array TAUB, represent the orthogonal matrix Z as a
          product of elementary reflectors (see Further Details).

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,P).

  TAUB    (output) DOUBLE PRECISION array, dimension (min(P,N))
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Z (see Further Details).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,N,M,P).
          For optimum performance LWORK >= max(N,M,P)*max(NB1,NB2,NB3),
          where NB1 is the optimal blocksize for the RQ factorization
          of an M-by-N matrix, NB2 is the optimal blocksize for the
          QR factorization of a P-by-N matrix, and NB3 is the optimal
          blocksize for a call of DORMRQ.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INF0= -i, the i-th argument had an illegal value.

  Further Details
  ===============

  The matrix Q is represented as a product of elementary reflectors

     Q = H(1) H(2) . . . H(k), where k = min(m,n).

  Each H(i) has the form

     H(i) = I - taua * v * v'

  where taua is a real scalar, and v is a real vector with
  v(n-k+i+1:n) = 0 and v(n-k+i) = 1; v(1:n-k+i-1) is stored on exit in

  A(m-k+i,1:n-k+i-1), and taua in TAUA(i).
  To form Q explicitly, use LAPACK subroutine DORGRQ.
  To use Q to update another matrix, use LAPACK subroutine DORMRQ.

  The matrix Z is represented as a product of elementary reflectors

     Z = H(1) H(2) . . . H(k), where k = min(p,n).

  Each H(i) has the form

     H(i) = I - taub * v * v'

  where taub is a real scalar, and v is a real vector with
  v(1:i-1) = 0 and v(i) = 1; v(i+1:p) is stored on exit in B(i+1:p,i),

  and taub in TAUB(i).
  To form Z explicitly, use LAPACK subroutine DORGQR.
  To use Z to update another matrix, use LAPACK subroutine DORMQR.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param m
	 * @param p
	 * @param n
	 * @param a
	 * @param lda
	 * @param taua
	 * @param b
	 * @param ldb
	 * @param taub
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dggrqf(int m, int p, int n, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGSVD computes the generalized singular value decomposition (GSVD)
  of an M-by-N real matrix A and P-by-N real matrix B:

      U'*A*Q = D1*( 0 R ),    V'*B*Q = D2*( 0 R )

  where U, V and Q are orthogonal matrices, and Z' is the transpose
  of Z.  Let K+L = the effective numerical rank of the matrix (A',B')',
  then R is a K+L-by-K+L nonsingular upper triangular matrix, D1 and
  D2 are M-by-(K+L) and P-by-(K+L) "diagonal" matrices and of the
  following structures, respectively:

  If M-K-L >= 0,

                      K  L
         D1 =     K ( I  0 )
                  L ( 0  C )
              M-K-L ( 0  0 )

                    K  L
         D2 =   L ( 0  S )
              P-L ( 0  0 )

                  N-K-L  K    L
    ( 0 R ) = K (  0   R11  R12 )
              L (  0    0   R22 )

  where

    C = diag( ALPHA(K+1), ... , ALPHA(K+L) ),
    S = diag( BETA(K+1),  ... , BETA(K+L) ),
    C**2 + S**2 = I.

    R is stored in A(1:K+L,N-K-L+1:N) on exit.

  If M-K-L < 0,

                    K M-K K+L-M
         D1 =   K ( I  0    0   )
              M-K ( 0  C    0   )

                      K M-K K+L-M
         D2 =   M-K ( 0  S    0  )
              K+L-M ( 0  0    I  )
                P-L ( 0  0    0  )

                     N-K-L  K   M-K  K+L-M
    ( 0 R ) =     K ( 0    R11  R12  R13  )
                M-K ( 0     0   R22  R23  )
              K+L-M ( 0     0    0   R33  )

  where

    C = diag( ALPHA(K+1), ... , ALPHA(M) ),
    S = diag( BETA(K+1),  ... , BETA(M) ),
    C**2 + S**2 = I.

    (R11 R12 R13 ) is stored in A(1:M, N-K-L+1:N), and R33 is stored
    ( 0  R22 R23 )
    in B(M-K+1:L,N+M-K-L+1:N) on exit.

  The routine computes C, S, R, and optionally the orthogonal
  transformation matrices U, V and Q.

  In particular, if B is an N-by-N nonsingular matrix, then the GSVD of
  A and B implicitly gives the SVD of A*inv(B):
                       A*inv(B) = U*(D1*inv(D2))*V'.
  If ( A',B')' has orthonormal columns, then the GSVD of A and B is
  also equal to the CS decomposition of A and B. Furthermore, the GSVD

  can be used to derive the solution of the eigenvalue problem:
                       A'*A x = lambda* B'*B x.
  In some literature, the GSVD of A and B is presented in the form
                   U'*A*X = ( 0 D1 ),   V'*B*X = ( 0 D2 )
  where U and V are orthogonal and X is nonsingular, D1 and D2 are
  ``diagonal''.  The former GSVD form can be converted to the latter
  form by taking the nonsingular matrix X as

                       X = Q*( I   0    )
                             ( 0 inv(R) ).

  Arguments
  =========

  JOBU    (input) CHARACTER*1
          = 'U':  Orthogonal matrix U is computed;
          = 'N':  U is not computed.

  JOBV    (input) CHARACTER*1
          = 'V':  Orthogonal matrix V is computed;
          = 'N':  V is not computed.

  JOBQ    (input) CHARACTER*1
          = 'Q':  Orthogonal matrix Q is computed;
          = 'N':  Q is not computed.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrices A and B.  N >= 0.

  P       (input) INTEGER
          The number of rows of the matrix B.  P >= 0.

  K       (output) INTEGER
  L       (output) INTEGER
          On exit, K and L specify the dimension of the subblocks
          described in the Purpose section.
          K + L = effective numerical rank of (A',B')'.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, A contains the triangular matrix R, or part of R.
          See Purpose for details.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
          On entry, the P-by-N matrix B.
          On exit, B contains the triangular matrix R if M-K-L < 0.
          See Purpose for details.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,P).

  ALPHA   (output) DOUBLE PRECISION array, dimension (N)
  BETA    (output) DOUBLE PRECISION array, dimension (N)
          On exit, ALPHA and BETA contain the generalized singular
          value pairs of A and B;
            ALPHA(1:K) = 1,
            BETA(1:K)  = 0,
          and if M-K-L >= 0,
            ALPHA(K+1:K+L) = C,
            BETA(K+1:K+L)  = S,
          or if M-K-L < 0,
            ALPHA(K+1:M)=C, ALPHA(M+1:K+L)=0
            BETA(K+1:M) =S, BETA(M+1:K+L) =1
          and
            ALPHA(K+L+1:N) = 0
            BETA(K+L+1:N)  = 0

  U       (output) DOUBLE PRECISION array, dimension (LDU,M)
          If JOBU = 'U', U contains the M-by-M orthogonal matrix U.
          If JOBU = 'N', U is not referenced.

  LDU     (input) INTEGER
          The leading dimension of the array U. LDU >= max(1,M) if
          JOBU = 'U'; LDU >= 1 otherwise.

  V       (output) DOUBLE PRECISION array, dimension (LDV,P)
          If JOBV = 'V', V contains the P-by-P orthogonal matrix V.
          If JOBV = 'N', V is not referenced.

  LDV     (input) INTEGER
          The leading dimension of the array V. LDV >= max(1,P) if
          JOBV = 'V'; LDV >= 1 otherwise.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
          If JOBQ = 'Q', Q contains the N-by-N orthogonal matrix Q.
          If JOBQ = 'N', Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q. LDQ >= max(1,N) if
          JOBQ = 'Q'; LDQ >= 1 otherwise.

  WORK    (workspace) DOUBLE PRECISION array,
                      dimension (max(3*N,M,P)+N)

  IWORK   (workspace/output) INTEGER array, dimension (N)
          On exit, IWORK stores the sorting information. More
          precisely, the following loop will sort ALPHA
             for I = K+1, min(M,K+L)
                 swap ALPHA(I) and ALPHA(IWORK(I))
             endfor
          such that ALPHA(1) >= ALPHA(2) >= ... >= ALPHA(N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, the Jacobi-type procedure failed to
                converge.  For further details, see subroutine DTGSJA.


  Internal Parameters
  ===================

  TOLA    DOUBLE PRECISION
  TOLB    DOUBLE PRECISION
          TOLA and TOLB are the thresholds to determine the effective
          rank of (A',B')'. Generally, they are set to
                   TOLA = MAX(M,N)*norm(A)*MAZHEPS,
                   TOLB = MAX(P,N)*norm(B)*MAZHEPS.
          The size of TOLA and TOLB may affect the size of backward
          errors of the decomposition.

  Further Details
  ===============

  2-96 Based on modifications by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param jobu
	 * @param jobv
	 * @param jobq
	 * @param m
	 * @param n
	 * @param p
	 * @param k
	 * @param l
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param alpha
	 * @param beta
	 * @param u
	 * @param ldu
	 * @param v
	 * @param ldv
	 * @param q
	 * @param ldq
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dggsvd(String jobu, String jobv, String jobq, int m, int n, int p, intW k, intW l, double[] a, int lda, double[] b, int ldb, double[] alpha, double[] beta, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGGSVP computes orthogonal matrices U, V and Q such that

                   N-K-L  K    L
   U'*A*Q =     K ( 0    A12  A13 )  if M-K-L >= 0;
                L ( 0     0   A23 )
            M-K-L ( 0     0    0  )

                   N-K-L  K    L
          =     K ( 0    A12  A13 )  if M-K-L < 0;
              M-K ( 0     0   A23 )

                 N-K-L  K    L
   V'*B*Q =   L ( 0     0   B13 )
            P-L ( 0     0    0  )

  where the K-by-K matrix A12 and L-by-L matrix B13 are nonsingular
  upper triangular; A23 is L-by-L upper triangular if M-K-L >= 0,
  otherwise A23 is (M-K)-by-L upper trapezoidal.  K+L = the effective
  numerical rank of the (M+P)-by-N matrix (A',B')'.  Z' denotes the
  transpose of Z.

  This decomposition is the preprocessing step for computing the
  Generalized Singular Value Decomposition (GSVD), see subroutine
  DGGSVD.

  Arguments
  =========

  JOBU    (input) CHARACTER*1
          = 'U':  Orthogonal matrix U is computed;
          = 'N':  U is not computed.

  JOBV    (input) CHARACTER*1
          = 'V':  Orthogonal matrix V is computed;
          = 'N':  V is not computed.

  JOBQ    (input) CHARACTER*1
          = 'Q':  Orthogonal matrix Q is computed;
          = 'N':  Q is not computed.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  P       (input) INTEGER
          The number of rows of the matrix B.  P >= 0.

  N       (input) INTEGER
          The number of columns of the matrices A and B.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, A contains the triangular (or trapezoidal) matrix
          described in the Purpose section.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,N)
          On entry, the P-by-N matrix B.
          On exit, B contains the triangular matrix described in
          the Purpose section.

  LDB     (input) INTEGER
          The leading dimension of the array B. LDB >= max(1,P).

  TOLA    (input) DOUBLE PRECISION
  TOLB    (input) DOUBLE PRECISION
          TOLA and TOLB are the thresholds to determine the effective
          numerical rank of matrix B and a subblock of A. Generally,
          they are set to
             TOLA = MAX(M,N)*norm(A)*MAZHEPS,
             TOLB = MAX(P,N)*norm(B)*MAZHEPS.
          The size of TOLA and TOLB may affect the size of backward
          errors of the decomposition.

  K       (output) INTEGER
  L       (output) INTEGER
          On exit, K and L specify the dimension of the subblocks
          described in Purpose.
          K + L = effective numerical rank of (A',B')'.

  U       (output) DOUBLE PRECISION array, dimension (LDU,M)
          If JOBU = 'U', U contains the orthogonal matrix U.
          If JOBU = 'N', U is not referenced.

  LDU     (input) INTEGER
          The leading dimension of the array U. LDU >= max(1,M) if
          JOBU = 'U'; LDU >= 1 otherwise.

  V       (output) DOUBLE PRECISION array, dimension (LDV,M)
          If JOBV = 'V', V contains the orthogonal matrix V.
          If JOBV = 'N', V is not referenced.

  LDV     (input) INTEGER
          The leading dimension of the array V. LDV >= max(1,P) if
          JOBV = 'V'; LDV >= 1 otherwise.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
          If JOBQ = 'Q', Q contains the orthogonal matrix Q.
          If JOBQ = 'N', Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q. LDQ >= max(1,N) if
          JOBQ = 'Q'; LDQ >= 1 otherwise.

  IWORK   (workspace) INTEGER array, dimension (N)

  TAU     (workspace) DOUBLE PRECISION array, dimension (N)

  WORK    (workspace) DOUBLE PRECISION array, dimension (max(3*N,M,P))


  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.


  Further Details
  ===============

  The subroutine uses LAPACK subroutine DGEQPF for the QR factorization
  with column pivoting to detect the effective numerical rank of the
  a matrix. It may be replaced by a better rank determination strategy.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobu
	 * @param jobv
	 * @param jobq
	 * @param m
	 * @param p
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param tola
	 * @param tolb
	 * @param k
	 * @param l
	 * @param u
	 * @param ldu
	 * @param v
	 * @param ldv
	 * @param q
	 * @param ldq
	 * @param iwork
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dggsvp(String jobu, String jobv, String jobq, int m, int p, int n, double[] a, int lda, double[] b, int ldb, double tola, double tolb, intW k, intW l, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, int[] iwork, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTCON estimates the reciprocal of the condition number of a real
  tridiagonal matrix A using the LU factorization as computed by
  DGTTRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies whether the 1-norm condition number or the
          infinity-norm condition number is required:
          = '1' or 'O':  1-norm;
          = 'I':         Infinity-norm.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) multipliers that define the matrix L from the
          LU factorization of A as computed by DGTTRF.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the upper triangular matrix U from
          the LU factorization of A.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) elements of the first superdiagonal of U.

  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
          The (n-2) elements of the second superdiagonal of U.

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= n, row i of the matrix was
          interchanged with row IPIV(i).  IPIV(i) will always be either
          i or i+1; IPIV(i) = i indicates a row interchange was not
          required.

  ANORM   (input) DOUBLE PRECISION
          If NORM = '1' or 'O', the 1-norm of the original matrix A.
          If NORM = 'I', the infinity-norm of the original matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
          estimate of the 1-norm of inv(A) computed in this routine.

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param dl
	 * @param d
	 * @param du
	 * @param du2
	 * @param ipiv
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgtcon(String norm, int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTRFS improves the computed solution to a system of linear
  equations when the coefficient matrix is tridiagonal, and provides
  error bounds and backward error estimates for the solution.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations:
          = 'N':  A * X = B     (No transpose)
          = 'T':  A**T * X = B  (Transpose)
          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of A.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The diagonal elements of A.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) superdiagonal elements of A.

  DLF     (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) multipliers that define the matrix L from the
          LU factorization of A as computed by DGTTRF.

  DF      (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the upper triangular matrix U from
          the LU factorization of A.

  DUF     (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) elements of the first superdiagonal of U.

  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
          The (n-2) elements of the second superdiagonal of U.

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= n, row i of the matrix was
          interchanged with row IPIV(i).  IPIV(i) will always be either
          i or i+1; IPIV(i) = i indicates a row interchange was not
          required.

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DGTTRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param dl
	 * @param d
	 * @param du
	 * @param dlf
	 * @param df
	 * @param duf
	 * @param du2
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgtrfs(String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTSV  solves the equation

     A*X = B,

  where A is an n by n tridiagonal matrix, by Gaussian elimination with
  partial pivoting.

  Note that the equation  A'*X = B  may be solved by interchanging the

  order of the arguments DU and DL.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  DL      (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, DL must contain the (n-1) sub-diagonal elements of

          A.

          On exit, DL is overwritten by the (n-2) elements of the
          second super-diagonal of the upper triangular matrix U from
          the LU factorization of A, in DL(1), ..., DL(n-2).

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, D must contain the diagonal elements of A.

          On exit, D is overwritten by the n diagonal elements of U.

  DU      (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, DU must contain the (n-1) super-diagonal elements
          of A.

          On exit, DU is overwritten by the (n-1) elements of the first
          super-diagonal of U.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N by NRHS matrix of right hand side matrix B.
          On exit, if INFO = 0, the N by NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value
          > 0: if INFO = i, U(i,i) is exactly zero, and the solution
               has not been computed.  The factorization has not been
               completed unless i = N.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param dl
	 * @param d
	 * @param du
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dgtsv(int n, int nrhs, double[] dl, double[] d, double[] du, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTSVX uses the LU factorization to compute the solution to a real
  system of linear equations A * X = B or A**T * X = B,
  where A is a tridiagonal matrix of order N and X and B are N-by-NRHS

  matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed:

  1. If FACT = 'N', the LU decomposition is used to factor the matrix A
     as A = L * U, where L is a product of permutation and unit lower
     bidiagonal matrices and U is upper triangular with nonzeros in
     only the main diagonal and first two superdiagonals.

  2. If some U(i,i)=0, so that U is exactly singular, then the routine

     returns with INFO = i. Otherwise, the factored form of A is used
     to estimate the condition number of the matrix A.  If the
     reciprocal of the condition number is less than machine precision,
     INFO = N+1 is returned as a warning, but the routine still goes on
     to solve for X and compute error bounds as described below.

  3. The system of equations is solved for X using the factored form
     of A.

  4. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of A has been
          supplied on entry.
          = 'F':  DLF, DF, DUF, DU2, and IPIV contain the factored
                  form of A; DL, D, DU, DLF, DF, DUF, DU2 and IPIV
                  will not be modified.
          = 'N':  The matrix will be copied to DLF, DF, and DUF
                  and factored.

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations:
          = 'N':  A * X = B     (No transpose)
          = 'T':  A**T * X = B  (Transpose)
          = 'C':  A**H * X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of A.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of A.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) superdiagonal elements of A.

  DLF     (input or output) DOUBLE PRECISION array, dimension (N-1)
          If FACT = 'F', then DLF is an input argument and on entry
          contains the (n-1) multipliers that define the matrix L from

          the LU factorization of A as computed by DGTTRF.

          If FACT = 'N', then DLF is an output argument and on exit
          contains the (n-1) multipliers that define the matrix L from

          the LU factorization of A.

  DF      (input or output) DOUBLE PRECISION array, dimension (N)
          If FACT = 'F', then DF is an input argument and on entry
          contains the n diagonal elements of the upper triangular
          matrix U from the LU factorization of A.

          If FACT = 'N', then DF is an output argument and on exit
          contains the n diagonal elements of the upper triangular
          matrix U from the LU factorization of A.

  DUF     (input or output) DOUBLE PRECISION array, dimension (N-1)
          If FACT = 'F', then DUF is an input argument and on entry
          contains the (n-1) elements of the first superdiagonal of U.


          If FACT = 'N', then DUF is an output argument and on exit
          contains the (n-1) elements of the first superdiagonal of U.


  DU2     (input or output) DOUBLE PRECISION array, dimension (N-2)
          If FACT = 'F', then DU2 is an input argument and on entry
          contains the (n-2) elements of the second superdiagonal of
          U.

          If FACT = 'N', then DU2 is an output argument and on exit
          contains the (n-2) elements of the second superdiagonal of
          U.

  IPIV    (input or output) INTEGER array, dimension (N)
          If FACT = 'F', then IPIV is an input argument and on entry
          contains the pivot indices from the LU factorization of A as

          computed by DGTTRF.

          If FACT = 'N', then IPIV is an output argument and on exit
          contains the pivot indices from the LU factorization of A;
          row i of the matrix was interchanged with row IPIV(i).
          IPIV(i) will always be either i or i+1; IPIV(i) = i indicates
          a row interchange was not required.

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The N-by-NRHS right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The estimate of the reciprocal condition number of the matrix
          A.  If RCOND is less than the machine precision (in
          particular, if RCOND = 0), the matrix is singular to working

          precision.  This condition is indicated by a return code of
          INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= N:  U(i,i) is exactly zero.  The factorization
                       has not been completed unless i = N, but the
                       factor U is exactly singular, so the solution
                       and error bounds could not be computed.
                       RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param dl
	 * @param d
	 * @param du
	 * @param dlf
	 * @param df
	 * @param duf
	 * @param du2
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dgtsvx(String fact, String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTTRF computes an LU factorization of a real tridiagonal matrix A
  using elimination with partial pivoting and row interchanges.

  The factorization has the form
     A = L * U
  where L is a product of permutation and unit lower bidiagonal
  matrices and U is upper triangular with nonzeros in only the main
  diagonal and first two superdiagonals.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.

  DL      (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, DL must contain the (n-1) sub-diagonal elements of

          A.

          On exit, DL is overwritten by the (n-1) multipliers that
          define the matrix L from the LU factorization of A.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, D must contain the diagonal elements of A.

          On exit, D is overwritten by the n diagonal elements of the
          upper triangular matrix U from the LU factorization of A.

  DU      (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, DU must contain the (n-1) super-diagonal elements
          of A.

          On exit, DU is overwritten by the (n-1) elements of the first
          super-diagonal of U.

  DU2     (output) DOUBLE PRECISION array, dimension (N-2)
          On exit, DU2 is overwritten by the (n-2) elements of the
          second super-diagonal of U.

  IPIV    (output) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= n, row i of the matrix was
          interchanged with row IPIV(i).  IPIV(i) will always be either
          i or i+1; IPIV(i) = i indicates a row interchange was not
          required.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -k, the k-th argument had an illegal value
          > 0:  if INFO = k, U(k,k) is exactly zero. The factorization

                has been completed, but the factor U is exactly
                singular, and division by zero will occur if it is used
                to solve a system of equations.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param dl
	 * @param d
	 * @param du
	 * @param du2
	 * @param ipiv
	 * @param info
	 */
	public abstract void dgttrf(int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTTRS solves one of the systems of equations
     A*X = B  or  A'*X = B,
  with a tridiagonal matrix A using the LU factorization computed
  by DGTTRF.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the form of the system of equations.
          = 'N':  A * X = B  (No transpose)
          = 'T':  A'* X = B  (Transpose)
          = 'C':  A'* X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) multipliers that define the matrix L from the
          LU factorization of A.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the upper triangular matrix U from
          the LU factorization of A.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) elements of the first super-diagonal of U.

  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
          The (n-2) elements of the second super-diagonal of U.

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= n, row i of the matrix was
          interchanged with row IPIV(i).  IPIV(i) will always be either
          i or i+1; IPIV(i) = i indicates a row interchange was not
          required.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the matrix of right hand side vectors B.
          On exit, B is overwritten by the solution vectors X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param dl
	 * @param d
	 * @param du
	 * @param du2
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dgttrs(String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DGTTS2 solves one of the systems of equations
     A*X = B  or  A'*X = B,
  with a tridiagonal matrix A using the LU factorization computed
  by DGTTRF.

  Arguments
  =========

  ITRANS  (input) INTEGER
          Specifies the form of the system of equations.
          = 0:  A * X = B  (No transpose)
          = 1:  A'* X = B  (Transpose)
          = 2:  A'* X = B  (Conjugate transpose = Transpose)

  N       (input) INTEGER
          The order of the matrix A.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) multipliers that define the matrix L from the
          LU factorization of A.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the upper triangular matrix U from
          the LU factorization of A.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) elements of the first super-diagonal of U.

  DU2     (input) DOUBLE PRECISION array, dimension (N-2)
          The (n-2) elements of the second super-diagonal of U.

  IPIV    (input) INTEGER array, dimension (N)
          The pivot indices; for 1 <= i <= n, row i of the matrix was
          interchanged with row IPIV(i).  IPIV(i) will always be either
          i or i+1; IPIV(i) = i indicates a row interchange was not
          required.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the matrix of right hand side vectors B.
          On exit, B is overwritten by the solution vectors X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param itrans
	 * @param n
	 * @param nrhs
	 * @param dl
	 * @param d
	 * @param du
	 * @param du2
	 * @param ipiv
	 * @param b
	 * @param ldb
	 */
	public abstract void dgtts2(int itrans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb);

	/**
<pre>

     ..

  Purpose
  =======

  DHGEQZ computes the eigenvalues of a real matrix pair (H,T),
  where H is an upper Hessenberg matrix and T is upper triangular,
  using the double-shift QZ method.
  Matrix pairs of this type are produced by the reduction to
  generalized upper Hessenberg form of a real matrix pair (A,B):

     A = Q1*H*Z1**T,  B = Q1*T*Z1**T,

  as computed by DGGHRD.

  If JOB='S', then the Hessenberg-triangular pair (H,T) is
  also reduced to generalized Schur form,
  
     H = Q*S*Z**T,  T = Q*P*Z**T,
  
  where Q and Z are orthogonal matrices, P is an upper triangular
  matrix, and S is a quasi-triangular matrix with 1-by-1 and 2-by-2
  diagonal blocks.

  The 1-by-1 blocks correspond to real eigenvalues of the matrix pair
  (H,T) and the 2-by-2 blocks correspond to complex conjugate pairs of

  eigenvalues.

  Additionally, the 2-by-2 upper triangular diagonal blocks of P
  corresponding to 2-by-2 blocks of S are reduced to positive diagonal

  form, i.e., if S(j+1,j) is non-zero, then P(j+1,j) = P(j,j+1) = 0,
  P(j,j) > 0, and P(j+1,j+1) > 0.

  Optionally, the orthogonal matrix Q from the generalized Schur
  factorization may be postmultiplied into an input matrix Q1, and the

  orthogonal matrix Z may be postmultiplied into an input matrix Z1.
  If Q1 and Z1 are the orthogonal matrices from DGGHRD that reduced
  the matrix pair (A,B) to generalized upper Hessenberg form, then the

  output matrices Q1*Q and Z1*Z are the orthogonal factors from the
  generalized Schur factorization of (A,B):

     A = (Q1*Q)*S*(Z1*Z)**T,  B = (Q1*Q)*P*(Z1*Z)**T.
  
  To avoid overflow, eigenvalues of the matrix pair (H,T) (equivalently
  of (A,B)) are computed as a pair of values (alpha,beta), where alpha 
  complex and beta real.
  If beta is nonzero, lambda = alpha / beta is an eigenvalue of the
  generalized nonsymmetric eigenvalue problem (GNEP)
     A*x = lambda*B*x
  and if alpha is nonzero, mu = beta / alpha is an eigenvalue of the
  alternate form of the GNEP
     mu*A*y = B*y.
  Real eigenvalues can be read directly from the generalized Schur
  form: 
    alpha = S(i,i), beta = P(i,i).

  Ref: C.B. Moler & G.W. Stewart, "An Algorithm for Generalized Matrix

       Eigenvalue Problems", SIAM J. Numer. Anal., 10(1973),
       pp. 241--256.

  Arguments
  =========

  JOB     (input) CHARACTER*1
          = 'E': Compute eigenvalues only;
          = 'S': Compute eigenvalues and the Schur form. 

  COMPQ   (input) CHARACTER*1
          = 'N': Left Schur vectors (Q) are not computed;
          = 'I': Q is initialized to the unit matrix and the matrix Q
                 of left Schur vectors of (H,T) is returned;
          = 'V': Q must contain an orthogonal matrix Q1 on entry and
                 the product Q1*Q is returned.

  COMPZ   (input) CHARACTER*1
          = 'N': Right Schur vectors (Z) are not computed;
          = 'I': Z is initialized to the unit matrix and the matrix Z
                 of right Schur vectors of (H,T) is returned;
          = 'V': Z must contain an orthogonal matrix Z1 on entry and
                 the product Z1*Z is returned.

  N       (input) INTEGER
          The order of the matrices H, T, Q, and Z.  N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          ILO and IHI mark the rows and columns of H which are in
          Hessenberg form.  It is assumed that A is already upper
          triangular in rows and columns 1:ILO-1 and IHI+1:N.
          If N > 0, 1 <= ILO <= IHI <= N; if N = 0, ILO=1 and IHI=0.

  H       (input/output) DOUBLE PRECISION array, dimension (LDH, N)
          On entry, the N-by-N upper Hessenberg matrix H.
          On exit, if JOB = 'S', H contains the upper quasi-triangular

          matrix S from the generalized Schur factorization;
          2-by-2 diagonal blocks (corresponding to complex conjugate
          pairs of eigenvalues) are returned in standard form, with
          H(i,i) = H(i+1,i+1) and H(i+1,i)*H(i,i+1) < 0.
          If JOB = 'E', the diagonal blocks of H match those of S, but

          the rest of H is unspecified.

  LDH     (input) INTEGER
          The leading dimension of the array H.  LDH >= max( 1, N ).

  T       (input/output) DOUBLE PRECISION array, dimension (LDT, N)
          On entry, the N-by-N upper triangular matrix T.
          On exit, if JOB = 'S', T contains the upper triangular
          matrix P from the generalized Schur factorization;
          2-by-2 diagonal blocks of P corresponding to 2-by-2 blocks of
          are reduced to positive diagonal form, i.e., if H(j+1,j) is
          non-zero, then T(j+1,j) = T(j,j+1) = 0, T(j,j) > 0, and
          T(j+1,j+1) > 0.
          If JOB = 'E', the diagonal blocks of T match those of P, but

          the rest of T is unspecified.

  LDT     (input) INTEGER
          The leading dimension of the array T.  LDT >= max( 1, N ).

  ALPHAR  (output) DOUBLE PRECISION array, dimension (N)
          The real parts of each scalar alpha defining an eigenvalue
          of GNEP.

  ALPHAI  (output) DOUBLE PRECISION array, dimension (N)
          The imaginary parts of each scalar alpha defining an
          eigenvalue of GNEP.
          If ALPHAI(j) is zero, then the j-th eigenvalue is real; if
          positive, then the j-th and (j+1)-st eigenvalues are a
          complex conjugate pair, with ALPHAI(j+1) = -ALPHAI(j).

  BETA    (output) DOUBLE PRECISION array, dimension (N)
          The scalars beta that define the eigenvalues of GNEP.
          Together, the quantities alpha = (ALPHAR(j),ALPHAI(j)) and
          beta = BETA(j) represent the j-th eigenvalue of the matrix
          pair (A,B), in one of the forms lambda = alpha/beta or
          mu = beta/alpha.  Since either lambda or mu may overflow,
          they should not, in general, be computed.

  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
          On entry, if COMPZ = 'V', the orthogonal matrix Q1 used in
          the reduction of (A,B) to generalized Hessenberg form.
          On exit, if COMPZ = 'I', the orthogonal matrix of left Schur

          vectors of (H,T), and if COMPZ = 'V', the orthogonal matrix
          of left Schur vectors of (A,B).
          Not referenced if COMPZ = 'N'.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.  LDQ >= 1.
          If COMPQ='V' or 'I', then LDQ >= N.

  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
          On entry, if COMPZ = 'V', the orthogonal matrix Z1 used in
          the reduction of (A,B) to generalized Hessenberg form.
          On exit, if COMPZ = 'I', the orthogonal matrix of
          right Schur vectors of (H,T), and if COMPZ = 'V', the
          orthogonal matrix of right Schur vectors of (A,B).
          Not referenced if COMPZ = 'N'.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1.
          If COMPZ='V' or 'I', then LDZ >= N.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO >= 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.  LWORK >= max(1,N).

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value
          = 1,...,N: the QZ iteration did not converge.  (H,T) is not
                     in Schur form, but ALPHAR(i), ALPHAI(i), and
                     BETA(i), i=INFO+1,...,N should be correct.
          = N+1,...,2*N: the shift calculation failed.  (H,T) is not
                     in Schur form, but ALPHAR(i), ALPHAI(i), and
                     BETA(i), i=INFO-N+1,...,N should be correct.

  Further Details
  ===============

  Iteration counters:

  JITER  -- counts iterations.
  IITER  -- counts iterations run since ILAST was last
            changed.  This is therefore reset only when a 1-by-1 or
            2-by-2 block deflates off the bottom.

  =====================================================================

     .. Parameters ..
    $                     SAFETY = 1.0E+0 )
</pre>
	 * @param job
	 * @param compq
	 * @param compz
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param h
	 * @param ldh
	 * @param t
	 * @param ldt
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param q
	 * @param ldq
	 * @param z
	 * @param ldz
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dhgeqz(String job, String compq, String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] t, int ldt, double[] alphar, double[] alphai, double[] beta, double[] q, int ldq, double[] z, int ldz, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DHSEIN uses inverse iteration to find specified right and/or left
  eigenvectors of a real upper Hessenberg matrix H.

  The right eigenvector x and the left eigenvector y of the matrix H
  corresponding to an eigenvalue w are defined by:

               H * x = w * x,     y**h * H = w * y**h

  where y**h denotes the conjugate transpose of the vector y.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'R': compute right eigenvectors only;
          = 'L': compute left eigenvectors only;
          = 'B': compute both right and left eigenvectors.

  EIGSRC  (input) CHARACTER*1
          Specifies the source of eigenvalues supplied in (WR,WI):
          = 'Q': the eigenvalues were found using DHSEQR; thus, if
                 H has zero subdiagonal elements, and so is
                 block-triangular, then the j-th eigenvalue can be
                 assumed to be an eigenvalue of the block containing
                 the j-th row/column.  This property allows DHSEIN to
                 perform inverse iteration on just one diagonal block.

          = 'N': no assumptions are made on the correspondence
                 between eigenvalues and diagonal blocks.  In this
                 case, DHSEIN must always perform inverse iteration
                 using the whole matrix H.

  INITV   (input) CHARACTER*1
          = 'N': no initial vectors are supplied;
          = 'U': user-supplied initial vectors are stored in the arrays
                 VL and/or VR.

  SELECT  (input/output) LOGICAL array, dimension (N)
          Specifies the eigenvectors to be computed. To select the
          real eigenvector corresponding to a real eigenvalue WR(j),
          SELECT(j) must be set to .TRUE.. To select the complex
          eigenvector corresponding to a complex eigenvalue
          (WR(j),WI(j)), with complex conjugate (WR(j+1),WI(j+1)),
          either SELECT(j) or SELECT(j+1) or both must be set to
          .TRUE.; then on exit SELECT(j) is .TRUE. and SELECT(j+1) is
          .FALSE..

  N       (input) INTEGER
          The order of the matrix H.  N >= 0.

  H       (input) DOUBLE PRECISION array, dimension (LDH,N)
          The upper Hessenberg matrix H.

  LDH     (input) INTEGER
          The leading dimension of the array H.  LDH >= max(1,N).

  WR      (input/output) DOUBLE PRECISION array, dimension (N)
  WI      (input) DOUBLE PRECISION array, dimension (N)
          On entry, the real and imaginary parts of the eigenvalues of

          H; a complex conjugate pair of eigenvalues must be stored in

          consecutive elements of WR and WI.
          On exit, WR may have been altered since close eigenvalues
          are perturbed slightly in searching for independent
          eigenvectors.

  VL      (input/output) DOUBLE PRECISION array, dimension (LDVL,MM)
          On entry, if INITV = 'U' and SIDE = 'L' or 'B', VL must
          contain starting vectors for the inverse iteration for the
          left eigenvectors; the starting vector for each eigenvector
          must be in the same column(s) in which the eigenvector will
          be stored.
          On exit, if SIDE = 'L' or 'B', the left eigenvectors
          specified by SELECT will be stored consecutively in the
          columns of VL, in the same order as their eigenvalues. A
          complex eigenvector corresponding to a complex eigenvalue is

          stored in two consecutive columns, the first holding the real
          part and the second the imaginary part.
          If SIDE = 'R', VL is not referenced.

  LDVL    (input) INTEGER
          The leading dimension of the array VL.
          LDVL >= max(1,N) if SIDE = 'L' or 'B'; LDVL >= 1 otherwise.

  VR      (input/output) DOUBLE PRECISION array, dimension (LDVR,MM)
          On entry, if INITV = 'U' and SIDE = 'R' or 'B', VR must
          contain starting vectors for the inverse iteration for the
          right eigenvectors; the starting vector for each eigenvector

          must be in the same column(s) in which the eigenvector will
          be stored.
          On exit, if SIDE = 'R' or 'B', the right eigenvectors
          specified by SELECT will be stored consecutively in the
          columns of VR, in the same order as their eigenvalues. A
          complex eigenvector corresponding to a complex eigenvalue is

          stored in two consecutive columns, the first holding the real
          part and the second the imaginary part.
          If SIDE = 'L', VR is not referenced.

  LDVR    (input) INTEGER
          The leading dimension of the array VR.
          LDVR >= max(1,N) if SIDE = 'R' or 'B'; LDVR >= 1 otherwise.

  MM      (input) INTEGER
          The number of columns in the arrays VL and/or VR. MM >= M.

  M       (output) INTEGER
          The number of columns in the arrays VL and/or VR required to

          store the eigenvectors; each selected real eigenvector
          occupies one column and each selected complex eigenvector
          occupies two columns.

  WORK    (workspace) DOUBLE PRECISION array, dimension ((N+2)*N)

  IFAILL  (output) INTEGER array, dimension (MM)
          If SIDE = 'L' or 'B', IFAILL(i) = j > 0 if the left
          eigenvector in the i-th column of VL (corresponding to the
          eigenvalue w(j)) failed to converge; IFAILL(i) = 0 if the
          eigenvector converged satisfactorily. If the i-th and (i+1)th
          columns of VL hold a complex eigenvector, then IFAILL(i) and

          IFAILL(i+1) are set to the same value.
          If SIDE = 'R', IFAILL is not referenced.

  IFAILR  (output) INTEGER array, dimension (MM)
          If SIDE = 'R' or 'B', IFAILR(i) = j > 0 if the right
          eigenvector in the i-th column of VR (corresponding to the
          eigenvalue w(j)) failed to converge; IFAILR(i) = 0 if the
          eigenvector converged satisfactorily. If the i-th and (i+1)th
          columns of VR hold a complex eigenvector, then IFAILR(i) and

          IFAILR(i+1) are set to the same value.
          If SIDE = 'L', IFAILR is not referenced.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, i is the number of eigenvectors which
                failed to converge; see IFAILL and IFAILR for further
                details.

  Further Details
  ===============

  Each eigenvector is normalized so that the element of largest
  magnitude has magnitude 1; here the magnitude of a complex number
  (x,y) is taken to be |x|+|y|.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param eigsrc
	 * @param initv
	 * @param select
	 * @param n
	 * @param h
	 * @param ldh
	 * @param wr
	 * @param wi
	 * @param vl
	 * @param ldvl
	 * @param vr
	 * @param ldvr
	 * @param mm
	 * @param m
	 * @param work
	 * @param ifaill
	 * @param ifailr
	 * @param info
	 */
	public abstract void dhsein(String side, String eigsrc, String initv, boolean[] select, int n, double[] h, int ldh, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, int[] ifaill, int[] ifailr, intW info);

	/**
<pre>

     ..
     Purpose
     =======

     DHSEQR computes the eigenvalues of a Hessenberg matrix H
     and, optionally, the matrices T and Z from the Schur decomposition
     H = Z T Z**T, where T is an upper quasi-triangular matrix (the
     Schur form), and Z is the orthogonal matrix of Schur vectors.

     Optionally Z may be postmultiplied into an input orthogonal
     matrix Q so that this routine can give the Schur factorization
     of a matrix A which has been reduced to the Hessenberg form H
     by the orthogonal matrix Q:  A = Q*H*Q**T = (QZ)*T*(QZ)**T.

     Arguments
     =========

     JOB   (input) CHARACTER*1
           = 'E':  compute eigenvalues only;
           = 'S':  compute eigenvalues and the Schur form T.

     COMPZ (input) CHARACTER*1
           = 'N':  no Schur vectors are computed;
           = 'I':  Z is initialized to the unit matrix and the matrix Z
                   of Schur vectors of H is returned;
           = 'V':  Z must contain an orthogonal matrix Q on entry, and

                   the product Q*Z is returned.

     N     (input) INTEGER
           The order of the matrix H.  N .GE. 0.

     ILO   (input) INTEGER
     IHI   (input) INTEGER
           It is assumed that H is already upper triangular in rows
           and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
           set by a previous call to DGEBAL, and then passed to DGEHRD

           when the matrix output by DGEBAL is reduced to Hessenberg
           form. Otherwise ILO and IHI should be set to 1 and N
           respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.
           If N = 0, then ILO = 1 and IHI = 0.

     H     (input/output) DOUBLE PRECISION array, dimension (LDH,N)
           On entry, the upper Hessenberg matrix H.
           On exit, if INFO = 0 and JOB = 'S', then H contains the
           upper quasi-triangular matrix T from the Schur decomposition
           (the Schur form); 2-by-2 diagonal blocks (corresponding to
           complex conjugate pairs of eigenvalues) are returned in
           standard form, with H(i,i) = H(i+1,i+1) and
           H(i+1,i)*H(i,i+1).LT.0. If INFO = 0 and JOB = 'E', the
           contents of H are unspecified on exit.  (The output value of
           H when INFO.GT.0 is given under the description of INFO
           below.)

           Unlike earlier versions of DHSEQR, this subroutine may
           explicitly H(i,j) = 0 for i.GT.j and j = 1, 2, ... ILO-1
           or j = IHI+1, IHI+2, ... N.

     LDH   (input) INTEGER
           The leading dimension of the array H. LDH .GE. max(1,N).

     WR    (output) DOUBLE PRECISION array, dimension (N)
     WI    (output) DOUBLE PRECISION array, dimension (N)
           The real and imaginary parts, respectively, of the computed

           eigenvalues. If two eigenvalues are computed as a complex
           conjugate pair, they are stored in consecutive elements of
           WR and WI, say the i-th and (i+1)th, with WI(i) .GT. 0 and
           WI(i+1) .LT. 0. If JOB = 'S', the eigenvalues are stored in

           the same order as on the diagonal of the Schur form returned
           in H, with WR(i) = H(i,i) and, if H(i:i+1,i:i+1) is a 2-by-2
           diagonal block, WI(i) = sqrt(-H(i+1,i)*H(i,i+1)) and
           WI(i+1) = -WI(i).

     Z     (input/output) DOUBLE PRECISION array, dimension (LDZ,N)
           If COMPZ = 'N', Z is not referenced.
           If COMPZ = 'I', on entry Z need not be set and on exit,
           if INFO = 0, Z contains the orthogonal matrix Z of the Schur
           vectors of H.  If COMPZ = 'V', on entry Z must contain an
           N-by-N matrix Q, which is assumed to be equal to the unit
           matrix except for the submatrix Z(ILO:IHI,ILO:IHI). On exit,
           if INFO = 0, Z contains Q*Z.
           Normally Q is the orthogonal matrix generated by DORGHR
           after the call to DGEHRD which formed the Hessenberg matrix

           H. (The output value of Z when INFO.GT.0 is given under
           the description of INFO below.)

     LDZ   (input) INTEGER
           The leading dimension of the array Z.  if COMPZ = 'I' or
           COMPZ = 'V', then LDZ.GE.MAX(1,N).  Otherwize, LDZ.GE.1.

     WORK  (workspace/output) DOUBLE PRECISION array, dimension (LWORK)
           On exit, if INFO = 0, WORK(1) returns an estimate of
           the optimal value for LWORK.

     LWORK (input) INTEGER
           The dimension of the array WORK.  LWORK .GE. max(1,N)
           is sufficient, but LWORK typically as large as 6*N may
           be required for optimal performance.  A workspace query
           to determine the optimal workspace size is recommended.

           If LWORK = -1, then DHSEQR does a workspace query.
           In this case, DHSEQR checks the input parameters and
           estimates the optimal workspace size for the given
           values of N, ILO and IHI.  The estimate is returned
           in WORK(1).  No error message related to LWORK is
           issued by XERBLA.  Neither H nor Z are accessed.


     INFO  (output) INTEGER
             =  0:  successful exit
           .LT. 0:  if INFO = -i, the i-th argument had an illegal
                    value
           .GT. 0:  if INFO = i, DHSEQR failed to compute all of
                the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR
                and WI contain those eigenvalues which have been
                successfully computed.  (Failures are rare.)

                If INFO .GT. 0 and JOB = 'E', then on exit, the
                remaining unconverged eigenvalues are the eigen-
                values of the upper Hessenberg matrix rows and
                columns ILO through INFO of the final, output
                value of H.

                If INFO .GT. 0 and JOB   = 'S', then on exit

           (*)  (initial value of H)*U  = U*(final value of H)

                where U is an orthogonal matrix.  The final
                value of H is upper Hessenberg and quasi-triangular
                in rows and columns INFO+1 through IHI.

                If INFO .GT. 0 and COMPZ = 'V', then on exit

                  (final value of Z)  =  (initial value of Z)*U

                where U is the orthogonal matrix in (*) (regard-
                less of the value of JOB.)

                If INFO .GT. 0 and COMPZ = 'I', then on exit
                      (final value of Z)  = U
                where U is the orthogonal matrix in (*) (regard-
                less of the value of JOB.)

                If INFO .GT. 0 and COMPZ = 'N', then Z is not
                accessed.

     ================================================================
             Default values supplied by
             ILAENV(ISPEC,'DHSEQR',JOB(:1)//COMPZ(:1),N,ILO,IHI,LWORK).
             It is suggested that these defaults be adjusted in order
             to attain best performance in each particular
             computational environment.

            ISPEC=1:  The DLAHQR vs DLAQR0 crossover point.
                      Default: 75. (Must be at least 11.)

            ISPEC=2:  Recommended deflation window size.
                      This depends on ILO, IHI and NS.  NS is the
                      number of simultaneous shifts returned
                      by ILAENV(ISPEC=4).  (See ISPEC=4 below.)
                      The default for (IHI-ILO+1).LE.500 is NS.
                      The default for (IHI-ILO+1).GT.500 is 3*NS/2.

            ISPEC=3:  Nibble crossover point. (See ILAENV for
                      details.)  Default: 14% of deflation window
                      size.

            ISPEC=4:  Number of simultaneous shifts, NS, in
                      a multi-shift QR iteration.

                      If IHI-ILO+1 is ...

                      greater than      ...but less    ... the
                      or equal to ...      than        default is

                           1               30          NS -   2(+)
                          30               60          NS -   4(+)
                          60              150          NS =  10(+)
                         150              590          NS =  **
                         590             3000          NS =  64
                        3000             6000          NS = 128
                        6000             infinity      NS = 256

                  (+)  By default some or all matrices of this order 
                       are passed to the implicit double shift routine

                       DLAHQR and NS is ignored.  See ISPEC=1 above 
                       and comments in IPARM for details.

                       The asterisks (**) indicate an ad-hoc
                       function of N increasing from 10 to 64.

            ISPEC=5:  Select structured matrix multiply.
                      (See ILAENV for details.) Default: 3.

     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ================================================================
     References:
       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
       Algorithm Part I: Maintaining Well Focused Shifts, and Level 3
       Performance, SIAM Journal of Matrix Analysis, volume 23, pages
       929--947, 2002.

       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
       Algorithm Part II: Aggressive Early Deflation, SIAM Journal
       of Matrix Analysis, volume 23, pages 948--973, 2002.

     ================================================================
     .. Parameters ..

     ==== Matrices of order NTINY or smaller must be processed by
     .    DLAHQR because of insufficient subdiagonal scratch space.
     .    (This is a hard limit.) ====

     ==== NL allocates some local workspace to help small matrices
     .    through a rare DLAHQR failure.  NL .GT. NTINY = 11 is
     .    required and NL .LE. NMIN = ILAENV(ISPEC=1,...) is recom-
     .    mended.  (The default value of NMIN is 75.)  Using NL = 49
     .    allows up to six simultaneous shifts and a 16-by-16
     .    deflation window.  ====

</pre>
	 * @param job
	 * @param compz
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param h
	 * @param ldh
	 * @param wr
	 * @param wi
	 * @param z
	 * @param ldz
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dhseqr(String job, String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, double[] z, int ldz, double[] work, int lwork, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DISNAN returns .TRUE. if its argument is NaN, and .FALSE.
  otherwise.  To be replaced by the Fortran 2003 intrinsic in the
  future.

  Arguments
  =========

  DIN      (input) DOUBLE PRECISION
          Input to test for NaN.

  =====================================================================

  .. External Functions ..
</pre>
	 * @param din
	 */
	public boolean disnan(double din) {
		return org.netlib.lapack.Disnan.disnan(din);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLABAD takes as input the values computed by DLAMCH for underflow and
  overflow, and returns the square root of each of these values if the

  log of LARGE is sufficiently large.  This subroutine is intended to
  identify machines with a large exponent range, such as the Crays, and
  redefine the underflow and overflow limits to be the square roots of

  the values computed by DLAMCH.  This subroutine is needed because
  DLAMCH does not compensate for poor arithmetic in the upper half of
  the exponent range, as is found on a Cray.

  Arguments
  =========

  SMALL   (input/output) DOUBLE PRECISION
          On entry, the underflow threshold as computed by DLAMCH.
          On exit, if LOG10(LARGE) is sufficiently large, the square
          root of SMALL, otherwise unchanged.

  LARGE   (input/output) DOUBLE PRECISION
          On entry, the overflow threshold as computed by DLAMCH.
          On exit, if LOG10(LARGE) is sufficiently large, the square
          root of LARGE, otherwise unchanged.

  =====================================================================

     .. Intrinsic Functions ..
</pre>
	 * @param small
	 * @param large
	 */
	public abstract void dlabad(doubleW small, doubleW large);

	/**
<pre>

     ..

  Purpose
  =======

  DLABRD reduces the first NB rows and columns of a real general
  m by n matrix A to upper or lower bidiagonal form by an orthogonal
  transformation Q' * A * P, and returns the matrices X and Y which
  are needed to apply the transformation to the unreduced part of A.

  If m >= n, A is reduced to upper bidiagonal form; if m < n, to lower

  bidiagonal form.

  This is an auxiliary routine called by DGEBRD

  Arguments
  =========

  M       (input) INTEGER
          The number of rows in the matrix A.

  N       (input) INTEGER
          The number of columns in the matrix A.

  NB      (input) INTEGER
          The number of leading rows and columns of A to be reduced.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the m by n general matrix to be reduced.
          On exit, the first NB rows and columns of the matrix are
          overwritten; the rest of the array is unchanged.
          If m >= n, elements on and below the diagonal in the first NB
            columns, with the array TAUQ, represent the orthogonal
            matrix Q as a product of elementary reflectors; and
            elements above the diagonal in the first NB rows, with the

            array TAUP, represent the orthogonal matrix P as a product

            of elementary reflectors.
          If m < n, elements below the diagonal in the first NB
            columns, with the array TAUQ, represent the orthogonal
            matrix Q as a product of elementary reflectors, and
            elements on and above the diagonal in the first NB rows,
            with the array TAUP, represent the orthogonal matrix P as
            a product of elementary reflectors.
          See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  D       (output) DOUBLE PRECISION array, dimension (NB)
          The diagonal elements of the first NB rows and columns of
          the reduced matrix.  D(i) = A(i,i).

  E       (output) DOUBLE PRECISION array, dimension (NB)
          The off-diagonal elements of the first NB rows and columns of
          the reduced matrix.

  TAUQ    (output) DOUBLE PRECISION array dimension (NB)
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix Q. See Further Details.

  TAUP    (output) DOUBLE PRECISION array, dimension (NB)
          The scalar factors of the elementary reflectors which
          represent the orthogonal matrix P. See Further Details.

  X       (output) DOUBLE PRECISION array, dimension (LDX,NB)
          The m-by-nb matrix X required to update the unreduced part
          of A.

  LDX     (input) INTEGER
          The leading dimension of the array X. LDX >= M.

  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
          The n-by-nb matrix Y required to update the unreduced part
          of A.

  LDY     (input) INTEGER
          The leading dimension of the array Y. LDY >= N.

  Further Details
  ===============

  The matrices Q and P are represented as products of elementary
  reflectors:

     Q = H(1) H(2) . . . H(nb)  and  P = G(1) G(2) . . . G(nb)

  Each H(i) and G(i) has the form:

     H(i) = I - tauq * v * v'  and G(i) = I - taup * u * u'

  where tauq and taup are real scalars, and v and u are real vectors.

  If m >= n, v(1:i-1) = 0, v(i) = 1, and v(i:m) is stored on exit in
  A(i:m,i); u(1:i) = 0, u(i+1) = 1, and u(i+1:n) is stored on exit in
  A(i,i+1:n); tauq is stored in TAUQ(i) and taup in TAUP(i).

  If m < n, v(1:i) = 0, v(i+1) = 1, and v(i+1:m) is stored on exit in
  A(i+2:m,i); u(1:i-1) = 0, u(i) = 1, and u(i:n) is stored on exit in
  A(i,i+1:n); tauq is stored in TAUQ(i) and taup in TAUP(i).

  The elements of the vectors v and u together form the m-by-nb matrix

  V and the nb-by-n matrix U' which are needed, with X and Y, to apply

  the transformation to the unreduced part of the matrix, using a block
  update of the form:  A := A - V*Y' - X*U'.

  The contents of A on exit are illustrated by the following examples
  with nb = 2:

  m = 6 and n = 5 (m > n):          m = 5 and n = 6 (m < n):

    (  1   1   u1  u1  u1 )           (  1   u1  u1  u1  u1  u1 )
    (  v1  1   1   u2  u2 )           (  1   1   u2  u2  u2  u2 )
    (  v1  v2  a   a   a  )           (  v1  1   a   a   a   a  )
    (  v1  v2  a   a   a  )           (  v1  v2  a   a   a   a  )
    (  v1  v2  a   a   a  )           (  v1  v2  a   a   a   a  )
    (  v1  v2  a   a   a  )

  where a denotes an element of the original matrix which is unchanged,
  vi denotes an element of the vector defining H(i), and ui an element

  of the vector defining G(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param nb
	 * @param a
	 * @param lda
	 * @param d
	 * @param e
	 * @param tauq
	 * @param taup
	 * @param x
	 * @param ldx
	 * @param y
	 * @param ldy
	 */
	public abstract void dlabrd(int m, int n, int nb, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] x, int ldx, double[] y, int ldy);

		/**
<pre>

     ..

  Purpose
  =======

  DLACN2 estimates the 1-norm of a square, real matrix A.
  Reverse communication is used for evaluating matrix-vector products.


  Arguments
  =========

  N      (input) INTEGER
         The order of the matrix.  N >= 1.

  V      (workspace) DOUBLE PRECISION array, dimension (N)
         On the final return, V = A*W,  where  EST = norm(V)/norm(W)
         (W is not returned).

  X      (input/output) DOUBLE PRECISION array, dimension (N)
         On an intermediate return, X should be overwritten by
               A * X,   if KASE=1,
               A' * X,  if KASE=2,
         and DLACN2 must be re-called with all the other parameters
         unchanged.

  ISGN   (workspace) INTEGER array, dimension (N)

  EST    (input/output) DOUBLE PRECISION
         On entry with KASE = 1 or 2 and ISAVE(1) = 3, EST should be
         unchanged from the previous call to DLACN2.
         On exit, EST is an estimate (a lower bound) for norm(A). 

  KASE   (input/output) INTEGER
         On the initial call to DLACN2, KASE should be 0.
         On an intermediate return, KASE will be 1 or 2, indicating
         whether X should be overwritten by A * X  or A' * X.
         On the final return from DLACN2, KASE will again be 0.

  ISAVE  (input/output) INTEGER array, dimension (3)
         ISAVE is used to save variables between calls to DLACN2

  Further Details
  ======= =======

  Contributed by Nick Higham, University of Manchester.
  Originally named SONEST, dated March 16, 1988.

  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of
  a real or complex matrix, with applications to condition estimation",
  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988.

  This is a thread safe version of DLACON, which uses the array ISAVE
  in place of a SAVE statement, as follows:

     DLACON     DLACN2
      JUMP     ISAVE(1)
      J        ISAVE(2)
      ITER     ISAVE(3)

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param v
	 * @param x
	 * @param isgn
	 * @param est
	 * @param kase
	 * @param isave
	 */
	public void dlacn2(int n, double[] v, double[] x, int[] isgn, doubleW est, intW kase, int[] isave) {
		org.netlib.lapack.Dlacn2.dlacn2(n, v, 0, x, 0, isgn, 0, est, kase, isave, 0);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLACON estimates the 1-norm of a square, real matrix A.
  Reverse communication is used for evaluating matrix-vector products.


  Arguments
  =========

  N      (input) INTEGER
         The order of the matrix.  N >= 1.

  V      (workspace) DOUBLE PRECISION array, dimension (N)
         On the final return, V = A*W,  where  EST = norm(V)/norm(W)
         (W is not returned).

  X      (input/output) DOUBLE PRECISION array, dimension (N)
         On an intermediate return, X should be overwritten by
               A * X,   if KASE=1,
               A' * X,  if KASE=2,
         and DLACON must be re-called with all the other parameters
         unchanged.

  ISGN   (workspace) INTEGER array, dimension (N)

  EST    (input/output) DOUBLE PRECISION
         On entry with KASE = 1 or 2 and JUMP = 3, EST should be
         unchanged from the previous call to DLACON.
         On exit, EST is an estimate (a lower bound) for norm(A). 

  KASE   (input/output) INTEGER
         On the initial call to DLACON, KASE should be 0.
         On an intermediate return, KASE will be 1 or 2, indicating
         whether X should be overwritten by A * X  or A' * X.
         On the final return from DLACON, KASE will again be 0.

  Further Details
  ======= =======

  Contributed by Nick Higham, University of Manchester.
  Originally named SONEST, dated March 16, 1988.

  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of
  a real or complex matrix, with applications to condition estimation",
  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param v
	 * @param x
	 * @param isgn
	 * @param est
	 * @param kase
	 */
	public abstract void dlacon(int n, double[] v, double[] x, int[] isgn, doubleW est, intW kase);

	/**
<pre>

     ..

  Purpose
  =======

  DLACPY copies all or part of a two-dimensional matrix A to another
  matrix B.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies the part of the matrix A to be copied to B.
          = 'U':      Upper triangular part
          = 'L':      Lower triangular part
          Otherwise:  All of the matrix A

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The m by n matrix A.  If UPLO = 'U', only the upper triangle

          or trapezoid is accessed; if UPLO = 'L', only the lower
          triangle or trapezoid is accessed.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  B       (output) DOUBLE PRECISION array, dimension (LDB,N)
          On exit, B = A in the locations specified by UPLO.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,M).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param uplo
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 */
	public abstract void dlacpy(String uplo, int m, int n, double[] a, int lda, double[] b, int ldb);

	/**
<pre>

     ..

  Purpose
  =======

  DLADIV performs complex division in  real arithmetic

                        a + i*b
             p + i*q = ---------
                        c + i*d

  The algorithm is due to Robert L. Smith and can be found
  in D. Knuth, The art of Computer Programming, Vol.2, p.195

  Arguments
  =========

  A       (input) DOUBLE PRECISION
  B       (input) DOUBLE PRECISION
  C       (input) DOUBLE PRECISION
  D       (input) DOUBLE PRECISION
          The scalars a, b, c, and d in the above expression.

  P       (output) DOUBLE PRECISION
  Q       (output) DOUBLE PRECISION
          The scalars p and q in the above expression.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param a
	 * @param b
	 * @param c
	 * @param d
	 * @param p
	 * @param q
	 */
	public abstract void dladiv(double a, double b, double c, double d, doubleW p, doubleW q);

	/**
<pre>

     ..

  Purpose
  =======

  DLAE2  computes the eigenvalues of a 2-by-2 symmetric matrix
     [  A   B  ]
     [  B   C  ].
  On return, RT1 is the eigenvalue of larger absolute value, and RT2
  is the eigenvalue of smaller absolute value.

  Arguments
  =========

  A       (input) DOUBLE PRECISION
          The (1,1) element of the 2-by-2 matrix.

  B       (input) DOUBLE PRECISION
          The (1,2) and (2,1) elements of the 2-by-2 matrix.

  C       (input) DOUBLE PRECISION
          The (2,2) element of the 2-by-2 matrix.

  RT1     (output) DOUBLE PRECISION
          The eigenvalue of larger absolute value.

  RT2     (output) DOUBLE PRECISION
          The eigenvalue of smaller absolute value.

  Further Details
  ===============

  RT1 is accurate to a few ulps barring over/underflow.

  RT2 may be inaccurate if there is massive cancellation in the
  determinant A*C-B*B; higher precision or correctly rounded or
  correctly truncated arithmetic would be needed to compute RT2
  accurately in all cases.

  Overflow is possible only if RT1 is within a factor of 5 of overflow.
  Underflow is harmless if the input data is 0 or exceeds
     underflow_threshold / macheps.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param a
	 * @param b
	 * @param c
	 * @param rt1
	 * @param rt2
	 */
	public abstract void dlae2(double a, double b, double c, doubleW rt1, doubleW rt2);

	/**
<pre>

     ..

  Purpose
  =======

  DLAEBZ contains the iteration loops which compute and use the
  function N(w), which is the count of eigenvalues of a symmetric
  tridiagonal matrix T less than or equal to its argument  w.  It
  performs a choice of two types of loops:

  IJOB=1, followed by
  IJOB=2: It takes as input a list of intervals and returns a list of
          sufficiently small intervals whose union contains the same
          eigenvalues as the union of the original intervals.
          The input intervals are (AB(j,1),AB(j,2)], j=1,...,MINP.
          The output interval (AB(j,1),AB(j,2)] will contain
          eigenvalues NAB(j,1)+1,...,NAB(j,2), where 1 <= j <= MOUT.

  IJOB=3: It performs a binary search in each input interval
          (AB(j,1),AB(j,2)] for a point  w(j)  such that
          N(w(j))=NVAL(j), and uses  C(j)  as the starting point of
          the search.  If such a w(j) is found, then on output
          AB(j,1)=AB(j,2)=w.  If no such w(j) is found, then on output

          (AB(j,1),AB(j,2)] will be a small interval containing the
          point where N(w) jumps through NVAL(j), unless that point
          lies outside the initial interval.

  Note that the intervals are in all cases half-open intervals,
  i.e., of the form  (a,b] , which includes  b  but not  a .

  To avoid underflow, the matrix should be scaled so that its largest
  element is no greater than  overflow**(1/2) * underflow**(1/4)
  in absolute value.  To assure the most accurate computation
  of small eigenvalues, the matrix should be scaled to be
  not much smaller than that, either.

  See W. Kahan "Accurate Eigenvalues of a Symmetric Tridiagonal
  Matrix", Report CS41, Computer Science Dept., Stanford
  University, July 21, 1966

  Note: the arguments are, in general, *not* checked for unreasonable
  values.

  Arguments
  =========

  IJOB    (input) INTEGER
          Specifies what is to be done:
          = 1:  Compute NAB for the initial intervals.
          = 2:  Perform bisection iteration to find eigenvalues of T.
          = 3:  Perform bisection iteration to invert N(w), i.e.,
                to find a point which has a specified number of
                eigenvalues of T to its left.
          Other values will cause DLAEBZ to return with INFO=-1.

  NITMAX  (input) INTEGER
          The maximum number of "levels" of bisection to be
          performed, i.e., an interval of width W will not be made
          smaller than 2^(-NITMAX) * W.  If not all intervals
          have converged after NITMAX iterations, then INFO is set
          to the number of non-converged intervals.

  N       (input) INTEGER
          The dimension n of the tridiagonal matrix T.  It must be at
          least 1.

  MMAX    (input) INTEGER
          The maximum number of intervals.  If more than MMAX intervals
          are generated, then DLAEBZ will quit with INFO=MMAX+1.

  MINP    (input) INTEGER
          The initial number of intervals.  It may not be greater than

          MMAX.

  NBMIN   (input) INTEGER
          The smallest number of intervals that should be processed
          using a vector loop.  If zero, then only the scalar loop
          will be used.

  ABSTOL  (input) DOUBLE PRECISION
          The minimum (absolute) width of an interval.  When an
          interval is narrower than ABSTOL, or than RELTOL times the
          larger (in magnitude) endpoint, then it is considered to be
          sufficiently small, i.e., converged.  This must be at least
          zero.

  RELTOL  (input) DOUBLE PRECISION
          The minimum relative width of an interval.  When an interval

          is narrower than ABSTOL, or than RELTOL times the larger (in

          magnitude) endpoint, then it is considered to be
          sufficiently small, i.e., converged.  Note: this should
          always be at least radix*machine epsilon.

  PIVMIN  (input) DOUBLE PRECISION
          The minimum absolute value of a "pivot" in the Sturm
          sequence loop.  This *must* be at least  max |e(j)**2| *
          safe_min  and at least safe_min, where safe_min is at least
          the smallest number that can divide one without overflow.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The diagonal elements of the tridiagonal matrix T.

  E       (input) DOUBLE PRECISION array, dimension (N)
          The offdiagonal elements of the tridiagonal matrix T in
          positions 1 through N-1.  E(N) is arbitrary.

  E2      (input) DOUBLE PRECISION array, dimension (N)
          The squares of the offdiagonal elements of the tridiagonal
          matrix T.  E2(N) is ignored.

  NVAL    (input/output) INTEGER array, dimension (MINP)
          If IJOB=1 or 2, not referenced.
          If IJOB=3, the desired values of N(w).  The elements of NVAL

          will be reordered to correspond with the intervals in AB.
          Thus, NVAL(j) on output will not, in general be the same as
          NVAL(j) on input, but it will correspond with the interval
          (AB(j,1),AB(j,2)] on output.

  AB      (input/output) DOUBLE PRECISION array, dimension (MMAX,2)
          The endpoints of the intervals.  AB(j,1) is  a(j), the left
          endpoint of the j-th interval, and AB(j,2) is b(j), the
          right endpoint of the j-th interval.  The input intervals
          will, in general, be modified, split, and reordered by the
          calculation.

  C       (input/output) DOUBLE PRECISION array, dimension (MMAX)
          If IJOB=1, ignored.
          If IJOB=2, workspace.
          If IJOB=3, then on input C(j) should be initialized to the
          first search point in the binary search.

  MOUT    (output) INTEGER
          If IJOB=1, the number of eigenvalues in the intervals.
          If IJOB=2 or 3, the number of intervals output.
          If IJOB=3, MOUT will equal MINP.

  NAB     (input/output) INTEGER array, dimension (MMAX,2)
          If IJOB=1, then on output NAB(i,j) will be set to N(AB(i,j)).
          If IJOB=2, then on input, NAB(i,j) should be set.  It must
             satisfy the condition:
             N(AB(i,1)) <= NAB(i,1) <= NAB(i,2) <= N(AB(i,2)),
             which means that in interval i only eigenvalues
             NAB(i,1)+1,...,NAB(i,2) will be considered.  Usually,
             NAB(i,j)=N(AB(i,j)), from a previous call to DLAEBZ with
             IJOB=1.
             On output, NAB(i,j) will contain
             max(na(k),min(nb(k),N(AB(i,j)))), where k is the index of

             the input interval that the output interval
             (AB(j,1),AB(j,2)] came from, and na(k) and nb(k) are the
             the input values of NAB(k,1) and NAB(k,2).
          If IJOB=3, then on output, NAB(i,j) contains N(AB(i,j)),
             unless N(w) > NVAL(i) for all search points  w , in which

             case NAB(i,1) will not be modified, i.e., the output
             value will be the same as the input value (modulo
             reorderings -- see NVAL and AB), or unless N(w) < NVAL(i)

             for all search points  w , in which case NAB(i,2) will
             not be modified.  Normally, NAB should be set to some
             distinctive value(s) before DLAEBZ is called.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MMAX)
          Workspace.

  IWORK   (workspace) INTEGER array, dimension (MMAX)
          Workspace.

  INFO    (output) INTEGER
          = 0:       All intervals converged.
          = 1--MMAX: The last INFO intervals did not converge.
          = MMAX+1:  More than MMAX intervals were generated.

  Further Details
  ===============

      This routine is intended to be called only by other LAPACK
  routines, thus the interface is less user-friendly.  It is intended
  for two purposes:

  (a) finding eigenvalues.  In this case, DLAEBZ should have one or
      more initial intervals set up in AB, and DLAEBZ should be called

      with IJOB=1.  This sets up NAB, and also counts the eigenvalues.

      Intervals with no eigenvalues would usually be thrown out at
      this point.  Also, if not all the eigenvalues in an interval i
      are desired, NAB(i,1) can be increased or NAB(i,2) decreased.
      For example, set NAB(i,1)=NAB(i,2)-1 to get the largest
      eigenvalue.  DLAEBZ is then called with IJOB=2 and MMAX
      no smaller than the value of MOUT returned by the call with
      IJOB=1.  After this (IJOB=2) call, eigenvalues NAB(i,1)+1
      through NAB(i,2) are approximately AB(i,1) (or AB(i,2)) to the
      tolerance specified by ABSTOL and RELTOL.

  (b) finding an interval (a',b'] containing eigenvalues w(f),...,w(l).
      In this case, start with a Gershgorin interval  (a,b).  Set up
      AB to contain 2 search intervals, both initially (a,b).  One
      NVAL element should contain  f-1  and the other should contain  l
      , while C should contain a and b, resp.  NAB(i,1) should be -1
      and NAB(i,2) should be N+1, to flag an error if the desired
      interval does not lie in (a,b).  DLAEBZ is then called with
      IJOB=3.  On exit, if w(f-1) < w(f), then one of the intervals --

      j -- will have AB(j,1)=AB(j,2) and NAB(j,1)=NAB(j,2)=f-1, while
      if, to the specified tolerance, w(f-k)=...=w(f+r), k > 0 and r
      >= 0, then the interval will have  N(AB(j,1))=NAB(j,1)=f-k and
      N(AB(j,2))=NAB(j,2)=f+r.  The cases w(l) < w(l+1) and
      w(l-r)=...=w(l+k) are handled similarly.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param ijob
	 * @param nitmax
	 * @param n
	 * @param mmax
	 * @param minp
	 * @param nbmin
	 * @param abstol
	 * @param reltol
	 * @param pivmin
	 * @param d
	 * @param e
	 * @param e2
	 * @param nval
	 * @param ab
	 * @param c
	 * @param mout
	 * @param nab
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, double abstol, double reltol, double pivmin, double[] d, double[] e, double[] e2, int[] nval, double[] ab, double[] c, intW mout, int[] nab, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED0 computes all eigenvalues and corresponding eigenvectors of a
  symmetric tridiagonal matrix using the divide and conquer method.

  Arguments
  =========

  ICOMPQ  (input) INTEGER
          = 0:  Compute eigenvalues only.
          = 1:  Compute eigenvectors of original dense symmetric matrix
                also.  On entry, Q contains the orthogonal matrix used

                to reduce the original matrix to tridiagonal form.
          = 2:  Compute eigenvalues and eigenvectors of tridiagonal
                matrix.

  QSIZ   (input) INTEGER
         The dimension of the orthogonal matrix used to reduce
         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.

  N      (input) INTEGER
         The dimension of the symmetric tridiagonal matrix.  N >= 0.

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry, the main diagonal of the tridiagonal matrix.
         On exit, its eigenvalues.

  E      (input) DOUBLE PRECISION array, dimension (N-1)
         The off-diagonal elements of the tridiagonal matrix.
         On exit, E has been destroyed.

  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
         On entry, Q must contain an N-by-N orthogonal matrix.
         If ICOMPQ = 0    Q is not referenced.
         If ICOMPQ = 1    On entry, Q is a subset of the columns of the
                          orthogonal matrix used to reduce the full
                          matrix to tridiagonal form corresponding to
                          the subset of the full matrix which is being

                          decomposed at this time.
         If ICOMPQ = 2    On entry, Q will be the identity matrix.
                          On exit, Q contains the eigenvectors of the
                          tridiagonal matrix.

  LDQ    (input) INTEGER
         The leading dimension of the array Q.  If eigenvectors are
         desired, then  LDQ >= max(1,N).  In any case,  LDQ >= 1.

  QSTORE (workspace) DOUBLE PRECISION array, dimension (LDQS, N)
         Referenced only when ICOMPQ = 1.  Used to store parts of
         the eigenvector matrix when the updating matrix multiplies
         take place.

  LDQS   (input) INTEGER
         The leading dimension of the array QSTORE.  If ICOMPQ = 1,
         then  LDQS >= max(1,N).  In any case,  LDQS >= 1.

  WORK   (workspace) DOUBLE PRECISION array,
         If ICOMPQ = 0 or 1, the dimension of WORK must be at least
                     1 + 3*N + 2*N*lg N + 2*N**2
                     ( lg( N ) = smallest integer k
                                 such that 2^k >= N )
         If ICOMPQ = 2, the dimension of WORK must be at least
                     4*N + N**2.

  IWORK  (workspace) INTEGER array,
         If ICOMPQ = 0 or 1, the dimension of IWORK must be at least
                        6 + 6*N + 5*N*lg N.
                        ( lg( N ) = smallest integer k
                                    such that 2^k >= N )
         If ICOMPQ = 2, the dimension of IWORK must be at least
                        3 + 5*N.

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  The algorithm failed to compute an eigenvalue while
                working on the submatrix lying in rows and columns
                INFO/(N+1) through mod(INFO,N+1).

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param qsiz
	 * @param n
	 * @param d
	 * @param e
	 * @param q
	 * @param ldq
	 * @param qstore
	 * @param ldqs
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlaed0(int icompq, int qsiz, int n, double[] d, double[] e, double[] q, int ldq, double[] qstore, int ldqs, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED1 computes the updated eigensystem of a diagonal
  matrix after modification by a rank-one symmetric matrix.  This
  routine is used only for the eigenproblem which requires all
  eigenvalues and eigenvectors of a tridiagonal matrix.  DLAED7 handles
  the case in which eigenvalues only or eigenvalues and eigenvectors
  of a full symmetric matrix (which was reduced to tridiagonal form)
  are desired.

    T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)

     where Z = Q'u, u is a vector of length N with ones in the
     CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.

     The eigenvectors of the original matrix are stored in Q, and the
     eigenvalues are in D.  The algorithm consists of three stages:

        The first stage consists of deflating the size of the problem
        when there are multiple eigenvalues or if there is a zero in
        the Z vector.  For each such occurence the dimension of the
        secular equation problem is reduced by one.  This stage is
        performed by the routine DLAED2.

        The second stage consists of calculating the updated
        eigenvalues. This is done by finding the roots of the secular
        equation via the routine DLAED4 (as called by DLAED3).
        This routine also calculates the eigenvectors of the current
        problem.

        The final stage consists of computing the updated eigenvectors

        directly using the updated eigenvalues.  The eigenvectors for
        the current problem are multiplied with the eigenvectors from
        the overall problem.

  Arguments
  =========

  N      (input) INTEGER
         The dimension of the symmetric tridiagonal matrix.  N >= 0.

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry, the eigenvalues of the rank-1-perturbed matrix.
         On exit, the eigenvalues of the repaired matrix.

  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
         On entry, the eigenvectors of the rank-1-perturbed matrix.
         On exit, the eigenvectors of the repaired tridiagonal matrix.


  LDQ    (input) INTEGER
         The leading dimension of the array Q.  LDQ >= max(1,N).

  INDXQ  (input/output) INTEGER array, dimension (N)
         On entry, the permutation which separately sorts the two
         subproblems in D into ascending order.
         On exit, the permutation which will reintegrate the
         subproblems back into sorted order,
         i.e. D( INDXQ( I = 1, N ) ) will be in ascending order.

  RHO    (input) DOUBLE PRECISION
         The subdiagonal entry used to create the rank-1 modification.


  CUTPNT (input) INTEGER
         The location of the last eigenvalue in the leading sub-matrix.
         min(1,N) <= CUTPNT <= N/2.

  WORK   (workspace) DOUBLE PRECISION array, dimension (4*N + N**2)

  IWORK  (workspace) INTEGER array, dimension (4*N)

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an eigenvalue did not converge

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA
  Modified by Francoise Tisseur, University of Tennessee.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param d
	 * @param q
	 * @param ldq
	 * @param indxq
	 * @param rho
	 * @param cutpnt
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlaed1(int n, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED2 merges the two sets of eigenvalues together into a single
  sorted set.  Then it tries to deflate the size of the problem.
  There are two ways in which deflation can occur:  when two or more
  eigenvalues are close together or if there is a tiny entry in the
  Z vector.  For each such occurrence the order of the related secular

  equation problem is reduced by one.

  Arguments
  =========

  K      (output) INTEGER
         The number of non-deflated eigenvalues, and the order of the
         related secular equation. 0 <= K <=N.

  N      (input) INTEGER
         The dimension of the symmetric tridiagonal matrix.  N >= 0.

  N1     (input) INTEGER
         The location of the last eigenvalue in the leading sub-matrix.
         min(1,N) <= N1 <= N/2.

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry, D contains the eigenvalues of the two submatrices to
         be combined.
         On exit, D contains the trailing (N-K) updated eigenvalues
         (those which were deflated) sorted into increasing order.

  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
         On entry, Q contains the eigenvectors of two submatrices in
         the two square blocks with corners at (1,1), (N1,N1)
         and (N1+1, N1+1), (N,N).
         On exit, Q contains the trailing (N-K) updated eigenvectors
         (those which were deflated) in its last N-K columns.

  LDQ    (input) INTEGER
         The leading dimension of the array Q.  LDQ >= max(1,N).

  INDXQ  (input/output) INTEGER array, dimension (N)
         The permutation which separately sorts the two sub-problems
         in D into ascending order.  Note that elements in the second
         half of this permutation must first have N1 added to their
         values. Destroyed on exit.

  RHO    (input/output) DOUBLE PRECISION
         On entry, the off-diagonal element associated with the rank-1

         cut which originally split the two submatrices which are now
         being recombined.
         On exit, RHO has been modified to the value required by
         DLAED3.

  Z      (input) DOUBLE PRECISION array, dimension (N)
         On entry, Z contains the updating vector (the last
         row of the first sub-eigenvector matrix and the first row of
         the second sub-eigenvector matrix).
         On exit, the contents of Z have been destroyed by the updating
         process.

  DLAMDA (output) DOUBLE PRECISION array, dimension (N)
         A copy of the first K eigenvalues which will be used by
         DLAED3 to form the secular equation.

  W      (output) DOUBLE PRECISION array, dimension (N)
         The first k values of the final deflation-altered z-vector
         which will be passed to DLAED3.

  Q2     (output) DOUBLE PRECISION array, dimension (N1**2+(N-N1)**2)
         A copy of the first K eigenvectors which will be used by
         DLAED3 in a matrix multiply (DGEMM) to solve for the new
         eigenvectors.

  INDX   (workspace) INTEGER array, dimension (N)
         The permutation used to sort the contents of DLAMDA into
         ascending order.

  INDXC  (output) INTEGER array, dimension (N)
         The permutation used to arrange the columns of the deflated
         Q matrix into three groups:  the first group contains non-zero
         elements only at and above N1, the second contains
         non-zero elements only below N1, and the third is dense.

  INDXP  (workspace) INTEGER array, dimension (N)
         The permutation used to place deflated values of D at the end

         of the array.  INDXP(1:K) points to the nondeflated D-values
         and INDXP(K+1:N) points to the deflated eigenvalues.

  COLTYP (workspace/output) INTEGER array, dimension (N)
         During execution, a label which will indicate which of the
         following types a column in the Q2 matrix is:
         1 : non-zero in the upper half only;
         2 : dense;
         3 : non-zero in the lower half only;
         4 : deflated.
         On exit, COLTYP(i) is the number of columns of type i,
         for i=1 to 4 only.

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA
  Modified by Francoise Tisseur, University of Tennessee.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param k
	 * @param n
	 * @param n1
	 * @param d
	 * @param q
	 * @param ldq
	 * @param indxq
	 * @param rho
	 * @param z
	 * @param dlamda
	 * @param w
	 * @param q2
	 * @param indx
	 * @param indxc
	 * @param indxp
	 * @param coltyp
	 * @param info
	 */
	public abstract void dlaed2(intW k, int n, int n1, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, double[] z, double[] dlamda, double[] w, double[] q2, int[] indx, int[] indxc, int[] indxp, int[] coltyp, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED3 finds the roots of the secular equation, as defined by the
  values in D, W, and RHO, between 1 and K.  It makes the
  appropriate calls to DLAED4 and then updates the eigenvectors by
  multiplying the matrix of eigenvectors of the pair of eigensystems
  being combined by the matrix of eigenvectors of the K-by-K system
  which is solved here.

  This code makes very mild assumptions about floating point
  arithmetic. It will work on machines with a guard digit in
  add/subtract, or on those binary machines without guard digits
  which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or Cray-2.
  It could conceivably fail on hexadecimal or decimal machines
  without guard digits, but we know of none.

  Arguments
  =========

  K       (input) INTEGER
          The number of terms in the rational function to be solved by

          DLAED4.  K >= 0.

  N       (input) INTEGER
          The number of rows and columns in the Q matrix.
          N >= K (deflation may result in N>K).

  N1      (input) INTEGER
          The location of the last eigenvalue in the leading submatrix.
          min(1,N) <= N1 <= N/2.

  D       (output) DOUBLE PRECISION array, dimension (N)
          D(I) contains the updated eigenvalues for
          1 <= I <= K.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
          Initially the first K columns are used as workspace.
          On output the columns 1 to K contain
          the updated eigenvectors.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.  LDQ >= max(1,N).

  RHO     (input) DOUBLE PRECISION
          The value of the parameter in the rank one update equation.
          RHO >= 0 required.

  DLAMDA  (input/output) DOUBLE PRECISION array, dimension (K)
          The first K elements of this array contain the old roots
          of the deflated updating problem.  These are the poles
          of the secular equation. May be changed on output by
          having lowest order bit set to zero on Cray X-MP, Cray Y-MP,

          Cray-2, or Cray C-90, as described above.

  Q2      (input) DOUBLE PRECISION array, dimension (LDQ2, N)
          The first K columns of this matrix contain the non-deflated
          eigenvectors for the split problem.

  INDX    (input) INTEGER array, dimension (N)
          The permutation used to arrange the columns of the deflated
          Q matrix into three groups (see DLAED2).
          The rows of the eigenvectors found by DLAED4 must be likewise
          permuted before the matrix multiply can take place.

  CTOT    (input) INTEGER array, dimension (4)
          A count of the total number of the various types of columns
          in Q, as described in INDX.  The fourth column type is any
          column which has been deflated.

  W       (input/output) DOUBLE PRECISION array, dimension (K)
          The first K elements of this array contain the components
          of the deflation-adjusted updating vector. Destroyed on
          output.

  S       (workspace) DOUBLE PRECISION array, dimension (N1 + 1)*K
          Will contain the eigenvectors of the repaired matrix which
          will be multiplied by the previously accumulated eigenvectors
          to update the system.

  LDS     (input) INTEGER
          The leading dimension of S.  LDS >= max(1,K).

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an eigenvalue did not converge

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA
  Modified by Francoise Tisseur, University of Tennessee.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param k
	 * @param n
	 * @param n1
	 * @param d
	 * @param q
	 * @param ldq
	 * @param rho
	 * @param dlamda
	 * @param q2
	 * @param indx
	 * @param ctot
	 * @param w
	 * @param s
	 * @param info
	 */
	public abstract void dlaed3(int k, int n, int n1, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] q2, int[] indx, int[] ctot, double[] w, double[] s, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This subroutine computes the I-th updated eigenvalue of a symmetric
  rank-one modification to a diagonal matrix whose elements are
  given in the array d, and that

             D(i) < D(j)  for  i < j

  and that RHO > 0.  This is arranged by the calling routine, and is
  no loss in generality.  The rank-one modified system is thus

             diag( D )  +  RHO *  Z * Z_transpose.

  where we assume the Euclidean norm of Z is 1.

  The method consists of approximating the rational functions in the
  secular equation by simpler interpolating rational functions.

  Arguments
  =========

  N      (input) INTEGER
         The length of all arrays.

  I      (input) INTEGER
         The index of the eigenvalue to be computed.  1 <= I <= N.

  D      (input) DOUBLE PRECISION array, dimension (N)
         The original eigenvalues.  It is assumed that they are in
         order, D(I) < D(J)  for I < J.

  Z      (input) DOUBLE PRECISION array, dimension (N)
         The components of the updating vector.

  DELTA  (output) DOUBLE PRECISION array, dimension (N)
         If N .GT. 2, DELTA contains (D(j) - lambda_I) in its  j-th
         component.  If N = 1, then DELTA(1) = 1. If N = 2, see DLAED5

         for detail. The vector DELTA contains the information necessar
         to construct the eigenvectors by DLAED3 and DLAED9.

  RHO    (input) DOUBLE PRECISION
         The scalar in the symmetric updating formula.

  DLAM   (output) DOUBLE PRECISION
         The computed lambda_I, the I-th updated eigenvalue.

  INFO   (output) INTEGER
         = 0:  successful exit
         > 0:  if INFO = 1, the updating process failed.

  Internal Parameters
  ===================

  Logical variable ORGATI (origin-at-i?) is used for distinguishing
  whether D(i) or D(i+1) is treated as the origin.

            ORGATI = .true.    origin at i
            ORGATI = .false.   origin at i+1

   Logical variable SWTCH3 (switch-for-3-poles?) is for noting
   if we are working with THREE poles!

   MAXIT is the maximum number of iterations allowed for each
   eigenvalue.

  Further Details
  ===============

  Based on contributions by
     Ren-Cang Li, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param i
	 * @param d
	 * @param z
	 * @param delta
	 * @param rho
	 * @param dlam
	 * @param info
	 */
	public abstract void dlaed4(int n, int i, double[] d, double[] z, double[] delta, double rho, doubleW dlam, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This subroutine computes the I-th eigenvalue of a symmetric rank-one

  modification of a 2-by-2 diagonal matrix

             diag( D )  +  RHO *  Z * transpose(Z) .

  The diagonal elements in the array D are assumed to satisfy

             D(i) < D(j)  for  i < j .

  We also assume RHO > 0 and that the Euclidean norm of the vector
  Z is one.

  Arguments
  =========

  I      (input) INTEGER
         The index of the eigenvalue to be computed.  I = 1 or I = 2.

  D      (input) DOUBLE PRECISION array, dimension (2)
         The original eigenvalues.  We assume D(1) < D(2).

  Z      (input) DOUBLE PRECISION array, dimension (2)
         The components of the updating vector.

  DELTA  (output) DOUBLE PRECISION array, dimension (2)
         The vector DELTA contains the information necessary
         to construct the eigenvectors.

  RHO    (input) DOUBLE PRECISION
         The scalar in the symmetric updating formula.

  DLAM   (output) DOUBLE PRECISION
         The computed lambda_I, the I-th updated eigenvalue.

  Further Details
  ===============

  Based on contributions by
     Ren-Cang Li, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param i
	 * @param d
	 * @param z
	 * @param delta
	 * @param rho
	 * @param dlam
	 */
	public abstract void dlaed5(int i, double[] d, double[] z, double[] delta, double rho, doubleW dlam);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED6 computes the positive or negative root (closest to the origin)
  of
                   z(1)        z(2)        z(3)
  f(x) =   rho + --------- + ---------- + ---------
                  d(1)-x      d(2)-x      d(3)-x

  It is assumed that

        if ORGATI = .true. the root is between d(2) and d(3);
        otherwise it is between d(1) and d(2)

  This routine will be called by DLAED4 when necessary. In most cases,

  the root sought is the smallest in magnitude, though it might not be

  in some extremely rare situations.

  Arguments
  =========

  KNITER       (input) INTEGER
               Refer to DLAED4 for its significance.

  ORGATI       (input) LOGICAL
               If ORGATI is true, the needed root is between d(2) and
               d(3); otherwise it is between d(1) and d(2).  See
               DLAED4 for further details.

  RHO          (input) DOUBLE PRECISION
               Refer to the equation f(x) above.

  D            (input) DOUBLE PRECISION array, dimension (3)
               D satisfies d(1) < d(2) < d(3).

  Z            (input) DOUBLE PRECISION array, dimension (3)
               Each of the elements in z must be positive.

  FINIT        (input) DOUBLE PRECISION
               The value of f at 0. It is more accurate than the one
               evaluated inside this routine (if someone wants to do
               so).

  TAU          (output) DOUBLE PRECISION
               The root of the equation f(x).

  INFO         (output) INTEGER
               = 0: successful exit
               > 0: if INFO = 1, failure to converge

  Further Details
  ===============

  30/06/99: Based on contributions by
     Ren-Cang Li, Computer Science Division, University of California
     at Berkeley, USA

  10/02/03: This version has a few statements commented out for thread

  safety (machine parameters are computed on each entry). SJH.

  05/10/06: Modified from a new version of Ren-Cang Li, use
     Gragg-Thornton-Warner cubic convergent scheme for better stability

  =====================================================================

     .. Parameters ..
</pre>
	 * @param kniter
	 * @param orgati
	 * @param rho
	 * @param d
	 * @param z
	 * @param finit
	 * @param tau
	 * @param info
	 */
	public abstract void dlaed6(int kniter, boolean orgati, double rho, double[] d, double[] z, double finit, doubleW tau, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED7 computes the updated eigensystem of a diagonal
  matrix after modification by a rank-one symmetric matrix. This
  routine is used only for the eigenproblem which requires all
  eigenvalues and optionally eigenvectors of a dense symmetric matrix
  that has been reduced to tridiagonal form.  DLAED1 handles
  the case in which all eigenvalues and eigenvectors of a symmetric
  tridiagonal matrix are desired.

    T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)

     where Z = Q'u, u is a vector of length N with ones in the
     CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.

     The eigenvectors of the original matrix are stored in Q, and the
     eigenvalues are in D.  The algorithm consists of three stages:

        The first stage consists of deflating the size of the problem
        when there are multiple eigenvalues or if there is a zero in
        the Z vector.  For each such occurence the dimension of the
        secular equation problem is reduced by one.  This stage is
        performed by the routine DLAED8.

        The second stage consists of calculating the updated
        eigenvalues. This is done by finding the roots of the secular
        equation via the routine DLAED4 (as called by DLAED9).
        This routine also calculates the eigenvectors of the current
        problem.

        The final stage consists of computing the updated eigenvectors

        directly using the updated eigenvalues.  The eigenvectors for
        the current problem are multiplied with the eigenvectors from
        the overall problem.

  Arguments
  =========

  ICOMPQ  (input) INTEGER
          = 0:  Compute eigenvalues only.
          = 1:  Compute eigenvectors of original dense symmetric matrix
                also.  On entry, Q contains the orthogonal matrix used

                to reduce the original matrix to tridiagonal form.

  N      (input) INTEGER
         The dimension of the symmetric tridiagonal matrix.  N >= 0.

  QSIZ   (input) INTEGER
         The dimension of the orthogonal matrix used to reduce
         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.

  TLVLS  (input) INTEGER
         The total number of merging levels in the overall divide and
         conquer tree.

  CURLVL (input) INTEGER
         The current level in the overall merge routine,
         0 <= CURLVL <= TLVLS.

  CURPBM (input) INTEGER
         The current problem in the current level in the overall
         merge routine (counting from upper left to lower right).

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry, the eigenvalues of the rank-1-perturbed matrix.
         On exit, the eigenvalues of the repaired matrix.

  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ, N)
         On entry, the eigenvectors of the rank-1-perturbed matrix.
         On exit, the eigenvectors of the repaired tridiagonal matrix.


  LDQ    (input) INTEGER
         The leading dimension of the array Q.  LDQ >= max(1,N).

  INDXQ  (output) INTEGER array, dimension (N)
         The permutation which will reintegrate the subproblem just
         solved back into sorted order, i.e., D( INDXQ( I = 1, N ) )
         will be in ascending order.

  RHO    (input) DOUBLE PRECISION
         The subdiagonal element used to create the rank-1
         modification.

  CUTPNT (input) INTEGER
         Contains the location of the last eigenvalue in the leading
         sub-matrix.  min(1,N) <= CUTPNT <= N.

  QSTORE (input/output) DOUBLE PRECISION array, dimension (N**2+1)
         Stores eigenvectors of submatrices encountered during
         divide and conquer, packed together. QPTR points to
         beginning of the submatrices.

  QPTR   (input/output) INTEGER array, dimension (N+2)
         List of indices pointing to beginning of submatrices stored
         in QSTORE. The submatrices are numbered starting at the
         bottom left of the divide and conquer tree, from left to
         right and bottom to top.

  PRMPTR (input) INTEGER array, dimension (N lg N)
         Contains a list of pointers which indicate where in PERM a
         level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)
         indicates the size of the permutation and also the size of
         the full, non-deflated problem.

  PERM   (input) INTEGER array, dimension (N lg N)
         Contains the permutations (from deflation and sorting) to be
         applied to each eigenblock.

  GIVPTR (input) INTEGER array, dimension (N lg N)
         Contains a list of pointers which indicate where in GIVCOL a
         level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)

         indicates the number of Givens rotations.

  GIVCOL (input) INTEGER array, dimension (2, N lg N)
         Each pair of numbers indicates a pair of columns to take place
         in a Givens rotation.

  GIVNUM (input) DOUBLE PRECISION array, dimension (2, N lg N)
         Each number indicates the S value to be used in the
         corresponding Givens rotation.

  WORK   (workspace) DOUBLE PRECISION array, dimension (3*N+QSIZ*N)

  IWORK  (workspace) INTEGER array, dimension (4*N)

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an eigenvalue did not converge

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param n
	 * @param qsiz
	 * @param tlvls
	 * @param curlvl
	 * @param curpbm
	 * @param d
	 * @param q
	 * @param ldq
	 * @param indxq
	 * @param rho
	 * @param cutpnt
	 * @param qstore
	 * @param qptr
	 * @param prmptr
	 * @param perm
	 * @param givptr
	 * @param givcol
	 * @param givnum
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] qstore, int[] qptr, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED8 merges the two sets of eigenvalues together into a single
  sorted set.  Then it tries to deflate the size of the problem.
  There are two ways in which deflation can occur:  when two or more
  eigenvalues are close together or if there is a tiny element in the
  Z vector.  For each such occurrence the order of the related secular

  equation problem is reduced by one.

  Arguments
  =========

  ICOMPQ  (input) INTEGER
          = 0:  Compute eigenvalues only.
          = 1:  Compute eigenvectors of original dense symmetric matrix
                also.  On entry, Q contains the orthogonal matrix used

                to reduce the original matrix to tridiagonal form.

  K      (output) INTEGER
         The number of non-deflated eigenvalues, and the order of the
         related secular equation.

  N      (input) INTEGER
         The dimension of the symmetric tridiagonal matrix.  N >= 0.

  QSIZ   (input) INTEGER
         The dimension of the orthogonal matrix used to reduce
         the full matrix to tridiagonal form.  QSIZ >= N if ICOMPQ = 1.

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry, the eigenvalues of the two submatrices to be
         combined.  On exit, the trailing (N-K) updated eigenvalues
         (those which were deflated) sorted into increasing order.

  Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
         If ICOMPQ = 0, Q is not referenced.  Otherwise,
         on entry, Q contains the eigenvectors of the partially solved

         system which has been previously updated in matrix
         multiplies with other partially solved eigensystems.
         On exit, Q contains the trailing (N-K) updated eigenvectors
         (those which were deflated) in its last N-K columns.

  LDQ    (input) INTEGER
         The leading dimension of the array Q.  LDQ >= max(1,N).

  INDXQ  (input) INTEGER array, dimension (N)
         The permutation which separately sorts the two sub-problems
         in D into ascending order.  Note that elements in the second
         half of this permutation must first have CUTPNT added to
         their values in order to be accurate.

  RHO    (input/output) DOUBLE PRECISION
         On entry, the off-diagonal element associated with the rank-1

         cut which originally split the two submatrices which are now
         being recombined.
         On exit, RHO has been modified to the value required by
         DLAED3.

  CUTPNT (input) INTEGER
         The location of the last eigenvalue in the leading
         sub-matrix.  min(1,N) <= CUTPNT <= N.

  Z      (input) DOUBLE PRECISION array, dimension (N)
         On entry, Z contains the updating vector (the last row of
         the first sub-eigenvector matrix and the first row of the
         second sub-eigenvector matrix).
         On exit, the contents of Z are destroyed by the updating
         process.

  DLAMDA (output) DOUBLE PRECISION array, dimension (N)
         A copy of the first K eigenvalues which will be used by
         DLAED3 to form the secular equation.

  Q2     (output) DOUBLE PRECISION array, dimension (LDQ2,N)
         If ICOMPQ = 0, Q2 is not referenced.  Otherwise,
         a copy of the first K eigenvectors which will be used by
         DLAED7 in a matrix multiply (DGEMM) to update the new
         eigenvectors.

  LDQ2   (input) INTEGER
         The leading dimension of the array Q2.  LDQ2 >= max(1,N).

  W      (output) DOUBLE PRECISION array, dimension (N)
         The first k values of the final deflation-altered z-vector and
         will be passed to DLAED3.

  PERM   (output) INTEGER array, dimension (N)
         The permutations (from deflation and sorting) to be applied
         to each eigenblock.

  GIVPTR (output) INTEGER
         The number of Givens rotations which took place in this
         subproblem.

  GIVCOL (output) INTEGER array, dimension (2, N)
         Each pair of numbers indicates a pair of columns to take place
         in a Givens rotation.

  GIVNUM (output) DOUBLE PRECISION array, dimension (2, N)
         Each number indicates the S value to be used in the
         corresponding Givens rotation.

  INDXP  (workspace) INTEGER array, dimension (N)
         The permutation used to place deflated values of D at the end

         of the array.  INDXP(1:K) points to the nondeflated D-values
         and INDXP(K+1:N) points to the deflated eigenvalues.

  INDX   (workspace) INTEGER array, dimension (N)
         The permutation used to sort the contents of D into ascending

         order.

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param k
	 * @param n
	 * @param qsiz
	 * @param d
	 * @param q
	 * @param ldq
	 * @param indxq
	 * @param rho
	 * @param cutpnt
	 * @param z
	 * @param dlamda
	 * @param q2
	 * @param ldq2
	 * @param w
	 * @param perm
	 * @param givptr
	 * @param givcol
	 * @param givnum
	 * @param indxp
	 * @param indx
	 * @param info
	 */
	public abstract void dlaed8(int icompq, intW k, int n, int qsiz, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] z, double[] dlamda, double[] q2, int ldq2, double[] w, int[] perm, intW givptr, int[] givcol, double[] givnum, int[] indxp, int[] indx, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAED9 finds the roots of the secular equation, as defined by the
  values in D, Z, and RHO, between KSTART and KSTOP.  It makes the
  appropriate calls to DLAED4 and then stores the new matrix of
  eigenvectors for use in calculating the next level of Z vectors.

  Arguments
  =========

  K       (input) INTEGER
          The number of terms in the rational function to be solved by

          DLAED4.  K >= 0.

  KSTART  (input) INTEGER
  KSTOP   (input) INTEGER
          The updated eigenvalues Lambda(I), KSTART <= I <= KSTOP
          are to be computed.  1 <= KSTART <= KSTOP <= K.

  N       (input) INTEGER
          The number of rows and columns in the Q matrix.
          N >= K (delation may result in N > K).

  D       (output) DOUBLE PRECISION array, dimension (N)
          D(I) contains the updated eigenvalues
          for KSTART <= I <= KSTOP.

  Q       (workspace) DOUBLE PRECISION array, dimension (LDQ,N)

  LDQ     (input) INTEGER
          The leading dimension of the array Q.  LDQ >= max( 1, N ).

  RHO     (input) DOUBLE PRECISION
          The value of the parameter in the rank one update equation.
          RHO >= 0 required.

  DLAMDA  (input) DOUBLE PRECISION array, dimension (K)
          The first K elements of this array contain the old roots
          of the deflated updating problem.  These are the poles
          of the secular equation.

  W       (input) DOUBLE PRECISION array, dimension (K)
          The first K elements of this array contain the components
          of the deflation-adjusted updating vector.

  S       (output) DOUBLE PRECISION array, dimension (LDS, K)
          Will contain the eigenvectors of the repaired matrix which
          will be stored for subsequent Z vector calculation and
          multiplied by the previously accumulated eigenvectors
          to update the system.

  LDS     (input) INTEGER
          The leading dimension of S.  LDS >= max( 1, K ).

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an eigenvalue did not converge

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param k
	 * @param kstart
	 * @param kstop
	 * @param n
	 * @param d
	 * @param q
	 * @param ldq
	 * @param rho
	 * @param dlamda
	 * @param w
	 * @param s
	 * @param lds
	 * @param info
	 */
	public abstract void dlaed9(int k, int kstart, int kstop, int n, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] w, double[] s, int lds, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAEDA computes the Z vector corresponding to the merge step in the
  CURLVLth step of the merge process with TLVLS steps for the CURPBMth

  problem.

  Arguments
  =========

  N      (input) INTEGER
         The dimension of the symmetric tridiagonal matrix.  N >= 0.

  TLVLS  (input) INTEGER
         The total number of merging levels in the overall divide and
         conquer tree.

  CURLVL (input) INTEGER
         The current level in the overall merge routine,
         0 <= curlvl <= tlvls.

  CURPBM (input) INTEGER
         The current problem in the current level in the overall
         merge routine (counting from upper left to lower right).

  PRMPTR (input) INTEGER array, dimension (N lg N)
         Contains a list of pointers which indicate where in PERM a
         level's permutation is stored.  PRMPTR(i+1) - PRMPTR(i)
         indicates the size of the permutation and incidentally the
         size of the full, non-deflated problem.

  PERM   (input) INTEGER array, dimension (N lg N)
         Contains the permutations (from deflation and sorting) to be
         applied to each eigenblock.

  GIVPTR (input) INTEGER array, dimension (N lg N)
         Contains a list of pointers which indicate where in GIVCOL a
         level's Givens rotations are stored.  GIVPTR(i+1) - GIVPTR(i)

         indicates the number of Givens rotations.

  GIVCOL (input) INTEGER array, dimension (2, N lg N)
         Each pair of numbers indicates a pair of columns to take place
         in a Givens rotation.

  GIVNUM (input) DOUBLE PRECISION array, dimension (2, N lg N)
         Each number indicates the S value to be used in the
         corresponding Givens rotation.

  Q      (input) DOUBLE PRECISION array, dimension (N**2)
         Contains the square eigenblocks from previous levels, the
         starting positions for blocks are given by QPTR.

  QPTR   (input) INTEGER array, dimension (N+2)
         Contains a list of pointers which indicate where in Q an
         eigenblock is stored.  SQRT( QPTR(i+1) - QPTR(i) ) indicates
         the size of the block.

  Z      (output) DOUBLE PRECISION array, dimension (N)
         On output this vector contains the updating vector (the last
         row of the first sub-eigenvector matrix and the first row of
         the second sub-eigenvector matrix).

  ZTEMP  (workspace) DOUBLE PRECISION array, dimension (N)

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Jeff Rutter, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param tlvls
	 * @param curlvl
	 * @param curpbm
	 * @param prmptr
	 * @param perm
	 * @param givptr
	 * @param givcol
	 * @param givnum
	 * @param q
	 * @param qptr
	 * @param z
	 * @param ztemp
	 * @param info
	 */
	public abstract void dlaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] q, int[] qptr, double[] z, double[] ztemp, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAEIN uses inverse iteration to find a right or left eigenvector
  corresponding to the eigenvalue (WR,WI) of a real upper Hessenberg
  matrix H.

  Arguments
  =========

  RIGHTV   (input) LOGICAL
          = .TRUE. : compute right eigenvector;
          = .FALSE.: compute left eigenvector.

  NOINIT   (input) LOGICAL
          = .TRUE. : no initial vector supplied in (VR,VI).
          = .FALSE.: initial vector supplied in (VR,VI).

  N       (input) INTEGER
          The order of the matrix H.  N >= 0.

  H       (input) DOUBLE PRECISION array, dimension (LDH,N)
          The upper Hessenberg matrix H.

  LDH     (input) INTEGER
          The leading dimension of the array H.  LDH >= max(1,N).

  WR      (input) DOUBLE PRECISION
  WI      (input) DOUBLE PRECISION
          The real and imaginary parts of the eigenvalue of H whose
          corresponding right or left eigenvector is to be computed.

  VR      (input/output) DOUBLE PRECISION array, dimension (N)
  VI      (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, if NOINIT = .FALSE. and WI = 0.0, VR must contain
          a real starting vector for inverse iteration using the real
          eigenvalue WR; if NOINIT = .FALSE. and WI.ne.0.0, VR and VI
          must contain the real and imaginary parts of a complex
          starting vector for inverse iteration using the complex
          eigenvalue (WR,WI); otherwise VR and VI need not be set.
          On exit, if WI = 0.0 (real eigenvalue), VR contains the
          computed real eigenvector; if WI.ne.0.0 (complex eigenvalue),
          VR and VI contain the real and imaginary parts of the
          computed complex eigenvector. The eigenvector is normalized
          so that the component of largest magnitude has magnitude 1;
          here the magnitude of a complex number (x,y) is taken to be
          |x| + |y|.
          VI is not referenced if WI = 0.0.

  B       (workspace) DOUBLE PRECISION array, dimension (LDB,N)

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= N+1.

  WORK   (workspace) DOUBLE PRECISION array, dimension (N)

  EPS3    (input) DOUBLE PRECISION
          A small machine-dependent value which is used to perturb
          close eigenvalues, and to replace zero pivots.

  SMLNUM  (input) DOUBLE PRECISION
          A machine-dependent value close to the underflow threshold.

  BIGNUM  (input) DOUBLE PRECISION
          A machine-dependent value close to the overflow threshold.

  INFO    (output) INTEGER
          = 0:  successful exit
          = 1:  inverse iteration did not converge; VR is set to the
                last iterate, and so is VI if WI.ne.0.0.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param rightv
	 * @param noinit
	 * @param n
	 * @param h
	 * @param ldh
	 * @param wr
	 * @param wi
	 * @param vr
	 * @param vi
	 * @param b
	 * @param ldb
	 * @param work
	 * @param eps3
	 * @param smlnum
	 * @param bignum
	 * @param info
	 */
	public abstract void dlaein(boolean rightv, boolean noinit, int n, double[] h, int ldh, double wr, double wi, double[] vr, double[] vi, double[] b, int ldb, double[] work, double eps3, double smlnum, double bignum, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAEV2 computes the eigendecomposition of a 2-by-2 symmetric matrix
     [  A   B  ]
     [  B   C  ].
  On return, RT1 is the eigenvalue of larger absolute value, RT2 is the
  eigenvalue of smaller absolute value, and (CS1,SN1) is the unit right
  eigenvector for RT1, giving the decomposition

     [ CS1  SN1 ] [  A   B  ] [ CS1 -SN1 ]  =  [ RT1  0  ]
     [-SN1  CS1 ] [  B   C  ] [ SN1  CS1 ]     [  0  RT2 ].

  Arguments
  =========

  A       (input) DOUBLE PRECISION
          The (1,1) element of the 2-by-2 matrix.

  B       (input) DOUBLE PRECISION
          The (1,2) element and the conjugate of the (2,1) element of
          the 2-by-2 matrix.

  C       (input) DOUBLE PRECISION
          The (2,2) element of the 2-by-2 matrix.

  RT1     (output) DOUBLE PRECISION
          The eigenvalue of larger absolute value.

  RT2     (output) DOUBLE PRECISION
          The eigenvalue of smaller absolute value.

  CS1     (output) DOUBLE PRECISION
  SN1     (output) DOUBLE PRECISION
          The vector (CS1, SN1) is a unit right eigenvector for RT1.

  Further Details
  ===============

  RT1 is accurate to a few ulps barring over/underflow.

  RT2 may be inaccurate if there is massive cancellation in the
  determinant A*C-B*B; higher precision or correctly rounded or
  correctly truncated arithmetic would be needed to compute RT2
  accurately in all cases.

  CS1 and SN1 are accurate to a few ulps barring over/underflow.

  Overflow is possible only if RT1 is within a factor of 5 of overflow.
  Underflow is harmless if the input data is 0 or exceeds
     underflow_threshold / macheps.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param a
	 * @param b
	 * @param c
	 * @param rt1
	 * @param rt2
	 * @param cs1
	 * @param sn1
	 */
	public abstract void dlaev2(double a, double b, double c, doubleW rt1, doubleW rt2, doubleW cs1, doubleW sn1);

	/**
<pre>

     ..

  Purpose
  =======

  DLAEXC swaps adjacent diagonal blocks T11 and T22 of order 1 or 2 in

  an upper quasi-triangular matrix T by an orthogonal similarity
  transformation.

  T must be in Schur canonical form, that is, block upper triangular
  with 1-by-1 and 2-by-2 diagonal blocks; each 2-by-2 diagonal block
  has its diagonal elemnts equal and its off-diagonal elements of
  opposite sign.

  Arguments
  =========

  WANTQ   (input) LOGICAL
          = .TRUE. : accumulate the transformation in the matrix Q;
          = .FALSE.: do not accumulate the transformation.

  N       (input) INTEGER
          The order of the matrix T. N >= 0.

  T       (input/output) DOUBLE PRECISION array, dimension (LDT,N)
          On entry, the upper quasi-triangular matrix T, in Schur
          canonical form.
          On exit, the updated matrix T, again in Schur canonical form.

  LDT     (input)  INTEGER
          The leading dimension of the array T. LDT >= max(1,N).

  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
          On entry, if WANTQ is .TRUE., the orthogonal matrix Q.
          On exit, if WANTQ is .TRUE., the updated matrix Q.
          If WANTQ is .FALSE., Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.
          LDQ >= 1; and if WANTQ is .TRUE., LDQ >= N.

  J1      (input) INTEGER
          The index of the first row of the first block T11.

  N1      (input) INTEGER
          The order of the first block T11. N1 = 0, 1 or 2.

  N2      (input) INTEGER
          The order of the second block T22. N2 = 0, 1 or 2.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0: successful exit
          = 1: the transformed matrix T would be too far from Schur
               form; the blocks are not swapped and T and Q are
               unchanged.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param wantq
	 * @param n
	 * @param t
	 * @param ldt
	 * @param q
	 * @param ldq
	 * @param j1
	 * @param n1
	 * @param n2
	 * @param work
	 * @param info
	 */
	public abstract void dlaexc(boolean wantq, int n, double[] t, int ldt, double[] q, int ldq, int j1, int n1, int n2, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAG2 computes the eigenvalues of a 2 x 2 generalized eigenvalue
  problem  A - w B, with scaling as necessary to avoid over-/underflow.

  The scaling factor "s" results in a modified eigenvalue equation

      s A - w B

  where  s  is a non-negative scaling factor chosen so that  w,  w B,
  and  s A  do not overflow and, if possible, do not underflow, either.

  Arguments
  =========

  A       (input) DOUBLE PRECISION array, dimension (LDA, 2)
          On entry, the 2 x 2 matrix A.  It is assumed that its 1-norm

          is less than 1/SAFMIN.  Entries less than
          sqrt(SAFMIN)*norm(A) are subject to being treated as zero.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= 2.

  B       (input) DOUBLE PRECISION array, dimension (LDB, 2)
          On entry, the 2 x 2 upper triangular matrix B.  It is
          assumed that the one-norm of B is less than 1/SAFMIN.  The
          diagonals should be at least sqrt(SAFMIN) times the largest
          element of B (in absolute value); if a diagonal is smaller
          than that, then  +/- sqrt(SAFMIN) will be used instead of
          that diagonal.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= 2.

  SAFMIN  (input) DOUBLE PRECISION
          The smallest positive number s.t. 1/SAFMIN does not
          overflow.  (This should always be DLAMCH('S') -- it is an
          argument in order to avoid having to call DLAMCH frequently.)

  SCALE1  (output) DOUBLE PRECISION
          A scaling factor used to avoid over-/underflow in the
          eigenvalue equation which defines the first eigenvalue.  If
          the eigenvalues are complex, then the eigenvalues are
          ( WR1  +/-  WI i ) / SCALE1  (which may lie outside the
          exponent range of the machine), SCALE1=SCALE2, and SCALE1
          will always be positive.  If the eigenvalues are real, then
          the first (real) eigenvalue is  WR1 / SCALE1 , but this may
          overflow or underflow, and in fact, SCALE1 may be zero or
          less than the underflow threshhold if the exact eigenvalue
          is sufficiently large.

  SCALE2  (output) DOUBLE PRECISION
          A scaling factor used to avoid over-/underflow in the
          eigenvalue equation which defines the second eigenvalue.  If

          the eigenvalues are complex, then SCALE2=SCALE1.  If the
          eigenvalues are real, then the second (real) eigenvalue is
          WR2 / SCALE2 , but this may overflow or underflow, and in
          fact, SCALE2 may be zero or less than the underflow
          threshhold if the exact eigenvalue is sufficiently large.

  WR1     (output) DOUBLE PRECISION
          If the eigenvalue is real, then WR1 is SCALE1 times the
          eigenvalue closest to the (2,2) element of A B**(-1).  If the
          eigenvalue is complex, then WR1=WR2 is SCALE1 times the real

          part of the eigenvalues.

  WR2     (output) DOUBLE PRECISION
          If the eigenvalue is real, then WR2 is SCALE2 times the
          other eigenvalue.  If the eigenvalue is complex, then
          WR1=WR2 is SCALE1 times the real part of the eigenvalues.

  WI      (output) DOUBLE PRECISION
          If the eigenvalue is real, then WI is zero.  If the
          eigenvalue is complex, then WI is SCALE1 times the imaginary

          part of the eigenvalues.  WI will always be non-negative.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param safmin
	 * @param scale1
	 * @param scale2
	 * @param wr1
	 * @param wr2
	 * @param wi
	 */
	public abstract void dlag2(double[] a, int lda, double[] b, int ldb, double safmin, doubleW scale1, doubleW scale2, doubleW wr1, doubleW wr2, doubleW wi);

		/**
<pre>

     ..

  Purpose
  =======

  DLAG2S converts a DOUBLE PRECISION matrix, SA, to a SINGLE
  PRECISION matrix, A.

  RMAX is the overflow for the SINGLE PRECISION arithmetic
  DLAG2S checks that all the entries of A are between -RMAX and
  RMAX. If not the convertion is aborted and a flag is raised.

  This is a helper routine so there is no argument checking.

  Arguments
  =========

  M       (input) INTEGER
          The number of lines of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N coefficient matrix A.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  SA      (output) REAL array, dimension (LDSA,N)
          On exit, if INFO=0, the M-by-N coefficient matrix SA.

  LDSA    (input) INTEGER
          The leading dimension of the array SA.  LDSA >= max(1,M).

  INFO    (output) INTEGER
          = 0:  successful exit
          > 0:  if INFO = k, the (i,j) entry of the matrix A has
                overflowed when moving from DOUBLE PRECISION to SINGLE

                k is given by k = (i-1)*LDA+j

  =========

     .. Local Scalars ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param sa
	 * @param ldsa
	 * @param info
	 */
	public void dlag2s(int m, int n, double[] a, int lda, float[] sa, int ldsa, intW info) {
		org.netlib.lapack.Dlag2s.dlag2s(m, n, a, 0, lda, sa, 0, ldsa, info);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLAGS2 computes 2-by-2 orthogonal matrices U, V and Q, such
  that if ( UPPER ) then

            U'*A*Q = U'*( A1 A2 )*Q = ( x  0  )
                        ( 0  A3 )     ( x  x  )
  and
            V'*B*Q = V'*( B1 B2 )*Q = ( x  0  )
                        ( 0  B3 )     ( x  x  )

  or if ( .NOT.UPPER ) then

            U'*A*Q = U'*( A1 0  )*Q = ( x  x  )
                        ( A2 A3 )     ( 0  x  )
  and
            V'*B*Q = V'*( B1 0  )*Q = ( x  x  )
                        ( B2 B3 )     ( 0  x  )

  The rows of the transformed A and B are parallel, where

    U = (  CSU  SNU ), V = (  CSV SNV ), Q = (  CSQ   SNQ )
        ( -SNU  CSU )      ( -SNV CSV )      ( -SNQ   CSQ )

  Z' denotes the transpose of Z.


  Arguments
  =========

  UPPER   (input) LOGICAL
          = .TRUE.: the input matrices A and B are upper triangular.
          = .FALSE.: the input matrices A and B are lower triangular.

  A1      (input) DOUBLE PRECISION
  A2      (input) DOUBLE PRECISION
  A3      (input) DOUBLE PRECISION
          On entry, A1, A2 and A3 are elements of the input 2-by-2
          upper (lower) triangular matrix A.

  B1      (input) DOUBLE PRECISION
  B2      (input) DOUBLE PRECISION
  B3      (input) DOUBLE PRECISION
          On entry, B1, B2 and B3 are elements of the input 2-by-2
          upper (lower) triangular matrix B.

  CSU     (output) DOUBLE PRECISION
  SNU     (output) DOUBLE PRECISION
          The desired orthogonal matrix U.

  CSV     (output) DOUBLE PRECISION
  SNV     (output) DOUBLE PRECISION
          The desired orthogonal matrix V.

  CSQ     (output) DOUBLE PRECISION
  SNQ     (output) DOUBLE PRECISION
          The desired orthogonal matrix Q.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param upper
	 * @param a1
	 * @param a2
	 * @param a3
	 * @param b1
	 * @param b2
	 * @param b3
	 * @param csu
	 * @param snu
	 * @param csv
	 * @param snv
	 * @param csq
	 * @param snq
	 */
	public abstract void dlags2(boolean upper, double a1, double a2, double a3, double b1, double b2, double b3, doubleW csu, doubleW snu, doubleW csv, doubleW snv, doubleW csq, doubleW snq);

	/**
<pre>

     ..

  Purpose
  =======

  DLAGTF factorizes the matrix (T - lambda*I), where T is an n by n
  tridiagonal matrix and lambda is a scalar, as

     T - lambda*I = PLU,

  where P is a permutation matrix, L is a unit lower tridiagonal matrix
  with at most one non-zero sub-diagonal elements per column and U is
  an upper triangular matrix with at most two non-zero super-diagonal
  elements per column.

  The factorization is obtained by Gaussian elimination with partial
  pivoting and implicit row scaling.

  The parameter LAMBDA is included in the routine so that DLAGTF may
  be used, in conjunction with DLAGTS, to obtain eigenvectors of T by
  inverse iteration.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix T.

  A       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, A must contain the diagonal elements of T.

          On exit, A is overwritten by the n diagonal elements of the
          upper triangular matrix U of the factorization of T.

  LAMBDA  (input) DOUBLE PRECISION
          On entry, the scalar lambda.

  B       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, B must contain the (n-1) super-diagonal elements of
          T.

          On exit, B is overwritten by the (n-1) super-diagonal
          elements of the matrix U of the factorization of T.

  C       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, C must contain the (n-1) sub-diagonal elements of
          T.

          On exit, C is overwritten by the (n-1) sub-diagonal elements

          of the matrix L of the factorization of T.

  TOL     (input) DOUBLE PRECISION
          On entry, a relative tolerance used to indicate whether or
          not the matrix (T - lambda*I) is nearly singular. TOL should

          normally be chose as approximately the largest relative error
          in the elements of T. For example, if the elements of T are
          correct to about 4 significant figures, then TOL should be
          set to about 5*10**(-4). If TOL is supplied as less than eps,
          where eps is the relative machine precision, then the value
          eps is used in place of TOL.

  D       (output) DOUBLE PRECISION array, dimension (N-2)
          On exit, D is overwritten by the (n-2) second super-diagonal

          elements of the matrix U of the factorization of T.

  IN      (output) INTEGER array, dimension (N)
          On exit, IN contains details of the permutation matrix P. If

          an interchange occurred at the kth step of the elimination,
          then IN(k) = 1, otherwise IN(k) = 0. The element IN(n)
          returns the smallest positive integer j such that

             abs( u(j,j) ).le. norm( (T - lambda*I)(j) )*TOL,

          where norm( A(j) ) denotes the sum of the absolute values of

          the jth row of the matrix A. If no such j exists then IN(n)
          is returned as zero. If IN(n) is returned as positive, then a
          diagonal element of U is small, indicating that
          (T - lambda*I) is singular or nearly singular,

  INFO    (output) INTEGER
          = 0   : successful exit
          .lt. 0: if INFO = -k, the kth argument had an illegal value

 =====================================================================


     .. Parameters ..
</pre>
	 * @param n
	 * @param a
	 * @param lambda
	 * @param b
	 * @param c
	 * @param tol
	 * @param d
	 * @param in
	 * @param info
	 */
	public abstract void dlagtf(int n, double[] a, double lambda, double[] b, double[] c, double tol, double[] d, int[] in, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAGTM performs a matrix-vector product of the form

     B := alpha * A * X + beta * B

  where A is a tridiagonal matrix of order N, B and X are N by NRHS
  matrices, and alpha and beta are real scalars, each of which may be
  0., 1., or -1.

  Arguments
  =========

  TRANS   (input) CHARACTER*1
          Specifies the operation applied to A.
          = 'N':  No transpose, B := alpha * A * X + beta * B
          = 'T':  Transpose,    B := alpha * A'* X + beta * B
          = 'C':  Conjugate transpose = Transpose

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices X and B.

  ALPHA   (input) DOUBLE PRECISION
          The scalar alpha.  ALPHA must be 0., 1., or -1.; otherwise,
          it is assumed to be 0.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) sub-diagonal elements of T.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The diagonal elements of T.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) super-diagonal elements of T.

  X       (input) DOUBLE PRECISION array, dimension (LDX,NRHS)
          The N by NRHS matrix X.
  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(N,1).

  BETA    (input) DOUBLE PRECISION
          The scalar beta.  BETA must be 0., 1., or -1.; otherwise,
          it is assumed to be 1.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N by NRHS matrix B.
          On exit, B is overwritten by the matrix expression
          B := alpha * A * X + beta * B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(N,1).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param trans
	 * @param n
	 * @param nrhs
	 * @param alpha
	 * @param dl
	 * @param d
	 * @param du
	 * @param x
	 * @param ldx
	 * @param beta
	 * @param b
	 * @param ldb
	 */
	public abstract void dlagtm(String trans, int n, int nrhs, double alpha, double[] dl, double[] d, double[] du, double[] x, int ldx, double beta, double[] b, int ldb);

	/**
<pre>

     ..

  Purpose
  =======

  DLAGTS may be used to solve one of the systems of equations

     (T - lambda*I)*x = y   or   (T - lambda*I)'*x = y,

  where T is an n by n tridiagonal matrix, for x, following the
  factorization of (T - lambda*I) as

     (T - lambda*I) = P*L*U ,

  by routine DLAGTF. The choice of equation to be solved is
  controlled by the argument JOB, and in each case there is an option
  to perturb zero or very small diagonal elements of U, this option
  being intended for use in applications such as inverse iteration.

  Arguments
  =========

  JOB     (input) INTEGER
          Specifies the job to be performed by DLAGTS as follows:
          =  1: The equations  (T - lambda*I)x = y  are to be solved,
                but diagonal elements of U are not to be perturbed.
          = -1: The equations  (T - lambda*I)x = y  are to be solved
                and, if overflow would otherwise occur, the diagonal
                elements of U are to be perturbed. See argument TOL
                below.
          =  2: The equations  (T - lambda*I)'x = y  are to be solved,

                but diagonal elements of U are not to be perturbed.
          = -2: The equations  (T - lambda*I)'x = y  are to be solved
                and, if overflow would otherwise occur, the diagonal
                elements of U are to be perturbed. See argument TOL
                below.

  N       (input) INTEGER
          The order of the matrix T.

  A       (input) DOUBLE PRECISION array, dimension (N)
          On entry, A must contain the diagonal elements of U as
          returned from DLAGTF.

  B       (input) DOUBLE PRECISION array, dimension (N-1)
          On entry, B must contain the first super-diagonal elements of
          U as returned from DLAGTF.

  C       (input) DOUBLE PRECISION array, dimension (N-1)
          On entry, C must contain the sub-diagonal elements of L as
          returned from DLAGTF.

  D       (input) DOUBLE PRECISION array, dimension (N-2)
          On entry, D must contain the second super-diagonal elements
          of U as returned from DLAGTF.

  IN      (input) INTEGER array, dimension (N)
          On entry, IN must contain details of the matrix P as returned
          from DLAGTF.

  Y       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the right hand side vector y.
          On exit, Y is overwritten by the solution vector x.

  TOL     (input/output) DOUBLE PRECISION
          On entry, with  JOB .lt. 0, TOL should be the minimum
          perturbation to be made to very small diagonal elements of U.
          TOL should normally be chosen as about eps*norm(U), where eps
          is the relative machine precision, but if TOL is supplied as

          non-positive, then it is reset to eps*max( abs( u(i,j) ) ).
          If  JOB .gt. 0  then TOL is not referenced.

          On exit, TOL is changed as described above, only if TOL is
          non-positive on entry. Otherwise TOL is unchanged.

  INFO    (output) INTEGER
          = 0   : successful exit
          .lt. 0: if INFO = -i, the i-th argument had an illegal value

          .gt. 0: overflow would occur when computing the INFO(th)
                  element of the solution vector x. This can only occur
                  when JOB is supplied as positive and either means
                  that a diagonal element of U is very small, or that
                  the elements of the right-hand side vector y are very
                  large.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param job
	 * @param n
	 * @param a
	 * @param b
	 * @param c
	 * @param d
	 * @param in
	 * @param y
	 * @param tol
	 * @param info
	 */
	public abstract void dlagts(int job, int n, double[] a, double[] b, double[] c, double[] d, int[] in, double[] y, doubleW tol, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAGV2 computes the Generalized Schur factorization of a real 2-by-2

  matrix pencil (A,B) where B is upper triangular. This routine
  computes orthogonal (rotation) matrices given by CSL, SNL and CSR,
  SNR such that

  1) if the pencil (A,B) has two real eigenvalues (include 0/0 or 1/0
     types), then

     [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]
     [  0  a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]

     [ b11 b12 ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]
     [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ],

  2) if the pencil (A,B) has a pair of complex conjugate eigenvalues,
     then

     [ a11 a12 ] := [  CSL  SNL ] [ a11 a12 ] [  CSR -SNR ]
     [ a21 a22 ]    [ -SNL  CSL ] [ a21 a22 ] [  SNR  CSR ]

     [ b11  0  ] := [  CSL  SNL ] [ b11 b12 ] [  CSR -SNR ]
     [  0  b22 ]    [ -SNL  CSL ] [  0  b22 ] [  SNR  CSR ]

     where b11 >= b22 > 0.


  Arguments
  =========

  A       (input/output) DOUBLE PRECISION array, dimension (LDA, 2)
          On entry, the 2 x 2 matrix A.
          On exit, A is overwritten by the ``A-part'' of the
          generalized Schur form.

  LDA     (input) INTEGER
          THe leading dimension of the array A.  LDA >= 2.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB, 2)
          On entry, the upper triangular 2 x 2 matrix B.
          On exit, B is overwritten by the ``B-part'' of the
          generalized Schur form.

  LDB     (input) INTEGER
          THe leading dimension of the array B.  LDB >= 2.

  ALPHAR  (output) DOUBLE PRECISION array, dimension (2)
  ALPHAI  (output) DOUBLE PRECISION array, dimension (2)
  BETA    (output) DOUBLE PRECISION array, dimension (2)
          (ALPHAR(k)+i*ALPHAI(k))/BETA(k) are the eigenvalues of the
          pencil (A,B), k=1,2, i = sqrt(-1).  Note that BETA(k) may
          be zero.

  CSL     (output) DOUBLE PRECISION
          The cosine of the left rotation matrix.

  SNL     (output) DOUBLE PRECISION
          The sine of the left rotation matrix.

  CSR     (output) DOUBLE PRECISION
          The cosine of the right rotation matrix.

  SNR     (output) DOUBLE PRECISION
          The sine of the right rotation matrix.

  Further Details
  ===============

  Based on contributions by
     Mark Fahey, Department of Mathematics, Univ. of Kentucky, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param alphar
	 * @param alphai
	 * @param beta
	 * @param csl
	 * @param snl
	 * @param csr
	 * @param snr
	 */
	public abstract void dlagv2(double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, doubleW csl, doubleW snl, doubleW csr, doubleW snr);

	/**
<pre>

     ..

     Purpose
     =======

     DLAHQR is an auxiliary routine called by DHSEQR to update the
     eigenvalues and Schur decomposition already computed by DHSEQR, by
     dealing with the Hessenberg submatrix in rows and columns ILO to
     IHI.

     Arguments
     =========

     WANTT   (input) LOGICAL
          = .TRUE. : the full Schur form T is required;
          = .FALSE.: only eigenvalues are required.

     WANTZ   (input) LOGICAL
          = .TRUE. : the matrix of Schur vectors Z is required;
          = .FALSE.: Schur vectors are not required.

     N       (input) INTEGER
          The order of the matrix H.  N >= 0.

     ILO     (input) INTEGER
     IHI     (input) INTEGER
          It is assumed that H is already upper quasi-triangular in
          rows and columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless
          ILO = 1). DLAHQR works primarily with the Hessenberg
          submatrix in rows and columns ILO to IHI, but applies
          transformations to all of H if WANTT is .TRUE..
          1 <= ILO <= max(1,IHI); IHI <= N.

     H       (input/output) DOUBLE PRECISION array, dimension (LDH,N)
          On entry, the upper Hessenberg matrix H.
          On exit, if INFO is zero and if WANTT is .TRUE., H is upper
          quasi-triangular in rows and columns ILO:IHI, with any
          2-by-2 diagonal blocks in standard form. If INFO is zero
          and WANTT is .FALSE., the contents of H are unspecified on
          exit.  The output state of H if INFO is nonzero is given
          below under the description of INFO.

     LDH     (input) INTEGER
          The leading dimension of the array H. LDH >= max(1,N).

     WR      (output) DOUBLE PRECISION array, dimension (N)
     WI      (output) DOUBLE PRECISION array, dimension (N)
          The real and imaginary parts, respectively, of the computed
          eigenvalues ILO to IHI are stored in the corresponding
          elements of WR and WI. If two eigenvalues are computed as a
          complex conjugate pair, they are stored in consecutive
          elements of WR and WI, say the i-th and (i+1)th, with
          WI(i) > 0 and WI(i+1) < 0. If WANTT is .TRUE., the
          eigenvalues are stored in the same order as on the diagonal
          of the Schur form returned in H, with WR(i) = H(i,i), and, if
          H(i:i+1,i:i+1) is a 2-by-2 diagonal block,
          WI(i) = sqrt(H(i+1,i)*H(i,i+1)) and WI(i+1) = -WI(i).

     ILOZ    (input) INTEGER
     IHIZ    (input) INTEGER
          Specify the rows of Z to which transformations must be
          applied if WANTZ is .TRUE..
          1 <= ILOZ <= ILO; IHI <= IHIZ <= N.

     Z       (input/output) DOUBLE PRECISION array, dimension (LDZ,N)
          If WANTZ is .TRUE., on entry Z must contain the current
          matrix Z of transformations accumulated by DHSEQR, and on
          exit Z has been updated; transformations are applied only to

          the submatrix Z(ILOZ:IHIZ,ILO:IHI).
          If WANTZ is .FALSE., Z is not referenced.

     LDZ     (input) INTEGER
          The leading dimension of the array Z. LDZ >= max(1,N).

     INFO    (output) INTEGER
           =   0: successful exit
          .GT. 0: If INFO = i, DLAHQR failed to compute all the
                  eigenvalues ILO to IHI in a total of 30 iterations
                  per eigenvalue; elements i+1:ihi of WR and WI
                  contain those eigenvalues which have been
                  successfully computed.

                  If INFO .GT. 0 and WANTT is .FALSE., then on exit,
                  the remaining unconverged eigenvalues are the
                  eigenvalues of the upper Hessenberg matrix rows
                  and columns ILO thorugh INFO of the final, output
                  value of H.

                  If INFO .GT. 0 and WANTT is .TRUE., then on exit
          (*)       (initial value of H)*U  = U*(final value of H)
                  where U is an orthognal matrix.    The final
                  value of H is upper Hessenberg and triangular in
                  rows and columns INFO+1 through IHI.

                  If INFO .GT. 0 and WANTZ is .TRUE., then on exit
                      (final value of Z)  = (initial value of Z)*U
                  where U is the orthogonal matrix in (*)
                  (regardless of the value of WANTT.)

     Further Details
     ===============

     02-96 Based on modifications by
     David Day, Sandia National Laboratory, USA

     12-04 Further modifications by
     Ralph Byers, University of Kansas, USA

       This is a modified version of DLAHQR from LAPACK version 3.0.
       It is (1) more robust against overflow and underflow and
       (2) adopts the more conservative Ahues & Tisseur stopping
       criterion (LAWN 122, 1997).

     =========================================================

     .. Parameters ..
</pre>
	 * @param wantt
	 * @param wantz
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param h
	 * @param ldh
	 * @param wr
	 * @param wi
	 * @param iloz
	 * @param ihiz
	 * @param z
	 * @param ldz
	 * @param info
	 */
	public abstract void dlahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, int iloz, int ihiz, double[] z, int ldz, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DLAHR2 reduces the first NB columns of A real general n-BY-(n-k+1)
  matrix A so that elements below the k-th subdiagonal are zero. The
  reduction is performed by an orthogonal similarity transformation
  Q' * A * Q. The routine returns the matrices V and T which determine

  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.

  This is an auxiliary routine called by DGEHRD.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.

  K       (input) INTEGER
          The offset for the reduction. Elements below the k-th
          subdiagonal in the first NB columns are reduced to zero.
          K < N.

  NB      (input) INTEGER
          The number of columns to be reduced.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N-K+1)

          On entry, the n-by-(n-k+1) general matrix A.
          On exit, the elements on and above the k-th subdiagonal in
          the first NB columns are overwritten with the corresponding
          elements of the reduced matrix; the elements below the k-th
          subdiagonal, with the array TAU, represent the matrix Q as a

          product of elementary reflectors. The other columns of A are

          unchanged. See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  TAU     (output) DOUBLE PRECISION array, dimension (NB)
          The scalar factors of the elementary reflectors. See Further

          Details.

  T       (output) DOUBLE PRECISION array, dimension (LDT,NB)
          The upper triangular matrix T.

  LDT     (input) INTEGER
          The leading dimension of the array T.  LDT >= NB.

  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
          The n-by-nb matrix Y.

  LDY     (input) INTEGER
          The leading dimension of the array Y. LDY >= N.

  Further Details
  ===============

  The matrix Q is represented as a product of nb elementary reflectors


     Q = H(1) H(2) . . . H(nb).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i+k-1) = 0, v(i+k) = 1; v(i+k+1:n) is stored on exit in
  A(i+k+1:n,i), and tau in TAU(i).

  The elements of the vectors v together form the (n-k+1)-by-nb matrix

  V which is needed, with T and Y, to apply the transformation to the
  unreduced part of the matrix, using an update of the form:
  A := (I - V*T*V') * (A - Y*V').

  The contents of A on exit are illustrated by the following example
  with n = 7, k = 3 and nb = 2:

     ( a   a   a   a   a )
     ( a   a   a   a   a )
     ( a   a   a   a   a )
     ( h   h   a   a   a )
     ( v1  h   a   a   a )
     ( v1  v2  a   a   a )
     ( v1  v2  a   a   a )

  where a denotes an element of the original matrix A, h denotes a
  modified element of the upper Hessenberg matrix H, and vi denotes an

  element of the vector defining H(i).

  This file is a slight modification of LAPACK-3.0's DLAHRD
  incorporating improvements proposed by Quintana-Orti and Van de
  Gejin. Note that the entries of A(1:K,2:NB) differ from those
  returned by the original LAPACK routine. This function is
  not backward compatible with LAPACK3.0.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param k
	 * @param nb
	 * @param a
	 * @param lda
	 * @param tau
	 * @param t
	 * @param ldt
	 * @param y
	 * @param ldy
	 */
	public void dlahr2(int n, int k, int nb, double[] a, int lda, double[] tau, double[] t, int ldt, double[] y, int ldy) {
		org.netlib.lapack.Dlahr2.dlahr2(n, k, nb, a, 0, lda, tau, 0, t, 0, ldt, y, 0, ldy);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLAHRD reduces the first NB columns of a real general n-by-(n-k+1)
  matrix A so that elements below the k-th subdiagonal are zero. The
  reduction is performed by an orthogonal similarity transformation
  Q' * A * Q. The routine returns the matrices V and T which determine

  Q as a block reflector I - V*T*V', and also the matrix Y = A * V * T.

  This is an OBSOLETE auxiliary routine. 
  This routine will be 'deprecated' in a  future release.
  Please use the new routine DLAHR2 instead.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.

  K       (input) INTEGER
          The offset for the reduction. Elements below the k-th
          subdiagonal in the first NB columns are reduced to zero.

  NB      (input) INTEGER
          The number of columns to be reduced.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N-K+1)

          On entry, the n-by-(n-k+1) general matrix A.
          On exit, the elements on and above the k-th subdiagonal in
          the first NB columns are overwritten with the corresponding
          elements of the reduced matrix; the elements below the k-th
          subdiagonal, with the array TAU, represent the matrix Q as a

          product of elementary reflectors. The other columns of A are

          unchanged. See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  TAU     (output) DOUBLE PRECISION array, dimension (NB)
          The scalar factors of the elementary reflectors. See Further

          Details.

  T       (output) DOUBLE PRECISION array, dimension (LDT,NB)
          The upper triangular matrix T.

  LDT     (input) INTEGER
          The leading dimension of the array T.  LDT >= NB.

  Y       (output) DOUBLE PRECISION array, dimension (LDY,NB)
          The n-by-nb matrix Y.

  LDY     (input) INTEGER
          The leading dimension of the array Y. LDY >= N.

  Further Details
  ===============

  The matrix Q is represented as a product of nb elementary reflectors


     Q = H(1) H(2) . . . H(nb).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i+k-1) = 0, v(i+k) = 1; v(i+k+1:n) is stored on exit in
  A(i+k+1:n,i), and tau in TAU(i).

  The elements of the vectors v together form the (n-k+1)-by-nb matrix

  V which is needed, with T and Y, to apply the transformation to the
  unreduced part of the matrix, using an update of the form:
  A := (I - V*T*V') * (A - Y*V').

  The contents of A on exit are illustrated by the following example
  with n = 7, k = 3 and nb = 2:

     ( a   h   a   a   a )
     ( a   h   a   a   a )
     ( a   h   a   a   a )
     ( h   h   a   a   a )
     ( v1  h   a   a   a )
     ( v1  v2  a   a   a )
     ( v1  v2  a   a   a )

  where a denotes an element of the original matrix A, h denotes a
  modified element of the upper Hessenberg matrix H, and vi denotes an

  element of the vector defining H(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param k
	 * @param nb
	 * @param a
	 * @param lda
	 * @param tau
	 * @param t
	 * @param ldt
	 * @param y
	 * @param ldy
	 */
	public abstract void dlahrd(int n, int k, int nb, double[] a, int lda, double[] tau, double[] t, int ldt, double[] y, int ldy);

	/**
<pre>

     ..

  Purpose
  =======

  DLAIC1 applies one step of incremental condition estimation in
  its simplest version:

  Let x, twonorm(x) = 1, be an approximate singular vector of an j-by-j
  lower triangular matrix L, such that
           twonorm(L*x) = sest
  Then DLAIC1 computes sestpr, s, c such that
  the vector
                  [ s*x ]
           xhat = [  c  ]
  is an approximate singular vector of
                  [ L     0  ]
           Lhat = [ w' gamma ]
  in the sense that
           twonorm(Lhat*xhat) = sestpr.

  Depending on JOB, an estimate for the largest or smallest singular
  value is computed.

  Note that [s c]' and sestpr**2 is an eigenpair of the system

      diag(sest*sest, 0) + [alpha  gamma] * [ alpha ]
                                            [ gamma ]

  where  alpha =  x'*w.

  Arguments
  =========

  JOB     (input) INTEGER
          = 1: an estimate for the largest singular value is computed.

          = 2: an estimate for the smallest singular value is computed.

  J       (input) INTEGER
          Length of X and W

  X       (input) DOUBLE PRECISION array, dimension (J)
          The j-vector x.

  SEST    (input) DOUBLE PRECISION
          Estimated singular value of j by j matrix L

  W       (input) DOUBLE PRECISION array, dimension (J)
          The j-vector w.

  GAMMA   (input) DOUBLE PRECISION
          The diagonal element gamma.

  SESTPR  (output) DOUBLE PRECISION
          Estimated singular value of (j+1) by (j+1) matrix Lhat.

  S       (output) DOUBLE PRECISION
          Sine needed in forming xhat.

  C       (output) DOUBLE PRECISION
          Cosine needed in forming xhat.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param job
	 * @param j
	 * @param x
	 * @param sest
	 * @param w
	 * @param gamma
	 * @param sestpr
	 * @param s
	 * @param c
	 */
	public abstract void dlaic1(int job, int j, double[] x, double sest, double[] w, double gamma, doubleW sestpr, doubleW s, doubleW c);

		/**
<pre>

     ..

  Purpose
  =======

  This routine is not for general use.  It exists solely to avoid
  over-optimization in DISNAN.

  DLAISNAN checks for NaNs by comparing its two arguments for
  inequality.  NaN is the only floating-point value where NaN != NaN
  returns .TRUE.  To check for NaNs, pass the same variable as both
  arguments.

  Strictly speaking, Fortran does not allow aliasing of function
  arguments. So a compiler must assume that the two arguments are
  not the same variable, and the test will not be optimized away.
  Interprocedural or whole-program optimization may delete this
  test.  The ISNAN functions will be replaced by the correct
  Fortran 03 intrinsic once the intrinsic is widely available.

  Arguments
  =========

  DIN1     (input) DOUBLE PRECISION
  DIN2     (input) DOUBLE PRECISION
          Two numbers to compare for inequality.

  =====================================================================

  .. Executable Statements ..
</pre>
	 * @param din1
	 * @param din2
	 */
	public boolean dlaisnan(double din1, double din2) {
		return org.netlib.lapack.Dlaisnan.dlaisnan(din1, din2);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLALN2 solves a system of the form  (ca A - w D ) X = s B
  or (ca A' - w D) X = s B   with possible scaling ("s") and
  perturbation of A.  (A' means A-transpose.)

  A is an NA x NA real matrix, ca is a real scalar, D is an NA x NA
  real diagonal matrix, w is a real or complex value, and X and B are
  NA x 1 matrices -- real if w is real, complex if w is complex.  NA
  may be 1 or 2.

  If w is complex, X and B are represented as NA x 2 matrices,
  the first column of each being the real part and the second
  being the imaginary part.

  "s" is a scaling factor (.LE. 1), computed by DLALN2, which is
  so chosen that X can be computed without overflow.  X is further
  scaled if necessary to assure that norm(ca A - w D)*norm(X) is less
  than overflow.

  If both singular values of (ca A - w D) are less than SMIN,
  SMIN*identity will be used instead of (ca A - w D).  If only one
  singular value is less than SMIN, one element of (ca A - w D) will be
  perturbed enough to make the smallest singular value roughly SMIN.
  If both singular values are at least SMIN, (ca A - w D) will not be
  perturbed.  In any case, the perturbation will be at most some small

  multiple of max( SMIN, ulp*norm(ca A - w D) ).  The singular values
  are computed by infinity-norm approximations, and thus will only be
  correct to a factor of 2 or so.

  Note: all input quantities are assumed to be smaller than overflow
  by a reasonable factor.  (See BIGNUM.)

  Arguments
  ==========

  LTRANS  (input) LOGICAL
          =.TRUE.:  A-transpose will be used.
          =.FALSE.: A will be used (not transposed.)

  NA      (input) INTEGER
          The size of the matrix A.  It may (only) be 1 or 2.

  NW      (input) INTEGER
          1 if "w" is real, 2 if "w" is complex.  It may only be 1
          or 2.

  SMIN    (input) DOUBLE PRECISION
          The desired lower bound on the singular values of A.  This
          should be a safe distance away from underflow or overflow,
          say, between (underflow/machine precision) and  (machine
          precision * overflow ).  (See BIGNUM and ULP.)

  CA      (input) DOUBLE PRECISION
          The coefficient c, which A is multiplied by.

  A       (input) DOUBLE PRECISION array, dimension (LDA,NA)
          The NA x NA matrix A.

  LDA     (input) INTEGER
          The leading dimension of A.  It must be at least NA.

  D1      (input) DOUBLE PRECISION
          The 1,1 element in the diagonal matrix D.

  D2      (input) DOUBLE PRECISION
          The 2,2 element in the diagonal matrix D.  Not used if NW=1.


  B       (input) DOUBLE PRECISION array, dimension (LDB,NW)
          The NA x NW matrix B (right-hand side).  If NW=2 ("w" is
          complex), column 1 contains the real part of B and column 2
          contains the imaginary part.

  LDB     (input) INTEGER
          The leading dimension of B.  It must be at least NA.

  WR      (input) DOUBLE PRECISION
          The real part of the scalar "w".

  WI      (input) DOUBLE PRECISION
          The imaginary part of the scalar "w".  Not used if NW=1.

  X       (output) DOUBLE PRECISION array, dimension (LDX,NW)
          The NA x NW matrix X (unknowns), as computed by DLALN2.
          If NW=2 ("w" is complex), on exit, column 1 will contain
          the real part of X and column 2 will contain the imaginary
          part.

  LDX     (input) INTEGER
          The leading dimension of X.  It must be at least NA.

  SCALE   (output) DOUBLE PRECISION
          The scale factor that B must be multiplied by to insure
          that overflow does not occur when computing X.  Thus,
          (ca A - w D) X  will be SCALE*B, not B (ignoring
          perturbations of A.)  It will be at most 1.

  XNORM   (output) DOUBLE PRECISION
          The infinity-norm of X, when X is regarded as an NA x NW
          real matrix.

  INFO    (output) INTEGER
          An error flag.  It will be set to zero if no error occurs,
          a negative number if an argument is in error, or a positive
          number if  ca A - w D  had to be perturbed.
          The possible values are:
          = 0: No error occurred, and (ca A - w D) did not have to be
                 perturbed.
          = 1: (ca A - w D) had to be perturbed to make its smallest
               (or only) singular value greater than SMIN.
          NOTE: In the interests of speed, this routine does not
                check the inputs for errors.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param ltrans
	 * @param na
	 * @param nw
	 * @param smin
	 * @param ca
	 * @param a
	 * @param lda
	 * @param d1
	 * @param d2
	 * @param b
	 * @param ldb
	 * @param wr
	 * @param wi
	 * @param x
	 * @param ldx
	 * @param scale
	 * @param xnorm
	 * @param info
	 */
	public abstract void dlaln2(boolean ltrans, int na, int nw, double smin, double ca, double[] a, int lda, double d1, double d2, double[] b, int ldb, double wr, double wi, double[] x, int ldx, doubleW scale, doubleW xnorm, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLALS0 applies back the multiplying factors of either the left or the
  right singular vector matrix of a diagonal matrix appended by a row
  to the right hand side matrix B in solving the least squares problem

  using the divide-and-conquer SVD approach.

  For the left singular vector matrix, three types of orthogonal
  matrices are involved:

  (1L) Givens rotations: the number of such rotations is GIVPTR; the
       pairs of columns/rows they were applied to are stored in GIVCOL;
       and the C- and S-values of these rotations are stored in GIVNUM.

  (2L) Permutation. The (NL+1)-st row of B is to be moved to the first

       row, and for J=2:N, PERM(J)-th row of B is to be moved to the
       J-th row.

  (3L) The left singular vector matrix of the remaining matrix.

  For the right singular vector matrix, four types of orthogonal
  matrices are involved:

  (1R) The right singular vector matrix of the remaining matrix.

  (2R) If SQRE = 1, one extra Givens rotation to generate the right
       null space.

  (3R) The inverse transformation of (2L).

  (4R) The inverse transformation of (1L).

  Arguments
  =========

  ICOMPQ (input) INTEGER
         Specifies whether singular vectors are to be computed in
         factored form:
         = 0: Left singular vector matrix.
         = 1: Right singular vector matrix.

  NL     (input) INTEGER
         The row dimension of the upper block. NL >= 1.

  NR     (input) INTEGER
         The row dimension of the lower block. NR >= 1.

  SQRE   (input) INTEGER
         = 0: the lower block is an NR-by-NR square matrix.
         = 1: the lower block is an NR-by-(NR+1) rectangular matrix.

         The bidiagonal matrix has row dimension N = NL + NR + 1,
         and column dimension M = N + SQRE.

  NRHS   (input) INTEGER
         The number of columns of B and BX. NRHS must be at least 1.

  B      (input/output) DOUBLE PRECISION array, dimension ( LDB, NRHS )
         On input, B contains the right hand sides of the least
         squares problem in rows 1 through M. On output, B contains
         the solution X in rows 1 through N.

  LDB    (input) INTEGER
         The leading dimension of B. LDB must be at least
         max(1,MAX( M, N ) ).

  BX     (workspace) DOUBLE PRECISION array, dimension ( LDBX, NRHS )

  LDBX   (input) INTEGER
         The leading dimension of BX.

  PERM   (input) INTEGER array, dimension ( N )
         The permutations (from deflation and sorting) applied
         to the two blocks.

  GIVPTR (input) INTEGER
         The number of Givens rotations which took place in this
         subproblem.

  GIVCOL (input) INTEGER array, dimension ( LDGCOL, 2 )
         Each pair of numbers indicates a pair of rows/columns
         involved in a Givens rotation.

  LDGCOL (input) INTEGER
         The leading dimension of GIVCOL, must be at least N.

  GIVNUM (input) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
         Each number indicates the C or S value used in the
         corresponding Givens rotation.

  LDGNUM (input) INTEGER
         The leading dimension of arrays DIFR, POLES and
         GIVNUM, must be at least K.

  POLES  (input) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
         On entry, POLES(1:K, 1) contains the new singular
         values obtained from solving the secular equation, and
         POLES(1:K, 2) is an array containing the poles in the secular

         equation.

  DIFL   (input) DOUBLE PRECISION array, dimension ( K ).
         On entry, DIFL(I) is the distance between I-th updated
         (undeflated) singular value and the I-th (undeflated) old
         singular value.

  DIFR   (input) DOUBLE PRECISION array, dimension ( LDGNUM, 2 ).
         On entry, DIFR(I, 1) contains the distances between I-th
         updated (undeflated) singular value and the I+1-th
         (undeflated) old singular value. And DIFR(I, 2) is the
         normalizing factor for the I-th right singular vector.

  Z      (input) DOUBLE PRECISION array, dimension ( K )
         Contain the components of the deflation-adjusted updating row

         vector.

  K      (input) INTEGER
         Contains the dimension of the non-deflated matrix,
         This is the order of the related secular equation. 1 <= K <=N.

  C      (input) DOUBLE PRECISION
         C contains garbage if SQRE =0 and the C-value of a Givens
         rotation related to the right null space if SQRE = 1.

  S      (input) DOUBLE PRECISION
         S contains garbage if SQRE =0 and the S-value of a Givens
         rotation related to the right null space if SQRE = 1.

  WORK   (workspace) DOUBLE PRECISION array, dimension ( K )

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Ren-Cang Li, Computer Science Division, University of

       California at Berkeley, USA
     Osni Marques, LBNL/NERSC, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param nl
	 * @param nr
	 * @param sqre
	 * @param nrhs
	 * @param b
	 * @param ldb
	 * @param bx
	 * @param ldbx
	 * @param perm
	 * @param givptr
	 * @param givcol
	 * @param ldgcol
	 * @param givnum
	 * @param ldgnum
	 * @param poles
	 * @param difl
	 * @param difr
	 * @param z
	 * @param k
	 * @param c
	 * @param s
	 * @param work
	 * @param info
	 */
	public abstract void dlals0(int icompq, int nl, int nr, int sqre, int nrhs, double[] b, int ldb, double[] bx, int ldbx, int[] perm, int givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, double[] poles, double[] difl, double[] difr, double[] z, int k, double c, double s, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLALSA is an itermediate step in solving the least squares problem
  by computing the SVD of the coefficient matrix in compact form (The
  singular vectors are computed as products of simple orthorgonal
  matrices.).

  If ICOMPQ = 0, DLALSA applies the inverse of the left singular vector
  matrix of an upper bidiagonal matrix to the right hand side; and if
  ICOMPQ = 1, DLALSA applies the right singular vector matrix to the
  right hand side. The singular vector matrices were generated in
  compact form by DLALSA.

  Arguments
  =========


  ICOMPQ (input) INTEGER
         Specifies whether the left or the right singular vector
         matrix is involved.
         = 0: Left singular vector matrix
         = 1: Right singular vector matrix

  SMLSIZ (input) INTEGER
         The maximum size of the subproblems at the bottom of the
         computation tree.

  N      (input) INTEGER
         The row and column dimensions of the upper bidiagonal matrix.


  NRHS   (input) INTEGER
         The number of columns of B and BX. NRHS must be at least 1.

  B      (input/output) DOUBLE PRECISION array, dimension ( LDB, NRHS )
         On input, B contains the right hand sides of the least
         squares problem in rows 1 through M.
         On output, B contains the solution X in rows 1 through N.

  LDB    (input) INTEGER
         The leading dimension of B in the calling subprogram.
         LDB must be at least max(1,MAX( M, N ) ).

  BX     (output) DOUBLE PRECISION array, dimension ( LDBX, NRHS )
         On exit, the result of applying the left or right singular
         vector matrix to B.

  LDBX   (input) INTEGER
         The leading dimension of BX.

  U      (input) DOUBLE PRECISION array, dimension ( LDU, SMLSIZ ).
         On entry, U contains the left singular vector matrices of all

         subproblems at the bottom level.

  LDU    (input) INTEGER, LDU = > N.
         The leading dimension of arrays U, VT, DIFL, DIFR,
         POLES, GIVNUM, and Z.

  VT     (input) DOUBLE PRECISION array, dimension ( LDU, SMLSIZ+1 ).
         On entry, VT' contains the right singular vector matrices of
         all subproblems at the bottom level.

  K      (input) INTEGER array, dimension ( N ).

  DIFL   (input) DOUBLE PRECISION array, dimension ( LDU, NLVL ).
         where NLVL = INT(log_2 (N/(SMLSIZ+1))) + 1.

  DIFR   (input) DOUBLE PRECISION array, dimension ( LDU, 2 * NLVL ).
         On entry, DIFL(*, I) and DIFR(*, 2 * I -1) record
         distances between singular values on the I-th level and
         singular values on the (I -1)-th level, and DIFR(*, 2 * I)
         record the normalizing factors of the right singular vectors
         matrices of subproblems on I-th level.

  Z      (input) DOUBLE PRECISION array, dimension ( LDU, NLVL ).
         On entry, Z(1, I) contains the components of the deflation-
         adjusted updating row vector for subproblems on the I-th
         level.

  POLES  (input) DOUBLE PRECISION array, dimension ( LDU, 2 * NLVL ).
         On entry, POLES(*, 2 * I -1: 2 * I) contains the new and old
         singular values involved in the secular equations on the I-th

         level.

  GIVPTR (input) INTEGER array, dimension ( N ).
         On entry, GIVPTR( I ) records the number of Givens
         rotations performed on the I-th problem on the computation
         tree.

  GIVCOL (input) INTEGER array, dimension ( LDGCOL, 2 * NLVL ).
         On entry, for each I, GIVCOL(*, 2 * I - 1: 2 * I) records the

         locations of Givens rotations performed on the I-th level on
         the computation tree.

  LDGCOL (input) INTEGER, LDGCOL = > N.
         The leading dimension of arrays GIVCOL and PERM.

  PERM   (input) INTEGER array, dimension ( LDGCOL, NLVL ).
         On entry, PERM(*, I) records permutations done on the I-th
         level of the computation tree.

  GIVNUM (input) DOUBLE PRECISION array, dimension ( LDU, 2 * NLVL ).
         On entry, GIVNUM(*, 2 *I -1 : 2 * I) records the C- and S-
         values of Givens rotations performed on the I-th level on the

         computation tree.

  C      (input) DOUBLE PRECISION array, dimension ( N ).
         On entry, if the I-th subproblem is not square,
         C( I ) contains the C-value of a Givens rotation related to
         the right null space of the I-th subproblem.

  S      (input) DOUBLE PRECISION array, dimension ( N ).
         On entry, if the I-th subproblem is not square,
         S( I ) contains the S-value of a Givens rotation related to
         the right null space of the I-th subproblem.

  WORK   (workspace) DOUBLE PRECISION array.
         The dimension must be at least N.

  IWORK  (workspace) INTEGER array.
         The dimension must be at least 3 * N

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Ren-Cang Li, Computer Science Division, University of

       California at Berkeley, USA
     Osni Marques, LBNL/NERSC, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param smlsiz
	 * @param n
	 * @param nrhs
	 * @param b
	 * @param ldb
	 * @param bx
	 * @param ldbx
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param k
	 * @param difl
	 * @param difr
	 * @param z
	 * @param poles
	 * @param givptr
	 * @param givcol
	 * @param ldgcol
	 * @param perm
	 * @param givnum
	 * @param c
	 * @param s
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlalsa(int icompq, int smlsiz, int n, int nrhs, double[] b, int ldb, double[] bx, int ldbx, double[] u, int ldu, double[] vt, int[] k, double[] difl, double[] difr, double[] z, double[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, double[] givnum, double[] c, double[] s, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLALSD uses the singular value decomposition of A to solve the least

  squares problem of finding X to minimize the Euclidean norm of each
  column of A*X-B, where A is N-by-N upper bidiagonal, and X and B
  are N-by-NRHS. The solution X overwrites B.

  The singular values of A smaller than RCOND times the largest
  singular value are treated as zero in solving the least squares
  problem; in this case a minimum norm solution is returned.
  The actual singular values are returned in D in ascending order.

  This code makes very mild assumptions about floating point
  arithmetic. It will work on machines with a guard digit in
  add/subtract, or on those binary machines without guard digits
  which subtract like the Cray XMP, Cray YMP, Cray C 90, or Cray 2.
  It could conceivably fail on hexadecimal or decimal machines
  without guard digits, but we know of none.

  Arguments
  =========

  UPLO   (input) CHARACTER*1
         = 'U': D and E define an upper bidiagonal matrix.
         = 'L': D and E define a  lower bidiagonal matrix.

  SMLSIZ (input) INTEGER
         The maximum size of the subproblems at the bottom of the
         computation tree.

  N      (input) INTEGER
         The dimension of the  bidiagonal matrix.  N >= 0.

  NRHS   (input) INTEGER
         The number of columns of B. NRHS must be at least 1.

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry D contains the main diagonal of the bidiagonal
         matrix. On exit, if INFO = 0, D contains its singular values.


  E      (input/output) DOUBLE PRECISION array, dimension (N-1)
         Contains the super-diagonal entries of the bidiagonal matrix.

         On exit, E has been destroyed.

  B      (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
         On input, B contains the right hand sides of the least
         squares problem. On output, B contains the solution X.

  LDB    (input) INTEGER
         The leading dimension of B in the calling subprogram.
         LDB must be at least max(1,N).

  RCOND  (input) DOUBLE PRECISION
         The singular values of A less than or equal to RCOND times
         the largest singular value are treated as zero in solving
         the least squares problem. If RCOND is negative,
         machine precision is used instead.
         For example, if diag(S)*X=B were the least squares problem,
         where diag(S) is a diagonal matrix of singular values, the
         solution would be X(i) = B(i) / S(i) if S(i) is greater than
         RCOND*max(S), and X(i) = 0 if S(i) is less than or equal to
         RCOND*max(S).

  RANK   (output) INTEGER
         The number of singular values of A greater than RCOND times
         the largest singular value.

  WORK   (workspace) DOUBLE PRECISION array, dimension at least
         (9*N + 2*N*SMLSIZ + 8*N*NLVL + N*NRHS + (SMLSIZ+1)**2),
         where NLVL = max(0, INT(log_2 (N/(SMLSIZ+1))) + 1).

  IWORK  (workspace) INTEGER array, dimension at least
         (3*N*NLVL + 11*N)

  INFO   (output) INTEGER
         = 0:  successful exit.
         < 0:  if INFO = -i, the i-th argument had an illegal value.
         > 0:  The algorithm failed to compute an singular value while

               working on the submatrix lying in rows and columns
               INFO/(N+1) through MOD(INFO,N+1).

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Ren-Cang Li, Computer Science Division, University of

       California at Berkeley, USA
     Osni Marques, LBNL/NERSC, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param smlsiz
	 * @param n
	 * @param nrhs
	 * @param d
	 * @param e
	 * @param b
	 * @param ldb
	 * @param rcond
	 * @param rank
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlalsd(String uplo, int smlsiz, int n, int nrhs, double[] d, double[] e, double[] b, int ldb, double rcond, intW rank, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAMRG will create a permutation list which will merge the elements
  of A (which is composed of two independently sorted sets) into a
  single set which is sorted in ascending order.

  Arguments
  =========

  N1     (input) INTEGER
  N2     (input) INTEGER
         These arguements contain the respective lengths of the two
         sorted lists to be merged.

  A      (input) DOUBLE PRECISION array, dimension (N1+N2)
         The first N1 elements of A contain a list of numbers which
         are sorted in either ascending or descending order.  Likewise

         for the final N2 elements.

  DTRD1  (input) INTEGER
  DTRD2  (input) INTEGER
         These are the strides to be taken through the array A.
         Allowable strides are 1 and -1.  They indicate whether a
         subset of A is sorted in ascending (DTRDx = 1) or descending
         (DTRDx = -1) order.

  INDEX  (output) INTEGER array, dimension (N1+N2)
         On exit this array will contain a permutation such that
         if B( I ) = A( INDEX( I ) ) for I=1,N1+N2, then B will be
         sorted in ascending order.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n1
	 * @param n2
	 * @param a
	 * @param dtrd1
	 * @param dtrd2
	 * @param index
	 */
	public abstract void dlamrg(int n1, int n2, double[] a, int dtrd1, int dtrd2, int[] index);

		/**
<pre>

     ..

  Purpose
  =======

  DLANEG computes the Sturm count, the number of negative pivots
  encountered while factoring tridiagonal T - sigma I = L D L^T.
  This implementation works directly on the factors without forming
  the tridiagonal matrix T.  The Sturm count is also the number of
  eigenvalues of T less than sigma.

  This routine is called from DLARRB.

  The current routine does not use the PIVMIN parameter but rather
  requires IEEE-754 propagation of Infinities and NaNs.  This
  routine also has no input range restrictions but does require
  default exception handling such that x/0 produces Inf when x is
  non-zero, and Inf/Inf produces NaN.  For more information, see:

    Marques, Riedy, and Voemel, "Benefits of IEEE-754 Features in
    Modern Symmetric Tridiagonal Eigensolvers," SIAM Journal on
    Scientific Computing, v28, n5, 2006.  DOI 10.1137/050641624
    (Tech report version in LAWN 172 with the same title.)

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The N diagonal elements of the diagonal matrix D.

  LLD     (input) DOUBLE PRECISION array, dimension (N-1)
          The (N-1) elements L(i)*L(i)*D(i).

  SIGMA   (input) DOUBLE PRECISION
          Shift amount in T - sigma I = L D L^T.

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot in the Sturm sequence.  May be used
          when zero pivots are encountered on non-IEEE-754
          architectures.

  R       (input) INTEGER
          The twist index for the twisted factorization that is used
          for the negcount.

  Further Details
  ===============

  Based on contributions by
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA
     Jason Riedy, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param lld
	 * @param sigma
	 * @param pivmin
	 * @param r
	 */
	public int dlaneg(int n, double[] d, double[] lld, double sigma, double pivmin, int r) {
		return org.netlib.lapack.Dlaneg.dlaneg(n, d, 0, lld, 0, sigma, pivmin, r);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANGB  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the element of  largest absolute value  of an
  n by n band matrix  A,  with kl sub-diagonals and ku super-diagonals.

  Description
  ===========

  DLANGB returns the value

     DLANGB = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANGB as described
          above.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANGB is
          set to zero.

  KL      (input) INTEGER
          The number of sub-diagonals of the matrix A.  KL >= 0.

  KU      (input) INTEGER
          The number of super-diagonals of the matrix A.  KU >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The band matrix A, stored in rows 1 to KL+KU+1.  The j-th
          column of A is stored in the j-th column of the array AB as
          follows:
          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(n,j+kl).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KL+KU+1.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I'; otherwise, WORK is not
          referenced.

 =====================================================================



     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param work
	 */
	public double dlangb(String norm, int n, int kl, int ku, double[] ab, int ldab, double[] work) {
		return org.netlib.lapack.Dlangb.dlangb(norm, n, kl, ku, ab, 0, ldab, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANGE  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  real matrix A.

  Description
  ===========

  DLANGE returns the value

     DLANGE = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANGE as described
          above.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.  When M = 0,
          DLANGE is set to zero.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.  When N = 0,

          DLANGE is set to zero.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The m by n matrix A.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(M,1).

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= M when NORM = 'I'; otherwise, WORK is not
          referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param work
	 */
	public double dlange(String norm, int m, int n, double[] a, int lda, double[] work) {
		return org.netlib.lapack.Dlange.dlange(norm, m, n, a, 0, lda, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANGT  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  real tridiagonal matrix A.

  Description
  ===========

  DLANGT returns the value

     DLANGT = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANGT as described
          above.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANGT is
          set to zero.

  DL      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) sub-diagonal elements of A.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The diagonal elements of A.

  DU      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) super-diagonal elements of A.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param dl
	 * @param d
	 * @param du
	 */
	public double dlangt(String norm, int n, double[] dl, double[] d, double[] du) {
		return org.netlib.lapack.Dlangt.dlangt(norm, n, dl, 0, d, 0, du, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANHS  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  Hessenberg matrix A.

  Description
  ===========

  DLANHS returns the value

     DLANHS = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANHS as described
          above.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANHS is
          set to zero.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The n by n upper Hessenberg matrix A; the part of A below the
          first sub-diagonal is not referenced.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(N,1).

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I'; otherwise, WORK is not
          referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param a
	 * @param lda
	 * @param work
	 */
	public double dlanhs(String norm, int n, double[] a, int lda, double[] work) {
		return org.netlib.lapack.Dlanhs.dlanhs(norm, n, a, 0, lda, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANSB  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the element of  largest absolute value  of an
  n by n symmetric band matrix A,  with k super-diagonals.

  Description
  ===========

  DLANSB returns the value

     DLANSB = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANSB as described
          above.

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          band matrix A is supplied.
          = 'U':  Upper triangular part is supplied
          = 'L':  Lower triangular part is supplied

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANSB is
          set to zero.

  K       (input) INTEGER
          The number of super-diagonals or sub-diagonals of the
          band matrix A.  K >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The upper or lower triangle of the symmetric band matrix A,
          stored in the first K+1 rows of AB.  The j-th column of A is

          stored in the j-th column of the array AB as follows:
          if UPLO = 'U', AB(k+1+i-j,j) = A(i,j) for max(1,j-k)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)   = A(i,j) for j<=i<=min(n,j+k).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= K+1.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,
          WORK is not referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param uplo
	 * @param n
	 * @param k
	 * @param ab
	 * @param ldab
	 * @param work
	 */
	public double dlansb(String norm, String uplo, int n, int k, double[] ab, int ldab, double[] work) {
		return org.netlib.lapack.Dlansb.dlansb(norm, uplo, n, k, ab, 0, ldab, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANSP  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  real symmetric matrix A,  supplied in packed form.

  Description
  ===========

  DLANSP returns the value

     DLANSP = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANSP as described
          above.

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is supplied.
          = 'U':  Upper triangular part of A is supplied
          = 'L':  Lower triangular part of A is supplied

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANSP is
          set to zero.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The upper or lower triangle of the symmetric matrix A, packed
          columnwise in a linear array.  The j-th column of A is stored
          in the array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,
          WORK is not referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param work
	 */
	public double dlansp(String norm, String uplo, int n, double[] ap, double[] work) {
		return org.netlib.lapack.Dlansp.dlansp(norm, uplo, n, ap, 0, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANST  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  real symmetric tridiagonal matrix A.

  Description
  ===========

  DLANST returns the value

     DLANST = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANST as described
          above.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANST is
          set to zero.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The diagonal elements of A.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) sub-diagonal or super-diagonal elements of A.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param norm
	 * @param n
	 * @param d
	 * @param e
	 */
	public double dlanst(String norm, int n, double[] d, double[] e) {
		return org.netlib.lapack.Dlanst.dlanst(norm, n, d, 0, e, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANSY  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  real symmetric matrix A.

  Description
  ===========

  DLANSY returns the value

     DLANSY = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANSY as described
          above.

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is to be referenced.
          = 'U':  Upper triangular part of A is referenced
          = 'L':  Lower triangular part of A is referenced

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANSY is
          set to zero.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The symmetric matrix A.  If UPLO = 'U', the leading n by n
          upper triangular part of A contains the upper triangular part
          of the matrix A, and the strictly lower triangular part of A

          is not referenced.  If UPLO = 'L', the leading n by n lower
          triangular part of A contains the lower triangular part of
          the matrix A, and the strictly upper triangular part of A is

          not referenced.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(N,1).

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I' or '1' or 'O'; otherwise,
          WORK is not referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param work
	 */
	public double dlansy(String norm, String uplo, int n, double[] a, int lda, double[] work) {
		return org.netlib.lapack.Dlansy.dlansy(norm, uplo, n, a, 0, lda, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANTB  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the element of  largest absolute value  of an
  n by n triangular band matrix A,  with ( k + 1 ) diagonals.

  Description
  ===========

  DLANTB returns the value

     DLANTB = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANTB as described
          above.

  UPLO    (input) CHARACTER*1
          Specifies whether the matrix A is upper or lower triangular.

          = 'U':  Upper triangular
          = 'L':  Lower triangular

  DIAG    (input) CHARACTER*1
          Specifies whether or not the matrix A is unit triangular.
          = 'N':  Non-unit triangular
          = 'U':  Unit triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANTB is
          set to zero.

  K       (input) INTEGER
          The number of super-diagonals of the matrix A if UPLO = 'U',

          or the number of sub-diagonals of the matrix A if UPLO = 'L'.
          K >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The upper or lower triangular band matrix A, stored in the
          first k+1 rows of AB.  The j-th column of A is stored
          in the j-th column of the array AB as follows:
          if UPLO = 'U', AB(k+1+i-j,j) = A(i,j) for max(1,j-k)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)   = A(i,j) for j<=i<=min(n,j+k).
          Note that when DIAG = 'U', the elements of the array AB
          corresponding to the diagonal elements of the matrix A are
          not referenced, but are assumed to be one.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= K+1.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I'; otherwise, WORK is not
          referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param uplo
	 * @param diag
	 * @param n
	 * @param k
	 * @param ab
	 * @param ldab
	 * @param work
	 */
	public double dlantb(String norm, String uplo, String diag, int n, int k, double[] ab, int ldab, double[] work) {
		return org.netlib.lapack.Dlantb.dlantb(norm, uplo, diag, n, k, ab, 0, ldab, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANTP  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  triangular matrix A, supplied in packed form.

  Description
  ===========

  DLANTP returns the value

     DLANTP = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANTP as described
          above.

  UPLO    (input) CHARACTER*1
          Specifies whether the matrix A is upper or lower triangular.

          = 'U':  Upper triangular
          = 'L':  Lower triangular

  DIAG    (input) CHARACTER*1
          Specifies whether or not the matrix A is unit triangular.
          = 'N':  Non-unit triangular
          = 'U':  Unit triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.  When N = 0, DLANTP is
          set to zero.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The upper or lower triangular matrix A, packed columnwise in

          a linear array.  The j-th column of A is stored in the array

          AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.
          Note that when DIAG = 'U', the elements of the array AP
          corresponding to the diagonal elements of the matrix A are
          not referenced, but are assumed to be one.

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= N when NORM = 'I'; otherwise, WORK is not
          referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param uplo
	 * @param diag
	 * @param n
	 * @param ap
	 * @param work
	 */
	public double dlantp(String norm, String uplo, String diag, int n, double[] ap, double[] work) {
		return org.netlib.lapack.Dlantp.dlantp(norm, uplo, diag, n, ap, 0, work, 0);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLANTR  returns the value of the one norm,  or the Frobenius norm, or
  the  infinity norm,  or the  element of  largest absolute value  of a
  trapezoidal or triangular matrix A.

  Description
  ===========

  DLANTR returns the value

     DLANTR = ( max(abs(A(i,j))), NORM = 'M' or 'm'
              (
              ( norm1(A),         NORM = '1', 'O' or 'o'
              (
              ( normI(A),         NORM = 'I' or 'i'
              (
              ( normF(A),         NORM = 'F', 'f', 'E' or 'e'

  where  norm1  denotes the  one norm of a matrix (maximum column sum),
  normI  denotes the  infinity norm  of a matrix  (maximum row sum) and
  normF  denotes the  Frobenius norm of a matrix (square root of sum of
  squares).  Note that  max(abs(A(i,j)))  is not a consistent matrix no

  Arguments
  =========

  NORM    (input) CHARACTER*1
          Specifies the value to be returned in DLANTR as described
          above.

  UPLO    (input) CHARACTER*1
          Specifies whether the matrix A is upper or lower trapezoidal.
          = 'U':  Upper trapezoidal
          = 'L':  Lower trapezoidal
          Note that A is triangular instead of trapezoidal if M = N.

  DIAG    (input) CHARACTER*1
          Specifies whether or not the matrix A has unit diagonal.
          = 'N':  Non-unit diagonal
          = 'U':  Unit diagonal

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0, and if
          UPLO = 'U', M <= N.  When M = 0, DLANTR is set to zero.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0, and if
          UPLO = 'L', N <= M.  When N = 0, DLANTR is set to zero.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The trapezoidal matrix A (A is triangular if M = N).
          If UPLO = 'U', the leading m by n upper trapezoidal part of
          the array A contains the upper trapezoidal matrix, and the
          strictly lower triangular part of A is not referenced.
          If UPLO = 'L', the leading m by n lower trapezoidal part of
          the array A contains the lower trapezoidal matrix, and the
          strictly upper triangular part of A is not referenced.  Note

          that when DIAG = 'U', the diagonal elements of A are not
          referenced and are assumed to be one.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(M,1).

  WORK    (workspace) DOUBLE PRECISION array, dimension (MAX(1,LWORK)),
          where LWORK >= M when NORM = 'I'; otherwise, WORK is not
          referenced.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param norm
	 * @param uplo
	 * @param diag
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param work
	 */
	public double dlantr(String norm, String uplo, String diag, int m, int n, double[] a, int lda, double[] work) {
		return org.netlib.lapack.Dlantr.dlantr(norm, uplo, diag, m, n, a, 0, lda, work, 0);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLANV2 computes the Schur factorization of a real 2-by-2 nonsymmetric
  matrix in standard form:

       [ A  B ] = [ CS -SN ] [ AA  BB ] [ CS  SN ]
       [ C  D ]   [ SN  CS ] [ CC  DD ] [-SN  CS ]

  where either
  1) CC = 0 so that AA and DD are real eigenvalues of the matrix, or
  2) AA = DD and BB*CC < 0, so that AA + or - sqrt(BB*CC) are complex
  conjugate eigenvalues.

  Arguments
  =========

  A       (input/output) DOUBLE PRECISION
  B       (input/output) DOUBLE PRECISION
  C       (input/output) DOUBLE PRECISION
  D       (input/output) DOUBLE PRECISION
          On entry, the elements of the input matrix.
          On exit, they are overwritten by the elements of the
          standardised Schur form.

  RT1R    (output) DOUBLE PRECISION
  RT1I    (output) DOUBLE PRECISION
  RT2R    (output) DOUBLE PRECISION
  RT2I    (output) DOUBLE PRECISION
          The real and imaginary parts of the eigenvalues. If the
          eigenvalues are a complex conjugate pair, RT1I > 0.

  CS      (output) DOUBLE PRECISION
  SN      (output) DOUBLE PRECISION
          Parameters of the rotation matrix.

  Further Details
  ===============

  Modified by V. Sima, Research Institute for Informatics, Bucharest,
  Romania, to reduce the risk of cancellation errors,
  when computing real eigenvalues, and to ensure, if possible, that
  abs(RT1R) >= abs(RT2R).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param a
	 * @param b
	 * @param c
	 * @param d
	 * @param rt1r
	 * @param rt1i
	 * @param rt2r
	 * @param rt2i
	 * @param cs
	 * @param sn
	 */
	public abstract void dlanv2(doubleW a, doubleW b, doubleW c, doubleW d, doubleW rt1r, doubleW rt1i, doubleW rt2r, doubleW rt2i, doubleW cs, doubleW sn);

	/**
<pre>

     ..

  Purpose
  =======

  Given two column vectors X and Y, let

                       A = ( X Y ).

  The subroutine first computes the QR factorization of A = Q*R,
  and then computes the SVD of the 2-by-2 upper triangular matrix R.
  The smaller singular value of R is returned in SSMIN, which is used
  as the measurement of the linear dependency of the vectors X and Y.

  Arguments
  =========

  N       (input) INTEGER
          The length of the vectors X and Y.

  X       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCX)
          On entry, X contains the N-vector X.
          On exit, X is overwritten.

  INCX    (input) INTEGER
          The increment between successive elements of X. INCX > 0.

  Y       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCY)
          On entry, Y contains the N-vector Y.
          On exit, Y is overwritten.

  INCY    (input) INTEGER
          The increment between successive elements of Y. INCY > 0.

  SSMIN   (output) DOUBLE PRECISION
          The smallest singular value of the N-by-2 matrix A = ( X Y ).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param x
	 * @param incx
	 * @param y
	 * @param incy
	 * @param ssmin
	 */
	public abstract void dlapll(int n, double[] x, int incx, double[] y, int incy, doubleW ssmin);

	/**
<pre>

     ..

  Purpose
  =======

  DLAPMT rearranges the columns of the M by N matrix X as specified
  by the permutation K(1),K(2),...,K(N) of the integers 1,...,N.
  If FORWRD = .TRUE.,  forward permutation:

       X(*,K(J)) is moved X(*,J) for J = 1,2,...,N.

  If FORWRD = .FALSE., backward permutation:

       X(*,J) is moved to X(*,K(J)) for J = 1,2,...,N.

  Arguments
  =========

  FORWRD  (input) LOGICAL
          = .TRUE., forward permutation
          = .FALSE., backward permutation

  M       (input) INTEGER
          The number of rows of the matrix X. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix X. N >= 0.

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,N)
          On entry, the M by N matrix X.
          On exit, X contains the permuted matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X, LDX >= MAX(1,M).

  K       (input/output) INTEGER array, dimension (N)
          On entry, K contains the permutation vector. K is used as
          internal workspace, but reset to its original value on
          output.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param forwrd
	 * @param m
	 * @param n
	 * @param x
	 * @param ldx
	 * @param k
	 */
	public abstract void dlapmt(boolean forwrd, int m, int n, double[] x, int ldx, int[] k);

		/**
<pre>

     ..

  Purpose
  =======

  DLAPY2 returns sqrt(x**2+y**2), taking care not to cause unnecessary

  overflow.

  Arguments
  =========

  X       (input) DOUBLE PRECISION
  Y       (input) DOUBLE PRECISION
          X and Y specify the values x and y.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param x
	 * @param y
	 */
	public double dlapy2(double x, double y) {
		return org.netlib.lapack.Dlapy2.dlapy2(x, y);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLAPY3 returns sqrt(x**2+y**2+z**2), taking care not to cause
  unnecessary overflow.

  Arguments
  =========

  X       (input) DOUBLE PRECISION
  Y       (input) DOUBLE PRECISION
  Z       (input) DOUBLE PRECISION
          X, Y and Z specify the values x, y and z.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param x
	 * @param y
	 * @param z
	 */
	public double dlapy3(double x, double y, double z) {
		return org.netlib.lapack.Dlapy3.dlapy3(x, y, z);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLAQGB equilibrates a general M by N band matrix A with KL
  subdiagonals and KU superdiagonals using the row and scaling factors

  in the vectors R and C.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  KL      (input) INTEGER
          The number of subdiagonals within the band of A.  KL >= 0.

  KU      (input) INTEGER
          The number of superdiagonals within the band of A.  KU >= 0.


  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the matrix A in band storage, in rows 1 to KL+KU+1.
          The j-th column of A is stored in the j-th column of the
          array AB as follows:
          AB(ku+1+i-j,j) = A(i,j) for max(1,j-ku)<=i<=min(m,j+kl)

          On exit, the equilibrated matrix, in the same storage format

          as A.  See EQUED for the form of the equilibrated matrix.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDA >= KL+KU+1.

  R       (input) DOUBLE PRECISION array, dimension (M)
          The row scale factors for A.

  C       (input) DOUBLE PRECISION array, dimension (N)
          The column scale factors for A.

  ROWCND  (input) DOUBLE PRECISION
          Ratio of the smallest R(i) to the largest R(i).

  COLCND  (input) DOUBLE PRECISION
          Ratio of the smallest C(i) to the largest C(i).

  AMAX    (input) DOUBLE PRECISION
          Absolute value of largest matrix entry.

  EQUED   (output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration
          = 'R':  Row equilibration, i.e., A has been premultiplied by

                  diag(R).
          = 'C':  Column equilibration, i.e., A has been postmultiplied
                  by diag(C).
          = 'B':  Both row and column equilibration, i.e., A has been
                  replaced by diag(R) * A * diag(C).

  Internal Parameters
  ===================

  THRESH is a threshold value used to decide if row or column scaling
  should be done based on the ratio of the row or column scaling
  factors.  If ROWCND < THRESH, row scaling is done, and if
  COLCND < THRESH, column scaling is done.

  LARGE and SMALL are threshold values used to decide if row scaling
  should be done based on the absolute size of the largest matrix
  element.  If AMAX > LARGE or AMAX < SMALL, row scaling is done.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param kl
	 * @param ku
	 * @param ab
	 * @param ldab
	 * @param r
	 * @param c
	 * @param rowcnd
	 * @param colcnd
	 * @param amax
	 * @param equed
	 */
	public abstract void dlaqgb(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, double rowcnd, double colcnd, double amax, StringW equed);

	/**
<pre>

     ..

  Purpose
  =======

  DLAQGE equilibrates a general M by N matrix A using the row and
  column scaling factors in the vectors R and C.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M by N matrix A.
          On exit, the equilibrated matrix.  See EQUED for the form of

          the equilibrated matrix.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(M,1).

  R       (input) DOUBLE PRECISION array, dimension (M)
          The row scale factors for A.

  C       (input) DOUBLE PRECISION array, dimension (N)
          The column scale factors for A.

  ROWCND  (input) DOUBLE PRECISION
          Ratio of the smallest R(i) to the largest R(i).

  COLCND  (input) DOUBLE PRECISION
          Ratio of the smallest C(i) to the largest C(i).

  AMAX    (input) DOUBLE PRECISION
          Absolute value of largest matrix entry.

  EQUED   (output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration
          = 'R':  Row equilibration, i.e., A has been premultiplied by

                  diag(R).
          = 'C':  Column equilibration, i.e., A has been postmultiplied
                  by diag(C).
          = 'B':  Both row and column equilibration, i.e., A has been
                  replaced by diag(R) * A * diag(C).

  Internal Parameters
  ===================

  THRESH is a threshold value used to decide if row or column scaling
  should be done based on the ratio of the row or column scaling
  factors.  If ROWCND < THRESH, row scaling is done, and if
  COLCND < THRESH, column scaling is done.

  LARGE and SMALL are threshold values used to decide if row scaling
  should be done based on the absolute size of the largest matrix
  element.  If AMAX > LARGE or AMAX < SMALL, row scaling is done.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param r
	 * @param c
	 * @param rowcnd
	 * @param colcnd
	 * @param amax
	 * @param equed
	 */
	public abstract void dlaqge(int m, int n, double[] a, int lda, double[] r, double[] c, double rowcnd, double colcnd, double amax, StringW equed);

	/**
<pre>

     ..

  Purpose
  =======

  DLAQP2 computes a QR factorization with column pivoting of
  the block A(OFFSET+1:M,1:N).
  The block A(1:OFFSET,1:N) is accordingly pivoted, but not factorized.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A. N >= 0.

  OFFSET  (input) INTEGER
          The number of rows of the matrix A that must be pivoted
          but no factorized. OFFSET >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, the upper triangle of block A(OFFSET+1:M,1:N) is 
          the triangular factor obtained; the elements in block
          A(OFFSET+1:M,1:N) below the diagonal, together with the
          array TAU, represent the orthogonal matrix Q as a product of

          elementary reflectors. Block A(1:OFFSET,1:N) has been
          accordingly pivoted, but no factorized.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  JPVT    (input/output) INTEGER array, dimension (N)
          On entry, if JPVT(i) .ne. 0, the i-th column of A is permuted
          to the front of A*P (a leading column); if JPVT(i) = 0,
          the i-th column of A is a free column.
          On exit, if JPVT(i) = k, then the i-th column of A*P
          was the k-th column of A.

  TAU     (output) DOUBLE PRECISION array, dimension (min(M,N))
          The scalar factors of the elementary reflectors.

  VN1     (input/output) DOUBLE PRECISION array, dimension (N)
          The vector with the partial column norms.

  VN2     (input/output) DOUBLE PRECISION array, dimension (N)
          The vector with the exact column norms.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  Further Details
  ===============

  Based on contributions by
    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
    X. Sun, Computer Science Dept., Duke University, USA

  Partial column norm updating strategy modified by
    Z. Drmac and Z. Bujanovic, Dept. of Mathematics,
    University of Zagreb, Croatia.
    June 2006.
  For more details see LAPACK Working Note 176.
  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param offset
	 * @param a
	 * @param lda
	 * @param jpvt
	 * @param tau
	 * @param vn1
	 * @param vn2
	 * @param work
	 */
	public abstract void dlaqp2(int m, int n, int offset, double[] a, int lda, int[] jpvt, double[] tau, double[] vn1, double[] vn2, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  DLAQPS computes a step of QR factorization with column pivoting
  of a real M-by-N matrix A by using Blas-3.  It tries to factorize
  NB columns from A starting from the row OFFSET+1, and updates all
  of the matrix with Blas-3 xGEMM.

  In some cases, due to catastrophic cancellations, it cannot
  factorize NB columns.  Hence, the actual number of factorized
  columns is returned in KB.

  Block A(1:OFFSET,1:N) is accordingly pivoted, but not factorized.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A. N >= 0

  OFFSET  (input) INTEGER
          The number of rows of A that have been factorized in
          previous steps.

  NB      (input) INTEGER
          The number of columns to factorize.

  KB      (output) INTEGER
          The number of columns actually factorized.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the M-by-N matrix A.
          On exit, block A(OFFSET+1:M,1:KB) is the triangular
          factor obtained and block A(1:OFFSET,1:N) has been
          accordingly pivoted, but no factorized.
          The rest of the matrix, block A(OFFSET+1:M,KB+1:N) has
          been updated.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  JPVT    (input/output) INTEGER array, dimension (N)
          JPVT(I) = K <==> Column K of the full matrix A has been
          permuted into position I in AP.

  TAU     (output) DOUBLE PRECISION array, dimension (KB)
          The scalar factors of the elementary reflectors.

  VN1     (input/output) DOUBLE PRECISION array, dimension (N)
          The vector with the partial column norms.

  VN2     (input/output) DOUBLE PRECISION array, dimension (N)
          The vector with the exact column norms.

  AUXV    (input/output) DOUBLE PRECISION array, dimension (NB)
          Auxiliar vector.

  F       (input/output) DOUBLE PRECISION array, dimension (LDF,NB)
          Matrix F' = L*Y'*A.

  LDF     (input) INTEGER
          The leading dimension of the array F. LDF >= max(1,N).

  Further Details
  ===============

  Based on contributions by
    G. Quintana-Orti, Depto. de Informatica, Universidad Jaime I, Spain
    X. Sun, Computer Science Dept., Duke University, USA

  Partial column norm updating strategy modified by
    Z. Drmac and Z. Bujanovic, Dept. of Mathematics,
    University of Zagreb, Croatia.
    June 2006.
  For more details see LAPACK Working Note 176.
  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param offset
	 * @param nb
	 * @param kb
	 * @param a
	 * @param lda
	 * @param jpvt
	 * @param tau
	 * @param vn1
	 * @param vn2
	 * @param auxv
	 * @param f
	 * @param ldf
	 */
	public abstract void dlaqps(int m, int n, int offset, int nb, intW kb, double[] a, int lda, int[] jpvt, double[] tau, double[] vn1, double[] vn2, double[] auxv, double[] f, int ldf);

		/**
<pre>

     ..

     Purpose
     =======

     DLAQR0 computes the eigenvalues of a Hessenberg matrix H
     and, optionally, the matrices T and Z from the Schur decomposition
     H = Z T Z**T, where T is an upper quasi-triangular matrix (the
     Schur form), and Z is the orthogonal matrix of Schur vectors.

     Optionally Z may be postmultiplied into an input orthogonal
     matrix Q so that this routine can give the Schur factorization
     of a matrix A which has been reduced to the Hessenberg form H
     by the orthogonal matrix Q:  A = Q*H*Q**T = (QZ)*T*(QZ)**T.

     Arguments
     =========

     WANTT   (input) LOGICAL
          = .TRUE. : the full Schur form T is required;
          = .FALSE.: only eigenvalues are required.

     WANTZ   (input) LOGICAL
          = .TRUE. : the matrix of Schur vectors Z is required;
          = .FALSE.: Schur vectors are not required.

     N     (input) INTEGER
           The order of the matrix H.  N .GE. 0.

     ILO   (input) INTEGER
     IHI   (input) INTEGER
           It is assumed that H is already upper triangular in rows
           and columns 1:ILO-1 and IHI+1:N and, if ILO.GT.1,
           H(ILO,ILO-1) is zero. ILO and IHI are normally set by a
           previous call to DGEBAL, and then passed to DGEHRD when the

           matrix output by DGEBAL is reduced to Hessenberg form.
           Otherwise, ILO and IHI should be set to 1 and N,
           respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.
           If N = 0, then ILO = 1 and IHI = 0.

     H     (input/output) DOUBLE PRECISION array, dimension (LDH,N)
           On entry, the upper Hessenberg matrix H.
           On exit, if INFO = 0 and WANTT is .TRUE., then H contains
           the upper quasi-triangular matrix T from the Schur
           decomposition (the Schur form); 2-by-2 diagonal blocks
           (corresponding to complex conjugate pairs of eigenvalues)
           are returned in standard form, with H(i,i) = H(i+1,i+1)
           and H(i+1,i)*H(i,i+1).LT.0. If INFO = 0 and WANTT is
           .FALSE., then the contents of H are unspecified on exit.
           (The output value of H when INFO.GT.0 is given under the
           description of INFO below.)

           This subroutine may explicitly set H(i,j) = 0 for i.GT.j and
           j = 1, 2, ... ILO-1 or j = IHI+1, IHI+2, ... N.

     LDH   (input) INTEGER
           The leading dimension of the array H. LDH .GE. max(1,N).

     WR    (output) DOUBLE PRECISION array, dimension (IHI)
     WI    (output) DOUBLE PRECISION array, dimension (IHI)
           The real and imaginary parts, respectively, of the computed

           eigenvalues of H(ILO:IHI,ILO:IHI) are stored WR(ILO:IHI)
           and WI(ILO:IHI). If two eigenvalues are computed as a
           complex conjugate pair, they are stored in consecutive
           elements of WR and WI, say the i-th and (i+1)th, with
           WI(i) .GT. 0 and WI(i+1) .LT. 0. If WANTT is .TRUE., then
           the eigenvalues are stored in the same order as on the
           diagonal of the Schur form returned in H, with
           WR(i) = H(i,i) and, if H(i:i+1,i:i+1) is a 2-by-2 diagonal
           block, WI(i) = sqrt(-H(i+1,i)*H(i,i+1)) and
           WI(i+1) = -WI(i).

     ILOZ     (input) INTEGER
     IHIZ     (input) INTEGER
           Specify the rows of Z to which transformations must be
           applied if WANTZ is .TRUE..
           1 .LE. ILOZ .LE. ILO; IHI .LE. IHIZ .LE. N.

     Z     (input/output) DOUBLE PRECISION array, dimension (LDZ,IHI)
           If WANTZ is .FALSE., then Z is not referenced.
           If WANTZ is .TRUE., then Z(ILO:IHI,ILOZ:IHIZ) is
           replaced by Z(ILO:IHI,ILOZ:IHIZ)*U where U is the
           orthogonal Schur factor of H(ILO:IHI,ILO:IHI).
           (The output value of Z when INFO.GT.0 is given under
           the description of INFO below.)

     LDZ   (input) INTEGER
           The leading dimension of the array Z.  if WANTZ is .TRUE.
           then LDZ.GE.MAX(1,IHIZ).  Otherwize, LDZ.GE.1.

     WORK  (workspace/output) DOUBLE PRECISION array, dimension LWORK
           On exit, if LWORK = -1, WORK(1) returns an estimate of
           the optimal value for LWORK.

     LWORK (input) INTEGER
           The dimension of the array WORK.  LWORK .GE. max(1,N)
           is sufficient, but LWORK typically as large as 6*N may
           be required for optimal performance.  A workspace query
           to determine the optimal workspace size is recommended.

           If LWORK = -1, then DLAQR0 does a workspace query.
           In this case, DLAQR0 checks the input parameters and
           estimates the optimal workspace size for the given
           values of N, ILO and IHI.  The estimate is returned
           in WORK(1).  No error message related to LWORK is
           issued by XERBLA.  Neither H nor Z are accessed.


     INFO  (output) INTEGER
             =  0:  successful exit
           .GT. 0:  if INFO = i, DLAQR0 failed to compute all of
                the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR
                and WI contain those eigenvalues which have been
                successfully computed.  (Failures are rare.)

                If INFO .GT. 0 and WANT is .FALSE., then on exit,
                the remaining unconverged eigenvalues are the eigen-
                values of the upper Hessenberg matrix rows and
                columns ILO through INFO of the final, output
                value of H.

                If INFO .GT. 0 and WANTT is .TRUE., then on exit

           (*)  (initial value of H)*U  = U*(final value of H)

                where U is an orthogonal matrix.  The final
                value of H is upper Hessenberg and quasi-triangular
                in rows and columns INFO+1 through IHI.

                If INFO .GT. 0 and WANTZ is .TRUE., then on exit

                  (final value of Z(ILO:IHI,ILOZ:IHIZ)
                   =  (initial value of Z(ILO:IHI,ILOZ:IHIZ)*U

                where U is the orthogonal matrix in (*) (regard-
                less of the value of WANTT.)

                If INFO .GT. 0 and WANTZ is .FALSE., then Z is not
                accessed.


     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ================================================================

     References:
       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
       Algorithm Part I: Maintaining Well Focused Shifts, and Level 3
       Performance, SIAM Journal of Matrix Analysis, volume 23, pages
       929--947, 2002.

       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
       Algorithm Part II: Aggressive Early Deflation, SIAM Journal
       of Matrix Analysis, volume 23, pages 948--973, 2002.

     ================================================================
     .. Parameters ..

     ==== Matrices of order NTINY or smaller must be processed by
     .    DLAHQR because of insufficient subdiagonal scratch space.
     .    (This is a hard limit.) ====

     ==== Exceptional deflation windows:  try to cure rare
     .    slow convergence by increasing the size of the
     .    deflation window after KEXNW iterations. =====

     ==== Exceptional shifts: try to cure rare slow convergence
     .    with ad-hoc exceptional shifts every KEXSH iterations.
     .    The constants WILK1 and WILK2 are used to form the
     .    exceptional shifts. ====

</pre>
	 * @param wantt
	 * @param wantz
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param h
	 * @param ldh
	 * @param wr
	 * @param wi
	 * @param iloz
	 * @param ihiz
	 * @param z
	 * @param ldz
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public void dlaqr0(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, int iloz, int ihiz, double[] z, int ldz, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dlaqr0.dlaqr0(wantt, wantz, n, ilo, ihi, h, 0, ldh, wr, 0, wi, 0, iloz, ihiz, z, 0, ldz, work, 0, lwork, info);
	}

		/**
<pre>

     ..

       Given a 2-by-2 or 3-by-3 matrix H, DLAQR1 sets v to a
       scalar multiple of the first column of the product

       (*)  K = (H - (sr1 + i*si1)*I)*(H - (sr2 + i*si2)*I)

       scaling to avoid overflows and most underflows. It
       is assumed that either

               1) sr1 = sr2 and si1 = -si2
           or
               2) si1 = si2 = 0.

       This is useful for starting double implicit shift bulges
       in the QR algorithm.


       N      (input) integer
              Order of the matrix H. N must be either 2 or 3.

       H      (input) DOUBLE PRECISION array of dimension (LDH,N)
              The 2-by-2 or 3-by-3 matrix H in (*).

       LDH    (input) integer
              The leading dimension of H as declared in
              the calling procedure.  LDH.GE.N

       SR1    (input) DOUBLE PRECISION
       SI1    The shifts in (*).
       SR2
       SI2

       V      (output) DOUBLE PRECISION array of dimension N
              A scalar multiple of the first column of the
              matrix K in (*).

     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param h
	 * @param ldh
	 * @param sr1
	 * @param si1
	 * @param sr2
	 * @param si2
	 * @param v
	 */
	public void dlaqr1(int n, double[] h, int ldh, double sr1, double si1, double sr2, double si2, double[] v) {
		org.netlib.lapack.Dlaqr1.dlaqr1(n, h, 0, ldh, sr1, si1, sr2, si2, v, 0);
	}

		/**
<pre>

     ..

     This subroutine is identical to DLAQR3 except that it avoids
     recursion by calling DLAHQR instead of DLAQR4.


     ******************************************************************
     Aggressive early deflation:

     This subroutine accepts as input an upper Hessenberg matrix
     H and performs an orthogonal similarity transformation
     designed to detect and deflate fully converged eigenvalues from
     a trailing principal submatrix.  On output H has been over-
     written by a new Hessenberg matrix that is a perturbation of
     an orthogonal similarity transformation of H.  It is to be
     hoped that the final version of H has many zero subdiagonal
     entries.

     ******************************************************************
     WANTT   (input) LOGICAL
          If .TRUE., then the Hessenberg matrix H is fully updated
          so that the quasi-triangular Schur factor may be
          computed (in cooperation with the calling subroutine).
          If .FALSE., then only enough of H is updated to preserve
          the eigenvalues.

     WANTZ   (input) LOGICAL
          If .TRUE., then the orthogonal matrix Z is updated so
          so that the orthogonal Schur factor may be computed
          (in cooperation with the calling subroutine).
          If .FALSE., then Z is not referenced.

     N       (input) INTEGER
          The order of the matrix H and (if WANTZ is .TRUE.) the
          order of the orthogonal matrix Z.

     KTOP    (input) INTEGER
          It is assumed that either KTOP = 1 or H(KTOP,KTOP-1)=0.
          KBOT and KTOP together determine an isolated block
          along the diagonal of the Hessenberg matrix.

     KBOT    (input) INTEGER
          It is assumed without a check that either
          KBOT = N or H(KBOT+1,KBOT)=0.  KBOT and KTOP together
          determine an isolated block along the diagonal of the
          Hessenberg matrix.

     NW      (input) INTEGER
          Deflation window size.  1 .LE. NW .LE. (KBOT-KTOP+1).

     H       (input/output) DOUBLE PRECISION array, dimension (LDH,N)
          On input the initial N-by-N section of H stores the
          Hessenberg matrix undergoing aggressive early deflation.
          On output H has been transformed by an orthogonal
          similarity transformation, perturbed, and the returned
          to Hessenberg form that (it is to be hoped) has some
          zero subdiagonal entries.

     LDH     (input) integer
          Leading dimension of H just as declared in the calling
          subroutine.  N .LE. LDH

     ILOZ    (input) INTEGER
     IHIZ    (input) INTEGER
          Specify the rows of Z to which transformations must be
          applied if WANTZ is .TRUE.. 1 .LE. ILOZ .LE. IHIZ .LE. N.

     Z       (input/output) DOUBLE PRECISION array, dimension (LDZ,IHI)
          IF WANTZ is .TRUE., then on output, the orthogonal
          similarity transformation mentioned above has been
          accumulated into Z(ILOZ:IHIZ,ILO:IHI) from the right.
          If WANTZ is .FALSE., then Z is unreferenced.

     LDZ     (input) integer
          The leading dimension of Z just as declared in the
          calling subroutine.  1 .LE. LDZ.

     NS      (output) integer
          The number of unconverged (ie approximate) eigenvalues
          returned in SR and SI that may be used as shifts by the
          calling subroutine.

     ND      (output) integer
          The number of converged eigenvalues uncovered by this
          subroutine.

     SR      (output) DOUBLE PRECISION array, dimension KBOT
     SI      (output) DOUBLE PRECISION array, dimension KBOT
          On output, the real and imaginary parts of approximate
          eigenvalues that may be used for shifts are stored in
          SR(KBOT-ND-NS+1) through SR(KBOT-ND) and
          SI(KBOT-ND-NS+1) through SI(KBOT-ND), respectively.
          The real and imaginary parts of converged eigenvalues
          are stored in SR(KBOT-ND+1) through SR(KBOT) and
          SI(KBOT-ND+1) through SI(KBOT), respectively.

     V       (workspace) DOUBLE PRECISION array, dimension (LDV,NW)
          An NW-by-NW work array.

     LDV     (input) integer scalar
          The leading dimension of V just as declared in the
          calling subroutine.  NW .LE. LDV

     NH      (input) integer scalar
          The number of columns of T.  NH.GE.NW.

     T       (workspace) DOUBLE PRECISION array, dimension (LDT,NW)

     LDT     (input) integer
          The leading dimension of T just as declared in the
          calling subroutine.  NW .LE. LDT

     NV      (input) integer
          The number of rows of work array WV available for
          workspace.  NV.GE.NW.

     WV      (workspace) DOUBLE PRECISION array, dimension (LDWV,NW)

     LDWV    (input) integer
          The leading dimension of W just as declared in the
          calling subroutine.  NW .LE. LDV

     WORK    (workspace) DOUBLE PRECISION array, dimension LWORK.
          On exit, WORK(1) is set to an estimate of the optimal value
          of LWORK for the given values of N, NW, KTOP and KBOT.

     LWORK   (input) integer
          The dimension of the work array WORK.  LWORK = 2*NW
          suffices, but greater efficiency may result from larger
          values of LWORK.

          If LWORK = -1, then a workspace query is assumed; DLAQR2
          only estimates the optimal workspace size for the given
          values of N, NW, KTOP and KBOT.  The estimate is returned
          in WORK(1).  No error message related to LWORK is issued
          by XERBLA.  Neither H nor Z are accessed.

     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ================================================================
     .. Parameters ..
</pre>
	 * @param wantt
	 * @param wantz
	 * @param n
	 * @param ktop
	 * @param kbot
	 * @param nw
	 * @param h
	 * @param ldh
	 * @param iloz
	 * @param ihiz
	 * @param z
	 * @param ldz
	 * @param ns
	 * @param nd
	 * @param sr
	 * @param si
	 * @param v
	 * @param ldv
	 * @param nh
	 * @param t
	 * @param ldt
	 * @param nv
	 * @param wv
	 * @param ldwv
	 * @param work
	 * @param lwork
	 */
	public void dlaqr2(boolean wantt, boolean wantz, int n, int ktop, int kbot, int nw, double[] h, int ldh, int iloz, int ihiz, double[] z, int ldz, intW ns, intW nd, double[] sr, double[] si, double[] v, int ldv, int nh, double[] t, int ldt, int nv, double[] wv, int ldwv, double[] work, int lwork) {
		org.netlib.lapack.Dlaqr2.dlaqr2(wantt, wantz, n, ktop, kbot, nw, h, 0, ldh, iloz, ihiz, z, 0, ldz, ns, nd, sr, 0, si, 0, v, 0, ldv, nh, t, 0, ldt, nv, wv, 0, ldwv, work, 0, lwork);
	}

		/**
<pre>

     ..

     ******************************************************************
     Aggressive early deflation:

     This subroutine accepts as input an upper Hessenberg matrix
     H and performs an orthogonal similarity transformation
     designed to detect and deflate fully converged eigenvalues from
     a trailing principal submatrix.  On output H has been over-
     written by a new Hessenberg matrix that is a perturbation of
     an orthogonal similarity transformation of H.  It is to be
     hoped that the final version of H has many zero subdiagonal
     entries.

     ******************************************************************
     WANTT   (input) LOGICAL
          If .TRUE., then the Hessenberg matrix H is fully updated
          so that the quasi-triangular Schur factor may be
          computed (in cooperation with the calling subroutine).
          If .FALSE., then only enough of H is updated to preserve
          the eigenvalues.

     WANTZ   (input) LOGICAL
          If .TRUE., then the orthogonal matrix Z is updated so
          so that the orthogonal Schur factor may be computed
          (in cooperation with the calling subroutine).
          If .FALSE., then Z is not referenced.

     N       (input) INTEGER
          The order of the matrix H and (if WANTZ is .TRUE.) the
          order of the orthogonal matrix Z.

     KTOP    (input) INTEGER
          It is assumed that either KTOP = 1 or H(KTOP,KTOP-1)=0.
          KBOT and KTOP together determine an isolated block
          along the diagonal of the Hessenberg matrix.

     KBOT    (input) INTEGER
          It is assumed without a check that either
          KBOT = N or H(KBOT+1,KBOT)=0.  KBOT and KTOP together
          determine an isolated block along the diagonal of the
          Hessenberg matrix.

     NW      (input) INTEGER
          Deflation window size.  1 .LE. NW .LE. (KBOT-KTOP+1).

     H       (input/output) DOUBLE PRECISION array, dimension (LDH,N)
          On input the initial N-by-N section of H stores the
          Hessenberg matrix undergoing aggressive early deflation.
          On output H has been transformed by an orthogonal
          similarity transformation, perturbed, and the returned
          to Hessenberg form that (it is to be hoped) has some
          zero subdiagonal entries.

     LDH     (input) integer
          Leading dimension of H just as declared in the calling
          subroutine.  N .LE. LDH

     ILOZ    (input) INTEGER
     IHIZ    (input) INTEGER
          Specify the rows of Z to which transformations must be
          applied if WANTZ is .TRUE.. 1 .LE. ILOZ .LE. IHIZ .LE. N.

     Z       (input/output) DOUBLE PRECISION array, dimension (LDZ,IHI)
          IF WANTZ is .TRUE., then on output, the orthogonal
          similarity transformation mentioned above has been
          accumulated into Z(ILOZ:IHIZ,ILO:IHI) from the right.
          If WANTZ is .FALSE., then Z is unreferenced.

     LDZ     (input) integer
          The leading dimension of Z just as declared in the
          calling subroutine.  1 .LE. LDZ.

     NS      (output) integer
          The number of unconverged (ie approximate) eigenvalues
          returned in SR and SI that may be used as shifts by the
          calling subroutine.

     ND      (output) integer
          The number of converged eigenvalues uncovered by this
          subroutine.

     SR      (output) DOUBLE PRECISION array, dimension KBOT
     SI      (output) DOUBLE PRECISION array, dimension KBOT
          On output, the real and imaginary parts of approximate
          eigenvalues that may be used for shifts are stored in
          SR(KBOT-ND-NS+1) through SR(KBOT-ND) and
          SI(KBOT-ND-NS+1) through SI(KBOT-ND), respectively.
          The real and imaginary parts of converged eigenvalues
          are stored in SR(KBOT-ND+1) through SR(KBOT) and
          SI(KBOT-ND+1) through SI(KBOT), respectively.

     V       (workspace) DOUBLE PRECISION array, dimension (LDV,NW)
          An NW-by-NW work array.

     LDV     (input) integer scalar
          The leading dimension of V just as declared in the
          calling subroutine.  NW .LE. LDV

     NH      (input) integer scalar
          The number of columns of T.  NH.GE.NW.

     T       (workspace) DOUBLE PRECISION array, dimension (LDT,NW)

     LDT     (input) integer
          The leading dimension of T just as declared in the
          calling subroutine.  NW .LE. LDT

     NV      (input) integer
          The number of rows of work array WV available for
          workspace.  NV.GE.NW.

     WV      (workspace) DOUBLE PRECISION array, dimension (LDWV,NW)

     LDWV    (input) integer
          The leading dimension of W just as declared in the
          calling subroutine.  NW .LE. LDV

     WORK    (workspace) DOUBLE PRECISION array, dimension LWORK.
          On exit, WORK(1) is set to an estimate of the optimal value
          of LWORK for the given values of N, NW, KTOP and KBOT.

     LWORK   (input) integer
          The dimension of the work array WORK.  LWORK = 2*NW
          suffices, but greater efficiency may result from larger
          values of LWORK.

          If LWORK = -1, then a workspace query is assumed; DLAQR3
          only estimates the optimal workspace size for the given
          values of N, NW, KTOP and KBOT.  The estimate is returned
          in WORK(1).  No error message related to LWORK is issued
          by XERBLA.  Neither H nor Z are accessed.

     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ==================================================================
     .. Parameters ..
</pre>
	 * @param wantt
	 * @param wantz
	 * @param n
	 * @param ktop
	 * @param kbot
	 * @param nw
	 * @param h
	 * @param ldh
	 * @param iloz
	 * @param ihiz
	 * @param z
	 * @param ldz
	 * @param ns
	 * @param nd
	 * @param sr
	 * @param si
	 * @param v
	 * @param ldv
	 * @param nh
	 * @param t
	 * @param ldt
	 * @param nv
	 * @param wv
	 * @param ldwv
	 * @param work
	 * @param lwork
	 */
	public void dlaqr3(boolean wantt, boolean wantz, int n, int ktop, int kbot, int nw, double[] h, int ldh, int iloz, int ihiz, double[] z, int ldz, intW ns, intW nd, double[] sr, double[] si, double[] v, int ldv, int nh, double[] t, int ldt, int nv, double[] wv, int ldwv, double[] work, int lwork) {
		org.netlib.lapack.Dlaqr3.dlaqr3(wantt, wantz, n, ktop, kbot, nw, h, 0, ldh, iloz, ihiz, z, 0, ldz, ns, nd, sr, 0, si, 0, v, 0, ldv, nh, t, 0, ldt, nv, wv, 0, ldwv, work, 0, lwork);
	}

		/**
<pre>

     ..

     This subroutine implements one level of recursion for DLAQR0.
     It is a complete implementation of the small bulge multi-shift
     QR algorithm.  It may be called by DLAQR0 and, for large enough
     deflation window size, it may be called by DLAQR3.  This
     subroutine is identical to DLAQR0 except that it calls DLAQR2
     instead of DLAQR3.

     Purpose
     =======

     DLAQR4 computes the eigenvalues of a Hessenberg matrix H
     and, optionally, the matrices T and Z from the Schur decomposition
     H = Z T Z**T, where T is an upper quasi-triangular matrix (the
     Schur form), and Z is the orthogonal matrix of Schur vectors.

     Optionally Z may be postmultiplied into an input orthogonal
     matrix Q so that this routine can give the Schur factorization
     of a matrix A which has been reduced to the Hessenberg form H
     by the orthogonal matrix Q:  A = Q*H*Q**T = (QZ)*T*(QZ)**T.

     Arguments
     =========

     WANTT   (input) LOGICAL
          = .TRUE. : the full Schur form T is required;
          = .FALSE.: only eigenvalues are required.

     WANTZ   (input) LOGICAL
          = .TRUE. : the matrix of Schur vectors Z is required;
          = .FALSE.: Schur vectors are not required.

     N     (input) INTEGER
           The order of the matrix H.  N .GE. 0.

     ILO   (input) INTEGER
     IHI   (input) INTEGER
           It is assumed that H is already upper triangular in rows
           and columns 1:ILO-1 and IHI+1:N and, if ILO.GT.1,
           H(ILO,ILO-1) is zero. ILO and IHI are normally set by a
           previous call to DGEBAL, and then passed to DGEHRD when the

           matrix output by DGEBAL is reduced to Hessenberg form.
           Otherwise, ILO and IHI should be set to 1 and N,
           respectively.  If N.GT.0, then 1.LE.ILO.LE.IHI.LE.N.
           If N = 0, then ILO = 1 and IHI = 0.

     H     (input/output) DOUBLE PRECISION array, dimension (LDH,N)
           On entry, the upper Hessenberg matrix H.
           On exit, if INFO = 0 and WANTT is .TRUE., then H contains
           the upper quasi-triangular matrix T from the Schur
           decomposition (the Schur form); 2-by-2 diagonal blocks
           (corresponding to complex conjugate pairs of eigenvalues)
           are returned in standard form, with H(i,i) = H(i+1,i+1)
           and H(i+1,i)*H(i,i+1).LT.0. If INFO = 0 and WANTT is
           .FALSE., then the contents of H are unspecified on exit.
           (The output value of H when INFO.GT.0 is given under the
           description of INFO below.)

           This subroutine may explicitly set H(i,j) = 0 for i.GT.j and
           j = 1, 2, ... ILO-1 or j = IHI+1, IHI+2, ... N.

     LDH   (input) INTEGER
           The leading dimension of the array H. LDH .GE. max(1,N).

     WR    (output) DOUBLE PRECISION array, dimension (IHI)
     WI    (output) DOUBLE PRECISION array, dimension (IHI)
           The real and imaginary parts, respectively, of the computed

           eigenvalues of H(ILO:IHI,ILO:IHI) are stored WR(ILO:IHI)
           and WI(ILO:IHI). If two eigenvalues are computed as a
           complex conjugate pair, they are stored in consecutive
           elements of WR and WI, say the i-th and (i+1)th, with
           WI(i) .GT. 0 and WI(i+1) .LT. 0. If WANTT is .TRUE., then
           the eigenvalues are stored in the same order as on the
           diagonal of the Schur form returned in H, with
           WR(i) = H(i,i) and, if H(i:i+1,i:i+1) is a 2-by-2 diagonal
           block, WI(i) = sqrt(-H(i+1,i)*H(i,i+1)) and
           WI(i+1) = -WI(i).

     ILOZ     (input) INTEGER
     IHIZ     (input) INTEGER
           Specify the rows of Z to which transformations must be
           applied if WANTZ is .TRUE..
           1 .LE. ILOZ .LE. ILO; IHI .LE. IHIZ .LE. N.

     Z     (input/output) DOUBLE PRECISION array, dimension (LDZ,IHI)
           If WANTZ is .FALSE., then Z is not referenced.
           If WANTZ is .TRUE., then Z(ILO:IHI,ILOZ:IHIZ) is
           replaced by Z(ILO:IHI,ILOZ:IHIZ)*U where U is the
           orthogonal Schur factor of H(ILO:IHI,ILO:IHI).
           (The output value of Z when INFO.GT.0 is given under
           the description of INFO below.)

     LDZ   (input) INTEGER
           The leading dimension of the array Z.  if WANTZ is .TRUE.
           then LDZ.GE.MAX(1,IHIZ).  Otherwize, LDZ.GE.1.

     WORK  (workspace/output) DOUBLE PRECISION array, dimension LWORK
           On exit, if LWORK = -1, WORK(1) returns an estimate of
           the optimal value for LWORK.

     LWORK (input) INTEGER
           The dimension of the array WORK.  LWORK .GE. max(1,N)
           is sufficient, but LWORK typically as large as 6*N may
           be required for optimal performance.  A workspace query
           to determine the optimal workspace size is recommended.

           If LWORK = -1, then DLAQR4 does a workspace query.
           In this case, DLAQR4 checks the input parameters and
           estimates the optimal workspace size for the given
           values of N, ILO and IHI.  The estimate is returned
           in WORK(1).  No error message related to LWORK is
           issued by XERBLA.  Neither H nor Z are accessed.


     INFO  (output) INTEGER
             =  0:  successful exit
           .GT. 0:  if INFO = i, DLAQR4 failed to compute all of
                the eigenvalues.  Elements 1:ilo-1 and i+1:n of WR
                and WI contain those eigenvalues which have been
                successfully computed.  (Failures are rare.)

                If INFO .GT. 0 and WANT is .FALSE., then on exit,
                the remaining unconverged eigenvalues are the eigen-
                values of the upper Hessenberg matrix rows and
                columns ILO through INFO of the final, output
                value of H.

                If INFO .GT. 0 and WANTT is .TRUE., then on exit

           (*)  (initial value of H)*U  = U*(final value of H)

                where U is an orthogonal matrix.  The final
                value of H is upper Hessenberg and quasi-triangular
                in rows and columns INFO+1 through IHI.

                If INFO .GT. 0 and WANTZ is .TRUE., then on exit

                  (final value of Z(ILO:IHI,ILOZ:IHIZ)
                   =  (initial value of Z(ILO:IHI,ILOZ:IHIZ)*U

                where U is the orthogonal matrix in (*) (regard-
                less of the value of WANTT.)

                If INFO .GT. 0 and WANTZ is .FALSE., then Z is not
                accessed.

     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ================================================================
     References:
       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
       Algorithm Part I: Maintaining Well Focused Shifts, and Level 3
       Performance, SIAM Journal of Matrix Analysis, volume 23, pages
       929--947, 2002.

       K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
       Algorithm Part II: Aggressive Early Deflation, SIAM Journal
       of Matrix Analysis, volume 23, pages 948--973, 2002.

     ================================================================
     .. Parameters ..

     ==== Matrices of order NTINY or smaller must be processed by
     .    DLAHQR because of insufficient subdiagonal scratch space.
     .    (This is a hard limit.) ====

     ==== Exceptional deflation windows:  try to cure rare
     .    slow convergence by increasing the size of the
     .    deflation window after KEXNW iterations. =====

     ==== Exceptional shifts: try to cure rare slow convergence
     .    with ad-hoc exceptional shifts every KEXSH iterations.
     .    The constants WILK1 and WILK2 are used to form the
     .    exceptional shifts. ====

</pre>
	 * @param wantt
	 * @param wantz
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param h
	 * @param ldh
	 * @param wr
	 * @param wi
	 * @param iloz
	 * @param ihiz
	 * @param z
	 * @param ldz
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public void dlaqr4(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, int iloz, int ihiz, double[] z, int ldz, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dlaqr4.dlaqr4(wantt, wantz, n, ilo, ihi, h, 0, ldh, wr, 0, wi, 0, iloz, ihiz, z, 0, ldz, work, 0, lwork, info);
	}

		/**
<pre>

     ..

     This auxiliary subroutine called by DLAQR0 performs a
     single small-bulge multi-shift QR sweep.

      WANTT  (input) logical scalar
             WANTT = .true. if the quasi-triangular Schur factor
             is being computed.  WANTT is set to .false. otherwise.

      WANTZ  (input) logical scalar
             WANTZ = .true. if the orthogonal Schur factor is being
             computed.  WANTZ is set to .false. otherwise.

      KACC22 (input) integer with value 0, 1, or 2.
             Specifies the computation mode of far-from-diagonal
             orthogonal updates.
        = 0: DLAQR5 does not accumulate reflections and does not
             use matrix-matrix multiply to update far-from-diagonal
             matrix entries.
        = 1: DLAQR5 accumulates reflections and uses matrix-matrix
             multiply to update the far-from-diagonal matrix entries.
        = 2: DLAQR5 accumulates reflections, uses matrix-matrix
             multiply to update the far-from-diagonal matrix entries,
             and takes advantage of 2-by-2 block structure during
             matrix multiplies.

      N      (input) integer scalar
             N is the order of the Hessenberg matrix H upon which this

             subroutine operates.

      KTOP   (input) integer scalar
      KBOT   (input) integer scalar
             These are the first and last rows and columns of an
             isolated diagonal block upon which the QR sweep is to be
             applied. It is assumed without a check that
                       either KTOP = 1  or   H(KTOP,KTOP-1) = 0
             and
                       either KBOT = N  or   H(KBOT+1,KBOT) = 0.

      NSHFTS (input) integer scalar
             NSHFTS gives the number of simultaneous shifts.  NSHFTS
             must be positive and even.

      SR     (input) DOUBLE PRECISION array of size (NSHFTS)
      SI     (input) DOUBLE PRECISION array of size (NSHFTS)
             SR contains the real parts and SI contains the imaginary
             parts of the NSHFTS shifts of origin that define the
             multi-shift QR sweep.

      H      (input/output) DOUBLE PRECISION array of size (LDH,N)
             On input H contains a Hessenberg matrix.  On output a
             multi-shift QR sweep with shifts SR(J)+i*SI(J) is applied

             to the isolated diagonal block in rows and columns KTOP
             through KBOT.

      LDH    (input) integer scalar
             LDH is the leading dimension of H just as declared in the

             calling procedure.  LDH.GE.MAX(1,N).

      ILOZ   (input) INTEGER
      IHIZ   (input) INTEGER
             Specify the rows of Z to which transformations must be
             applied if WANTZ is .TRUE.. 1 .LE. ILOZ .LE. IHIZ .LE. N

      Z      (input/output) DOUBLE PRECISION array of size (LDZ,IHI)
             If WANTZ = .TRUE., then the QR Sweep orthogonal
             similarity transformation is accumulated into
             Z(ILOZ:IHIZ,ILO:IHI) from the right.
             If WANTZ = .FALSE., then Z is unreferenced.

      LDZ    (input) integer scalar
             LDA is the leading dimension of Z just as declared in
             the calling procedure. LDZ.GE.N.

      V      (workspace) DOUBLE PRECISION array of size (LDV,NSHFTS/2)


      LDV    (input) integer scalar
             LDV is the leading dimension of V as declared in the
             calling procedure.  LDV.GE.3.

      U      (workspace) DOUBLE PRECISION array of size
             (LDU,3*NSHFTS-3)

      LDU    (input) integer scalar
             LDU is the leading dimension of U just as declared in the

             in the calling subroutine.  LDU.GE.3*NSHFTS-3.

      NH     (input) integer scalar
             NH is the number of columns in array WH available for
             workspace. NH.GE.1.

      WH     (workspace) DOUBLE PRECISION array of size (LDWH,NH)

      LDWH   (input) integer scalar
             Leading dimension of WH just as declared in the
             calling procedure.  LDWH.GE.3*NSHFTS-3.

      NV     (input) integer scalar
             NV is the number of rows in WV agailable for workspace.
             NV.GE.1.

      WV     (workspace) DOUBLE PRECISION array of size
             (LDWV,3*NSHFTS-3)

      LDWV   (input) integer scalar
             LDWV is the leading dimension of WV as declared in the
             in the calling subroutine.  LDWV.GE.NV.


     ================================================================
     Based on contributions by
        Karen Braman and Ralph Byers, Department of Mathematics,
        University of Kansas, USA

     ============================================================
     Reference:

     K. Braman, R. Byers and R. Mathias, The Multi-Shift QR
     Algorithm Part I: Maintaining Well Focused Shifts, and
     Level 3 Performance, SIAM Journal of Matrix Analysis,
     volume 23, pages 929--947, 2002.

     ============================================================
     .. Parameters ..
</pre>
	 * @param wantt
	 * @param wantz
	 * @param kacc22
	 * @param n
	 * @param ktop
	 * @param kbot
	 * @param nshfts
	 * @param sr
	 * @param si
	 * @param h
	 * @param ldh
	 * @param iloz
	 * @param ihiz
	 * @param z
	 * @param ldz
	 * @param v
	 * @param ldv
	 * @param u
	 * @param ldu
	 * @param nv
	 * @param wv
	 * @param ldwv
	 * @param nh
	 * @param wh
	 * @param ldwh
	 */
	public void dlaqr5(boolean wantt, boolean wantz, int kacc22, int n, int ktop, int kbot, int nshfts, double[] sr, double[] si, double[] h, int ldh, int iloz, int ihiz, double[] z, int ldz, double[] v, int ldv, double[] u, int ldu, int nv, double[] wv, int ldwv, int nh, double[] wh, int ldwh) {
		org.netlib.lapack.Dlaqr5.dlaqr5(wantt, wantz, kacc22, n, ktop, kbot, nshfts, sr, 0, si, 0, h, 0, ldh, iloz, ihiz, z, 0, ldz, v, 0, ldv, u, 0, ldu, nv, wv, 0, ldwv, nh, wh, 0, ldwh);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLAQSB equilibrates a symmetric band matrix A using the scaling
  factors in the vector S.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored.
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of super-diagonals of the matrix A if UPLO = 'U',

          or the number of sub-diagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, if INFO = 0, the triangular factor U or L from the
          Cholesky factorization A = U'*U or A = L*L' of the band
          matrix A, in the same storage format as A.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  S       (input) DOUBLE PRECISION array, dimension (N)
          The scale factors for A.

  SCOND   (input) DOUBLE PRECISION
          Ratio of the smallest S(i) to the largest S(i).

  AMAX    (input) DOUBLE PRECISION
          Absolute value of largest matrix entry.

  EQUED   (output) CHARACTER*1
          Specifies whether or not equilibration was done.
          = 'N':  No equilibration.
          = 'Y':  Equilibration was done, i.e., A has been replaced by

                  diag(S) * A * diag(S).

  Internal Parameters
  ===================

  THRESH is a threshold value used to decide if scaling should be done

  based on the ratio of the scaling factors.  If SCOND < THRESH,
  scaling is done.

  LARGE and SMALL are threshold values used to decide if scaling should
  be done based on the absolute size of the largest matrix element.
  If AMAX > LARGE or AMAX < SMALL, scaling is done.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param s
	 * @param scond
	 * @param amax
	 * @param equed
	 */
	public abstract void dlaqsb(String uplo, int n, int kd, double[] ab, int ldab, double[] s, double scond, double amax, StringW equed);

	/**
<pre>

     ..

  Purpose
  =======

  DLAQSP equilibrates a symmetric matrix A using the scaling factors
  in the vector S.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored.
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input/output) DOUBLE PRECISION array, dimension (N*(N+1)/2)

          On entry, the upper or lower triangle of the symmetric matrix
          A, packed columnwise in a linear array.  The j-th column of A
          is stored in the array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.

          On exit, the equilibrated matrix:  diag(S) * A * diag(S), in

          the same storage format as A.

  S       (input) DOUBLE PRECISION array, dimension (N)
          The scale factors for A.

  SCOND   (input) DOUBLE PRECISION
          Ratio of the smallest S(i) to the largest S(i).

  AMAX    (input) DOUBLE PRECISION
          Absolute value of largest matrix entry.

  EQUED   (output) CHARACTER*1
          Specifies whether or not equilibration was done.
          = 'N':  No equilibration.
          = 'Y':  Equilibration was done, i.e., A has been replaced by

                  diag(S) * A * diag(S).

  Internal Parameters
  ===================

  THRESH is a threshold value used to decide if scaling should be done

  based on the ratio of the scaling factors.  If SCOND < THRESH,
  scaling is done.

  LARGE and SMALL are threshold values used to decide if scaling should
  be done based on the absolute size of the largest matrix element.
  If AMAX > LARGE or AMAX < SMALL, scaling is done.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param s
	 * @param scond
	 * @param amax
	 * @param equed
	 */
	public abstract void dlaqsp(String uplo, int n, double[] ap, double[] s, double scond, double amax, StringW equed);

	/**
<pre>

     ..

  Purpose
  =======

  DLAQSY equilibrates a symmetric matrix A using the scaling factors
  in the vector S.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored.
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A.  If UPLO = 'U', the leading
          n by n upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading n by n lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.

          On exit, if EQUED = 'Y', the equilibrated matrix:
          diag(S) * A * diag(S).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(N,1).

  S       (input) DOUBLE PRECISION array, dimension (N)
          The scale factors for A.

  SCOND   (input) DOUBLE PRECISION
          Ratio of the smallest S(i) to the largest S(i).

  AMAX    (input) DOUBLE PRECISION
          Absolute value of largest matrix entry.

  EQUED   (output) CHARACTER*1
          Specifies whether or not equilibration was done.
          = 'N':  No equilibration.
          = 'Y':  Equilibration was done, i.e., A has been replaced by

                  diag(S) * A * diag(S).

  Internal Parameters
  ===================

  THRESH is a threshold value used to decide if scaling should be done

  based on the ratio of the scaling factors.  If SCOND < THRESH,
  scaling is done.

  LARGE and SMALL are threshold values used to decide if scaling should
  be done based on the absolute size of the largest matrix element.
  If AMAX > LARGE or AMAX < SMALL, scaling is done.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param s
	 * @param scond
	 * @param amax
	 * @param equed
	 */
	public abstract void dlaqsy(String uplo, int n, double[] a, int lda, double[] s, double scond, double amax, StringW equed);

	/**
<pre>

     ..

  Purpose
  =======

  DLAQTR solves the real quasi-triangular system

               op(T)*p = scale*c,               if LREAL = .TRUE.

  or the complex quasi-triangular systems

             op(T + iB)*(p+iq) = scale*(c+id),  if LREAL = .FALSE.

  in real arithmetic, where T is upper quasi-triangular.
  If LREAL = .FALSE., then the first diagonal block of T must be
  1 by 1, B is the specially structured matrix

                 B = [ b(1) b(2) ... b(n) ]
                     [       w            ]
                     [           w        ]
                     [              .     ]
                     [                 w  ]

  op(A) = A or A', A' denotes the conjugate transpose of
  matrix A.

  On input, X = [ c ].  On output, X = [ p ].
                [ d ]                  [ q ]

  This subroutine is designed for the condition number estimation
  in routine DTRSNA.

  Arguments
  =========

  LTRAN   (input) LOGICAL
          On entry, LTRAN specifies the option of conjugate transpose:

             = .FALSE.,    op(T+i*B) = T+i*B,
             = .TRUE.,     op(T+i*B) = (T+i*B)'.

  LREAL   (input) LOGICAL
          On entry, LREAL specifies the input matrix structure:
             = .FALSE.,    the input is complex
             = .TRUE.,     the input is real

  N       (input) INTEGER
          On entry, N specifies the order of T+i*B. N >= 0.

  T       (input) DOUBLE PRECISION array, dimension (LDT,N)
          On entry, T contains a matrix in Schur canonical form.
          If LREAL = .FALSE., then the first diagonal block of T mu
          be 1 by 1.

  LDT     (input) INTEGER
          The leading dimension of the matrix T. LDT >= max(1,N).

  B       (input) DOUBLE PRECISION array, dimension (N)
          On entry, B contains the elements to form the matrix
          B as described above.
          If LREAL = .TRUE., B is not referenced.

  W       (input) DOUBLE PRECISION
          On entry, W is the diagonal element of the matrix B.
          If LREAL = .TRUE., W is not referenced.

  SCALE   (output) DOUBLE PRECISION
          On exit, SCALE is the scale factor.

  X       (input/output) DOUBLE PRECISION array, dimension (2*N)
          On entry, X contains the right hand side of the system.
          On exit, X is overwritten by the solution.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          On exit, INFO is set to
             0: successful exit.
               1: the some diagonal 1 by 1 block has been perturbed by

                  a small number SMIN to keep nonsingularity.
               2: the some diagonal 2 by 2 block has been perturbed by

                  a small number in DLALN2 to keep nonsingularity.
          NOTE: In the interests of speed, this routine does not
                check the inputs for errors.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param ltran
	 * @param lreal
	 * @param n
	 * @param t
	 * @param ldt
	 * @param b
	 * @param w
	 * @param scale
	 * @param x
	 * @param work
	 * @param info
	 */
	public abstract void dlaqtr(boolean ltran, boolean lreal, int n, double[] t, int ldt, double[] b, double w, doubleW scale, double[] x, double[] work, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DLAR1V computes the (scaled) r-th column of the inverse of
  the sumbmatrix in rows B1 through BN of the tridiagonal matrix
  L D L^T - sigma I. When sigma is close to an eigenvalue, the
  computed vector is an accurate eigenvector. Usually, r corresponds
  to the index where the eigenvector is largest in magnitude.
  The following steps accomplish this computation :
  (a) Stationary qd transform,  L D L^T - sigma I = L(+) D(+) L(+)^T,
  (b) Progressive qd transform, L D L^T - sigma I = U(-) D(-) U(-)^T,
  (c) Computation of the diagonal elements of the inverse of
      L D L^T - sigma I by combining the above transforms, and choosing
      r as the index where the diagonal of the inverse is (one of the)

      largest in magnitude.
  (d) Computation of the (scaled) r-th column of the inverse using the

      twisted factorization obtained by combining the top part of the
      the stationary and the bottom part of the progressive transform.


  Arguments
  =========

  N        (input) INTEGER
           The order of the matrix L D L^T.

  B1       (input) INTEGER
           First index of the submatrix of L D L^T.

  BN       (input) INTEGER
           Last index of the submatrix of L D L^T.

  LAMBDA    (input) DOUBLE PRECISION
           The shift. In order to compute an accurate eigenvector,
           LAMBDA should be a good approximation to an eigenvalue
           of L D L^T.

  L        (input) DOUBLE PRECISION array, dimension (N-1)
           The (n-1) subdiagonal elements of the unit bidiagonal matrix
           L, in elements 1 to N-1.

  D        (input) DOUBLE PRECISION array, dimension (N)
           The n diagonal elements of the diagonal matrix D.

  LD       (input) DOUBLE PRECISION array, dimension (N-1)
           The n-1 elements L(i)*D(i).

  LLD      (input) DOUBLE PRECISION array, dimension (N-1)
           The n-1 elements L(i)*L(i)*D(i).

  PIVMIN   (input) DOUBLE PRECISION
           The minimum pivot in the Sturm sequence.

  GAPTOL   (input) DOUBLE PRECISION
           Tolerance that indicates when eigenvector entries are neglig
           w.r.t. their contribution to the residual.

  Z        (input/output) DOUBLE PRECISION array, dimension (N)
           On input, all entries of Z must be set to 0.
           On output, Z contains the (scaled) r-th column of the
           inverse. The scaling is such that Z(R) equals 1.

  WANTNC   (input) LOGICAL
           Specifies whether NEGCNT has to be computed.

  NEGCNT   (output) INTEGER
           If WANTNC is .TRUE. then NEGCNT = the number of pivots < piv
           in the  matrix factorization L D L^T, and NEGCNT = -1 otherw

  ZTZ      (output) DOUBLE PRECISION
           The square of the 2-norm of Z.

  MINGMA   (output) DOUBLE PRECISION
           The reciprocal of the largest (in magnitude) diagonal
           element of the inverse of L D L^T - sigma I.

  R        (input/output) INTEGER
           The twist index for the twisted factorization used to
           compute Z.
           On input, 0 <= R <= N. If R is input as 0, R is set to
           the index where (L D L^T - sigma I)^{-1} is largest
           in magnitude. If 1 <= R <= N, R is unchanged.
           On output, R contains the twist index used to compute Z.
           Ideally, R designates the position of the maximum entry in t
           eigenvector.

  ISUPPZ   (output) INTEGER array, dimension (2)
           The support of the vector in Z, i.e., the vector Z is
           nonzero only in elements ISUPPZ(1) through ISUPPZ( 2 ).

  NRMINV   (output) DOUBLE PRECISION
           NRMINV = 1/SQRT( ZTZ )

  RESID    (output) DOUBLE PRECISION
           The residual of the FP vector.
           RESID = ABS( MINGMA )/SQRT( ZTZ )

  RQCORR   (output) DOUBLE PRECISION
           The Rayleigh Quotient correction to LAMBDA.
           RQCORR = MINGMA*TMP

  WORK     (workspace) DOUBLE PRECISION array, dimension (4*N)

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param b1
	 * @param bn
	 * @param lambda
	 * @param d
	 * @param l
	 * @param ld
	 * @param lld
	 * @param pivmin
	 * @param gaptol
	 * @param z
	 * @param wantnc
	 * @param negcnt
	 * @param ztz
	 * @param mingma
	 * @param r
	 * @param isuppz
	 * @param nrminv
	 * @param resid
	 * @param rqcorr
	 * @param work
	 */
	public void dlar1v(int n, int b1, int bn, double lambda, double[] d, double[] l, double[] ld, double[] lld, double pivmin, double gaptol, double[] z, boolean wantnc, intW negcnt, doubleW ztz, doubleW mingma, intW r, int[] isuppz, doubleW nrminv, doubleW resid, doubleW rqcorr, double[] work) {
		org.netlib.lapack.Dlar1v.dlar1v(n, b1, bn, lambda, d, 0, l, 0, ld, 0, lld, 0, pivmin, gaptol, z, 0, wantnc, negcnt, ztz, mingma, r, isuppz, 0, nrminv, resid, rqcorr, work, 0);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLAR2V applies a vector of real plane rotations from both sides to
  a sequence of 2-by-2 real symmetric matrices, defined by the elements
  of the vectors x, y and z. For i = 1,2,...,n

     ( x(i)  z(i) ) := (  c(i)  s(i) ) ( x(i)  z(i) ) ( c(i) -s(i) )
     ( z(i)  y(i) )    ( -s(i)  c(i) ) ( z(i)  y(i) ) ( s(i)  c(i) )

  Arguments
  =========

  N       (input) INTEGER
          The number of plane rotations to be applied.

  X       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCX)
          The vector x.

  Y       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCX)
          The vector y.

  Z       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCX)
          The vector z.

  INCX    (input) INTEGER
          The increment between elements of X, Y and Z. INCX > 0.

  C       (input) DOUBLE PRECISION array, dimension (1+(N-1)*INCC)
          The cosines of the plane rotations.

  S       (input) DOUBLE PRECISION array, dimension (1+(N-1)*INCC)
          The sines of the plane rotations.

  INCC    (input) INTEGER
          The increment between elements of C and S. INCC > 0.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param x
	 * @param y
	 * @param z
	 * @param incx
	 * @param c
	 * @param s
	 * @param incc
	 */
	public abstract void dlar2v(int n, double[] x, double[] y, double[] z, int incx, double[] c, double[] s, int incc);

	/**
<pre>

     ..

  Purpose
  =======

  DLARF applies a real elementary reflector H to a real m by n matrix
  C, from either the left or the right. H is represented in the form

        H = I - tau * v * v'

  where tau is a real scalar and v is a real vector.

  If tau = 0, then H is taken to be the unit matrix.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': form  H * C
          = 'R': form  C * H

  M       (input) INTEGER
          The number of rows of the matrix C.

  N       (input) INTEGER
          The number of columns of the matrix C.

  V       (input) DOUBLE PRECISION array, dimension
                     (1 + (M-1)*abs(INCV)) if SIDE = 'L'
                  or (1 + (N-1)*abs(INCV)) if SIDE = 'R'
          The vector v in the representation of H. V is not used if
          TAU = 0.

  INCV    (input) INTEGER
          The increment between elements of v. INCV <> 0.

  TAU     (input) DOUBLE PRECISION
          The value tau in the representation of H.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by the matrix H * C if SIDE = 'L',

          or C * H if SIDE = 'R'.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                         (N) if SIDE = 'L'
                      or (M) if SIDE = 'R'

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param m
	 * @param n
	 * @param v
	 * @param incv
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 */
	public abstract void dlarf(String side, int m, int n, double[] v, int incv, double tau, double[] c, int Ldc, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  DLARFB applies a real block reflector H or its transpose H' to a
  real m by n matrix C, from either the left or the right.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply H or H' from the Left
          = 'R': apply H or H' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply H (No transpose)
          = 'T': apply H' (Transpose)

  DIRECT  (input) CHARACTER*1
          Indicates how H is formed from a product of elementary
          reflectors
          = 'F': H = H(1) H(2) . . . H(k) (Forward)
          = 'B': H = H(k) . . . H(2) H(1) (Backward)

  STOREV  (input) CHARACTER*1
          Indicates how the vectors which define the elementary
          reflectors are stored:
          = 'C': Columnwise
          = 'R': Rowwise

  M       (input) INTEGER
          The number of rows of the matrix C.

  N       (input) INTEGER
          The number of columns of the matrix C.

  K       (input) INTEGER
          The order of the matrix T (= the number of elementary
          reflectors whose product defines the block reflector).

  V       (input) DOUBLE PRECISION array, dimension
                                (LDV,K) if STOREV = 'C'
                                (LDV,M) if STOREV = 'R' and SIDE = 'L'

                                (LDV,N) if STOREV = 'R' and SIDE = 'R'

          The matrix V. See further details.

  LDV     (input) INTEGER
          The leading dimension of the array V.
          If STOREV = 'C' and SIDE = 'L', LDV >= max(1,M);
          if STOREV = 'C' and SIDE = 'R', LDV >= max(1,N);
          if STOREV = 'R', LDV >= K.

  T       (input) DOUBLE PRECISION array, dimension (LDT,K)
          The triangular k by k matrix T in the representation of the
          block reflector.

  LDT     (input) INTEGER
          The leading dimension of the array T. LDT >= K.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by H*C or H'*C or C*H or C*H'.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDA >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension (LDWORK,K)

  LDWORK  (input) INTEGER
          The leading dimension of the array WORK.
          If SIDE = 'L', LDWORK >= max(1,N);
          if SIDE = 'R', LDWORK >= max(1,M).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param direct
	 * @param storev
	 * @param m
	 * @param n
	 * @param k
	 * @param v
	 * @param ldv
	 * @param t
	 * @param ldt
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param ldwork
	 */
	public abstract void dlarfb(String side, String trans, String direct, String storev, int m, int n, int k, double[] v, int ldv, double[] t, int ldt, double[] c, int Ldc, double[] work, int ldwork);

	/**
<pre>

     ..

  Purpose
  =======

  DLARFG generates a real elementary reflector H of order n, such
  that

        H * ( alpha ) = ( beta ),   H' * H = I.
            (   x   )   (   0  )

  where alpha and beta are scalars, and x is an (n-1)-element real
  vector. H is represented in the form

        H = I - tau * ( 1 ) * ( 1 v' ) ,
                      ( v )

  where tau is a real scalar and v is a real (n-1)-element
  vector.

  If the elements of x are all zero, then tau = 0 and H is taken to be

  the unit matrix.

  Otherwise  1 <= tau <= 2.

  Arguments
  =========

  N       (input) INTEGER
          The order of the elementary reflector.

  ALPHA   (input/output) DOUBLE PRECISION
          On entry, the value alpha.
          On exit, it is overwritten with the value beta.

  X       (input/output) DOUBLE PRECISION array, dimension
                         (1+(N-2)*abs(INCX))
          On entry, the vector x.
          On exit, it is overwritten with the vector v.

  INCX    (input) INTEGER
          The increment between elements of X. INCX > 0.

  TAU     (output) DOUBLE PRECISION
          The value tau.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param alpha
	 * @param x
	 * @param incx
	 * @param tau
	 */
	public abstract void dlarfg(int n, doubleW alpha, double[] x, int incx, doubleW tau);

	/**
<pre>

     ..

  Purpose
  =======

  DLARFT forms the triangular factor T of a real block reflector H
  of order n, which is defined as a product of k elementary reflectors.

  If DIRECT = 'F', H = H(1) H(2) . . . H(k) and T is upper triangular;


  If DIRECT = 'B', H = H(k) . . . H(2) H(1) and T is lower triangular.


  If STOREV = 'C', the vector which defines the elementary reflector
  H(i) is stored in the i-th column of the array V, and

     H  =  I - V * T * V'

  If STOREV = 'R', the vector which defines the elementary reflector
  H(i) is stored in the i-th row of the array V, and

     H  =  I - V' * T * V

  Arguments
  =========

  DIRECT  (input) CHARACTER*1
          Specifies the order in which the elementary reflectors are
          multiplied to form the block reflector:
          = 'F': H = H(1) H(2) . . . H(k) (Forward)
          = 'B': H = H(k) . . . H(2) H(1) (Backward)

  STOREV  (input) CHARACTER*1
          Specifies how the vectors which define the elementary
          reflectors are stored (see also Further Details):
          = 'C': columnwise
          = 'R': rowwise

  N       (input) INTEGER
          The order of the block reflector H. N >= 0.

  K       (input) INTEGER
          The order of the triangular factor T (= the number of
          elementary reflectors). K >= 1.

  V       (input/output) DOUBLE PRECISION array, dimension
                               (LDV,K) if STOREV = 'C'
                               (LDV,N) if STOREV = 'R'
          The matrix V. See further details.

  LDV     (input) INTEGER
          The leading dimension of the array V.
          If STOREV = 'C', LDV >= max(1,N); if STOREV = 'R', LDV >= K.


  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i).

  T       (output) DOUBLE PRECISION array, dimension (LDT,K)
          The k by k triangular factor T of the block reflector.
          If DIRECT = 'F', T is upper triangular; if DIRECT = 'B', T is
          lower triangular. The rest of the array is not used.

  LDT     (input) INTEGER
          The leading dimension of the array T. LDT >= K.

  Further Details
  ===============

  The shape of the matrix V and the storage of the vectors which define
  the H(i) is best illustrated by the following example with n = 5 and

  k = 3. The elements equal to 1 are not stored; the corresponding
  array elements are modified but restored on exit. The rest of the
  array is not used.

  DIRECT = 'F' and STOREV = 'C':         DIRECT = 'F' and STOREV = 'R':

               V = (  1       )                 V = (  1 v1 v1 v1 v1 )

                   ( v1  1    )                     (     1 v2 v2 v2 )

                   ( v1 v2  1 )                     (        1 v3 v3 )

                   ( v1 v2 v3 )
                   ( v1 v2 v3 )

  DIRECT = 'B' and STOREV = 'C':         DIRECT = 'B' and STOREV = 'R':

               V = ( v1 v2 v3 )                 V = ( v1 v1  1       )

                   ( v1 v2 v3 )                     ( v2 v2 v2  1    )

                   (  1 v2 v3 )                     ( v3 v3 v3 v3  1 )

                   (     1 v3 )
                   (        1 )

  =====================================================================

     .. Parameters ..
</pre>
	 * @param direct
	 * @param storev
	 * @param n
	 * @param k
	 * @param v
	 * @param ldv
	 * @param tau
	 * @param t
	 * @param ldt
	 */
	public abstract void dlarft(String direct, String storev, int n, int k, double[] v, int ldv, double[] tau, double[] t, int ldt);

	/**
<pre>

     ..

  Purpose
  =======

  DLARFX applies a real elementary reflector H to a real m by n
  matrix C, from either the left or the right. H is represented in the

  form

        H = I - tau * v * v'

  where tau is a real scalar and v is a real vector.

  If tau = 0, then H is taken to be the unit matrix

  This version uses inline code if H has order < 11.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': form  H * C
          = 'R': form  C * H

  M       (input) INTEGER
          The number of rows of the matrix C.

  N       (input) INTEGER
          The number of columns of the matrix C.

  V       (input) DOUBLE PRECISION array, dimension (M) if SIDE = 'L'
                                     or (N) if SIDE = 'R'
          The vector v in the representation of H.

  TAU     (input) DOUBLE PRECISION
          The value tau in the representation of H.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by the matrix H * C if SIDE = 'L',

          or C * H if SIDE = 'R'.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDA >= (1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                      (N) if SIDE = 'L'
                      or (M) if SIDE = 'R'
          WORK is not referenced if H has order < 11.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param m
	 * @param n
	 * @param v
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 */
	public abstract void dlarfx(String side, int m, int n, double[] v, double tau, double[] c, int Ldc, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  DLARGV generates a vector of real plane rotations, determined by
  elements of the real vectors x and y. For i = 1,2,...,n

     (  c(i)  s(i) ) ( x(i) ) = ( a(i) )
     ( -s(i)  c(i) ) ( y(i) ) = (   0  )

  Arguments
  =========

  N       (input) INTEGER
          The number of plane rotations to be generated.

  X       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCX)
          On entry, the vector x.
          On exit, x(i) is overwritten by a(i), for i = 1,...,n.

  INCX    (input) INTEGER
          The increment between elements of X. INCX > 0.

  Y       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCY)
          On entry, the vector y.
          On exit, the sines of the plane rotations.

  INCY    (input) INTEGER
          The increment between elements of Y. INCY > 0.

  C       (output) DOUBLE PRECISION array, dimension (1+(N-1)*INCC)
          The cosines of the plane rotations.

  INCC    (input) INTEGER
          The increment between elements of C. INCC > 0.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param x
	 * @param incx
	 * @param y
	 * @param incy
	 * @param c
	 * @param incc
	 */
	public abstract void dlargv(int n, double[] x, int incx, double[] y, int incy, double[] c, int incc);

	/**
<pre>

     ..

  Purpose
  =======

  DLARNV returns a vector of n random real numbers from a uniform or
  normal distribution.

  Arguments
  =========

  IDIST   (input) INTEGER
          Specifies the distribution of the random numbers:
          = 1:  uniform (0,1)
          = 2:  uniform (-1,1)
          = 3:  normal (0,1)

  ISEED   (input/output) INTEGER array, dimension (4)
          On entry, the seed of the random number generator; the array

          elements must be between 0 and 4095, and ISEED(4) must be
          odd.
          On exit, the seed is updated.

  N       (input) INTEGER
          The number of random numbers to be generated.

  X       (output) DOUBLE PRECISION array, dimension (N)
          The generated random numbers.

  Further Details
  ===============

  This routine calls the auxiliary routine DLARUV to generate random
  real numbers from a uniform (0,1) distribution, in batches of up to
  128 using vectorisable code. The Box-Muller method is used to
  transform numbers from a uniform to a normal distribution.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param idist
	 * @param iseed
	 * @param n
	 * @param x
	 */
	public abstract void dlarnv(int idist, int[] iseed, int n, double[] x);

		/**
<pre>

     ..

  Purpose
  =======

  Compute the splitting points with threshold SPLTOL.
  DLARRA sets any "small" off-diagonal elements to zero.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix. N > 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          On entry, the N diagonal elements of the tridiagonal
          matrix T.

  E       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the first (N-1) entries contain the subdiagonal
          elements of the tridiagonal matrix T; E(N) need not be set.
          On exit, the entries E( ISPLIT( I ) ), 1 <= I <= NSPLIT,
          are set to zero, the other entries of E are untouched.

  E2      (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the first (N-1) entries contain the SQUARES of the

          subdiagonal elements of the tridiagonal matrix T;
          E2(N) need not be set.
          On exit, the entries E2( ISPLIT( I ) ),
          1 <= I <= NSPLIT, have been set to zero

  SPLTOL (input) DOUBLE PRECISION
          The threshold for splitting. Two criteria can be used:
          SPLTOL<0 : criterion based on absolute off-diagonal value
          SPLTOL>0 : criterion that preserves relative accuracy

  TNRM (input) DOUBLE PRECISION
          The norm of the matrix.

  NSPLIT  (output) INTEGER
          The number of blocks T splits into. 1 <= NSPLIT <= N.

  ISPLIT  (output) INTEGER array, dimension (N)
          The splitting points, at which T breaks up into blocks.
          The first block consists of rows/columns 1 to ISPLIT(1),
          the second of rows/columns ISPLIT(1)+1 through ISPLIT(2),
          etc., and the NSPLIT-th consists of rows/columns
          ISPLIT(NSPLIT-1)+1 through ISPLIT(NSPLIT)=N.


  INFO    (output) INTEGER
          = 0:  successful exit

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param e
	 * @param e2
	 * @param spltol
	 * @param tnrm
	 * @param nsplit
	 * @param isplit
	 * @param info
	 */
	public void dlarra(int n, double[] d, double[] e, double[] e2, double spltol, double tnrm, intW nsplit, int[] isplit, intW info) {
		org.netlib.lapack.Dlarra.dlarra(n, d, 0, e, 0, e2, 0, spltol, tnrm, nsplit, isplit, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  Given the relatively robust representation(RRR) L D L^T, DLARRB
  does "limited" bisection to refine the eigenvalues of L D L^T,
  W( IFIRST-OFFSET ) through W( ILAST-OFFSET ), to more accuracy. Initi
  guesses for these eigenvalues are input in W, the corresponding estim
  of the error in these guesses and their gaps are input in WERR
  and WGAP, respectively. During bisection, intervals
  [left, right] are maintained by storing their mid-points and
  semi-widths in the arrays W and WERR respectively.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The N diagonal elements of the diagonal matrix D.

  LLD     (input) DOUBLE PRECISION array, dimension (N-1)
          The (N-1) elements L(i)*L(i)*D(i).

  IFIRST  (input) INTEGER
          The index of the first eigenvalue to be computed.

  ILAST   (input) INTEGER
          The index of the last eigenvalue to be computed.

  RTOL1   (input) DOUBLE PRECISION
  RTOL2   (input) DOUBLE PRECISION
          Tolerance for the convergence of the bisection intervals.
          An interval [LEFT,RIGHT] has converged if
          RIGHT-LEFT.LT.MAX( RTOL1*GAP, RTOL2*MAX(|LEFT|,|RIGHT|) )
          where GAP is the (estimated) distance to the nearest
          eigenvalue.

  OFFSET  (input) INTEGER
          Offset for the arrays W, WGAP and WERR, i.e., the IFIRST-OFFS
          through ILAST-OFFSET elements of these arrays are to be used.

  W       (input/output) DOUBLE PRECISION array, dimension (N)
          On input, W( IFIRST-OFFSET ) through W( ILAST-OFFSET ) are
          estimates of the eigenvalues of L D L^T indexed IFIRST throug
          ILAST.
          On output, these estimates are refined.

  WGAP    (input/output) DOUBLE PRECISION array, dimension (N-1)
          On input, the (estimated) gaps between consecutive
          eigenvalues of L D L^T, i.e., WGAP(I-OFFSET) is the gap betwe
          eigenvalues I and I+1. Note that if IFIRST.EQ.ILAST
          then WGAP(IFIRST-OFFSET) must be set to ZERO.
          On output, these gaps are refined.

  WERR    (input/output) DOUBLE PRECISION array, dimension (N)
          On input, WERR( IFIRST-OFFSET ) through WERR( ILAST-OFFSET ) 
          the errors in the estimates of the corresponding elements in 
          On output, these errors are refined.

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
          Workspace.

  IWORK   (workspace) INTEGER array, dimension (2*N)
          Workspace.

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot in the Sturm sequence.

  SPDIAM  (input) DOUBLE PRECISION
          The spectral diameter of the matrix.

  TWIST   (input) INTEGER
          The twist index for the twisted factorization that is used
          for the negcount.
          TWIST = N: Compute negcount from L D L^T - LAMBDA I = L+ D+ L
          TWIST = 1: Compute negcount from L D L^T - LAMBDA I = U- D- U
          TWIST = R: Compute negcount from L D L^T - LAMBDA I = N(r) D(

  INFO    (output) INTEGER
          Error flag.

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param lld
	 * @param ifirst
	 * @param ilast
	 * @param rtol1
	 * @param rtol2
	 * @param offset
	 * @param w
	 * @param wgap
	 * @param werr
	 * @param work
	 * @param iwork
	 * @param pivmin
	 * @param spdiam
	 * @param twist
	 * @param info
	 */
	public void dlarrb(int n, double[] d, double[] lld, int ifirst, int ilast, double rtol1, double rtol2, int offset, double[] w, double[] wgap, double[] werr, double[] work, int[] iwork, double pivmin, double spdiam, int twist, intW info) {
		org.netlib.lapack.Dlarrb.dlarrb(n, d, 0, lld, 0, ifirst, ilast, rtol1, rtol2, offset, w, 0, wgap, 0, werr, 0, work, 0, iwork, 0, pivmin, spdiam, twist, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  Find the number of eigenvalues of the symmetric tridiagonal matrix T

  that are in the interval (VL,VU] if JOBT = 'T', and of L D L^T
  if JOBT = 'L'.

  Arguments
  =========

  JOBT    (input) CHARACTER*1
          = 'T':  Compute Sturm count for matrix T.
          = 'L':  Compute Sturm count for matrix L D L^T.

  N       (input) INTEGER
          The order of the matrix. N > 0.

  VL      (input) DOUBLE PRECISION
  VU      (input) DOUBLE PRECISION
          The lower and upper bounds for the eigenvalues.

  D       (input) DOUBLE PRECISION array, dimension (N)
          JOBT = 'T': The N diagonal elements of the tridiagonal matrix
          JOBT = 'L': The N diagonal elements of the diagonal matrix D.

  E       (input) DOUBLE PRECISION array, dimension (N)
          JOBT = 'T': The N-1 offdiagonal elements of the matrix T.
          JOBT = 'L': The N-1 offdiagonal elements of the matrix L.

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot in the Sturm sequence for T.

  EIGCNT  (output) INTEGER
          The number of eigenvalues of the symmetric tridiagonal matrix
          that are in the interval (VL,VU]

  LCNT    (output) INTEGER
  RCNT    (output) INTEGER
          The left and right negcounts of the interval.

  INFO    (output) INTEGER

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobt
	 * @param n
	 * @param vl
	 * @param vu
	 * @param d
	 * @param e
	 * @param pivmin
	 * @param eigcnt
	 * @param lcnt
	 * @param rcnt
	 * @param info
	 */
	public void dlarrc(String jobt, int n, double vl, double vu, double[] d, double[] e, double pivmin, intW eigcnt, intW lcnt, intW rcnt, intW info) {
		org.netlib.lapack.Dlarrc.dlarrc(jobt, n, vl, vu, d, 0, e, 0, pivmin, eigcnt, lcnt, rcnt, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLARRD computes the eigenvalues of a symmetric tridiagonal
  matrix T to suitable accuracy. This is an auxiliary code to be
  called from DSTEMR.
  The user may ask for all eigenvalues, all eigenvalues
  in the half-open interval (VL, VU], or the IL-th through IU-th
  eigenvalues.

  To avoid overflow, the matrix must be scaled so that its
  largest element is no greater than overflow**(1/2) *
  underflow**(1/4) in absolute value, and for greatest
  accuracy, it should not be much smaller than that.

  See W. Kahan "Accurate Eigenvalues of a Symmetric Tridiagonal
  Matrix", Report CS41, Computer Science Dept., Stanford
  University, July 21, 1966.

  Arguments
  =========

  RANGE   (input) CHARACTER
          = 'A': ("All")   all eigenvalues will be found.
          = 'V': ("Value") all eigenvalues in the half-open interval
                           (VL, VU] will be found.
          = 'I': ("Index") the IL-th through IU-th eigenvalues (of the

                           entire matrix) will be found.

  ORDER   (input) CHARACTER
          = 'B': ("By Block") the eigenvalues will be grouped by
                              split-off block (see IBLOCK, ISPLIT) and

                              ordered from smallest to largest within
                              the block.
          = 'E': ("Entire matrix")
                              the eigenvalues for the entire matrix
                              will be ordered from smallest to
                              largest.

  N       (input) INTEGER
          The order of the tridiagonal matrix T.  N >= 0.

  VL      (input) DOUBLE PRECISION
  VU      (input) DOUBLE PRECISION
          If RANGE='V', the lower and upper bounds of the interval to
          be searched for eigenvalues.  Eigenvalues less than or equal

          to VL, or greater than VU, will not be returned.  VL < VU.
          Not referenced if RANGE = 'A' or 'I'.

  IL      (input) INTEGER
  IU      (input) INTEGER
          If RANGE='I', the indices (in ascending order) of the
          smallest and largest eigenvalues to be returned.
          1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.
          Not referenced if RANGE = 'A' or 'V'.

  GERS    (input) DOUBLE PRECISION array, dimension (2*N)
          The N Gerschgorin intervals (the i-th Gerschgorin interval
          is (GERS(2*i-1), GERS(2*i)).

  RELTOL  (input) DOUBLE PRECISION
          The minimum relative width of an interval.  When an interval

          is narrower than RELTOL times the larger (in
          magnitude) endpoint, then it is considered to be
          sufficiently small, i.e., converged.  Note: this should
          always be at least radix*machine epsilon.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the tridiagonal matrix T.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) off-diagonal elements of the tridiagonal matrix T.


  E2      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) squared off-diagonal elements of the tridiagonal ma

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot allowed in the Sturm sequence for T.

  NSPLIT  (input) INTEGER
          The number of diagonal blocks in the matrix T.
          1 <= NSPLIT <= N.

  ISPLIT  (input) INTEGER array, dimension (N)
          The splitting points, at which T breaks up into submatrices.

          The first submatrix consists of rows/columns 1 to ISPLIT(1),

          the second of rows/columns ISPLIT(1)+1 through ISPLIT(2),
          etc., and the NSPLIT-th consists of rows/columns
          ISPLIT(NSPLIT-1)+1 through ISPLIT(NSPLIT)=N.
          (Only the first NSPLIT elements will actually be used, but
          since the user cannot know a priori what value NSPLIT will
          have, N words must be reserved for ISPLIT.)

  M       (output) INTEGER
          The actual number of eigenvalues found. 0 <= M <= N.
          (See also the description of INFO=2,3.)

  W       (output) DOUBLE PRECISION array, dimension (N)
          On exit, the first M elements of W will contain the
          eigenvalue approximations. DLARRD computes an interval
          I_j = (a_j, b_j] that includes eigenvalue j. The eigenvalue
          approximation is given as the interval midpoint
          W(j)= ( a_j + b_j)/2. The corresponding error is bounded by
          WERR(j) = abs( a_j - b_j)/2

  WERR    (output) DOUBLE PRECISION array, dimension (N)
          The error bound on the corresponding eigenvalue approximation
          in W.

  WL      (output) DOUBLE PRECISION
  WU      (output) DOUBLE PRECISION
          The interval (WL, WU] contains all the wanted eigenvalues.
          If RANGE='V', then WL=VL and WU=VU.
          If RANGE='A', then WL and WU are the global Gerschgorin bound
                        on the spectrum.
          If RANGE='I', then WL and WU are computed by DLAEBZ from the

                        index range specified.

  IBLOCK  (output) INTEGER array, dimension (N)
          At each row/column j where E(j) is zero or small, the
          matrix T is considered to split into a block diagonal
          matrix.  On exit, if INFO = 0, IBLOCK(i) specifies to which
          block (from 1 to the number of blocks) the eigenvalue W(i)
          belongs.  (DLARRD may use the remaining N-M elements as
          workspace.)

  INDEXW  (output) INTEGER array, dimension (N)
          The indices of the eigenvalues within each block (submatrix);
          for example, INDEXW(i)= j and IBLOCK(i)=k imply that the
          i-th eigenvalue W(i) is the j-th eigenvalue in block k.

  WORK    (workspace) DOUBLE PRECISION array, dimension (4*N)

  IWORK   (workspace) INTEGER array, dimension (3*N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  some or all of the eigenvalues failed to converge or
                were not computed:
                =1 or 3: Bisection failed to converge for some
                        eigenvalues; these eigenvalues are flagged by a
                        negative block number.  The effect is that the

                        eigenvalues may not be as accurate as the
                        absolute and relative tolerances.  This is
                        generally caused by unexpectedly inaccurate
                        arithmetic.
                =2 or 3: RANGE='I' only: Not all of the eigenvalues
                        IL:IU were found.
                        Effect: M < IU+1-IL
                        Cause:  non-monotonic arithmetic, causing the
                                Sturm sequence to be non-monotonic.
                        Cure:   recalculate, using RANGE='A', and pick

                                out eigenvalues IL:IU.  In some cases,

                                increasing the PARAMETER "FUDGE" may
                                make things work.
                = 4:    RANGE='I', and the Gershgorin interval
                        initially used was too small.  No eigenvalues
                        were computed.
                        Probable cause: your machine has sloppy
                                        floating-point arithmetic.
                        Cure: Increase the PARAMETER "FUDGE",
                              recompile, and try again.

  Internal Parameters
  ===================

  FUDGE   DOUBLE PRECISION, default = 2
          A "fudge factor" to widen the Gershgorin intervals.  Ideally,
          a value of 1 should work, but on machines with sloppy
          arithmetic, this needs to be larger.  The default for
          publicly released versions should be large enough to handle
          the worst machine around.  Note that this has no effect
          on accuracy of the solution.

  Based on contributions by
     W. Kahan, University of California, Berkeley, USA
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param range
	 * @param order
	 * @param n
	 * @param vl
	 * @param vu
	 * @param il
	 * @param iu
	 * @param gers
	 * @param reltol
	 * @param d
	 * @param e
	 * @param e2
	 * @param pivmin
	 * @param nsplit
	 * @param isplit
	 * @param m
	 * @param w
	 * @param werr
	 * @param wl
	 * @param wu
	 * @param iblock
	 * @param indexw
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public void dlarrd(String range, String order, int n, double vl, double vu, int il, int iu, double[] gers, double reltol, double[] d, double[] e, double[] e2, double pivmin, int nsplit, int[] isplit, intW m, double[] w, double[] werr, doubleW wl, doubleW wu, int[] iblock, int[] indexw, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlarrd.dlarrd(range, order, n, vl, vu, il, iu, gers, 0, reltol, d, 0, e, 0, e2, 0, pivmin, nsplit, isplit, 0, m, w, 0, werr, 0, wl, wu, iblock, 0, indexw, 0, work, 0, iwork, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  To find the desired eigenvalues of a given real symmetric
  tridiagonal matrix T, DLARRE sets any "small" off-diagonal
  elements to zero, and for each unreduced block T_i, it finds
  (a) a suitable shift at one end of the block's spectrum,
  (b) the base representation, T_i - sigma_i I = L_i D_i L_i^T, and
  (c) eigenvalues of each L_i D_i L_i^T.
  The representations and eigenvalues found are then used by
  DSTEMR to compute the eigenvectors of T.
  The accuracy varies depending on whether bisection is used to
  find a few eigenvalues or the dqds algorithm (subroutine DLASQ2) to
  conpute all and then discard any unwanted one.
  As an added benefit, DLARRE also outputs the n
  Gerschgorin intervals for the matrices L_i D_i L_i^T.

  Arguments
  =========

  RANGE   (input) CHARACTER
          = 'A': ("All")   all eigenvalues will be found.
          = 'V': ("Value") all eigenvalues in the half-open interval
                           (VL, VU] will be found.
          = 'I': ("Index") the IL-th through IU-th eigenvalues (of the

                           entire matrix) will be found.

  N       (input) INTEGER
          The order of the matrix. N > 0.

  VL      (input/output) DOUBLE PRECISION
  VU      (input/output) DOUBLE PRECISION
          If RANGE='V', the lower and upper bounds for the eigenvalues.
          Eigenvalues less than or equal to VL, or greater than VU,
          will not be returned.  VL < VU.
          If RANGE='I' or ='A', DLARRE computes bounds on the desired
          part of the spectrum.

  IL      (input) INTEGER
  IU      (input) INTEGER
          If RANGE='I', the indices (in ascending order) of the
          smallest and largest eigenvalues to be returned.
          1 <= IL <= IU <= N.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the N diagonal elements of the tridiagonal
          matrix T.
          On exit, the N diagonal elements of the diagonal
          matrices D_i.

  E       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the first (N-1) entries contain the subdiagonal
          elements of the tridiagonal matrix T; E(N) need not be set.
          On exit, E contains the subdiagonal elements of the unit
          bidiagonal matrices L_i. The entries E( ISPLIT( I ) ),
          1 <= I <= NSPLIT, contain the base points sigma_i on output.


  E2      (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the first (N-1) entries contain the SQUARES of the

          subdiagonal elements of the tridiagonal matrix T;
          E2(N) need not be set.
          On exit, the entries E2( ISPLIT( I ) ),
          1 <= I <= NSPLIT, have been set to zero

  RTOL1   (input) DOUBLE PRECISION
  RTOL2   (input) DOUBLE PRECISION
           Parameters for bisection.
           An interval [LEFT,RIGHT] has converged if
           RIGHT-LEFT.LT.MAX( RTOL1*GAP, RTOL2*MAX(|LEFT|,|RIGHT|) )

  SPLTOL (input) DOUBLE PRECISION
          The threshold for splitting.

  NSPLIT  (output) INTEGER
          The number of blocks T splits into. 1 <= NSPLIT <= N.

  ISPLIT  (output) INTEGER array, dimension (N)
          The splitting points, at which T breaks up into blocks.
          The first block consists of rows/columns 1 to ISPLIT(1),
          the second of rows/columns ISPLIT(1)+1 through ISPLIT(2),
          etc., and the NSPLIT-th consists of rows/columns
          ISPLIT(NSPLIT-1)+1 through ISPLIT(NSPLIT)=N.

  M       (output) INTEGER
          The total number of eigenvalues (of all L_i D_i L_i^T)
          found.

  W       (output) DOUBLE PRECISION array, dimension (N)
          The first M elements contain the eigenvalues. The
          eigenvalues of each of the blocks, L_i D_i L_i^T, are
          sorted in ascending order ( DLARRE may use the
          remaining N-M elements as workspace).

  WERR    (output) DOUBLE PRECISION array, dimension (N)
          The error bound on the corresponding eigenvalue in W.

  WGAP    (output) DOUBLE PRECISION array, dimension (N)
          The separation from the right neighbor eigenvalue in W.
          The gap is only with respect to the eigenvalues of the same b
          as each block has its own representation tree.
          Exception: at the right end of a block we store the left gap


  IBLOCK  (output) INTEGER array, dimension (N)
          The indices of the blocks (submatrices) associated with the
          corresponding eigenvalues in W; IBLOCK(i)=1 if eigenvalue
          W(i) belongs to the first block from the top, =2 if W(i)
          belongs to the second block, etc.

  INDEXW  (output) INTEGER array, dimension (N)
          The indices of the eigenvalues within each block (submatrix);
          for example, INDEXW(i)= 10 and IBLOCK(i)=2 imply that the
          i-th eigenvalue W(i) is the 10-th eigenvalue in block 2

  GERS    (output) DOUBLE PRECISION array, dimension (2*N)
          The N Gerschgorin intervals (the i-th Gerschgorin interval
          is (GERS(2*i-1), GERS(2*i)).

  PIVMIN  (output) DOUBLE PRECISION
          The minimum pivot in the Sturm sequence for T.

  WORK    (workspace) DOUBLE PRECISION array, dimension (6*N)
          Workspace.

  IWORK   (workspace) INTEGER array, dimension (5*N)
          Workspace.

  INFO    (output) INTEGER
          = 0:  successful exit
          > 0:  A problem occured in DLARRE.
          < 0:  One of the called subroutines signaled an internal prob
                Needs inspection of the corresponding parameter IINFO
                for further information.

          =-1:  Problem in DLARRD.
          = 2:  No base representation could be found in MAXTRY iterati
                Increasing MAXTRY and recompilation might be a remedy.

          =-3:  Problem in DLARRB when computing the refined root
                representation for DLASQ2.
          =-4:  Problem in DLARRB when preforming bisection on the
                desired part of the spectrum.
          =-5:  Problem in DLASQ2.
          =-6:  Problem in DLASQ2.

  Further Details
  The base representations are required to suffer very little
  element growth and consequently define all their eigenvalues to
  high relative accuracy.
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param range
	 * @param n
	 * @param vl
	 * @param vu
	 * @param il
	 * @param iu
	 * @param d
	 * @param e
	 * @param e2
	 * @param rtol1
	 * @param rtol2
	 * @param spltol
	 * @param nsplit
	 * @param isplit
	 * @param m
	 * @param w
	 * @param werr
	 * @param wgap
	 * @param iblock
	 * @param indexw
	 * @param gers
	 * @param pivmin
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public void dlarre(String range, int n, doubleW vl, doubleW vu, int il, int iu, double[] d, double[] e, double[] e2, double rtol1, double rtol2, double spltol, intW nsplit, int[] isplit, intW m, double[] w, double[] werr, double[] wgap, int[] iblock, int[] indexw, double[] gers, doubleW pivmin, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlarre.dlarre(range, n, vl, vu, il, iu, d, 0, e, 0, e2, 0, rtol1, rtol2, spltol, nsplit, isplit, 0, m, w, 0, werr, 0, wgap, 0, iblock, 0, indexw, 0, gers, 0, pivmin, work, 0, iwork, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  Given the initial representation L D L^T and its cluster of close
  eigenvalues (in a relative measure), W( CLSTRT ), W( CLSTRT+1 ), ...

  W( CLEND ), DLARRF finds a new relatively robust representation
  L D L^T - SIGMA I = L(+) D(+) L(+)^T such that at least one of the
  eigenvalues of L(+) D(+) L(+)^T is relatively isolated.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix (subblock, if the matrix splitted).

  D       (input) DOUBLE PRECISION array, dimension (N)
          The N diagonal elements of the diagonal matrix D.

  L       (input) DOUBLE PRECISION array, dimension (N-1)
          The (N-1) subdiagonal elements of the unit bidiagonal
          matrix L.

  LD      (input) DOUBLE PRECISION array, dimension (N-1)
          The (N-1) elements L(i)*D(i).

  CLSTRT  (input) INTEGER
          The index of the first eigenvalue in the cluster.

  CLEND   (input) INTEGER
          The index of the last eigenvalue in the cluster.

  W       (input) DOUBLE PRECISION array, dimension >=  (CLEND-CLSTRT+1
          The eigenvalue APPROXIMATIONS of L D L^T in ascending order.

          W( CLSTRT ) through W( CLEND ) form the cluster of relatively
          close eigenalues.

  WGAP    (input/output) DOUBLE PRECISION array, dimension >=  (CLEND-C
          The separation from the right neighbor eigenvalue in W.

  WERR    (input) DOUBLE PRECISION array, dimension >=  (CLEND-CLSTRT+1
          WERR contain the semiwidth of the uncertainty
          interval of the corresponding eigenvalue APPROXIMATION in W

  SPDIAM (input) estimate of the spectral diameter obtained from the
          Gerschgorin intervals

  CLGAPL, CLGAPR (input) absolute gap on each end of the cluster.
          Set by the calling routine to protect against shifts too clos
          to eigenvalues outside the cluster.

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot allowed in the Sturm sequence.

  SIGMA   (output) DOUBLE PRECISION
          The shift used to form L(+) D(+) L(+)^T.

  DPLUS   (output) DOUBLE PRECISION array, dimension (N)
          The N diagonal elements of the diagonal matrix D(+).

  LPLUS   (output) DOUBLE PRECISION array, dimension (N-1)
          The first (N-1) elements of LPLUS contain the subdiagonal
          elements of the unit bidiagonal matrix L(+).

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
          Workspace.

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param l
	 * @param ld
	 * @param clstrt
	 * @param clend
	 * @param w
	 * @param wgap
	 * @param werr
	 * @param spdiam
	 * @param clgapl
	 * @param clgapr
	 * @param pivmin
	 * @param sigma
	 * @param dplus
	 * @param lplus
	 * @param work
	 * @param info
	 */
	public void dlarrf(int n, double[] d, double[] l, double[] ld, int clstrt, int clend, double[] w, double[] wgap, double[] werr, double spdiam, double clgapl, double clgapr, double pivmin, doubleW sigma, double[] dplus, double[] lplus, double[] work, intW info) {
		org.netlib.lapack.Dlarrf.dlarrf(n, d, 0, l, 0, ld, 0, clstrt, clend, w, 0, wgap, 0, werr, 0, spdiam, clgapl, clgapr, pivmin, sigma, dplus, 0, lplus, 0, work, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  Given the initial eigenvalue approximations of T, DLARRJ
  does  bisection to refine the eigenvalues of T,
  W( IFIRST-OFFSET ) through W( ILAST-OFFSET ), to more accuracy. Initi
  guesses for these eigenvalues are input in W, the corresponding estim
  of the error in these guesses in WERR. During bisection, intervals
  [left, right] are maintained by storing their mid-points and
  semi-widths in the arrays W and WERR respectively.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The N diagonal elements of T.

  E2      (input) DOUBLE PRECISION array, dimension (N-1)
          The Squares of the (N-1) subdiagonal elements of T.

  IFIRST  (input) INTEGER
          The index of the first eigenvalue to be computed.

  ILAST   (input) INTEGER
          The index of the last eigenvalue to be computed.

  RTOL   (input) DOUBLE PRECISION
          Tolerance for the convergence of the bisection intervals.
          An interval [LEFT,RIGHT] has converged if
          RIGHT-LEFT.LT.RTOL*MAX(|LEFT|,|RIGHT|).

  OFFSET  (input) INTEGER
          Offset for the arrays W and WERR, i.e., the IFIRST-OFFSET
          through ILAST-OFFSET elements of these arrays are to be used.

  W       (input/output) DOUBLE PRECISION array, dimension (N)
          On input, W( IFIRST-OFFSET ) through W( ILAST-OFFSET ) are
          estimates of the eigenvalues of L D L^T indexed IFIRST throug
          ILAST.
          On output, these estimates are refined.

  WERR    (input/output) DOUBLE PRECISION array, dimension (N)
          On input, WERR( IFIRST-OFFSET ) through WERR( ILAST-OFFSET ) 
          the errors in the estimates of the corresponding elements in 
          On output, these errors are refined.

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)
          Workspace.

  IWORK   (workspace) INTEGER array, dimension (2*N)
          Workspace.

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot in the Sturm sequence for T.

  SPDIAM  (input) DOUBLE PRECISION
          The spectral diameter of T.

  INFO    (output) INTEGER
          Error flag.

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param e2
	 * @param ifirst
	 * @param ilast
	 * @param rtol
	 * @param offset
	 * @param w
	 * @param werr
	 * @param work
	 * @param iwork
	 * @param pivmin
	 * @param spdiam
	 * @param info
	 */
	public void dlarrj(int n, double[] d, double[] e2, int ifirst, int ilast, double rtol, int offset, double[] w, double[] werr, double[] work, int[] iwork, double pivmin, double spdiam, intW info) {
		org.netlib.lapack.Dlarrj.dlarrj(n, d, 0, e2, 0, ifirst, ilast, rtol, offset, w, 0, werr, 0, work, 0, iwork, 0, pivmin, spdiam, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLARRK computes one eigenvalue of a symmetric tridiagonal
  matrix T to suitable accuracy. This is an auxiliary code to be
  called from DSTEMR.

  To avoid overflow, the matrix must be scaled so that its
  largest element is no greater than overflow**(1/2) *
  underflow**(1/4) in absolute value, and for greatest
  accuracy, it should not be much smaller than that.

  See W. Kahan "Accurate Eigenvalues of a Symmetric Tridiagonal
  Matrix", Report CS41, Computer Science Dept., Stanford
  University, July 21, 1966.

  Arguments
  =========

  N       (input) INTEGER
          The order of the tridiagonal matrix T.  N >= 0.

  IW      (input) INTEGER
          The index of the eigenvalues to be returned.

  GL      (input) DOUBLE PRECISION
  GU      (input) DOUBLE PRECISION
          An upper and a lower bound on the eigenvalue.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the tridiagonal matrix T.

  E2      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) squared off-diagonal elements of the tridiagonal ma

  PIVMIN  (input) DOUBLE PRECISION
          The minimum pivot allowed in the Sturm sequence for T.

  RELTOL  (input) DOUBLE PRECISION
          The minimum relative width of an interval.  When an interval

          is narrower than RELTOL times the larger (in
          magnitude) endpoint, then it is considered to be
          sufficiently small, i.e., converged.  Note: this should
          always be at least radix*machine epsilon.

  W       (output) DOUBLE PRECISION

  WERR    (output) DOUBLE PRECISION
          The error bound on the corresponding eigenvalue approximation
          in W.

  INFO    (output) INTEGER
          = 0:       Eigenvalue converged
          = -1:      Eigenvalue did NOT converge

  Internal Parameters
  ===================

  FUDGE   DOUBLE PRECISION, default = 2
          A "fudge factor" to widen the Gershgorin intervals.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param iw
	 * @param gl
	 * @param gu
	 * @param d
	 * @param e2
	 * @param pivmin
	 * @param reltol
	 * @param w
	 * @param werr
	 * @param info
	 */
	public void dlarrk(int n, int iw, double gl, double gu, double[] d, double[] e2, double pivmin, double reltol, doubleW w, doubleW werr, intW info) {
		org.netlib.lapack.Dlarrk.dlarrk(n, iw, gl, gu, d, 0, e2, 0, pivmin, reltol, w, werr, info);
	}

		/**
<pre>

     ..


  Purpose
  =======

  Perform tests to decide whether the symmetric tridiagonal matrix T
  warrants expensive computations which guarantee high relative accurac
  in the eigenvalues.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix. N > 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The N diagonal elements of the tridiagonal matrix T.

  E       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the first (N-1) entries contain the subdiagonal
          elements of the tridiagonal matrix T; E(N) is set to ZERO.

  INFO    (output) INTEGER
          INFO = 0(default) : the matrix warrants computations preservi
                              relative accuracy.
          INFO = 1          : the matrix warrants computations guarante
                              only absolute accuracy.

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param e
	 * @param info
	 */
	public void dlarrr(int n, double[] d, double[] e, intW info) {
		org.netlib.lapack.Dlarrr.dlarrr(n, d, 0, e, 0, info);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLARRV computes the eigenvectors of the tridiagonal matrix
  T = L D L^T given L, D and APPROXIMATIONS to the eigenvalues of L D L
  The input eigenvalues should have been computed by DLARRE.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix.  N >= 0.

  VL      (input) DOUBLE PRECISION
  VU      (input) DOUBLE PRECISION
          Lower and upper bounds of the interval that contains the desi
          eigenvalues. VL < VU. Needed to compute gaps on the left or r
          end of the extremal eigenvalues in the desired RANGE.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the N diagonal elements of the diagonal matrix D.
          On exit, D may be overwritten.

  L       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the (N-1) subdiagonal elements of the unit
          bidiagonal matrix L are in elements 1 to N-1 of L
          (if the matrix is not splitted.) At the end of each block
          is stored the corresponding shift as given by DLARRE.
          On exit, L is overwritten.

  PIVMIN  (in) DOUBLE PRECISION
          The minimum pivot allowed in the Sturm sequence.

  ISPLIT  (input) INTEGER array, dimension (N)
          The splitting points, at which T breaks up into blocks.
          The first block consists of rows/columns 1 to
          ISPLIT( 1 ), the second of rows/columns ISPLIT( 1 )+1
          through ISPLIT( 2 ), etc.

  M       (input) INTEGER
          The total number of input eigenvalues.  0 <= M <= N.

  DOL     (input) INTEGER
  DOU     (input) INTEGER
          If the user wants to compute only selected eigenvectors from 
          the eigenvalues supplied, he can specify an index range DOL:D
          Or else the setting DOL=1, DOU=M should be applied.
          Note that DOL and DOU refer to the order in which the eigenva
          are stored in W.
          If the user wants to compute only selected eigenpairs, then
          the columns DOL-1 to DOU+1 of the eigenvector space Z contain
          computed eigenvectors. All other columns of Z are set to zero

  MINRGP  (input) DOUBLE PRECISION

  RTOL1   (input) DOUBLE PRECISION
  RTOL2   (input) DOUBLE PRECISION
           Parameters for bisection.
           An interval [LEFT,RIGHT] has converged if
           RIGHT-LEFT.LT.MAX( RTOL1*GAP, RTOL2*MAX(|LEFT|,|RIGHT|) )

  W       (input/output) DOUBLE PRECISION array, dimension (N)
          The first M elements of W contain the APPROXIMATE eigenvalues
          which eigenvectors are to be computed.  The eigenvalues
          should be grouped by split-off block and ordered from
          smallest to largest within the block ( The output array
          W from DLARRE is expected here ). Furthermore, they are with

          respect to the shift of the corresponding root representation
          for their block. On exit, W holds the eigenvalues of the
          UNshifted matrix.

  WERR    (input/output) DOUBLE PRECISION array, dimension (N)
          The first M elements contain the semiwidth of the uncertainty
          interval of the corresponding eigenvalue in W

  WGAP    (input/output) DOUBLE PRECISION array, dimension (N)
          The separation from the right neighbor eigenvalue in W.

  IBLOCK  (input) INTEGER array, dimension (N)
          The indices of the blocks (submatrices) associated with the
          corresponding eigenvalues in W; IBLOCK(i)=1 if eigenvalue
          W(i) belongs to the first block from the top, =2 if W(i)
          belongs to the second block, etc.

  INDEXW  (input) INTEGER array, dimension (N)
          The indices of the eigenvalues within each block (submatrix);
          for example, INDEXW(i)= 10 and IBLOCK(i)=2 imply that the
          i-th eigenvalue W(i) is the 10-th eigenvalue in the second bl

  GERS    (input) DOUBLE PRECISION array, dimension (2*N)
          The N Gerschgorin intervals (the i-th Gerschgorin interval
          is (GERS(2*i-1), GERS(2*i)). The Gerschgorin intervals should
          be computed from the original UNshifted matrix.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, max(1,M) )
          If INFO = 0, the first M columns of Z contain the
          orthonormal eigenvectors of the matrix T
          corresponding to the input eigenvalues, with the i-th
          column of Z holding the eigenvector associated with W(i).
          Note: the user must ensure that at least max(1,M) columns are
          supplied in the array Z.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= max(1,N).

  ISUPPZ  (output) INTEGER array, dimension ( 2*max(1,M) )
          The support of the eigenvectors in Z, i.e., the indices
          indicating the nonzero elements in Z. The I-th eigenvector
          is nonzero only in elements ISUPPZ( 2*I-1 ) through
          ISUPPZ( 2*I ).

  WORK    (workspace) DOUBLE PRECISION array, dimension (12*N)

  IWORK   (workspace) INTEGER array, dimension (7*N)

  INFO    (output) INTEGER
          = 0:  successful exit

          > 0:  A problem occured in DLARRV.
          < 0:  One of the called subroutines signaled an internal prob
                Needs inspection of the corresponding parameter IINFO
                for further information.

          =-1:  Problem in DLARRB when refining a child's eigenvalues.

          =-2:  Problem in DLARRF when computing the RRR of a child.
                When a child is inside a tight cluster, it can be diffi
                to find an RRR. A partial remedy from the user's point 
                view is to make the parameter MINRGP smaller and recomp
                However, as the orthogonality of the computed vectors i
                proportional to 1/MINRGP, the user should be aware that
                he might be trading in precision when he decreases MINR
          =-3:  Problem in DLARRB when refining a single eigenvalue
                after the Rayleigh correction was rejected.
          = 5:  The Rayleigh Quotient Iteration failed to converge to
                full accuracy in MAXITR steps.

  Further Details
  ===============

  Based on contributions by
     Beresford Parlett, University of California, Berkeley, USA
     Jim Demmel, University of California, Berkeley, USA
     Inderjit Dhillon, University of Texas, Austin, USA
     Osni Marques, LBNL/NERSC, USA
     Christof Voemel, University of California, Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param vl
	 * @param vu
	 * @param d
	 * @param l
	 * @param pivmin
	 * @param isplit
	 * @param m
	 * @param dol
	 * @param dou
	 * @param minrgp
	 * @param rtol1
	 * @param rtol2
	 * @param w
	 * @param werr
	 * @param wgap
	 * @param iblock
	 * @param indexw
	 * @param gers
	 * @param z
	 * @param ldz
	 * @param isuppz
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public void dlarrv(int n, double vl, double vu, double[] d, double[] l, double pivmin, int[] isplit, int m, int dol, int dou, double minrgp, doubleW rtol1, doubleW rtol2, double[] w, double[] werr, double[] wgap, int[] iblock, int[] indexw, double[] gers, double[] z, int ldz, int[] isuppz, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlarrv.dlarrv(n, vl, vu, d, 0, l, 0, pivmin, isplit, 0, m, dol, dou, minrgp, rtol1, rtol2, w, 0, werr, 0, wgap, 0, iblock, 0, indexw, 0, gers, 0, z, 0, ldz, isuppz, 0, work, 0, iwork, 0, info);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DLARTG generate a plane rotation so that

     [  CS  SN  ]  .  [ F ]  =  [ R ]   where CS**2 + SN**2 = 1.
     [ -SN  CS  ]     [ G ]     [ 0 ]

  This is a slower, more accurate version of the BLAS1 routine DROTG,
  with the following other differences:
     F and G are unchanged on return.
     If G=0, then CS=1 and SN=0.
     If F=0 and (G .ne. 0), then CS=0 and SN=1 without doing any
        floating point operations (saves work in DBDSQR when
        there are zeros on the diagonal).

  If F exceeds G in magnitude, CS will be positive.

  Arguments
  =========

  F       (input) DOUBLE PRECISION
          The first component of vector to be rotated.

  G       (input) DOUBLE PRECISION
          The second component of vector to be rotated.

  CS      (output) DOUBLE PRECISION
          The cosine of the rotation.

  SN      (output) DOUBLE PRECISION
          The sine of the rotation.

  R       (output) DOUBLE PRECISION
          The nonzero component of the rotated vector.

  This version has a few statements commented out for thread safety
  (machine parameters are computed on each entry). 10 feb 03, SJH.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param f
	 * @param g
	 * @param cs
	 * @param sn
	 * @param r
	 */
	public abstract void dlartg(double f, double g, doubleW cs, doubleW sn, doubleW r);

	/**
<pre>

     ..

  Purpose
  =======

  DLARTV applies a vector of real plane rotations to elements of the
  real vectors x and y. For i = 1,2,...,n

     ( x(i) ) := (  c(i)  s(i) ) ( x(i) )
     ( y(i) )    ( -s(i)  c(i) ) ( y(i) )

  Arguments
  =========

  N       (input) INTEGER
          The number of plane rotations to be applied.

  X       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCX)
          The vector x.

  INCX    (input) INTEGER
          The increment between elements of X. INCX > 0.

  Y       (input/output) DOUBLE PRECISION array,
                         dimension (1+(N-1)*INCY)
          The vector y.

  INCY    (input) INTEGER
          The increment between elements of Y. INCY > 0.

  C       (input) DOUBLE PRECISION array, dimension (1+(N-1)*INCC)
          The cosines of the plane rotations.

  S       (input) DOUBLE PRECISION array, dimension (1+(N-1)*INCC)
          The sines of the plane rotations.

  INCC    (input) INTEGER
          The increment between elements of C and S. INCC > 0.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param x
	 * @param incx
	 * @param y
	 * @param incy
	 * @param c
	 * @param s
	 * @param incc
	 */
	public abstract void dlartv(int n, double[] x, int incx, double[] y, int incy, double[] c, double[] s, int incc);

	/**
<pre>

     ..

  Purpose
  =======

  DLARUV returns a vector of n random real numbers from a uniform (0,1)
  distribution (n <= 128).

  This is an auxiliary routine called by DLARNV and ZLARNV.

  Arguments
  =========

  ISEED   (input/output) INTEGER array, dimension (4)
          On entry, the seed of the random number generator; the array

          elements must be between 0 and 4095, and ISEED(4) must be
          odd.
          On exit, the seed is updated.

  N       (input) INTEGER
          The number of random numbers to be generated. N <= 128.

  X       (output) DOUBLE PRECISION array, dimension (N)
          The generated random numbers.

  Further Details
  ===============

  This routine uses a multiplicative congruential method with modulus
  2**48 and multiplier 33952834046453 (see G.S.Fishman,
  'Multiplicative congruential random number generators with modulus
  2**b: an exhaustive analysis for b = 32 and a partial analysis for
  b = 48', Math. Comp. 189, pp 331-344, 1990).

  48-bit integers are stored in 4 integer array elements with 12 bits
  per element. Hence the routine is portable across machines with
  integers of 32 bits or more.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param iseed
	 * @param n
	 * @param x
	 */
	public abstract void dlaruv(int[] iseed, int n, double[] x);

	/**
<pre>

     ..

  Purpose
  =======

  DLARZ applies a real elementary reflector H to a real M-by-N
  matrix C, from either the left or the right. H is represented in the

  form

        H = I - tau * v * v'

  where tau is a real scalar and v is a real vector.

  If tau = 0, then H is taken to be the unit matrix.


  H is a product of k elementary reflectors as returned by DTZRZF.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': form  H * C
          = 'R': form  C * H

  M       (input) INTEGER
          The number of rows of the matrix C.

  N       (input) INTEGER
          The number of columns of the matrix C.

  L       (input) INTEGER
          The number of entries of the vector V containing
          the meaningful part of the Householder vectors.
          If SIDE = 'L', M >= L >= 0, if SIDE = 'R', N >= L >= 0.

  V       (input) DOUBLE PRECISION array, dimension (1+(L-1)*abs(INCV))
          The vector v in the representation of H as returned by
          DTZRZF. V is not used if TAU = 0.

  INCV    (input) INTEGER
          The increment between elements of v. INCV <> 0.

  TAU     (input) DOUBLE PRECISION
          The value tau in the representation of H.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by the matrix H * C if SIDE = 'L',

          or C * H if SIDE = 'R'.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                         (N) if SIDE = 'L'
                      or (M) if SIDE = 'R'

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA


  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param m
	 * @param n
	 * @param l
	 * @param v
	 * @param incv
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 */
	public abstract void dlarz(String side, int m, int n, int l, double[] v, int incv, double tau, double[] c, int Ldc, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  DLARZB applies a real block reflector H or its transpose H**T to
  a real distributed M-by-N  C from the left or the right.

  Currently, only STOREV = 'R' and DIRECT = 'B' are supported.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply H or H' from the Left
          = 'R': apply H or H' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply H (No transpose)
          = 'C': apply H' (Transpose)

  DIRECT  (input) CHARACTER*1
          Indicates how H is formed from a product of elementary
          reflectors
          = 'F': H = H(1) H(2) . . . H(k) (Forward, not supported yet)

          = 'B': H = H(k) . . . H(2) H(1) (Backward)

  STOREV  (input) CHARACTER*1
          Indicates how the vectors which define the elementary
          reflectors are stored:
          = 'C': Columnwise                        (not supported yet)

          = 'R': Rowwise

  M       (input) INTEGER
          The number of rows of the matrix C.

  N       (input) INTEGER
          The number of columns of the matrix C.

  K       (input) INTEGER
          The order of the matrix T (= the number of elementary
          reflectors whose product defines the block reflector).

  L       (input) INTEGER
          The number of columns of the matrix V containing the
          meaningful part of the Householder reflectors.
          If SIDE = 'L', M >= L >= 0, if SIDE = 'R', N >= L >= 0.

  V       (input) DOUBLE PRECISION array, dimension (LDV,NV).
          If STOREV = 'C', NV = K; if STOREV = 'R', NV = L.

  LDV     (input) INTEGER
          The leading dimension of the array V.
          If STOREV = 'C', LDV >= L; if STOREV = 'R', LDV >= K.

  T       (input) DOUBLE PRECISION array, dimension (LDT,K)
          The triangular K-by-K matrix T in the representation of the
          block reflector.

  LDT     (input) INTEGER
          The leading dimension of the array T. LDT >= K.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by H*C or H'*C or C*H or C*H'.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension (LDWORK,K)

  LDWORK  (input) INTEGER
          The leading dimension of the array WORK.
          If SIDE = 'L', LDWORK >= max(1,N);
          if SIDE = 'R', LDWORK >= max(1,M).

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA


  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param direct
	 * @param storev
	 * @param m
	 * @param n
	 * @param k
	 * @param l
	 * @param v
	 * @param ldv
	 * @param t
	 * @param ldt
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param ldwork
	 */
	public abstract void dlarzb(String side, String trans, String direct, String storev, int m, int n, int k, int l, double[] v, int ldv, double[] t, int ldt, double[] c, int Ldc, double[] work, int ldwork);

	/**
<pre>

     ..

  Purpose
  =======

  DLARZT forms the triangular factor T of a real block reflector
  H of order > n, which is defined as a product of k elementary
  reflectors.

  If DIRECT = 'F', H = H(1) H(2) . . . H(k) and T is upper triangular;


  If DIRECT = 'B', H = H(k) . . . H(2) H(1) and T is lower triangular.


  If STOREV = 'C', the vector which defines the elementary reflector
  H(i) is stored in the i-th column of the array V, and

     H  =  I - V * T * V'

  If STOREV = 'R', the vector which defines the elementary reflector
  H(i) is stored in the i-th row of the array V, and

     H  =  I - V' * T * V

  Currently, only STOREV = 'R' and DIRECT = 'B' are supported.

  Arguments
  =========

  DIRECT  (input) CHARACTER*1
          Specifies the order in which the elementary reflectors are
          multiplied to form the block reflector:
          = 'F': H = H(1) H(2) . . . H(k) (Forward, not supported yet)

          = 'B': H = H(k) . . . H(2) H(1) (Backward)

  STOREV  (input) CHARACTER*1
          Specifies how the vectors which define the elementary
          reflectors are stored (see also Further Details):
          = 'C': columnwise                        (not supported yet)

          = 'R': rowwise

  N       (input) INTEGER
          The order of the block reflector H. N >= 0.

  K       (input) INTEGER
          The order of the triangular factor T (= the number of
          elementary reflectors). K >= 1.

  V       (input/output) DOUBLE PRECISION array, dimension
                               (LDV,K) if STOREV = 'C'
                               (LDV,N) if STOREV = 'R'
          The matrix V. See further details.

  LDV     (input) INTEGER
          The leading dimension of the array V.
          If STOREV = 'C', LDV >= max(1,N); if STOREV = 'R', LDV >= K.


  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i).

  T       (output) DOUBLE PRECISION array, dimension (LDT,K)
          The k by k triangular factor T of the block reflector.
          If DIRECT = 'F', T is upper triangular; if DIRECT = 'B', T is
          lower triangular. The rest of the array is not used.

  LDT     (input) INTEGER
          The leading dimension of the array T. LDT >= K.

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA


  The shape of the matrix V and the storage of the vectors which define
  the H(i) is best illustrated by the following example with n = 5 and

  k = 3. The elements equal to 1 are not stored; the corresponding
  array elements are modified but restored on exit. The rest of the
  array is not used.

  DIRECT = 'F' and STOREV = 'C':         DIRECT = 'F' and STOREV = 'R':

                                              ______V_____
         ( v1 v2 v3 )                        /            \
         ( v1 v2 v3 )                      ( v1 v1 v1 v1 v1 . . . . 1 )
     V = ( v1 v2 v3 )                      ( v2 v2 v2 v2 v2 . . . 1   )
         ( v1 v2 v3 )                      ( v3 v3 v3 v3 v3 . . 1     )
         ( v1 v2 v3 )
            .  .  .
            .  .  .
            1  .  .
               1  .
                  1

  DIRECT = 'B' and STOREV = 'C':         DIRECT = 'B' and STOREV = 'R':

                                                        ______V_____
            1                                          /            \
            .  1                           ( 1 . . . . v1 v1 v1 v1 v1 )
            .  .  1                        ( . 1 . . . v2 v2 v2 v2 v2 )
            .  .  .                        ( . . 1 . . v3 v3 v3 v3 v3 )
            .  .  .
         ( v1 v2 v3 )
         ( v1 v2 v3 )
     V = ( v1 v2 v3 )
         ( v1 v2 v3 )
         ( v1 v2 v3 )

  =====================================================================

     .. Parameters ..
</pre>
	 * @param direct
	 * @param storev
	 * @param n
	 * @param k
	 * @param v
	 * @param ldv
	 * @param tau
	 * @param t
	 * @param ldt
	 */
	public abstract void dlarzt(String direct, String storev, int n, int k, double[] v, int ldv, double[] tau, double[] t, int ldt);

	/**
<pre>

     ..

  Purpose
  =======

  DLAS2  computes the singular values of the 2-by-2 matrix
     [  F   G  ]
     [  0   H  ].
  On return, SSMIN is the smaller singular value and SSMAX is the
  larger singular value.

  Arguments
  =========

  F       (input) DOUBLE PRECISION
          The (1,1) element of the 2-by-2 matrix.

  G       (input) DOUBLE PRECISION
          The (1,2) element of the 2-by-2 matrix.

  H       (input) DOUBLE PRECISION
          The (2,2) element of the 2-by-2 matrix.

  SSMIN   (output) DOUBLE PRECISION
          The smaller singular value.

  SSMAX   (output) DOUBLE PRECISION
          The larger singular value.

  Further Details
  ===============

  Barring over/underflow, all output quantities are correct to within
  a few units in the last place (ulps), even in the absence of a guard

  digit in addition/subtraction.

  In IEEE arithmetic, the code works correctly if one matrix element is
  infinite.

  Overflow will not occur unless the largest singular value itself
  overflows, or is within a few ulps of overflow. (On machines with
  partial overflow, like the Cray, overflow may occur if the largest
  singular value is within a factor of 2 of overflow.)

  Underflow is harmless if underflow is gradual. Otherwise, results
  may correspond to a matrix modified by perturbations of size near
  the underflow threshold.

  ====================================================================


     .. Parameters ..
</pre>
	 * @param f
	 * @param g
	 * @param h
	 * @param ssmin
	 * @param ssmax
	 */
	public abstract void dlas2(double f, double g, double h, doubleW ssmin, doubleW ssmax);

	/**
<pre>

     ..

  Purpose
  =======

  DLASCL multiplies the M by N real matrix A by the real scalar
  CTO/CFROM.  This is done without over/underflow as long as the final

  result CTO*A(I,J)/CFROM does not over/underflow. TYPE specifies that

  A may be full, upper triangular, lower triangular, upper Hessenberg,

  or banded.

  Arguments
  =========

  TYPE    (input) CHARACTER*1
          TYPE indices the storage type of the input matrix.
          = 'G':  A is a full matrix.
          = 'L':  A is a lower triangular matrix.
          = 'U':  A is an upper triangular matrix.
          = 'H':  A is an upper Hessenberg matrix.
          = 'B':  A is a symmetric band matrix with lower bandwidth KL

                  and upper bandwidth KU and with the only the lower
                  half stored.
          = 'Q':  A is a symmetric band matrix with lower bandwidth KL

                  and upper bandwidth KU and with the only the upper
                  half stored.
          = 'Z':  A is a band matrix with lower bandwidth KL and upper

                  bandwidth KU.

  KL      (input) INTEGER
          The lower bandwidth of A.  Referenced only if TYPE = 'B',
          'Q' or 'Z'.

  KU      (input) INTEGER
          The upper bandwidth of A.  Referenced only if TYPE = 'B',
          'Q' or 'Z'.

  CFROM   (input) DOUBLE PRECISION
  CTO     (input) DOUBLE PRECISION
          The matrix A is multiplied by CTO/CFROM. A(I,J) is computed
          without over/underflow if the final result CTO*A(I,J)/CFROM
          can be represented without over/underflow.  CFROM must be
          nonzero.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          The matrix to be multiplied by CTO/CFROM.  See TYPE for the
          storage type.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  INFO    (output) INTEGER
          0  - successful exit
          <0 - if INFO = -i, the i-th argument had an illegal value.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param type
	 * @param kl
	 * @param ku
	 * @param cfrom
	 * @param cto
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param info
	 */
	public abstract void dlascl(String type, int kl, int ku, double cfrom, double cto, int m, int n, double[] a, int lda, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  Using a divide and conquer approach, DLASD0 computes the singular
  value decomposition (SVD) of a real upper bidiagonal N-by-M
  matrix B with diagonal D and offdiagonal E, where M = N + SQRE.
  The algorithm computes orthogonal matrices U and VT such that
  B = U * S * VT. The singular values S are overwritten on D.

  A related subroutine, DLASDA, computes only the singular values,
  and optionally, the singular vectors in compact form.

  Arguments
  =========

  N      (input) INTEGER
         On entry, the row dimension of the upper bidiagonal matrix.
         This is also the dimension of the main diagonal array D.

  SQRE   (input) INTEGER
         Specifies the column dimension of the bidiagonal matrix.
         = 0: The bidiagonal matrix has column dimension M = N;
         = 1: The bidiagonal matrix has column dimension M = N+1;

  D      (input/output) DOUBLE PRECISION array, dimension (N)
         On entry D contains the main diagonal of the bidiagonal
         matrix.
         On exit D, if INFO = 0, contains its singular values.

  E      (input) DOUBLE PRECISION array, dimension (M-1)
         Contains the subdiagonal entries of the bidiagonal matrix.
         On exit, E has been destroyed.

  U      (output) DOUBLE PRECISION array, dimension at least (LDQ, N)
         On exit, U contains the left singular vectors.

  LDU    (input) INTEGER
         On entry, leading dimension of U.

  VT     (output) DOUBLE PRECISION array, dimension at least (LDVT, M)

         On exit, VT' contains the right singular vectors.

  LDVT   (input) INTEGER
         On entry, leading dimension of VT.

  SMLSIZ (input) INTEGER
         On entry, maximum size of the subproblems at the
         bottom of the computation tree.

  IWORK  (workspace) INTEGER work array.
         Dimension must be at least (8 * N)

  WORK   (workspace) DOUBLE PRECISION work array.
         Dimension must be at least (3 * M**2 + 2 * M)

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an singular value did not converge

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param sqre
	 * @param d
	 * @param e
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param ldvt
	 * @param smlsiz
	 * @param iwork
	 * @param work
	 * @param info
	 */
	public abstract void dlasd0(int n, int sqre, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, int smlsiz, int[] iwork, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASD1 computes the SVD of an upper bidiagonal N-by-M matrix B,
  where N = NL + NR + 1 and M = N + SQRE. DLASD1 is called from DLASD0.

  A related subroutine DLASD7 handles the case in which the singular
  values (and the singular vectors in factored form) are desired.

  DLASD1 computes the SVD as follows:

                ( D1(in)  0    0     0 )
    B = U(in) * (   Z1'   a   Z2'    b ) * VT(in)
                (   0     0   D2(in) 0 )

      = U(out) * ( D(out) 0) * VT(out)

  where Z' = (Z1' a Z2' b) = u' VT', and u is a vector of dimension M
  with ALPHA and BETA in the NL+1 and NL+2 th entries and zeros
  elsewhere; and the entry b is empty if SQRE = 0.

  The left singular vectors of the original matrix are stored in U, and
  the transpose of the right singular vectors are stored in VT, and the
  singular values are in D.  The algorithm consists of three stages:

     The first stage consists of deflating the size of the problem
     when there are multiple singular values or when there are zeros in
     the Z vector.  For each such occurence the dimension of the
     secular equation problem is reduced by one.  This stage is
     performed by the routine DLASD2.

     The second stage consists of calculating the updated
     singular values. This is done by finding the square roots of the
     roots of the secular equation via the routine DLASD4 (as called
     by DLASD3). This routine also calculates the singular vectors of
     the current problem.

     The final stage consists of computing the updated singular vectors
     directly using the updated singular values.  The singular vectors

     for the current problem are multiplied with the singular vectors
     from the overall problem.

  Arguments
  =========

  NL     (input) INTEGER
         The row dimension of the upper block.  NL >= 1.

  NR     (input) INTEGER
         The row dimension of the lower block.  NR >= 1.

  SQRE   (input) INTEGER
         = 0: the lower block is an NR-by-NR square matrix.
         = 1: the lower block is an NR-by-(NR+1) rectangular matrix.

         The bidiagonal matrix has row dimension N = NL + NR + 1,
         and column dimension M = N + SQRE.

  D      (input/output) DOUBLE PRECISION array,
                        dimension (N = NL+NR+1).
         On entry D(1:NL,1:NL) contains the singular values of the
         upper block; and D(NL+2:N) contains the singular values of
         the lower block. On exit D(1:N) contains the singular values
         of the modified matrix.

  ALPHA  (input/output) DOUBLE PRECISION
         Contains the diagonal element associated with the added row.

  BETA   (input/output) DOUBLE PRECISION
         Contains the off-diagonal element associated with the added
         row.

  U      (input/output) DOUBLE PRECISION array, dimension(LDU,N)
         On entry U(1:NL, 1:NL) contains the left singular vectors of
         the upper block; U(NL+2:N, NL+2:N) contains the left singular

         vectors of the lower block. On exit U contains the left
         singular vectors of the bidiagonal matrix.

  LDU    (input) INTEGER
         The leading dimension of the array U.  LDU >= max( 1, N ).

  VT     (input/output) DOUBLE PRECISION array, dimension(LDVT,M)
         where M = N + SQRE.
         On entry VT(1:NL+1, 1:NL+1)' contains the right singular
         vectors of the upper block; VT(NL+2:M, NL+2:M)' contains
         the right singular vectors of the lower block. On exit
         VT' contains the right singular vectors of the
         bidiagonal matrix.

  LDVT   (input) INTEGER
         The leading dimension of the array VT.  LDVT >= max( 1, M ).

  IDXQ  (output) INTEGER array, dimension(N)
         This contains the permutation which will reintegrate the
         subproblem just solved back into sorted order, i.e.
         D( IDXQ( I = 1, N ) ) will be in ascending order.

  IWORK  (workspace) INTEGER array, dimension( 4 * N )

  WORK   (workspace) DOUBLE PRECISION array, dimension( 3*M**2 + 2*M )


  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an singular value did not converge

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..

</pre>
	 * @param nl
	 * @param nr
	 * @param sqre
	 * @param d
	 * @param alpha
	 * @param beta
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param ldvt
	 * @param idxq
	 * @param iwork
	 * @param work
	 * @param info
	 */
	public abstract void dlasd1(int nl, int nr, int sqre, double[] d, doubleW alpha, doubleW beta, double[] u, int ldu, double[] vt, int ldvt, int[] idxq, int[] iwork, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASD2 merges the two sets of singular values together into a single

  sorted set.  Then it tries to deflate the size of the problem.
  There are two ways in which deflation can occur:  when two or more
  singular values are close together or if there is a tiny entry in the
  Z vector.  For each such occurrence the order of the related secular

  equation problem is reduced by one.

  DLASD2 is called from DLASD1.

  Arguments
  =========

  NL     (input) INTEGER
         The row dimension of the upper block.  NL >= 1.

  NR     (input) INTEGER
         The row dimension of the lower block.  NR >= 1.

  SQRE   (input) INTEGER
         = 0: the lower block is an NR-by-NR square matrix.
         = 1: the lower block is an NR-by-(NR+1) rectangular matrix.

         The bidiagonal matrix has N = NL + NR + 1 rows and
         M = N + SQRE >= N columns.

  K      (output) INTEGER
         Contains the dimension of the non-deflated matrix,
         This is the order of the related secular equation. 1 <= K <=N.

  D      (input/output) DOUBLE PRECISION array, dimension(N)
         On entry D contains the singular values of the two submatrices
         to be combined.  On exit D contains the trailing (N-K) updated
         singular values (those which were deflated) sorted into
         increasing order.

  Z      (output) DOUBLE PRECISION array, dimension(N)
         On exit Z contains the updating row vector in the secular
         equation.

  ALPHA  (input) DOUBLE PRECISION
         Contains the diagonal element associated with the added row.

  BETA   (input) DOUBLE PRECISION
         Contains the off-diagonal element associated with the added
         row.

  U      (input/output) DOUBLE PRECISION array, dimension(LDU,N)
         On entry U contains the left singular vectors of two
         submatrices in the two square blocks with corners at (1,1),
         (NL, NL), and (NL+2, NL+2), (N,N).
         On exit U contains the trailing (N-K) updated left singular
         vectors (those which were deflated) in its last N-K columns.

  LDU    (input) INTEGER
         The leading dimension of the array U.  LDU >= N.

  VT     (input/output) DOUBLE PRECISION array, dimension(LDVT,M)
         On entry VT' contains the right singular vectors of two
         submatrices in the two square blocks with corners at (1,1),
         (NL+1, NL+1), and (NL+2, NL+2), (M,M).
         On exit VT' contains the trailing (N-K) updated right singular
         vectors (those which were deflated) in its last N-K columns.
         In case SQRE =1, the last row of VT spans the right null
         space.

  LDVT   (input) INTEGER
         The leading dimension of the array VT.  LDVT >= M.

  DSIGMA (output) DOUBLE PRECISION array, dimension (N)
         Contains a copy of the diagonal elements (K-1 singular values

         and one zero) in the secular equation.

  U2     (output) DOUBLE PRECISION array, dimension(LDU2,N)
         Contains a copy of the first K-1 left singular vectors which
         will be used by DLASD3 in a matrix multiply (DGEMM) to solve
         for the new left singular vectors. U2 is arranged into four
         blocks. The first block contains a column with 1 at NL+1 and
         zero everywhere else; the second block contains non-zero
         entries only at and above NL; the third contains non-zero
         entries only below NL+1; and the fourth is dense.

  LDU2   (input) INTEGER
         The leading dimension of the array U2.  LDU2 >= N.

  VT2    (output) DOUBLE PRECISION array, dimension(LDVT2,N)
         VT2' contains a copy of the first K right singular vectors
         which will be used by DLASD3 in a matrix multiply (DGEMM) to
         solve for the new right singular vectors. VT2 is arranged into
         three blocks. The first block contains a row that corresponds

         to the special 0 diagonal element in SIGMA; the second block
         contains non-zeros only at and before NL +1; the third block
         contains non-zeros only at and after  NL +2.

  LDVT2  (input) INTEGER
         The leading dimension of the array VT2.  LDVT2 >= M.

  IDXP   (workspace) INTEGER array dimension(N)
         This will contain the permutation used to place deflated
         values of D at the end of the array. On output IDXP(2:K)
         points to the nondeflated D-values and IDXP(K+1:N)
         points to the deflated singular values.

  IDX    (workspace) INTEGER array dimension(N)
         This will contain the permutation used to sort the contents of
         D into ascending order.

  IDXC   (output) INTEGER array dimension(N)
         This will contain the permutation used to arrange the columns

         of the deflated U matrix into three groups:  the first group
         contains non-zero entries only at and above NL, the second
         contains non-zero entries only below NL+2, and the third is
         dense.

  IDXQ   (input/output) INTEGER array dimension(N)
         This contains the permutation which separately sorts the two
         sub-problems in D into ascending order.  Note that entries in

         the first hlaf of this permutation must first be moved one
         position backward; and entries in the second half
         must first have NL+1 added to their values.

  COLTYP (workspace/output) INTEGER array dimension(N)
         As workspace, this will contain a label which will indicate
         which of the following types a column in the U2 matrix or a
         row in the VT2 matrix is:
         1 : non-zero in the upper half only
         2 : non-zero in the lower half only
         3 : dense
         4 : deflated

         On exit, it is an array of dimension 4, with COLTYP(I) being
         the dimension of the I-th type columns.

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param nl
	 * @param nr
	 * @param sqre
	 * @param k
	 * @param d
	 * @param z
	 * @param alpha
	 * @param beta
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param ldvt
	 * @param dsigma
	 * @param u2
	 * @param ldu2
	 * @param vt2
	 * @param ldvt2
	 * @param idxp
	 * @param idx
	 * @param idxc
	 * @param idxq
	 * @param coltyp
	 * @param info
	 */
	public abstract void dlasd2(int nl, int nr, int sqre, intW k, double[] d, double[] z, double alpha, double beta, double[] u, int ldu, double[] vt, int ldvt, double[] dsigma, double[] u2, int ldu2, double[] vt2, int ldvt2, int[] idxp, int[] idx, int[] idxc, int[] idxq, int[] coltyp, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASD3 finds all the square roots of the roots of the secular
  equation, as defined by the values in D and Z.  It makes the
  appropriate calls to DLASD4 and then updates the singular
  vectors by matrix multiplication.

  This code makes very mild assumptions about floating point
  arithmetic. It will work on machines with a guard digit in
  add/subtract, or on those binary machines without guard digits
  which subtract like the Cray XMP, Cray YMP, Cray C 90, or Cray 2.
  It could conceivably fail on hexadecimal or decimal machines
  without guard digits, but we know of none.

  DLASD3 is called from DLASD1.

  Arguments
  =========

  NL     (input) INTEGER
         The row dimension of the upper block.  NL >= 1.

  NR     (input) INTEGER
         The row dimension of the lower block.  NR >= 1.

  SQRE   (input) INTEGER
         = 0: the lower block is an NR-by-NR square matrix.
         = 1: the lower block is an NR-by-(NR+1) rectangular matrix.

         The bidiagonal matrix has N = NL + NR + 1 rows and
         M = N + SQRE >= N columns.

  K      (input) INTEGER
         The size of the secular equation, 1 =< K = < N.

  D      (output) DOUBLE PRECISION array, dimension(K)
         On exit the square roots of the roots of the secular equation,
         in ascending order.

  Q      (workspace) DOUBLE PRECISION array,
                     dimension at least (LDQ,K).

  LDQ    (input) INTEGER
         The leading dimension of the array Q.  LDQ >= K.

  DSIGMA (input) DOUBLE PRECISION array, dimension(K)
         The first K elements of this array contain the old roots
         of the deflated updating problem.  These are the poles
         of the secular equation.

  U      (output) DOUBLE PRECISION array, dimension (LDU, N)
         The last N - K columns of this matrix contain the deflated
         left singular vectors.

  LDU    (input) INTEGER
         The leading dimension of the array U.  LDU >= N.

  U2     (input/output) DOUBLE PRECISION array, dimension (LDU2, N)
         The first K columns of this matrix contain the non-deflated
         left singular vectors for the split problem.

  LDU2   (input) INTEGER
         The leading dimension of the array U2.  LDU2 >= N.

  VT     (output) DOUBLE PRECISION array, dimension (LDVT, M)
         The last M - K columns of VT' contain the deflated
         right singular vectors.

  LDVT   (input) INTEGER
         The leading dimension of the array VT.  LDVT >= N.

  VT2    (input/output) DOUBLE PRECISION array, dimension (LDVT2, N)
         The first K columns of VT2' contain the non-deflated
         right singular vectors for the split problem.

  LDVT2  (input) INTEGER
         The leading dimension of the array VT2.  LDVT2 >= N.

  IDXC   (input) INTEGER array, dimension ( N )
         The permutation used to arrange the columns of U (and rows of

         VT) into three groups:  the first group contains non-zero
         entries only at and above (or before) NL +1; the second
         contains non-zero entries only at and below (or after) NL+2;
         and the third is dense. The first column of U and the row of
         VT are treated separately, however.

         The rows of the singular vectors found by DLASD4
         must be likewise permuted before the matrix multiplies can
         take place.

  CTOT   (input) INTEGER array, dimension ( 4 )
         A count of the total number of the various types of columns
         in U (or rows in VT), as described in IDXC. The fourth column

         type is any column which has been deflated.

  Z      (input) DOUBLE PRECISION array, dimension (K)
         The first K elements of this array contain the components
         of the deflation-adjusted updating row vector.

  INFO   (output) INTEGER
         = 0:  successful exit.
         < 0:  if INFO = -i, the i-th argument had an illegal value.
         > 0:  if INFO = 1, an singular value did not converge

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param nl
	 * @param nr
	 * @param sqre
	 * @param k
	 * @param d
	 * @param q
	 * @param ldq
	 * @param dsigma
	 * @param u
	 * @param ldu
	 * @param u2
	 * @param ldu2
	 * @param vt
	 * @param ldvt
	 * @param vt2
	 * @param ldvt2
	 * @param idxc
	 * @param ctot
	 * @param z
	 * @param info
	 */
	public abstract void dlasd3(int nl, int nr, int sqre, int k, double[] d, double[] q, int ldq, double[] dsigma, double[] u, int ldu, double[] u2, int ldu2, double[] vt, int ldvt, double[] vt2, int ldvt2, int[] idxc, int[] ctot, double[] z, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This subroutine computes the square root of the I-th updated
  eigenvalue of a positive symmetric rank-one modification to
  a positive diagonal matrix whose entries are given as the squares
  of the corresponding entries in the array d, and that

         0 <= D(i) < D(j)  for  i < j

  and that RHO > 0. This is arranged by the calling routine, and is
  no loss in generality.  The rank-one modified system is thus

         diag( D ) * diag( D ) +  RHO *  Z * Z_transpose.

  where we assume the Euclidean norm of Z is 1.

  The method consists of approximating the rational functions in the
  secular equation by simpler interpolating rational functions.

  Arguments
  =========

  N      (input) INTEGER
         The length of all arrays.

  I      (input) INTEGER
         The index of the eigenvalue to be computed.  1 <= I <= N.

  D      (input) DOUBLE PRECISION array, dimension ( N )
         The original eigenvalues.  It is assumed that they are in
         order, 0 <= D(I) < D(J)  for I < J.

  Z      (input) DOUBLE PRECISION array, dimension ( N )
         The components of the updating vector.

  DELTA  (output) DOUBLE PRECISION array, dimension ( N )
         If N .ne. 1, DELTA contains (D(j) - sigma_I) in its  j-th
         component.  If N = 1, then DELTA(1) = 1.  The vector DELTA
         contains the information necessary to construct the
         (singular) eigenvectors.

  RHO    (input) DOUBLE PRECISION
         The scalar in the symmetric updating formula.

  SIGMA  (output) DOUBLE PRECISION
         The computed sigma_I, the I-th updated eigenvalue.

  WORK   (workspace) DOUBLE PRECISION array, dimension ( N )
         If N .ne. 1, WORK contains (D(j) + sigma_I) in its  j-th
         component.  If N = 1, then WORK( 1 ) = 1.

  INFO   (output) INTEGER
         = 0:  successful exit
         > 0:  if INFO = 1, the updating process failed.

  Internal Parameters
  ===================

  Logical variable ORGATI (origin-at-i?) is used for distinguishing
  whether D(i) or D(i+1) is treated as the origin.

            ORGATI = .true.    origin at i
            ORGATI = .false.   origin at i+1

  Logical variable SWTCH3 (switch-for-3-poles?) is for noting
  if we are working with THREE poles!

  MAXIT is the maximum number of iterations allowed for each
  eigenvalue.

  Further Details
  ===============

  Based on contributions by
     Ren-Cang Li, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param i
	 * @param d
	 * @param z
	 * @param delta
	 * @param rho
	 * @param sigma
	 * @param work
	 * @param info
	 */
	public abstract void dlasd4(int n, int i, double[] d, double[] z, double[] delta, double rho, doubleW sigma, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  This subroutine computes the square root of the I-th eigenvalue
  of a positive symmetric rank-one modification of a 2-by-2 diagonal
  matrix

             diag( D ) * diag( D ) +  RHO *  Z * transpose(Z) .

  The diagonal entries in the array D are assumed to satisfy

             0 <= D(i) < D(j)  for  i < j .

  We also assume RHO > 0 and that the Euclidean norm of the vector
  Z is one.

  Arguments
  =========

  I      (input) INTEGER
         The index of the eigenvalue to be computed.  I = 1 or I = 2.

  D      (input) DOUBLE PRECISION array, dimension ( 2 )
         The original eigenvalues.  We assume 0 <= D(1) < D(2).

  Z      (input) DOUBLE PRECISION array, dimension ( 2 )
         The components of the updating vector.

  DELTA  (output) DOUBLE PRECISION array, dimension ( 2 )
         Contains (D(j) - sigma_I) in its  j-th component.
         The vector DELTA contains the information necessary
         to construct the eigenvectors.

  RHO    (input) DOUBLE PRECISION
         The scalar in the symmetric updating formula.

  DSIGMA (output) DOUBLE PRECISION
         The computed sigma_I, the I-th updated eigenvalue.

  WORK   (workspace) DOUBLE PRECISION array, dimension ( 2 )
         WORK contains (D(j) + sigma_I) in its  j-th component.

  Further Details
  ===============

  Based on contributions by
     Ren-Cang Li, Computer Science Division, University of California
     at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param i
	 * @param d
	 * @param z
	 * @param delta
	 * @param rho
	 * @param dsigma
	 * @param work
	 */
	public abstract void dlasd5(int i, double[] d, double[] z, double[] delta, double rho, doubleW dsigma, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  DLASD6 computes the SVD of an updated upper bidiagonal matrix B
  obtained by merging two smaller ones by appending a row. This
  routine is used only for the problem which requires all singular
  values and optionally singular vector matrices in factored form.
  B is an N-by-M matrix with N = NL + NR + 1 and M = N + SQRE.
  A related subroutine, DLASD1, handles the case in which all singular

  values and singular vectors of the bidiagonal matrix are desired.

  DLASD6 computes the SVD as follows:

                ( D1(in)  0    0     0 )
    B = U(in) * (   Z1'   a   Z2'    b ) * VT(in)
                (   0     0   D2(in) 0 )

      = U(out) * ( D(out) 0) * VT(out)

  where Z' = (Z1' a Z2' b) = u' VT', and u is a vector of dimension M
  with ALPHA and BETA in the NL+1 and NL+2 th entries and zeros
  elsewhere; and the entry b is empty if SQRE = 0.

  The singular values of B can be computed using D1, D2, the first
  components of all the right singular vectors of the lower block, and

  the last components of all the right singular vectors of the upper
  block. These components are stored and updated in VF and VL,
  respectively, in DLASD6. Hence U and VT are not explicitly
  referenced.

  The singular values are stored in D. The algorithm consists of two
  stages:

        The first stage consists of deflating the size of the problem
        when there are multiple singular values or if there is a zero
        in the Z vector. For each such occurence the dimension of the
        secular equation problem is reduced by one. This stage is
        performed by the routine DLASD7.

        The second stage consists of calculating the updated
        singular values. This is done by finding the roots of the
        secular equation via the routine DLASD4 (as called by DLASD8).

        This routine also updates VF and VL and computes the distances

        between the updated singular values and the old singular
        values.

  DLASD6 is called from DLASDA.

  Arguments
  =========

  ICOMPQ (input) INTEGER
         Specifies whether singular vectors are to be computed in
         factored form:
         = 0: Compute singular values only.
         = 1: Compute singular vectors in factored form as well.

  NL     (input) INTEGER
         The row dimension of the upper block.  NL >= 1.

  NR     (input) INTEGER
         The row dimension of the lower block.  NR >= 1.

  SQRE   (input) INTEGER
         = 0: the lower block is an NR-by-NR square matrix.
         = 1: the lower block is an NR-by-(NR+1) rectangular matrix.

         The bidiagonal matrix has row dimension N = NL + NR + 1,
         and column dimension M = N + SQRE.

  D      (input/output) DOUBLE PRECISION array, dimension ( NL+NR+1 ).

         On entry D(1:NL,1:NL) contains the singular values of the
         upper block, and D(NL+2:N) contains the singular values
         of the lower block. On exit D(1:N) contains the singular
         values of the modified matrix.

  VF     (input/output) DOUBLE PRECISION array, dimension ( M )
         On entry, VF(1:NL+1) contains the first components of all
         right singular vectors of the upper block; and VF(NL+2:M)
         contains the first components of all right singular vectors
         of the lower block. On exit, VF contains the first components

         of all right singular vectors of the bidiagonal matrix.

  VL     (input/output) DOUBLE PRECISION array, dimension ( M )
         On entry, VL(1:NL+1) contains the  last components of all
         right singular vectors of the upper block; and VL(NL+2:M)
         contains the last components of all right singular vectors of

         the lower block. On exit, VL contains the last components of
         all right singular vectors of the bidiagonal matrix.

  ALPHA  (input/output) DOUBLE PRECISION
         Contains the diagonal element associated with the added row.

  BETA   (input/output) DOUBLE PRECISION
         Contains the off-diagonal element associated with the added
         row.

  IDXQ   (output) INTEGER array, dimension ( N )
         This contains the permutation which will reintegrate the
         subproblem just solved back into sorted order, i.e.
         D( IDXQ( I = 1, N ) ) will be in ascending order.

  PERM   (output) INTEGER array, dimension ( N )
         The permutations (from deflation and sorting) to be applied
         to each block. Not referenced if ICOMPQ = 0.

  GIVPTR (output) INTEGER
         The number of Givens rotations which took place in this
         subproblem. Not referenced if ICOMPQ = 0.

  GIVCOL (output) INTEGER array, dimension ( LDGCOL, 2 )
         Each pair of numbers indicates a pair of columns to take place
         in a Givens rotation. Not referenced if ICOMPQ = 0.

  LDGCOL (input) INTEGER
         leading dimension of GIVCOL, must be at least N.

  GIVNUM (output) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
         Each number indicates the C or S value to be used in the
         corresponding Givens rotation. Not referenced if ICOMPQ = 0.

  LDGNUM (input) INTEGER
         The leading dimension of GIVNUM and POLES, must be at least N.

  POLES  (output) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
         On exit, POLES(1,*) is an array containing the new singular
         values obtained from solving the secular equation, and
         POLES(2,*) is an array containing the poles in the secular
         equation. Not referenced if ICOMPQ = 0.

  DIFL   (output) DOUBLE PRECISION array, dimension ( N )
         On exit, DIFL(I) is the distance between I-th updated
         (undeflated) singular value and the I-th (undeflated) old
         singular value.

  DIFR   (output) DOUBLE PRECISION array,
                  dimension ( LDGNUM, 2 ) if ICOMPQ = 1 and
                  dimension ( N ) if ICOMPQ = 0.
         On exit, DIFR(I, 1) is the distance between I-th updated
         (undeflated) singular value and the I+1-th (undeflated) old
         singular value.

         If ICOMPQ = 1, DIFR(1:K,2) is an array containing the
         normalizing factors for the right singular vector matrix.

         See DLASD8 for details on DIFL and DIFR.

  Z      (output) DOUBLE PRECISION array, dimension ( M )
         The first elements of this array contain the components
         of the deflation-adjusted updating row vector.

  K      (output) INTEGER
         Contains the dimension of the non-deflated matrix,
         This is the order of the related secular equation. 1 <= K <=N.

  C      (output) DOUBLE PRECISION
         C contains garbage if SQRE =0 and the C-value of a Givens
         rotation related to the right null space if SQRE = 1.

  S      (output) DOUBLE PRECISION
         S contains garbage if SQRE =0 and the S-value of a Givens
         rotation related to the right null space if SQRE = 1.

  WORK   (workspace) DOUBLE PRECISION array, dimension ( 4 * M )

  IWORK  (workspace) INTEGER array, dimension ( 3 * N )

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an singular value did not converge

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param nl
	 * @param nr
	 * @param sqre
	 * @param d
	 * @param vf
	 * @param vl
	 * @param alpha
	 * @param beta
	 * @param idxq
	 * @param perm
	 * @param givptr
	 * @param givcol
	 * @param ldgcol
	 * @param givnum
	 * @param ldgnum
	 * @param poles
	 * @param difl
	 * @param difr
	 * @param z
	 * @param k
	 * @param c
	 * @param s
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlasd6(int icompq, int nl, int nr, int sqre, double[] d, double[] vf, double[] vl, doubleW alpha, doubleW beta, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, double[] poles, double[] difl, double[] difr, double[] z, intW k, doubleW c, doubleW s, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASD7 merges the two sets of singular values together into a single

  sorted set. Then it tries to deflate the size of the problem. There
  are two ways in which deflation can occur:  when two or more singular
  values are close together or if there is a tiny entry in the Z
  vector. For each such occurrence the order of the related
  secular equation problem is reduced by one.

  DLASD7 is called from DLASD6.

  Arguments
  =========

  ICOMPQ  (input) INTEGER
          Specifies whether singular vectors are to be computed
          in compact form, as follows:
          = 0: Compute singular values only.
          = 1: Compute singular vectors of upper
               bidiagonal matrix in compact form.

  NL     (input) INTEGER
         The row dimension of the upper block. NL >= 1.

  NR     (input) INTEGER
         The row dimension of the lower block. NR >= 1.

  SQRE   (input) INTEGER
         = 0: the lower block is an NR-by-NR square matrix.
         = 1: the lower block is an NR-by-(NR+1) rectangular matrix.

         The bidiagonal matrix has
         N = NL + NR + 1 rows and
         M = N + SQRE >= N columns.

  K      (output) INTEGER
         Contains the dimension of the non-deflated matrix, this is
         the order of the related secular equation. 1 <= K <=N.

  D      (input/output) DOUBLE PRECISION array, dimension ( N )
         On entry D contains the singular values of the two submatrices
         to be combined. On exit D contains the trailing (N-K) updated

         singular values (those which were deflated) sorted into
         increasing order.

  Z      (output) DOUBLE PRECISION array, dimension ( M )
         On exit Z contains the updating row vector in the secular
         equation.

  ZW     (workspace) DOUBLE PRECISION array, dimension ( M )
         Workspace for Z.

  VF     (input/output) DOUBLE PRECISION array, dimension ( M )
         On entry, VF(1:NL+1) contains the first components of all
         right singular vectors of the upper block; and VF(NL+2:M)
         contains the first components of all right singular vectors
         of the lower block. On exit, VF contains the first components

         of all right singular vectors of the bidiagonal matrix.

  VFW    (workspace) DOUBLE PRECISION array, dimension ( M )
         Workspace for VF.

  VL     (input/output) DOUBLE PRECISION array, dimension ( M )
         On entry, VL(1:NL+1) contains the  last components of all
         right singular vectors of the upper block; and VL(NL+2:M)
         contains the last components of all right singular vectors
         of the lower block. On exit, VL contains the last components
         of all right singular vectors of the bidiagonal matrix.

  VLW    (workspace) DOUBLE PRECISION array, dimension ( M )
         Workspace for VL.

  ALPHA  (input) DOUBLE PRECISION
         Contains the diagonal element associated with the added row.

  BETA   (input) DOUBLE PRECISION
         Contains the off-diagonal element associated with the added
         row.

  DSIGMA (output) DOUBLE PRECISION array, dimension ( N )
         Contains a copy of the diagonal elements (K-1 singular values

         and one zero) in the secular equation.

  IDX    (workspace) INTEGER array, dimension ( N )
         This will contain the permutation used to sort the contents of
         D into ascending order.

  IDXP   (workspace) INTEGER array, dimension ( N )
         This will contain the permutation used to place deflated
         values of D at the end of the array. On output IDXP(2:K)
         points to the nondeflated D-values and IDXP(K+1:N)
         points to the deflated singular values.

  IDXQ   (input) INTEGER array, dimension ( N )
         This contains the permutation which separately sorts the two
         sub-problems in D into ascending order.  Note that entries in

         the first half of this permutation must first be moved one
         position backward; and entries in the second half
         must first have NL+1 added to their values.

  PERM   (output) INTEGER array, dimension ( N )
         The permutations (from deflation and sorting) to be applied
         to each singular block. Not referenced if ICOMPQ = 0.

  GIVPTR (output) INTEGER
         The number of Givens rotations which took place in this
         subproblem. Not referenced if ICOMPQ = 0.

  GIVCOL (output) INTEGER array, dimension ( LDGCOL, 2 )
         Each pair of numbers indicates a pair of columns to take place
         in a Givens rotation. Not referenced if ICOMPQ = 0.

  LDGCOL (input) INTEGER
         The leading dimension of GIVCOL, must be at least N.

  GIVNUM (output) DOUBLE PRECISION array, dimension ( LDGNUM, 2 )
         Each number indicates the C or S value to be used in the
         corresponding Givens rotation. Not referenced if ICOMPQ = 0.

  LDGNUM (input) INTEGER
         The leading dimension of GIVNUM, must be at least N.

  C      (output) DOUBLE PRECISION
         C contains garbage if SQRE =0 and the C-value of a Givens
         rotation related to the right null space if SQRE = 1.

  S      (output) DOUBLE PRECISION
         S contains garbage if SQRE =0 and the S-value of a Givens
         rotation related to the right null space if SQRE = 1.

  INFO   (output) INTEGER
         = 0:  successful exit.
         < 0:  if INFO = -i, the i-th argument had an illegal value.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param nl
	 * @param nr
	 * @param sqre
	 * @param k
	 * @param d
	 * @param z
	 * @param zw
	 * @param vf
	 * @param vfw
	 * @param vl
	 * @param vlw
	 * @param alpha
	 * @param beta
	 * @param dsigma
	 * @param idx
	 * @param idxp
	 * @param idxq
	 * @param perm
	 * @param givptr
	 * @param givcol
	 * @param ldgcol
	 * @param givnum
	 * @param ldgnum
	 * @param c
	 * @param s
	 * @param info
	 */
	public abstract void dlasd7(int icompq, int nl, int nr, int sqre, intW k, double[] d, double[] z, double[] zw, double[] vf, double[] vfw, double[] vl, double[] vlw, double alpha, double beta, double[] dsigma, int[] idx, int[] idxp, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, doubleW c, doubleW s, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASD8 finds the square roots of the roots of the secular equation,
  as defined by the values in DSIGMA and Z. It makes the appropriate
  calls to DLASD4, and stores, for each  element in D, the distance
  to its two nearest poles (elements in DSIGMA). It also updates
  the arrays VF and VL, the first and last components of all the
  right singular vectors of the original bidiagonal matrix.

  DLASD8 is called from DLASD6.

  Arguments
  =========

  ICOMPQ  (input) INTEGER
          Specifies whether singular vectors are to be computed in
          factored form in the calling routine:
          = 0: Compute singular values only.
          = 1: Compute singular vectors in factored form as well.

  K       (input) INTEGER
          The number of terms in the rational function to be solved
          by DLASD4.  K >= 1.

  D       (output) DOUBLE PRECISION array, dimension ( K )
          On output, D contains the updated singular values.

  Z       (input) DOUBLE PRECISION array, dimension ( K )
          The first K elements of this array contain the components
          of the deflation-adjusted updating row vector.

  VF      (input/output) DOUBLE PRECISION array, dimension ( K )
          On entry, VF contains  information passed through DBEDE8.
          On exit, VF contains the first K components of the first
          components of all right singular vectors of the bidiagonal
          matrix.

  VL      (input/output) DOUBLE PRECISION array, dimension ( K )
          On entry, VL contains  information passed through DBEDE8.
          On exit, VL contains the first K components of the last
          components of all right singular vectors of the bidiagonal
          matrix.

  DIFL    (output) DOUBLE PRECISION array, dimension ( K )
          On exit, DIFL(I) = D(I) - DSIGMA(I).

  DIFR    (output) DOUBLE PRECISION array,
                   dimension ( LDDIFR, 2 ) if ICOMPQ = 1 and
                   dimension ( K ) if ICOMPQ = 0.
          On exit, DIFR(I,1) = D(I) - DSIGMA(I+1), DIFR(K,1) is not
          defined and will not be referenced.

          If ICOMPQ = 1, DIFR(1:K,2) is an array containing the
          normalizing factors for the right singular vector matrix.

  LDDIFR  (input) INTEGER
          The leading dimension of DIFR, must be at least K.

  DSIGMA  (input) DOUBLE PRECISION array, dimension ( K )
          The first K elements of this array contain the old roots
          of the deflated updating problem.  These are the poles
          of the secular equation.

  WORK    (workspace) DOUBLE PRECISION array, dimension at least 3 * K


  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an singular value did not converge

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param k
	 * @param d
	 * @param z
	 * @param vf
	 * @param vl
	 * @param difl
	 * @param difr
	 * @param lddifr
	 * @param dsigma
	 * @param work
	 * @param info
	 */
	public abstract void dlasd8(int icompq, int k, double[] d, double[] z, double[] vf, double[] vl, double[] difl, double[] difr, int lddifr, double[] dsigma, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  Using a divide and conquer approach, DLASDA computes the singular
  value decomposition (SVD) of a real upper bidiagonal N-by-M matrix
  B with diagonal D and offdiagonal E, where M = N + SQRE. The
  algorithm computes the singular values in the SVD B = U * S * VT.
  The orthogonal matrices U and VT are optionally computed in
  compact form.

  A related subroutine, DLASD0, computes the singular values and
  the singular vectors in explicit form.

  Arguments
  =========

  ICOMPQ (input) INTEGER
         Specifies whether singular vectors are to be computed
         in compact form, as follows
         = 0: Compute singular values only.
         = 1: Compute singular vectors of upper bidiagonal
              matrix in compact form.

  SMLSIZ (input) INTEGER
         The maximum size of the subproblems at the bottom of the
         computation tree.

  N      (input) INTEGER
         The row dimension of the upper bidiagonal matrix. This is
         also the dimension of the main diagonal array D.

  SQRE   (input) INTEGER
         Specifies the column dimension of the bidiagonal matrix.
         = 0: The bidiagonal matrix has column dimension M = N;
         = 1: The bidiagonal matrix has column dimension M = N + 1.

  D      (input/output) DOUBLE PRECISION array, dimension ( N )
         On entry D contains the main diagonal of the bidiagonal
         matrix. On exit D, if INFO = 0, contains its singular values.


  E      (input) DOUBLE PRECISION array, dimension ( M-1 )
         Contains the subdiagonal entries of the bidiagonal matrix.
         On exit, E has been destroyed.

  U      (output) DOUBLE PRECISION array,
         dimension ( LDU, SMLSIZ ) if ICOMPQ = 1, and not referenced
         if ICOMPQ = 0. If ICOMPQ = 1, on exit, U contains the left
         singular vector matrices of all subproblems at the bottom
         level.

  LDU    (input) INTEGER, LDU = > N.
         The leading dimension of arrays U, VT, DIFL, DIFR, POLES,
         GIVNUM, and Z.

  VT     (output) DOUBLE PRECISION array,
         dimension ( LDU, SMLSIZ+1 ) if ICOMPQ = 1, and not referenced

         if ICOMPQ = 0. If ICOMPQ = 1, on exit, VT' contains the right

         singular vector matrices of all subproblems at the bottom
         level.

  K      (output) INTEGER array,
         dimension ( N ) if ICOMPQ = 1 and dimension 1 if ICOMPQ = 0.
         If ICOMPQ = 1, on exit, K(I) is the dimension of the I-th
         secular equation on the computation tree.

  DIFL   (output) DOUBLE PRECISION array, dimension ( LDU, NLVL ),
         where NLVL = floor(log_2 (N/SMLSIZ))).

  DIFR   (output) DOUBLE PRECISION array,
                  dimension ( LDU, 2 * NLVL ) if ICOMPQ = 1 and
                  dimension ( N ) if ICOMPQ = 0.
         If ICOMPQ = 1, on exit, DIFL(1:N, I) and DIFR(1:N, 2 * I - 1)

         record distances between singular values on the I-th
         level and singular values on the (I -1)-th level, and
         DIFR(1:N, 2 * I ) contains the normalizing factors for
         the right singular vector matrix. See DLASD8 for details.

  Z      (output) DOUBLE PRECISION array,
                  dimension ( LDU, NLVL ) if ICOMPQ = 1 and
                  dimension ( N ) if ICOMPQ = 0.
         The first K elements of Z(1, I) contain the components of
         the deflation-adjusted updating row vector for subproblems
         on the I-th level.

  POLES  (output) DOUBLE PRECISION array,
         dimension ( LDU, 2 * NLVL ) if ICOMPQ = 1, and not referenced

         if ICOMPQ = 0. If ICOMPQ = 1, on exit, POLES(1, 2*I - 1) and
         POLES(1, 2*I) contain  the new and old singular values
         involved in the secular equations on the I-th level.

  GIVPTR (output) INTEGER array,
         dimension ( N ) if ICOMPQ = 1, and not referenced if
         ICOMPQ = 0. If ICOMPQ = 1, on exit, GIVPTR( I ) records
         the number of Givens rotations performed on the I-th
         problem on the computation tree.

  GIVCOL (output) INTEGER array,
         dimension ( LDGCOL, 2 * NLVL ) if ICOMPQ = 1, and not
         referenced if ICOMPQ = 0. If ICOMPQ = 1, on exit, for each I,

         GIVCOL(1, 2 *I - 1) and GIVCOL(1, 2 *I) record the locations
         of Givens rotations performed on the I-th level on the
         computation tree.

  LDGCOL (input) INTEGER, LDGCOL = > N.
         The leading dimension of arrays GIVCOL and PERM.

  PERM   (output) INTEGER array,
         dimension ( LDGCOL, NLVL ) if ICOMPQ = 1, and not referenced
         if ICOMPQ = 0. If ICOMPQ = 1, on exit, PERM(1, I) records
         permutations done on the I-th level of the computation tree.

  GIVNUM (output) DOUBLE PRECISION array,
         dimension ( LDU,  2 * NLVL ) if ICOMPQ = 1, and not
         referenced if ICOMPQ = 0. If ICOMPQ = 1, on exit, for each I,

         GIVNUM(1, 2 *I - 1) and GIVNUM(1, 2 *I) record the C- and S-
         values of Givens rotations performed on the I-th level on
         the computation tree.

  C      (output) DOUBLE PRECISION array,
         dimension ( N ) if ICOMPQ = 1, and dimension 1 if ICOMPQ = 0.

         If ICOMPQ = 1 and the I-th subproblem is not square, on exit,

         C( I ) contains the C-value of a Givens rotation related to
         the right null space of the I-th subproblem.

  S      (output) DOUBLE PRECISION array, dimension ( N ) if
         ICOMPQ = 1, and dimension 1 if ICOMPQ = 0. If ICOMPQ = 1
         and the I-th subproblem is not square, on exit, S( I )
         contains the S-value of a Givens rotation related to
         the right null space of the I-th subproblem.

  WORK   (workspace) DOUBLE PRECISION array, dimension
         (6 * N + (SMLSIZ + 1)*(SMLSIZ + 1)).

  IWORK  (workspace) INTEGER array.
         Dimension must be at least (7 * N).

  INFO   (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = 1, an singular value did not converge

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param icompq
	 * @param smlsiz
	 * @param n
	 * @param sqre
	 * @param d
	 * @param e
	 * @param u
	 * @param ldu
	 * @param vt
	 * @param k
	 * @param difl
	 * @param difr
	 * @param z
	 * @param poles
	 * @param givptr
	 * @param givcol
	 * @param ldgcol
	 * @param perm
	 * @param givnum
	 * @param c
	 * @param s
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dlasda(int icompq, int smlsiz, int n, int sqre, double[] d, double[] e, double[] u, int ldu, double[] vt, int[] k, double[] difl, double[] difr, double[] z, double[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, double[] givnum, double[] c, double[] s, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASDQ computes the singular value decomposition (SVD) of a real
  (upper or lower) bidiagonal matrix with diagonal D and offdiagonal
  E, accumulating the transformations if desired. Letting B denote
  the input bidiagonal matrix, the algorithm computes orthogonal
  matrices Q and P such that B = Q * S * P' (P' denotes the transpose
  of P). The singular values S are overwritten on D.

  The input matrix U  is changed to U  * Q  if desired.
  The input matrix VT is changed to P' * VT if desired.
  The input matrix C  is changed to Q' * C  if desired.

  See "Computing  Small Singular Values of Bidiagonal Matrices With
  Guaranteed High Relative Accuracy," by J. Demmel and W. Kahan,
  LAPACK Working Note #3, for a detailed description of the algorithm.


  Arguments
  =========

  UPLO  (input) CHARACTER*1
        On entry, UPLO specifies whether the input bidiagonal matrix
        is upper or lower bidiagonal, and wether it is square are
        not.
           UPLO = 'U' or 'u'   B is upper bidiagonal.
           UPLO = 'L' or 'l'   B is lower bidiagonal.

  SQRE  (input) INTEGER
        = 0: then the input matrix is N-by-N.
        = 1: then the input matrix is N-by-(N+1) if UPLU = 'U' and
             (N+1)-by-N if UPLU = 'L'.

        The bidiagonal matrix has
        N = NL + NR + 1 rows and
        M = N + SQRE >= N columns.

  N     (input) INTEGER
        On entry, N specifies the number of rows and columns
        in the matrix. N must be at least 0.

  NCVT  (input) INTEGER
        On entry, NCVT specifies the number of columns of
        the matrix VT. NCVT must be at least 0.

  NRU   (input) INTEGER
        On entry, NRU specifies the number of rows of
        the matrix U. NRU must be at least 0.

  NCC   (input) INTEGER
        On entry, NCC specifies the number of columns of
        the matrix C. NCC must be at least 0.

  D     (input/output) DOUBLE PRECISION array, dimension (N)
        On entry, D contains the diagonal entries of the
        bidiagonal matrix whose SVD is desired. On normal exit,
        D contains the singular values in ascending order.

  E     (input/output) DOUBLE PRECISION array.
        dimension is (N-1) if SQRE = 0 and N if SQRE = 1.
        On entry, the entries of E contain the offdiagonal entries
        of the bidiagonal matrix whose SVD is desired. On normal
        exit, E will contain 0. If the algorithm does not converge,
        D and E will contain the diagonal and superdiagonal entries
        of a bidiagonal matrix orthogonally equivalent to the one
        given as input.

  VT    (input/output) DOUBLE PRECISION array, dimension (LDVT, NCVT)
        On entry, contains a matrix which on exit has been
        premultiplied by P', dimension N-by-NCVT if SQRE = 0
        and (N+1)-by-NCVT if SQRE = 1 (not referenced if NCVT=0).

  LDVT  (input) INTEGER
        On entry, LDVT specifies the leading dimension of VT as
        declared in the calling (sub) program. LDVT must be at
        least 1. If NCVT is nonzero LDVT must also be at least N.

  U     (input/output) DOUBLE PRECISION array, dimension (LDU, N)
        On entry, contains a  matrix which on exit has been
        postmultiplied by Q, dimension NRU-by-N if SQRE = 0
        and NRU-by-(N+1) if SQRE = 1 (not referenced if NRU=0).

  LDU   (input) INTEGER
        On entry, LDU  specifies the leading dimension of U as
        declared in the calling (sub) program. LDU must be at
        least max( 1, NRU ) .

  C     (input/output) DOUBLE PRECISION array, dimension (LDC, NCC)
        On entry, contains an N-by-NCC matrix which on exit
        has been premultiplied by Q'  dimension N-by-NCC if SQRE = 0
        and (N+1)-by-NCC if SQRE = 1 (not referenced if NCC=0).

  LDC   (input) INTEGER
        On entry, LDC  specifies the leading dimension of C as
        declared in the calling (sub) program. LDC must be at
        least 1. If NCC is nonzero, LDC must also be at least N.

  WORK  (workspace) DOUBLE PRECISION array, dimension (4*N)
        Workspace. Only referenced if one of NCVT, NRU, or NCC is
        nonzero, and if N is at least 2.

  INFO  (output) INTEGER
        On exit, a value of 0 indicates a successful exit.
        If INFO < 0, argument number -INFO is illegal.
        If INFO > 0, the algorithm did not converge, and INFO
        specifies how many superdiagonals did not converge.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param sqre
	 * @param n
	 * @param ncvt
	 * @param nru
	 * @param ncc
	 * @param d
	 * @param e
	 * @param vt
	 * @param ldvt
	 * @param u
	 * @param ldu
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dlasdq(String uplo, int sqre, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASDT creates a tree of subproblems for bidiagonal divide and
  conquer.

  Arguments
  =========

   N      (input) INTEGER
          On entry, the number of diagonal elements of the
          bidiagonal matrix.

   LVL    (output) INTEGER
          On exit, the number of levels on the computation tree.

   ND     (output) INTEGER
          On exit, the number of nodes on the tree.

   INODE  (output) INTEGER array, dimension ( N )
          On exit, centers of subproblems.

   NDIML  (output) INTEGER array, dimension ( N )
          On exit, row dimensions of left children.

   NDIMR  (output) INTEGER array, dimension ( N )
          On exit, row dimensions of right children.

   MSUB   (input) INTEGER.
          On entry, the maximum row dimension each subproblem at the
          bottom of the tree can be of.

  Further Details
  ===============

  Based on contributions by
     Ming Gu and Huan Ren, Computer Science Division, University of
     California at Berkeley, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param lvl
	 * @param nd
	 * @param inode
	 * @param ndiml
	 * @param ndimr
	 * @param msub
	 */
	public abstract void dlasdt(int n, intW lvl, intW nd, int[] inode, int[] ndiml, int[] ndimr, int msub);

	/**
<pre>

     ..

  Purpose
  =======

  DLASET initializes an m-by-n matrix A to BETA on the diagonal and
  ALPHA on the offdiagonals.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies the part of the matrix A to be set.
          = 'U':      Upper triangular part is set; the strictly lower

                      triangular part of A is not changed.
          = 'L':      Lower triangular part is set; the strictly upper

                      triangular part of A is not changed.
          Otherwise:  All of the matrix A is set.

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  ALPHA   (input) DOUBLE PRECISION
          The constant to which the offdiagonal elements are to be set.

  BETA    (input) DOUBLE PRECISION
          The constant to which the diagonal elements are to be set.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On exit, the leading m-by-n submatrix of A is set as follows:

          if UPLO = 'U', A(i,j) = ALPHA, 1<=i<=j-1, 1<=j<=n,
          if UPLO = 'L', A(i,j) = ALPHA, j+1<=i<=m, 1<=j<=n,
          otherwise,     A(i,j) = ALPHA, 1<=i<=m, 1<=j<=n, i.ne.j,

          and, for all UPLO, A(i,i) = BETA, 1<=i<=min(m,n).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

 =====================================================================


     .. Local Scalars ..
</pre>
	 * @param uplo
	 * @param m
	 * @param n
	 * @param alpha
	 * @param beta
	 * @param a
	 * @param lda
	 */
	public abstract void dlaset(String uplo, int m, int n, double alpha, double beta, double[] a, int lda);

	/**
<pre>

     ..

  Purpose
  =======

  DLASQ1 computes the singular values of a real N-by-N bidiagonal
  matrix with diagonal D and off-diagonal E. The singular values
  are computed to high relative accuracy, in the absence of
  denormalization, underflow and overflow. The algorithm was first
  presented in

  "Accurate singular values and differential qd algorithms" by K. V.
  Fernando and B. N. Parlett, Numer. Math., Vol-67, No. 2, pp. 191-230,
  1994,

  and the present implementation is described in "An implementation of

  the dqds Algorithm (Positive Case)", LAPACK Working Note.

  Arguments
  =========

  N     (input) INTEGER
        The number of rows and columns in the matrix. N >= 0.

  D     (input/output) DOUBLE PRECISION array, dimension (N)
        On entry, D contains the diagonal elements of the
        bidiagonal matrix whose SVD is desired. On normal exit,
        D contains the singular values in decreasing order.

  E     (input/output) DOUBLE PRECISION array, dimension (N)
        On entry, elements E(1:N-1) contain the off-diagonal elements
        of the bidiagonal matrix whose SVD is desired.
        On exit, E is overwritten.

  WORK  (workspace) DOUBLE PRECISION array, dimension (4*N)

  INFO  (output) INTEGER
        = 0: successful exit
        < 0: if INFO = -i, the i-th argument had an illegal value
        > 0: the algorithm failed
             = 1, a split was marked by a positive value in E
             = 2, current block of Z not diagonalized after 30*N
                  iterations (in inner while loop)
             = 3, termination criterion of outer while loop not met 
                  (program created more than N unreduced blocks)

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param e
	 * @param work
	 * @param info
	 */
	public abstract void dlasq1(int n, double[] d, double[] e, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASQ2 computes all the eigenvalues of the symmetric positive 
  definite tridiagonal matrix associated with the qd array Z to high
  relative accuracy are computed to high relative accuracy, in the
  absence of denormalization, underflow and overflow.

  To see the relation of Z to the tridiagonal matrix, let L be a
  unit lower bidiagonal matrix with subdiagonals Z(2,4,6,,..) and
  let U be an upper bidiagonal matrix with 1's above and diagonal
  Z(1,3,5,,..). The tridiagonal is L*U or, if you prefer, the
  symmetric tridiagonal to which it is similar.

  Note : DLASQ2 defines a logical variable, IEEE, which is true
  on machines which follow ieee-754 floating-point standard in their
  handling of infinities and NaNs, and false otherwise. This variable
  is passed to DLAZQ3.

  Arguments
  =========

  N     (input) INTEGER
        The number of rows and columns in the matrix. N >= 0.

  Z     (workspace) DOUBLE PRECISION array, dimension ( 4*N )
        On entry Z holds the qd array. On exit, entries 1 to N hold
        the eigenvalues in decreasing order, Z( 2*N+1 ) holds the
        trace, and Z( 2*N+2 ) holds the sum of the eigenvalues. If
        N > 2, then Z( 2*N+3 ) holds the iteration count, Z( 2*N+4 )
        holds NDIVS/NIN^2, and Z( 2*N+5 ) holds the percentage of
        shifts that failed.

  INFO  (output) INTEGER
        = 0: successful exit
        < 0: if the i-th argument is a scalar and had an illegal
             value, then INFO = -i, if the i-th argument is an
             array and the j-entry had an illegal value, then
             INFO = -(i*100+j)
        > 0: the algorithm failed
              = 1, a split was marked by a positive value in E
              = 2, current block of Z not diagonalized after 30*N
                   iterations (in inner while loop)
              = 3, termination criterion of outer while loop not met 
                   (program created more than N unreduced blocks)

  Further Details
  ===============
  Local Variables: I0:N0 defines a current unreduced segment of Z.
  The shifts are accumulated in SIGMA. Iteration count is in ITER.
  Ping-pong is controlled by PP (alternates between 0 and 1).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param z
	 * @param info
	 */
	public abstract void dlasq2(int n, double[] z, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASQ3 checks for deflation, computes a shift (TAU) and calls dqds.
  In case of failure it changes shifts, and tries again until output
  is positive.

  Arguments
  =========

  I0     (input) INTEGER
         First index.

  N0     (input) INTEGER
         Last index.

  Z      (input) DOUBLE PRECISION array, dimension ( 4*N )
         Z holds the qd array.

  PP     (input) INTEGER
         PP=0 for ping, PP=1 for pong.

  DMIN   (output) DOUBLE PRECISION
         Minimum value of d.

  SIGMA  (output) DOUBLE PRECISION
         Sum of shifts used in current segment.

  DESIG  (input/output) DOUBLE PRECISION
         Lower order part of SIGMA

  QMAX   (input) DOUBLE PRECISION
         Maximum value of q.

  NFAIL  (output) INTEGER
         Number of times shift was too big.

  ITER   (output) INTEGER
         Number of iterations.

  NDIV   (output) INTEGER
         Number of divisions.

  TTYPE  (output) INTEGER
         Shift type.

  IEEE   (input) LOGICAL
         Flag for IEEE or non IEEE arithmetic (passed to DLASQ5).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param i0
	 * @param n0
	 * @param z
	 * @param pp
	 * @param dmin
	 * @param sigma
	 * @param desig
	 * @param qmax
	 * @param nfail
	 * @param iter
	 * @param ndiv
	 * @param ieee
	 */
	public abstract void dlasq3(int i0, intW n0, double[] z, int pp, doubleW dmin, doubleW sigma, doubleW desig, doubleW qmax, intW nfail, intW iter, intW ndiv, boolean ieee);

	/**
<pre>

     ..

  Purpose
  =======

  DLASQ4 computes an approximation TAU to the smallest eigenvalue 
  using values of d from the previous transform.

  I0    (input) INTEGER
        First index.

  N0    (input) INTEGER
        Last index.

  Z     (input) DOUBLE PRECISION array, dimension ( 4*N )
        Z holds the qd array.

  PP    (input) INTEGER
        PP=0 for ping, PP=1 for pong.

  N0IN  (input) INTEGER
        The value of N0 at start of EIGTEST.

  DMIN  (input) DOUBLE PRECISION
        Minimum value of d.

  DMIN1 (input) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ).

  DMIN2 (input) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ) and D( N0-1 ).

  DN    (input) DOUBLE PRECISION
        d(N)

  DN1   (input) DOUBLE PRECISION
        d(N-1)

  DN2   (input) DOUBLE PRECISION
        d(N-2)

  TAU   (output) DOUBLE PRECISION
        This is the shift.

  TTYPE (output) INTEGER
        Shift type.

  Further Details
  ===============
  CNST1 = 9/16

  =====================================================================

     .. Parameters ..
</pre>
	 * @param i0
	 * @param n0
	 * @param z
	 * @param pp
	 * @param n0in
	 * @param dmin
	 * @param dmin1
	 * @param dmin2
	 * @param dn
	 * @param dn1
	 * @param dn2
	 * @param tau
	 * @param ttype
	 */
	public abstract void dlasq4(int i0, int n0, double[] z, int pp, int n0in, double dmin, double dmin1, double dmin2, double dn, double dn1, double dn2, doubleW tau, intW ttype);

	/**
<pre>

     ..

  Purpose
  =======

  DLASQ5 computes one dqds transform in ping-pong form, one
  version for IEEE machines another for non IEEE machines.

  Arguments
  =========

  I0    (input) INTEGER
        First index.

  N0    (input) INTEGER
        Last index.

  Z     (input) DOUBLE PRECISION array, dimension ( 4*N )
        Z holds the qd array. EMIN is stored in Z(4*N0) to avoid
        an extra argument.

  PP    (input) INTEGER
        PP=0 for ping, PP=1 for pong.

  TAU   (input) DOUBLE PRECISION
        This is the shift.

  DMIN  (output) DOUBLE PRECISION
        Minimum value of d.

  DMIN1 (output) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ).

  DMIN2 (output) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ) and D( N0-1 ).

  DN    (output) DOUBLE PRECISION
        d(N0), the last value of d.

  DNM1  (output) DOUBLE PRECISION
        d(N0-1).

  DNM2  (output) DOUBLE PRECISION
        d(N0-2).

  IEEE  (input) LOGICAL
        Flag for IEEE or non IEEE arithmetic.

  =====================================================================

     .. Parameter ..
</pre>
	 * @param i0
	 * @param n0
	 * @param z
	 * @param pp
	 * @param tau
	 * @param dmin
	 * @param dmin1
	 * @param dmin2
	 * @param dn
	 * @param dnm1
	 * @param dnm2
	 * @param ieee
	 */
	public abstract void dlasq5(int i0, int n0, double[] z, int pp, double tau, doubleW dmin, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dnm1, doubleW dnm2, boolean ieee);

	/**
<pre>

     ..

  Purpose
  =======

  DLASQ6 computes one dqd (shift equal to zero) transform in
  ping-pong form, with protection against underflow and overflow.

  Arguments
  =========

  I0    (input) INTEGER
        First index.

  N0    (input) INTEGER
        Last index.

  Z     (input) DOUBLE PRECISION array, dimension ( 4*N )
        Z holds the qd array. EMIN is stored in Z(4*N0) to avoid
        an extra argument.

  PP    (input) INTEGER
        PP=0 for ping, PP=1 for pong.

  DMIN  (output) DOUBLE PRECISION
        Minimum value of d.

  DMIN1 (output) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ).

  DMIN2 (output) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ) and D( N0-1 ).

  DN    (output) DOUBLE PRECISION
        d(N0), the last value of d.

  DNM1  (output) DOUBLE PRECISION
        d(N0-1).

  DNM2  (output) DOUBLE PRECISION
        d(N0-2).

  =====================================================================

     .. Parameter ..
</pre>
	 * @param i0
	 * @param n0
	 * @param z
	 * @param pp
	 * @param dmin
	 * @param dmin1
	 * @param dmin2
	 * @param dn
	 * @param dnm1
	 * @param dnm2
	 */
	public abstract void dlasq6(int i0, int n0, double[] z, int pp, doubleW dmin, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dnm1, doubleW dnm2);

	/**
<pre>

     ..

  Purpose
  =======

  DLASR applies a sequence of plane rotations to a real matrix A,
  from either the left or the right.
  
  When SIDE = 'L', the transformation takes the form
  
     A := P*A
  
  and when SIDE = 'R', the transformation takes the form
  
     A := A*P**T
  
  where P is an orthogonal matrix consisting of a sequence of z plane
  rotations, with z = M when SIDE = 'L' and z = N when SIDE = 'R',
  and P**T is the transpose of P.
  
  When DIRECT = 'F' (Forward sequence), then
  
     P = P(z-1) * ... * P(2) * P(1)
  
  and when DIRECT = 'B' (Backward sequence), then
  
     P = P(1) * P(2) * ... * P(z-1)
  
  where P(k) is a plane rotation matrix defined by the 2-by-2 rotation

  
     R(k) = (  c(k)  s(k) )
          = ( -s(k)  c(k) ).
  
  When PIVOT = 'V' (Variable pivot), the rotation is performed
  for the plane (k,k+1), i.e., P(k) has the form
  
     P(k) = (  1                                            )
            (       ...                                     )
            (              1                                )
            (                   c(k)  s(k)                  )
            (                  -s(k)  c(k)                  )
            (                                1              )
            (                                     ...       )
            (                                            1  )
  
  where R(k) appears as a rank-2 modification to the identity matrix in
  rows and columns k and k+1.
  
  When PIVOT = 'T' (Top pivot), the rotation is performed for the
  plane (1,k+1), so P(k) has the form
  
     P(k) = (  c(k)                    s(k)                 )
            (         1                                     )
            (              ...                              )
            (                     1                         )
            ( -s(k)                    c(k)                 )
            (                                 1             )
            (                                      ...      )
            (                                             1 )
  
  where R(k) appears in rows and columns 1 and k+1.
  
  Similarly, when PIVOT = 'B' (Bottom pivot), the rotation is
  performed for the plane (k,z), giving P(k) the form
  
     P(k) = ( 1                                             )
            (      ...                                      )
            (             1                                 )
            (                  c(k)                    s(k) )
            (                         1                     )
            (                              ...              )
            (                                     1         )
            (                 -s(k)                    c(k) )
  
  where R(k) appears in rows and columns k and z.  The rotations are
  performed without ever forming P(k) explicitly.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          Specifies whether the plane rotation matrix P is applied to
          A on the left or the right.
          = 'L':  Left, compute A := P*A
          = 'R':  Right, compute A:= A*P**T

  PIVOT   (input) CHARACTER*1
          Specifies the plane for which P(k) is a plane rotation
          matrix.
          = 'V':  Variable pivot, the plane (k,k+1)
          = 'T':  Top pivot, the plane (1,k+1)
          = 'B':  Bottom pivot, the plane (k,z)

  DIRECT  (input) CHARACTER*1
          Specifies whether P is a forward or backward sequence of
          plane rotations.
          = 'F':  Forward, P = P(z-1)*...*P(2)*P(1)
          = 'B':  Backward, P = P(1)*P(2)*...*P(z-1)

  M       (input) INTEGER
          The number of rows of the matrix A.  If m <= 1, an immediate

          return is effected.

  N       (input) INTEGER
          The number of columns of the matrix A.  If n <= 1, an
          immediate return is effected.

  C       (input) DOUBLE PRECISION array, dimension
                  (M-1) if SIDE = 'L'
                  (N-1) if SIDE = 'R'
          The cosines c(k) of the plane rotations.

  S       (input) DOUBLE PRECISION array, dimension
                  (M-1) if SIDE = 'L'
                  (N-1) if SIDE = 'R'
          The sines s(k) of the plane rotations.  The 2-by-2 plane
          rotation part of the matrix P(k), R(k), has the form
          R(k) = (  c(k)  s(k) )
                 ( -s(k)  c(k) ).

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          The M-by-N matrix A.  On exit, A is overwritten by P*A if
          SIDE = 'R' or by A*P**T if SIDE = 'L'.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param pivot
	 * @param direct
	 * @param m
	 * @param n
	 * @param c
	 * @param s
	 * @param a
	 * @param lda
	 */
	public abstract void dlasr(String side, String pivot, String direct, int m, int n, double[] c, double[] s, double[] a, int lda);

	/**
<pre>

     ..

  Purpose
  =======

  Sort the numbers in D in increasing order (if ID = 'I') or
  in decreasing order (if ID = 'D' ).

  Use Quick Sort, reverting to Insertion sort on arrays of
  size <= 20. Dimension of STACK limits N to about 2**32.

  Arguments
  =========

  ID      (input) CHARACTER*1
          = 'I': sort D in increasing order;
          = 'D': sort D in decreasing order.

  N       (input) INTEGER
          The length of the array D.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the array to be sorted.
          On exit, D has been sorted into increasing order
          (D(1) <= ... <= D(N) ) or into decreasing order
          (D(1) >= ... >= D(N) ), depending on ID.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param id
	 * @param n
	 * @param d
	 * @param info
	 */
	public abstract void dlasrt(String id, int n, double[] d, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASSQ  returns the values  scl  and  smsq  such that

     ( scl**2 )*smsq = x( 1 )**2 +...+ x( n )**2 + ( scale**2 )*sumsq,


  where  x( i ) = X( 1 + ( i - 1 )*INCX ). The value of  sumsq  is
  assumed to be non-negative and  scl  returns the value

     scl = max( scale, abs( x( i ) ) ).

  scale and sumsq must be supplied in SCALE and SUMSQ and
  scl and smsq are overwritten on SCALE and SUMSQ respectively.

  The routine makes only one pass through the vector x.

  Arguments
  =========

  N       (input) INTEGER
          The number of elements to be used from the vector X.

  X       (input) DOUBLE PRECISION array, dimension (N)
          The vector for which a scaled sum of squares is computed.
             x( i )  = X( 1 + ( i - 1 )*INCX ), 1 <= i <= n.

  INCX    (input) INTEGER
          The increment between successive values of the vector X.
          INCX > 0.

  SCALE   (input/output) DOUBLE PRECISION
          On entry, the value  scale  in the equation above.
          On exit, SCALE is overwritten with  scl , the scaling factor

          for the sum of squares.

  SUMSQ   (input/output) DOUBLE PRECISION
          On entry, the value  sumsq  in the equation above.
          On exit, SUMSQ is overwritten with  smsq , the basic sum of
          squares from which  scl  has been factored out.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param n
	 * @param x
	 * @param incx
	 * @param scale
	 * @param sumsq
	 */
	public abstract void dlassq(int n, double[] x, int incx, doubleW scale, doubleW sumsq);

	/**
<pre>

     ..

  Purpose
  =======

  DLASV2 computes the singular value decomposition of a 2-by-2
  triangular matrix
     [  F   G  ]
     [  0   H  ].
  On return, abs(SSMAX) is the larger singular value, abs(SSMIN) is the
  smaller singular value, and (CSL,SNL) and (CSR,SNR) are the left and

  right singular vectors for abs(SSMAX), giving the decomposition

     [ CSL  SNL ] [  F   G  ] [ CSR -SNR ]  =  [ SSMAX   0   ]
     [-SNL  CSL ] [  0   H  ] [ SNR  CSR ]     [  0    SSMIN ].

  Arguments
  =========

  F       (input) DOUBLE PRECISION
          The (1,1) element of the 2-by-2 matrix.

  G       (input) DOUBLE PRECISION
          The (1,2) element of the 2-by-2 matrix.

  H       (input) DOUBLE PRECISION
          The (2,2) element of the 2-by-2 matrix.

  SSMIN   (output) DOUBLE PRECISION
          abs(SSMIN) is the smaller singular value.

  SSMAX   (output) DOUBLE PRECISION
          abs(SSMAX) is the larger singular value.

  SNL     (output) DOUBLE PRECISION
  CSL     (output) DOUBLE PRECISION
          The vector (CSL, SNL) is a unit left singular vector for the

          singular value abs(SSMAX).

  SNR     (output) DOUBLE PRECISION
  CSR     (output) DOUBLE PRECISION
          The vector (CSR, SNR) is a unit right singular vector for the
          singular value abs(SSMAX).

  Further Details
  ===============

  Any input parameter may be aliased with any output parameter.

  Barring over/underflow and assuming a guard digit in subtraction, all
  output quantities are correct to within a few units in the last
  place (ulps).

  In IEEE arithmetic, the code works correctly if one matrix element is
  infinite.

  Overflow will not occur unless the largest singular value itself
  overflows or is within a few ulps of overflow. (On machines with
  partial overflow, like the Cray, overflow may occur if the largest
  singular value is within a factor of 2 of overflow.)

  Underflow is harmless if underflow is gradual. Otherwise, results
  may correspond to a matrix modified by perturbations of size near
  the underflow threshold.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param f
	 * @param g
	 * @param h
	 * @param ssmin
	 * @param ssmax
	 * @param snr
	 * @param csr
	 * @param snl
	 * @param csl
	 */
	public abstract void dlasv2(double f, double g, double h, doubleW ssmin, doubleW ssmax, doubleW snr, doubleW csr, doubleW snl, doubleW csl);

	/**
<pre>

     ..

  Purpose
  =======

  DLASWP performs a series of row interchanges on the matrix A.
  One row interchange is initiated for each of rows K1 through K2 of A.

  Arguments
  =========

  N       (input) INTEGER
          The number of columns of the matrix A.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the matrix of column dimension N to which the row
          interchanges will be applied.
          On exit, the permuted matrix.

  LDA     (input) INTEGER
          The leading dimension of the array A.

  K1      (input) INTEGER
          The first element of IPIV for which a row interchange will
          be done.

  K2      (input) INTEGER
          The last element of IPIV for which a row interchange will
          be done.

  IPIV    (input) INTEGER array, dimension (K2*abs(INCX))
          The vector of pivot indices.  Only the elements in positions

          K1 through K2 of IPIV are accessed.
          IPIV(K) = L implies rows K and L are to be interchanged.

  INCX    (input) INTEGER
          The increment between successive values of IPIV.  If IPIV
          is negative, the pivots are applied in reverse order.

  Further Details
  ===============

  Modified by
   R. C. Whaley, Computer Science Dept., Univ. of Tenn., Knoxville, USA

 =====================================================================


     .. Local Scalars ..
</pre>
	 * @param n
	 * @param a
	 * @param lda
	 * @param k1
	 * @param k2
	 * @param ipiv
	 * @param incx
	 */
	public abstract void dlaswp(int n, double[] a, int lda, int k1, int k2, int[] ipiv, int incx);

	/**
<pre>

     ..

  Purpose
  =======

  DLASY2 solves for the N1 by N2 matrix X, 1 <= N1,N2 <= 2, in

         op(TL)*X + ISGN*X*op(TR) = SCALE*B,

  where TL is N1 by N1, TR is N2 by N2, B is N1 by N2, and ISGN = 1 or

  -1.  op(T) = T or T', where T' denotes the transpose of T.

  Arguments
  =========

  LTRANL  (input) LOGICAL
          On entry, LTRANL specifies the op(TL):
             = .FALSE., op(TL) = TL,
             = .TRUE., op(TL) = TL'.

  LTRANR  (input) LOGICAL
          On entry, LTRANR specifies the op(TR):
            = .FALSE., op(TR) = TR,
            = .TRUE., op(TR) = TR'.

  ISGN    (input) INTEGER
          On entry, ISGN specifies the sign of the equation
          as described before. ISGN may only be 1 or -1.

  N1      (input) INTEGER
          On entry, N1 specifies the order of matrix TL.
          N1 may only be 0, 1 or 2.

  N2      (input) INTEGER
          On entry, N2 specifies the order of matrix TR.
          N2 may only be 0, 1 or 2.

  TL      (input) DOUBLE PRECISION array, dimension (LDTL,2)
          On entry, TL contains an N1 by N1 matrix.

  LDTL    (input) INTEGER
          The leading dimension of the matrix TL. LDTL >= max(1,N1).

  TR      (input) DOUBLE PRECISION array, dimension (LDTR,2)
          On entry, TR contains an N2 by N2 matrix.

  LDTR    (input) INTEGER
          The leading dimension of the matrix TR. LDTR >= max(1,N2).

  B       (input) DOUBLE PRECISION array, dimension (LDB,2)
          On entry, the N1 by N2 matrix B contains the right-hand
          side of the equation.

  LDB     (input) INTEGER
          The leading dimension of the matrix B. LDB >= max(1,N1).

  SCALE   (output) DOUBLE PRECISION
          On exit, SCALE contains the scale factor. SCALE is chosen
          less than or equal to 1 to prevent the solution overflowing.


  X       (output) DOUBLE PRECISION array, dimension (LDX,2)
          On exit, X contains the N1 by N2 solution.

  LDX     (input) INTEGER
          The leading dimension of the matrix X. LDX >= max(1,N1).

  XNORM   (output) DOUBLE PRECISION
          On exit, XNORM is the infinity-norm of the solution.

  INFO    (output) INTEGER
          On exit, INFO is set to
             0: successful exit.
             1: TL and TR have too close eigenvalues, so TL or
                TR is perturbed to get a nonsingular equation.
          NOTE: In the interests of speed, this routine does not
                check the inputs for errors.

 =====================================================================


     .. Parameters ..
</pre>
	 * @param ltranl
	 * @param ltranr
	 * @param isgn
	 * @param n1
	 * @param n2
	 * @param tl
	 * @param ldtl
	 * @param tr
	 * @param ldtr
	 * @param b
	 * @param ldb
	 * @param scale
	 * @param x
	 * @param ldx
	 * @param xnorm
	 * @param info
	 */
	public abstract void dlasy2(boolean ltranl, boolean ltranr, int isgn, int n1, int n2, double[] tl, int ldtl, double[] tr, int ldtr, double[] b, int ldb, doubleW scale, double[] x, int ldx, doubleW xnorm, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLASYF computes a partial factorization of a real symmetric matrix A

  using the Bunch-Kaufman diagonal pivoting method. The partial
  factorization has the form:

  A  =  ( I  U12 ) ( A11  0  ) (  I    0   )  if UPLO = 'U', or:
        ( 0  U22 ) (  0   D  ) ( U12' U22' )

  A  =  ( L11  0 ) (  D   0  ) ( L11' L21' )  if UPLO = 'L'
        ( L21  I ) (  0  A22 ) (  0    I   )

  where the order of D is at most NB. The actual order is returned in
  the argument KB, and is either NB or NB-1, or N if N <= NB.

  DLASYF is an auxiliary routine called by DSYTRF. It uses blocked code
  (calling Level 3 BLAS) to update the submatrix A11 (if UPLO = 'U') or
  A22 (if UPLO = 'L').

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored:
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NB      (input) INTEGER
          The maximum number of columns of the matrix A that should be

          factored.  NB should be at least 2 to allow for 2-by-2 pivot

          blocks.

  KB      (output) INTEGER
          The number of columns of A that were actually factored.
          KB is either NB-1 or NB, or N if N <= NB.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A.  If UPLO = 'U', the leading
          n-by-n upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading n-by-n lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.
          On exit, A contains details of the partial factorization.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  IPIV    (output) INTEGER array, dimension (N)
          Details of the interchanges and the block structure of D.
          If UPLO = 'U', only the last KB elements of IPIV are set;
          if UPLO = 'L', only the first KB elements are set.

          If IPIV(k) > 0, then rows and columns k and IPIV(k) were
          interchanged and D(k,k) is a 1-by-1 diagonal block.
          If UPLO = 'U' and IPIV(k) = IPIV(k-1) < 0, then rows and
          columns k-1 and -IPIV(k) were interchanged and D(k-1:k,k-1:k)
          is a 2-by-2 diagonal block.  If UPLO = 'L' and IPIV(k) =
          IPIV(k+1) < 0, then rows and columns k+1 and -IPIV(k) were
          interchanged and D(k:k+1,k:k+1) is a 2-by-2 diagonal block.

  W       (workspace) DOUBLE PRECISION array, dimension (LDW,NB)

  LDW     (input) INTEGER
          The leading dimension of the array W.  LDW >= max(1,N).

  INFO    (output) INTEGER
          = 0: successful exit
          > 0: if INFO = k, D(k,k) is exactly zero.  The factorization

               has been completed, but the block diagonal matrix D is
               exactly singular.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nb
	 * @param kb
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param w
	 * @param ldw
	 * @param info
	 */
	public abstract void dlasyf(String uplo, int n, int nb, intW kb, double[] a, int lda, int[] ipiv, double[] w, int ldw, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLATBS solves one of the triangular systems

     A *x = s*b  or  A'*x = s*b

  with scaling to prevent overflow, where A is an upper or lower
  triangular band matrix.  Here A' denotes the transpose of A, x and b

  are n-element vectors, and s is a scaling factor, usually less than
  or equal to 1, chosen so that the components of x will be less than
  the overflow threshold.  If the unscaled problem will not cause
  overflow, the Level 2 BLAS routine DTBSV is called.  If the matrix A

  is singular (A(j,j) = 0 for some j), then s is set to 0 and a
  non-trivial solution to A*x = 0 is returned.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the matrix A is upper or lower triangular.

          = 'U':  Upper triangular
          = 'L':  Lower triangular

  TRANS   (input) CHARACTER*1
          Specifies the operation applied to A.
          = 'N':  Solve A * x = s*b  (No transpose)
          = 'T':  Solve A'* x = s*b  (Transpose)
          = 'C':  Solve A'* x = s*b  (Conjugate transpose = Transpose)


  DIAG    (input) CHARACTER*1
          Specifies whether or not the matrix A is unit triangular.
          = 'N':  Non-unit triangular
          = 'U':  Unit triangular

  NORMIN  (input) CHARACTER*1
          Specifies whether CNORM has been set or not.
          = 'Y':  CNORM contains the column norms on entry
          = 'N':  CNORM is not set on entry.  On exit, the norms will
                  be computed and stored in CNORM.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of subdiagonals or superdiagonals in the
          triangular matrix A.  KD >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The upper or lower triangular band matrix A, stored in the
          first KD+1 rows of the array. The j-th column of A is stored

          in the j-th column of the array AB as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  X       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the right hand side b of the triangular system.
          On exit, X is overwritten by the solution vector x.

  SCALE   (output) DOUBLE PRECISION
          The scaling factor s for the triangular system
             A * x = s*b  or  A'* x = s*b.
          If SCALE = 0, the matrix A is singular or badly scaled, and
          the vector x is an exact or approximate solution to A*x = 0.


  CNORM   (input or output) DOUBLE PRECISION array, dimension (N)

          If NORMIN = 'Y', CNORM is an input argument and CNORM(j)
          contains the norm of the off-diagonal part of the j-th column
          of A.  If TRANS = 'N', CNORM(j) must be greater than or equal
          to the infinity-norm, and if TRANS = 'T' or 'C', CNORM(j)
          must be greater than or equal to the 1-norm.

          If NORMIN = 'N', CNORM is an output argument and CNORM(j)
          returns the 1-norm of the offdiagonal part of the j-th column
          of A.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -k, the k-th argument had an illegal value

  Further Details
  ======= =======

  A rough bound on x is computed; if that is less than overflow, DTBSV

  is called, otherwise, specific code is used which checks for possible
  overflow or divide-by-zero at every operation.

  A columnwise scheme is used for solving A*x = b.  The basic algorithm
  if A is lower triangular is

       x[1:n] := b[1:n]
       for j = 1, ..., n
            x(j) := x(j) / A(j,j)
            x[j+1:n] := x[j+1:n] - x(j) * A[j+1:n,j]
       end

  Define bounds on the components of x after j iterations of the loop:

     M(j) = bound on x[1:j]
     G(j) = bound on x[j+1:n]
  Initially, let M(0) = 0 and G(0) = max{x(i), i=1,...,n}.

  Then for iteration j+1 we have
     M(j+1) <= G(j) / | A(j+1,j+1) |
     G(j+1) <= G(j) + M(j+1) * | A[j+2:n,j+1] |
            <= G(j) ( 1 + CNORM(j+1) / | A(j+1,j+1) | )

  where CNORM(j+1) is greater than or equal to the infinity-norm of
  column j+1 of A, not counting the diagonal.  Hence

     G(j) <= G(0) product ( 1 + CNORM(i) / | A(i,i) | )
                  1<=i<=j
  and

     |x(j)| <= ( G(0) / |A(j,j)| ) product ( 1 + CNORM(i) / |A(i,i)| )

                                   1<=i< j

  Since |x(j)| <= M(j), we use the Level 2 BLAS routine DTBSV if the
  reciprocal of the largest M(j), j=1,..,n, is larger than
  max(underflow, 1/overflow).

  The bound on x(j) is also used to determine when a step in the
  columnwise method can be performed without fear of overflow.  If
  the computed bound is greater than a large constant, x is scaled to
  prevent overflow, but if the bound overflows, x is set to 0, x(j) to

  1, and scale to 0, and a non-trivial solution to A*x = 0 is found.

  Similarly, a row-wise scheme is used to solve A'*x = b.  The basic
  algorithm for A upper triangular is

       for j = 1, ..., n
            x(j) := ( b(j) - A[1:j-1,j]' * x[1:j-1] ) / A(j,j)
       end

  We simultaneously compute two bounds
       G(j) = bound on ( b(i) - A[1:i-1,i]' * x[1:i-1] ), 1<=i<=j
       M(j) = bound on x(i), 1<=i<=j

  The initial values are G(0) = 0, M(0) = max{b(i), i=1,..,n}, and we
  add the constraint G(j) >= G(j-1) and M(j) >= M(j-1) for j >= 1.
  Then the bound on x(j) is

       M(j) <= M(j-1) * ( 1 + CNORM(j) ) / | A(j,j) |

            <= M(0) * product ( ( 1 + CNORM(i) ) / |A(i,i)| )
                      1<=i<=j

  and we can safely call DTBSV if 1/M(n) and 1/G(n) are both greater
  than max(underflow, 1/overflow).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param trans
	 * @param diag
	 * @param normin
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param x
	 * @param scale
	 * @param cnorm
	 * @param info
	 */
	public abstract void dlatbs(String uplo, String trans, String diag, String normin, int n, int kd, double[] ab, int ldab, double[] x, doubleW scale, double[] cnorm, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLATDF uses the LU factorization of the n-by-n matrix Z computed by
  DGETC2 and computes a contribution to the reciprocal Dif-estimate
  by solving Z * x = b for x, and choosing the r.h.s. b such that
  the norm of x is as large as possible. On entry RHS = b holds the
  contribution from earlier solved sub-systems, and on return RHS = x.


  The factorization of Z returned by DGETC2 has the form Z = P*L*U*Q,
  where P and Q are permutation matrices. L is lower triangular with
  unit diagonal elements and U is upper triangular.

  Arguments
  =========

  IJOB    (input) INTEGER
          IJOB = 2: First compute an approximative null-vector e
              of Z using DGECON, e is normalized and solve for
              Zx = +-e - f with the sign giving the greater value
              of 2-norm(x). About 5 times as expensive as Default.
          IJOB .ne. 2: Local look ahead strategy where all entries of
              the r.h.s. b is choosen as either +1 or -1 (Default).

  N       (input) INTEGER
          The number of columns of the matrix Z.

  Z       (input) DOUBLE PRECISION array, dimension (LDZ, N)
          On entry, the LU part of the factorization of the n-by-n
          matrix Z computed by DGETC2:  Z = P * L * U * Q

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDA >= max(1, N).

  RHS     (input/output) DOUBLE PRECISION array, dimension N.
          On entry, RHS contains contributions from other subsystems.
          On exit, RHS contains the solution of the subsystem with
          entries acoording to the value of IJOB (see above).

  RDSUM   (input/output) DOUBLE PRECISION
          On entry, the sum of squares of computed contributions to
          the Dif-estimate under computation by DTGSYL, where the
          scaling factor RDSCAL (see below) has been factored out.
          On exit, the corresponding sum of squares updated with the
          contributions from the current sub-system.
          If TRANS = 'T' RDSUM is not touched.
          NOTE: RDSUM only makes sense when DTGSY2 is called by STGSYL.

  RDSCAL  (input/output) DOUBLE PRECISION
          On entry, scaling factor used to prevent overflow in RDSUM.
          On exit, RDSCAL is updated w.r.t. the current contributions
          in RDSUM.
          If TRANS = 'T', RDSCAL is not touched.
          NOTE: RDSCAL only makes sense when DTGSY2 is called by
                DTGSYL.

  IPIV    (input) INTEGER array, dimension (N).
          The pivot indices; for 1 <= i <= N, row i of the
          matrix has been interchanged with row IPIV(i).

  JPIV    (input) INTEGER array, dimension (N).
          The pivot indices; for 1 <= j <= N, column j of the
          matrix has been interchanged with column JPIV(j).

  Further Details
  ===============

  Based on contributions by
     Bo Kagstrom and Peter Poromaa, Department of Computing Science,
     Umea University, S-901 87 Umea, Sweden.

  This routine is a further developed implementation of algorithm
  BSOLVE in [1] using complete pivoting in the LU factorization.

  [1] Bo Kagstrom and Lars Westin,
      Generalized Schur Methods with Condition Estimators for
      Solving the Generalized Sylvester Equation, IEEE Transactions
      on Automatic Control, Vol. 34, No. 7, July 1989, pp 745-751.

  [2] Peter Poromaa,
      On Efficient and Robust Estimators for the Separation
      between two Regular Matrix Pairs with Applications in
      Condition Estimation. Report IMINF-95.05, Departement of
      Computing Science, Umea University, S-901 87 Umea, Sweden, 1995.


  =====================================================================

     .. Parameters ..
</pre>
	 * @param ijob
	 * @param n
	 * @param z
	 * @param ldz
	 * @param rhs
	 * @param rdsum
	 * @param rdscal
	 * @param ipiv
	 * @param jpiv
	 */
	public abstract void dlatdf(int ijob, int n, double[] z, int ldz, double[] rhs, doubleW rdsum, doubleW rdscal, int[] ipiv, int[] jpiv);

	/**
<pre>

     ..

  Purpose
  =======

  DLATPS solves one of the triangular systems

     A *x = s*b  or  A'*x = s*b

  with scaling to prevent overflow, where A is an upper or lower
  triangular matrix stored in packed form.  Here A' denotes the
  transpose of A, x and b are n-element vectors, and s is a scaling
  factor, usually less than or equal to 1, chosen so that the
  components of x will be less than the overflow threshold.  If the
  unscaled problem will not cause overflow, the Level 2 BLAS routine
  DTPSV is called. If the matrix A is singular (A(j,j) = 0 for some j),
  then s is set to 0 and a non-trivial solution to A*x = 0 is returned.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the matrix A is upper or lower triangular.

          = 'U':  Upper triangular
          = 'L':  Lower triangular

  TRANS   (input) CHARACTER*1
          Specifies the operation applied to A.
          = 'N':  Solve A * x = s*b  (No transpose)
          = 'T':  Solve A'* x = s*b  (Transpose)
          = 'C':  Solve A'* x = s*b  (Conjugate transpose = Transpose)


  DIAG    (input) CHARACTER*1
          Specifies whether or not the matrix A is unit triangular.
          = 'N':  Non-unit triangular
          = 'U':  Unit triangular

  NORMIN  (input) CHARACTER*1
          Specifies whether CNORM has been set or not.
          = 'Y':  CNORM contains the column norms on entry
          = 'N':  CNORM is not set on entry.  On exit, the norms will
                  be computed and stored in CNORM.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The upper or lower triangular matrix A, packed columnwise in

          a linear array.  The j-th column of A is stored in the array

          AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.

  X       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the right hand side b of the triangular system.
          On exit, X is overwritten by the solution vector x.

  SCALE   (output) DOUBLE PRECISION
          The scaling factor s for the triangular system
             A * x = s*b  or  A'* x = s*b.
          If SCALE = 0, the matrix A is singular or badly scaled, and
          the vector x is an exact or approximate solution to A*x = 0.


  CNORM   (input or output) DOUBLE PRECISION array, dimension (N)

          If NORMIN = 'Y', CNORM is an input argument and CNORM(j)
          contains the norm of the off-diagonal part of the j-th column
          of A.  If TRANS = 'N', CNORM(j) must be greater than or equal
          to the infinity-norm, and if TRANS = 'T' or 'C', CNORM(j)
          must be greater than or equal to the 1-norm.

          If NORMIN = 'N', CNORM is an output argument and CNORM(j)
          returns the 1-norm of the offdiagonal part of the j-th column
          of A.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -k, the k-th argument had an illegal value

  Further Details
  ======= =======

  A rough bound on x is computed; if that is less than overflow, DTPSV

  is called, otherwise, specific code is used which checks for possible
  overflow or divide-by-zero at every operation.

  A columnwise scheme is used for solving A*x = b.  The basic algorithm
  if A is lower triangular is

       x[1:n] := b[1:n]
       for j = 1, ..., n
            x(j) := x(j) / A(j,j)
            x[j+1:n] := x[j+1:n] - x(j) * A[j+1:n,j]
       end

  Define bounds on the components of x after j iterations of the loop:

     M(j) = bound on x[1:j]
     G(j) = bound on x[j+1:n]
  Initially, let M(0) = 0 and G(0) = max{x(i), i=1,...,n}.

  Then for iteration j+1 we have
     M(j+1) <= G(j) / | A(j+1,j+1) |
     G(j+1) <= G(j) + M(j+1) * | A[j+2:n,j+1] |
            <= G(j) ( 1 + CNORM(j+1) / | A(j+1,j+1) | )

  where CNORM(j+1) is greater than or equal to the infinity-norm of
  column j+1 of A, not counting the diagonal.  Hence

     G(j) <= G(0) product ( 1 + CNORM(i) / | A(i,i) | )
                  1<=i<=j
  and

     |x(j)| <= ( G(0) / |A(j,j)| ) product ( 1 + CNORM(i) / |A(i,i)| )

                                   1<=i< j

  Since |x(j)| <= M(j), we use the Level 2 BLAS routine DTPSV if the
  reciprocal of the largest M(j), j=1,..,n, is larger than
  max(underflow, 1/overflow).

  The bound on x(j) is also used to determine when a step in the
  columnwise method can be performed without fear of overflow.  If
  the computed bound is greater than a large constant, x is scaled to
  prevent overflow, but if the bound overflows, x is set to 0, x(j) to

  1, and scale to 0, and a non-trivial solution to A*x = 0 is found.

  Similarly, a row-wise scheme is used to solve A'*x = b.  The basic
  algorithm for A upper triangular is

       for j = 1, ..., n
            x(j) := ( b(j) - A[1:j-1,j]' * x[1:j-1] ) / A(j,j)
       end

  We simultaneously compute two bounds
       G(j) = bound on ( b(i) - A[1:i-1,i]' * x[1:i-1] ), 1<=i<=j
       M(j) = bound on x(i), 1<=i<=j

  The initial values are G(0) = 0, M(0) = max{b(i), i=1,..,n}, and we
  add the constraint G(j) >= G(j-1) and M(j) >= M(j-1) for j >= 1.
  Then the bound on x(j) is

       M(j) <= M(j-1) * ( 1 + CNORM(j) ) / | A(j,j) |

            <= M(0) * product ( ( 1 + CNORM(i) ) / |A(i,i)| )
                      1<=i<=j

  and we can safely call DTPSV if 1/M(n) and 1/G(n) are both greater
  than max(underflow, 1/overflow).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param trans
	 * @param diag
	 * @param normin
	 * @param n
	 * @param ap
	 * @param x
	 * @param scale
	 * @param cnorm
	 * @param info
	 */
	public abstract void dlatps(String uplo, String trans, String diag, String normin, int n, double[] ap, double[] x, doubleW scale, double[] cnorm, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLATRD reduces NB rows and columns of a real symmetric matrix A to
  symmetric tridiagonal form by an orthogonal similarity
  transformation Q' * A * Q, and returns the matrices V and W which are
  needed to apply the transformation to the unreduced part of A.

  If UPLO = 'U', DLATRD reduces the last NB rows and columns of a
  matrix, of which the upper triangle is supplied;
  if UPLO = 'L', DLATRD reduces the first NB rows and columns of a
  matrix, of which the lower triangle is supplied.

  This is an auxiliary routine called by DSYTRD.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored:
          = 'U': Upper triangular
          = 'L': Lower triangular

  N       (input) INTEGER
          The order of the matrix A.

  NB      (input) INTEGER
          The number of rows and columns to be reduced.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A.  If UPLO = 'U', the leading
          n-by-n upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading n-by-n lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.
          On exit:
          if UPLO = 'U', the last NB columns have been reduced to
            tridiagonal form, with the diagonal elements overwriting
            the diagonal elements of A; the elements above the diagonal
            with the array TAU, represent the orthogonal matrix Q as a

            product of elementary reflectors;
          if UPLO = 'L', the first NB columns have been reduced to
            tridiagonal form, with the diagonal elements overwriting
            the diagonal elements of A; the elements below the diagonal
            with the array TAU, represent the  orthogonal matrix Q as a
            product of elementary reflectors.
          See Further Details.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= (1,N).

  E       (output) DOUBLE PRECISION array, dimension (N-1)
          If UPLO = 'U', E(n-nb:n-1) contains the superdiagonal
          elements of the last NB columns of the reduced matrix;
          if UPLO = 'L', E(1:nb) contains the subdiagonal elements of
          the first NB columns of the reduced matrix.

  TAU     (output) DOUBLE PRECISION array, dimension (N-1)
          The scalar factors of the elementary reflectors, stored in
          TAU(n-nb:n-1) if UPLO = 'U', and in TAU(1:nb) if UPLO = 'L'.

          See Further Details.

  W       (output) DOUBLE PRECISION array, dimension (LDW,NB)
          The n-by-nb matrix W required to update the unreduced part
          of A.

  LDW     (input) INTEGER
          The leading dimension of the array W. LDW >= max(1,N).

  Further Details
  ===============

  If UPLO = 'U', the matrix Q is represented as a product of elementary
  reflectors

     Q = H(n) H(n-1) . . . H(n-nb+1).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(i:n) = 0 and v(i-1) = 1; v(1:i-1) is stored on exit in A(1:i-1,i),

  and tau in TAU(i-1).

  If UPLO = 'L', the matrix Q is represented as a product of elementary
  reflectors

     Q = H(1) H(2) . . . H(nb).

  Each H(i) has the form

     H(i) = I - tau * v * v'

  where tau is a real scalar, and v is a real vector with
  v(1:i) = 0 and v(i+1) = 1; v(i+1:n) is stored on exit in A(i+1:n,i),

  and tau in TAU(i).

  The elements of the vectors v together form the n-by-nb matrix V
  which is needed, with W, to apply the transformation to the unreduced
  part of the matrix, using a symmetric rank-2k update of the form:
  A := A - V*W' - W*V'.

  The contents of A on exit are illustrated by the following examples
  with n = 5 and nb = 2:

  if UPLO = 'U':                       if UPLO = 'L':

    (  a   a   a   v4  v5 )              (  d                  )
    (      a   a   v4  v5 )              (  1   d              )
    (          a   1   v5 )              (  v1  1   a          )
    (              d   1  )              (  v1  v2  a   a      )
    (                  d  )              (  v1  v2  a   a   a  )

  where d denotes a diagonal element of the reduced matrix, a denotes
  an element of the original matrix that is unchanged, and vi denotes
  an element of the vector defining H(i).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nb
	 * @param a
	 * @param lda
	 * @param e
	 * @param tau
	 * @param w
	 * @param ldw
	 */
	public abstract void dlatrd(String uplo, int n, int nb, double[] a, int lda, double[] e, double[] tau, double[] w, int ldw);

	/**
<pre>

     ..

  Purpose
  =======

  DLATRS solves one of the triangular systems

     A *x = s*b  or  A'*x = s*b

  with scaling to prevent overflow.  Here A is an upper or lower
  triangular matrix, A' denotes the transpose of A, x and b are
  n-element vectors, and s is a scaling factor, usually less than
  or equal to 1, chosen so that the components of x will be less than
  the overflow threshold.  If the unscaled problem will not cause
  overflow, the Level 2 BLAS routine DTRSV is called.  If the matrix A

  is singular (A(j,j) = 0 for some j), then s is set to 0 and a
  non-trivial solution to A*x = 0 is returned.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the matrix A is upper or lower triangular.

          = 'U':  Upper triangular
          = 'L':  Lower triangular

  TRANS   (input) CHARACTER*1
          Specifies the operation applied to A.
          = 'N':  Solve A * x = s*b  (No transpose)
          = 'T':  Solve A'* x = s*b  (Transpose)
          = 'C':  Solve A'* x = s*b  (Conjugate transpose = Transpose)


  DIAG    (input) CHARACTER*1
          Specifies whether or not the matrix A is unit triangular.
          = 'N':  Non-unit triangular
          = 'U':  Unit triangular

  NORMIN  (input) CHARACTER*1
          Specifies whether CNORM has been set or not.
          = 'Y':  CNORM contains the column norms on entry
          = 'N':  CNORM is not set on entry.  On exit, the norms will
                  be computed and stored in CNORM.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The triangular matrix A.  If UPLO = 'U', the leading n by n
          upper triangular part of the array A contains the upper
          triangular matrix, and the strictly lower triangular part of

          A is not referenced.  If UPLO = 'L', the leading n by n lower
          triangular part of the array A contains the lower triangular

          matrix, and the strictly upper triangular part of A is not
          referenced.  If DIAG = 'U', the diagonal elements of A are
          also not referenced and are assumed to be 1.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max (1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the right hand side b of the triangular system.
          On exit, X is overwritten by the solution vector x.

  SCALE   (output) DOUBLE PRECISION
          The scaling factor s for the triangular system
             A * x = s*b  or  A'* x = s*b.
          If SCALE = 0, the matrix A is singular or badly scaled, and
          the vector x is an exact or approximate solution to A*x = 0.


  CNORM   (input or output) DOUBLE PRECISION array, dimension (N)

          If NORMIN = 'Y', CNORM is an input argument and CNORM(j)
          contains the norm of the off-diagonal part of the j-th column
          of A.  If TRANS = 'N', CNORM(j) must be greater than or equal
          to the infinity-norm, and if TRANS = 'T' or 'C', CNORM(j)
          must be greater than or equal to the 1-norm.

          If NORMIN = 'N', CNORM is an output argument and CNORM(j)
          returns the 1-norm of the offdiagonal part of the j-th column
          of A.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -k, the k-th argument had an illegal value

  Further Details
  ======= =======

  A rough bound on x is computed; if that is less than overflow, DTRSV

  is called, otherwise, specific code is used which checks for possible
  overflow or divide-by-zero at every operation.

  A columnwise scheme is used for solving A*x = b.  The basic algorithm
  if A is lower triangular is

       x[1:n] := b[1:n]
       for j = 1, ..., n
            x(j) := x(j) / A(j,j)
            x[j+1:n] := x[j+1:n] - x(j) * A[j+1:n,j]
       end

  Define bounds on the components of x after j iterations of the loop:

     M(j) = bound on x[1:j]
     G(j) = bound on x[j+1:n]
  Initially, let M(0) = 0 and G(0) = max{x(i), i=1,...,n}.

  Then for iteration j+1 we have
     M(j+1) <= G(j) / | A(j+1,j+1) |
     G(j+1) <= G(j) + M(j+1) * | A[j+2:n,j+1] |
            <= G(j) ( 1 + CNORM(j+1) / | A(j+1,j+1) | )

  where CNORM(j+1) is greater than or equal to the infinity-norm of
  column j+1 of A, not counting the diagonal.  Hence

     G(j) <= G(0) product ( 1 + CNORM(i) / | A(i,i) | )
                  1<=i<=j
  and

     |x(j)| <= ( G(0) / |A(j,j)| ) product ( 1 + CNORM(i) / |A(i,i)| )

                                   1<=i< j

  Since |x(j)| <= M(j), we use the Level 2 BLAS routine DTRSV if the
  reciprocal of the largest M(j), j=1,..,n, is larger than
  max(underflow, 1/overflow).

  The bound on x(j) is also used to determine when a step in the
  columnwise method can be performed without fear of overflow.  If
  the computed bound is greater than a large constant, x is scaled to
  prevent overflow, but if the bound overflows, x is set to 0, x(j) to

  1, and scale to 0, and a non-trivial solution to A*x = 0 is found.

  Similarly, a row-wise scheme is used to solve A'*x = b.  The basic
  algorithm for A upper triangular is

       for j = 1, ..., n
            x(j) := ( b(j) - A[1:j-1,j]' * x[1:j-1] ) / A(j,j)
       end

  We simultaneously compute two bounds
       G(j) = bound on ( b(i) - A[1:i-1,i]' * x[1:i-1] ), 1<=i<=j
       M(j) = bound on x(i), 1<=i<=j

  The initial values are G(0) = 0, M(0) = max{b(i), i=1,..,n}, and we
  add the constraint G(j) >= G(j-1) and M(j) >= M(j-1) for j >= 1.
  Then the bound on x(j) is

       M(j) <= M(j-1) * ( 1 + CNORM(j) ) / | A(j,j) |

            <= M(0) * product ( ( 1 + CNORM(i) ) / |A(i,i)| )
                      1<=i<=j

  and we can safely call DTRSV if 1/M(n) and 1/G(n) are both greater
  than max(underflow, 1/overflow).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param trans
	 * @param diag
	 * @param normin
	 * @param n
	 * @param a
	 * @param lda
	 * @param x
	 * @param scale
	 * @param cnorm
	 * @param info
	 */
	public abstract void dlatrs(String uplo, String trans, String diag, String normin, int n, double[] a, int lda, double[] x, doubleW scale, double[] cnorm, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLATRZ factors the M-by-(M+L) real upper trapezoidal matrix
  [ A1 A2 ] = [ A(1:M,1:M) A(1:M,N-L+1:N) ] as ( R  0 ) * Z, by means
  of orthogonal transformations.  Z is an (M+L)-by-(M+L) orthogonal
  matrix and, R and A1 are M-by-M upper triangular matrices.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix A.  M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix A.  N >= 0.

  L       (input) INTEGER
          The number of columns of the matrix A containing the
          meaningful part of the Householder vectors. N-M >= L >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the leading M-by-N upper trapezoidal part of the
          array A must contain the matrix to be factorized.
          On exit, the leading M-by-M upper triangular part of A
          contains the upper triangular matrix R, and elements N-L+1 to
          N of the first M rows of A, with the array TAU, represent the
          orthogonal matrix Z as a product of M elementary reflectors.


  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,M).

  TAU     (output) DOUBLE PRECISION array, dimension (M)
          The scalar factors of the elementary reflectors.

  WORK    (workspace) DOUBLE PRECISION array, dimension (M)

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA


  The factorization is obtained by Householder's method.  The kth
  transformation matrix, Z( k ), which is used to introduce zeros into

  the ( m - k + 1 )th row of A, is given in the form

     Z( k ) = ( I     0   ),
              ( 0  T( k ) )

  where

     T( k ) = I - tau*u( k )*u( k )',   u( k ) = (   1    ),
                                                 (   0    )
                                                 ( z( k ) )

  tau is a scalar and z( k ) is an l element vector. tau and z( k )
  are chosen to annihilate the elements of the kth row of A2.

  The scalar tau is returned in the kth element of TAU and the vector
  u( k ) in the kth row of A2, such that the elements of z( k ) are
  in  a( k, l + 1 ), ..., a( k, n ). The elements of R are returned in

  the upper triangular part of A1.

  Z is given by

     Z =  Z( 1 ) * Z( 2 ) * ... * Z( m ).

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param l
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 */
	public abstract void dlatrz(int m, int n, int l, double[] a, int lda, double[] tau, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  This routine is deprecated and has been replaced by routine DORMRZ.

  DLATZM applies a Householder matrix generated by DTZRQF to a matrix.


  Let P = I - tau*u*u',   u = ( 1 ),
                              ( v )
  where v is an (m-1) vector if SIDE = 'L', or a (n-1) vector if
  SIDE = 'R'.

  If SIDE equals 'L', let
         C = [ C1 ] 1
             [ C2 ] m-1
               n
  Then C is overwritten by P*C.

  If SIDE equals 'R', let
         C = [ C1, C2 ] m
                1  n-1
  Then C is overwritten by C*P.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': form P * C
          = 'R': form C * P

  M       (input) INTEGER
          The number of rows of the matrix C.

  N       (input) INTEGER
          The number of columns of the matrix C.

  V       (input) DOUBLE PRECISION array, dimension
                  (1 + (M-1)*abs(INCV)) if SIDE = 'L'
                  (1 + (N-1)*abs(INCV)) if SIDE = 'R'
          The vector v in the representation of P. V is not used
          if TAU = 0.

  INCV    (input) INTEGER
          The increment between elements of v. INCV <> 0

  TAU     (input) DOUBLE PRECISION
          The value tau in the representation of P.

  C1      (input/output) DOUBLE PRECISION array, dimension
                         (LDC,N) if SIDE = 'L'
                         (M,1)   if SIDE = 'R'
          On entry, the n-vector C1 if SIDE = 'L', or the m-vector C1
          if SIDE = 'R'.

          On exit, the first row of P*C if SIDE = 'L', or the first
          column of C*P if SIDE = 'R'.

  C2      (input/output) DOUBLE PRECISION array, dimension
                         (LDC, N)   if SIDE = 'L'
                         (LDC, N-1) if SIDE = 'R'
          On entry, the (m - 1) x n matrix C2 if SIDE = 'L', or the
          m x (n - 1) matrix C2 if SIDE = 'R'.

          On exit, rows 2:m of P*C if SIDE = 'L', or columns 2:m of C*P
          if SIDE = 'R'.

  LDC     (input) INTEGER
          The leading dimension of the arrays C1 and C2. LDC >= (1,M).


  WORK    (workspace) DOUBLE PRECISION array, dimension
                      (N) if SIDE = 'L'
                      (M) if SIDE = 'R'

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param m
	 * @param n
	 * @param v
	 * @param incv
	 * @param tau
	 * @param c1
	 * @param c2
	 * @param Ldc
	 * @param work
	 */
	public abstract void dlatzm(String side, int m, int n, double[] v, int incv, double tau, double[] c1, double[] c2, int Ldc, double[] work);

	/**
<pre>

     ..

  Purpose
  =======

  DLAUU2 computes the product U * U' or L' * L, where the triangular
  factor U or L is stored in the upper or lower triangular part of
  the array A.

  If UPLO = 'U' or 'u' then the upper triangle of the result is stored,
  overwriting the factor U in A.
  If UPLO = 'L' or 'l' then the lower triangle of the result is stored,
  overwriting the factor L in A.

  This is the unblocked form of the algorithm, calling Level 2 BLAS.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the triangular factor stored in the array A
          is upper or lower triangular:
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the triangular factor U or L.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the triangular factor U or L.
          On exit, if UPLO = 'U', the upper triangle of A is
          overwritten with the upper triangle of the product U * U';
          if UPLO = 'L', the lower triangle of A is overwritten with
          the lower triangle of the product L' * L.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param info
	 */
	public abstract void dlauu2(String uplo, int n, double[] a, int lda, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DLAUUM computes the product U * U' or L' * L, where the triangular
  factor U or L is stored in the upper or lower triangular part of
  the array A.

  If UPLO = 'U' or 'u' then the upper triangle of the result is stored,
  overwriting the factor U in A.
  If UPLO = 'L' or 'l' then the lower triangle of the result is stored,
  overwriting the factor L in A.

  This is the blocked form of the algorithm, calling Level 3 BLAS.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the triangular factor stored in the array A
          is upper or lower triangular:
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the triangular factor U or L.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the triangular factor U or L.
          On exit, if UPLO = 'U', the upper triangle of A is
          overwritten with the upper triangle of the product U * U';
          if UPLO = 'L', the lower triangle of A is overwritten with
          the lower triangle of the product L' * L.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param info
	 */
	public abstract void dlauum(String uplo, int n, double[] a, int lda, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DLAZQ3 checks for deflation, computes a shift (TAU) and calls dqds.
  In case of failure it changes shifts, and tries again until output
  is positive.

  Arguments
  =========

  I0     (input) INTEGER
         First index.

  N0     (input) INTEGER
         Last index.

  Z      (input) DOUBLE PRECISION array, dimension ( 4*N )
         Z holds the qd array.

  PP     (input) INTEGER
         PP=0 for ping, PP=1 for pong.

  DMIN   (output) DOUBLE PRECISION
         Minimum value of d.

  SIGMA  (output) DOUBLE PRECISION
         Sum of shifts used in current segment.

  DESIG  (input/output) DOUBLE PRECISION
         Lower order part of SIGMA

  QMAX   (input) DOUBLE PRECISION
         Maximum value of q.

  NFAIL  (output) INTEGER
         Number of times shift was too big.

  ITER   (output) INTEGER
         Number of iterations.

  NDIV   (output) INTEGER
         Number of divisions.

  IEEE   (input) LOGICAL
         Flag for IEEE or non IEEE arithmetic (passed to DLASQ5).

  TTYPE  (input/output) INTEGER
         Shift type.  TTYPE is passed as an argument in order to save
         its value between calls to DLAZQ3

  DMIN1  (input/output) REAL
  DMIN2  (input/output) REAL
  DN     (input/output) REAL
  DN1    (input/output) REAL
  DN2    (input/output) REAL
  TAU    (input/output) REAL
         These are passed as arguments in order to save their values
         between calls to DLAZQ3

  This is a thread safe version of DLASQ3, which passes TTYPE, DMIN1,
  DMIN2, DN, DN1. DN2 and TAU through the argument list in place of
  declaring them in a SAVE statment.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param i0
	 * @param n0
	 * @param z
	 * @param pp
	 * @param dmin
	 * @param sigma
	 * @param desig
	 * @param qmax
	 * @param nfail
	 * @param iter
	 * @param ndiv
	 * @param ieee
	 * @param ttype
	 * @param dmin1
	 * @param dmin2
	 * @param dn
	 * @param dn1
	 * @param dn2
	 * @param tau
	 */
	public void dlazq3(int i0, intW n0, double[] z, int pp, doubleW dmin, doubleW sigma, doubleW desig, doubleW qmax, intW nfail, intW iter, intW ndiv, boolean ieee, intW ttype, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dn1, doubleW dn2, doubleW tau) {
		org.netlib.lapack.Dlazq3.dlazq3(i0, n0, z, 0, pp, dmin, sigma, desig, qmax, nfail, iter, ndiv, ieee, ttype, dmin1, dmin2, dn, dn1, dn2, tau);
	}

		/**
<pre>

     ..

  Purpose
  =======

  DLAZQ4 computes an approximation TAU to the smallest eigenvalue 
  using values of d from the previous transform.

  I0    (input) INTEGER
        First index.

  N0    (input) INTEGER
        Last index.

  Z     (input) DOUBLE PRECISION array, dimension ( 4*N )
        Z holds the qd array.

  PP    (input) INTEGER
        PP=0 for ping, PP=1 for pong.

  N0IN  (input) INTEGER
        The value of N0 at start of EIGTEST.

  DMIN  (input) DOUBLE PRECISION
        Minimum value of d.

  DMIN1 (input) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ).

  DMIN2 (input) DOUBLE PRECISION
        Minimum value of d, excluding D( N0 ) and D( N0-1 ).

  DN    (input) DOUBLE PRECISION
        d(N)

  DN1   (input) DOUBLE PRECISION
        d(N-1)

  DN2   (input) DOUBLE PRECISION
        d(N-2)

  TAU   (output) DOUBLE PRECISION
        This is the shift.

  TTYPE (output) INTEGER
        Shift type.

  G     (input/output) DOUBLE PRECISION
        G is passed as an argument in order to save its value between
        calls to DLAZQ4

  Further Details
  ===============
  CNST1 = 9/16

  This is a thread safe version of DLASQ4, which passes G through the
  argument list in place of declaring G in a SAVE statment.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param i0
	 * @param n0
	 * @param z
	 * @param pp
	 * @param n0in
	 * @param dmin
	 * @param dmin1
	 * @param dmin2
	 * @param dn
	 * @param dn1
	 * @param dn2
	 * @param tau
	 * @param ttype
	 * @param g
	 */
	public void dlazq4(int i0, int n0, double[] z, int pp, int n0in, double dmin, double dmin1, double dmin2, double dn, double dn1, double dn2, doubleW tau, intW ttype, doubleW g) {
		org.netlib.lapack.Dlazq4.dlazq4(i0, n0, z, 0, pp, n0in, dmin, dmin1, dmin2, dn, dn1, dn2, tau, ttype, g);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DOPGTR generates a real orthogonal matrix Q which is defined as the
  product of n-1 elementary reflectors H(i) of order n, as returned by

  DSPTRD using packed storage:

  if UPLO = 'U', Q = H(n-1) . . . H(2) H(1),

  if UPLO = 'L', Q = H(1) H(2) . . . H(n-1).

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U': Upper triangular packed storage used in previous
                 call to DSPTRD;
          = 'L': Lower triangular packed storage used in previous
                 call to DSPTRD.

  N       (input) INTEGER
          The order of the matrix Q. N >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The vectors which define the elementary reflectors, as
          returned by DSPTRD.

  TAU     (input) DOUBLE PRECISION array, dimension (N-1)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DSPTRD.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ,N)
          The N-by-N orthogonal matrix Q.

  LDQ     (input) INTEGER
          The leading dimension of the array Q. LDQ >= max(1,N).

  WORK    (workspace) DOUBLE PRECISION array, dimension (N-1)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param tau
	 * @param q
	 * @param ldq
	 * @param work
	 * @param info
	 */
	public abstract void dopgtr(String uplo, int n, double[] ap, double[] tau, double[] q, int ldq, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DOPMTR overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix of order nq, with nq = m if
  SIDE = 'L' and nq = n if SIDE = 'R'. Q is defined as the product of
  nq-1 elementary reflectors, as returned by DSPTRD using packed
  storage:

  if UPLO = 'U', Q = H(nq-1) . . . H(2) H(1);

  if UPLO = 'L', Q = H(1) H(2) . . . H(nq-1).

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  UPLO    (input) CHARACTER*1
          = 'U': Upper triangular packed storage used in previous
                 call to DSPTRD;
          = 'L': Lower triangular packed storage used in previous
                 call to DSPTRD.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  AP      (input) DOUBLE PRECISION array, dimension
                               (M*(M+1)/2) if SIDE = 'L'
                               (N*(N+1)/2) if SIDE = 'R'
          The vectors which define the elementary reflectors, as
          returned by DSPTRD.  AP is modified by the routine but
          restored on exit.

  TAU     (input) DOUBLE PRECISION array, dimension (M-1) if SIDE = 'L'
                                     or (N-1) if SIDE = 'R'
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DSPTRD.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                                   (N) if SIDE = 'L'
                                   (M) if SIDE = 'R'

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param uplo
	 * @param trans
	 * @param m
	 * @param n
	 * @param ap
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dopmtr(String side, String uplo, String trans, int m, int n, double[] ap, double[] tau, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORG2L generates an m by n real matrix Q with orthonormal columns,
  which is defined as the last n columns of a product of k elementary
  reflectors of order m

        Q  =  H(k) . . . H(2) H(1)

  as returned by DGEQLF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. M >= N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. N >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the (n-k+i)-th column must contain the vector which
          defines the elementary reflector H(i), for i = 1,2,...,k, as

          returned by DGEQLF in the last k columns of its array
          argument A.
          On exit, the m by n matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQLF.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dorg2l(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORG2R generates an m by n real matrix Q with orthonormal columns,
  which is defined as the first n columns of a product of k elementary

  reflectors of order m

        Q  =  H(1) H(2) . . . H(k)

  as returned by DGEQRF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. M >= N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. N >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the i-th column must contain the vector which
          defines the elementary reflector H(i), for i = 1,2,...,k, as

          returned by DGEQRF in the first k columns of its array
          argument A.
          On exit, the m-by-n matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQRF.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dorg2r(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGBR generates one of the real orthogonal matrices Q or P**T
  determined by DGEBRD when reducing a real matrix A to bidiagonal
  form: A = Q * B * P**T.  Q and P**T are defined as products of
  elementary reflectors H(i) or G(i) respectively.

  If VECT = 'Q', A is assumed to have been an M-by-K matrix, and Q
  is of order M:
  if m >= k, Q = H(1) H(2) . . . H(k) and DORGBR returns the first n
  columns of Q, where m >= n >= k;
  if m < k, Q = H(1) H(2) . . . H(m-1) and DORGBR returns Q as an
  M-by-M matrix.

  If VECT = 'P', A is assumed to have been a K-by-N matrix, and P**T
  is of order N:
  if k < n, P**T = G(k) . . . G(2) G(1) and DORGBR returns the first m

  rows of P**T, where n >= m >= k;
  if k >= n, P**T = G(n-1) . . . G(2) G(1) and DORGBR returns P**T as
  an N-by-N matrix.

  Arguments
  =========

  VECT    (input) CHARACTER*1
          Specifies whether the matrix Q or the matrix P**T is
          required, as defined in the transformation applied by DGEBRD:
          = 'Q':  generate Q;
          = 'P':  generate P**T.

  M       (input) INTEGER
          The number of rows of the matrix Q or P**T to be returned.
          M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q or P**T to be returned.
          N >= 0.
          If VECT = 'Q', M >= N >= min(M,K);
          if VECT = 'P', N >= M >= min(N,K).

  K       (input) INTEGER
          If VECT = 'Q', the number of columns in the original M-by-K
          matrix reduced by DGEBRD.
          If VECT = 'P', the number of rows in the original K-by-N
          matrix reduced by DGEBRD.
          K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the vectors which define the elementary reflectors,
          as returned by DGEBRD.
          On exit, the M-by-N matrix Q or P**T.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension
                                (min(M,K)) if VECT = 'Q'
                                (min(N,K)) if VECT = 'P'
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i) or G(i), which determines Q or P**T, as
          returned by DGEBRD in its array argument TAUQ or TAUP.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,min(M,N)).
          For optimum performance LWORK >= min(M,N)*NB, where NB
          is the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param vect
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorgbr(String vect, int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGHR generates a real orthogonal matrix Q which is defined as the
  product of IHI-ILO elementary reflectors of order N, as returned by
  DGEHRD:

  Q = H(ilo) H(ilo+1) . . . H(ihi-1).

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix Q. N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          ILO and IHI must have the same values as in the previous call
          of DGEHRD. Q is equal to the unit matrix except in the
          submatrix Q(ilo+1:ihi,ilo+1:ihi).
          1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the vectors which define the elementary reflectors,
          as returned by DGEHRD.
          On exit, the N-by-N orthogonal matrix Q.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,N).

  TAU     (input) DOUBLE PRECISION array, dimension (N-1)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEHRD.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= IHI-ILO.
          For optimum performance LWORK >= (IHI-ILO)*NB, where NB is
          the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorghr(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGL2 generates an m by n real matrix Q with orthonormal rows,
  which is defined as the first m rows of a product of k elementary
  reflectors of order n

        Q  =  H(k) . . . H(2) H(1)

  as returned by DGELQF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. N >= M.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. M >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the i-th row must contain the vector which defines

          the elementary reflector H(i), for i = 1,2,...,k, as returned
          by DGELQF in the first k rows of its array argument A.
          On exit, the m-by-n matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGELQF.

  WORK    (workspace) DOUBLE PRECISION array, dimension (M)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dorgl2(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGLQ generates an M-by-N real matrix Q with orthonormal rows,
  which is defined as the first M rows of a product of K elementary
  reflectors of order N

        Q  =  H(k) . . . H(2) H(1)

  as returned by DGELQF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. N >= M.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. M >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the i-th row must contain the vector which defines

          the elementary reflector H(i), for i = 1,2,...,k, as returned
          by DGELQF in the first k rows of its array argument A.
          On exit, the M-by-N matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGELQF.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,M).
          For optimum performance LWORK >= M*NB, where NB is
          the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorglq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGQL generates an M-by-N real matrix Q with orthonormal columns,
  which is defined as the last N columns of a product of K elementary
  reflectors of order M

        Q  =  H(k) . . . H(2) H(1)

  as returned by DGEQLF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. M >= N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. N >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the (n-k+i)-th column must contain the vector which
          defines the elementary reflector H(i), for i = 1,2,...,k, as

          returned by DGEQLF in the last k columns of its array
          argument A.
          On exit, the M-by-N matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQLF.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,N).
          For optimum performance LWORK >= N*NB, where NB is the
          optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorgql(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGQR generates an M-by-N real matrix Q with orthonormal columns,
  which is defined as the first N columns of a product of K elementary

  reflectors of order M

        Q  =  H(1) H(2) . . . H(k)

  as returned by DGEQRF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. M >= N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. N >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the i-th column must contain the vector which
          defines the elementary reflector H(i), for i = 1,2,...,k, as

          returned by DGEQRF in the first k columns of its array
          argument A.
          On exit, the M-by-N matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQRF.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,N).
          For optimum performance LWORK >= N*NB, where NB is the
          optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorgqr(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGR2 generates an m by n real matrix Q with orthonormal rows,
  which is defined as the last m rows of a product of k elementary
  reflectors of order n

        Q  =  H(1) H(2) . . . H(k)

  as returned by DGERQF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. N >= M.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. M >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the (m-k+i)-th row must contain the vector which
          defines the elementary reflector H(i), for i = 1,2,...,k, as

          returned by DGERQF in the last k rows of its array argument
          A.
          On exit, the m by n matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGERQF.

  WORK    (workspace) DOUBLE PRECISION array, dimension (M)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param info
	 */
	public abstract void dorgr2(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGRQ generates an M-by-N real matrix Q with orthonormal rows,
  which is defined as the last M rows of a product of K elementary
  reflectors of order N

        Q  =  H(1) H(2) . . . H(k)

  as returned by DGERQF.

  Arguments
  =========

  M       (input) INTEGER
          The number of rows of the matrix Q. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix Q. N >= M.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines the
          matrix Q. M >= K >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the (m-k+i)-th row must contain the vector which
          defines the elementary reflector H(i), for i = 1,2,...,k, as

          returned by DGERQF in the last k rows of its array argument
          A.
          On exit, the M-by-N matrix Q.

  LDA     (input) INTEGER
          The first dimension of the array A. LDA >= max(1,M).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGERQF.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,M).
          For optimum performance LWORK >= M*NB, where NB is the
          optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument has an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorgrq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORGTR generates a real orthogonal matrix Q which is defined as the
  product of n-1 elementary reflectors of order N, as returned by
  DSYTRD:

  if UPLO = 'U', Q = H(n-1) . . . H(2) H(1),

  if UPLO = 'L', Q = H(1) H(2) . . . H(n-1).

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U': Upper triangle of A contains elementary reflectors
                 from DSYTRD;
          = 'L': Lower triangle of A contains elementary reflectors
                 from DSYTRD.

  N       (input) INTEGER
          The order of the matrix Q. N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the vectors which define the elementary reflectors,
          as returned by DSYTRD.
          On exit, the N-by-N orthogonal matrix Q.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,N).

  TAU     (input) DOUBLE PRECISION array, dimension (N-1)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DSYTRD.

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK. LWORK >= max(1,N-1).
          For optimum performance LWORK >= (N-1)*NB, where NB is
          the optimal blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dorgtr(String uplo, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORM2L overwrites the general real m by n matrix C with

        Q * C  if SIDE = 'L' and TRANS = 'N', or

        Q'* C  if SIDE = 'L' and TRANS = 'T', or

        C * Q  if SIDE = 'R' and TRANS = 'N', or

        C * Q' if SIDE = 'R' and TRANS = 'T',

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(k) . . . H(2) H(1)

  as returned by DGEQLF. Q is of order m if SIDE = 'L' and of order n
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q' from the Left
          = 'R': apply Q or Q' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply Q  (No transpose)
          = 'T': apply Q' (Transpose)

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,K)
          The i-th column must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGEQLF in the last k columns of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          If SIDE = 'L', LDA >= max(1,M);
          if SIDE = 'R', LDA >= max(1,N).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQLF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by Q*C or Q'*C or C*Q' or C*Q.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                                   (N) if SIDE = 'L',
                                   (M) if SIDE = 'R'

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dorm2l(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORM2R overwrites the general real m by n matrix C with

        Q * C  if SIDE = 'L' and TRANS = 'N', or

        Q'* C  if SIDE = 'L' and TRANS = 'T', or

        C * Q  if SIDE = 'R' and TRANS = 'N', or

        C * Q' if SIDE = 'R' and TRANS = 'T',

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(1) H(2) . . . H(k)

  as returned by DGEQRF. Q is of order m if SIDE = 'L' and of order n
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q' from the Left
          = 'R': apply Q or Q' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply Q  (No transpose)
          = 'T': apply Q' (Transpose)

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,K)
          The i-th column must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGEQRF in the first k columns of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          If SIDE = 'L', LDA >= max(1,M);
          if SIDE = 'R', LDA >= max(1,N).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQRF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by Q*C or Q'*C or C*Q' or C*Q.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                                   (N) if SIDE = 'L',
                                   (M) if SIDE = 'R'

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dorm2r(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  If VECT = 'Q', DORMBR overwrites the general real M-by-N matrix C
  with
                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  If VECT = 'P', DORMBR overwrites the general real M-by-N matrix C
  with
                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      P * C          C * P
  TRANS = 'T':      P**T * C       C * P**T

  Here Q and P**T are the orthogonal matrices determined by DGEBRD when
  reducing a real matrix A to bidiagonal form: A = Q * B * P**T. Q and

  P**T are defined as products of elementary reflectors H(i) and G(i)
  respectively.

  Let nq = m if SIDE = 'L' and nq = n if SIDE = 'R'. Thus nq is the
  order of the orthogonal matrix Q or P**T that is applied.

  If VECT = 'Q', A is assumed to have been an NQ-by-K matrix:
  if nq >= k, Q = H(1) H(2) . . . H(k);
  if nq < k, Q = H(1) H(2) . . . H(nq-1).

  If VECT = 'P', A is assumed to have been a K-by-NQ matrix:
  if k < nq, P = G(1) G(2) . . . G(k);
  if k >= nq, P = G(1) G(2) . . . G(nq-1).

  Arguments
  =========

  VECT    (input) CHARACTER*1
          = 'Q': apply Q or Q**T;
          = 'P': apply P or P**T.

  SIDE    (input) CHARACTER*1
          = 'L': apply Q, Q**T, P or P**T from the Left;
          = 'R': apply Q, Q**T, P or P**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q  or P;
          = 'T':  Transpose, apply Q**T or P**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          If VECT = 'Q', the number of columns in the original
          matrix reduced by DGEBRD.
          If VECT = 'P', the number of rows in the original
          matrix reduced by DGEBRD.
          K >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                                (LDA,min(nq,K)) if VECT = 'Q'
                                (LDA,nq)        if VECT = 'P'
          The vectors which define the elementary reflectors H(i) and
          G(i), whose products determine the matrices Q and P, as
          returned by DGEBRD.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          If VECT = 'Q', LDA >= max(1,nq);
          if VECT = 'P', LDA >= max(1,min(nq,K)).

  TAU     (input) DOUBLE PRECISION array, dimension (min(nq,K))
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i) or G(i) which determines Q or P, as returned
          by DGEBRD in the array argument TAUQ or TAUP.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q
          or P*C or P**T*C or C*P or C*P**T.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param vect
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormbr(String vect, String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMHR overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix of order nq, with nq = m if
  SIDE = 'L' and nq = n if SIDE = 'R'. Q is defined as the product of
  IHI-ILO elementary reflectors, as returned by DGEHRD:

  Q = H(ilo) H(ilo+1) . . . H(ihi-1).

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  ILO     (input) INTEGER
  IHI     (input) INTEGER
          ILO and IHI must have the same values as in the previous call
          of DGEHRD. Q is equal to the unit matrix except in the
          submatrix Q(ilo+1:ihi,ilo+1:ihi).
          If SIDE = 'L', then 1 <= ILO <= IHI <= M, if M > 0, and
          ILO = 1 and IHI = 0, if M = 0;
          if SIDE = 'R', then 1 <= ILO <= IHI <= N, if N > 0, and
          ILO = 1 and IHI = 0, if N = 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L'
                               (LDA,N) if SIDE = 'R'
          The vectors which define the elementary reflectors, as
          returned by DGEHRD.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          LDA >= max(1,M) if SIDE = 'L'; LDA >= max(1,N) if SIDE = 'R'.

  TAU     (input) DOUBLE PRECISION array, dimension
                               (M-1) if SIDE = 'L'
                               (N-1) if SIDE = 'R'
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEHRD.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param ilo
	 * @param ihi
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormhr(String side, String trans, int m, int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORML2 overwrites the general real m by n matrix C with

        Q * C  if SIDE = 'L' and TRANS = 'N', or

        Q'* C  if SIDE = 'L' and TRANS = 'T', or

        C * Q  if SIDE = 'R' and TRANS = 'N', or

        C * Q' if SIDE = 'R' and TRANS = 'T',

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(k) . . . H(2) H(1)

  as returned by DGELQF. Q is of order m if SIDE = 'L' and of order n
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q' from the Left
          = 'R': apply Q or Q' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply Q  (No transpose)
          = 'T': apply Q' (Transpose)

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L',
                               (LDA,N) if SIDE = 'R'
          The i-th row must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGELQF in the first k rows of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,K).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGELQF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by Q*C or Q'*C or C*Q' or C*Q.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                                   (N) if SIDE = 'L',
                                   (M) if SIDE = 'R'

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dorml2(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMLQ overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(k) . . . H(2) H(1)

  as returned by DGELQF. Q is of order M if SIDE = 'L' and of order N
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L',
                               (LDA,N) if SIDE = 'R'
          The i-th row must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGELQF in the first k rows of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,K).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGELQF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormlq(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMQL overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(k) . . . H(2) H(1)

  as returned by DGEQLF. Q is of order M if SIDE = 'L' and of order N
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,K)
          The i-th column must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGEQLF in the last k columns of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          If SIDE = 'L', LDA >= max(1,M);
          if SIDE = 'R', LDA >= max(1,N).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQLF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormql(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMQR overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(1) H(2) . . . H(k)

  as returned by DGEQRF. Q is of order M if SIDE = 'L' and of order N
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,K)
          The i-th column must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGEQRF in the first k columns of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          If SIDE = 'L', LDA >= max(1,M);
          if SIDE = 'R', LDA >= max(1,N).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGEQRF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormqr(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMR2 overwrites the general real m by n matrix C with

        Q * C  if SIDE = 'L' and TRANS = 'N', or

        Q'* C  if SIDE = 'L' and TRANS = 'T', or

        C * Q  if SIDE = 'R' and TRANS = 'N', or

        C * Q' if SIDE = 'R' and TRANS = 'T',

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(1) H(2) . . . H(k)

  as returned by DGERQF. Q is of order m if SIDE = 'L' and of order n
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q' from the Left
          = 'R': apply Q or Q' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply Q  (No transpose)
          = 'T': apply Q' (Transpose)

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L',
                               (LDA,N) if SIDE = 'R'
          The i-th row must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGERQF in the last k rows of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,K).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGERQF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m by n matrix C.
          On exit, C is overwritten by Q*C or Q'*C or C*Q' or C*Q.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                                   (N) if SIDE = 'L',
                                   (M) if SIDE = 'R'

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dormr2(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMR3 overwrites the general real m by n matrix C with

        Q * C  if SIDE = 'L' and TRANS = 'N', or

        Q'* C  if SIDE = 'L' and TRANS = 'T', or

        C * Q  if SIDE = 'R' and TRANS = 'N', or

        C * Q' if SIDE = 'R' and TRANS = 'T',

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(1) H(2) . . . H(k)

  as returned by DTZRZF. Q is of order m if SIDE = 'L' and of order n
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q' from the Left
          = 'R': apply Q or Q' from the Right

  TRANS   (input) CHARACTER*1
          = 'N': apply Q  (No transpose)
          = 'T': apply Q' (Transpose)

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  L       (input) INTEGER
          The number of columns of the matrix A containing
          the meaningful part of the Householder reflectors.
          If SIDE = 'L', M >= L >= 0, if SIDE = 'R', N >= L >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L',
                               (LDA,N) if SIDE = 'R'
          The i-th row must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DTZRZF in the last k rows of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,K).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DTZRZF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the m-by-n matrix C.
          On exit, C is overwritten by Q*C or Q'*C or C*Q' or C*Q.

  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace) DOUBLE PRECISION array, dimension
                                   (N) if SIDE = 'L',
                                   (M) if SIDE = 'R'

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA


  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param l
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param info
	 */
	public abstract void dormr3(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMRQ overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(1) H(2) . . . H(k)

  as returned by DGERQF. Q is of order M if SIDE = 'L' and of order N
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L',
                               (LDA,N) if SIDE = 'R'
          The i-th row must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DGERQF in the last k rows of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,K).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DGERQF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormrq(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMRZ overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix defined as the product of k
  elementary reflectors

        Q = H(1) H(2) . . . H(k)

  as returned by DTZRZF. Q is of order M if SIDE = 'L' and of order N
  if SIDE = 'R'.

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  K       (input) INTEGER
          The number of elementary reflectors whose product defines
          the matrix Q.
          If SIDE = 'L', M >= K >= 0;
          if SIDE = 'R', N >= K >= 0.

  L       (input) INTEGER
          The number of columns of the matrix A containing
          the meaningful part of the Householder reflectors.
          If SIDE = 'L', M >= L >= 0, if SIDE = 'R', N >= L >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L',
                               (LDA,N) if SIDE = 'R'
          The i-th row must contain the vector which defines the
          elementary reflector H(i), for i = 1,2,...,k, as returned by

          DTZRZF in the last k rows of its array argument A.
          A is modified by the routine but restored on exit.

  LDA     (input) INTEGER
          The leading dimension of the array A. LDA >= max(1,K).

  TAU     (input) DOUBLE PRECISION array, dimension (K)
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DTZRZF.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**H*C or C*Q**H or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  Based on contributions by
    A. Petitet, Computer Science Dept., Univ. of Tenn., Knoxville, USA


  =====================================================================

     .. Parameters ..
</pre>
	 * @param side
	 * @param trans
	 * @param m
	 * @param n
	 * @param k
	 * @param l
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormrz(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DORMTR overwrites the general real M-by-N matrix C with

                  SIDE = 'L'     SIDE = 'R'
  TRANS = 'N':      Q * C          C * Q
  TRANS = 'T':      Q**T * C       C * Q**T

  where Q is a real orthogonal matrix of order nq, with nq = m if
  SIDE = 'L' and nq = n if SIDE = 'R'. Q is defined as the product of
  nq-1 elementary reflectors, as returned by DSYTRD:

  if UPLO = 'U', Q = H(nq-1) . . . H(2) H(1);

  if UPLO = 'L', Q = H(1) H(2) . . . H(nq-1).

  Arguments
  =========

  SIDE    (input) CHARACTER*1
          = 'L': apply Q or Q**T from the Left;
          = 'R': apply Q or Q**T from the Right.

  UPLO    (input) CHARACTER*1
          = 'U': Upper triangle of A contains elementary reflectors
                 from DSYTRD;
          = 'L': Lower triangle of A contains elementary reflectors
                 from DSYTRD.

  TRANS   (input) CHARACTER*1
          = 'N':  No transpose, apply Q;
          = 'T':  Transpose, apply Q**T.

  M       (input) INTEGER
          The number of rows of the matrix C. M >= 0.

  N       (input) INTEGER
          The number of columns of the matrix C. N >= 0.

  A       (input) DOUBLE PRECISION array, dimension
                               (LDA,M) if SIDE = 'L'
                               (LDA,N) if SIDE = 'R'
          The vectors which define the elementary reflectors, as
          returned by DSYTRD.

  LDA     (input) INTEGER
          The leading dimension of the array A.
          LDA >= max(1,M) if SIDE = 'L'; LDA >= max(1,N) if SIDE = 'R'.

  TAU     (input) DOUBLE PRECISION array, dimension
                               (M-1) if SIDE = 'L'
                               (N-1) if SIDE = 'R'
          TAU(i) must contain the scalar factor of the elementary
          reflector H(i), as returned by DSYTRD.

  C       (input/output) DOUBLE PRECISION array, dimension (LDC,N)
          On entry, the M-by-N matrix C.
          On exit, C is overwritten by Q*C or Q**T*C or C*Q**T or C*Q.


  LDC     (input) INTEGER
          The leading dimension of the array C. LDC >= max(1,M).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If SIDE = 'L', LWORK >= max(1,N);
          if SIDE = 'R', LWORK >= max(1,M).
          For optimum performance LWORK >= N*NB if SIDE = 'L', and
          LWORK >= M*NB if SIDE = 'R', where NB is the optimal
          blocksize.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal size of the WORK array, returns
          this value as the first entry of the WORK array, and no error
          message related to LWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param side
	 * @param uplo
	 * @param trans
	 * @param m
	 * @param n
	 * @param a
	 * @param lda
	 * @param tau
	 * @param c
	 * @param Ldc
	 * @param work
	 * @param lwork
	 * @param info
	 */
	public abstract void dormtr(String side, String uplo, String trans, int m, int n, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBCON estimates the reciprocal of the condition number (in the
  1-norm) of a real symmetric positive definite band matrix using the
  Cholesky factorization A = U**T*U or A = L*L**T computed by DPBTRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangular factor stored in AB;
          = 'L':  Lower triangular factor stored in AB.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T of the band matrix A, stored in the

          first KD+1 rows of the array.  The j-th column of U or L is
          stored in the j-th column of the array AB as follows:
          if UPLO ='U', AB(kd+1+i-j,j) = U(i,j) for max(1,j-kd)<=i<=j;

          if UPLO ='L', AB(1+i-j,j)    = L(i,j) for j<=i<=min(n,j+kd).


  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  ANORM   (input) DOUBLE PRECISION
          The 1-norm (or infinity-norm) of the symmetric band matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
          estimate of the 1-norm of inv(A) computed in this routine.

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dpbcon(String uplo, int n, int kd, double[] ab, int ldab, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBEQU computes row and column scalings intended to equilibrate a
  symmetric positive definite band matrix A and reduce its condition
  number (with respect to the two-norm).  S contains the scale factors,
  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
  choice of S puts the condition number of B within a factor N of the
  smallest possible condition number over all possible diagonal
  scalings.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangular of A is stored;
          = 'L':  Lower triangular of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The upper or lower triangle of the symmetric band matrix A,
          stored in the first KD+1 rows of the array.  The j-th column

          of A is stored in the j-th column of the array AB as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

  LDAB     (input) INTEGER
          The leading dimension of the array A.  LDAB >= KD+1.

  S       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, S contains the scale factors for A.

  SCOND   (output) DOUBLE PRECISION
          If INFO = 0, S contains the ratio of the smallest S(i) to
          the largest S(i).  If SCOND >= 0.1 and AMAX is neither too
          large nor too small, it is not worth scaling by S.

  AMAX    (output) DOUBLE PRECISION
          Absolute value of largest matrix element.  If AMAX is very
          close to overflow or very close to underflow, the matrix
          should be scaled.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = i, the i-th diagonal element is nonpositive.


  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param s
	 * @param scond
	 * @param amax
	 * @param info
	 */
	public abstract void dpbequ(String uplo, int n, int kd, double[] ab, int ldab, double[] s, doubleW scond, doubleW amax, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBRFS improves the computed solution to a system of linear
  equations when the coefficient matrix is symmetric positive definite

  and banded, and provides error bounds and backward error estimates
  for the solution.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The upper or lower triangle of the symmetric band matrix A,
          stored in the first KD+1 rows of the array.  The j-th column

          of A is stored in the j-th column of the array AB as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  AFB     (input) DOUBLE PRECISION array, dimension (LDAFB,N)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T of the band matrix A as computed by

          DPBTRF, in the same storage format as A (see AB).

  LDAFB   (input) INTEGER
          The leading dimension of the array AFB.  LDAFB >= KD+1.

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DPBTRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param afb
	 * @param ldafb
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dpbrfs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBSTF computes a split Cholesky factorization of a real
  symmetric positive definite band matrix A.

  This routine is designed to be used in conjunction with DSBGST.

  The factorization has the form  A = S**T*S  where S is a band matrix

  of the same bandwidth as A and the following structure:

    S = ( U    )
        ( M  L )

  where U is upper triangular of order m = (n+kd)/2, and L is lower
  triangular of order n-m.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first kd+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, if INFO = 0, the factor S from the split Cholesky
          factorization A = S**T*S. See Further Details.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value
          > 0: if INFO = i, the factorization could not be completed,
               because the updated element a(i,i) was negative; the
               matrix A is not positive definite.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  N = 7, KD = 2:

  S = ( s11  s12  s13                     )
      (      s22  s23  s24                )
      (           s33  s34                )
      (                s44                )
      (           s53  s54  s55           )
      (                s64  s65  s66      )
      (                     s75  s76  s77 )

  If UPLO = 'U', the array AB holds:

  on entry:                          on exit:

   *    *   a13  a24  a35  a46  a57   *    *   s13  s24  s53  s64  s75

   *   a12  a23  a34  a45  a56  a67   *   s12  s23  s34  s54  s65  s76

  a11  a22  a33  a44  a55  a66  a77  s11  s22  s33  s44  s55  s66  s77


  If UPLO = 'L', the array AB holds:

  on entry:                          on exit:

  a11  a22  a33  a44  a55  a66  a77  s11  s22  s33  s44  s55  s66  s77

  a21  a32  a43  a54  a65  a76   *   s12  s23  s34  s54  s65  s76   *
  a31  a42  a53  a64  a64   *    *   s13  s24  s53  s64  s75   *    *

  Array elements marked * are not used by the routine.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param info
	 */
	public abstract void dpbstf(String uplo, int n, int kd, double[] ab, int ldab, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBSV computes the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N symmetric positive definite band matrix and X
  and B are N-by-NRHS matrices.

  The Cholesky decomposition is used to factor A as
     A = U**T * U,  if UPLO = 'U', or
     A = L * L**T,  if UPLO = 'L',
  where U is an upper triangular band matrix, and L is a lower
  triangular band matrix, with the same number of superdiagonals or
  subdiagonals as A.  The factored form of A is then used to solve the

  system of equations A * X = B.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(KD+1+i-j,j) = A(i,j) for max(1,j-KD)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(N,j+KD).
          See below for further details.

          On exit, if INFO = 0, the triangular factor U or L from the
          Cholesky factorization A = U**T*U or A = L*L**T of the band
          matrix A, in the same storage format as A.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if INFO = 0, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i of A is not
                positive definite, so the factorization could not be
                completed, and the solution has not been computed.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  N = 6, KD = 2, and UPLO = 'U':

  On entry:                       On exit:

      *    *   a13  a24  a35  a46      *    *   u13  u24  u35  u46
      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66

  Similarly, if UPLO = 'L' the format of A is as follows:

  On entry:                       On exit:

     a11  a22  a33  a44  a55  a66     l11  l22  l33  l44  l55  l66
     a21  a32  a43  a54  a65   *      l21  l32  l43  l54  l65   *
     a31  a42  a53  a64   *    *      l31  l42  l53  l64   *    *

  Array elements marked * are not used by the routine.

  =====================================================================

     .. External Functions ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dpbsv(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
  compute the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N symmetric positive definite band matrix and X
  and B are N-by-NRHS matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed:

  1. If FACT = 'E', real scaling factors are computed to equilibrate
     the system:
        diag(S) * A * diag(S) * inv(diag(S)) * X = diag(S) * B
     Whether or not the system will be equilibrated depends on the
     scaling of the matrix A, but if equilibration is used, A is
     overwritten by diag(S)*A*diag(S) and B by diag(S)*B.

  2. If FACT = 'N' or 'E', the Cholesky decomposition is used to
     factor the matrix A (after equilibration if FACT = 'E') as
        A = U**T * U,  if UPLO = 'U', or
        A = L * L**T,  if UPLO = 'L',
     where U is an upper triangular band matrix, and L is a lower
     triangular band matrix.

  3. If the leading i-by-i principal minor is not positive definite,
     then the routine returns with INFO = i. Otherwise, the factored
     form of A is used to estimate the condition number of the matrix
     A.  If the reciprocal of the condition number is less than machine
     precision, INFO = N+1 is returned as a warning, but the routine
     still goes on to solve for X and compute error bounds as
     described below.

  4. The system of equations is solved for X using the factored form
     of A.

  5. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  6. If equilibration was used, the matrix X is premultiplied by
     diag(S) so that it solves the original system before
     equilibration.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of the matrix A is
          supplied on entry, and if not, whether the matrix A should be
          equilibrated before it is factored.
          = 'F':  On entry, AFB contains the factored form of A.
                  If EQUED = 'Y', the matrix A has been equilibrated
                  with scaling factors given by S.  AB and AFB will not
                  be modified.
          = 'N':  The matrix A will be copied to AFB and factored.
          = 'E':  The matrix A will be equilibrated if necessary, then

                  copied to AFB and factored.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  NRHS    (input) INTEGER
          The number of right-hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array, except

          if FACT = 'F' and EQUED = 'Y', then A must contain the
          equilibrated matrix diag(S)*A*diag(S).  The j-th column of A

          is stored in the j-th column of the array AB as follows:
          if UPLO = 'U', AB(KD+1+i-j,j) = A(i,j) for max(1,j-KD)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(N,j+KD).
          See below for further details.

          On exit, if FACT = 'E' and EQUED = 'Y', A is overwritten by
          diag(S)*A*diag(S).

  LDAB    (input) INTEGER
          The leading dimension of the array A.  LDAB >= KD+1.

  AFB     (input or output) DOUBLE PRECISION array, dimension (LDAFB,N)
          If FACT = 'F', then AFB is an input argument and on entry
          contains the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T of the band matrix
          A, in the same storage format as A (see AB).  If EQUED = 'Y',
          then AFB is the factored form of the equilibrated matrix A.

          If FACT = 'N', then AFB is an output argument and on exit
          returns the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T.

          If FACT = 'E', then AFB is an output argument and on exit
          returns the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T of the equilibrated
          matrix A (see the description of A for the form of the
          equilibrated matrix).

  LDAFB   (input) INTEGER
          The leading dimension of the array AFB.  LDAFB >= KD+1.

  EQUED   (input or output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration (always true if FACT = 'N').
          = 'Y':  Equilibration was done, i.e., A has been replaced by

                  diag(S) * A * diag(S).
          EQUED is an input argument if FACT = 'F'; otherwise, it is an
          output argument.

  S       (input or output) DOUBLE PRECISION array, dimension (N)
          The scale factors for A; not accessed if EQUED = 'N'.  S is
          an input argument if FACT = 'F'; otherwise, S is an output
          argument.  If FACT = 'F' and EQUED = 'Y', each element of S
          must be positive.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if EQUED = 'N', B is not modified; if EQUED = 'Y',
          B is overwritten by diag(S) * B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X to
          the original system of equations.  Note that if EQUED = 'Y',

          A and B are modified on exit, and the solution to the
          equilibrated system is inv(diag(S))*X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The estimate of the reciprocal condition number of the matrix
          A after equilibration (if done).  If RCOND is less than the
          machine precision (in particular, if RCOND = 0), the matrix
          is singular to working precision.  This condition is
          indicated by a return code of INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= N:  the leading minor of order i of A is
                       not positive definite, so the factorization
                       could not be completed, and the solution has not
                       been computed. RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  N = 6, KD = 2, and UPLO = 'U':

  Two-dimensional storage of the symmetric matrix A:

     a11  a12  a13
          a22  a23  a24
               a33  a34  a35
                    a44  a45  a46
                         a55  a56
     (aij=conjg(aji))         a66

  Band storage of the upper triangle of A:

      *    *   a13  a24  a35  a46
      *   a12  a23  a34  a45  a56
     a11  a22  a33  a44  a55  a66

  Similarly, if UPLO = 'L' the format of A is as follows:

     a11  a22  a33  a44  a55  a66
     a21  a32  a43  a54  a65   *
     a31  a42  a53  a64   *    *

  Array elements marked * are not used by the routine.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param afb
	 * @param ldafb
	 * @param equed
	 * @param s
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dpbsvx(String fact, String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBTF2 computes the Cholesky factorization of a real symmetric
  positive definite band matrix A.

  The factorization has the form
     A = U' * U ,  if UPLO = 'U', or
     A = L  * L',  if UPLO = 'L',
  where U is an upper triangular matrix, U' is the transpose of U, and

  L is lower triangular.

  This is the unblocked version of the algorithm, calling Level 2 BLAS.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored:
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of super-diagonals of the matrix A if UPLO = 'U',

          or the number of sub-diagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, if INFO = 0, the triangular factor U or L from the
          Cholesky factorization A = U'*U or A = L*L' of the band
          matrix A, in the same storage format as A.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value
          > 0: if INFO = k, the leading minor of order k is not
               positive definite, and the factorization could not be
               completed.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  N = 6, KD = 2, and UPLO = 'U':

  On entry:                       On exit:

      *    *   a13  a24  a35  a46      *    *   u13  u24  u35  u46
      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66

  Similarly, if UPLO = 'L' the format of A is as follows:

  On entry:                       On exit:

     a11  a22  a33  a44  a55  a66     l11  l22  l33  l44  l55  l66
     a21  a32  a43  a54  a65   *      l21  l32  l43  l54  l65   *
     a31  a42  a53  a64   *    *      l31  l42  l53  l64   *    *

  Array elements marked * are not used by the routine.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param info
	 */
	public abstract void dpbtf2(String uplo, int n, int kd, double[] ab, int ldab, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBTRF computes the Cholesky factorization of a real symmetric
  positive definite band matrix A.

  The factorization has the form
     A = U**T * U,  if UPLO = 'U', or
     A = L  * L**T,  if UPLO = 'L',
  where U is an upper triangular matrix and L is lower triangular.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, if INFO = 0, the triangular factor U or L from the
          Cholesky factorization A = U**T*U or A = L*L**T of the band
          matrix A, in the same storage format as A.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i is not
                positive definite, and the factorization could not be
                completed.

  Further Details
  ===============

  The band storage scheme is illustrated by the following example, when
  N = 6, KD = 2, and UPLO = 'U':

  On entry:                       On exit:

      *    *   a13  a24  a35  a46      *    *   u13  u24  u35  u46
      *   a12  a23  a34  a45  a56      *   u12  u23  u34  u45  u56
     a11  a22  a33  a44  a55  a66     u11  u22  u33  u44  u55  u66

  Similarly, if UPLO = 'L' the format of A is as follows:

  On entry:                       On exit:

     a11  a22  a33  a44  a55  a66     l11  l22  l33  l44  l55  l66
     a21  a32  a43  a54  a65   *      l21  l32  l43  l54  l65   *
     a31  a42  a53  a64   *    *      l31  l42  l53  l64   *    *

  Array elements marked * are not used by the routine.

  Contributed by
  Peter Mayes and Giuseppe Radicati, IBM ECSEC, Rome, March 23, 1989

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param info
	 */
	public abstract void dpbtrf(String uplo, int n, int kd, double[] ab, int ldab, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPBTRS solves a system of linear equations A*X = B with a symmetric
  positive definite band matrix A using the Cholesky factorization
  A = U**T*U or A = L*L**T computed by DPBTRF.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangular factor stored in AB;
          = 'L':  Lower triangular factor stored in AB.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  AB      (input) DOUBLE PRECISION array, dimension (LDAB,N)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T of the band matrix A, stored in the

          first KD+1 rows of the array.  The j-th column of U or L is
          stored in the j-th column of the array AB as follows:
          if UPLO ='U', AB(kd+1+i-j,j) = U(i,j) for max(1,j-kd)<=i<=j;

          if UPLO ='L', AB(1+i-j,j)    = L(i,j) for j<=i<=min(n,j+kd).


  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side matrix B.
          On exit, the solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param nrhs
	 * @param ab
	 * @param ldab
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dpbtrs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOCON estimates the reciprocal of the condition number (in the
  1-norm) of a real symmetric positive definite matrix using the
  Cholesky factorization A = U**T*U or A = L*L**T computed by DPOTRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T, as computed by DPOTRF.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  ANORM   (input) DOUBLE PRECISION
          The 1-norm (or infinity-norm) of the symmetric matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
          estimate of the 1-norm of inv(A) computed in this routine.

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dpocon(String uplo, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOEQU computes row and column scalings intended to equilibrate a
  symmetric positive definite matrix A and reduce its condition number

  (with respect to the two-norm).  S contains the scale factors,
  S(i) = 1/sqrt(A(i,i)), chosen so that the scaled matrix B with
  elements B(i,j) = S(i)*A(i,j)*S(j) has ones on the diagonal.  This
  choice of S puts the condition number of B within a factor N of the
  smallest possible condition number over all possible diagonal
  scalings.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The N-by-N symmetric positive definite matrix whose scaling
          factors are to be computed.  Only the diagonal elements of A

          are referenced.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  S       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, S contains the scale factors for A.

  SCOND   (output) DOUBLE PRECISION
          If INFO = 0, S contains the ratio of the smallest S(i) to
          the largest S(i).  If SCOND >= 0.1 and AMAX is neither too
          large nor too small, it is not worth scaling by S.

  AMAX    (output) DOUBLE PRECISION
          Absolute value of largest matrix element.  If AMAX is very
          close to overflow or very close to underflow, the matrix
          should be scaled.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the i-th diagonal element is nonpositive.


  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param a
	 * @param lda
	 * @param s
	 * @param scond
	 * @param amax
	 * @param info
	 */
	public abstract void dpoequ(int n, double[] a, int lda, double[] s, doubleW scond, doubleW amax, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPORFS improves the computed solution to a system of linear
  equations when the coefficient matrix is symmetric positive definite,
  and provides error bounds and backward error estimates for the
  solution.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The symmetric matrix A.  If UPLO = 'U', the leading N-by-N
          upper triangular part of A contains the upper triangular part
          of the matrix A, and the strictly lower triangular part of A

          is not referenced.  If UPLO = 'L', the leading N-by-N lower
          triangular part of A contains the lower triangular part of
          the matrix A, and the strictly upper triangular part of A is

          not referenced.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  AF      (input) DOUBLE PRECISION array, dimension (LDAF,N)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T, as computed by DPOTRF.

  LDAF    (input) INTEGER
          The leading dimension of the array AF.  LDAF >= max(1,N).

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DPOTRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param af
	 * @param ldaf
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dporfs(String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOSV computes the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N symmetric positive definite matrix and X and B
  are N-by-NRHS matrices.

  The Cholesky decomposition is used to factor A as
     A = U**T* U,  if UPLO = 'U', or
     A = L * L**T,  if UPLO = 'L',
  where U is an upper triangular matrix and L is a lower triangular
  matrix.  The factored form of A is then used to solve the system of
  equations A * X = B.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A.  If UPLO = 'U', the leading
          N-by-N upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading N-by-N lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.

          On exit, if INFO = 0, the factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if INFO = 0, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i of A is not
                positive definite, so the factorization could not be
                completed, and the solution has not been computed.

  =====================================================================

     .. External Functions ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dposv(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
  compute the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N symmetric positive definite matrix and X and B
  are N-by-NRHS matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed:

  1. If FACT = 'E', real scaling factors are computed to equilibrate
     the system:
        diag(S) * A * diag(S) * inv(diag(S)) * X = diag(S) * B
     Whether or not the system will be equilibrated depends on the
     scaling of the matrix A, but if equilibration is used, A is
     overwritten by diag(S)*A*diag(S) and B by diag(S)*B.

  2. If FACT = 'N' or 'E', the Cholesky decomposition is used to
     factor the matrix A (after equilibration if FACT = 'E') as
        A = U**T* U,  if UPLO = 'U', or
        A = L * L**T,  if UPLO = 'L',
     where U is an upper triangular matrix and L is a lower triangular

     matrix.

  3. If the leading i-by-i principal minor is not positive definite,
     then the routine returns with INFO = i. Otherwise, the factored
     form of A is used to estimate the condition number of the matrix
     A.  If the reciprocal of the condition number is less than machine
     precision, INFO = N+1 is returned as a warning, but the routine
     still goes on to solve for X and compute error bounds as
     described below.

  4. The system of equations is solved for X using the factored form
     of A.

  5. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  6. If equilibration was used, the matrix X is premultiplied by
     diag(S) so that it solves the original system before
     equilibration.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of the matrix A is
          supplied on entry, and if not, whether the matrix A should be
          equilibrated before it is factored.
          = 'F':  On entry, AF contains the factored form of A.
                  If EQUED = 'Y', the matrix A has been equilibrated
                  with scaling factors given by S.  A and AF will not
                  be modified.
          = 'N':  The matrix A will be copied to AF and factored.
          = 'E':  The matrix A will be equilibrated if necessary, then

                  copied to AF and factored.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A, except if FACT = 'F' and
          EQUED = 'Y', then A must contain the equilibrated matrix
          diag(S)*A*diag(S).  If UPLO = 'U', the leading
          N-by-N upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading N-by-N lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.  A is not modified if
          FACT = 'F' or 'N', or if FACT = 'E' and EQUED = 'N' on exit.


          On exit, if FACT = 'E' and EQUED = 'Y', A is overwritten by
          diag(S)*A*diag(S).

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  AF      (input or output) DOUBLE PRECISION array, dimension (LDAF,N)

          If FACT = 'F', then AF is an input argument and on entry
          contains the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T, in the same storage
          format as A.  If EQUED .ne. 'N', then AF is the factored form
          of the equilibrated matrix diag(S)*A*diag(S).

          If FACT = 'N', then AF is an output argument and on exit
          returns the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T of the original
          matrix A.

          If FACT = 'E', then AF is an output argument and on exit
          returns the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T of the equilibrated
          matrix A (see the description of A for the form of the
          equilibrated matrix).

  LDAF    (input) INTEGER
          The leading dimension of the array AF.  LDAF >= max(1,N).

  EQUED   (input or output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration (always true if FACT = 'N').
          = 'Y':  Equilibration was done, i.e., A has been replaced by

                  diag(S) * A * diag(S).
          EQUED is an input argument if FACT = 'F'; otherwise, it is an
          output argument.

  S       (input or output) DOUBLE PRECISION array, dimension (N)
          The scale factors for A; not accessed if EQUED = 'N'.  S is
          an input argument if FACT = 'F'; otherwise, S is an output
          argument.  If FACT = 'F' and EQUED = 'Y', each element of S
          must be positive.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if EQUED = 'N', B is not modified; if EQUED = 'Y',
          B is overwritten by diag(S) * B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X to
          the original system of equations.  Note that if EQUED = 'Y',

          A and B are modified on exit, and the solution to the
          equilibrated system is inv(diag(S))*X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The estimate of the reciprocal condition number of the matrix
          A after equilibration (if done).  If RCOND is less than the
          machine precision (in particular, if RCOND = 0), the matrix
          is singular to working precision.  This condition is
          indicated by a return code of INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -i, the i-th argument had an illegal value
          > 0: if INFO = i, and i is
                <= N:  the leading minor of order i of A is
                       not positive definite, so the factorization
                       could not be completed, and the solution has not
                       been computed. RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param af
	 * @param ldaf
	 * @param equed
	 * @param s
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dposvx(String fact, String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOTF2 computes the Cholesky factorization of a real symmetric
  positive definite matrix A.

  The factorization has the form
     A = U' * U ,  if UPLO = 'U', or
     A = L  * L',  if UPLO = 'L',
  where U is an upper triangular matrix and L is lower triangular.

  This is the unblocked version of the algorithm, calling Level 2 BLAS.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the upper or lower triangular part of the
          symmetric matrix A is stored.
          = 'U':  Upper triangular
          = 'L':  Lower triangular

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A.  If UPLO = 'U', the leading
          n by n upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading n by n lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.

          On exit, if INFO = 0, the factor U or L from the Cholesky
          factorization A = U'*U  or A = L*L'.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value
          > 0: if INFO = k, the leading minor of order k is not
               positive definite, and the factorization could not be
               completed.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param info
	 */
	public abstract void dpotf2(String uplo, int n, double[] a, int lda, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOTRF computes the Cholesky factorization of a real symmetric
  positive definite matrix A.

  The factorization has the form
     A = U**T * U,  if UPLO = 'U', or
     A = L  * L**T,  if UPLO = 'L',
  where U is an upper triangular matrix and L is lower triangular.

  This is the block version of the algorithm, calling Level 3 BLAS.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the symmetric matrix A.  If UPLO = 'U', the leading
          N-by-N upper triangular part of A contains the upper
          triangular part of the matrix A, and the strictly lower
          triangular part of A is not referenced.  If UPLO = 'L', the
          leading N-by-N lower triangular part of A contains the lower

          triangular part of the matrix A, and the strictly upper
          triangular part of A is not referenced.

          On exit, if INFO = 0, the factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i is not
                positive definite, and the factorization could not be
                completed.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param info
	 */
	public abstract void dpotrf(String uplo, int n, double[] a, int lda, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOTRI computes the inverse of a real symmetric positive definite
  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
  computed by DPOTRF.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  A       (input/output) DOUBLE PRECISION array, dimension (LDA,N)
          On entry, the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T, as computed by
          DPOTRF.
          On exit, the upper or lower triangle of the (symmetric)
          inverse of A, overwriting the input factor U or L.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the (i,i) element of the factor U or L is

                zero, and the inverse could not be computed.

  =====================================================================

     .. External Functions ..
</pre>
	 * @param uplo
	 * @param n
	 * @param a
	 * @param lda
	 * @param info
	 */
	public abstract void dpotri(String uplo, int n, double[] a, int lda, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPOTRS solves a system of linear equations A*X = B with a symmetric
  positive definite matrix A using the Cholesky factorization
  A = U**T*U or A = L*L**T computed by DPOTRF.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T, as computed by DPOTRF.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side matrix B.
          On exit, the solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dpotrs(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPCON estimates the reciprocal of the condition number (in the
  1-norm) of a real symmetric positive definite packed matrix using
  the Cholesky factorization A = U**T*U or A = L*L**T computed by
  DPPTRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T, packed columnwise in a linear
          array.  The j-th column of U or L is stored in the array AP
          as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.

  ANORM   (input) DOUBLE PRECISION
          The 1-norm (or infinity-norm) of the symmetric matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
          estimate of the 1-norm of inv(A) computed in this routine.

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dppcon(String uplo, int n, double[] ap, double anorm, doubleW rcond, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPEQU computes row and column scalings intended to equilibrate a
  symmetric positive definite matrix A in packed storage and reduce
  its condition number (with respect to the two-norm).  S contains the

  scale factors, S(i)=1/sqrt(A(i,i)), chosen so that the scaled matrix

  B with elements B(i,j)=S(i)*A(i,j)*S(j) has ones on the diagonal.
  This choice of S puts the condition number of B within a factor N of

  the smallest possible condition number over all possible diagonal
  scalings.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The upper or lower triangle of the symmetric matrix A, packed
          columnwise in a linear array.  The j-th column of A is stored
          in the array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.

  S       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, S contains the scale factors for A.

  SCOND   (output) DOUBLE PRECISION
          If INFO = 0, S contains the ratio of the smallest S(i) to
          the largest S(i).  If SCOND >= 0.1 and AMAX is neither too
          large nor too small, it is not worth scaling by S.

  AMAX    (output) DOUBLE PRECISION
          Absolute value of largest matrix element.  If AMAX is very
          close to overflow or very close to underflow, the matrix
          should be scaled.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the i-th diagonal element is nonpositive.


  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param s
	 * @param scond
	 * @param amax
	 * @param info
	 */
	public abstract void dppequ(String uplo, int n, double[] ap, double[] s, doubleW scond, doubleW amax, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPRFS improves the computed solution to a system of linear
  equations when the coefficient matrix is symmetric positive definite

  and packed, and provides error bounds and backward error estimates
  for the solution.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The upper or lower triangle of the symmetric matrix A, packed
          columnwise in a linear array.  The j-th column of A is stored
          in the array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.

  AFP     (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T, as computed by DPPTRF/ZPPTRF,
          packed columnwise in a linear array in the same format as A
          (see AP).

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DPPTRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param ap
	 * @param afp
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dpprfs(String uplo, int n, int nrhs, double[] ap, double[] afp, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPSV computes the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N symmetric positive definite matrix stored in
  packed format and X and B are N-by-NRHS matrices.

  The Cholesky decomposition is used to factor A as
     A = U**T* U,  if UPLO = 'U', or
     A = L * L**T,  if UPLO = 'L',
  where U is an upper triangular matrix and L is a lower triangular
  matrix.  The factored form of A is then used to solve the system of
  equations A * X = B.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  AP      (input/output) DOUBLE PRECISION array, dimension (N*(N+1)/2)

          On entry, the upper or lower triangle of the symmetric matrix
          A, packed columnwise in a linear array.  The j-th column of A
          is stored in the array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.
          See below for further details.

          On exit, if INFO = 0, the factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T, in the same storage
          format as A.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if INFO = 0, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i of A is not
                positive definite, so the factorization could not be
                completed, and the solution has not been computed.

  Further Details
  ===============

  The packed storage scheme is illustrated by the following example
  when N = 4, UPLO = 'U':

  Two-dimensional storage of the symmetric matrix A:

     a11 a12 a13 a14
         a22 a23 a24
             a33 a34     (aij = conjg(aji))
                 a44

  Packed storage of the upper triangle of A:

  AP = [ a11, a12, a22, a13, a23, a33, a14, a24, a34, a44 ]

  =====================================================================

     .. External Functions ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param ap
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dppsv(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPSVX uses the Cholesky factorization A = U**T*U or A = L*L**T to
  compute the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N symmetric positive definite matrix stored in
  packed format and X and B are N-by-NRHS matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed:

  1. If FACT = 'E', real scaling factors are computed to equilibrate
     the system:
        diag(S) * A * diag(S) * inv(diag(S)) * X = diag(S) * B
     Whether or not the system will be equilibrated depends on the
     scaling of the matrix A, but if equilibration is used, A is
     overwritten by diag(S)*A*diag(S) and B by diag(S)*B.

  2. If FACT = 'N' or 'E', the Cholesky decomposition is used to
     factor the matrix A (after equilibration if FACT = 'E') as
        A = U**T* U,  if UPLO = 'U', or
        A = L * L**T,  if UPLO = 'L',
     where U is an upper triangular matrix and L is a lower triangular

     matrix.

  3. If the leading i-by-i principal minor is not positive definite,
     then the routine returns with INFO = i. Otherwise, the factored
     form of A is used to estimate the condition number of the matrix
     A.  If the reciprocal of the condition number is less than machine
     precision, INFO = N+1 is returned as a warning, but the routine
     still goes on to solve for X and compute error bounds as
     described below.

  4. The system of equations is solved for X using the factored form
     of A.

  5. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  6. If equilibration was used, the matrix X is premultiplied by
     diag(S) so that it solves the original system before
     equilibration.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of the matrix A is
          supplied on entry, and if not, whether the matrix A should be
          equilibrated before it is factored.
          = 'F':  On entry, AFP contains the factored form of A.
                  If EQUED = 'Y', the matrix A has been equilibrated
                  with scaling factors given by S.  AP and AFP will not
                  be modified.
          = 'N':  The matrix A will be copied to AFP and factored.
          = 'E':  The matrix A will be equilibrated if necessary, then

                  copied to AFP and factored.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  AP      (input/output) DOUBLE PRECISION array, dimension (N*(N+1)/2)

          On entry, the upper or lower triangle of the symmetric matrix
          A, packed columnwise in a linear array, except if FACT = 'F'

          and EQUED = 'Y', then A must contain the equilibrated matrix

          diag(S)*A*diag(S).  The j-th column of A is stored in the
          array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.
          See below for further details.  A is not modified if
          FACT = 'F' or 'N', or if FACT = 'E' and EQUED = 'N' on exit.


          On exit, if FACT = 'E' and EQUED = 'Y', A is overwritten by
          diag(S)*A*diag(S).

  AFP     (input or output) DOUBLE PRECISION array, dimension
                            (N*(N+1)/2)
          If FACT = 'F', then AFP is an input argument and on entry
          contains the triangular factor U or L from the Cholesky
          factorization A = U'*U or A = L*L', in the same storage
          format as A.  If EQUED .ne. 'N', then AFP is the factored
          form of the equilibrated matrix A.

          If FACT = 'N', then AFP is an output argument and on exit
          returns the triangular factor U or L from the Cholesky
          factorization A = U'*U or A = L*L' of the original matrix A.


          If FACT = 'E', then AFP is an output argument and on exit
          returns the triangular factor U or L from the Cholesky
          factorization A = U'*U or A = L*L' of the equilibrated
          matrix A (see the description of AP for the form of the
          equilibrated matrix).

  EQUED   (input or output) CHARACTER*1
          Specifies the form of equilibration that was done.
          = 'N':  No equilibration (always true if FACT = 'N').
          = 'Y':  Equilibration was done, i.e., A has been replaced by

                  diag(S) * A * diag(S).
          EQUED is an input argument if FACT = 'F'; otherwise, it is an
          output argument.

  S       (input or output) DOUBLE PRECISION array, dimension (N)
          The scale factors for A; not accessed if EQUED = 'N'.  S is
          an input argument if FACT = 'F'; otherwise, S is an output
          argument.  If FACT = 'F' and EQUED = 'Y', each element of S
          must be positive.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if EQUED = 'N', B is not modified; if EQUED = 'Y',
          B is overwritten by diag(S) * B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 or INFO = N+1, the N-by-NRHS solution matrix X to
          the original system of equations.  Note that if EQUED = 'Y',

          A and B are modified on exit, and the solution to the
          equilibrated system is inv(diag(S))*X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The estimate of the reciprocal condition number of the matrix
          A after equilibration (if done).  If RCOND is less than the
          machine precision (in particular, if RCOND = 0), the matrix
          is singular to working precision.  This condition is
          indicated by a return code of INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The estimated forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).  The estimate is as reliable as
          the estimate for RCOND, and is almost always a slight
          overestimate of the true error.

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  IWORK   (workspace) INTEGER array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= N:  the leading minor of order i of A is
                       not positive definite, so the factorization
                       could not be completed, and the solution has not
                       been computed. RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  Further Details
  ===============

  The packed storage scheme is illustrated by the following example
  when N = 4, UPLO = 'U':

  Two-dimensional storage of the symmetric matrix A:

     a11 a12 a13 a14
         a22 a23 a24
             a33 a34     (aij = conjg(aji))
                 a44

  Packed storage of the upper triangle of A:

  AP = [ a11, a12, a22, a13, a23, a33, a14, a24, a34, a44 ]

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param ap
	 * @param afp
	 * @param equed
	 * @param s
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param iwork
	 * @param info
	 */
	public abstract void dppsvx(String fact, String uplo, int n, int nrhs, double[] ap, double[] afp, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPTRF computes the Cholesky factorization of a real symmetric
  positive definite matrix A stored in packed format.

  The factorization has the form
     A = U**T * U,  if UPLO = 'U', or
     A = L  * L**T,  if UPLO = 'L',
  where U is an upper triangular matrix and L is lower triangular.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input/output) DOUBLE PRECISION array, dimension (N*(N+1)/2)

          On entry, the upper or lower triangle of the symmetric matrix
          A, packed columnwise in a linear array.  The j-th column of A
          is stored in the array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = A(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = A(i,j) for j<=i<=n.
          See below for further details.

          On exit, if INFO = 0, the triangular factor U or L from the
          Cholesky factorization A = U**T*U or A = L*L**T, in the same

          storage format as A.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i is not
                positive definite, and the factorization could not be
                completed.

  Further Details
  ======= =======

  The packed storage scheme is illustrated by the following example
  when N = 4, UPLO = 'U':

  Two-dimensional storage of the symmetric matrix A:

     a11 a12 a13 a14
         a22 a23 a24
             a33 a34     (aij = aji)
                 a44

  Packed storage of the upper triangle of A:

  AP = [ a11, a12, a22, a13, a23, a33, a14, a24, a34, a44 ]

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param info
	 */
	public abstract void dpptrf(String uplo, int n, double[] ap, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPTRI computes the inverse of a real symmetric positive definite
  matrix A using the Cholesky factorization A = U**T*U or A = L*L**T
  computed by DPPTRF.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangular factor is stored in AP;
          = 'L':  Lower triangular factor is stored in AP.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input/output) DOUBLE PRECISION array, dimension (N*(N+1)/2)

          On entry, the triangular factor U or L from the Cholesky
          factorization A = U**T*U or A = L*L**T, packed columnwise as

          a linear array.  The j-th column of U or L is stored in the
          array AP as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.

          On exit, the upper or lower triangle of the (symmetric)
          inverse of A, overwriting the input factor U or L.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the (i,i) element of the factor U or L is

                zero, and the inverse could not be computed.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param uplo
	 * @param n
	 * @param ap
	 * @param info
	 */
	public abstract void dpptri(String uplo, int n, double[] ap, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPPTRS solves a system of linear equations A*X = B with a symmetric
  positive definite matrix A in packed storage using the Cholesky
  factorization A = U**T*U or A = L*L**T computed by DPPTRF.

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The triangular factor U or L from the Cholesky factorization

          A = U**T*U or A = L*L**T, packed columnwise in a linear
          array.  The j-th column of U or L is stored in the array AP
          as follows:
          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side matrix B.
          On exit, the solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param uplo
	 * @param n
	 * @param nrhs
	 * @param ap
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dpptrs(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTCON computes the reciprocal of the condition number (in the
  1-norm) of a real symmetric positive definite tridiagonal matrix
  using the factorization A = L*D*L**T or A = U**T*D*U computed by
  DPTTRF.

  Norm(inv(A)) is computed by a direct method, and the reciprocal of
  the condition number is computed as
               RCOND = 1 / (ANORM * norm(inv(A))).

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the diagonal matrix D from the
          factorization of A, as computed by DPTTRF.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) off-diagonal elements of the unit bidiagonal factor
          U or L from the factorization of A,  as computed by DPTTRF.

  ANORM   (input) DOUBLE PRECISION
          The 1-norm of the original matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is the
          1-norm of inv(A) computed in this routine.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  The method used is described in Nicholas J. Higham, "Efficient
  Algorithms for Computing the Condition Number of a Tridiagonal
  Matrix", SIAM J. Sci. Stat. Comput., Vol. 7, No. 1, January 1986.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param e
	 * @param anorm
	 * @param rcond
	 * @param work
	 * @param info
	 */
	public abstract void dptcon(int n, double[] d, double[] e, double anorm, doubleW rcond, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTEQR computes all eigenvalues and, optionally, eigenvectors of a
  symmetric positive definite tridiagonal matrix by first factoring the
  matrix using DPTTRF, and then calling DBDSQR to compute the singular

  values of the bidiagonal factor.

  This routine computes the eigenvalues of the positive definite
  tridiagonal matrix to high relative accuracy.  This means that if the
  eigenvalues range over many orders of magnitude in size, then the
  small eigenvalues and corresponding eigenvectors will be computed
  more accurately than, for example, with the standard QR method.

  The eigenvectors of a full or band symmetric positive definite matrix
  can also be found if DSYTRD, DSPTRD, or DSBTRD has been used to
  reduce this matrix to tridiagonal form. (The reduction to tridiagonal
  form, however, may preclude the possibility of obtaining high
  relative accuracy in the small eigenvalues of the original matrix, if
  these eigenvalues range over many orders of magnitude.)

  Arguments
  =========

  COMPZ   (input) CHARACTER*1
          = 'N':  Compute eigenvalues only.
          = 'V':  Compute eigenvectors of original symmetric
                  matrix also.  Array Z contains the orthogonal
                  matrix used to reduce the original matrix to
                  tridiagonal form.
          = 'I':  Compute eigenvectors of tridiagonal matrix also.

  N       (input) INTEGER
          The order of the matrix.  N >= 0.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the n diagonal elements of the tridiagonal
          matrix.
          On normal exit, D contains the eigenvalues, in descending
          order.

  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, the (n-1) subdiagonal elements of the tridiagonal
          matrix.
          On exit, E has been destroyed.

  Z       (input/output) DOUBLE PRECISION array, dimension (LDZ, N)
          On entry, if COMPZ = 'V', the orthogonal matrix used in the
          reduction to tridiagonal form.
          On exit, if COMPZ = 'V', the orthonormal eigenvectors of the

          original symmetric matrix;
          if COMPZ = 'I', the orthonormal eigenvectors of the
          tridiagonal matrix.
          If INFO > 0 on exit, Z contains the eigenvectors associated
          with only the stored eigenvalues.
          If  COMPZ = 'N', then Z is not referenced.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          COMPZ = 'V' or 'I', LDZ >= max(1,N).

  WORK    (workspace) DOUBLE PRECISION array, dimension (4*N)

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = i, and i is:
                <= N  the Cholesky factorization of the matrix could
                      not be performed because the i-th principal minor
                      was not positive definite.
                > N   the SVD algorithm failed to converge;
                      if INFO = N+i, i off-diagonal elements of the
                      bidiagonal factor did not converge to zero.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param compz
	 * @param n
	 * @param d
	 * @param e
	 * @param z
	 * @param ldz
	 * @param work
	 * @param info
	 */
	public abstract void dpteqr(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTRFS improves the computed solution to a system of linear
  equations when the coefficient matrix is symmetric positive definite

  and tridiagonal, and provides error bounds and backward error
  estimates for the solution.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the tridiagonal matrix A.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of the tridiagonal matrix A.

  DF      (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the diagonal matrix D from the
          factorization computed by DPTTRF.

  EF      (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of the unit bidiagonal factor

          L from the factorization computed by DPTTRF.

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (input/output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          On entry, the solution matrix X, as computed by DPTTRS.
          On exit, the improved solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in
          any element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Internal Parameters
  ===================

  ITMAX is the maximum number of steps of iterative refinement.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param d
	 * @param e
	 * @param df
	 * @param ef
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param info
	 */
	public abstract void dptrfs(int n, int nrhs, double[] d, double[] e, double[] df, double[] ef, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTSV computes the solution to a real system of linear equations
  A*X = B, where A is an N-by-N symmetric positive definite tridiagonal
  matrix, and X and B are N-by-NRHS matrices.

  A is factored as A = L*D*L**T, and the factored form of A is then
  used to solve the system of equations.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the n diagonal elements of the tridiagonal matrix
          A.  On exit, the n diagonal elements of the diagonal matrix
          D from the factorization A = L*D*L**T.

  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, the (n-1) subdiagonal elements of the tridiagonal
          matrix A.  On exit, the (n-1) subdiagonal elements of the
          unit bidiagonal factor L from the L*D*L**T factorization of
          A.  (E can also be regarded as the superdiagonal of the unit

          bidiagonal factor U from the U**T*D*U factorization of A.)

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the N-by-NRHS right hand side matrix B.
          On exit, if INFO = 0, the N-by-NRHS solution matrix X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the leading minor of order i is not
                positive definite, and the solution has not been
                computed.  The factorization has not been completed
                unless i = N.

  =====================================================================

     .. External Subroutines ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param d
	 * @param e
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dptsv(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTSVX uses the factorization A = L*D*L**T to compute the solution
  to a real system of linear equations A*X = B, where A is an N-by-N
  symmetric positive definite tridiagonal matrix and X and B are
  N-by-NRHS matrices.

  Error bounds on the solution and a condition estimate are also
  provided.

  Description
  ===========

  The following steps are performed:

  1. If FACT = 'N', the matrix A is factored as A = L*D*L**T, where L
     is a unit lower bidiagonal matrix and D is diagonal.  The
     factorization can also be regarded as having the form
     A = U**T*D*U.

  2. If the leading i-by-i principal minor is not positive definite,
     then the routine returns with INFO = i. Otherwise, the factored
     form of A is used to estimate the condition number of the matrix
     A.  If the reciprocal of the condition number is less than machine
     precision, INFO = N+1 is returned as a warning, but the routine
     still goes on to solve for X and compute error bounds as
     described below.

  3. The system of equations is solved for X using the factored form
     of A.

  4. Iterative refinement is applied to improve the computed solution
     matrix and calculate error bounds and backward error estimates
     for it.

  Arguments
  =========

  FACT    (input) CHARACTER*1
          Specifies whether or not the factored form of A has been
          supplied on entry.
          = 'F':  On entry, DF and EF contain the factored form of A.
                  D, E, DF, and EF will not be modified.
          = 'N':  The matrix A will be copied to DF and EF and
                  factored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrices B and X.  NRHS >= 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the tridiagonal matrix A.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of the tridiagonal matrix A.

  DF      (input or output) DOUBLE PRECISION array, dimension (N)
          If FACT = 'F', then DF is an input argument and on entry
          contains the n diagonal elements of the diagonal matrix D
          from the L*D*L**T factorization of A.
          If FACT = 'N', then DF is an output argument and on exit
          contains the n diagonal elements of the diagonal matrix D
          from the L*D*L**T factorization of A.

  EF      (input or output) DOUBLE PRECISION array, dimension (N-1)
          If FACT = 'F', then EF is an input argument and on entry
          contains the (n-1) subdiagonal elements of the unit
          bidiagonal factor L from the L*D*L**T factorization of A.
          If FACT = 'N', then EF is an output argument and on exit
          contains the (n-1) subdiagonal elements of the unit
          bidiagonal factor L from the L*D*L**T factorization of A.

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The N-by-NRHS right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0 of INFO = N+1, the N-by-NRHS solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  RCOND   (output) DOUBLE PRECISION
          The reciprocal condition number of the matrix A.  If RCOND
          is less than the machine precision (in particular, if
          RCOND = 0), the matrix is singular to working precision.
          This condition is indicated by a return code of INFO > 0.

  FERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The forward error bound for each solution vector
          X(j) (the j-th column of the solution matrix X).
          If XTRUE is the true solution corresponding to X(j), FERR(j)

          is an estimated upper bound for the magnitude of the largest

          element in (X(j) - XTRUE) divided by the magnitude of the
          largest element in X(j).

  BERR    (output) DOUBLE PRECISION array, dimension (NRHS)
          The componentwise relative backward error of each solution
          vector X(j) (i.e., the smallest relative change in any
          element of A or B that makes X(j) an exact solution).

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is
                <= N:  the leading minor of order i of A is
                       not positive definite, so the factorization
                       could not be completed, and the solution has not
                       been computed. RCOND = 0 is returned.
                = N+1: U is nonsingular, but RCOND is less than machine
                       precision, meaning that the matrix is singular
                       to working precision.  Nevertheless, the
                       solution and error bounds are computed because
                       there are a number of situations where the
                       computed solution can be more accurate than the

                       value of RCOND would suggest.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param fact
	 * @param n
	 * @param nrhs
	 * @param d
	 * @param e
	 * @param df
	 * @param ef
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param rcond
	 * @param ferr
	 * @param berr
	 * @param work
	 * @param info
	 */
	public abstract void dptsvx(String fact, int n, int nrhs, double[] d, double[] e, double[] df, double[] ef, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTTRF computes the L*D*L' factorization of a real symmetric
  positive definite tridiagonal matrix A.  The factorization may also
  be regarded as having the form A = U'*D*U.

  Arguments
  =========

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  D       (input/output) DOUBLE PRECISION array, dimension (N)
          On entry, the n diagonal elements of the tridiagonal matrix
          A.  On exit, the n diagonal elements of the diagonal matrix
          D from the L*D*L' factorization of A.

  E       (input/output) DOUBLE PRECISION array, dimension (N-1)
          On entry, the (n-1) subdiagonal elements of the tridiagonal
          matrix A.  On exit, the (n-1) subdiagonal elements of the
          unit bidiagonal factor L from the L*D*L' factorization of A.

          E can also be regarded as the superdiagonal of the unit
          bidiagonal factor U from the U'*D*U factorization of A.

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value
          > 0: if INFO = k, the leading minor of order k is not
               positive definite; if k < N, the factorization could not
               be completed, while if k = N, the factorization was
               completed, but D(N) <= 0.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param n
	 * @param d
	 * @param e
	 * @param info
	 */
	public abstract void dpttrf(int n, double[] d, double[] e, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTTRS solves a tridiagonal system of the form
     A * X = B
  using the L*D*L' factorization of A computed by DPTTRF.  D is a
  diagonal matrix specified in the vector D, L is a unit bidiagonal
  matrix whose subdiagonal is specified in the vector E, and X and B
  are N by NRHS matrices.

  Arguments
  =========

  N       (input) INTEGER
          The order of the tridiagonal matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the diagonal matrix D from the
          L*D*L' factorization of A.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of the unit bidiagonal factor

          L from the L*D*L' factorization of A.  E can also be regarded
          as the superdiagonal of the unit bidiagonal factor U from the
          factorization A = U'*D*U.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side vectors B for the system of
          linear equations.
          On exit, the solution vectors, X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  INFO    (output) INTEGER
          = 0: successful exit
          < 0: if INFO = -k, the k-th argument had an illegal value

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param d
	 * @param e
	 * @param b
	 * @param ldb
	 * @param info
	 */
	public abstract void dpttrs(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DPTTS2 solves a tridiagonal system of the form
     A * X = B
  using the L*D*L' factorization of A computed by DPTTRF.  D is a
  diagonal matrix specified in the vector D, L is a unit bidiagonal
  matrix whose subdiagonal is specified in the vector E, and X and B
  are N by NRHS matrices.

  Arguments
  =========

  N       (input) INTEGER
          The order of the tridiagonal matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  D       (input) DOUBLE PRECISION array, dimension (N)
          The n diagonal elements of the diagonal matrix D from the
          L*D*L' factorization of A.

  E       (input) DOUBLE PRECISION array, dimension (N-1)
          The (n-1) subdiagonal elements of the unit bidiagonal factor

          L from the L*D*L' factorization of A.  E can also be regarded
          as the superdiagonal of the unit bidiagonal factor U from the
          factorization A = U'*D*U.

  B       (input/output) DOUBLE PRECISION array, dimension (LDB,NRHS)
          On entry, the right hand side vectors B for the system of
          linear equations.
          On exit, the solution vectors, X.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param d
	 * @param e
	 * @param b
	 * @param ldb
	 */
	public abstract void dptts2(int n, int nrhs, double[] d, double[] e, double[] b, int ldb);

	/**
<pre>

     ..

  Purpose
  =======

  DRSCL multiplies an n-element real vector x by the real scalar 1/a.
  This is done without overflow or underflow as long as
  the final result x/a does not overflow or underflow.

  Arguments
  =========

  N       (input) INTEGER
          The number of components of the vector x.

  SA      (input) DOUBLE PRECISION
          The scalar a which is used to divide each component of x.
          SA must be >= 0, or the subroutine will divide by zero.

  SX      (input/output) DOUBLE PRECISION array, dimension
                         (1+(N-1)*abs(INCX))
          The n-element vector x.

  INCX    (input) INTEGER
          The increment between successive values of the vector SX.
          > 0:  SX(1) = X(1) and SX(1+(i-1)*INCX) = x(i),     1< i<= n


 =====================================================================


     .. Parameters ..
</pre>
	 * @param n
	 * @param sa
	 * @param sx
	 * @param incx
	 */
	public abstract void drscl(int n, double sa, double[] sx, int incx);

	/**
<pre>

     ..

  Purpose
  =======

  DSBEV computes all the eigenvalues and, optionally, eigenvectors of
  a real symmetric band matrix A.

  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          = 'N':  Compute eigenvalues only;
          = 'V':  Compute eigenvalues and eigenvectors.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, AB is overwritten by values generated during the
          reduction to tridiagonal form.  If UPLO = 'U', the first
          superdiagonal and the diagonal of the tridiagonal matrix T
          are returned in rows KD and KD+1 of AB, and if UPLO = 'L',
          the diagonal and first subdiagonal of T are returned in the
          first two rows of AB.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD + 1.

  W       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, the eigenvalues in ascending order.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, N)
          If JOBZ = 'V', then if INFO = 0, Z contains the orthonormal
          eigenvectors of the matrix A, with the i-th column of Z
          holding the eigenvector associated with W(i).
          If JOBZ = 'N', then Z is not referenced.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= max(1,N).

  WORK    (workspace) DOUBLE PRECISION array, dimension (max(1,3*N-2))


  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the algorithm failed to converge; i
                off-diagonal elements of an intermediate tridiagonal
                form did not converge to zero.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobz
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param w
	 * @param z
	 * @param ldz
	 * @param work
	 * @param info
	 */
	public abstract void dsbev(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBEVD computes all the eigenvalues and, optionally, eigenvectors of

  a real symmetric band matrix A. If eigenvectors are desired, it uses

  a divide and conquer algorithm.

  The divide and conquer algorithm makes very mild assumptions about
  floating point arithmetic. It will work on machines with a guard
  digit in add/subtract, or on those binary machines without guard
  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
  Cray-2. It could conceivably fail on hexadecimal or decimal machines

  without guard digits, but we know of none.

  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          = 'N':  Compute eigenvalues only;
          = 'V':  Compute eigenvalues and eigenvectors.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, AB is overwritten by values generated during the
          reduction to tridiagonal form.  If UPLO = 'U', the first
          superdiagonal and the diagonal of the tridiagonal matrix T
          are returned in rows KD and KD+1 of AB, and if UPLO = 'L',
          the diagonal and first subdiagonal of T are returned in the
          first two rows of AB.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD + 1.

  W       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, the eigenvalues in ascending order.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, N)
          If JOBZ = 'V', then if INFO = 0, Z contains the orthonormal
          eigenvectors of the matrix A, with the i-th column of Z
          holding the eigenvector associated with W(i).
          If JOBZ = 'N', then Z is not referenced.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= max(1,N).

  WORK    (workspace/output) DOUBLE PRECISION array,
                                         dimension (LWORK)
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          IF N <= 1,                LWORK must be at least 1.
          If JOBZ  = 'N' and N > 2, LWORK must be at least 2*N.
          If JOBZ  = 'V' and N > 2, LWORK must be at least
                         ( 1 + 5*N + 2*N**2 ).

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal sizes of the WORK and IWORK
          arrays, returns these values as the first entries of the WORK
          and IWORK arrays, and no error message related to LWORK or
          LIWORK is issued by XERBLA.

  IWORK   (workspace/output) INTEGER array, dimension (MAX(1,LIWORK))
          On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.

  LIWORK  (input) INTEGER
          The dimension of the array LIWORK.
          If JOBZ  = 'N' or N <= 1, LIWORK must be at least 1.
          If JOBZ  = 'V' and N > 2, LIWORK must be at least 3 + 5*N.

          If LIWORK = -1, then a workspace query is assumed; the
          routine only calculates the optimal sizes of the WORK and
          IWORK arrays, returns these values as the first entries of
          the WORK and IWORK arrays, and no error message related to
          LWORK or LIWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, the algorithm failed to converge; i
                off-diagonal elements of an intermediate tridiagonal
                form did not converge to zero.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobz
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param w
	 * @param z
	 * @param ldz
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param liwork
	 * @param info
	 */
	public abstract void dsbevd(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBEVX computes selected eigenvalues and, optionally, eigenvectors
  of a real symmetric band matrix A.  Eigenvalues and eigenvectors can

  be selected by specifying either a range of values or a range of
  indices for the desired eigenvalues.

  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          = 'N':  Compute eigenvalues only;
          = 'V':  Compute eigenvalues and eigenvectors.

  RANGE   (input) CHARACTER*1
          = 'A': all eigenvalues will be found;
          = 'V': all eigenvalues in the half-open interval (VL,VU]
                 will be found;
          = 'I': the IL-th through IU-th eigenvalues will be found.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).

          On exit, AB is overwritten by values generated during the
          reduction to tridiagonal form.  If UPLO = 'U', the first
          superdiagonal and the diagonal of the tridiagonal matrix T
          are returned in rows KD and KD+1 of AB, and if UPLO = 'L',
          the diagonal and first subdiagonal of T are returned in the
          first two rows of AB.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD + 1.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ, N)
          If JOBZ = 'V', the N-by-N orthogonal matrix used in the
                         reduction to tridiagonal form.
          If JOBZ = 'N', the array Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.  If JOBZ = 'V', then
          LDQ >= max(1,N).

  VL      (input) DOUBLE PRECISION
  VU      (input) DOUBLE PRECISION
          If RANGE='V', the lower and upper bounds of the interval to
          be searched for eigenvalues. VL < VU.
          Not referenced if RANGE = 'A' or 'I'.

  IL      (input) INTEGER
  IU      (input) INTEGER
          If RANGE='I', the indices (in ascending order) of the
          smallest and largest eigenvalues to be returned.
          1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.
          Not referenced if RANGE = 'A' or 'V'.

  ABSTOL  (input) DOUBLE PRECISION
          The absolute error tolerance for the eigenvalues.
          An approximate eigenvalue is accepted as converged
          when it is determined to lie in an interval [a,b]
          of width less than or equal to

                  ABSTOL + EPS *   max( |a|,|b| ) ,

          where EPS is the machine precision.  If ABSTOL is less than
          or equal to zero, then  EPS*|T|  will be used in its place,
          where |T| is the 1-norm of the tridiagonal matrix obtained
          by reducing AB to tridiagonal form.

          Eigenvalues will be computed most accurately when ABSTOL is
          set to twice the underflow threshold 2*DLAMCH('S'), not zero.
          If this routine returns with INFO>0, indicating that some
          eigenvectors did not converge, try setting ABSTOL to
          2*DLAMCH('S').

          See "Computing Small Singular Values of Bidiagonal Matrices
          with Guaranteed High Relative Accuracy," by Demmel and
          Kahan, LAPACK Working Note #3.

  M       (output) INTEGER
          The total number of eigenvalues found.  0 <= M <= N.
          If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1.

  W       (output) DOUBLE PRECISION array, dimension (N)
          The first M elements contain the selected eigenvalues in
          ascending order.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, max(1,M))
          If JOBZ = 'V', then if INFO = 0, the first M columns of Z
          contain the orthonormal eigenvectors of the matrix A
          corresponding to the selected eigenvalues, with the i-th
          column of Z holding the eigenvector associated with W(i).
          If an eigenvector fails to converge, then that column of Z
          contains the latest approximation to the eigenvector, and the
          index of the eigenvector is returned in IFAIL.
          If JOBZ = 'N', then Z is not referenced.
          Note: the user must ensure that at least max(1,M) columns are
          supplied in the array Z; if RANGE = 'V', the exact value of M
          is not known in advance and an upper bound must be used.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= max(1,N).

  WORK    (workspace) DOUBLE PRECISION array, dimension (7*N)

  IWORK   (workspace) INTEGER array, dimension (5*N)

  IFAIL   (output) INTEGER array, dimension (N)
          If JOBZ = 'V', then if INFO = 0, the first M elements of
          IFAIL are zero.  If INFO > 0, then IFAIL contains the
          indices of the eigenvectors that failed to converge.
          If JOBZ = 'N', then IFAIL is not referenced.

  INFO    (output) INTEGER
          = 0:  successful exit.
          < 0:  if INFO = -i, the i-th argument had an illegal value.
          > 0:  if INFO = i, then i eigenvectors failed to converge.
                Their indices are stored in array IFAIL.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobz
	 * @param range
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param q
	 * @param ldq
	 * @param vl
	 * @param vu
	 * @param il
	 * @param iu
	 * @param abstol
	 * @param m
	 * @param w
	 * @param z
	 * @param ldz
	 * @param work
	 * @param iwork
	 * @param ifail
	 * @param info
	 */
	public abstract void dsbevx(String jobz, String range, String uplo, int n, int kd, double[] ab, int ldab, double[] q, int ldq, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBGST reduces a real symmetric-definite banded generalized
  eigenproblem  A*x = lambda*B*x  to standard form  C*y = lambda*y,
  such that C has the same bandwidth as A.

  B must have been previously factorized as S**T*S by DPBSTF, using a
  split Cholesky factorization. A is overwritten by C = X**T*A*X, where
  X = S**(-1)*Q and Q is an orthogonal matrix chosen to preserve the
  bandwidth of A.

  Arguments
  =========

  VECT    (input) CHARACTER*1
          = 'N':  do not form the transformation matrix X;
          = 'V':  form X.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrices A and B.  N >= 0.

  KA      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KA >= 0.

  KB      (input) INTEGER
          The number of superdiagonals of the matrix B if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KA >= KB >= 0.


  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first ka+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(ka+1+i-j,j) = A(i,j) for max(1,j-ka)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+ka).

          On exit, the transformed matrix X**T*A*X, stored in the same

          format as A.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KA+1.

  BB      (input) DOUBLE PRECISION array, dimension (LDBB,N)
          The banded factor S from the split Cholesky factorization of

          B, as returned by DPBSTF, stored in the first KB+1 rows of
          the array.

  LDBB    (input) INTEGER
          The leading dimension of the array BB.  LDBB >= KB+1.

  X       (output) DOUBLE PRECISION array, dimension (LDX,N)
          If VECT = 'V', the n-by-n matrix X.
          If VECT = 'N', the array X is not referenced.

  LDX     (input) INTEGER
          The leading dimension of the array X.
          LDX >= max(1,N) if VECT = 'V'; LDX >= 1 otherwise.

  WORK    (workspace) DOUBLE PRECISION array, dimension (2*N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param vect
	 * @param uplo
	 * @param n
	 * @param ka
	 * @param kb
	 * @param ab
	 * @param ldab
	 * @param bb
	 * @param ldbb
	 * @param x
	 * @param ldx
	 * @param work
	 * @param info
	 */
	public abstract void dsbgst(String vect, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] x, int ldx, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBGV computes all the eigenvalues, and optionally, the eigenvectors

  of a real generalized symmetric-definite banded eigenproblem, of
  the form A*x=(lambda)*B*x. Here A and B are assumed to be symmetric
  and banded, and B is also positive definite.

  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          = 'N':  Compute eigenvalues only;
          = 'V':  Compute eigenvalues and eigenvectors.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangles of A and B are stored;
          = 'L':  Lower triangles of A and B are stored.

  N       (input) INTEGER
          The order of the matrices A and B.  N >= 0.

  KA      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'. KA >= 0.

  KB      (input) INTEGER
          The number of superdiagonals of the matrix B if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'. KB >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first ka+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(ka+1+i-j,j) = A(i,j) for max(1,j-ka)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+ka).

          On exit, the contents of AB are destroyed.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KA+1.

  BB      (input/output) DOUBLE PRECISION array, dimension (LDBB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix B, stored in the first kb+1 rows of the array.  The
          j-th column of B is stored in the j-th column of the array BB
          as follows:
          if UPLO = 'U', BB(kb+1+i-j,j) = B(i,j) for max(1,j-kb)<=i<=j;
          if UPLO = 'L', BB(1+i-j,j)    = B(i,j) for j<=i<=min(n,j+kb).

          On exit, the factor S from the split Cholesky factorization
          B = S**T*S, as returned by DPBSTF.

  LDBB    (input) INTEGER
          The leading dimension of the array BB.  LDBB >= KB+1.

  W       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, the eigenvalues in ascending order.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, N)
          If JOBZ = 'V', then if INFO = 0, Z contains the matrix Z of
          eigenvectors, with the i-th column of Z holding the
          eigenvector associated with W(i). The eigenvectors are
          normalized so that Z**T*B*Z = I.
          If JOBZ = 'N', then Z is not referenced.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= N.

  WORK    (workspace) DOUBLE PRECISION array, dimension (3*N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is:
             <= N:  the algorithm failed to converge:
                    i off-diagonal elements of an intermediate
                    tridiagonal form did not converge to zero;
             > N:   if INFO = N + i, for 1 <= i <= N, then DPBSTF
                    returned INFO = i: B is not positive definite.
                    The factorization of B could not be completed and
                    no eigenvalues or eigenvectors were computed.

  =====================================================================

     .. Local Scalars ..
</pre>
	 * @param jobz
	 * @param uplo
	 * @param n
	 * @param ka
	 * @param kb
	 * @param ab
	 * @param ldab
	 * @param bb
	 * @param ldbb
	 * @param w
	 * @param z
	 * @param ldz
	 * @param work
	 * @param info
	 */
	public abstract void dsbgv(String jobz, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] w, double[] z, int ldz, double[] work, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBGVD computes all the eigenvalues, and optionally, the eigenvectors
  of a real generalized symmetric-definite banded eigenproblem, of the

  form A*x=(lambda)*B*x.  Here A and B are assumed to be symmetric and

  banded, and B is also positive definite.  If eigenvectors are
  desired, it uses a divide and conquer algorithm.

  The divide and conquer algorithm makes very mild assumptions about
  floating point arithmetic. It will work on machines with a guard
  digit in add/subtract, or on those binary machines without guard
  digits which subtract like the Cray X-MP, Cray Y-MP, Cray C-90, or
  Cray-2. It could conceivably fail on hexadecimal or decimal machines

  without guard digits, but we know of none.

  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          = 'N':  Compute eigenvalues only;
          = 'V':  Compute eigenvalues and eigenvectors.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangles of A and B are stored;
          = 'L':  Lower triangles of A and B are stored.

  N       (input) INTEGER
          The order of the matrices A and B.  N >= 0.

  KA      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KA >= 0.

  KB      (input) INTEGER
          The number of superdiagonals of the matrix B if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KB >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first ka+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(ka+1+i-j,j) = A(i,j) for max(1,j-ka)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+ka).

          On exit, the contents of AB are destroyed.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KA+1.

  BB      (input/output) DOUBLE PRECISION array, dimension (LDBB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix B, stored in the first kb+1 rows of the array.  The
          j-th column of B is stored in the j-th column of the array BB
          as follows:
          if UPLO = 'U', BB(ka+1+i-j,j) = B(i,j) for max(1,j-kb)<=i<=j;
          if UPLO = 'L', BB(1+i-j,j)    = B(i,j) for j<=i<=min(n,j+kb).

          On exit, the factor S from the split Cholesky factorization
          B = S**T*S, as returned by DPBSTF.

  LDBB    (input) INTEGER
          The leading dimension of the array BB.  LDBB >= KB+1.

  W       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, the eigenvalues in ascending order.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, N)
          If JOBZ = 'V', then if INFO = 0, Z contains the matrix Z of
          eigenvectors, with the i-th column of Z holding the
          eigenvector associated with W(i).  The eigenvectors are
          normalized so Z**T*B*Z = I.
          If JOBZ = 'N', then Z is not referenced.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= max(1,N).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (MAX(1,L
          On exit, if INFO = 0, WORK(1) returns the optimal LWORK.

  LWORK   (input) INTEGER
          The dimension of the array WORK.
          If N <= 1,               LWORK >= 1.
          If JOBZ = 'N' and N > 1, LWORK >= 3*N.
          If JOBZ = 'V' and N > 1, LWORK >= 1 + 5*N + 2*N**2.

          If LWORK = -1, then a workspace query is assumed; the routine
          only calculates the optimal sizes of the WORK and IWORK
          arrays, returns these values as the first entries of the WORK
          and IWORK arrays, and no error message related to LWORK or
          LIWORK is issued by XERBLA.

  IWORK   (workspace/output) INTEGER array, dimension (MAX(1,LIWORK))
          On exit, if LIWORK > 0, IWORK(1) returns the optimal LIWORK.


  LIWORK  (input) INTEGER
          The dimension of the array IWORK.
          If JOBZ  = 'N' or N <= 1, LIWORK >= 1.
          If JOBZ  = 'V' and N > 1, LIWORK >= 3 + 5*N.

          If LIWORK = -1, then a workspace query is assumed; the
          routine only calculates the optimal sizes of the WORK and
          IWORK arrays, returns these values as the first entries of
          the WORK and IWORK arrays, and no error message related to
          LWORK or LIWORK is issued by XERBLA.

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, and i is:
             <= N:  the algorithm failed to converge:
                    i off-diagonal elements of an intermediate
                    tridiagonal form did not converge to zero;
             > N:   if INFO = N + i, for 1 <= i <= N, then DPBSTF
                    returned INFO = i: B is not positive definite.
                    The factorization of B could not be completed and
                    no eigenvalues or eigenvectors were computed.

  Further Details
  ===============

  Based on contributions by
     Mark Fahey, Department of Mathematics, Univ. of Kentucky, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobz
	 * @param uplo
	 * @param n
	 * @param ka
	 * @param kb
	 * @param ab
	 * @param ldab
	 * @param bb
	 * @param ldbb
	 * @param w
	 * @param z
	 * @param ldz
	 * @param work
	 * @param lwork
	 * @param iwork
	 * @param liwork
	 * @param info
	 */
	public abstract void dsbgvd(String jobz, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBGVX computes selected eigenvalues, and optionally, eigenvectors
  of a real generalized symmetric-definite banded eigenproblem, of
  the form A*x=(lambda)*B*x.  Here A and B are assumed to be symmetric

  and banded, and B is also positive definite.  Eigenvalues and
  eigenvectors can be selected by specifying either all eigenvalues,
  a range of values or a range of indices for the desired eigenvalues.


  Arguments
  =========

  JOBZ    (input) CHARACTER*1
          = 'N':  Compute eigenvalues only;
          = 'V':  Compute eigenvalues and eigenvectors.

  RANGE   (input) CHARACTER*1
          = 'A': all eigenvalues will be found.
          = 'V': all eigenvalues in the half-open interval (VL,VU]
                 will be found.
          = 'I': the IL-th through IU-th eigenvalues will be found.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangles of A and B are stored;
          = 'L':  Lower triangles of A and B are stored.

  N       (input) INTEGER
          The order of the matrices A and B.  N >= 0.

  KA      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KA >= 0.

  KB      (input) INTEGER
          The number of superdiagonals of the matrix B if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KB >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first ka+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(ka+1+i-j,j) = A(i,j) for max(1,j-ka)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+ka).

          On exit, the contents of AB are destroyed.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KA+1.

  BB      (input/output) DOUBLE PRECISION array, dimension (LDBB, N)
          On entry, the upper or lower triangle of the symmetric band
          matrix B, stored in the first kb+1 rows of the array.  The
          j-th column of B is stored in the j-th column of the array BB
          as follows:
          if UPLO = 'U', BB(ka+1+i-j,j) = B(i,j) for max(1,j-kb)<=i<=j;
          if UPLO = 'L', BB(1+i-j,j)    = B(i,j) for j<=i<=min(n,j+kb).

          On exit, the factor S from the split Cholesky factorization
          B = S**T*S, as returned by DPBSTF.

  LDBB    (input) INTEGER
          The leading dimension of the array BB.  LDBB >= KB+1.

  Q       (output) DOUBLE PRECISION array, dimension (LDQ, N)
          If JOBZ = 'V', the n-by-n matrix used in the reduction of
          A*x = (lambda)*B*x to standard form, i.e. C*x = (lambda)*x,
          and consequently C to tridiagonal form.
          If JOBZ = 'N', the array Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.  If JOBZ = 'N',
          LDQ >= 1. If JOBZ = 'V', LDQ >= max(1,N).

  VL      (input) DOUBLE PRECISION
  VU      (input) DOUBLE PRECISION
          If RANGE='V', the lower and upper bounds of the interval to
          be searched for eigenvalues. VL < VU.
          Not referenced if RANGE = 'A' or 'I'.

  IL      (input) INTEGER
  IU      (input) INTEGER
          If RANGE='I', the indices (in ascending order) of the
          smallest and largest eigenvalues to be returned.
          1 <= IL <= IU <= N, if N > 0; IL = 1 and IU = 0 if N = 0.
          Not referenced if RANGE = 'A' or 'V'.

  ABSTOL  (input) DOUBLE PRECISION
          The absolute error tolerance for the eigenvalues.
          An approximate eigenvalue is accepted as converged
          when it is determined to lie in an interval [a,b]
          of width less than or equal to

                  ABSTOL + EPS *   max( |a|,|b| ) ,

          where EPS is the machine precision.  If ABSTOL is less than
          or equal to zero, then  EPS*|T|  will be used in its place,
          where |T| is the 1-norm of the tridiagonal matrix obtained
          by reducing A to tridiagonal form.

          Eigenvalues will be computed most accurately when ABSTOL is
          set to twice the underflow threshold 2*DLAMCH('S'), not zero.
          If this routine returns with INFO>0, indicating that some
          eigenvectors did not converge, try setting ABSTOL to
          2*DLAMCH('S').

  M       (output) INTEGER
          The total number of eigenvalues found.  0 <= M <= N.
          If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1.

  W       (output) DOUBLE PRECISION array, dimension (N)
          If INFO = 0, the eigenvalues in ascending order.

  Z       (output) DOUBLE PRECISION array, dimension (LDZ, N)
          If JOBZ = 'V', then if INFO = 0, Z contains the matrix Z of
          eigenvectors, with the i-th column of Z holding the
          eigenvector associated with W(i).  The eigenvectors are
          normalized so Z**T*B*Z = I.
          If JOBZ = 'N', then Z is not referenced.

  LDZ     (input) INTEGER
          The leading dimension of the array Z.  LDZ >= 1, and if
          JOBZ = 'V', LDZ >= max(1,N).

  WORK    (workspace/output) DOUBLE PRECISION array, dimension (7*N)

  IWORK   (workspace/output) INTEGER array, dimension (5*N)

  IFAIL   (output) INTEGER array, dimension (M)
          If JOBZ = 'V', then if INFO = 0, the first M elements of
          IFAIL are zero.  If INFO > 0, then IFAIL contains the
          indices of the eigenvalues that failed to converge.
          If JOBZ = 'N', then IFAIL is not referenced.

  INFO    (output) INTEGER
          = 0 : successful exit
          < 0 : if INFO = -i, the i-th argument had an illegal value
          <= N: if INFO = i, then i eigenvectors failed to converge.
                  Their indices are stored in IFAIL.
          > N : DPBSTF returned an error code; i.e.,
                if INFO = N + i, for 1 <= i <= N, then the leading
                minor of order i of B is not positive definite.
                The factorization of B could not be completed and
                no eigenvalues or eigenvectors were computed.

  Further Details
  ===============

  Based on contributions by
     Mark Fahey, Department of Mathematics, Univ. of Kentucky, USA

  =====================================================================

     .. Parameters ..
</pre>
	 * @param jobz
	 * @param range
	 * @param uplo
	 * @param n
	 * @param ka
	 * @param kb
	 * @param ab
	 * @param ldab
	 * @param bb
	 * @param ldbb
	 * @param q
	 * @param ldq
	 * @param vl
	 * @param vu
	 * @param il
	 * @param iu
	 * @param abstol
	 * @param m
	 * @param w
	 * @param z
	 * @param ldz
	 * @param work
	 * @param iwork
	 * @param ifail
	 * @param info
	 */
	public abstract void dsbgvx(String jobz, String range, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] q, int ldq, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info);

	/**
<pre>

     ..

  Purpose
  =======

  DSBTRD reduces a real symmetric band matrix A to symmetric
  tridiagonal form T by an orthogonal similarity transformation:
  Q**T * A * Q = T.

  Arguments
  =========

  VECT    (input) CHARACTER*1
          = 'N':  do not form Q;
          = 'V':  form Q;
          = 'U':  update a matrix X, by forming X*Q.

  UPLO    (input) CHARACTER*1
          = 'U':  Upper triangle of A is stored;
          = 'L':  Lower triangle of A is stored.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  KD      (input) INTEGER
          The number of superdiagonals of the matrix A if UPLO = 'U',
          or the number of subdiagonals if UPLO = 'L'.  KD >= 0.

  AB      (input/output) DOUBLE PRECISION array, dimension (LDAB,N)
          On entry, the upper or lower triangle of the symmetric band
          matrix A, stored in the first KD+1 rows of the array.  The
          j-th column of A is stored in the j-th column of the array AB
          as follows:
          if UPLO = 'U', AB(kd+1+i-j,j) = A(i,j) for max(1,j-kd)<=i<=j;
          if UPLO = 'L', AB(1+i-j,j)    = A(i,j) for j<=i<=min(n,j+kd).
          On exit, the diagonal elements of AB are overwritten by the
          diagonal elements of the tridiagonal matrix T; if KD > 0, the
          elements on the first superdiagonal (if UPLO = 'U') or the
          first subdiagonal (if UPLO = 'L') are overwritten by the
          off-diagonal elements of T; the rest of AB is overwritten by

          values generated during the reduction.

  LDAB    (input) INTEGER
          The leading dimension of the array AB.  LDAB >= KD+1.

  D       (output) DOUBLE PRECISION array, dimension (N)
          The diagonal elements of the tridiagonal matrix T.

  E       (output) DOUBLE PRECISION array, dimension (N-1)
          The off-diagonal elements of the tridiagonal matrix T:
          E(i) = T(i,i+1) if UPLO = 'U'; E(i) = T(i+1,i) if UPLO = 'L'.

  Q       (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
          On entry, if VECT = 'U', then Q must contain an N-by-N
          matrix X; if VECT = 'N' or 'V', then Q need not be set.

          On exit:
          if VECT = 'V', Q contains the N-by-N orthogonal matrix Q;
          if VECT = 'U', Q contains the product X*Q;
          if VECT = 'N', the array Q is not referenced.

  LDQ     (input) INTEGER
          The leading dimension of the array Q.
          LDQ >= 1, and LDQ >= N if VECT = 'V' or 'U'.

  WORK    (workspace) DOUBLE PRECISION array, dimension (N)

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value

  Further Details
  ===============

  Modified by Linda Kaufman, Bell Labs.

  =====================================================================

     .. Parameters ..
</pre>
	 * @param vect
	 * @param uplo
	 * @param n
	 * @param kd
	 * @param ab
	 * @param ldab
	 * @param d
	 * @param e
	 * @param q
	 * @param ldq
	 * @param work
	 * @param info
	 */
	public abstract void dsbtrd(String vect, String uplo, int n, int kd, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] work, intW info);

		/**
<pre>

     ..

  Purpose
  =======

  DSGESV computes the solution to a real system of linear equations
     A * X = B,
  where A is an N-by-N matrix and X and B are N-by-NRHS matrices.

  DSGESV first attempts to factorize the matrix in SINGLE PRECISION 
  and use this factorization within an iterative refinement procedure t
  produce a solution with DOUBLE PRECISION normwise backward error
  quality (see below). If the approach fails the method switches to a
  DOUBLE PRECISION factorization and solve.

  The iterative refinement is not going to be a winning strategy if
  the ratio SINGLE PRECISION performance over DOUBLE PRECISION performa
  is too small. A reasonable strategy should take the number of right-h
  sides and the size of the matrix into account. This might be done wit
  call to ILAENV in the future. Up to now, we always try iterative refi

  The iterative refinement process is stopped if
      ITER > ITERMAX
  or for all the RHS we have:
      RNRM < SQRT(N)*XNRM*ANRM*EPS*BWDMAX 
  where
      o ITER is the number of the current iteration in the iterative
        refinement process
      o RNRM is the infinity-norm of the residual
      o XNRM is the infinity-norm of the solution
      o ANRM is the infinity-operator-norm of the matrix A
      o EPS is the machine epsilon returned by DLAMCH('Epsilon')
  The value ITERMAX and BWDMAX are fixed to 30 and 1.0D+00 respectively

  Arguments
  =========

  N       (input) INTEGER
          The number of linear equations, i.e., the order of the
          matrix A.  N >= 0.

  NRHS    (input) INTEGER
          The number of right hand sides, i.e., the number of columns
          of the matrix B.  NRHS >= 0.

  A       (input or input/ouptut) DOUBLE PRECISION array,
          dimension (LDA,N)
          On entry, the N-by-N coefficient matrix A.
          On exit, if iterative refinement has been successfully used
          (INFO.EQ.0 and ITER.GE.0, see description below), then A is
          unchanged, if double precision factorization has been used
          (INFO.EQ.0 and ITER.LT.0, see description below), then the
          array A contains the factors L and U from the factorization
          A = P*L*U; the unit diagonal elements of L are not stored.

  LDA     (input) INTEGER
          The leading dimension of the array A.  LDA >= max(1,N).

  IPIV    (output) INTEGER array, dimension (N)
          The pivot indices that define the permutation matrix P;
          row i of the matrix was interchanged with row IPIV(i).
          Corresponds either to the single precision factorization 
          (if INFO.EQ.0 and ITER.GE.0) or the double precision 
          factorization (if INFO.EQ.0 and ITER.LT.0).

  B       (input) DOUBLE PRECISION array, dimension (LDB,NRHS)
          The N-by-NRHS matrix of right hand side matrix B.

  LDB     (input) INTEGER
          The leading dimension of the array B.  LDB >= max(1,N).

  X       (output) DOUBLE PRECISION array, dimension (LDX,NRHS)
          If INFO = 0, the N-by-NRHS solution matrix X.

  LDX     (input) INTEGER
          The leading dimension of the array X.  LDX >= max(1,N).

  WORK    (workspace) DOUBLE PRECISION array, dimension (N*NRHS)
          This array is used to hold the residual vectors.

  SWORK   (workspace) REAL array, dimension (N*(N+NRHS))
          This array is used to use the single precision matrix and the
          right-hand sides or solutions in single precision.

  ITER    (output) INTEGER
          < 0: iterative refinement has failed, double precision
               factorization has been performed
               -1 : taking into account machine parameters, N, NRHS, it
                    is a priori not worth working in SINGLE PRECISION
               -2 : overflow of an entry when moving from double to
                    SINGLE PRECISION
               -3 : failure of SGETRF
               -31: stop the iterative refinement after the 30th
                    iterations
          > 0: iterative refinement has been sucessfully used.
               Returns the number of iterations

  INFO    (output) INTEGER
          = 0:  successful exit
          < 0:  if INFO = -i, the i-th argument had an illegal value
          > 0:  if INFO = i, U(i,i) computed in DOUBLE PRECISION is
                exactly zero.  The factorization has been completed,
                but the factor U is exactly singular, so the solution
                could not be computed.

  =========

     .. Parameters ..
</pre>
	 * @param n
	 * @param nrhs
	 * @param a
	 * @param lda
	 * @param ipiv
	 * @param b
	 * @param ldb
	 * @param x
	 * @param ldx
	 * @param work
	 * @param swork
	 * @param iter
	 * @param info
	 */
	public void dsgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] work, float[] swork, intW iter, intW info) {
		org.netlib.lapack.Dsgesv.dsgesv(n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, x, 0, ldx, work, 0, swork, 0, iter, info);
	}

	/**
<pre>

     ..

  Purpose
  =======

  DSPCON estimates the reciprocal of the condition number (in the
  1-norm) of a real symmetric packed matrix A using the factorization
  A = U*D*U**T or A = L*D*L**T computed by DSPTRF.

  An estimate is obtained for norm(inv(A)), and the reciprocal of the
  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).

  Arguments
  =========

  UPLO    (input) CHARACTER*1
          Specifies whether the details of the factorization are stored
          as an upper or lower triangular matrix.
          = 'U':  Upper triangular, form is A = U*D*U**T;
          = 'L':  Lower triangular, form is A = L*D*L**T.

  N       (input) INTEGER
          The order of the matrix A.  N >= 0.

  AP      (input) DOUBLE PRECISION array, dimension (N*(N+1)/2)
          The block diagonal matrix D and the multipliers used to
          obtain the factor U or L as computed by DSPTRF, stored as a
          packed triangular matrix.

  IPIV    (input) INTEGER array, dimension (N)
          Details of the interchanges and the block structure of D
          as determined by DSPTRF.

  ANORM   (input) DOUBLE PRECISION
          The 1-norm of the original matrix A.

  RCOND   (output) DOUBLE PRECISION
          The reciprocal of the condition number of the matrix A,
          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
          estimate of the 1-norm of inv(A) computed in this routine.

  WORK    (workspace) DOUBLE PRECISION array, dimensio