/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Square of the mathematical constant `π`.
*
* @module @stdlib/constants/float64/pi-squared
* @type {number}
*
* @example
* var PI_SQUARED = require( '@stdlib/constants/float64/pi-squared' );
* // returns 9.869604401089358
*/


// MAIN //

/**
* Square of the mathematical constant `π`.
*
* @constant
* @type {number}
* @default 9.869604401089358
* @see [Wikipedia]{@link https://en.wikipedia.org/wiki/Pi}
*/
var PI_SQUARED = 9.86960440108935861883449099987615113531369940724079062641334937622004482241920524300177340371855223182402591377; // eslint-disable-line max-len


// EXPORTS //

module.exports = PI_SQUARED;
