/*
 * Copyright © 2014 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/**
 * \file invalid-patch-vertices-range.c
 *
 * From the ARB_tessellation_shader spec (Errors section):
 *
 *     "The error INVALID_VALUE is generated by PatchParameteri if <pname> is
 *     PATCH_VERTICES and <value> is less than or equal to zero or is greater
 *     than the implementation-dependent maximum patch size."
 *
 */

#include "piglit-util-gl.h"

PIGLIT_GL_TEST_CONFIG_BEGIN

	config.supports_gl_compat_version = 32;
	config.supports_gl_core_version = 32;
	config.khr_no_error_support = PIGLIT_HAS_ERRORS;

PIGLIT_GL_TEST_CONFIG_END


void
piglit_init(int argc, char **argv)
{
	bool pass = true;
	int max_patch_vertices;

	piglit_require_extension("GL_ARB_tessellation_shader");

	glGetIntegerv(GL_MAX_PATCH_VERTICES, &max_patch_vertices);

	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;
	glPatchParameteri(GL_PATCH_VERTICES, -1);
	pass = piglit_check_gl_error(GL_INVALID_VALUE) && pass;

	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;
	glPatchParameteri(GL_PATCH_VERTICES, 0);
	pass = piglit_check_gl_error(GL_INVALID_VALUE) && pass;

	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;
	glPatchParameteri(GL_PATCH_VERTICES, max_patch_vertices + 1);
	pass = piglit_check_gl_error(GL_INVALID_VALUE) && pass;

	pass = piglit_check_gl_error(GL_NO_ERROR) && pass;

	piglit_report_result(pass ? PIGLIT_PASS : PIGLIT_FAIL);
}


enum piglit_result
piglit_display(void)
{
	return PIGLIT_PASS;
}

