# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AccessPolicyResponse(_serialization.Model):
    """Get Data Plane read only token response definition.

    :ivar policy: The user access policy.
    :vartype policy: ~azure.mgmt.datafactory.models.UserAccessPolicy
    :ivar access_token: Data Plane read only access token.
    :vartype access_token: str
    :ivar data_plane_url: Data Plane service base URL.
    :vartype data_plane_url: str
    """

    _attribute_map = {
        "policy": {"key": "policy", "type": "UserAccessPolicy"},
        "access_token": {"key": "accessToken", "type": "str"},
        "data_plane_url": {"key": "dataPlaneUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        policy: Optional["_models.UserAccessPolicy"] = None,
        access_token: Optional[str] = None,
        data_plane_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword policy: The user access policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.UserAccessPolicy
        :keyword access_token: Data Plane read only access token.
        :paramtype access_token: str
        :keyword data_plane_url: Data Plane service base URL.
        :paramtype data_plane_url: str
        """
        super().__init__(**kwargs)
        self.policy = policy
        self.access_token = access_token
        self.data_plane_url = data_plane_url


class Activity(_serialization.Model):
    """A pipeline activity.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ControlActivity, ExecuteWranglingDataflowActivity, ExecutionActivity

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
    }

    _subtype_map = {
        "type": {
            "Container": "ControlActivity",
            "ExecuteWranglingDataflow": "ExecuteWranglingDataflowActivity",
            "Execution": "ExecutionActivity",
        }
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = name
        self.type = None  # type: Optional[str]
        self.description = description
        self.depends_on = depends_on
        self.user_properties = user_properties


class ActivityDependency(_serialization.Model):
    """Activity dependency information.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar activity: Activity name. Required.
    :vartype activity: str
    :ivar dependency_conditions: Match-Condition for the dependency. Required.
    :vartype dependency_conditions: list[str or ~azure.mgmt.datafactory.models.DependencyCondition]
    """

    _validation = {
        "activity": {"required": True},
        "dependency_conditions": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "activity": {"key": "activity", "type": "str"},
        "dependency_conditions": {"key": "dependencyConditions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        activity: str,
        dependency_conditions: List[Union[str, "_models.DependencyCondition"]],
        additional_properties: Optional[Dict[str, JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword activity: Activity name. Required.
        :paramtype activity: str
        :keyword dependency_conditions: Match-Condition for the dependency. Required.
        :paramtype dependency_conditions: list[str or
         ~azure.mgmt.datafactory.models.DependencyCondition]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.activity = activity
        self.dependency_conditions = dependency_conditions


class ActivityPolicy(_serialization.Model):
    """Execution policy for an activity.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar timeout: Specifies the timeout for the activity to run. The default timeout is 7 days.
     Type: string (or Expression with resultType string), pattern:
     ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype timeout: JSON
    :ivar retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with
     resultType integer), minimum: 0.
    :vartype retry: JSON
    :ivar retry_interval_in_seconds: Interval between each retry attempt (in seconds). The default
     is 30 sec.
    :vartype retry_interval_in_seconds: int
    :ivar secure_input: When set to true, Input from activity is considered as secure and will not
     be logged to monitoring.
    :vartype secure_input: bool
    :ivar secure_output: When set to true, Output from activity is considered as secure and will
     not be logged to monitoring.
    :vartype secure_output: bool
    """

    _validation = {
        "retry_interval_in_seconds": {"maximum": 86400, "minimum": 30},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "timeout": {"key": "timeout", "type": "object"},
        "retry": {"key": "retry", "type": "object"},
        "retry_interval_in_seconds": {"key": "retryIntervalInSeconds", "type": "int"},
        "secure_input": {"key": "secureInput", "type": "bool"},
        "secure_output": {"key": "secureOutput", "type": "bool"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        timeout: Optional[JSON] = None,
        retry: Optional[JSON] = None,
        retry_interval_in_seconds: Optional[int] = None,
        secure_input: Optional[bool] = None,
        secure_output: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword timeout: Specifies the timeout for the activity to run. The default timeout is 7 days.
         Type: string (or Expression with resultType string), pattern:
         ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype timeout: JSON
        :keyword retry: Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression
         with resultType integer), minimum: 0.
        :paramtype retry: JSON
        :keyword retry_interval_in_seconds: Interval between each retry attempt (in seconds). The
         default is 30 sec.
        :paramtype retry_interval_in_seconds: int
        :keyword secure_input: When set to true, Input from activity is considered as secure and will
         not be logged to monitoring.
        :paramtype secure_input: bool
        :keyword secure_output: When set to true, Output from activity is considered as secure and will
         not be logged to monitoring.
        :paramtype secure_output: bool
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.timeout = timeout
        self.retry = retry
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.secure_input = secure_input
        self.secure_output = secure_output


class ActivityRun(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Information about an activity run in a pipeline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar pipeline_name: The name of the pipeline.
    :vartype pipeline_name: str
    :ivar pipeline_run_id: The id of the pipeline run.
    :vartype pipeline_run_id: str
    :ivar activity_name: The name of the activity.
    :vartype activity_name: str
    :ivar activity_type: The type of the activity.
    :vartype activity_type: str
    :ivar activity_run_id: The id of the activity run.
    :vartype activity_run_id: str
    :ivar linked_service_name: The name of the compute linked service.
    :vartype linked_service_name: str
    :ivar status: The status of the activity run.
    :vartype status: str
    :ivar activity_run_start: The start time of the activity run in 'ISO 8601' format.
    :vartype activity_run_start: ~datetime.datetime
    :ivar activity_run_end: The end time of the activity run in 'ISO 8601' format.
    :vartype activity_run_end: ~datetime.datetime
    :ivar duration_in_ms: The duration of the activity run.
    :vartype duration_in_ms: int
    :ivar input: The input for the activity.
    :vartype input: JSON
    :ivar output: The output for the activity.
    :vartype output: JSON
    :ivar error: The error if any from the activity run.
    :vartype error: JSON
    """

    _validation = {
        "pipeline_name": {"readonly": True},
        "pipeline_run_id": {"readonly": True},
        "activity_name": {"readonly": True},
        "activity_type": {"readonly": True},
        "activity_run_id": {"readonly": True},
        "linked_service_name": {"readonly": True},
        "status": {"readonly": True},
        "activity_run_start": {"readonly": True},
        "activity_run_end": {"readonly": True},
        "duration_in_ms": {"readonly": True},
        "input": {"readonly": True},
        "output": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "pipeline_name": {"key": "pipelineName", "type": "str"},
        "pipeline_run_id": {"key": "pipelineRunId", "type": "str"},
        "activity_name": {"key": "activityName", "type": "str"},
        "activity_type": {"key": "activityType", "type": "str"},
        "activity_run_id": {"key": "activityRunId", "type": "str"},
        "linked_service_name": {"key": "linkedServiceName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "activity_run_start": {"key": "activityRunStart", "type": "iso-8601"},
        "activity_run_end": {"key": "activityRunEnd", "type": "iso-8601"},
        "duration_in_ms": {"key": "durationInMs", "type": "int"},
        "input": {"key": "input", "type": "object"},
        "output": {"key": "output", "type": "object"},
        "error": {"key": "error", "type": "object"},
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.pipeline_name = None
        self.pipeline_run_id = None
        self.activity_name = None
        self.activity_type = None
        self.activity_run_id = None
        self.linked_service_name = None
        self.status = None
        self.activity_run_start = None
        self.activity_run_end = None
        self.duration_in_ms = None
        self.input = None
        self.output = None
        self.error = None


class ActivityRunsQueryResponse(_serialization.Model):
    """A list activity runs.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of activity runs. Required.
    :vartype value: list[~azure.mgmt.datafactory.models.ActivityRun]
    :ivar continuation_token: The continuation token for getting the next page of results, if any
     remaining results exist, null otherwise.
    :vartype continuation_token: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ActivityRun]"},
        "continuation_token": {"key": "continuationToken", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ActivityRun"], continuation_token: Optional[str] = None, **kwargs):
        """
        :keyword value: List of activity runs. Required.
        :paramtype value: list[~azure.mgmt.datafactory.models.ActivityRun]
        :keyword continuation_token: The continuation token for getting the next page of results, if
         any remaining results exist, null otherwise.
        :paramtype continuation_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.continuation_token = continuation_token


class AddDataFlowToDebugSessionResponse(_serialization.Model):
    """Response body structure for starting data flow debug session.

    :ivar job_version: The ID of data flow debug job version.
    :vartype job_version: str
    """

    _attribute_map = {
        "job_version": {"key": "jobVersion", "type": "str"},
    }

    def __init__(self, *, job_version: Optional[str] = None, **kwargs):
        """
        :keyword job_version: The ID of data flow debug job version.
        :paramtype job_version: str
        """
        super().__init__(**kwargs)
        self.job_version = job_version


class AdditionalColumns(_serialization.Model):
    """Specify the column name and value of additional columns.

    :ivar name: Additional column name. Type: string (or Expression with resultType string).
    :vartype name: JSON
    :ivar value: Additional column value. Type: string (or Expression with resultType string).
    :vartype value: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "object"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, name: Optional[JSON] = None, value: Optional[JSON] = None, **kwargs):
        """
        :keyword name: Additional column name. Type: string (or Expression with resultType string).
        :paramtype name: JSON
        :keyword value: Additional column value. Type: string (or Expression with resultType string).
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class LinkedService(_serialization.Model):
    """The nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmazonMWSLinkedService, AmazonRdsForOracleLinkedService, AmazonRdsForSqlServerLinkedService,
    AmazonRedshiftLinkedService, AmazonS3LinkedService, AmazonS3CompatibleLinkedService,
    AppFiguresLinkedService, AsanaLinkedService, AzureBatchLinkedService, AzureBlobFSLinkedService,
    AzureBlobStorageLinkedService, AzureDataExplorerLinkedService,
    AzureDataLakeAnalyticsLinkedService, AzureDataLakeStoreLinkedService,
    AzureDatabricksLinkedService, AzureDatabricksDeltaLakeLinkedService,
    AzureFileStorageLinkedService, AzureFunctionLinkedService, AzureKeyVaultLinkedService,
    AzureMLLinkedService, AzureMLServiceLinkedService, AzureMariaDBLinkedService,
    AzureMySqlLinkedService, AzurePostgreSqlLinkedService, AzureSearchLinkedService,
    AzureSqlDWLinkedService, AzureSqlDatabaseLinkedService, AzureSqlMILinkedService,
    AzureStorageLinkedService, AzureSynapseArtifactsLinkedService, AzureTableStorageLinkedService,
    CassandraLinkedService, CommonDataServiceForAppsLinkedService, ConcurLinkedService,
    CosmosDbLinkedService, CosmosDbMongoDbApiLinkedService, CouchbaseLinkedService,
    CustomDataSourceLinkedService, DataworldLinkedService, Db2LinkedService, DrillLinkedService,
    DynamicsLinkedService, DynamicsAXLinkedService, DynamicsCrmLinkedService, EloquaLinkedService,
    FileServerLinkedService, FtpServerLinkedService, GoogleAdWordsLinkedService,
    GoogleBigQueryLinkedService, GoogleCloudStorageLinkedService, GoogleSheetsLinkedService,
    GreenplumLinkedService, HBaseLinkedService, HDInsightLinkedService,
    HDInsightOnDemandLinkedService, HdfsLinkedService, HiveLinkedService, HttpLinkedService,
    HubspotLinkedService, ImpalaLinkedService, InformixLinkedService, JiraLinkedService,
    MagentoLinkedService, MariaDBLinkedService, MarketoLinkedService, MicrosoftAccessLinkedService,
    MongoDbLinkedService, MongoDbAtlasLinkedService, MongoDbV2LinkedService, MySqlLinkedService,
    NetezzaLinkedService, ODataLinkedService, OdbcLinkedService, Office365LinkedService,
    OracleLinkedService, OracleCloudStorageLinkedService, OracleServiceCloudLinkedService,
    PaypalLinkedService, PhoenixLinkedService, PostgreSqlLinkedService, PrestoLinkedService,
    QuickBooksLinkedService, QuickbaseLinkedService, ResponsysLinkedService,
    RestServiceLinkedService, SalesforceLinkedService, SalesforceMarketingCloudLinkedService,
    SalesforceServiceCloudLinkedService, SapBWLinkedService, SapCloudForCustomerLinkedService,
    SapEccLinkedService, SapHanaLinkedService, SapOdpLinkedService, SapOpenHubLinkedService,
    SapTableLinkedService, ServiceNowLinkedService, SftpServerLinkedService,
    SharePointOnlineListLinkedService, ShopifyLinkedService, SmartsheetLinkedService,
    SnowflakeLinkedService, SparkLinkedService, SqlServerLinkedService, SquareLinkedService,
    SybaseLinkedService, TeamDeskLinkedService, TeradataLinkedService, TwilioLinkedService,
    VerticaLinkedService, WebLinkedService, XeroLinkedService, ZendeskLinkedService,
    ZohoLinkedService

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
    }

    _subtype_map = {
        "type": {
            "AmazonMWS": "AmazonMWSLinkedService",
            "AmazonRdsForOracle": "AmazonRdsForOracleLinkedService",
            "AmazonRdsForSqlServer": "AmazonRdsForSqlServerLinkedService",
            "AmazonRedshift": "AmazonRedshiftLinkedService",
            "AmazonS3": "AmazonS3LinkedService",
            "AmazonS3Compatible": "AmazonS3CompatibleLinkedService",
            "AppFigures": "AppFiguresLinkedService",
            "Asana": "AsanaLinkedService",
            "AzureBatch": "AzureBatchLinkedService",
            "AzureBlobFS": "AzureBlobFSLinkedService",
            "AzureBlobStorage": "AzureBlobStorageLinkedService",
            "AzureDataExplorer": "AzureDataExplorerLinkedService",
            "AzureDataLakeAnalytics": "AzureDataLakeAnalyticsLinkedService",
            "AzureDataLakeStore": "AzureDataLakeStoreLinkedService",
            "AzureDatabricks": "AzureDatabricksLinkedService",
            "AzureDatabricksDeltaLake": "AzureDatabricksDeltaLakeLinkedService",
            "AzureFileStorage": "AzureFileStorageLinkedService",
            "AzureFunction": "AzureFunctionLinkedService",
            "AzureKeyVault": "AzureKeyVaultLinkedService",
            "AzureML": "AzureMLLinkedService",
            "AzureMLService": "AzureMLServiceLinkedService",
            "AzureMariaDB": "AzureMariaDBLinkedService",
            "AzureMySql": "AzureMySqlLinkedService",
            "AzurePostgreSql": "AzurePostgreSqlLinkedService",
            "AzureSearch": "AzureSearchLinkedService",
            "AzureSqlDW": "AzureSqlDWLinkedService",
            "AzureSqlDatabase": "AzureSqlDatabaseLinkedService",
            "AzureSqlMI": "AzureSqlMILinkedService",
            "AzureStorage": "AzureStorageLinkedService",
            "AzureSynapseArtifacts": "AzureSynapseArtifactsLinkedService",
            "AzureTableStorage": "AzureTableStorageLinkedService",
            "Cassandra": "CassandraLinkedService",
            "CommonDataServiceForApps": "CommonDataServiceForAppsLinkedService",
            "Concur": "ConcurLinkedService",
            "CosmosDb": "CosmosDbLinkedService",
            "CosmosDbMongoDbApi": "CosmosDbMongoDbApiLinkedService",
            "Couchbase": "CouchbaseLinkedService",
            "CustomDataSource": "CustomDataSourceLinkedService",
            "Dataworld": "DataworldLinkedService",
            "Db2": "Db2LinkedService",
            "Drill": "DrillLinkedService",
            "Dynamics": "DynamicsLinkedService",
            "DynamicsAX": "DynamicsAXLinkedService",
            "DynamicsCrm": "DynamicsCrmLinkedService",
            "Eloqua": "EloquaLinkedService",
            "FileServer": "FileServerLinkedService",
            "FtpServer": "FtpServerLinkedService",
            "GoogleAdWords": "GoogleAdWordsLinkedService",
            "GoogleBigQuery": "GoogleBigQueryLinkedService",
            "GoogleCloudStorage": "GoogleCloudStorageLinkedService",
            "GoogleSheets": "GoogleSheetsLinkedService",
            "Greenplum": "GreenplumLinkedService",
            "HBase": "HBaseLinkedService",
            "HDInsight": "HDInsightLinkedService",
            "HDInsightOnDemand": "HDInsightOnDemandLinkedService",
            "Hdfs": "HdfsLinkedService",
            "Hive": "HiveLinkedService",
            "HttpServer": "HttpLinkedService",
            "Hubspot": "HubspotLinkedService",
            "Impala": "ImpalaLinkedService",
            "Informix": "InformixLinkedService",
            "Jira": "JiraLinkedService",
            "Magento": "MagentoLinkedService",
            "MariaDB": "MariaDBLinkedService",
            "Marketo": "MarketoLinkedService",
            "MicrosoftAccess": "MicrosoftAccessLinkedService",
            "MongoDb": "MongoDbLinkedService",
            "MongoDbAtlas": "MongoDbAtlasLinkedService",
            "MongoDbV2": "MongoDbV2LinkedService",
            "MySql": "MySqlLinkedService",
            "Netezza": "NetezzaLinkedService",
            "OData": "ODataLinkedService",
            "Odbc": "OdbcLinkedService",
            "Office365": "Office365LinkedService",
            "Oracle": "OracleLinkedService",
            "OracleCloudStorage": "OracleCloudStorageLinkedService",
            "OracleServiceCloud": "OracleServiceCloudLinkedService",
            "Paypal": "PaypalLinkedService",
            "Phoenix": "PhoenixLinkedService",
            "PostgreSql": "PostgreSqlLinkedService",
            "Presto": "PrestoLinkedService",
            "QuickBooks": "QuickBooksLinkedService",
            "Quickbase": "QuickbaseLinkedService",
            "Responsys": "ResponsysLinkedService",
            "RestService": "RestServiceLinkedService",
            "Salesforce": "SalesforceLinkedService",
            "SalesforceMarketingCloud": "SalesforceMarketingCloudLinkedService",
            "SalesforceServiceCloud": "SalesforceServiceCloudLinkedService",
            "SapBW": "SapBWLinkedService",
            "SapCloudForCustomer": "SapCloudForCustomerLinkedService",
            "SapEcc": "SapEccLinkedService",
            "SapHana": "SapHanaLinkedService",
            "SapOdp": "SapOdpLinkedService",
            "SapOpenHub": "SapOpenHubLinkedService",
            "SapTable": "SapTableLinkedService",
            "ServiceNow": "ServiceNowLinkedService",
            "Sftp": "SftpServerLinkedService",
            "SharePointOnlineList": "SharePointOnlineListLinkedService",
            "Shopify": "ShopifyLinkedService",
            "Smartsheet": "SmartsheetLinkedService",
            "Snowflake": "SnowflakeLinkedService",
            "Spark": "SparkLinkedService",
            "SqlServer": "SqlServerLinkedService",
            "Square": "SquareLinkedService",
            "Sybase": "SybaseLinkedService",
            "TeamDesk": "TeamDeskLinkedService",
            "Teradata": "TeradataLinkedService",
            "Twilio": "TwilioLinkedService",
            "Vertica": "VerticaLinkedService",
            "Web": "WebLinkedService",
            "Xero": "XeroLinkedService",
            "Zendesk": "ZendeskLinkedService",
            "Zoho": "ZohoLinkedService",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.connect_via = connect_via
        self.description = description
        self.parameters = parameters
        self.annotations = annotations


class AmazonMWSLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Amazon Marketplace Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar endpoint: The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com). Required.
    :vartype endpoint: JSON
    :ivar marketplace_id: The Amazon Marketplace ID you want to retrieve data from. To retrieve
     data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2).
     Required.
    :vartype marketplace_id: JSON
    :ivar seller_id: The Amazon seller ID. Required.
    :vartype seller_id: JSON
    :ivar mws_auth_token: The Amazon MWS authentication token.
    :vartype mws_auth_token: ~azure.mgmt.datafactory.models.SecretBase
    :ivar access_key_id: The access key id used to access data. Required.
    :vartype access_key_id: JSON
    :ivar secret_key: The secret key used to access data.
    :vartype secret_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :vartype use_encrypted_endpoints: JSON
    :ivar use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :vartype use_host_verification: JSON
    :ivar use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :vartype use_peer_verification: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "endpoint": {"required": True},
        "marketplace_id": {"required": True},
        "seller_id": {"required": True},
        "access_key_id": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "endpoint": {"key": "typeProperties.endpoint", "type": "object"},
        "marketplace_id": {"key": "typeProperties.marketplaceID", "type": "object"},
        "seller_id": {"key": "typeProperties.sellerID", "type": "object"},
        "mws_auth_token": {"key": "typeProperties.mwsAuthToken", "type": "SecretBase"},
        "access_key_id": {"key": "typeProperties.accessKeyId", "type": "object"},
        "secret_key": {"key": "typeProperties.secretKey", "type": "SecretBase"},
        "use_encrypted_endpoints": {"key": "typeProperties.useEncryptedEndpoints", "type": "object"},
        "use_host_verification": {"key": "typeProperties.useHostVerification", "type": "object"},
        "use_peer_verification": {"key": "typeProperties.usePeerVerification", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        endpoint: JSON,
        marketplace_id: JSON,
        seller_id: JSON,
        access_key_id: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        mws_auth_token: Optional["_models.SecretBase"] = None,
        secret_key: Optional["_models.SecretBase"] = None,
        use_encrypted_endpoints: Optional[JSON] = None,
        use_host_verification: Optional[JSON] = None,
        use_peer_verification: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword endpoint: The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com).
         Required.
        :paramtype endpoint: JSON
        :keyword marketplace_id: The Amazon Marketplace ID you want to retrieve data from. To retrieve
         data from multiple Marketplace IDs, separate them with a comma (,). (i.e. A2EUQ1WTGCTBG2).
         Required.
        :paramtype marketplace_id: JSON
        :keyword seller_id: The Amazon seller ID. Required.
        :paramtype seller_id: JSON
        :keyword mws_auth_token: The Amazon MWS authentication token.
        :paramtype mws_auth_token: ~azure.mgmt.datafactory.models.SecretBase
        :keyword access_key_id: The access key id used to access data. Required.
        :paramtype access_key_id: JSON
        :keyword secret_key: The secret key used to access data.
        :paramtype secret_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted
         using HTTPS. The default value is true.
        :paramtype use_encrypted_endpoints: JSON
        :keyword use_host_verification: Specifies whether to require the host name in the server's
         certificate to match the host name of the server when connecting over SSL. The default value is
         true.
        :paramtype use_host_verification: JSON
        :keyword use_peer_verification: Specifies whether to verify the identity of the server when
         connecting over SSL. The default value is true.
        :paramtype use_peer_verification: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AmazonMWS"  # type: str
        self.endpoint = endpoint
        self.marketplace_id = marketplace_id
        self.seller_id = seller_id
        self.mws_auth_token = mws_auth_token
        self.access_key_id = access_key_id
        self.secret_key = secret_key
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class Dataset(_serialization.Model):
    """The Azure Data Factory nested object which identifies data within different data stores, such as tables, files, folders, and documents.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmazonMWSObjectDataset, AmazonRdsForOracleTableDataset, AmazonRdsForSqlServerTableDataset,
    AmazonRedshiftTableDataset, AmazonS3Dataset, AvroDataset, AzureBlobDataset, AzureBlobFSDataset,
    AzureDataExplorerTableDataset, AzureDataLakeStoreDataset, AzureDatabricksDeltaLakeDataset,
    AzureMariaDBTableDataset, AzureMySqlTableDataset, AzurePostgreSqlTableDataset,
    AzureSearchIndexDataset, AzureSqlDWTableDataset, AzureSqlMITableDataset, AzureSqlTableDataset,
    AzureTableDataset, BinaryDataset, CassandraTableDataset, CommonDataServiceForAppsEntityDataset,
    ConcurObjectDataset, CosmosDbMongoDbApiCollectionDataset, CosmosDbSqlApiCollectionDataset,
    CouchbaseTableDataset, CustomDataset, Db2TableDataset, DelimitedTextDataset,
    DocumentDbCollectionDataset, DrillTableDataset, DynamicsAXResourceDataset,
    DynamicsCrmEntityDataset, DynamicsEntityDataset, EloquaObjectDataset, ExcelDataset,
    FileShareDataset, GoogleAdWordsObjectDataset, GoogleBigQueryObjectDataset,
    GreenplumTableDataset, HBaseObjectDataset, HiveObjectDataset, HttpDataset,
    HubspotObjectDataset, ImpalaObjectDataset, InformixTableDataset, JiraObjectDataset,
    JsonDataset, MagentoObjectDataset, MariaDBTableDataset, MarketoObjectDataset,
    MicrosoftAccessTableDataset, MongoDbAtlasCollectionDataset, MongoDbCollectionDataset,
    MongoDbV2CollectionDataset, MySqlTableDataset, NetezzaTableDataset, ODataResourceDataset,
    OdbcTableDataset, Office365Dataset, OracleServiceCloudObjectDataset, OracleTableDataset,
    OrcDataset, ParquetDataset, PaypalObjectDataset, PhoenixObjectDataset, PostgreSqlTableDataset,
    PrestoObjectDataset, QuickBooksObjectDataset, RelationalTableDataset, ResponsysObjectDataset,
    RestResourceDataset, SalesforceMarketingCloudObjectDataset, SalesforceObjectDataset,
    SalesforceServiceCloudObjectDataset, SapBwCubeDataset, SapCloudForCustomerResourceDataset,
    SapEccResourceDataset, SapHanaTableDataset, SapOdpResourceDataset, SapOpenHubTableDataset,
    SapTableResourceDataset, ServiceNowObjectDataset, SharePointOnlineListResourceDataset,
    ShopifyObjectDataset, SnowflakeDataset, SparkObjectDataset, SqlServerTableDataset,
    SquareObjectDataset, SybaseTableDataset, TeradataTableDataset, VerticaTableDataset,
    WebTableDataset, XeroObjectDataset, XmlDataset, ZohoObjectDataset

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
    }

    _subtype_map = {
        "type": {
            "AmazonMWSObject": "AmazonMWSObjectDataset",
            "AmazonRdsForOracleTable": "AmazonRdsForOracleTableDataset",
            "AmazonRdsForSqlServerTable": "AmazonRdsForSqlServerTableDataset",
            "AmazonRedshiftTable": "AmazonRedshiftTableDataset",
            "AmazonS3Object": "AmazonS3Dataset",
            "Avro": "AvroDataset",
            "AzureBlob": "AzureBlobDataset",
            "AzureBlobFSFile": "AzureBlobFSDataset",
            "AzureDataExplorerTable": "AzureDataExplorerTableDataset",
            "AzureDataLakeStoreFile": "AzureDataLakeStoreDataset",
            "AzureDatabricksDeltaLakeDataset": "AzureDatabricksDeltaLakeDataset",
            "AzureMariaDBTable": "AzureMariaDBTableDataset",
            "AzureMySqlTable": "AzureMySqlTableDataset",
            "AzurePostgreSqlTable": "AzurePostgreSqlTableDataset",
            "AzureSearchIndex": "AzureSearchIndexDataset",
            "AzureSqlDWTable": "AzureSqlDWTableDataset",
            "AzureSqlMITable": "AzureSqlMITableDataset",
            "AzureSqlTable": "AzureSqlTableDataset",
            "AzureTable": "AzureTableDataset",
            "Binary": "BinaryDataset",
            "CassandraTable": "CassandraTableDataset",
            "CommonDataServiceForAppsEntity": "CommonDataServiceForAppsEntityDataset",
            "ConcurObject": "ConcurObjectDataset",
            "CosmosDbMongoDbApiCollection": "CosmosDbMongoDbApiCollectionDataset",
            "CosmosDbSqlApiCollection": "CosmosDbSqlApiCollectionDataset",
            "CouchbaseTable": "CouchbaseTableDataset",
            "CustomDataset": "CustomDataset",
            "Db2Table": "Db2TableDataset",
            "DelimitedText": "DelimitedTextDataset",
            "DocumentDbCollection": "DocumentDbCollectionDataset",
            "DrillTable": "DrillTableDataset",
            "DynamicsAXResource": "DynamicsAXResourceDataset",
            "DynamicsCrmEntity": "DynamicsCrmEntityDataset",
            "DynamicsEntity": "DynamicsEntityDataset",
            "EloquaObject": "EloquaObjectDataset",
            "Excel": "ExcelDataset",
            "FileShare": "FileShareDataset",
            "GoogleAdWordsObject": "GoogleAdWordsObjectDataset",
            "GoogleBigQueryObject": "GoogleBigQueryObjectDataset",
            "GreenplumTable": "GreenplumTableDataset",
            "HBaseObject": "HBaseObjectDataset",
            "HiveObject": "HiveObjectDataset",
            "HttpFile": "HttpDataset",
            "HubspotObject": "HubspotObjectDataset",
            "ImpalaObject": "ImpalaObjectDataset",
            "InformixTable": "InformixTableDataset",
            "JiraObject": "JiraObjectDataset",
            "Json": "JsonDataset",
            "MagentoObject": "MagentoObjectDataset",
            "MariaDBTable": "MariaDBTableDataset",
            "MarketoObject": "MarketoObjectDataset",
            "MicrosoftAccessTable": "MicrosoftAccessTableDataset",
            "MongoDbAtlasCollection": "MongoDbAtlasCollectionDataset",
            "MongoDbCollection": "MongoDbCollectionDataset",
            "MongoDbV2Collection": "MongoDbV2CollectionDataset",
            "MySqlTable": "MySqlTableDataset",
            "NetezzaTable": "NetezzaTableDataset",
            "ODataResource": "ODataResourceDataset",
            "OdbcTable": "OdbcTableDataset",
            "Office365Table": "Office365Dataset",
            "OracleServiceCloudObject": "OracleServiceCloudObjectDataset",
            "OracleTable": "OracleTableDataset",
            "Orc": "OrcDataset",
            "Parquet": "ParquetDataset",
            "PaypalObject": "PaypalObjectDataset",
            "PhoenixObject": "PhoenixObjectDataset",
            "PostgreSqlTable": "PostgreSqlTableDataset",
            "PrestoObject": "PrestoObjectDataset",
            "QuickBooksObject": "QuickBooksObjectDataset",
            "RelationalTable": "RelationalTableDataset",
            "ResponsysObject": "ResponsysObjectDataset",
            "RestResource": "RestResourceDataset",
            "SalesforceMarketingCloudObject": "SalesforceMarketingCloudObjectDataset",
            "SalesforceObject": "SalesforceObjectDataset",
            "SalesforceServiceCloudObject": "SalesforceServiceCloudObjectDataset",
            "SapBwCube": "SapBwCubeDataset",
            "SapCloudForCustomerResource": "SapCloudForCustomerResourceDataset",
            "SapEccResource": "SapEccResourceDataset",
            "SapHanaTable": "SapHanaTableDataset",
            "SapOdpResource": "SapOdpResourceDataset",
            "SapOpenHubTable": "SapOpenHubTableDataset",
            "SapTableResource": "SapTableResourceDataset",
            "ServiceNowObject": "ServiceNowObjectDataset",
            "SharePointOnlineListResource": "SharePointOnlineListResourceDataset",
            "ShopifyObject": "ShopifyObjectDataset",
            "SnowflakeTable": "SnowflakeDataset",
            "SparkObject": "SparkObjectDataset",
            "SqlServerTable": "SqlServerTableDataset",
            "SquareObject": "SquareObjectDataset",
            "SybaseTable": "SybaseTableDataset",
            "TeradataTable": "TeradataTableDataset",
            "VerticaTable": "VerticaTableDataset",
            "WebTable": "WebTableDataset",
            "XeroObject": "XeroObjectDataset",
            "Xml": "XmlDataset",
            "ZohoObject": "ZohoObjectDataset",
        }
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.description = description
        self.structure = structure
        self.schema = schema
        self.linked_service_name = linked_service_name
        self.parameters = parameters
        self.annotations = annotations
        self.folder = folder


class AmazonMWSObjectDataset(Dataset):
    """Amazon Marketplace Web Service dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name. Type: string (or Expression with resultType string).
    :vartype table_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name. Type: string (or Expression with resultType string).
        :paramtype table_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AmazonMWSObject"  # type: str
        self.table_name = table_name


class CopySource(_serialization.Model):
    """A copy activity source.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmazonRdsForOracleSource, AvroSource, AzureBlobFSSource, AzureDataExplorerSource,
    AzureDataLakeStoreSource, AzureDatabricksDeltaLakeSource, BinarySource, BlobSource,
    CommonDataServiceForAppsSource, CosmosDbMongoDbApiSource, CosmosDbSqlApiSource,
    DelimitedTextSource, DocumentDbCollectionSource, DynamicsCrmSource, DynamicsSource,
    ExcelSource, FileSystemSource, HdfsSource, HttpSource, JsonSource, MicrosoftAccessSource,
    MongoDbAtlasSource, MongoDbSource, MongoDbV2Source, ODataSource, Office365Source, OracleSource,
    OrcSource, ParquetSource, RelationalSource, RestSource, SalesforceServiceCloudSource,
    SharePointOnlineListSource, SnowflakeSource, TabularSource, WebSource, XmlSource

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AmazonRdsForOracleSource": "AmazonRdsForOracleSource",
            "AvroSource": "AvroSource",
            "AzureBlobFSSource": "AzureBlobFSSource",
            "AzureDataExplorerSource": "AzureDataExplorerSource",
            "AzureDataLakeStoreSource": "AzureDataLakeStoreSource",
            "AzureDatabricksDeltaLakeSource": "AzureDatabricksDeltaLakeSource",
            "BinarySource": "BinarySource",
            "BlobSource": "BlobSource",
            "CommonDataServiceForAppsSource": "CommonDataServiceForAppsSource",
            "CosmosDbMongoDbApiSource": "CosmosDbMongoDbApiSource",
            "CosmosDbSqlApiSource": "CosmosDbSqlApiSource",
            "DelimitedTextSource": "DelimitedTextSource",
            "DocumentDbCollectionSource": "DocumentDbCollectionSource",
            "DynamicsCrmSource": "DynamicsCrmSource",
            "DynamicsSource": "DynamicsSource",
            "ExcelSource": "ExcelSource",
            "FileSystemSource": "FileSystemSource",
            "HdfsSource": "HdfsSource",
            "HttpSource": "HttpSource",
            "JsonSource": "JsonSource",
            "MicrosoftAccessSource": "MicrosoftAccessSource",
            "MongoDbAtlasSource": "MongoDbAtlasSource",
            "MongoDbSource": "MongoDbSource",
            "MongoDbV2Source": "MongoDbV2Source",
            "ODataSource": "ODataSource",
            "Office365Source": "Office365Source",
            "OracleSource": "OracleSource",
            "OrcSource": "OrcSource",
            "ParquetSource": "ParquetSource",
            "RelationalSource": "RelationalSource",
            "RestSource": "RestSource",
            "SalesforceServiceCloudSource": "SalesforceServiceCloudSource",
            "SharePointOnlineListSource": "SharePointOnlineListSource",
            "SnowflakeSource": "SnowflakeSource",
            "TabularSource": "TabularSource",
            "WebSource": "WebSource",
            "XmlSource": "XmlSource",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.source_retry_count = source_retry_count
        self.source_retry_wait = source_retry_wait
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection


class TabularSource(CopySource):
    """Copy activity sources of tabular type.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmazonMWSSource, AmazonRdsForSqlServerSource, AmazonRedshiftSource, AzureMariaDBSource,
    AzureMySqlSource, AzurePostgreSqlSource, AzureSqlSource, AzureTableSource, CassandraSource,
    ConcurSource, CouchbaseSource, Db2Source, DrillSource, DynamicsAXSource, EloquaSource,
    GoogleAdWordsSource, GoogleBigQuerySource, GreenplumSource, HBaseSource, HiveSource,
    HubspotSource, ImpalaSource, InformixSource, JiraSource, MagentoSource, MariaDBSource,
    MarketoSource, MySqlSource, NetezzaSource, OdbcSource, OracleServiceCloudSource, PaypalSource,
    PhoenixSource, PostgreSqlSource, PrestoSource, QuickBooksSource, ResponsysSource,
    SalesforceMarketingCloudSource, SalesforceSource, SapBwSource, SapCloudForCustomerSource,
    SapEccSource, SapHanaSource, SapOdpSource, SapOpenHubSource, SapTableSource, ServiceNowSource,
    ShopifySource, SparkSource, SqlDWSource, SqlMISource, SqlServerSource, SqlSource, SquareSource,
    SybaseSource, TeradataSource, VerticaSource, XeroSource, ZohoSource

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AmazonMWSSource": "AmazonMWSSource",
            "AmazonRdsForSqlServerSource": "AmazonRdsForSqlServerSource",
            "AmazonRedshiftSource": "AmazonRedshiftSource",
            "AzureMariaDBSource": "AzureMariaDBSource",
            "AzureMySqlSource": "AzureMySqlSource",
            "AzurePostgreSqlSource": "AzurePostgreSqlSource",
            "AzureSqlSource": "AzureSqlSource",
            "AzureTableSource": "AzureTableSource",
            "CassandraSource": "CassandraSource",
            "ConcurSource": "ConcurSource",
            "CouchbaseSource": "CouchbaseSource",
            "Db2Source": "Db2Source",
            "DrillSource": "DrillSource",
            "DynamicsAXSource": "DynamicsAXSource",
            "EloquaSource": "EloquaSource",
            "GoogleAdWordsSource": "GoogleAdWordsSource",
            "GoogleBigQuerySource": "GoogleBigQuerySource",
            "GreenplumSource": "GreenplumSource",
            "HBaseSource": "HBaseSource",
            "HiveSource": "HiveSource",
            "HubspotSource": "HubspotSource",
            "ImpalaSource": "ImpalaSource",
            "InformixSource": "InformixSource",
            "JiraSource": "JiraSource",
            "MagentoSource": "MagentoSource",
            "MariaDBSource": "MariaDBSource",
            "MarketoSource": "MarketoSource",
            "MySqlSource": "MySqlSource",
            "NetezzaSource": "NetezzaSource",
            "OdbcSource": "OdbcSource",
            "OracleServiceCloudSource": "OracleServiceCloudSource",
            "PaypalSource": "PaypalSource",
            "PhoenixSource": "PhoenixSource",
            "PostgreSqlSource": "PostgreSqlSource",
            "PrestoSource": "PrestoSource",
            "QuickBooksSource": "QuickBooksSource",
            "ResponsysSource": "ResponsysSource",
            "SalesforceMarketingCloudSource": "SalesforceMarketingCloudSource",
            "SalesforceSource": "SalesforceSource",
            "SapBwSource": "SapBwSource",
            "SapCloudForCustomerSource": "SapCloudForCustomerSource",
            "SapEccSource": "SapEccSource",
            "SapHanaSource": "SapHanaSource",
            "SapOdpSource": "SapOdpSource",
            "SapOpenHubSource": "SapOpenHubSource",
            "SapTableSource": "SapTableSource",
            "ServiceNowSource": "ServiceNowSource",
            "ShopifySource": "ShopifySource",
            "SparkSource": "SparkSource",
            "SqlDWSource": "SqlDWSource",
            "SqlMISource": "SqlMISource",
            "SqlServerSource": "SqlServerSource",
            "SqlSource": "SqlSource",
            "SquareSource": "SquareSource",
            "SybaseSource": "SybaseSource",
            "TeradataSource": "TeradataSource",
            "VerticaSource": "VerticaSource",
            "XeroSource": "XeroSource",
            "ZohoSource": "ZohoSource",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "TabularSource"  # type: str
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class AmazonMWSSource(TabularSource):
    """A copy activity Amazon Marketplace Web Service source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :vartype query: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: A query to retrieve data from source. Type: string (or Expression with
         resultType string).
        :paramtype query: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AmazonMWSSource"  # type: str
        self.query = query


class AmazonRdsForOracleLinkedService(LinkedService):
    """AmazonRdsForOracle database.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Required.
    :vartype connection_string: JSON
    :ivar password: The Azure key vault secret reference of password in connection string.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        password: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference. Required.
        :paramtype connection_string: JSON
        :keyword password: The Azure key vault secret reference of password in connection string.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AmazonRdsForOracle"  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AmazonRdsForOraclePartitionSettings(_serialization.Model):
    """The settings that will be leveraged for AmazonRdsForOracle source partitioning.

    :ivar partition_names: Names of the physical partitions of AmazonRdsForOracle table.
    :vartype partition_names: JSON
    :ivar partition_column_name: The name of the column in integer type that will be used for
     proceeding range partitioning. Type: string (or Expression with resultType string).
    :vartype partition_column_name: JSON
    :ivar partition_upper_bound: The maximum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :vartype partition_upper_bound: JSON
    :ivar partition_lower_bound: The minimum value of column specified in partitionColumnName that
     will be used for proceeding range partitioning. Type: string (or Expression with resultType
     string).
    :vartype partition_lower_bound: JSON
    """

    _attribute_map = {
        "partition_names": {"key": "partitionNames", "type": "object"},
        "partition_column_name": {"key": "partitionColumnName", "type": "object"},
        "partition_upper_bound": {"key": "partitionUpperBound", "type": "object"},
        "partition_lower_bound": {"key": "partitionLowerBound", "type": "object"},
    }

    def __init__(
        self,
        *,
        partition_names: Optional[JSON] = None,
        partition_column_name: Optional[JSON] = None,
        partition_upper_bound: Optional[JSON] = None,
        partition_lower_bound: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword partition_names: Names of the physical partitions of AmazonRdsForOracle table.
        :paramtype partition_names: JSON
        :keyword partition_column_name: The name of the column in integer type that will be used for
         proceeding range partitioning. Type: string (or Expression with resultType string).
        :paramtype partition_column_name: JSON
        :keyword partition_upper_bound: The maximum value of column specified in partitionColumnName
         that will be used for proceeding range partitioning. Type: string (or Expression with
         resultType string).
        :paramtype partition_upper_bound: JSON
        :keyword partition_lower_bound: The minimum value of column specified in partitionColumnName
         that will be used for proceeding range partitioning. Type: string (or Expression with
         resultType string).
        :paramtype partition_lower_bound: JSON
        """
        super().__init__(**kwargs)
        self.partition_names = partition_names
        self.partition_column_name = partition_column_name
        self.partition_upper_bound = partition_upper_bound
        self.partition_lower_bound = partition_lower_bound


class AmazonRdsForOracleSource(CopySource):  # pylint: disable=too-many-instance-attributes
    """A copy activity AmazonRdsForOracle source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar oracle_reader_query: AmazonRdsForOracle reader query. Type: string (or Expression with
     resultType string).
    :vartype oracle_reader_query: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar partition_option: The partition mechanism that will be used for AmazonRdsForOracle read
     in parallel. Type: string (or Expression with resultType string).
    :vartype partition_option: JSON
    :ivar partition_settings: The settings that will be leveraged for AmazonRdsForOracle source
     partitioning.
    :vartype partition_settings: ~azure.mgmt.datafactory.models.AmazonRdsForOraclePartitionSettings
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "oracle_reader_query": {"key": "oracleReaderQuery", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "partition_option": {"key": "partitionOption", "type": "object"},
        "partition_settings": {"key": "partitionSettings", "type": "AmazonRdsForOraclePartitionSettings"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        oracle_reader_query: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        partition_option: Optional[JSON] = None,
        partition_settings: Optional["_models.AmazonRdsForOraclePartitionSettings"] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword oracle_reader_query: AmazonRdsForOracle reader query. Type: string (or Expression with
         resultType string).
        :paramtype oracle_reader_query: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword partition_option: The partition mechanism that will be used for AmazonRdsForOracle
         read in parallel. Type: string (or Expression with resultType string).
        :paramtype partition_option: JSON
        :keyword partition_settings: The settings that will be leveraged for AmazonRdsForOracle source
         partitioning.
        :paramtype partition_settings:
         ~azure.mgmt.datafactory.models.AmazonRdsForOraclePartitionSettings
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AmazonRdsForOracleSource"  # type: str
        self.oracle_reader_query = oracle_reader_query
        self.query_timeout = query_timeout
        self.partition_option = partition_option
        self.partition_settings = partition_settings
        self.additional_columns = additional_columns


class AmazonRdsForOracleTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The AmazonRdsForOracle database dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar schema_type_properties_schema: The schema name of the AmazonRdsForOracle database. Type:
     string (or Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    :ivar table: The table name of the AmazonRdsForOracle database. Type: string (or Expression
     with resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword schema_type_properties_schema: The schema name of the AmazonRdsForOracle database.
         Type: string (or Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        :keyword table: The table name of the AmazonRdsForOracle database. Type: string (or Expression
         with resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AmazonRdsForOracleTable"  # type: str
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AmazonRdsForSqlServerLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Amazon RDS for SQL Server linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Required.
    :vartype connection_string: JSON
    :ivar user_name: The on-premises Windows authentication user name. Type: string (or Expression
     with resultType string).
    :vartype user_name: JSON
    :ivar password: The on-premises Windows authentication password.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar always_encrypted_settings: Sql always encrypted properties.
    :vartype always_encrypted_settings: ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "user_name": {"key": "typeProperties.userName", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "always_encrypted_settings": {
            "key": "typeProperties.alwaysEncryptedSettings",
            "type": "SqlAlwaysEncryptedProperties",
        },
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        user_name: Optional[JSON] = None,
        password: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        always_encrypted_settings: Optional["_models.SqlAlwaysEncryptedProperties"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference. Required.
        :paramtype connection_string: JSON
        :keyword user_name: The on-premises Windows authentication user name. Type: string (or
         Expression with resultType string).
        :paramtype user_name: JSON
        :keyword password: The on-premises Windows authentication password.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword always_encrypted_settings: Sql always encrypted properties.
        :paramtype always_encrypted_settings:
         ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AmazonRdsForSqlServer"  # type: str
        self.connection_string = connection_string
        self.user_name = user_name
        self.password = password
        self.encrypted_credential = encrypted_credential
        self.always_encrypted_settings = always_encrypted_settings


class AmazonRdsForSqlServerSource(TabularSource):  # pylint: disable=too-many-instance-attributes
    """A copy activity Amazon RDS for SQL Server source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar sql_reader_query: SQL reader query. Type: string (or Expression with resultType string).
    :vartype sql_reader_query: JSON
    :ivar sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database source.
     This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with
     resultType string).
    :vartype sql_reader_stored_procedure_name: JSON
    :ivar stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :vartype stored_procedure_parameters: JSON
    :ivar produce_additional_types: Which additional types to produce.
    :vartype produce_additional_types: JSON
    :ivar partition_option: The partition mechanism that will be used for Sql read in parallel.
     Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
    :vartype partition_option: JSON
    :ivar partition_settings: The settings that will be leveraged for Sql source partitioning.
    :vartype partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "sql_reader_query": {"key": "sqlReaderQuery", "type": "object"},
        "sql_reader_stored_procedure_name": {"key": "sqlReaderStoredProcedureName", "type": "object"},
        "stored_procedure_parameters": {"key": "storedProcedureParameters", "type": "object"},
        "produce_additional_types": {"key": "produceAdditionalTypes", "type": "object"},
        "partition_option": {"key": "partitionOption", "type": "object"},
        "partition_settings": {"key": "partitionSettings", "type": "SqlPartitionSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        sql_reader_query: Optional[JSON] = None,
        sql_reader_stored_procedure_name: Optional[JSON] = None,
        stored_procedure_parameters: Optional[JSON] = None,
        produce_additional_types: Optional[JSON] = None,
        partition_option: Optional[JSON] = None,
        partition_settings: Optional["_models.SqlPartitionSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword sql_reader_query: SQL reader query. Type: string (or Expression with resultType
         string).
        :paramtype sql_reader_query: JSON
        :keyword sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database
         source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression
         with resultType string).
        :paramtype sql_reader_stored_procedure_name: JSON
        :keyword stored_procedure_parameters: Value and type setting for stored procedure parameters.
         Example: "{Parameter1: {value: "1", type: "int"}}".
        :paramtype stored_procedure_parameters: JSON
        :keyword produce_additional_types: Which additional types to produce.
        :paramtype produce_additional_types: JSON
        :keyword partition_option: The partition mechanism that will be used for Sql read in parallel.
         Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
        :paramtype partition_option: JSON
        :keyword partition_settings: The settings that will be leveraged for Sql source partitioning.
        :paramtype partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AmazonRdsForSqlServerSource"  # type: str
        self.sql_reader_query = sql_reader_query
        self.sql_reader_stored_procedure_name = sql_reader_stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters
        self.produce_additional_types = produce_additional_types
        self.partition_option = partition_option
        self.partition_settings = partition_settings


class AmazonRdsForSqlServerTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Amazon RDS for SQL Server dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar schema_type_properties_schema: The schema name of the SQL Server dataset. Type: string
     (or Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    :ivar table: The table name of the SQL Server dataset. Type: string (or Expression with
     resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword schema_type_properties_schema: The schema name of the SQL Server dataset. Type: string
         (or Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        :keyword table: The table name of the SQL Server dataset. Type: string (or Expression with
         resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AmazonRdsForSqlServerTable"  # type: str
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AmazonRedshiftLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Linked service for Amazon Redshift.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar server: The name of the Amazon Redshift server. Type: string (or Expression with
     resultType string). Required.
    :vartype server: JSON
    :ivar username: The username of the Amazon Redshift source. Type: string (or Expression with
     resultType string).
    :vartype username: JSON
    :ivar password: The password of the Amazon Redshift source.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar database: The database name of the Amazon Redshift source. Type: string (or Expression
     with resultType string). Required.
    :vartype database: JSON
    :ivar port: The TCP port number that the Amazon Redshift server uses to listen for client
     connections. The default value is 5439. Type: integer (or Expression with resultType integer).
    :vartype port: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "server": {"required": True},
        "database": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "server": {"key": "typeProperties.server", "type": "object"},
        "username": {"key": "typeProperties.username", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "database": {"key": "typeProperties.database", "type": "object"},
        "port": {"key": "typeProperties.port", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        server: JSON,
        database: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        username: Optional[JSON] = None,
        password: Optional["_models.SecretBase"] = None,
        port: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword server: The name of the Amazon Redshift server. Type: string (or Expression with
         resultType string). Required.
        :paramtype server: JSON
        :keyword username: The username of the Amazon Redshift source. Type: string (or Expression with
         resultType string).
        :paramtype username: JSON
        :keyword password: The password of the Amazon Redshift source.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword database: The database name of the Amazon Redshift source. Type: string (or Expression
         with resultType string). Required.
        :paramtype database: JSON
        :keyword port: The TCP port number that the Amazon Redshift server uses to listen for client
         connections. The default value is 5439. Type: integer (or Expression with resultType integer).
        :paramtype port: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AmazonRedshift"  # type: str
        self.server = server
        self.username = username
        self.password = password
        self.database = database
        self.port = port
        self.encrypted_credential = encrypted_credential


class AmazonRedshiftSource(TabularSource):
    """A copy activity source for Amazon Redshift Source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: Database query. Type: string (or Expression with resultType string).
    :vartype query: JSON
    :ivar redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when
     copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be
     unloaded into S3 first and then copied into the targeted sink from the interim S3.
    :vartype redshift_unload_settings: ~azure.mgmt.datafactory.models.RedshiftUnloadSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
        "redshift_unload_settings": {"key": "redshiftUnloadSettings", "type": "RedshiftUnloadSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        redshift_unload_settings: Optional["_models.RedshiftUnloadSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: Database query. Type: string (or Expression with resultType string).
        :paramtype query: JSON
        :keyword redshift_unload_settings: The Amazon S3 settings needed for the interim Amazon S3 when
         copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be
         unloaded into S3 first and then copied into the targeted sink from the interim S3.
        :paramtype redshift_unload_settings: ~azure.mgmt.datafactory.models.RedshiftUnloadSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AmazonRedshiftSource"  # type: str
        self.query = query
        self.redshift_unload_settings = redshift_unload_settings


class AmazonRedshiftTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Amazon Redshift table dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :vartype table_name: JSON
    :ivar table: The Amazon Redshift table name. Type: string (or Expression with resultType
     string).
    :vartype table: JSON
    :ivar schema_type_properties_schema: The Amazon Redshift schema name. Type: string (or
     Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        table: Optional[JSON] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: This property will be retired. Please consider using schema + table
         properties instead.
        :paramtype table_name: JSON
        :keyword table: The Amazon Redshift table name. Type: string (or Expression with resultType
         string).
        :paramtype table: JSON
        :keyword schema_type_properties_schema: The Amazon Redshift schema name. Type: string (or
         Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AmazonRedshiftTable"  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AmazonS3CompatibleLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Linked service for Amazon S3 Compatible.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar access_key_id: The access key identifier of the Amazon S3 Compatible Identity and Access
     Management (IAM) user. Type: string (or Expression with resultType string).
    :vartype access_key_id: JSON
    :ivar secret_access_key: The secret access key of the Amazon S3 Compatible Identity and Access
     Management (IAM) user.
    :vartype secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar service_url: This value specifies the endpoint to access with the Amazon S3 Compatible
     Connector. This is an optional property; change it only if you want to try a different service
     endpoint or want to switch between https and http. Type: string (or Expression with resultType
     string).
    :vartype service_url: JSON
    :ivar force_path_style: If true, use S3 path-style access instead of virtual hosted-style
     access. Default value is false. Type: boolean (or Expression with resultType boolean).
    :vartype force_path_style: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "access_key_id": {"key": "typeProperties.accessKeyId", "type": "object"},
        "secret_access_key": {"key": "typeProperties.secretAccessKey", "type": "SecretBase"},
        "service_url": {"key": "typeProperties.serviceUrl", "type": "object"},
        "force_path_style": {"key": "typeProperties.forcePathStyle", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        access_key_id: Optional[JSON] = None,
        secret_access_key: Optional["_models.SecretBase"] = None,
        service_url: Optional[JSON] = None,
        force_path_style: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword access_key_id: The access key identifier of the Amazon S3 Compatible Identity and
         Access Management (IAM) user. Type: string (or Expression with resultType string).
        :paramtype access_key_id: JSON
        :keyword secret_access_key: The secret access key of the Amazon S3 Compatible Identity and
         Access Management (IAM) user.
        :paramtype secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword service_url: This value specifies the endpoint to access with the Amazon S3 Compatible
         Connector. This is an optional property; change it only if you want to try a different service
         endpoint or want to switch between https and http. Type: string (or Expression with resultType
         string).
        :paramtype service_url: JSON
        :keyword force_path_style: If true, use S3 path-style access instead of virtual hosted-style
         access. Default value is false. Type: boolean (or Expression with resultType boolean).
        :paramtype force_path_style: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AmazonS3Compatible"  # type: str
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.force_path_style = force_path_style
        self.encrypted_credential = encrypted_credential


class DatasetLocation(_serialization.Model):
    """Dataset location.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmazonS3CompatibleLocation, AmazonS3Location, AzureBlobFSLocation, AzureBlobStorageLocation,
    AzureDataLakeStoreLocation, AzureFileStorageLocation, FileServerLocation, FtpServerLocation,
    GoogleCloudStorageLocation, HdfsLocation, HttpServerLocation, OracleCloudStorageLocation,
    SftpLocation

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AmazonS3CompatibleLocation": "AmazonS3CompatibleLocation",
            "AmazonS3Location": "AmazonS3Location",
            "AzureBlobFSLocation": "AzureBlobFSLocation",
            "AzureBlobStorageLocation": "AzureBlobStorageLocation",
            "AzureDataLakeStoreLocation": "AzureDataLakeStoreLocation",
            "AzureFileStorageLocation": "AzureFileStorageLocation",
            "FileServerLocation": "FileServerLocation",
            "FtpServerLocation": "FtpServerLocation",
            "GoogleCloudStorageLocation": "GoogleCloudStorageLocation",
            "HdfsLocation": "HdfsLocation",
            "HttpServerLocation": "HttpServerLocation",
            "OracleCloudStorageLocation": "OracleCloudStorageLocation",
            "SftpLocation": "SftpLocation",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.folder_path = folder_path
        self.file_name = file_name


class AmazonS3CompatibleLocation(DatasetLocation):
    """The location of Amazon S3 Compatible dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    :ivar bucket_name: Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression
     with resultType string).
    :vartype bucket_name: JSON
    :ivar version: Specify the version of Amazon S3 Compatible. Type: string (or Expression with
     resultType string).
    :vartype version: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
        "bucket_name": {"key": "bucketName", "type": "object"},
        "version": {"key": "version", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        bucket_name: Optional[JSON] = None,
        version: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        :keyword bucket_name: Specify the bucketName of Amazon S3 Compatible. Type: string (or
         Expression with resultType string).
        :paramtype bucket_name: JSON
        :keyword version: Specify the version of Amazon S3 Compatible. Type: string (or Expression with
         resultType string).
        :paramtype version: JSON
        """
        super().__init__(
            additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs
        )
        self.type = "AmazonS3CompatibleLocation"  # type: str
        self.bucket_name = bucket_name
        self.version = version


class StoreReadSettings(_serialization.Model):
    """Connector read setting.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AmazonS3CompatibleReadSettings, AmazonS3ReadSettings, AzureBlobFSReadSettings,
    AzureBlobStorageReadSettings, AzureDataLakeStoreReadSettings, AzureFileStorageReadSettings,
    FileServerReadSettings, FtpReadSettings, GoogleCloudStorageReadSettings, HdfsReadSettings,
    HttpReadSettings, OracleCloudStorageReadSettings, SftpReadSettings

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AmazonS3CompatibleReadSettings": "AmazonS3CompatibleReadSettings",
            "AmazonS3ReadSettings": "AmazonS3ReadSettings",
            "AzureBlobFSReadSettings": "AzureBlobFSReadSettings",
            "AzureBlobStorageReadSettings": "AzureBlobStorageReadSettings",
            "AzureDataLakeStoreReadSettings": "AzureDataLakeStoreReadSettings",
            "AzureFileStorageReadSettings": "AzureFileStorageReadSettings",
            "FileServerReadSettings": "FileServerReadSettings",
            "FtpReadSettings": "FtpReadSettings",
            "GoogleCloudStorageReadSettings": "GoogleCloudStorageReadSettings",
            "HdfsReadSettings": "HdfsReadSettings",
            "HttpReadSettings": "HttpReadSettings",
            "OracleCloudStorageReadSettings": "OracleCloudStorageReadSettings",
            "SftpReadSettings": "SftpReadSettings",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection


class AmazonS3CompatibleReadSettings(StoreReadSettings):  # pylint: disable=too-many-instance-attributes
    """Amazon S3 Compatible read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    :ivar wildcard_folder_path: Amazon S3 Compatible wildcardFolderPath. Type: string (or
     Expression with resultType string).
    :vartype wildcard_folder_path: JSON
    :ivar wildcard_file_name: Amazon S3 Compatible wildcardFileName. Type: string (or Expression
     with resultType string).
    :vartype wildcard_file_name: JSON
    :ivar prefix: The prefix filter for the S3 Compatible object name. Type: string (or Expression
     with resultType string).
    :vartype prefix: JSON
    :ivar file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :vartype file_list_path: JSON
    :ivar enable_partition_discovery: Indicates whether to enable partition discovery.
    :vartype enable_partition_discovery: bool
    :ivar partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :vartype partition_root_path: JSON
    :ivar delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :vartype delete_files_after_completion: JSON
    :ivar modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :vartype modified_datetime_end: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
        "wildcard_folder_path": {"key": "wildcardFolderPath", "type": "object"},
        "wildcard_file_name": {"key": "wildcardFileName", "type": "object"},
        "prefix": {"key": "prefix", "type": "object"},
        "file_list_path": {"key": "fileListPath", "type": "object"},
        "enable_partition_discovery": {"key": "enablePartitionDiscovery", "type": "bool"},
        "partition_root_path": {"key": "partitionRootPath", "type": "object"},
        "delete_files_after_completion": {"key": "deleteFilesAfterCompletion", "type": "object"},
        "modified_datetime_start": {"key": "modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "modifiedDatetimeEnd", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        wildcard_folder_path: Optional[JSON] = None,
        wildcard_file_name: Optional[JSON] = None,
        prefix: Optional[JSON] = None,
        file_list_path: Optional[JSON] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[JSON] = None,
        delete_files_after_completion: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        :keyword wildcard_folder_path: Amazon S3 Compatible wildcardFolderPath. Type: string (or
         Expression with resultType string).
        :paramtype wildcard_folder_path: JSON
        :keyword wildcard_file_name: Amazon S3 Compatible wildcardFileName. Type: string (or Expression
         with resultType string).
        :paramtype wildcard_file_name: JSON
        :keyword prefix: The prefix filter for the S3 Compatible object name. Type: string (or
         Expression with resultType string).
        :paramtype prefix: JSON
        :keyword file_list_path: Point to a text file that lists each file (relative path to the path
         configured in the dataset) that you want to copy. Type: string (or Expression with resultType
         string).
        :paramtype file_list_path: JSON
        :keyword enable_partition_discovery: Indicates whether to enable partition discovery.
        :paramtype enable_partition_discovery: bool
        :keyword partition_root_path: Specify the root path where partition discovery starts from.
         Type: string (or Expression with resultType string).
        :paramtype partition_root_path: JSON
        :keyword delete_files_after_completion: Indicates whether the source files need to be deleted
         after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
        :paramtype delete_files_after_completion: JSON
        :keyword modified_datetime_start: The start of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AmazonS3CompatibleReadSettings"  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AmazonS3Dataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """A single Amazon Simple Storage Service (S3) object or a set of S3 objects.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar bucket_name: The name of the Amazon S3 bucket. Type: string (or Expression with
     resultType string). Required.
    :vartype bucket_name: JSON
    :ivar key: The key of the Amazon S3 object. Type: string (or Expression with resultType
     string).
    :vartype key: JSON
    :ivar prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :vartype prefix: JSON
    :ivar version: The version for the S3 object. Type: string (or Expression with resultType
     string).
    :vartype version: JSON
    :ivar modified_datetime_start: The start of S3 object's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of S3 object's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_end: JSON
    :ivar format: The format of files.
    :vartype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :ivar compression: The data compression method used for the Amazon S3 object.
    :vartype compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
        "bucket_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "bucket_name": {"key": "typeProperties.bucketName", "type": "object"},
        "key": {"key": "typeProperties.key", "type": "object"},
        "prefix": {"key": "typeProperties.prefix", "type": "object"},
        "version": {"key": "typeProperties.version", "type": "object"},
        "modified_datetime_start": {"key": "typeProperties.modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "typeProperties.modifiedDatetimeEnd", "type": "object"},
        "format": {"key": "typeProperties.format", "type": "DatasetStorageFormat"},
        "compression": {"key": "typeProperties.compression", "type": "DatasetCompression"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        bucket_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        key: Optional[JSON] = None,
        prefix: Optional[JSON] = None,
        version: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        format: Optional["_models.DatasetStorageFormat"] = None,
        compression: Optional["_models.DatasetCompression"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword bucket_name: The name of the Amazon S3 bucket. Type: string (or Expression with
         resultType string). Required.
        :paramtype bucket_name: JSON
        :keyword key: The key of the Amazon S3 object. Type: string (or Expression with resultType
         string).
        :paramtype key: JSON
        :keyword prefix: The prefix filter for the S3 object name. Type: string (or Expression with
         resultType string).
        :paramtype prefix: JSON
        :keyword version: The version for the S3 object. Type: string (or Expression with resultType
         string).
        :paramtype version: JSON
        :keyword modified_datetime_start: The start of S3 object's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of S3 object's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        :keyword format: The format of files.
        :paramtype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
        :keyword compression: The data compression method used for the Amazon S3 object.
        :paramtype compression: ~azure.mgmt.datafactory.models.DatasetCompression
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AmazonS3Object"  # type: str
        self.bucket_name = bucket_name
        self.key = key
        self.prefix = prefix
        self.version = version
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.compression = compression


class AmazonS3LinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Linked service for Amazon S3.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar authentication_type: The authentication type of S3. Allowed value: AccessKey (default) or
     TemporarySecurityCredentials. Type: string (or Expression with resultType string).
    :vartype authentication_type: JSON
    :ivar access_key_id: The access key identifier of the Amazon S3 Identity and Access Management
     (IAM) user. Type: string (or Expression with resultType string).
    :vartype access_key_id: JSON
    :ivar secret_access_key: The secret access key of the Amazon S3 Identity and Access Management
     (IAM) user.
    :vartype secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar service_url: This value specifies the endpoint to access with the S3 Connector. This is
     an optional property; change it only if you want to try a different service endpoint or want to
     switch between https and http. Type: string (or Expression with resultType string).
    :vartype service_url: JSON
    :ivar session_token: The session token for the S3 temporary security credential.
    :vartype session_token: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "authentication_type": {"key": "typeProperties.authenticationType", "type": "object"},
        "access_key_id": {"key": "typeProperties.accessKeyId", "type": "object"},
        "secret_access_key": {"key": "typeProperties.secretAccessKey", "type": "SecretBase"},
        "service_url": {"key": "typeProperties.serviceUrl", "type": "object"},
        "session_token": {"key": "typeProperties.sessionToken", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        authentication_type: Optional[JSON] = None,
        access_key_id: Optional[JSON] = None,
        secret_access_key: Optional["_models.SecretBase"] = None,
        service_url: Optional[JSON] = None,
        session_token: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword authentication_type: The authentication type of S3. Allowed value: AccessKey (default)
         or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
        :paramtype authentication_type: JSON
        :keyword access_key_id: The access key identifier of the Amazon S3 Identity and Access
         Management (IAM) user. Type: string (or Expression with resultType string).
        :paramtype access_key_id: JSON
        :keyword secret_access_key: The secret access key of the Amazon S3 Identity and Access
         Management (IAM) user.
        :paramtype secret_access_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword service_url: This value specifies the endpoint to access with the S3 Connector. This
         is an optional property; change it only if you want to try a different service endpoint or want
         to switch between https and http. Type: string (or Expression with resultType string).
        :paramtype service_url: JSON
        :keyword session_token: The session token for the S3 temporary security credential.
        :paramtype session_token: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AmazonS3"  # type: str
        self.authentication_type = authentication_type
        self.access_key_id = access_key_id
        self.secret_access_key = secret_access_key
        self.service_url = service_url
        self.session_token = session_token
        self.encrypted_credential = encrypted_credential


class AmazonS3Location(DatasetLocation):
    """The location of amazon S3 dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    :ivar bucket_name: Specify the bucketName of amazon S3. Type: string (or Expression with
     resultType string).
    :vartype bucket_name: JSON
    :ivar version: Specify the version of amazon S3. Type: string (or Expression with resultType
     string).
    :vartype version: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
        "bucket_name": {"key": "bucketName", "type": "object"},
        "version": {"key": "version", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        bucket_name: Optional[JSON] = None,
        version: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        :keyword bucket_name: Specify the bucketName of amazon S3. Type: string (or Expression with
         resultType string).
        :paramtype bucket_name: JSON
        :keyword version: Specify the version of amazon S3. Type: string (or Expression with resultType
         string).
        :paramtype version: JSON
        """
        super().__init__(
            additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs
        )
        self.type = "AmazonS3Location"  # type: str
        self.bucket_name = bucket_name
        self.version = version


class AmazonS3ReadSettings(StoreReadSettings):  # pylint: disable=too-many-instance-attributes
    """Amazon S3 read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    :ivar wildcard_folder_path: AmazonS3 wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :vartype wildcard_folder_path: JSON
    :ivar wildcard_file_name: AmazonS3 wildcardFileName. Type: string (or Expression with
     resultType string).
    :vartype wildcard_file_name: JSON
    :ivar prefix: The prefix filter for the S3 object name. Type: string (or Expression with
     resultType string).
    :vartype prefix: JSON
    :ivar file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :vartype file_list_path: JSON
    :ivar enable_partition_discovery: Indicates whether to enable partition discovery.
    :vartype enable_partition_discovery: bool
    :ivar partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :vartype partition_root_path: JSON
    :ivar delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :vartype delete_files_after_completion: JSON
    :ivar modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :vartype modified_datetime_end: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
        "wildcard_folder_path": {"key": "wildcardFolderPath", "type": "object"},
        "wildcard_file_name": {"key": "wildcardFileName", "type": "object"},
        "prefix": {"key": "prefix", "type": "object"},
        "file_list_path": {"key": "fileListPath", "type": "object"},
        "enable_partition_discovery": {"key": "enablePartitionDiscovery", "type": "bool"},
        "partition_root_path": {"key": "partitionRootPath", "type": "object"},
        "delete_files_after_completion": {"key": "deleteFilesAfterCompletion", "type": "object"},
        "modified_datetime_start": {"key": "modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "modifiedDatetimeEnd", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        wildcard_folder_path: Optional[JSON] = None,
        wildcard_file_name: Optional[JSON] = None,
        prefix: Optional[JSON] = None,
        file_list_path: Optional[JSON] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[JSON] = None,
        delete_files_after_completion: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        :keyword wildcard_folder_path: AmazonS3 wildcardFolderPath. Type: string (or Expression with
         resultType string).
        :paramtype wildcard_folder_path: JSON
        :keyword wildcard_file_name: AmazonS3 wildcardFileName. Type: string (or Expression with
         resultType string).
        :paramtype wildcard_file_name: JSON
        :keyword prefix: The prefix filter for the S3 object name. Type: string (or Expression with
         resultType string).
        :paramtype prefix: JSON
        :keyword file_list_path: Point to a text file that lists each file (relative path to the path
         configured in the dataset) that you want to copy. Type: string (or Expression with resultType
         string).
        :paramtype file_list_path: JSON
        :keyword enable_partition_discovery: Indicates whether to enable partition discovery.
        :paramtype enable_partition_discovery: bool
        :keyword partition_root_path: Specify the root path where partition discovery starts from.
         Type: string (or Expression with resultType string).
        :paramtype partition_root_path: JSON
        :keyword delete_files_after_completion: Indicates whether the source files need to be deleted
         after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
        :paramtype delete_files_after_completion: JSON
        :keyword modified_datetime_start: The start of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AmazonS3ReadSettings"  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class ControlActivity(Activity):
    """Base class for all control activities like IfCondition, ForEach , Until.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AppendVariableActivity, ExecutePipelineActivity, FailActivity, FilterActivity, ForEachActivity,
    IfConditionActivity, SetVariableActivity, SwitchActivity, UntilActivity, ValidationActivity,
    WaitActivity, WebHookActivity

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
    }

    _subtype_map = {
        "type": {
            "AppendVariable": "AppendVariableActivity",
            "ExecutePipeline": "ExecutePipelineActivity",
            "Fail": "FailActivity",
            "Filter": "FilterActivity",
            "ForEach": "ForEachActivity",
            "IfCondition": "IfConditionActivity",
            "SetVariable": "SetVariableActivity",
            "Switch": "SwitchActivity",
            "Until": "UntilActivity",
            "Validation": "ValidationActivity",
            "Wait": "WaitActivity",
            "WebHook": "WebHookActivity",
        }
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            **kwargs
        )
        self.type = "Container"  # type: str


class AppendVariableActivity(ControlActivity):
    """Append value for a Variable of type Array.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar variable_name: Name of the variable whose value needs to be appended to.
    :vartype variable_name: str
    :ivar value: Value to be appended. Could be a static value or Expression.
    :vartype value: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "variable_name": {"key": "typeProperties.variableName", "type": "str"},
        "value": {"key": "typeProperties.value", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        variable_name: Optional[str] = None,
        value: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword variable_name: Name of the variable whose value needs to be appended to.
        :paramtype variable_name: str
        :keyword value: Value to be appended. Could be a static value or Expression.
        :paramtype value: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            **kwargs
        )
        self.type = "AppendVariable"  # type: str
        self.variable_name = variable_name
        self.value = value


class AppFiguresLinkedService(LinkedService):
    """Linked service for AppFigures.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar user_name: The username of the Appfigures source. Required.
    :vartype user_name: JSON
    :ivar password: The password of the AppFigures source. Required.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar client_key: The client key for the AppFigures source. Required.
    :vartype client_key: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        "type": {"required": True},
        "user_name": {"required": True},
        "password": {"required": True},
        "client_key": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "user_name": {"key": "typeProperties.userName", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "client_key": {"key": "typeProperties.clientKey", "type": "SecretBase"},
    }

    def __init__(
        self,
        *,
        user_name: JSON,
        password: "_models.SecretBase",
        client_key: "_models.SecretBase",
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword user_name: The username of the Appfigures source. Required.
        :paramtype user_name: JSON
        :keyword password: The password of the AppFigures source. Required.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword client_key: The client key for the AppFigures source. Required.
        :paramtype client_key: ~azure.mgmt.datafactory.models.SecretBase
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AppFigures"  # type: str
        self.user_name = user_name
        self.password = password
        self.client_key = client_key


class ArmIdWrapper(_serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class AsanaLinkedService(LinkedService):
    """Linked service for Asana.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar api_token: The api token for the Asana source. Required.
    :vartype api_token: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "api_token": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "api_token": {"key": "typeProperties.apiToken", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        api_token: "_models.SecretBase",
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword api_token: The api token for the Asana source. Required.
        :paramtype api_token: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "Asana"  # type: str
        self.api_token = api_token
        self.encrypted_credential = encrypted_credential


class AvroDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """Avro dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar location: The location of the avro storage.
    :vartype location: ~azure.mgmt.datafactory.models.DatasetLocation
    :ivar avro_compression_codec: The data avroCompressionCodec. Type: string (or Expression with
     resultType string).
    :vartype avro_compression_codec: JSON
    :ivar avro_compression_level:
    :vartype avro_compression_level: int
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
        "avro_compression_level": {"maximum": 9, "minimum": 1},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "location": {"key": "typeProperties.location", "type": "DatasetLocation"},
        "avro_compression_codec": {"key": "typeProperties.avroCompressionCodec", "type": "object"},
        "avro_compression_level": {"key": "typeProperties.avroCompressionLevel", "type": "int"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        location: Optional["_models.DatasetLocation"] = None,
        avro_compression_codec: Optional[JSON] = None,
        avro_compression_level: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword location: The location of the avro storage.
        :paramtype location: ~azure.mgmt.datafactory.models.DatasetLocation
        :keyword avro_compression_codec: The data avroCompressionCodec. Type: string (or Expression
         with resultType string).
        :paramtype avro_compression_codec: JSON
        :keyword avro_compression_level:
        :paramtype avro_compression_level: int
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "Avro"  # type: str
        self.location = location
        self.avro_compression_codec = avro_compression_codec
        self.avro_compression_level = avro_compression_level


class DatasetStorageFormat(_serialization.Model):
    """The format definition of a storage.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AvroFormat, JsonFormat, OrcFormat, ParquetFormat, TextFormat

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage format. Required.
    :vartype type: str
    :ivar serializer: Serializer. Type: string (or Expression with resultType string).
    :vartype serializer: JSON
    :ivar deserializer: Deserializer. Type: string (or Expression with resultType string).
    :vartype deserializer: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "serializer": {"key": "serializer", "type": "object"},
        "deserializer": {"key": "deserializer", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AvroFormat": "AvroFormat",
            "JsonFormat": "JsonFormat",
            "OrcFormat": "OrcFormat",
            "ParquetFormat": "ParquetFormat",
            "TextFormat": "TextFormat",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        serializer: Optional[JSON] = None,
        deserializer: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword serializer: Serializer. Type: string (or Expression with resultType string).
        :paramtype serializer: JSON
        :keyword deserializer: Deserializer. Type: string (or Expression with resultType string).
        :paramtype deserializer: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.serializer = serializer
        self.deserializer = deserializer


class AvroFormat(DatasetStorageFormat):
    """The data stored in Avro format.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage format. Required.
    :vartype type: str
    :ivar serializer: Serializer. Type: string (or Expression with resultType string).
    :vartype serializer: JSON
    :ivar deserializer: Deserializer. Type: string (or Expression with resultType string).
    :vartype deserializer: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "serializer": {"key": "serializer", "type": "object"},
        "deserializer": {"key": "deserializer", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        serializer: Optional[JSON] = None,
        deserializer: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword serializer: Serializer. Type: string (or Expression with resultType string).
        :paramtype serializer: JSON
        :keyword deserializer: Deserializer. Type: string (or Expression with resultType string).
        :paramtype deserializer: JSON
        """
        super().__init__(
            additional_properties=additional_properties, serializer=serializer, deserializer=deserializer, **kwargs
        )
        self.type = "AvroFormat"  # type: str


class CopySink(_serialization.Model):
    """A copy activity sink.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AvroSink, AzureBlobFSSink, AzureDataExplorerSink, AzureDataLakeStoreSink,
    AzureDatabricksDeltaLakeSink, AzureMySqlSink, AzurePostgreSqlSink, AzureQueueSink,
    AzureSearchIndexSink, AzureSqlSink, AzureTableSink, BinarySink, BlobSink,
    CommonDataServiceForAppsSink, CosmosDbMongoDbApiSink, CosmosDbSqlApiSink, DelimitedTextSink,
    DocumentDbCollectionSink, DynamicsCrmSink, DynamicsSink, FileSystemSink, InformixSink,
    JsonSink, MicrosoftAccessSink, MongoDbAtlasSink, MongoDbV2Sink, OdbcSink, OracleSink, OrcSink,
    ParquetSink, RestSink, SalesforceServiceCloudSink, SalesforceSink, SapCloudForCustomerSink,
    SnowflakeSink, SqlDWSink, SqlMISink, SqlServerSink, SqlSink

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AvroSink": "AvroSink",
            "AzureBlobFSSink": "AzureBlobFSSink",
            "AzureDataExplorerSink": "AzureDataExplorerSink",
            "AzureDataLakeStoreSink": "AzureDataLakeStoreSink",
            "AzureDatabricksDeltaLakeSink": "AzureDatabricksDeltaLakeSink",
            "AzureMySqlSink": "AzureMySqlSink",
            "AzurePostgreSqlSink": "AzurePostgreSqlSink",
            "AzureQueueSink": "AzureQueueSink",
            "AzureSearchIndexSink": "AzureSearchIndexSink",
            "AzureSqlSink": "AzureSqlSink",
            "AzureTableSink": "AzureTableSink",
            "BinarySink": "BinarySink",
            "BlobSink": "BlobSink",
            "CommonDataServiceForAppsSink": "CommonDataServiceForAppsSink",
            "CosmosDbMongoDbApiSink": "CosmosDbMongoDbApiSink",
            "CosmosDbSqlApiSink": "CosmosDbSqlApiSink",
            "DelimitedTextSink": "DelimitedTextSink",
            "DocumentDbCollectionSink": "DocumentDbCollectionSink",
            "DynamicsCrmSink": "DynamicsCrmSink",
            "DynamicsSink": "DynamicsSink",
            "FileSystemSink": "FileSystemSink",
            "InformixSink": "InformixSink",
            "JsonSink": "JsonSink",
            "MicrosoftAccessSink": "MicrosoftAccessSink",
            "MongoDbAtlasSink": "MongoDbAtlasSink",
            "MongoDbV2Sink": "MongoDbV2Sink",
            "OdbcSink": "OdbcSink",
            "OracleSink": "OracleSink",
            "OrcSink": "OrcSink",
            "ParquetSink": "ParquetSink",
            "RestSink": "RestSink",
            "SalesforceServiceCloudSink": "SalesforceServiceCloudSink",
            "SalesforceSink": "SalesforceSink",
            "SapCloudForCustomerSink": "SapCloudForCustomerSink",
            "SnowflakeSink": "SnowflakeSink",
            "SqlDWSink": "SqlDWSink",
            "SqlMISink": "SqlMISink",
            "SqlServerSink": "SqlServerSink",
            "SqlSink": "SqlSink",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.write_batch_size = write_batch_size
        self.write_batch_timeout = write_batch_timeout
        self.sink_retry_count = sink_retry_count
        self.sink_retry_wait = sink_retry_wait
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection


class AvroSink(CopySink):
    """A copy activity Avro sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar store_settings: Avro store settings.
    :vartype store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    :ivar format_settings: Avro format settings.
    :vartype format_settings: ~azure.mgmt.datafactory.models.AvroWriteSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "store_settings": {"key": "storeSettings", "type": "StoreWriteSettings"},
        "format_settings": {"key": "formatSettings", "type": "AvroWriteSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        store_settings: Optional["_models.StoreWriteSettings"] = None,
        format_settings: Optional["_models.AvroWriteSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword store_settings: Avro store settings.
        :paramtype store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
        :keyword format_settings: Avro format settings.
        :paramtype format_settings: ~azure.mgmt.datafactory.models.AvroWriteSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AvroSink"  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class AvroSource(CopySource):
    """A copy activity Avro source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar store_settings: Avro store settings.
    :vartype store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "store_settings": {"key": "storeSettings", "type": "StoreReadSettings"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        store_settings: Optional["_models.StoreReadSettings"] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword store_settings: Avro store settings.
        :paramtype store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AvroSource"  # type: str
        self.store_settings = store_settings
        self.additional_columns = additional_columns


class FormatWriteSettings(_serialization.Model):
    """Format write settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AvroWriteSettings, DelimitedTextWriteSettings, JsonWriteSettings, OrcWriteSettings,
    ParquetWriteSettings

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AvroWriteSettings": "AvroWriteSettings",
            "DelimitedTextWriteSettings": "DelimitedTextWriteSettings",
            "JsonWriteSettings": "JsonWriteSettings",
            "OrcWriteSettings": "OrcWriteSettings",
            "ParquetWriteSettings": "ParquetWriteSettings",
        }
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]


class AvroWriteSettings(FormatWriteSettings):
    """Avro write settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    :ivar record_name: Top level record name in write result, which is required in AVRO spec.
    :vartype record_name: str
    :ivar record_namespace: Record namespace in the write result.
    :vartype record_namespace: str
    :ivar max_rows_per_file: Limit the written file's row count to be smaller than or equal to the
     specified count. Type: integer (or Expression with resultType integer).
    :vartype max_rows_per_file: JSON
    :ivar file_name_prefix: Specifies the file name pattern
     :code:`<fileNamePrefix>`_:code:`<fileIndex>`.:code:`<fileExtension>` when copy from non-file
     based store without partitionOptions. Type: string (or Expression with resultType string).
    :vartype file_name_prefix: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "record_name": {"key": "recordName", "type": "str"},
        "record_namespace": {"key": "recordNamespace", "type": "str"},
        "max_rows_per_file": {"key": "maxRowsPerFile", "type": "object"},
        "file_name_prefix": {"key": "fileNamePrefix", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        record_name: Optional[str] = None,
        record_namespace: Optional[str] = None,
        max_rows_per_file: Optional[JSON] = None,
        file_name_prefix: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword record_name: Top level record name in write result, which is required in AVRO spec.
        :paramtype record_name: str
        :keyword record_namespace: Record namespace in the write result.
        :paramtype record_namespace: str
        :keyword max_rows_per_file: Limit the written file's row count to be smaller than or equal to
         the specified count. Type: integer (or Expression with resultType integer).
        :paramtype max_rows_per_file: JSON
        :keyword file_name_prefix: Specifies the file name pattern
         :code:`<fileNamePrefix>`_:code:`<fileIndex>`.:code:`<fileExtension>` when copy from non-file
         based store without partitionOptions. Type: string (or Expression with resultType string).
        :paramtype file_name_prefix: JSON
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.type = "AvroWriteSettings"  # type: str
        self.record_name = record_name
        self.record_namespace = record_namespace
        self.max_rows_per_file = max_rows_per_file
        self.file_name_prefix = file_name_prefix


class CustomSetupBase(_serialization.Model):
    """The base definition of the custom setup.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzPowerShellSetup, CmdkeySetup, ComponentSetup, EnvironmentVariableSetup

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of custom setup. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AzPowerShellSetup": "AzPowerShellSetup",
            "CmdkeySetup": "CmdkeySetup",
            "ComponentSetup": "ComponentSetup",
            "EnvironmentVariableSetup": "EnvironmentVariableSetup",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzPowerShellSetup(CustomSetupBase):
    """The express custom setup of installing Azure PowerShell.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of custom setup. Required.
    :vartype type: str
    :ivar version: The required version of Azure PowerShell to install. Required.
    :vartype version: str
    """

    _validation = {
        "type": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "typeProperties.version", "type": "str"},
    }

    def __init__(self, *, version: str, **kwargs):
        """
        :keyword version: The required version of Azure PowerShell to install. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.type = "AzPowerShellSetup"  # type: str
        self.version = version


class AzureBatchLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Batch linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar account_name: The Azure Batch account name. Type: string (or Expression with resultType
     string). Required.
    :vartype account_name: JSON
    :ivar access_key: The Azure Batch account access key.
    :vartype access_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar batch_uri: The Azure Batch URI. Type: string (or Expression with resultType string).
     Required.
    :vartype batch_uri: JSON
    :ivar pool_name: The Azure Batch pool name. Type: string (or Expression with resultType
     string). Required.
    :vartype pool_name: JSON
    :ivar linked_service_name: The Azure Storage linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "account_name": {"required": True},
        "batch_uri": {"required": True},
        "pool_name": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "account_name": {"key": "typeProperties.accountName", "type": "object"},
        "access_key": {"key": "typeProperties.accessKey", "type": "SecretBase"},
        "batch_uri": {"key": "typeProperties.batchUri", "type": "object"},
        "pool_name": {"key": "typeProperties.poolName", "type": "object"},
        "linked_service_name": {"key": "typeProperties.linkedServiceName", "type": "LinkedServiceReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        account_name: JSON,
        batch_uri: JSON,
        pool_name: JSON,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        access_key: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword account_name: The Azure Batch account name. Type: string (or Expression with
         resultType string). Required.
        :paramtype account_name: JSON
        :keyword access_key: The Azure Batch account access key.
        :paramtype access_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword batch_uri: The Azure Batch URI. Type: string (or Expression with resultType string).
         Required.
        :paramtype batch_uri: JSON
        :keyword pool_name: The Azure Batch pool name. Type: string (or Expression with resultType
         string). Required.
        :paramtype pool_name: JSON
        :keyword linked_service_name: The Azure Storage linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureBatch"  # type: str
        self.account_name = account_name
        self.access_key = access_key
        self.batch_uri = batch_uri
        self.pool_name = pool_name
        self.linked_service_name = linked_service_name
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureBlobDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Azure Blob storage.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar folder_path: The path of the Azure Blob storage. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar table_root_location: The root of blob path. Type: string (or Expression with resultType
     string).
    :vartype table_root_location: JSON
    :ivar file_name: The name of the Azure Blob. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    :ivar modified_datetime_start: The start of Azure Blob's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of Azure Blob's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_end: JSON
    :ivar format: The format of the Azure Blob storage.
    :vartype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :ivar compression: The data compression method used for the blob storage.
    :vartype compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "folder_path": {"key": "typeProperties.folderPath", "type": "object"},
        "table_root_location": {"key": "typeProperties.tableRootLocation", "type": "object"},
        "file_name": {"key": "typeProperties.fileName", "type": "object"},
        "modified_datetime_start": {"key": "typeProperties.modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "typeProperties.modifiedDatetimeEnd", "type": "object"},
        "format": {"key": "typeProperties.format", "type": "DatasetStorageFormat"},
        "compression": {"key": "typeProperties.compression", "type": "DatasetCompression"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        folder_path: Optional[JSON] = None,
        table_root_location: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        format: Optional["_models.DatasetStorageFormat"] = None,
        compression: Optional["_models.DatasetCompression"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword folder_path: The path of the Azure Blob storage. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword table_root_location: The root of blob path. Type: string (or Expression with
         resultType string).
        :paramtype table_root_location: JSON
        :keyword file_name: The name of the Azure Blob. Type: string (or Expression with resultType
         string).
        :paramtype file_name: JSON
        :keyword modified_datetime_start: The start of Azure Blob's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of Azure Blob's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        :keyword format: The format of the Azure Blob storage.
        :paramtype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
        :keyword compression: The data compression method used for the blob storage.
        :paramtype compression: ~azure.mgmt.datafactory.models.DatasetCompression
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureBlob"  # type: str
        self.folder_path = folder_path
        self.table_root_location = table_root_location
        self.file_name = file_name
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end
        self.format = format
        self.compression = compression


class AzureBlobFSDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Azure Data Lake Storage Gen2 storage.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar folder_path: The path of the Azure Data Lake Storage Gen2 storage. Type: string (or
     Expression with resultType string).
    :vartype folder_path: JSON
    :ivar file_name: The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with
     resultType string).
    :vartype file_name: JSON
    :ivar format: The format of the Azure Data Lake Storage Gen2 storage.
    :vartype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :ivar compression: The data compression method used for the blob storage.
    :vartype compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "folder_path": {"key": "typeProperties.folderPath", "type": "object"},
        "file_name": {"key": "typeProperties.fileName", "type": "object"},
        "format": {"key": "typeProperties.format", "type": "DatasetStorageFormat"},
        "compression": {"key": "typeProperties.compression", "type": "DatasetCompression"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        format: Optional["_models.DatasetStorageFormat"] = None,
        compression: Optional["_models.DatasetCompression"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword folder_path: The path of the Azure Data Lake Storage Gen2 storage. Type: string (or
         Expression with resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: The name of the Azure Data Lake Storage Gen2. Type: string (or Expression
         with resultType string).
        :paramtype file_name: JSON
        :keyword format: The format of the Azure Data Lake Storage Gen2 storage.
        :paramtype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
        :keyword compression: The data compression method used for the blob storage.
        :paramtype compression: ~azure.mgmt.datafactory.models.DatasetCompression
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureBlobFSFile"  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression


class AzureBlobFSLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Data Lake Storage Gen2 linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar url: Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression
     with resultType string). Required.
    :vartype url: JSON
    :ivar account_key: Account key for the Azure Data Lake Storage Gen2 service. Type: string (or
     Expression with resultType string).
    :vartype account_key: JSON
    :ivar service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Storage Gen2 account.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    :ivar service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string).
    :vartype service_principal_credential_type: JSON
    :ivar service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :vartype service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        "type": {"required": True},
        "url": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "url": {"key": "typeProperties.url", "type": "object"},
        "account_key": {"key": "typeProperties.accountKey", "type": "object"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
        "service_principal_credential_type": {"key": "typeProperties.servicePrincipalCredentialType", "type": "object"},
        "service_principal_credential": {"key": "typeProperties.servicePrincipalCredential", "type": "SecretBase"},
    }

    def __init__(
        self,
        *,
        url: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        account_key: Optional[JSON] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        service_principal_credential_type: Optional[JSON] = None,
        service_principal_credential: Optional["_models.SecretBase"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword url: Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or
         Expression with resultType string). Required.
        :paramtype url: JSON
        :keyword account_key: Account key for the Azure Data Lake Storage Gen2 service. Type: string
         (or Expression with resultType string).
        :paramtype account_key: JSON
        :keyword service_principal_id: The ID of the application used to authenticate against the Azure
         Data Lake Storage Gen2 account. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The Key of the application used to authenticate against the
         Azure Data Lake Storage Gen2 account.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        :keyword service_principal_credential_type: The service principal credential type to use in
         Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
         for certificate. Type: string (or Expression with resultType string).
        :paramtype service_principal_credential_type: JSON
        :keyword service_principal_credential: The credential of the service principal object in Azure
         Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
         servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
         servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
         be AzureKeyVaultSecretReference.
        :paramtype service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureBlobFS"  # type: str
        self.url = url
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.credential = credential
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential


class AzureBlobFSLocation(DatasetLocation):
    """The location of azure blobFS dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    :ivar file_system: Specify the fileSystem of azure blobFS. Type: string (or Expression with
     resultType string).
    :vartype file_system: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
        "file_system": {"key": "fileSystem", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        file_system: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        :keyword file_system: Specify the fileSystem of azure blobFS. Type: string (or Expression with
         resultType string).
        :paramtype file_system: JSON
        """
        super().__init__(
            additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs
        )
        self.type = "AzureBlobFSLocation"  # type: str
        self.file_system = file_system


class AzureBlobFSReadSettings(StoreReadSettings):  # pylint: disable=too-many-instance-attributes
    """Azure blobFS read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    :ivar wildcard_folder_path: Azure blobFS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :vartype wildcard_folder_path: JSON
    :ivar wildcard_file_name: Azure blobFS wildcardFileName. Type: string (or Expression with
     resultType string).
    :vartype wildcard_file_name: JSON
    :ivar file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :vartype file_list_path: JSON
    :ivar enable_partition_discovery: Indicates whether to enable partition discovery.
    :vartype enable_partition_discovery: bool
    :ivar partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :vartype partition_root_path: JSON
    :ivar delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :vartype delete_files_after_completion: JSON
    :ivar modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :vartype modified_datetime_end: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
        "wildcard_folder_path": {"key": "wildcardFolderPath", "type": "object"},
        "wildcard_file_name": {"key": "wildcardFileName", "type": "object"},
        "file_list_path": {"key": "fileListPath", "type": "object"},
        "enable_partition_discovery": {"key": "enablePartitionDiscovery", "type": "bool"},
        "partition_root_path": {"key": "partitionRootPath", "type": "object"},
        "delete_files_after_completion": {"key": "deleteFilesAfterCompletion", "type": "object"},
        "modified_datetime_start": {"key": "modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "modifiedDatetimeEnd", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        wildcard_folder_path: Optional[JSON] = None,
        wildcard_file_name: Optional[JSON] = None,
        file_list_path: Optional[JSON] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[JSON] = None,
        delete_files_after_completion: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        :keyword wildcard_folder_path: Azure blobFS wildcardFolderPath. Type: string (or Expression
         with resultType string).
        :paramtype wildcard_folder_path: JSON
        :keyword wildcard_file_name: Azure blobFS wildcardFileName. Type: string (or Expression with
         resultType string).
        :paramtype wildcard_file_name: JSON
        :keyword file_list_path: Point to a text file that lists each file (relative path to the path
         configured in the dataset) that you want to copy. Type: string (or Expression with resultType
         string).
        :paramtype file_list_path: JSON
        :keyword enable_partition_discovery: Indicates whether to enable partition discovery.
        :paramtype enable_partition_discovery: bool
        :keyword partition_root_path: Specify the root path where partition discovery starts from.
         Type: string (or Expression with resultType string).
        :paramtype partition_root_path: JSON
        :keyword delete_files_after_completion: Indicates whether the source files need to be deleted
         after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
        :paramtype delete_files_after_completion: JSON
        :keyword modified_datetime_start: The start of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureBlobFSReadSettings"  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureBlobFSSink(CopySink):
    """A copy activity Azure Data Lake Storage Gen2 sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    :ivar metadata: Specify the custom metadata to be added to sink data. Type: array of objects
     (or Expression with resultType array of objects).
    :vartype metadata: list[~azure.mgmt.datafactory.models.MetadataItem]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
        "metadata": {"key": "metadata", "type": "[MetadataItem]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        metadata: Optional[List["_models.MetadataItem"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        :keyword metadata: Specify the custom metadata to be added to sink data. Type: array of objects
         (or Expression with resultType array of objects).
        :paramtype metadata: list[~azure.mgmt.datafactory.models.MetadataItem]
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureBlobFSSink"  # type: str
        self.copy_behavior = copy_behavior
        self.metadata = metadata


class AzureBlobFSSource(CopySource):
    """A copy activity Azure BlobFS source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :vartype treat_empty_as_null: JSON
    :ivar skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :vartype skip_header_line_count: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "treat_empty_as_null": {"key": "treatEmptyAsNull", "type": "object"},
        "skip_header_line_count": {"key": "skipHeaderLineCount", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        treat_empty_as_null: Optional[JSON] = None,
        skip_header_line_count: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
         boolean).
        :paramtype treat_empty_as_null: JSON
        :keyword skip_header_line_count: Number of header lines to skip from each blob. Type: integer
         (or Expression with resultType integer).
        :paramtype skip_header_line_count: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureBlobFSSource"  # type: str
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_header_line_count = skip_header_line_count
        self.recursive = recursive


class StoreWriteSettings(_serialization.Model):
    """Connector write settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBlobFSWriteSettings, AzureBlobStorageWriteSettings, AzureDataLakeStoreWriteSettings,
    AzureFileStorageWriteSettings, FileServerWriteSettings, SftpWriteSettings

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
    }

    _subtype_map = {
        "type": {
            "AzureBlobFSWriteSettings": "AzureBlobFSWriteSettings",
            "AzureBlobStorageWriteSettings": "AzureBlobStorageWriteSettings",
            "AzureDataLakeStoreWriteSettings": "AzureDataLakeStoreWriteSettings",
            "AzureFileStorageWriteSettings": "AzureFileStorageWriteSettings",
            "FileServerWriteSettings": "FileServerWriteSettings",
            "SftpWriteSettings": "SftpWriteSettings",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.max_concurrent_connections = max_concurrent_connections
        self.disable_metrics_collection = disable_metrics_collection
        self.copy_behavior = copy_behavior


class AzureBlobFSWriteSettings(StoreWriteSettings):
    """Azure blobFS write settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    :ivar block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :vartype block_size_in_mb: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
        "block_size_in_mb": {"key": "blockSizeInMB", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        block_size_in_mb: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        :keyword block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type:
         integer (or Expression with resultType integer).
        :paramtype block_size_in_mb: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            copy_behavior=copy_behavior,
            **kwargs
        )
        self.type = "AzureBlobFSWriteSettings"  # type: str
        self.block_size_in_mb = block_size_in_mb


class AzureBlobStorageLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """The azure blob storage linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. It is mutually exclusive with sasUri,
     serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar account_key: The Azure key vault secret reference of accountKey in connection string.
    :vartype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar sas_uri: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
     connectionString, serviceEndpoint property. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :vartype sas_uri: JSON
    :ivar sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :vartype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar service_endpoint: Blob service endpoint of the Azure Blob Storage resource. It is
     mutually exclusive with connectionString, sasUri property.
    :vartype service_endpoint: str
    :ivar service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar account_kind: Specify the kind of your storage account. Allowed values are: Storage
     (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type:
     string (or Expression with resultType string).
    :vartype account_kind: str
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: str
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "account_key": {"key": "typeProperties.accountKey", "type": "AzureKeyVaultSecretReference"},
        "sas_uri": {"key": "typeProperties.sasUri", "type": "object"},
        "sas_token": {"key": "typeProperties.sasToken", "type": "AzureKeyVaultSecretReference"},
        "service_endpoint": {"key": "typeProperties.serviceEndpoint", "type": "str"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "account_kind": {"key": "typeProperties.accountKind", "type": "str"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "str"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        account_key: Optional["_models.AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[JSON] = None,
        sas_token: Optional["_models.AzureKeyVaultSecretReference"] = None,
        service_endpoint: Optional[str] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        account_kind: Optional[str] = None,
        encrypted_credential: Optional[str] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. It is mutually exclusive with sasUri,
         serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword account_key: The Azure key vault secret reference of accountKey in connection string.
        :paramtype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword sas_uri: SAS URI of the Azure Blob Storage resource. It is mutually exclusive with
         connectionString, serviceEndpoint property. Type: string, SecureString or
         AzureKeyVaultSecretReference.
        :paramtype sas_uri: JSON
        :keyword sas_token: The Azure key vault secret reference of sasToken in sas uri.
        :paramtype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword service_endpoint: Blob service endpoint of the Azure Blob Storage resource. It is
         mutually exclusive with connectionString, sasUri property.
        :paramtype service_endpoint: str
        :keyword service_principal_id: The ID of the service principal used to authenticate against
         Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         Azure SQL Data Warehouse.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword account_kind: Specify the kind of your storage account. Allowed values are: Storage
         (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type:
         string (or Expression with resultType string).
        :paramtype account_kind: str
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: str
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureBlobStorage"  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.service_endpoint = service_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.account_kind = account_kind
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureBlobStorageLocation(DatasetLocation):
    """The location of azure blob dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    :ivar container: Specify the container of azure blob. Type: string (or Expression with
     resultType string).
    :vartype container: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
        "container": {"key": "container", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        container: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        :keyword container: Specify the container of azure blob. Type: string (or Expression with
         resultType string).
        :paramtype container: JSON
        """
        super().__init__(
            additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs
        )
        self.type = "AzureBlobStorageLocation"  # type: str
        self.container = container


class AzureBlobStorageReadSettings(StoreReadSettings):  # pylint: disable=too-many-instance-attributes
    """Azure blob read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    :ivar wildcard_folder_path: Azure blob wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :vartype wildcard_folder_path: JSON
    :ivar wildcard_file_name: Azure blob wildcardFileName. Type: string (or Expression with
     resultType string).
    :vartype wildcard_file_name: JSON
    :ivar prefix: The prefix filter for the Azure Blob name. Type: string (or Expression with
     resultType string).
    :vartype prefix: JSON
    :ivar file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :vartype file_list_path: JSON
    :ivar enable_partition_discovery: Indicates whether to enable partition discovery.
    :vartype enable_partition_discovery: bool
    :ivar partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :vartype partition_root_path: JSON
    :ivar delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :vartype delete_files_after_completion: JSON
    :ivar modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :vartype modified_datetime_end: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
        "wildcard_folder_path": {"key": "wildcardFolderPath", "type": "object"},
        "wildcard_file_name": {"key": "wildcardFileName", "type": "object"},
        "prefix": {"key": "prefix", "type": "object"},
        "file_list_path": {"key": "fileListPath", "type": "object"},
        "enable_partition_discovery": {"key": "enablePartitionDiscovery", "type": "bool"},
        "partition_root_path": {"key": "partitionRootPath", "type": "object"},
        "delete_files_after_completion": {"key": "deleteFilesAfterCompletion", "type": "object"},
        "modified_datetime_start": {"key": "modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "modifiedDatetimeEnd", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        wildcard_folder_path: Optional[JSON] = None,
        wildcard_file_name: Optional[JSON] = None,
        prefix: Optional[JSON] = None,
        file_list_path: Optional[JSON] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[JSON] = None,
        delete_files_after_completion: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        :keyword wildcard_folder_path: Azure blob wildcardFolderPath. Type: string (or Expression with
         resultType string).
        :paramtype wildcard_folder_path: JSON
        :keyword wildcard_file_name: Azure blob wildcardFileName. Type: string (or Expression with
         resultType string).
        :paramtype wildcard_file_name: JSON
        :keyword prefix: The prefix filter for the Azure Blob name. Type: string (or Expression with
         resultType string).
        :paramtype prefix: JSON
        :keyword file_list_path: Point to a text file that lists each file (relative path to the path
         configured in the dataset) that you want to copy. Type: string (or Expression with resultType
         string).
        :paramtype file_list_path: JSON
        :keyword enable_partition_discovery: Indicates whether to enable partition discovery.
        :paramtype enable_partition_discovery: bool
        :keyword partition_root_path: Specify the root path where partition discovery starts from.
         Type: string (or Expression with resultType string).
        :paramtype partition_root_path: JSON
        :keyword delete_files_after_completion: Indicates whether the source files need to be deleted
         after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
        :paramtype delete_files_after_completion: JSON
        :keyword modified_datetime_start: The start of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureBlobStorageReadSettings"  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureBlobStorageWriteSettings(StoreWriteSettings):
    """Azure blob write settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    :ivar block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type: integer
     (or Expression with resultType integer).
    :vartype block_size_in_mb: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
        "block_size_in_mb": {"key": "blockSizeInMB", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        block_size_in_mb: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        :keyword block_size_in_mb: Indicates the block size(MB) when writing data to blob. Type:
         integer (or Expression with resultType integer).
        :paramtype block_size_in_mb: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            copy_behavior=copy_behavior,
            **kwargs
        )
        self.type = "AzureBlobStorageWriteSettings"  # type: str
        self.block_size_in_mb = block_size_in_mb


class AzureDatabricksDeltaLakeDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """Azure Databricks Delta Lake dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table: The name of delta table. Type: string (or Expression with resultType string).
    :vartype table: JSON
    :ivar database: The database name of delta table. Type: string (or Expression with resultType
     string).
    :vartype database: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table": {"key": "typeProperties.table", "type": "object"},
        "database": {"key": "typeProperties.database", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table: Optional[JSON] = None,
        database: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table: The name of delta table. Type: string (or Expression with resultType string).
        :paramtype table: JSON
        :keyword database: The database name of delta table. Type: string (or Expression with
         resultType string).
        :paramtype database: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureDatabricksDeltaLakeDataset"  # type: str
        self.table = table
        self.database = database


class ExportSettings(_serialization.Model):
    """Export command settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureDatabricksDeltaLakeExportCommand, SnowflakeExportCopyCommand

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The export setting type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AzureDatabricksDeltaLakeExportCommand": "AzureDatabricksDeltaLakeExportCommand",
            "SnowflakeExportCopyCommand": "SnowflakeExportCopyCommand",
        }
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]


class AzureDatabricksDeltaLakeExportCommand(ExportSettings):
    """Azure Databricks Delta Lake export command settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The export setting type. Required.
    :vartype type: str
    :ivar date_format: Specify the date format for the csv in Azure Databricks Delta Lake Copy.
     Type: string (or Expression with resultType string).
    :vartype date_format: JSON
    :ivar timestamp_format: Specify the timestamp format for the csv in Azure Databricks Delta Lake
     Copy. Type: string (or Expression with resultType string).
    :vartype timestamp_format: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "object"},
        "timestamp_format": {"key": "timestampFormat", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        date_format: Optional[JSON] = None,
        timestamp_format: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword date_format: Specify the date format for the csv in Azure Databricks Delta Lake Copy.
         Type: string (or Expression with resultType string).
        :paramtype date_format: JSON
        :keyword timestamp_format: Specify the timestamp format for the csv in Azure Databricks Delta
         Lake Copy. Type: string (or Expression with resultType string).
        :paramtype timestamp_format: JSON
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.type = "AzureDatabricksDeltaLakeExportCommand"  # type: str
        self.date_format = date_format
        self.timestamp_format = timestamp_format


class ImportSettings(_serialization.Model):
    """Import command settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureDatabricksDeltaLakeImportCommand, SnowflakeImportCopyCommand

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The import setting type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "AzureDatabricksDeltaLakeImportCommand": "AzureDatabricksDeltaLakeImportCommand",
            "SnowflakeImportCopyCommand": "SnowflakeImportCopyCommand",
        }
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]


class AzureDatabricksDeltaLakeImportCommand(ImportSettings):
    """Azure Databricks Delta Lake import command settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The import setting type. Required.
    :vartype type: str
    :ivar date_format: Specify the date format for csv in Azure Databricks Delta Lake Copy. Type:
     string (or Expression with resultType string).
    :vartype date_format: JSON
    :ivar timestamp_format: Specify the timestamp format for csv in Azure Databricks Delta Lake
     Copy. Type: string (or Expression with resultType string).
    :vartype timestamp_format: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "date_format": {"key": "dateFormat", "type": "object"},
        "timestamp_format": {"key": "timestampFormat", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        date_format: Optional[JSON] = None,
        timestamp_format: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword date_format: Specify the date format for csv in Azure Databricks Delta Lake Copy.
         Type: string (or Expression with resultType string).
        :paramtype date_format: JSON
        :keyword timestamp_format: Specify the timestamp format for csv in Azure Databricks Delta Lake
         Copy. Type: string (or Expression with resultType string).
        :paramtype timestamp_format: JSON
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.type = "AzureDatabricksDeltaLakeImportCommand"  # type: str
        self.date_format = date_format
        self.timestamp_format = timestamp_format


class AzureDatabricksDeltaLakeLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Databricks Delta Lake linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar domain: :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks deployment.
     Type: string (or Expression with resultType string). Required.
    :vartype domain: JSON
    :ivar access_token: Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :vartype access_token: ~azure.mgmt.datafactory.models.SecretBase
    :ivar cluster_id: The id of an existing interactive cluster that will be used for all runs of
     this job. Type: string (or Expression with resultType string).
    :vartype cluster_id: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    :ivar workspace_resource_id: Workspace resource id for databricks REST API. Type: string (or
     Expression with resultType string).
    :vartype workspace_resource_id: JSON
    """

    _validation = {
        "type": {"required": True},
        "domain": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "domain": {"key": "typeProperties.domain", "type": "object"},
        "access_token": {"key": "typeProperties.accessToken", "type": "SecretBase"},
        "cluster_id": {"key": "typeProperties.clusterId", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
        "workspace_resource_id": {"key": "typeProperties.workspaceResourceId", "type": "object"},
    }

    def __init__(
        self,
        *,
        domain: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        access_token: Optional["_models.SecretBase"] = None,
        cluster_id: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        workspace_resource_id: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword domain: :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
         deployment. Type: string (or Expression with resultType string). Required.
        :paramtype domain: JSON
        :keyword access_token: Access token for databricks REST API. Refer to
         https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or
         AzureKeyVaultSecretReference.
        :paramtype access_token: ~azure.mgmt.datafactory.models.SecretBase
        :keyword cluster_id: The id of an existing interactive cluster that will be used for all runs
         of this job. Type: string (or Expression with resultType string).
        :paramtype cluster_id: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        :keyword workspace_resource_id: Workspace resource id for databricks REST API. Type: string (or
         Expression with resultType string).
        :paramtype workspace_resource_id: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureDatabricksDeltaLake"  # type: str
        self.domain = domain
        self.access_token = access_token
        self.cluster_id = cluster_id
        self.encrypted_credential = encrypted_credential
        self.credential = credential
        self.workspace_resource_id = workspace_resource_id


class AzureDatabricksDeltaLakeSink(CopySink):
    """A copy activity Azure Databricks Delta Lake sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :vartype pre_copy_script: JSON
    :ivar import_settings: Azure Databricks Delta Lake import settings.
    :vartype import_settings: ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeImportCommand
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "pre_copy_script": {"key": "preCopyScript", "type": "object"},
        "import_settings": {"key": "importSettings", "type": "AzureDatabricksDeltaLakeImportCommand"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        pre_copy_script: Optional[JSON] = None,
        import_settings: Optional["_models.AzureDatabricksDeltaLakeImportCommand"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
         string).
        :paramtype pre_copy_script: JSON
        :keyword import_settings: Azure Databricks Delta Lake import settings.
        :paramtype import_settings:
         ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeImportCommand
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDatabricksDeltaLakeSink"  # type: str
        self.pre_copy_script = pre_copy_script
        self.import_settings = import_settings


class AzureDatabricksDeltaLakeSource(CopySource):
    """A copy activity Azure Databricks Delta Lake source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query: Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType
     string).
    :vartype query: JSON
    :ivar export_settings: Azure Databricks Delta Lake export settings.
    :vartype export_settings: ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeExportCommand
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query": {"key": "query", "type": "object"},
        "export_settings": {"key": "exportSettings", "type": "AzureDatabricksDeltaLakeExportCommand"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query: Optional[JSON] = None,
        export_settings: Optional["_models.AzureDatabricksDeltaLakeExportCommand"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query: Azure Databricks Delta Lake Sql query. Type: string (or Expression with
         resultType string).
        :paramtype query: JSON
        :keyword export_settings: Azure Databricks Delta Lake export settings.
        :paramtype export_settings:
         ~azure.mgmt.datafactory.models.AzureDatabricksDeltaLakeExportCommand
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDatabricksDeltaLakeSource"  # type: str
        self.query = query
        self.export_settings = export_settings


class AzureDatabricksLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Databricks linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar domain: :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks deployment.
     Type: string (or Expression with resultType string). Required.
    :vartype domain: JSON
    :ivar access_token: Access token for databricks REST API. Refer to
     https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression
     with resultType string).
    :vartype access_token: ~azure.mgmt.datafactory.models.SecretBase
    :ivar authentication: Required to specify MSI, if using Workspace resource id for databricks
     REST API. Type: string (or Expression with resultType string).
    :vartype authentication: JSON
    :ivar workspace_resource_id: Workspace resource id for databricks REST API. Type: string (or
     Expression with resultType string).
    :vartype workspace_resource_id: JSON
    :ivar existing_cluster_id: The id of an existing interactive cluster that will be used for all
     runs of this activity. Type: string (or Expression with resultType string).
    :vartype existing_cluster_id: JSON
    :ivar instance_pool_id: The id of an existing instance pool that will be used for all runs of
     this activity. Type: string (or Expression with resultType string).
    :vartype instance_pool_id: JSON
    :ivar new_cluster_version: If not using an existing interactive cluster, this specifies the
     Spark version of a new job cluster or instance pool nodes created for each run of this
     activity. Required if instancePoolId is specified. Type: string (or Expression with resultType
     string).
    :vartype new_cluster_version: JSON
    :ivar new_cluster_num_of_worker: If not using an existing interactive cluster, this specifies
     the number of worker nodes to use for the new job cluster or instance pool. For new job
     clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means
     auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and
     can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is
     specified. Type: string (or Expression with resultType string).
    :vartype new_cluster_num_of_worker: JSON
    :ivar new_cluster_node_type: The node type of the new job cluster. This property is required if
     newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is
     specified, this property is ignored. Type: string (or Expression with resultType string).
    :vartype new_cluster_node_type: JSON
    :ivar new_cluster_spark_conf: A set of optional, user-specified Spark configuration key-value
     pairs.
    :vartype new_cluster_spark_conf: dict[str, JSON]
    :ivar new_cluster_spark_env_vars: A set of optional, user-specified Spark environment variables
     key-value pairs.
    :vartype new_cluster_spark_env_vars: dict[str, JSON]
    :ivar new_cluster_custom_tags: Additional tags for cluster resources. This property is ignored
     in instance pool configurations.
    :vartype new_cluster_custom_tags: dict[str, JSON]
    :ivar new_cluster_log_destination: Specify a location to deliver Spark driver, worker, and
     event logs. Type: string (or Expression with resultType string).
    :vartype new_cluster_log_destination: JSON
    :ivar new_cluster_driver_node_type: The driver node type for the new job cluster. This property
     is ignored in instance pool configurations. Type: string (or Expression with resultType
     string).
    :vartype new_cluster_driver_node_type: JSON
    :ivar new_cluster_init_scripts: User-defined initialization scripts for the new cluster. Type:
     array of strings (or Expression with resultType array of strings).
    :vartype new_cluster_init_scripts: JSON
    :ivar new_cluster_enable_elastic_disk: Enable the elastic disk on the new cluster. This
     property is now ignored, and takes the default elastic disk behavior in Databricks (elastic
     disks are always enabled). Type: boolean (or Expression with resultType boolean).
    :vartype new_cluster_enable_elastic_disk: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar policy_id: The policy id for limiting the ability to configure clusters based on a user
     defined set of rules. Type: string (or Expression with resultType string).
    :vartype policy_id: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "domain": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "domain": {"key": "typeProperties.domain", "type": "object"},
        "access_token": {"key": "typeProperties.accessToken", "type": "SecretBase"},
        "authentication": {"key": "typeProperties.authentication", "type": "object"},
        "workspace_resource_id": {"key": "typeProperties.workspaceResourceId", "type": "object"},
        "existing_cluster_id": {"key": "typeProperties.existingClusterId", "type": "object"},
        "instance_pool_id": {"key": "typeProperties.instancePoolId", "type": "object"},
        "new_cluster_version": {"key": "typeProperties.newClusterVersion", "type": "object"},
        "new_cluster_num_of_worker": {"key": "typeProperties.newClusterNumOfWorker", "type": "object"},
        "new_cluster_node_type": {"key": "typeProperties.newClusterNodeType", "type": "object"},
        "new_cluster_spark_conf": {"key": "typeProperties.newClusterSparkConf", "type": "{object}"},
        "new_cluster_spark_env_vars": {"key": "typeProperties.newClusterSparkEnvVars", "type": "{object}"},
        "new_cluster_custom_tags": {"key": "typeProperties.newClusterCustomTags", "type": "{object}"},
        "new_cluster_log_destination": {"key": "typeProperties.newClusterLogDestination", "type": "object"},
        "new_cluster_driver_node_type": {"key": "typeProperties.newClusterDriverNodeType", "type": "object"},
        "new_cluster_init_scripts": {"key": "typeProperties.newClusterInitScripts", "type": "object"},
        "new_cluster_enable_elastic_disk": {"key": "typeProperties.newClusterEnableElasticDisk", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "policy_id": {"key": "typeProperties.policyId", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        domain: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        access_token: Optional["_models.SecretBase"] = None,
        authentication: Optional[JSON] = None,
        workspace_resource_id: Optional[JSON] = None,
        existing_cluster_id: Optional[JSON] = None,
        instance_pool_id: Optional[JSON] = None,
        new_cluster_version: Optional[JSON] = None,
        new_cluster_num_of_worker: Optional[JSON] = None,
        new_cluster_node_type: Optional[JSON] = None,
        new_cluster_spark_conf: Optional[Dict[str, JSON]] = None,
        new_cluster_spark_env_vars: Optional[Dict[str, JSON]] = None,
        new_cluster_custom_tags: Optional[Dict[str, JSON]] = None,
        new_cluster_log_destination: Optional[JSON] = None,
        new_cluster_driver_node_type: Optional[JSON] = None,
        new_cluster_init_scripts: Optional[JSON] = None,
        new_cluster_enable_elastic_disk: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        policy_id: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword domain: :code:`<REGION>`.azuredatabricks.net, domain name of your Databricks
         deployment. Type: string (or Expression with resultType string). Required.
        :paramtype domain: JSON
        :keyword access_token: Access token for databricks REST API. Refer to
         https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string (or Expression
         with resultType string).
        :paramtype access_token: ~azure.mgmt.datafactory.models.SecretBase
        :keyword authentication: Required to specify MSI, if using Workspace resource id for databricks
         REST API. Type: string (or Expression with resultType string).
        :paramtype authentication: JSON
        :keyword workspace_resource_id: Workspace resource id for databricks REST API. Type: string (or
         Expression with resultType string).
        :paramtype workspace_resource_id: JSON
        :keyword existing_cluster_id: The id of an existing interactive cluster that will be used for
         all runs of this activity. Type: string (or Expression with resultType string).
        :paramtype existing_cluster_id: JSON
        :keyword instance_pool_id: The id of an existing instance pool that will be used for all runs
         of this activity. Type: string (or Expression with resultType string).
        :paramtype instance_pool_id: JSON
        :keyword new_cluster_version: If not using an existing interactive cluster, this specifies the
         Spark version of a new job cluster or instance pool nodes created for each run of this
         activity. Required if instancePoolId is specified. Type: string (or Expression with resultType
         string).
        :paramtype new_cluster_version: JSON
        :keyword new_cluster_num_of_worker: If not using an existing interactive cluster, this
         specifies the number of worker nodes to use for the new job cluster or instance pool. For new
         job clusters, this a string-formatted Int32, like '1' means numOfWorker is 1 or '1:10' means
         auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted Int32, and
         can only specify a fixed number of worker nodes, such as '2'. Required if newClusterVersion is
         specified. Type: string (or Expression with resultType string).
        :paramtype new_cluster_num_of_worker: JSON
        :keyword new_cluster_node_type: The node type of the new job cluster. This property is required
         if newClusterVersion is specified and instancePoolId is not specified. If instancePoolId is
         specified, this property is ignored. Type: string (or Expression with resultType string).
        :paramtype new_cluster_node_type: JSON
        :keyword new_cluster_spark_conf: A set of optional, user-specified Spark configuration
         key-value pairs.
        :paramtype new_cluster_spark_conf: dict[str, JSON]
        :keyword new_cluster_spark_env_vars: A set of optional, user-specified Spark environment
         variables key-value pairs.
        :paramtype new_cluster_spark_env_vars: dict[str, JSON]
        :keyword new_cluster_custom_tags: Additional tags for cluster resources. This property is
         ignored in instance pool configurations.
        :paramtype new_cluster_custom_tags: dict[str, JSON]
        :keyword new_cluster_log_destination: Specify a location to deliver Spark driver, worker, and
         event logs. Type: string (or Expression with resultType string).
        :paramtype new_cluster_log_destination: JSON
        :keyword new_cluster_driver_node_type: The driver node type for the new job cluster. This
         property is ignored in instance pool configurations. Type: string (or Expression with
         resultType string).
        :paramtype new_cluster_driver_node_type: JSON
        :keyword new_cluster_init_scripts: User-defined initialization scripts for the new cluster.
         Type: array of strings (or Expression with resultType array of strings).
        :paramtype new_cluster_init_scripts: JSON
        :keyword new_cluster_enable_elastic_disk: Enable the elastic disk on the new cluster. This
         property is now ignored, and takes the default elastic disk behavior in Databricks (elastic
         disks are always enabled). Type: boolean (or Expression with resultType boolean).
        :paramtype new_cluster_enable_elastic_disk: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword policy_id: The policy id for limiting the ability to configure clusters based on a
         user defined set of rules. Type: string (or Expression with resultType string).
        :paramtype policy_id: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureDatabricks"  # type: str
        self.domain = domain
        self.access_token = access_token
        self.authentication = authentication
        self.workspace_resource_id = workspace_resource_id
        self.existing_cluster_id = existing_cluster_id
        self.instance_pool_id = instance_pool_id
        self.new_cluster_version = new_cluster_version
        self.new_cluster_num_of_worker = new_cluster_num_of_worker
        self.new_cluster_node_type = new_cluster_node_type
        self.new_cluster_spark_conf = new_cluster_spark_conf
        self.new_cluster_spark_env_vars = new_cluster_spark_env_vars
        self.new_cluster_custom_tags = new_cluster_custom_tags
        self.new_cluster_log_destination = new_cluster_log_destination
        self.new_cluster_driver_node_type = new_cluster_driver_node_type
        self.new_cluster_init_scripts = new_cluster_init_scripts
        self.new_cluster_enable_elastic_disk = new_cluster_enable_elastic_disk
        self.encrypted_credential = encrypted_credential
        self.policy_id = policy_id
        self.credential = credential


class ExecutionActivity(Activity):
    """Base class for all execution activities.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureDataExplorerCommandActivity, AzureFunctionActivity, AzureMLBatchExecutionActivity,
    AzureMLExecutePipelineActivity, AzureMLUpdateResourceActivity, CopyActivity, CustomActivity,
    DataLakeAnalyticsUSQLActivity, DatabricksNotebookActivity, DatabricksSparkJarActivity,
    DatabricksSparkPythonActivity, DeleteActivity, ExecuteDataFlowActivity,
    ExecuteSSISPackageActivity, GetMetadataActivity, HDInsightHiveActivity,
    HDInsightMapReduceActivity, HDInsightPigActivity, HDInsightSparkActivity,
    HDInsightStreamingActivity, LookupActivity, ScriptActivity, SynapseSparkJobDefinitionActivity,
    SqlServerStoredProcedureActivity, SynapseNotebookActivity, WebActivity

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
    }

    _subtype_map = {
        "type": {
            "AzureDataExplorerCommand": "AzureDataExplorerCommandActivity",
            "AzureFunctionActivity": "AzureFunctionActivity",
            "AzureMLBatchExecution": "AzureMLBatchExecutionActivity",
            "AzureMLExecutePipeline": "AzureMLExecutePipelineActivity",
            "AzureMLUpdateResource": "AzureMLUpdateResourceActivity",
            "Copy": "CopyActivity",
            "Custom": "CustomActivity",
            "DataLakeAnalyticsU-SQL": "DataLakeAnalyticsUSQLActivity",
            "DatabricksNotebook": "DatabricksNotebookActivity",
            "DatabricksSparkJar": "DatabricksSparkJarActivity",
            "DatabricksSparkPython": "DatabricksSparkPythonActivity",
            "Delete": "DeleteActivity",
            "ExecuteDataFlow": "ExecuteDataFlowActivity",
            "ExecuteSSISPackage": "ExecuteSSISPackageActivity",
            "GetMetadata": "GetMetadataActivity",
            "HDInsightHive": "HDInsightHiveActivity",
            "HDInsightMapReduce": "HDInsightMapReduceActivity",
            "HDInsightPig": "HDInsightPigActivity",
            "HDInsightSpark": "HDInsightSparkActivity",
            "HDInsightStreaming": "HDInsightStreamingActivity",
            "Lookup": "LookupActivity",
            "Script": "ScriptActivity",
            "SparkJob": "SynapseSparkJobDefinitionActivity",
            "SqlServerStoredProcedure": "SqlServerStoredProcedureActivity",
            "SynapseNotebook": "SynapseNotebookActivity",
            "WebActivity": "WebActivity",
        }
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            **kwargs
        )
        self.type = "Execution"  # type: str
        self.linked_service_name = linked_service_name
        self.policy = policy


class AzureDataExplorerCommandActivity(ExecutionActivity):
    """Azure Data Explorer command activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar command: A control command, according to the Azure Data Explorer command syntax. Type:
     string (or Expression with resultType string). Required.
    :vartype command: JSON
    :ivar command_timeout: Control command timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..).
    :vartype command_timeout: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "command": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "command": {"key": "typeProperties.command", "type": "object"},
        "command_timeout": {"key": "typeProperties.commandTimeout", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        command: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        command_timeout: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword command: A control command, according to the Azure Data Explorer command syntax. Type:
         string (or Expression with resultType string). Required.
        :paramtype command: JSON
        :keyword command_timeout: Control command timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..).
        :paramtype command_timeout: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "AzureDataExplorerCommand"  # type: str
        self.command = command
        self.command_timeout = command_timeout


class AzureDataExplorerLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Data Explorer (Kusto) linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar endpoint: The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the
     format https://:code:`<clusterName>`.:code:`<regionName>`.kusto.windows.net. Type: string (or
     Expression with resultType string). Required.
    :vartype endpoint: JSON
    :ivar service_principal_id: The ID of the service principal used to authenticate against Azure
     Data Explorer. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against
     Kusto.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar database: Database name for connection. Type: string (or Expression with resultType
     string). Required.
    :vartype database: JSON
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "endpoint": {"required": True},
        "database": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "endpoint": {"key": "typeProperties.endpoint", "type": "object"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "database": {"key": "typeProperties.database", "type": "object"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        endpoint: JSON,
        database: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword endpoint: The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in
         the format https://:code:`<clusterName>`.:code:`<regionName>`.kusto.windows.net. Type: string
         (or Expression with resultType string). Required.
        :paramtype endpoint: JSON
        :keyword service_principal_id: The ID of the service principal used to authenticate against
         Azure Data Explorer. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         Kusto.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword database: Database name for connection. Type: string (or Expression with resultType
         string). Required.
        :paramtype database: JSON
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureDataExplorer"  # type: str
        self.endpoint = endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.database = database
        self.tenant = tenant
        self.credential = credential


class AzureDataExplorerSink(CopySink):  # pylint: disable=too-many-instance-attributes
    """A copy activity Azure Data Explorer sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar ingestion_mapping_name: A name of a pre-created csv mapping that was defined on the
     target Kusto table. Type: string.
    :vartype ingestion_mapping_name: JSON
    :ivar ingestion_mapping_as_json: An explicit column mapping description provided in a json
     format. Type: string.
    :vartype ingestion_mapping_as_json: JSON
    :ivar flush_immediately: If set to true, any aggregation will be skipped. Default is false.
     Type: boolean.
    :vartype flush_immediately: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "ingestion_mapping_name": {"key": "ingestionMappingName", "type": "object"},
        "ingestion_mapping_as_json": {"key": "ingestionMappingAsJson", "type": "object"},
        "flush_immediately": {"key": "flushImmediately", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        ingestion_mapping_name: Optional[JSON] = None,
        ingestion_mapping_as_json: Optional[JSON] = None,
        flush_immediately: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword ingestion_mapping_name: A name of a pre-created csv mapping that was defined on the
         target Kusto table. Type: string.
        :paramtype ingestion_mapping_name: JSON
        :keyword ingestion_mapping_as_json: An explicit column mapping description provided in a json
         format. Type: string.
        :paramtype ingestion_mapping_as_json: JSON
        :keyword flush_immediately: If set to true, any aggregation will be skipped. Default is false.
         Type: boolean.
        :paramtype flush_immediately: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDataExplorerSink"  # type: str
        self.ingestion_mapping_name = ingestion_mapping_name
        self.ingestion_mapping_as_json = ingestion_mapping_as_json
        self.flush_immediately = flush_immediately


class AzureDataExplorerSource(CopySource):
    """A copy activity Azure Data Explorer (Kusto) source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query: Database query. Should be a Kusto Query Language (KQL) query. Type: string (or
     Expression with resultType string). Required.
    :vartype query: JSON
    :ivar no_truncation: The name of the Boolean option that controls whether truncation is applied
     to result-sets that go beyond a certain row-count limit.
    :vartype no_truncation: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
        "query": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query": {"key": "query", "type": "object"},
        "no_truncation": {"key": "noTruncation", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        query: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        no_truncation: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query: Database query. Should be a Kusto Query Language (KQL) query. Type: string (or
         Expression with resultType string). Required.
        :paramtype query: JSON
        :keyword no_truncation: The name of the Boolean option that controls whether truncation is
         applied to result-sets that go beyond a certain row-count limit.
        :paramtype no_truncation: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDataExplorerSource"  # type: str
        self.query = query
        self.no_truncation = no_truncation
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class AzureDataExplorerTableDataset(Dataset):
    """The Azure Data Explorer (Kusto) dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table: The table name of the Azure Data Explorer database. Type: string (or Expression
     with resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table: The table name of the Azure Data Explorer database. Type: string (or Expression
         with resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureDataExplorerTable"  # type: str
        self.table = table


class AzureDataLakeAnalyticsLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Data Lake Analytics linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar account_name: The Azure Data Lake Analytics account name. Type: string (or Expression
     with resultType string). Required.
    :vartype account_name: JSON
    :ivar service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Analytics account. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Analytics account.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string). Required.
    :vartype tenant: JSON
    :ivar subscription_id: Data Lake Analytics account subscription ID (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :vartype subscription_id: JSON
    :ivar resource_group_name: Data Lake Analytics account resource group name (if different from
     Data Factory account). Type: string (or Expression with resultType string).
    :vartype resource_group_name: JSON
    :ivar data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression with
     resultType string).
    :vartype data_lake_analytics_uri: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "account_name": {"required": True},
        "tenant": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "account_name": {"key": "typeProperties.accountName", "type": "object"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "subscription_id": {"key": "typeProperties.subscriptionId", "type": "object"},
        "resource_group_name": {"key": "typeProperties.resourceGroupName", "type": "object"},
        "data_lake_analytics_uri": {"key": "typeProperties.dataLakeAnalyticsUri", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        account_name: JSON,
        tenant: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        subscription_id: Optional[JSON] = None,
        resource_group_name: Optional[JSON] = None,
        data_lake_analytics_uri: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword account_name: The Azure Data Lake Analytics account name. Type: string (or Expression
         with resultType string). Required.
        :paramtype account_name: JSON
        :keyword service_principal_id: The ID of the application used to authenticate against the Azure
         Data Lake Analytics account. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The Key of the application used to authenticate against the
         Azure Data Lake Analytics account.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string). Required.
        :paramtype tenant: JSON
        :keyword subscription_id: Data Lake Analytics account subscription ID (if different from Data
         Factory account). Type: string (or Expression with resultType string).
        :paramtype subscription_id: JSON
        :keyword resource_group_name: Data Lake Analytics account resource group name (if different
         from Data Factory account). Type: string (or Expression with resultType string).
        :paramtype resource_group_name: JSON
        :keyword data_lake_analytics_uri: Azure Data Lake Analytics URI Type: string (or Expression
         with resultType string).
        :paramtype data_lake_analytics_uri: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureDataLakeAnalytics"  # type: str
        self.account_name = account_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.data_lake_analytics_uri = data_lake_analytics_uri
        self.encrypted_credential = encrypted_credential


class AzureDataLakeStoreDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """Azure Data Lake Store dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar folder_path: Path to the folder in the Azure Data Lake Store. Type: string (or Expression
     with resultType string).
    :vartype folder_path: JSON
    :ivar file_name: The name of the file in the Azure Data Lake Store. Type: string (or Expression
     with resultType string).
    :vartype file_name: JSON
    :ivar format: The format of the Data Lake Store.
    :vartype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
    :ivar compression: The data compression method used for the item(s) in the Azure Data Lake
     Store.
    :vartype compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "folder_path": {"key": "typeProperties.folderPath", "type": "object"},
        "file_name": {"key": "typeProperties.fileName", "type": "object"},
        "format": {"key": "typeProperties.format", "type": "DatasetStorageFormat"},
        "compression": {"key": "typeProperties.compression", "type": "DatasetCompression"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        format: Optional["_models.DatasetStorageFormat"] = None,
        compression: Optional["_models.DatasetCompression"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword folder_path: Path to the folder in the Azure Data Lake Store. Type: string (or
         Expression with resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: The name of the file in the Azure Data Lake Store. Type: string (or
         Expression with resultType string).
        :paramtype file_name: JSON
        :keyword format: The format of the Data Lake Store.
        :paramtype format: ~azure.mgmt.datafactory.models.DatasetStorageFormat
        :keyword compression: The data compression method used for the item(s) in the Azure Data Lake
         Store.
        :paramtype compression: ~azure.mgmt.datafactory.models.DatasetCompression
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureDataLakeStoreFile"  # type: str
        self.folder_path = folder_path
        self.file_name = file_name
        self.format = format
        self.compression = compression


class AzureDataLakeStoreLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Data Lake Store linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar data_lake_store_uri: Data Lake Store service URI. Type: string (or Expression with
     resultType string). Required.
    :vartype data_lake_store_uri: JSON
    :ivar service_principal_id: The ID of the application used to authenticate against the Azure
     Data Lake Store account. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The Key of the application used to authenticate against the Azure
     Data Lake Store account.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar account_name: Data Lake Store account name. Type: string (or Expression with resultType
     string).
    :vartype account_name: JSON
    :ivar subscription_id: Data Lake Store account subscription ID (if different from Data Factory
     account). Type: string (or Expression with resultType string).
    :vartype subscription_id: JSON
    :ivar resource_group_name: Data Lake Store account resource group name (if different from Data
     Factory account). Type: string (or Expression with resultType string).
    :vartype resource_group_name: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "data_lake_store_uri": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "data_lake_store_uri": {"key": "typeProperties.dataLakeStoreUri", "type": "object"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "account_name": {"key": "typeProperties.accountName", "type": "object"},
        "subscription_id": {"key": "typeProperties.subscriptionId", "type": "object"},
        "resource_group_name": {"key": "typeProperties.resourceGroupName", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        data_lake_store_uri: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        account_name: Optional[JSON] = None,
        subscription_id: Optional[JSON] = None,
        resource_group_name: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword data_lake_store_uri: Data Lake Store service URI. Type: string (or Expression with
         resultType string). Required.
        :paramtype data_lake_store_uri: JSON
        :keyword service_principal_id: The ID of the application used to authenticate against the Azure
         Data Lake Store account. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The Key of the application used to authenticate against the
         Azure Data Lake Store account.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword account_name: Data Lake Store account name. Type: string (or Expression with
         resultType string).
        :paramtype account_name: JSON
        :keyword subscription_id: Data Lake Store account subscription ID (if different from Data
         Factory account). Type: string (or Expression with resultType string).
        :paramtype subscription_id: JSON
        :keyword resource_group_name: Data Lake Store account resource group name (if different from
         Data Factory account). Type: string (or Expression with resultType string).
        :paramtype resource_group_name: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureDataLakeStore"  # type: str
        self.data_lake_store_uri = data_lake_store_uri
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.account_name = account_name
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureDataLakeStoreLocation(DatasetLocation):
    """The location of azure data lake store dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs
        )
        self.type = "AzureDataLakeStoreLocation"  # type: str


class AzureDataLakeStoreReadSettings(StoreReadSettings):  # pylint: disable=too-many-instance-attributes
    """Azure data lake store read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    :ivar wildcard_folder_path: ADLS wildcardFolderPath. Type: string (or Expression with
     resultType string).
    :vartype wildcard_folder_path: JSON
    :ivar wildcard_file_name: ADLS wildcardFileName. Type: string (or Expression with resultType
     string).
    :vartype wildcard_file_name: JSON
    :ivar file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :vartype file_list_path: JSON
    :ivar list_after: Lists files after the value (exclusive) based on file/folder names’
     lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
     under the folderPath. Type: string (or Expression with resultType string).
    :vartype list_after: JSON
    :ivar list_before: Lists files before the value (inclusive) based on file/folder names’
     lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
     under the folderPath. Type: string (or Expression with resultType string).
    :vartype list_before: JSON
    :ivar enable_partition_discovery: Indicates whether to enable partition discovery.
    :vartype enable_partition_discovery: bool
    :ivar partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :vartype partition_root_path: JSON
    :ivar delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :vartype delete_files_after_completion: JSON
    :ivar modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :vartype modified_datetime_end: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
        "wildcard_folder_path": {"key": "wildcardFolderPath", "type": "object"},
        "wildcard_file_name": {"key": "wildcardFileName", "type": "object"},
        "file_list_path": {"key": "fileListPath", "type": "object"},
        "list_after": {"key": "listAfter", "type": "object"},
        "list_before": {"key": "listBefore", "type": "object"},
        "enable_partition_discovery": {"key": "enablePartitionDiscovery", "type": "bool"},
        "partition_root_path": {"key": "partitionRootPath", "type": "object"},
        "delete_files_after_completion": {"key": "deleteFilesAfterCompletion", "type": "object"},
        "modified_datetime_start": {"key": "modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "modifiedDatetimeEnd", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        wildcard_folder_path: Optional[JSON] = None,
        wildcard_file_name: Optional[JSON] = None,
        file_list_path: Optional[JSON] = None,
        list_after: Optional[JSON] = None,
        list_before: Optional[JSON] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[JSON] = None,
        delete_files_after_completion: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        :keyword wildcard_folder_path: ADLS wildcardFolderPath. Type: string (or Expression with
         resultType string).
        :paramtype wildcard_folder_path: JSON
        :keyword wildcard_file_name: ADLS wildcardFileName. Type: string (or Expression with resultType
         string).
        :paramtype wildcard_file_name: JSON
        :keyword file_list_path: Point to a text file that lists each file (relative path to the path
         configured in the dataset) that you want to copy. Type: string (or Expression with resultType
         string).
        :paramtype file_list_path: JSON
        :keyword list_after: Lists files after the value (exclusive) based on file/folder names’
         lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
         under the folderPath. Type: string (or Expression with resultType string).
        :paramtype list_after: JSON
        :keyword list_before: Lists files before the value (inclusive) based on file/folder names’
         lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders
         under the folderPath. Type: string (or Expression with resultType string).
        :paramtype list_before: JSON
        :keyword enable_partition_discovery: Indicates whether to enable partition discovery.
        :paramtype enable_partition_discovery: bool
        :keyword partition_root_path: Specify the root path where partition discovery starts from.
         Type: string (or Expression with resultType string).
        :paramtype partition_root_path: JSON
        :keyword delete_files_after_completion: Indicates whether the source files need to be deleted
         after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
        :paramtype delete_files_after_completion: JSON
        :keyword modified_datetime_start: The start of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDataLakeStoreReadSettings"  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.file_list_path = file_list_path
        self.list_after = list_after
        self.list_before = list_before
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureDataLakeStoreSink(CopySink):
    """A copy activity Azure Data Lake Store sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    :ivar enable_adls_single_file_parallel: Single File Parallel.
    :vartype enable_adls_single_file_parallel: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
        "enable_adls_single_file_parallel": {"key": "enableAdlsSingleFileParallel", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        enable_adls_single_file_parallel: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        :keyword enable_adls_single_file_parallel: Single File Parallel.
        :paramtype enable_adls_single_file_parallel: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDataLakeStoreSink"  # type: str
        self.copy_behavior = copy_behavior
        self.enable_adls_single_file_parallel = enable_adls_single_file_parallel


class AzureDataLakeStoreSource(CopySource):
    """A copy activity Azure Data Lake source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureDataLakeStoreSource"  # type: str
        self.recursive = recursive


class AzureDataLakeStoreWriteSettings(StoreWriteSettings):
    """Azure data lake store write settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    :ivar expiry_date_time: Specifies the expiry time of the written files. The time is applied to
     the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type: integer
     (or Expression with resultType integer).
    :vartype expiry_date_time: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
        "expiry_date_time": {"key": "expiryDateTime", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        expiry_date_time: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        :keyword expiry_date_time: Specifies the expiry time of the written files. The time is applied
         to the UTC time zone in the format of "2018-12-01T05:00:00Z". Default value is NULL. Type:
         integer (or Expression with resultType integer).
        :paramtype expiry_date_time: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            copy_behavior=copy_behavior,
            **kwargs
        )
        self.type = "AzureDataLakeStoreWriteSettings"  # type: str
        self.expiry_date_time = expiry_date_time


class AzureFileStorageLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure File Storage linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar host: Host name of the server. Type: string (or Expression with resultType string).
    :vartype host: JSON
    :ivar user_id: User ID to logon the server. Type: string (or Expression with resultType
     string).
    :vartype user_id: JSON
    :ivar password: Password to logon the server.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar account_key: The Azure key vault secret reference of accountKey in connection string.
    :vartype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar sas_uri: SAS URI of the Azure File resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype sas_uri: JSON
    :ivar sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :vartype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar file_share: The azure file share name. It is required when auth with accountKey/sasToken.
     Type: string (or Expression with resultType string).
    :vartype file_share: JSON
    :ivar snapshot: The azure file share snapshot version. Type: string (or Expression with
     resultType string).
    :vartype snapshot: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "host": {"key": "typeProperties.host", "type": "object"},
        "user_id": {"key": "typeProperties.userId", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "account_key": {"key": "typeProperties.accountKey", "type": "AzureKeyVaultSecretReference"},
        "sas_uri": {"key": "typeProperties.sasUri", "type": "object"},
        "sas_token": {"key": "typeProperties.sasToken", "type": "AzureKeyVaultSecretReference"},
        "file_share": {"key": "typeProperties.fileShare", "type": "object"},
        "snapshot": {"key": "typeProperties.snapshot", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        host: Optional[JSON] = None,
        user_id: Optional[JSON] = None,
        password: Optional["_models.SecretBase"] = None,
        connection_string: Optional[JSON] = None,
        account_key: Optional["_models.AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[JSON] = None,
        sas_token: Optional["_models.AzureKeyVaultSecretReference"] = None,
        file_share: Optional[JSON] = None,
        snapshot: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword host: Host name of the server. Type: string (or Expression with resultType string).
        :paramtype host: JSON
        :keyword user_id: User ID to logon the server. Type: string (or Expression with resultType
         string).
        :paramtype user_id: JSON
        :keyword password: Password to logon the server.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword connection_string: The connection string. It is mutually exclusive with sasUri
         property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword account_key: The Azure key vault secret reference of accountKey in connection string.
        :paramtype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword sas_uri: SAS URI of the Azure File resource. It is mutually exclusive with
         connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype sas_uri: JSON
        :keyword sas_token: The Azure key vault secret reference of sasToken in sas uri.
        :paramtype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword file_share: The azure file share name. It is required when auth with
         accountKey/sasToken. Type: string (or Expression with resultType string).
        :paramtype file_share: JSON
        :keyword snapshot: The azure file share snapshot version. Type: string (or Expression with
         resultType string).
        :paramtype snapshot: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureFileStorage"  # type: str
        self.host = host
        self.user_id = user_id
        self.password = password
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.file_share = file_share
        self.snapshot = snapshot
        self.encrypted_credential = encrypted_credential


class AzureFileStorageLocation(DatasetLocation):
    """The location of file server dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset storage location. Required.
    :vartype type: str
    :ivar folder_path: Specify the folder path of dataset. Type: string (or Expression with
     resultType string).
    :vartype folder_path: JSON
    :ivar file_name: Specify the file name of dataset. Type: string (or Expression with resultType
     string).
    :vartype file_name: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "folder_path": {"key": "folderPath", "type": "object"},
        "file_name": {"key": "fileName", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        folder_path: Optional[JSON] = None,
        file_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword folder_path: Specify the folder path of dataset. Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword file_name: Specify the file name of dataset. Type: string (or Expression with
         resultType string).
        :paramtype file_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties, folder_path=folder_path, file_name=file_name, **kwargs
        )
        self.type = "AzureFileStorageLocation"  # type: str


class AzureFileStorageReadSettings(StoreReadSettings):  # pylint: disable=too-many-instance-attributes
    """Azure File Storage read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    :ivar wildcard_folder_path: Azure File Storage wildcardFolderPath. Type: string (or Expression
     with resultType string).
    :vartype wildcard_folder_path: JSON
    :ivar wildcard_file_name: Azure File Storage wildcardFileName. Type: string (or Expression with
     resultType string).
    :vartype wildcard_file_name: JSON
    :ivar prefix: The prefix filter for the Azure File name starting from root path. Type: string
     (or Expression with resultType string).
    :vartype prefix: JSON
    :ivar file_list_path: Point to a text file that lists each file (relative path to the path
     configured in the dataset) that you want to copy. Type: string (or Expression with resultType
     string).
    :vartype file_list_path: JSON
    :ivar enable_partition_discovery: Indicates whether to enable partition discovery.
    :vartype enable_partition_discovery: bool
    :ivar partition_root_path: Specify the root path where partition discovery starts from. Type:
     string (or Expression with resultType string).
    :vartype partition_root_path: JSON
    :ivar delete_files_after_completion: Indicates whether the source files need to be deleted
     after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
    :vartype delete_files_after_completion: JSON
    :ivar modified_datetime_start: The start of file's modified datetime. Type: string (or
     Expression with resultType string).
    :vartype modified_datetime_start: JSON
    :ivar modified_datetime_end: The end of file's modified datetime. Type: string (or Expression
     with resultType string).
    :vartype modified_datetime_end: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
        "wildcard_folder_path": {"key": "wildcardFolderPath", "type": "object"},
        "wildcard_file_name": {"key": "wildcardFileName", "type": "object"},
        "prefix": {"key": "prefix", "type": "object"},
        "file_list_path": {"key": "fileListPath", "type": "object"},
        "enable_partition_discovery": {"key": "enablePartitionDiscovery", "type": "bool"},
        "partition_root_path": {"key": "partitionRootPath", "type": "object"},
        "delete_files_after_completion": {"key": "deleteFilesAfterCompletion", "type": "object"},
        "modified_datetime_start": {"key": "modifiedDatetimeStart", "type": "object"},
        "modified_datetime_end": {"key": "modifiedDatetimeEnd", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        wildcard_folder_path: Optional[JSON] = None,
        wildcard_file_name: Optional[JSON] = None,
        prefix: Optional[JSON] = None,
        file_list_path: Optional[JSON] = None,
        enable_partition_discovery: Optional[bool] = None,
        partition_root_path: Optional[JSON] = None,
        delete_files_after_completion: Optional[JSON] = None,
        modified_datetime_start: Optional[JSON] = None,
        modified_datetime_end: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        :keyword wildcard_folder_path: Azure File Storage wildcardFolderPath. Type: string (or
         Expression with resultType string).
        :paramtype wildcard_folder_path: JSON
        :keyword wildcard_file_name: Azure File Storage wildcardFileName. Type: string (or Expression
         with resultType string).
        :paramtype wildcard_file_name: JSON
        :keyword prefix: The prefix filter for the Azure File name starting from root path. Type:
         string (or Expression with resultType string).
        :paramtype prefix: JSON
        :keyword file_list_path: Point to a text file that lists each file (relative path to the path
         configured in the dataset) that you want to copy. Type: string (or Expression with resultType
         string).
        :paramtype file_list_path: JSON
        :keyword enable_partition_discovery: Indicates whether to enable partition discovery.
        :paramtype enable_partition_discovery: bool
        :keyword partition_root_path: Specify the root path where partition discovery starts from.
         Type: string (or Expression with resultType string).
        :paramtype partition_root_path: JSON
        :keyword delete_files_after_completion: Indicates whether the source files need to be deleted
         after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
        :paramtype delete_files_after_completion: JSON
        :keyword modified_datetime_start: The start of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_start: JSON
        :keyword modified_datetime_end: The end of file's modified datetime. Type: string (or
         Expression with resultType string).
        :paramtype modified_datetime_end: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureFileStorageReadSettings"  # type: str
        self.recursive = recursive
        self.wildcard_folder_path = wildcard_folder_path
        self.wildcard_file_name = wildcard_file_name
        self.prefix = prefix
        self.file_list_path = file_list_path
        self.enable_partition_discovery = enable_partition_discovery
        self.partition_root_path = partition_root_path
        self.delete_files_after_completion = delete_files_after_completion
        self.modified_datetime_start = modified_datetime_start
        self.modified_datetime_end = modified_datetime_end


class AzureFileStorageWriteSettings(StoreWriteSettings):
    """Azure File Storage write settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The write setting type. Required.
    :vartype type: str
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            copy_behavior=copy_behavior,
            **kwargs
        )
        self.type = "AzureFileStorageWriteSettings"  # type: str


class AzureFunctionActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Azure Function activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar method: Rest API method for target endpoint. Required. Known values are: "GET", "POST",
     "PUT", "DELETE", "OPTIONS", "HEAD", and "TRACE".
    :vartype method: str or ~azure.mgmt.datafactory.models.AzureFunctionActivityMethod
    :ivar function_name: Name of the Function that the Azure Function Activity will call. Type:
     string (or Expression with resultType string). Required.
    :vartype function_name: JSON
    :ivar headers: Represents the headers that will be sent to the request. For example, to set the
     language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type":
     "application/json" }. Type: string (or Expression with resultType string).
    :vartype headers: JSON
    :ivar body: Represents the payload that will be sent to the endpoint. Required for POST/PUT
     method, not allowed for GET method Type: string (or Expression with resultType string).
    :vartype body: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "method": {"required": True},
        "function_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "method": {"key": "typeProperties.method", "type": "str"},
        "function_name": {"key": "typeProperties.functionName", "type": "object"},
        "headers": {"key": "typeProperties.headers", "type": "object"},
        "body": {"key": "typeProperties.body", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        method: Union[str, "_models.AzureFunctionActivityMethod"],
        function_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        headers: Optional[JSON] = None,
        body: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword method: Rest API method for target endpoint. Required. Known values are: "GET",
         "POST", "PUT", "DELETE", "OPTIONS", "HEAD", and "TRACE".
        :paramtype method: str or ~azure.mgmt.datafactory.models.AzureFunctionActivityMethod
        :keyword function_name: Name of the Function that the Azure Function Activity will call. Type:
         string (or Expression with resultType string). Required.
        :paramtype function_name: JSON
        :keyword headers: Represents the headers that will be sent to the request. For example, to set
         the language and type on a request: "headers" : { "Accept-Language": "en-us", "Content-Type":
         "application/json" }. Type: string (or Expression with resultType string).
        :paramtype headers: JSON
        :keyword body: Represents the payload that will be sent to the endpoint. Required for POST/PUT
         method, not allowed for GET method Type: string (or Expression with resultType string).
        :paramtype body: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "AzureFunctionActivity"  # type: str
        self.method = method
        self.function_name = function_name
        self.headers = headers
        self.body = body


class AzureFunctionLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure Function linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar function_app_url: The endpoint of the Azure Function App. URL will be in the format
     https://:code:`<accountName>`.azurewebsites.net. Required.
    :vartype function_app_url: JSON
    :ivar function_key: Function or Host key for Azure Function App.
    :vartype function_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    :ivar resource_id: Allowed token audiences for azure function.
    :vartype resource_id: JSON
    :ivar authentication: Type of authentication (Required to specify MSI) used to connect to
     AzureFunction. Type: string (or Expression with resultType string).
    :vartype authentication: JSON
    """

    _validation = {
        "type": {"required": True},
        "function_app_url": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "function_app_url": {"key": "typeProperties.functionAppUrl", "type": "object"},
        "function_key": {"key": "typeProperties.functionKey", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
        "resource_id": {"key": "typeProperties.resourceId", "type": "object"},
        "authentication": {"key": "typeProperties.authentication", "type": "object"},
    }

    def __init__(
        self,
        *,
        function_app_url: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        function_key: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        resource_id: Optional[JSON] = None,
        authentication: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword function_app_url: The endpoint of the Azure Function App. URL will be in the format
         https://:code:`<accountName>`.azurewebsites.net. Required.
        :paramtype function_app_url: JSON
        :keyword function_key: Function or Host key for Azure Function App.
        :paramtype function_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        :keyword resource_id: Allowed token audiences for azure function.
        :paramtype resource_id: JSON
        :keyword authentication: Type of authentication (Required to specify MSI) used to connect to
         AzureFunction. Type: string (or Expression with resultType string).
        :paramtype authentication: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureFunction"  # type: str
        self.function_app_url = function_app_url
        self.function_key = function_key
        self.encrypted_credential = encrypted_credential
        self.credential = credential
        self.resource_id = resource_id
        self.authentication = authentication


class AzureKeyVaultLinkedService(LinkedService):
    """Azure Key Vault linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar base_url: The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type:
     string (or Expression with resultType string). Required.
    :vartype base_url: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "base_url": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "base_url": {"key": "typeProperties.baseUrl", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        base_url: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword base_url: The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net
         Type: string (or Expression with resultType string). Required.
        :paramtype base_url: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureKeyVault"  # type: str
        self.base_url = base_url
        self.credential = credential


class SecretBase(_serialization.Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureKeyVaultSecretReference, SecureString

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the secret. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"AzureKeyVaultSecret": "AzureKeyVaultSecretReference", "SecureString": "SecureString"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class AzureKeyVaultSecretReference(SecretBase):
    """Azure Key Vault secret reference.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of the secret. Required.
    :vartype type: str
    :ivar store: The Azure Key Vault linked service reference. Required.
    :vartype store: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar secret_name: The name of the secret in Azure Key Vault. Type: string (or Expression with
     resultType string). Required.
    :vartype secret_name: JSON
    :ivar secret_version: The version of the secret in Azure Key Vault. The default value is the
     latest version of the secret. Type: string (or Expression with resultType string).
    :vartype secret_version: JSON
    """

    _validation = {
        "type": {"required": True},
        "store": {"required": True},
        "secret_name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "store": {"key": "store", "type": "LinkedServiceReference"},
        "secret_name": {"key": "secretName", "type": "object"},
        "secret_version": {"key": "secretVersion", "type": "object"},
    }

    def __init__(
        self,
        *,
        store: "_models.LinkedServiceReference",
        secret_name: JSON,
        secret_version: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword store: The Azure Key Vault linked service reference. Required.
        :paramtype store: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword secret_name: The name of the secret in Azure Key Vault. Type: string (or Expression
         with resultType string). Required.
        :paramtype secret_name: JSON
        :keyword secret_version: The version of the secret in Azure Key Vault. The default value is the
         latest version of the secret. Type: string (or Expression with resultType string).
        :paramtype secret_version: JSON
        """
        super().__init__(**kwargs)
        self.type = "AzureKeyVaultSecret"  # type: str
        self.store = store
        self.secret_name = secret_name
        self.secret_version = secret_version


class AzureMariaDBLinkedService(LinkedService):
    """Azure Database for MariaDB linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar pwd: The Azure key vault secret reference of password in connection string.
    :vartype pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "pwd": {"key": "typeProperties.pwd", "type": "AzureKeyVaultSecretReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        pwd: Optional["_models.AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: An ODBC connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword pwd: The Azure key vault secret reference of password in connection string.
        :paramtype pwd: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureMariaDB"  # type: str
        self.connection_string = connection_string
        self.pwd = pwd
        self.encrypted_credential = encrypted_credential


class AzureMariaDBSource(TabularSource):
    """A copy activity Azure MariaDB source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :vartype query: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: A query to retrieve data from source. Type: string (or Expression with
         resultType string).
        :paramtype query: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AzureMariaDBSource"  # type: str
        self.query = query


class AzureMariaDBTableDataset(Dataset):
    """Azure Database for MariaDB dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name. Type: string (or Expression with resultType string).
    :vartype table_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name. Type: string (or Expression with resultType string).
        :paramtype table_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureMariaDBTable"  # type: str
        self.table_name = table_name


class AzureMLBatchExecutionActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Azure ML Batch Execution activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution Service
     endpoint. Keys must match the names of web service parameters defined in the published Azure ML
     web service. Values will be passed in the GlobalParameters property of the Azure ML batch
     execution request.
    :vartype global_parameters: dict[str, JSON]
    :ivar web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
     Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This
     information will be passed in the WebServiceOutputs property of the Azure ML batch execution
     request.
    :vartype web_service_outputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
    :ivar web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web Service
     Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information
     will be passed in the WebServiceInputs property of the Azure ML batch execution request.
    :vartype web_service_inputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "global_parameters": {"key": "typeProperties.globalParameters", "type": "{object}"},
        "web_service_outputs": {"key": "typeProperties.webServiceOutputs", "type": "{AzureMLWebServiceFile}"},
        "web_service_inputs": {"key": "typeProperties.webServiceInputs", "type": "{AzureMLWebServiceFile}"},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        global_parameters: Optional[Dict[str, JSON]] = None,
        web_service_outputs: Optional[Dict[str, "_models.AzureMLWebServiceFile"]] = None,
        web_service_inputs: Optional[Dict[str, "_models.AzureMLWebServiceFile"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword global_parameters: Key,Value pairs to be passed to the Azure ML Batch Execution
         Service endpoint. Keys must match the names of web service parameters defined in the published
         Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML
         batch execution request.
        :paramtype global_parameters: dict[str, JSON]
        :keyword web_service_outputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
         Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This
         information will be passed in the WebServiceOutputs property of the Azure ML batch execution
         request.
        :paramtype web_service_outputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
        :keyword web_service_inputs: Key,Value pairs, mapping the names of Azure ML endpoint's Web
         Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This
         information will be passed in the WebServiceInputs property of the Azure ML batch execution
         request.
        :paramtype web_service_inputs: dict[str, ~azure.mgmt.datafactory.models.AzureMLWebServiceFile]
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "AzureMLBatchExecution"  # type: str
        self.global_parameters = global_parameters
        self.web_service_outputs = web_service_outputs
        self.web_service_inputs = web_service_inputs


class AzureMLExecutePipelineActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Azure ML Execute Pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar ml_pipeline_id: ID of the published Azure ML pipeline. Type: string (or Expression with
     resultType string).
    :vartype ml_pipeline_id: JSON
    :ivar ml_pipeline_endpoint_id: ID of the published Azure ML pipeline endpoint. Type: string (or
     Expression with resultType string).
    :vartype ml_pipeline_endpoint_id: JSON
    :ivar version: Version of the published Azure ML pipeline endpoint. Type: string (or Expression
     with resultType string).
    :vartype version: JSON
    :ivar experiment_name: Run history experiment name of the pipeline run. This information will
     be passed in the ExperimentName property of the published pipeline execution request. Type:
     string (or Expression with resultType string).
    :vartype experiment_name: JSON
    :ivar ml_pipeline_parameters: Key,Value pairs to be passed to the published Azure ML pipeline
     endpoint. Keys must match the names of pipeline parameters defined in the published pipeline.
     Values will be passed in the ParameterAssignments property of the published pipeline execution
     request. Type: object with key value pairs (or Expression with resultType object).
    :vartype ml_pipeline_parameters: JSON
    :ivar data_path_assignments: Dictionary used for changing data path assignments without
     retraining. Values will be passed in the dataPathAssignments property of the published pipeline
     execution request. Type: object with key value pairs (or Expression with resultType object).
    :vartype data_path_assignments: JSON
    :ivar ml_parent_run_id: The parent Azure ML Service pipeline run id. This information will be
     passed in the ParentRunId property of the published pipeline execution request. Type: string
     (or Expression with resultType string).
    :vartype ml_parent_run_id: JSON
    :ivar continue_on_step_failure: Whether to continue execution of other steps in the PipelineRun
     if a step fails. This information will be passed in the continueOnStepFailure property of the
     published pipeline execution request. Type: boolean (or Expression with resultType boolean).
    :vartype continue_on_step_failure: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "ml_pipeline_id": {"key": "typeProperties.mlPipelineId", "type": "object"},
        "ml_pipeline_endpoint_id": {"key": "typeProperties.mlPipelineEndpointId", "type": "object"},
        "version": {"key": "typeProperties.version", "type": "object"},
        "experiment_name": {"key": "typeProperties.experimentName", "type": "object"},
        "ml_pipeline_parameters": {"key": "typeProperties.mlPipelineParameters", "type": "object"},
        "data_path_assignments": {"key": "typeProperties.dataPathAssignments", "type": "object"},
        "ml_parent_run_id": {"key": "typeProperties.mlParentRunId", "type": "object"},
        "continue_on_step_failure": {"key": "typeProperties.continueOnStepFailure", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        ml_pipeline_id: Optional[JSON] = None,
        ml_pipeline_endpoint_id: Optional[JSON] = None,
        version: Optional[JSON] = None,
        experiment_name: Optional[JSON] = None,
        ml_pipeline_parameters: Optional[JSON] = None,
        data_path_assignments: Optional[JSON] = None,
        ml_parent_run_id: Optional[JSON] = None,
        continue_on_step_failure: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword ml_pipeline_id: ID of the published Azure ML pipeline. Type: string (or Expression
         with resultType string).
        :paramtype ml_pipeline_id: JSON
        :keyword ml_pipeline_endpoint_id: ID of the published Azure ML pipeline endpoint. Type: string
         (or Expression with resultType string).
        :paramtype ml_pipeline_endpoint_id: JSON
        :keyword version: Version of the published Azure ML pipeline endpoint. Type: string (or
         Expression with resultType string).
        :paramtype version: JSON
        :keyword experiment_name: Run history experiment name of the pipeline run. This information
         will be passed in the ExperimentName property of the published pipeline execution request.
         Type: string (or Expression with resultType string).
        :paramtype experiment_name: JSON
        :keyword ml_pipeline_parameters: Key,Value pairs to be passed to the published Azure ML
         pipeline endpoint. Keys must match the names of pipeline parameters defined in the published
         pipeline. Values will be passed in the ParameterAssignments property of the published pipeline
         execution request. Type: object with key value pairs (or Expression with resultType object).
        :paramtype ml_pipeline_parameters: JSON
        :keyword data_path_assignments: Dictionary used for changing data path assignments without
         retraining. Values will be passed in the dataPathAssignments property of the published pipeline
         execution request. Type: object with key value pairs (or Expression with resultType object).
        :paramtype data_path_assignments: JSON
        :keyword ml_parent_run_id: The parent Azure ML Service pipeline run id. This information will
         be passed in the ParentRunId property of the published pipeline execution request. Type: string
         (or Expression with resultType string).
        :paramtype ml_parent_run_id: JSON
        :keyword continue_on_step_failure: Whether to continue execution of other steps in the
         PipelineRun if a step fails. This information will be passed in the continueOnStepFailure
         property of the published pipeline execution request. Type: boolean (or Expression with
         resultType boolean).
        :paramtype continue_on_step_failure: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "AzureMLExecutePipeline"  # type: str
        self.ml_pipeline_id = ml_pipeline_id
        self.ml_pipeline_endpoint_id = ml_pipeline_endpoint_id
        self.version = version
        self.experiment_name = experiment_name
        self.ml_pipeline_parameters = ml_pipeline_parameters
        self.data_path_assignments = data_path_assignments
        self.ml_parent_run_id = ml_parent_run_id
        self.continue_on_step_failure = continue_on_step_failure


class AzureMLLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure ML Studio Web Service linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar ml_endpoint: The Batch Execution REST URL for an Azure ML Studio Web Service endpoint.
     Type: string (or Expression with resultType string). Required.
    :vartype ml_endpoint: JSON
    :ivar api_key: The API key for accessing the Azure ML model endpoint. Required.
    :vartype api_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar update_resource_endpoint: The Update Resource REST URL for an Azure ML Studio Web Service
     endpoint. Type: string (or Expression with resultType string).
    :vartype update_resource_endpoint: JSON
    :ivar service_principal_id: The ID of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression
     with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against the
     ARM-based updateResourceEndpoint of an Azure ML Studio web service.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar authentication: Type of authentication (Required to specify MSI) used to connect to
     AzureML. Type: string (or Expression with resultType string).
    :vartype authentication: JSON
    """

    _validation = {
        "type": {"required": True},
        "ml_endpoint": {"required": True},
        "api_key": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "ml_endpoint": {"key": "typeProperties.mlEndpoint", "type": "object"},
        "api_key": {"key": "typeProperties.apiKey", "type": "SecretBase"},
        "update_resource_endpoint": {"key": "typeProperties.updateResourceEndpoint", "type": "object"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "authentication": {"key": "typeProperties.authentication", "type": "object"},
    }

    def __init__(
        self,
        *,
        ml_endpoint: JSON,
        api_key: "_models.SecretBase",
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        update_resource_endpoint: Optional[JSON] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        authentication: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword ml_endpoint: The Batch Execution REST URL for an Azure ML Studio Web Service endpoint.
         Type: string (or Expression with resultType string). Required.
        :paramtype ml_endpoint: JSON
        :keyword api_key: The API key for accessing the Azure ML model endpoint. Required.
        :paramtype api_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword update_resource_endpoint: The Update Resource REST URL for an Azure ML Studio Web
         Service endpoint. Type: string (or Expression with resultType string).
        :paramtype update_resource_endpoint: JSON
        :keyword service_principal_id: The ID of the service principal used to authenticate against the
         ARM-based updateResourceEndpoint of an Azure ML Studio web service. Type: string (or Expression
         with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         the ARM-based updateResourceEndpoint of an Azure ML Studio web service.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword authentication: Type of authentication (Required to specify MSI) used to connect to
         AzureML. Type: string (or Expression with resultType string).
        :paramtype authentication: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureML"  # type: str
        self.ml_endpoint = ml_endpoint
        self.api_key = api_key
        self.update_resource_endpoint = update_resource_endpoint
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential
        self.authentication = authentication


class AzureMLServiceLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure ML Service linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar subscription_id: Azure ML Service workspace subscription ID. Type: string (or Expression
     with resultType string). Required.
    :vartype subscription_id: JSON
    :ivar resource_group_name: Azure ML Service workspace resource group name. Type: string (or
     Expression with resultType string). Required.
    :vartype resource_group_name: JSON
    :ivar ml_workspace_name: Azure ML Service workspace name. Type: string (or Expression with
     resultType string). Required.
    :vartype ml_workspace_name: JSON
    :ivar service_principal_id: The ID of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType
     string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against the
     endpoint of a published Azure ML Service pipeline.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "subscription_id": {"required": True},
        "resource_group_name": {"required": True},
        "ml_workspace_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "subscription_id": {"key": "typeProperties.subscriptionId", "type": "object"},
        "resource_group_name": {"key": "typeProperties.resourceGroupName", "type": "object"},
        "ml_workspace_name": {"key": "typeProperties.mlWorkspaceName", "type": "object"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        subscription_id: JSON,
        resource_group_name: JSON,
        ml_workspace_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword subscription_id: Azure ML Service workspace subscription ID. Type: string (or
         Expression with resultType string). Required.
        :paramtype subscription_id: JSON
        :keyword resource_group_name: Azure ML Service workspace resource group name. Type: string (or
         Expression with resultType string). Required.
        :paramtype resource_group_name: JSON
        :keyword ml_workspace_name: Azure ML Service workspace name. Type: string (or Expression with
         resultType string). Required.
        :paramtype ml_workspace_name: JSON
        :keyword service_principal_id: The ID of the service principal used to authenticate against the
         endpoint of a published Azure ML Service pipeline. Type: string (or Expression with resultType
         string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         the endpoint of a published Azure ML Service pipeline.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureMLService"  # type: str
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.ml_workspace_name = ml_workspace_name
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.encrypted_credential = encrypted_credential


class AzureMLUpdateResourceActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Azure ML Update Resource management activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar trained_model_name: Name of the Trained Model module in the Web Service experiment to be
     updated. Type: string (or Expression with resultType string). Required.
    :vartype trained_model_name: JSON
    :ivar trained_model_linked_service_name: Name of Azure Storage linked service holding the
     .ilearner file that will be uploaded by the update operation. Required.
    :vartype trained_model_linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar trained_model_file_path: The relative file path in trainedModelLinkedService to represent
     the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression
     with resultType string). Required.
    :vartype trained_model_file_path: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "trained_model_name": {"required": True},
        "trained_model_linked_service_name": {"required": True},
        "trained_model_file_path": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "trained_model_name": {"key": "typeProperties.trainedModelName", "type": "object"},
        "trained_model_linked_service_name": {
            "key": "typeProperties.trainedModelLinkedServiceName",
            "type": "LinkedServiceReference",
        },
        "trained_model_file_path": {"key": "typeProperties.trainedModelFilePath", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        trained_model_name: JSON,
        trained_model_linked_service_name: "_models.LinkedServiceReference",
        trained_model_file_path: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword trained_model_name: Name of the Trained Model module in the Web Service experiment to
         be updated. Type: string (or Expression with resultType string). Required.
        :paramtype trained_model_name: JSON
        :keyword trained_model_linked_service_name: Name of Azure Storage linked service holding the
         .ilearner file that will be uploaded by the update operation. Required.
        :paramtype trained_model_linked_service_name:
         ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword trained_model_file_path: The relative file path in trainedModelLinkedService to
         represent the .ilearner file that will be uploaded by the update operation.  Type: string (or
         Expression with resultType string). Required.
        :paramtype trained_model_file_path: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "AzureMLUpdateResource"  # type: str
        self.trained_model_name = trained_model_name
        self.trained_model_linked_service_name = trained_model_linked_service_name
        self.trained_model_file_path = trained_model_file_path


class AzureMLWebServiceFile(_serialization.Model):
    """Azure ML WebService Input/Output file.

    All required parameters must be populated in order to send to Azure.

    :ivar file_path: The relative file path, including container name, in the Azure Blob Storage
     specified by the LinkedService. Type: string (or Expression with resultType string). Required.
    :vartype file_path: JSON
    :ivar linked_service_name: Reference to an Azure Storage LinkedService, where Azure ML
     WebService Input/Output file located. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        "file_path": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "file_path": {"key": "filePath", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
    }

    def __init__(self, *, file_path: JSON, linked_service_name: "_models.LinkedServiceReference", **kwargs):
        """
        :keyword file_path: The relative file path, including container name, in the Azure Blob Storage
         specified by the LinkedService. Type: string (or Expression with resultType string). Required.
        :paramtype file_path: JSON
        :keyword linked_service_name: Reference to an Azure Storage LinkedService, where Azure ML
         WebService Input/Output file located. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        """
        super().__init__(**kwargs)
        self.file_path = file_path
        self.linked_service_name = linked_service_name


class AzureMySqlLinkedService(LinkedService):
    """Azure MySQL database linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Required.
    :vartype connection_string: JSON
    :ivar password: The Azure key vault secret reference of password in connection string.
    :vartype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "AzureKeyVaultSecretReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        password: Optional["_models.AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference. Required.
        :paramtype connection_string: JSON
        :keyword password: The Azure key vault secret reference of password in connection string.
        :paramtype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureMySql"  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzureMySqlSink(CopySink):
    """A copy activity Azure MySql sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar pre_copy_script: A query to execute before starting the copy. Type: string (or Expression
     with resultType string).
    :vartype pre_copy_script: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "pre_copy_script": {"key": "preCopyScript", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        pre_copy_script: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword pre_copy_script: A query to execute before starting the copy. Type: string (or
         Expression with resultType string).
        :paramtype pre_copy_script: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureMySqlSink"  # type: str
        self.pre_copy_script = pre_copy_script


class AzureMySqlSource(TabularSource):
    """A copy activity Azure MySQL source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: Database query. Type: string (or Expression with resultType string).
    :vartype query: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: Database query. Type: string (or Expression with resultType string).
        :paramtype query: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AzureMySqlSource"  # type: str
        self.query = query


class AzureMySqlTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Azure MySQL database dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The Azure MySQL database table name. Type: string (or Expression with
     resultType string).
    :vartype table_name: JSON
    :ivar table: The name of Azure MySQL database table. Type: string (or Expression with
     resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The Azure MySQL database table name. Type: string (or Expression with
         resultType string).
        :paramtype table_name: JSON
        :keyword table: The name of Azure MySQL database table. Type: string (or Expression with
         resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureMySqlTable"  # type: str
        self.table_name = table_name
        self.table = table


class AzurePostgreSqlLinkedService(LinkedService):
    """Azure PostgreSQL linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar password: The Azure key vault secret reference of password in connection string.
    :vartype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "AzureKeyVaultSecretReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        password: Optional["_models.AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: An ODBC connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword password: The Azure key vault secret reference of password in connection string.
        :paramtype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzurePostgreSql"  # type: str
        self.connection_string = connection_string
        self.password = password
        self.encrypted_credential = encrypted_credential


class AzurePostgreSqlSink(CopySink):
    """A copy activity Azure PostgreSQL sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar pre_copy_script: A query to execute before starting the copy. Type: string (or Expression
     with resultType string).
    :vartype pre_copy_script: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "pre_copy_script": {"key": "preCopyScript", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        pre_copy_script: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword pre_copy_script: A query to execute before starting the copy. Type: string (or
         Expression with resultType string).
        :paramtype pre_copy_script: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzurePostgreSqlSink"  # type: str
        self.pre_copy_script = pre_copy_script


class AzurePostgreSqlSource(TabularSource):
    """A copy activity Azure PostgreSQL source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :vartype query: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: A query to retrieve data from source. Type: string (or Expression with
         resultType string).
        :paramtype query: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AzurePostgreSqlSource"  # type: str
        self.query = query


class AzurePostgreSqlTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """Azure PostgreSQL dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name of the Azure PostgreSQL database which includes both schema
     and table. Type: string (or Expression with resultType string).
    :vartype table_name: JSON
    :ivar table: The table name of the Azure PostgreSQL database. Type: string (or Expression with
     resultType string).
    :vartype table: JSON
    :ivar schema_type_properties_schema: The schema name of the Azure PostgreSQL database. Type:
     string (or Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        table: Optional[JSON] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name of the Azure PostgreSQL database which includes both schema
         and table. Type: string (or Expression with resultType string).
        :paramtype table_name: JSON
        :keyword table: The table name of the Azure PostgreSQL database. Type: string (or Expression
         with resultType string).
        :paramtype table: JSON
        :keyword schema_type_properties_schema: The schema name of the Azure PostgreSQL database. Type:
         string (or Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzurePostgreSqlTable"  # type: str
        self.table_name = table_name
        self.table = table
        self.schema_type_properties_schema = schema_type_properties_schema


class AzureQueueSink(CopySink):
    """A copy activity Azure Queue sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureQueueSink"  # type: str


class AzureSearchIndexDataset(Dataset):
    """The Azure Search Index.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar index_name: The name of the Azure Search Index. Type: string (or Expression with
     resultType string). Required.
    :vartype index_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
        "index_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "index_name": {"key": "typeProperties.indexName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        index_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword index_name: The name of the Azure Search Index. Type: string (or Expression with
         resultType string). Required.
        :paramtype index_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureSearchIndex"  # type: str
        self.index_name = index_name


class AzureSearchIndexSink(CopySink):
    """A copy activity Azure Search Index sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar write_behavior: Specify the write behavior when upserting documents into Azure Search
     Index. Known values are: "Merge" and "Upload".
    :vartype write_behavior: str or
     ~azure.mgmt.datafactory.models.AzureSearchIndexWriteBehaviorType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "write_behavior": {"key": "writeBehavior", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        write_behavior: Optional[Union[str, "_models.AzureSearchIndexWriteBehaviorType"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword write_behavior: Specify the write behavior when upserting documents into Azure Search
         Index. Known values are: "Merge" and "Upload".
        :paramtype write_behavior: str or
         ~azure.mgmt.datafactory.models.AzureSearchIndexWriteBehaviorType
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureSearchIndexSink"  # type: str
        self.write_behavior = write_behavior


class AzureSearchLinkedService(LinkedService):
    """Linked service for Windows Azure Search Service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar url: URL for Azure Search service. Type: string (or Expression with resultType string).
     Required.
    :vartype url: JSON
    :ivar key: Admin Key for Azure Search service.
    :vartype key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "url": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "url": {"key": "typeProperties.url", "type": "object"},
        "key": {"key": "typeProperties.key", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        url: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        key: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword url: URL for Azure Search service. Type: string (or Expression with resultType
         string). Required.
        :paramtype url: JSON
        :keyword key: Admin Key for Azure Search service.
        :paramtype key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureSearch"  # type: str
        self.url = url
        self.key = key
        self.encrypted_credential = encrypted_credential


class AzureSqlDatabaseLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Microsoft Azure SQL Database linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Required.
    :vartype connection_string: JSON
    :ivar password: The Azure key vault secret reference of password in connection string.
    :vartype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Database. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Database.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar always_encrypted_settings: Sql always encrypted properties.
    :vartype always_encrypted_settings: ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "AzureKeyVaultSecretReference"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "always_encrypted_settings": {
            "key": "typeProperties.alwaysEncryptedSettings",
            "type": "SqlAlwaysEncryptedProperties",
        },
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        password: Optional["_models.AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        always_encrypted_settings: Optional["_models.SqlAlwaysEncryptedProperties"] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference. Required.
        :paramtype connection_string: JSON
        :keyword password: The Azure key vault secret reference of password in connection string.
        :paramtype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword service_principal_id: The ID of the service principal used to authenticate against
         Azure SQL Database. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         Azure SQL Database.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword always_encrypted_settings: Sql always encrypted properties.
        :paramtype always_encrypted_settings:
         ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureSqlDatabase"  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.always_encrypted_settings = always_encrypted_settings
        self.credential = credential


class AzureSqlDWLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure SQL Data Warehouse linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     Required.
    :vartype connection_string: JSON
    :ivar password: The Azure key vault secret reference of password in connection string.
    :vartype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Data Warehouse. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Data Warehouse.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "AzureKeyVaultSecretReference"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        password: Optional["_models.AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
         Required.
        :paramtype connection_string: JSON
        :keyword password: The Azure key vault secret reference of password in connection string.
        :paramtype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword service_principal_id: The ID of the service principal used to authenticate against
         Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         Azure SQL Data Warehouse.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureSqlDW"  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class AzureSqlDWTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Azure SQL Data Warehouse dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :vartype table_name: JSON
    :ivar schema_type_properties_schema: The schema name of the Azure SQL Data Warehouse. Type:
     string (or Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    :ivar table: The table name of the Azure SQL Data Warehouse. Type: string (or Expression with
     resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: This property will be retired. Please consider using schema + table
         properties instead.
        :paramtype table_name: JSON
        :keyword schema_type_properties_schema: The schema name of the Azure SQL Data Warehouse. Type:
         string (or Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        :keyword table: The table name of the Azure SQL Data Warehouse. Type: string (or Expression
         with resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureSqlDWTable"  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlMILinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Azure SQL Managed Instance linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference. Required.
    :vartype connection_string: JSON
    :ivar password: The Azure key vault secret reference of password in connection string.
    :vartype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar service_principal_id: The ID of the service principal used to authenticate against Azure
     SQL Managed Instance. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_key: The key of the service principal used to authenticate against
     Azure SQL Managed Instance.
    :vartype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar always_encrypted_settings: Sql always encrypted properties.
    :vartype always_encrypted_settings: ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "AzureKeyVaultSecretReference"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_key": {"key": "typeProperties.servicePrincipalKey", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "always_encrypted_settings": {
            "key": "typeProperties.alwaysEncryptedSettings",
            "type": "SqlAlwaysEncryptedProperties",
        },
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        password: Optional["_models.AzureKeyVaultSecretReference"] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_key: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        always_encrypted_settings: Optional["_models.SqlAlwaysEncryptedProperties"] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference. Required.
        :paramtype connection_string: JSON
        :keyword password: The Azure key vault secret reference of password in connection string.
        :paramtype password: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword service_principal_id: The ID of the service principal used to authenticate against
         Azure SQL Managed Instance. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_key: The key of the service principal used to authenticate against
         Azure SQL Managed Instance.
        :paramtype service_principal_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword always_encrypted_settings: Sql always encrypted properties.
        :paramtype always_encrypted_settings:
         ~azure.mgmt.datafactory.models.SqlAlwaysEncryptedProperties
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureSqlMI"  # type: str
        self.connection_string = connection_string
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_key = service_principal_key
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.encrypted_credential = encrypted_credential
        self.always_encrypted_settings = always_encrypted_settings
        self.credential = credential


class AzureSqlMITableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Azure SQL Managed Instance dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :vartype table_name: JSON
    :ivar schema_type_properties_schema: The schema name of the Azure SQL Managed Instance. Type:
     string (or Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    :ivar table: The table name of the Azure SQL Managed Instance dataset. Type: string (or
     Expression with resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: This property will be retired. Please consider using schema + table
         properties instead.
        :paramtype table_name: JSON
        :keyword schema_type_properties_schema: The schema name of the Azure SQL Managed Instance.
         Type: string (or Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        :keyword table: The table name of the Azure SQL Managed Instance dataset. Type: string (or
         Expression with resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureSqlMITable"  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureSqlSink(CopySink):  # pylint: disable=too-many-instance-attributes
    """A copy activity Azure SQL sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar sql_writer_stored_procedure_name: SQL writer stored procedure name. Type: string (or
     Expression with resultType string).
    :vartype sql_writer_stored_procedure_name: JSON
    :ivar sql_writer_table_type: SQL writer table type. Type: string (or Expression with resultType
     string).
    :vartype sql_writer_table_type: JSON
    :ivar pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
     string).
    :vartype pre_copy_script: JSON
    :ivar stored_procedure_parameters: SQL stored procedure parameters.
    :vartype stored_procedure_parameters: JSON
    :ivar stored_procedure_table_type_parameter_name: The stored procedure parameter name of the
     table type. Type: string (or Expression with resultType string).
    :vartype stored_procedure_table_type_parameter_name: JSON
    :ivar table_option: The option to handle sink table, such as autoCreate. For now only
     'autoCreate' value is supported. Type: string (or Expression with resultType string).
    :vartype table_option: JSON
    :ivar sql_writer_use_table_lock: Whether to use table lock during bulk copy. Type: boolean (or
     Expression with resultType boolean).
    :vartype sql_writer_use_table_lock: JSON
    :ivar write_behavior: Write behavior when copying data into Azure SQL. Type:
     SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum).
    :vartype write_behavior: JSON
    :ivar upsert_settings: SQL upsert settings.
    :vartype upsert_settings: ~azure.mgmt.datafactory.models.SqlUpsertSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "sql_writer_stored_procedure_name": {"key": "sqlWriterStoredProcedureName", "type": "object"},
        "sql_writer_table_type": {"key": "sqlWriterTableType", "type": "object"},
        "pre_copy_script": {"key": "preCopyScript", "type": "object"},
        "stored_procedure_parameters": {"key": "storedProcedureParameters", "type": "object"},
        "stored_procedure_table_type_parameter_name": {
            "key": "storedProcedureTableTypeParameterName",
            "type": "object",
        },
        "table_option": {"key": "tableOption", "type": "object"},
        "sql_writer_use_table_lock": {"key": "sqlWriterUseTableLock", "type": "object"},
        "write_behavior": {"key": "writeBehavior", "type": "object"},
        "upsert_settings": {"key": "upsertSettings", "type": "SqlUpsertSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        sql_writer_stored_procedure_name: Optional[JSON] = None,
        sql_writer_table_type: Optional[JSON] = None,
        pre_copy_script: Optional[JSON] = None,
        stored_procedure_parameters: Optional[JSON] = None,
        stored_procedure_table_type_parameter_name: Optional[JSON] = None,
        table_option: Optional[JSON] = None,
        sql_writer_use_table_lock: Optional[JSON] = None,
        write_behavior: Optional[JSON] = None,
        upsert_settings: Optional["_models.SqlUpsertSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword sql_writer_stored_procedure_name: SQL writer stored procedure name. Type: string (or
         Expression with resultType string).
        :paramtype sql_writer_stored_procedure_name: JSON
        :keyword sql_writer_table_type: SQL writer table type. Type: string (or Expression with
         resultType string).
        :paramtype sql_writer_table_type: JSON
        :keyword pre_copy_script: SQL pre-copy script. Type: string (or Expression with resultType
         string).
        :paramtype pre_copy_script: JSON
        :keyword stored_procedure_parameters: SQL stored procedure parameters.
        :paramtype stored_procedure_parameters: JSON
        :keyword stored_procedure_table_type_parameter_name: The stored procedure parameter name of the
         table type. Type: string (or Expression with resultType string).
        :paramtype stored_procedure_table_type_parameter_name: JSON
        :keyword table_option: The option to handle sink table, such as autoCreate. For now only
         'autoCreate' value is supported. Type: string (or Expression with resultType string).
        :paramtype table_option: JSON
        :keyword sql_writer_use_table_lock: Whether to use table lock during bulk copy. Type: boolean
         (or Expression with resultType boolean).
        :paramtype sql_writer_use_table_lock: JSON
        :keyword write_behavior: Write behavior when copying data into Azure SQL. Type:
         SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum).
        :paramtype write_behavior: JSON
        :keyword upsert_settings: SQL upsert settings.
        :paramtype upsert_settings: ~azure.mgmt.datafactory.models.SqlUpsertSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureSqlSink"  # type: str
        self.sql_writer_stored_procedure_name = sql_writer_stored_procedure_name
        self.sql_writer_table_type = sql_writer_table_type
        self.pre_copy_script = pre_copy_script
        self.stored_procedure_parameters = stored_procedure_parameters
        self.stored_procedure_table_type_parameter_name = stored_procedure_table_type_parameter_name
        self.table_option = table_option
        self.sql_writer_use_table_lock = sql_writer_use_table_lock
        self.write_behavior = write_behavior
        self.upsert_settings = upsert_settings


class AzureSqlSource(TabularSource):  # pylint: disable=too-many-instance-attributes
    """A copy activity Azure SQL source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar sql_reader_query: SQL reader query. Type: string (or Expression with resultType string).
    :vartype sql_reader_query: JSON
    :ivar sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database source.
     This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression with
     resultType string).
    :vartype sql_reader_stored_procedure_name: JSON
    :ivar stored_procedure_parameters: Value and type setting for stored procedure parameters.
     Example: "{Parameter1: {value: "1", type: "int"}}".
    :vartype stored_procedure_parameters: JSON
    :ivar produce_additional_types: Which additional types to produce.
    :vartype produce_additional_types: JSON
    :ivar partition_option: The partition mechanism that will be used for Sql read in parallel.
     Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
    :vartype partition_option: JSON
    :ivar partition_settings: The settings that will be leveraged for Sql source partitioning.
    :vartype partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "sql_reader_query": {"key": "sqlReaderQuery", "type": "object"},
        "sql_reader_stored_procedure_name": {"key": "sqlReaderStoredProcedureName", "type": "object"},
        "stored_procedure_parameters": {"key": "storedProcedureParameters", "type": "object"},
        "produce_additional_types": {"key": "produceAdditionalTypes", "type": "object"},
        "partition_option": {"key": "partitionOption", "type": "object"},
        "partition_settings": {"key": "partitionSettings", "type": "SqlPartitionSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        sql_reader_query: Optional[JSON] = None,
        sql_reader_stored_procedure_name: Optional[JSON] = None,
        stored_procedure_parameters: Optional[JSON] = None,
        produce_additional_types: Optional[JSON] = None,
        partition_option: Optional[JSON] = None,
        partition_settings: Optional["_models.SqlPartitionSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword sql_reader_query: SQL reader query. Type: string (or Expression with resultType
         string).
        :paramtype sql_reader_query: JSON
        :keyword sql_reader_stored_procedure_name: Name of the stored procedure for a SQL Database
         source. This cannot be used at the same time as SqlReaderQuery. Type: string (or Expression
         with resultType string).
        :paramtype sql_reader_stored_procedure_name: JSON
        :keyword stored_procedure_parameters: Value and type setting for stored procedure parameters.
         Example: "{Parameter1: {value: "1", type: "int"}}".
        :paramtype stored_procedure_parameters: JSON
        :keyword produce_additional_types: Which additional types to produce.
        :paramtype produce_additional_types: JSON
        :keyword partition_option: The partition mechanism that will be used for Sql read in parallel.
         Possible values include: "None", "PhysicalPartitionsOfTable", "DynamicRange".
        :paramtype partition_option: JSON
        :keyword partition_settings: The settings that will be leveraged for Sql source partitioning.
        :paramtype partition_settings: ~azure.mgmt.datafactory.models.SqlPartitionSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AzureSqlSource"  # type: str
        self.sql_reader_query = sql_reader_query
        self.sql_reader_stored_procedure_name = sql_reader_stored_procedure_name
        self.stored_procedure_parameters = stored_procedure_parameters
        self.produce_additional_types = produce_additional_types
        self.partition_option = partition_option
        self.partition_settings = partition_settings


class AzureSqlTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Azure SQL Server database dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: This property will be retired. Please consider using schema + table
     properties instead.
    :vartype table_name: JSON
    :ivar schema_type_properties_schema: The schema name of the Azure SQL database. Type: string
     (or Expression with resultType string).
    :vartype schema_type_properties_schema: JSON
    :ivar table: The table name of the Azure SQL database. Type: string (or Expression with
     resultType string).
    :vartype table: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "schema_type_properties_schema": {"key": "typeProperties.schema", "type": "object"},
        "table": {"key": "typeProperties.table", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        schema_type_properties_schema: Optional[JSON] = None,
        table: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: This property will be retired. Please consider using schema + table
         properties instead.
        :paramtype table_name: JSON
        :keyword schema_type_properties_schema: The schema name of the Azure SQL database. Type: string
         (or Expression with resultType string).
        :paramtype schema_type_properties_schema: JSON
        :keyword table: The table name of the Azure SQL database. Type: string (or Expression with
         resultType string).
        :paramtype table: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureSqlTable"  # type: str
        self.table_name = table_name
        self.schema_type_properties_schema = schema_type_properties_schema
        self.table = table


class AzureStorageLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """The storage account linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar account_key: The Azure key vault secret reference of accountKey in connection string.
    :vartype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype sas_uri: JSON
    :ivar sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :vartype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "account_key": {"key": "typeProperties.accountKey", "type": "AzureKeyVaultSecretReference"},
        "sas_uri": {"key": "typeProperties.sasUri", "type": "object"},
        "sas_token": {"key": "typeProperties.sasToken", "type": "AzureKeyVaultSecretReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        account_key: Optional["_models.AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[JSON] = None,
        sas_token: Optional["_models.AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. It is mutually exclusive with sasUri
         property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword account_key: The Azure key vault secret reference of accountKey in connection string.
        :paramtype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
         connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype sas_uri: JSON
        :keyword sas_token: The Azure key vault secret reference of sasToken in sas uri.
        :paramtype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: str
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureStorage"  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class AzureSynapseArtifactsLinkedService(LinkedService):
    """Azure Synapse Analytics (Artifacts) linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar endpoint: https://:code:`<workspacename>`.dev.azuresynapse.net, Azure Synapse Analytics
     workspace URL. Type: string (or Expression with resultType string). Required.
    :vartype endpoint: JSON
    :ivar authentication: Required to specify MSI, if using system assigned managed identity as
     authentication method. Type: string (or Expression with resultType string).
    :vartype authentication: JSON
    :ivar workspace_resource_id: The resource ID of the Synapse workspace. The format should be:
     /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}.
     Type: string (or Expression with resultType string).
    :vartype workspace_resource_id: JSON
    """

    _validation = {
        "type": {"required": True},
        "endpoint": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "endpoint": {"key": "typeProperties.endpoint", "type": "object"},
        "authentication": {"key": "typeProperties.authentication", "type": "object"},
        "workspace_resource_id": {"key": "typeProperties.workspaceResourceId", "type": "object"},
    }

    def __init__(
        self,
        *,
        endpoint: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        authentication: Optional[JSON] = None,
        workspace_resource_id: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword endpoint: https://:code:`<workspacename>`.dev.azuresynapse.net, Azure Synapse
         Analytics workspace URL. Type: string (or Expression with resultType string). Required.
        :paramtype endpoint: JSON
        :keyword authentication: Required to specify MSI, if using system assigned managed identity as
         authentication method. Type: string (or Expression with resultType string).
        :paramtype authentication: JSON
        :keyword workspace_resource_id: The resource ID of the Synapse workspace. The format should be:
         /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}.
         Type: string (or Expression with resultType string).
        :paramtype workspace_resource_id: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureSynapseArtifacts"  # type: str
        self.endpoint = endpoint
        self.authentication = authentication
        self.workspace_resource_id = workspace_resource_id


class AzureTableDataset(Dataset):
    """The Azure Table storage dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name of the Azure Table storage. Type: string (or Expression with
     resultType string). Required.
    :vartype table_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
        "table_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        table_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name of the Azure Table storage. Type: string (or Expression
         with resultType string). Required.
        :paramtype table_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "AzureTable"  # type: str
        self.table_name = table_name


class AzureTableSink(CopySink):  # pylint: disable=too-many-instance-attributes
    """A copy activity Azure Table sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar azure_table_default_partition_key_value: Azure Table default partition key value. Type:
     string (or Expression with resultType string).
    :vartype azure_table_default_partition_key_value: JSON
    :ivar azure_table_partition_key_name: Azure Table partition key name. Type: string (or
     Expression with resultType string).
    :vartype azure_table_partition_key_name: JSON
    :ivar azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with
     resultType string).
    :vartype azure_table_row_key_name: JSON
    :ivar azure_table_insert_type: Azure Table insert type. Type: string (or Expression with
     resultType string).
    :vartype azure_table_insert_type: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "azure_table_default_partition_key_value": {"key": "azureTableDefaultPartitionKeyValue", "type": "object"},
        "azure_table_partition_key_name": {"key": "azureTablePartitionKeyName", "type": "object"},
        "azure_table_row_key_name": {"key": "azureTableRowKeyName", "type": "object"},
        "azure_table_insert_type": {"key": "azureTableInsertType", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        azure_table_default_partition_key_value: Optional[JSON] = None,
        azure_table_partition_key_name: Optional[JSON] = None,
        azure_table_row_key_name: Optional[JSON] = None,
        azure_table_insert_type: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword azure_table_default_partition_key_value: Azure Table default partition key value.
         Type: string (or Expression with resultType string).
        :paramtype azure_table_default_partition_key_value: JSON
        :keyword azure_table_partition_key_name: Azure Table partition key name. Type: string (or
         Expression with resultType string).
        :paramtype azure_table_partition_key_name: JSON
        :keyword azure_table_row_key_name: Azure Table row key name. Type: string (or Expression with
         resultType string).
        :paramtype azure_table_row_key_name: JSON
        :keyword azure_table_insert_type: Azure Table insert type. Type: string (or Expression with
         resultType string).
        :paramtype azure_table_insert_type: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "AzureTableSink"  # type: str
        self.azure_table_default_partition_key_value = azure_table_default_partition_key_value
        self.azure_table_partition_key_name = azure_table_partition_key_name
        self.azure_table_row_key_name = azure_table_row_key_name
        self.azure_table_insert_type = azure_table_insert_type


class AzureTableSource(TabularSource):
    """A copy activity Azure Table source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar azure_table_source_query: Azure Table source query. Type: string (or Expression with
     resultType string).
    :vartype azure_table_source_query: JSON
    :ivar azure_table_source_ignore_table_not_found: Azure Table source ignore table not found.
     Type: boolean (or Expression with resultType boolean).
    :vartype azure_table_source_ignore_table_not_found: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "azure_table_source_query": {"key": "azureTableSourceQuery", "type": "object"},
        "azure_table_source_ignore_table_not_found": {"key": "azureTableSourceIgnoreTableNotFound", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        azure_table_source_query: Optional[JSON] = None,
        azure_table_source_ignore_table_not_found: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword azure_table_source_query: Azure Table source query. Type: string (or Expression with
         resultType string).
        :paramtype azure_table_source_query: JSON
        :keyword azure_table_source_ignore_table_not_found: Azure Table source ignore table not found.
         Type: boolean (or Expression with resultType boolean).
        :paramtype azure_table_source_ignore_table_not_found: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "AzureTableSource"  # type: str
        self.azure_table_source_query = azure_table_source_query
        self.azure_table_source_ignore_table_not_found = azure_table_source_ignore_table_not_found


class AzureTableStorageLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """The azure table storage linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. It is mutually exclusive with sasUri property.
     Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar account_key: The Azure key vault secret reference of accountKey in connection string.
    :vartype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
     connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
    :vartype sas_uri: JSON
    :ivar sas_token: The Azure key vault secret reference of sasToken in sas uri.
    :vartype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "account_key": {"key": "typeProperties.accountKey", "type": "AzureKeyVaultSecretReference"},
        "sas_uri": {"key": "typeProperties.sasUri", "type": "object"},
        "sas_token": {"key": "typeProperties.sasToken", "type": "AzureKeyVaultSecretReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        account_key: Optional["_models.AzureKeyVaultSecretReference"] = None,
        sas_uri: Optional[JSON] = None,
        sas_token: Optional["_models.AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. It is mutually exclusive with sasUri
         property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword account_key: The Azure key vault secret reference of accountKey in connection string.
        :paramtype account_key: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword sas_uri: SAS URI of the Azure Storage resource. It is mutually exclusive with
         connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
        :paramtype sas_uri: JSON
        :keyword sas_token: The Azure key vault secret reference of sasToken in sas uri.
        :paramtype sas_token: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: str
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "AzureTableStorage"  # type: str
        self.connection_string = connection_string
        self.account_key = account_key
        self.sas_uri = sas_uri
        self.sas_token = sas_token
        self.encrypted_credential = encrypted_credential


class BigDataPoolParametrizationReference(_serialization.Model):
    """Big data pool reference type.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Big data pool reference type. Required. "BigDataPoolReference"
    :vartype type: str or ~azure.mgmt.datafactory.models.BigDataPoolReferenceType
    :ivar reference_name: Reference big data pool name. Type: string (or Expression with resultType
     string). Required.
    :vartype reference_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "reference_name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "reference_name": {"key": "referenceName", "type": "object"},
    }

    def __init__(self, *, type: Union[str, "_models.BigDataPoolReferenceType"], reference_name: JSON, **kwargs):
        """
        :keyword type: Big data pool reference type. Required. "BigDataPoolReference"
        :paramtype type: str or ~azure.mgmt.datafactory.models.BigDataPoolReferenceType
        :keyword reference_name: Reference big data pool name. Type: string (or Expression with
         resultType string). Required.
        :paramtype reference_name: JSON
        """
        super().__init__(**kwargs)
        self.type = type
        self.reference_name = reference_name


class BinaryDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """Binary dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar location: The location of the Binary storage.
    :vartype location: ~azure.mgmt.datafactory.models.DatasetLocation
    :ivar compression: The data compression method used for the binary dataset.
    :vartype compression: ~azure.mgmt.datafactory.models.DatasetCompression
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "location": {"key": "typeProperties.location", "type": "DatasetLocation"},
        "compression": {"key": "typeProperties.compression", "type": "DatasetCompression"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        location: Optional["_models.DatasetLocation"] = None,
        compression: Optional["_models.DatasetCompression"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword location: The location of the Binary storage.
        :paramtype location: ~azure.mgmt.datafactory.models.DatasetLocation
        :keyword compression: The data compression method used for the binary dataset.
        :paramtype compression: ~azure.mgmt.datafactory.models.DatasetCompression
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "Binary"  # type: str
        self.location = location
        self.compression = compression


class FormatReadSettings(_serialization.Model):
    """Format read settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BinaryReadSettings, DelimitedTextReadSettings, JsonReadSettings, XmlReadSettings

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "BinaryReadSettings": "BinaryReadSettings",
            "DelimitedTextReadSettings": "DelimitedTextReadSettings",
            "JsonReadSettings": "JsonReadSettings",
            "XmlReadSettings": "XmlReadSettings",
        }
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]


class BinaryReadSettings(FormatReadSettings):
    """Binary read settings.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The read setting type. Required.
    :vartype type: str
    :ivar compression_properties: Compression settings.
    :vartype compression_properties: ~azure.mgmt.datafactory.models.CompressionReadSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "compression_properties": {"key": "compressionProperties", "type": "CompressionReadSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        compression_properties: Optional["_models.CompressionReadSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword compression_properties: Compression settings.
        :paramtype compression_properties: ~azure.mgmt.datafactory.models.CompressionReadSettings
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.type = "BinaryReadSettings"  # type: str
        self.compression_properties = compression_properties


class BinarySink(CopySink):
    """A copy activity Binary sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar store_settings: Binary store settings.
    :vartype store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "store_settings": {"key": "storeSettings", "type": "StoreWriteSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        store_settings: Optional["_models.StoreWriteSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword store_settings: Binary store settings.
        :paramtype store_settings: ~azure.mgmt.datafactory.models.StoreWriteSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "BinarySink"  # type: str
        self.store_settings = store_settings


class BinarySource(CopySource):
    """A copy activity Binary source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar store_settings: Binary store settings.
    :vartype store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
    :ivar format_settings: Binary format settings.
    :vartype format_settings: ~azure.mgmt.datafactory.models.BinaryReadSettings
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "store_settings": {"key": "storeSettings", "type": "StoreReadSettings"},
        "format_settings": {"key": "formatSettings", "type": "BinaryReadSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        store_settings: Optional["_models.StoreReadSettings"] = None,
        format_settings: Optional["_models.BinaryReadSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword store_settings: Binary store settings.
        :paramtype store_settings: ~azure.mgmt.datafactory.models.StoreReadSettings
        :keyword format_settings: Binary format settings.
        :paramtype format_settings: ~azure.mgmt.datafactory.models.BinaryReadSettings
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "BinarySource"  # type: str
        self.store_settings = store_settings
        self.format_settings = format_settings


class Trigger(_serialization.Model):
    """Azure data factory nested object which contains information about creating pipeline run.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ChainingTrigger, MultiplePipelineTrigger, RerunTumblingWindowTrigger, TumblingWindowTrigger

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Trigger type. Required.
    :vartype type: str
    :ivar description: Trigger description.
    :vartype description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Known values are: "Started", "Stopped", and "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :ivar annotations: List of tags that can be used for describing the trigger.
    :vartype annotations: list[JSON]
    """

    _validation = {
        "type": {"required": True},
        "runtime_state": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "runtime_state": {"key": "runtimeState", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
    }

    _subtype_map = {
        "type": {
            "ChainingTrigger": "ChainingTrigger",
            "MultiplePipelineTrigger": "MultiplePipelineTrigger",
            "RerunTumblingWindowTrigger": "RerunTumblingWindowTrigger",
            "TumblingWindowTrigger": "TumblingWindowTrigger",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Trigger description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the trigger.
        :paramtype annotations: list[JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.description = description
        self.runtime_state = None
        self.annotations = annotations


class MultiplePipelineTrigger(Trigger):
    """Base class for all triggers that support one to many model for trigger to pipeline.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BlobEventsTrigger, BlobTrigger, CustomEventsTrigger, ScheduleTrigger

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Trigger type. Required.
    :vartype type: str
    :ivar description: Trigger description.
    :vartype description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Known values are: "Started", "Stopped", and "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :ivar annotations: List of tags that can be used for describing the trigger.
    :vartype annotations: list[JSON]
    :ivar pipelines: Pipelines that need to be started.
    :vartype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    """

    _validation = {
        "type": {"required": True},
        "runtime_state": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "runtime_state": {"key": "runtimeState", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "pipelines": {"key": "pipelines", "type": "[TriggerPipelineReference]"},
    }

    _subtype_map = {
        "type": {
            "BlobEventsTrigger": "BlobEventsTrigger",
            "BlobTrigger": "BlobTrigger",
            "CustomEventsTrigger": "CustomEventsTrigger",
            "ScheduleTrigger": "ScheduleTrigger",
        }
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        pipelines: Optional[List["_models.TriggerPipelineReference"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Trigger description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the trigger.
        :paramtype annotations: list[JSON]
        :keyword pipelines: Pipelines that need to be started.
        :paramtype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
        """
        super().__init__(
            additional_properties=additional_properties, description=description, annotations=annotations, **kwargs
        )
        self.type = "MultiplePipelineTrigger"  # type: str
        self.pipelines = pipelines


class BlobEventsTrigger(MultiplePipelineTrigger):  # pylint: disable=too-many-instance-attributes
    """Trigger that runs every time a Blob event occurs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Trigger type. Required.
    :vartype type: str
    :ivar description: Trigger description.
    :vartype description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Known values are: "Started", "Stopped", and "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :ivar annotations: List of tags that can be used for describing the trigger.
    :vartype annotations: list[JSON]
    :ivar pipelines: Pipelines that need to be started.
    :vartype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :ivar blob_path_begins_with: The blob path must begin with the pattern provided for trigger to
     fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the
     december folder under the records container. At least one of these must be provided:
     blobPathBeginsWith, blobPathEndsWith.
    :vartype blob_path_begins_with: str
    :ivar blob_path_ends_with: The blob path must end with the pattern provided for trigger to
     fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a
     december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
    :vartype blob_path_ends_with: str
    :ivar ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
    :vartype ignore_empty_blobs: bool
    :ivar events: The type of events that cause this trigger to fire. Required.
    :vartype events: list[str or ~azure.mgmt.datafactory.models.BlobEventTypes]
    :ivar scope: The ARM resource ID of the Storage Account. Required.
    :vartype scope: str
    """

    _validation = {
        "type": {"required": True},
        "runtime_state": {"readonly": True},
        "events": {"required": True},
        "scope": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "runtime_state": {"key": "runtimeState", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "pipelines": {"key": "pipelines", "type": "[TriggerPipelineReference]"},
        "blob_path_begins_with": {"key": "typeProperties.blobPathBeginsWith", "type": "str"},
        "blob_path_ends_with": {"key": "typeProperties.blobPathEndsWith", "type": "str"},
        "ignore_empty_blobs": {"key": "typeProperties.ignoreEmptyBlobs", "type": "bool"},
        "events": {"key": "typeProperties.events", "type": "[str]"},
        "scope": {"key": "typeProperties.scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        events: List[Union[str, "_models.BlobEventTypes"]],
        scope: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        pipelines: Optional[List["_models.TriggerPipelineReference"]] = None,
        blob_path_begins_with: Optional[str] = None,
        blob_path_ends_with: Optional[str] = None,
        ignore_empty_blobs: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Trigger description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the trigger.
        :paramtype annotations: list[JSON]
        :keyword pipelines: Pipelines that need to be started.
        :paramtype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
        :keyword blob_path_begins_with: The blob path must begin with the pattern provided for trigger
         to fire. For example, '/records/blobs/december/' will only fire the trigger for blobs in the
         december folder under the records container. At least one of these must be provided:
         blobPathBeginsWith, blobPathEndsWith.
        :paramtype blob_path_begins_with: str
        :keyword blob_path_ends_with: The blob path must end with the pattern provided for trigger to
         fire. For example, 'december/boxes.csv' will only fire the trigger for blobs named boxes in a
         december folder. At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
        :paramtype blob_path_ends_with: str
        :keyword ignore_empty_blobs: If set to true, blobs with zero bytes will be ignored.
        :paramtype ignore_empty_blobs: bool
        :keyword events: The type of events that cause this trigger to fire. Required.
        :paramtype events: list[str or ~azure.mgmt.datafactory.models.BlobEventTypes]
        :keyword scope: The ARM resource ID of the Storage Account. Required.
        :paramtype scope: str
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            annotations=annotations,
            pipelines=pipelines,
            **kwargs
        )
        self.type = "BlobEventsTrigger"  # type: str
        self.blob_path_begins_with = blob_path_begins_with
        self.blob_path_ends_with = blob_path_ends_with
        self.ignore_empty_blobs = ignore_empty_blobs
        self.events = events
        self.scope = scope


class BlobSink(CopySink):  # pylint: disable=too-many-instance-attributes
    """A copy activity Azure Blob sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression
     with resultType boolean).
    :vartype blob_writer_overwrite_files: JSON
    :ivar blob_writer_date_time_format: Blob writer date time format. Type: string (or Expression
     with resultType string).
    :vartype blob_writer_date_time_format: JSON
    :ivar blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with
     resultType boolean).
    :vartype blob_writer_add_header: JSON
    :ivar copy_behavior: The type of copy behavior for copy sink.
    :vartype copy_behavior: JSON
    :ivar metadata: Specify the custom metadata to be added to sink data. Type: array of objects
     (or Expression with resultType array of objects).
    :vartype metadata: list[~azure.mgmt.datafactory.models.MetadataItem]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "blob_writer_overwrite_files": {"key": "blobWriterOverwriteFiles", "type": "object"},
        "blob_writer_date_time_format": {"key": "blobWriterDateTimeFormat", "type": "object"},
        "blob_writer_add_header": {"key": "blobWriterAddHeader", "type": "object"},
        "copy_behavior": {"key": "copyBehavior", "type": "object"},
        "metadata": {"key": "metadata", "type": "[MetadataItem]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        blob_writer_overwrite_files: Optional[JSON] = None,
        blob_writer_date_time_format: Optional[JSON] = None,
        blob_writer_add_header: Optional[JSON] = None,
        copy_behavior: Optional[JSON] = None,
        metadata: Optional[List["_models.MetadataItem"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword blob_writer_overwrite_files: Blob writer overwrite files. Type: boolean (or Expression
         with resultType boolean).
        :paramtype blob_writer_overwrite_files: JSON
        :keyword blob_writer_date_time_format: Blob writer date time format. Type: string (or
         Expression with resultType string).
        :paramtype blob_writer_date_time_format: JSON
        :keyword blob_writer_add_header: Blob writer add header. Type: boolean (or Expression with
         resultType boolean).
        :paramtype blob_writer_add_header: JSON
        :keyword copy_behavior: The type of copy behavior for copy sink.
        :paramtype copy_behavior: JSON
        :keyword metadata: Specify the custom metadata to be added to sink data. Type: array of objects
         (or Expression with resultType array of objects).
        :paramtype metadata: list[~azure.mgmt.datafactory.models.MetadataItem]
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "BlobSink"  # type: str
        self.blob_writer_overwrite_files = blob_writer_overwrite_files
        self.blob_writer_date_time_format = blob_writer_date_time_format
        self.blob_writer_add_header = blob_writer_add_header
        self.copy_behavior = copy_behavior
        self.metadata = metadata


class BlobSource(CopySource):
    """A copy activity Azure Blob source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
     boolean).
    :vartype treat_empty_as_null: JSON
    :ivar skip_header_line_count: Number of header lines to skip from each blob. Type: integer (or
     Expression with resultType integer).
    :vartype skip_header_line_count: JSON
    :ivar recursive: If true, files under the folder path will be read recursively. Default is
     true. Type: boolean (or Expression with resultType boolean).
    :vartype recursive: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "treat_empty_as_null": {"key": "treatEmptyAsNull", "type": "object"},
        "skip_header_line_count": {"key": "skipHeaderLineCount", "type": "object"},
        "recursive": {"key": "recursive", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        treat_empty_as_null: Optional[JSON] = None,
        skip_header_line_count: Optional[JSON] = None,
        recursive: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword treat_empty_as_null: Treat empty as null. Type: boolean (or Expression with resultType
         boolean).
        :paramtype treat_empty_as_null: JSON
        :keyword skip_header_line_count: Number of header lines to skip from each blob. Type: integer
         (or Expression with resultType integer).
        :paramtype skip_header_line_count: JSON
        :keyword recursive: If true, files under the folder path will be read recursively. Default is
         true. Type: boolean (or Expression with resultType boolean).
        :paramtype recursive: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "BlobSource"  # type: str
        self.treat_empty_as_null = treat_empty_as_null
        self.skip_header_line_count = skip_header_line_count
        self.recursive = recursive


class BlobTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time the selected Blob container changes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Trigger type. Required.
    :vartype type: str
    :ivar description: Trigger description.
    :vartype description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Known values are: "Started", "Stopped", and "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :ivar annotations: List of tags that can be used for describing the trigger.
    :vartype annotations: list[JSON]
    :ivar pipelines: Pipelines that need to be started.
    :vartype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :ivar folder_path: The path of the container/folder that will trigger the pipeline. Required.
    :vartype folder_path: str
    :ivar max_concurrency: The max number of parallel files to handle when it is triggered.
     Required.
    :vartype max_concurrency: int
    :ivar linked_service: The Azure Storage linked service reference. Required.
    :vartype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        "type": {"required": True},
        "runtime_state": {"readonly": True},
        "folder_path": {"required": True},
        "max_concurrency": {"required": True},
        "linked_service": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "runtime_state": {"key": "runtimeState", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "pipelines": {"key": "pipelines", "type": "[TriggerPipelineReference]"},
        "folder_path": {"key": "typeProperties.folderPath", "type": "str"},
        "max_concurrency": {"key": "typeProperties.maxConcurrency", "type": "int"},
        "linked_service": {"key": "typeProperties.linkedService", "type": "LinkedServiceReference"},
    }

    def __init__(
        self,
        *,
        folder_path: str,
        max_concurrency: int,
        linked_service: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        pipelines: Optional[List["_models.TriggerPipelineReference"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Trigger description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the trigger.
        :paramtype annotations: list[JSON]
        :keyword pipelines: Pipelines that need to be started.
        :paramtype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
        :keyword folder_path: The path of the container/folder that will trigger the pipeline.
         Required.
        :paramtype folder_path: str
        :keyword max_concurrency: The max number of parallel files to handle when it is triggered.
         Required.
        :paramtype max_concurrency: int
        :keyword linked_service: The Azure Storage linked service reference. Required.
        :paramtype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            annotations=annotations,
            pipelines=pipelines,
            **kwargs
        )
        self.type = "BlobTrigger"  # type: str
        self.folder_path = folder_path
        self.max_concurrency = max_concurrency
        self.linked_service = linked_service


class CassandraLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Linked service for Cassandra data source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar host: Host name for connection. Type: string (or Expression with resultType string).
     Required.
    :vartype host: JSON
    :ivar authentication_type: AuthenticationType to be used for connection. Type: string (or
     Expression with resultType string).
    :vartype authentication_type: JSON
    :ivar port: The port for the connection. Type: integer (or Expression with resultType integer).
    :vartype port: JSON
    :ivar username: Username for authentication. Type: string (or Expression with resultType
     string).
    :vartype username: JSON
    :ivar password: Password for authentication.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "host": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "host": {"key": "typeProperties.host", "type": "object"},
        "authentication_type": {"key": "typeProperties.authenticationType", "type": "object"},
        "port": {"key": "typeProperties.port", "type": "object"},
        "username": {"key": "typeProperties.username", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        host: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        authentication_type: Optional[JSON] = None,
        port: Optional[JSON] = None,
        username: Optional[JSON] = None,
        password: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword host: Host name for connection. Type: string (or Expression with resultType string).
         Required.
        :paramtype host: JSON
        :keyword authentication_type: AuthenticationType to be used for connection. Type: string (or
         Expression with resultType string).
        :paramtype authentication_type: JSON
        :keyword port: The port for the connection. Type: integer (or Expression with resultType
         integer).
        :paramtype port: JSON
        :keyword username: Username for authentication. Type: string (or Expression with resultType
         string).
        :paramtype username: JSON
        :keyword password: Password for authentication.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "Cassandra"  # type: str
        self.host = host
        self.authentication_type = authentication_type
        self.port = port
        self.username = username
        self.password = password
        self.encrypted_credential = encrypted_credential


class CassandraSource(TabularSource):
    """A copy activity source for a Cassandra database.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: Database query. Should be a SQL-92 query expression or Cassandra Query Language
     (CQL) command. Type: string (or Expression with resultType string).
    :vartype query: JSON
    :ivar consistency_level: The consistency level specifies how many Cassandra servers must
     respond to a read request before returning data to the client application. Cassandra checks the
     specified number of Cassandra servers for data to satisfy the read request. Must be one of
     cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive. Known
     values are: "ALL", "EACH_QUORUM", "QUORUM", "LOCAL_QUORUM", "ONE", "TWO", "THREE", "LOCAL_ONE",
     "SERIAL", and "LOCAL_SERIAL".
    :vartype consistency_level: str or
     ~azure.mgmt.datafactory.models.CassandraSourceReadConsistencyLevels
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
        "consistency_level": {"key": "consistencyLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        consistency_level: Optional[Union[str, "_models.CassandraSourceReadConsistencyLevels"]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: Database query. Should be a SQL-92 query expression or Cassandra Query Language
         (CQL) command. Type: string (or Expression with resultType string).
        :paramtype query: JSON
        :keyword consistency_level: The consistency level specifies how many Cassandra servers must
         respond to a read request before returning data to the client application. Cassandra checks the
         specified number of Cassandra servers for data to satisfy the read request. Must be one of
         cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive. Known
         values are: "ALL", "EACH_QUORUM", "QUORUM", "LOCAL_QUORUM", "ONE", "TWO", "THREE", "LOCAL_ONE",
         "SERIAL", and "LOCAL_SERIAL".
        :paramtype consistency_level: str or
         ~azure.mgmt.datafactory.models.CassandraSourceReadConsistencyLevels
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "CassandraSource"  # type: str
        self.query = query
        self.consistency_level = consistency_level


class CassandraTableDataset(Dataset):  # pylint: disable=too-many-instance-attributes
    """The Cassandra database dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name of the Cassandra database. Type: string (or Expression with
     resultType string).
    :vartype table_name: JSON
    :ivar keyspace: The keyspace of the Cassandra database. Type: string (or Expression with
     resultType string).
    :vartype keyspace: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
        "keyspace": {"key": "typeProperties.keyspace", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        keyspace: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name of the Cassandra database. Type: string (or Expression with
         resultType string).
        :paramtype table_name: JSON
        :keyword keyspace: The keyspace of the Cassandra database. Type: string (or Expression with
         resultType string).
        :paramtype keyspace: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "CassandraTable"  # type: str
        self.table_name = table_name
        self.keyspace = keyspace


class ChainingTrigger(Trigger):
    """Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Trigger type. Required.
    :vartype type: str
    :ivar description: Trigger description.
    :vartype description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Known values are: "Started", "Stopped", and "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :ivar annotations: List of tags that can be used for describing the trigger.
    :vartype annotations: list[JSON]
    :ivar pipeline: Pipeline for which runs are created when all upstream pipelines complete
     successfully. Required.
    :vartype pipeline: ~azure.mgmt.datafactory.models.TriggerPipelineReference
    :ivar depends_on: Upstream Pipelines. Required.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.PipelineReference]
    :ivar run_dimension: Run Dimension property that needs to be emitted by upstream pipelines.
     Required.
    :vartype run_dimension: str
    """

    _validation = {
        "type": {"required": True},
        "runtime_state": {"readonly": True},
        "pipeline": {"required": True},
        "depends_on": {"required": True},
        "run_dimension": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "runtime_state": {"key": "runtimeState", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "pipeline": {"key": "pipeline", "type": "TriggerPipelineReference"},
        "depends_on": {"key": "typeProperties.dependsOn", "type": "[PipelineReference]"},
        "run_dimension": {"key": "typeProperties.runDimension", "type": "str"},
    }

    def __init__(
        self,
        *,
        pipeline: "_models.TriggerPipelineReference",
        depends_on: List["_models.PipelineReference"],
        run_dimension: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Trigger description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the trigger.
        :paramtype annotations: list[JSON]
        :keyword pipeline: Pipeline for which runs are created when all upstream pipelines complete
         successfully. Required.
        :paramtype pipeline: ~azure.mgmt.datafactory.models.TriggerPipelineReference
        :keyword depends_on: Upstream Pipelines. Required.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.PipelineReference]
        :keyword run_dimension: Run Dimension property that needs to be emitted by upstream pipelines.
         Required.
        :paramtype run_dimension: str
        """
        super().__init__(
            additional_properties=additional_properties, description=description, annotations=annotations, **kwargs
        )
        self.type = "ChainingTrigger"  # type: str
        self.pipeline = pipeline
        self.depends_on = depends_on
        self.run_dimension = run_dimension


class CloudError(_serialization.Model):
    """The object that defines the structure of an Azure Data Factory error response.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Error code. Required.
    :vartype code: str
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar target: Property name/path in request associated with error.
    :vartype target: str
    :ivar details: Array with additional error details.
    :vartype details: list[~azure.mgmt.datafactory.models.CloudError]
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "error.code", "type": "str"},
        "message": {"key": "error.message", "type": "str"},
        "target": {"key": "error.target", "type": "str"},
        "details": {"key": "error.details", "type": "[CloudError]"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudError"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code. Required.
        :paramtype code: str
        :keyword message: Error message. Required.
        :paramtype message: str
        :keyword target: Property name/path in request associated with error.
        :paramtype target: str
        :keyword details: Array with additional error details.
        :paramtype details: list[~azure.mgmt.datafactory.models.CloudError]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CmdkeySetup(CustomSetupBase):
    """The custom setup of running cmdkey commands.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of custom setup. Required.
    :vartype type: str
    :ivar target_name: The server name of data source access. Required.
    :vartype target_name: JSON
    :ivar user_name: The user name of data source access. Required.
    :vartype user_name: JSON
    :ivar password: The password of data source access. Required.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        "type": {"required": True},
        "target_name": {"required": True},
        "user_name": {"required": True},
        "password": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "target_name": {"key": "typeProperties.targetName", "type": "object"},
        "user_name": {"key": "typeProperties.userName", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
    }

    def __init__(self, *, target_name: JSON, user_name: JSON, password: "_models.SecretBase", **kwargs):
        """
        :keyword target_name: The server name of data source access. Required.
        :paramtype target_name: JSON
        :keyword user_name: The user name of data source access. Required.
        :paramtype user_name: JSON
        :keyword password: The password of data source access. Required.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        """
        super().__init__(**kwargs)
        self.type = "CmdkeySetup"  # type: str
        self.target_name = target_name
        self.user_name = user_name
        self.password = password


class CMKIdentityDefinition(_serialization.Model):
    """Managed Identity used for CMK.

    :ivar user_assigned_identity: The resource id of the user assigned identity to authenticate to
     customer's key vault.
    :vartype user_assigned_identity: str
    """

    _attribute_map = {
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
    }

    def __init__(self, *, user_assigned_identity: Optional[str] = None, **kwargs):
        """
        :keyword user_assigned_identity: The resource id of the user assigned identity to authenticate
         to customer's key vault.
        :paramtype user_assigned_identity: str
        """
        super().__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity


class CommonDataServiceForAppsEntityDataset(Dataset):
    """The Common Data Service for Apps entity dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar entity_name: The logical name of the entity. Type: string (or Expression with resultType
     string).
    :vartype entity_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "entity_name": {"key": "typeProperties.entityName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        entity_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword entity_name: The logical name of the entity. Type: string (or Expression with
         resultType string).
        :paramtype entity_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "CommonDataServiceForAppsEntity"  # type: str
        self.entity_name = entity_name


class CommonDataServiceForAppsLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Common Data Service for Apps linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar deployment_type: The deployment type of the Common Data Service for Apps instance.
     'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common Data
     Service for Apps on-premises with Ifd. Type: string (or Expression with resultType string).
     Required.
    :vartype deployment_type: JSON
    :ivar host_name: The host name of the on-premises Common Data Service for Apps server. The
     property is required for on-prem and not allowed for online. Type: string (or Expression with
     resultType string).
    :vartype host_name: JSON
    :ivar port: The port of on-premises Common Data Service for Apps server. The property is
     required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression
     with resultType integer), minimum: 0.
    :vartype port: JSON
    :ivar service_uri: The URL to the Microsoft Common Data Service for Apps server. The property
     is required for on-line and not allowed for on-prem. Type: string (or Expression with
     resultType string).
    :vartype service_uri: JSON
    :ivar organization_name: The organization name of the Common Data Service for Apps instance.
     The property is required for on-prem and required for online when there are more than one
     Common Data Service for Apps instances associated with the user. Type: string (or Expression
     with resultType string).
    :vartype organization_name: JSON
    :ivar authentication_type: The authentication type to connect to Common Data Service for Apps
     server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario.
     'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
     Expression with resultType string). Required.
    :vartype authentication_type: JSON
    :ivar username: User name to access the Common Data Service for Apps instance. Type: string (or
     Expression with resultType string).
    :vartype username: JSON
    :ivar password: Password to access the Common Data Service for Apps instance.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar service_principal_id: The client ID of the application in Azure Active Directory used for
     Server-To-Server authentication. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string).
    :vartype service_principal_credential_type: JSON
    :ivar service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :vartype service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "deployment_type": {"required": True},
        "authentication_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "deployment_type": {"key": "typeProperties.deploymentType", "type": "object"},
        "host_name": {"key": "typeProperties.hostName", "type": "object"},
        "port": {"key": "typeProperties.port", "type": "object"},
        "service_uri": {"key": "typeProperties.serviceUri", "type": "object"},
        "organization_name": {"key": "typeProperties.organizationName", "type": "object"},
        "authentication_type": {"key": "typeProperties.authenticationType", "type": "object"},
        "username": {"key": "typeProperties.username", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_credential_type": {"key": "typeProperties.servicePrincipalCredentialType", "type": "object"},
        "service_principal_credential": {"key": "typeProperties.servicePrincipalCredential", "type": "SecretBase"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        deployment_type: JSON,
        authentication_type: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        host_name: Optional[JSON] = None,
        port: Optional[JSON] = None,
        service_uri: Optional[JSON] = None,
        organization_name: Optional[JSON] = None,
        username: Optional[JSON] = None,
        password: Optional["_models.SecretBase"] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_credential_type: Optional[JSON] = None,
        service_principal_credential: Optional["_models.SecretBase"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword deployment_type: The deployment type of the Common Data Service for Apps instance.
         'Online' for Common Data Service for Apps Online and 'OnPremisesWithIfd' for Common Data
         Service for Apps on-premises with Ifd. Type: string (or Expression with resultType string).
         Required.
        :paramtype deployment_type: JSON
        :keyword host_name: The host name of the on-premises Common Data Service for Apps server. The
         property is required for on-prem and not allowed for online. Type: string (or Expression with
         resultType string).
        :paramtype host_name: JSON
        :keyword port: The port of on-premises Common Data Service for Apps server. The property is
         required for on-prem and not allowed for online. Default is 443. Type: integer (or Expression
         with resultType integer), minimum: 0.
        :paramtype port: JSON
        :keyword service_uri: The URL to the Microsoft Common Data Service for Apps server. The
         property is required for on-line and not allowed for on-prem. Type: string (or Expression with
         resultType string).
        :paramtype service_uri: JSON
        :keyword organization_name: The organization name of the Common Data Service for Apps instance.
         The property is required for on-prem and required for online when there are more than one
         Common Data Service for Apps instances associated with the user. Type: string (or Expression
         with resultType string).
        :paramtype organization_name: JSON
        :keyword authentication_type: The authentication type to connect to Common Data Service for
         Apps server. 'Office365' for online scenario, 'Ifd' for on-premises with Ifd scenario.
         'AADServicePrincipal' for Server-To-Server authentication in online scenario. Type: string (or
         Expression with resultType string). Required.
        :paramtype authentication_type: JSON
        :keyword username: User name to access the Common Data Service for Apps instance. Type: string
         (or Expression with resultType string).
        :paramtype username: JSON
        :keyword password: Password to access the Common Data Service for Apps instance.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword service_principal_id: The client ID of the application in Azure Active Directory used
         for Server-To-Server authentication. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_credential_type: The service principal credential type to use in
         Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
         for certificate. Type: string (or Expression with resultType string).
        :paramtype service_principal_credential_type: JSON
        :keyword service_principal_credential: The credential of the service principal object in Azure
         Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
         servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
         servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
         be AzureKeyVaultSecretReference.
        :paramtype service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "CommonDataServiceForApps"  # type: str
        self.deployment_type = deployment_type
        self.host_name = host_name
        self.port = port
        self.service_uri = service_uri
        self.organization_name = organization_name
        self.authentication_type = authentication_type
        self.username = username
        self.password = password
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.encrypted_credential = encrypted_credential


class CommonDataServiceForAppsSink(CopySink):  # pylint: disable=too-many-instance-attributes
    """A copy activity Common Data Service for Apps sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar write_behavior: The write behavior for the operation. Required. "Upsert"
    :vartype write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
    :ivar ignore_null_values: The flag indicating whether to ignore null values from input dataset
     (except key fields) during write operation. Default is false. Type: boolean (or Expression with
     resultType boolean).
    :vartype ignore_null_values: JSON
    :ivar alternate_key_name: The logical name of the alternate key which will be used when
     upserting records. Type: string (or Expression with resultType string).
    :vartype alternate_key_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "write_behavior": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "write_behavior": {"key": "writeBehavior", "type": "str"},
        "ignore_null_values": {"key": "ignoreNullValues", "type": "object"},
        "alternate_key_name": {"key": "alternateKeyName", "type": "object"},
    }

    def __init__(
        self,
        *,
        write_behavior: Union[str, "_models.DynamicsSinkWriteBehavior"],
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        ignore_null_values: Optional[JSON] = None,
        alternate_key_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword write_behavior: The write behavior for the operation. Required. "Upsert"
        :paramtype write_behavior: str or ~azure.mgmt.datafactory.models.DynamicsSinkWriteBehavior
        :keyword ignore_null_values: The flag indicating whether to ignore null values from input
         dataset (except key fields) during write operation. Default is false. Type: boolean (or
         Expression with resultType boolean).
        :paramtype ignore_null_values: JSON
        :keyword alternate_key_name: The logical name of the alternate key which will be used when
         upserting records. Type: string (or Expression with resultType string).
        :paramtype alternate_key_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "CommonDataServiceForAppsSink"  # type: str
        self.write_behavior = write_behavior
        self.ignore_null_values = ignore_null_values
        self.alternate_key_name = alternate_key_name


class CommonDataServiceForAppsSource(CopySource):
    """A copy activity Common Data Service for Apps source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query: FetchXML is a proprietary query language that is used in Microsoft Common Data
     Service for Apps (online & on-premises). Type: string (or Expression with resultType string).
    :vartype query: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query": {"key": "query", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query: FetchXML is a proprietary query language that is used in Microsoft Common Data
         Service for Apps (online & on-premises). Type: string (or Expression with resultType string).
        :paramtype query: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "CommonDataServiceForAppsSource"  # type: str
        self.query = query
        self.additional_columns = additional_columns


class ComponentSetup(CustomSetupBase):
    """The custom setup of installing 3rd party components.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of custom setup. Required.
    :vartype type: str
    :ivar component_name: The name of the 3rd party component. Required.
    :vartype component_name: str
    :ivar license_key: The license key to activate the component.
    :vartype license_key: ~azure.mgmt.datafactory.models.SecretBase
    """

    _validation = {
        "type": {"required": True},
        "component_name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "component_name": {"key": "typeProperties.componentName", "type": "str"},
        "license_key": {"key": "typeProperties.licenseKey", "type": "SecretBase"},
    }

    def __init__(self, *, component_name: str, license_key: Optional["_models.SecretBase"] = None, **kwargs):
        """
        :keyword component_name: The name of the 3rd party component. Required.
        :paramtype component_name: str
        :keyword license_key: The license key to activate the component.
        :paramtype license_key: ~azure.mgmt.datafactory.models.SecretBase
        """
        super().__init__(**kwargs)
        self.type = "ComponentSetup"  # type: str
        self.component_name = component_name
        self.license_key = license_key


class CompressionReadSettings(_serialization.Model):
    """Compression read settings.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TarGZipReadSettings, TarReadSettings, ZipDeflateReadSettings

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: The Compression setting type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "TarGZipReadSettings": "TarGZipReadSettings",
            "TarReadSettings": "TarReadSettings",
            "ZipDeflateReadSettings": "ZipDeflateReadSettings",
        }
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]


class ConcurLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Concur Service linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_properties: Properties used to connect to Concur. It is mutually exclusive
     with any other properties in the linked service. Type: object.
    :vartype connection_properties: JSON
    :ivar client_id: Application client_id supplied by Concur App Management. Required.
    :vartype client_id: JSON
    :ivar username: The user name that you use to access Concur Service. Required.
    :vartype username: JSON
    :ivar password: The password corresponding to the user name that you provided in the username
     field.
    :vartype password: ~azure.mgmt.datafactory.models.SecretBase
    :ivar use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted using
     HTTPS. The default value is true.
    :vartype use_encrypted_endpoints: JSON
    :ivar use_host_verification: Specifies whether to require the host name in the server's
     certificate to match the host name of the server when connecting over SSL. The default value is
     true.
    :vartype use_host_verification: JSON
    :ivar use_peer_verification: Specifies whether to verify the identity of the server when
     connecting over SSL. The default value is true.
    :vartype use_peer_verification: JSON
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
        "client_id": {"required": True},
        "username": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_properties": {"key": "typeProperties.connectionProperties", "type": "object"},
        "client_id": {"key": "typeProperties.clientId", "type": "object"},
        "username": {"key": "typeProperties.username", "type": "object"},
        "password": {"key": "typeProperties.password", "type": "SecretBase"},
        "use_encrypted_endpoints": {"key": "typeProperties.useEncryptedEndpoints", "type": "object"},
        "use_host_verification": {"key": "typeProperties.useHostVerification", "type": "object"},
        "use_peer_verification": {"key": "typeProperties.usePeerVerification", "type": "object"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        client_id: JSON,
        username: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_properties: Optional[JSON] = None,
        password: Optional["_models.SecretBase"] = None,
        use_encrypted_endpoints: Optional[JSON] = None,
        use_host_verification: Optional[JSON] = None,
        use_peer_verification: Optional[JSON] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_properties: Properties used to connect to Concur. It is mutually exclusive
         with any other properties in the linked service. Type: object.
        :paramtype connection_properties: JSON
        :keyword client_id: Application client_id supplied by Concur App Management. Required.
        :paramtype client_id: JSON
        :keyword username: The user name that you use to access Concur Service. Required.
        :paramtype username: JSON
        :keyword password: The password corresponding to the user name that you provided in the
         username field.
        :paramtype password: ~azure.mgmt.datafactory.models.SecretBase
        :keyword use_encrypted_endpoints: Specifies whether the data source endpoints are encrypted
         using HTTPS. The default value is true.
        :paramtype use_encrypted_endpoints: JSON
        :keyword use_host_verification: Specifies whether to require the host name in the server's
         certificate to match the host name of the server when connecting over SSL. The default value is
         true.
        :paramtype use_host_verification: JSON
        :keyword use_peer_verification: Specifies whether to verify the identity of the server when
         connecting over SSL. The default value is true.
        :paramtype use_peer_verification: JSON
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "Concur"  # type: str
        self.connection_properties = connection_properties
        self.client_id = client_id
        self.username = username
        self.password = password
        self.use_encrypted_endpoints = use_encrypted_endpoints
        self.use_host_verification = use_host_verification
        self.use_peer_verification = use_peer_verification
        self.encrypted_credential = encrypted_credential


class ConcurObjectDataset(Dataset):
    """Concur Service dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name. Type: string (or Expression with resultType string).
    :vartype table_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name. Type: string (or Expression with resultType string).
        :paramtype table_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "ConcurObject"  # type: str
        self.table_name = table_name


class ConcurSource(TabularSource):
    """A copy activity Concur Service source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :vartype query: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: A query to retrieve data from source. Type: string (or Expression with
         resultType string).
        :paramtype query: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "ConcurSource"  # type: str
        self.query = query


class ConnectionStateProperties(_serialization.Model):
    """The connection state of a managed private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar actions_required: The actions required on the managed private endpoint.
    :vartype actions_required: str
    :ivar description: The managed private endpoint description.
    :vartype description: str
    :ivar status: The approval status.
    :vartype status: str
    """

    _validation = {
        "actions_required": {"readonly": True},
        "description": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "actions_required": {"key": "actionsRequired", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.actions_required = None
        self.description = None
        self.status = None


class CopyActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Copy activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar inputs: List of inputs for the activity.
    :vartype inputs: list[~azure.mgmt.datafactory.models.DatasetReference]
    :ivar outputs: List of outputs for the activity.
    :vartype outputs: list[~azure.mgmt.datafactory.models.DatasetReference]
    :ivar source: Copy activity source. Required.
    :vartype source: ~azure.mgmt.datafactory.models.CopySource
    :ivar sink: Copy activity sink. Required.
    :vartype sink: ~azure.mgmt.datafactory.models.CopySink
    :ivar translator: Copy activity translator. If not specified, tabular translator is used.
    :vartype translator: JSON
    :ivar enable_staging: Specifies whether to copy data via an interim staging. Default value is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype enable_staging: JSON
    :ivar staging_settings: Specifies interim staging settings when EnableStaging is true.
    :vartype staging_settings: ~azure.mgmt.datafactory.models.StagingSettings
    :ivar parallel_copies: Maximum number of concurrent sessions opened on the source or sink to
     avoid overloading the data store. Type: integer (or Expression with resultType integer),
     minimum: 0.
    :vartype parallel_copies: JSON
    :ivar data_integration_units: Maximum number of data integration units that can be used to
     perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
    :vartype data_integration_units: JSON
    :ivar enable_skip_incompatible_row: Whether to skip incompatible row. Default value is false.
     Type: boolean (or Expression with resultType boolean).
    :vartype enable_skip_incompatible_row: JSON
    :ivar redirect_incompatible_row_settings: Redirect incompatible row settings when
     EnableSkipIncompatibleRow is true.
    :vartype redirect_incompatible_row_settings:
     ~azure.mgmt.datafactory.models.RedirectIncompatibleRowSettings
    :ivar log_storage_settings: (Deprecated. Please use LogSettings) Log storage settings customer
     need to provide when enabling session log.
    :vartype log_storage_settings: ~azure.mgmt.datafactory.models.LogStorageSettings
    :ivar log_settings: Log settings customer needs provide when enabling log.
    :vartype log_settings: ~azure.mgmt.datafactory.models.LogSettings
    :ivar preserve_rules: Preserve Rules.
    :vartype preserve_rules: list[JSON]
    :ivar preserve: Preserve rules.
    :vartype preserve: list[JSON]
    :ivar validate_data_consistency: Whether to enable Data Consistency validation. Type: boolean
     (or Expression with resultType boolean).
    :vartype validate_data_consistency: JSON
    :ivar skip_error_file: Specify the fault tolerance for data consistency.
    :vartype skip_error_file: ~azure.mgmt.datafactory.models.SkipErrorFile
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "source": {"required": True},
        "sink": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "inputs": {"key": "inputs", "type": "[DatasetReference]"},
        "outputs": {"key": "outputs", "type": "[DatasetReference]"},
        "source": {"key": "typeProperties.source", "type": "CopySource"},
        "sink": {"key": "typeProperties.sink", "type": "CopySink"},
        "translator": {"key": "typeProperties.translator", "type": "object"},
        "enable_staging": {"key": "typeProperties.enableStaging", "type": "object"},
        "staging_settings": {"key": "typeProperties.stagingSettings", "type": "StagingSettings"},
        "parallel_copies": {"key": "typeProperties.parallelCopies", "type": "object"},
        "data_integration_units": {"key": "typeProperties.dataIntegrationUnits", "type": "object"},
        "enable_skip_incompatible_row": {"key": "typeProperties.enableSkipIncompatibleRow", "type": "object"},
        "redirect_incompatible_row_settings": {
            "key": "typeProperties.redirectIncompatibleRowSettings",
            "type": "RedirectIncompatibleRowSettings",
        },
        "log_storage_settings": {"key": "typeProperties.logStorageSettings", "type": "LogStorageSettings"},
        "log_settings": {"key": "typeProperties.logSettings", "type": "LogSettings"},
        "preserve_rules": {"key": "typeProperties.preserveRules", "type": "[object]"},
        "preserve": {"key": "typeProperties.preserve", "type": "[object]"},
        "validate_data_consistency": {"key": "typeProperties.validateDataConsistency", "type": "object"},
        "skip_error_file": {"key": "typeProperties.skipErrorFile", "type": "SkipErrorFile"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        source: "_models.CopySource",
        sink: "_models.CopySink",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        inputs: Optional[List["_models.DatasetReference"]] = None,
        outputs: Optional[List["_models.DatasetReference"]] = None,
        translator: Optional[JSON] = None,
        enable_staging: Optional[JSON] = None,
        staging_settings: Optional["_models.StagingSettings"] = None,
        parallel_copies: Optional[JSON] = None,
        data_integration_units: Optional[JSON] = None,
        enable_skip_incompatible_row: Optional[JSON] = None,
        redirect_incompatible_row_settings: Optional["_models.RedirectIncompatibleRowSettings"] = None,
        log_storage_settings: Optional["_models.LogStorageSettings"] = None,
        log_settings: Optional["_models.LogSettings"] = None,
        preserve_rules: Optional[List[JSON]] = None,
        preserve: Optional[List[JSON]] = None,
        validate_data_consistency: Optional[JSON] = None,
        skip_error_file: Optional["_models.SkipErrorFile"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword inputs: List of inputs for the activity.
        :paramtype inputs: list[~azure.mgmt.datafactory.models.DatasetReference]
        :keyword outputs: List of outputs for the activity.
        :paramtype outputs: list[~azure.mgmt.datafactory.models.DatasetReference]
        :keyword source: Copy activity source. Required.
        :paramtype source: ~azure.mgmt.datafactory.models.CopySource
        :keyword sink: Copy activity sink. Required.
        :paramtype sink: ~azure.mgmt.datafactory.models.CopySink
        :keyword translator: Copy activity translator. If not specified, tabular translator is used.
        :paramtype translator: JSON
        :keyword enable_staging: Specifies whether to copy data via an interim staging. Default value
         is false. Type: boolean (or Expression with resultType boolean).
        :paramtype enable_staging: JSON
        :keyword staging_settings: Specifies interim staging settings when EnableStaging is true.
        :paramtype staging_settings: ~azure.mgmt.datafactory.models.StagingSettings
        :keyword parallel_copies: Maximum number of concurrent sessions opened on the source or sink to
         avoid overloading the data store. Type: integer (or Expression with resultType integer),
         minimum: 0.
        :paramtype parallel_copies: JSON
        :keyword data_integration_units: Maximum number of data integration units that can be used to
         perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
        :paramtype data_integration_units: JSON
        :keyword enable_skip_incompatible_row: Whether to skip incompatible row. Default value is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype enable_skip_incompatible_row: JSON
        :keyword redirect_incompatible_row_settings: Redirect incompatible row settings when
         EnableSkipIncompatibleRow is true.
        :paramtype redirect_incompatible_row_settings:
         ~azure.mgmt.datafactory.models.RedirectIncompatibleRowSettings
        :keyword log_storage_settings: (Deprecated. Please use LogSettings) Log storage settings
         customer need to provide when enabling session log.
        :paramtype log_storage_settings: ~azure.mgmt.datafactory.models.LogStorageSettings
        :keyword log_settings: Log settings customer needs provide when enabling log.
        :paramtype log_settings: ~azure.mgmt.datafactory.models.LogSettings
        :keyword preserve_rules: Preserve Rules.
        :paramtype preserve_rules: list[JSON]
        :keyword preserve: Preserve rules.
        :paramtype preserve: list[JSON]
        :keyword validate_data_consistency: Whether to enable Data Consistency validation. Type:
         boolean (or Expression with resultType boolean).
        :paramtype validate_data_consistency: JSON
        :keyword skip_error_file: Specify the fault tolerance for data consistency.
        :paramtype skip_error_file: ~azure.mgmt.datafactory.models.SkipErrorFile
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "Copy"  # type: str
        self.inputs = inputs
        self.outputs = outputs
        self.source = source
        self.sink = sink
        self.translator = translator
        self.enable_staging = enable_staging
        self.staging_settings = staging_settings
        self.parallel_copies = parallel_copies
        self.data_integration_units = data_integration_units
        self.enable_skip_incompatible_row = enable_skip_incompatible_row
        self.redirect_incompatible_row_settings = redirect_incompatible_row_settings
        self.log_storage_settings = log_storage_settings
        self.log_settings = log_settings
        self.preserve_rules = preserve_rules
        self.preserve = preserve
        self.validate_data_consistency = validate_data_consistency
        self.skip_error_file = skip_error_file


class CopyActivityLogSettings(_serialization.Model):
    """Settings for copy activity log.

    :ivar log_level: Gets or sets the log level, support: Info, Warning. Type: string (or
     Expression with resultType string).
    :vartype log_level: JSON
    :ivar enable_reliable_logging: Specifies whether to enable reliable logging. Type: boolean (or
     Expression with resultType boolean).
    :vartype enable_reliable_logging: JSON
    """

    _attribute_map = {
        "log_level": {"key": "logLevel", "type": "object"},
        "enable_reliable_logging": {"key": "enableReliableLogging", "type": "object"},
    }

    def __init__(self, *, log_level: Optional[JSON] = None, enable_reliable_logging: Optional[JSON] = None, **kwargs):
        """
        :keyword log_level: Gets or sets the log level, support: Info, Warning. Type: string (or
         Expression with resultType string).
        :paramtype log_level: JSON
        :keyword enable_reliable_logging: Specifies whether to enable reliable logging. Type: boolean
         (or Expression with resultType boolean).
        :paramtype enable_reliable_logging: JSON
        """
        super().__init__(**kwargs)
        self.log_level = log_level
        self.enable_reliable_logging = enable_reliable_logging


class CopyTranslator(_serialization.Model):
    """A copy activity translator.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TabularTranslator

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy translator type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"TabularTranslator": "TabularTranslator"}}

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]


class CosmosDbLinkedService(LinkedService):  # pylint: disable=too-many-instance-attributes
    """Microsoft Azure Cosmos Database (CosmosDB) linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: The connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar account_endpoint: The endpoint of the Azure CosmosDB account. Type: string (or Expression
     with resultType string).
    :vartype account_endpoint: JSON
    :ivar database: The name of the database. Type: string (or Expression with resultType string).
    :vartype database: JSON
    :ivar account_key: The account key of the Azure CosmosDB account. Type: SecureString or
     AzureKeyVaultSecretReference.
    :vartype account_key: ~azure.mgmt.datafactory.models.SecretBase
    :ivar service_principal_id: The client ID of the application in Azure Active Directory used for
     Server-To-Server authentication. Type: string (or Expression with resultType string).
    :vartype service_principal_id: JSON
    :ivar service_principal_credential_type: The service principal credential type to use in
     Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
     for certificate. Type: string (or Expression with resultType string). Known values are:
     "ServicePrincipalKey" and "ServicePrincipalCert".
    :vartype service_principal_credential_type: str or
     ~azure.mgmt.datafactory.models.CosmosDbServicePrincipalCredentialType
    :ivar service_principal_credential: The credential of the service principal object in Azure
     Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
     servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
     servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
     be AzureKeyVaultSecretReference.
    :vartype service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
    :ivar tenant: The name or ID of the tenant to which the service principal belongs. Type: string
     (or Expression with resultType string).
    :vartype tenant: JSON
    :ivar azure_cloud_type: Indicates the azure cloud type of the service principle auth. Allowed
     values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data
     factory regions’ cloud type. Type: string (or Expression with resultType string).
    :vartype azure_cloud_type: JSON
    :ivar connection_mode: The connection mode used to access CosmosDB account. Type: string (or
     Expression with resultType string). Known values are: "Gateway" and "Direct".
    :vartype connection_mode: str or ~azure.mgmt.datafactory.models.CosmosDbConnectionMode
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    :ivar credential: The credential reference containing authentication information.
    :vartype credential: ~azure.mgmt.datafactory.models.CredentialReference
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "account_endpoint": {"key": "typeProperties.accountEndpoint", "type": "object"},
        "database": {"key": "typeProperties.database", "type": "object"},
        "account_key": {"key": "typeProperties.accountKey", "type": "SecretBase"},
        "service_principal_id": {"key": "typeProperties.servicePrincipalId", "type": "object"},
        "service_principal_credential_type": {"key": "typeProperties.servicePrincipalCredentialType", "type": "str"},
        "service_principal_credential": {"key": "typeProperties.servicePrincipalCredential", "type": "SecretBase"},
        "tenant": {"key": "typeProperties.tenant", "type": "object"},
        "azure_cloud_type": {"key": "typeProperties.azureCloudType", "type": "object"},
        "connection_mode": {"key": "typeProperties.connectionMode", "type": "str"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
        "credential": {"key": "typeProperties.credential", "type": "CredentialReference"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        account_endpoint: Optional[JSON] = None,
        database: Optional[JSON] = None,
        account_key: Optional["_models.SecretBase"] = None,
        service_principal_id: Optional[JSON] = None,
        service_principal_credential_type: Optional[
            Union[str, "_models.CosmosDbServicePrincipalCredentialType"]
        ] = None,
        service_principal_credential: Optional["_models.SecretBase"] = None,
        tenant: Optional[JSON] = None,
        azure_cloud_type: Optional[JSON] = None,
        connection_mode: Optional[Union[str, "_models.CosmosDbConnectionMode"]] = None,
        encrypted_credential: Optional[JSON] = None,
        credential: Optional["_models.CredentialReference"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: The connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword account_endpoint: The endpoint of the Azure CosmosDB account. Type: string (or
         Expression with resultType string).
        :paramtype account_endpoint: JSON
        :keyword database: The name of the database. Type: string (or Expression with resultType
         string).
        :paramtype database: JSON
        :keyword account_key: The account key of the Azure CosmosDB account. Type: SecureString or
         AzureKeyVaultSecretReference.
        :paramtype account_key: ~azure.mgmt.datafactory.models.SecretBase
        :keyword service_principal_id: The client ID of the application in Azure Active Directory used
         for Server-To-Server authentication. Type: string (or Expression with resultType string).
        :paramtype service_principal_id: JSON
        :keyword service_principal_credential_type: The service principal credential type to use in
         Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert'
         for certificate. Type: string (or Expression with resultType string). Known values are:
         "ServicePrincipalKey" and "ServicePrincipalCert".
        :paramtype service_principal_credential_type: str or
         ~azure.mgmt.datafactory.models.CosmosDbServicePrincipalCredentialType
        :keyword service_principal_credential: The credential of the service principal object in Azure
         Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
         servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If
         servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only
         be AzureKeyVaultSecretReference.
        :paramtype service_principal_credential: ~azure.mgmt.datafactory.models.SecretBase
        :keyword tenant: The name or ID of the tenant to which the service principal belongs. Type:
         string (or Expression with resultType string).
        :paramtype tenant: JSON
        :keyword azure_cloud_type: Indicates the azure cloud type of the service principle auth.
         Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is
         the data factory regions’ cloud type. Type: string (or Expression with resultType string).
        :paramtype azure_cloud_type: JSON
        :keyword connection_mode: The connection mode used to access CosmosDB account. Type: string (or
         Expression with resultType string). Known values are: "Gateway" and "Direct".
        :paramtype connection_mode: str or ~azure.mgmt.datafactory.models.CosmosDbConnectionMode
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        :keyword credential: The credential reference containing authentication information.
        :paramtype credential: ~azure.mgmt.datafactory.models.CredentialReference
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "CosmosDb"  # type: str
        self.connection_string = connection_string
        self.account_endpoint = account_endpoint
        self.database = database
        self.account_key = account_key
        self.service_principal_id = service_principal_id
        self.service_principal_credential_type = service_principal_credential_type
        self.service_principal_credential = service_principal_credential
        self.tenant = tenant
        self.azure_cloud_type = azure_cloud_type
        self.connection_mode = connection_mode
        self.encrypted_credential = encrypted_credential
        self.credential = credential


class CosmosDbMongoDbApiCollectionDataset(Dataset):
    """The CosmosDB (MongoDB API) database dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar collection: The collection name of the CosmosDB (MongoDB API) database. Type: string (or
     Expression with resultType string). Required.
    :vartype collection: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
        "collection": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "collection": {"key": "typeProperties.collection", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        collection: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword collection: The collection name of the CosmosDB (MongoDB API) database. Type: string
         (or Expression with resultType string). Required.
        :paramtype collection: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "CosmosDbMongoDbApiCollection"  # type: str
        self.collection = collection


class CosmosDbMongoDbApiLinkedService(LinkedService):
    """Linked service for CosmosDB (MongoDB API) data source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar is_server_version_above32: Whether the CosmosDB (MongoDB API) server version is higher
     than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
    :vartype is_server_version_above32: JSON
    :ivar connection_string: The CosmosDB (MongoDB API) connection string. Type: string,
     SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or
     AzureKeyVaultSecretReference. Required.
    :vartype connection_string: JSON
    :ivar database: The name of the CosmosDB (MongoDB API) database that you want to access. Type:
     string (or Expression with resultType string). Required.
    :vartype database: JSON
    """

    _validation = {
        "type": {"required": True},
        "connection_string": {"required": True},
        "database": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "is_server_version_above32": {"key": "typeProperties.isServerVersionAbove32", "type": "object"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "database": {"key": "typeProperties.database", "type": "object"},
    }

    def __init__(
        self,
        *,
        connection_string: JSON,
        database: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        is_server_version_above32: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword is_server_version_above32: Whether the CosmosDB (MongoDB API) server version is higher
         than 3.2. The default value is false. Type: boolean (or Expression with resultType boolean).
        :paramtype is_server_version_above32: JSON
        :keyword connection_string: The CosmosDB (MongoDB API) connection string. Type: string,
         SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or
         AzureKeyVaultSecretReference. Required.
        :paramtype connection_string: JSON
        :keyword database: The name of the CosmosDB (MongoDB API) database that you want to access.
         Type: string (or Expression with resultType string). Required.
        :paramtype database: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "CosmosDbMongoDbApi"  # type: str
        self.is_server_version_above32 = is_server_version_above32
        self.connection_string = connection_string
        self.database = database


class CosmosDbMongoDbApiSink(CopySink):
    """A copy activity sink for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar write_behavior: Specifies whether the document with same key to be overwritten (upsert)
     rather than throw exception (insert). The default value is "insert". Type: string (or
     Expression with resultType string). Type: string (or Expression with resultType string).
    :vartype write_behavior: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "write_behavior": {"key": "writeBehavior", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        write_behavior: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword write_behavior: Specifies whether the document with same key to be overwritten
         (upsert) rather than throw exception (insert). The default value is "insert". Type: string (or
         Expression with resultType string). Type: string (or Expression with resultType string).
        :paramtype write_behavior: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "CosmosDbMongoDbApiSink"  # type: str
        self.write_behavior = write_behavior


class CosmosDbMongoDbApiSource(CopySource):  # pylint: disable=too-many-instance-attributes
    """A copy activity source for a CosmosDB (MongoDB API) database.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar filter: Specifies selection filter using query operators. To return all documents in a
     collection, omit this parameter or pass an empty document ({}). Type: string (or Expression
     with resultType string).
    :vartype filter: JSON
    :ivar cursor_methods: Cursor methods for Mongodb query.
    :vartype cursor_methods: ~azure.mgmt.datafactory.models.MongoDbCursorMethodsProperties
    :ivar batch_size: Specifies the number of documents to return in each batch of the response
     from MongoDB instance. In most cases, modifying the batch size will not affect the user or the
     application. This property's main purpose is to avoid hit the limitation of response size.
     Type: integer (or Expression with resultType integer).
    :vartype batch_size: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "filter": {"key": "filter", "type": "object"},
        "cursor_methods": {"key": "cursorMethods", "type": "MongoDbCursorMethodsProperties"},
        "batch_size": {"key": "batchSize", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        filter: Optional[JSON] = None,  # pylint: disable=redefined-builtin
        cursor_methods: Optional["_models.MongoDbCursorMethodsProperties"] = None,
        batch_size: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword filter: Specifies selection filter using query operators. To return all documents in a
         collection, omit this parameter or pass an empty document ({}). Type: string (or Expression
         with resultType string).
        :paramtype filter: JSON
        :keyword cursor_methods: Cursor methods for Mongodb query.
        :paramtype cursor_methods: ~azure.mgmt.datafactory.models.MongoDbCursorMethodsProperties
        :keyword batch_size: Specifies the number of documents to return in each batch of the response
         from MongoDB instance. In most cases, modifying the batch size will not affect the user or the
         application. This property's main purpose is to avoid hit the limitation of response size.
         Type: integer (or Expression with resultType integer).
        :paramtype batch_size: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "CosmosDbMongoDbApiSource"  # type: str
        self.filter = filter
        self.cursor_methods = cursor_methods
        self.batch_size = batch_size
        self.query_timeout = query_timeout
        self.additional_columns = additional_columns


class CosmosDbSqlApiCollectionDataset(Dataset):
    """Microsoft Azure CosmosDB (SQL API) Collection dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar collection_name: CosmosDB (SQL API) collection name. Type: string (or Expression with
     resultType string). Required.
    :vartype collection_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
        "collection_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "collection_name": {"key": "typeProperties.collectionName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        collection_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword collection_name: CosmosDB (SQL API) collection name. Type: string (or Expression with
         resultType string). Required.
        :paramtype collection_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "CosmosDbSqlApiCollection"  # type: str
        self.collection_name = collection_name


class CosmosDbSqlApiSink(CopySink):
    """A copy activity Azure CosmosDB (SQL API) Collection sink.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy sink type. Required.
    :vartype type: str
    :ivar write_batch_size: Write batch size. Type: integer (or Expression with resultType
     integer), minimum: 0.
    :vartype write_batch_size: JSON
    :ivar write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype write_batch_timeout: JSON
    :ivar sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
     integer).
    :vartype sink_retry_count: JSON
    :ivar sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype sink_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the sink data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
     Expression with resultType string). Allowed values: insert and upsert.
    :vartype write_behavior: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "write_batch_size": {"key": "writeBatchSize", "type": "object"},
        "write_batch_timeout": {"key": "writeBatchTimeout", "type": "object"},
        "sink_retry_count": {"key": "sinkRetryCount", "type": "object"},
        "sink_retry_wait": {"key": "sinkRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "write_behavior": {"key": "writeBehavior", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        write_batch_size: Optional[JSON] = None,
        write_batch_timeout: Optional[JSON] = None,
        sink_retry_count: Optional[JSON] = None,
        sink_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        write_behavior: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword write_batch_size: Write batch size. Type: integer (or Expression with resultType
         integer), minimum: 0.
        :paramtype write_batch_size: JSON
        :keyword write_batch_timeout: Write batch timeout. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype write_batch_timeout: JSON
        :keyword sink_retry_count: Sink retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype sink_retry_count: JSON
        :keyword sink_retry_wait: Sink retry wait. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype sink_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the sink data
         store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword write_behavior: Describes how to write data to Azure Cosmos DB. Type: string (or
         Expression with resultType string). Allowed values: insert and upsert.
        :paramtype write_behavior: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            write_batch_size=write_batch_size,
            write_batch_timeout=write_batch_timeout,
            sink_retry_count=sink_retry_count,
            sink_retry_wait=sink_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "CosmosDbSqlApiSink"  # type: str
        self.write_behavior = write_behavior


class CosmosDbSqlApiSource(CopySource):  # pylint: disable=too-many-instance-attributes
    """A copy activity Azure CosmosDB (SQL API) Collection source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query: SQL API query. Type: string (or Expression with resultType string).
    :vartype query: JSON
    :ivar page_size: Page size of the result. Type: integer (or Expression with resultType
     integer).
    :vartype page_size: JSON
    :ivar preferred_regions: Preferred regions. Type: array of strings (or Expression with
     resultType array of strings).
    :vartype preferred_regions: JSON
    :ivar detect_datetime: Whether detect primitive values as datetime values. Type: boolean (or
     Expression with resultType boolean).
    :vartype detect_datetime: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query": {"key": "query", "type": "object"},
        "page_size": {"key": "pageSize", "type": "object"},
        "preferred_regions": {"key": "preferredRegions", "type": "object"},
        "detect_datetime": {"key": "detectDatetime", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query: Optional[JSON] = None,
        page_size: Optional[JSON] = None,
        preferred_regions: Optional[JSON] = None,
        detect_datetime: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query: SQL API query. Type: string (or Expression with resultType string).
        :paramtype query: JSON
        :keyword page_size: Page size of the result. Type: integer (or Expression with resultType
         integer).
        :paramtype page_size: JSON
        :keyword preferred_regions: Preferred regions. Type: array of strings (or Expression with
         resultType array of strings).
        :paramtype preferred_regions: JSON
        :keyword detect_datetime: Whether detect primitive values as datetime values. Type: boolean (or
         Expression with resultType boolean).
        :paramtype detect_datetime: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            **kwargs
        )
        self.type = "CosmosDbSqlApiSource"  # type: str
        self.query = query
        self.page_size = page_size
        self.preferred_regions = preferred_regions
        self.detect_datetime = detect_datetime
        self.additional_columns = additional_columns


class CouchbaseLinkedService(LinkedService):
    """Couchbase server linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar connection_string: An ODBC connection string. Type: string, SecureString or
     AzureKeyVaultSecretReference.
    :vartype connection_string: JSON
    :ivar cred_string: The Azure key vault secret reference of credString in connection string.
    :vartype cred_string: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
    :ivar encrypted_credential: The encrypted credential used for authentication. Credentials are
     encrypted using the integration runtime credential manager. Type: string (or Expression with
     resultType string).
    :vartype encrypted_credential: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "connection_string": {"key": "typeProperties.connectionString", "type": "object"},
        "cred_string": {"key": "typeProperties.credString", "type": "AzureKeyVaultSecretReference"},
        "encrypted_credential": {"key": "typeProperties.encryptedCredential", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        connection_string: Optional[JSON] = None,
        cred_string: Optional["_models.AzureKeyVaultSecretReference"] = None,
        encrypted_credential: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword connection_string: An ODBC connection string. Type: string, SecureString or
         AzureKeyVaultSecretReference.
        :paramtype connection_string: JSON
        :keyword cred_string: The Azure key vault secret reference of credString in connection string.
        :paramtype cred_string: ~azure.mgmt.datafactory.models.AzureKeyVaultSecretReference
        :keyword encrypted_credential: The encrypted credential used for authentication. Credentials
         are encrypted using the integration runtime credential manager. Type: string (or Expression
         with resultType string).
        :paramtype encrypted_credential: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "Couchbase"  # type: str
        self.connection_string = connection_string
        self.cred_string = cred_string
        self.encrypted_credential = encrypted_credential


class CouchbaseSource(TabularSource):
    """A copy activity Couchbase server source.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Copy source type. Required.
    :vartype type: str
    :ivar source_retry_count: Source retry count. Type: integer (or Expression with resultType
     integer).
    :vartype source_retry_count: JSON
    :ivar source_retry_wait: Source retry wait. Type: string (or Expression with resultType
     string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype source_retry_wait: JSON
    :ivar max_concurrent_connections: The maximum concurrent connection count for the source data
     store. Type: integer (or Expression with resultType integer).
    :vartype max_concurrent_connections: JSON
    :ivar disable_metrics_collection: If true, disable data store metrics collection. Default is
     false. Type: boolean (or Expression with resultType boolean).
    :vartype disable_metrics_collection: JSON
    :ivar query_timeout: Query timeout. Type: string (or Expression with resultType string),
     pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :vartype query_timeout: JSON
    :ivar additional_columns: Specifies the additional columns to be added to source data. Type:
     array of objects(AdditionalColumns) (or Expression with resultType array of objects).
    :vartype additional_columns: JSON
    :ivar query: A query to retrieve data from source. Type: string (or Expression with resultType
     string).
    :vartype query: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "source_retry_count": {"key": "sourceRetryCount", "type": "object"},
        "source_retry_wait": {"key": "sourceRetryWait", "type": "object"},
        "max_concurrent_connections": {"key": "maxConcurrentConnections", "type": "object"},
        "disable_metrics_collection": {"key": "disableMetricsCollection", "type": "object"},
        "query_timeout": {"key": "queryTimeout", "type": "object"},
        "additional_columns": {"key": "additionalColumns", "type": "object"},
        "query": {"key": "query", "type": "object"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_retry_count: Optional[JSON] = None,
        source_retry_wait: Optional[JSON] = None,
        max_concurrent_connections: Optional[JSON] = None,
        disable_metrics_collection: Optional[JSON] = None,
        query_timeout: Optional[JSON] = None,
        additional_columns: Optional[JSON] = None,
        query: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_retry_count: Source retry count. Type: integer (or Expression with resultType
         integer).
        :paramtype source_retry_count: JSON
        :keyword source_retry_wait: Source retry wait. Type: string (or Expression with resultType
         string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype source_retry_wait: JSON
        :keyword max_concurrent_connections: The maximum concurrent connection count for the source
         data store. Type: integer (or Expression with resultType integer).
        :paramtype max_concurrent_connections: JSON
        :keyword disable_metrics_collection: If true, disable data store metrics collection. Default is
         false. Type: boolean (or Expression with resultType boolean).
        :paramtype disable_metrics_collection: JSON
        :keyword query_timeout: Query timeout. Type: string (or Expression with resultType string),
         pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
        :paramtype query_timeout: JSON
        :keyword additional_columns: Specifies the additional columns to be added to source data. Type:
         array of objects(AdditionalColumns) (or Expression with resultType array of objects).
        :paramtype additional_columns: JSON
        :keyword query: A query to retrieve data from source. Type: string (or Expression with
         resultType string).
        :paramtype query: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            source_retry_count=source_retry_count,
            source_retry_wait=source_retry_wait,
            max_concurrent_connections=max_concurrent_connections,
            disable_metrics_collection=disable_metrics_collection,
            query_timeout=query_timeout,
            additional_columns=additional_columns,
            **kwargs
        )
        self.type = "CouchbaseSource"  # type: str
        self.query = query


class CouchbaseTableDataset(Dataset):
    """Couchbase server dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar table_name: The table name. Type: string (or Expression with resultType string).
    :vartype table_name: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "table_name": {"key": "typeProperties.tableName", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        table_name: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword table_name: The table name. Type: string (or Expression with resultType string).
        :paramtype table_name: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "CouchbaseTable"  # type: str
        self.table_name = table_name


class CreateDataFlowDebugSessionRequest(_serialization.Model):
    """Request body structure for creating data flow debug session.

    :ivar compute_type: Compute type of the cluster. The value will be overwritten by the same
     setting in integration runtime if provided.
    :vartype compute_type: str
    :ivar core_count: Core count of the cluster. The value will be overwritten by the same setting
     in integration runtime if provided.
    :vartype core_count: int
    :ivar time_to_live: Time to live setting of the cluster in minutes.
    :vartype time_to_live: int
    :ivar integration_runtime: Set to use integration runtime setting for data flow debug session.
    :vartype integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeDebugResource
    """

    _attribute_map = {
        "compute_type": {"key": "computeType", "type": "str"},
        "core_count": {"key": "coreCount", "type": "int"},
        "time_to_live": {"key": "timeToLive", "type": "int"},
        "integration_runtime": {"key": "integrationRuntime", "type": "IntegrationRuntimeDebugResource"},
    }

    def __init__(
        self,
        *,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        time_to_live: Optional[int] = None,
        integration_runtime: Optional["_models.IntegrationRuntimeDebugResource"] = None,
        **kwargs
    ):
        """
        :keyword compute_type: Compute type of the cluster. The value will be overwritten by the same
         setting in integration runtime if provided.
        :paramtype compute_type: str
        :keyword core_count: Core count of the cluster. The value will be overwritten by the same
         setting in integration runtime if provided.
        :paramtype core_count: int
        :keyword time_to_live: Time to live setting of the cluster in minutes.
        :paramtype time_to_live: int
        :keyword integration_runtime: Set to use integration runtime setting for data flow debug
         session.
        :paramtype integration_runtime: ~azure.mgmt.datafactory.models.IntegrationRuntimeDebugResource
        """
        super().__init__(**kwargs)
        self.compute_type = compute_type
        self.core_count = core_count
        self.time_to_live = time_to_live
        self.integration_runtime = integration_runtime


class CreateDataFlowDebugSessionResponse(_serialization.Model):
    """Response body structure for creating data flow debug session.

    :ivar status: The state of the debug session.
    :vartype status: str
    :ivar session_id: The ID of data flow debug session.
    :vartype session_id: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "session_id": {"key": "sessionId", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, session_id: Optional[str] = None, **kwargs):
        """
        :keyword status: The state of the debug session.
        :paramtype status: str
        :keyword session_id: The ID of data flow debug session.
        :paramtype session_id: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.session_id = session_id


class CreateLinkedIntegrationRuntimeRequest(_serialization.Model):
    """The linked integration runtime information.

    :ivar name: The name of the linked integration runtime.
    :vartype name: str
    :ivar subscription_id: The ID of the subscription that the linked integration runtime belongs
     to.
    :vartype subscription_id: str
    :ivar data_factory_name: The name of the data factory that the linked integration runtime
     belongs to.
    :vartype data_factory_name: str
    :ivar data_factory_location: The location of the data factory that the linked integration
     runtime belongs to.
    :vartype data_factory_location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "data_factory_name": {"key": "dataFactoryName", "type": "str"},
        "data_factory_location": {"key": "dataFactoryLocation", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        subscription_id: Optional[str] = None,
        data_factory_name: Optional[str] = None,
        data_factory_location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the linked integration runtime.
        :paramtype name: str
        :keyword subscription_id: The ID of the subscription that the linked integration runtime
         belongs to.
        :paramtype subscription_id: str
        :keyword data_factory_name: The name of the data factory that the linked integration runtime
         belongs to.
        :paramtype data_factory_name: str
        :keyword data_factory_location: The location of the data factory that the linked integration
         runtime belongs to.
        :paramtype data_factory_location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.subscription_id = subscription_id
        self.data_factory_name = data_factory_name
        self.data_factory_location = data_factory_location


class CreateRunResponse(_serialization.Model):
    """Response body with a run identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar run_id: Identifier of a run. Required.
    :vartype run_id: str
    """

    _validation = {
        "run_id": {"required": True},
    }

    _attribute_map = {
        "run_id": {"key": "runId", "type": "str"},
    }

    def __init__(self, *, run_id: str, **kwargs):
        """
        :keyword run_id: Identifier of a run. Required.
        :paramtype run_id: str
        """
        super().__init__(**kwargs)
        self.run_id = run_id


class Credential(_serialization.Model):
    """The Azure Data Factory nested object which contains the information and credential which can be used to connect with related store or compute resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ManagedIdentityCredential, ServicePrincipalCredential

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of credential. Required.
    :vartype type: str
    :ivar description: Credential description.
    :vartype description: str
    :ivar annotations: List of tags that can be used for describing the Credential.
    :vartype annotations: list[JSON]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
    }

    _subtype_map = {
        "type": {"ManagedIdentity": "ManagedIdentityCredential", "ServicePrincipal": "ServicePrincipalCredential"}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Credential description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the Credential.
        :paramtype annotations: list[JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None  # type: Optional[str]
        self.description = description
        self.annotations = annotations


class CredentialReference(_serialization.Model):
    """Credential reference type.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Credential reference type. Required. "CredentialReference"
    :vartype type: str or ~azure.mgmt.datafactory.models.CredentialReferenceType
    :ivar reference_name: Reference credential name. Required.
    :vartype reference_name: str
    """

    _validation = {
        "type": {"required": True},
        "reference_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "reference_name": {"key": "referenceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.CredentialReferenceType"],
        reference_name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword type: Credential reference type. Required. "CredentialReference"
        :paramtype type: str or ~azure.mgmt.datafactory.models.CredentialReferenceType
        :keyword reference_name: Reference credential name. Required.
        :paramtype reference_name: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.reference_name = reference_name


class SubResource(_serialization.Model):
    """Azure Data Factory nested resource, which belongs to a factory.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class CredentialResource(SubResource):
    """Credential resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :ivar properties: Properties of credentials. Required.
    :vartype properties: ~azure.mgmt.datafactory.models.Credential
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "Credential"},
    }

    def __init__(self, *, properties: "_models.Credential", **kwargs):
        """
        :keyword properties: Properties of credentials. Required.
        :paramtype properties: ~azure.mgmt.datafactory.models.Credential
        """
        super().__init__(**kwargs)
        self.properties = properties


class CustomActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Custom activity type.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar command: Command for custom activity Type: string (or Expression with resultType string).
     Required.
    :vartype command: JSON
    :ivar resource_linked_service: Resource linked service reference.
    :vartype resource_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar folder_path: Folder path for resource files Type: string (or Expression with resultType
     string).
    :vartype folder_path: JSON
    :ivar reference_objects: Reference objects.
    :vartype reference_objects: ~azure.mgmt.datafactory.models.CustomActivityReferenceObject
    :ivar extended_properties: User defined property bag. There is no restriction on the keys or
     values that can be used. The user specified custom activity has the full responsibility to
     consume and interpret the content defined.
    :vartype extended_properties: dict[str, JSON]
    :ivar retention_time_in_days: The retention time for the files submitted for custom activity.
     Type: double (or Expression with resultType double).
    :vartype retention_time_in_days: JSON
    :ivar auto_user_specification: Elevation level and scope for the user, default is nonadmin
     task. Type: string (or Expression with resultType double).
    :vartype auto_user_specification: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "command": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "command": {"key": "typeProperties.command", "type": "object"},
        "resource_linked_service": {"key": "typeProperties.resourceLinkedService", "type": "LinkedServiceReference"},
        "folder_path": {"key": "typeProperties.folderPath", "type": "object"},
        "reference_objects": {"key": "typeProperties.referenceObjects", "type": "CustomActivityReferenceObject"},
        "extended_properties": {"key": "typeProperties.extendedProperties", "type": "{object}"},
        "retention_time_in_days": {"key": "typeProperties.retentionTimeInDays", "type": "object"},
        "auto_user_specification": {"key": "typeProperties.autoUserSpecification", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        command: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        resource_linked_service: Optional["_models.LinkedServiceReference"] = None,
        folder_path: Optional[JSON] = None,
        reference_objects: Optional["_models.CustomActivityReferenceObject"] = None,
        extended_properties: Optional[Dict[str, JSON]] = None,
        retention_time_in_days: Optional[JSON] = None,
        auto_user_specification: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword command: Command for custom activity Type: string (or Expression with resultType
         string). Required.
        :paramtype command: JSON
        :keyword resource_linked_service: Resource linked service reference.
        :paramtype resource_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword folder_path: Folder path for resource files Type: string (or Expression with
         resultType string).
        :paramtype folder_path: JSON
        :keyword reference_objects: Reference objects.
        :paramtype reference_objects: ~azure.mgmt.datafactory.models.CustomActivityReferenceObject
        :keyword extended_properties: User defined property bag. There is no restriction on the keys or
         values that can be used. The user specified custom activity has the full responsibility to
         consume and interpret the content defined.
        :paramtype extended_properties: dict[str, JSON]
        :keyword retention_time_in_days: The retention time for the files submitted for custom
         activity. Type: double (or Expression with resultType double).
        :paramtype retention_time_in_days: JSON
        :keyword auto_user_specification: Elevation level and scope for the user, default is nonadmin
         task. Type: string (or Expression with resultType double).
        :paramtype auto_user_specification: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "Custom"  # type: str
        self.command = command
        self.resource_linked_service = resource_linked_service
        self.folder_path = folder_path
        self.reference_objects = reference_objects
        self.extended_properties = extended_properties
        self.retention_time_in_days = retention_time_in_days
        self.auto_user_specification = auto_user_specification


class CustomActivityReferenceObject(_serialization.Model):
    """Reference objects for custom activity.

    :ivar linked_services: Linked service references.
    :vartype linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
    :ivar datasets: Dataset references.
    :vartype datasets: list[~azure.mgmt.datafactory.models.DatasetReference]
    """

    _attribute_map = {
        "linked_services": {"key": "linkedServices", "type": "[LinkedServiceReference]"},
        "datasets": {"key": "datasets", "type": "[DatasetReference]"},
    }

    def __init__(
        self,
        *,
        linked_services: Optional[List["_models.LinkedServiceReference"]] = None,
        datasets: Optional[List["_models.DatasetReference"]] = None,
        **kwargs
    ):
        """
        :keyword linked_services: Linked service references.
        :paramtype linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceReference]
        :keyword datasets: Dataset references.
        :paramtype datasets: list[~azure.mgmt.datafactory.models.DatasetReference]
        """
        super().__init__(**kwargs)
        self.linked_services = linked_services
        self.datasets = datasets


class CustomDataset(Dataset):
    """The custom dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset. Required.
    :vartype type: str
    :ivar description: Dataset description.
    :vartype description: str
    :ivar structure: Columns that define the structure of the dataset. Type: array (or Expression
     with resultType array), itemType: DatasetDataElement.
    :vartype structure: JSON
    :ivar schema: Columns that define the physical type schema of the dataset. Type: array (or
     Expression with resultType array), itemType: DatasetSchemaDataElement.
    :vartype schema: JSON
    :ivar linked_service_name: Linked service reference. Required.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar parameters: Parameters for dataset.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the Dataset.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this Dataset is in. If not specified, Dataset will appear at the
     root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DatasetFolder
    :ivar type_properties: Custom dataset properties.
    :vartype type_properties: JSON
    """

    _validation = {
        "type": {"required": True},
        "linked_service_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "structure": {"key": "structure", "type": "object"},
        "schema": {"key": "schema", "type": "object"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DatasetFolder"},
        "type_properties": {"key": "typeProperties", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service_name: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        structure: Optional[JSON] = None,
        schema: Optional[JSON] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DatasetFolder"] = None,
        type_properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Dataset description.
        :paramtype description: str
        :keyword structure: Columns that define the structure of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetDataElement.
        :paramtype structure: JSON
        :keyword schema: Columns that define the physical type schema of the dataset. Type: array (or
         Expression with resultType array), itemType: DatasetSchemaDataElement.
        :paramtype schema: JSON
        :keyword linked_service_name: Linked service reference. Required.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword parameters: Parameters for dataset.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the Dataset.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this Dataset is in. If not specified, Dataset will appear at
         the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DatasetFolder
        :keyword type_properties: Custom dataset properties.
        :paramtype type_properties: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            structure=structure,
            schema=schema,
            linked_service_name=linked_service_name,
            parameters=parameters,
            annotations=annotations,
            folder=folder,
            **kwargs
        )
        self.type = "CustomDataset"  # type: str
        self.type_properties = type_properties


class CustomDataSourceLinkedService(LinkedService):
    """Custom linked service.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of linked service. Required.
    :vartype type: str
    :ivar connect_via: The integration runtime reference.
    :vartype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
    :ivar description: Linked service description.
    :vartype description: str
    :ivar parameters: Parameters for linked service.
    :vartype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
    :ivar annotations: List of tags that can be used for describing the linked service.
    :vartype annotations: list[JSON]
    :ivar type_properties: Custom linked service properties. Required.
    :vartype type_properties: JSON
    """

    _validation = {
        "type": {"required": True},
        "type_properties": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "connect_via": {"key": "connectVia", "type": "IntegrationRuntimeReference"},
        "description": {"key": "description", "type": "str"},
        "parameters": {"key": "parameters", "type": "{ParameterSpecification}"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "type_properties": {"key": "typeProperties", "type": "object"},
    }

    def __init__(
        self,
        *,
        type_properties: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        connect_via: Optional["_models.IntegrationRuntimeReference"] = None,
        description: Optional[str] = None,
        parameters: Optional[Dict[str, "_models.ParameterSpecification"]] = None,
        annotations: Optional[List[JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword connect_via: The integration runtime reference.
        :paramtype connect_via: ~azure.mgmt.datafactory.models.IntegrationRuntimeReference
        :keyword description: Linked service description.
        :paramtype description: str
        :keyword parameters: Parameters for linked service.
        :paramtype parameters: dict[str, ~azure.mgmt.datafactory.models.ParameterSpecification]
        :keyword annotations: List of tags that can be used for describing the linked service.
        :paramtype annotations: list[JSON]
        :keyword type_properties: Custom linked service properties. Required.
        :paramtype type_properties: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            connect_via=connect_via,
            description=description,
            parameters=parameters,
            annotations=annotations,
            **kwargs
        )
        self.type = "CustomDataSource"  # type: str
        self.type_properties = type_properties


class CustomEventsTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time a custom event is received.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Trigger type. Required.
    :vartype type: str
    :ivar description: Trigger description.
    :vartype description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when Start/Stop APIs are
     called on the Trigger. Known values are: "Started", "Stopped", and "Disabled".
    :vartype runtime_state: str or ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :ivar annotations: List of tags that can be used for describing the trigger.
    :vartype annotations: list[JSON]
    :ivar pipelines: Pipelines that need to be started.
    :vartype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :ivar subject_begins_with: The event subject must begin with the pattern provided for trigger
     to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
    :vartype subject_begins_with: str
    :ivar subject_ends_with: The event subject must end with the pattern provided for trigger to
     fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
    :vartype subject_ends_with: str
    :ivar events: The list of event types that cause this trigger to fire. Required.
    :vartype events: list[JSON]
    :ivar scope: The ARM resource ID of the Azure Event Grid Topic. Required.
    :vartype scope: str
    """

    _validation = {
        "type": {"required": True},
        "runtime_state": {"readonly": True},
        "events": {"required": True},
        "scope": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "runtime_state": {"key": "runtimeState", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "pipelines": {"key": "pipelines", "type": "[TriggerPipelineReference]"},
        "subject_begins_with": {"key": "typeProperties.subjectBeginsWith", "type": "str"},
        "subject_ends_with": {"key": "typeProperties.subjectEndsWith", "type": "str"},
        "events": {"key": "typeProperties.events", "type": "[object]"},
        "scope": {"key": "typeProperties.scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        events: List[JSON],
        scope: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        pipelines: Optional[List["_models.TriggerPipelineReference"]] = None,
        subject_begins_with: Optional[str] = None,
        subject_ends_with: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword description: Trigger description.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the trigger.
        :paramtype annotations: list[JSON]
        :keyword pipelines: Pipelines that need to be started.
        :paramtype pipelines: list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
        :keyword subject_begins_with: The event subject must begin with the pattern provided for
         trigger to fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
        :paramtype subject_begins_with: str
        :keyword subject_ends_with: The event subject must end with the pattern provided for trigger to
         fire. At least one of these must be provided: subjectBeginsWith, subjectEndsWith.
        :paramtype subject_ends_with: str
        :keyword events: The list of event types that cause this trigger to fire. Required.
        :paramtype events: list[JSON]
        :keyword scope: The ARM resource ID of the Azure Event Grid Topic. Required.
        :paramtype scope: str
        """
        super().__init__(
            additional_properties=additional_properties,
            description=description,
            annotations=annotations,
            pipelines=pipelines,
            **kwargs
        )
        self.type = "CustomEventsTrigger"  # type: str
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.events = events
        self.scope = scope


class DatabricksNotebookActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """DatabricksNotebook activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar notebook_path: The absolute path of the notebook to be run in the Databricks Workspace.
     This path must begin with a slash. Type: string (or Expression with resultType string).
     Required.
    :vartype notebook_path: JSON
    :ivar base_parameters: Base parameters to be used for each run of this job.If the notebook
     takes a parameter that is not specified, the default value from the notebook will be used.
    :vartype base_parameters: dict[str, JSON]
    :ivar libraries: A list of libraries to be installed on the cluster that will execute the job.
    :vartype libraries: list[dict[str, JSON]]
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "notebook_path": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "notebook_path": {"key": "typeProperties.notebookPath", "type": "object"},
        "base_parameters": {"key": "typeProperties.baseParameters", "type": "{object}"},
        "libraries": {"key": "typeProperties.libraries", "type": "[{object}]"},
    }

    def __init__(
        self,
        *,
        name: str,
        notebook_path: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        base_parameters: Optional[Dict[str, JSON]] = None,
        libraries: Optional[List[Dict[str, JSON]]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword notebook_path: The absolute path of the notebook to be run in the Databricks
         Workspace. This path must begin with a slash. Type: string (or Expression with resultType
         string). Required.
        :paramtype notebook_path: JSON
        :keyword base_parameters: Base parameters to be used for each run of this job.If the notebook
         takes a parameter that is not specified, the default value from the notebook will be used.
        :paramtype base_parameters: dict[str, JSON]
        :keyword libraries: A list of libraries to be installed on the cluster that will execute the
         job.
        :paramtype libraries: list[dict[str, JSON]]
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "DatabricksNotebook"  # type: str
        self.notebook_path = notebook_path
        self.base_parameters = base_parameters
        self.libraries = libraries


class DatabricksSparkJarActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """DatabricksSparkJar activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar main_class_name: The full name of the class containing the main method to be executed.
     This class must be contained in a JAR provided as a library. Type: string (or Expression with
     resultType string). Required.
    :vartype main_class_name: JSON
    :ivar parameters: Parameters that will be passed to the main method.
    :vartype parameters: list[JSON]
    :ivar libraries: A list of libraries to be installed on the cluster that will execute the job.
    :vartype libraries: list[dict[str, JSON]]
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "main_class_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "main_class_name": {"key": "typeProperties.mainClassName", "type": "object"},
        "parameters": {"key": "typeProperties.parameters", "type": "[object]"},
        "libraries": {"key": "typeProperties.libraries", "type": "[{object}]"},
    }

    def __init__(
        self,
        *,
        name: str,
        main_class_name: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        parameters: Optional[List[JSON]] = None,
        libraries: Optional[List[Dict[str, JSON]]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword main_class_name: The full name of the class containing the main method to be executed.
         This class must be contained in a JAR provided as a library. Type: string (or Expression with
         resultType string). Required.
        :paramtype main_class_name: JSON
        :keyword parameters: Parameters that will be passed to the main method.
        :paramtype parameters: list[JSON]
        :keyword libraries: A list of libraries to be installed on the cluster that will execute the
         job.
        :paramtype libraries: list[dict[str, JSON]]
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "DatabricksSparkJar"  # type: str
        self.main_class_name = main_class_name
        self.parameters = parameters
        self.libraries = libraries


class DatabricksSparkPythonActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """DatabricksSparkPython activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar python_file: The URI of the Python file to be executed. DBFS paths are supported. Type:
     string (or Expression with resultType string). Required.
    :vartype python_file: JSON
    :ivar parameters: Command line parameters that will be passed to the Python file.
    :vartype parameters: list[JSON]
    :ivar libraries: A list of libraries to be installed on the cluster that will execute the job.
    :vartype libraries: list[dict[str, JSON]]
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "python_file": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "python_file": {"key": "typeProperties.pythonFile", "type": "object"},
        "parameters": {"key": "typeProperties.parameters", "type": "[object]"},
        "libraries": {"key": "typeProperties.libraries", "type": "[{object}]"},
    }

    def __init__(
        self,
        *,
        name: str,
        python_file: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        parameters: Optional[List[JSON]] = None,
        libraries: Optional[List[Dict[str, JSON]]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword python_file: The URI of the Python file to be executed. DBFS paths are supported.
         Type: string (or Expression with resultType string). Required.
        :paramtype python_file: JSON
        :keyword parameters: Command line parameters that will be passed to the Python file.
        :paramtype parameters: list[JSON]
        :keyword libraries: A list of libraries to be installed on the cluster that will execute the
         job.
        :paramtype libraries: list[dict[str, JSON]]
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "DatabricksSparkPython"  # type: str
        self.python_file = python_file
        self.parameters = parameters
        self.libraries = libraries


class DataFlow(_serialization.Model):
    """Azure Data Factory nested object which contains a flow with data movements and transformations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Flowlet, MappingDataFlow, WranglingDataFlow

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of data flow. Required.
    :vartype type: str
    :ivar description: The description of the data flow.
    :vartype description: str
    :ivar annotations: List of tags that can be used for describing the data flow.
    :vartype annotations: list[JSON]
    :ivar folder: The folder that this data flow is in. If not specified, Data flow will appear at
     the root level.
    :vartype folder: ~azure.mgmt.datafactory.models.DataFlowFolder
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "annotations": {"key": "annotations", "type": "[object]"},
        "folder": {"key": "folder", "type": "DataFlowFolder"},
    }

    _subtype_map = {
        "type": {"Flowlet": "Flowlet", "MappingDataFlow": "MappingDataFlow", "WranglingDataFlow": "WranglingDataFlow"}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        annotations: Optional[List[JSON]] = None,
        folder: Optional["_models.DataFlowFolder"] = None,
        **kwargs
    ):
        """
        :keyword description: The description of the data flow.
        :paramtype description: str
        :keyword annotations: List of tags that can be used for describing the data flow.
        :paramtype annotations: list[JSON]
        :keyword folder: The folder that this data flow is in. If not specified, Data flow will appear
         at the root level.
        :paramtype folder: ~azure.mgmt.datafactory.models.DataFlowFolder
        """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.description = description
        self.annotations = annotations
        self.folder = folder


class DataFlowDebugCommandPayload(_serialization.Model):
    """Structure of command payload.

    All required parameters must be populated in order to send to Azure.

    :ivar stream_name: The stream name which is used for preview. Required.
    :vartype stream_name: str
    :ivar row_limits: Row limits for preview response.
    :vartype row_limits: int
    :ivar columns: Array of column names.
    :vartype columns: list[str]
    :ivar expression: The expression which is used for preview.
    :vartype expression: str
    """

    _validation = {
        "stream_name": {"required": True},
    }

    _attribute_map = {
        "stream_name": {"key": "streamName", "type": "str"},
        "row_limits": {"key": "rowLimits", "type": "int"},
        "columns": {"key": "columns", "type": "[str]"},
        "expression": {"key": "expression", "type": "str"},
    }

    def __init__(
        self,
        *,
        stream_name: str,
        row_limits: Optional[int] = None,
        columns: Optional[List[str]] = None,
        expression: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword stream_name: The stream name which is used for preview. Required.
        :paramtype stream_name: str
        :keyword row_limits: Row limits for preview response.
        :paramtype row_limits: int
        :keyword columns: Array of column names.
        :paramtype columns: list[str]
        :keyword expression: The expression which is used for preview.
        :paramtype expression: str
        """
        super().__init__(**kwargs)
        self.stream_name = stream_name
        self.row_limits = row_limits
        self.columns = columns
        self.expression = expression


class DataFlowDebugCommandRequest(_serialization.Model):
    """Request body structure for data flow debug command.

    :ivar session_id: The ID of data flow debug session.
    :vartype session_id: str
    :ivar command: The command type. Known values are: "executePreviewQuery",
     "executeStatisticsQuery", and "executeExpressionQuery".
    :vartype command: str or ~azure.mgmt.datafactory.models.DataFlowDebugCommandType
    :ivar command_payload: The command payload object.
    :vartype command_payload: ~azure.mgmt.datafactory.models.DataFlowDebugCommandPayload
    """

    _attribute_map = {
        "session_id": {"key": "sessionId", "type": "str"},
        "command": {"key": "command", "type": "str"},
        "command_payload": {"key": "commandPayload", "type": "DataFlowDebugCommandPayload"},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        command: Optional[Union[str, "_models.DataFlowDebugCommandType"]] = None,
        command_payload: Optional["_models.DataFlowDebugCommandPayload"] = None,
        **kwargs
    ):
        """
        :keyword session_id: The ID of data flow debug session.
        :paramtype session_id: str
        :keyword command: The command type. Known values are: "executePreviewQuery",
         "executeStatisticsQuery", and "executeExpressionQuery".
        :paramtype command: str or ~azure.mgmt.datafactory.models.DataFlowDebugCommandType
        :keyword command_payload: The command payload object.
        :paramtype command_payload: ~azure.mgmt.datafactory.models.DataFlowDebugCommandPayload
        """
        super().__init__(**kwargs)
        self.session_id = session_id
        self.command = command
        self.command_payload = command_payload


class DataFlowDebugCommandResponse(_serialization.Model):
    """Response body structure of data flow result for data preview, statistics or expression preview.

    :ivar status: The run status of data preview, statistics or expression preview.
    :vartype status: str
    :ivar data: The result data of data preview, statistics or expression preview.
    :vartype data: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "data": {"key": "data", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, data: Optional[str] = None, **kwargs):
        """
        :keyword status: The run status of data preview, statistics or expression preview.
        :paramtype status: str
        :keyword data: The result data of data preview, statistics or expression preview.
        :paramtype data: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.data = data


class DataFlowDebugPackage(_serialization.Model):
    """Request body structure for starting data flow debug session.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar session_id: The ID of data flow debug session.
    :vartype session_id: str
    :ivar data_flow: Data flow instance.
    :vartype data_flow: ~azure.mgmt.datafactory.models.DataFlowDebugResource
    :ivar data_flows: List of Data flows.
    :vartype data_flows: list[~azure.mgmt.datafactory.models.DataFlowDebugResource]
    :ivar datasets: List of datasets.
    :vartype datasets: list[~azure.mgmt.datafactory.models.DatasetDebugResource]
    :ivar linked_services: List of linked services.
    :vartype linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceDebugResource]
    :ivar staging: Staging info for debug session.
    :vartype staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
    :ivar debug_settings: Data flow debug settings.
    :vartype debug_settings: ~azure.mgmt.datafactory.models.DataFlowDebugPackageDebugSettings
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "session_id": {"key": "sessionId", "type": "str"},
        "data_flow": {"key": "dataFlow", "type": "DataFlowDebugResource"},
        "data_flows": {"key": "dataFlows", "type": "[DataFlowDebugResource]"},
        "datasets": {"key": "datasets", "type": "[DatasetDebugResource]"},
        "linked_services": {"key": "linkedServices", "type": "[LinkedServiceDebugResource]"},
        "staging": {"key": "staging", "type": "DataFlowStagingInfo"},
        "debug_settings": {"key": "debugSettings", "type": "DataFlowDebugPackageDebugSettings"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        session_id: Optional[str] = None,
        data_flow: Optional["_models.DataFlowDebugResource"] = None,
        data_flows: Optional[List["_models.DataFlowDebugResource"]] = None,
        datasets: Optional[List["_models.DatasetDebugResource"]] = None,
        linked_services: Optional[List["_models.LinkedServiceDebugResource"]] = None,
        staging: Optional["_models.DataFlowStagingInfo"] = None,
        debug_settings: Optional["_models.DataFlowDebugPackageDebugSettings"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword session_id: The ID of data flow debug session.
        :paramtype session_id: str
        :keyword data_flow: Data flow instance.
        :paramtype data_flow: ~azure.mgmt.datafactory.models.DataFlowDebugResource
        :keyword data_flows: List of Data flows.
        :paramtype data_flows: list[~azure.mgmt.datafactory.models.DataFlowDebugResource]
        :keyword datasets: List of datasets.
        :paramtype datasets: list[~azure.mgmt.datafactory.models.DatasetDebugResource]
        :keyword linked_services: List of linked services.
        :paramtype linked_services: list[~azure.mgmt.datafactory.models.LinkedServiceDebugResource]
        :keyword staging: Staging info for debug session.
        :paramtype staging: ~azure.mgmt.datafactory.models.DataFlowStagingInfo
        :keyword debug_settings: Data flow debug settings.
        :paramtype debug_settings: ~azure.mgmt.datafactory.models.DataFlowDebugPackageDebugSettings
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.session_id = session_id
        self.data_flow = data_flow
        self.data_flows = data_flows
        self.datasets = datasets
        self.linked_services = linked_services
        self.staging = staging
        self.debug_settings = debug_settings


class DataFlowDebugPackageDebugSettings(_serialization.Model):
    """Data flow debug settings.

    :ivar source_settings: Source setting for data flow debug.
    :vartype source_settings: list[~azure.mgmt.datafactory.models.DataFlowSourceSetting]
    :ivar parameters: Data flow parameters.
    :vartype parameters: dict[str, JSON]
    :ivar dataset_parameters: Parameters for dataset.
    :vartype dataset_parameters: JSON
    """

    _attribute_map = {
        "source_settings": {"key": "sourceSettings", "type": "[DataFlowSourceSetting]"},
        "parameters": {"key": "parameters", "type": "{object}"},
        "dataset_parameters": {"key": "datasetParameters", "type": "object"},
    }

    def __init__(
        self,
        *,
        source_settings: Optional[List["_models.DataFlowSourceSetting"]] = None,
        parameters: Optional[Dict[str, JSON]] = None,
        dataset_parameters: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword source_settings: Source setting for data flow debug.
        :paramtype source_settings: list[~azure.mgmt.datafactory.models.DataFlowSourceSetting]
        :keyword parameters: Data flow parameters.
        :paramtype parameters: dict[str, JSON]
        :keyword dataset_parameters: Parameters for dataset.
        :paramtype dataset_parameters: JSON
        """
        super().__init__(**kwargs)
        self.source_settings = source_settings
        self.parameters = parameters
        self.dataset_parameters = dataset_parameters


class SubResourceDebugResource(_serialization.Model):
    """Azure Data Factory nested debug resource.

    :ivar name: The resource name.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: The resource name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class DataFlowDebugResource(SubResourceDebugResource):
    """Data flow debug resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The resource name.
    :vartype name: str
    :ivar properties: Data flow properties. Required.
    :vartype properties: ~azure.mgmt.datafactory.models.DataFlow
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "DataFlow"},
    }

    def __init__(self, *, properties: "_models.DataFlow", name: Optional[str] = None, **kwargs):
        """
        :keyword name: The resource name.
        :paramtype name: str
        :keyword properties: Data flow properties. Required.
        :paramtype properties: ~azure.mgmt.datafactory.models.DataFlow
        """
        super().__init__(name=name, **kwargs)
        self.properties = properties


class DataFlowDebugSessionInfo(_serialization.Model):
    """Data flow debug session info.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar data_flow_name: The name of the data flow.
    :vartype data_flow_name: str
    :ivar compute_type: Compute type of the cluster.
    :vartype compute_type: str
    :ivar core_count: Core count of the cluster.
    :vartype core_count: int
    :ivar node_count: Node count of the cluster. (deprecated property).
    :vartype node_count: int
    :ivar integration_runtime_name: Attached integration runtime name of data flow debug session.
    :vartype integration_runtime_name: str
    :ivar session_id: The ID of data flow debug session.
    :vartype session_id: str
    :ivar start_time: Start time of data flow debug session.
    :vartype start_time: str
    :ivar time_to_live_in_minutes: Compute type of the cluster.
    :vartype time_to_live_in_minutes: int
    :ivar last_activity_time: Last activity time of data flow debug session.
    :vartype last_activity_time: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "data_flow_name": {"key": "dataFlowName", "type": "str"},
        "compute_type": {"key": "computeType", "type": "str"},
        "core_count": {"key": "coreCount", "type": "int"},
        "node_count": {"key": "nodeCount", "type": "int"},
        "integration_runtime_name": {"key": "integrationRuntimeName", "type": "str"},
        "session_id": {"key": "sessionId", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "time_to_live_in_minutes": {"key": "timeToLiveInMinutes", "type": "int"},
        "last_activity_time": {"key": "lastActivityTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        data_flow_name: Optional[str] = None,
        compute_type: Optional[str] = None,
        core_count: Optional[int] = None,
        node_count: Optional[int] = None,
        integration_runtime_name: Optional[str] = None,
        session_id: Optional[str] = None,
        start_time: Optional[str] = None,
        time_to_live_in_minutes: Optional[int] = None,
        last_activity_time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword data_flow_name: The name of the data flow.
        :paramtype data_flow_name: str
        :keyword compute_type: Compute type of the cluster.
        :paramtype compute_type: str
        :keyword core_count: Core count of the cluster.
        :paramtype core_count: int
        :keyword node_count: Node count of the cluster. (deprecated property).
        :paramtype node_count: int
        :keyword integration_runtime_name: Attached integration runtime name of data flow debug
         session.
        :paramtype integration_runtime_name: str
        :keyword session_id: The ID of data flow debug session.
        :paramtype session_id: str
        :keyword start_time: Start time of data flow debug session.
        :paramtype start_time: str
        :keyword time_to_live_in_minutes: Compute type of the cluster.
        :paramtype time_to_live_in_minutes: int
        :keyword last_activity_time: Last activity time of data flow debug session.
        :paramtype last_activity_time: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.data_flow_name = data_flow_name
        self.compute_type = compute_type
        self.core_count = core_count
        self.node_count = node_count
        self.integration_runtime_name = integration_runtime_name
        self.session_id = session_id
        self.start_time = start_time
        self.time_to_live_in_minutes = time_to_live_in_minutes
        self.last_activity_time = last_activity_time


class DataFlowFolder(_serialization.Model):
    """The folder that this data flow is in. If not specified, Data flow will appear at the root level.

    :ivar name: The name of the folder that this data flow is in.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs):
        """
        :keyword name: The name of the folder that this data flow is in.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class DataFlowListResponse(_serialization.Model):
    """A list of data flow resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of data flows. Required.
    :vartype value: list[~azure.mgmt.datafactory.models.DataFlowResource]
    :ivar next_link: The link to the next page of results, if any remaining results exist.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataFlowResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DataFlowResource"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of data flows. Required.
        :paramtype value: list[~azure.mgmt.datafactory.models.DataFlowResource]
        :keyword next_link: The link to the next page of results, if any remaining results exist.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataFlowReference(_serialization.Model):
    """Data flow reference type.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Data flow reference type. Required. "DataFlowReference"
    :vartype type: str or ~azure.mgmt.datafactory.models.DataFlowReferenceType
    :ivar reference_name: Reference data flow name. Required.
    :vartype reference_name: str
    :ivar dataset_parameters: Reference data flow parameters from dataset.
    :vartype dataset_parameters: JSON
    :ivar parameters: Data flow parameters.
    :vartype parameters: dict[str, JSON]
    """

    _validation = {
        "type": {"required": True},
        "reference_name": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
        "reference_name": {"key": "referenceName", "type": "str"},
        "dataset_parameters": {"key": "datasetParameters", "type": "object"},
        "parameters": {"key": "parameters", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.DataFlowReferenceType"],
        reference_name: str,
        additional_properties: Optional[Dict[str, JSON]] = None,
        dataset_parameters: Optional[JSON] = None,
        parameters: Optional[Dict[str, JSON]] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword type: Data flow reference type. Required. "DataFlowReference"
        :paramtype type: str or ~azure.mgmt.datafactory.models.DataFlowReferenceType
        :keyword reference_name: Reference data flow name. Required.
        :paramtype reference_name: str
        :keyword dataset_parameters: Reference data flow parameters from dataset.
        :paramtype dataset_parameters: JSON
        :keyword parameters: Data flow parameters.
        :paramtype parameters: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.reference_name = reference_name
        self.dataset_parameters = dataset_parameters
        self.parameters = parameters


class DataFlowResource(SubResource):
    """Data flow resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar etag: Etag identifies change in the resource.
    :vartype etag: str
    :ivar properties: Data flow properties. Required.
    :vartype properties: ~azure.mgmt.datafactory.models.DataFlow
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "properties": {"key": "properties", "type": "DataFlow"},
    }

    def __init__(self, *, properties: "_models.DataFlow", **kwargs):
        """
        :keyword properties: Data flow properties. Required.
        :paramtype properties: ~azure.mgmt.datafactory.models.DataFlow
        """
        super().__init__(**kwargs)
        self.properties = properties


class Transformation(_serialization.Model):
    """A data flow transformation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Transformation name. Required.
    :vartype name: str
    :ivar description: Transformation description.
    :vartype description: str
    :ivar dataset: Dataset reference.
    :vartype dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :ivar linked_service: Linked service reference.
    :vartype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar flowlet: Flowlet Reference.
    :vartype flowlet: ~azure.mgmt.datafactory.models.DataFlowReference
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "dataset": {"key": "dataset", "type": "DatasetReference"},
        "linked_service": {"key": "linkedService", "type": "LinkedServiceReference"},
        "flowlet": {"key": "flowlet", "type": "DataFlowReference"},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["_models.DatasetReference"] = None,
        linked_service: Optional["_models.LinkedServiceReference"] = None,
        flowlet: Optional["_models.DataFlowReference"] = None,
        **kwargs
    ):
        """
        :keyword name: Transformation name. Required.
        :paramtype name: str
        :keyword description: Transformation description.
        :paramtype description: str
        :keyword dataset: Dataset reference.
        :paramtype dataset: ~azure.mgmt.datafactory.models.DatasetReference
        :keyword linked_service: Linked service reference.
        :paramtype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword flowlet: Flowlet Reference.
        :paramtype flowlet: ~azure.mgmt.datafactory.models.DataFlowReference
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.dataset = dataset
        self.linked_service = linked_service
        self.flowlet = flowlet


class DataFlowSink(Transformation):
    """Transformation for data flow sink.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Transformation name. Required.
    :vartype name: str
    :ivar description: Transformation description.
    :vartype description: str
    :ivar dataset: Dataset reference.
    :vartype dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :ivar linked_service: Linked service reference.
    :vartype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar flowlet: Flowlet Reference.
    :vartype flowlet: ~azure.mgmt.datafactory.models.DataFlowReference
    :ivar schema_linked_service: Schema linked service reference.
    :vartype schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar rejected_data_linked_service: Rejected data linked service reference.
    :vartype rejected_data_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "dataset": {"key": "dataset", "type": "DatasetReference"},
        "linked_service": {"key": "linkedService", "type": "LinkedServiceReference"},
        "flowlet": {"key": "flowlet", "type": "DataFlowReference"},
        "schema_linked_service": {"key": "schemaLinkedService", "type": "LinkedServiceReference"},
        "rejected_data_linked_service": {"key": "rejectedDataLinkedService", "type": "LinkedServiceReference"},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["_models.DatasetReference"] = None,
        linked_service: Optional["_models.LinkedServiceReference"] = None,
        flowlet: Optional["_models.DataFlowReference"] = None,
        schema_linked_service: Optional["_models.LinkedServiceReference"] = None,
        rejected_data_linked_service: Optional["_models.LinkedServiceReference"] = None,
        **kwargs
    ):
        """
        :keyword name: Transformation name. Required.
        :paramtype name: str
        :keyword description: Transformation description.
        :paramtype description: str
        :keyword dataset: Dataset reference.
        :paramtype dataset: ~azure.mgmt.datafactory.models.DatasetReference
        :keyword linked_service: Linked service reference.
        :paramtype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword flowlet: Flowlet Reference.
        :paramtype flowlet: ~azure.mgmt.datafactory.models.DataFlowReference
        :keyword schema_linked_service: Schema linked service reference.
        :paramtype schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword rejected_data_linked_service: Rejected data linked service reference.
        :paramtype rejected_data_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        """
        super().__init__(
            name=name,
            description=description,
            dataset=dataset,
            linked_service=linked_service,
            flowlet=flowlet,
            **kwargs
        )
        self.schema_linked_service = schema_linked_service
        self.rejected_data_linked_service = rejected_data_linked_service


class DataFlowSource(Transformation):
    """Transformation for data flow source.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Transformation name. Required.
    :vartype name: str
    :ivar description: Transformation description.
    :vartype description: str
    :ivar dataset: Dataset reference.
    :vartype dataset: ~azure.mgmt.datafactory.models.DatasetReference
    :ivar linked_service: Linked service reference.
    :vartype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar flowlet: Flowlet Reference.
    :vartype flowlet: ~azure.mgmt.datafactory.models.DataFlowReference
    :ivar schema_linked_service: Schema linked service reference.
    :vartype schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "dataset": {"key": "dataset", "type": "DatasetReference"},
        "linked_service": {"key": "linkedService", "type": "LinkedServiceReference"},
        "flowlet": {"key": "flowlet", "type": "DataFlowReference"},
        "schema_linked_service": {"key": "schemaLinkedService", "type": "LinkedServiceReference"},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        dataset: Optional["_models.DatasetReference"] = None,
        linked_service: Optional["_models.LinkedServiceReference"] = None,
        flowlet: Optional["_models.DataFlowReference"] = None,
        schema_linked_service: Optional["_models.LinkedServiceReference"] = None,
        **kwargs
    ):
        """
        :keyword name: Transformation name. Required.
        :paramtype name: str
        :keyword description: Transformation description.
        :paramtype description: str
        :keyword dataset: Dataset reference.
        :paramtype dataset: ~azure.mgmt.datafactory.models.DatasetReference
        :keyword linked_service: Linked service reference.
        :paramtype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword flowlet: Flowlet Reference.
        :paramtype flowlet: ~azure.mgmt.datafactory.models.DataFlowReference
        :keyword schema_linked_service: Schema linked service reference.
        :paramtype schema_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        """
        super().__init__(
            name=name,
            description=description,
            dataset=dataset,
            linked_service=linked_service,
            flowlet=flowlet,
            **kwargs
        )
        self.schema_linked_service = schema_linked_service


class DataFlowSourceSetting(_serialization.Model):
    """Definition of data flow source setting for debug.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar source_name: The data flow source name.
    :vartype source_name: str
    :ivar row_limit: Defines the row limit of data flow source in debug.
    :vartype row_limit: int
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "source_name": {"key": "sourceName", "type": "str"},
        "row_limit": {"key": "rowLimit", "type": "int"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        source_name: Optional[str] = None,
        row_limit: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword source_name: The data flow source name.
        :paramtype source_name: str
        :keyword row_limit: Defines the row limit of data flow source in debug.
        :paramtype row_limit: int
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.source_name = source_name
        self.row_limit = row_limit


class DataFlowStagingInfo(_serialization.Model):
    """Staging info for execute data flow activity.

    :ivar linked_service: Staging linked service reference.
    :vartype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar folder_path: Folder path for staging blob. Type: string (or Expression with resultType
     string).
    :vartype folder_path: JSON
    """

    _attribute_map = {
        "linked_service": {"key": "linkedService", "type": "LinkedServiceReference"},
        "folder_path": {"key": "folderPath", "type": "object"},
    }

    def __init__(
        self,
        *,
        linked_service: Optional["_models.LinkedServiceReference"] = None,
        folder_path: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword linked_service: Staging linked service reference.
        :paramtype linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword folder_path: Folder path for staging blob. Type: string (or Expression with resultType
         string).
        :paramtype folder_path: JSON
        """
        super().__init__(**kwargs)
        self.linked_service = linked_service
        self.folder_path = folder_path


class DataLakeAnalyticsUSQLActivity(ExecutionActivity):  # pylint: disable=too-many-instance-attributes
    """Data Lake Analytics U-SQL activity.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar name: Activity name. Required.
    :vartype name: str
    :ivar type: Type of activity. Required.
    :vartype type: str
    :ivar description: Activity description.
    :vartype description: str
    :ivar depends_on: Activity depends on condition.
    :vartype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :ivar user_properties: Activity user properties.
    :vartype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :ivar linked_service_name: Linked service reference.
    :vartype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar policy: Activity policy.
    :vartype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :ivar script_path: Case-sensitive path to folder that contains the U-SQL script. Type: string
     (or Expression with resultType string). Required.
    :vartype script_path: JSON
    :ivar script_linked_service: Script linked service reference. Required.
    :vartype script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
    :ivar degree_of_parallelism: The maximum number of nodes simultaneously used to run the job.
     Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
    :vartype degree_of_parallelism: JSON
    :ivar priority: Determines which jobs out of all that are queued should be selected to run
     first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or
     Expression with resultType integer), minimum: 1.
    :vartype priority: JSON
    :ivar parameters: Parameters for U-SQL job request.
    :vartype parameters: dict[str, JSON]
    :ivar runtime_version: Runtime version of the U-SQL engine to use. Type: string (or Expression
     with resultType string).
    :vartype runtime_version: JSON
    :ivar compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic, Full
     and SingleBox. Type: string (or Expression with resultType string).
    :vartype compilation_mode: JSON
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "script_path": {"required": True},
        "script_linked_service": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "depends_on": {"key": "dependsOn", "type": "[ActivityDependency]"},
        "user_properties": {"key": "userProperties", "type": "[UserProperty]"},
        "linked_service_name": {"key": "linkedServiceName", "type": "LinkedServiceReference"},
        "policy": {"key": "policy", "type": "ActivityPolicy"},
        "script_path": {"key": "typeProperties.scriptPath", "type": "object"},
        "script_linked_service": {"key": "typeProperties.scriptLinkedService", "type": "LinkedServiceReference"},
        "degree_of_parallelism": {"key": "typeProperties.degreeOfParallelism", "type": "object"},
        "priority": {"key": "typeProperties.priority", "type": "object"},
        "parameters": {"key": "typeProperties.parameters", "type": "{object}"},
        "runtime_version": {"key": "typeProperties.runtimeVersion", "type": "object"},
        "compilation_mode": {"key": "typeProperties.compilationMode", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        script_path: JSON,
        script_linked_service: "_models.LinkedServiceReference",
        additional_properties: Optional[Dict[str, JSON]] = None,
        description: Optional[str] = None,
        depends_on: Optional[List["_models.ActivityDependency"]] = None,
        user_properties: Optional[List["_models.UserProperty"]] = None,
        linked_service_name: Optional["_models.LinkedServiceReference"] = None,
        policy: Optional["_models.ActivityPolicy"] = None,
        degree_of_parallelism: Optional[JSON] = None,
        priority: Optional[JSON] = None,
        parameters: Optional[Dict[str, JSON]] = None,
        runtime_version: Optional[JSON] = None,
        compilation_mode: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Activity name. Required.
        :paramtype name: str
        :keyword description: Activity description.
        :paramtype description: str
        :keyword depends_on: Activity depends on condition.
        :paramtype depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
        :keyword user_properties: Activity user properties.
        :paramtype user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
        :keyword linked_service_name: Linked service reference.
        :paramtype linked_service_name: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword policy: Activity policy.
        :paramtype policy: ~azure.mgmt.datafactory.models.ActivityPolicy
        :keyword script_path: Case-sensitive path to folder that contains the U-SQL script. Type:
         string (or Expression with resultType string). Required.
        :paramtype script_path: JSON
        :keyword script_linked_service: Script linked service reference. Required.
        :paramtype script_linked_service: ~azure.mgmt.datafactory.models.LinkedServiceReference
        :keyword degree_of_parallelism: The maximum number of nodes simultaneously used to run the job.
         Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
        :paramtype degree_of_parallelism: JSON
        :keyword priority: Determines which jobs out of all that are queued should be selected to run
         first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or
         Expression with resultType integer), minimum: 1.
        :paramtype priority: JSON
        :keyword parameters: Parameters for U-SQL job request.
        :paramtype parameters: dict[str, JSON]
        :keyword runtime_version: Runtime version of the U-SQL engine to use. Type: string (or
         Expression with resultType string).
        :paramtype runtime_version: JSON
        :keyword compilation_mode: Compilation mode of U-SQL. Must be one of these values : Semantic,
         Full and SingleBox. Type: string (or Expression with resultType string).
        :paramtype compilation_mode: JSON
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            description=description,
            depends_on=depends_on,
            user_properties=user_properties,
            linked_service_name=linked_service_name,
            policy=policy,
            **kwargs
        )
        self.type = "DataLakeAnalyticsU-SQL"  # type: str
        self.script_path = script_path
        self.script_linked_service = script_linked_service
        self.degree_of_parallelism = degree_of_parallelism
        self.priority = priority
        self.parameters = parameters
        self.runtime_version = runtime_version
        self.compilation_mode = compilation_mode


class DatasetCompression(_serialization.Model):
    """The compression method used on a dataset.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of dataset compression. Type: string (or Expression with resultType string).
     Required.
    :vartype type: JSON
    :ivar level: The dataset compression level. Type: string (or Expression with resultType
     string).
    :vartype level: JSON
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "object"},
        "level": {"key": "level", "type": "object"},
    }

    def __init__(
        self,
        *,
        type: JSON,
        additional_properties: Optional[Dict[str, JSON]] = None,
        level: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword type: Type of dataset compression. Type: string (or Expression with resultType
         string). Required.
        :paramtype type: JSON
        :keyword level: The dataset compression level. Type: string (or Expression with resultType
         string).
        :paramtype level: JSON
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = type
        self.level = level


class DatasetDataElement(_serialization.Model):
    """Columns that define the structure of the dataset.

    :ivar name: Name of the column. Type: string (or Expression with resultType string).
    :vartype name: JSON
    :ivar type: Type of the column. Type: string (or Expression with resultType string).
    :vartype type: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "object"},
        "type": {"key": "type", "type": "object"},
    }

    def __init__(self, *, name: Optional[JSON] = None, type: Optional[JSON] = None, **kwargs):
        """
        :keyword name: Name of the column. Type: string (or Expression with resultType string).
        :paramtype name: JSON
        :keyword type: Type of the column. Type: string (or Expression with resultType string).
        :paramtype type: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class DatasetDebugResource(SubResourceDebugResource):
    """Dataset debug resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The resource name.
    :vartype name: str
    :ivar properties: Dataset properties. Required.
    :vartype properties: ~azure.mgmt.datafactory.models.Dataset
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "Dataset"},
    }

    def __init__(self, *, properties: "_models.Dataset", name: Optional[str] = None, **kwargs):
        """
        :keyword name: 