# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementSharesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shares_list_by_data_box_edge_device(self, resource_group):
        response = self.client.shares.list_by_data_box_edge_device(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shares_get(self, resource_group):
        response = self.client.shares.get(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shares_begin_create_or_update(self, resource_group):
        response = self.client.shares.begin_create_or_update(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            share={
                "accessProtocol": "str",
                "monitoringStatus": "str",
                "shareStatus": "str",
                "azureContainerInfo": {
                    "containerName": "str",
                    "dataFormat": "str",
                    "storageAccountCredentialId": "str",
                },
                "clientAccessRights": [{"accessPermission": "str", "client": "str"}],
                "dataPolicy": "str",
                "description": "str",
                "id": "str",
                "name": "str",
                "refreshDetails": {
                    "errorManifestFile": "str",
                    "inProgressRefreshJobId": "str",
                    "lastCompletedRefreshJobTimeInUTC": "2020-02-20 00:00:00",
                    "lastJob": "str",
                },
                "shareMappings": [{"shareId": "str", "mountPoint": "str", "roleId": "str", "roleType": "str"}],
                "type": "str",
                "userAccessRights": [{"accessType": "str", "userId": "str"}],
            },
            api_version="2019-08-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shares_begin_delete(self, resource_group):
        response = self.client.shares.begin_delete(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_shares_begin_refresh(self, resource_group):
        response = self.client.shares.begin_refresh(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
