% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translateTextQuery.R
\name{translateTextQuery}
\alias{translateTextQuery}
\title{Translate a plain-text query to a gypsum.search.clause}
\usage{
translateTextQuery(query)
}
\arguments{
\item{query}{String containing a query in user-friendly format to a \link{gypsum.search.clause}.}
}
\value{
A \link{gypsum.search.clause} representing \code{query}.
}
\description{
Translate a plain-text query in user-friendly format to a \link{gypsum.search.clause},
equivalent to that created by \code{\link{gsc}} with the corresponding boolean operations.
}
\details{
For text searches, we support a more human-readable syntax for boolean operations in the query.
The search string below will look for all metadata documents that match \code{foo} or \code{bar} but not \code{whee}:

\preformatted{
(foo OR bar) AND NOT whee
}

The \code{AND}, \code{OR} and \code{NOT} (note the all-caps!) are automatically translated to the corresponding search clauses.
This can be combined with parentheses to control precedence; otherwise, \code{AND} takes precedence over \code{OR}, and \code{NOT} takes precedence over both.
Note that any sequence of adjacent text terms are implicitly AND'd together, so the two expressions below are equivalent:

\preformatted{
foo bar whee
foo AND bar AND whee
} 

Users can prefix any sequence of text terms with the name of a metadata field, to only search for matches within that field of the metadata file.
For example:

\preformatted{
(title: prostate cancer) AND (genome: GRCh38 OR genome: GRCm38)
} 

Note that this does not extend to the \code{AND}, \code{OR} and \code{NOT} keywords,
e.g., \code{title:foo OR bar} will not limit the search for \code{bar} to the \code{title} field.

If a \code{\%} wildcard is present in a search term, its corresponding text search clause is configured to perform a partial search.
}
\examples{
str(translateTextQuery("foo AND bar"))
str(translateTextQuery("foo AND bar\%"))
str(translateTextQuery("(foo AND NOT bar) OR whee"))
str(translateTextQuery("blah:foo whee AND stuff: bar blob"))

}
\author{
Aaron Lun
}
