% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperiment-class.R,
%   R/MultiAssayExperiment-methods.R, R/assay-methods.R
\docType{class}
\name{MultiAssayExperiment-class}
\alias{MultiAssayExperiment-class}
\alias{show,MultiAssayExperiment-method}
\alias{length,MultiAssayExperiment-method}
\alias{names,MultiAssayExperiment-method}
\alias{updateObject,MultiAssayExperiment-method}
\alias{coerce-MultiAssayExperiment}
\alias{coerce,list,MultiAssayExperiment-method}
\alias{coerce,List,MultiAssayExperiment-method}
\alias{dimnames,MultiAssayExperiment-method}
\alias{c,MultiAssayExperiment-method}
\alias{exportClass,MultiAssayExperiment-method}
\alias{exportClass}
\alias{assays,MultiAssayExperiment-method}
\alias{assay,MultiAssayExperiment,missing-method}
\alias{assay,MultiAssayExperiment,numeric-method}
\alias{assay,MultiAssayExperiment,character-method}
\title{MultiAssayExperiment - An integrative multi-assay class for experiment data}
\usage{
\S4method{show}{MultiAssayExperiment}(object)

\S4method{length}{MultiAssayExperiment}(x)

\S4method{names}{MultiAssayExperiment}(x)

\S4method{updateObject}{MultiAssayExperiment}(object, ..., verbose = FALSE)

\S4method{dimnames}{MultiAssayExperiment}(x)

\S4method{c}{MultiAssayExperiment}(x, ..., sampleMap = NULL, mapFrom = NULL)

\S4method{exportClass}{MultiAssayExperiment}(
  object,
  dir = tempdir(),
  fmt,
  ext,
  match = FALSE,
  verbose = TRUE,
  ...
)

\S4method{assays}{MultiAssayExperiment}(x, withDimnames = TRUE, ...)

\S4method{assay}{MultiAssayExperiment,missing}(x, i, withDimnames = TRUE, ...)

\S4method{assay}{MultiAssayExperiment,numeric}(x, i, withDimnames = TRUE, ...)

\S4method{assay}{MultiAssayExperiment,character}(x, i, withDimnames = TRUE, ...)
}
\arguments{
\item{object, x}{A \code{MultiAssayExperiment} object}

\item{...}{Additional arguments for supporting functions. See details.}

\item{verbose}{logical(1) Whether to print additional information (default
TRUE)}

\item{sampleMap}{\code{c} method: a \code{sampleMap} \code{list} or
\code{DataFrame} to guide merge}

\item{mapFrom}{Either a \code{logical}, \code{character}, or \code{integer}
vector indicating the experiment(s) that have an identical colname order as
the experiment input(s). If using a character input, the name must match
exactly.}

\item{dir}{character(1) A directory for saving exported data (default:
`tempdir()`)}

\item{fmt}{character(1) or function() Either a format character atomic as
supported by `write.table` either ('csv', or 'tsv') or a function whose
first two arguments are 'object to save' and 'file location'}

\item{ext}{character(1) A file extension supported by the format argument}

\item{match}{logical(1) Whether to coerce the current object to a
'MatchedAssayExperiment' object (default: FALSE)}

\item{withDimnames}{logical (default TRUE) whether to return dimension names
included in the object}

\item{i}{An integer or character scalar indicating the assay to return}
}
\value{
A \code{MultiAssayExperiment} object
}
\description{
The \code{MultiAssayExperiment} class can be used to manage results of
diverse assays on a collection of specimen. Currently,  the class can handle
assays that are organized instances of
\code{\linkS4class{SummarizedExperiment}},
\code{\linkS4class{ExpressionSet}}, \code{matrix},
\code{\link[RaggedExperiment:RaggedExperiment-class]{RaggedExperiment}}
(inherits from \code{\linkS4class{GRangesList}}), and \code{RangedVcfStack}.
Create new \code{MultiAssayExperiment} instances with the homonymous
constructor, minimally with the argument \code{\link{ExperimentList}},
potentially also with the arguments \code{colData} (see section below) and
\code{\link{sampleMap}}.
}
\details{
The dots (\code{\ldots}) argument allows the user to specify additional
arguments in several instances.
\itemize{
\item subsetting \strong{[}: additional arguments sent to
\link[GenomicRanges:findOverlaps-methods]{findOverlaps}.
\item mergeReplicates: used to specify arguments for the \code{simplify}
functional argument
\item assay: may contain withDimnames, which is forwarded to assays
\item combining \strong{c}: compatible \code{MultiAssayExperiment} classes
passed on to the \code{\linkS4class{ExperimentList}} constructor,
can be a \code{list}, \code{\linkS4class{List}}, or a series of
named arguments. See the examples below.
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(MultiAssayExperiment)}: Show method for a
\code{MultiAssayExperiment}

\item \code{length(MultiAssayExperiment)}: Get the length of ExperimentList

\item \code{names(MultiAssayExperiment)}: Get the names of the ExperimentList

\item \code{updateObject(MultiAssayExperiment)}: Update old serialized MultiAssayExperiment
objects to new API

\item \code{dimnames(MultiAssayExperiment)}: Get the dimension names
for a \code{MultiAssayExperiment} object

\item \code{c(MultiAssayExperiment)}: Add a supported data class to the
\code{ExperimentList}

\item \code{exportClass(MultiAssayExperiment)}: Export data from class to a series
of text files

\item \code{assays(MultiAssayExperiment)}: Obtain a \code{\link{SimpleList}} of assay
data for all available experiments in the object

\item \code{assay(x = MultiAssayExperiment, i = missing)}: Convenience function for extracting the
assay of the first element (default) in the \code{ExperimentList}. A
\code{numeric} or \code{character} index can also be provided

}}
\section{Slots}{

\describe{
\item{\code{ExperimentList}}{A \code{\link{ExperimentList}} class object for
each assay dataset}

\item{\code{colData}}{A \code{DataFrame} of all clinical/specimen data available
across experiments}

\item{\code{sampleMap}}{A \code{DataFrame} of translatable identifiers
of samples and participants}

\item{\code{metadata}}{Additional data describing the
\code{MultiAssayExperiment} object}

\item{\code{drops}}{A metadata \code{list} of dropped information}
}}

\section{colData}{

The \code{colData} slot is a collection of primary specimen data valid
across all experiments. This slot is strictly of class
\code{\linkS4class{DataFrame}} but arguments for the constructor function
allow arguments to be of class \code{data.frame} and subsequently coerced.
}

\section{ExperimentList}{

The \code{\link{ExperimentList}} slot is designed to contain results from
each experiment/assay. It contains a \linkS4class{SimpleList}.
}

\section{sampleMap}{

The \code{\link{sampleMap}} contains a \code{DataFrame} of translatable
identifiers of samples and participants or biological units. The standard
column names of the \code{sampleMap} are "assay", "primary", and "colname".
Note that the "assay" column is a factor corresponding to the names of each
experiment in the \code{ExperimentList}. In the case where these names do
not match between the \code{sampleMap} and the experiments, the documented
experiments in the \code{sampleMap} take precedence and experiments are
dropped by the harmonization procedure. The constructor function will
generate a \code{sampleMap} in the case where it is not provided and this
method may be a 'safer' alternative for creating the \code{MultiAssayExperiment}
(so long as the rownames are identical in the \code{colData}, if provided).
An empty \code{sampleMap} may produce empty experiments if the levels of the
"assay" factor in the \code{sampleMap} do not match the names in the
\code{ExperimentList}.
}

\section{coercion}{

Convert a \code{list} or S4 \code{List} to a MultiAssayExperiment object using the
\link[methods]{as} function.

In the following example, \code{x} is either a \code{list} or \linkS4class{List}:

\code{as(x, "MultiAssayExperiment")}

Convert a \code{MultiAssayExperiment} to \code{MAF} class object using the
\link[methods]{as} function.

In the following example, \code{x} is a \linkS4class{MultiAssayExperiment}:

\code{MultiAssayExperimentToMAF(x)}
}

\examples{
example("MultiAssayExperiment")

## Subsetting
# Rows (i) Rows/Features in each experiment
mae[1, , ]
mae[c(TRUE, FALSE), , ]

# Columns (j) Rows in colData
mae[, rownames(colData(mae))[3:2],  ]

# Assays (k)
mae[, , "Affy"]

## Complete cases (returns logical vector)
completes <- complete.cases(mae)
compMAE <- mae[, completes, ]
compMAE
colData(compMAE)

example("MultiAssayExperiment")

## Add an experiment
test1 <- mae[[1L]]
colnames(test1) <- rownames(colData(mae))

## Combine current MultiAssayExperiment with additional experiment
## (no sampleMap)
c(mae, newExperiment = test1)

test2 <- mae[[3L]]
c(mae, newExp = test2, mapFrom = 3L)

## Add experiment using experiment name in mapFrom
c(mae, RNASeqGeneV2 = test2, mapFrom = "RNASeqGene")

}
\seealso{
\link{MultiAssayExperiment-methods} for slot modifying methods,
\href{https://github.com/waldronlab/MultiAssayExperiment/wiki/MultiAssayExperiment-API}{MultiAssayExperiment API}
}
