% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwl-requirements.R
\name{cwl-requirements}
\alias{cwl-requirements}
\alias{requireDocker}
\alias{requireJS}
\alias{requireSoftware}
\alias{condaPackage}
\alias{requireInitialWorkDir}
\alias{Dirent}
\alias{requireManifest}
\alias{requireSubworkflow}
\alias{requireScatter}
\alias{requireMultipleInput}
\alias{requireStepInputExpression}
\alias{requireEnvVar}
\alias{requireRscript}
\alias{requireResource}
\alias{requireShellCommand}
\alias{requireShellScript}
\alias{ShellScript}
\alias{CondaTool}
\alias{requireNetwork}
\title{CWL requirements functions}
\usage{
requireDocker(
  docker = NULL,
  Load = NULL,
  File = NULL,
  Import = NULL,
  ImageId = NULL,
  OutputDir = NULL
)

requireJS(expressionLib = list())

requireSoftware(packages = list())

condaPackage(package, source = "bioconda", version = NULL)

requireInitialWorkDir(listing = list())

Dirent(entryname = character(), entry, writable = FALSE)

requireManifest(inputID, sep = "\\\\n")

requireSubworkflow()

requireScatter()

requireMultipleInput()

requireStepInputExpression()

requireEnvVar(envlist)

requireRscript(rscript)

requireResource(
  coresMin = NULL,
  coresMax = NULL,
  ramMin = NULL,
  ramMax = NULL,
  tmpdirMin = NULL,
  tmpdirMax = NULL,
  outdirMin = NULL,
  outdirMax = NULL
)

requireShellCommand()

requireShellScript(script)

ShellScript(shell = "bash", script = "script.sh")

CondaTool(tools)

requireNetwork(networkAccess = TRUE)
}
\arguments{
\item{docker}{Character. Specify a Docker image to retrieve using
docker pull.}

\item{Load}{Character. Specify a HTTP URL from which to download a
Docker image using docker load.}

\item{File}{Character. Supply the contents of a Dockerfile which will
be built using docker build.}

\item{Import}{Character. Provide HTTP URL to download and gunzip a
Docker images using `docker import.}

\item{ImageId}{Character. The image id that will be used for docker
run. May be a human-readable image name or the image identifier
hash. May be skipped if dockerPull is specified, in which case
the dockerPull image id must be used.}

\item{OutputDir}{Character. Set the designated output directory to a
specific location inside the Docker container.}

\item{expressionLib}{optional list. Additional code fragments that
will also be inserted before executing the expression
code. Allows for function definitions that may be called from
CWL expressions.}

\item{packages}{The list of software to be configured.}

\item{package}{The software name.}

\item{source}{The source of software in anaconda. `bioconda` is
used by default.}

\item{version}{The version of software.}

\item{listing}{The list of files or subdirectories that must be
placed in the designated output directory prior to executing
the command line tool.}

\item{entryname}{Character or Expression. The name of the file or
subdirectory to create in the output directory. The name of the
file or subdirectory to create in the output directory. If
entry is a File or Directory, the entryname field overrides the
value of basename of the File or Directory object. Optional.}

\item{entry}{Charactor or expression. Required.}

\item{writable}{Logical. If true, the file or directory must be
writable by the tool. Changes to the file or directory must be
isolated and not visible by any other CommandLineTool
process. Default is FALSE (files and directories are
read-only). Optional.}

\item{inputID}{The input ID from corresponding `InputParam`.}

\item{sep}{The separator of the input files in the manifest config.}

\item{envlist}{A list of environment variables.}

\item{rscript}{An R script to run.}

\item{coresMin}{Minimum reserved number of CPU cores (default is
1).}

\item{coresMax}{Maximum reserved number of CPU cores.}

\item{ramMin}{Minimum reserved RAM in mebibytes (2**20) (default is
256).}

\item{ramMax}{Maximum reserved RAM in mebibytes (2**20)}

\item{tmpdirMin}{Minimum reserved filesystem based storage for the
designated temporary directory, in mebibytes (2**20) (default
is 1024).}

\item{tmpdirMax}{Maximum reserved filesystem based storage for the
designated temporary directory, in mebibytes (2**20).}

\item{outdirMin}{Minimum reserved filesystem based storage for the
designated output directory, in mebibytes (2**20) (default is
1024).}

\item{outdirMax}{Maximum reserved filesystem based storage for the
designated output directory, in mebibytes (2**20).}

\item{script}{script.sh}

\item{shell}{Default shell.}

\item{tools}{A character vector for tools to install by conda.}

\item{networkAccess}{TRUE or FALSE.}
}
\value{
requireDocker: A list of docker requirement to fetch or
    build the image.

requireJS: A list of inline Javascript requirement.

requireSoftware: A list of software requirements.

A list of software package.

requireInitialWorkDir: A list of initial work directory requirements.

Dirent: A list.

requireSubworkflow: A SubworkflowFeatureRequirement list.

rquireScatter: A ScatterFeatureRequirement list.

requireMultipleInput: A MultipleInputFeatureRequirement list.

requireStepInputExpression: A StepInputExpressionRequirement list.

requireEnvVar: A EnvVarRequirementlist.

A requirement list with Rscript as manifest entry.

ResourceRequirement: A ResourceRequirement list.

ShellCommandRequirement: A ShellCommandRequirement list.

requireShellScript: Initial directory with shell script.

baseCommand for shell script

CondaTool: Dockerfile

requireNetwork: a list of NetworkAccess requirement.
}
\description{
requireDocker: If a workflow component should be run
    in a Docker container, this function specifies how to fetch or
    build the image.

requireJS: Indicates that the workflow platform must
    support inline Javascript expressions. If this requirement is
    not present, the workflow platform must not perform expression
    interpolatation.

requireSoftware: A list of software packages that
    should be configured in the environment of the defined process.

SoftwarePackage from anaconda.

InitialWorkDirRequirement: Define a list of files and
    subdirectories that must be created by the workflow platform in
    the designated output directory prior to executing the command
    line tool.

: Dirent: Define a file or subdirectory that must be
    placed in the designated output directory prior to executing
    the command line tool. May be the result of executing an
    expression, such as building a configuration file from a
    template.

Create manifest for configure files.

requireShellScript: create shell script to work dir.

CondaTool: create dockerfile for tools.

requireNetwork: Whether a process requires network
    access.
}
\details{
More details about `requireDocker`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#DockerRequirement

More details about `requireJS`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#InlineJavascriptRequirement

More details about `requireSoftware`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#SoftwareRequirement

More details about `requireSoftware`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#SoftwarePackage

More details about `requireInitialWorkDir`, See:
    https://www.commonwl.org/v1.0/CommandLineTool.html#InitialWorkDirRequirement

More details about `Dirent`,
    See:https://www.commonwl.org/v1.0/CommandLineTool.html#Dirent
}
\examples{
p1 <- InputParam(id = "ifiles", type = "File[]?", position = -1)
CAT <- cwlProcess(baseCommand = "cat",
       requirements = list(requireDocker("alpine"), requireManifest("ifiles"), requireJS()),
       arguments = list("ifiles"),
       inputs = InputParamList(p1))

}
