% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_response.R
\name{get_response}
\alias{get_response}
\title{Get the values from the response variable}
\usage{
get_response(x, select = NULL, as_proportion = TRUE, verbose = TRUE)
}
\arguments{
\item{x}{A fitted model.}

\item{select}{Optional name(s) of response variables for which to extract values.
Can be used in case of regression models with multiple response variables.}

\item{as_proportion}{Logical, if \code{TRUE} and the response value is a proportion
(e.g. \code{y1 / y2}), then the returned response value will be a vector with
the result of this proportion. Else, always a data frame is returned.}

\item{verbose}{Toggle warnings.}
}
\value{
The values of the response variable, as vector, or a data frame if
\code{x} has more than one defined response variable.
}
\description{
Returns the values the response variable(s) from a model object.
If the model is a multivariate response model, a data frame with values
from all response variables is returned.
}
\examples{
if (require("lme4")) {
  data(cbpp)
  cbpp$trials <- cbpp$size - cbpp$incidence
  dat <<- cbpp

  m <- glm(cbind(incidence, trials) ~ period, data = dat, family = binomial)
  head(get_response(m))
  get_response(m, select = "incidence")
}

data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_response(m)
}
