% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{alnum_id}
\alias{alnum_id}
\title{Generate ID strings}
\usage{
alnum_id(x, exclude = "[^[:alnum:]]+")
}
\arguments{
\item{x}{A character vector.}

\item{exclude}{A (Perl) regular expression to detect characters to be
replaced by dashes. By default, non-alphanumeric characters are replaced.}
}
\value{
A character vector of IDs.
}
\description{
Substitute certain (by default, non-alphanumeric) characters with dashes and
remove extra dashes at both ends to generate ID strings.
}
\examples{
x = c("Hello world 123!", "a  &b*^##c 456")
xfun::alnum_id(x)
xfun::alnum_id(x, "[^[:alpha:]]+")  # only keep alphabetical chars
}
