# Dropbead: Basic Exploration and Analysis of Drop-seq Data

## About
This `R` package is created and maintained by Nikos Karaiskos.
It offers a quick and straightfoward way to explore and perform
basic analysis of single cell sequencing data coming from droplet
sequencing. It has been particularly tailored for Drop-seq.

Dropbead accompanies the following publication and was used to
generate all figures appearing in the manuscript prior clustering.


*Cell fixation and preservation for droplet-based single-cell transcriptomics*, <br />
[BMC Biology 2017 15:44](https://bmcbiol.biomedcentral.com/articles/10.1186/s12915-017-0383-5),
[bioRxiv](http://biorxiv.org/content/biorxiv/early/2017/04/13/099473.full.pdf), 99473 (2017)
doi: https://doi.org/10.1101/099473 

J. Alles<sup>#</sup>, N. Karaiskos<sup>#</sup>, S. Praktiknjo<sup>#</sup>, S. Grosswendt, P. Wahle, P.-L. Ruffault,
S. Ayoub, L. Schreyer, A. Boltengagen, C. Birchmeier, R. Zinzen, C. Kocks<sup>&</sup> and N. Rajewsky<sup>&</sup>

<sup>#</sup> Contributed equally <br />
<sup>&</sup> Corresponding authors: [C. Kocks](mailto:christine.kocks@mdc-berlin.de), [N. Rajewsky](mailto:rajewsky@mdc-berlin.de)

[Contact the author](mailto:nikolaos.karaiskos@mdc-berlin.de) in case you've found a bug. 
Feel free to cite the package in case you've used it.

## Installation
The easiest way to install `dropbead` is through `devtools`

```
library(devtools)
install_github("rajewsky-lab/dropbead")
```
## Tutorial
A first walkthrough is found in the tutorial. As the file's size is currently 
too big for Github, to view the tutorial click on the `.html` file, then on the
`raw` format and save it locally. You can then view the tutorial with an
ordinary web browser.
